# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAddonResult',
    'AwaitableGetAddonResult',
    'get_addon',
]

@pulumi.output_type
class GetAddonResult:
    """
    A collection of values returned by getAddon.
    """
    def __init__(__self__, addon_name=None, addon_version=None, arn=None, cluster_name=None, created_at=None, id=None, modified_at=None, service_account_role_arn=None, tags=None):
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if addon_version and not isinstance(addon_version, str):
            raise TypeError("Expected argument 'addon_version' to be a str")
        pulumi.set(__self__, "addon_version", addon_version)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if service_account_role_arn and not isinstance(service_account_role_arn, str):
            raise TypeError("Expected argument 'service_account_role_arn' to be a str")
        pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> str:
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> str:
        """
        The version of EKS add-on.
        """
        return pulumi.get(self, "addon_version")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> str:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> str:
        """
        ARN of IAM role used for EKS add-on. If value is empty -
        then add-on uses the IAM role assigned to the EKS Cluster node.
        """
        return pulumi.get(self, "service_account_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetAddonResult(GetAddonResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonResult(
            addon_name=self.addon_name,
            addon_version=self.addon_version,
            arn=self.arn,
            cluster_name=self.cluster_name,
            created_at=self.created_at,
            id=self.id,
            modified_at=self.modified_at,
            service_account_role_arn=self.service_account_role_arn,
            tags=self.tags)


def get_addon(addon_name: Optional[str] = None,
              cluster_name: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonResult:
    """
    Retrieve information about an EKS add-on.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_addon(addon_name="vpc-cni",
        cluster_name=aws_eks_cluster["example"]["name"])
    pulumi.export("eksAddonOutputs", aws_eks_addon["example"])
    ```


    :param str addon_name: Name of the EKS add-on. The name must match one of
           the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
    :param str cluster_name: Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['clusterName'] = cluster_name
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:eks/getAddon:getAddon', __args__, opts=opts, typ=GetAddonResult).value

    return AwaitableGetAddonResult(
        addon_name=__ret__.addon_name,
        addon_version=__ret__.addon_version,
        arn=__ret__.arn,
        cluster_name=__ret__.cluster_name,
        created_at=__ret__.created_at,
        id=__ret__.id,
        modified_at=__ret__.modified_at,
        service_account_role_arn=__ret__.service_account_role_arn,
        tags=__ret__.tags)
