# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPointPosixUser',
    'AccessPointRootDirectory',
    'AccessPointRootDirectoryCreationInfo',
    'BackupPolicyBackupPolicy',
    'FileSystemLifecyclePolicy',
    'FileSystemSizeInByte',
    'GetAccessPointPosixUserResult',
    'GetAccessPointRootDirectoryResult',
    'GetAccessPointRootDirectoryCreationInfoResult',
    'GetFileSystemLifecyclePolicyResult',
]

@pulumi.output_type
class AccessPointPosixUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryGids":
            suggest = "secondary_gids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPosixUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: int,
                 uid: int,
                 secondary_gids: Optional[Sequence[int]] = None):
        """
        :param int gid: POSIX group ID used for all file system operations using this access point.
        :param int uid: POSIX user ID used for all file system operations using this access point.
        :param Sequence[int] secondary_gids: Secondary POSIX group IDs used for all file system operations using this access point.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        POSIX group ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        POSIX user ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[Sequence[int]]:
        """
        Secondary POSIX group IDs used for all file system operations using this access point.
        """
        return pulumi.get(self, "secondary_gids")


@pulumi.output_type
class AccessPointRootDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationInfo":
            suggest = "creation_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointRootDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointRootDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointRootDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_info: Optional['outputs.AccessPointRootDirectoryCreationInfo'] = None,
                 path: Optional[str] = None):
        """
        :param 'AccessPointRootDirectoryCreationInfoArgs' creation_info: POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        :param str path: Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        if creation_info is not None:
            pulumi.set(__self__, "creation_info", creation_info)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="creationInfo")
    def creation_info(self) -> Optional['outputs.AccessPointRootDirectoryCreationInfo']:
        """
        POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        """
        return pulumi.get(self, "creation_info")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AccessPointRootDirectoryCreationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerGid":
            suggest = "owner_gid"
        elif key == "ownerUid":
            suggest = "owner_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointRootDirectoryCreationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointRootDirectoryCreationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointRootDirectoryCreationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_gid: int,
                 owner_uid: int,
                 permissions: str):
        """
        :param int owner_gid: POSIX group ID to apply to the `root_directory`.
        :param int owner_uid: POSIX user ID to apply to the `root_directory`.
        :param str permissions: POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        pulumi.set(__self__, "owner_gid", owner_gid)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="ownerGid")
    def owner_gid(self) -> int:
        """
        POSIX group ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_gid")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> int:
        """
        POSIX user ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class BackupPolicyBackupPolicy(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FileSystemLifecyclePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transitionToIa":
            suggest = "transition_to_ia"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemLifecyclePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemLifecyclePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemLifecyclePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transition_to_ia: str):
        """
        :param str transition_to_ia: Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
        """
        pulumi.set(__self__, "transition_to_ia", transition_to_ia)

    @property
    @pulumi.getter(name="transitionToIa")
    def transition_to_ia(self) -> str:
        """
        Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, or `AFTER_90_DAYS`.
        """
        return pulumi.get(self, "transition_to_ia")


@pulumi.output_type
class FileSystemSizeInByte(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueInIa":
            suggest = "value_in_ia"
        elif key == "valueInStandard":
            suggest = "value_in_standard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSizeInByte. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSizeInByte.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSizeInByte.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: Optional[int] = None,
                 value_in_ia: Optional[int] = None,
                 value_in_standard: Optional[int] = None):
        """
        :param int value: The latest known metered size (in bytes) of data stored in the file system.
        :param int value_in_ia: The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        :param int value_in_standard: The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_in_ia is not None:
            pulumi.set(__self__, "value_in_ia", value_in_ia)
        if value_in_standard is not None:
            pulumi.set(__self__, "value_in_standard", value_in_standard)

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueInIa")
    def value_in_ia(self) -> Optional[int]:
        """
        The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        """
        return pulumi.get(self, "value_in_ia")

    @property
    @pulumi.getter(name="valueInStandard")
    def value_in_standard(self) -> Optional[int]:
        """
        The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        return pulumi.get(self, "value_in_standard")


@pulumi.output_type
class GetAccessPointPosixUserResult(dict):
    def __init__(__self__, *,
                 gid: int,
                 secondary_gids: Sequence[int],
                 uid: int):
        """
        :param int gid: Group ID
        :param Sequence[int] secondary_gids: Secondary group IDs
        :param int uid: User Id
               * `root_directory`- Single element list containing information on the directory on the Amazon EFS file system that the access point provides access to.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "secondary_gids", secondary_gids)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> int:
        """
        Group ID
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Sequence[int]:
        """
        Secondary group IDs
        """
        return pulumi.get(self, "secondary_gids")

    @property
    @pulumi.getter
    def uid(self) -> int:
        """
        User Id
        * `root_directory`- Single element list containing information on the directory on the Amazon EFS file system that the access point provides access to.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetAccessPointRootDirectoryResult(dict):
    def __init__(__self__, *,
                 creation_infos: Sequence['outputs.GetAccessPointRootDirectoryCreationInfoResult'],
                 path: str):
        """
        :param Sequence['GetAccessPointRootDirectoryCreationInfoArgs'] creation_infos: Single element list containing information on the creation permissions of the directory
        :param str path: Path exposed as the root directory
        """
        pulumi.set(__self__, "creation_infos", creation_infos)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="creationInfos")
    def creation_infos(self) -> Sequence['outputs.GetAccessPointRootDirectoryCreationInfoResult']:
        """
        Single element list containing information on the creation permissions of the directory
        """
        return pulumi.get(self, "creation_infos")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path exposed as the root directory
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAccessPointRootDirectoryCreationInfoResult(dict):
    def __init__(__self__, *,
                 owner_gid: int,
                 owner_uid: int,
                 permissions: str):
        """
        :param int owner_gid: POSIX owner group ID
        :param int owner_uid: POSIX owner user ID
        :param str permissions: POSIX permissions mode
        """
        pulumi.set(__self__, "owner_gid", owner_gid)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="ownerGid")
    def owner_gid(self) -> int:
        """
        POSIX owner group ID
        """
        return pulumi.get(self, "owner_gid")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> int:
        """
        POSIX owner user ID
        """
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        POSIX permissions mode
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetFileSystemLifecyclePolicyResult(dict):
    def __init__(__self__, *,
                 transition_to_ia: str):
        pulumi.set(__self__, "transition_to_ia", transition_to_ia)

    @property
    @pulumi.getter(name="transitionToIa")
    def transition_to_ia(self) -> str:
        return pulumi.get(self, "transition_to_ia")


