# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CapacityProviderAutoScalingGroupProvider',
    'CapacityProviderAutoScalingGroupProviderManagedScaling',
    'ClusterConfiguration',
    'ClusterConfigurationExecuteCommandConfiguration',
    'ClusterConfigurationExecuteCommandConfigurationLogConfiguration',
    'ClusterDefaultCapacityProviderStrategy',
    'ClusterSetting',
    'ServiceCapacityProviderStrategy',
    'ServiceDeploymentCircuitBreaker',
    'ServiceDeploymentController',
    'ServiceLoadBalancer',
    'ServiceNetworkConfiguration',
    'ServiceOrderedPlacementStrategy',
    'ServicePlacementConstraint',
    'ServiceServiceRegistries',
    'TaskDefinitionEphemeralStorage',
    'TaskDefinitionInferenceAccelerator',
    'TaskDefinitionPlacementConstraint',
    'TaskDefinitionProxyConfiguration',
    'TaskDefinitionVolume',
    'TaskDefinitionVolumeDockerVolumeConfiguration',
    'TaskDefinitionVolumeEfsVolumeConfiguration',
    'TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig',
    'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration',
    'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig',
    'GetClusterSettingResult',
]

@pulumi.output_type
class CapacityProviderAutoScalingGroupProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScalingGroupArn":
            suggest = "auto_scaling_group_arn"
        elif key == "managedScaling":
            suggest = "managed_scaling"
        elif key == "managedTerminationProtection":
            suggest = "managed_termination_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling_group_arn: str,
                 managed_scaling: Optional['outputs.CapacityProviderAutoScalingGroupProviderManagedScaling'] = None,
                 managed_termination_protection: Optional[str] = None):
        """
        :param str auto_scaling_group_arn: - ARN of the associated auto scaling group.
        :param 'CapacityProviderAutoScalingGroupProviderManagedScalingArgs' managed_scaling: - Configuration block defining the parameters of the auto scaling. Detailed below.
        :param str managed_termination_protection: - Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
        """
        pulumi.set(__self__, "auto_scaling_group_arn", auto_scaling_group_arn)
        if managed_scaling is not None:
            pulumi.set(__self__, "managed_scaling", managed_scaling)
        if managed_termination_protection is not None:
            pulumi.set(__self__, "managed_termination_protection", managed_termination_protection)

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> str:
        """
        - ARN of the associated auto scaling group.
        """
        return pulumi.get(self, "auto_scaling_group_arn")

    @property
    @pulumi.getter(name="managedScaling")
    def managed_scaling(self) -> Optional['outputs.CapacityProviderAutoScalingGroupProviderManagedScaling']:
        """
        - Configuration block defining the parameters of the auto scaling. Detailed below.
        """
        return pulumi.get(self, "managed_scaling")

    @property
    @pulumi.getter(name="managedTerminationProtection")
    def managed_termination_protection(self) -> Optional[str]:
        """
        - Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "managed_termination_protection")


@pulumi.output_type
class CapacityProviderAutoScalingGroupProviderManagedScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceWarmupPeriod":
            suggest = "instance_warmup_period"
        elif key == "maximumScalingStepSize":
            suggest = "maximum_scaling_step_size"
        elif key == "minimumScalingStepSize":
            suggest = "minimum_scaling_step_size"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProviderManagedScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProviderManagedScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProviderManagedScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_warmup_period: Optional[int] = None,
                 maximum_scaling_step_size: Optional[int] = None,
                 minimum_scaling_step_size: Optional[int] = None,
                 status: Optional[str] = None,
                 target_capacity: Optional[int] = None):
        """
        :param int instance_warmup_period: Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
        :param int maximum_scaling_step_size: Maximum step adjustment size. A number between 1 and 10,000.
        :param int minimum_scaling_step_size: Minimum step adjustment size. A number between 1 and 10,000.
        :param str status: Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
        :param int target_capacity: Target utilization for the capacity provider. A number between 1 and 100.
        """
        if instance_warmup_period is not None:
            pulumi.set(__self__, "instance_warmup_period", instance_warmup_period)
        if maximum_scaling_step_size is not None:
            pulumi.set(__self__, "maximum_scaling_step_size", maximum_scaling_step_size)
        if minimum_scaling_step_size is not None:
            pulumi.set(__self__, "minimum_scaling_step_size", minimum_scaling_step_size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="instanceWarmupPeriod")
    def instance_warmup_period(self) -> Optional[int]:
        """
        Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
        """
        return pulumi.get(self, "instance_warmup_period")

    @property
    @pulumi.getter(name="maximumScalingStepSize")
    def maximum_scaling_step_size(self) -> Optional[int]:
        """
        Maximum step adjustment size. A number between 1 and 10,000.
        """
        return pulumi.get(self, "maximum_scaling_step_size")

    @property
    @pulumi.getter(name="minimumScalingStepSize")
    def minimum_scaling_step_size(self) -> Optional[int]:
        """
        Minimum step adjustment size. A number between 1 and 10,000.
        """
        return pulumi.get(self, "minimum_scaling_step_size")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[int]:
        """
        Target utilization for the capacity provider. A number between 1 and 100.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ClusterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeCommandConfiguration":
            suggest = "execute_command_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_command_configuration: Optional['outputs.ClusterConfigurationExecuteCommandConfiguration'] = None):
        """
        :param 'ClusterConfigurationExecuteCommandConfigurationArgs' execute_command_configuration: The details of the execute command configuration. Detailed below.
        """
        if execute_command_configuration is not None:
            pulumi.set(__self__, "execute_command_configuration", execute_command_configuration)

    @property
    @pulumi.getter(name="executeCommandConfiguration")
    def execute_command_configuration(self) -> Optional['outputs.ClusterConfigurationExecuteCommandConfiguration']:
        """
        The details of the execute command configuration. Detailed below.
        """
        return pulumi.get(self, "execute_command_configuration")


@pulumi.output_type
class ClusterConfigurationExecuteCommandConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigurationExecuteCommandConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigurationExecuteCommandConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigurationExecuteCommandConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None,
                 log_configuration: Optional['outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration'] = None,
                 logging: Optional[str] = None):
        """
        :param str kms_key_id: The AWS Key Management Service key ID to encrypt the data between the local client and the container.
        :param 'ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs' log_configuration: The log configuration for the results of the execute command actions Required when `logging` is `OVERRIDE`. Detailed below.
        :param str logging: The log setting to use for redirecting logs for your execute command results. Valid values are `NONE`, `DEFAULT`, and `OVERRIDE`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The AWS Key Management Service key ID to encrypt the data between the local client and the container.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration']:
        """
        The log configuration for the results of the execute command actions Required when `logging` is `OVERRIDE`. Detailed below.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def logging(self) -> Optional[str]:
        """
        The log setting to use for redirecting logs for your execute command results. Valid values are `NONE`, `DEFAULT`, and `OVERRIDE`.
        """
        return pulumi.get(self, "logging")


@pulumi.output_type
class ClusterConfigurationExecuteCommandConfigurationLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchEncryptionEnabled":
            suggest = "cloud_watch_encryption_enabled"
        elif key == "cloudWatchLogGroupName":
            suggest = "cloud_watch_log_group_name"
        elif key == "s3BucketEncryptionEnabled":
            suggest = "s3_bucket_encryption_enabled"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigurationExecuteCommandConfigurationLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigurationExecuteCommandConfigurationLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigurationExecuteCommandConfigurationLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_encryption_enabled: Optional[bool] = None,
                 cloud_watch_log_group_name: Optional[str] = None,
                 s3_bucket_encryption_enabled: Optional[bool] = None,
                 s3_bucket_name: Optional[str] = None,
                 s3_key_prefix: Optional[str] = None):
        """
        :param bool cloud_watch_encryption_enabled: Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
        :param str cloud_watch_log_group_name: The name of the CloudWatch log group to send logs to.
        :param bool s3_bucket_encryption_enabled: Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
        :param str s3_bucket_name: The name of the S3 bucket to send logs to.
        :param str s3_key_prefix: An optional folder in the S3 bucket to place logs in.
        """
        if cloud_watch_encryption_enabled is not None:
            pulumi.set(__self__, "cloud_watch_encryption_enabled", cloud_watch_encryption_enabled)
        if cloud_watch_log_group_name is not None:
            pulumi.set(__self__, "cloud_watch_log_group_name", cloud_watch_log_group_name)
        if s3_bucket_encryption_enabled is not None:
            pulumi.set(__self__, "s3_bucket_encryption_enabled", s3_bucket_encryption_enabled)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="cloudWatchEncryptionEnabled")
    def cloud_watch_encryption_enabled(self) -> Optional[bool]:
        """
        Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
        """
        return pulumi.get(self, "cloud_watch_encryption_enabled")

    @property
    @pulumi.getter(name="cloudWatchLogGroupName")
    def cloud_watch_log_group_name(self) -> Optional[str]:
        """
        The name of the CloudWatch log group to send logs to.
        """
        return pulumi.get(self, "cloud_watch_log_group_name")

    @property
    @pulumi.getter(name="s3BucketEncryptionEnabled")
    def s3_bucket_encryption_enabled(self) -> Optional[bool]:
        """
        Whether or not to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
        """
        return pulumi.get(self, "s3_bucket_encryption_enabled")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        The name of the S3 bucket to send logs to.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        An optional folder in the S3 bucket to place logs in.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class ClusterDefaultCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDefaultCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDefaultCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDefaultCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: str,
                 base: Optional[int] = None,
                 weight: Optional[int] = None):
        """
        :param str capacity_provider: The short name of the capacity provider.
        :param int base: The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        :param int weight: The relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> str:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        """
        The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterSetting(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the setting to manage. Valid values: `containerInsights`.
        :param str value: The value to assign to the setting. Value values are `enabled` and `disabled`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the setting to manage. Valid values: `containerInsights`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value to assign to the setting. Value values are `enabled` and `disabled`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: str,
                 base: Optional[int] = None,
                 weight: Optional[int] = None):
        """
        :param str capacity_provider: Short name of the capacity provider.
        :param int base: Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        :param int weight: Relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> str:
        """
        Short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        """
        Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceDeploymentCircuitBreaker(dict):
    def __init__(__self__, *,
                 enable: bool,
                 rollback: bool):
        """
        :param bool enable: Whether to enable the deployment circuit breaker logic for the service.
        :param bool rollback: Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Whether to enable the deployment circuit breaker logic for the service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> bool:
        """
        Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceDeploymentController(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "elbName":
            suggest = "elb_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 container_port: int,
                 elb_name: Optional[str] = None,
                 target_group_arn: Optional[str] = None):
        """
        :param str container_name: Name of the container to associate with the load balancer (as it appears in a container definition).
        :param int container_port: Port on the container to associate with the load balancer.
        :param str elb_name: Name of the ELB (Classic) to associate with the service.
        :param str target_group_arn: ARN of the Load Balancer target group to associate with the service.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "container_port", container_port)
        if elb_name is not None:
            pulumi.set(__self__, "elb_name", elb_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Name of the container to associate with the load balancer (as it appears in a container definition).
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port on the container to associate with the load balancer.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="elbName")
    def elb_name(self) -> Optional[str]:
        """
        Name of the ELB (Classic) to associate with the service.
        """
        return pulumi.get(self, "elb_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[str]:
        """
        ARN of the Load Balancer target group to associate with the service.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[str],
                 assign_public_ip: Optional[bool] = None,
                 security_groups: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] subnets: Subnets associated with the task or service.
        :param bool assign_public_ip: Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
        :param Sequence[str] security_groups: Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        Subnets associated with the task or service.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[bool]:
        """
        Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class ServiceOrderedPlacementStrategy(dict):
    def __init__(__self__, *,
                 type: str,
                 field: Optional[str] = None):
        """
        :param str type: Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
        :param str field: For the `spread` placement strategy, valid values are `instanceId` (or `host`,
               which has the same effect), or any platform or custom attribute that is applied to a container instance.
               For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
               needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        For the `spread` placement strategy, valid values are `instanceId` (or `host`,
        which has the same effect), or any platform or custom attribute that is applied to a container instance.
        For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
        needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class ServicePlacementConstraint(dict):
    def __init__(__self__, *,
                 type: str,
                 expression: Optional[str] = None):
        """
        :param str type: Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        :param str expression: Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class ServiceServiceRegistries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryArn":
            suggest = "registry_arn"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceRegistries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceRegistries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceRegistries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_arn: str,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 port: Optional[int] = None):
        """
        :param str registry_arn: ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
        :param str container_name: Container name value, already specified in the task definition, to be used for your service discovery service.
        :param int container_port: Port value, already specified in the task definition, to be used for your service discovery service.
        :param int port: Port value used if your Service Discovery service specified an SRV record.
        """
        pulumi.set(__self__, "registry_arn", registry_arn)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> str:
        """
        ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
        """
        return pulumi.get(self, "registry_arn")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Container name value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        Port value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port value used if your Service Discovery service specified an SRV record.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TaskDefinitionEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGib":
            suggest = "size_in_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gib: int):
        """
        :param int size_in_gib: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gib", size_in_gib)

    @property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gib")


@pulumi.output_type
class TaskDefinitionInferenceAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deviceType":
            suggest = "device_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionInferenceAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 device_type: str):
        """
        :param str device_name: Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
        :param str device_type: Elastic Inference accelerator type to use.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "device_type", device_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Elastic Inference accelerator device name. The deviceName must also be referenced in a container definition as a ResourceRequirement.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> str:
        """
        Elastic Inference accelerator type to use.
        """
        return pulumi.get(self, "device_type")


@pulumi.output_type
class TaskDefinitionPlacementConstraint(dict):
    def __init__(__self__, *,
                 type: str,
                 expression: Optional[str] = None):
        """
        :param str type: Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        :param str expression: Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class TaskDefinitionProxyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionProxyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 properties: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        :param str container_name: Name of the container that will serve as the App Mesh proxy.
        :param Mapping[str, str] properties: Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        :param str type: Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        pulumi.set(__self__, "container_name", container_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Name of the container that will serve as the App Mesh proxy.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerVolumeConfiguration":
            suggest = "docker_volume_configuration"
        elif key == "efsVolumeConfiguration":
            suggest = "efs_volume_configuration"
        elif key == "fsxWindowsFileServerVolumeConfiguration":
            suggest = "fsx_windows_file_server_volume_configuration"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 docker_volume_configuration: Optional['outputs.TaskDefinitionVolumeDockerVolumeConfiguration'] = None,
                 efs_volume_configuration: Optional['outputs.TaskDefinitionVolumeEfsVolumeConfiguration'] = None,
                 fsx_windows_file_server_volume_configuration: Optional['outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration'] = None,
                 host_path: Optional[str] = None):
        """
        :param str name: Name of the volume. This name is referenced in the `sourceVolume`
               parameter of container definition in the `mountPoints` section.
        :param 'TaskDefinitionVolumeDockerVolumeConfigurationArgs' docker_volume_configuration: Configuration block to configure a docker volume. Detailed below.
        :param 'TaskDefinitionVolumeEfsVolumeConfigurationArgs' efs_volume_configuration: Configuration block for an EFS volume. Detailed below.
        :param 'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs' fsx_windows_file_server_volume_configuration: Configuration block for an FSX Windows File Server volume. Detailed below.
        :param str host_path: Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        """
        pulumi.set(__self__, "name", name)
        if docker_volume_configuration is not None:
            pulumi.set(__self__, "docker_volume_configuration", docker_volume_configuration)
        if efs_volume_configuration is not None:
            pulumi.set(__self__, "efs_volume_configuration", efs_volume_configuration)
        if fsx_windows_file_server_volume_configuration is not None:
            pulumi.set(__self__, "fsx_windows_file_server_volume_configuration", fsx_windows_file_server_volume_configuration)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume. This name is referenced in the `sourceVolume`
        parameter of container definition in the `mountPoints` section.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dockerVolumeConfiguration")
    def docker_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeDockerVolumeConfiguration']:
        """
        Configuration block to configure a docker volume. Detailed below.
        """
        return pulumi.get(self, "docker_volume_configuration")

    @property
    @pulumi.getter(name="efsVolumeConfiguration")
    def efs_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeEfsVolumeConfiguration']:
        """
        Configuration block for an EFS volume. Detailed below.
        """
        return pulumi.get(self, "efs_volume_configuration")

    @property
    @pulumi.getter(name="fsxWindowsFileServerVolumeConfiguration")
    def fsx_windows_file_server_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration']:
        """
        Configuration block for an FSX Windows File Server volume. Detailed below.
        """
        return pulumi.get(self, "fsx_windows_file_server_volume_configuration")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[str]:
        """
        Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        """
        return pulumi.get(self, "host_path")


@pulumi.output_type
class TaskDefinitionVolumeDockerVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverOpts":
            suggest = "driver_opts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeDockerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeDockerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeDockerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovision: Optional[bool] = None,
                 driver: Optional[str] = None,
                 driver_opts: Optional[Mapping[str, str]] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 scope: Optional[str] = None):
        """
        :param bool autoprovision: If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        :param str driver: Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        :param Mapping[str, str] driver_opts: Map of Docker driver specific options.
        :param Mapping[str, str] labels: Map of custom metadata to add to your Docker volume.
        :param str scope: Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        if autoprovision is not None:
            pulumi.set(__self__, "autoprovision", autoprovision)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_opts is not None:
            pulumi.set(__self__, "driver_opts", driver_opts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def autoprovision(self) -> Optional[bool]:
        """
        If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        """
        return pulumi.get(self, "autoprovision")

    @property
    @pulumi.getter
    def driver(self) -> Optional[str]:
        """
        Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Optional[Mapping[str, str]]:
        """
        Map of Docker driver specific options.
        """
        return pulumi.get(self, "driver_opts")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Map of custom metadata to add to your Docker volume.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class TaskDefinitionVolumeEfsVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "transitEncryption":
            suggest = "transit_encryption"
        elif key == "transitEncryptionPort":
            suggest = "transit_encryption_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeEfsVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeEfsVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeEfsVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: str,
                 authorization_config: Optional['outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig'] = None,
                 root_directory: Optional[str] = None,
                 transit_encryption: Optional[str] = None,
                 transit_encryption_port: Optional[int] = None):
        """
        :param str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param 'TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs' authorization_config: Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        :param str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        :param str transit_encryption: Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        :param int transit_encryption_port: Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig']:
        """
        Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[str]:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional[str]:
        """
        Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[int]:
        """
        Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointId":
            suggest = "access_point_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point_id: Optional[str] = None,
                 iam: Optional[str] = None):
        """
        :param str access_point_id: Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        :param str iam: Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[str]:
        """
        Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> Optional[str]:
        """
        Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_config: 'outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig',
                 file_system_id: str,
                 root_directory: str):
        """
        :param 'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs' authorization_config: Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        :param str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        pulumi.set(__self__, "authorization_config", authorization_config)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> 'outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig':
        """
        Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: str,
                 domain: str):
        """
        :param str credentials_parameter: The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        :param str domain: A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> str:
        """
        The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        """
        return pulumi.get(self, "credentials_parameter")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetClusterSettingResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


