# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EndpointAuthenticationOption',
    'EndpointConnectionLogOptions',
]

@pulumi.output_type
class EndpointAuthenticationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryId":
            suggest = "active_directory_id"
        elif key == "rootCertificateChainArn":
            suggest = "root_certificate_chain_arn"
        elif key == "samlProviderArn":
            suggest = "saml_provider_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAuthenticationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAuthenticationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAuthenticationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 active_directory_id: Optional[str] = None,
                 root_certificate_chain_arn: Optional[str] = None,
                 saml_provider_arn: Optional[str] = None):
        """
        :param str type: The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        :param str active_directory_id: The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        :param str root_certificate_chain_arn: The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        :param str saml_provider_arn: The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        """
        pulumi.set(__self__, "type", type)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if root_certificate_chain_arn is not None:
            pulumi.set(__self__, "root_certificate_chain_arn", root_certificate_chain_arn)
        if saml_provider_arn is not None:
            pulumi.set(__self__, "saml_provider_arn", saml_provider_arn)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[str]:
        """
        The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        """
        return pulumi.get(self, "active_directory_id")

    @property
    @pulumi.getter(name="rootCertificateChainArn")
    def root_certificate_chain_arn(self) -> Optional[str]:
        """
        The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        """
        return pulumi.get(self, "root_certificate_chain_arn")

    @property
    @pulumi.getter(name="samlProviderArn")
    def saml_provider_arn(self) -> Optional[str]:
        """
        The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        """
        return pulumi.get(self, "saml_provider_arn")


@pulumi.output_type
class EndpointConnectionLogOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroup":
            suggest = "cloudwatch_log_group"
        elif key == "cloudwatchLogStream":
            suggest = "cloudwatch_log_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConnectionLogOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConnectionLogOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConnectionLogOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 cloudwatch_log_group: Optional[str] = None,
                 cloudwatch_log_stream: Optional[str] = None):
        """
        :param bool enabled: Indicates whether connection logging is enabled.
        :param str cloudwatch_log_group: The name of the CloudWatch Logs log group.
        :param str cloudwatch_log_stream: The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        pulumi.set(__self__, "enabled", enabled)
        if cloudwatch_log_group is not None:
            pulumi.set(__self__, "cloudwatch_log_group", cloudwatch_log_group)
        if cloudwatch_log_stream is not None:
            pulumi.set(__self__, "cloudwatch_log_stream", cloudwatch_log_stream)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether connection logging is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="cloudwatchLogGroup")
    def cloudwatch_log_group(self) -> Optional[str]:
        """
        The name of the CloudWatch Logs log group.
        """
        return pulumi.get(self, "cloudwatch_log_group")

    @property
    @pulumi.getter(name="cloudwatchLogStream")
    def cloudwatch_log_stream(self) -> Optional[str]:
        """
        The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        return pulumi.get(self, "cloudwatch_log_stream")


