# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AmiLaunchPermissionArgs', 'AmiLaunchPermission']

@pulumi.input_type
class AmiLaunchPermissionArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 image_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AmiLaunchPermission resource.
        :param pulumi.Input[str] account_id: An AWS Account ID to add launch permissions.
        :param pulumi.Input[str] image_id: A region-unique name for the AMI.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "image_id", image_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        An AWS Account ID to add launch permissions.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        A region-unique name for the AMI.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)


@pulumi.input_type
class _AmiLaunchPermissionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AmiLaunchPermission resources.
        :param pulumi.Input[str] account_id: An AWS Account ID to add launch permissions.
        :param pulumi.Input[str] image_id: A region-unique name for the AMI.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        An AWS Account ID to add launch permissions.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        A region-unique name for the AMI.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)


class AmiLaunchPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Adds launch permission to Amazon Machine Image (AMI) from another AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            account_id="123456789012",
            image_id="ami-12345678")
        ```

        ## Import

        AWS AMI Launch Permission can be imported using the `ACCOUNT-ID/IMAGE-ID`, e.g.

        ```sh
         $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: An AWS Account ID to add launch permissions.
        :param pulumi.Input[str] image_id: A region-unique name for the AMI.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AmiLaunchPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds launch permission to Amazon Machine Image (AMI) from another AWS account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            account_id="123456789012",
            image_id="ami-12345678")
        ```

        ## Import

        AWS AMI Launch Permission can be imported using the `ACCOUNT-ID/IMAGE-ID`, e.g.

        ```sh
         $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param AmiLaunchPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AmiLaunchPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AmiLaunchPermissionArgs.__new__(AmiLaunchPermissionArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
        super(AmiLaunchPermission, __self__).__init__(
            'aws:ec2/amiLaunchPermission:AmiLaunchPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None) -> 'AmiLaunchPermission':
        """
        Get an existing AmiLaunchPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: An AWS Account ID to add launch permissions.
        :param pulumi.Input[str] image_id: A region-unique name for the AMI.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AmiLaunchPermissionState.__new__(_AmiLaunchPermissionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["image_id"] = image_id
        return AmiLaunchPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        An AWS Account ID to add launch permissions.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        A region-unique name for the AMI.
        """
        return pulumi.get(self, "image_id")

