# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GlobalTableReplicaArgs',
    'TableAttributeArgs',
    'TableGlobalSecondaryIndexArgs',
    'TableLocalSecondaryIndexArgs',
    'TablePointInTimeRecoveryArgs',
    'TableReplicaArgs',
    'TableServerSideEncryptionArgs',
    'TableTtlArgs',
    'GetTableServerSideEncryptionArgs',
]

@pulumi.input_type
class GlobalTableReplicaArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] region_name: AWS region name of replica DynamoDB Table. e.g. `us-east-1`
        """
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[str]:
        """
        AWS region name of replica DynamoDB Table. e.g. `us-east-1`
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_name", value)


@pulumi.input_type
class TableAttributeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the index
        :param pulumi.Input[str] type: Attribute type, which must be a scalar type: `S`, `N`, or `B` for (S)tring, (N)umber or (B)inary data
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the index
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Attribute type, which must be a scalar type: `S`, `N`, or `B` for (S)tring, (N)umber or (B)inary data
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class TableGlobalSecondaryIndexArgs:
    def __init__(__self__, *,
                 hash_key: pulumi.Input[str],
                 name: pulumi.Input[str],
                 projection_type: pulumi.Input[str],
                 non_key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 range_key: Optional[pulumi.Input[str]] = None,
                 read_capacity: Optional[pulumi.Input[int]] = None,
                 write_capacity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] hash_key: The name of the hash key in the index; must be
               defined as an attribute in the resource.
        :param pulumi.Input[str] name: The name of the index
        :param pulumi.Input[str] projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY`
               where `ALL` projects every attribute into the index, `KEYS_ONLY`
               projects just the hash and range key into the index, and `INCLUDE`
               projects only the keys specified in the _non_key_attributes_
               parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_key_attributes: Only required with `INCLUDE` as a
               projection type; a list of attributes to project into the index. These
               do not need to be defined as attributes on the table.
        :param pulumi.Input[str] range_key: The name of the range key; must be defined
        :param pulumi.Input[int] read_capacity: The number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        :param pulumi.Input[int] write_capacity: The number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        pulumi.set(__self__, "hash_key", hash_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if range_key is not None:
            pulumi.set(__self__, "range_key", range_key)
        if read_capacity is not None:
            pulumi.set(__self__, "read_capacity", read_capacity)
        if write_capacity is not None:
            pulumi.set(__self__, "write_capacity", write_capacity)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> pulumi.Input[str]:
        """
        The name of the hash key in the index; must be
        defined as an attribute in the resource.
        """
        return pulumi.get(self, "hash_key")

    @hash_key.setter
    def hash_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the index
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> pulumi.Input[str]:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY`
        where `ALL` projects every attribute into the index, `KEYS_ONLY`
        projects just the hash and range key into the index, and `INCLUDE`
        projects only the keys specified in the _non_key_attributes_
        parameter.
        """
        return pulumi.get(self, "projection_type")

    @projection_type.setter
    def projection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "projection_type", value)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only required with `INCLUDE` as a
        projection type; a list of attributes to project into the index. These
        do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @non_key_attributes.setter
    def non_key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_key_attributes", value)

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the range key; must be defined
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key", value)

    @property
    @pulumi.getter(name="readCapacity")
    def read_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of read units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "read_capacity")

    @read_capacity.setter
    def read_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_capacity", value)

    @property
    @pulumi.getter(name="writeCapacity")
    def write_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of write units for this index. Must be set if billing_mode is set to PROVISIONED.
        """
        return pulumi.get(self, "write_capacity")

    @write_capacity.setter
    def write_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "write_capacity", value)


@pulumi.input_type
class TableLocalSecondaryIndexArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 projection_type: pulumi.Input[str],
                 range_key: pulumi.Input[str],
                 non_key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: The name of the index
        :param pulumi.Input[str] projection_type: One of `ALL`, `INCLUDE` or `KEYS_ONLY`
               where `ALL` projects every attribute into the index, `KEYS_ONLY`
               projects just the hash and range key into the index, and `INCLUDE`
               projects only the keys specified in the _non_key_attributes_
               parameter.
        :param pulumi.Input[str] range_key: The name of the range key; must be defined
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_key_attributes: Only required with `INCLUDE` as a
               projection type; a list of attributes to project into the index. These
               do not need to be defined as attributes on the table.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "projection_type", projection_type)
        pulumi.set(__self__, "range_key", range_key)
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the index
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> pulumi.Input[str]:
        """
        One of `ALL`, `INCLUDE` or `KEYS_ONLY`
        where `ALL` projects every attribute into the index, `KEYS_ONLY`
        projects just the hash and range key into the index, and `INCLUDE`
        projects only the keys specified in the _non_key_attributes_
        parameter.
        """
        return pulumi.get(self, "projection_type")

    @projection_type.setter
    def projection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "projection_type", value)

    @property
    @pulumi.getter(name="rangeKey")
    def range_key(self) -> pulumi.Input[str]:
        """
        The name of the range key; must be defined
        """
        return pulumi.get(self, "range_key")

    @range_key.setter
    def range_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "range_key", value)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only required with `INCLUDE` as a
        projection type; a list of attributes to project into the index. These
        do not need to be defined as attributes on the table.
        """
        return pulumi.get(self, "non_key_attributes")

    @non_key_attributes.setter
    def non_key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_key_attributes", value)


@pulumi.input_type
class TablePointInTimeRecoveryArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Indicates whether ttl is enabled (true) or disabled (false).
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Indicates whether ttl is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class TableReplicaArgs:
    def __init__(__self__, *,
                 region_name: pulumi.Input[str],
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] region_name: Region name of the replica.
        :param pulumi.Input[str] kms_key_arn: The ARN of the CMK that should be used for the AWS KMS encryption.
               This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        pulumi.set(__self__, "region_name", region_name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Input[str]:
        """
        Region name of the replica.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_name", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the CMK that should be used for the AWS KMS encryption.
        This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class TableServerSideEncryptionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates whether ttl is enabled (true) or disabled (false).
        :param pulumi.Input[str] kms_key_arn: The ARN of the CMK that should be used for the AWS KMS encryption.
               This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Indicates whether ttl is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the CMK that should be used for the AWS KMS encryption.
        This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class TableTtlArgs:
    def __init__(__self__, *,
                 attribute_name: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attribute_name: The name of the table attribute to store the TTL timestamp in.
        :param pulumi.Input[bool] enabled: Indicates whether ttl is enabled (true) or disabled (false).
        :param pulumi.Input[str] kms_key_arn: The ARN of the CMK that should be used for the AWS KMS encryption.
               This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> pulumi.Input[str]:
        """
        The name of the table attribute to store the TTL timestamp in.
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether ttl is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the CMK that should be used for the AWS KMS encryption.
        This attribute should only be specified if the key is different from the default DynamoDB CMK, `alias/aws/dynamodb`.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class GetTableServerSideEncryptionArgs:
    def __init__(__self__, *,
                 enabled: bool,
                 kms_key_arn: str):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: bool):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> str:
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: str):
        pulumi.set(self, "kms_key_arn", value)


