# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DirectoryConnectSettings',
    'DirectoryVpcSettings',
    'GetDirectoryConnectSettingResult',
    'GetDirectoryVpcSettingResult',
]

@pulumi.output_type
class DirectoryConnectSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerDnsIps":
            suggest = "customer_dns_ips"
        elif key == "customerUsername":
            suggest = "customer_username"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "connectIps":
            suggest = "connect_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryConnectSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryConnectSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryConnectSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_dns_ips: Sequence[str],
                 customer_username: str,
                 subnet_ids: Sequence[str],
                 vpc_id: str,
                 availability_zones: Optional[Sequence[str]] = None,
                 connect_ips: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] customer_dns_ips: The DNS IP addresses of the domain to connect to.
        :param str customer_username: The username corresponding to the password provided.
        :param Sequence[str] subnet_ids: The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
        :param str vpc_id: The identifier of the VPC that the directory is in.
        :param Sequence[str] connect_ips: The IP addresses of the AD Connector servers.
        """
        pulumi.set(__self__, "customer_dns_ips", customer_dns_ips)
        pulumi.set(__self__, "customer_username", customer_username)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if connect_ips is not None:
            pulumi.set(__self__, "connect_ips", connect_ips)

    @property
    @pulumi.getter(name="customerDnsIps")
    def customer_dns_ips(self) -> Sequence[str]:
        """
        The DNS IP addresses of the domain to connect to.
        """
        return pulumi.get(self, "customer_dns_ips")

    @property
    @pulumi.getter(name="customerUsername")
    def customer_username(self) -> str:
        """
        The username corresponding to the password provided.
        """
        return pulumi.get(self, "customer_username")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The identifier of the VPC that the directory is in.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="connectIps")
    def connect_ips(self) -> Optional[Sequence[str]]:
        """
        The IP addresses of the AD Connector servers.
        """
        return pulumi.get(self, "connect_ips")


@pulumi.output_type
class DirectoryVpcSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "availabilityZones":
            suggest = "availability_zones"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryVpcSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryVpcSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryVpcSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[str],
                 vpc_id: str,
                 availability_zones: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] subnet_ids: The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
        :param str vpc_id: The identifier of the VPC that the directory is in.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The identifier of the VPC that the directory is in.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "availability_zones")


@pulumi.output_type
class GetDirectoryConnectSettingResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 connect_ips: Sequence[str],
                 customer_dns_ips: Sequence[str],
                 customer_username: str,
                 subnet_ids: Sequence[str],
                 vpc_id: str):
        """
        :param Sequence[str] connect_ips: The IP addresses of the AD Connector servers.
        :param Sequence[str] customer_dns_ips: The DNS IP addresses of the domain to connect to.
        :param str customer_username: The username corresponding to the password provided.
        :param Sequence[str] subnet_ids: The identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
        :param str vpc_id: The ID of the VPC that the connector is in.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "connect_ips", connect_ips)
        pulumi.set(__self__, "customer_dns_ips", customer_dns_ips)
        pulumi.set(__self__, "customer_username", customer_username)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="connectIps")
    def connect_ips(self) -> Sequence[str]:
        """
        The IP addresses of the AD Connector servers.
        """
        return pulumi.get(self, "connect_ips")

    @property
    @pulumi.getter(name="customerDnsIps")
    def customer_dns_ips(self) -> Sequence[str]:
        """
        The DNS IP addresses of the domain to connect to.
        """
        return pulumi.get(self, "customer_dns_ips")

    @property
    @pulumi.getter(name="customerUsername")
    def customer_username(self) -> str:
        """
        The username corresponding to the password provided.
        """
        return pulumi.get(self, "customer_username")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC that the connector is in.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetDirectoryVpcSettingResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 subnet_ids: Sequence[str],
                 vpc_id: str):
        """
        :param Sequence[str] subnet_ids: The identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
        :param str vpc_id: The ID of the VPC that the connector is in.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC that the connector is in.
        """
        return pulumi.get(self, "vpc_id")


