# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, arn=None, clone_url_http=None, clone_url_ssh=None, id=None, repository_id=None, repository_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if clone_url_http and not isinstance(clone_url_http, str):
            raise TypeError("Expected argument 'clone_url_http' to be a str")
        pulumi.set(__self__, "clone_url_http", clone_url_http)
        if clone_url_ssh and not isinstance(clone_url_ssh, str):
            raise TypeError("Expected argument 'clone_url_ssh' to be a str")
        pulumi.set(__self__, "clone_url_ssh", clone_url_ssh)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The ARN of the repository
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloneUrlHttp")
    def clone_url_http(self) -> str:
        """
        The URL to use for cloning the repository over HTTPS.
        """
        return pulumi.get(self, "clone_url_http")

    @property
    @pulumi.getter(name="cloneUrlSsh")
    def clone_url_ssh(self) -> str:
        """
        The URL to use for cloning the repository over SSH.
        """
        return pulumi.get(self, "clone_url_ssh")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        The ID of the repository
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> str:
        return pulumi.get(self, "repository_name")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            arn=self.arn,
            clone_url_http=self.clone_url_http,
            clone_url_ssh=self.clone_url_ssh,
            id=self.id,
            repository_id=self.repository_id,
            repository_name=self.repository_name)


def get_repository(repository_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    The CodeCommit Repository data source allows the ARN, Repository ID, Repository URL for HTTP and Repository URL for SSH to be retrieved for an CodeCommit repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.codecommit.get_repository(repository_name="MyTestRepository")
    ```


    :param str repository_name: The name for the repository. This needs to be less than 100 characters.
    """
    __args__ = dict()
    __args__['repositoryName'] = repository_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws:codecommit/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        arn=__ret__.arn,
        clone_url_http=__ret__.clone_url_http,
        clone_url_ssh=__ret__.clone_url_ssh,
        id=__ret__.id,
        repository_id=__ret__.repository_id,
        repository_name=__ret__.repository_name)
