# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ProjectArtifactsArgs',
    'ProjectBuildBatchConfigArgs',
    'ProjectBuildBatchConfigRestrictionsArgs',
    'ProjectCacheArgs',
    'ProjectEnvironmentArgs',
    'ProjectEnvironmentEnvironmentVariableArgs',
    'ProjectEnvironmentRegistryCredentialArgs',
    'ProjectFileSystemLocationArgs',
    'ProjectLogsConfigArgs',
    'ProjectLogsConfigCloudwatchLogsArgs',
    'ProjectLogsConfigS3LogsArgs',
    'ProjectSecondaryArtifactArgs',
    'ProjectSecondarySourceArgs',
    'ProjectSecondarySourceAuthArgs',
    'ProjectSecondarySourceBuildStatusConfigArgs',
    'ProjectSecondarySourceGitSubmodulesConfigArgs',
    'ProjectSourceArgs',
    'ProjectSourceAuthArgs',
    'ProjectSourceBuildStatusConfigArgs',
    'ProjectSourceGitSubmodulesConfigArgs',
    'ProjectVpcConfigArgs',
    'ReportGroupExportConfigArgs',
    'ReportGroupExportConfigS3DestinationArgs',
    'WebhookFilterGroupArgs',
    'WebhookFilterGroupFilterArgs',
]

@pulumi.input_type
class ProjectArtifactsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 artifact_identifier: Optional[pulumi.Input[str]] = None,
                 encryption_disabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_type: Optional[pulumi.Input[str]] = None,
                 override_artifact_name: Optional[pulumi.Input[bool]] = None,
                 packaging: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input[str] artifact_identifier: Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        :param pulumi.Input[bool] encryption_disabled: Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] namespace_type: Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID` or `NONE`.
        :param pulumi.Input[bool] override_artifact_name: Whether a name specified in the build specification overrides the artifact name.
        :param pulumi.Input[str] packaging: Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        :param pulumi.Input[str] path: If `type` is set to `S3`, this is the path to the output artifact.
        """
        pulumi.set(__self__, "type", type)
        if artifact_identifier is not None:
            pulumi.set(__self__, "artifact_identifier", artifact_identifier)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if override_artifact_name is not None:
            pulumi.set(__self__, "override_artifact_name", override_artifact_name)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactIdentifier")
    def artifact_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        """
        return pulumi.get(self, "artifact_identifier")

    @artifact_identifier.setter
    def artifact_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_identifier", value)

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @encryption_disabled.setter
    def encryption_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID` or `NONE`.
        """
        return pulumi.get(self, "namespace_type")

    @namespace_type.setter
    def namespace_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_type", value)

    @property
    @pulumi.getter(name="overrideArtifactName")
    def override_artifact_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a name specified in the build specification overrides the artifact name.
        """
        return pulumi.get(self, "override_artifact_name")

    @override_artifact_name.setter
    def override_artifact_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override_artifact_name", value)

    @property
    @pulumi.getter
    def packaging(self) -> Optional[pulumi.Input[str]]:
        """
        Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        """
        return pulumi.get(self, "packaging")

    @packaging.setter
    def packaging(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packaging", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        If `type` is set to `S3`, this is the path to the output artifact.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ProjectBuildBatchConfigArgs:
    def __init__(__self__, *,
                 service_role: pulumi.Input[str],
                 combine_artifacts: Optional[pulumi.Input[bool]] = None,
                 restrictions: Optional[pulumi.Input['ProjectBuildBatchConfigRestrictionsArgs']] = None,
                 timeout_in_mins: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] service_role: Specifies the service role ARN for the batch build project.
        :param pulumi.Input[bool] combine_artifacts: Specifies if the build artifacts for the batch build should be combined into a single artifact location.
        :param pulumi.Input['ProjectBuildBatchConfigRestrictionsArgs'] restrictions: Specifies the restrictions for the batch build.
        :param pulumi.Input[int] timeout_in_mins: Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
        """
        pulumi.set(__self__, "service_role", service_role)
        if combine_artifacts is not None:
            pulumi.set(__self__, "combine_artifacts", combine_artifacts)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if timeout_in_mins is not None:
            pulumi.set(__self__, "timeout_in_mins", timeout_in_mins)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[str]:
        """
        Specifies the service role ARN for the batch build project.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_role", value)

    @property
    @pulumi.getter(name="combineArtifacts")
    def combine_artifacts(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the build artifacts for the batch build should be combined into a single artifact location.
        """
        return pulumi.get(self, "combine_artifacts")

    @combine_artifacts.setter
    def combine_artifacts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "combine_artifacts", value)

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input['ProjectBuildBatchConfigRestrictionsArgs']]:
        """
        Specifies the restrictions for the batch build.
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input['ProjectBuildBatchConfigRestrictionsArgs']]):
        pulumi.set(self, "restrictions", value)

    @property
    @pulumi.getter(name="timeoutInMins")
    def timeout_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
        """
        return pulumi.get(self, "timeout_in_mins")

    @timeout_in_mins.setter
    def timeout_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_mins", value)


@pulumi.input_type
class ProjectBuildBatchConfigRestrictionsArgs:
    def __init__(__self__, *,
                 compute_types_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_builds_allowed: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compute_types_alloweds: An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
        :param pulumi.Input[int] maximum_builds_allowed: Specifies the maximum number of builds allowed.
        """
        if compute_types_alloweds is not None:
            pulumi.set(__self__, "compute_types_alloweds", compute_types_alloweds)
        if maximum_builds_allowed is not None:
            pulumi.set(__self__, "maximum_builds_allowed", maximum_builds_allowed)

    @property
    @pulumi.getter(name="computeTypesAlloweds")
    def compute_types_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
        """
        return pulumi.get(self, "compute_types_alloweds")

    @compute_types_alloweds.setter
    def compute_types_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compute_types_alloweds", value)

    @property
    @pulumi.getter(name="maximumBuildsAllowed")
    def maximum_builds_allowed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of builds allowed.
        """
        return pulumi.get(self, "maximum_builds_allowed")

    @maximum_builds_allowed.setter
    def maximum_builds_allowed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_builds_allowed", value)


@pulumi.input_type
class ProjectCacheArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] modes: Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
        """
        return pulumi.get(self, "modes")

    @modes.setter
    def modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "modes", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ProjectEnvironmentArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 image: pulumi.Input[str],
                 type: pulumi.Input[str],
                 certificate: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentEnvironmentVariableArgs']]]] = None,
                 image_pull_credentials_type: Optional[pulumi.Input[str]] = None,
                 privileged_mode: Optional[pulumi.Input[bool]] = None,
                 registry_credential: Optional[pulumi.Input['ProjectEnvironmentRegistryCredentialArgs']] = None):
        """
        :param pulumi.Input[str] compute_type: Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`.
        :param pulumi.Input[str] image: Docker image to use for this build project. Valid values include [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) (e.g `aws/codebuild/standard:2.0`), [Docker Hub images](https://hub.docker.com/) (e.g. `nginx:latest`), and full Docker repository URIs such as those for ECR (e.g. `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input[str] certificate: ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentEnvironmentVariableArgs']]] environment_variables: Configuration block. Detailed below.
        :param pulumi.Input[str] image_pull_credentials_type: Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
        :param pulumi.Input[bool] privileged_mode: Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
        :param pulumi.Input['ProjectEnvironmentRegistryCredentialArgs'] registry_credential: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "type", type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image_pull_credentials_type is not None:
            pulumi.set(__self__, "image_pull_credentials_type", image_pull_credentials_type)
        if privileged_mode is not None:
            pulumi.set(__self__, "privileged_mode", privileged_mode)
        if registry_credential is not None:
            pulumi.set(__self__, "registry_credential", registry_credential)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        Docker image to use for this build project. Valid values include [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) (e.g `aws/codebuild/standard:2.0`), [Docker Hub images](https://hub.docker.com/) (e.g. `nginx:latest`), and full Docker repository URIs such as those for ECR (e.g. `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentEnvironmentVariableArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="imagePullCredentialsType")
    def image_pull_credentials_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
        """
        return pulumi.get(self, "image_pull_credentials_type")

    @image_pull_credentials_type.setter
    def image_pull_credentials_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_credentials_type", value)

    @property
    @pulumi.getter(name="privilegedMode")
    def privileged_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
        """
        return pulumi.get(self, "privileged_mode")

    @privileged_mode.setter
    def privileged_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged_mode", value)

    @property
    @pulumi.getter(name="registryCredential")
    def registry_credential(self) -> Optional[pulumi.Input['ProjectEnvironmentRegistryCredentialArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "registry_credential")

    @registry_credential.setter
    def registry_credential(self, value: Optional[pulumi.Input['ProjectEnvironmentRegistryCredentialArgs']]):
        pulumi.set(self, "registry_credential", value)


@pulumi.input_type
class ProjectEnvironmentEnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] value: Environment variable's value.
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Environment variable's value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ProjectEnvironmentRegistryCredentialArgs:
    def __init__(__self__, *,
                 credential: pulumi.Input[str],
                 credential_provider: pulumi.Input[str]):
        """
        :param pulumi.Input[str] credential: ARN or name of credentials created using AWS Secrets Manager.
        :param pulumi.Input[str] credential_provider: Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "credential_provider", credential_provider)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input[str]:
        """
        ARN or name of credentials created using AWS Secrets Manager.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="credentialProvider")
    def credential_provider(self) -> pulumi.Input[str]:
        """
        Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
        """
        return pulumi.get(self, "credential_provider")

    @credential_provider.setter
    def credential_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_provider", value)


@pulumi.input_type
class ProjectFileSystemLocationArgs:
    def __init__(__self__, *,
                 identifier: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 mount_options: Optional[pulumi.Input[str]] = None,
                 mount_point: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] identifier: The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
        :param pulumi.Input[str] location: A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
        :param pulumi.Input[str] mount_options: The mount options for a file system created by AWS EFS.
        :param pulumi.Input[str] mount_point: The location in the container where you mount the file system.
        :param pulumi.Input[str] type: Authorization type to use. The only valid value is `OAUTH`. This data type is deprecated and is no longer accurate or used. Use the `codebuild.SourceCredential` resource instead.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if mount_point is not None:
            pulumi.set(__self__, "mount_point", mount_point)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[str]]:
        """
        The mount options for a file system created by AWS EFS.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> Optional[pulumi.Input[str]]:
        """
        The location in the container where you mount the file system.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Authorization type to use. The only valid value is `OAUTH`. This data type is deprecated and is no longer accurate or used. Use the `codebuild.SourceCredential` resource instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ProjectLogsConfigArgs:
    def __init__(__self__, *,
                 cloudwatch_logs: Optional[pulumi.Input['ProjectLogsConfigCloudwatchLogsArgs']] = None,
                 s3_logs: Optional[pulumi.Input['ProjectLogsConfigS3LogsArgs']] = None):
        """
        :param pulumi.Input['ProjectLogsConfigCloudwatchLogsArgs'] cloudwatch_logs: Configuration block. Detailed below.
        :param pulumi.Input['ProjectLogsConfigS3LogsArgs'] s3_logs: Configuration block. Detailed below.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional[pulumi.Input['ProjectLogsConfigCloudwatchLogsArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @cloudwatch_logs.setter
    def cloudwatch_logs(self, value: Optional[pulumi.Input['ProjectLogsConfigCloudwatchLogsArgs']]):
        pulumi.set(self, "cloudwatch_logs", value)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional[pulumi.Input['ProjectLogsConfigS3LogsArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "s3_logs")

    @s3_logs.setter
    def s3_logs(self, value: Optional[pulumi.Input['ProjectLogsConfigS3LogsArgs']]):
        pulumi.set(self, "s3_logs", value)


@pulumi.input_type
class ProjectLogsConfigCloudwatchLogsArgs:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] group_name: Group name of the logs in CloudWatch Logs.
        :param pulumi.Input[str] status: Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        :param pulumi.Input[str] stream_name: Stream name of the logs in CloudWatch Logs.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Group name of the logs in CloudWatch Logs.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        Stream name of the logs in CloudWatch Logs.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_name", value)


@pulumi.input_type
class ProjectLogsConfigS3LogsArgs:
    def __init__(__self__, *,
                 encryption_disabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] encryption_disabled: Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[str] status: Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        """
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @encryption_disabled.setter
    def encryption_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ProjectSecondaryArtifactArgs:
    def __init__(__self__, *,
                 artifact_identifier: pulumi.Input[str],
                 type: pulumi.Input[str],
                 encryption_disabled: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_type: Optional[pulumi.Input[str]] = None,
                 override_artifact_name: Optional[pulumi.Input[bool]] = None,
                 packaging: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] artifact_identifier: Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input[bool] encryption_disabled: Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[str] name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param pulumi.Input[str] namespace_type: Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID` or `NONE`.
        :param pulumi.Input[bool] override_artifact_name: Whether a name specified in the build specification overrides the artifact name.
        :param pulumi.Input[str] packaging: Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        :param pulumi.Input[str] path: If `type` is set to `S3`, this is the path to the output artifact.
        """
        pulumi.set(__self__, "artifact_identifier", artifact_identifier)
        pulumi.set(__self__, "type", type)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if override_artifact_name is not None:
            pulumi.set(__self__, "override_artifact_name", override_artifact_name)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="artifactIdentifier")
    def artifact_identifier(self) -> pulumi.Input[str]:
        """
        Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        """
        return pulumi.get(self, "artifact_identifier")

    @artifact_identifier.setter
    def artifact_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "artifact_identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @encryption_disabled.setter
    def encryption_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID` or `NONE`.
        """
        return pulumi.get(self, "namespace_type")

    @namespace_type.setter
    def namespace_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_type", value)

    @property
    @pulumi.getter(name="overrideArtifactName")
    def override_artifact_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a name specified in the build specification overrides the artifact name.
        """
        return pulumi.get(self, "override_artifact_name")

    @override_artifact_name.setter
    def override_artifact_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override_artifact_name", value)

    @property
    @pulumi.getter
    def packaging(self) -> Optional[pulumi.Input[str]]:
        """
        Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        """
        return pulumi.get(self, "packaging")

    @packaging.setter
    def packaging(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packaging", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        If `type` is set to `S3`, this is the path to the output artifact.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ProjectSecondarySourceArgs:
    def __init__(__self__, *,
                 source_identifier: pulumi.Input[str],
                 type: pulumi.Input[str],
                 auth: Optional[pulumi.Input['ProjectSecondarySourceAuthArgs']] = None,
                 build_status_config: Optional[pulumi.Input['ProjectSecondarySourceBuildStatusConfigArgs']] = None,
                 buildspec: Optional[pulumi.Input[str]] = None,
                 git_clone_depth: Optional[pulumi.Input[int]] = None,
                 git_submodules_config: Optional[pulumi.Input['ProjectSecondarySourceGitSubmodulesConfigArgs']] = None,
                 insecure_ssl: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 report_build_status: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] source_identifier: Source identifier. Source data will be put inside a folder named as this parameter inside AWS CodeBuild source directory
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input['ProjectSecondarySourceAuthArgs'] auth: Configuration block with the authorization settings for AWS CodeBuild to access the source code to be built. This information is for the AWS CodeBuild console's use only. Use the `codebuild.SourceCredential` resource instead. Auth blocks are documented below.
        :param pulumi.Input['ProjectSecondarySourceBuildStatusConfigArgs'] build_status_config: Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
        :param pulumi.Input[str] buildspec: Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`.
        :param pulumi.Input[int] git_clone_depth: Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        :param pulumi.Input['ProjectSecondarySourceGitSubmodulesConfigArgs'] git_submodules_config: Configuration block. Detailed below.
        :param pulumi.Input[bool] insecure_ssl: Ignore SSL warnings when connecting to source control.
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[bool] report_build_status: Whether to report the status of a build's start and finish to your source provider. This option is only valid when the `type` is `BITBUCKET` or `GITHUB`.
        """
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "type", type)
        if auth is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""auth is deprecated: Use the aws_codebuild_source_credential resource instead""")
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if build_status_config is not None:
            pulumi.set(__self__, "build_status_config", build_status_config)
        if buildspec is not None:
            pulumi.set(__self__, "buildspec", buildspec)
        if git_clone_depth is not None:
            pulumi.set(__self__, "git_clone_depth", git_clone_depth)
        if git_submodules_config is not None:
            pulumi.set(__self__, "git_submodules_config", git_submodules_config)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if report_build_status is not None:
            pulumi.set(__self__, "report_build_status", report_build_status)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> pulumi.Input[str]:
        """
        Source identifier. Source data will be put inside a folder named as this parameter inside AWS CodeBuild source directory
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_identifier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input['ProjectSecondarySourceAuthArgs']]:
        """
        Configuration block with the authorization settings for AWS CodeBuild to access the source code to be built. This information is for the AWS CodeBuild console's use only. Use the `codebuild.SourceCredential` resource instead. Auth blocks are documented below.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input['ProjectSecondarySourceAuthArgs']]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="buildStatusConfig")
    def build_status_config(self) -> Optional[pulumi.Input['ProjectSecondarySourceBuildStatusConfigArgs']]:
        """
        Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
        """
        return pulumi.get(self, "build_status_config")

    @build_status_config.setter
    def build_status_config(self, value: Optional[pulumi.Input['ProjectSecondarySourceBuildStatusConfigArgs']]):
        pulumi.set(self, "build_status_config", value)

    @property
    @pulumi.getter
    def buildspec(self) -> Optional[pulumi.Input[str]]:
        """
        Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`.
        """
        return pulumi.get(self, "buildspec")

    @buildspec.setter
    def buildspec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buildspec", value)

    @property
    @pulumi.getter(name="gitCloneDepth")
    def git_clone_depth(self) -> Optional[pulumi.Input[int]]:
        """
        Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        """
        return pulumi.get(self, "git_clone_depth")

    @git_clone_depth.setter
    def git_clone_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "git_clone_depth", value)

    @property
    @pulumi.getter(name="gitSubmodulesConfig")
    def git_submodules_config(self) -> Optional[pulumi.Input['ProjectSecondarySourceGitSubmodulesConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "git_submodules_config")

    @git_submodules_config.setter
    def git_submodules_config(self, value: Optional[pulumi.Input['ProjectSecondarySourceGitSubmodulesConfigArgs']]):
        pulumi.set(self, "git_submodules_config", value)

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore SSL warnings when connecting to source control.
        """
        return pulumi.get(self, "insecure_ssl")

    @insecure_ssl.setter
    def insecure_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_ssl", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to report the status of a build's start and finish to your source provider. This option is only valid when the `type` is `BITBUCKET` or `GITHUB`.
        """
        return pulumi.get(self, "report_build_status")

    @report_build_status.setter
    def report_build_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "report_build_status", value)


@pulumi.input_type
class ProjectSecondarySourceAuthArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 resource: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input[str] resource: Resource value that applies to the specified authorization type. Use the `codebuild.SourceCredential` resource instead.
        """
        if type is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Use the aws_codebuild_source_credential resource instead""")
        pulumi.set(__self__, "type", type)
        if resource is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""resource is deprecated: Use the aws_codebuild_source_credential resource instead""")
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        Resource value that applies to the specified authorization type. Use the `codebuild.SourceCredential` resource instead.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class ProjectSecondarySourceBuildStatusConfigArgs:
    def __init__(__self__, *,
                 context: Optional[pulumi.Input[str]] = None,
                 target_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] context: Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        :param pulumi.Input[str] target_url: Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "target_url")

    @target_url.setter
    def target_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_url", value)


@pulumi.input_type
class ProjectSecondarySourceGitSubmodulesConfigArgs:
    def __init__(__self__, *,
                 fetch_submodules: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] fetch_submodules: Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        pulumi.set(__self__, "fetch_submodules", fetch_submodules)

    @property
    @pulumi.getter(name="fetchSubmodules")
    def fetch_submodules(self) -> pulumi.Input[bool]:
        """
        Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        return pulumi.get(self, "fetch_submodules")

    @fetch_submodules.setter
    def fetch_submodules(self, value: pulumi.Input[bool]):
        pulumi.set(self, "fetch_submodules", value)


@pulumi.input_type
class ProjectSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 auth: Optional[pulumi.Input['ProjectSourceAuthArgs']] = None,
                 build_status_config: Optional[pulumi.Input['ProjectSourceBuildStatusConfigArgs']] = None,
                 buildspec: Optional[pulumi.Input[str]] = None,
                 git_clone_depth: Optional[pulumi.Input[int]] = None,
                 git_submodules_config: Optional[pulumi.Input['ProjectSourceGitSubmodulesConfigArgs']] = None,
                 insecure_ssl: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 report_build_status: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input['ProjectSourceAuthArgs'] auth: Configuration block with the authorization settings for AWS CodeBuild to access the source code to be built. This information is for the AWS CodeBuild console's use only. Use the `codebuild.SourceCredential` resource instead. Auth blocks are documented below.
        :param pulumi.Input['ProjectSourceBuildStatusConfigArgs'] build_status_config: Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
        :param pulumi.Input[str] buildspec: Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`.
        :param pulumi.Input[int] git_clone_depth: Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        :param pulumi.Input['ProjectSourceGitSubmodulesConfigArgs'] git_submodules_config: Configuration block. Detailed below.
        :param pulumi.Input[bool] insecure_ssl: Ignore SSL warnings when connecting to source control.
        :param pulumi.Input[str] location: Location of the source code from git or s3.
        :param pulumi.Input[bool] report_build_status: Whether to report the status of a build's start and finish to your source provider. This option is only valid when the `type` is `BITBUCKET` or `GITHUB`.
        """
        pulumi.set(__self__, "type", type)
        if auth is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""auth is deprecated: Use the aws_codebuild_source_credential resource instead""")
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if build_status_config is not None:
            pulumi.set(__self__, "build_status_config", build_status_config)
        if buildspec is not None:
            pulumi.set(__self__, "buildspec", buildspec)
        if git_clone_depth is not None:
            pulumi.set(__self__, "git_clone_depth", git_clone_depth)
        if git_submodules_config is not None:
            pulumi.set(__self__, "git_submodules_config", git_submodules_config)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if report_build_status is not None:
            pulumi.set(__self__, "report_build_status", report_build_status)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input['ProjectSourceAuthArgs']]:
        """
        Configuration block with the authorization settings for AWS CodeBuild to access the source code to be built. This information is for the AWS CodeBuild console's use only. Use the `codebuild.SourceCredential` resource instead. Auth blocks are documented below.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input['ProjectSourceAuthArgs']]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="buildStatusConfig")
    def build_status_config(self) -> Optional[pulumi.Input['ProjectSourceBuildStatusConfigArgs']]:
        """
        Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
        """
        return pulumi.get(self, "build_status_config")

    @build_status_config.setter
    def build_status_config(self, value: Optional[pulumi.Input['ProjectSourceBuildStatusConfigArgs']]):
        pulumi.set(self, "build_status_config", value)

    @property
    @pulumi.getter
    def buildspec(self) -> Optional[pulumi.Input[str]]:
        """
        Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`.
        """
        return pulumi.get(self, "buildspec")

    @buildspec.setter
    def buildspec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buildspec", value)

    @property
    @pulumi.getter(name="gitCloneDepth")
    def git_clone_depth(self) -> Optional[pulumi.Input[int]]:
        """
        Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        """
        return pulumi.get(self, "git_clone_depth")

    @git_clone_depth.setter
    def git_clone_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "git_clone_depth", value)

    @property
    @pulumi.getter(name="gitSubmodulesConfig")
    def git_submodules_config(self) -> Optional[pulumi.Input['ProjectSourceGitSubmodulesConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "git_submodules_config")

    @git_submodules_config.setter
    def git_submodules_config(self, value: Optional[pulumi.Input['ProjectSourceGitSubmodulesConfigArgs']]):
        pulumi.set(self, "git_submodules_config", value)

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignore SSL warnings when connecting to source control.
        """
        return pulumi.get(self, "insecure_ssl")

    @insecure_ssl.setter
    def insecure_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_ssl", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to report the status of a build's start and finish to your source provider. This option is only valid when the `type` is `BITBUCKET` or `GITHUB`.
        """
        return pulumi.get(self, "report_build_status")

    @report_build_status.setter
    def report_build_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "report_build_status", value)


@pulumi.input_type
class ProjectSourceAuthArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 resource: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        :param pulumi.Input[str] resource: Resource value that applies to the specified authorization type. Use the `codebuild.SourceCredential` resource instead.
        """
        if type is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""type is deprecated: Use the aws_codebuild_source_credential resource instead""")
        pulumi.set(__self__, "type", type)
        if resource is not None:
            warnings.warn("""Use the aws_codebuild_source_credential resource instead""", DeprecationWarning)
            pulumi.log.warn("""resource is deprecated: Use the aws_codebuild_source_credential resource instead""")
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET`, `S3`, `NO_SOURCE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[str]]:
        """
        Resource value that applies to the specified authorization type. Use the `codebuild.SourceCredential` resource instead.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class ProjectSourceBuildStatusConfigArgs:
    def __init__(__self__, *,
                 context: Optional[pulumi.Input[str]] = None,
                 target_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] context: Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        :param pulumi.Input[str] target_url: Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "target_url")

    @target_url.setter
    def target_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_url", value)


@pulumi.input_type
class ProjectSourceGitSubmodulesConfigArgs:
    def __init__(__self__, *,
                 fetch_submodules: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] fetch_submodules: Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        pulumi.set(__self__, "fetch_submodules", fetch_submodules)

    @property
    @pulumi.getter(name="fetchSubmodules")
    def fetch_submodules(self) -> pulumi.Input[bool]:
        """
        Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        return pulumi.get(self, "fetch_submodules")

    @fetch_submodules.setter
    def fetch_submodules(self, value: pulumi.Input[bool]):
        pulumi.set(self, "fetch_submodules", value)


@pulumi.input_type
class ProjectVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security group IDs to assign to running builds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: Subnet IDs within which to run builds.
        :param pulumi.Input[str] vpc_id: ID of the VPC within which to run builds.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Security group IDs to assign to running builds.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Subnet IDs within which to run builds.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC within which to run builds.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class ReportGroupExportConfigArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 s3_destination: Optional[pulumi.Input['ReportGroupExportConfigS3DestinationArgs']] = None):
        """
        :param pulumi.Input[str] type: The export configuration type. Valid values are `S3` and `NO_EXPORT`.
        :param pulumi.Input['ReportGroupExportConfigS3DestinationArgs'] s3_destination: contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
        """
        pulumi.set(__self__, "type", type)
        if s3_destination is not None:
            pulumi.set(__self__, "s3_destination", s3_destination)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The export configuration type. Valid values are `S3` and `NO_EXPORT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> Optional[pulumi.Input['ReportGroupExportConfigS3DestinationArgs']]:
        """
        contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
        """
        return pulumi.get(self, "s3_destination")

    @s3_destination.setter
    def s3_destination(self, value: Optional[pulumi.Input['ReportGroupExportConfigS3DestinationArgs']]):
        pulumi.set(self, "s3_destination", value)


@pulumi.input_type
class ReportGroupExportConfigS3DestinationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 encryption_key: pulumi.Input[str],
                 encryption_disabled: Optional[pulumi.Input[bool]] = None,
                 packaging: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The name of the S3 bucket where the raw data of a report are exported.
        :param pulumi.Input[str] encryption_key: The encryption key for the report's encrypted raw data. The KMS key ARN.
        :param pulumi.Input[bool] encryption_disabled: A boolean value that specifies if the results of a report are encrypted.
               **Note: the API does not currently allow setting encryption as disabled**
        :param pulumi.Input[str] packaging: The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
        :param pulumi.Input[str] path: The path to the exported report's raw data results.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the S3 bucket where the raw data of a report are exported.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Input[str]:
        """
        The encryption key for the report's encrypted raw data. The KMS key ARN.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that specifies if the results of a report are encrypted.
        **Note: the API does not currently allow setting encryption as disabled**
        """
        return pulumi.get(self, "encryption_disabled")

    @encryption_disabled.setter
    def encryption_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_disabled", value)

    @property
    @pulumi.getter
    def packaging(self) -> Optional[pulumi.Input[str]]:
        """
        The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
        """
        return pulumi.get(self, "packaging")

    @packaging.setter
    def packaging(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packaging", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the exported report's raw data results.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class WebhookFilterGroupArgs:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookFilterGroupFilterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WebhookFilterGroupFilterArgs']]] filters: A webhook filter for the group. Filter blocks are documented below.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookFilterGroupFilterArgs']]]]:
        """
        A webhook filter for the group. Filter blocks are documented below.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookFilterGroupFilterArgs']]]]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class WebhookFilterGroupFilterArgs:
    def __init__(__self__, *,
                 pattern: pulumi.Input[str],
                 type: pulumi.Input[str],
                 exclude_matched_pattern: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] pattern: For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
        :param pulumi.Input[str] type: The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`. At least one filter group must specify `EVENT` as its type.
        :param pulumi.Input[bool] exclude_matched_pattern: If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)
        if exclude_matched_pattern is not None:
            pulumi.set(__self__, "exclude_matched_pattern", exclude_matched_pattern)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[str]:
        """
        For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`. At least one filter group must specify `EVENT` as its type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="excludeMatchedPattern")
    def exclude_matched_pattern(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_matched_pattern")

    @exclude_matched_pattern.setter
    def exclude_matched_pattern(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_matched_pattern", value)


