# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'TrailEventSelector',
    'TrailEventSelectorDataResource',
    'TrailInsightSelector',
]

@pulumi.output_type
class TrailEventSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataResources":
            suggest = "data_resources"
        elif key == "includeManagementEvents":
            suggest = "include_management_events"
        elif key == "readWriteType":
            suggest = "read_write_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrailEventSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrailEventSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrailEventSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_resources: Optional[Sequence['outputs.TrailEventSelectorDataResource']] = None,
                 include_management_events: Optional[bool] = None,
                 read_write_type: Optional[str] = None):
        """
        :param Sequence['TrailEventSelectorDataResourceArgs'] data_resources: Configuration block for data events. See details below.
        :param bool include_management_events: Whether to include management events for your trail.
        :param str read_write_type: Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
        """
        if data_resources is not None:
            pulumi.set(__self__, "data_resources", data_resources)
        if include_management_events is not None:
            pulumi.set(__self__, "include_management_events", include_management_events)
        if read_write_type is not None:
            pulumi.set(__self__, "read_write_type", read_write_type)

    @property
    @pulumi.getter(name="dataResources")
    def data_resources(self) -> Optional[Sequence['outputs.TrailEventSelectorDataResource']]:
        """
        Configuration block for data events. See details below.
        """
        return pulumi.get(self, "data_resources")

    @property
    @pulumi.getter(name="includeManagementEvents")
    def include_management_events(self) -> Optional[bool]:
        """
        Whether to include management events for your trail.
        """
        return pulumi.get(self, "include_management_events")

    @property
    @pulumi.getter(name="readWriteType")
    def read_write_type(self) -> Optional[str]:
        """
        Type of events to log. Valid values are `ReadOnly`, `WriteOnly`, `All`. Default value is `All`.
        """
        return pulumi.get(self, "read_write_type")


@pulumi.output_type
class TrailEventSelectorDataResource(dict):
    def __init__(__self__, *,
                 type: str,
                 values: Sequence[str]):
        """
        :param str type: Resource type in which you want to log data events. You can specify only the following value: "AWS::S3::Object", "AWS::Lambda::Function" and "AWS::DynamoDB::Table".
        :param Sequence[str] values: List of ARN strings or partial ARN strings to specify selectors for data audit events over data resources. ARN list is specific to single-valued `type`. For example, `arn:aws:s3:::<bucket name>/` for all objects in a bucket, `arn:aws:s3:::<bucket name>/key` for specific objects, `arn:aws:lambda` for all lambda events within an account, `arn:aws:lambda:<region>:<account number>:function:<function name>` for a specific Lambda function, `arn:aws:dynamodb` for all DDB events for all tables within an account, or `arn:aws:dynamodb:<region>:<account number>:table/<table name>` for a specific DynamoDB table.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type in which you want to log data events. You can specify only the following value: "AWS::S3::Object", "AWS::Lambda::Function" and "AWS::DynamoDB::Table".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of ARN strings or partial ARN strings to specify selectors for data audit events over data resources. ARN list is specific to single-valued `type`. For example, `arn:aws:s3:::<bucket name>/` for all objects in a bucket, `arn:aws:s3:::<bucket name>/key` for specific objects, `arn:aws:lambda` for all lambda events within an account, `arn:aws:lambda:<region>:<account number>:function:<function name>` for a specific Lambda function, `arn:aws:dynamodb` for all DDB events for all tables within an account, or `arn:aws:dynamodb:<region>:<account number>:table/<table name>` for a specific DynamoDB table.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class TrailInsightSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insightType":
            suggest = "insight_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrailInsightSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrailInsightSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrailInsightSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insight_type: str):
        """
        :param str insight_type: Type of insights to log on a trail. The valid value is `ApiCallRateInsight`.
        """
        pulumi.set(__self__, "insight_type", insight_type)

    @property
    @pulumi.getter(name="insightType")
    def insight_type(self) -> str:
        """
        Type of insights to log on a trail. The valid value is `ApiCallRateInsight`.
        """
        return pulumi.get(self, "insight_type")


