# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CachePolicyParametersInCacheKeyAndForwardedToOriginArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs',
    'CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs',
    'DistributionCustomErrorResponseArgs',
    'DistributionDefaultCacheBehaviorArgs',
    'DistributionDefaultCacheBehaviorForwardedValuesArgs',
    'DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs',
    'DistributionDefaultCacheBehaviorFunctionAssociationArgs',
    'DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs',
    'DistributionLoggingConfigArgs',
    'DistributionOrderedCacheBehaviorArgs',
    'DistributionOrderedCacheBehaviorForwardedValuesArgs',
    'DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs',
    'DistributionOrderedCacheBehaviorFunctionAssociationArgs',
    'DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs',
    'DistributionOriginArgs',
    'DistributionOriginCustomHeaderArgs',
    'DistributionOriginCustomOriginConfigArgs',
    'DistributionOriginGroupArgs',
    'DistributionOriginGroupFailoverCriteriaArgs',
    'DistributionOriginGroupMemberArgs',
    'DistributionOriginOriginShieldArgs',
    'DistributionOriginS3OriginConfigArgs',
    'DistributionRestrictionsArgs',
    'DistributionRestrictionsGeoRestrictionArgs',
    'DistributionTrustedKeyGroupArgs',
    'DistributionTrustedKeyGroupItemArgs',
    'DistributionTrustedSignerArgs',
    'DistributionTrustedSignerItemArgs',
    'DistributionViewerCertificateArgs',
    'MonitoringSubscriptionMonitoringSubscriptionArgs',
    'MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs',
    'OriginRequestPolicyCookiesConfigArgs',
    'OriginRequestPolicyCookiesConfigCookiesArgs',
    'OriginRequestPolicyHeadersConfigArgs',
    'OriginRequestPolicyHeadersConfigHeadersArgs',
    'OriginRequestPolicyQueryStringsConfigArgs',
    'OriginRequestPolicyQueryStringsConfigQueryStringsArgs',
    'RealtimeLogConfigEndpointArgs',
    'RealtimeLogConfigEndpointKinesisStreamConfigArgs',
]

@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginArgs:
    def __init__(__self__, *,
                 cookies_config: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs'],
                 headers_config: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs'],
                 query_strings_config: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs'],
                 enable_accept_encoding_brotli: Optional[pulumi.Input[bool]] = None,
                 enable_accept_encoding_gzip: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs'] cookies_config: Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs'] headers_config: Object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs'] query_strings_config: Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Query Strings Config for more information.
        :param pulumi.Input[bool] enable_accept_encoding_brotli: A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
        :param pulumi.Input[bool] enable_accept_encoding_gzip: A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
        """
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if enable_accept_encoding_brotli is not None:
            pulumi.set(__self__, "enable_accept_encoding_brotli", enable_accept_encoding_brotli)
        if enable_accept_encoding_gzip is not None:
            pulumi.set(__self__, "enable_accept_encoding_gzip", enable_accept_encoding_gzip)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs']:
        """
        Object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Cookies Config for more information.
        """
        return pulumi.get(self, "cookies_config")

    @cookies_config.setter
    def cookies_config(self, value: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs']):
        pulumi.set(self, "cookies_config", value)

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs']:
        """
        Object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Headers Config for more information.
        """
        return pulumi.get(self, "headers_config")

    @headers_config.setter
    def headers_config(self, value: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs']):
        pulumi.set(self, "headers_config", value)

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs']:
        """
        Object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin. See Query Strings Config for more information.
        """
        return pulumi.get(self, "query_strings_config")

    @query_strings_config.setter
    def query_strings_config(self, value: pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs']):
        pulumi.set(self, "query_strings_config", value)

    @property
    @pulumi.getter(name="enableAcceptEncodingBrotli")
    def enable_accept_encoding_brotli(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "enable_accept_encoding_brotli")

    @enable_accept_encoding_brotli.setter
    def enable_accept_encoding_brotli(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accept_encoding_brotli", value)

    @property
    @pulumi.getter(name="enableAcceptEncodingGzip")
    def enable_accept_encoding_gzip(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag that can affect whether the Accept-Encoding HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.
        """
        return pulumi.get(self, "enable_accept_encoding_gzip")

    @enable_accept_encoding_gzip.setter
    def enable_accept_encoding_gzip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accept_encoding_gzip", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigArgs:
    def __init__(__self__, *,
                 cookie_behavior: pulumi.Input[str],
                 cookies: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs']] = None):
        """
        :param pulumi.Input[str] cookie_behavior: Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs'] cookies: Object that contains a list of cookie names. See Items for more information.
        """
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> pulumi.Input[str]:
        """
        Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
        """
        return pulumi.get(self, "cookie_behavior")

    @cookie_behavior.setter
    def cookie_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "cookie_behavior", value)

    @property
    @pulumi.getter
    def cookies(self) -> Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs']]:
        """
        Object that contains a list of cookie names. See Items for more information.
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs']]):
        pulumi.set(self, "cookies", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginCookiesConfigCookiesArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of item names (cookies, headers, or query strings).
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of item names (cookies, headers, or query strings).
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigArgs:
    def __init__(__self__, *,
                 header_behavior: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs']] = None):
        """
        :param pulumi.Input[str] header_behavior: Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs'] headers: Object that contains a list of header names. See Items for more information.
        """
        if header_behavior is not None:
            pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`.
        """
        return pulumi.get(self, "header_behavior")

    @header_behavior.setter
    def header_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_behavior", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs']]:
        """
        Object that contains a list of header names. See Items for more information.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs']]):
        pulumi.set(self, "headers", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginHeadersConfigHeadersArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of item names (cookies, headers, or query strings).
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of item names (cookies, headers, or query strings).
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigArgs:
    def __init__(__self__, *,
                 query_string_behavior: pulumi.Input[str],
                 query_strings: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs']] = None):
        """
        :param pulumi.Input[str] query_string_behavior: Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
        :param pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs'] query_strings: Object that contains a list of query string names. See Items for more information.
        """
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> pulumi.Input[str]:
        """
        Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are `none`, `whitelist`, `allExcept`, `all`.
        """
        return pulumi.get(self, "query_string_behavior")

    @query_string_behavior.setter
    def query_string_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_string_behavior", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs']]:
        """
        Object that contains a list of query string names. See Items for more information.
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input['CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs']]):
        pulumi.set(self, "query_strings", value)


@pulumi.input_type
class CachePolicyParametersInCacheKeyAndForwardedToOriginQueryStringsConfigQueryStringsArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: A list of item names (cookies, headers, or query strings).
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of item names (cookies, headers, or query strings).
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class DistributionCustomErrorResponseArgs:
    def __init__(__self__, *,
                 error_code: pulumi.Input[int],
                 error_caching_min_ttl: Optional[pulumi.Input[int]] = None,
                 response_code: Optional[pulumi.Input[int]] = None,
                 response_page_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] error_code: The 4xx or 5xx HTTP status code that you want to
               customize.
        :param pulumi.Input[int] error_caching_min_ttl: The minimum amount of time you want
               HTTP error codes to stay in CloudFront caches before CloudFront queries your
               origin to see whether the object has been updated.
        :param pulumi.Input[int] response_code: The HTTP status code that you want CloudFront
               to return with the custom error page to the viewer.
        :param pulumi.Input[str] response_page_path: The path of the custom error page (for
               example, `/custom_404.html`).
        """
        pulumi.set(__self__, "error_code", error_code)
        if error_caching_min_ttl is not None:
            pulumi.set(__self__, "error_caching_min_ttl", error_caching_min_ttl)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if response_page_path is not None:
            pulumi.set(__self__, "response_page_path", response_page_path)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Input[int]:
        """
        The 4xx or 5xx HTTP status code that you want to
        customize.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "error_code", value)

    @property
    @pulumi.getter(name="errorCachingMinTtl")
    def error_caching_min_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of time you want
        HTTP error codes to stay in CloudFront caches before CloudFront queries your
        origin to see whether the object has been updated.
        """
        return pulumi.get(self, "error_caching_min_ttl")

    @error_caching_min_ttl.setter
    def error_caching_min_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_caching_min_ttl", value)

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP status code that you want CloudFront
        to return with the custom error page to the viewer.
        """
        return pulumi.get(self, "response_code")

    @response_code.setter
    def response_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "response_code", value)

    @property
    @pulumi.getter(name="responsePagePath")
    def response_page_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the custom error page (for
        example, `/custom_404.html`).
        """
        return pulumi.get(self, "response_page_path")

    @response_page_path.setter
    def response_page_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_page_path", value)


@pulumi.input_type
class DistributionDefaultCacheBehaviorArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cached_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 target_origin_id: pulumi.Input[str],
                 viewer_protocol_policy: pulumi.Input[str],
                 cache_policy_id: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 field_level_encryption_id: Optional[pulumi.Input[str]] = None,
                 forwarded_values: Optional[pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesArgs']] = None,
                 function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorFunctionAssociationArgs']]]] = None,
                 lambda_function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs']]]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 min_ttl: Optional[pulumi.Input[int]] = None,
                 origin_request_policy_id: Optional[pulumi.Input[str]] = None,
                 realtime_log_config_arn: Optional[pulumi.Input[str]] = None,
                 smooth_streaming: Optional[pulumi.Input[bool]] = None,
                 trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Controls which HTTP methods CloudFront
               processes and forwards to your Amazon S3 bucket or your custom origin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cached_methods: Controls whether CloudFront caches the
               response to requests using the specified HTTP methods.
        :param pulumi.Input[str] target_origin_id: The value of ID for the origin that you want
               CloudFront to route requests to when a request matches the path pattern
               either for a cache behavior or for the default cache behavior.
        :param pulumi.Input[str] viewer_protocol_policy: Use this element to specify the
               protocol that users can use to access the files in the origin specified by
               TargetOriginId when a request matches the path pattern in PathPattern. One
               of `allow-all`, `https-only`, or `redirect-to-https`.
        :param pulumi.Input[str] cache_policy_id: The unique identifier of the cache policy that
               is attached to the cache behavior.
        :param pulumi.Input[bool] compress: Whether you want CloudFront to automatically
               compress content for web requests that include `Accept-Encoding: gzip` in
               the request header (default: `false`).
        :param pulumi.Input[int] default_ttl: The default amount of time (in seconds) that an
               object is in a CloudFront cache before CloudFront forwards another request
               in the absence of an `Cache-Control max-age` or `Expires` header.
        :param pulumi.Input[str] field_level_encryption_id: Field level encryption configuration ID
        :param pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesArgs'] forwarded_values: The forwarded values configuration that specifies how CloudFront
               handles query strings, cookies and headers (maximum one).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorFunctionAssociationArgs']]] function_associations: A config block that triggers a cloudfront
               function with specific actions (maximum 2).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs']]] lambda_function_associations: A config block that triggers a lambda
               function with specific actions (maximum 4).
        :param pulumi.Input[int] max_ttl: The maximum amount of time (in seconds) that an
               object is in a CloudFront cache before CloudFront forwards another request
               to your origin to determine whether the object has been updated. Only
               effective in the presence of `Cache-Control max-age`, `Cache-Control
               s-maxage`, and `Expires` headers.
        :param pulumi.Input[int] min_ttl: The minimum amount of time that you want objects to
               stay in CloudFront caches before CloudFront queries your origin to see
               whether the object has been updated. Defaults to 0 seconds.
        :param pulumi.Input[str] origin_request_policy_id: The unique identifier of the origin request policy
               that is attached to the behavior.
        :param pulumi.Input[str] realtime_log_config_arn: The ARN of the real-time log configuration
               that is attached to this cache behavior.
        :param pulumi.Input[bool] smooth_streaming: Indicates whether you want to distribute
               media files in Microsoft Smooth Streaming format using the origin that is
               associated with this cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_key_groups: A list of key group IDs that CloudFront can use to validate signed URLs or signed cookies.
               See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_signers: List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content.
               See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "cached_methods", cached_methods)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Controls which HTTP methods CloudFront
        processes and forwards to your Amazon S3 bucket or your custom origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Controls whether CloudFront caches the
        response to requests using the specified HTTP methods.
        """
        return pulumi.get(self, "cached_methods")

    @cached_methods.setter
    def cached_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "cached_methods", value)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> pulumi.Input[str]:
        """
        The value of ID for the origin that you want
        CloudFront to route requests to when a request matches the path pattern
        either for a cache behavior or for the default cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @target_origin_id.setter
    def target_origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_origin_id", value)

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> pulumi.Input[str]:
        """
        Use this element to specify the
        protocol that users can use to access the files in the origin specified by
        TargetOriginId when a request matches the path pattern in PathPattern. One
        of `allow-all`, `https-only`, or `redirect-to-https`.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @viewer_protocol_policy.setter
    def viewer_protocol_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "viewer_protocol_policy", value)

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the cache policy that
        is attached to the cache behavior.
        """
        return pulumi.get(self, "cache_policy_id")

    @cache_policy_id.setter
    def cache_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_policy_id", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you want CloudFront to automatically
        compress content for web requests that include `Accept-Encoding: gzip` in
        the request header (default: `false`).
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default amount of time (in seconds) that an
        object is in a CloudFront cache before CloudFront forwards another request
        in the absence of an `Cache-Control max-age` or `Expires` header.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Field level encryption configuration ID
        """
        return pulumi.get(self, "field_level_encryption_id")

    @field_level_encryption_id.setter
    def field_level_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_level_encryption_id", value)

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional[pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesArgs']]:
        """
        The forwarded values configuration that specifies how CloudFront
        handles query strings, cookies and headers (maximum one).
        """
        return pulumi.get(self, "forwarded_values")

    @forwarded_values.setter
    def forwarded_values(self, value: Optional[pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesArgs']]):
        pulumi.set(self, "forwarded_values", value)

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorFunctionAssociationArgs']]]]:
        """
        A config block that triggers a cloudfront
        function with specific actions (maximum 2).
        """
        return pulumi.get(self, "function_associations")

    @function_associations.setter
    def function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorFunctionAssociationArgs']]]]):
        pulumi.set(self, "function_associations", value)

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs']]]]:
        """
        A config block that triggers a lambda
        function with specific actions (maximum 4).
        """
        return pulumi.get(self, "lambda_function_associations")

    @lambda_function_associations.setter
    def lambda_function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs']]]]):
        pulumi.set(self, "lambda_function_associations", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time (in seconds) that an
        object is in a CloudFront cache before CloudFront forwards another request
        to your origin to determine whether the object has been updated. Only
        effective in the presence of `Cache-Control max-age`, `Cache-Control
        s-maxage`, and `Expires` headers.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of time that you want objects to
        stay in CloudFront caches before CloudFront queries your origin to see
        whether the object has been updated. Defaults to 0 seconds.
        """
        return pulumi.get(self, "min_ttl")

    @min_ttl.setter
    def min_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ttl", value)

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the origin request policy
        that is attached to the behavior.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @origin_request_policy_id.setter
    def origin_request_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_request_policy_id", value)

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the real-time log configuration
        that is attached to this cache behavior.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @realtime_log_config_arn.setter
    def realtime_log_config_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realtime_log_config_arn", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether you want to distribute
        media files in Microsoft Smooth Streaming format using the origin that is
        associated with this cache behavior.
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smooth_streaming", value)

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of key group IDs that CloudFront can use to validate signed URLs or signed cookies.
        See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        return pulumi.get(self, "trusted_key_groups")

    @trusted_key_groups.setter
    def trusted_key_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_key_groups", value)

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content.
        See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        return pulumi.get(self, "trusted_signers")

    @trusted_signers.setter
    def trusted_signers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_signers", value)


@pulumi.input_type
class DistributionDefaultCacheBehaviorForwardedValuesArgs:
    def __init__(__self__, *,
                 cookies: pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs'],
                 query_string: pulumi.Input[bool],
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_cache_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs'] cookies: The forwarded values cookies
               that specifies how CloudFront handles cookies (maximum one).
        :param pulumi.Input[bool] query_string: Indicates whether you want CloudFront to forward
               query strings to the origin that is associated with this cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] headers: Specifies the Headers, if any, that you want
               CloudFront to vary upon for this cache behavior. Specify `*` to include all
               headers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_string_cache_keys: When specified, along with a value of
               `true` for `query_string`, all query strings are forwarded, however only the
               query string keys listed in this argument are cached. When omitted with a
               value of `true` for `query_string`, all query string keys are cached.
        """
        pulumi.set(__self__, "cookies", cookies)
        pulumi.set(__self__, "query_string", query_string)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter
    def cookies(self) -> pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs']:
        """
        The forwarded values cookies
        that specifies how CloudFront handles cookies (maximum one).
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: pulumi.Input['DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs']):
        pulumi.set(self, "cookies", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[bool]:
        """
        Indicates whether you want CloudFront to forward
        query strings to the origin that is associated with this cache behavior.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[bool]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the Headers, if any, that you want
        CloudFront to vary upon for this cache behavior. Specify `*` to include all
        headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When specified, along with a value of
        `true` for `query_string`, all query strings are forwarded, however only the
        query string keys listed in this argument are cached. When omitted with a
        value of `true` for `query_string`, all query string keys are cached.
        """
        return pulumi.get(self, "query_string_cache_keys")

    @query_string_cache_keys.setter
    def query_string_cache_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_cache_keys", value)


@pulumi.input_type
class DistributionDefaultCacheBehaviorForwardedValuesCookiesArgs:
    def __init__(__self__, *,
                 forward: pulumi.Input[str],
                 whitelisted_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] forward: Specifies whether you want CloudFront to forward
               cookies to the origin that is associated with this cache behavior. You can
               specify `all`, `none` or `whitelist`. If `whitelist`, you must include the
               subsequent `whitelisted_names`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_names: If you have specified `whitelist` to
               `forward`, the whitelisted cookies that you want CloudFront to forward to
               your origin.
        """
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> pulumi.Input[str]:
        """
        Specifies whether you want CloudFront to forward
        cookies to the origin that is associated with this cache behavior. You can
        specify `all`, `none` or `whitelist`. If `whitelist`, you must include the
        subsequent `whitelisted_names`
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: pulumi.Input[str]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If you have specified `whitelist` to
        `forward`, the whitelisted cookies that you want CloudFront to forward to
        your origin.
        """
        return pulumi.get(self, "whitelisted_names")

    @whitelisted_names.setter
    def whitelisted_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelisted_names", value)


@pulumi.input_type
class DistributionDefaultCacheBehaviorFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[str],
                 function_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] event_type: The specific event to trigger this function.
               Valid values: `viewer-request` or `viewer-response`
        :param pulumi.Input[str] function_arn: ARN of the Cloudfront function.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[str]:
        """
        The specific event to trigger this function.
        Valid values: `viewer-request` or `viewer-response`
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Cloudfront function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)


@pulumi.input_type
class DistributionDefaultCacheBehaviorLambdaFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[str],
                 lambda_arn: pulumi.Input[str],
                 include_body: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] event_type: The specific event to trigger this function.
               Valid values: `viewer-request` or `viewer-response`
        :param pulumi.Input[str] lambda_arn: ARN of the Lambda function.
        :param pulumi.Input[bool] include_body: When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[str]:
        """
        The specific event to trigger this function.
        Valid values: `viewer-request` or `viewer-response`
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Lambda function.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_arn", value)

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "include_body")

    @include_body.setter
    def include_body(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_body", value)


@pulumi.input_type
class DistributionLoggingConfigArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 include_cookies: Optional[pulumi.Input[bool]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: The Amazon S3 bucket to store the access logs in, for
               example, `myawslogbucket.s3.amazonaws.com`.
        :param pulumi.Input[bool] include_cookies: Specifies whether you want CloudFront to
               include cookies in access logs (default: `false`).
        :param pulumi.Input[str] prefix: An optional string that you want CloudFront to prefix
               to the access log filenames for this distribution, for example, `myprefix/`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The Amazon S3 bucket to store the access logs in, for
        example, `myawslogbucket.s3.amazonaws.com`.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether you want CloudFront to
        include cookies in access logs (default: `false`).
        """
        return pulumi.get(self, "include_cookies")

    @include_cookies.setter
    def include_cookies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_cookies", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        An optional string that you want CloudFront to prefix
        to the access log filenames for this distribution, for example, `myprefix/`.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class DistributionOrderedCacheBehaviorArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cached_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path_pattern: pulumi.Input[str],
                 target_origin_id: pulumi.Input[str],
                 viewer_protocol_policy: pulumi.Input[str],
                 cache_policy_id: Optional[pulumi.Input[str]] = None,
                 compress: Optional[pulumi.Input[bool]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 field_level_encryption_id: Optional[pulumi.Input[str]] = None,
                 forwarded_values: Optional[pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesArgs']] = None,
                 function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorFunctionAssociationArgs']]]] = None,
                 lambda_function_associations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs']]]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 min_ttl: Optional[pulumi.Input[int]] = None,
                 origin_request_policy_id: Optional[pulumi.Input[str]] = None,
                 realtime_log_config_arn: Optional[pulumi.Input[str]] = None,
                 smooth_streaming: Optional[pulumi.Input[bool]] = None,
                 trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Controls which HTTP methods CloudFront
               processes and forwards to your Amazon S3 bucket or your custom origin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cached_methods: Controls whether CloudFront caches the
               response to requests using the specified HTTP methods.
        :param pulumi.Input[str] path_pattern: The pattern (for example, `images/*.jpg)` that
               specifies which requests you want this cache behavior to apply to.
        :param pulumi.Input[str] target_origin_id: The value of ID for the origin that you want
               CloudFront to route requests to when a request matches the path pattern
               either for a cache behavior or for the default cache behavior.
        :param pulumi.Input[str] viewer_protocol_policy: Use this element to specify the
               protocol that users can use to access the files in the origin specified by
               TargetOriginId when a request matches the path pattern in PathPattern. One
               of `allow-all`, `https-only`, or `redirect-to-https`.
        :param pulumi.Input[str] cache_policy_id: The unique identifier of the cache policy that
               is attached to the cache behavior.
        :param pulumi.Input[bool] compress: Whether you want CloudFront to automatically
               compress content for web requests that include `Accept-Encoding: gzip` in
               the request header (default: `false`).
        :param pulumi.Input[int] default_ttl: The default amount of time (in seconds) that an
               object is in a CloudFront cache before CloudFront forwards another request
               in the absence of an `Cache-Control max-age` or `Expires` header.
        :param pulumi.Input[str] field_level_encryption_id: Field level encryption configuration ID
        :param pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesArgs'] forwarded_values: The forwarded values configuration that specifies how CloudFront
               handles query strings, cookies and headers (maximum one).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorFunctionAssociationArgs']]] function_associations: A config block that triggers a cloudfront
               function with specific actions (maximum 2).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs']]] lambda_function_associations: A config block that triggers a lambda
               function with specific actions (maximum 4).
        :param pulumi.Input[int] max_ttl: The maximum amount of time (in seconds) that an
               object is in a CloudFront cache before CloudFront forwards another request
               to your origin to determine whether the object has been updated. Only
               effective in the presence of `Cache-Control max-age`, `Cache-Control
               s-maxage`, and `Expires` headers.
        :param pulumi.Input[int] min_ttl: The minimum amount of time that you want objects to
               stay in CloudFront caches before CloudFront queries your origin to see
               whether the object has been updated. Defaults to 0 seconds.
        :param pulumi.Input[str] origin_request_policy_id: The unique identifier of the origin request policy
               that is attached to the behavior.
        :param pulumi.Input[str] realtime_log_config_arn: The ARN of the real-time log configuration
               that is attached to this cache behavior.
        :param pulumi.Input[bool] smooth_streaming: Indicates whether you want to distribute
               media files in Microsoft Smooth Streaming format using the origin that is
               associated with this cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_key_groups: A list of key group IDs that CloudFront can use to validate signed URLs or signed cookies.
               See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_signers: List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content.
               See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "cached_methods", cached_methods)
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Controls which HTTP methods CloudFront
        processes and forwards to your Amazon S3 bucket or your custom origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Controls whether CloudFront caches the
        response to requests using the specified HTTP methods.
        """
        return pulumi.get(self, "cached_methods")

    @cached_methods.setter
    def cached_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "cached_methods", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> pulumi.Input[str]:
        """
        The pattern (for example, `images/*.jpg)` that
        specifies which requests you want this cache behavior to apply to.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> pulumi.Input[str]:
        """
        The value of ID for the origin that you want
        CloudFront to route requests to when a request matches the path pattern
        either for a cache behavior or for the default cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @target_origin_id.setter
    def target_origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_origin_id", value)

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> pulumi.Input[str]:
        """
        Use this element to specify the
        protocol that users can use to access the files in the origin specified by
        TargetOriginId when a request matches the path pattern in PathPattern. One
        of `allow-all`, `https-only`, or `redirect-to-https`.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @viewer_protocol_policy.setter
    def viewer_protocol_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "viewer_protocol_policy", value)

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the cache policy that
        is attached to the cache behavior.
        """
        return pulumi.get(self, "cache_policy_id")

    @cache_policy_id.setter
    def cache_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_policy_id", value)

    @property
    @pulumi.getter
    def compress(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether you want CloudFront to automatically
        compress content for web requests that include `Accept-Encoding: gzip` in
        the request header (default: `false`).
        """
        return pulumi.get(self, "compress")

    @compress.setter
    def compress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "compress", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default amount of time (in seconds) that an
        object is in a CloudFront cache before CloudFront forwards another request
        in the absence of an `Cache-Control max-age` or `Expires` header.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Field level encryption configuration ID
        """
        return pulumi.get(self, "field_level_encryption_id")

    @field_level_encryption_id.setter
    def field_level_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_level_encryption_id", value)

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional[pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesArgs']]:
        """
        The forwarded values configuration that specifies how CloudFront
        handles query strings, cookies and headers (maximum one).
        """
        return pulumi.get(self, "forwarded_values")

    @forwarded_values.setter
    def forwarded_values(self, value: Optional[pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesArgs']]):
        pulumi.set(self, "forwarded_values", value)

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorFunctionAssociationArgs']]]]:
        """
        A config block that triggers a cloudfront
        function with specific actions (maximum 2).
        """
        return pulumi.get(self, "function_associations")

    @function_associations.setter
    def function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorFunctionAssociationArgs']]]]):
        pulumi.set(self, "function_associations", value)

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs']]]]:
        """
        A config block that triggers a lambda
        function with specific actions (maximum 4).
        """
        return pulumi.get(self, "lambda_function_associations")

    @lambda_function_associations.setter
    def lambda_function_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs']]]]):
        pulumi.set(self, "lambda_function_associations", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time (in seconds) that an
        object is in a CloudFront cache before CloudFront forwards another request
        to your origin to determine whether the object has been updated. Only
        effective in the presence of `Cache-Control max-age`, `Cache-Control
        s-maxage`, and `Expires` headers.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of time that you want objects to
        stay in CloudFront caches before CloudFront queries your origin to see
        whether the object has been updated. Defaults to 0 seconds.
        """
        return pulumi.get(self, "min_ttl")

    @min_ttl.setter
    def min_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ttl", value)

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the origin request policy
        that is attached to the behavior.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @origin_request_policy_id.setter
    def origin_request_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_request_policy_id", value)

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the real-time log configuration
        that is attached to this cache behavior.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @realtime_log_config_arn.setter
    def realtime_log_config_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realtime_log_config_arn", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether you want to distribute
        media files in Microsoft Smooth Streaming format using the origin that is
        associated with this cache behavior.
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smooth_streaming", value)

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of key group IDs that CloudFront can use to validate signed URLs or signed cookies.
        See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        return pulumi.get(self, "trusted_key_groups")

    @trusted_key_groups.setter
    def trusted_key_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_key_groups", value)

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of AWS account IDs (or `self`) that you want to allow to create signed URLs for private content.
        See the [CloudFront User Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-trusted-signers.html) for more information about this feature.
        """
        return pulumi.get(self, "trusted_signers")

    @trusted_signers.setter
    def trusted_signers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_signers", value)


@pulumi.input_type
class DistributionOrderedCacheBehaviorForwardedValuesArgs:
    def __init__(__self__, *,
                 cookies: pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs'],
                 query_string: pulumi.Input[bool],
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_cache_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs'] cookies: The forwarded values cookies
               that specifies how CloudFront handles cookies (maximum one).
        :param pulumi.Input[bool] query_string: Indicates whether you want CloudFront to forward
               query strings to the origin that is associated with this cache behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] headers: Specifies the Headers, if any, that you want
               CloudFront to vary upon for this cache behavior. Specify `*` to include all
               headers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_string_cache_keys: When specified, along with a value of
               `true` for `query_string`, all query strings are forwarded, however only the
               query string keys listed in this argument are cached. When omitted with a
               value of `true` for `query_string`, all query string keys are cached.
        """
        pulumi.set(__self__, "cookies", cookies)
        pulumi.set(__self__, "query_string", query_string)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter
    def cookies(self) -> pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs']:
        """
        The forwarded values cookies
        that specifies how CloudFront handles cookies (maximum one).
        """
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: pulumi.Input['DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs']):
        pulumi.set(self, "cookies", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[bool]:
        """
        Indicates whether you want CloudFront to forward
        query strings to the origin that is associated with this cache behavior.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[bool]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the Headers, if any, that you want
        CloudFront to vary upon for this cache behavior. Specify `*` to include all
        headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When specified, along with a value of
        `true` for `query_string`, all query strings are forwarded, however only the
        query string keys listed in this argument are cached. When omitted with a
        value of `true` for `query_string`, all query string keys are cached.
        """
        return pulumi.get(self, "query_string_cache_keys")

    @query_string_cache_keys.setter
    def query_string_cache_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_cache_keys", value)


@pulumi.input_type
class DistributionOrderedCacheBehaviorForwardedValuesCookiesArgs:
    def __init__(__self__, *,
                 forward: pulumi.Input[str],
                 whitelisted_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] forward: Specifies whether you want CloudFront to forward
               cookies to the origin that is associated with this cache behavior. You can
               specify `all`, `none` or `whitelist`. If `whitelist`, you must include the
               subsequent `whitelisted_names`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelisted_names: If you have specified `whitelist` to
               `forward`, the whitelisted cookies that you want CloudFront to forward to
               your origin.
        """
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> pulumi.Input[str]:
        """
        Specifies whether you want CloudFront to forward
        cookies to the origin that is associated with this cache behavior. You can
        specify `all`, `none` or `whitelist`. If `whitelist`, you must include the
        subsequent `whitelisted_names`
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: pulumi.Input[str]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If you have specified `whitelist` to
        `forward`, the whitelisted cookies that you want CloudFront to forward to
        your origin.
        """
        return pulumi.get(self, "whitelisted_names")

    @whitelisted_names.setter
    def whitelisted_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelisted_names", value)


@pulumi.input_type
class DistributionOrderedCacheBehaviorFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[str],
                 function_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] event_type: The specific event to trigger this function.
               Valid values: `viewer-request` or `viewer-response`
        :param pulumi.Input[str] function_arn: ARN of the Cloudfront function.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[str]:
        """
        The specific event to trigger this function.
        Valid values: `viewer-request` or `viewer-response`
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Cloudfront function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)


@pulumi.input_type
class DistributionOrderedCacheBehaviorLambdaFunctionAssociationArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[str],
                 lambda_arn: pulumi.Input[str],
                 include_body: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] event_type: The specific event to trigger this function.
               Valid values: `viewer-request` or `viewer-response`
        :param pulumi.Input[str] lambda_arn: ARN of the Lambda function.
        :param pulumi.Input[bool] include_body: When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[str]:
        """
        The specific event to trigger this function.
        Valid values: `viewer-request` or `viewer-response`
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Lambda function.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_arn", value)

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true it exposes the request body to the lambda function. Defaults to false. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "include_body")

    @include_body.setter
    def include_body(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_body", value)


@pulumi.input_type
class DistributionOriginArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 origin_id: pulumi.Input[str],
                 connection_attempts: Optional[pulumi.Input[int]] = None,
                 connection_timeout: Optional[pulumi.Input[int]] = None,
                 custom_headers: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]] = None,
                 custom_origin_config: Optional[pulumi.Input['DistributionOriginCustomOriginConfigArgs']] = None,
                 origin_path: Optional[pulumi.Input[str]] = None,
                 origin_shield: Optional[pulumi.Input['DistributionOriginOriginShieldArgs']] = None,
                 s3_origin_config: Optional[pulumi.Input['DistributionOriginS3OriginConfigArgs']] = None):
        """
        :param pulumi.Input[str] domain_name: The DNS domain name of either the S3 bucket, or
               web site of your custom origin.
        :param pulumi.Input[str] origin_id: The unique identifier of the member origin
        :param pulumi.Input[int] connection_attempts: The number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
        :param pulumi.Input[int] connection_timeout: The number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]] custom_headers: One or more sub-resources with `name` and
               `value` parameters that specify header data that will be sent to the origin
               (multiples allowed).
        :param pulumi.Input['DistributionOriginCustomOriginConfigArgs'] custom_origin_config: The CloudFront custom
               origin configuration information. If an S3
               origin is required, use `s3_origin_config` instead.
        :param pulumi.Input[str] origin_path: An optional element that causes CloudFront to
               request your content from a directory in your Amazon S3 bucket or your
               custom origin.
        :param pulumi.Input['DistributionOriginOriginShieldArgs'] origin_shield: The CloudFront Origin Shield
               configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
        :param pulumi.Input['DistributionOriginS3OriginConfigArgs'] s3_origin_config: The CloudFront S3 origin
               configuration information. If a custom origin is required, use
               `custom_origin_config` instead.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "origin_id", origin_id)
        if connection_attempts is not None:
            pulumi.set(__self__, "connection_attempts", connection_attempts)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_origin_config is not None:
            pulumi.set(__self__, "custom_origin_config", custom_origin_config)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origin_shield is not None:
            pulumi.set(__self__, "origin_shield", origin_shield)
        if s3_origin_config is not None:
            pulumi.set(__self__, "s3_origin_config", s3_origin_config)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The DNS domain name of either the S3 bucket, or
        web site of your custom origin.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the member origin
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_id", value)

    @property
    @pulumi.getter(name="connectionAttempts")
    def connection_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times that CloudFront attempts to connect to the origin. Must be between 1-3. Defaults to 3.
        """
        return pulumi.get(self, "connection_attempts")

    @connection_attempts.setter
    def connection_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_attempts", value)

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds that CloudFront waits when trying to establish a connection to the origin. Must be between 1-10. Defaults to 10.
        """
        return pulumi.get(self, "connection_timeout")

    @connection_timeout.setter
    def connection_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_timeout", value)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]]:
        """
        One or more sub-resources with `name` and
        `value` parameters that specify header data that will be sent to the origin
        (multiples allowed).
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginCustomHeaderArgs']]]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter(name="customOriginConfig")
    def custom_origin_config(self) -> Optional[pulumi.Input['DistributionOriginCustomOriginConfigArgs']]:
        """
        The CloudFront custom
        origin configuration information. If an S3
        origin is required, use `s3_origin_config` instead.
        """
        return pulumi.get(self, "custom_origin_config")

    @custom_origin_config.setter
    def custom_origin_config(self, value: Optional[pulumi.Input['DistributionOriginCustomOriginConfigArgs']]):
        pulumi.set(self, "custom_origin_config", value)

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[pulumi.Input[str]]:
        """
        An optional element that causes CloudFront to
        request your content from a directory in your Amazon S3 bucket or your
        custom origin.
        """
        return pulumi.get(self, "origin_path")

    @origin_path.setter
    def origin_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_path", value)

    @property
    @pulumi.getter(name="originShield")
    def origin_shield(self) -> Optional[pulumi.Input['DistributionOriginOriginShieldArgs']]:
        """
        The CloudFront Origin Shield
        configuration information. Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the Amazon CloudFront Developer Guide.
        """
        return pulumi.get(self, "origin_shield")

    @origin_shield.setter
    def origin_shield(self, value: Optional[pulumi.Input['DistributionOriginOriginShieldArgs']]):
        pulumi.set(self, "origin_shield", value)

    @property
    @pulumi.getter(name="s3OriginConfig")
    def s3_origin_config(self) -> Optional[pulumi.Input['DistributionOriginS3OriginConfigArgs']]:
        """
        The CloudFront S3 origin
        configuration information. If a custom origin is required, use
        `custom_origin_config` instead.
        """
        return pulumi.get(self, "s3_origin_config")

    @s3_origin_config.setter
    def s3_origin_config(self, value: Optional[pulumi.Input['DistributionOriginS3OriginConfigArgs']]):
        pulumi.set(self, "s3_origin_config", value)


@pulumi.input_type
class DistributionOriginCustomHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DistributionOriginCustomOriginConfigArgs:
    def __init__(__self__, *,
                 http_port: pulumi.Input[int],
                 https_port: pulumi.Input[int],
                 origin_protocol_policy: pulumi.Input[str],
                 origin_ssl_protocols: pulumi.Input[Sequence[pulumi.Input[str]]],
                 origin_keepalive_timeout: Optional[pulumi.Input[int]] = None,
                 origin_read_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] http_port: The HTTP port the custom origin listens on.
        :param pulumi.Input[int] https_port: The HTTPS port the custom origin listens on.
        :param pulumi.Input[str] origin_protocol_policy: The origin protocol policy to apply to
               your origin. One of `http-only`, `https-only`, or `match-viewer`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] origin_ssl_protocols: The SSL/TLS protocols that you want
               CloudFront to use when communicating with your origin over HTTPS. A list of
               one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
        :param pulumi.Input[int] origin_keepalive_timeout: The Custom KeepAlive timeout, in seconds. By default, AWS enforces a limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout).
        :param pulumi.Input[int] origin_read_timeout: The Custom Read timeout, in seconds. By default, AWS enforces a limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout).
        """
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "https_port", https_port)
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> pulumi.Input[int]:
        """
        The HTTP port the custom origin listens on.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> pulumi.Input[int]:
        """
        The HTTPS port the custom origin listens on.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> pulumi.Input[str]:
        """
        The origin protocol policy to apply to
        your origin. One of `http-only`, `https-only`, or `match-viewer`.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @origin_protocol_policy.setter
    def origin_protocol_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_protocol_policy", value)

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The SSL/TLS protocols that you want
        CloudFront to use when communicating with your origin over HTTPS. A list of
        one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
        """
        return pulumi.get(self, "origin_ssl_protocols")

    @origin_ssl_protocols.setter
    def origin_ssl_protocols(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "origin_ssl_protocols", value)

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The Custom KeepAlive timeout, in seconds. By default, AWS enforces a limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout).
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @origin_keepalive_timeout.setter
    def origin_keepalive_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "origin_keepalive_timeout", value)

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The Custom Read timeout, in seconds. By default, AWS enforces a limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout).
        """
        return pulumi.get(self, "origin_read_timeout")

    @origin_read_timeout.setter
    def origin_read_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "origin_read_timeout", value)


@pulumi.input_type
class DistributionOriginGroupArgs:
    def __init__(__self__, *,
                 failover_criteria: pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs'],
                 members: pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]],
                 origin_id: pulumi.Input[str]):
        """
        :param pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs'] failover_criteria: The failover criteria for when to failover to the secondary origin
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]] members: Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
        :param pulumi.Input[str] origin_id: The unique identifier of the member origin
        """
        pulumi.set(__self__, "failover_criteria", failover_criteria)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="failoverCriteria")
    def failover_criteria(self) -> pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs']:
        """
        The failover criteria for when to failover to the secondary origin
        """
        return pulumi.get(self, "failover_criteria")

    @failover_criteria.setter
    def failover_criteria(self, value: pulumi.Input['DistributionOriginGroupFailoverCriteriaArgs']):
        pulumi.set(self, "failover_criteria", value)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]]:
        """
        Ordered member configuration blocks assigned to the origin group, where the first member is the primary origin. You must specify two members.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupMemberArgs']]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the member origin
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_id", value)


@pulumi.input_type
class DistributionOriginGroupFailoverCriteriaArgs:
    def __init__(__self__, *,
                 status_codes: pulumi.Input[Sequence[pulumi.Input[int]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] status_codes: A list of HTTP status codes for the origin group
        """
        pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        A list of HTTP status codes for the origin group
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "status_codes", value)


@pulumi.input_type
class DistributionOriginGroupMemberArgs:
    def __init__(__self__, *,
                 origin_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] origin_id: The unique identifier of the member origin
        """
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the member origin
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_id", value)


@pulumi.input_type
class DistributionOriginOriginShieldArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 origin_shield_region: pulumi.Input[str]):
        """
        :param pulumi.Input[bool] enabled: A flag that specifies whether Origin Shield is enabled.
        :param pulumi.Input[str] origin_shield_region: The AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as us-east-2.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "origin_shield_region", origin_shield_region)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        A flag that specifies whether Origin Shield is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="originShieldRegion")
    def origin_shield_region(self) -> pulumi.Input[str]:
        """
        The AWS Region for Origin Shield. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as us-east-2.
        """
        return pulumi.get(self, "origin_shield_region")

    @origin_shield_region.setter
    def origin_shield_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_shield_region", value)


@pulumi.input_type
class DistributionOriginS3OriginConfigArgs:
    def __init__(__self__, *,
                 origin_access_identity: pulumi.Input[str]):
        """
        :param pulumi.Input[str] origin_access_identity: The [CloudFront origin access
               identity][5] to associate with the origin.
        """
        pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> pulumi.Input[str]:
        """
        The [CloudFront origin access
        identity][5] to associate with the origin.
        """
        return pulumi.get(self, "origin_access_identity")

    @origin_access_identity.setter
    def origin_access_identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_access_identity", value)


@pulumi.input_type
class DistributionRestrictionsArgs:
    def __init__(__self__, *,
                 geo_restriction: pulumi.Input['DistributionRestrictionsGeoRestrictionArgs']):
        pulumi.set(__self__, "geo_restriction", geo_restriction)

    @property
    @pulumi.getter(name="geoRestriction")
    def geo_restriction(self) -> pulumi.Input['DistributionRestrictionsGeoRestrictionArgs']:
        return pulumi.get(self, "geo_restriction")

    @geo_restriction.setter
    def geo_restriction(self, value: pulumi.Input['DistributionRestrictionsGeoRestrictionArgs']):
        pulumi.set(self, "geo_restriction", value)


@pulumi.input_type
class DistributionRestrictionsGeoRestrictionArgs:
    def __init__(__self__, *,
                 restriction_type: pulumi.Input[str],
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] restriction_type: The method that you want to use to restrict
               distribution of your content by country: `none`, `whitelist`, or
               `blacklist`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: The [ISO 3166-1-alpha-2 codes][4] for which you
               want CloudFront either to distribute your content (`whitelist`) or not
               distribute your content (`blacklist`).
        """
        pulumi.set(__self__, "restriction_type", restriction_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> pulumi.Input[str]:
        """
        The method that you want to use to restrict
        distribution of your content by country: `none`, `whitelist`, or
        `blacklist`.
        """
        return pulumi.get(self, "restriction_type")

    @restriction_type.setter
    def restriction_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "restriction_type", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [ISO 3166-1-alpha-2 codes][4] for which you
        want CloudFront either to distribute your content (`whitelist`) or not
        distribute your content (`blacklist`).
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)


@pulumi.input_type
class DistributionTrustedKeyGroupArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupItemArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: A flag that specifies whether Origin Shield is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupItemArgs']]] items: List of nested attributes for each trusted signer
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag that specifies whether Origin Shield is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupItemArgs']]]]:
        """
        List of nested attributes for each trusted signer
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class DistributionTrustedKeyGroupItemArgs:
    def __init__(__self__, *,
                 key_group_id: Optional[pulumi.Input[str]] = None,
                 key_pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] key_group_id: The ID of the key group that contains the public keys
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_pair_ids: Set of active CloudFront key pairs associated with the signer account
        """
        if key_group_id is not None:
            pulumi.set(__self__, "key_group_id", key_group_id)
        if key_pair_ids is not None:
            pulumi.set(__self__, "key_pair_ids", key_pair_ids)

    @property
    @pulumi.getter(name="keyGroupId")
    def key_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the key group that contains the public keys
        """
        return pulumi.get(self, "key_group_id")

    @key_group_id.setter
    def key_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_group_id", value)

    @property
    @pulumi.getter(name="keyPairIds")
    def key_pair_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of active CloudFront key pairs associated with the signer account
        """
        return pulumi.get(self, "key_pair_ids")

    @key_pair_ids.setter
    def key_pair_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_pair_ids", value)


@pulumi.input_type
class DistributionTrustedSignerArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerItemArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: A flag that specifies whether Origin Shield is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerItemArgs']]] items: List of nested attributes for each trusted signer
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag that specifies whether Origin Shield is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerItemArgs']]]]:
        """
        List of nested attributes for each trusted signer
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class DistributionTrustedSignerItemArgs:
    def __init__(__self__, *,
                 aws_account_number: Optional[pulumi.Input[str]] = None,
                 key_pair_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] aws_account_number: AWS account ID or `self`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_pair_ids: Set of active CloudFront key pairs associated with the signer account
        """
        if aws_account_number is not None:
            pulumi.set(__self__, "aws_account_number", aws_account_number)
        if key_pair_ids is not None:
            pulumi.set(__self__, "key_pair_ids", key_pair_ids)

    @property
    @pulumi.getter(name="awsAccountNumber")
    def aws_account_number(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID or `self`
        """
        return pulumi.get(self, "aws_account_number")

    @aws_account_number.setter
    def aws_account_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_number", value)

    @property
    @pulumi.getter(name="keyPairIds")
    def key_pair_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of active CloudFront key pairs associated with the signer account
        """
        return pulumi.get(self, "key_pair_ids")

    @key_pair_ids.setter
    def key_pair_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_pair_ids", value)


@pulumi.input_type
class DistributionViewerCertificateArgs:
    def __init__(__self__, *,
                 acm_certificate_arn: Optional[pulumi.Input[str]] = None,
                 cloudfront_default_certificate: Optional[pulumi.Input[bool]] = None,
                 iam_certificate_id: Optional[pulumi.Input[str]] = None,
                 minimum_protocol_version: Optional[pulumi.Input[str]] = None,
                 ssl_support_method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] acm_certificate_arn: The ARN of the [AWS Certificate Manager](https://aws.amazon.com/certificate-manager/)
               certificate that you wish to use with this distribution. Specify this,
               `cloudfront_default_certificate`, or `iam_certificate_id`.  The ACM
               certificate must be in  US-EAST-1.
        :param pulumi.Input[bool] cloudfront_default_certificate: `true` if you want viewers to use HTTPS
               to request your objects and you're using the CloudFront domain name for your
               distribution. Specify this, `acm_certificate_arn`, or `iam_certificate_id`.
        :param pulumi.Input[str] iam_certificate_id: The IAM certificate identifier of the custom viewer
               certificate for this distribution if you are using a custom domain. Specify
               this, `acm_certificate_arn`, or `cloudfront_default_certificate`.
        :param pulumi.Input[str] minimum_protocol_version: The minimum version of the SSL protocol that
               you want CloudFront to use for HTTPS connections. Can only be set if
               `cloudfront_default_certificate = false`. See all possible values in
               [this](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html)
               table under "Security policy." Some examples include: `TLSv1.2_2019` and
               `TLSv1.2_2021`. Default: `TLSv1`. **NOTE**:
               If you are using a custom certificate (specified with `acm_certificate_arn`
               or `iam_certificate_id`), and have specified `sni-only` in
               `ssl_support_method`, `TLSv1` or later must be specified. If you have
               specified `vip` in `ssl_support_method`, only `SSLv3` or `TLSv1` can be
               specified. If you have specified `cloudfront_default_certificate`, `TLSv1`
               must be specified.
        """
        if acm_certificate_arn is not None:
            pulumi.set(__self__, "acm_certificate_arn", acm_certificate_arn)
        if cloudfront_default_certificate is not None:
            pulumi.set(__self__, "cloudfront_default_certificate", cloudfront_default_certificate)
        if iam_certificate_id is not None:
            pulumi.set(__self__, "iam_certificate_id", iam_certificate_id)
        if minimum_protocol_version is not None:
            pulumi.set(__self__, "minimum_protocol_version", minimum_protocol_version)
        if ssl_support_method is not None:
            pulumi.set(__self__, "ssl_support_method", ssl_support_method)

    @property
    @pulumi.getter(name="acmCertificateArn")
    def acm_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the [AWS Certificate Manager](https://aws.amazon.com/certificate-manager/)
        certificate that you wish to use with this distribution. Specify this,
        `cloudfront_default_certificate`, or `iam_certificate_id`.  The ACM
        certificate must be in  US-EAST-1.
        """
        return pulumi.get(self, "acm_certificate_arn")

    @acm_certificate_arn.setter
    def acm_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acm_certificate_arn", value)

    @property
    @pulumi.getter(name="cloudfrontDefaultCertificate")
    def cloudfront_default_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        `true` if you want viewers to use HTTPS
        to request your objects and you're using the CloudFront domain name for your
        distribution. Specify this, `acm_certificate_arn`, or `iam_certificate_id`.
        """
        return pulumi.get(self, "cloudfront_default_certificate")

    @cloudfront_default_certificate.setter
    def cloudfront_default_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloudfront_default_certificate", value)

    @property
    @pulumi.getter(name="iamCertificateId")
    def iam_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM certificate identifier of the custom viewer
        certificate for this distribution if you are using a custom domain. Specify
        this, `acm_certificate_arn`, or `cloudfront_default_certificate`.
        """
        return pulumi.get(self, "iam_certificate_id")

    @iam_certificate_id.setter
    def iam_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_certificate_id", value)

    @property
    @pulumi.getter(name="minimumProtocolVersion")
    def minimum_protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum version of the SSL protocol that
        you want CloudFront to use for HTTPS connections. Can only be set if
        `cloudfront_default_certificate = false`. See all possible values in
        [this](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html)
        table under "Security policy." Some examples include: `TLSv1.2_2019` and
        `TLSv1.2_2021`. Default: `TLSv1`. **NOTE**:
        If you are using a custom certificate (specified with `acm_certificate_arn`
        or `iam_certificate_id`), and have specified `sni-only` in
        `ssl_support_method`, `TLSv1` or later must be specified. If you have
        specified `vip` in `ssl_support_method`, only `SSLv3` or `TLSv1` can be
        specified. If you have specified `cloudfront_default_certificate`, `TLSv1`
        must be specified.
        """
        return pulumi.get(self, "minimum_protocol_version")

    @minimum_protocol_version.setter
    def minimum_protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimum_protocol_version", value)

    @property
    @pulumi.getter(name="sslSupportMethod")
    def ssl_support_method(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssl_support_method")

    @ssl_support_method.setter
    def ssl_support_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_support_method", value)


@pulumi.input_type
class MonitoringSubscriptionMonitoringSubscriptionArgs:
    def __init__(__self__, *,
                 realtime_metrics_subscription_config: pulumi.Input['MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']):
        """
        :param pulumi.Input['MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs'] realtime_metrics_subscription_config: A subscription configuration for additional CloudWatch metrics. See below.
        """
        pulumi.set(__self__, "realtime_metrics_subscription_config", realtime_metrics_subscription_config)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionConfig")
    def realtime_metrics_subscription_config(self) -> pulumi.Input['MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']:
        """
        A subscription configuration for additional CloudWatch metrics. See below.
        """
        return pulumi.get(self, "realtime_metrics_subscription_config")

    @realtime_metrics_subscription_config.setter
    def realtime_metrics_subscription_config(self, value: pulumi.Input['MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs']):
        pulumi.set(self, "realtime_metrics_subscription_config", value)


@pulumi.input_type
class MonitoringSubscriptionMonitoringSubscriptionRealtimeMetricsSubscriptionConfigArgs:
    def __init__(__self__, *,
                 realtime_metrics_subscription_status: pulumi.Input[str]):
        """
        :param pulumi.Input[str] realtime_metrics_subscription_status: A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. Valid values are `Enabled` and `Disabled`. See below.
        """
        pulumi.set(__self__, "realtime_metrics_subscription_status", realtime_metrics_subscription_status)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionStatus")
    def realtime_metrics_subscription_status(self) -> pulumi.Input[str]:
        """
        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution. Valid values are `Enabled` and `Disabled`. See below.
        """
        return pulumi.get(self, "realtime_metrics_subscription_status")

    @realtime_metrics_subscription_status.setter
    def realtime_metrics_subscription_status(self, value: pulumi.Input[str]):
        pulumi.set(self, "realtime_metrics_subscription_status", value)


@pulumi.input_type
class OriginRequestPolicyCookiesConfigArgs:
    def __init__(__self__, *,
                 cookie_behavior: pulumi.Input[str],
                 cookies: Optional[pulumi.Input['OriginRequestPolicyCookiesConfigCookiesArgs']] = None):
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cookie_behavior")

    @cookie_behavior.setter
    def cookie_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "cookie_behavior", value)

    @property
    @pulumi.getter
    def cookies(self) -> Optional[pulumi.Input['OriginRequestPolicyCookiesConfigCookiesArgs']]:
        return pulumi.get(self, "cookies")

    @cookies.setter
    def cookies(self, value: Optional[pulumi.Input['OriginRequestPolicyCookiesConfigCookiesArgs']]):
        pulumi.set(self, "cookies", value)


@pulumi.input_type
class OriginRequestPolicyCookiesConfigCookiesArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class OriginRequestPolicyHeadersConfigArgs:
    def __init__(__self__, *,
                 header_behavior: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input['OriginRequestPolicyHeadersConfigHeadersArgs']] = None):
        if header_behavior is not None:
            pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "header_behavior")

    @header_behavior.setter
    def header_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_behavior", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input['OriginRequestPolicyHeadersConfigHeadersArgs']]:
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input['OriginRequestPolicyHeadersConfigHeadersArgs']]):
        pulumi.set(self, "headers", value)


@pulumi.input_type
class OriginRequestPolicyHeadersConfigHeadersArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class OriginRequestPolicyQueryStringsConfigArgs:
    def __init__(__self__, *,
                 query_string_behavior: pulumi.Input[str],
                 query_strings: Optional[pulumi.Input['OriginRequestPolicyQueryStringsConfigQueryStringsArgs']] = None):
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> pulumi.Input[str]:
        return pulumi.get(self, "query_string_behavior")

    @query_string_behavior.setter
    def query_string_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_string_behavior", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input['OriginRequestPolicyQueryStringsConfigQueryStringsArgs']]:
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input['OriginRequestPolicyQueryStringsConfigQueryStringsArgs']]):
        pulumi.set(self, "query_strings", value)


@pulumi.input_type
class OriginRequestPolicyQueryStringsConfigQueryStringsArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class RealtimeLogConfigEndpointArgs:
    def __init__(__self__, *,
                 kinesis_stream_config: pulumi.Input['RealtimeLogConfigEndpointKinesisStreamConfigArgs'],
                 stream_type: pulumi.Input[str]):
        """
        :param pulumi.Input['RealtimeLogConfigEndpointKinesisStreamConfigArgs'] kinesis_stream_config: The Amazon Kinesis data stream configuration.
        :param pulumi.Input[str] stream_type: The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
        """
        pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        pulumi.set(__self__, "stream_type", stream_type)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> pulumi.Input['RealtimeLogConfigEndpointKinesisStreamConfigArgs']:
        """
        The Amazon Kinesis data stream configuration.
        """
        return pulumi.get(self, "kinesis_stream_config")

    @kinesis_stream_config.setter
    def kinesis_stream_config(self, value: pulumi.Input['RealtimeLogConfigEndpointKinesisStreamConfigArgs']):
        pulumi.set(self, "kinesis_stream_config", value)

    @property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> pulumi.Input[str]:
        """
        The type of data stream where real-time log data is sent. The only valid value is `Kinesis`.
        """
        return pulumi.get(self, "stream_type")

    @stream_type.setter
    def stream_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_type", value)


@pulumi.input_type
class RealtimeLogConfigEndpointKinesisStreamConfigArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 stream_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] role_arn: The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
               See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
        :param pulumi.Input[str] stream_arn: The ARN of the Kinesis data stream.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of an IAM role that CloudFront can use to send real-time log data to the Kinesis data stream.
        See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) for more information.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")

    @stream_arn.setter
    def stream_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_arn", value)


