# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GroupInitialLifecycleHook',
    'GroupInstanceRefresh',
    'GroupInstanceRefreshPreferences',
    'GroupLaunchTemplate',
    'GroupMixedInstancesPolicy',
    'GroupMixedInstancesPolicyInstancesDistribution',
    'GroupMixedInstancesPolicyLaunchTemplate',
    'GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification',
    'GroupMixedInstancesPolicyLaunchTemplateOverride',
    'GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification',
    'GroupTag',
    'GroupWarmPool',
    'PolicyPredictiveScalingConfiguration',
    'PolicyPredictiveScalingConfigurationMetricSpecification',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification',
    'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification',
    'PolicyStepAdjustment',
    'PolicyTargetTrackingConfiguration',
    'PolicyTargetTrackingConfigurationCustomizedMetricSpecification',
    'PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension',
    'PolicyTargetTrackingConfigurationPredefinedMetricSpecification',
    'GetAmiIdsFilterResult',
    'GetGroupLaunchTemplateResult',
]

@pulumi.output_type
class GroupInitialLifecycleHook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifecycleTransition":
            suggest = "lifecycle_transition"
        elif key == "defaultResult":
            suggest = "default_result"
        elif key == "heartbeatTimeout":
            suggest = "heartbeat_timeout"
        elif key == "notificationMetadata":
            suggest = "notification_metadata"
        elif key == "notificationTargetArn":
            suggest = "notification_target_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupInitialLifecycleHook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupInitialLifecycleHook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupInitialLifecycleHook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycle_transition: str,
                 name: str,
                 default_result: Optional[str] = None,
                 heartbeat_timeout: Optional[int] = None,
                 notification_metadata: Optional[str] = None,
                 notification_target_arn: Optional[str] = None,
                 role_arn: Optional[str] = None):
        """
        :param str name: The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        pulumi.set(__self__, "name", name)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if notification_target_arn is not None:
            pulumi.set(__self__, "notification_target_arn", notification_target_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> str:
        return pulumi.get(self, "lifecycle_transition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[str]:
        return pulumi.get(self, "default_result")

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[int]:
        return pulumi.get(self, "heartbeat_timeout")

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[str]:
        return pulumi.get(self, "notification_metadata")

    @property
    @pulumi.getter(name="notificationTargetArn")
    def notification_target_arn(self) -> Optional[str]:
        return pulumi.get(self, "notification_target_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class GroupInstanceRefresh(dict):
    def __init__(__self__, *,
                 strategy: str,
                 preferences: Optional['outputs.GroupInstanceRefreshPreferences'] = None,
                 triggers: Optional[Sequence[str]] = None):
        """
        :param str strategy: The strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
        :param 'GroupInstanceRefreshPreferencesArgs' preferences: Override default parameters for Instance Refresh.
        :param Sequence[str] triggers: Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
        """
        pulumi.set(__self__, "strategy", strategy)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        The strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def preferences(self) -> Optional['outputs.GroupInstanceRefreshPreferences']:
        """
        Override default parameters for Instance Refresh.
        """
        return pulumi.get(self, "preferences")

    @property
    @pulumi.getter
    def triggers(self) -> Optional[Sequence[str]]:
        """
        Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
        """
        return pulumi.get(self, "triggers")


@pulumi.output_type
class GroupInstanceRefreshPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceWarmup":
            suggest = "instance_warmup"
        elif key == "minHealthyPercentage":
            suggest = "min_healthy_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupInstanceRefreshPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupInstanceRefreshPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupInstanceRefreshPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_warmup: Optional[str] = None,
                 min_healthy_percentage: Optional[int] = None):
        """
        :param str instance_warmup: The number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
        :param int min_healthy_percentage: The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group. Defaults to `90`.
        """
        if instance_warmup is not None:
            pulumi.set(__self__, "instance_warmup", instance_warmup)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)

    @property
    @pulumi.getter(name="instanceWarmup")
    def instance_warmup(self) -> Optional[str]:
        """
        The number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
        """
        return pulumi.get(self, "instance_warmup")

    @property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[int]:
        """
        The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group. Defaults to `90`.
        """
        return pulumi.get(self, "min_healthy_percentage")


@pulumi.output_type
class GroupLaunchTemplate(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str id: The ID of the launch template. Conflicts with `name`.
        :param str name: The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        :param str version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the launch template. Conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Auto Scaling Group. By default generated by this provider. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GroupMixedInstancesPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplate":
            suggest = "launch_template"
        elif key == "instancesDistribution":
            suggest = "instances_distribution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template: 'outputs.GroupMixedInstancesPolicyLaunchTemplate',
                 instances_distribution: Optional['outputs.GroupMixedInstancesPolicyInstancesDistribution'] = None):
        """
        :param 'GroupMixedInstancesPolicyLaunchTemplateArgs' launch_template: Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
        :param 'GroupMixedInstancesPolicyInstancesDistributionArgs' instances_distribution: Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
        """
        pulumi.set(__self__, "launch_template", launch_template)
        if instances_distribution is not None:
            pulumi.set(__self__, "instances_distribution", instances_distribution)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> 'outputs.GroupMixedInstancesPolicyLaunchTemplate':
        """
        Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="instancesDistribution")
    def instances_distribution(self) -> Optional['outputs.GroupMixedInstancesPolicyInstancesDistribution']:
        """
        Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
        """
        return pulumi.get(self, "instances_distribution")


@pulumi.output_type
class GroupMixedInstancesPolicyInstancesDistribution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandAllocationStrategy":
            suggest = "on_demand_allocation_strategy"
        elif key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "spotAllocationStrategy":
            suggest = "spot_allocation_strategy"
        elif key == "spotInstancePools":
            suggest = "spot_instance_pools"
        elif key == "spotMaxPrice":
            suggest = "spot_max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicyInstancesDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicyInstancesDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicyInstancesDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_allocation_strategy: Optional[str] = None,
                 on_demand_base_capacity: Optional[int] = None,
                 on_demand_percentage_above_base_capacity: Optional[int] = None,
                 spot_allocation_strategy: Optional[str] = None,
                 spot_instance_pools: Optional[int] = None,
                 spot_max_price: Optional[str] = None):
        """
        :param str on_demand_allocation_strategy: Strategy to use when launching on-demand instances. Valid values: `prioritized`. Default: `prioritized`.
        :param int on_demand_base_capacity: Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
        :param int on_demand_percentage_above_base_capacity: Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
        :param str spot_allocation_strategy: How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`. Default: `lowest-price`.
        :param int spot_instance_pools: Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Default: `2`.
        :param str spot_max_price: Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
        """
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[str]:
        """
        Strategy to use when launching on-demand instances. Valid values: `prioritized`. Default: `prioritized`.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[int]:
        """
        Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[int]:
        """
        Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[str]:
        """
        How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`. Default: `lowest-price`.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[int]:
        """
        Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Default: `2`.
        """
        return pulumi.get(self, "spot_instance_pools")

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[str]:
        """
        Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
        """
        return pulumi.get(self, "spot_max_price")


@pulumi.output_type
class GroupMixedInstancesPolicyLaunchTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateSpecification":
            suggest = "launch_template_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicyLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicyLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicyLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_specification: 'outputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification',
                 overrides: Optional[Sequence['outputs.GroupMixedInstancesPolicyLaunchTemplateOverride']] = None):
        """
        :param 'GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs' launch_template_specification: Override the instance launch template specification in the Launch Template.
        :param Sequence['GroupMixedInstancesPolicyLaunchTemplateOverrideArgs'] overrides: List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
        """
        pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> 'outputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification':
        """
        Override the instance launch template specification in the Launch Template.
        """
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.GroupMixedInstancesPolicyLaunchTemplateOverride']]:
        """
        List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
        """
        return pulumi.get(self, "overrides")


@pulumi.output_type
class GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str launch_template_id: The ID of the launch template. Conflicts with `launch_template_name`.
        :param str launch_template_name: The name of the launch template. Conflicts with `launch_template_id`.
        :param str version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        The ID of the launch template. Conflicts with `launch_template_name`.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        """
        The name of the launch template. Conflicts with `launch_template_id`.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GroupMixedInstancesPolicyLaunchTemplateOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "launchTemplateSpecification":
            suggest = "launch_template_specification"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicyLaunchTemplateOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 launch_template_specification: Optional['outputs.GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification'] = None,
                 weighted_capacity: Optional[str] = None):
        """
        :param str instance_type: Override the instance type in the Launch Template.
        :param 'GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs' launch_template_specification: Override the instance launch template specification in the Launch Template.
        :param str weighted_capacity: The number of capacity units, which gives the instance type a proportional weight to other instance types.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if launch_template_specification is not None:
            pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Override the instance type in the Launch Template.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> Optional['outputs.GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification']:
        """
        Override the instance launch template specification in the Launch Template.
        """
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[str]:
        """
        The number of capacity units, which gives the instance type a proportional weight to other instance types.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str launch_template_id: The ID of the launch template. Conflicts with `launch_template_name`.
        :param str launch_template_name: The name of the launch template. Conflicts with `launch_template_id`.
        :param str version: Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        The ID of the launch template. Conflicts with `launch_template_name`.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        """
        The name of the launch template. Conflicts with `launch_template_id`.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GroupTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propagateAtLaunch":
            suggest = "propagate_at_launch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 propagate_at_launch: bool,
                 value: str):
        """
        :param str key: Key
        :param bool propagate_at_launch: Enables propagation of the tag to
               Amazon EC2 instances launched via this ASG
        :param str value: Value
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> bool:
        """
        Enables propagation of the tag to
        Amazon EC2 instances launched via this ASG
        """
        return pulumi.get(self, "propagate_at_launch")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GroupWarmPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxGroupPreparedCapacity":
            suggest = "max_group_prepared_capacity"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "poolState":
            suggest = "pool_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupWarmPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupWarmPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupWarmPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_group_prepared_capacity: Optional[int] = None,
                 min_size: Optional[int] = None,
                 pool_state: Optional[str] = None):
        """
        :param int max_group_prepared_capacity: Specifies the total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
        :param int min_size: Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
        :param str pool_state: Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default) or Running.
        """
        if max_group_prepared_capacity is not None:
            pulumi.set(__self__, "max_group_prepared_capacity", max_group_prepared_capacity)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if pool_state is not None:
            pulumi.set(__self__, "pool_state", pool_state)

    @property
    @pulumi.getter(name="maxGroupPreparedCapacity")
    def max_group_prepared_capacity(self) -> Optional[int]:
        """
        Specifies the total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
        """
        return pulumi.get(self, "max_group_prepared_capacity")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[int]:
        """
        Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="poolState")
    def pool_state(self) -> Optional[str]:
        """
        Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default) or Running.
        """
        return pulumi.get(self, "pool_state")


@pulumi.output_type
class PolicyPredictiveScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricSpecification":
            suggest = "metric_specification"
        elif key == "maxCapacityBreachBehavior":
            suggest = "max_capacity_breach_behavior"
        elif key == "maxCapacityBuffer":
            suggest = "max_capacity_buffer"
        elif key == "schedulingBufferTime":
            suggest = "scheduling_buffer_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPredictiveScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_specification: 'outputs.PolicyPredictiveScalingConfigurationMetricSpecification',
                 max_capacity_breach_behavior: Optional[str] = None,
                 max_capacity_buffer: Optional[str] = None,
                 mode: Optional[str] = None,
                 scheduling_buffer_time: Optional[str] = None):
        """
        :param 'PolicyPredictiveScalingConfigurationMetricSpecificationArgs' metric_specification: This structure includes the metrics and target utilization to use for predictive scaling.
        :param str max_capacity_breach_behavior: Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Valid values are `HonorMaxCapacity` or `IncreaseMaxCapacity`. Default is `HonorMaxCapacity`.
        :param str max_capacity_buffer: The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. Valid range is `0` to `100`. If set to `0`, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
        :param str mode: The predictive scaling mode. Valid values are `ForecastAndScale` and `ForecastOnly`. Default is `ForecastOnly`.
        :param str scheduling_buffer_time: The amount of time, in seconds, by which the instance launch time can be advanced. Minimum is `0`.
        """
        pulumi.set(__self__, "metric_specification", metric_specification)
        if max_capacity_breach_behavior is not None:
            pulumi.set(__self__, "max_capacity_breach_behavior", max_capacity_breach_behavior)
        if max_capacity_buffer is not None:
            pulumi.set(__self__, "max_capacity_buffer", max_capacity_buffer)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scheduling_buffer_time is not None:
            pulumi.set(__self__, "scheduling_buffer_time", scheduling_buffer_time)

    @property
    @pulumi.getter(name="metricSpecification")
    def metric_specification(self) -> 'outputs.PolicyPredictiveScalingConfigurationMetricSpecification':
        """
        This structure includes the metrics and target utilization to use for predictive scaling.
        """
        return pulumi.get(self, "metric_specification")

    @property
    @pulumi.getter(name="maxCapacityBreachBehavior")
    def max_capacity_breach_behavior(self) -> Optional[str]:
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Valid values are `HonorMaxCapacity` or `IncreaseMaxCapacity`. Default is `HonorMaxCapacity`.
        """
        return pulumi.get(self, "max_capacity_breach_behavior")

    @property
    @pulumi.getter(name="maxCapacityBuffer")
    def max_capacity_buffer(self) -> Optional[str]:
        """
        The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. Valid range is `0` to `100`. If set to `0`, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
        """
        return pulumi.get(self, "max_capacity_buffer")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The predictive scaling mode. Valid values are `ForecastAndScale` and `ForecastOnly`. Default is `ForecastOnly`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="schedulingBufferTime")
    def scheduling_buffer_time(self) -> Optional[str]:
        """
        The amount of time, in seconds, by which the instance launch time can be advanced. Minimum is `0`.
        """
        return pulumi.get(self, "scheduling_buffer_time")


@pulumi.output_type
class PolicyPredictiveScalingConfigurationMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "predefinedLoadMetricSpecification":
            suggest = "predefined_load_metric_specification"
        elif key == "predefinedMetricPairSpecification":
            suggest = "predefined_metric_pair_specification"
        elif key == "predefinedScalingMetricSpecification":
            suggest = "predefined_scaling_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPredictiveScalingConfigurationMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: int,
                 predefined_load_metric_specification: Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification'] = None,
                 predefined_metric_pair_specification: Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification'] = None,
                 predefined_scaling_metric_specification: Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification'] = None):
        """
        :param int target_value: The target value for the metric.
        :param 'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs' predefined_load_metric_specification: The load metric specification.
        :param 'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs' predefined_metric_pair_specification: The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        :param 'PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs' predefined_scaling_metric_specification: The scaling metric specification.
        """
        pulumi.set(__self__, "target_value", target_value)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predefined_metric_pair_specification is not None:
            pulumi.set(__self__, "predefined_metric_pair_specification", predefined_metric_pair_specification)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> int:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification']:
        """
        The load metric specification.
        """
        return pulumi.get(self, "predefined_load_metric_specification")

    @property
    @pulumi.getter(name="predefinedMetricPairSpecification")
    def predefined_metric_pair_specification(self) -> Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification']:
        """
        The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
        """
        return pulumi.get(self, "predefined_metric_pair_specification")

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional['outputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification']:
        """
        The scaling metric specification.
        """
        return pulumi.get(self, "predefined_scaling_metric_specification")


@pulumi.output_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: str):
        """
        :param str predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> str:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: str):
        """
        :param str predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> str:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: str):
        """
        :param str predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> str:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class PolicyStepAdjustment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scaling_adjustment: int,
                 metric_interval_lower_bound: Optional[str] = None,
                 metric_interval_upper_bound: Optional[str] = None):
        """
        :param int scaling_adjustment: The number of members by which to
               scale, when the adjustment bounds are breached. A positive value scales
               up. A negative value scales down.
        :param str metric_interval_lower_bound: The lower bound for the
               difference between the alarm threshold and the CloudWatch metric.
               Without a value, AWS will treat this bound as infinity.
        :param str metric_interval_upper_bound: The upper bound for the
               difference between the alarm threshold and the CloudWatch metric.
               Without a value, AWS will treat this bound as infinity. The upper bound
               must be greater than the lower bound.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> int:
        """
        The number of members by which to
        scale, when the adjustment bounds are breached. A positive value scales
        up. A negative value scales down.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[str]:
        """
        The lower bound for the
        difference between the alarm threshold and the CloudWatch metric.
        Without a value, AWS will treat this bound as infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[str]:
        """
        The upper bound for the
        difference between the alarm threshold and the CloudWatch metric.
        Without a value, AWS will treat this bound as infinity. The upper bound
        must be greater than the lower bound.
        """
        return pulumi.get(self, "metric_interval_upper_bound")


@pulumi.output_type
class PolicyTargetTrackingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedMetricSpecification":
            suggest = "customized_metric_specification"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "predefinedMetricSpecification":
            suggest = "predefined_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 customized_metric_specification: Optional['outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecification'] = None,
                 disable_scale_in: Optional[bool] = None,
                 predefined_metric_specification: Optional['outputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecification'] = None):
        """
        :param float target_value: The target value for the metric.
        :param 'PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs' customized_metric_specification: A customized metric. Conflicts with `predefined_metric_specification`.
        :param bool disable_scale_in: Indicates whether scale in by the target tracking policy is disabled.
        :param 'PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs' predefined_metric_specification: A predefined metric. Conflicts with `customized_metric_specification`.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        The target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional['outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecification']:
        """
        A customized metric. Conflicts with `predefined_metric_specification`.
        """
        return pulumi.get(self, "customized_metric_specification")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[bool]:
        """
        Indicates whether scale in by the target tracking policy is disabled.
        """
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional['outputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecification']:
        """
        A predefined metric. Conflicts with `customized_metric_specification`.
        """
        return pulumi.get(self, "predefined_metric_specification")


@pulumi.output_type
class PolicyTargetTrackingConfigurationCustomizedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricDimensions":
            suggest = "metric_dimensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyTargetTrackingConfigurationCustomizedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyTargetTrackingConfigurationCustomizedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyTargetTrackingConfigurationCustomizedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 statistic: str,
                 metric_dimensions: Optional[Sequence['outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension']] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_name: The name of the metric.
        :param str namespace: The namespace of the metric.
        :param str statistic: The statistic of the metric.
        :param Sequence['PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs'] metric_dimensions: The dimensions of the metric.
        :param str unit: The unit of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "statistic", statistic)
        if metric_dimensions is not None:
            pulumi.set(__self__, "metric_dimensions", metric_dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="metricDimensions")
    def metric_dimensions(self) -> Optional[Sequence['outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension']]:
        """
        The dimensions of the metric.
        """
        return pulumi.get(self, "metric_dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit of the metric.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the dimension.
        :param str value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PolicyTargetTrackingConfigurationPredefinedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyTargetTrackingConfigurationPredefinedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyTargetTrackingConfigurationPredefinedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyTargetTrackingConfigurationPredefinedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        :param str predefined_metric_type: Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        :param str resource_label: A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class GetAmiIdsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the filter. The valid values are: `auto-scaling-group`, `key`, `value`, and `propagate-at-launch`.
        :param Sequence[str] values: The value of the filter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the filter. The valid values are: `auto-scaling-group`, `key`, `value`, and `propagate-at-launch`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of the filter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetGroupLaunchTemplateResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 version: str):
        """
        :param str id: Name of the Auto Scaling Group.
        :param str name: Specify the exact name of the desired autoscaling group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Name of the Auto Scaling Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specify the exact name of the desired autoscaling group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


