# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseEncryptionConfiguration',
    'WorkgroupConfiguration',
    'WorkgroupConfigurationResultConfiguration',
    'WorkgroupConfigurationResultConfigurationEncryptionConfiguration',
]

@pulumi.output_type
class DatabaseEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_option: str,
                 kms_key: Optional[str] = None):
        """
        :param str encryption_option: The type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
        :param str kms_key: The KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
        """
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> str:
        """
        The type of key; one of `SSE_S3`, `SSE_KMS`, `CSE_KMS`
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        The KMS key ARN or ID; required for key types `SSE_KMS` and `CSE_KMS`.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class WorkgroupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesScannedCutoffPerQuery":
            suggest = "bytes_scanned_cutoff_per_query"
        elif key == "enforceWorkgroupConfiguration":
            suggest = "enforce_workgroup_configuration"
        elif key == "publishCloudwatchMetricsEnabled":
            suggest = "publish_cloudwatch_metrics_enabled"
        elif key == "resultConfiguration":
            suggest = "result_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bytes_scanned_cutoff_per_query: Optional[int] = None,
                 enforce_workgroup_configuration: Optional[bool] = None,
                 publish_cloudwatch_metrics_enabled: Optional[bool] = None,
                 result_configuration: Optional['outputs.WorkgroupConfigurationResultConfiguration'] = None):
        """
        :param int bytes_scanned_cutoff_per_query: Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
        :param bool enforce_workgroup_configuration: Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
        :param bool publish_cloudwatch_metrics_enabled: Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
        :param 'WorkgroupConfigurationResultConfigurationArgs' result_configuration: Configuration block with result settings. Documented below.
        """
        if bytes_scanned_cutoff_per_query is not None:
            pulumi.set(__self__, "bytes_scanned_cutoff_per_query", bytes_scanned_cutoff_per_query)
        if enforce_workgroup_configuration is not None:
            pulumi.set(__self__, "enforce_workgroup_configuration", enforce_workgroup_configuration)
        if publish_cloudwatch_metrics_enabled is not None:
            pulumi.set(__self__, "publish_cloudwatch_metrics_enabled", publish_cloudwatch_metrics_enabled)
        if result_configuration is not None:
            pulumi.set(__self__, "result_configuration", result_configuration)

    @property
    @pulumi.getter(name="bytesScannedCutoffPerQuery")
    def bytes_scanned_cutoff_per_query(self) -> Optional[int]:
        """
        Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
        """
        return pulumi.get(self, "bytes_scanned_cutoff_per_query")

    @property
    @pulumi.getter(name="enforceWorkgroupConfiguration")
    def enforce_workgroup_configuration(self) -> Optional[bool]:
        """
        Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
        """
        return pulumi.get(self, "enforce_workgroup_configuration")

    @property
    @pulumi.getter(name="publishCloudwatchMetricsEnabled")
    def publish_cloudwatch_metrics_enabled(self) -> Optional[bool]:
        """
        Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
        """
        return pulumi.get(self, "publish_cloudwatch_metrics_enabled")

    @property
    @pulumi.getter(name="resultConfiguration")
    def result_configuration(self) -> Optional['outputs.WorkgroupConfigurationResultConfiguration']:
        """
        Configuration block with result settings. Documented below.
        """
        return pulumi.get(self, "result_configuration")


@pulumi.output_type
class WorkgroupConfigurationResultConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "outputLocation":
            suggest = "output_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationResultConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationResultConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationResultConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_configuration: Optional['outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration'] = None,
                 output_location: Optional[str] = None):
        """
        :param 'WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs' encryption_configuration: Configuration block with encryption settings. Documented below.
        :param str output_location: The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
        """
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration']:
        """
        Configuration block with encryption settings. Documented below.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[str]:
        """
        The location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
        """
        return pulumi.get(self, "output_location")


@pulumi.output_type
class WorkgroupConfigurationResultConfigurationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkgroupConfigurationResultConfigurationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkgroupConfigurationResultConfigurationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkgroupConfigurationResultConfigurationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_option: Optional[str] = None,
                 kms_key_arn: Optional[str] = None):
        """
        :param str encryption_option: Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        :param str kms_key_arn: For `SSE_KMS` and `CSE_KMS`, this is the KMS key Amazon Resource Name (ARN).
        """
        if encryption_option is not None:
            pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> Optional[str]:
        """
        Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (`SSE_S3`), server-side encryption with KMS-managed keys (`SSE_KMS`), or client-side encryption with KMS-managed keys (`CSE_KMS`) is used. If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        For `SSE_KMS` and `CSE_KMS`, this is the KMS key Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "kms_key_arn")


