# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DataSourceDynamodbConfigArgs',
    'DataSourceElasticsearchConfigArgs',
    'DataSourceHttpConfigArgs',
    'DataSourceLambdaConfigArgs',
    'GraphQLApiAdditionalAuthenticationProviderArgs',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs',
    'GraphQLApiLogConfigArgs',
    'GraphQLApiOpenidConnectConfigArgs',
    'GraphQLApiUserPoolConfigArgs',
    'ResolverCachingConfigArgs',
    'ResolverPipelineConfigArgs',
]

@pulumi.input_type
class DataSourceDynamodbConfigArgs:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None,
                 use_caller_credentials: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] table_name: Name of the DynamoDB table.
        :param pulumi.Input[str] region: AWS region of Elasticsearch domain. Defaults to current region.
        :param pulumi.Input[bool] use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @use_caller_credentials.setter
    def use_caller_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_caller_credentials", value)


@pulumi.input_type
class DataSourceElasticsearchConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] endpoint: HTTP URL.
        :param pulumi.Input[str] region: AWS region of Elasticsearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class DataSourceHttpConfigArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str]):
        """
        :param pulumi.Input[str] endpoint: HTTP URL.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)


@pulumi.input_type
class DataSourceLambdaConfigArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] function_arn: The ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        The ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)


@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[str],
                 openid_connect_config: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']] = None):
        """
        :param pulumi.Input[str] authentication_type: The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
        :param pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs'] openid_connect_config: Nested argument containing OpenID Connect configuration. Defined below.
        :param pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs'] user_pool_config: The Amazon Cognito User Pool configuration. Defined below.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[str]:
        """
        The authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']]:
        """
        Nested argument containing OpenID Connect configuration. Defined below.
        """
        return pulumi.get(self, "openid_connect_config")

    @openid_connect_config.setter
    def openid_connect_config(self, value: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs']]):
        pulumi.set(self, "openid_connect_config", value)

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']]:
        """
        The Amazon Cognito User Pool configuration. Defined below.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)


@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[str],
                 auth_ttl: Optional[pulumi.Input[int]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 iat_ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param pulumi.Input[int] auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param pulumi.Input[str] client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param pulumi.Input[int] iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iat_ttl", value)


@pulumi.input_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[str],
                 app_id_client_regex: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] user_pool_id: The user pool ID.
        :param pulumi.Input[str] app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param pulumi.Input[str] aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)


@pulumi.input_type
class GraphQLApiLogConfigArgs:
    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: pulumi.Input[str],
                 field_log_level: pulumi.Input[str],
                 exclude_verbose_content: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param pulumi.Input[str] field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param pulumi.Input[bool] exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @cloudwatch_logs_role_arn.setter
    def cloudwatch_logs_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudwatch_logs_role_arn", value)

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> pulumi.Input[str]:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @field_log_level.setter
    def field_log_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_log_level", value)

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")

    @exclude_verbose_content.setter
    def exclude_verbose_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_verbose_content", value)


@pulumi.input_type
class GraphQLApiOpenidConnectConfigArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[str],
                 auth_ttl: Optional[pulumi.Input[int]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 iat_ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param pulumi.Input[int] auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param pulumi.Input[str] client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param pulumi.Input[int] iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @auth_ttl.setter
    def auth_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_ttl", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")

    @iat_ttl.setter
    def iat_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iat_ttl", value)


@pulumi.input_type
class GraphQLApiUserPoolConfigArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[str],
                 user_pool_id: pulumi.Input[str],
                 app_id_client_regex: Optional[pulumi.Input[str]] = None,
                 aws_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] default_action: The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param pulumi.Input[str] user_pool_id: The user pool ID.
        :param pulumi.Input[str] app_id_client_regex: A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param pulumi.Input[str] aws_region: The AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[str]:
        """
        The action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @app_id_client_regex.setter
    def app_id_client_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id_client_regex", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)


@pulumi.input_type
class ResolverCachingConfigArgs:
    def __init__(__self__, *,
                 caching_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] caching_keys: The list of caching key.
        :param pulumi.Input[int] ttl: The TTL in seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of caching key.
        """
        return pulumi.get(self, "caching_keys")

    @caching_keys.setter
    def caching_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "caching_keys", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class ResolverPipelineConfigArgs:
    def __init__(__self__, *,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] functions: The list of Function ID.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Function ID.
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "functions", value)


