# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ResponseArgs', 'Response']

@pulumi.input_type
class ResponseArgs:
    def __init__(__self__, *,
                 response_type: pulumi.Input[str],
                 rest_api_id: pulumi.Input[str],
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 status_code: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Response resource.
        :param pulumi.Input[str] response_type: The response type of the associated GatewayResponse.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated REST API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_parameters: A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_templates: A map specifying the templates used to transform the response body.
        :param pulumi.Input[str] status_code: The HTTP status code of the Gateway Response.
        """
        pulumi.set(__self__, "response_type", response_type)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> pulumi.Input[str]:
        """
        The response type of the associated GatewayResponse.
        """
        return pulumi.get(self, "response_type")

    @response_type.setter
    def response_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "response_type", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[str]:
        """
        The string identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "response_parameters", value)

    @property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map specifying the templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @response_templates.setter
    def response_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "response_templates", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class _ResponseState:
    def __init__(__self__, *,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_type: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Response resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_parameters: A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_templates: A map specifying the templates used to transform the response body.
        :param pulumi.Input[str] response_type: The response type of the associated GatewayResponse.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated REST API.
        :param pulumi.Input[str] status_code: The HTTP status code of the Gateway Response.
        """
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if response_type is not None:
            pulumi.set(__self__, "response_type", response_type)
        if rest_api_id is not None:
            pulumi.set(__self__, "rest_api_id", rest_api_id)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "response_parameters", value)

    @property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map specifying the templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @response_templates.setter
    def response_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "response_templates", value)

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> Optional[pulumi.Input[str]]:
        """
        The response type of the associated GatewayResponse.
        """
        return pulumi.get(self, "response_type")

    @response_type.setter
    def response_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_type", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[pulumi.Input[str]]:
        """
        The string identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)


class Response(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_type: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an API Gateway Gateway Response for a REST API Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.apigateway.RestApi("main")
        test = aws.apigateway.Response("test",
            rest_api_id=main.id,
            status_code="401",
            response_type="UNAUTHORIZED",
            response_templates={
                "application/json": "{\"message\":$context.error.messageString}",
            },
            response_parameters={
                "gatewayresponse.header.Authorization": "'Basic'",
            })
        ```

        ## Import

        `aws_api_gateway_gateway_response` can be imported using `REST-API-ID/RESPONSE-TYPE`, e.g.

        ```sh
         $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_parameters: A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_templates: A map specifying the templates used to transform the response body.
        :param pulumi.Input[str] response_type: The response type of the associated GatewayResponse.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated REST API.
        :param pulumi.Input[str] status_code: The HTTP status code of the Gateway Response.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResponseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an API Gateway Gateway Response for a REST API Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.apigateway.RestApi("main")
        test = aws.apigateway.Response("test",
            rest_api_id=main.id,
            status_code="401",
            response_type="UNAUTHORIZED",
            response_templates={
                "application/json": "{\"message\":$context.error.messageString}",
            },
            response_parameters={
                "gatewayresponse.header.Authorization": "'Basic'",
            })
        ```

        ## Import

        `aws_api_gateway_gateway_response` can be imported using `REST-API-ID/RESPONSE-TYPE`, e.g.

        ```sh
         $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
        ```

        :param str resource_name: The name of the resource.
        :param ResponseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResponseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 response_type: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResponseArgs.__new__(ResponseArgs)

            __props__.__dict__["response_parameters"] = response_parameters
            __props__.__dict__["response_templates"] = response_templates
            if response_type is None and not opts.urn:
                raise TypeError("Missing required property 'response_type'")
            __props__.__dict__["response_type"] = response_type
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
            __props__.__dict__["status_code"] = status_code
        super(Response, __self__).__init__(
            'aws:apigateway/response:Response',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            response_type: Optional[pulumi.Input[str]] = None,
            rest_api_id: Optional[pulumi.Input[str]] = None,
            status_code: Optional[pulumi.Input[str]] = None) -> 'Response':
        """
        Get an existing Response resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_parameters: A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] response_templates: A map specifying the templates used to transform the response body.
        :param pulumi.Input[str] response_type: The response type of the associated GatewayResponse.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated REST API.
        :param pulumi.Input[str] status_code: The HTTP status code of the Gateway Response.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResponseState.__new__(_ResponseState)

        __props__.__dict__["response_parameters"] = response_parameters
        __props__.__dict__["response_templates"] = response_templates
        __props__.__dict__["response_type"] = response_type
        __props__.__dict__["rest_api_id"] = rest_api_id
        __props__.__dict__["status_code"] = status_code
        return Response(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map specifying the parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map specifying the templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> pulumi.Output[str]:
        """
        The response type of the associated GatewayResponse.
        """
        return pulumi.get(self, "response_type")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[str]:
        """
        The string identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

