//Anime4K v3.0 GLSL

// MIT License

// Copyright (c) 2019-2020 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!SAVE LUMAN0
//!COMPONENTS 4


vec4 hook() {
	vec2 dp = HOOKED_pt;
	float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
	float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
	float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
	float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
	float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
	float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
	float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
	float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
	float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;

	float s = 0.4215035*a + 0.41656324*b + 0.57168597*c + -0.07139752*d + -1.0765523*e + 0.04791426*f + -0.074310005*g + -0.20214646*h + 0.21949938*i;
	float o = s+0.080419116;
	s = 0.47888502*a + -0.5302326*b + 0.044158366*c + -0.061843097*d + 0.93260187*e + -0.48089626*f + -0.0035360905*g + -0.46852994*h + -0.040424205*i;
	float p = s+-0.021478968;
	s = 1.0640558*a + -1.0064243*b + -0.07889837*c + 0.094287656*d + -0.1063593*e + 0.03934059*f + 0.030866144*g + -0.029255068*h + -0.022191582*i;
	float q = s+-0.00651517;
	s = 0.0032808038*a + -0.41636068*b + -0.43624774*c + 1.7085389*d + -0.31619057*e + -0.6808209*f + 0.12012518*g + 0.008737675*h + -0.035705682*i;
	float r = s+-0.10506958;

	return vec4(o, p, q, r);
}


//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!SAVE LUMAN1
//!COMPONENTS 4

#define L_tex LUMAN0_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = 0.11412825*a.x + 0.1840317*b.x + -0.10466666*c.x + -0.12713116*d.x + 0.35276088*e.x + -0.02395153*f.x + -0.28461823*g.x + -0.96569353*h.x + -0.18971665*i.x;
	float t = -1.1137404*a.y + 0.43714485*b.y + -0.044679902*c.y + -0.2501947*d.y + -1.2947936*e.y + -0.31301048*f.y + 0.3053378*g.y + 0.29979745*h.y + -0.51788515*i.y;
	float u = 0.47026485*a.z + -0.31839973*b.z + 0.055645958*c.z + -0.29835618*d.z + 0.81404704*e.z + 0.34622005*f.z + -0.5541774*g.z + 0.22531238*h.z + 0.40981588*i.z;
	float v = 0.24740729*a.w + 0.23572107*b.w + -0.08851564*c.w + 0.28490144*d.w + -0.44812602*e.w + -0.11019879*f.w + -0.027907236*g.w + -0.10703253*h.w + 0.25705412*i.w;
	float w = -0.028948177*na.x + -0.3628554*nb.x + 0.15084967*nc.x + 0.51021785*nd.x + -0.28001648*ne.x + -0.014126939*nf.x + -0.067092106*ng.x + 1.1658121*nh.x + 0.1256911*ni.x;
	float x = 1.0376894*na.y + -0.48707172*nb.y + -0.009269018*nc.y + 0.55338943*nd.y + 0.90316075*ne.y + 0.5183273*nf.y + -0.32279676*ng.y + -0.34821483*nh.y + 0.41045278*ni.y;
	float y = -0.4172725*na.z + 0.2591147*nb.z + -0.011703725*nc.z + 0.21599749*nd.z + -0.754353*ne.z + -0.24588206*nf.z + 0.45339534*ng.z + 0.02932943*nh.z + -0.27703565*ni.z;
	float z = -0.28587815*na.w + -0.20535208*nb.w + 0.14220202*nc.w + -0.2592008*nd.w + 0.24861126*ne.w + 0.07041689*nf.w + 0.0374483*ng.w + 0.14708018*nh.w + -0.31886858*ni.w;
	float o = s+t+u+v+w+x+y+z+0.07075245;
	s = 0.22809531*a.x + 0.713199*b.x + 0.020191291*c.x + -0.42702183*d.x + 0.079573214*e.x + -0.20965911*f.x + -0.16740705*g.x + -0.015297627*h.x + -0.09801453*i.x;
	t = 0.80420643*a.y + 0.42259648*b.y + -0.795659*c.y + 0.0325615*d.y + -0.33446467*e.y + 0.41807374*f.y + 0.0836409*g.y + 0.23192492*h.y + -0.1460712*i.y;
	u = -0.26335868*a.z + -0.15078981*b.z + 0.25765446*c.z + -0.07761006*d.z + 0.39791512*e.z + -1.5991426*f.z + -0.27469876*g.z + -0.34801024*h.z + -0.8188961*i.z;
	v = 0.43287337*a.w + 0.124613665*b.w + 0.22592716*c.w + 0.2346119*d.w + 0.49975863*e.w + -0.14529376*f.w + -0.017041866*g.w + -0.11588172*h.w + -0.052651063*i.w;
	w = 0.025791507*na.x + -0.3686168*nb.x + 0.07106921*nc.x + 0.491538*nd.x + -1.0039831*ne.x + 0.013333708*nf.x + 0.34352425*ng.x + 0.43233067*nh.x + 0.5134391*ni.x;
	x = -0.2640387*na.y + -0.3845837*nb.y + 0.3327947*nc.y + 0.05188843*nd.y + 0.34995463*ne.y + 0.20881203*nf.y + -0.10452135*ng.y + -0.12896696*nh.y + 0.12609659*ni.y;
	y = 0.2306687*na.z + 0.35035846*nb.z + -0.23430833*nc.z + 0.10205449*nd.z + -0.7719395*ne.z + -1.7360915*nf.z + 0.116180964*ng.z + 0.3520401*nh.z + -0.1896886*ni.z;
	z = -0.32307857*na.w + -0.13180432*nb.w + 0.102697425*nc.w + -0.058036186*nd.w + -0.029107057*ne.w + -0.10502086*nf.w + 0.055922143*ng.w + 0.27744582*nh.w + 0.20273137*ni.w;
	float p = s+t+u+v+w+x+y+z+0.17738186;
	s = 0.25096753*a.x + -0.1439386*b.x + 0.06863364*c.x + -0.023040973*d.x + -0.087104216*e.x + 0.025757983*f.x + -0.13160077*g.x + -0.31460378*h.x + -0.2810511*i.x;
	t = -0.037828647*a.y + 0.46088392*b.y + 0.16697082*c.y + -0.32181877*d.y + -0.8034469*e.y + -0.007853226*f.y + 0.22245245*g.y + -0.17000756*h.y + -0.3170783*i.y;
	u = -0.05339165*a.z + -0.23307642*b.z + -0.27752477*c.z + 0.57795924*d.z + 2.4150634*e.z + -0.1553794*f.z + 0.91762215*g.z + 2.9205158*h.z + -0.62780726*i.z;
	v = 0.008431615*a.w + -0.3139873*b.w + 0.077316776*c.w + -0.48687732*d.w + -0.26484016*e.w + -0.30870837*f.w + 0.074478514*g.w + -0.017214324*h.w + -0.23271704*i.w;
	w = 0.019084003*na.x + -0.27042627*nb.x + 0.35310376*nc.x + 0.9040677*nd.x + -0.22280133*ne.x + 0.038271353*nf.x + 0.29289967*ng.x + 0.73126876*nh.x + 0.5824376*ni.x;
	x = 0.20054185*na.y + -0.5243122*nb.y + -0.2988139*nc.y + 0.5042576*nd.y + 0.19609748*ne.y + 0.10971252*nf.y + -0.23124342*ng.y + 0.0101277875*nh.y + 0.03808317*ni.y;
	y = -0.029705035*na.z + -0.01676097*nb.z + 0.16964933*nc.z + -0.38320288*nd.z + -0.20108853*ne.z + 0.52724063*nf.z + -0.45516887*ng.z + 1.8857152*nh.z + 1.1747494*ni.z;
	z = 0.07067171*na.w + 0.075052306*nb.w + -0.047203705*nc.w + 0.43481615*nd.w + -0.13102*ne.w + 0.29182047*nf.w + -0.1287183*ng.w + -0.37939408*nh.w + 0.070292786*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.115625635;
	s = 0.35827693*a.x + -0.30227056*b.x + -0.44081002*c.x + 0.26017424*d.x + 0.8550553*e.x + -0.55716866*f.x + 0.054754138*g.x + -0.080581844*h.x + -0.15080602*i.x;
	t = -0.062642284*a.y + -0.14259076*b.y + 0.33019453*c.y + 0.71486366*d.y + -1.0258917*e.y + -0.11104437*f.y + 0.015965585*g.y + 0.10489625*h.y + -0.10499223*i.y;
	u = -0.15696016*a.z + -0.12249757*b.z + -0.22436732*c.z + -0.857205*d.z + 0.61505085*e.z + 1.3274351*f.z + -0.18885106*g.z + -0.7410624*h.z + 0.4326501*i.z;
	v = 0.24964753*a.w + -0.24759892*b.w + -0.64394045*c.w + 0.10346697*d.w + 0.17717692*e.w + -0.07325081*f.w + 0.03706077*g.w + 0.2017116*h.w + -0.33281687*i.w;
	w = -0.50056964*na.x + 0.40377027*nb.x + 0.43643215*nc.x + -0.41446805*nd.x + -0.20904464*ne.x + 0.6639448*nf.x + -0.0852812*ng.x + 0.0454402*nh.x + 0.05429976*ni.x;
	x = -0.18911883*na.y + 0.32083353*nb.y + -0.13942093*nc.y + -1.0000733*nd.y + 0.96402824*ne.y + -0.35260603*nf.y + -0.10849313*ng.y + -0.077746384*nh.y + 0.01527712*ni.y;
	y = 0.17753036*na.z + 0.010192072*nb.z + 0.24215275*nc.z + 0.89387465*nd.z + -0.36714798*ne.z + 0.24506041*nf.z + 0.036823828*ng.z + 0.06819655*nh.z + 0.27566668*ni.z;
	z = -0.18686979*na.w + 0.25775823*nb.w + 0.3835672*nc.w + -0.051711187*nd.w + -0.106725216*ne.w + 0.20422176*nf.w + -0.08836096*ng.w + -0.24972022*nh.w + 0.35029697*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.115707986;

	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN1
//!SAVE LUMAN2
//!COMPONENTS 4

#define L_tex LUMAN1_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);

	float s = 0.19531512*a.x + 0.75661004*b.x + 0.3096166*c.x + 0.06358046*d.x + 0.1499614*e.x + -0.030383693*f.x + -0.033407122*g.x + 0.048501644*h.x + 0.049986936*i.x;
	float t = 0.06886095*a.y + 0.03402651*b.y + 0.01457621*c.y + -0.21454492*d.y + -0.36702567*e.y + -0.1630866*f.y + 0.13787402*g.y + -0.024016507*h.y + -0.109474584*i.y;
	float u = 0.0069454503*a.z + -0.034396306*b.z + -0.12354474*c.z + 0.07201203*d.z + -0.10630567*e.z + 0.18307814*f.z + -0.03039953*g.z + 0.07355419*h.z + -0.021904688*i.z;
	float v = 0.016922433*a.w + 0.30183804*b.w + 0.11077736*c.w + 0.35945925*d.w + -0.4954182*e.w + -0.38786575*f.w + 0.09543617*g.w + 0.24686292*h.w + 0.05511377*i.w;
	float w = -0.15380311*na.x + -0.40750685*nb.x + -0.11207901*nc.x + -0.046549615*nd.x + 0.39128157*ne.x + 0.24458118*nf.x + 0.102530785*ng.x + 0.06391891*nh.x + -0.03831063*ni.x;
	float x = -0.05588117*na.y + -0.1881189*nb.y + -0.09076967*nc.y + -0.16613042*nd.y + 0.020559976*ne.y + -0.008077824*nf.y + -0.17901485*ng.y + -0.04537302*nh.y + -0.11788763*ni.y;
	float y = -0.007689388*na.z + -0.05978623*nb.z + 0.14321665*nc.z + 0.042092275*nd.z + 0.34321675*ne.z + -0.03005287*nf.z + 0.011204766*ng.z + -0.105857685*nh.z + 0.13019703*ni.z;
	float z = -0.04347269*na.w + -0.4376902*nb.w + -0.04843904*nc.w + -0.059588917*nd.w + 0.46535304*ne.w + 0.4958977*nf.w + -0.03444163*ng.w + -0.18499602*nh.w + -0.012110156*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.074530095;
	s = -0.06742854*a.x + -0.12321965*b.x + -0.14357084*c.x + -0.01815457*d.x + 0.17294414*e.x + -0.18659571*f.x + 0.06692644*g.x + 0.09908733*h.x + -0.11809575*i.x;
	t = -0.005772749*a.y + -0.013990392*b.y + -0.0020466307*c.y + -0.036487233*d.y + 0.4806164*e.y + -0.0046594343*f.y + 0.042192*g.y + 0.26031008*h.y + 0.009724199*i.y;
	u = -0.024550475*a.z + -0.038105283*b.z + 0.030287327*c.z + -0.027531162*d.z + 0.08877715*e.z + -0.027587755*f.z + -0.0028527123*g.z + -0.07279942*h.z + -0.010473134*i.z;
	v = -0.18172199*a.w + -0.29467285*b.w + -0.047669973*c.w + -0.40614647*d.w + 0.9024393*e.w + 0.10957179*f.w + 0.007726905*g.w + -0.028344521*h.w + -0.021076318*i.w;
	w = -0.024287289*na.x + -0.08251041*nb.x + 0.13607152*nc.x + 0.056396626*nd.x + -0.30565166*ne.x + -0.06323622*nf.x + 0.0034147159*ng.x + -0.068183005*nh.x + 0.09750015*ni.x;
	x = 0.11207607*na.y + 0.19217284*nb.y + 0.060664564*nc.y + -0.0028700104*nd.y + -0.44213495*ne.y + -0.010552949*nf.y + 0.09471371*ng.y + 0.07775542*nh.y + 0.1293176*ni.y;
	y = -0.021849515*na.z + -0.103380375*nb.z + -0.1386149*nc.z + 0.035920314*nd.z + -0.034096282*ne.z + -0.011182113*nf.z + -0.07874607*ng.z + -0.0998542*nh.z + -0.11313594*ni.z;
	z = 0.26100898*na.w + 0.26773435*nb.w + 0.07979528*nc.w + 0.4306503*nd.w + -0.709519*ne.w + -0.028593455*nf.w + -0.0013585149*ng.w + -0.08628674*nh.w + 0.031180594*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.1715465;
	s = -0.14666776*a.x + 0.26855308*b.x + -0.10737497*c.x + -0.478907*d.x + -1.2726359*e.x + 0.3092185*f.x + -0.17867793*g.x + -0.0936289*h.x + 0.12641555*i.x;
	t = 0.008328487*a.y + -0.037953213*b.y + -0.025492352*c.y + -0.19912837*d.y + -0.3742934*e.y + -0.10713854*f.y + -0.22536866*g.y + -0.11653662*h.y + -0.029667256*i.y;
	u = 0.0976369*a.z + 0.05373832*b.z + 0.10847769*c.z + 0.15022285*d.z + -0.19162357*e.z + -0.07674518*f.z + -0.026067028*g.z + 0.08050421*h.z + 0.107850924*i.z;
	v = 0.21821137*a.w + 0.2239173*b.w + -0.040711384*c.w + 0.010436842*d.w + -0.33070624*e.w + -0.07766937*f.w + -0.547517*g.w + -0.22036882*h.w + 0.068507455*i.w;
	w = -0.27923876*na.x + -0.83953506*nb.x + -0.04937735*nc.x + -0.12517925*nd.x + -0.34880203*ne.x + -0.03229114*nf.x + 0.07304*ng.x + -0.099752046*nh.x + -0.09073451*ni.x;
	x = 0.0071992767*na.y + -0.17674018*nb.y + -0.165915*nc.y + 0.24181545*nd.y + 0.39054248*ne.y + 0.01080755*nf.y + 0.13797866*ng.y + 0.096533135*nh.y + -0.18103594*ni.y;
	y = 0.10480431*na.z + 0.27455416*nb.z + 0.24250263*nc.z + 0.0921634*nd.z + 0.057761982*ne.z + 0.1963843*nf.z + 0.2117321*ng.z + 0.089583576*nh.z + 0.26418045*ni.z;
	z = -0.06917119*na.w + -0.27698052*nb.w + -0.00064422615*nc.w + 0.16140637*nd.w + 0.3779389*ne.w + -0.11035467*nf.w + 0.5129668*ng.w + 0.5356295*nh.w + -0.13237986*ni.w;
	float q = s+t+u+v+w+x+y+z+0.10023738;
	s = -0.23887102*a.x + 0.24277607*b.x + -0.41683316*c.x + -0.2895234*d.x + 0.00010446638*e.x + 0.36765575*f.x + -0.024521258*g.x + 0.14120218*h.x + 0.16108708*i.x;
	t = -0.33275175*a.y + 0.007576721*b.y + -0.13189057*c.y + -0.0536059*d.y + 0.19288039*e.y + 0.15331933*f.y + -0.16995217*g.y + -0.23417917*h.y + 0.38105*i.y;
	u = 0.09834787*a.z + 0.1253177*b.z + -0.028776247*c.z + -0.07806128*d.z + 0.3587465*e.z + -0.046493925*f.z + -0.016537353*g.z + -0.27969596*h.z + 0.1458732*i.z;
	v = -0.57924134*a.w + 0.24679546*b.w + -0.22474492*c.w + -1.2378064*d.w + -0.33317074*e.w + 0.22736992*f.w + 0.014587293*g.w + -0.65192467*h.w + 0.023514273*i.w;
	w = 0.26154968*na.x + -0.75984037*nb.x + 0.03717654*nc.x + 0.37500888*nd.x + -0.56587577*ne.x + -0.48871645*nf.x + -0.2826228*ng.x + 0.08908507*nh.x + -0.086056955*ni.x;
	x = 0.042194832*na.y + -0.11804398*nb.y + 0.0643243*nc.y + 0.22535841*nd.y + 0.36214152*ne.y + 0.10931784*nf.y + 0.18903424*ng.y + -0.08267276*nh.y + 0.22756808*ni.y;
	y = 0.068569325*na.z + -0.0023039673*nb.z + -0.04598484*nc.z + 0.3297236*nd.z + -0.32703748*ne.z + 0.07459695*nf.z + 0.10545363*ng.z + 0.18110338*nh.z + -0.26289833*ni.z;
	z = 0.8522838*na.w + -0.11771054*nb.w + 0.11908337*nc.w + 1.3367181*nd.w + 0.7088517*ne.w + -0.62825435*nf.w + 0.087871*ng.w + 1.1323127*nh.w + -0.15303938*ni.w;
	float r = s+t+u+v+w+x+y+z+0.08765152;
	
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN2
//!SAVE LUMAN3
//!COMPONENTS 4

#define L_tex LUMAN2_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);

	float s = -0.071484216*a.x + -0.15379138*b.x + -0.011637495*c.x + -0.12485528*d.x + 0.05375508*e.x + 0.022603117*f.x + 0.049010042*g.x + 0.06119798*h.x + -0.0343863*i.x;
	float t = 0.20201275*a.y + 0.19588579*b.y + -0.07735335*c.y + 0.47221488*d.y + 0.16061525*e.y + 0.29085115*f.y + 0.17465873*g.y + 0.24865559*h.y + -0.14413305*i.y;
	float u = -0.15183356*a.z + -0.06946449*b.z + -0.13527918*c.z + -0.009835063*d.z + -0.07576131*e.z + 0.16591768*f.z + -0.011752567*g.z + 0.051701143*h.z + -0.055118393*i.z;
	float v = 0.0100477245*a.w + 0.026903853*b.w + 0.048386924*c.w + -0.040059995*d.w + 0.026380781*e.w + -0.0033332172*f.w + -0.073551245*g.w + 0.06826868*h.w + -0.015563708*i.w;
	float w = -0.13719939*na.x + 0.13114864*nb.x + -0.02011338*nc.x + -0.045670643*nd.x + 0.009785428*ne.x + -0.0940287*nf.x + 0.06100234*ng.x + -0.050412152*nh.x + 0.14110225*ni.x;
	float x = -0.16927695*na.y + -0.058850475*nb.y + 0.15892337*nc.y + -0.3816563*nd.y + 0.42354158*ne.y + -0.31966108*nf.y + -0.074423924*ng.y + -0.19131769*nh.y + 0.13021442*ni.y;
	float y = 0.014524241*na.z + -0.054700878*nb.z + -0.011205598*nc.z + -0.056959968*nd.z + -0.044072304*ne.z + -0.053675648*nf.z + -0.03056575*ng.z + -0.10361115*nh.z + 0.044025842*ni.z;
	float z = 0.09876018*na.w + 0.059865728*nb.w + -0.013275731*nc.w + 0.047606464*nd.w + -0.020946808*ne.w + -0.013572179*nf.w + 0.106707744*ng.w + -0.0496323*nh.w + 0.0055612717*ni.w;
	float o = s+t+u+v+w+x+y+z+0.0060072606;
	s = 0.17296407*a.x + -0.02353393*b.x + 0.03221925*c.x + 0.0029942524*d.x + 0.10439903*e.x + 0.12231822*f.x + -0.0648184*g.x + 0.37160578*h.x + 0.050405774*i.x;
	t = 0.056227725*a.y + 0.090547815*b.y + -0.1280931*c.y + 0.12094268*d.y + 0.7131343*e.y + -0.05858293*f.y + -0.10204301*g.y + 0.30663434*h.y + 0.027529169*i.y;
	u = -0.09819936*a.z + 0.06856007*b.z + 0.010322064*c.z + -0.022368576*d.z + 0.17078836*e.z + 0.13764809*f.z + -0.042109784*g.z + -0.028037867*h.z + 0.043926377*i.z;
	v = -0.028774306*a.w + -0.02652384*b.w + 0.031702884*c.w + -0.037220463*d.w + -0.039529596*e.w + 0.03946858*f.w + -0.038924288*g.w + 0.030092617*h.w + 0.0024306113*i.w;
	w = -0.16252601*na.x + -0.025766501*nb.x + 0.07263466*nc.x + 0.11477501*nd.x + 0.0019494815*ne.x + -0.10480847*nf.x + 0.23158173*ng.x + -0.4040528*nh.x + 0.052536312*ni.x;
	x = -0.09707612*na.y + -0.20994882*nb.y + 0.04613562*nc.y + -0.31773815*nd.y + -0.27689534*ne.y + -0.3284137*nf.y + -0.0038156905*ng.y + -0.32932884*nh.y + -0.24467573*ni.y;
	y = 0.048376214*na.z + -0.06355544*nb.z + 0.022650821*nc.z + -0.07016279*nd.z + -0.009721295*ne.z + 0.03617427*nf.z + 0.012988838*ng.z + -0.08307036*nh.z + -0.015296994*ni.z;
	z = 0.03248693*na.w + 0.055572554*nb.w + 0.015513567*nc.w + 0.037825506*nd.w + 0.00948496*ne.w + -0.06464796*nf.w + 0.036613774*ng.w + -0.04314624*nh.w + -0.028679999*ni.w;
	float p = s+t+u+v+w+x+y+z+0.2829641;
	s = 0.320721*a.x + 0.035459336*b.x + 0.023306018*c.x + 0.119004264*d.x + 0.20438322*e.x + 0.17621407*f.x + -0.31589565*g.x + -0.18008752*h.x + 0.03621878*i.x;
	t = 0.040115036*a.y + 0.32931724*b.y + -0.114885755*c.y + -0.08075643*d.y + 0.32371774*e.y + 0.16414165*f.y + 0.008934278*g.y + 0.00058803306*h.y + -0.058671538*i.y;
	u = 0.46319002*a.z + 0.5111636*b.z + 0.28321937*c.z + 0.27626333*d.z + 0.734393*e.z + 0.14846851*f.z + 0.07379987*g.z + 0.18866524*h.z + 0.16969498*i.z;
	v = -0.074738964*a.w + -0.13338739*b.w + -0.09041253*c.w + -0.114089765*d.w + -0.1643739*e.w + -0.060028445*f.w + -0.017498652*g.w + -0.13155481*h.w + -0.043019716*i.w;
	w = 0.16080199*na.x + -0.011583823*nb.x + 0.08729478*nc.x + 0.11836629*nd.x + 0.18851641*ne.x + -0.015855411*nf.x + 0.04861083*ng.x + -0.14782971*nh.x + -0.025266634*ni.x;
	x = 0.01589688*na.y + -0.17345417*nb.y + -0.08792109*nc.y + 0.3921203*nd.y + -0.10856708*ne.y + -0.32589427*nf.y + 0.11128785*ng.y + 0.26814553*nh.y + -0.11513526*ni.y;
	y = -0.14557354*na.z + -0.06748066*nb.z + -0.029917005*nc.z + 0.07269401*nd.z + -0.20973498*ne.z + -0.04152044*nf.z + 0.012080292*ng.z + 0.07383861*nh.z + 0.014937096*ni.z;
	z = -0.07913194*na.w + -0.08965903*nb.w + 0.010154432*nc.w + 0.10218615*nd.w + -0.041559584*ne.w + -0.061589126*nf.w + -0.0672816*ng.w + -0.0072393185*nh.w + -0.0646147*ni.w;
	float q = s+t+u+v+w+x+y+z+0.022043083;
	s = -0.27225387*a.x + 0.2828754*b.x + -0.10630629*c.x + 0.019877*d.x + -0.3263776*e.x + -0.23130926*f.x + 0.2440649*g.x + -0.42757595*h.x + -0.020886745*i.x;
	t = 0.014259129*a.y + -0.2630813*b.y + 0.08917837*c.y + -0.027197517*d.y + -0.42261592*e.y + -0.44196936*f.y + 0.060653217*g.y + -0.33134687*h.y + -0.048561227*i.y;
	u = 0.091200985*a.z + -0.21007726*b.z + -0.058688443*c.z + 0.094780594*d.z + -0.5010706*e.z + -0.375842*f.z + 0.05078212*g.z + 0.052483276*h.z + -0.20040707*i.z;
	v = -0.023157451*a.w + 0.0056420853*b.w + -0.066936195*c.w + -0.014182511*d.w + 0.12831312*e.w + -0.09974167*f.w + 0.09050297*g.w + -0.018599695*h.w + 0.06922196*i.w;
	w = 0.3577923*na.x + -0.1555226*nb.x + -0.011806127*nc.x + 0.014978679*nd.x + 0.49296147*ne.x + 0.33308923*nf.x + -0.44142124*ng.x + 0.70373046*nh.x + -0.03331094*ni.x;
	x = 0.08271521*na.y + 0.37149724*nb.y + -0.13579668*nc.y + 0.27287593*nd.y + -0.22429353*ne.y + 0.9060158*nf.y + 0.03304059*ng.y + 0.31473508*nh.y + 0.3542939*ni.y;
	y = -0.02708005*na.z + 0.08278668*nb.z + -0.030191392*nc.z + -0.018278172*nd.z + 0.0730759*ne.z + 0.05692738*nf.z + -0.01901399*ng.z + 0.04840379*nh.z + 0.064143375*ni.z;
	z = -0.026436036*na.w + -0.0831705*nb.w + -0.015898217*nc.w + -0.0042800093*nd.w + -0.10546304*ne.w + 0.11703322*nf.w + -0.051917955*ng.w + 0.06514161*nh.w + -0.03650162*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.26078916;
	
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN3
//!SAVE LUMAN4
//!COMPONENTS 4

#define L_tex LUMAN3_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = -0.107556306*a.x + -0.04081029*b.x + -0.008938213*c.x + 0.24670267*d.x + 0.01085363*e.x + 0.075738996*f.x + -0.0067675672*g.x + -0.05323595*h.x + -0.13599646*i.x;
	float t = -0.37925526*a.y + 0.22347686*b.y + -0.1767171*c.y + -0.08196524*d.y + 0.18382895*e.y + -0.35576165*f.y + -0.03806031*g.y + -0.5451033*h.y + -0.2305202*i.y;
	float u = -0.15359999*a.z + -0.006875495*b.z + -0.09655429*c.z + 0.21034376*d.z + -0.64395905*e.z + -0.03866011*f.z + 0.0029128285*g.z + -0.3779341*h.z + -0.14098142*i.z;
	float v = -0.19084647*a.w + 0.030812489*b.w + -0.059366476*c.w + 0.18756826*d.w + 0.6189365*e.w + 0.26788878*f.w + 0.21478464*g.w + -0.44997966*h.w + 0.22089215*i.w;
	float w = 0.17184879*na.x + 0.0033282684*nb.x + 0.054216553*nc.x + -0.5273202*nd.x + 0.2670501*ne.x + 0.076237395*nf.x + -0.030878715*ng.x + 0.21421494*nh.x + -0.29449406*ni.x;
	float x = 0.18188754*na.y + -0.3733855*nb.y + 0.038874805*nc.y + -0.14291866*nd.y + -0.6214685*ne.y + -0.10476491*nf.y + -0.19340777*ng.y + 0.2156583*nh.y + -0.050107118*ni.y;
	float y = 0.059755128*na.z + 0.07389861*nb.z + -0.006266912*nc.z + -0.16210014*nd.z + 0.52666557*ne.z + -0.06711788*nf.z + 0.15005633*ng.z + 0.16562483*nh.z + -0.22913584*ni.z;
	float z = 0.6047426*na.w + 0.20271854*nb.w + 0.3384107*nc.w + 0.33195493*nd.w + -0.22297256*ne.w + -0.12546994*nf.w + 0.059544683*ng.w + 0.52085406*nh.w + -0.00873421*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.13064185;
	s = 0.08732821*a.x + -0.05341844*b.x + 0.06901437*c.x + 0.09303019*d.x + -0.0096632475*e.x + 0.1702191*f.x + -0.1589017*g.x + -0.11956275*h.x + 0.09487855*i.x;
	t = 0.3286443*a.y + 0.45296693*b.y + 0.23995438*c.y + 0.060606387*d.y + -0.703761*e.y + -0.16169147*f.y + -0.10184594*g.y + 0.045386706*h.y + -0.03909988*i.y;
	u = 0.024303712*a.z + 0.012471365*b.z + -0.01730113*c.z + 0.1404732*d.z + 0.18380049*e.z + 0.0479657*f.z + -0.06476113*g.z + 0.023015436*h.z + 0.02297177*i.z;
	v = 0.08092012*a.w + 0.14953266*b.w + -0.016252734*c.w + 0.009759683*d.w + -0.7273685*e.w + 0.008518111*f.w + -0.10309023*g.w + 0.12540577*h.w + 0.031582095*i.w;
	w = -0.10731416*na.x + -0.1368941*nb.x + -0.13317919*nc.x + -0.30966043*nd.x + -0.1918782*ne.x + -0.44585067*nf.x + 0.15991306*ng.x + 0.024030292*nh.x + -0.024647191*ni.x;
	x = -0.1979266*na.y + -0.646615*nb.y + -0.20555265*nc.y + 0.024128452*nd.y + 1.219782*ne.y + 0.15514997*nf.y + 0.09696628*ng.y + -0.25017464*nh.y + 0.059785355*ni.y;
	y = -0.04753436*na.z + -0.05745985*nb.z + 0.010196696*nc.z + -0.009032149*nd.z + 0.16765115*ne.z + 0.14833985*nf.z + 0.06543748*ng.z + -0.01792832*nh.z + -0.009773784*ni.z;
	z = -0.23816025*na.w + -0.07474088*nb.w + -0.023512343*nc.w + -0.034709882*nd.w + 0.5064627*ne.w + 0.12378374*nf.w + 0.11695783*ng.w + -0.15038316*nh.w + -0.10991656*ni.w;
	float p = s+t+u+v+w+x+y+z+0.111566626;
	s = 0.04803703*a.x + 0.09719456*b.x + 0.037009735*c.x + -0.14740345*d.x + -0.84762454*e.x + 0.26000938*f.x + -0.0018342865*g.x + 0.21009481*h.x + 0.32474878*i.x;
	t = 0.540793*a.y + 0.40065685*b.y + 0.19238408*c.y + 0.61297274*d.y + 1.796825*e.y + 0.39143816*f.y + 0.3346262*g.y + 0.5160184*h.y + 0.23154403*i.y;
	u = 0.068333425*a.z + 0.2247325*b.z + -0.0012861274*c.z + -0.13434076*d.z + -0.065552816*e.z + -0.115094036*f.z + 0.0074256705*g.z + 0.19417994*h.z + 0.053342123*i.z;
	v = 0.22789666*a.w + 0.2571478*b.w + -0.09805842*c.w + -0.012676717*d.w + 0.29140922*e.w + 0.2520991*f.w + 0.007481838*g.w + -0.019897738*h.w + 0.011071546*i.w;
	w = -0.11999563*na.x + -0.49221912*nb.x + -0.23500362*nc.x + 0.15113503*nd.x + 0.21974513*ne.x + -0.80736375*nf.x + -0.045717135*ng.x + -0.42507663*nh.x + -0.13569136*ni.x;
	x = -0.4226151*na.y + -0.40575272*nb.y + -0.15956134*nc.y + -0.34036857*nd.y + -1.102862*ne.y + -0.42583948*nf.y + -0.3897435*ng.y + -0.3760679*nh.y + -0.22287402*ni.y;
	y = -0.06418248*na.z + -0.19241585*nb.z + 0.021428568*nc.z + 0.033025675*nd.z + 0.33696234*ne.z + -0.15845138*nf.z + -0.009344784*ng.z + -0.29591*nh.z + 0.2119428*ni.z;
	z = -0.49135718*na.w + -0.2149747*nb.w + 0.010947395*nc.w + -0.23447789*nd.w + -0.57303745*ne.w + -0.26816955*nf.w + -0.06945182*ng.w + -0.41862604*nh.w + -0.20820309*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.17401248;
	s = 0.024169812*a.x + 0.12276286*b.x + 0.072896846*c.x + 0.013356247*d.x + -0.29824728*e.x + 0.3640592*f.x + -0.021671157*g.x + 0.17517301*h.x + 0.20794316*i.x;
	t = 0.73604757*a.y + -0.40369877*b.y + -0.047552362*c.y + 0.5976236*d.y + 1.2667477*e.y + 0.120913014*f.y + -0.086337656*g.y + 0.57444984*h.y + 0.1568324*i.y;
	u = 0.09157643*a.z + 0.120509826*b.z + 0.0963957*c.z + -0.17727146*d.z + 0.41721648*e.z + 0.13159907*f.z + -0.03929071*g.z + 0.33859134*h.z + 0.11599431*i.z;
	v = 0.41087788*a.w + -0.050653685*b.w + -0.03918905*c.w + 0.06573269*d.w + -0.20179011*e.w + -0.035744686*f.w + -0.42498958*g.w + 0.3335128*h.w + -0.15998083*i.w;
	w = -0.18987572*na.x + -0.08540897*nb.x + -0.114256285*nc.x + 0.22100426*nd.x + 0.12920749*ne.x + -0.2667084*nf.x + 0.08685889*ng.x + -0.2826793*nh.x + 0.31001362*ni.x;
	x = -0.5575261*na.y + 0.505366*nb.y + 0.13648646*nc.y + -0.45204118*nd.y + -0.42505625*ne.y + 0.17850064*nf.y + 0.17871024*ng.y + -0.24247022*nh.y + 0.013947173*ni.y;
	y = -0.050637517*na.z + -0.16217881*nb.z + 0.016173797*nc.z + 0.034584884*nd.z + -0.40451482*ne.z + -0.0717917*nf.z + -0.07246215*ng.z + -0.19490081*nh.z + 0.23232709*ni.z;
	z = -0.83920246*na.w + -0.11618735*nb.w + -0.1241044*nc.w + -0.56043375*nd.w + -0.467935*ne.w + -0.019662065*nf.w + 0.16833934*ng.w + -0.54890954*nh.w + -0.036264963*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.0033602072;
		
	return vec4(o, p, q, r);
}
//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN4
//!SAVE LUMAN5
//!COMPONENTS 4

#define L_tex LUMAN4_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = -0.059548892*a.x + 0.43702522*b.x + -0.13668647*c.x + 0.123984024*d.x + -0.2343888*e.x + 0.025218552*f.x + -0.06524572*g.x + 0.04462251*h.x + 0.16215426*i.x;
	float t = -0.23212624*a.y + 0.5297861*b.y + -0.08972621*c.y + -0.29718494*d.y + 0.24537762*e.y + -0.13523978*f.y + -0.0004026576*g.y + -0.04473626*h.y + 0.05336481*i.y;
	float u = 0.017119335*a.z + -0.3263757*b.z + 0.12577404*c.z + -0.029412897*d.z + -0.041355725*e.z + -0.15547447*f.z + 0.0076208394*g.z + 0.011133262*h.z + -0.09348499*i.z;
	float v = 0.038146578*a.w + 0.12203401*b.w + -0.19569762*c.w + 0.069038145*d.w + -0.47764647*e.w + -0.037598196*f.w + -0.03700972*g.w + -0.011845992*h.w + 0.06614768*i.w;
	float w = -0.008910504*na.x + -0.36844528*nb.x + 0.095519766*nc.x + -0.043147206*nd.x + 0.22098836*ne.x + 0.058772195*nf.x + 0.005588626*ng.x + -0.032535374*nh.x + -0.12800957*ni.x;
	float x = 0.13014328*na.y + -0.2560215*nb.y + 0.12146188*nc.y + 0.3076815*nd.y + -0.19066697*ne.y + -0.026679447*nf.y + -0.16170867*ng.y + 0.0062916437*nh.y + -0.042638574*ni.y;
	float y = -0.09460875*na.z + 0.33835813*nb.z + -0.13774352*nc.z + 0.09747969*nd.z + -0.2775574*ne.z + 0.10525732*nf.z + 0.002360881*ng.z + -0.07545961*nh.z + 0.083646305*ni.z;
	float z = -0.017314918*na.w + -0.16075635*nb.w + 0.019418081*nc.w + -0.00021538461*nd.w + 0.37484276*ne.w + 0.04987272*nf.w + 0.045123585*ng.w + -0.011118931*nh.w + 0.008850806*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.01168409;
	s = 0.04390882*a.x + 0.00028676892*b.x + 0.1369192*c.x + 0.09192912*d.x + 0.40848687*e.x + -0.07258693*f.x + 0.051216785*g.x + -0.042233836*h.x + -0.10429957*i.x;
	t = 0.19647208*a.y + -0.17864986*b.y + 0.14890863*c.y + 0.36475497*d.y + -0.66949457*e.y + 0.2154419*f.y + 0.24297847*g.y + -0.41431725*h.y + 0.05826373*i.y;
	u = -0.08638336*a.z + 0.07897926*b.z + -0.12295154*c.z + -0.06136639*d.z + 0.3678849*e.z + 0.14977399*f.z + 0.052167486*g.z + 0.07076993*h.z + 0.14226422*i.z;
	v = -0.022243215*a.w + 0.1288933*b.w + 0.17433701*c.w + 0.095396556*d.w + 0.33610657*e.w + -0.0039668*f.w + -0.04683302*g.w + 0.068621494*h.w + -0.25429747*i.w;
	w = 0.034006625*na.x + -0.042580634*nb.x + -0.09349343*nc.x + -0.13119647*nd.x + -0.29319564*ne.x + -0.07300171*nf.x + 0.044772662*ng.x + -0.04995681*nh.x + 0.22140417*ni.x;
	x = -0.16712625*na.y + 0.10423614*nb.y + -0.17219703*nc.y + -0.4457812*nd.y + 0.61158*ne.y + -0.29955527*nf.y + -0.10820896*ng.y + 0.1999257*nh.y + 0.06247788*ni.y;
	y = 0.0608084*na.z + -0.07334189*nb.z + 0.047938384*nc.z + 0.09157263*nd.z + -0.35632375*ne.z + -0.024168178*nf.z + -0.08407318*ng.z + -0.017649708*nh.z + -0.14972878*ni.z;
	z = 0.02588695*na.w + -0.08707571*nb.w + -0.09017493*nc.w + -0.023196384*nd.w + -0.48675185*ne.w + 0.085413784*nf.w + -0.08183361*ng.w + 0.079769425*nh.w + 0.17876361*ni.w;
	float p = s+t+u+v+w+x+y+z+0.08974541;
	s = 0.11793741*a.x + 0.17236432*b.x + 0.007316329*c.x + -0.029080074*d.x + -0.5462617*e.x + -0.21368095*f.x + -0.03163705*g.x + -0.18045929*h.x + 0.033423495*i.x;
	t = -0.07487674*a.y + 0.039981645*b.y + 0.04123286*c.y + 0.0026752134*d.y + 0.025552675*e.y + 0.14129147*f.y + -0.052356925*g.y + 0.080669664*h.y + -0.1604305*i.y;
	u = 0.014396548*a.z + -0.15668866*b.z + -0.086082*c.z + 0.20217386*d.z + 0.26358724*e.z + -0.053174455*f.z + -0.0226553*g.z + 0.1240673*h.z + -0.10206111*i.z;
	v = 0.09398775*a.w + 0.18773827*b.w + 0.17133693*c.w + -0.23268327*d.w + -0.3664219*e.w + -0.26318702*f.w + -0.095037445*g.w + -0.41657946*h.w + 0.15929739*i.w;
	w = -0.106357284*na.x + -0.085850805*nb.x + -0.0362939*nc.x + 0.11971479*nd.x + 0.17938587*ne.x + 0.1855791*nf.x + 0.11161726*ng.x + 0.23719479*nh.x + -0.06750009*ni.x;
	x = 0.017156227*na.y + -0.15604517*nb.y + -0.052415892*nc.y + 0.41085327*nd.y + 0.29584593*ne.y + 0.0076787835*nf.y + 0.24328612*ng.y + 0.44541475*nh.y + 0.47811326*ni.y;
	y = -0.08137792*na.z + 0.0054794652*nb.z + 0.010020674*nc.z + 0.010480144*nd.z + -0.039868042*ne.z + -0.07489741*nf.z + 0.07070988*ng.z + -0.21065474*nh.z + 0.021973649*ni.z;
	z = 0.064107254*na.w + -0.0053908625*nb.w + -0.114863224*nc.w + 0.16731638*nd.w + 0.25538787*ne.w + 0.1866355*nf.w + -0.093945995*ng.w + -0.06418409*nh.w + 0.0345877*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.2105562;
	s = -0.055774365*a.x + -0.11095068*b.x + 0.21099071*c.x + 0.76015043*d.x + 0.70880866*e.x + 0.4252973*f.x + 0.33279955*g.x + -0.02746693*h.x + 0.035472445*i.x;
	t = -0.4341578*a.y + -1.1611111*b.y + 0.08520569*c.y + -0.46149805*d.y + 1.0809829*e.y + 1.0949802*f.y + 0.6203274*g.y + 0.6198926*h.y + -0.32556617*i.y;
	u = 0.23835486*a.z + 0.52716905*b.z + 0.26488614*c.z + -0.14032772*d.z + 0.57221615*e.z + -0.2149275*f.z + -0.12058982*g.z + 0.026753379*h.z + 0.04769247*i.z;
	v = -0.21759552*a.w + -0.1794376*b.w + 0.13685067*c.w + 0.5899814*d.w + -0.3134837*e.w + -0.63145995*f.w + 0.027390439*g.w + -0.3019604*h.w + 0.22841412*i.w;
	w = 0.49606472*na.x + 0.28688988*nb.x + 0.041773863*nc.x + -1.0630385*nd.x + 0.3604913*ne.x + 0.35036606*nf.x + 0.1582547*ng.x + 0.101572216*nh.x + -0.17073904*ni.x;
	x = 0.04452118*na.y + 0.6793677*nb.y + -0.3826497*nc.y + 0.9849937*nd.y + -0.37544703*ne.y + -0.576944*nf.y + -0.7299865*ng.y + -0.5656419*nh.y + 0.47959635*ni.y;
	y = -0.1702095*na.z + -0.6615286*nb.z + 0.20921148*nc.z + 0.22325529*nd.z + 0.39463216*ne.z + 0.03648698*nf.z + 0.14656936*ng.z + -0.056198504*nh.z + 0.11951617*ni.z;
	z = -0.1369188*na.w + 0.024898373*nb.w + 0.11420796*nc.w + 0.38682333*nd.w + 0.6144158*ne.w + 0.12780511*nf.w + -0.3802895*ng.w + -0.3029823*nh.w + -0.12185999*ni.w;
	float r = s+t+u+v+w+x+y+z+0.13825609;
	
	return vec4(o, p, q, r);
}
//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN5
//!SAVE LUMAN6
//!COMPONENTS 4

#define L_tex LUMAN5_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = 0.11009468*a.x + 0.15513662*b.x + -0.007939103*c.x + 0.048910838*d.x + 0.3156732*e.x + 0.16871493*f.x + -0.04735453*g.x + 0.07840642*h.x + 0.01043032*i.x;
	float t = 0.0603009*a.y + 0.15049285*b.y + 0.031496715*c.y + 0.1218871*d.y + 0.83518285*e.y + 0.21006268*f.y + 0.070826806*g.y + 0.12967728*h.y + -0.021242341*i.y;
	float u = 0.041648302*a.z + -0.06679761*b.z + 0.0326429*c.z + -0.042804968*d.z + 0.009708471*e.z + 0.0055857953*f.z + 0.037250772*g.z + -0.038288858*h.z + 0.012428109*i.z;
	float v = -2.5322544e-05*a.w + 0.0024099427*b.w + -0.000615236*c.w + 0.0055611636*d.w + 0.022731034*e.w + 0.009610867*f.w + -0.0034642597*g.w + 0.041869152*h.w + 0.012283638*i.w;
	float w = -0.05471599*na.x + -0.062206052*nb.x + -0.014943314*nc.x + 0.06406119*nd.x + -0.14147298*ne.x + -0.05516727*nf.x + 0.0071981153*ng.x + -0.014024714*nh.x + 0.0036288039*ni.x;
	float x = 0.024135597*na.y + -0.04542887*nb.y + -0.04953123*nc.y + -0.0053452025*nd.y + -0.68761176*ne.y + -0.14826675*nf.y + -0.023273345*ng.y + 0.0069940654*nh.y + 0.0012266012*ni.y;
	float y = -0.02337356*na.z + 0.034824524*nb.z + -0.052677378*nc.z + -0.0016783525*nd.z + -0.025233837*ne.z + -0.022239193*nf.z + -0.0020268154*ng.z + 0.025603252*nh.z + -0.002237668*ni.z;
	float z = -0.00023191393*na.w + 0.0002701566*nb.w + 0.009119059*nc.w + 0.0056037884*nd.w + -0.106378235*ne.w + -0.027843285*nf.w + 0.007191847*ng.w + -0.037982292*nh.w + -0.023501761*ni.w;
	float o = s+t+u+v+w+x+y+z+0.029863132;
	s = -0.66817456*a.x + -0.17347263*b.x + 0.080370635*c.x + -1.775243*d.x + -1.9561555*e.x + 0.02470279*f.x + -5.9847964e-05*g.x + -1.3914839*h.x + -0.26987377*i.x;
	t = -0.4700984*a.y + -0.50769645*b.y + -0.045086645*c.y + 0.00030881853*d.y + -0.93926907*e.y + -0.3561231*f.y + -0.040285986*g.y + 0.0388076*h.y + -0.19906054*i.y;
	u = -0.37273812*a.z + 0.23507157*b.z + -0.037670404*c.z + 0.13803919*d.z + -0.26558334*e.z + -0.112284966*f.z + -0.12488504*g.z + 0.24608758*h.z + -0.21625374*i.z;
	v = 0.0014740598*a.w + 0.11752688*b.w + -0.064109504*c.w + 0.0066263312*d.w + 0.23817827*e.w + 0.012854009*f.w + 0.03952307*g.w + -0.035320062*h.w + 0.06463719*i.w;
	w = 0.08255567*na.x + 0.05223393*nb.x + 0.1343985*nc.x + 0.39146107*nd.x + 0.6095351*ne.x + 0.3864864*nf.x + 0.21635368*ng.x + 0.46070915*nh.x + 0.19115895*ni.x;
	x = 0.32835186*na.y + 0.040014826*nb.y + -0.13152607*nc.y + -0.8299666*nd.y + 0.48882028*ne.y + -0.07651838*nf.y + -0.16252832*ng.y + -0.538613*nh.y + -0.07108342*ni.y;
	y = 0.4021103*na.z + -0.09048767*nb.z + -0.115632*nc.z + 0.19079824*nd.z + 0.043100078*ne.z + 0.17494403*nf.z + -0.029845314*ng.z + -0.3444861*nh.z + 0.31939086*ni.z;
	z = 0.012830754*na.w + -0.00422419*nb.w + 0.12061506*nc.w + -0.036665943*nd.w + -0.035168063*ne.w + 0.07614391*nf.w + 0.059708446*ng.w + 0.025309797*nh.w + -0.0062844246*ni.w;
	float p = s+t+u+v+w+x+y+z+0.002471427;
	s = 0.20465308*a.x + 0.542538*b.x + -0.19668695*c.x + -0.46615118*d.x + -0.7388785*e.x + 0.1529125*f.x + -0.2751929*g.x + 0.6901443*h.x + 0.1376039*i.x;
	t = -0.017125504*a.y + 0.12224764*b.y + -0.08542459*c.y + -0.24185401*d.y + 0.47374752*e.y + -0.0033960456*f.y + 0.14010258*g.y + 0.028386783*h.y + -0.11714224*i.y;
	u = -0.23188816*a.z + 0.043953367*b.z + -0.16183634*c.z + 0.09362778*d.z + -0.09717627*e.z + -0.20605122*f.z + -0.12872243*g.z + -0.10989092*h.z + 0.057827067*i.z;
	v = -0.002244122*a.w + 0.09510225*b.w + -0.08434639*c.w + -0.040398773*d.w + 0.15733676*e.w + -0.060302224*f.w + -0.098776944*g.w + 0.07610583*h.w + -0.017036678*i.w;
	w = -0.20887235*na.x + -0.034263313*nb.x + -0.024945809*nc.x + 0.85824406*nd.x + 0.51730734*ne.x + 0.38317314*nf.x + -0.10828173*ng.x + -0.21163985*nh.x + -0.15301323*ni.x;
	x = -0.03789462*na.y + 0.03121076*nb.y + -0.12869243*nc.y + 0.1547663*nd.y + 0.31563655*ne.y + -0.31219396*nf.y + -0.08229911*ng.y + 0.0006357061*nh.y + 0.099844694*ni.y;
	y = 0.52138287*na.z + 0.012390004*nb.z + 0.21885982*nc.z + 0.38221806*nd.z + 0.29663363*ne.z + 0.41821536*nf.z + -0.1269795*ng.z + 0.21488404*nh.z + -0.06741776*ni.z;
	z = 0.0212839*na.w + 0.05015271*nb.w + 0.121716134*nc.w + 0.055636514*nd.w + -0.44407418*ne.w + 0.008133906*nf.w + 0.10648469*ng.w + 0.1383999*nh.w + 0.08884415*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.27760294;
	s = 0.4786117*a.x + 0.358807*b.x + -0.06828353*c.x + 0.3529208*d.x + -1.1123186*e.x + -0.19466123*f.x + -0.027625978*g.x + -0.63549286*h.x + 0.6956727*i.x;
	t = 0.26915464*a.y + 0.0823444*b.y + 0.023828594*c.y + -0.65952504*d.y + -1.1619157*e.y + -0.36460975*f.y + 0.46075603*g.y + 1.1788677*h.y + 0.2645987*i.y;
	u = 0.264061*a.z + 0.09876012*b.z + -0.15258524*c.z + -0.4519789*d.z + -0.3031103*e.z + 0.025894605*f.z + 0.06110853*g.z + 0.011523663*h.z + -0.23029587*i.z;
	v = 0.06102014*a.w + -0.0018368509*b.w + -0.04596994*c.w + 0.047891494*d.w + 0.038071867*e.w + -0.15030977*f.w + -0.10674307*g.w + 0.0449417*h.w + 0.08584883*i.w;
	w = -0.2798041*na.x + -0.01905936*nb.x + -0.00607432*nc.x + 0.23136932*nd.x + 0.31604388*ne.x + 0.3732394*nf.x + 0.33444604*ng.x + 0.26030633*nh.x + -0.19958955*ni.x;
	x = -0.32725465*na.y + 0.14851013*nb.y + 0.0063473266*nc.y + 1.0751069*nd.y + 2.0589304*ne.y + -0.081835136*nf.y + -0.29807976*ng.y + -0.6531924*nh.y + -0.533299*ni.y;
	y = 0.16828158*na.z + 0.2584582*nb.z + 0.3255441*nc.z + 0.073779166*nd.z + 0.85978925*ne.z + -0.04444849*nf.z + 0.29215494*ng.z + 0.36225298*nh.z + 0.5460576*ni.z;
	z = -0.0040158187*na.w + 0.09762142*nb.w + 0.024949705*nc.w + 0.010230338*nd.w + -0.27563623*ne.w + 0.023636622*nf.w + -0.23736711*ng.w + -0.036448788*nh.w + -0.006399815*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.3031631;
		
	return vec4(o, p, q, r);
}
//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN6
//!SAVE LUMAN7
//!COMPONENTS 4

#define L_tex LUMAN6_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = -0.058837105*a.x + -0.06594728*b.x + -0.120181195*c.x + -0.15464571*d.x + 1.7877747*e.x + -0.6247841*f.x + -0.42160726*g.x + -0.33591035*h.x + -0.11929968*i.x;
	float t = -0.04083831*a.y + 0.12604362*b.y + -0.22171828*c.y + -0.031979512*d.y + -0.35148853*e.y + 0.18371807*f.y + -0.18025142*g.y + -0.21343473*h.y + -0.17652942*i.y;
	float u = 0.1296916*a.z + -0.34561402*b.z + 0.15583903*c.z + -0.009572381*d.z + 0.24573243*e.z + 0.23531769*f.z + 0.043407425*g.z + 0.031191947*h.z + 0.05083483*i.z;
	float v = 0.041308045*a.w + 0.42653918*b.w + 0.057123598*c.w + 0.1467786*d.w + 0.084570505*e.w + 0.049585123*f.w + 0.07951087*g.w + 0.023403723*h.w + 0.058703538*i.w;
	float w = -0.29908794*na.x + -0.11057356*nb.x + -0.19249663*nc.x + -0.120062664*nd.x + -1.4294766*ne.x + 0.31442398*nf.x + 0.0059633995*ng.x + 0.2249554*nh.x + 0.08491458*ni.x;
	float x = -0.19419838*na.y + -0.17405464*nb.y + 0.054804742*nc.y + -0.1721043*nd.y + 1.0572225*ne.y + -0.17402618*nf.y + -0.010076491*ng.y + -0.18260245*nh.y + -0.07440039*ni.y;
	float y = -0.08780574*na.z + 0.21823792*nb.z + 0.042452354*nc.z + -0.4371129*nd.z + -1.1089542*ne.z + -0.9202084*nf.z + 0.23421216*ng.z + 0.3200002*nh.z + 0.16972181*ni.z;
	float z = -0.18576154*na.w + -0.9690735*nb.w + -0.438257*nc.w + -0.30590606*nd.w + -0.20159644*ne.w + -0.28393722*nf.w + -0.082253136*ng.w + -0.02268838*nh.w + 0.12528493*ni.w;
	float o = s+t+u+v+w+x+y+z+0.55023825;
	s = -0.51214135*a.x + 0.1587179*b.x + 0.305341*c.x + 0.05605032*d.x + 0.9423743*e.x + -0.4808295*f.x + 0.11528174*g.x + -0.14417756*h.x + 0.0129921865*i.x;
	t = -0.07586892*a.y + 0.24033594*b.y + 0.14581378*c.y + 0.26807228*d.y + 0.06457829*e.y + 0.08675401*f.y + 0.020429688*g.y + -0.07649382*h.y + 0.10409905*i.y;
	u = 0.106955506*a.z + -0.1377736*b.z + -0.19970961*c.z + 0.0904285*d.z + -0.28510383*e.z + -0.12552631*f.z + -0.045292355*g.z + 0.103908435*h.z + 0.05300471*i.z;
	v = -0.019068277*a.w + 0.34505695*b.w + 0.112522*c.w + -0.1256843*d.w + 0.16478562*e.w + 0.131798*f.w + -0.032958005*g.w + -0.07537802*h.w + -0.033006195*i.w;
	w = 0.06426005*na.x + -0.9773888*nb.x + -0.19099084*nc.x + -0.14661065*nd.x + 1.2671355*ne.x + 0.29711735*nf.x + 0.044925593*ng.x + -0.1830269*nh.x + 0.017887615*ni.x;
	x = 0.06334686*na.y + 0.098540165*nb.y + -0.033426896*nc.y + 0.020740842*nd.y + -0.27653226*ne.y + -0.081057064*nf.y + -0.054287493*ng.y + 0.1748596*nh.y + 0.071279585*ni.y;
	y = -0.37052953*na.z + -0.0927202*nb.z + 0.10979261*nc.z + -0.046625905*nd.z + 0.62244016*ne.z + 0.06752621*nf.z + -0.008467355*ng.z + -0.28500867*nh.z + -0.36461726*ni.z;
	z = -0.020395795*na.w + -0.27024668*nb.w + 0.11460854*nc.w + 0.28669026*nd.w + -0.10853164*ne.w + -0.18687932*nf.w + 0.104976*ng.w + -0.044547517*nh.w + -0.20245767*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.020145543;
	s = -0.21427825*a.x + 0.24354467*b.x + -0.18458553*c.x + 0.45293218*d.x + -0.09833768*e.x + -0.24275231*f.x + -0.2929853*g.x + -0.38809168*h.x + -0.14154571*i.x;
	t = -0.01905719*a.y + 0.105777286*b.y + -0.15444006*c.y + -0.11596759*d.y + -0.47393703*e.y + 0.46603683*f.y + -0.1404903*g.y + -0.0428205*h.y + -0.28013608*i.y;
	u = 0.119027026*a.z + -0.17662995*b.z + 0.019392667*c.z + 0.06876451*d.z + 0.14729378*e.z + -0.064709045*f.z + 0.06468247*g.z + 0.12282632*h.z + -0.03295381*i.z;
	v = 0.05555683*a.w + 0.27148938*b.w + 0.1483462*c.w + -0.018142568*d.w + 0.04831512*e.w + 0.082228415*f.w + 0.03016951*g.w + 0.041722942*h.w + 0.064237125*i.w;
	w = -0.1274535*na.x + -0.74423933*nb.x + 0.094309576*nc.x + -0.6064515*nd.x + -0.7374763*ne.x + -0.037755545*nf.x + 0.11237847*ng.x + 0.043476455*nh.x + 0.37125015*ni.x;
	x = -0.15306838*na.y + -0.073084116*nb.y + 0.045736372*nc.y + -0.0021994396*nd.y + 0.57814497*ne.y + -0.23400332*nf.y + -0.032077234*ng.y + -0.15969266*nh.y + -0.009385252*ni.y;
	y = -0.1314027*na.z + -0.010501284*nb.z + 0.06986638*nc.z + -0.37545362*nd.z + -0.62438697*ne.z + -0.7353602*nf.z + 0.0557151*ng.z + 0.0988044*nh.z + 0.2847317*ni.z;
	z = -0.17195743*na.w + -0.639232*nb.w + -0.3238178*nc.w + -0.082515515*nd.w + -0.19047117*ne.w + -0.45840627*nf.w + -0.015534327*ng.w + 0.009699336*nh.w + 0.05022438*ni.w;
	float q = s+t+u+v+w+x+y+z+-0.15954065;
	s = -0.10845235*a.x + 0.24572098*b.x + -0.06379948*c.x + -0.10001011*d.x + 0.13738203*e.x + 0.04018451*f.x + -0.071444474*g.x + 0.22664078*h.x + -0.02070635*i.x;
	t = -0.07616105*a.y + 0.23639366*b.y + -0.09321473*c.y + 0.19796714*d.y + -0.14075017*e.y + -0.0449301*f.y + 0.029756686*g.y + -0.09885688*h.y + 0.08356498*i.y;
	u = 0.06800984*a.z + -0.2931856*b.z + 0.100556076*c.z + -0.048377596*d.z + -0.1781981*e.z + 0.20730834*f.z + -0.050653838*g.z + -0.04698904*h.z + 0.05376993*i.z;
	v = -0.057300698*a.w + 0.3078168*b.w + -0.10591571*c.w + 0.074197516*d.w + 0.018544165*e.w + -0.055442665*f.w + 0.027493756*g.w + -0.057727467*h.w + -0.0016655796*i.w;
	w = -0.081195965*na.x + -0.08301429*nb.x + 0.040080633*nc.x + 0.12346547*nd.x + 0.18738393*ne.x + -0.03630349*nf.x + 0.037644714*ng.x + 0.06655326*nh.x + -0.20145845*ni.x;
	x = -0.0056442716*na.y + -0.05646837*nb.y + -0.029295942*nc.y + -0.12593834*nd.y + 0.14838746*ne.y + 0.07026047*nf.y + 0.018739218*ng.y + 0.025475666*nh.y + -0.060179282*ni.y;
	y = -0.17208712*na.z + 0.30523688*nb.z + -0.046919305*nc.z + 0.044572577*nd.z + 0.14609618*ne.z + -0.14204772*nf.z + 0.12861522*ng.z + 0.022710633*nh.z + -0.13174535*ni.z;
	z = 0.04883451*na.w + -0.18461144*nb.w + 0.030086063*nc.w + -0.042053822*nd.w + -0.0111156525*ne.w + 0.13287982*nf.w + -0.033152506*ng.w + -0.015516242*nh.w + 0.014659999*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.018601736;
		
	return vec4(o, p, q, r);
}


//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN7
//!SAVE LUMAN8
//!COMPONENTS 4

#define L_tex LUMAN7_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
		
	float s = 0.0043343515*a.x + 0.031900514*b.x + 0.02680601*c.x + 0.008120107*d.x + 0.12049021*e.x + 0.02749568*f.x + 0.026941638*g.x + 0.045876786*h.x + -0.01782276*i.x;
	float t = -0.008756276*a.y + 0.0073754247*b.y + -0.008660523*c.y + -0.021356458*d.y + 0.06971389*e.y + 0.012638647*f.y + 0.00094445737*g.y + -0.029716656*h.y + 0.009664455*i.y;
	float u = 0.023963265*a.z + -0.07385482*b.z + -0.008637229*c.z + 0.011912516*d.z + -0.11463661*e.z + -0.044297565*f.z + -0.03391417*g.z + -0.08568166*h.z + 0.0030300939*i.z;
	float v = -0.02145077*a.w + -0.027281249*b.w + -0.07125093*c.w + -0.014157959*d.w + -0.11553326*e.w + -0.24110094*f.w + -0.08401101*g.w + -0.17157026*h.w + -0.0044118585*i.w;
	float w = -0.0023835276*na.x + -0.02092952*nb.x + -0.019703476*nc.x + -0.00941571*nd.x + -0.10274844*ne.x + -0.0050635873*nf.x + -0.014229466*ng.x + -0.018546402*nh.x + 0.011970106*ni.x;
	float x = 0.011714406*na.y + -0.0131633775*nb.y + -0.032575697*nc.y + 0.015258186*nd.y + 0.019382585*ne.y + 0.032736704*nf.y + 0.00022378328*ng.y + 0.025328603*nh.y + -0.0068634544*ni.y;
	float y = -0.0059372336*na.z + 0.042804737*nb.z + 0.035751443*nc.z + 0.024954861*nd.z + 0.11153299*ne.z + 0.04162905*nf.z + -0.0015105935*ng.z + 0.08583687*nh.z + -0.020246334*ni.z;
	float z = 0.00062923395*na.w + -0.09963906*nb.w + -0.10948316*nc.w + -0.0023887279*nd.w + -0.15891573*ne.w + 0.078041255*nf.w + -0.0327718*ng.w + -0.06652081*nh.w + -0.14793763*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.15004753;
	s = -0.045950558*a.x + 0.08526373*b.x + 0.0015848293*c.x + 0.051914793*d.x + 0.4589526*e.x + 0.12101746*f.x + 0.14604174*g.x + -0.046519924*h.x + 0.037631262*i.x;
	t = 0.031554867*a.y + 0.10354585*b.y + 0.029392516*c.y + -0.09057631*d.y + 0.60485184*e.y + -0.21951634*f.y + 0.07822993*g.y + -0.13727486*h.y + 0.020326601*i.y;
	u = -0.24499135*a.z + 0.26627466*b.z + -0.030018428*c.z + 0.19534595*d.z + -1.0132202*e.z + -0.07760421*f.z + -0.08407245*g.z + 0.36748743*h.z + -0.023003025*i.z;
	v = -0.01961517*a.w + -0.5236786*b.w + -0.21719319*c.w + 0.13156417*d.w + 0.9680923*e.w + 0.7953026*f.w + -0.27221867*g.w + 0.5287818*h.w + -0.28001225*i.w;
	w = 0.041952703*na.x + -0.14607002*nb.x + 0.0115916515*nc.x + 0.071879886*nd.x + -0.49262965*ne.x + -0.2333565*nf.x + -0.14631014*ng.x + 0.20252785*nh.x + -0.047205925*ni.x;
	x = 0.41004127*na.y + -0.023229387*nb.y + 0.3145412*nc.y + -0.10125493*nd.y + -0.29814953*ne.y + -0.30311933*nf.y + 0.16076022*ng.y + 0.44950342*nh.y + 0.30537477*ni.y;
	y = 0.097353384*na.z + -0.2591137*nb.z + 0.10219444*nc.z + -0.10034551*nd.z + 1.0460515*ne.z + -0.027748754*nf.z + -0.049792234*ng.z + -0.18423916*nh.z + 0.039041415*ni.z;
	z = -0.07199283*na.w + 0.9118068*nb.w + -0.11371128*nc.w + -0.1457156*nd.w + -1.3157147*ne.w + 0.032120865*nf.w + 0.43028107*ng.w + -0.60653263*nh.w + -0.18424125*ni.w;
	float p = s+t+u+v+w+x+y+z+-0.21027789;
	s = 0.015061524*a.x + -0.042695962*b.x + -0.027390774*c.x + -0.021753458*d.x + -0.28389663*e.x + -0.087922245*f.x + -0.04256834*g.x + -0.07680529*h.x + 0.09721116*i.x;
	t = 0.03526287*a.y + -0.05655033*b.y + 0.011230106*c.y + 0.0505008*d.y + -0.31851402*e.y + 0.028345106*f.y + -0.00942657*g.y + -0.000914478*h.y + 0.01844695*i.y;
	u = -0.050099995*a.z + 0.1496227*b.z + 0.03834261*c.z + 0.058271393*d.z + 0.3408369*e.z + 0.05830523*f.z + 0.0609813*g.z + 0.21783021*h.z + -0.104018345*i.z;
	v = 0.00960184*a.w + 0.10341055*b.w + 0.07877837*c.w + 0.044007037*d.w + 0.85637236*e.w + 0.23916075*f.w + 0.10500761*g.w + 0.30397025*h.w + -0.17380545*i.w;
	w = -0.015112898*na.x + 0.018385632*nb.x + 0.014311772*nc.x + 0.011377564*nd.x + 0.26749414*ne.x + 0.06939789*nf.x + -0.0041372473*ng.x + 0.0898865*nh.x + -0.0643906*ni.x;
	x = -0.049965397*na.y + 0.09991889*nb.y + 0.019229416*nc.y + 0.007982338*nd.y + 0.19790286*ne.y + -0.15425439*nf.y + -0.012504278*ng.y + 0.013296758*nh.y + 0.059106532*ni.y;
	y = 0.03129402*na.z + -0.07959529*nb.z + -0.027276205*nc.z + -0.084852204*nd.z + -0.2994552*ne.z + -0.08323548*nf.z + 0.056710556*ng.z + -0.23716407*nh.z + 0.106749184*ni.z;
	z = 0.06815949*na.w + 0.09474177*nb.w + 0.11548853*nc.w + -0.07429912*nd.w + -0.81639*ne.w + -0.055724826*nf.w + 0.027693715*ng.w + -0.2331348*nh.w + 0.3457547*ni.w;
	float q = s+t+u+v+w+x+y+z+0.31094915;
	s = 0.0013066636*a.x + -0.014470875*b.x + 0.02128841*c.x + 0.07338732*d.x + 0.20127793*e.x + 0.011061661*f.x + 0.033728953*g.x + 0.0985754*h.x + -0.050257705*i.x;
	t = -0.031690102*a.y + 0.08306357*b.y + -0.032130457*c.y + -0.038631335*d.y + 0.12435732*e.y + -0.038088728*f.y + 0.0183084*g.y + 0.027007373*h.y + -0.035241753*i.y;
	u = 0.0022380766*a.z + -0.030015426*b.z + -0.017416682*c.z + -0.051282678*d.z + -0.06903824*e.z + 0.18370411*f.z + -0.007649599*g.z + 0.17488697*h.z + 0.021375295*i.z;
	v = -0.039706558*a.w + -0.18508846*b.w + -0.17433922*c.w + -0.019243676*d.w + 0.41235447*e.w + 0.5118561*f.w + -0.046311516*g.w + -0.049719848*h.w + -0.046298645*i.w;
	w = -0.00018484949*na.x + -0.027503032*nb.x + -0.0055394815*nc.x + -0.011507984*nd.x + -0.15373719*ne.x + -0.0014909318*nf.x + 0.021079242*ng.x + -0.0021839878*nh.x + 0.014581417*ni.x;
	x = 0.2559631*na.y + 0.20557807*nb.y + 0.17747739*nc.y + -0.0077582854*nd.y + -0.33705455*ne.y + -0.03593226*nf.y + 0.09016103*ng.y + 0.26824155*nh.y + 0.15681592*ni.y;
	y = -0.0006438971*na.z + -0.05665117*nb.z + -0.01930691*nc.z + 0.055304658*nd.z + 0.2226201*ne.z + -0.115618564*nf.z + -0.17851204*ng.z + 0.02309775*nh.z + -0.0020957827*ni.z;
	z = -0.12483319*na.w + 0.17680287*nb.w + 0.07221295*nc.w + -0.14756423*nd.w + -0.575894*ne.w + -0.5924514*nf.w + -0.18334259*ng.w + 0.21495773*nh.w + -0.28770602*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.14252092;
		
	return vec4(o, p, q, r);
}


//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-4x3x3x8
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN8
//!SAVE LUMAN9
//!COMPONENTS 4

#define L_tex LUMAN8_tex

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = L_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
	vec4 b = L_tex(HOOKED_pos + vec2(-dp.x, 0));
	vec4 c = L_tex(HOOKED_pos + vec2(-dp.x, dp.y));
	vec4 d = L_tex(HOOKED_pos + vec2(0, -dp.y));
	vec4 e = L_tex(HOOKED_pos + vec2(0, 0));
	vec4 f = L_tex(HOOKED_pos + vec2(0, dp.y));
	vec4 g = L_tex(HOOKED_pos + vec2(dp.x, -dp.y));
	vec4 h = L_tex(HOOKED_pos + vec2(dp.x, 0));
	vec4 i = L_tex(HOOKED_pos + vec2(dp.x, dp.y));
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);
	
	float s = 0.0045221616*a.x + 0.13361083*b.x + -0.10101074*c.x + -0.3104477*d.x + 0.014453704*e.x + 0.16743605*f.x + 0.42815346*g.x + -0.43762806*h.x + 0.13747907*i.x;
	float t = -0.0025087043*a.y + 0.034502532*b.y + -0.024045702*c.y + -0.06813702*d.y + 0.37240034*e.y + -0.048689447*f.y + -0.017587204*g.y + 0.07796901*h.y + -0.019994954*i.y;
	float u = -0.004463331*a.z + -0.04021734*b.z + -0.1710686*c.z + -0.3861281*d.z + -0.27769396*e.z + -0.17114232*f.z + 0.008659706*g.z + -0.13689534*h.z + -0.017564151*i.z;
	float v = -0.03719927*a.w + -0.060866248*b.w + -0.0005154834*c.w + 0.13105202*d.w + -0.4756373*e.w + 0.038031157*f.w + 0.007987142*g.w + -0.1287741*h.w + 0.0044731162*i.w;
	float w = -0.1588144*na.x + -0.17861399*nb.x + 0.20677862*nc.x + 0.27629393*nd.x + -0.8962142*ne.x + 0.08535742*nf.x + 0.1059245*ng.x + -0.21035257*nh.x + 0.12790036*ni.x;
	float x = 0.016721228*na.y + -0.043781657*nb.y + 0.0063481582*nc.y + 0.020839894*nd.y + -0.33675256*ne.y + 0.07076052*nf.y + -0.021649923*ng.y + 0.030575788*nh.y + 0.0031574676*ni.y;
	float y = -0.03249512*na.z + -0.059435222*nb.z + 0.019422397*nc.z + 0.060571607*nd.z + 0.51076144*ne.z + -0.11944391*nf.z + -0.18080437*ng.z + 0.13912733*nh.z + -0.03084553*ni.z;
	float z = -0.027890082*na.w + 0.074107096*nb.w + -0.025465522*nc.w + 0.052459516*nd.w + 0.35346648*ne.w + 0.0057676597*nf.w + -0.09199142*ng.w + 0.13720098*nh.w + -0.026844189*ni.w;
	float o = s+t+u+v+w+x+y+z+-0.07062165;
	s = -0.36914617*a.x + -0.387709*b.x + 0.24546379*c.x + -0.13407065*d.x + -1.3985281*e.x + -0.38215598*f.x + -0.4253273*g.x + -0.6018277*h.x + -0.1896727*i.x;
	t = 0.059232086*a.y + -0.03218242*b.y + 0.0854699*c.y + -0.0541505*d.y + -0.29609218*e.y + 0.11369224*f.y + 0.040713545*g.y + -0.0018869163*h.y + 0.006187881*i.y;
	u = -0.008775295*a.z + -0.5102556*b.z + 0.7375027*c.z + 0.072452776*d.z + -1.2024788*e.z + 0.46121085*f.z + 0.058012936*g.z + 0.18176034*h.z + 0.048703782*i.z;
	v = 0.044314258*a.w + 0.109136716*b.w + 0.01512838*c.w + 0.123235516*d.w + 0.012212226*e.w + -0.058148805*f.w + -0.037189372*g.w + 0.15093021*h.w + 0.1898863*i.w;
	w = 0.21549232*na.x + 0.65820724*nb.x + -0.48491365*nc.x + 0.42730922*nd.x + 1.6641526*ne.x + -0.65468395*nf.x + -0.023389338*ng.x + 0.814365*nh.x + -0.11903003*ni.x;
	x = -0.10621744*na.y + 0.028651522*nb.y + -0.03911892*nc.y + 0.2328494*nd.y + -0.79811394*ne.y + -0.07812101*nf.y + -0.0048260875*ng.y + -0.20159449*nh.y + 0.012622353*ni.y;
	y = 0.16155821*na.z + 0.17430165*nb.z + -0.11564172*nc.z + -0.09045215*nd.z + -0.17220502*ne.z + 0.033265576*nf.z + 0.19950038*ng.z + 0.15146245*nh.z + -0.0076287147*ni.z;
	z = -0.042550612*na.w + 0.52137315*nb.w + 0.17050217*nc.w + -0.30661416*nd.w + -0.7809509*ne.w + -0.4212841*nf.w + 0.20205358*ng.w + -0.030464187*nh.w + 0.0151808495*ni.w;
	float p = s+t+u+v+w+x+y+z+0.021308308;
	s = 0.13723312*a.x + -0.13058148*b.x + 0.02991709*c.x + 0.17664903*d.x + 0.80338216*e.x + -0.16452265*f.x + -0.52892923*g.x + 0.5847315*h.x + -0.13948771*i.x;
	t = -0.05281949*a.y + -0.013688717*b.y + 0.0066821994*c.y + 0.18340334*d.y + 0.17611703*e.y + 0.014302875*f.y + 0.027431076*g.y + -0.03286966*h.y + 0.00777125*i.y;
	u = -0.030233394*a.z + -0.1516942*b.z + 0.023113774*c.z + 0.5036234*d.z + 0.35019687*e.z + 0.083215944*f.z + -0.10124035*g.z + -0.4368648*h.z + -0.09983686*i.z;
	v = 0.08234885*a.w + -0.12858762*b.w + 0.011945575*c.w + -0.3161481*d.w + 0.73186344*e.w + -0.08109684*f.w + -0.068002164*g.w + -0.00015807863*h.w + -0.14903568*i.w;
	w = -0.01809736*na.x + 0.106148295*nb.x + -0.11458607*nc.x + -0.24150115*nd.x + 0.6235813*ne.x + 0.29316586*nf.x + -0.38179514*ng.x + 0.08143321*nh.x + 0.11211959*ni.x;
	x = 0.018066866*na.y + 0.00932761*nb.y + 0.020590544*nc.y + -0.19661997*nd.y + -0.1589172*ne.y + -0.024075199*nf.y + 0.037923746*ng.y + 0.075451836*nh.y + -0.016839966*ni.y;
	y = 0.01555148*na.z + 0.07518228*nb.z + 0.014010743*nc.z + 0.074753106*nd.z + 0.16666804*ne.z + -0.04246754*nf.z + 0.23196241*ng.z + -0.08842999*nh.z + 0.13125029*ni.z;
	z = -0.023343185*na.w + -0.011415688*nb.w + 0.13216138*nc.w + 0.0020203877*nd.w + -0.82738686*ne.w + 0.18328057*nf.w + 0.1155263*ng.w + 0.2484653*nh.w + 0.024372995*ni.w;
	float q = s+t+u+v+w+x+y+z+0.1330845;
	s = 0.058917314*a.x + -0.59722525*b.x + 0.1952677*c.x + -0.8540309*d.x + 1.8505293*e.x + -0.34204116*f.x + -0.90100527*g.x + 0.9598115*h.x + -0.6574991*i.x;
	t = -0.061550487*a.y + -0.041244105*b.y + 0.089612804*c.y + 0.274677*d.y + 0.20550548*e.y + 0.12090422*f.y + 0.07600108*g.y + 0.039211385*h.y + 0.0569241*i.y;
	u = 0.11367846*a.z + -1.2503271*b.z + 0.60662305*c.z + 0.80728525*d.z + -3.170348*e.z + 0.6594199*f.z + -0.32941318*g.z + -0.48758575*h.z + -0.23526128*i.z;
	v = 0.14170112*a.w + -0.39299014*b.w + 0.07595085*c.w + -0.36611298*d.w + -0.19472311*e.w + -0.25320992*f.w + -0.16693003*g.w + -0.08744426*h.w + -0.30629703*i.w;
	w = 0.23633157*na.x + 0.1263963*nb.x + -0.5513621*nc.x + -0.9526632*nd.x + 0.8599824*ne.x + -0.24109666*nf.x + -0.26302767*ng.x + -0.83445895*nh.x + 0.49014238*ni.x;
	x = 0.06461769*na.y + -0.09234017*nb.y + 0.0017150213*nc.y + -0.36574394*nd.y + 0.5042944*ne.y + -0.09363131*nf.y + 0.04096498*ng.y + 0.13416007*nh.y + -0.08434449*ni.y;
	y = 0.22188498*na.z + 0.22532557*nb.z + -0.16574928*nc.z + 0.298751*nd.z + 0.64085424*ne.z + -0.553648*nf.z + 0.43413857*ng.z + -0.08766077*nh.z + 0.27797157*ni.z;
	z = -0.14811756*na.w + 0.16666892*nb.w + 0.6009881*nc.w + -0.031475574*nd.w + 0.73704195*ne.w + -0.13920692*nf.w + 0.21735713*ng.w + 0.40883866*nh.w + 0.22915195*ni.w;
	float r = s+t+u+v+w+x+y+z+-0.11533214;
		
	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!BIND LUMAN1
//!BIND LUMAN2
//!BIND LUMAN3
//!BIND LUMAN4
//!BIND LUMAN5
//!BIND LUMAN6
//!BIND LUMAN7
//!BIND LUMAN8
//!BIND LUMAN9
//!SAVE LUMAN0
//!COMPONENTS 4

vec4 hook() {
	vec2 dp = HOOKED_pt;
	vec4 a = LUMAN1_tex(HOOKED_pos);
	vec4 b = LUMAN2_tex(HOOKED_pos);
	vec4 c = LUMAN3_tex(HOOKED_pos);
	vec4 d = LUMAN4_tex(HOOKED_pos);
	vec4 e = LUMAN5_tex(HOOKED_pos);
	vec4 f = LUMAN6_tex(HOOKED_pos);
	vec4 g = LUMAN7_tex(HOOKED_pos);
	vec4 h = LUMAN8_tex(HOOKED_pos);
	vec4 i = LUMAN9_tex(HOOKED_pos);
	
	vec4 na = -min(a, 0);
	vec4 nb = -min(b, 0);
	vec4 nc = -min(c, 0);
	vec4 nd = -min(d, 0);
	vec4 ne = -min(e, 0);
	vec4 nf = -min(f, 0);
	vec4 ng = -min(g, 0);
	vec4 nh = -min(h, 0);
	vec4 ni = -min(i, 0);
	
	a = max(a, 0);
	b = max(b, 0);
	c = max(c, 0);
	d = max(d, 0);
	e = max(e, 0);
	f = max(f, 0);
	g = max(g, 0);
	h = max(h, 0);
	i = max(i, 0);

	float o = -0.025345499*a.x + -0.0021511635*a.y + -0.01552223*a.z + 0.0030616536*a.w + 0.0032075346*na.x + 0.015554411*na.y + -0.016889228*na.z + -0.025014572*na.w + 0.0325229*b.x + -0.024351532*b.y + -0.008672373*b.z + 0.005590789*b.w + -0.020257758*nb.x + -0.018104428*nb.y + 0.005594391*nb.z + -0.0038329903*nb.w + 0.0383081*c.x + 0.0256335*c.y + -0.0046722684*c.z + 0.012396267*c.w + 0.0072566173*nc.x + -0.030656457*nc.y + -0.015092298*nc.z + -0.018772159*nc.w + -0.007535416*d.x + 0.006674194*d.y + 0.008633592*d.z + 0.0062616826*d.w + 0.008656795*nd.x + -0.068955205*nd.y + 0.02067291*nd.z + 0.007096046*nd.w + 0.01846029*e.x + 0.0638565*e.y + -0.00031000233*e.z + -9.5327276e-05*e.w + -0.029591039*ne.x + 0.03750348*ne.y + 0.006678989*ne.z + 0.014006669*ne.w + 0.008463897*f.x + 0.0070520015*f.y + 0.011277146*f.z + -0.0012753214*f.w + -0.023588767*nf.x + 0.004832184*nf.y + 0.034385283*nf.z + 0.008817432*nf.w + -0.07026202*g.x + -0.014893343*g.y + 0.06503661*g.z + 0.060461916*g.w + 0.073642954*ng.x + -0.039829027*ng.y + -0.069101036*ng.z + -0.05795985*ng.w + 0.19353457*h.x + -0.04431774*h.y + 0.14139234*h.z + 0.029222706*h.w + -0.13620058*nh.x + 0.1519176*nh.y + -0.11167681*nh.z + -0.007895559*nh.w + 0.16441825*i.x + 0.072630785*i.y + 0.07183864*i.z + -0.026890865*i.w + -0.26577094*ni.x + -0.06758755*ni.y + -0.16738161*ni.z + 0.05678283*ni.w + 0.05050823;
	float p = -0.026869139*a.x + 0.002010285*a.y + -0.016674858*a.z + 0.021867773*a.w + -0.0028898043*na.x + 0.010733717*na.y + -0.009715258*na.z + -0.011681211*na.w + 0.028584342*b.x + -0.034911852*b.y + -0.022455417*b.z + 0.0026852142*b.w + 0.001420245*nb.x + 0.004688186*nb.y + 0.0030484367*nb.z + -0.0011866139*nb.w + 0.027579257*c.x + -0.015300072*c.y + -0.0014369268*c.z + -0.023694385*c.w + 0.008272616*nc.x + 0.04187405*nc.y + -0.022349909*nc.z + 0.005638889*nc.w + 0.048093572*d.x + 0.014570987*d.y + 0.0094069885*d.z + 0.02643197*d.w + -0.023413727*nd.x + -0.018971106*nd.y + 0.009009003*nd.z + 0.02342026*nd.w + -0.08019369*e.x + -0.06362331*e.y + 0.019364605*e.z + -0.007610332*e.w + 0.0048531704*ne.x + 0.030215567*ne.y + -0.009395934*ne.z + -0.0039095255*ne.w + 0.029369153*f.x + 0.0009064993*f.y + 0.007748084*f.z + -0.0042151194*f.w + -0.012785969*nf.x + -4.0651157e-05*nf.y + -0.06834957*nf.z + -0.018293295*nf.w + 0.0041621197*g.x + 0.005473837*g.y + 0.011909403*g.z + 0.021833688*g.w + -0.00785828*ng.x + 0.046268523*ng.y + 0.0041527576*ng.z + -0.0073750536*ng.w + 0.051478274*h.x + 0.0048867916*h.y + 0.21436256*h.z + 0.0848831*h.w + 0.19794522*nh.x + -0.078197576*nh.y + -0.010980174*nh.z + -0.1313427*nh.w + 0.003084501*i.x + -0.03095605*i.y + -0.15071087*i.z + 0.049830485*i.w + -0.12544242*ni.x + 0.037474785*ni.y + 0.21824111*ni.z + -0.020350412*ni.w + 0.034696534;
	float q = -0.011473843*a.x + -0.008500929*a.y + -0.006225505*a.z + -0.06859053*a.w + -0.002649979*na.x + 0.0349027*na.y + 0.004008673*na.z + 0.010730329*na.w + 0.02279527*b.x + 0.011611871*b.y + 0.0053784857*b.z + -0.0014197611*b.w + -0.012508805*nb.x + -0.008713889*nb.y + 0.0055506355*nb.z + 0.0034218444*nb.w + 0.037574526*c.x + 0.018567413*c.y + 0.009479835*c.z + 0.0030985347*c.w + 0.012783179*nc.x + 0.03769012*nc.y + -0.022271728*nc.z + -0.022396212*nc.w + -0.023644615*d.x + -0.01713754*d.y + 0.036613688*d.z + -0.028280022*d.w + 0.01478604*nd.x + -0.047950666*nd.y + -0.028563306*nd.z + 0.01610751*nd.w + 0.18479255*e.x + 0.03375349*e.y + -0.006211228*e.z + 0.0013715967*e.w + -0.011906715*ne.x + -0.027515646*ne.y + -0.0014491043*ne.z + -0.010461221*ne.w + -0.027081*f.x + -0.00024475018*f.y + 0.0016701716*f.z + -0.0051322295*f.w + 0.08178321*nf.x + -0.0039486554*nf.y + 0.048087467*nf.z + 0.0062712957*nf.w + -0.0060339626*g.x + 0.01327678*g.y + -0.015740184*g.z + -0.04198038*g.w + 0.017990626*ng.x + -0.05803023*ng.y + 0.008065028*ng.z + 0.09840205*ng.w + 0.21650502*h.x + -0.044883523*h.y + 0.35736752*h.z + 0.13069746*h.w + -0.0055992976*nh.x + -0.0070668226*nh.y + -0.13867852*nh.z + -0.15813062*nh.w + 0.07502654*i.x + 0.037590154*i.y + -0.05456113*i.z + 0.04583868*i.w + -0.005933467*ni.x + -0.028233645*ni.y + 0.036081396*ni.z + -0.09075903*ni.w + 0.031019757;
	float r = -0.012266471*a.x + -0.01038637*a.y + -0.006403305*a.z + -0.061549455*a.w + -0.0020815514*na.x + 0.025403013*na.y + 0.0030878584*na.z + 0.025642337*na.w + 0.021623747*b.x + 0.025759231*b.y + 0.016868886*b.z + -0.011757056*b.w + 0.018949974*nb.x + -0.03879046*nb.y + -0.008584741*nb.z + 0.010319324*nb.w + 0.009948425*c.x + 0.053120364*c.y + 0.0014052548*c.z + 0.015825326*c.w + 0.0032175633*nc.x + -0.010692245*nc.y + -0.0076005645*nc.z + -0.052508987*nc.w + -0.009496796*d.x + 0.0066874796*d.y + 0.013183267*d.z + -0.017360926*d.w + 0.010480816*nd.x + -0.02319759*nd.y + 0.00336114*nd.z + 0.022330863*nd.w + 0.058043666*e.x + 0.08283237*e.y + 0.030803166*e.z + -0.0032534911*e.w + -0.03677484*ne.x + 0.03213852*ne.y + -0.018663544*ne.z + -0.012127*ne.w + -0.018157737*f.x + 0.009688269*f.y + 0.018519528*f.z + 0.0061194277*f.w + 0.007688681*nf.x + 0.004965012*nf.y + -0.06950929*nf.z + -0.024124136*nf.w + -0.06957238*g.x + -0.032947022*g.y + 0.07435419*g.z + 0.13112263*g.w + 0.055360015*ng.x + 0.05605465*ng.y + -0.076736465*ng.z + -0.14243616*ng.w + -0.11771925*h.x + 0.04998612*h.y + -0.13548268*h.z + 0.030703869*h.w + 0.110005826*nh.x + -0.09178284*nh.y + 0.15351678*nh.z + -0.05320431*nh.w + -0.15733768*i.x + -0.023674926*i.y + -0.13662882*i.z + 0.03777956*i.w + 0.24352121*ni.x + 0.05974571*ni.y + 0.13660003*ni.z + -0.06796056*ni.w + 0.0752347;

	return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(L)
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!WIDTH LUMA.w 2 *
//!HEIGHT LUMA.h 2 *


vec4 hook() {
	vec2 f = fract(LUMAN0_pos * LUMAN0_size);
	ivec2 i = ivec2(f * vec2(2));
	float c = LUMAN0_tex((vec2(0.5) - f) * LUMAN0_pt + LUMAN0_pos)[i.y * 2 + i.x];
	return vec4(c + HOOKED_tex(HOOKED_pos).x, HOOKED_tex(HOOKED_pos).yz, 0);
}
