//Anime4K v3.0 GLSL

// MIT License

// Copyright (c) 2019-2020 bloc97
// All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!SAVE LUMAN00

vec4 hook() {
    vec2 dp = HOOKED_pt;
    float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
    float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
    float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
    float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
    float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
    float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
    float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
    float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
    float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;
    float s = 0.4235461*a + 0.6575531*b + -0.59399563*c + 0.12646995*d + 0.0016557063*e + -0.39317647*f + -0.100805044*g + -0.18261948*h + 0.05910521*i + 0.0036176245;
    float t = 0.5664837*a + -0.39679363*b + -0.55953777*c + -0.32150665*d + -0.3936088*e + 0.37721646*f + -0.60057974*g + 0.4423712*h + 0.69548297*i + -0.019462775;
    float u = 0.7905936*a + -0.5065353*b + -0.084980056*c + -0.72207355*d + 0.5796332*e + -0.0633104*f + -0.07915572*g + -0.02368675*h + 0.10642056*i + -0.0021129327;
    float v = -0.33403575*a + 0.06273845*b + 0.15680763*c + 0.20368172*d + 0.46718*e + -0.09569307*f + -0.39521396*g + -0.6665878*h + -0.04230685*i + -0.06889051;
    return vec4(s, t, u, v);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x1
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!SAVE LUMAN01

vec4 hook() {
    vec2 dp = HOOKED_pt;
    float a = HOOKED_tex(HOOKED_pos + vec2(-dp.x, -dp.y)).x;
    float b = HOOKED_tex(HOOKED_pos + vec2(-dp.x, 0)).x;
    float c = HOOKED_tex(HOOKED_pos + vec2(-dp.x, dp.y)).x;
    float d = HOOKED_tex(HOOKED_pos + vec2(0, -dp.y)).x;
    float e = HOOKED_tex(HOOKED_pos + vec2(0, 0)).x;
    float f = HOOKED_tex(HOOKED_pos + vec2(0, dp.y)).x;
    float g = HOOKED_tex(HOOKED_pos + vec2(dp.x, -dp.y)).x;
    float h = HOOKED_tex(HOOKED_pos + vec2(dp.x, 0)).x;
    float i = HOOKED_tex(HOOKED_pos + vec2(dp.x, dp.y)).x;
    float s = 0.1510581*a + -0.33944955*b + 0.41192937*c + -0.5593376*d + -0.2621178*e + 0.20262389*f + 0.4376239*g + -0.094951846*h + -0.000841184*i + 0.0716263;
    float t = 0.098491974*a + -0.2960018*b + 0.3868153*c + -0.23705281*d + 0.4334124*e + -0.024507731*f + -0.015037636*g + -0.31689927*h + 0.31873173*i + 0.01124041;
    float u = 0.0766584*a + 0.5304577*b + -0.26359338*c + 0.12965855*d + -0.60080534*e + 0.27573597*f + 0.18143131*g + -0.94315463*h + 0.622251*i + 0.013815441;
    float v = -0.43200308*a + 0.621546*b + 0.2821124*c + -0.3073557*d + -0.23042628*e + 0.40253773*f + 0.10696488*g + -0.38473094*h + -0.1074526*i + 0.0901962;
    return vec4(s, t, u, v);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN00
//!BIND LUMAN01
//!SAVE LUMAN10

#define L0_tex LUMAN00_tex
#define L1_tex LUMAN01_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.16794677*a0.x + -0.22088864*b0.x + -0.1283413*c0.x + 0.35326216*d0.x + -0.2505379*e0.x + -0.035250086*f0.x + -0.0045629917*g0.x + -0.1302178*h0.x + 0.05232725*i0.x;
    float j = -0.15471086*a0.y + -0.18507053*b0.y + -0.06861622*c0.y + -0.05748694*d0.y + -0.08527682*e0.y + 0.018715255*f0.y + -0.07595843*g0.y + 0.031272165*h0.y + 0.07775021*i0.y;
    float k = -0.07023514*a0.z + 0.03369304*b0.z + 0.06894717*c0.z + 0.06823276*d0.z + 0.07589299*e0.z + -0.030963233*f0.z + 0.15168014*g0.z + 0.1776977*h0.z + 0.08588179*i0.z;
    float l = -0.2703367*a0.w + -0.14327289*b0.w + -0.19046761*c0.w + 0.23068829*d0.w + -0.19009744*e0.w + -0.22730376*f0.w + 0.0012157126*g0.w + 0.07482562*h0.w + 0.02318948*i0.w;
    float m = 0.012120285*a1.x + -0.22524278*b1.x + -0.190054*c1.x + -0.18266979*d1.x + 0.14826988*e1.x + 0.19927607*f1.x + 0.13757557*g1.x + 0.06252144*h1.x + 0.004383658*i1.x;
    float n = 0.14290562*a1.y + -0.14010437*b1.y + 0.17256533*c1.y + -0.00489204*d1.y + -0.55112445*e1.y + -0.19324628*f1.y + -0.20041578*g1.y + -0.29953226*h1.y + -0.093128584*i1.y;
    float o = 0.114136316*a1.z + -0.09969167*b1.z + -0.18182483*c1.z + 0.111348055*d1.z + 0.19055453*e1.z + -0.023537107*f1.z + 0.026970962*g1.z + 0.053700164*h1.z + -0.090746425*i1.z;
    float p = 0.18388204*a1.w + 0.1076922*b1.w + -0.10952749*c1.w + 0.047915682*d1.w + -0.04908849*e1.w + 0.13134465*f1.w + -0.010922534*g1.w + 0.093240745*h1.w + 0.10995429*i1.w;
    float q = -0.13068312*na0.x + 0.37798575*nb0.x + 0.07315507*nc0.x + -0.30374587*nd0.x + -0.027977318*ne0.x + 0.052229732*nf0.x + 0.22509663*ng0.x + 0.19470495*nh0.x + -0.023475593*ni0.x;
    float r = 0.17921193*na0.y + 0.15262721*nb0.y + 0.09348953*nc0.y + 0.08629486*nd0.y + 0.058778033*ne0.y + -0.049769867*nf0.y + 0.04349436*ng0.y + -0.019163493*nh0.y + -0.085440144*ni0.y;
    float s = -0.24993967*na0.z + -0.38155112*nb0.z + -0.06854216*nc0.z + -0.19560374*nd0.z + -0.13779017*ne0.z + -0.04520518*nf0.z + -0.2073175*ng0.z + 0.037903383*nh0.z + -0.08490066*ni0.z;
    float t = -0.053389367*na0.w + 0.077983424*nb0.w + 0.1866747*nc0.w + 0.06767585*nd0.w + 0.29341182*ne0.w + 0.015612053*nf0.w + -0.048845258*ng0.w + -0.06773192*nh0.w + 0.06828569*ni0.w;
    float u = -0.03143063*na1.x + 0.25195265*nb1.x + 0.2465402*nc1.x + 0.25821936*nd1.x + -0.21205051*ne1.x + -0.3031046*nf1.x + -0.064663626*ng1.x + -0.14141451*nh1.x + -0.049167875*ni1.x;
    float v = -0.22485651*na1.y + -0.030627564*nb1.y + -0.14952712*nc1.y + 0.07637464*nd1.y + 0.8533537*ne1.y + 0.10979076*nf1.y + 0.25307453*ng1.y + 0.36255696*nh1.y + 0.18161052*ni1.y;
    float w = 0.18741444*na1.z + 0.120343775*nb1.z + 0.17920719*nc1.z + 0.008429135*nd1.z + -0.18602121*ne1.z + 0.069860265*nf1.z + -0.07423891*ng1.z + -0.028029565*nh1.z + 0.0014492195*ni1.z;
    float x = -0.12813547*na1.w + -0.1251407*nb1.w + 0.10064979*nc1.w + -0.06593215*nd1.w + 0.08266265*ne1.w + -0.09072239*nf1.w + -0.03712963*ng1.w + -0.0380577*nh1.w + -0.1358046*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.08555427;
    i = -0.0106605785*a0.x + -0.02346621*b0.x + -0.025302485*c0.x + 0.42064977*d0.x + -0.3165855*e0.x + 0.1474086*f0.x + 0.002056423*g0.x + -0.3396167*h0.x + -0.20908986*i0.x;
    j = 0.085144304*a0.y + -0.025604391*b0.y + -0.09882538*c0.y + -0.16107202*d0.y + -0.0032053476*e0.y + 0.07671078*f0.y + -0.121254414*g0.y + -0.05503632*h0.y + 0.16113484*i0.y;
    k = -0.04301299*a0.z + 0.21927366*b0.z + 0.09128585*c0.z + -0.14557154*d0.z + -0.33144742*e0.z + 0.69390583*f0.z + 0.18670692*g0.z + 0.4288587*h0.z + 0.25589642*i0.z;
    l = 0.014806381*a0.w + -0.30577102*b0.w + -0.26680395*c0.w + 0.6580376*d0.w + 0.13689107*e0.w + 0.26344156*f0.w + 0.02003577*g0.w + 0.24800275*h0.w + 0.11940925*i0.w;
    m = -0.17510436*a1.x + -0.036337443*b1.x + -0.1621788*c1.x + 0.24176209*d1.x + 0.27377644*e1.x + 0.35164487*f1.x + -0.06084558*g1.x + 0.13541429*h1.x + 0.08383871*i1.x;
    n = -0.032581344*a1.y + -0.33266672*b1.y + -0.1254758*c1.y + 0.070055634*d1.y + -0.31106472*e1.y + -0.16749112*f1.y + 0.14661339*g1.y + -0.061245497*h1.y + -0.2153471*i1.y;
    o = -0.09507444*a1.z + 0.1633995*b1.z + 0.01893883*c1.z + 0.017567528*d1.z + 0.04895553*e1.z + -0.10323042*f1.z + -0.005264178*g1.z + -0.19580299*h1.z + -0.04270323*i1.z;
    p = -0.010821707*a1.w + 0.27088144*b1.w + 0.08854837*c1.w + 0.07468544*d1.w + -0.15011162*e1.w + 0.2767248*f1.w + -0.10650934*g1.w + 0.11232344*h1.w + -0.13245808*i1.w;
    q = -0.07898428*na0.x + 0.033453744*nb0.x + 0.17228787*nc0.x + -0.28074503*nd0.x + 0.2055687*ne0.x + -0.12419395*nf0.x + 0.099752426*ng0.x + 0.47015744*nh0.x + 0.18449554*ni0.x;
    r = -0.17434135*na0.y + 0.07637648*nb0.y + 0.110988095*nc0.y + 0.10198229*nd0.y + 0.095133536*ne0.y + -0.12944523*nf0.y + 0.113437034*ng0.y + 0.02337726*nh0.y + -0.16349663*ni0.y;
    s = 0.13760604*na0.z + -0.19821507*nb0.z + -0.11951691*nc0.z + 0.22723325*nd0.z + 0.51187444*ne0.z + -0.001953517*nf0.z + -0.23731533*ng0.z + -0.52571917*nh0.z + 0.028138466*ni0.z;
    t = 0.017788691*na0.w + 0.11692077*nb0.w + 0.04552704*nc0.w + -0.11863895*nd0.w + 0.7263193*ne0.w + 0.077140756*nf0.w + 0.006894849*ng0.w + -0.08404261*nh0.w + -0.15646511*ni0.w;
    u = 0.1712769*na1.x + 0.15116447*nb1.x + 0.124495275*nc1.x + -0.17404018*nd1.x + -0.35752162*ne1.x + -0.30307415*nf1.x + 0.1124137*ng1.x + -0.20265274*nh1.x + -0.17206767*ni1.x;
    v = 0.06449334*na1.y + 0.2783839*nb1.y + 0.029395351*nc1.y + -0.4473567*nd1.y + 0.37940356*ne1.y + 0.24877474*nf1.y + -0.26481625*ng1.y + -0.044119053*nh1.y + 0.34096232*ni1.y;
    w = 0.13477752*na1.z + -0.013630374*nb1.z + -0.13816717*nc1.z + 0.09557402*nd1.z + -0.0038175562*ne1.z + 0.14273618*nf1.z + 0.018297989*ng1.z + 0.27939084*nh1.z + 0.12599975*ni1.z;
    x = -0.071283296*na1.w + -0.20715164*nb1.w + -0.13858369*nc1.w + -0.029546877*nd1.w + 0.063970774*ne1.w + -0.18851285*nf1.w + 0.10951296*ng1.w + 0.014773112*nh1.w + 0.12096485*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.13808772;
    i = 0.08543486*a0.x + -0.06339528*b0.x + 0.08643516*c0.x + -0.16561024*d0.x + -0.124620974*e0.x + 0.5155396*f0.x + -0.36339906*g0.x + 0.22400329*h0.x + -0.14128657*i0.x;
    j = -0.29701614*a0.y + -0.079046*b0.y + 0.025680672*c0.y + -0.40005872*d0.y + -0.0026881134*e0.y + 0.12396565*f0.y + 0.28015617*g0.y + 0.19931334*h0.y + -0.13053301*i0.y;
    k = -0.018083062*a0.z + -0.2995659*b0.z + 0.12293853*c0.z + 0.39782542*d0.z + -0.08047593*e0.z + -0.00798882*f0.z + 0.19066185*g0.z + -0.4197668*h0.z + 0.41353148*i0.z;
    l = 0.2531281*a0.w + 0.20558453*b0.w + 0.12816961*c0.w + -0.40887693*d0.w + -0.75598484*e0.w + 0.67733926*f0.w + -0.17545569*g0.w + -0.09809934*h0.w + 0.38785964*i0.w;
    m = 0.32967457*a1.x + 0.037468296*b1.x + -0.07958115*c1.x + 0.22996488*d1.x + 0.29492065*e1.x + -0.029338673*f1.x + 0.014237537*g1.x + 0.18754248*h1.x + -0.08127657*i1.x;
    n = 0.040210586*a1.y + 0.34547487*b1.y + 0.27756944*c1.y + -0.11648041*d1.y + -0.66630447*e1.y + 0.3621801*f1.y + -0.52747697*g1.y + 0.108236276*h1.y + -0.23471309*i1.y;
    o = 0.30032736*a1.z + -0.18578514*b1.z + -0.0770958*c1.z + -0.34115535*d1.z + 0.07363463*e1.z + -0.058073323*f1.z + -0.045252394*g1.z + 0.12356456*h1.z + 0.28394222*i1.z;
    p = -0.116601326*a1.w + -0.14359862*b1.w + -0.08438345*c1.w + 0.13927905*d1.w + 0.37232953*e1.w + 0.3016352*f1.w + 0.469494*g1.w + -0.31357527*h1.w + 0.28242698*i1.w;
    q = -0.09050382*na0.x + -0.012025754*nb0.x + 0.11904028*nc0.x + 0.22277842*nd0.x + 0.511553*ne0.x + 0.0725231*nf0.x + 0.07063996*ng0.x + -0.13095577*nh0.x + -0.03559222*ni0.x;
    r = 0.32554454*na0.y + 0.057850234*nb0.y + -0.09855525*nc0.y + 0.50782645*nd0.y + -0.063144326*ne0.y + -0.036865633*nf0.y + -0.28869686*ng0.y + -0.18935527*nh0.y + 0.13458657*ni0.y;
    s = -0.09230108*na0.z + 0.42308152*nb0.z + 0.39727864*nc0.z + -0.5248546*nd0.z + -0.28623953*ne0.z + 0.57086474*nf0.z + -0.32816634*ng0.z + -0.330851*nh0.z + -0.91903055*ni0.z;
    t = -0.20520322*na0.w + 0.012853672*nb0.w + -0.018758446*nc0.w + -0.008448064*nd0.w + 0.46334872*ne0.w + 0.19974*nf0.w + 0.10137746*ng0.w + -0.16349177*nh0.w + -0.09975543*ni0.w;
    u = -0.37509602*na1.x + 0.0064346674*nb1.x + -0.07314594*nc1.x + -0.29104117*nd1.x + -0.3105957*ne1.x + -0.31734526*nf1.x + -0.28809702*ng1.x + -0.05734701*nh1.x + -0.08137321*ni1.x;
    v = 0.22592704*na1.y + -0.008293352*nb1.y + -0.13925971*nc1.y + 0.48756573*nd1.y + 0.7549005*ne1.y + -0.39747772*nf1.y + 0.17185897*ng1.y + 0.06366977*nh1.y + -0.28335187*ni1.y;
    w = -0.59168625*na1.z + 0.101777606*nb1.z + 0.4479166*nc1.z + 0.115051255*nd1.z + -0.1799079*ne1.z + 0.5368214*nf1.z + -0.16581482*ng1.z + -0.18885252*nh1.z + -0.07730688*ni1.z;
    x = 0.12536506*na1.w + 0.093024015*nb1.w + 0.11894012*nc1.w + -0.09191671*nd1.w + 0.024672559*ne1.w + -0.293548*nf1.w + -0.40645325*ng1.w + 0.33320007*nh1.w + -0.27361652*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.18878956;
    i = -0.17554133*a0.x + 0.08770128*b0.x + 0.1130292*c0.x + -0.11718522*d0.x + 0.34429708*e0.x + 0.11860599*f0.x + 0.061209697*g0.x + -0.03596431*h0.x + -0.15006644*i0.x;
    j = 0.34442133*a0.y + 0.18410078*b0.y + 0.10553784*c0.y + 0.083126865*d0.y + 0.26996818*e0.y + -0.057579536*f0.y + 0.08065425*g0.y + -0.038600635*h0.y + 0.1337284*i0.y;
    k = -0.07592328*a0.z + -0.10521636*b0.z + 0.047978353*c0.z + -0.18327633*d0.z + 0.8187111*e0.z + 0.1053916*f0.z + -0.051000945*g0.z + 0.032780662*h0.z + -0.24659613*i0.z;
    l = 0.11310651*a0.w + -0.72847044*b0.w + 0.14607516*c0.w + -0.0545269*d0.w + 0.33854204*e0.w + 0.477869*f0.w + 0.03370307*g0.w + 0.18669982*h0.w + 0.087542474*i0.w;
    m = 0.026408873*a1.x + 0.21242142*b1.x + 0.10273795*c1.x + 0.12721732*d1.x + 0.3051287*e1.x + -0.10380253*f1.x + 0.21183428*g1.x + 0.011781035*h1.x + -0.157168*i1.x;
    n = -0.31023848*a1.y + -0.12418054*b1.y + 0.06871101*c1.y + -0.055353377*d1.y + 0.29283622*e1.y + 0.0629144*f1.y + 0.10536345*g1.y + 0.005131209*h1.y + 0.01050696*i1.y;
    o = 0.21290451*a1.z + 0.13438411*b1.z + -0.18430226*c1.z + 0.043690648*d1.z + -0.083583824*e1.z + -0.08178097*f1.z + 0.009168952*g1.z + -0.093769684*h1.z + -0.074894816*i1.z;
    p = -0.009761168*a1.w + 0.13623533*b1.w + 0.19300689*c1.w + -0.18730181*d1.w + -0.03478467*e1.w + 0.302313*f1.w + 0.024195945*g1.w + -0.056365933*h1.w + 0.083279416*i1.w;
    q = 0.094621725*na0.x + -0.21166989*nb0.x + -0.13730079*nc0.x + 0.019476462*nd0.x + -0.32468584*ne0.x + -0.10870433*nf0.x + 0.06361098*ng0.x + 0.22786614*nh0.x + 0.016555896*ni0.x;
    r = -0.45527184*na0.y + -0.1840554*nb0.y + -0.11216771*nc0.y + -0.11387475*nd0.y + -0.28390703*ne0.y + 0.10614178*nf0.y + -0.086305596*ng0.y + 0.01007403*nh0.y + -0.086720556*ni0.y;
    s = 0.12321956*na0.z + 0.16506156*nb0.z + -0.03085585*nc0.z + 0.17304778*nd0.z + -0.41865125*ne0.z + -0.25131994*nf0.z + 0.015150618*ng0.z + 0.038200963*nh0.z + 0.21354003*ni0.z;
    t = -0.03856252*na0.w + 0.5171248*nb0.w + -0.16520032*nc0.w + 0.2699771*nd0.w + 0.02709677*ne0.w + -0.1288841*nf0.w + -0.007368464*ng0.w + 0.039352447*nh0.w + -0.06819223*ni0.w;
    u = -0.09914638*na1.x + -0.2402648*nb1.x + -0.044966992*nc1.x + -0.06250364*nd1.x + -0.43965408*ne1.x + 0.035948656*nf1.x + -0.19700348*ng1.x + 0.027183928*nh1.x + 0.12255059*ni1.x;
    v = 0.035281736*na1.y + -0.12445711*nb1.y + -0.11005861*nc1.y + -0.3244261*nd1.y + -0.03600395*ne1.y + 0.102474555*nf1.y + 0.0433403*ng1.y + -0.16804694*nh1.y + 0.1529647*ni1.y;
    w = 0.0015002415*na1.z + 0.01684284*nb1.z + 0.19736712*nc1.z + -0.033935662*nd1.z + 0.20540716*ne1.z + 0.025974788*nf1.z + 0.111514784*ng1.z + 0.13752428*nh1.z + 0.011327623*ni1.z;
    x = -0.14010908*na1.w + -0.07261111*nb1.w + -0.25126088*nc1.w + 0.1697692*nd1.w + -0.020014642*ne1.w + -0.105643414*nf1.w + 0.016477138*ng1.w + 0.03148673*nh1.w + -0.13972881*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.104817756;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN00
//!BIND LUMAN01
//!SAVE LUMAN11

#define L0_tex LUMAN00_tex
#define L1_tex LUMAN01_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.08353107*a0.x + 0.28736016*b0.x + 0.06043241*c0.x + 0.3756145*d0.x + -0.21849196*e0.x + -0.049966827*f0.x + 0.06684435*g0.x + -0.31316793*h0.x + -0.14380705*i0.x;
    float j = 0.17063656*a0.y + -0.062669165*b0.y + 0.08566759*c0.y + 0.02365466*d0.y + 0.04036862*e0.y + -0.05693226*f0.y + -0.03300663*g0.y + -0.24487613*h0.y + 0.21347883*i0.y;
    float k = -0.21652856*a0.z + -0.19351771*b0.z + -0.2467005*c0.z + -0.73068035*d0.z + -0.42616466*e0.z + -0.12823705*f0.z + -0.075517796*g0.z + 0.3647414*h0.z + 0.26326218*i0.z;
    float l = 0.4126963*a0.w + 0.2086867*b0.w + 0.5041759*c0.w + -0.243043*d0.w + -0.32740736*e0.w + 0.0022745235*f0.w + 0.19319366*g0.w + 0.049629156*h0.w + -0.12715256*i0.w;
    float m = -0.14272708*a1.x + -0.099596515*b1.x + -0.4202246*c1.x + 0.18351686*d1.x + -0.11177526*e1.x + -0.06569924*f1.x + 0.031184534*g1.x + 0.121226974*h1.x + -0.05880319*i1.x;
    float n = 0.04794056*a1.y + -0.095302925*b1.y + 0.039960325*c1.y + 0.26515916*d1.y + -0.18812327*e1.y + -0.018485704*f1.y + 0.19372816*g1.y + -0.15000892*h1.y + -0.0651102*i1.y;
    float o = 0.03567814*a1.z + 0.38550282*b1.z + -0.23689032*c1.z + 0.03756719*d1.z + 0.5521864*e1.z + 0.045050826*f1.z + -0.07008592*g1.z + -0.29005158*h1.z + -0.18711509*i1.z;
    float p = -0.1770443*a1.w + 0.13982445*b1.w + 0.40291548*c1.w + -0.10975701*d1.w + 0.3894214*e1.w + 0.56349623*f1.w + 0.22294973*g1.w + 0.102117985*h1.w + -0.05722196*i1.w;
    float q = -0.053553056*na0.x + -0.19602972*nb0.x + -0.049908735*nc0.x + -0.4098372*nd0.x + 0.1553083*ne0.x + -0.13798437*nf0.x + 0.020964932*ng0.x + 0.21640925*nh0.x + 0.17697215*ni0.x;
    float r = -0.17972371*na0.y + 0.11094383*nb0.y + -0.07758381*nc0.y + -0.06468317*nd0.y + 0.054030456*ne0.y + 0.08155672*nf0.y + 0.06632324*ng0.y + 0.20341587*nh0.y + -0.21935543*ni0.y;
    float s = 0.10066643*na0.z + -0.09760212*nb0.z + -0.21011324*nc0.z + 0.5705846*nd0.z + 0.34045073*ne0.z + -0.34776747*nf0.z + 0.05816446*ng0.z + 0.15500267*nh0.z + -0.06549823*ni0.z;
    float t = -0.113237955*na0.w + 0.07596917*nb0.w + -0.2689601*nc0.w + 0.06720722*nd0.w + 0.24187401*ne0.w + 0.06495155*nf0.w + -0.10120916*ng0.w + -0.015051687*nh0.w + 0.08580574*ni0.w;
    float u = 0.18368104*na1.x + 0.0067408364*nb1.x + 0.5401991*nc1.x + -0.28887546*nd1.x + 0.15580553*ne1.x + 0.13127*nf1.x + -0.02988204*ng1.x + -0.09457715*nh1.x + 0.031352654*ni1.x;
    float v = -0.16335279*na1.y + 0.121307105*nb1.y + -0.15070735*nc1.y + -0.066209905*nd1.y + 0.47985828*ne1.y + 0.23986837*nf1.y + -0.1174723*ng1.y + 0.10828484*nh1.y + 0.18975943*ni1.y;
    float w = 0.16884287*na1.z + -0.120039694*nb1.z + 0.15371844*nc1.z + -0.15169354*nd1.z + -0.43843856*ne1.z + -0.08414658*nf1.z + 0.09939408*ng1.z + 0.2920639*nh1.z + 0.14563619*ni1.z;
    float x = 0.19525896*na1.w + -0.07340261*nb1.w + -0.40502468*nc1.w + 0.12006268*nd1.w + -0.44480872*ne1.w + -0.39131236*nf1.w + -0.32856262*ng1.w + -0.12405321*nh1.w + -0.011340729*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.11855532;
    i = 0.27427614*a0.x + 0.06942368*b0.x + -0.34394878*c0.x + 0.015660247*d0.x + -0.07202456*e0.x + 0.17674516*f0.x + -0.37723058*g0.x + -0.06464191*h0.x + 0.29758364*i0.x;
    j = -0.5557797*a0.y + -0.5094059*b0.y + -0.05587837*c0.y + -0.35446486*d0.y + 0.030154578*e0.y + 0.296504*f0.y + -0.07820415*g0.y + 0.2622216*h0.y + 0.022169966*i0.y;
    k = 0.69592035*a0.z + 0.40577736*b0.z + 0.27399254*c0.z + 0.69817305*d0.z + 0.34048787*e0.z + -0.7022997*f0.z + 0.19809163*g0.z + -0.31440312*h0.z + -0.2537085*i0.z;
    l = 0.20212564*a0.w + 0.7220086*b0.w + 0.002391091*c0.w + 0.29846865*d0.w + -0.20860793*e0.w + 0.19008926*f0.w + 0.36558378*g0.w + -0.1705263*h0.w + 0.36423033*i0.w;
    m = -0.24980646*a1.x + -0.33889583*b1.x + -0.8488761*c1.x + 0.06502713*d1.x + -0.0033379206*e1.x + 0.62711746*f1.x + 0.111587234*g1.x + 0.47429568*h1.x + 0.13620043*i1.x;
    n = 0.02041788*a1.y + 0.25287375*b1.y + 0.22821611*c1.y + -0.019414136*d1.y + -0.45490053*e1.y + 0.15264598*f1.y + -0.342234*g1.y + 0.04632452*h1.y + 0.019633954*i1.y;
    o = 0.00159017*a1.z + -0.2284143*b1.z + -0.23702304*c1.z + -0.10418077*d1.z + -0.29623184*e1.z + -0.24214037*f1.z + 0.1672665*g1.z + 0.27197334*h1.z + 0.053051285*i1.z;
    p = 0.41270512*a1.w + 0.0030170777*b1.w + -0.2195157*c1.w + -0.25108942*d1.w + 0.05822611*e1.w + 0.22943507*f1.w + -0.21789554*g1.w + -0.24804015*h1.w + 0.1326624*i1.w;
    q = -0.13518767*na0.x + -0.097464286*nb0.x + 0.3898497*nc0.x + 0.08496002*nd0.x + 0.34897512*ne0.x + -0.11182062*nf0.x + 0.46268395*ng0.x + 0.027733872*nh0.x + -0.42308947*ni0.x;
    r = 0.56646675*na0.y + 0.5082163*nb0.y + 0.009196356*nc0.y + 0.38347927*nd0.y + -0.033876*ne0.y + -0.2798138*nf0.y + 0.08064149*ng0.y + -0.30561203*nh0.y + -0.028080948*ni0.y;
    s = -0.3202713*na0.z + 0.20401385*nb0.z + 0.26491576*nc0.z + -0.41670644*nd0.z + 0.30387732*ne0.z + 0.46047074*nf0.z + -0.2244506*ng0.z + -0.114643514*nh0.z + -0.20456*ni0.z;
    t = 0.08074196*na0.w + -0.39162296*nb0.w + 0.06135529*nc0.w + -0.22237217*nd0.w + 0.5211155*ne0.w + 0.089273445*nf0.w + -0.24561495*ng0.w + 0.20437199*nh0.w + -0.30850124*ni0.w;
    u = 0.3417056*na1.x + 0.49182546*nb1.x + 0.7867592*nc1.x + 0.11405216*nd1.x + -0.195181*ne1.x + -0.45771012*nf1.x + -0.081563495*ng1.x + -0.5275772*nh1.x + -0.07899438*ni1.x;
    v = -0.2075087*na1.y + -0.83008796*nb1.y + -0.24807826*nc1.y + 0.45271036*nd1.y + 0.46465632*ne1.y + -0.11798111*nf1.y + 0.35069796*ng1.y + -0.5051347*nh1.y + -0.07678797*ni1.y;
    w = -0.048510555*na1.z + 0.118899114*nb1.z + 0.3113541*nc1.z + 0.20021926*nd1.z + 0.34808552*ne1.z + 0.21785673*nf1.z + -0.07644035*ng1.z + -0.27205282*nh1.z + -0.09634399*ni1.z;
    x = -0.34171695*na1.w + 0.09623902*nb1.w + 0.15177064*nc1.w + 0.23439713*nd1.w + 0.005359915*ne1.w + -0.16126914*nf1.w + 0.2436929*ng1.w + 0.2693655*nh1.w + -0.10080733*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.05893463;
    i = 0.004456483*a0.x + -0.061023016*b0.x + 0.102604285*c0.x + 0.25974935*d0.x + -0.20572382*e0.x + 0.061911833*f0.x + -0.006440185*g0.x + -0.37464473*h0.x + -0.3729*i0.x;
    j = -0.024366496*a0.y + -0.26316297*b0.y + 0.0054109367*c0.y + -0.07425994*d0.y + 0.06885401*e0.y + -0.08147861*f0.y + -0.13024221*g0.y + -0.080083355*h0.y + 0.25079504*i0.y;
    k = 0.2073608*a0.z + 0.12756912*b0.z + -0.11947837*c0.z + 0.28547776*d0.z + -0.061251625*e0.z + -0.59111315*f0.z + 0.117697865*g0.z + 0.026501577*h0.z + 0.0762802*i0.z;
    l = 0.1538773*a0.w + 0.40656957*b0.w + 0.22812115*c0.w + 0.18197793*d0.w + -0.23915672*e0.w + -0.23416357*f0.w + 0.2286656*g0.w + 0.286252*h0.w + 0.14785512*i0.w;
    m = 0.11419092*a1.x + -0.0821377*b1.x + -0.34094295*c1.x + -0.07735428*d1.x + 0.24763437*e1.x + 0.07993605*f1.x + -0.15961358*g1.x + 0.25929016*h1.x + 0.03193567*i1.x;
    n = -0.19794407*a1.y + -0.06941228*b1.y + 0.34876403*c1.y + 0.061097983*d1.y + -0.46923164*e1.y + 0.27673528*f1.y + -0.024302537*g1.y + 0.024407104*h1.y + 0.21435632*i1.y;
    o = 0.058641165*a1.z + 0.0221897*b1.z + -0.3210071*c1.z + -0.27893165*d1.z + -0.067594975*e1.z + -0.06148374*f1.z + -0.08762428*g1.z + -0.4118411*h1.z + -0.35298195*i1.z;
    p = 0.25539416*a1.w + -0.22562106*b1.w + -0.04863095*c1.w + -0.21510895*d1.w + -0.015554503*e1.w + 0.021378404*f1.w + -0.18449734*g1.w + -0.33694598*h1.w + -0.07462068*i1.w;
    q = 0.060614746*na0.x + 0.058145523*nb0.x + -0.1876711*nc0.x + -0.2275418*nd0.x + 0.5676264*ne0.x + 0.03986006*nf0.x + 0.078224525*ng0.x + 0.32184383*nh0.x + 0.27731317*ni0.x;
    r = 0.10075902*na0.y + 0.27120215*nb0.y + 0.010115167*nc0.y + 0.17081438*nd0.y + -0.07218907*ne0.y + 0.1359228*nf0.y + 0.15724167*ng0.y + 0.18022752*nh0.y + -0.22473678*ni0.y;
    s = -0.24924998*na0.z + -0.09653091*nb0.z + 0.09842852*nc0.z + -0.22506349*nd0.z + -0.21285143*ne0.z + -0.23974708*nf0.z + -0.022973223*ng0.z + -0.12828088*nh0.z + -0.43499368*ni0.z;
    t = 0.068837054*na0.w + -0.10233581*nb0.w + -0.023833485*nc0.w + -0.013764958*nd0.w + 0.11303134*ne0.w + -0.10601694*nf0.w + -0.07437375*ng0.w + -0.12237613*nh0.w + -0.08480185*ni0.w;
    u = -0.09819356*na1.x + -0.018653207*nb1.x + 0.3962384*nc1.x + 0.11719601*nd1.x + -0.12368154*ne1.x + -0.1337247*nf1.x + 0.16457178*ng1.x + -0.1798564*nh1.x + 0.12946187*ni1.x;
    v = 0.14447375*na1.y + -0.18453734*nb1.y + -0.2785266*nc1.y + 0.261676*nd1.y + 0.43455735*ne1.y + -0.2976331*nf1.y + 0.44750854*ng1.y + -0.1517372*nh1.y + -0.16358607*ni1.y;
    w = 0.11880657*na1.z + -0.07722677*nb1.z + 0.5107066*nc1.z + 0.43152595*nd1.z + 0.04887373*ne1.z + 0.08405834*nf1.z + 0.09773806*ng1.z + 0.3092558*nh1.z + 0.31471527*ni1.z;
    x = -0.21641015*na1.w + 0.267585*nb1.w + 0.015544073*nc1.w + 0.26414764*nd1.w + 0.17490867*ne1.w + -0.10566998*nf1.w + 0.13985798*ng1.w + 0.08020897*nh1.w + 0.1375628*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.13600975;
    i = -0.077056326*a0.x + 0.056493748*b0.x + 0.050523862*c0.x + 0.025413549*d0.x + 0.05170877*e0.x + -0.06227649*f0.x + 0.023418976*g0.x + -0.26896232*h0.x + -0.19462766*i0.x;
    j = -0.092321195*a0.y + 0.28203773*b0.y + -0.28923175*c0.y + 0.26040012*d0.y + 0.18827046*e0.y + -0.08830989*f0.y + -0.1735084*g0.y + -0.20724946*h0.y + 0.050195698*i0.y;
    k = 0.18182454*a0.z + 0.1262915*b0.z + 0.32059082*c0.z + -0.09649511*d0.z + -0.05475635*e0.z + -0.08667132*f0.z + -0.082669996*g0.z + 0.013742665*h0.z + 0.28168282*i0.z;
    l = 0.005121575*a0.w + 0.08816379*b0.w + 0.023842517*c0.w + 0.1915638*d0.w + -0.18842512*e0.w + 0.3029226*f0.w + -0.00450142*g0.w + 0.061655905*h0.w + -0.17317536*i0.w;
    m = 0.05655378*a1.x + 0.045647632*b1.x + -0.23208252*c1.x + 0.1689679*d1.x + -0.06055369*e1.x + -0.010835976*f1.x + -0.14401563*g1.x + 0.24879168*h1.x + -0.059451584*i1.x;
    n = -0.06845674*a1.y + 0.083448485*b1.y + 0.06342751*c1.y + 0.19503595*d1.y + -0.24631637*e1.y + 0.024991803*f1.y + 0.5379571*g1.y + 0.2981694*h1.y + -0.18874584*i1.y;
    o = -0.23313029*a1.z + -0.12869471*b1.z + 0.2058894*c1.z + 0.056324985*d1.z + 0.5014833*e1.z + -0.14272012*f1.z + 0.04597481*g1.z + -0.07321104*h1.z + 0.036346544*i1.z;
    p = -0.20939653*a1.w + 0.039054863*b1.w + -0.009903461*c1.w + 0.039352827*d1.w + -0.3272497*e1.w + 0.16723883*f1.w + -0.22277309*g1.w + -0.15519314*h1.w + 0.106375985*i1.w;
    q = 0.15840702*na0.x + -0.012343732*nb0.x + -0.12434003*nc0.x + -0.050945174*nd0.x + 0.075114325*ne0.x + -0.08470733*nf0.x + -0.14440396*ng0.x + 0.28335252*nh0.x + 0.22015902*ni0.x;
    r = 0.1405543*na0.y + -0.32733896*nb0.y + 0.325749*nc0.y + -0.32933486*nd0.y + -0.24138382*ne0.y + 0.09864685*nf0.y + 0.16631408*ng0.y + 0.23151954*nh0.y + -0.018035514*ni0.y;
    s = -0.005933659*na0.z + -0.036268864*nb0.z + -0.2393363*nc0.z + 0.25365856*nd0.z + 0.27714846*ne0.z + 0.027788207*nf0.z + 0.105633155*ng0.z + -0.023569448*nh0.z + -0.11092802*ni0.z;
    t = -0.057706855*na0.w + -0.04314378*nb0.w + 0.1376379*nc0.w + -0.29201*nd0.w + -0.031740203*ne0.w + -0.21162407*nf0.w + -0.04941525*ng0.w + -0.09689754*nh0.w + 0.17491642*ni0.w;
    u = -0.045997567*na1.x + -0.004313898*nb1.x + 0.26557937*nc1.x + -0.10115272*nd1.x + 0.1497043*ne1.x + 0.0030241008*nf1.x + 0.22281039*ng1.x + -0.16505872*nh1.x + 0.17553228*ni1.x;
    v = 0.0372862*na1.y + -0.036076758*nb1.y + -0.1271902*nc1.y + -0.10472729*nd1.y + 0.5514008*ne1.y + -0.08602682*nf1.y + -0.39617947*ng1.y + -0.058530744*nh1.y + 0.20215146*ni1.y;
    w = 0.060919374*na1.z + -0.0063310824*nb1.z + -0.24551807*nc1.z + -0.18111996*nd1.z + -0.42163506*ne1.z + -0.0802586*nf1.z + -0.004400816*ng1.z + 0.06707879*nh1.z + -0.07458748*ni1.z;
    x = 0.23475559*na1.w + 0.008814685*nb1.w + 0.053149946*nc1.w + -0.039289605*nd1.w + 0.22436316*ne1.w + -0.18004929*nf1.w + 0.3210669*ng1.w + 0.16655089*nh1.w + -0.032627415*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.092078924;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!SAVE LUMAN20

#define L0_tex LUMAN10_tex
#define L1_tex LUMAN11_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.015673656*a0.x + -0.02099352*b0.x + 0.05503547*c0.x + -0.00073340687*d0.x + -0.121280506*e0.x + 0.29105297*f0.x + -0.03861604*g0.x + 0.075420655*h0.x + 0.083060674*i0.x;
    float j = -0.091996595*a0.y + 0.07510911*b0.y + -0.062198374*c0.y + 0.05949073*d0.y + -0.1820295*e0.y + 0.09697475*f0.y + 0.03708951*g0.y + -0.036565762*h0.y + -0.009997776*i0.y;
    float k = 0.03365902*a0.z + 0.024528746*b0.z + -0.07705728*c0.z + 0.015009792*d0.z + -0.026952326*e0.z + 0.057927553*f0.z + 0.011296611*g0.z + -0.05988774*h0.z + -0.07589114*i0.z;
    float l = -0.021712398*a0.w + 0.030812785*b0.w + -0.0710952*c0.w + -0.009192136*d0.w + 0.10309372*e0.w + -0.06865543*f0.w + 0.010613057*g0.w + -0.08165008*h0.w + -0.046066593*i0.w;
    float m = -0.008692918*a1.x + -0.06709967*b1.x + 0.018412719*c1.x + -0.10602186*d1.x + -0.14788082*e1.x + 0.07910418*f1.x + -0.042071406*g1.x + -0.03480511*h1.x + -0.17732185*i1.x;
    float n = 0.01920865*a1.y + -0.09064567*b1.y + 0.060349815*c1.y + 0.0017988305*d1.y + 0.024946429*e1.y + -0.10279574*f1.y + -0.06084332*g1.y + 0.08148241*h1.y + 0.049391948*i1.y;
    float o = -0.014042648*a1.z + 0.13778652*b1.z + -0.044523995*c1.z + 0.028905908*d1.z + -0.053008698*e1.z + 0.18101577*f1.z + 0.040709715*g1.z + -0.06592997*h1.z + 0.0137453135*i1.z;
    float p = 0.0147396345*a1.w + -0.05519722*b1.w + -0.06594861*c1.w + 0.006423891*d1.w + -0.3153246*e1.w + 0.06916029*f1.w + 0.1014631*g1.w + 0.15333757*h1.w + 0.02263975*i1.w;
    float q = -0.074357234*na0.x + -0.009763043*nb0.x + -0.11689638*nc0.x + -0.039435375*nd0.x + 0.119010925*ne0.x + -0.45772043*nf0.x + -0.007293864*ng0.x + -0.08986677*nh0.x + 0.00863173*ni0.x;
    float r = 0.031472135*na0.y + 0.04116749*nb0.y + -0.036898814*nc0.y + -0.03728472*nd0.y + 0.30707526*ne0.y + -0.19659965*nf0.y + -0.024439543*ng0.y + 0.025200637*nh0.y + -0.022478241*ni0.y;
    float s = 0.0038156274*na0.z + -0.061238572*nb0.z + 0.10164135*nc0.z + 0.0071307714*nd0.z + 0.09782806*ne0.z + -0.036823805*nf0.z + -0.051009785*ng0.z + -0.045252185*nh0.z + 0.008454376*ni0.z;
    float t = -0.0040852334*na0.w + 0.004206126*nb0.w + 0.056624953*nc0.w + 0.059114635*nd0.w + -0.05446261*ne0.w + 0.039389167*nf0.w + -0.10022764*ng0.w + 0.19637282*nh0.w + -0.015569797*ni0.w;
    float u = 0.040393475*na1.x + 0.09522407*nb1.x + -0.010178237*nc1.x + -0.03436084*nd1.x + 0.4680346*ne1.x + -0.07413823*nf1.x + 0.036522653*ng1.x + 0.026252978*nh1.x + 0.1363545*ni1.x;
    float v = 0.010021632*na1.y + 0.017375447*nb1.y + -0.07255486*nc1.y + -0.044482302*nd1.y + -0.1145225*ne1.y + -0.057170864*nf1.y + -0.0044367113*ng1.y + -0.084041774*nh1.y + -0.10282541*ni1.y;
    float w = -0.008224637*na1.z + -0.07302064*nb1.z + 0.08129463*nc1.z + 0.05966201*nd1.z + 0.19672397*ne1.z + -0.20587848*nf1.z + -0.020178175*ng1.z + -0.0015114375*nh1.z + -0.01026235*ni1.z;
    float x = 0.007066653*na1.w + -0.13657302*nb1.w + 0.08176532*nc1.w + 0.07563069*nd1.w + 0.17663209*ne1.w + -0.14801173*nf1.w + -0.19493645*ng1.w + 0.10676253*nh1.w + -0.05212441*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.034949664;
    i = -0.04030141*a0.x + -0.02292212*b0.x + 0.115096815*c0.x + -0.012690876*d0.x + 0.08087445*e0.x + 0.05919553*f0.x + 0.022237342*g0.x + 0.10526474*h0.x + -0.07153429*i0.x;
    j = -0.06611239*a0.y + -0.22464392*b0.y + 0.055294756*c0.y + -0.14041202*d0.y + 0.12165779*e0.y + 0.06812188*f0.y + -0.009226198*g0.y + 0.045144778*h0.y + 0.037657242*i0.y;
    k = -0.061883915*a0.z + -0.017648114*b0.z + 0.06447766*c0.z + -0.18309109*d0.z + 0.20868579*e0.z + 0.07306107*f0.z + 0.042334717*g0.z + 0.009320599*h0.z + -0.08148243*i0.z;
    l = -0.02177497*a0.w + 0.04437367*b0.w + 0.009073194*c0.w + -0.1485765*d0.w + -0.14565298*e0.w + -0.11893995*f0.w + 0.02053271*g0.w + 0.08995071*h0.w + 0.008549951*i0.w;
    m = -0.16447179*a1.x + 0.031375743*b1.x + -0.015620195*c1.x + -0.22476283*d1.x + 0.24823458*e1.x + -0.047999866*f1.x + -0.2514463*g1.x + 0.042610887*h1.x + 0.0812778*i1.x;
    n = 0.032238446*a1.y + 0.17415202*b1.y + -0.0054007177*c1.y + 0.075851046*d1.y + 0.046077635*e1.y + -0.14960578*f1.y + -0.05029922*g1.y + -0.11156724*h1.y + 0.036022555*i1.y;
    o = 0.015531561*a1.z + -0.212191*b1.z + -0.040764205*c1.z + -0.12781884*d1.z + 0.044870555*e1.z + -0.015441081*f1.z + 0.048236687*g1.z + 0.17973152*h1.z + -0.029533911*i1.z;
    p = -0.055784054*a1.w + -0.19721657*b1.w + 0.086148694*c1.w + -0.054337233*d1.w + 0.16613255*e1.w + 0.019707054*f1.w + 0.061197594*g1.w + -0.09649971*h1.w + -0.08844818*i1.w;
    q = 0.06738272*na0.x + -0.009395042*nb0.x + 0.017489811*nc0.x + -0.064345725*nd0.x + 0.03713633*ne0.x + -0.08849133*nf0.x + 0.014640531*ng0.x + 0.09498315*nh0.x + 0.0056702523*ni0.x;
    r = 0.22121245*na0.y + 0.056038234*nb0.y + -0.107978776*nc0.y + 0.096367195*nd0.y + -0.30045885*ne0.y + -0.0025898942*nf0.y + -0.031757444*ng0.y + -0.09654942*nh0.y + -0.023382347*ni0.y;
    s = 0.060906056*na0.z + 0.032286223*nb0.z + -0.027005702*nc0.z + 0.27080688*nd0.z + 0.076307185*ne0.z + 0.03645927*nf0.z + 0.11629662*ng0.z + 0.12386864*nh0.z + 0.028949413*ni0.z;
    t = 0.0182073*na0.w + -0.2043918*nb0.w + -0.02887608*nc0.w + 0.1769455*nd0.w + 0.085888594*ne0.w + 0.1660409*nf0.w + -0.034466684*ng0.w + -0.03382163*nh0.w + -0.0092838835*ni0.w;
    u = 0.099306785*na1.x + -0.1303775*nb1.x + 0.043936282*nc1.x + 0.17220032*nd1.x + -0.0056134374*ne1.x + -0.02121608*nf1.x + 0.04421245*ng1.x + 0.04001445*nh1.x + -0.07139496*ni1.x;
    v = -0.023696968*na1.y + -0.0729322*nb1.y + -0.022487238*nc1.y + 0.08815881*nd1.y + 0.007617644*ne1.y + 0.13980423*nf1.y + 0.18962389*ng1.y + 0.24695751*nh1.y + -0.0015834856*ni1.y;
    w = 0.077137835*na1.z + 0.09958312*nb1.z + -0.034727976*nc1.z + 0.11745516*nd1.z + -0.07195595*ne1.z + 0.008483939*nf1.z + -0.022856953*ng1.z + -0.056135558*nh1.z + 0.053542014*ni1.z;
    x = 0.14396225*na1.w + 0.0034367044*nb1.w + -0.049312852*nc1.w + 0.08469975*nd1.w + -0.15791649*ne1.w + 0.031535268*nf1.w + -0.04043745*ng1.w + 0.062251687*nh1.w + 0.06067408*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.024711853;
    i = 0.0664629*a0.x + 0.10692318*b0.x + -0.030991748*c0.x + 0.026725665*d0.x + -0.029399896*e0.x + 0.19930662*f0.x + 0.022686703*g0.x + 0.122738674*h0.x + 0.29318526*i0.x;
    j = 0.061199848*a0.y + 0.37346324*b0.y + 0.17881247*c0.y + 0.1309697*d0.y + -0.16666664*e0.y + 0.14824271*f0.y + -0.010173596*g0.y + 0.09238088*h0.y + -0.045568574*i0.y;
    k = 0.03038598*a0.z + 0.04836922*b0.z + -0.11428102*c0.z + -0.08397164*d0.z + -0.04179684*e0.z + -0.04103596*f0.z + -0.061901543*g0.z + -0.24047509*h0.z + -0.094810486*i0.z;
    l = 0.0057008374*a0.w + -0.089383446*b0.w + -0.0011578492*c0.w + 0.053484034*d0.w + 0.19560213*e0.w + -0.02209287*f0.w + 0.0682118*g0.w + -0.15668254*h0.w + -0.035337582*i0.w;
    m = 0.010179538*a1.x + -0.009926354*b1.x + -0.109158345*c1.x + 0.27797452*d1.x + -0.1501926*e1.x + -0.049379334*f1.x + 0.23668613*g1.x + 0.26095024*h1.x + 0.17412317*i1.x;
    n = 0.048617676*a1.y + -0.13061006*b1.y + -0.08699499*c1.y + 0.02437259*d1.y + -0.23905917*e1.y + 0.028373206*f1.y + -0.012324001*g1.y + 0.10831793*h1.y + 0.15613145*i1.y;
    o = -0.16202231*a1.z + 0.112338796*b1.z + 0.06859486*c1.z + 0.0040570013*d1.z + -0.17021316*e1.z + -0.20034729*f1.z + -0.12724905*g1.z + -0.12640756*h1.z + -0.16577214*i1.z;
    p = -0.11785086*a1.w + 0.15373552*b1.w + 0.02865212*c1.w + -0.07240135*d1.w + 0.09834478*e1.w + 0.23596184*f1.w + 0.03104167*g1.w + -0.11922373*h1.w + -0.06501047*i1.w;
    q = 0.038581338*na0.x + 0.09411416*nb0.x + -0.07578247*nc0.x + 0.039436612*nd0.x + 0.008611034*ne0.x + -0.06424503*nf0.x + 0.18458883*ng0.x + 0.24410121*nh0.x + 0.07844407*ni0.x;
    r = 0.18324456*na0.y + -0.12021226*nb0.y + -0.13208836*nc0.y + 0.09850728*nd0.y + 0.1699451*ne0.y + 0.14253475*nf0.y + 0.0015629302*ng0.y + -0.040416647*nh0.y + 0.08870965*ni0.y;
    s = -0.06539628*na0.z + -0.054774016*nb0.z + 0.036072135*nc0.z + 0.03065878*nd0.z + -0.048773237*ne0.z + -0.059441544*nf0.z + -0.13824742*ng0.z + -0.040871058*nh0.z + -0.0865028*ni0.z;
    t = -0.08315763*na0.w + 0.15382922*nb0.w + 0.024102645*nc0.w + -0.13100009*nd0.w + -0.08944311*ne0.w + 0.17389596*nf0.w + -0.06263836*ng0.w + 0.13482958*nh0.w + -0.021643665*ni0.w;
    u = -0.023210822*na1.x + 0.048466727*nb1.x + 0.063160636*nc1.x + 0.1562828*nd1.x + 0.07086501*ne1.x + 0.051311936*nf1.x + 0.0907613*ng1.x + 0.15781668*nh1.x + -0.084114805*ni1.x;
    v = -0.014547862*na1.y + 0.11834738*nb1.y + 0.07009007*nc1.y + 0.0065218625*nd1.y + 0.04465036*ne1.y + -0.20078123*nf1.y + -0.062787935*ng1.y + -0.23939967*nh1.y + -0.21409222*ni1.y;
    w = 0.088896476*na1.z + -0.08346275*nb1.z + -0.22665153*nc1.z + -0.1509825*nd1.z + -0.02430444*ne1.z + -0.03576661*nf1.z + -0.008432229*ng1.z + 0.10790929*nh1.z + 0.14536415*ni1.z;
    x = -0.058379993*na1.w + 0.059363015*nb1.w + -0.08000655*nc1.w + -0.11767427*nd1.w + 0.04934514*ne1.w + -0.015116642*nf1.w + 0.11867853*ng1.w + 0.06474982*nh1.w + 0.17333901*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.020185012;
    i = 0.030302616*a0.x + 0.012936507*b0.x + 0.0034298657*c0.x + 0.048076052*d0.x + -0.023669489*e0.x + -0.32370427*f0.x + 0.19902824*g0.x + 0.34311166*h0.x + -0.054156173*i0.x;
    j = -0.08579449*a0.y + -0.5084439*b0.y + -0.36801156*c0.y + 0.06661955*d0.y + -0.19014734*e0.y + -0.2399755*f0.y + 0.12736103*g0.y + -0.10410863*h0.y + 0.030177465*i0.y;
    k = -0.02324905*a0.z + -0.039416317*b0.z + 0.053991266*c0.z + -0.059502456*d0.z + 0.0958005*e0.z + 0.16579872*f0.z + -0.06434475*g0.z + -0.077372804*h0.z + -0.007644695*i0.z;
    l = 0.011956397*a0.w + -0.034856573*b0.w + 0.053423986*c0.w + 0.14070635*d0.w + 0.13123417*e0.w + 0.14346647*f0.w + 0.062868804*g0.w + -0.0454593*h0.w + 0.20762633*i0.w;
    m = -0.09791193*a1.x + -0.07366587*b1.x + 0.05572499*c1.x + 0.042659637*d1.x + 0.3969945*e1.x + -0.14020206*f1.x + 0.09684962*g1.x + 0.2450303*h1.x + -0.12085263*i1.x;
    n = 0.047850836*a1.y + 0.07184617*b1.y + 0.24567747*c1.y + 0.07264752*d1.y + -0.15156308*e1.y + 0.096985765*f1.y + -0.0642458*g1.y + 0.07803079*h1.y + -0.059010334*i1.y;
    o = -0.11122571*a1.z + -0.13089983*b1.z + -0.12985906*c1.z + -0.01955418*d1.z + -0.00661554*e1.z + -0.03197555*f1.z + -0.098977715*g1.z + -0.036374472*h1.z + 0.0061592176*i1.z;
    p = -0.15445514*a1.w + -0.073438495*b1.w + -0.05213208*c1.w + -0.10382142*d1.w + 0.02313335*e1.w + 0.13147756*f1.w + 0.1708675*g1.w + -0.14348018*h1.w + 0.015913507*i1.w;
    q = 0.008228371*na0.x + 0.18060881*nb0.x + -0.07841216*nc0.x + 0.082817584*nd0.x + 0.24217492*ne0.x + 0.22461349*nf0.x + 0.11344033*ng0.x + 0.17460021*nh0.x + 0.010574159*ni0.x;
    r = 0.0053345948*na0.y + 0.26769656*nb0.y + 0.24543934*nc0.y + -0.008411275*nd0.y + 0.07112208*ne0.y + 0.12919407*nf0.y + -0.114602774*ng0.y + 0.12264793*nh0.y + 0.059904482*ni0.y;
    s = 0.031678814*na0.z + 0.009786311*nb0.z + -0.00043090843*nc0.z + 0.051394574*nd0.z + -0.027239706*ne0.z + -0.13517226*nf0.z + -0.1504396*ng0.z + 0.017549086*nh0.z + 0.035983074*ni0.z;
    t = 0.04294746*na0.w + 0.030728973*nb0.w + -0.06257568*nc0.w + 0.03680996*nd0.w + -0.12803526*ne0.w + -0.16854705*nf0.w + 0.09934979*ng0.w + 0.12420867*nh0.w + -0.09642918*ni0.w;
    u = -0.13854499*na1.x + -0.08508567*nb1.x + -0.10403998*nc1.x + -0.14275831*nd1.x + -0.2893701*ne1.x + 0.10766267*nf1.x + -0.059306674*ng1.x + -0.008940202*nh1.x + 0.027810914*ni1.x;
    v = 0.10816545*na1.y + -0.035457894*nb1.y + -0.15443805*nc1.y + -0.041631605*nd1.y + -0.009998618*ne1.y + -0.024312135*nf1.y + -0.108551584*ng1.y + 0.019042801*nh1.y + 0.12016941*ni1.y;
    w = 0.032154717*na1.z + 0.029346332*nb1.z + 0.06843047*nc1.z + 0.07081246*nd1.z + -0.094431624*ne1.z + -0.008167981*nf1.z + 0.080870464*ng1.z + -0.047441497*nh1.z + -0.013129369*ni1.z;
    x = 0.06746627*na1.w + 0.2383694*nb1.w + -0.009648939*nc1.w + 0.34424412*nd1.w + -0.12228263*ne1.w + -0.014683395*nf1.w + -0.048362486*ng1.w + 0.20429887*nh1.w + 0.086006135*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.018327164;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!SAVE LUMAN21

#define L0_tex LUMAN10_tex
#define L1_tex LUMAN11_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.031572185*a0.x + -0.21954902*b0.x + -0.0015886037*c0.x + 0.015651193*d0.x + -0.091154985*e0.x + -0.018254288*f0.x + -0.21651629*g0.x + -0.3765238*h0.x + -0.19374359*i0.x;
    float j = -0.11055657*a0.y + 0.10585374*b0.y + -0.16947359*c0.y + -0.12919404*d0.y + -0.021268021*e0.y + -0.35808194*f0.y + -0.15131818*g0.y + -0.1534713*h0.y + -0.16522256*i0.y;
    float k = 0.022202993*a0.z + 0.13158104*b0.z + 0.02993379*c0.z + -0.065304205*d0.z + 0.1619402*e0.z + -0.08785627*f0.z + 0.07271879*g0.z + -0.027453387*h0.z + 0.03305999*i0.z;
    float l = -0.031789348*a0.w + 0.1364406*b0.w + -0.105685*c0.w + -0.0835975*d0.w + 0.24896793*e0.w + 0.23575991*f0.w + 0.034829173*g0.w + 0.2133406*h0.w + 0.23606575*i0.w;
    float m = 0.026959497*a1.x + 0.025455823*b1.x + 0.06471504*c1.x + -0.0917701*d1.x + -0.06036751*e1.x + 0.01769423*f1.x + -0.070855275*g1.x + -0.6317431*h1.x + -0.26277852*i1.x;
    float n = 0.04054354*a1.y + -0.018250944*b1.y + -0.029417658*c1.y + -0.058662474*d1.y + 0.13121347*e1.y + 0.014632146*f1.y + 0.032180488*g1.y + 0.08486894*h1.y + 0.10152975*i1.y;
    float o = 0.011421388*a1.z + 0.10503153*b1.z + -0.053112317*c1.z + 0.16231366*d1.z + 0.510692*e1.z + 0.061217006*f1.z + 0.10842525*g1.z + 0.023373902*h1.z + 0.112074*i1.z;
    float p = 0.055356618*a1.w + 0.24337149*b1.w + 0.09520685*c1.w + 0.01738178*d1.w + 0.24592605*e1.w + -0.10954584*f1.w + -0.12327179*g1.w + 0.22724484*h1.w + 0.014190379*i1.w;
    float q = -0.024113731*na0.x + 0.009835982*nb0.x + -0.10777386*nc0.x + -0.15397954*nd0.x + -0.09266727*ne0.x + -0.07481691*nf0.x + -0.008523596*ng0.x + -0.07305857*nh0.x + 0.24318755*ni0.x;
    float r = 0.11217226*na0.y + 0.05932721*nb0.y + -0.025799839*nc0.y + 0.14853054*nd0.y + 0.001339241*ne0.y + 0.08442375*nf0.y + 0.124774024*ng0.y + 0.097981855*nh0.y + -0.008815408*ni0.y;
    float s = 0.027524095*na0.z + -0.05636311*nb0.z + -0.03188364*nc0.z + 0.06141485*nd0.z + -0.079391986*ne0.z + 0.07785756*nf0.z + -0.0071809567*ng0.z + 0.03687449*nh0.z + -0.0442086*ni0.z;
    float t = 0.035764426*na0.w + -0.10056812*nb0.w + 0.02812691*nc0.w + 0.059040796*nd0.w + -0.14287305*ne0.w + -0.27596393*nf0.w + -0.1910503*ng0.w + -0.06406169*nh0.w + -0.3807643*ni0.w;
    float u = 0.11490726*na1.x + 0.08433622*nb1.x + -0.17036709*nc1.x + -0.005325759*nd1.x + 0.044904377*ne1.x + -0.039056204*nf1.x + 0.07262492*ng1.x + 0.13203709*nh1.x + 0.15060328*ni1.x;
    float v = -0.011916096*na1.y + -0.065864034*nb1.y + 0.13334328*nc1.y + 0.102103874*nd1.y + -0.10388749*ne1.y + 0.032959808*nf1.y + -0.06913139*ng1.y + -0.15625963*nh1.y + -0.10595022*ni1.y;
    float w = -0.022166956*na1.z + 0.10815417*nb1.z + 0.21165903*nc1.z + -0.13659082*nd1.z + 0.052216068*ne1.z + -0.06214634*nf1.z + -0.04564452*ng1.z + 0.030564032*nh1.z + -0.072751716*ni1.z;
    float x = -0.09017466*na1.w + 0.12638079*nb1.w + -0.12365812*nc1.w + 0.0103500765*nd1.w + -0.123947635*ne1.w + -0.09846554*nf1.w + -0.084648766*ng1.w + -0.04470046*nh1.w + 0.017418804*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.09885861;
    i = 0.090828754*a0.x + 0.096411645*b0.x + -0.15743771*c0.x + 0.08865681*d0.x + 0.10327069*e0.x + 0.2907515*f0.x + 0.035096664*g0.x + 0.138947*h0.x + 0.1427179*i0.x;
    j = -0.16812293*a0.y + 0.1728308*b0.y + 0.06070683*c0.y + -0.15704797*d0.y + -0.3200545*e0.y + -0.103168875*f0.y + 0.036229726*g0.y + -0.06575844*h0.y + 0.0054576118*i0.y;
    k = -0.029580152*a0.z + 0.032304466*b0.z + -0.0809943*c0.z + 0.030459069*d0.z + -0.084344*e0.z + 0.015767999*f0.z + -0.02092132*g0.z + 0.03526388*h0.z + 0.053177886*i0.z;
    l = 0.03594482*a0.w + 0.117228456*b0.w + 0.13116013*c0.w + 0.0047780536*d0.w + 0.1656387*e0.w + 0.10872266*f0.w + 0.118444785*g0.w + 0.115576595*h0.w + -0.015038535*i0.w;
    m = 0.04955351*a1.x + -0.03695812*b1.x + -0.077832796*c1.x + 0.11647708*d1.x + -0.041836414*e1.x + -0.055132084*f1.x + -0.009689516*g1.x + -0.11150424*h1.x + -0.11962264*i1.x;
    n = 0.006930824*a1.y + -0.01891034*b1.y + -0.095406644*c1.y + -0.0113957785*d1.y + -0.099846445*e1.y + 0.16559218*f1.y + -0.16096973*g1.y + -0.06362691*h1.y + 0.08387959*i1.y;
    o = -0.083899364*a1.z + 0.14254184*b1.z + -0.046050787*c1.z + 0.08787931*d1.z + -0.051230885*e1.z + -0.047911417*f1.z + -0.08292005*g1.z + 0.08841273*h1.z + 0.090280995*i1.z;
    p = -0.086902104*a1.w + -0.0024573256*b1.w + 0.078667*c1.w + 0.10535157*d1.w + -0.035453692*e1.w + -0.045311164*f1.w + -0.030063452*g1.w + 0.08216843*h1.w + -0.016280625*i1.w;
    q = 0.010650102*na0.x + 0.09113334*nb0.x + 0.06135689*nc0.x + -0.051896483*nd0.x + 0.015457821*ne0.x + 0.12674108*nf0.x + 0.087930046*ng0.x + -0.02034448*nh0.x + -0.07680683*ni0.x;
    r = 0.14385392*na0.y + -0.26780227*nb0.y + -0.031701945*nc0.y + 0.0868935*nd0.y + 0.04931676*ne0.y + 0.05209976*nf0.y + 0.029715285*ng0.y + 0.10936048*nh0.y + -0.023246985*ni0.y;
    s = -0.019656094*na0.z + -0.08280237*nb0.z + 0.06794925*nc0.z + -0.052385163*nd0.z + 0.018505935*ne0.z + -0.06555773*nf0.z + -0.054259684*ng0.z + -0.045448292*nh0.z + -0.02774003*ni0.z;
    t = 0.045591917*na0.w + 0.068767734*nb0.w + 0.037671242*nc0.w + 0.13044554*nd0.w + -0.18201542*ne0.w + -0.045410927*nf0.w + 0.090715006*ng0.w + -0.113842964*nh0.w + 0.02751698*ni0.w;
    u = -0.1091907*na1.x + -0.1165115*nb1.x + 0.0005568998*nc1.x + -0.22252907*nd1.x + 0.12667035*ne1.x + 0.008930634*nf1.x + 0.015448396*ng1.x + 0.021914594*nh1.x + 0.06726403*ni1.x;
    v = 0.100759745*na1.y + 0.008389446*nb1.y + 0.022286365*nc1.y + -0.028480763*nd1.y + 0.25048685*ne1.y + -0.30521858*nf1.y + -0.044158556*ng1.y + 0.16390778*nh1.y + -0.040408246*ni1.y;
    w = -0.056419935*na1.z + -0.25055963*nb1.z + -0.049138095*nc1.z + -0.19915849*nd1.z + -0.09285168*ne1.z + 0.066150635*nf1.z + -0.048173662*ng1.z + -0.2055458*nh1.z + -0.07158348*ni1.z;
    x = -0.2606289*na1.w + 0.016254561*nb1.w + -0.074577205*nc1.w + 0.04077225*nd1.w + 0.04064234*ne1.w + 0.014783259*nf1.w + 0.19851059*ng1.w + 0.011379637*nh1.w + 0.0639475*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.019597191;
    i = -0.020242073*a0.x + -0.05308193*b0.x + 0.18023895*c0.x + 0.08489619*d0.x + 0.083558254*e0.x + -0.07950611*f0.x + 0.17617436*g0.x + 0.17022839*h0.x + -0.070535906*i0.x;
    j = -0.008529808*a0.y + 0.07710499*b0.y + -0.09458898*c0.y + 0.025928719*d0.y + 0.02094489*e0.y + -0.13695501*f0.y + 0.031141782*g0.y + 0.0073337485*h0.y + 0.024863651*i0.y;
    k = -0.016425258*a0.z + -0.0120658*b0.z + 0.08000494*c0.z + 0.11181177*d0.z + -0.045137078*e0.z + 0.118886255*f0.z + -0.0037934526*g0.z + 0.007946874*h0.z + -0.07523597*i0.z;
    l = 0.1161145*a0.w + 0.11615834*b0.w + 0.03312487*c0.w + 0.010220156*d0.w + 0.10032188*e0.w + -0.06552804*f0.w + 0.07098567*g0.w + -0.031219715*h0.w + 0.14219265*i0.w;
    m = -0.07355923*a1.x + -0.124543294*b1.x + -0.11123776*c1.x + -0.04914004*d1.x + -0.13508037*e1.x + -0.08538037*f1.x + -0.019250447*g1.x + -0.08325892*h1.x + -0.08339272*i1.x;
    n = 0.03417587*a1.y + 0.025351161*b1.y + 0.10959054*c1.y + 0.027764061*d1.y + -0.34036496*e1.y + 0.07244361*f1.y + -0.006465673*g1.y + 0.10414523*h1.y + -0.010445836*i1.y;
    o = 0.004427069*a1.z + 0.09301199*b1.z + -0.059907075*c1.z + -0.11519208*d1.z + -0.1104757*e1.z + -0.023946041*f1.z + 0.032483287*g1.z + -0.094261475*h1.z + 0.019523932*i1.z;
    p = -0.12207462*a1.w + -0.05009648*b1.w + 0.22022372*c1.w + 0.26285815*d1.w + -0.39705196*e1.w + 0.2079559*f1.w + 0.029637828*g1.w + 0.14109252*h1.w + -0.15722114*i1.w;
    q = 0.12842292*na0.x + 0.040316265*nb0.x + -0.046668567*nc0.x + -0.1790541*nd0.x + 0.39654964*ne0.x + 0.10837263*nf0.x + -0.014433793*ng0.x + 0.058479983*nh0.x + 0.16391735*ni0.x;
    r = 0.029365534*na0.y + -0.29093117*nb0.y + -0.1335489*nc0.y + -0.09151678*nd0.y + 0.098561645*ne0.y + -0.099725164*nf0.y + -0.17893723*ng0.y + -0.052773494*nh0.y + -0.015666319*ni0.y;
    s = 0.047640108*na0.z + 0.08673376*nb0.z + -0.0078012454*nc0.z + 0.0575252*nd0.z + 0.28432444*ne0.z + -0.1002306*nf0.z + 0.09963052*ng0.z + 0.054946344*nh0.z + 0.100503296*ni0.z;
    t = -0.006640146*na0.w + -0.09308057*nb0.w + -0.0057282364*nc0.w + 0.14567396*nd0.w + 0.01839891*ne0.w + 0.12528877*nf0.w + 0.09085395*ng0.w + 0.2048081*nh0.w + -0.0076175393*ni0.w;
    u = -0.07017045*na1.x + 0.09735179*nb1.x + -0.07009357*nc1.x + 0.02023705*nd1.x + 0.218486*ne1.x + -0.024970353*nf1.x + -0.13825807*ng1.x + -0.04828522*nh1.x + -0.0057001337*ni1.x;
    v = 0.08126537*na1.y + -0.031536*nb1.y + 0.037959702*nc1.y + 0.20027067*nd1.y + 0.21129422*ne1.y + 0.1862494*nf1.y + 0.180125*ng1.y + 0.022476744*nh1.y + 0.05598345*ni1.y;
    w = 0.020886317*na1.z + -0.110396385*nb1.z + 0.10073255*nc1.z + 0.040812705*nd1.z + 0.014480216*ne1.z + -0.010606202*nf1.z + -0.041063044*ng1.z + 0.029324416*nh1.z + 0.01893235*ni1.z;
    x = -0.02117882*na1.w + 0.19071308*nb1.w + -0.1419392*nc1.w + -0.0527013*nd1.w + 0.07907033*ne1.w + -0.052748203*nf1.w + 0.08567526*ng1.w + -0.0592885*nh1.w + 0.20510149*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.029102495;
    i = -0.075755544*a0.x + -0.011345147*b0.x + -0.043020517*c0.x + -0.076325096*d0.x + -0.4086877*e0.x + -0.04542607*f0.x + -0.09695344*g0.x + -0.07378155*h0.x + 0.062268447*i0.x;
    j = -0.024231238*a0.y + 0.18943751*b0.y + 0.039547183*c0.y + 0.24655502*d0.y + 0.11322199*e0.y + 0.0040923445*f0.y + -0.030605817*g0.y + -0.029112251*h0.y + -0.092641145*i0.y;
    k = -0.06868489*a0.z + 0.093663774*b0.z + -0.05326381*c0.z + 0.20458257*d0.z + 0.080837764*e0.z + 0.049542785*f0.z + -0.07633304*g0.z + -0.079116225*h0.z + 0.02151533*i0.z;
    l = -0.16702063*a0.w + 0.03387102*b0.w + 0.128119*c0.w + -0.078100264*d0.w + -0.3766126*e0.w + -0.029631527*f0.w + -0.0036548837*g0.w + -0.003755168*h0.w + 0.032454517*i0.w;
    m = 0.004539345*a1.x + 0.035367977*b1.x + -0.024105042*c1.x + 0.042090166*d1.x + -0.122908995*e1.x + -0.013073632*f1.x + -0.0371632*g1.x + -0.14399377*h1.x + -0.11981582*i1.x;
    n = 0.094303235*a1.y + -0.089308694*b1.y + 0.10684167*c1.y + 0.04173341*d1.y + 0.013348961*e1.y + 0.0677585*f1.y + 0.1170188*g1.y + 0.28716058*h1.y + 0.08580711*i1.y;
    o = -0.10841774*a1.z + 0.011063079*b1.z + -0.0699171*c1.z + -0.020767417*d1.z + 0.32828206*e1.z + -0.04855068*f1.z + -0.04515191*g1.z + 0.032077674*h1.z + -0.052970123*i1.z;
    p = -0.11867851*a1.w + -0.15362826*b1.w + -0.08771901*c1.w + -0.16020527*d1.w + 0.076826505*e1.w + 0.086025305*f1.w + 0.043390036*g1.w + 0.10139997*h1.w + -0.0039536236*i1.w;
    q = -0.03787442*na0.x + 0.06320837*nb0.x + -0.033287127*nc0.x + -0.061944425*nd0.x + 0.031171579*ne0.x + 0.01694876*nf0.x + 0.046434026*ng0.x + -0.028421821*nh0.x + 0.09308639*ni0.x;
    r = -0.06541709*na0.y + 0.25386578*nb0.y + 0.0014157171*nc0.y + -0.10769748*nd0.y + -0.40667775*ne0.y + -0.14396338*nf0.y + -0.05874716*ng0.y + -0.03484261*nh0.y + 0.017493723*ni0.y;
    s = 0.21681505*na0.z + -0.034055233*nb0.z + 0.02617582*nc0.z + 0.038299404*nd0.z + 0.031072108*ne0.z + -0.06932048*nf0.z + 0.05036968*ng0.z + -0.06750086*nh0.z + 0.04094509*ni0.z;
    t = 0.08190957*na0.w + 0.15915425*nb0.w + 0.0131659405*nc0.w + 0.053403776*nd0.w + 0.34565467*ne0.w + 0.08184508*nf0.w + 0.13011171*ng0.w + -0.06749469*nh0.w + 0.046303164*ni0.w;
    u = 0.14052047*na1.x + -0.053244803*nb1.x + -0.18655081*nc1.x + 0.015175705*nd1.x + -0.44549644*ne1.x + -0.09666402*nf1.x + -0.07448092*ng1.x + -0.1022428*nh1.x + 0.10026984*ni1.x;
    v = -0.039204475*na1.y + 0.06170189*nb1.y + 0.06672028*nc1.y + 0.18241915*nd1.y + 0.0048539606*ne1.y + 0.31951326*nf1.y + 0.20582074*ng1.y + -0.31659672*nh1.y + 0.21938471*ni1.y;
    w = 0.23948088*na1.z + 0.37910646*nb1.z + 0.21267733*nc1.z + 0.1353376*nd1.z + -0.2806238*ne1.z + -0.1860066*nf1.z + -0.09305172*ng1.z + -0.041649293*nh1.z + -0.0153132705*ni1.z;
    x = -0.02297408*na1.w + 0.1199497*nb1.w + 0.04796784*nc1.w + -0.37305376*nd1.w + -0.16561341*ne1.w + -0.095281884*nf1.w + 0.07637466*ng1.w + -0.04438899*nh1.w + -0.050757162*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0019644105;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN20
//!BIND LUMAN21
//!SAVE LUMAN30

#define L0_tex LUMAN20_tex
#define L1_tex LUMAN21_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.10643633*a0.x + -0.036906414*b0.x + -0.1111053*c0.x + 0.25501183*d0.x + 0.014018466*e0.x + -0.061034296*f0.x + -0.00068537623*g0.x + -0.010772575*h0.x + 0.018131634*i0.x;
    float j = -0.026088478*a0.y + -0.21230131*b0.y + -0.003618772*c0.y + 0.0064307135*d0.y + -0.16586839*e0.y + -0.15548082*f0.y + 0.013893729*g0.y + -0.014476677*h0.y + 0.009556796*i0.y;
    float k = 0.0036814748*a0.z + 0.0072407345*b0.z + 0.027842285*c0.z + -0.044016458*d0.z + -0.0702261*e0.z + 0.09113725*f0.z + 0.07005032*g0.z + 0.18412821*h0.z + 0.058644623*i0.z;
    float l = 0.057065602*a0.w + 0.048588675*b0.w + -0.057245746*c0.w + 0.05475095*d0.w + 0.1420745*e0.w + 0.037316687*f0.w + -0.06891968*g0.w + -0.016110359*h0.w + -0.05803794*i0.w;
    float m = 0.038496323*a1.x + -0.03790667*b1.x + -0.025374807*c1.x + 0.043793097*d1.x + -0.2158214*e1.x + 0.023474434*f1.x + -0.023752023*g1.x + -0.01691174*h1.x + 0.015506258*i1.x;
    float n = -0.1361195*a1.y + -0.21140288*b1.y + -0.08454087*c1.y + -0.06148918*d1.y + -0.10822299*e1.y + -0.23093574*f1.y + -0.019948276*g1.y + -0.06194488*h1.y + -0.120892406*i1.y;
    float o = -0.049701612*a1.z + 0.1065619*b1.z + 0.016156977*c1.z + -0.045148958*d1.z + -0.06694894*e1.z + -0.0176919*f1.z + 0.03590984*g1.z + -0.17600913*h1.z + -0.036402546*i1.z;
    float p = -0.04690928*a1.w + -0.02835606*b1.w + -0.09638407*c1.w + 0.014927076*d1.w + 0.0034195676*e1.w + -0.05188964*f1.w + 0.100567654*g1.w + 0.11274578*h1.w + 0.01773749*i1.w;
    float q = -0.023610353*na0.x + 0.030650157*nb0.x + -0.05444737*nc0.x + 0.41447455*nd0.x + 0.5024452*ne0.x + 0.104963444*nf0.x + 0.30694106*ng0.x + 0.053822875*nh0.x + -0.09730409*ni0.x;
    float r = -0.028364167*na0.y + 0.13048097*nb0.y + 0.011416225*nc0.y + -0.04943442*nd0.y + -0.24018818*ne0.y + 0.07666743*nf0.y + -0.059948284*ng0.y + -0.19827667*nh0.y + -0.0049656746*ni0.y;
    float s = -0.05825712*na0.z + 0.066884935*nb0.z + 0.025379421*nc0.z + 0.08924984*nd0.z + -0.1867149*ne0.z + -0.1258125*nf0.z + -0.04889679*ng0.z + -0.057346914*nh0.z + 0.017777069*ni0.z;
    float t = 0.0036332337*na0.w + -0.016131833*nb0.w + -0.016359037*nc0.w + 0.0092720445*nd0.w + -0.16337238*ne0.w + -0.13277072*nf0.w + 0.036498047*ng0.w + -0.052755818*nh0.w + 0.018927759*ni0.w;
    float u = -0.1815154*na1.x + -0.087429486*nb1.x + -0.017911742*nc1.x + -0.10084511*nd1.x + -0.04621298*ne1.x + -0.14156355*nf1.x + -0.05798644*ng1.x + -0.22305803*nh1.x + -0.009415597*ni1.x;
    float v = 0.16611154*na1.y + 0.106082186*nb1.y + 0.08782764*nc1.y + 0.03455289*nd1.y + 0.010741922*ne1.y + 0.062042207*nf1.y + -0.16904944*ng1.y + 0.22352377*nh1.y + 0.04690581*ni1.y;
    float w = 0.07852161*na1.z + 0.0013620722*nb1.z + 0.038907528*nc1.z + 0.3628306*nd1.z + 0.011874221*ne1.z + -0.04687281*nf1.z + -0.26009414*ng1.z + 0.2499944*nh1.z + 0.068138845*ni1.z;
    float x = 0.048991237*na1.w + 0.010137228*nb1.w + 0.09121104*nc1.w + 0.050308313*nd1.w + -0.100869745*ne1.w + 0.09473232*nf1.w + 0.062941894*ng1.w + -0.12540334*nh1.w + -0.019815128*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.028611533;
    i = 0.041587368*a0.x + 0.01827282*b0.x + -0.013873069*c0.x + -0.24341245*d0.x + -0.27286956*e0.x + -0.039693765*f0.x + 0.09158187*g0.x + 0.07718322*h0.x + -0.04822146*i0.x;
    j = -0.077187955*a0.y + 0.053837564*b0.y + 0.043846983*c0.y + 0.05413649*d0.y + -0.14214621*e0.y + -0.06885113*f0.y + 0.0663552*g0.y + 0.095145516*h0.y + -0.061877612*i0.y;
    k = -0.019598985*a0.z + -0.036677573*b0.z + -0.09773802*c0.z + -0.25499588*d0.z + 0.04864643*e0.z + -0.04847572*f0.z + -0.026475035*g0.z + -0.01951032*h0.z + -0.06544461*i0.z;
    l = 0.03859847*a0.w + 0.1137901*b0.w + -0.04948835*c0.w + 0.1557564*d0.w + -0.10947979*e0.w + 0.015548971*f0.w + 0.22057895*g0.w + -0.040277276*h0.w + -0.07086392*i0.w;
    m = 0.03145267*a1.x + -0.025462307*b1.x + -0.0463051*c1.x + -0.074188426*d1.x + 0.029483223*e1.x + -0.031941865*f1.x + 0.007561021*g1.x + -0.04342986*h1.x + 0.017778557*i1.x;
    n = -0.034897916*a1.y + 0.079400115*b1.y + 0.019503072*c1.y + 0.11235732*d1.y + -0.026031071*e1.y + -0.09676807*f1.y + -0.1779691*g1.y + 0.17168868*h1.y + -0.1402981*i1.y;
    o = -0.03698885*a1.z + 0.027295057*b1.z + 0.08494035*c1.z + -0.16241463*d1.z + 0.18817148*e1.z + 0.0069888486*f1.z + 0.10624407*g1.z + 0.08390974*h1.z + 0.0999854*i1.z;
    p = -0.079902805*a1.w + 0.054902624*b1.w + 0.03831344*c1.w + -0.01018791*d1.w + 0.105503865*e1.w + -0.0045422777*f1.w + -0.08551547*g1.w + 0.014839678*h1.w + -0.0042692786*i1.w;
    q = 0.14067799*na0.x + 0.053378116*nb0.x + 0.04058857*nc0.x + 0.17887895*nd0.x + 0.12430842*ne0.x + 0.15898004*nf0.x + 0.11768944*ng0.x + -0.037185024*nh0.x + 0.009110197*ni0.x;
    r = 0.086276785*na0.y + 0.027156599*nb0.y + 0.014366527*nc0.y + -0.12710768*nd0.y + 0.41335082*ne0.y + 0.22516267*nf0.y + 0.06087766*ng0.y + -0.16419986*nh0.y + 0.07734832*ni0.y;
    s = -0.16815056*na0.z + 0.108973786*nb0.z + -0.008016018*nc0.z + 0.060010143*nd0.z + -0.03355337*ne0.z + 0.1301468*nf0.z + -0.1348207*ng0.z + 0.046151087*nh0.z + 0.015409749*ni0.z;
    t = -0.014207295*na0.w + -0.04218836*nb0.w + 0.0067676282*nc0.w + -0.17053707*nd0.w + 0.08037372*ne0.w + -0.0058613042*nf0.w + -0.06331095*ng0.w + 0.10058814*nh0.w + 0.030210534*ni0.w;
    u = -0.11319795*na1.x + 0.029488392*nb1.x + -0.010583512*nc1.x + -0.114965856*nd1.x + -0.023316355*ne1.x + 0.062252164*nf1.x + -0.03523979*ng1.x + -0.013047221*nh1.x + -0.0053103394*ni1.x;
    v = 0.05976406*na1.y + 0.022942819*nb1.y + 0.04437112*nc1.y + -0.22688077*nd1.y + 0.045486756*ne1.y + 0.07254583*nf1.y + 0.06141088*ng1.y + 0.028864142*nh1.y + 0.1240949*ni1.y;
    w = 0.13044041*na1.z + -0.2329393*nb1.z + -0.0382236*nc1.z + 0.07264846*nd1.z + -0.12195677*ne1.z + -0.017324021*nf1.z + 0.121612154*ng1.z + 0.047399193*nh1.z + -0.13527565*ni1.z;
    x = 0.059934974*na1.w + -0.1111012*nb1.w + 0.030002043*nc1.w + -0.023710279*nd1.w + 0.17099407*ne1.w + 0.08030319*nf1.w + 0.0016157839*ng1.w + -0.18830262*nh1.w + 0.08394579*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.001321388;
    i = 0.071545444*a0.x + 0.32496607*b0.x + 0.15365659*c0.x + 0.121577024*d0.x + -0.17505717*e0.x + 0.16289195*f0.x + -0.0648079*g0.x + 0.15859945*h0.x + 0.032257058*i0.x;
    j = 0.011973064*a0.y + -0.16694728*b0.y + -0.056336023*c0.y + -0.0011007001*d0.y + 0.17363375*e0.y + 0.181033*f0.y + -0.008971892*g0.y + 0.019856619*h0.y + 0.059345547*i0.y;
    k = 0.0052531324*a0.z + 0.14736383*b0.z + 0.048309688*c0.z + 0.041148175*d0.z + -0.19401208*e0.z + -0.020993957*f0.z + 0.062306486*g0.z + -0.08399667*h0.z + 0.016625507*i0.z;
    l = -0.020745479*a0.w + 0.12733771*b0.w + 0.057055835*c0.w + 0.024295107*d0.w + 0.21874963*e0.w + 0.20513003*f0.w + 0.057991862*g0.w + 0.07877612*h0.w + 0.05527445*i0.w;
    m = 0.021244286*a1.x + 0.015290164*b1.x + -0.03950085*c1.x + -0.046619404*d1.x + -0.08696681*e1.x + -0.054744504*f1.x + 0.038519688*g1.x + -0.13894098*h1.x + -0.036025655*i1.x;
    n = -0.091958016*a1.y + -0.05390509*b1.y + 0.022566987*c1.y + 0.061428353*d1.y + -0.075702526*e1.y + 0.32732865*f1.y + -0.0007603688*g1.y + 0.12742408*h1.y + 0.0932513*i1.y;
    o = 0.07413146*a1.z + -0.043927237*b1.z + 0.099399686*c1.z + -0.06604147*d1.z + -0.13035367*e1.z + -0.23295024*f1.z + 0.04786522*g1.z + -0.07348675*h1.z + -0.03825064*i1.z;
    p = 0.052928247*a1.w + -0.09133611*b1.w + 0.061273582*c1.w + -0.0039093695*d1.w + 0.07333901*e1.w + 0.058747426*f1.w + -0.061208177*g1.w + 0.03055871*h1.w + -0.04453164*i1.w;
    q = -0.019145327*na0.x + 0.23282546*nb0.x + 0.078314364*nc0.x + -0.06364767*nd0.x + -0.105903655*ne0.x + -0.20121083*nf0.x + 0.06118902*ng0.x + -0.22779615*nh0.x + -0.074413195*ni0.x;
    r = 0.056243785*na0.y + 0.30475444*nb0.y + 0.35658857*nc0.y + 0.00036167758*nd0.y + -0.091504164*ne0.y + -0.13814391*nf0.y + -0.03528659*ng0.y + 0.11410796*nh0.y + 0.108269215*ni0.y;
    s = 0.058173932*na0.z + -0.0920868*nb0.z + 0.047370248*nc0.z + 0.022357361*nd0.z + 0.1056848*ne0.z + 0.12012219*nf0.z + -0.030601367*ng0.z + 0.13887161*nh0.z + -0.10589772*ni0.z;
    t = 0.018066294*na0.w + -0.13855995*nb0.w + -0.04259209*nc0.w + -0.061554506*nd0.w + -0.11533582*ne0.w + -0.25060752*nf0.w + -0.047970247*ng0.w + 0.113073446*nh0.w + -0.055563718*ni0.w;
    u = 0.04350478*na1.x + -0.02057861*nb1.x + 0.082972564*nc1.x + 0.09450377*nd1.x + -0.020292157*ne1.x + -0.019516591*nf1.x + -0.067337714*ng1.x + 0.13866435*nh1.x + 0.03235949*ni1.x;
    v = -0.009059243*na1.y + 0.10090246*nb1.y + 0.08752086*nc1.y + -0.0017559788*nd1.y + 0.115805514*ne1.y + 0.002917317*nf1.y + -0.017110765*ng1.y + -0.01419701*nh1.y + -0.0636791*ni1.y;
    w = -0.11286448*na1.z + -0.067641154*nb1.z + -0.14130938*nc1.z + 0.06486227*nd1.z + 0.036358926*ne1.z + 0.14507468*nf1.z + 0.010521049*ng1.z + 0.09771575*nh1.z + 0.071096644*ni1.z;
    x = -0.0063579637*na1.w + 0.0074052885*nb1.w + -0.094562985*nc1.w + -0.025548384*nd1.w + -0.3769633*ne1.w + -0.28372648*nf1.w + 0.06836641*ng1.w + -0.17378987*nh1.w + -0.04446821*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.030421099;
    i = 0.03630972*a0.x + 0.03523327*b0.x + -0.08293865*c0.x + -0.21982624*d0.x + 0.36658382*e0.x + 0.09405754*f0.x + -0.0765099*g0.x + -0.017510056*h0.x + 0.024932105*i0.x;
    j = 0.029382393*a0.y + 0.0074663917*b0.y + -0.08808589*c0.y + -0.122646965*d0.y + -0.31578365*e0.y + -0.05433889*f0.y + 0.05131103*g0.y + 0.05232373*h0.y + -0.02975889*i0.y;
    k = 0.07101219*a0.z + 0.120809495*b0.z + -0.02234444*c0.z + -0.023502193*d0.z + 0.21097527*e0.z + -0.19294956*f0.z + 0.010837906*g0.z + 0.01842376*h0.z + 0.025430828*i0.z;
    l = 0.11364191*a0.w + 0.1905141*b0.w + -0.0011817712*c0.w + 0.31210938*d0.w + 0.25006205*e0.w + 0.030226331*f0.w + 0.13784334*g0.w + 0.2281184*h0.w + 0.26303968*i0.w;
    m = 0.20311864*a1.x + 0.046665657*b1.x + 0.08734007*c1.x + 0.20788254*d1.x + -0.3129463*e1.x + -0.1034487*f1.x + 0.044930696*g1.x + 0.06827188*h1.x + 0.0077128126*i1.x;
    n = -0.15269807*a1.y + -0.24423297*b1.y + -0.16777211*c1.y + -0.117007636*d1.y + -0.6073*e1.y + 0.111332096*f1.y + -0.3006221*g1.y + 0.05876093*h1.y + 0.038046006*i1.y;
    o = -0.0153901735*a1.z + -0.024091184*b1.z + 0.10764487*c1.z + -0.021961832*d1.z + 0.22035132*e1.z + 0.09268526*f1.z + 0.085437834*g1.z + -0.08049326*h1.z + -0.06466641*i1.z;
    p = -0.05375048*a1.w + -0.03399916*b1.w + -0.058176164*c1.w + -0.07561558*d1.w + -0.061255652*e1.w + -0.097357504*f1.w + -0.11741467*g1.w + -0.061670892*h1.w + -0.07436903*i1.w;
    q = 0.071051694*na0.x + 0.1814416*nb0.x + 0.22951497*nc0.x + 0.1546238*nd0.x + -0.019326491*ne0.x + -0.05573559*nf0.x + 0.016983688*ng0.x + 0.06897233*nh0.x + 0.008648969*ni0.x;
    r = -0.014931178*na0.y + -0.06446547*nb0.y + 0.063605614*nc0.y + 0.08041688*nd0.y + 0.25108832*ne0.y + -0.31870738*nf0.y + -0.02379586*ng0.y + -0.08481717*nh0.y + -0.0016163252*ni0.y;
    s = -0.032453634*na0.z + -0.041135035*nb0.z + -0.06835738*nc0.z + 0.025102768*nd0.z + -0.26983768*ne0.z + -0.2279373*nf0.z + 0.03183848*ng0.z + -0.15011281*nh0.z + 0.09245014*ni0.z;
    t = 0.02049012*na0.w + 0.014409927*nb0.w + -0.053820163*nc0.w + -0.06857825*nd0.w + 0.049533352*ne0.w + -0.0059399894*nf0.w + 0.06423862*ng0.w + -0.1422229*nh0.w + -0.101355284*ni0.w;
    u = -0.07012918*na1.x + 0.01263355*nb1.x + -0.051622722*nc1.x + -0.17590354*nd1.x + 0.28435645*ne1.x + -0.008795671*nf1.x + -0.04458566*ng1.x + -0.060899705*nh1.x + -0.0025370463*ni1.x;
    v = 0.098538294*na1.y + 0.17665358*nb1.y + 0.09652097*nc1.y + 0.08301102*nd1.y + 0.14594017*ne1.y + 0.1076866*nf1.y + 0.018559845*ng1.y + 0.008664722*nh1.y + 0.19314465*ni1.y;
    w = -0.0036817864*na1.z + 0.028279642*nb1.z + -0.07943624*nc1.z + 0.29500982*nd1.z + -0.25036684*ne1.z + -0.25631368*nf1.z + -0.07839792*ng1.z + 0.18605448*nh1.z + 0.01258324*ni1.z;
    x = -0.00030955416*na1.w + -0.11364831*nb1.w + -0.031985335*nc1.w + -0.067054465*nd1.w + -0.07023549*ne1.w + -0.24119556*nf1.w + 0.088734835*ng1.w + -0.10806103*nh1.w + -0.08079391*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.006313841;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN20
//!BIND LUMAN21
//!SAVE LUMAN31

#define L0_tex LUMAN20_tex
#define L1_tex LUMAN21_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.082612395*a0.x + -0.049185723*b0.x + 0.007860312*c0.x + -0.07619104*d0.x + -0.061066628*e0.x + -0.234122*f0.x + -0.025663877*g0.x + -0.09894433*h0.x + -0.08856901*i0.x;
    float j = 0.028992495*a0.y + 0.060103714*b0.y + 0.070344836*c0.y + 0.029064424*d0.y + 0.07586566*e0.y + 0.51010346*f0.y + 0.017292246*g0.y + 0.002633715*h0.y + 0.11349569*i0.y;
    float k = -0.06872372*a0.z + -0.016517969*b0.z + 0.0826774*c0.z + -0.093704216*d0.z + -0.0106905*e0.z + 0.16762802*f0.z + -0.0033384203*g0.z + -0.032237183*h0.z + 0.043032877*i0.z;
    float l = 0.024126578*a0.w + -0.06437252*b0.w + 0.04205709*c0.w + -0.0033347043*d0.w + -0.40628058*e0.w + -0.08603576*f0.w + 0.10561821*g0.w + 0.06512041*h0.w + -0.09332843*i0.w;
    float m = -0.07182272*a1.x + -0.09454206*b1.x + 0.061906293*c1.x + 0.026286539*d1.x + -0.39927563*e1.x + 0.008726781*f1.x + 0.0005037006*g1.x + -0.069342464*h1.x + -0.11110182*i1.x;
    float n = -0.012922981*a1.y + 0.16917652*b1.y + 0.07799769*c1.y + 0.023201788*d1.y + 0.2626289*e1.y + 0.0018231489*f1.y + -0.08402095*g1.y + -0.12002021*h1.y + 0.054342803*i1.y;
    float o = 0.025521107*a1.z + 0.06767924*b1.z + -0.04768362*c1.z + 0.0024316174*d1.z + 0.06449517*e1.z + -0.095331565*f1.z + -0.1276331*g1.z + 0.08763754*h1.z + -0.082404226*i1.z;
    float p = 0.003203677*a1.w + 0.14995256*b1.w + -0.03622031*c1.w + 0.00857825*d1.w + -0.14085086*e1.w + 0.26847202*f1.w + 0.05867755*g1.w + 0.036008976*h1.w + 0.051128622*i1.w;
    float q = -0.013764248*na0.x + -0.07657615*nb0.x + -0.10106088*nc0.x + -0.085903384*nd0.x + -0.6161812*ne0.x + -0.021359652*nf0.x + -0.015972499*ng0.x + -0.08998824*nh0.x + -0.17376873*ni0.x;
    float r = -0.0006796045*na0.y + 0.05056079*nb0.y + 0.12611836*nc0.y + -0.07547889*nd0.y + -0.0973721*ne0.y + -0.09426381*nf0.y + 0.09283747*ng0.y + -0.0036219582*nh0.y + 0.033203803*ni0.y;
    float s = -0.061120506*na0.z + -0.0032669806*nb0.z + 0.17457744*nc0.z + 0.0786906*nd0.z + -0.40016562*ne0.z + 0.4663654*nf0.z + 0.012628118*ng0.z + 0.05319796*nh0.z + -0.0024167062*ni0.z;
    float t = -0.1353105*na0.w + 0.019064318*nb0.w + -0.0072273333*nc0.w + -0.04670005*nd0.w + 0.29887754*ne0.w + 0.016659219*nf0.w + -0.014867551*ng0.w + -0.011917135*nh0.w + 0.13788454*ni0.w;
    float u = -0.029870111*na1.x + 0.033843093*nb1.x + -0.065248415*nc1.x + -0.08469054*nd1.x + 0.017073529*ne1.x + -0.023332408*nf1.x + -0.0628914*ng1.x + -0.0745155*nh1.x + 0.15528484*ni1.x;
    float v = -0.0019400625*na1.y + -0.030651335*nb1.y + 0.090773754*nc1.y + 0.0258287*nd1.y + -0.20470299*ne1.y + -0.047677934*nf1.y + -0.05859846*ng1.y + 0.1281607*nh1.y + 0.0177529*ni1.y;
    float w = -0.011972396*na1.z + -0.09978911*nb1.z + -0.057061244*nc1.z + 0.047144193*nd1.z + -0.059643425*ne1.z + 0.31873918*nf1.z + 0.17199998*ng1.z + 0.0934847*nh1.z + 0.31202945*ni1.z;
    float x = -0.08166581*na1.w + 0.057511628*nb1.w + 0.0742405*nc1.w + 0.052457616*nd1.w + 0.18768248*ne1.w + 0.05856997*nf1.w + -0.0054697786*ng1.w + -0.0898955*nh1.w + -0.10827548*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.009003827;
    i = -0.2563088*a0.x + 0.05043541*b0.x + 0.08568264*c0.x + -0.25449166*d0.x + -0.20602058*e0.x + -0.05074106*f0.x + -0.24613608*g0.x + 0.022720609*h0.x + -0.12870306*i0.x;
    j = 0.113697335*a0.y + -0.05368127*b0.y + -0.05319295*c0.y + -0.0055116396*d0.y + -0.37782472*e0.y + -0.06400323*f0.y + 0.0020659082*g0.y + -0.0830408*h0.y + -0.2580011*i0.y;
    k = 0.2294053*a0.z + 0.13383579*b0.z + 0.17804933*c0.z + 0.23239657*d0.z + -0.13443974*e0.z + 0.18296231*f0.z + 0.097049445*g0.z + 0.13477755*h0.z + -0.03763717*i0.z;
    l = 0.021966321*a0.w + 0.11378714*b0.w + 0.03098346*c0.w + 0.2932349*d0.w + 0.24182005*e0.w + 0.1548571*f0.w + 0.1858839*g0.w + 0.36080515*h0.w + 0.1537605*i0.w;
    m = 0.24021837*a1.x + 0.10757309*b1.x + -0.08044931*c1.x + 0.13565575*d1.x + 0.11971135*e1.x + -0.049942825*f1.x + -0.087746575*g1.x + 0.107465945*h1.x + 0.094088905*i1.x;
    n = -0.15980811*a1.y + 0.043343157*b1.y + 0.112694*c1.y + -0.2359384*d1.y + 0.31993595*e1.y + 0.04207265*f1.y + -0.0896765*g1.y + 0.06047066*h1.y + 0.07702838*i1.y;
    o = -0.027281009*a1.z + -0.053025093*b1.z + -0.026898835*c1.z + -0.21167403*d1.z + 0.11063941*e1.z + 0.21649761*f1.z + -0.0654316*g1.z + 0.0036047318*h1.z + -0.040679716*i1.z;
    p = -0.09511372*a1.w + 0.07544163*b1.w + -0.068545476*c1.w + -0.11898356*d1.w + -0.12553929*e1.w + -0.036977906*f1.w + -0.05818198*g1.w + -0.18978088*h1.w + -0.12406578*i1.w;
    q = 0.18537302*na0.x + 0.0471562*nb0.x + -0.024299944*nc0.x + 0.3394632*nd0.x + -0.070106596*ne0.x + 0.017024457*nf0.x + 0.050112784*ng0.x + 0.049462743*nh0.x + -0.06373756*ni0.x;
    r = 0.01591681*na0.y + 0.118769474*nb0.y + -0.00033438014*nc0.y + 0.13797139*nd0.y + 0.24115679*ne0.y + -0.10003855*nf0.y + 0.17300089*ng0.y + -0.0046724756*nh0.y + -0.015399904*ni0.y;
    s = -0.06551598*na0.z + 0.09221071*nb0.z + 0.06134306*nc0.z + -0.10775717*nd0.z + -0.21501426*ne0.z + 0.16960567*nf0.z + 0.019851804*ng0.z + -0.066120826*nh0.z + 0.04763201*ni0.z;
    t = 0.034631733*na0.w + -0.006004178*nb0.w + -0.08292008*nc0.w + -0.11344495*nd0.w + 0.06891366*ne0.w + -0.13559465*nf0.w + -0.071880035*ng0.w + 0.09140712*nh0.w + -0.055761162*ni0.w;
    u = 0.108538955*na1.x + 0.23723991*nb1.x + 0.13979872*nc1.x + 0.0026236933*nd1.x + -0.1712317*ne1.x + 0.18337625*nf1.x + -0.05319237*ng1.x + -0.084970586*nh1.x + -0.037275948*ni1.x;
    v = 0.07666163*na1.y + -0.14426368*nb1.y + 0.08600506*nc1.y + 0.059441805*nd1.y + -0.03408525*ne1.y + 0.16753855*nf1.y + 0.11846989*ng1.y + -3.7933783e-05*nh1.y + -0.20521663*ni1.y;
    w = 0.036177203*na1.z + -0.016836358*nb1.z + -0.029763628*nc1.z + 0.15060756*nd1.z + 0.04416379*ne1.z + -0.25545955*nf1.z + 0.045269053*ng1.z + -0.07570143*nh1.z + 0.049832813*ni1.z;
    x = 0.0784876*na1.w + -0.02017831*nb1.w + -0.13643329*nc1.w + 0.09018697*nd1.w + -0.17120928*ne1.w + 0.10865079*nf1.w + 0.018973323*ng1.w + -0.11135826*nh1.w + 0.018946206*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0066723884;
    i = -0.02766134*a0.x + -0.07910128*b0.x + 0.10000432*c0.x + -0.0077935955*d0.x + -0.18509458*e0.x + -0.04612191*f0.x + -0.07807891*g0.x + -0.027197784*h0.x + 0.040843934*i0.x;
    j = 0.015636139*a0.y + 0.18825547*b0.y + 0.13782531*c0.y + -0.091497056*d0.y + -0.32420376*e0.y + -0.006751257*f0.y + -0.043966822*g0.y + 0.101294726*h0.y + 0.1581135*i0.y;
    k = 0.08092526*a0.z + 0.06745233*b0.z + -0.0044060666*c0.z + -0.07794502*d0.z + 0.021141954*e0.z + -0.09169699*f0.z + 0.0025336859*g0.z + -0.056924406*h0.z + 0.08214582*i0.z;
    l = 0.20671146*a0.w + -0.23547839*b0.w + 0.02666375*c0.w + 0.105076894*d0.w + -0.28910094*e0.w + 0.034965467*f0.w + 0.1268616*g0.w + 0.023588797*h0.w + -0.018232921*i0.w;
    m = -0.028498547*a1.x + 0.116014436*b1.x + 0.09713531*c1.x + -0.05301735*d1.x + -0.29605877*e1.x + 0.061098687*f1.x + -0.07680063*g1.x + -0.02204858*h1.x + -0.078532085*i1.x;
    n = -0.048041645*a1.y + -0.32098907*b1.y + -0.2454318*c1.y + -0.48134127*d1.y + -0.35850272*e1.y + 0.41497707*f1.y + -0.20349054*g1.y + 0.3936116*h1.y + -0.018326268*i1.y;
    o = -0.14116973*a1.z + 0.02285499*b1.z + -0.07057403*c1.z + -0.09118363*d1.z + 0.37333208*e1.z + -0.20065124*f1.z + -0.026436245*g1.z + 0.16267431*h1.z + 0.11812809*i1.z;
    p = -0.14101206*a1.w + -0.06963015*b1.w + -0.15444969*c1.w + 0.033450324*d1.w + -0.33700934*e1.w + -0.060848374*f1.w + 0.01683083*g1.w + -0.05332889*h1.w + -0.07328846*i1.w;
    q = 0.051498156*na0.x + 0.16069268*nb0.x + 0.16637984*nc0.x + -0.0972913*nd0.x + -0.2021069*ne0.x + -0.030674994*nf0.x + -0.20328711*ng0.x + -0.07884667*nh0.x + 0.100347206*ni0.x;
    r = -0.13863328*na0.y + 0.06469719*nb0.y + -0.088265724*nc0.y + -0.024668645*nd0.y + -0.19632864*ne0.y + 0.17612971*nf0.y + 0.02625999*ng0.y + -0.03309975*nh0.y + 0.07569001*ni0.y;
    s = -0.075251035*na0.z + -0.050738305*nb0.z + 0.24210216*nc0.z + 0.13114996*nd0.z + -0.4864818*ne0.z + 0.06905125*nf0.z + 0.045289278*ng0.z + -0.10157096*nh0.z + -0.2800613*ni0.z;
    t = -0.025999604*na0.w + 0.13178527*nb0.w + 0.044900127*nc0.w + 0.0607803*nd0.w + -0.09442027*ne0.w + -0.022236204*nf0.w + 0.18774076*ng0.w + -0.12149716*nh0.w + 0.05680034*ni0.w;
    u = 0.088651866*na1.x + 0.027440932*nb1.x + -0.04109482*nc1.x + -0.1949932*nd1.x + -0.10897533*ne1.x + 0.07088638*nf1.x + -0.10386488*ng1.x + -0.11656961*nh1.x + -0.10445978*ni1.x;
    v = 0.10474032*na1.y + 0.10221516*nb1.y + 0.15839252*nc1.y + 0.049012497*nd1.y + -0.2063483*ne1.y + 0.1840777*nf1.y + -0.043723542*ng1.y + 0.047894552*nh1.y + -0.009499964*ni1.y;
    w = 0.4258637*na1.z + 0.18832234*nb1.z + -0.18723905*nc1.z + 0.10645866*nd1.z + -0.032949854*ne1.z + 0.12812077*nf1.z + 0.4025724*ng1.z + 0.12732601*nh1.z + 0.10769062*ni1.z;
    x = -0.11810964*na1.w + 0.14253752*nb1.w + 0.042235278*nc1.w + 0.13767174*nd1.w + 0.2960284*ne1.w + -0.15177676*nf1.w + -0.0055533214*ng1.w + 0.09012071*nh1.w + 0.15953456*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.00672277;
    i = 0.0012310629*a0.x + 0.19084314*b0.x + 0.11294963*c0.x + -0.0886832*d0.x + -0.16454856*e0.x + 0.037493285*f0.x + -0.004760058*g0.x + -0.12350646*h0.x + 0.07630086*i0.x;
    j = -0.01957707*a0.y + -0.06819614*b0.y + 0.12367452*c0.y + 0.040409215*d0.y + -0.021836663*e0.y + 0.12864098*f0.y + -0.007157583*g0.y + 0.08941197*h0.y + 0.25203055*i0.y;
    k = 0.020333389*a0.z + 0.11860472*b0.z + -0.00065172574*c0.z + 0.066716105*d0.z + 0.192155*e0.z + -0.000989324*f0.z + 0.0034235346*g0.z + 0.19203706*h0.z + 0.15892717*i0.z;
    l = 0.07310296*a0.w + -0.05110208*b0.w + 0.11367794*c0.w + 0.033097357*d0.w + -0.06798024*e0.w + 0.08370761*f0.w + -0.14428368*g0.w + 0.11058313*h0.w + -0.029681815*i0.w;
    m = -0.009701145*a1.x + 0.12630996*b1.x + 0.017602919*c1.x + -0.023853028*d1.x + -0.20952903*e1.x + -0.056210782*f1.x + -0.0733302*g1.x + -0.03288728*h1.x + 0.0049576587*i1.x;
    n = -0.022181654*a1.y + -0.14963089*b1.y + -0.0068189222*c1.y + -0.15434141*d1.y + 0.14266609*e1.y + 0.34974262*f1.y + 0.14620017*g1.y + 0.12013395*h1.y + 0.15577218*i1.y;
    o = -0.041419595*a1.z + 0.0049163126*b1.z + -0.0125360815*c1.z + -0.061257165*d1.z + 0.18954872*e1.z + -0.2485608*f1.z + -0.006892711*g1.z + 0.058746573*h1.z + -0.044149607*i1.z;
    p = 0.011658519*a1.w + -0.090956636*b1.w + 0.03994311*c1.w + 0.070552535*d1.w + 0.06298112*e1.w + -0.028974736*f1.w + 0.0021537086*g1.w + 0.1029031*h1.w + 0.055890955*i1.w;
    q = 0.0320352*na0.x + 0.14326142*nb0.x + 0.082991965*nc0.x + 0.21549419*nd0.x + -0.3395594*ne0.x + -0.024059823*nf0.x + 0.019351935*ng0.x + -0.1382331*nh0.x + -0.0304686*ni0.x;
    r = 0.03710443*na0.y + 0.1930695*nb0.y + -0.14523448*nc0.y + 0.10579029*nd0.y + -0.05521899*ne0.y + -0.33665508*nf0.y + -0.10289396*ng0.y + 0.024678295*nh0.y + -0.059992127*ni0.y;
    s = 0.026773388*na0.z + -0.0975856*nb0.z + 0.02035129*nc0.z + -0.044302266*nd0.z + -0.0270736*ne0.z + -0.13728258*nf0.z + -0.061705247*ng0.z + -0.02596695*nh0.z + -0.12971757*ni0.z;
    t = -0.024138713*na0.w + 0.0155523615*nb0.w + -0.091659635*nc0.w + 0.010630842*nd0.w + 0.16401519*ne0.w + -0.06192334*nf0.w + -0.03184829*ng0.w + -0.051016547*nh0.w + -0.032736193*ni0.w;
    u = 0.029396972*na1.x + -0.07129105*nb1.x + -0.0025841917*nc1.x + 0.074881524*nd1.x + 0.14281105*ne1.x + -0.114080995*nf1.x + -0.021587078*ng1.x + -0.08054726*nh1.x + -0.12657729*ni1.x;
    v = -0.00041675888*na1.y + 0.0053440374*nb1.y + 0.005137936*nc1.y + -0.0135748*nd1.y + 0.04248027*ne1.y + -0.0016815509*nf1.y + -0.033098955*ng1.y + 0.036555868*nh1.y + 0.049444973*ni1.y;
    w = 0.03400237*na1.z + 0.06084352*nb1.z + -0.04488614*nc1.z + -0.100054935*nd1.z + 0.025200516*ne1.z + 0.13285275*nf1.z + -0.1963087*ng1.z + -0.004163397*nh1.z + 0.14134736*ni1.z;
    x = -0.0012568784*na1.w + 0.06601895*nb1.w + -0.110312514*nc1.w + -0.0034374476*nd1.w + 0.055813357*ne1.w + -0.1290571*nf1.w + 0.04696615*ng1.w + 0.03428323*nh1.w + -0.004907712*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.013123342;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN30
//!BIND LUMAN31
//!SAVE LUMAN40

#define L0_tex LUMAN30_tex
#define L1_tex LUMAN31_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.08536383*a0.x + 0.22057784*b0.x + -0.0070729763*c0.x + 0.036197208*d0.x + -0.07672289*e0.x + 0.104230516*f0.x + -0.027658395*g0.x + 0.037242346*h0.x + 0.080793746*i0.x;
    float j = -0.028750127*a0.y + -0.113906324*b0.y + -0.07433507*c0.y + -0.045031663*d0.y + -0.06684857*e0.y + -0.044401973*f0.y + -0.0034719035*g0.y + -0.068872675*h0.y + -0.019946523*i0.y;
    float k = 0.03557092*a0.z + -0.05054397*b0.z + 0.0036708773*c0.z + -0.06777095*d0.z + -0.09847624*e0.z + 0.03362397*f0.z + 0.012949831*g0.z + -0.023764836*h0.z + 0.052689515*i0.z;
    float l = -0.027142372*a0.w + -0.07203122*b0.w + -0.06388474*c0.w + 0.01628509*d0.w + -0.22445866*e0.w + 0.024412872*f0.w + -0.008128143*g0.w + -0.067040876*h0.w + -0.06806653*i0.w;
    float m = 0.03498277*a1.x + 0.039069988*b1.x + -0.013376671*c1.x + 0.23731333*d1.x + -0.01699014*e1.x + 0.010777388*f1.x + 0.045220964*g1.x + 0.016791182*h1.x + -0.06050448*i1.x;
    float n = -0.010797193*a1.y + -0.039635405*b1.y + 0.018689604*c1.y + 0.04257897*d1.y + -0.0948216*e1.y + -0.039236613*f1.y + -0.016331976*g1.y + -0.048512593*h1.y + 0.0064482763*i1.y;
    float o = 0.09766405*a1.z + 0.104419*b1.z + -0.076465145*c1.z + 0.0079194885*d1.z + -0.015444938*e1.z + -0.03390264*f1.z + -0.023632193*g1.z + 0.11754263*h1.z + -0.012952367*i1.z;
    float p = 0.088692114*a1.w + 0.0014476123*b1.w + 0.10322219*c1.w + 0.069038235*d1.w + -0.061100803*e1.w + -0.048262775*f1.w + 0.09612743*g1.w + 0.058897*h1.w + 0.074676886*i1.w;
    float q = -0.0036980624*na0.x + -0.024267241*nb0.x + 0.026586728*nc0.x + 0.035541214*nd0.x + -0.085665174*ne0.x + -0.1630016*nf0.x + 0.00490034*ng0.x + -0.08901139*nh0.x + -0.018733606*ni0.x;
    float r = 0.013042566*na0.y + 0.14665644*nb0.y + 0.0055058184*nc0.y + -0.021425422*nd0.y + 0.16959174*ne0.y + -0.0129146585*nf0.y + -0.00012834472*ng0.y + 0.08471551*nh0.y + -0.05428125*ni0.y;
    float s = -0.012737113*na0.z + 0.027404707*nb0.z + -0.01801338*nc0.z + 0.037341356*nd0.z + -0.17581393*ne0.z + -0.006813803*nf0.z + 0.030534925*ng0.z + -0.08039794*nh0.z + 0.051014334*ni0.z;
    float t = -0.0140338885*na0.w + 0.14739423*nb0.w + 0.07582113*nc0.w + -0.053938482*nd0.w + 0.08839668*ne0.w + -0.037514362*nf0.w + -0.020815395*ng0.w + -0.023945889*nh0.w + 0.008050809*ni0.w;
    float u = 0.083485134*na1.x + 0.037310943*nb1.x + 0.03057954*nc1.x + -0.09993926*nd1.x + 0.039829873*ne1.x + -0.06892306*nf1.x + 0.038759235*ng1.x + 0.005647801*nh1.x + 0.019709172*ni1.x;
    float v = 0.081475616*na1.y + 0.048962787*nb1.y + 0.045870036*nc1.y + -0.098586746*nd1.y + 0.020431047*ne1.y + 0.012638942*nf1.y + -0.017170994*ng1.y + 7.067469e-05*nh1.y + 0.107078105*ni1.y;
    float w = -0.045930725*na1.z + -0.040031545*nb1.z + 0.029053928*nc1.z + 0.0089001665*nd1.z + -0.08677615*ne1.z + 0.06877404*nf1.z + -0.009662309*ng1.z + -0.010047991*nh1.z + 0.003443427*ni1.z;
    float x = 0.08166517*na1.w + -0.0028700489*nb1.w + -0.045297828*nc1.w + 0.052762747*nd1.w + 0.01898965*ne1.w + 0.038606808*nf1.w + 0.13621548*ng1.w + 0.11403761*nh1.w + -0.044998493*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.01725295;
    i = -0.03088376*a0.x + -0.06506699*b0.x + 0.028759485*c0.x + 0.0063022817*d0.x + -0.23940088*e0.x + -0.1632248*f0.x + 0.0764616*g0.x + 0.042672176*h0.x + 0.17377013*i0.x;
    j = 0.035214774*a0.y + -0.03817774*b0.y + -0.08883238*c0.y + -0.00111298*d0.y + -0.029566031*e0.y + -0.118429996*f0.y + 0.016505836*g0.y + -0.104897566*h0.y + -0.08694124*i0.y;
    k = 0.09665161*a0.z + -0.029328583*b0.z + -0.0685033*c0.z + 0.1252019*d0.z + -0.090078555*e0.z + 0.010249423*f0.z + 0.03936791*g0.z + 0.24433094*h0.z + 0.07952615*i0.z;
    l = -0.016106704*a0.w + -0.08684218*b0.w + 0.040539164*c0.w + -0.015498147*d0.w + 0.13228345*e0.w + -0.27393204*f0.w + -0.11668647*g0.w + -0.09482715*h0.w + 0.012399258*i0.w;
    m = -0.1488633*a1.x + -0.065216005*b1.x + 0.0535183*c1.x + -0.051078368*d1.x + 0.15633519*e1.x + -0.08940123*f1.x + -0.1322567*g1.x + -0.08257876*h1.x + 0.009185964*i1.x;
    n = -0.07108216*a1.y + -0.07719289*b1.y + 0.04625283*c1.y + -0.09986587*d1.y + -0.021199053*e1.y + -0.028616274*f1.y + 0.04687508*g1.y + 0.11452391*h1.y + 0.07083235*i1.y;
    o = -0.11037789*a1.z + -0.051027145*b1.z + -0.19961402*c1.z + -0.13499379*d1.z + -0.0248805*e1.z + -0.21664341*f1.z + -0.12658863*g1.z + -0.30715507*h1.z + -0.06774432*i1.z;
    p = 0.07840328*a1.w + 0.076184236*b1.w + 0.1698377*c1.w + 0.1683458*d1.w + 0.201538*e1.w + 0.15030397*f1.w + 0.034305293*g1.w + 0.0963635*h1.w + -0.0154249985*i1.w;
    q = 0.02538238*na0.x + 0.09864331*nb0.x + 0.11035262*nc0.x + 0.024396792*nd0.x + 0.09908008*ne0.x + -0.013617436*nf0.x + -0.041231457*ng0.x + -0.0014901091*nh0.x + -0.19220696*ni0.x;
    r = 0.04589675*na0.y + -0.010927794*nb0.y + 0.0038104362*nc0.y + -0.13047443*nd0.y + 0.044636056*ne0.y + 0.1223258*nf0.y + -0.09432054*ng0.y + -0.13457677*nh0.y + -0.1626453*ni0.y;
    s = -0.06592902*na0.z + -0.10535102*nb0.z + -0.009799053*nc0.z + -0.022730127*nd0.z + 0.11826458*ne0.z + 0.07741324*nf0.z + -0.08576461*ng0.z + -0.21813503*nh0.z + 0.18526982*ni0.z;
    t = -0.08173712*na0.w + 0.10438044*nb0.w + -0.08517764*nc0.w + 0.12938815*nd0.w + -0.17576784*ne0.w + -0.0072915126*nf0.w + 0.15446301*ng0.w + 0.016681919*nh0.w + 0.051581446*ni0.w;
    u = 0.115558125*na1.x + -0.022121336*nb1.x + -0.0825352*nc1.x + 0.09382652*nd1.x + 0.04846142*ne1.x + 0.041536648*nf1.x + 0.15467171*ng1.x + 0.008293472*nh1.x + -0.050614562*ni1.x;
    v = -0.003924168*na1.y + 0.1541878*nb1.y + -0.059138734*nc1.y + -0.028176788*nd1.y + -0.07557443*ne1.y + -0.14664999*nf1.y + -0.04713122*ng1.y + -0.041739505*nh1.y + -0.09211264*ni1.y;
    w = -0.0975832*na1.z + -0.09730037*nb1.z + 0.09086173*nc1.z + -0.10395223*nd1.z + -0.00226716*ne1.z + 0.038585648*nf1.z + -0.047330752*ng1.z + 0.12446333*nh1.z + -0.01351817*ni1.z;
    x = 0.2791586*na1.w + -0.076250456*nb1.w + -0.13428825*nc1.w + 0.048622146*nd1.w + -0.17240109*ne1.w + -0.09587715*nf1.w + -0.19276465*ng1.w + 0.07107969*nh1.w + 0.12039959*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.025054017;
    i = -0.043591976*a0.x + 0.19324586*b0.x + -0.07647055*c0.x + 0.02770661*d0.x + -0.09756863*e0.x + 0.012610168*f0.x + 0.10716365*g0.x + -0.003939735*h0.x + 0.21686499*i0.x;
    j = 0.028424889*a0.y + -0.027860237*b0.y + 0.024531493*c0.y + -0.0048383856*d0.y + -0.13793367*e0.y + -0.10382182*f0.y + -0.060784034*g0.y + -0.1279115*h0.y + -0.06899814*i0.y;
    k = 0.03997191*a0.z + 0.07490852*b0.z + 0.058225974*c0.z + -0.0019495608*d0.z + -0.37614638*e0.z + 0.15587313*f0.z + -0.076541044*g0.z + 0.24963339*h0.z + 0.081270605*i0.z;
    l = 0.07424056*a0.w + 0.024657438*b0.w + -0.052919507*c0.w + -0.20227009*d0.w + 0.046584353*e0.w + -0.059170544*f0.w + -0.19375145*g0.w + 0.03974534*h0.w + -0.05024785*i0.w;
    m = 0.18138728*a1.x + -0.022965115*b1.x + -0.054253504*c1.x + -0.119478576*d1.x + 0.15398093*e1.x + 0.15598615*f1.x + 0.0581195*g1.x + 0.11262932*h1.x + -0.06966203*i1.x;
    n = -0.10707376*a1.y + 0.033553954*b1.y + -0.10746114*c1.y + 0.08243729*d1.y + -0.0044641383*e1.y + -0.020447541*f1.y + 0.12454565*g1.y + 0.008655268*h1.y + 0.060918845*i1.y;
    o = 0.029880892*a1.z + 0.11741621*b1.z + -0.05349719*c1.z + 0.25883275*d1.z + -0.10153349*e1.z + -0.11170519*f1.z + -0.018178564*g1.z + 0.13763513*h1.z + 0.11400469*i1.z;
    p = -0.10463172*a1.w + -0.10077497*b1.w + 0.009877957*c1.w + -0.16648768*d1.w + 0.27668706*e1.w + 0.099615164*f1.w + 0.12298496*g1.w + 0.017380107*h1.w + 0.032301165*i1.w;
    q = -0.055131678*na0.x + -0.04987668*nb0.x + -0.071181804*nc0.x + 0.005380595*nd0.x + -0.018658975*ne0.x + -0.10966231*nf0.x + 0.015993118*ng0.x + 0.0901746*nh0.x + -0.072906815*ni0.x;
    r = 0.11788679*na0.y + 0.051318392*nb0.y + -0.018426865*nc0.y + -0.009329915*nd0.y + 0.118940435*ne0.y + 0.06237265*nf0.y + -0.10727782*ng0.y + 0.02792092*nh0.y + 0.018413879*ni0.y;
    s = 0.02677677*na0.z + 0.034773823*nb0.z + -0.09717205*nc0.z + -0.18123712*nd0.z + 0.05084739*ne0.z + 0.009756145*nf0.z + -0.14528298*ng0.z + -0.17318346*nh0.z + 0.02436373*ni0.z;
    t = 0.061065402*na0.w + -0.14666232*nb0.w + 0.020277957*nc0.w + -0.022936646*nd0.w + -0.20519575*ne0.w + -0.09254183*nf0.w + -0.017779186*ng0.w + -0.009078557*nh0.w + -0.019824954*ni0.w;
    u = -0.19521299*na1.x + 0.13830769*nb1.x + 0.043815285*nc1.x + 0.058472138*nd1.x + -0.10857395*ne1.x + -0.07171282*nf1.x + 0.00773933*ng1.x + 0.12705073*nh1.x + 0.038176555*ni1.x;
    v = 0.16605817*na1.y + -0.112485126*nb1.y + 0.097068876*nc1.y + -0.1400524*nd1.y + 0.010091068*ne1.y + 0.037447132*nf1.y + -0.08650508*ng1.y + -0.037930984*nh1.y + 0.023731159*ni1.y;
    w = 0.104652576*na1.z + 0.047396503*nb1.z + -0.020233953*nc1.z + -0.063091435*nd1.z + 0.008213536*ne1.z + 0.12577772*nf1.z + 0.018698437*ng1.z + -0.05598111*nh1.z + 0.053034004*ni1.z;
    x = -0.072743595*na1.w + 0.20017679*nb1.w + -0.020352483*nc1.w + -0.11213662*nd1.w + -0.0695337*ne1.w + -0.0844762*nf1.w + 0.21215153*ng1.w + -0.031425636*nh1.w + 0.02297093*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013116349;
    i = -0.035587903*a0.x + 0.28998992*b0.x + -0.09151781*c0.x + -0.0885913*d0.x + -0.18430325*e0.x + -0.08728831*f0.x + -0.08809791*g0.x + -0.12908792*h0.x + -0.13577425*i0.x;
    j = 0.080175355*a0.y + 0.06254113*b0.y + 0.09340586*c0.y + 0.09902964*d0.y + 0.2341167*e0.y + -0.15395014*f0.y + 0.07856779*g0.y + 0.048811354*h0.y + 0.0030428942*i0.y;
    k = 0.08139451*a0.z + 0.22830209*b0.z + 0.10671315*c0.z + 0.13054849*d0.z + -0.121118866*e0.z + 0.114327714*f0.z + 0.2536303*g0.z + -0.04966182*h0.z + -0.03836721*i0.z;
    l = -0.030240182*a0.w + 0.037857987*b0.w + 0.039160606*c0.w + -0.025005141*d0.w + 0.10855964*e0.w + -0.2704116*f0.w + 0.10738485*g0.w + 0.055243604*h0.w + -0.05044504*i0.w;
    m = 0.0509642*a1.x + -0.084604576*b1.x + 0.116994545*c1.x + 0.21990353*d1.x + 0.06141327*e1.x + -0.10694696*f1.x + -0.2123716*g1.x + -0.24490428*h1.x + -0.02086803*i1.x;
    n = -0.029533416*a1.y + -0.029786944*b1.y + -0.14562476*c1.y + -0.08382081*d1.y + 0.05943508*e1.y + -0.14098302*f1.y + -0.15943012*g1.y + -0.06873147*h1.y + 0.040483374*i1.y;
    o = -0.13607192*a1.z + 0.03382944*b1.z + -0.08697416*c1.z + -0.09518328*d1.z + -0.024908481*e1.z + -0.002681208*f1.z + 0.000790745*g1.z + -0.20081358*h1.z + -0.17025524*i1.z;
    p = -0.04001146*a1.w + -0.19817154*b1.w + -0.0867182*c1.w + -0.07767924*d1.w + 0.23588526*e1.w + 0.03359696*f1.w + 0.053512283*g1.w + -0.15246984*h1.w + 0.096771784*i1.w;
    q = -0.07844516*na0.x + -0.13646075*nb0.x + 0.13378*nc0.x + 0.00081356516*nd0.x + 0.36044842*ne0.x + 0.03636914*nf0.x + -0.14159712*ng0.x + -0.12730932*nh0.x + 0.07580974*ni0.x;
    r = 0.12939188*na0.y + 0.1376879*nb0.y + 0.09112592*nc0.y + 0.0052671693*nd0.y + 0.2309594*ne0.y + 0.26507932*nf0.y + -0.053765927*ng0.y + -0.057173535*nh0.y + 0.14044432*ni0.y;
    s = 0.053574387*na0.z + -0.1098049*nb0.z + -0.03359242*nc0.z + -0.009376764*nd0.z + -0.026915615*ne0.z + -0.24570042*nf0.z + 0.12763985*ng0.z + -0.33731624*nh0.z + -0.00048419682*ni0.z;
    t = 0.050085705*na0.w + -0.065321915*nb0.w + -0.13701434*nc0.w + 0.17681946*nd0.w + -0.15797354*ne0.w + -0.15324375*nf0.w + -0.106378034*ng0.w + 0.100880235*nh0.w + 0.04465426*ni0.w;
    u = -0.05654472*na1.x + 0.0327931*nb1.x + -0.09484717*nc1.x + -0.0029626698*nd1.x + 0.10992431*ne1.x + 0.12324815*nf1.x + 0.12251335*ng1.x + 0.103057526*nh1.x + 0.053130142*ni1.x;
    v = 0.062485415*na1.y + 0.13917658*nb1.y + 0.1527197*nc1.y + 0.012253399*nd1.y + -0.12345317*ne1.y + -0.012620613*nf1.y + -0.06488545*ng1.y + 0.10458118*nh1.y + -0.09761376*ni1.y;
    w = -0.009200393*na1.z + -0.07518724*nb1.z + 0.06756176*nc1.z + -0.060130857*nd1.z + -0.0025904253*ne1.z + -0.018850297*nf1.z + -0.018455606*ng1.z + 0.11698259*nh1.z + -0.06945231*ni1.z;
    x = -0.038078338*na1.w + 0.28164002*nb1.w + 0.15806901*nc1.w + 0.049810838*nd1.w + -0.29538316*ne1.w + 0.09279826*nf1.w + -0.3216003*ng1.w + -0.0039241235*nh1.w + 0.107743636*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.00022777569;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN30
//!BIND LUMAN31
//!SAVE LUMAN41

#define L0_tex LUMAN30_tex
#define L1_tex LUMAN31_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.054257732*a0.x + 0.27371246*b0.x + -0.052580442*c0.x + 0.0821893*d0.x + -0.103322186*e0.x + -0.24418627*f0.x + 0.0611493*g0.x + 0.07409564*h0.x + -0.0091123395*i0.x;
    float j = 0.011560797*a0.y + 0.104165755*b0.y + 0.109339796*c0.y + -0.010434488*d0.y + 0.0779517*e0.y + -0.1448543*f0.y + 0.060612075*g0.y + 0.05546987*h0.y + 0.062975384*i0.y;
    float k = -0.07776099*a0.z + -0.088368*b0.z + 0.038915366*c0.z + -0.0038091897*d0.z + -0.18550852*e0.z + 0.042044386*f0.z + -0.13174416*g0.z + -0.05231247*h0.z + 0.021248076*i0.z;
    float l = -0.11482602*a0.w + -0.22810052*b0.w + -0.020931996*c0.w + -0.19848773*d0.w + 0.017370276*e0.w + 0.11224409*f0.w + -0.1283919*g0.w + -0.0064690793*h0.w + -0.108108915*i0.w;
    float m = -0.21868303*a1.x + -0.1460253*b1.x + -0.02056819*c1.x + -0.2683982*d1.x + 0.02188942*e1.x + -0.044143774*f1.x + -0.1582242*g1.x + -0.04801052*h1.x + 0.002758771*i1.x;
    float n = 0.02125123*a1.y + 0.046871092*b1.y + 0.034314208*c1.y + 0.14033747*d1.y + -0.06737769*e1.y + -0.05111058*f1.y + 0.045157064*g1.y + -0.087649085*h1.y + -0.07641853*i1.y;
    float o = 0.020611035*a1.z + -0.08709827*b1.z + -0.058960218*c1.z + 0.09095107*d1.z + -0.15974514*e1.z + -0.03847971*f1.z + -0.034782387*g1.z + 0.09239257*h1.z + -0.033537846*i1.z;
    float p = 0.10096098*a1.w + 0.045786828*b1.w + 0.12547746*c1.w + -0.036246233*d1.w + 0.41335067*e1.w + -0.097790875*f1.w + 0.18755811*g1.w + -0.019576516*h1.w + -0.021100365*i1.w;
    float q = 0.053558517*na0.x + -0.103455506*nb0.x + 0.07568259*nc0.x + -0.1341594*nd0.x + -0.27883413*ne0.x + 0.12920994*nf0.x + -0.051551364*ng0.x + -0.14494799*nh0.x + 0.060187746*ni0.x;
    float r = 0.0035913682*na0.y + 0.034207687*nb0.y + -0.16305931*nc0.y + 0.16384187*nd0.y + -0.3219198*ne0.y + -0.07760979*nf0.y + 0.024765978*ng0.y + 0.14511627*nh0.y + -0.02396373*ni0.y;
    float s = 0.064441316*na0.z + -0.06812652*nb0.z + -0.023528796*nc0.z + 0.023931213*nd0.z + 0.07976284*ne0.z + -0.08934557*nf0.z + 0.112490386*ng0.z + -0.0018943544*nh0.z + 0.09055857*ni0.z;
    float t = 0.010761819*na0.w + 0.19307621*nb0.w + -0.018758457*nc0.w + 0.117349915*nd0.w + -0.49189666*ne0.w + -0.073640645*nf0.w + 0.14908928*ng0.w + -0.05187949*nh0.w + 0.037098415*ni0.w;
    float u = 0.17489052*na1.x + 0.10258782*nb1.x + -0.011808832*nc1.x + 0.41893494*nd1.x + -0.006189705*ne1.x + -0.005704103*nf1.x + 0.1725503*ng1.x + 0.037721056*nh1.x + 0.032897796*ni1.x;
    float v = 0.09965535*na1.y + -0.00053941424*nb1.y + -0.020717151*nc1.y + -0.16562484*nd1.y + -0.19280563*ne1.y + 0.023265366*nf1.y + -0.09598055*ng1.y + 0.07879483*nh1.y + 0.12717162*ni1.y;
    float w = -0.006158638*na1.z + -0.036102273*nb1.z + 0.046437833*nc1.z + -0.07120665*nd1.z + 0.07908869*ne1.z + 0.06220462*nf1.z + -0.03583926*ng1.z + -0.0023331905*nh1.z + -0.04308482*ni1.z;
    float x = 0.025252044*na1.w + -0.13039218*nb1.w + -0.049975194*nc1.w + 0.3390306*nd1.w + -0.36262757*ne1.w + 0.121574536*nf1.w + 0.008622063*ng1.w + 0.13189486*nh1.w + 0.013918466*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0146441385;
    i = -0.013898038*a0.x + -0.03979066*b0.x + 0.013716644*c0.x + -0.05803892*d0.x + -0.17036788*e0.x + -0.3342159*f0.x + 0.04831618*g0.x + 0.24438389*h0.x + 0.02146156*i0.x;
    j = 0.022180267*a0.y + 0.06300591*b0.y + 0.12514699*c0.y + 0.031278454*d0.y + -0.11972857*e0.y + 0.19775085*f0.y + -0.015505284*g0.y + 0.010023316*h0.y + -0.025825808*i0.y;
    k = 0.014485555*a0.z + 0.26375902*b0.z + 0.0076107443*c0.z + 0.17171423*d0.z + 0.5273228*e0.z + 0.01864456*f0.z + -0.22563499*g0.z + 0.0170489*h0.z + 0.28598356*i0.z;
    l = 0.047197193*a0.w + -0.017492149*b0.w + 0.011938872*c0.w + 0.07983482*d0.w + -0.2200942*e0.w + -0.4455703*f0.w + -0.10833807*g0.w + 0.0022238574*h0.w + -0.058342494*i0.w;
    m = -0.147014*a1.x + -0.034537677*b1.x + 0.055885065*c1.x + 0.12269109*d1.x + -0.29608414*e1.x + -0.13602276*f1.x + -0.024383334*g1.x + -0.041556574*h1.x + -0.0045015765*i1.x;
    n = -0.003671958*a1.y + -0.10448101*b1.y + -0.12877181*c1.y + -0.18488549*d1.y + -0.20216179*e1.y + 0.027074011*f1.y + 0.03869564*g1.y + 0.035818394*h1.y + 0.04081701*i1.y;
    o = -0.059633434*a1.z + -0.3231465*b1.z + -0.09229924*c1.z + -0.034015656*d1.z + -0.31763735*e1.z + -0.18460466*f1.z + -0.14652348*g1.z + -0.086540945*h1.z + -0.18895042*i1.z;
    p = -0.034059793*a1.w + 0.1330705*b1.w + -0.008831851*c1.w + 0.09408874*d1.w + 0.23037615*e1.w + 0.18210898*f1.w + 0.1452968*g1.w + -0.062167976*h1.w + -0.017864835*i1.w;
    q = -0.20313866*na0.x + 0.18900125*nb0.x + 0.03937197*nc0.x + -0.05634852*nd0.x + -0.4738788*ne0.x + -0.045856085*nf0.x + -0.078206174*ng0.x + -0.06023494*nh0.x + -0.06339165*ni0.x;
    r = 0.19454652*na0.y + 0.34385923*nb0.y + -0.0041349703*nc0.y + 0.08996544*nd0.y + 0.2569007*ne0.y + -0.2474613*nf0.y + -0.024326248*ng0.y + 0.023791725*nh0.y + -0.32401955*ni0.y;
    s = 0.116586015*na0.z + -0.18811816*nb0.z + -0.14147806*nc0.z + -0.10564098*nd0.z + -0.11500905*ne0.z + -0.061058026*nf0.z + 0.08801095*ng0.z + 0.45184898*nh0.z + 0.09909426*ni0.z;
    t = -0.01624822*na0.w + -0.17384705*nb0.w + -0.034403823*nc0.w + 0.14754735*nd0.w + -0.19339335*ne0.w + 0.11690697*nf0.w + 0.124998204*ng0.w + 0.04661684*nh0.w + -0.033586837*ni0.w;
    u = -0.0065229195*na1.x + -0.13284405*nb1.x + -0.023017338*nc1.x + -0.07398193*nd1.x + 0.4825102*ne1.x + 0.08925245*nf1.x + 0.05063243*ng1.x + -0.009413221*nh1.x + -0.02179575*ni1.x;
    v = 0.10751584*na1.y + 0.12421872*nb1.y + 0.15576623*nc1.y + -0.07117823*nd1.y + -0.12944762*ne1.y + -0.020601777*nf1.y + -0.055569127*ng1.y + 0.0517449*nh1.y + -0.026469603*ni1.y;
    w = 0.06402894*na1.z + -0.02451236*nb1.z + -0.009025469*nc1.z + -0.06993758*nd1.z + 0.046909396*ne1.z + 0.075585544*nf1.z + -0.03814493*ng1.z + 0.102764644*nh1.z + 0.118356474*ni1.z;
    x = 0.24888949*na1.w + -0.044692367*nb1.w + 0.06531858*nc1.w + 0.09090876*nd1.w + 0.023833174*ne1.w + -0.23695849*nf1.w + -0.092104465*ng1.w + -0.066167325*nh1.w + 0.22259745*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.03182151;
    i = -0.055676714*a0.x + -0.25448143*b0.x + 0.18013322*c0.x + -0.016296074*d0.x + 0.35178718*e0.x + 0.086339705*f0.x + -0.12396428*g0.x + -0.17678769*h0.x + 0.045469724*i0.x;
    j = -0.023601016*a0.y + -0.1515943*b0.y + 0.06641525*c0.y + 0.14069307*d0.y + -0.09185563*e0.y + 0.0009995411*f0.y + -0.01795657*g0.y + -0.20260298*h0.y + 0.13007584*i0.y;
    k = 0.050869405*a0.z + 0.03870583*b0.z + 0.11086443*c0.z + 0.3541734*d0.z + 0.2433259*e0.z + -0.2360573*f0.z + 0.256418*g0.z + 0.26638928*h0.z + 0.04232309*i0.z;
    l = 0.006167372*a0.w + -0.08807704*b0.w + 0.010333488*c0.w + 0.1846896*d0.w + 0.20306796*e0.w + -0.1017967*f0.w + 0.04408679*g0.w + 0.009385814*h0.w + 0.0812451*i0.w;
    m = 0.11955763*a1.x + -0.0019768341*b1.x + -0.0011848988*c1.x + -0.11757946*d1.x + 0.09276894*e1.x + 0.024858102*f1.x + -0.21629071*g1.x + 0.030862717*h1.x + -0.02532812*i1.x;
    n = 0.03326022*a1.y + 0.00015413002*b1.y + -0.16767214*c1.y + 0.123497516*d1.y + 0.24444306*e1.y + 0.2712187*f1.y + -0.030230884*g1.y + -0.082629666*h1.y + -0.024234135*i1.y;
    o = -0.009569331*a1.z + 0.03957016*b1.z + -0.009828169*c1.z + -0.18476558*d1.z + 0.11622815*e1.z + -0.054776173*f1.z + 0.36828658*g1.z + -0.21097352*h1.z + -0.1212632*i1.z;
    p = -0.049165506*a1.w + -0.025031764*b1.w + -0.045519356*c1.w + -0.45892698*d1.w + -0.08665716*e1.w + 0.17259243*f1.w + -0.3446269*g1.w + 0.08124788*h1.w + 0.0474314*i1.w;
    q = -0.013619317*na0.x + 0.08601415*nb0.x + 0.042602405*nc0.x + -0.29564625*nd0.x + -0.4379702*ne0.x + -0.24080415*nf0.x + -0.07202186*ng0.x + 0.023242502*nh0.x + -0.08246445*ni0.x;
    r = -0.06685381*na0.y + 0.48487332*nb0.y + 0.23622492*nc0.y + -0.2997885*nd0.y + -0.41947487*ne0.y + -0.084841214*nf0.y + -0.18672894*ng0.y + -0.26829925*nh0.y + -0.1523847*ni0.y;
    s = -0.11687069*na0.z + 0.10023403*nb0.z + -0.09487604*nc0.z + -0.18753096*nd0.z + 0.30460224*ne0.z + 0.0039108214*nf0.z + -0.09877181*ng0.z + -0.23594226*nh0.z + 0.12037597*ni0.z;
    t = -0.034343548*na0.w + -0.036309738*nb0.w + -0.12448924*nc0.w + -0.16076897*nd0.w + -0.07157816*ne0.w + 0.09196994*nf0.w + 0.24514483*ng0.w + -0.0071206214*nh0.w + -0.038094837*ni0.w;
    u = 0.0572477*na1.x + -0.016320515*nb1.x + 0.0053648325*nc1.x + -0.10834618*nd1.x + -0.099836186*ne1.x + -0.011570353*nf1.x + -0.0221365*ng1.x + 0.07518451*nh1.x + -0.022385065*ni1.x;
    v = -0.14453459*na1.y + 0.1577858*nb1.y + 0.21396358*nc1.y + -0.042960834*nd1.y + -0.06931992*ne1.y + -0.20045131*nf1.y + 0.10752383*ng1.y + 0.11698326*nh1.y + -0.0103794895*ni1.y;
    w = -0.01758386*na1.z + -0.111778334*nb1.z + 0.018639343*nc1.z + 0.21834186*nd1.z + 0.027805107*ne1.z + 0.1141556*nf1.z + -0.20649067*ng1.z + 0.12635934*nh1.z + 0.04264156*ni1.z;
    x = 0.059818614*na1.w + 0.15443759*nb1.w + 0.15723677*nc1.w + -0.10244512*nd1.w + 0.3773032*ne1.w + -0.2509182*nf1.w + -0.04801961*ng1.w + 0.11025253*nh1.w + -0.03324385*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.029252391;
    i = -0.11146781*a0.x + -0.13930416*b0.x + -0.012807164*c0.x + -0.16427898*d0.x + 0.035926312*e0.x + -0.32527724*f0.x + -0.10702975*g0.x + 0.10439494*h0.x + 0.0599904*i0.x;
    j = 0.048776623*a0.y + -0.038230047*b0.y + -0.11723245*c0.y + -0.13150196*d0.y + -0.2554953*e0.y + -0.3719466*f0.y + -0.12187547*g0.y + -0.017176606*h0.y + -0.29902893*i0.y;
    k = -0.17713442*a0.z + -0.05686459*b0.z + -0.10990948*c0.z + -0.14846052*d0.z + -0.3923777*e0.z + -0.046105888*f0.z + -0.09068917*g0.z + -0.07364397*h0.z + 0.12608323*i0.z;
    l = 0.049529247*a0.w + 0.01276487*b0.w + -0.1421581*c0.w + 0.20870978*d0.w + 0.30118164*e0.w + 0.15338081*f0.w + 0.048369683*g0.w + -0.01961338*h0.w + 0.14480333*i0.w;
    m = -0.051235564*a1.x + -0.029327184*b1.x + 0.015349697*c1.x + -0.20066127*d1.x + 0.23792872*e1.x + 0.0793269*f1.x + 0.049080133*g1.x + 0.22532736*h1.x + 0.18527938*i1.x;
    n = -0.012327854*a1.y + 0.14383848*b1.y + 0.11006613*c1.y + -0.21115981*d1.y + 0.02891759*e1.y + 0.08358382*f1.y + 0.03262832*g1.y + -0.1486431*h1.y + 0.06767234*i1.y;
    o = 0.061599392*a1.z + -0.050808303*b1.z + -0.08906126*c1.z + 0.11978335*d1.z + -0.13210684*e1.z + -0.20221381*f1.z + -0.032080967*g1.z + -0.1130153*h1.z + 0.23689748*i1.z;
    p = -0.023339517*a1.w + 0.08052153*b1.w + 0.13133153*c1.w + 0.27531967*d1.w + 0.20974505*e1.w + 0.27152357*f1.w + -0.013597851*g1.w + 0.1377039*h1.w + -0.22347575*i1.w;
    q = 0.063578114*na0.x + 0.19848521*nb0.x + -0.14250876*nc0.x + 0.20224428*nd0.x + -0.041862875*ne0.x + 0.0135630295*nf0.x + -0.032130726*ng0.x + 0.15371478*nh0.x + -0.0057651824*ni0.x;
    r = -0.071654126*na0.y + -0.003993231*nb0.y + 0.09714553*nc0.y + -0.055221733*nd0.y + -0.30018488*ne0.y + 0.095710516*nf0.y + -0.11766741*ng0.y + -0.25716934*nh0.y + 0.029781904*ni0.y;
    s = 0.0092608*na0.z + -0.17544937*nb0.z + 0.04323492*nc0.z + -0.15429379*nd0.z + -0.16374534*ne0.z + 0.16135879*nf0.z + -0.13333586*ng0.z + 0.21047768*nh0.z + 0.14531775*ni0.z;
    t = 0.059168484*na0.w + 0.054052614*nb0.w + 0.0912373*nc0.w + -0.27993843*nd0.w + -0.18782286*ne0.w + 0.12640288*nf0.w + -0.04521121*ng0.w + -0.24763185*nh0.w + 0.056749433*ni0.w;
    u = 0.16253576*na1.x + 0.32441705*nb1.x + 0.09456559*nc1.x + 0.19797282*nd1.x + 0.0057451613*ne1.x + -0.0038693126*nf1.x + 0.28363606*ng1.x + -0.09297955*nh1.x + -0.034141365*ni1.x;
    v = -0.05110465*na1.y + -0.1417263*nb1.y + -0.21924758*nc1.y + 0.11003367*nd1.y + -0.1469238*ne1.y + -0.06051238*nf1.y + 0.07040412*ng1.y + 0.004858706*nh1.y + -0.029183824*ni1.y;
    w = 0.11109892*na1.z + -0.010970046*nb1.z + -0.019303208*nc1.z + -0.06718125*nd1.z + -0.19049284*ne1.z + 0.037818458*nf1.z + -0.031651754*ng1.z + 0.20565633*nh1.z + 0.054614466*ni1.z;
    x = -0.07991577*na1.w + -0.020427423*nb1.w + -0.051706005*nc1.w + -0.39715537*nd1.w + 0.15884823*ne1.w + -0.075157814*nf1.w + 0.1896494*ng1.w + -0.19617552*nh1.w + 0.034390915*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.021990512;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN40
//!BIND LUMAN41
//!SAVE LUMAN50

#define L0_tex LUMAN40_tex
#define L1_tex LUMAN41_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.03901763*a0.x + 0.042043958*b0.x + 0.20759591*c0.x + 0.07238248*d0.x + -0.03175368*e0.x + 0.42647663*f0.x + 0.063095406*g0.x + 0.17951673*h0.x + 0.56211257*i0.x;
    float j = 0.017079493*a0.y + 0.018908331*b0.y + 0.12611814*c0.y + 0.1692957*d0.y + 0.10425174*e0.y + -0.009320183*f0.y + 0.07855408*g0.y + 0.12618572*h0.y + 0.0056016305*i0.y;
    float k = 0.003895585*a0.z + -0.12828486*b0.z + 0.007352829*c0.z + 0.041258164*d0.z + -0.18446647*e0.z + 0.0014502462*f0.z + 0.122117795*g0.z + 0.028269382*h0.z + 0.05895878*i0.z;
    float l = -0.034471042*a0.w + 0.11535646*b0.w + -0.08276919*c0.w + -0.1517208*d0.w + 0.13121732*e0.w + -0.014896526*f0.w + 0.059614662*g0.w + 0.007029084*h0.w + -0.026446465*i0.w;
    float m = -0.014367774*a1.x + -0.01154789*b1.x + 0.116640516*c1.x + 0.012053954*d1.x + 0.08732725*e1.x + 0.3481207*f1.x + -0.043433346*g1.x + 0.24575688*h1.x + -0.08716174*i1.x;
    float n = -0.083043255*a1.y + -0.0018384286*b1.y + 0.077247486*c1.y + -0.10015612*d1.y + -0.02895449*e1.y + -0.0034695133*f1.y + -0.08432179*g1.y + -0.018412631*h1.y + 0.048789904*i1.y;
    float o = -0.02007061*a1.z + 0.019421883*b1.z + 0.020988448*c1.z + 0.06899935*d1.z + 0.08572854*e1.z + 0.022193762*f1.z + -0.024855195*g1.z + 0.0017533574*h1.z + -0.12034477*i1.z;
    float p = -0.029753547*a1.w + 0.056169406*b1.w + -0.02607546*c1.w + -0.13830246*d1.w + 0.11301596*e1.w + -0.10754139*f1.w + 0.030982474*g1.w + -0.12194179*h1.w + -0.036577355*i1.w;
    float q = 0.056209657*na0.x + 0.14330581*nb0.x + 0.025293726*nc0.x + -0.21342021*nd0.x + -0.084453605*ne0.x + 0.115266524*nf0.x + -0.12682225*ng0.x + -0.3689846*nh0.x + -0.07184923*ni0.x;
    float r = 0.049175244*na0.y + 0.0051955744*nb0.y + -0.161476*nc0.y + -0.27953863*nd0.y + -0.3501893*ne0.y + -0.029806182*nf0.y + -0.13269718*ng0.y + -0.078298844*nh0.y + -0.100507766*ni0.y;
    float s = -0.021728419*na0.z + 0.2949833*nb0.z + 0.04041976*nc0.z + -0.22645602*nd0.z + 0.0043244623*ne0.z + -0.07251154*nf0.z + -0.04249778*ng0.z + -0.022189863*nh0.z + 0.034809884*ni0.z;
    float t = -0.04636795*na0.w + -0.070915006*nb0.w + 0.16660848*nc0.w + -0.038829613*nd0.w + -0.018555382*ne0.w + 0.090619646*nf0.w + -0.063014254*ng0.w + 0.041635923*nh0.w + 0.04670918*ni0.w;
    float u = -0.08293028*na1.x + -0.10538213*nb1.x + -0.05078218*nc1.x + -0.009467721*nd1.x + -0.24456158*ne1.x + -0.042963307*nf1.x + -0.050950877*ng1.x + -0.12885745*nh1.x + 0.032130353*ni1.x;
    float v = 0.008749523*na1.y + 0.075966515*nb1.y + -0.07249367*nc1.y + 0.08500086*nd1.y + -0.034895904*ne1.y + 0.0063278098*nf1.y + 0.11463324*ng1.y + 0.16510871*nh1.y + 0.11060035*ni1.y;
    float w = 0.0145977605*na1.z + -0.011436806*nb1.z + -0.14411648*nc1.z + -0.09809371*nd1.z + -0.11482118*ne1.z + 0.02429512*nf1.z + 0.045754995*ng1.z + 0.0038492538*nh1.z + 0.016950041*ni1.z;
    float x = -0.00016985212*na1.w + -0.21708094*nb1.w + -0.015174203*nc1.w + 0.11822005*nd1.w + -0.07034816*ne1.w + 0.09898518*nf1.w + -0.026325967*ng1.w + 0.04686595*nh1.w + -0.090023234*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.023285406;
    i = -0.010824311*a0.x + -0.051164586*b0.x + 0.27670133*c0.x + 0.025654908*d0.x + -0.16047996*e0.x + 0.101701476*f0.x + 0.20869365*g0.x + 0.1551052*h0.x + -0.04961477*i0.x;
    j = -0.04719406*a0.y + -0.07095295*b0.y + -0.04231228*c0.y + 0.07927513*d0.y + 0.38385487*e0.y + -0.01641401*f0.y + 0.088219166*g0.y + 0.13669278*h0.y + 0.20710975*i0.y;
    k = 0.037131984*a0.z + -0.21383446*b0.z + 0.03858047*c0.z + -0.07852924*d0.z + 0.011736041*e0.z + -0.018761475*f0.z + -0.09981803*g0.z + -0.12974207*h0.z + 0.03911999*i0.z;
    l = 0.02382806*a0.w + -0.10670318*b0.w + 0.011510644*c0.w + -0.1161868*d0.w + 0.0041843294*e0.w + 0.016270278*f0.w + 0.069239296*g0.w + -0.028811965*h0.w + -0.04534862*i0.w;
    m = -0.044963628*a1.x + -0.01751885*b1.x + -0.10190605*c1.x + 0.059436988*d1.x + 0.14531457*e1.x + -0.23966753*f1.x + -0.1271861*g1.x + -0.07273356*h1.x + 0.07296893*i1.x;
    n = 0.022063058*a1.y + 0.06588515*b1.y + -0.02025325*c1.y + -0.074304804*d1.y + -0.3432966*e1.y + 0.03045909*f1.y + -0.12180348*g1.y + -0.051952507*h1.y + 0.016071681*i1.y;
    o = -0.026687931*a1.z + -0.011702836*b1.z + -0.018618263*c1.z + -0.09509828*d1.z + -0.13936874*e1.z + 0.09854914*f1.z + -0.065601945*g1.z + -0.041659098*h1.z + -0.041994475*i1.z;
    p = -0.033111252*a1.w + -0.12730075*b1.w + -0.042272773*c1.w + 0.07217914*d1.w + 0.15409409*e1.w + -0.0044050133*f1.w + -0.013193102*g1.w + -0.028257802*h1.w + -0.102279514*i1.w;
    q = -0.0011312288*na0.x + -0.039966878*nb0.x + 0.008169095*nc0.x + 0.1176138*nd0.x + -0.23989339*ne0.x + -0.018491985*nf0.x + -0.1523537*ng0.x + -0.010189696*nh0.x + 0.0815769*ni0.x;
    r = 0.01800503*na0.y + 0.15263285*nb0.y + 0.04650022*nc0.y + -0.13463746*nd0.y + -0.27009314*ne0.y + 0.01367243*nf0.y + -0.22182891*ng0.y + -0.19270231*nh0.y + -0.11944978*ni0.y;
    s = 0.18900774*na0.z + 0.2452615*nb0.z + 0.019770019*nc0.z + 0.0037184495*nd0.z + 0.07873577*ne0.z + 0.1459445*nf0.z + 0.16317609*ng0.z + 0.18358271*nh0.z + -0.005921751*ni0.z;
    t = -0.001758597*na0.w + -0.04255167*nb0.w + -0.039924048*nc0.w + 0.07788507*nd0.w + 0.02266053*ne0.w + -0.048366588*nf0.w + 0.09384315*ng0.w + 0.10784829*nh0.w + 0.07399594*ni0.w;
    u = -0.05568954*na1.x + -0.16227238*nb1.x + -0.18156245*nc1.x + -0.12531707*nd1.x + -0.041247047*ne1.x + -0.09639712*nf1.x + 0.033412196*ng1.x + -0.05420894*nh1.x + -0.093623616*ni1.x;
    v = 0.034429446*na1.y + -0.06343978*nb1.y + 0.02254936*nc1.y + 0.0943558*nd1.y + 0.42765942*ne1.y + 0.06764561*nf1.y + 0.07859029*ng1.y + 0.01776498*nh1.y + -0.022389429*ni1.y;
    w = -0.017445106*na1.z + -0.1185644*nb1.z + -0.08676281*nc1.z + -0.06505645*nd1.z + -0.034937456*ne1.z + -0.15074748*nf1.z + 0.021122504*ng1.z + 0.0059979744*nh1.z + 0.10534208*ni1.z;
    x = -0.00053062243*na1.w + 0.0734179*nb1.w + -0.06674257*nc1.w + -0.121134385*nd1.w + 0.10454449*ne1.w + -0.097229205*nf1.w + -0.14843033*ng1.w + 0.039904114*nh1.w + 0.123104535*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.03842096;
    i = 0.09437239*a0.x + 0.13398713*b0.x + 0.1979105*c0.x + -0.13101088*d0.x + 0.3024643*e0.x + 0.21643195*f0.x + 0.17110038*g0.x + 0.25579646*h0.x + 0.491231*i0.x;
    j = 0.119239025*a0.y + -0.005078826*b0.y + 0.06520955*c0.y + -0.07381558*d0.y + -0.20958072*e0.y + 0.12261875*f0.y + 0.005449452*g0.y + 0.024978561*h0.y + -0.018444*i0.y;
    k = 0.11646403*a0.z + 0.04598884*b0.z + 0.18244609*c0.z + -0.17297442*d0.z + -0.3503025*e0.z + 0.028473197*f0.z + 0.009787073*g0.z + 0.12604016*h0.z + 0.03578933*i0.z;
    l = -0.13558882*a0.w + -0.0004211131*b0.w + 0.017237354*c0.w + -0.010725203*d0.w + 0.038099974*e0.w + -0.039385892*f0.w + -0.09769444*g0.w + -0.10143334*h0.w + 0.091641724*i0.w;
    m = -0.04192423*a1.x + 0.08233079*b1.x + 0.11315233*c1.x + 0.009459983*d1.x + 0.094343804*e1.x + 0.21664256*f1.x + 0.037537515*g1.x + -0.018830419*h1.x + -0.10526479*i1.x;
    n = -0.0118954545*a1.y + 0.20957565*b1.y + 0.23365454*c1.y + 0.008078816*d1.y + 0.14520495*e1.y + 0.15520053*f1.y + -0.076743595*g1.y + 0.19146152*h1.y + -0.059763126*i1.y;
    o = -0.0321574*a1.z + 0.056251407*b1.z + 0.061999843*c1.z + -0.03410336*d1.z + 0.042447362*e1.z + 0.17759623*f1.z + -0.0075536836*g1.z + 0.07079352*h1.z + -0.023566507*i1.z;
    p = -0.056103203*a1.w + -0.10488084*b1.w + -0.20350598*c1.w + -0.037546467*d1.w + -0.1716325*e1.w + -0.18705478*f1.w + -0.11137474*g1.w + -0.26239237*h1.w + -0.0650922*i1.w;
    q = 0.0028324497*na0.x + 0.05103814*nb0.x + 0.044681083*nc0.x + 0.18316808*nd0.x + -0.28045008*ne0.x + 0.067069866*nf0.x + -0.19181287*ng0.x + -0.09849666*nh0.x + 0.12940155*ni0.x;
    r = 0.09483203*na0.y + 0.3539591*nb0.y + 0.060038615*nc0.y + -0.13552736*nd0.y + 0.0928684*ne0.y + 0.003215415*nf0.y + -0.051365677*ng0.y + -0.086155534*nh0.y + -0.18595453*ni0.y;
    s = 0.05942614*na0.z + 0.193376*nb0.z + -0.09784394*nc0.z + 0.05096658*nd0.z + -0.070978366*ne0.z + -0.019585976*nf0.z + -0.08555191*ng0.z + -0.22733821*nh0.z + -0.014307356*ni0.z;
    t = 0.24031532*na0.w + 0.059133667*nb0.w + 0.12544549*nc0.w + 0.012513658*nd0.w + 0.32163772*ne0.w + 0.20125918*nf0.w + 0.053959697*ng0.w + 0.13063285*nh0.w + 0.12090184*ni0.w;
    u = -0.105667464*na1.x + -0.10932421*nb1.x + -0.15408312*nc1.x + 0.04899373*nd1.x + 0.07510841*ne1.x + -0.20361173*nf1.x + -0.043369625*ng1.x + 0.01743366*nh1.x + -0.04387706*ni1.x;
    v = -0.014914074*na1.y + -0.088104874*nb1.y + -0.13474074*nc1.y + -0.12898755*nd1.y + -0.2159242*ne1.y + -0.017311292*nf1.y + 0.059139296*ng1.y + -0.02463293*nh1.y + 0.102143966*ni1.y;
    w = 0.20635265*na1.z + 0.12899849*nb1.z + -0.13934886*nc1.z + -0.025166152*nd1.z + 0.19824727*ne1.z + 0.0476692*nf1.z + 0.08188326*ng1.z + 0.16099016*nh1.z + 0.121255964*ni1.z;
    x = -0.057871774*na1.w + -0.14890087*nb1.w + -0.036178485*nc1.w + -0.11591994*nd1.w + -0.17214559*ne1.w + 0.066402994*nf1.w + 0.088192135*ng1.w + 0.05370566*nh1.w + -0.08887657*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.018936345;
    i = -0.110597*a0.x + 0.14439704*b0.x + 0.07974332*c0.x + -0.029453456*d0.x + 0.078683145*e0.x + 0.121442296*f0.x + -0.13931674*g0.x + -0.15240826*h0.x + -0.0059107463*i0.x;
    j = 0.036193337*a0.y + -0.042138703*b0.y + 0.017361153*c0.y + -0.077247314*d0.y + 0.033903867*e0.y + -0.15094012*f0.y + 0.09833268*g0.y + 0.0471915*h0.y + 0.042530224*i0.y;
    k = 0.022343786*a0.z + 0.1771308*b0.z + 0.023711894*c0.z + -0.004949796*d0.z + 0.091341995*e0.z + 0.0115282*f0.z + 0.111846566*g0.z + 0.1449886*h0.z + -0.007880583*i0.z;
    l = 0.06515425*a0.w + 0.07250873*b0.w + 0.07384295*c0.w + 0.037702788*d0.w + 0.30957448*e0.w + 0.1728089*f0.w + -0.0011135521*g0.w + 0.073804356*h0.w + -0.07097225*i0.w;
    m = -0.059413772*a1.x + -0.11423178*b1.x + -0.0700013*c1.x + 0.007900054*d1.x + -0.45595673*e1.x + 0.12823504*f1.x + -0.14837785*g1.x + -0.06934808*h1.x + 0.06862923*i1.x;
    n = 0.007177377*a1.y + -0.04293527*b1.y + 0.04063131*c1.y + -0.043710213*d1.y + 0.09957697*e1.y + -0.16395952*f1.y + -0.03072646*g1.y + 0.0051787533*h1.y + 0.061441462*i1.y;
    o = 0.069179684*a1.z + 0.116715014*b1.z + -0.010597147*c1.z + -0.0020988528*d1.z + 0.08299716*e1.z + -0.041164685*f1.z + -0.04620522*g1.z + -0.009105994*h1.z + -0.10926514*i1.z;
    p = 0.030827038*a1.w + -0.035137884*b1.w + 0.08008966*c1.w + -0.0067170095*d1.w + -0.004441314*e1.w + 0.02607193*f1.w + -0.09919228*g1.w + -0.054578528*h1.w + -0.016953837*i1.w;
    q = -0.12492103*na0.x + 0.06447065*nb0.x + 0.06314454*nc0.x + -0.21107356*nd0.x + -0.07198418*ne0.x + 0.20510519*nf0.x + 0.09715707*ng0.x + -0.117380224*nh0.x + 0.01743949*ni0.x;
    r = 0.055481322*na0.y + 0.2807053*nb0.y + 0.017788293*nc0.y + -0.007054203*nd0.y + -0.021603152*ne0.y + 0.030201485*nf0.y + 0.092528746*ng0.y + 0.021230493*nh0.y + -0.044057943*ni0.y;
    s = -0.12875526*na0.z + -0.04763216*nb0.z + -0.063952245*nc0.z + -0.1002236*nd0.z + -0.28400442*ne0.z + 0.004502422*nf0.z + -0.10722054*ng0.z + -0.11645166*nh0.z + 0.01232295*ni0.z;
    t = -0.08266725*na0.w + 0.041546606*nb0.w + -0.040076066*nc0.w + -0.13500398*nd0.w + -0.22226901*ne0.w + -0.09316429*nf0.w + -0.0060878615*ng0.w + -0.055560965*nh0.w + 0.08122037*ni0.w;
    u = -0.0042413883*na1.x + -0.061129585*nb1.x + 0.105731405*nc1.x + 0.08033816*nd1.x + 0.3060952*ne1.x + 0.30381104*nf1.x + 0.044904403*ng1.x + 0.007477402*nh1.x + -0.06733228*ni1.x;
    v = -0.047427956*na1.y + 0.03387862*nb1.y + -0.024295041*nc1.y + 0.03468945*nd1.y + -0.14339851*ne1.y + 0.114759035*nf1.y + -0.06987076*ng1.y + 0.11075623*nh1.y + 0.04302722*ni1.y;
    w = -0.017457472*na1.z + 0.0503154*nb1.z + -0.011205378*nc1.z + -0.0068278625*nd1.z + 0.06237739*ne1.z + 0.04317868*nf1.z + -0.007881838*ng1.z + 0.02493619*nh1.z + -0.0025645192*ni1.z;
    x = 0.0121476855*na1.w + -0.076116875*nb1.w + -0.046628572*nc1.w + 0.0071924813*nd1.w + -0.23273*ne1.w + -0.116542414*nf1.w + -0.014419636*ng1.w + -0.062192116*nh1.w + -0.057106964*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.010890064;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN40
//!BIND LUMAN41
//!SAVE LUMAN51

#define L0_tex LUMAN40_tex
#define L1_tex LUMAN41_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.056090385*a0.x + -0.21354978*b0.x + 0.022244206*c0.x + -0.0038582683*d0.x + -0.4012598*e0.x + 0.12896599*f0.x + 0.028825298*g0.x + -0.29657465*h0.x + -0.06449916*i0.x;
    float j = 0.026674105*a0.y + -0.073722854*b0.y + -0.041813698*c0.y + 0.11658765*d0.y + 0.3502272*e0.y + 0.06097762*f0.y + 0.05928873*g0.y + -0.005221818*h0.y + -0.16896306*i0.y;
    float k = -0.08193254*a0.z + 0.041702736*b0.z + -0.15537265*c0.z + 0.11105868*d0.z + 0.3349596*e0.z + -0.1513197*f0.z + 0.08305401*g0.z + 0.07004251*h0.z + 0.18821335*i0.z;
    float l = -0.095114745*a0.w + -0.11035136*b0.w + 0.00035387988*c0.w + 0.0019896766*d0.w + 0.06287483*e0.w + -0.036226697*f0.w + 0.034236606*g0.w + -0.14316571*h0.w + 0.12548448*i0.w;
    float m = -0.012757697*a1.x + -0.0424596*b1.x + 0.07418381*c1.x + 0.017576486*d1.x + 0.11420773*e1.x + 0.09729983*f1.x + -0.09684233*g1.x + 0.015091571*h1.x + -0.059635445*i1.x;
    float n = -0.04934384*a1.y + 0.0583751*b1.y + 0.00020525829*c1.y + -0.07054101*d1.y + -0.1676501*e1.y + -0.16150194*f1.y + -0.092985466*g1.y + 0.113083154*h1.y + 0.050833102*i1.y;
    float o = -0.022584658*a1.z + -0.09515754*b1.z + 0.03568323*c1.z + -0.047969703*d1.z + -0.11314889*e1.z + -0.115591094*f1.z + -0.016234715*g1.z + -0.025610313*h1.z + -0.07118454*i1.z;
    float p = 0.07897343*a1.w + 0.03182414*b1.w + 0.08555049*c1.w + 0.122302584*d1.w + 0.25546962*e1.w + 0.08809629*f1.w + 0.080174565*g1.w + -0.03668826*h1.w + 0.08251504*i1.w;
    float q = 0.08174073*na0.x + -0.0051570395*nb0.x + -0.0133568*nc0.x + -0.070082866*nd0.x + 0.23727296*ne0.x + -0.086276196*nf0.x + -0.076185346*ng0.x + -0.0559138*nh0.x + 0.015404762*ni0.x;
    float r = -0.08720322*na0.y + -0.05951848*nb0.y + 0.034683157*nc0.y + -0.17522079*nd0.y + -0.35350683*ne0.y + -0.25798985*nf0.y + 0.018907735*ng0.y + 0.018688858*nh0.y + 0.038296565*ni0.y;
    float s = 0.02662396*na0.z + 0.06100318*nb0.z + 0.0680031*nc0.z + 0.035090797*nd0.z + -0.2585021*ne0.z + 0.16387142*nf0.z + -0.016490232*ng0.z + 0.012245514*nh0.z + -0.08640067*ni0.z;
    float t = 0.09162307*na0.w + 0.16067226*nb0.w + -0.06062272*nc0.w + -0.05303003*nd0.w + -0.18600427*ne0.w + -0.045804538*nf0.w + -0.12862766*ng0.w + 0.036286026*nh0.w + -0.18143234*ni0.w;
    float u = 0.012268778*na1.x + 0.012088465*nb1.x + 0.07320402*nc1.x + 0.021589423*nd1.x + -0.14693566*ne1.x + 0.10664899*nf1.x + 0.12277371*ng1.x + 0.05519008*nh1.x + 0.041153215*ni1.x;
    float v = 0.09537083*na1.y + -0.045650475*nb1.y + 0.005396567*nc1.y + 0.2421518*nd1.y + 0.053676106*ne1.y + 0.13822643*nf1.y + 0.060495824*ng1.y + 0.06461739*nh1.y + -0.018778283*ni1.y;
    float w = -0.07602112*na1.z + 0.061583236*nb1.z + -0.033689767*nc1.z + -0.03578945*nd1.z + -0.08015314*ne1.z + -0.1077307*nf1.z + -0.043930896*ng1.z + -0.054180264*nh1.z + -0.05338287*ni1.z;
    float x = -0.023978792*na1.w + -0.13703878*nb1.w + 0.022100048*nc1.w + -0.18234284*nd1.w + -0.27772492*ne1.w + -0.046820987*nf1.w + -0.03914553*ng1.w + 0.067679755*nh1.w + 0.03914887*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0023595907;
    i = 0.074523576*a0.x + -0.0057058106*b0.x + 0.1495846*c0.x + 0.07862369*d0.x + 0.2601132*e0.x + 0.055141743*f0.x + -0.055496864*g0.x + 0.17406371*h0.x + 0.03363062*i0.x;
    j = -0.05768032*a0.y + 0.15153283*b0.y + 0.022397926*c0.y + 0.041255094*d0.y + -0.15575399*e0.y + 0.004296451*f0.y + -0.10716406*g0.y + 0.17955858*h0.y + -0.056085326*i0.y;
    k = 0.0767875*a0.z + 0.15396415*b0.z + 0.12849167*c0.z + -0.019631831*d0.z + -0.23114394*e0.z + 0.0637445*f0.z + -0.005215477*g0.z + -0.05406419*h0.z + 0.10674206*i0.z;
    l = 0.005438333*a0.w + 0.057442818*b0.w + 0.076435395*c0.w + -0.13085583*d0.w + 0.025045734*e0.w + -0.02133746*f0.w + 0.004774787*g0.w + -0.078436404*h0.w + 0.0770084*i0.w;
    m = 0.049647626*a1.x + -0.03611224*b1.x + -0.02900914*c1.x + -0.0297745*d1.x + -0.07690945*e1.x + 0.126761*f1.x + -0.029992094*g1.x + -0.022881499*h1.x + 0.002003654*i1.x;
    n = -0.021211253*a1.y + 0.035476483*b1.y + 0.0066271857*c1.y + 0.15816237*d1.y + 0.08037103*e1.y + 0.078838296*f1.y + 0.13713017*g1.y + 0.009883336*h1.y + 0.03251063*i1.y;
    o = 0.035349734*a1.z + 0.07648513*b1.z + 0.06887409*c1.z + 0.046504598*d1.z + 0.15764192*e1.z + 0.06933311*f1.z + 0.011121327*g1.z + 0.007391677*h1.z + -0.034738954*i1.z;
    p = -0.067246154*a1.w + -0.09859619*b1.w + -0.05811951*c1.w + -0.113591455*d1.w + -0.03732589*e1.w + -0.11367689*f1.w + -0.020308692*g1.w + -0.1417131*h1.w + -0.08917582*i1.w;
    q = -0.027683554*na0.x + 0.15755071*nb0.x + -0.003439709*nc0.x + -0.012204899*nd0.x + 0.17021354*ne0.x + 0.052708283*nf0.x + 0.13149692*ng0.x + 0.090040006*nh0.x + 0.082834296*ni0.x;
    r = 0.08598448*na0.y + -0.06366249*nb0.y + 0.06250332*nc0.y + 0.07564566*nd0.y + 0.06026603*ne0.y + 0.02985282*nf0.y + -0.0016011299*ng0.y + -0.07034113*nh0.y + -0.012777306*ni0.y;
    s = -0.081845134*na0.z + -0.059878513*nb0.z + -0.059053805*nc0.z + -0.07074469*nd0.z + 0.11270868*ne0.z + -0.07313795*nf0.z + -0.009732927*ng0.z + -0.03957525*nh0.z + -0.11639261*ni0.z;
    t = 0.012251858*na0.w + -0.016193997*nb0.w + 0.037083402*nc0.w + 0.15208524*nd0.w + 0.16492158*ne0.w + 0.09038345*nf0.w + 0.05002708*ng0.w + 0.06938181*nh0.w + 0.035729285*ni0.w;
    u = -0.08110931*na1.x + -0.061242368*nb1.x + -0.04353678*nc1.x + 0.018317655*nd1.x + 0.04822334*ne1.x + -0.076507956*nf1.x + -0.06782663*ng1.x + -0.026877085*nh1.x + -0.0077283815*ni1.x;
    v = -0.02637395*na1.y + 0.021053223*nb1.y + 0.012836627*nc1.y + -0.14172155*nd1.y + -0.067660406*ne1.y + -0.058461625*nf1.y + -0.01881357*ng1.y + -0.11821575*nh1.y + 0.0023459315*ni1.y;
    w = 0.046686847*na1.z + 0.052543245*nb1.z + -0.04574683*nc1.z + 0.02516899*nd1.z + -0.061450865*ne1.z + -0.03359517*nf1.z + 0.005574621*ng1.z + 0.06778139*nh1.z + 0.10011491*ni1.z;
    x = 0.06502524*na1.w + -0.0040995805*nb1.w + -0.015988229*nc1.w + 0.11461034*nd1.w + -0.15330766*ne1.w + 0.040734354*nf1.w + 0.0053051845*ng1.w + 0.23152955*nh1.w + -0.0368622*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.02745514;
    i = -0.01857899*a0.x + -0.092307605*b0.x + 0.23468553*c0.x + -0.008275093*d0.x + 0.0299927*e0.x + 0.04424954*f0.x + 0.28297913*g0.x + 0.13633645*h0.x + 0.15201968*i0.x;
    j = 0.016598519*a0.y + 0.054542385*b0.y + 0.01263706*c0.y + -0.00012104201*d0.y + 0.076503254*e0.y + -0.044411242*f0.y + -0.025271175*g0.y + 0.0646408*h0.y + -0.13263232*i0.y;
    k = -0.01718374*a0.z + -0.12544994*b0.z + 0.06670591*c0.z + 0.015052461*d0.z + -0.18256845*e0.z + -0.011040225*f0.z + -0.03879542*g0.z + 0.046089746*h0.z + 0.09762668*i0.z;
    l = 0.12880234*a0.w + 0.13655676*b0.w + -0.055386145*c0.w + 2.7221502e-05*d0.w + -0.1837622*e0.w + -0.05390036*f0.w + 0.11130797*g0.w + -0.06714729*h0.w + 0.09534897*i0.w;
    m = -0.035553545*a1.x + -0.077911995*b1.x + 0.09121035*c1.x + 0.12778811*d1.x + -0.2663*e1.x + 0.053164348*f1.x + -0.046842456*g1.x + -0.007667375*h1.x + -0.08408594*i1.x;
    n = -0.0474031*a1.y + 0.055257063*b1.y + 0.005891854*c1.y + -0.10317752*d1.y + 0.03853582*e1.y + 0.033959396*f1.y + -0.115612805*g1.y + 0.05966341*h1.y + 0.07382099*i1.y;
    o = -0.04195247*a1.z + -0.0042094598*b1.z + 0.10695232*c1.z + -0.056741405*d1.z + -0.30472994*e1.z + 0.005160417*f1.z + 0.014849301*g1.z + -0.024300938*h1.z + -0.053432226*i1.z;
    p = 0.0020989536*a1.w + -0.015926143*b1.w + -0.044968095*c1.w + -0.012733179*d1.w + 0.0393187*e1.w + 0.0011893001*f1.w + 0.011631138*g1.w + -0.11833222*h1.w + 0.020912772*i1.w;
    q = 0.008642761*na0.x + -0.08873245*nb0.x + 0.01787369*nc0.x + 0.14553125*nd0.x + -0.58352995*ne0.x + 0.10984562*nf0.x + -0.1902785*ng0.x + -0.21255754*nh0.x + 0.110708214*ni0.x;
    r = -0.25730217*na0.y + -0.17411886*nb0.y + 0.050862312*nc0.y + -0.29447538*nd0.y + -0.08723386*ne0.y + -0.07595737*nf0.y + -0.061803184*ng0.y + -0.09596136*nh0.y + -0.004391057*ni0.y;
    s = -0.05154969*na0.z + 0.05528125*nb0.z + -0.10029961*nc0.z + -0.20609719*nd0.z + 0.25845483*ne0.z + -0.05684945*nf0.z + 0.07435376*ng0.z + 0.014821872*nh0.z + -0.061488997*ni0.z;
    t = -0.023973742*na0.w + -0.13101381*nb0.w + 0.015695877*nc0.w + -0.00094274344*nd0.w + 0.21626495*ne0.w + 0.029855108*nf0.w + -0.134424*ng0.w + 0.11344095*nh0.w + -0.0688341*ni0.w;
    u = 0.006327158*na1.x + 0.1400969*nb1.x + -0.115483135*nc1.x + 0.02067186*nd1.x + 0.6160511*ne1.x + -0.11206414*nf1.x + 0.012858851*ng1.x + 0.11192121*nh1.x + 0.12743135*ni1.x;
    v = 0.05244468*na1.y + -0.06280365*nb1.y + 0.019899432*nc1.y + 0.07587428*nd1.y + -0.14695287*ne1.y + 0.026428325*nf1.y + 0.062318433*ng1.y + -0.031316523*nh1.y + 0.0015856139*ni1.y;
    w = 0.01552606*na1.z + -0.022213168*nb1.z + -0.1368877*nc1.z + -0.061803505*nd1.z + 0.157332*ne1.z + -0.055489*nf1.z + 0.0029063963*ng1.z + 0.07240079*nh1.z + 0.010527223*ni1.z;
    x = 0.024937052*na1.w + -0.0075372527*nb1.w + 0.04825707*nc1.w + -0.13231899*nd1.w + 0.1424721*ne1.w + -0.047129158*nf1.w + -0.090350956*ng1.w + 0.06530548*nh1.w + -0.03276755*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.016945923;
    i = -0.20472403*a0.x + -0.5440036*b0.x + -0.3415662*c0.x + 0.05028589*d0.x + -0.34596926*e0.x + -0.1575801*f0.x + -0.24130724*g0.x + -0.111981355*h0.x + -0.22872117*i0.x;
    j = 0.044235244*a0.y + 0.007408926*b0.y + -0.24718694*c0.y + 0.06598211*d0.y + -0.07944181*e0.y + -0.041312583*f0.y + -0.07749238*g0.y + -0.07008483*h0.y + -0.15196827*i0.y;
    k = 0.1394436*a0.z + 0.38492495*b0.z + -0.07301584*c0.z + 0.12015508*d0.z + -0.12864132*e0.z + -0.062012754*f0.z + -0.061071713*g0.z + -0.009352104*h0.z + 0.022086248*i0.z;
    l = -0.10533721*a0.w + 0.1136085*b0.w + 0.09260235*c0.w + 0.16164571*d0.w + 0.050596695*e0.w + -0.042681392*f0.w + 0.11215146*g0.w + 0.18171057*h0.w + -0.044888046*i0.w;
    m = -0.02860989*a1.x + -0.016434899*b1.x + -0.0038043826*c1.x + -0.08402011*d1.x + -0.23148729*e1.x + 0.046447888*f1.x + -0.088443585*g1.x + -0.059526023*h1.x + 0.037529606*i1.x;
    n = -0.038139734*a1.y + -0.14247769*b1.y + -0.2032673*c1.y + 0.032973308*d1.y + 0.16246238*e1.y + -0.00042745384*f1.y + 0.18080023*g1.y + -0.146968*h1.y + 0.042115618*i1.y;
    o = -0.10349262*a1.z + -0.19341536*b1.z + -0.057436164*c1.z + -0.20337299*d1.z + -0.052316416*e1.z + -0.17337418*f1.z + 0.066893056*g1.z + 0.003318179*h1.z + -0.013517227*i1.z;
    p = 0.060909916*a1.w + 0.054543044*b1.w + 0.18993464*c1.w + 0.124290615*d1.w + 0.39217323*e1.w + 0.16063812*f1.w + 0.09056663*g1.w + 0.16192786*h1.w + 0.025336025*i1.w;
    q = 0.18991727*na0.x + -0.00027004647*nb0.x + 0.14546877*nc0.x + 0.41973418*nd0.x + -0.3041173*ne0.x + 0.11617702*nf0.x + 0.22507893*ng0.x + -0.06283164*nh0.x + -0.11073948*ni0.x;
    r = -0.10698047*na0.y + -0.10182019*nb0.y + 0.032850496*nc0.y + 0.1551779*nd0.y + -0.1004046*ne0.y + -0.095385954*nf0.y + 0.050851043*ng0.y + 0.17835791*nh0.y + 0.087634064*ni0.y;
    s = 0.0058534653*na0.z + -0.15356995*nb0.z + 0.07764963*nc0.z + -0.031784218*nd0.z + 0.3259575*ne0.z + -0.01998434*nf0.z + 0.05851326*ng0.z + 0.029404469*nh0.z + 0.07388124*ni0.z;
    t = -0.10876924*na0.w + -0.020953424*nb0.w + -0.079560705*nc0.w + -0.02719251*nd0.w + -0.4081154*ne0.w + -0.0029835652*nf0.w + -0.03687583*ng0.w + -0.33821964*nh0.w + -0.12425579*ni0.w;
    u = 0.09229234*na1.x + 0.090341*nb1.x + 0.13298485*nc1.x + 0.17295581*nd1.x + 0.36484036*ne1.x + 0.16058661*nf1.x + 0.102394134*ng1.x + 0.16044867*nh1.x + 0.15259685*ni1.x;
    v = 0.15718122*na1.y + 0.072678976*nb1.y + 0.14487597*nc1.y + -0.05968116*nd1.y + -0.08476398*ne1.y + -0.13279647*nf1.y + -0.23609617*ng1.y + -0.14004059*nh1.y + -0.032762706*ni1.y;
    w = -0.115983024*na1.z + -0.0353234*nb1.z + 0.16114388*nc1.z + 0.11989774*nd1.z + -0.15475188*ne1.z + 0.015697762*nf1.z + -0.036263574*ng1.z + -0.09506931*nh1.z + -0.08309461*ni1.z;
    x = -0.0009906742*na1.w + 0.043757707*nb1.w + 0.038789403*nc1.w + -0.17851372*nd1.w + 0.021087*ne1.w + 0.02302371*nf1.w + -0.03420213*ng1.w + -0.0016994842*nh1.w + -0.039775606*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.011434225;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN50
//!BIND LUMAN51
//!SAVE LUMAN60

#define L0_tex LUMAN50_tex
#define L1_tex LUMAN51_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.007900067*a0.x + 0.06111605*b0.x + 0.13362223*c0.x + -0.08097709*d0.x + 0.103360735*e0.x + -0.07250116*f0.x + 0.031838957*g0.x + -0.08329396*h0.x + 0.07071538*i0.x;
    float j = -0.100912035*a0.y + -0.014328106*b0.y + 0.080552615*c0.y + 0.072964214*d0.y + 0.20794426*e0.y + 0.1481695*f0.y + 0.070850804*g0.y + -0.076575726*h0.y + 0.041372977*i0.y;
    float k = -0.03987942*a0.z + 0.08942544*b0.z + 0.037421957*c0.z + 0.106816724*d0.z + 0.1251162*e0.z + -0.020023407*f0.z + 0.13727182*g0.z + 0.0875649*h0.z + 0.016416198*i0.z;
    float l = -0.0645122*a0.w + -0.10794101*b0.w + 0.019238126*c0.w + 0.018906446*d0.w + 0.053039797*e0.w + 0.20710008*f0.w + 0.07407084*g0.w + 0.24502033*h0.w + 0.053760402*i0.w;
    float m = -0.019182838*a1.x + 0.024340963*b1.x + -0.04285745*c1.x + -0.1267232*d1.x + -0.027013803*e1.x + -0.06522738*f1.x + 0.099756*g1.x + -0.0895132*h1.x + -0.06274337*i1.x;
    float n = 0.21720274*a1.y + 0.22679296*b1.y + 0.094728276*c1.y + 0.03987187*d1.y + 0.3363125*e1.y + 0.25583714*f1.y + 0.18515237*g1.y + 0.10880643*h1.y + 0.014202542*i1.y;
    float o = 0.04833541*a1.z + 0.022809451*b1.z + -0.060894404*c1.z + 0.029224632*d1.z + 0.13964699*e1.z + -0.079538874*f1.z + -0.12321884*g1.z + -0.0109314835*h1.z + -0.028924821*i1.z;
    float p = -0.099998884*a1.w + -0.06404399*b1.w + -0.013308858*c1.w + 0.0015877723*d1.w + 0.021802263*e1.w + -0.04523103*f1.w + 0.0009092714*g1.w + -0.1224042*h1.w + -0.10198278*i1.w;
    float q = -0.009989799*na0.x + -0.023531131*nb0.x + -0.016424935*nc0.x + 0.1580643*nd0.x + -0.07054254*ne0.x + 0.017178383*nf0.x + 0.12825544*ng0.x + 0.04345318*nh0.x + -0.025755657*ni0.x;
    float r = 0.05775632*na0.y + -0.073533855*nb0.y + -0.078828685*nc0.y + -0.09696127*nd0.y + -0.06458487*ne0.y + -0.15739019*nf0.y + -0.14344892*ng0.y + -0.023483401*nh0.y + -0.06177725*ni0.y;
    float s = 0.16263905*na0.z + 0.119967565*nb0.z + 0.058884792*nc0.z + -0.0016427131*nd0.z + 0.12633163*ne0.z + 0.12480811*nf0.z + -0.13420187*ng0.z + 0.22198138*nh0.z + 0.066704325*ni0.z;
    float t = 0.14367525*na0.w + 0.16780959*nb0.w + 0.13001716*nc0.w + -0.019490587*nd0.w + 0.017529594*ne0.w + -0.06288588*nf0.w + -0.008786988*ng0.w + -0.18995468*nh0.w + -0.0835717*ni0.w;
    float u = -0.072073266*na1.x + -0.15306944*nb1.x + 0.00436017*nc1.x + -0.03719954*nd1.x + -0.08704513*ne1.x + -0.040555727*nf1.x + -0.06939967*ng1.x + -0.047218878*nh1.x + 0.011211359*ni1.x;
    float v = 0.0530403*na1.y + -0.21789601*nb1.y + -0.110040896*nc1.y + -0.12080109*nd1.y + -0.063249566*ne1.y + -0.050723586*nf1.y + -0.00483581*ng1.y + 0.0133364545*nh1.y + 0.1337577*ni1.y;
    float w = -0.11044843*na1.z + 0.035734586*nb1.z + -0.009872459*nc1.z + -0.1027228*nd1.z + -0.15830374*ne1.z + 0.10537158*nf1.z + 0.057217788*ng1.z + -0.094153106*nh1.z + -0.09629833*ni1.z;
    float x = 0.10235088*na1.w + 0.048925947*nb1.w + -0.0071955076*nc1.w + 0.026082518*nd1.w + 0.047619376*ne1.w + -0.025943337*nf1.w + -0.028843133*ng1.w + -0.0053447234*nh1.w + 0.047757845*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0022438124;
    i = 0.05064848*a0.x + -0.20422895*b0.x + -0.048842456*c0.x + 0.14468466*d0.x + 0.045398735*e0.x + 0.11933529*f0.x + -0.09603952*g0.x + 0.11587896*h0.x + -0.08594006*i0.x;
    j = 0.051009253*a0.y + 0.020939386*b0.y + -0.056426525*c0.y + 0.111202724*d0.y + -0.27524063*e0.y + 0.25247937*f0.y + 0.15901652*g0.y + 0.18370955*h0.y + -0.0006100606*i0.y;
    k = 0.026922384*a0.z + -0.019294612*b0.z + 0.118673414*c0.z + -0.043769788*d0.z + -0.070539124*e0.z + -0.06258966*f0.z + -0.0041388213*g0.z + -0.0027373051*h0.z + -0.03782834*i0.z;
    l = 0.036438785*a0.w + -0.08447189*b0.w + -0.09808555*c0.w + -0.05171045*d0.w + -0.14444746*e0.w + -0.21831968*f0.w + 0.06325723*g0.w + -0.25083756*h0.w + 0.121623024*i0.w;
    m = -0.05461014*a1.x + -0.060001776*b1.x + 0.07407202*c1.x + -0.0008134506*d1.x + -0.21538503*e1.x + 0.17426263*f1.x + -0.081575185*g1.x + -0.021462401*h1.x + 0.10259248*i1.x;
    n = -0.028844604*a1.y + -0.1055795*b1.y + -0.12056408*c1.y + -0.06945176*d1.y + 0.24445438*e1.y + -0.04565883*f1.y + -0.10659118*g1.y + 0.060785856*h1.y + -0.041710086*i1.y;
    o = -0.0035760484*a1.z + 0.033717036*b1.z + 0.14456153*c1.z + -0.003583616*d1.z + 0.0428905*e1.z + 0.08271759*f1.z + -0.026236393*g1.z + -0.05663394*h1.z + -0.11643835*i1.z;
    p = 0.06603419*a1.w + -0.03694121*b1.w + 0.008290856*c1.w + 0.047380496*d1.w + 0.16152279*e1.w + 0.024927517*f1.w + 0.018398501*g1.w + 0.045266174*h1.w + 0.1532531*i1.w;
    q = 0.05501013*na0.x + 0.07717635*nb0.x + -0.08030905*nc0.x + -0.21632951*nd0.x + -0.2373707*ne0.x + -0.31690797*nf0.x + -0.054487124*ng0.x + -0.11547693*nh0.x + 0.11048151*ni0.x;
    r = -0.03760372*na0.y + 0.071262136*nb0.y + 0.050859585*nc0.y + -0.03484282*nd0.y + 0.10759817*ne0.y + 0.010887812*nf0.y + -0.0907616*ng0.y + -0.13002929*nh0.y + 0.039026946*ni0.y;
    s = -0.005286152*na0.z + 0.011639715*nb0.z + -0.09048027*nc0.z + 0.027714854*nd0.z + -0.1285118*ne0.z + 0.093528196*nf0.z + 0.003392913*ng0.z + -0.1098825*nh0.z + -0.0821848*ni0.z;
    t = -0.028145354*na0.w + 0.050427336*nb0.w + 0.043978024*nc0.w + 0.04701224*nd0.w + -0.08590698*ne0.w + 0.19342361*nf0.w + -0.043336395*ng0.w + 0.07020605*nh0.w + -0.11217858*ni0.w;
    u = 0.081151985*na1.x + 0.1695107*nb1.x + 0.08539623*nc1.x + 0.062478133*nd1.x + 0.027216671*ne1.x + -0.0007516228*nf1.x + 0.07613257*ng1.x + 0.011643803*nh1.x + -0.033885993*ni1.x;
    v = -0.040014226*na1.y + -0.05567425*nb1.y + -0.09321087*nc1.y + 0.13047898*nd1.y + -0.37765887*ne1.y + -0.5407485*nf1.y + 0.026491206*ng1.y + 0.215762*nh1.y + -0.20646265*ni1.y;
    w = -0.028338104*na1.z + -0.13641936*nb1.z + -0.0008554815*nc1.z + -0.026358705*nd1.z + -0.027189348*ne1.z + 0.014966428*nf1.z + 0.02931294*ng1.z + 0.13201293*nh1.z + 0.021129422*ni1.z;
    x = -0.0706693*na1.w + 0.027378365*nb1.w + -0.011388007*nc1.w + -0.016765244*nd1.w + -0.14355792*ne1.w + 0.16164084*nf1.w + 0.064222276*ng1.w + 0.06362779*nh1.w + 0.08947278*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0079668;
    i = -0.052216068*a0.x + 0.054898728*b0.x + 0.036882155*c0.x + 0.06379019*d0.x + -0.20955375*e0.x + -0.011356595*f0.x + 0.026242755*g0.x + -0.037986107*h0.x + 0.013255572*i0.x;
    j = -0.11782476*a0.y + -0.0209143*b0.y + 0.09975378*c0.y + 0.08051828*d0.y + 0.028034722*e0.y + -0.11601055*f0.y + 0.08857265*g0.y + 0.12780881*h0.y + 0.042145763*i0.y;
    k = -0.024772175*a0.z + -0.0046171104*b0.z + -0.027132677*c0.z + 0.05496378*d0.z + 0.10925047*e0.z + 0.14660946*f0.z + 0.04814382*g0.z + 0.11250083*h0.z + 0.21809563*i0.z;
    l = -0.048624218*a0.w + 0.036018074*b0.w + 0.018748894*c0.w + 0.04089426*d0.w + 0.03679874*e0.w + -0.024487058*f0.w + -0.006175484*g0.w + -0.12283346*h0.w + -0.09193407*i0.w;
    m = -0.044582702*a1.x + 0.04411854*b1.x + -0.020496923*c1.x + -0.17571406*d1.x + -0.17814021*e1.x + -0.13249502*f1.x + -0.016790845*g1.x + 0.14915213*h1.x + 0.06783924*i1.x;
    n = 0.062412664*a1.y + 0.01842933*b1.y + 0.008690827*c1.y + -0.23738204*d1.y + -0.2828378*e1.y + -0.07163012*f1.y + -0.029558232*g1.y + -0.08761727*h1.y + -0.24004433*i1.y;
    o = 0.023585051*a1.z + -0.069970764*b1.z + -0.04842618*c1.z + -0.007836811*d1.z + 0.28026676*e1.z + 0.06314062*f1.z + -0.07615924*g1.z + -0.33812356*h1.z + -0.04734389*i1.z;
    p = -0.0105614085*a1.w + -0.0010307096*b1.w + -0.049624432*c1.w + 0.07334713*d1.w + 0.023181029*e1.w + 0.22236523*f1.w + -0.036988813*g1.w + 0.08197461*h1.w + 0.112293564*i1.w;
    q = -0.04700814*na0.x + -0.092280574*nb0.x + -0.08462992*nc0.x + -0.11683497*nd0.x + 0.17987503*ne0.x + 0.06173114*nf0.x + 0.01673716*ng0.x + 0.06325463*nh0.x + -0.05398158*ni0.x;
    r = 0.056093518*na0.y + -0.029174399*nb0.y + 0.008268589*nc0.y + -0.038166087*nd0.y + 0.31754375*ne0.y + -0.076780386*nf0.y + -0.17114313*ng0.y + -0.32900494*nh0.y + -0.12613133*ni0.y;
    s = 0.022803396*na0.z + 0.06633487*nb0.z + 0.09868759*nc0.z + -0.03169617*nd0.z + -0.23164985*ne0.z + -0.1550096*nf0.z + -0.05340548*ng0.z + -0.30185044*nh0.z + -0.15606295*ni0.z;
    t = 0.047760352*na0.w + -0.023117915*nb0.w + -0.013897625*nc0.w + -0.022600356*nd0.w + -0.1053882*ne0.w + -0.064644404*nf0.w + -0.076259404*ng0.w + 0.08077569*nh0.w + 0.056261458*ni0.w;
    u = -0.036427572*na1.x + 0.013039251*nb1.x + 0.0008705984*nc1.x + 0.18672472*nd1.x + 0.25473928*ne1.x + 0.051945034*nf1.x + 0.036714926*ng1.x + -0.091437206*nh1.x + -0.07168086*ni1.x;
    v = -0.03265293*na1.y + -0.08496432*nb1.y + -0.0643857*nc1.y + 0.1900388*nd1.y + 0.21765114*ne1.y + 0.052614775*nf1.y + 0.07429901*ng1.y + 0.2578138*nh1.y + 0.22327712*ni1.y;
    w = 0.029738856*na1.z + 0.13880761*nb1.z + 0.016748065*nc1.z + -0.026210256*nd1.z + -0.26959187*ne1.z + -0.0051032137*nf1.z + 0.093300216*ng1.z + 0.2578347*nh1.z + 0.0731899*ni1.z;
    x = 0.023803368*na1.w + -0.022662397*nb1.w + 0.012398539*nc1.w + -0.07820376*nd1.w + -0.06055157*ne1.w + -0.061961398*nf1.w + 0.09714569*ng1.w + 0.01943341*nh1.w + -0.09513158*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0022567785;
    i = 0.015182305*a0.x + 0.24893573*b0.x + -0.0022004095*c0.x + 0.09184145*d0.x + -0.05798882*e0.x + 0.20459242*f0.x + -0.045849342*g0.x + 0.18169454*h0.x + -0.0020022106*i0.x;
    j = 0.06535713*a0.y + 0.067995876*b0.y + -0.15596136*c0.y + -0.0571899*d0.y + 0.16720164*e0.y + 0.29680288*f0.y + 0.07203544*g0.y + 0.12709936*h0.y + 0.08908467*i0.y;
    k = -0.035225604*a0.z + -0.01637087*b0.z + 0.08659167*c0.z + 0.011060907*d0.z + 0.32298514*e0.z + -0.026474915*f0.z + 0.017311417*g0.z + 0.09786248*h0.z + 0.14111069*i0.z;
    l = -0.013472993*a0.w + -0.20824556*b0.w + -0.12898146*c0.w + -0.014164601*d0.w + -0.005099344*e0.w + -0.10799987*f0.w + -0.035937253*g0.w + -0.011961274*h0.w + 0.013696468*i0.w;
    m = 0.0005670277*a1.x + -0.26264974*b1.x + -0.0048576635*c1.x + -0.09822187*d1.x + 0.04494708*e1.x + 0.025521396*f1.x + 0.00015683453*g1.x + -0.07115157*h1.x + -0.05619935*i1.x;
    n = -0.02532665*a1.y + 0.29243463*b1.y + 0.31513873*c1.y + -0.14378825*d1.y + 0.19135693*e1.y + 0.21406765*f1.y + 0.20193236*g1.y + 0.014083933*h1.y + -0.026462164*i1.y;
    o = 0.03566653*a1.z + -0.043557085*b1.z + -0.11857579*c1.z + -0.10190321*d1.z + 0.15822466*e1.z + -0.44667184*f1.z + -0.01721309*g1.z + -0.16478701*h1.z + -0.1190363*i1.z;
    p = -0.039312962*a1.w + 0.107173085*b1.w + -0.0672977*c1.w + -0.047271557*d1.w + 0.1652996*e1.w + -0.051441222*f1.w + -0.022646252*g1.w + -0.050653923*h1.w + 0.11192206*i1.w;
    q = 0.0137756765*na0.x + 0.10019253*nb0.x + 0.03521767*nc0.x + 0.031304695*nd0.x + 0.22698583*ne0.x + -0.19912961*nf0.x + 0.07153089*ng0.x + -0.02893902*nh0.x + 0.06328283*ni0.x;
    r = 0.0015052083*na0.y + -0.094727606*nb0.y + -0.12986736*nc0.y + -0.11083681*nd0.y + 0.03377681*ne0.y + -0.17758591*nf0.y + -0.06644192*ng0.y + -0.18634509*nh0.y + -0.0352864*ni0.y;
    s = -0.008672401*na0.z + -0.001848777*nb0.z + -0.0126453405*nc0.z + 0.016603608*nd0.z + -0.05969051*ne0.z + 0.16930741*nf0.z + 0.0012650864*ng0.z + -0.06459553*nh0.z + -0.12883076*ni0.z;
    t = -0.03171965*na0.w + 0.1401744*nb0.w + 0.19563067*nc0.w + -0.12079*nd0.w + 0.082978256*ne0.w + 0.079056926*nf0.w + -0.06612365*ng0.w + 0.052545033*nh0.w + -0.09354296*ni0.w;
    u = -0.024908075*na1.x + 0.054468673*nb1.x + -0.1664688*nc1.x + 0.14513916*nd1.x + 0.52940583*ne1.x + -0.09289571*nf1.x + 0.0792853*ng1.x + -0.047211148*nh1.x + -0.05823414*ni1.x;
    v = -0.11715029*na1.y + 0.252586*nb1.y + 0.041131303*nc1.y + -0.055155452*nd1.y + 0.41648072*ne1.y + -0.21591651*nf1.y + -0.09149343*ng1.y + -0.014857513*nh1.y + 0.1410885*ni1.y;
    w = -0.07564878*na1.z + -0.02708825*nb1.z + -0.08688533*nc1.z + -0.046987806*nd1.z + -0.5431695*ne1.z + -0.18476017*nf1.z + -0.095298484*ng1.z + 0.06094703*nh1.z + -0.039970815*ni1.z;
    x = 0.04833648*na1.w + -0.1409518*nb1.w + 0.11214609*nc1.w + 0.033194754*nd1.w + -0.3089111*ne1.w + 0.06044798*nf1.w + -0.0066538164*ng1.w + 0.010930421*nh1.w + 0.013376871*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.051068775;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN50
//!BIND LUMAN51
//!SAVE LUMAN61

#define L0_tex LUMAN50_tex
#define L1_tex LUMAN51_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.031546153*a0.x + 0.10181991*b0.x + 0.073859274*c0.x + -0.15246408*d0.x + 0.14763272*e0.x + -0.0125050405*f0.x + -0.017787706*g0.x + -0.20371142*h0.x + -0.00050032407*i0.x;
    float j = -0.010432319*a0.y + 0.030510774*b0.y + 0.1426763*c0.y + 0.059396524*d0.y + 0.15544188*e0.y + -0.12718435*f0.y + 0.02799549*g0.y + 0.010854321*h0.y + -0.0015246007*i0.y;
    float k = -0.093501434*a0.z + -0.07160352*b0.z + -0.0084140515*c0.z + -0.056851644*d0.z + -0.017626492*e0.z + -0.061777826*f0.z + -0.036883313*g0.z + 0.0859227*h0.z + 0.13611211*i0.z;
    float l = 0.035202347*a0.w + 0.009860384*b0.w + 0.038405575*c0.w + -0.12947462*d0.w + -0.1261992*e0.w + 0.12101405*f0.w + 0.014062706*g0.w + 0.15318196*h0.w + -0.0024715464*i0.w;
    float m = 0.16668798*a1.x + -0.16932218*b1.x + -0.009941405*c1.x + -0.022664279*d1.x + 0.32400167*e1.x + -0.105916865*f1.x + 0.067544185*g1.x + -0.07818027*h1.x + -0.0073417565*i1.x;
    float n = -0.05549741*a1.y + -0.04343892*b1.y + 0.10069597*c1.y + -0.015486789*d1.y + -0.22637175*e1.y + 0.19503605*f1.y + -0.012474865*g1.y + -0.13727693*h1.y + -0.017787639*i1.y;
    float o = 0.041081887*a1.z + 0.034970902*b1.z + -0.06543123*c1.z + 0.13859794*d1.z + -0.15330139*e1.z + -0.23288219*f1.z + -0.012868079*g1.z + -0.14391816*h1.z + 0.060016695*i1.z;
    float p = -0.069112025*a1.w + 0.037988856*b1.w + -0.093884565*c1.w + -0.15653755*d1.w + -0.22540344*e1.w + -0.06968565*f1.w + -0.055913948*g1.w + -0.050365813*h1.w + -0.033494245*i1.w;
    float q = 0.045975808*na0.x + 0.08250363*nb0.x + 0.022651628*nc0.x + 0.28382483*nd0.x + 0.097844034*ne0.x + 0.10232113*nf0.x + 0.06628655*ng0.x + 0.14861946*nh0.x + 0.08355251*ni0.x;
    float r = 0.04361711*na0.y + -0.05094804*nb0.y + -0.014008724*nc0.y + 0.07368605*nd0.y + -0.1254038*ne0.y + -0.04381839*nf0.y + -0.095921315*ng0.y + -0.036264747*nh0.y + 0.018310638*ni0.y;
    float s = 0.06879594*na0.z + -0.0066300803*nb0.z + 0.05720748*nc0.z + 0.029433746*nd0.z + -0.03982782*ne0.z + 0.05603243*nf0.z + 0.05490365*ng0.z + 0.03296246*nh0.z + -0.09842967*ni0.z;
    float t = 0.025421478*na0.w + -0.11407852*nb0.w + 0.12202771*nc0.w + 0.060819726*nd0.w + 0.24847539*ne0.w + 0.011995541*nf0.w + -0.040386673*ng0.w + -0.07721791*nh0.w + 0.033605415*ni0.w;
    float u = -0.17270409*na1.x + 0.013868905*nb1.x + -0.002881239*nc1.x + 0.039273325*nd1.x + -0.106161565*ne1.x + -0.025495555*nf1.x + 0.048340194*ng1.x + -0.07479905*nh1.x + -0.08653662*ni1.x;
    float v = 0.13883483*na1.y + 0.13072231*nb1.y + 0.08571931*nc1.y + -0.1619657*nd1.y + 0.37347794*ne1.y + 0.1372329*nf1.y + 0.0140385255*ng1.y + -0.122313775*nh1.y + 0.20132363*ni1.y;
    float w = 0.0040083956*na1.z + 0.10405894*nb1.z + 0.027527817*nc1.z + -0.05968225*nd1.z + 0.2647388*ne1.z + 0.016327286*nf1.z + 0.011635987*ng1.z + 0.04504511*nh1.z + -0.051735844*ni1.z;
    float x = 0.10528082*na1.w + 0.0142691685*nb1.w + 0.014016689*nc1.w + 0.17657901*nd1.w + 0.121575035*ne1.w + -0.063305*nf1.w + -0.018475758*ng1.w + -0.04090849*nh1.w + -0.07978934*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0003618291;
    i = -0.036286984*a0.x + -0.14125206*b0.x + 0.06066132*c0.x + 0.05547197*d0.x + 0.068194166*e0.x + 0.008525646*f0.x + -0.039609205*g0.x + -0.11230934*h0.x + -0.113056414*i0.x;
    j = -0.085862525*a0.y + -0.123490535*b0.y + 0.020701244*c0.y + -0.2048334*d0.y + -0.45535797*e0.y + -0.083858036*f0.y + -0.15180224*g0.y + 0.12630956*h0.y + 0.017587205*i0.y;
    k = -0.018024435*a0.z + -0.09302786*b0.z + 0.021795405*c0.z + -0.12134385*d0.z + -0.20438811*e0.z + -0.14382325*f0.z + -0.076487675*g0.z + 0.10817767*h0.z + -0.077478066*i0.z;
    l = -0.038971703*a0.w + 0.048376482*b0.w + -0.023732191*c0.w + 0.09670338*d0.w + -0.2802389*e0.w + -0.09253269*f0.w + -0.080351844*g0.w + 0.017240494*h0.w + 0.006485758*i0.w;
    m = 0.01397742*a1.x + -0.025987474*b1.x + 0.07466099*c1.x + -0.09267096*d1.x + -0.5153345*e1.x + -0.062083337*f1.x + 0.10469547*g1.x + -0.11062864*h1.x + 0.014658386*i1.x;
    n = -0.091483*a1.y + -0.16846472*b1.y + -0.10234011*c1.y + -0.01535046*d1.y + -0.0051777046*e1.y + 0.10139349*f1.y + -0.10388479*g1.y + -0.12109544*h1.y + 0.15738633*i1.y;
    o = 0.020996617*a1.z + 0.037067533*b1.z + 0.073568314*c1.z + -0.09159761*d1.z + 0.087282114*e1.z + -0.039215967*f1.z + 0.16177997*g1.z + 0.14786617*h1.z + 0.09942117*i1.z;
    p = 0.0019687389*a1.w + -0.013382924*b1.w + 0.1135481*c1.w + 0.07714744*d1.w + -0.1592662*e1.w + -0.10746641*f1.w + 0.048666194*g1.w + 0.08981723*h1.w + -0.07497876*i1.w;
    q = -0.015083009*na0.x + -0.019428026*nb0.x + 0.03813817*nc0.x + -0.15238467*nd0.x + -0.23520324*ne0.x + 0.07369356*nf0.x + 0.012670117*ng0.x + -0.08351004*nh0.x + 0.044962507*ni0.x;
    r = 0.088389374*na0.y + 0.18492348*nb0.y + 0.025082428*nc0.y + 0.05480784*nd0.y + 0.22750247*ne0.y + 0.13846515*nf0.y + 0.2636925*ng0.y + 0.17539035*nh0.y + 0.11087739*ni0.y;
    s = -0.12868524*na0.z + -0.037687402*nb0.z + -0.1252832*nc0.z + 0.10420505*nd0.z + 0.04623572*ne0.z + 0.0655443*nf0.z + -0.025120152*ng0.z + -0.17205289*nh0.z + 0.008899509*ni0.z;
    t = -0.07281317*na0.w + -0.1546063*nb0.w + -0.016060047*nc0.w + 0.060486432*nd0.w + 0.1441806*ne0.w + 0.17752542*nf0.w + 0.030893242*ng0.w + 0.03714838*nh0.w + -0.0048728893*ni0.w;
    u = 0.060912687*na1.x + 0.12079206*nb1.x + -0.027241277*nc1.x + 0.04047401*nd1.x + 0.09416829*ne1.x + 0.15379521*nf1.x + -0.19458131*ng1.x + -0.00538213*nh1.x + 0.037444368*ni1.x;
    v = -0.023998167*na1.y + 0.025314212*nb1.y + -0.17185235*nc1.y + 0.16584304*nd1.y + -0.4452612*ne1.y + -0.110297464*nf1.y + 0.06593299*ng1.y + 0.10085941*nh1.y + 0.044712596*ni1.y;
    w = 0.04893469*na1.z + -0.0019785075*nb1.z + 0.05903422*nc1.z + 0.17388752*nd1.z + 0.17576037*ne1.z + 0.24168177*nf1.z + -0.07972112*ng1.z + -0.10765523*nh1.z + 0.038109303*ni1.z;
    x = 0.027872296*na1.w + 0.018650744*nb1.w + -0.07063714*nc1.w + -0.068980865*nd1.w + 0.10454622*ne1.w + -0.04499944*nf1.w + -0.100115106*ng1.w + -0.1471108*nh1.w + -0.04576075*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.030282622;
    i = 0.07732889*a0.x + -0.28814515*b0.x + -0.0064604837*c0.x + 0.29301605*d0.x + -0.09963081*e0.x + -0.08197728*f0.x + -0.028975101*g0.x + 0.14664023*h0.x + -0.08978697*i0.x;
    j = 0.068587825*a0.y + 0.20948891*b0.y + 0.045638446*c0.y + 0.051091406*d0.y + 0.34080246*e0.y + 0.14575565*f0.y + 0.08811473*g0.y + -0.05562346*h0.y + -0.15261091*i0.y;
    k = -0.011278103*a0.z + -0.15211527*b0.z + 0.20716971*c0.z + 0.09526687*d0.z + -0.08959701*e0.z + 0.067594126*f0.z + 0.14893652*g0.z + -0.028068649*h0.z + -0.048965998*i0.z;
    l = 0.055225685*a0.w + 0.20627908*b0.w + -0.15372919*c0.w + -0.11007142*d0.w + -0.075520106*e0.w + -0.09346816*f0.w + 0.034588765*g0.w + -0.026151113*h0.w + 0.0026015725*i0.w;
    m = -0.048829716*a1.x + -0.20407067*b1.x + 0.06337002*c1.x + 0.32504085*d1.x + -0.12869559*e1.x + 0.06284247*f1.x + 0.20259036*g1.x + -0.054262947*h1.x + 0.0046158135*i1.x;
    n = 0.22670676*a1.y + -0.21922074*b1.y + -0.19599336*c1.y + 0.16530077*d1.y + -0.16839084*e1.y + -0.0039421143*f1.y + 0.04603167*g1.y + 0.07083225*h1.y + -0.064544596*i1.y;
    o = -0.037351932*a1.z + 0.0018220773*b1.z + 0.10817571*c1.z + 0.0832664*d1.z + -0.083478995*e1.z + 0.30855995*f1.z + -0.055833396*g1.z + 0.12978391*h1.z + 0.06139905*i1.z;
    p = -0.028281745*a1.w + -0.16829659*b1.w + -0.026146065*c1.w + -0.06691971*d1.w + -0.23516048*e1.w + -0.31896853*f1.w + 0.07790477*g1.w + -0.021854805*h1.w + -0.21510248*i1.w;
    q = -0.14794815*na0.x + 0.033303283*nb0.x + 0.03536612*nc0.x + -0.09868507*nd0.x + -0.26048434*ne0.x + -0.06149607*nf0.x + 0.117348015*ng0.x + -0.10047164*nh0.x + -0.09653776*ni0.x;
    r = -0.06575016*na0.y + -0.054421987*nb0.y + 0.099354625*nc0.y + 0.039376777*nd0.y + -0.02198662*ne0.y + 0.11862724*nf0.y + 0.020930216*ng0.y + 0.0056599323*nh0.y + 0.16156995*ni0.y;
    s = 0.13081959*na0.z + 0.32655948*nb0.z + -0.23558922*nc0.z + 0.072354905*nd0.z + 0.16327718*ne0.z + 0.02562823*nf0.z + -0.1573292*ng0.z + 0.19618611*nh0.z + 0.10715276*ni0.z;
    t = -0.1405503*na0.w + -0.33976465*nb0.w + 0.04658757*nc0.w + 0.12673989*nd0.w + -0.04829641*ne0.w + -0.00910403*nf0.w + -0.11427059*ng0.w + -0.14695705*nh0.w + -0.08690347*ni0.w;
    u = 0.11926451*na1.x + 0.19877844*nb1.x + 0.027044713*nc1.x + -0.19027933*nd1.x + -0.14013988*ne1.x + 0.07460557*nf1.x + -0.043402057*ng1.x + -0.09343368*nh1.x + 0.047437534*ni1.x;
    v = 0.08416891*na1.y + 0.14631395*nb1.y + 0.26600307*nc1.y + -0.1871122*nd1.y + 0.22076473*ne1.y + 0.28523198*nf1.y + -0.055752814*ng1.y + 0.015490213*nh1.y + 0.054972388*ni1.y;
    w = 0.08740491*na1.z + -0.23947707*nb1.z + 0.016575981*nc1.z + -0.10177695*nd1.z + 0.15792145*ne1.z + -0.03995825*nf1.z + -0.039797496*ng1.z + -0.025917966*nh1.z + -0.09652502*ni1.z;
    x = 0.0071426067*na1.w + 0.095553674*nb1.w + -0.07099863*nc1.w + 0.024027854*nd1.w + 0.12360891*ne1.w + 0.1681869*nf1.w + -0.03580952*ng1.w + 0.044734523*nh1.w + 0.10288006*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0055503496;
    i = -0.012075199*a0.x + 0.029157963*b0.x + -0.094539605*c0.x + 0.009049657*d0.x + 0.0066867545*e0.x + 0.123809524*f0.x + -0.034514107*g0.x + -0.033612035*h0.x + 0.022811875*i0.x;
    j = 0.17061445*a0.y + -0.010893953*b0.y + -0.07004314*c0.y + 0.23383701*d0.y + 0.093025014*e0.y + -0.11091873*f0.y + 0.12727837*g0.y + 0.0642397*h0.y + 0.11227179*i0.y;
    k = 0.019130148*a0.z + 0.1882869*b0.z + -0.0023966245*c0.z + -0.23950866*d0.z + 0.038852807*e0.z + -0.0430306*f0.z + -0.11410439*g0.z + 0.12466275*h0.z + -0.047253113*i0.z;
    l = 0.09055786*a0.w + 0.07580854*b0.w + -0.11349518*c0.w + -0.13999584*d0.w + 0.12614273*e0.w + -0.15902464*f0.w + -0.038654026*g0.w + -0.058192287*h0.w + 0.035802983*i0.w;
    m = -0.08979459*a1.x + -0.050968487*b1.x + -0.02907599*c1.x + 0.042554542*d1.x + 0.07000888*e1.x + 0.028022232*f1.x + -0.096248545*g1.x + 0.035345096*h1.x + 0.074281015*i1.x;
    n = -0.16023806*a1.y + 0.05844222*b1.y + 0.07899191*c1.y + 0.18628545*d1.y + -0.035070125*e1.y + 0.1912711*f1.y + -0.044375904*g1.y + -0.16154447*h1.y + -0.012721664*i1.y;
    o = -0.021872953*a1.z + -0.021403098*b1.z + -0.026954386*c1.z + -0.041741677*d1.z + -0.046587247*e1.z + -0.11817974*f1.z + -0.008084186*g1.z + -0.14949232*h1.z + 0.1003316*i1.z;
    p = 0.08669636*a1.w + 0.19403161*b1.w + 0.031784803*c1.w + -0.06290836*d1.w + 0.16112271*e1.w + 0.10850725*f1.w + -0.051847808*g1.w + 0.1305159*h1.w + 0.026885018*i1.w;
    q = 0.17550388*na0.x + 0.17034264*nb0.x + -0.021896753*nc0.x + 0.013124788*nd0.x + 0.3335409*ne0.x + 0.018226452*nf0.x + -0.018352246*ng0.x + 0.119319744*nh0.x + 0.04201911*ni0.x;
    r = -0.07380144*na0.y + -0.13001768*nb0.y + 0.051442172*nc0.y + -0.15560588*nd0.y + -0.07077073*ne0.y + 0.022792563*nf0.y + -0.025004702*ng0.y + -0.014225961*nh0.y + 0.030852502*ni0.y;
    s = -0.07394243*na0.z + -0.31966287*nb0.z + -0.031208597*nc0.z + 0.1298494*nd0.z + -0.17820711*ne0.z + -0.011843899*nf0.z + 0.1022889*ng0.z + -0.19961227*nh0.z + 0.021356137*ni0.z;
    t = -0.057077024*na0.w + 0.038792044*nb0.w + 0.06577576*nc0.w + -0.08349324*nd0.w + 0.004292813*ne0.w + 0.19245423*nf0.w + -0.06170392*ng0.w + 0.110614605*nh0.w + 0.07479524*ni0.w;
    u = 0.057603214*na1.x + 0.069764175*nb1.x + -0.031894762*nc1.x + -0.02513546*nd1.x + 0.41143113*ne1.x + -0.048580915*nf1.x + 0.06527271*ng1.x + -0.042320378*nh1.x + -0.09458812*ni1.x;
    v = -0.03011336*na1.y + 0.1658467*nb1.y + 0.0071091754*nc1.y + -0.06092405*nd1.y + -0.18375023*ne1.y + 0.085011095*nf1.y + 0.065524936*ng1.y + -0.11302712*nh1.y + -0.06424482*ni1.y;
    w = 0.016921792*na1.z + -0.06271212*nb1.z + -0.0177968*nc1.z + 0.046915255*nd1.z + -0.2927471*ne1.z + -0.2323749*nf1.z + -0.042442553*ng1.z + -0.023555394*nh1.z + -0.14939739*ni1.z;
    x = -0.06065122*na1.w + -0.18494257*nb1.w + -0.028549945*nc1.w + 0.037122887*nd1.w + -0.0827869*ne1.w + -0.0648537*nf1.w + 0.124712236*ng1.w + -0.044237345*nh1.w + -0.052325983*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.010284809;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN60
//!BIND LUMAN61
//!SAVE LUMAN70

#define L0_tex LUMAN60_tex
#define L1_tex LUMAN61_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.16578029*a0.x + 0.013990818*b0.x + 0.09837317*c0.x + 0.07576955*d0.x + -0.16992646*e0.x + 0.23093958*f0.x + 0.017147336*g0.x + 0.1219098*h0.x + 0.12366357*i0.x;
    float j = 0.07109732*a0.y + -0.1423914*b0.y + -0.1047342*c0.y + 0.009923733*d0.y + -0.19652642*e0.y + 0.07588192*f0.y + 0.14325468*g0.y + 0.15657106*h0.y + 0.05293008*i0.y;
    float k = 0.078111775*a0.z + 0.064393364*b0.z + -0.016043022*c0.z + 0.024629833*d0.z + 0.006721816*e0.z + 0.14674336*f0.z + -0.015520731*g0.z + -0.06537491*h0.z + 0.086636305*i0.z;
    float l = -0.0741245*a0.w + -0.06732808*b0.w + -0.079615004*c0.w + -0.008385015*d0.w + -0.10109181*e0.w + -0.07363017*f0.w + -0.035449628*g0.w + 0.06175979*h0.w + -0.07361961*i0.w;
    float m = 0.063247964*a1.x + -0.075120606*b1.x + -0.028360335*c1.x + 0.030195588*d1.x + 0.10427086*e1.x + 0.13412566*f1.x + 0.042594828*g1.x + -0.03038559*h1.x + -0.042622592*i1.x;
    float n = 0.11696979*a1.y + -0.027478525*b1.y + -0.099160425*c1.y + 0.08101374*d1.y + -0.06059322*e1.y + 0.04557204*f1.y + -0.057096496*g1.y + 0.0312891*h1.y + 0.078683846*i1.y;
    float o = -0.12690002*a1.z + 0.0043969243*b1.z + -0.04436471*c1.z + -0.15787491*d1.z + -0.027084693*e1.z + 0.07680882*f1.z + -0.02875257*g1.z + -0.23554859*h1.z + -0.0563404*i1.z;
    float p = 0.08040078*a1.w + 0.08603515*b1.w + 0.041610844*c1.w + 0.003927433*d1.w + -0.09296107*e1.w + 0.039034292*f1.w + -0.0036091765*g1.w + 0.14170401*h1.w + -0.033236314*i1.w;
    float q = -0.096916005*na0.x + 0.02102143*nb0.x + -0.12104281*nc0.x + -0.12628518*nd0.x + -0.068820976*ne0.x + -0.069862284*nf0.x + -0.08238152*ng0.x + -0.15156785*nh0.x + -0.11870064*ni0.x;
    float r = 0.03282288*na0.y + 0.041718647*nb0.y + 0.082437046*nc0.y + -0.029205652*nd0.y + 0.09701532*ne0.y + -0.054706994*nf0.y + -0.07382584*ng0.y + -0.06306124*nh0.y + 0.029283857*ni0.y;
    float s = 0.012279362*na0.z + -0.07578884*nb0.z + 0.03965951*nc0.z + 0.11721266*nd0.z + 0.016962193*ne0.z + -0.13157724*nf0.z + 0.0441183*ng0.z + 0.04841312*nh0.z + -0.033188727*ni0.z;
    float t = 0.076621324*na0.w + 0.005180186*nb0.w + 0.096331365*nc0.w + -0.14043762*nd0.w + 0.00794994*ne0.w + 0.0113677345*nf0.w + -0.038655013*ng0.w + -0.037150774*nh0.w + 0.049118478*ni0.w;
    float u = 0.043390647*na1.x + 0.14366865*nb1.x + 0.059894454*nc1.x + 0.040974643*nd1.x + -0.24173065*ne1.x + -0.167277*nf1.x + -0.051057592*ng1.x + -0.06775998*nh1.x + 0.09672075*ni1.x;
    float v = 0.011191803*na1.y + 0.05300878*nb1.y + 0.049616437*nc1.y + 0.053501844*nd1.y + -0.048268393*ne1.y + 0.04606292*nf1.y + -0.018835546*ng1.y + 0.003935801*nh1.y + 0.017734563*ni1.y;
    float w = 0.051565535*na1.z + -0.055144522*nb1.z + 0.076759696*nc1.z + 0.09252661*nd1.z + 0.037071202*ne1.z + -0.17852075*nf1.z + 0.12125989*ng1.z + 0.18283102*nh1.z + -0.00016908294*ni1.z;
    float x = -0.17815267*na1.w + -0.13834023*nb1.w + -0.05997425*nc1.w + 0.1757715*nd1.w + -0.37225088*ne1.w + -0.11723465*nf1.w + 0.08268649*ng1.w + 0.035000995*nh1.w + -0.16776145*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.028719269;
    i = 0.18548845*a0.x + -0.05647053*b0.x + -0.040696014*c0.x + 0.052823003*d0.x + -0.4189399*e0.x + -0.015366636*f0.x + 0.06766774*g0.x + 0.15743747*h0.x + 0.033094455*i0.x;
    j = 0.030546375*a0.y + 0.03572686*b0.y + 0.17469496*c0.y + 0.2902643*d0.y + 0.014449327*e0.y + -0.084437944*f0.y + 0.0078015416*g0.y + 0.058347438*h0.y + -0.12598446*i0.y;
    k = -0.02351964*a0.z + -0.13462098*b0.z + -0.10640411*c0.z + -0.05373117*d0.z + -0.16264963*e0.z + 0.13459212*f0.z + 0.029319022*g0.z + -0.010710142*h0.z + 0.099324025*i0.z;
    l = -0.06633435*a0.w + 0.021756038*b0.w + 0.06893574*c0.w + -0.008018089*d0.w + -0.23540919*e0.w + 0.02644514*f0.w + -0.13601077*g0.w + -0.008815168*h0.w + -0.011743013*i0.w;
    m = 0.038345877*a1.x + -0.086153336*b1.x + 0.07479341*c1.x + -0.010996278*d1.x + 0.14060572*e1.x + -0.31776565*f1.x + -0.058094885*g1.x + -0.058991406*h1.x + -0.1718826*i1.x;
    n = 0.19658592*a1.y + -0.061105892*b1.y + 0.057346955*c1.y + -0.100882664*d1.y + -0.4392003*e1.y + -0.05740425*f1.y + -0.1170415*g1.y + -0.01486477*h1.y + -0.0033719817*i1.y;
    o = -0.0748515*a1.z + 0.027030269*b1.z + 0.08899301*c1.z + -0.15835983*d1.z + -0.10266469*e1.z + -0.015304557*f1.z + -0.02540133*g1.z + 0.1456681*h1.z + 0.057394672*i1.z;
    p = 0.05575373*a1.w + 0.060642187*b1.w + -0.087482736*c1.w + -0.048063513*d1.w + 0.02059542*e1.w + 0.26618627*f1.w + 0.10006077*g1.w + 0.11526471*h1.w + -0.048317786*i1.w;
    q = -0.13790658*na0.x + -0.063561045*nb0.x + 0.07387912*nc0.x + 0.017276092*nd0.x + 0.14578958*ne0.x + -0.24436425*nf0.x + -0.0341115*ng0.x + -0.2219738*nh0.x + 0.06889617*ni0.x;
    r = -0.042442624*na0.y + -0.13584505*nb0.y + -0.039730333*nc0.y + -0.12337824*nd0.y + -0.021769421*ne0.y + 0.07597415*nf0.y + 0.0382621*ng0.y + -0.057937287*nh0.y + 0.040303767*ni0.y;
    s = 0.056913987*na0.z + -0.004294972*nb0.z + 0.10427198*nc0.z + 0.20038685*nd0.z + 0.18569255*ne0.z + 0.054610845*nf0.z + -0.00021753006*ng0.z + 0.05635846*nh0.z + -0.12966545*ni0.z;
    t = 0.03689294*na0.w + -0.12253988*nb0.w + -0.064768024*nc0.w + -0.12623608*nd0.w + 0.05227509*ne0.w + -0.07615756*nf0.w + 0.1060167*ng0.w + 0.022959046*nh0.w + 0.006676678*ni0.w;
    u = -0.05955148*na1.x + 0.16712731*nb1.x + 0.113733746*nc1.x + 0.048157085*nd1.x + -0.13083988*ne1.x + 0.3291639*nf1.x + 0.17111477*ng1.x + 0.1411651*nh1.x + -0.058225065*ni1.x;
    v = -0.053716976*na1.y + 0.051629025*nb1.y + -0.09303743*nc1.y + 0.050438844*nd1.y + 0.3974745*ne1.y + 0.109845474*nf1.y + 0.06978495*ng1.y + -0.048667617*nh1.y + -0.0008301881*ni1.y;
    w = 0.08895754*na1.z + 0.04203822*nb1.z + -0.071697205*nc1.z + 0.06069184*nd1.z + 0.08287753*ne1.z + 0.12639408*nf1.z + -0.021879954*ng1.z + -0.053128574*nh1.z + -0.031865556*ni1.z;
    x = -0.042749748*na1.w + 0.012698759*nb1.w + 0.041044585*nc1.w + 0.25456965*nd1.w + -0.11546677*ne1.w + -0.0329849*nf1.w + -0.07359456*ng1.w + -0.14368512*nh1.w + 0.11999542*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.011110204;
    i = 0.0074592545*a0.x + 0.043397088*b0.x + 0.062201325*c0.x + 0.023201836*d0.x + 0.25556907*e0.x + 0.040537015*f0.x + 0.00130909*g0.x + -0.105612725*h0.x + 0.053336933*i0.x;
    j = -0.17386965*a0.y + -0.32382426*b0.y + -0.061145358*c0.y + 0.04002571*d0.y + -0.23882376*e0.y + -0.033762064*f0.y + -0.12921101*g0.y + -0.15359834*h0.y + 0.16432834*i0.y;
    k = 0.028706433*a0.z + -0.10239519*b0.z + 0.17036264*c0.z + 0.05046601*d0.z + -0.07968705*e0.z + 0.06268126*f0.z + 0.03414322*g0.z + -0.14754891*h0.z + -0.08879028*i0.z;
    l = -0.036177054*a0.w + -0.14996824*b0.w + -0.12140647*c0.w + 0.062374283*d0.w + 0.21741039*e0.w + -0.012958527*f0.w + -0.02862404*g0.w + -0.014645144*h0.w + -0.07075824*i0.w;
    m = -0.01300554*a1.x + -0.118286535*b1.x + -0.022690719*c1.x + 0.09580937*d1.x + 0.2351647*e1.x + 0.093059495*f1.x + 0.097405665*g1.x + 0.26961285*h1.x + 0.31288835*i1.x;
    n = 0.008415521*a1.y + -0.16029839*b1.y + -0.06299726*c1.y + 0.053338848*d1.y + 0.1848575*e1.y + 0.16177703*f1.y + 0.033813134*g1.y + 0.074481755*h1.y + 0.1191071*i1.y;
    o = 0.03554395*a1.z + 0.029654032*b1.z + -0.0025611767*c1.z + 0.13693488*d1.z + 0.20568362*e1.z + -0.02008338*f1.z + 0.110492304*g1.z + -0.015586609*h1.z + 0.008658279*i1.z;
    p = -0.062073592*a1.w + 0.12636374*b1.w + 0.143853*c1.w + 0.13521259*d1.w + 0.086283565*e1.w + -0.1396292*f1.w + 0.11080437*g1.w + 0.06066151*h1.w + -0.047289044*i1.w;
    q = 0.079622135*na0.x + 0.13997798*nb0.x + -0.12444296*nc0.x + -0.24639496*nd0.x + -0.058971554*ne0.x + -0.043049175*nf0.x + -0.16991176*ng0.x + 0.28243*nh0.x + 0.114248134*ni0.x;
    r = 0.19420412*na0.y + 0.22056995*nb0.y + 0.02228691*nc0.y + -0.08229736*nd0.y + -0.17353967*ne0.y + 0.027384117*nf0.y + -0.055681773*ng0.y + 0.047341447*nh0.y + 0.011827025*ni0.y;
    s = -0.19429816*na0.z + -0.019068794*nb0.z + -0.15515451*nc0.z + -0.1561127*nd0.z + -0.5365578*ne0.z + -0.47798854*nf0.z + -0.088053495*ng0.z + 0.08626954*nh0.z + 0.033513896*ni0.z;
    t = -0.019487524*na0.w + 0.12894231*nb0.w + 0.057398915*nc0.w + 0.035676952*nd0.w + -0.1672153*ne0.w + -0.009412913*nf0.w + 0.08559531*ng0.w + 0.12037487*nh0.w + 0.11312014*ni0.w;
    u = 0.022511158*na1.x + -0.002289268*nb1.x + -0.10513552*nc1.x + -0.03751128*nd1.x + -0.14417613*ne1.x + -0.25909096*nf1.x + -0.06497719*ng1.x + -0.19180773*nh1.x + -0.10507793*ni1.x;
    v = -0.018047635*na1.y + 0.109712765*nb1.y + -0.007114467*nc1.y + -0.1626408*nd1.y + -0.09422333*ne1.y + 0.008029611*nf1.y + -0.092768595*ng1.y + 0.008543296*nh1.y + -0.06329041*ni1.y;
    w = -0.004643168*na1.z + -0.06549557*nb1.z + 0.024286577*nc1.z + 0.11289367*nd1.z + -0.06594302*ne1.z + 0.0007953774*nf1.z + -0.024661655*ng1.z + -0.08614193*nh1.z + 0.04030148*ni1.z;
    x = 0.036247578*na1.w + -0.15959524*nb1.w + -0.047722068*nc1.w + -0.061771885*nd1.w + -0.027329838*ne1.w + 0.10989542*nf1.w + -0.07891876*ng1.w + 0.053630132*nh1.w + 0.07017752*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.024209157;
    i = 0.0803816*a0.x + -0.27919126*b0.x + 0.074065596*c0.x + -0.028041711*d0.x + 0.08890479*e0.x + -0.23712136*f0.x + -0.097136654*g0.x + 0.12058667*h0.x + -0.08708536*i0.x;
    j = 0.1727559*a0.y + -0.017551957*b0.y + -0.022949927*c0.y + -0.29679775*d0.y + 0.26063496*e0.y + 0.1274615*f0.y + 0.22342013*g0.y + 0.2565278*h0.y + -0.17510408*i0.y;
    k = -0.13825856*a0.z + -0.32330674*b0.z + -0.096224956*c0.z + 0.015928205*d0.z + -0.008965429*e0.z + -0.009688457*f0.z + -0.053291973*g0.z + 0.0035815418*h0.z + -0.01406214*i0.z;
    l = 0.025246026*a0.w + 0.08746249*b0.w + 0.054473277*c0.w + 0.07564705*d0.w + 0.36086765*e0.w + -0.07294847*f0.w + -0.05731445*g0.w + 0.16488546*h0.w + 0.1051391*i0.w;
    m = 0.043292508*a1.x + -0.05688463*b1.x + -0.015260159*c1.x + -0.034311038*d1.x + 0.022605684*e1.x + 0.067839354*f1.x + 0.0061159763*g1.x + -0.21483196*h1.x + -0.21822494*i1.x;
    n = 0.07060806*a1.y + 0.036499433*b1.y + 0.06328188*c1.y + -0.01600864*d1.y + 0.12019602*e1.y + -0.005704468*f1.y + -0.08529293*g1.y + 0.11870455*h1.y + -0.010954343*i1.y;
    o = -0.025742063*a1.z + 0.03137751*b1.z + -0.05091499*c1.z + 0.09746075*d1.z + -0.12615938*e1.z + 0.022217032*f1.z + -0.070888266*g1.z + -0.13394141*h1.z + 0.045135196*i1.z;
    p = -0.0045820107*a1.w + -0.17361222*b1.w + -0.034899686*c1.w + 0.13965659*d1.w + 0.28254306*e1.w + 0.08674435*f1.w + 0.0043952106*g1.w + -0.08248237*h1.w + -0.060236216*i1.w;
    q = -0.01671497*na0.x + 0.2706943*nb0.x + -0.059392486*nc0.x + -0.08367182*nd0.x + -0.12964763*ne0.x + 0.14313929*nf0.x + -0.0376002*ng0.x + -0.1556175*nh0.x + 0.1717994*ni0.x;
    r = -0.13063015*na0.y + -0.09716623*nb0.y + 0.024953064*nc0.y + -0.12042667*nd0.y + -0.099800974*ne0.y + -0.05611497*nf0.y + 0.09859522*ng0.y + -0.15328264*nh0.y + 0.17297874*ni0.y;
    s = 0.07288057*na0.z + -0.026626898*nb0.z + 0.022637181*nc0.z + -0.082871124*nd0.z + -0.099834375*ne0.z + 0.048337597*nf0.z + -0.013129719*ng0.z + -0.106599286*nh0.z + -0.09004616*ni0.z;
    t = -0.016658474*na0.w + -0.07718386*nb0.w + 0.012443814*nc0.w + -0.17324288*nd0.w + -0.12695457*ne0.w + 0.079303846*nf0.w + 0.050723445*ng0.w + -0.079862684*nh0.w + -0.101098046*ni0.w;
    u = -0.07239776*na1.x + 0.049419682*nb1.x + 0.0034176882*nc1.x + -0.0030864673*nd1.x + 0.050037086*ne1.x + -0.031178009*nf1.x + 0.1564304*ng1.x + 0.017682616*nh1.x + -0.011802952*ni1.x;
    v = 0.034944337*na1.y + -0.07103817*nb1.y + -0.046081703*nc1.y + -0.020656273*nd1.y + 0.0087076835*ne1.y + -0.015704094*nf1.y + 0.0063806917*ng1.y + -0.23284888*nh1.y + 0.12339237*ni1.y;
    w = 0.052958157*na1.z + -0.08084726*nb1.z + -0.029484414*nc1.z + -0.08496418*nd1.z + 0.03637533*ne1.z + 0.023300169*nf1.z + 0.16558544*ng1.z + 0.21808468*nh1.z + -0.06323104*ni1.z;
    x = 0.0126498*na1.w + 0.11205986*nb1.w + 0.043474864*nc1.w + 0.02638971*nd1.w + -0.43571174*ne1.w + -0.029462261*nf1.w + 0.063208215*ng1.w + -0.034104012*nh1.w + 0.15246783*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.026696365;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN60
//!BIND LUMAN61
//!SAVE LUMAN71

#define L0_tex LUMAN60_tex
#define L1_tex LUMAN61_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.02122406*a0.x + -0.122874014*b0.x + 0.038901694*c0.x + -0.20805544*d0.x + 0.17793977*e0.x + -0.10250643*f0.x + 0.06715224*g0.x + 0.117481254*h0.x + 0.06661811*i0.x;
    float j = 0.20923853*a0.y + -0.048322447*b0.y + 0.005236233*c0.y + -0.28995273*d0.y + 0.3262455*e0.y + 0.33262008*f0.y + 0.052094195*g0.y + 0.17168306*h0.y + -0.036342744*i0.y;
    float k = -0.34261653*a0.z + -0.16838802*b0.z + 0.037084457*c0.z + -0.079159625*d0.z + -0.23170805*e0.z + -0.1125017*f0.z + -0.038093638*g0.z + 0.022413125*h0.z + -0.09555592*i0.z;
    float l = -0.086659975*a0.w + 0.106437966*b0.w + 0.0443302*c0.w + 0.06381515*d0.w + -0.053781297*e0.w + -0.11590847*f0.w + -0.045483135*g0.w + -0.07360541*h0.w + 0.10073613*i0.w;
    float m = -0.05701288*a1.x + -0.24610838*b1.x + 0.018135766*c1.x + 0.12883955*d1.x + 0.41501093*e1.x + 0.06160426*f1.x + -0.015019228*g1.x + -0.04798661*h1.x + -0.18290891*i1.x;
    float n = 0.08840133*a1.y + -0.0723592*b1.y + -0.013035237*c1.y + 0.029143438*d1.y + 0.07747262*e1.y + 0.1619763*f1.y + -0.0152199*g1.y + -0.07636964*h1.y + -0.06660503*i1.y;
    float o = -0.06300358*a1.z + -0.16973108*b1.z + -0.030542169*c1.z + 0.31630164*d1.z + 0.16739343*e1.z + -0.04173233*f1.z + 0.1247867*g1.z + 0.025531637*h1.z + 0.06582077*i1.z;
    float p = -0.09305507*a1.w + -0.28399915*b1.w + -0.080629244*c1.w + 0.23983668*d1.w + 0.12860516*e1.w + 0.23577705*f1.w + 0.13577867*g1.w + -0.07724891*h1.w + -0.008147254*i1.w;
    float q = 0.03351352*na0.x + 0.27948612*nb0.x + 0.08278565*nc0.x + -0.22903872*nd0.x + -0.36529925*ne0.x + -0.11294542*nf0.x + -0.10836371*ng0.x + 0.043583702*nh0.x + 0.12022892*ni0.x;
    float r = 0.24315806*na0.y + -0.014898937*nb0.y + -0.072684065*nc0.y + -0.34174332*nd0.y + -0.3306895*ne0.y + -0.1688999*nf0.y + 0.1802616*ng0.y + 0.054149028*nh0.y + 0.07491759*ni0.y;
    float s = 0.14524053*na0.z + 0.03985881*nb0.z + -0.07349137*nc0.z + -0.029068999*nd0.z + 0.29518262*ne0.z + 0.105075926*nf0.z + -0.044849645*ng0.z + -0.07877199*nh0.z + -0.018896762*ni0.z;
    float t = 0.006239417*na0.w + -0.041456237*nb0.w + -0.0608528*nc0.w + 0.026246265*nd0.w + 0.1952428*ne0.w + 0.10006589*nf0.w + 0.1131621*ng0.w + 0.04781334*nh0.w + -0.10323906*ni0.w;
    float u = 0.0026973956*na1.x + 0.024592897*nb1.x + -0.08732975*nc1.x + -0.12753011*nd1.x + 0.037744883*ne1.x + -0.04100176*nf1.x + 0.12247657*ng1.x + -0.06303277*nh1.x + -0.030839955*ni1.x;
    float v = 0.04998994*na1.y + 0.2190631*nb1.y + 0.012344049*nc1.y + -0.046477366*nd1.y + 0.21627255*ne1.y + -0.12330876*nf1.y + -0.024180658*ng1.y + -0.072642304*nh1.y + 0.051594056*ni1.y;
    float w = 0.22652966*na1.z + 0.073615074*nb1.z + -0.08273673*nc1.z + -0.08763388*nd1.z + -0.008043756*ne1.z + 0.12864473*nf1.z + 0.03537027*ng1.z + 0.059408348*nh1.z + 0.04823138*ni1.z;
    float x = 0.1555011*na1.w + 0.18730667*nb1.w + 0.092899986*nc1.w + -0.09313055*nd1.w + -0.33994874*ne1.w + -0.24858464*nf1.w + -0.03746077*ng1.w + -0.026002746*nh1.w + 0.29153302*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.011664822;
    i = 0.02352895*a0.x + 0.05641156*b0.x + 0.078280956*c0.x + 0.07717666*d0.x + -0.035463758*e0.x + 0.009567614*f0.x + 0.00025401218*g0.x + -0.03555166*h0.x + 0.2594732*i0.x;
    j = -0.11683443*a0.y + 0.080092624*b0.y + 0.056203302*c0.y + 0.1363966*d0.y + -0.0110321725*e0.y + -0.045341235*f0.y + -0.059118755*g0.y + 0.15527584*h0.y + 0.01331635*i0.y;
    k = -0.0041987197*a0.z + 0.0345237*b0.z + 0.15223417*c0.z + 0.012654664*d0.z + -0.5447243*e0.z + 0.05722937*f0.z + -0.049002286*g0.z + -0.004447922*h0.z + 0.04951206*i0.z;
    l = -0.08451674*a0.w + -0.024253484*b0.w + -0.017119942*c0.w + -0.037239343*d0.w + -0.022879312*e0.w + 0.008458778*f0.w + -0.0017262232*g0.w + 0.015090765*h0.w + -0.040642884*i0.w;
    m = -0.054323617*a1.x + -0.10455227*b1.x + 0.11347284*c1.x + 0.084072776*d1.x + -0.1276103*e1.x + -0.07317883*f1.x + 0.11719509*g1.x + 0.057568833*h1.x + -0.051696643*i1.x;
    n = 0.042820938*a1.y + -0.02861234*b1.y + -0.001742703*c1.y + -0.02341394*d1.y + 0.06754185*e1.y + 0.17484309*f1.y + 0.04625852*g1.y + 0.013787463*h1.y + 0.021725819*i1.y;
    o = 0.015193026*a1.z + 0.022666635*b1.z + -0.004895655*c1.z + 0.079393126*d1.z + -0.041474957*e1.z + 0.022292048*f1.z + -0.04631282*g1.z + -0.2341182*h1.z + -0.047459356*i1.z;
    p = 0.069909975*a1.w + 0.09708741*b1.w + -0.015319313*c1.w + 0.08355726*d1.w + -0.089847885*e1.w + 0.036775794*f1.w + -0.08940877*g1.w + -0.10380246*h1.w + -0.01191475*i1.w;
    q = -0.027098697*na0.x + -0.012161473*nb0.x + -0.026864702*nc0.x + -0.12660462*nd0.x + 0.0990314*ne0.x + -0.12914999*nf0.x + -0.046412915*ng0.x + -0.12010923*nh0.x + -0.11516924*ni0.x;
    r = -0.033694383*na0.y + 0.06400211*nb0.y + -0.041638944*nc0.y + 0.058733433*nd0.y + 0.13461815*ne0.y + 0.069503896*nf0.y + 0.057904493*ng0.y + 0.04740161*nh0.y + 0.052169807*ni0.y;
    s = -0.1280024*na0.z + 0.07261403*nb0.z + -0.16699356*nc0.z + -0.18404467*nd0.z + 0.03145433*ne0.z + -0.25424013*nf0.z + -0.05147552*ng0.z + -0.026482437*nh0.z + -0.10573895*ni0.z;
    t = 0.067109175*na0.w + 0.031449948*nb0.w + 0.013580667*nc0.w + 0.08999468*nd0.w + 0.06441078*ne0.w + 0.011897138*nf0.w + -0.02429012*ng0.w + -0.014271303*nh0.w + 0.040478792*ni0.w;
    u = 0.012266889*na1.x + 0.012559257*nb1.x + -0.09407199*nc1.x + 0.053907778*nd1.x + 0.098508924*ne1.x + 0.15341955*nf1.x + 0.006937512*ng1.x + 0.005956507*nh1.x + 0.03249789*ni1.x;
    v = 0.013781064*na1.y + 0.058633123*nb1.y + -0.0028954444*nc1.y + 0.05297195*nd1.y + 0.06769266*ne1.y + -0.02680043*nf1.y + -0.04230351*ng1.y + 0.009958785*nh1.y + 0.02449031*ni1.y;
    w = 0.02855934*na1.z + -0.027689163*nb1.z + -0.091561586*nc1.z + 0.07357439*nd1.z + 0.07912537*ne1.z + -0.007009628*nf1.z + 0.038752858*ng1.z + 0.22135073*nh1.z + 0.1820932*ni1.z;
    x = -0.11065314*na1.w + -0.07073019*nb1.w + -0.039376423*nc1.w + 0.002637176*nd1.w + 0.18356855*ne1.w + -0.08918799*nf1.w + 0.102989495*ng1.w + 0.091820255*nh1.w + 0.081612736*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.03237309;
    i = -0.029179381*a0.x + -0.399904*b0.x + -0.10546226*c0.x + -0.15321073*d0.x + -0.24549395*e0.x + 0.1059444*f0.x + 0.03506827*g0.x + -0.10771783*h0.x + -0.008853774*i0.x;
    j = 0.3460747*a0.y + 0.0865475*b0.y + -0.14424714*c0.y + -0.057151236*d0.y + 0.016695386*e0.y + 0.018587252*f0.y + 0.0057751653*g0.y + -0.04921362*h0.y + 0.08053979*i0.y;
    k = -0.07731715*a0.z + -0.33547333*b0.z + -0.19403888*c0.z + -0.13951413*d0.z + -0.2874189*e0.z + -0.0733894*f0.z + 0.083793215*g0.z + 0.010882907*h0.z + -0.0801371*i0.z;
    l = 0.086197056*a0.w + 0.042804822*b0.w + 0.06790401*c0.w + 0.11497068*d0.w + 0.40902892*e0.w + -0.100231454*f0.w + -0.09324331*g0.w + 0.061669666*h0.w + -0.078184955*i0.w;
    m = 0.1024341*a1.x + 0.09483551*b1.x + -0.11577831*c1.x + 0.061093554*d1.x + 0.4354177*e1.x + -0.003482848*f1.x + -0.054774903*g1.x + -0.052496303*h1.x + 0.055754557*i1.x;
    n = 0.027582759*a1.y + 0.048956715*b1.y + 0.081751816*c1.y + -0.08518418*d1.y + 0.0071396288*e1.y + -0.07494192*f1.y + -0.05762159*g1.y + 0.03547776*h1.y + -0.04589949*i1.y;
    o = 0.08761022*a1.z + -0.11256065*b1.z + -0.07362036*c1.z + -0.005784562*d1.z + -0.1518354*e1.z + 0.0707934*f1.z + 0.07585483*g1.z + -0.101856686*h1.z + 0.02290287*i1.z;
    p = -0.14703225*a1.w + -0.40506554*b1.w + -0.08841411*c1.w + -0.10106204*d1.w + 0.020844888*e1.w + -0.08255499*f1.w + 0.072836034*g1.w + -0.22072136*h1.w + 0.078699805*i1.w;
    q = 0.05410673*na0.x + 0.56434864*nb0.x + 0.15250632*nc0.x + 0.15072995*nd0.x + 0.23121674*ne0.x + -0.091878496*nf0.x + 0.021191215*ng0.x + 0.30648914*nh0.x + 0.0027192836*ni0.x;
    r = -0.15243874*na0.y + 0.16097021*nb0.y + 0.14542924*nc0.y + -0.2594916*nd0.y + 0.2001302*ne0.y + 0.15738378*nf0.y + 0.1125107*ng0.y + -0.000828865*nh0.y + 0.0034008678*ni0.y;
    s = 0.09582677*na0.z + -0.20216575*nb0.z + 0.0342159*nc0.z + 0.1348178*nd0.z + 0.25691655*ne0.z + 0.065807156*nf0.z + -0.04580014*ng0.z + -0.06942384*nh0.z + 0.094458185*ni0.z;
    t = -0.08216763*na0.w + -0.06083898*nb0.w + 0.0253852*nc0.w + -0.073093645*nd0.w + -0.11038054*ne0.w + 0.052107688*nf0.w + 0.1660941*ng0.w + -0.016418027*nh0.w + 0.03343749*ni0.w;
    u = -0.19165094*na1.x + -0.1334287*nb1.x + 0.0091586765*nc1.x + -0.10333341*nd1.x + -0.15913464*ne1.x + 0.0407771*nf1.x + 0.12843952*ng1.x + -0.08429767*nh1.x + -0.05745864*ni1.x;
    v = -0.081046775*na1.y + 0.07381984*nb1.y + 0.009666139*nc1.y + -0.038198773*nd1.y + 0.24606997*ne1.y + 0.14351115*nf1.y + 0.019953914*ng1.y + -0.0036941094*nh1.y + 0.12769328*ni1.y;
    w = -0.049717456*na1.z + 0.037626073*nb1.z + 0.04401121*nc1.z + -0.09087364*nd1.z + 0.0401449*ne1.z + 0.1321236*nf1.z + -0.17823285*ng1.z + 0.053816546*nh1.z + -0.028679416*ni1.z;
    x = 0.13035227*na1.w + 0.27161187*nb1.w + 0.031947732*nc1.w + -0.0975645*nd1.w + 0.16841753*ne1.w + -0.27727732*nf1.w + -0.21447992*ng1.w + 0.078854404*nh1.w + -0.054858927*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.01894838;
    i = 0.0079668425*a0.x + -0.07422627*b0.x + -0.05381097*c0.x + -0.001110633*d0.x + -0.20713502*e0.x + -0.056877725*f0.x + 0.14787298*g0.x + -0.007461876*h0.x + 0.11331837*i0.x;
    j = 0.06312278*a0.y + -0.1544424*b0.y + 0.11058164*c0.y + 0.5353646*d0.y + 0.4057092*e0.y + -0.016643116*f0.y + -0.18393958*g0.y + 0.081287585*h0.y + 0.13400263*i0.y;
    k = 0.050054587*a0.z + 0.390245*b0.z + 0.07146366*c0.z + -0.025271675*d0.z + 0.24546371*e0.z + -0.06178857*f0.z + 0.15098862*g0.z + -0.06981505*h0.z + -0.000883212*i0.z;
    l = -0.14884777*a0.w + -0.030569784*b0.w + -0.034837935*c0.w + 0.17419794*d0.w + -0.15046959*e0.w + 0.034272935*f0.w + -0.02676834*g0.w + -0.075397864*h0.w + -0.13665098*i0.w;
    m = 0.006430372*a1.x + 0.03326361*b1.x + 0.22867146*c1.x + 0.060091905*d1.x + 0.10638443*e1.x + -0.03568107*f1.x + -0.07123764*g1.x + 0.08767965*h1.x + 0.0161292*i1.x;
    n = 0.10730417*a1.y + -0.123981245*b1.y + -0.12169163*c1.y + -0.060162723*d1.y + 0.2749544*e1.y + -0.022398425*f1.y + -0.04764729*g1.y + -0.07512602*h1.y + 0.0038564159*i1.y;
    o = -0.11018294*a1.z + 0.110614195*b1.z + -0.051655006*c1.z + 0.026749836*d1.z + -0.018087594*e1.z + 0.15209238*f1.z + -0.07122703*g1.z + -0.124878496*h1.z + -0.012159373*i1.z;
    p = -0.01836787*a1.w + 0.11678819*b1.w + -0.14215414*c1.w + -0.027997391*d1.w + -0.2400757*e1.w + 0.11681005*f1.w + 0.048901644*g1.w + 0.27619568*h1.w + 0.12937818*i1.w;
    q = -0.007452019*na0.x + -0.108269095*nb0.x + 0.0377401*nc0.x + -0.025126463*nd0.x + -0.25620756*ne0.x + 0.032948766*nf0.x + 0.119483955*ng0.x + -0.009526129*nh0.x + -0.24419886*ni0.x;
    r = 0.05470462*na0.y + -0.10784284*nb0.y + -0.16701409*nc0.y + -0.2059512*nd0.y + -0.5498889*ne0.y + -0.03296476*nf0.y + -0.036837514*ng0.y + 0.06995424*nh0.y + -0.18900663*ni0.y;
    s = 0.03921239*na0.z + -0.21186037*nb0.z + -0.034299407*nc0.z + -0.055376794*nd0.z + -0.24106656*ne0.z + 0.11517722*nf0.z + -0.08621893*ng0.z + 0.21757211*nh0.z + 0.08821429*ni0.z;
    t = 0.053762823*na0.w + 0.12375887*nb0.w + -0.040141582*nc0.w + -0.0043350835*nd0.w + -0.13625754*ne0.w + -0.066250436*nf0.w + 0.022221101*ng0.w + 0.0782264*nh0.w + 0.060842544*ni0.w;
    u = -0.06924076*na1.x + 0.0055637453*nb1.x + 0.022828998*nc1.x + 0.014314398*nd1.x + -0.21101159*ne1.x + 0.08400121*nf1.x + 0.045525722*ng1.x + 0.2275885*nh1.x + 0.019211018*ni1.x;
    v = 0.016533395*na1.y + 0.24990486*nb1.y + 0.008917476*nc1.y + -0.075179845*nd1.y + -0.55625296*ne1.y + 0.024725836*nf1.y + 0.055780824*ng1.y + 0.14240427*nh1.y + 0.0060216533*ni1.y;
    w = 0.14341103*na1.z + -0.00055958953*nb1.z + -0.0022099577*nc1.z + -0.07100837*nd1.z + -0.11276687*ne1.z + -0.21479277*nf1.z + -0.05732173*ng1.z + -0.0015413442*nh1.z + 0.13017043*ni1.z;
    x = -0.04714052*na1.w + -0.07072589*nb1.w + 0.25506595*nc1.w + -0.015962688*nd1.w + 0.0036053585*ne1.w + -0.2162668*nf1.w + -0.045118492*ng1.w + -0.120520905*nh1.w + -0.08143057*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.011888741;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN80

#define L0_tex LUMAN70_tex
#define L1_tex LUMAN71_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.030014958*a0.x + 0.11617654*b0.x + 0.085433066*c0.x + -0.1261423*d0.x + 0.047405504*e0.x + 0.061996467*f0.x + -0.10112785*g0.x + 0.047271233*h0.x + -0.06215415*i0.x;
    float j = -0.0022536367*a0.y + -0.0060937707*b0.y + -0.10756953*c0.y + 0.31538245*d0.y + 0.037766777*e0.y + -0.056547288*f0.y + 0.14819144*g0.y + -0.10782268*h0.y + -0.06100584*i0.y;
    float k = 0.08497498*a0.z + 0.26157343*b0.z + 0.013502692*c0.z + 0.0699558*d0.z + -0.19328873*e0.z + -0.0475276*f0.z + 0.026507724*g0.z + -0.06282603*h0.z + -0.04068036*i0.z;
    float l = 0.046383705*a0.w + -0.12183681*b0.w + -0.00920855*c0.w + 0.048471894*d0.w + -0.12586446*e0.w + -0.019446298*f0.w + -0.06742635*g0.w + 0.057105564*h0.w + 0.06584737*i0.w;
    float m = 0.05995811*a1.x + 0.057865914*b1.x + 0.08130486*c1.x + 0.012107202*d1.x + -0.077897824*e1.x + 0.020051733*f1.x + -0.03836068*g1.x + -0.03387517*h1.x + -0.08656535*i1.x;
    float n = -0.20272078*a1.y + -0.2898444*b1.y + -0.10181991*c1.y + 0.13289294*d1.y + -0.06898282*e1.y + 0.05879356*f1.y + 0.15247238*g1.y + -0.11598066*h1.y + 0.15448447*i1.y;
    float o = -0.010809236*a1.z + -0.013210217*b1.z + 0.025830679*c1.z + 0.06216019*d1.z + 0.107064195*e1.z + -0.042192664*f1.z + 0.09274758*g1.z + 0.15812838*h1.z + 0.06922273*i1.z;
    float p = -0.0037883355*a1.w + 0.34655213*b1.w + -0.045297805*c1.w + 0.31633198*d1.w + -0.025437295*e1.w + -0.0737913*f1.w + -0.050256167*g1.w + 0.13340046*h1.w + -0.000409566*i1.w;
    float q = 0.1492289*na0.x + -0.108267814*nb0.x + -0.10260736*nc0.x + 0.11189305*nd0.x + -0.10544551*ne0.x + -0.04593426*nf0.x + -0.0037677416*ng0.x + 0.017464899*nh0.x + 0.06664255*ni0.x;
    float r = -0.046894286*na0.y + -0.056725997*nb0.y + -0.004030325*nc0.y + -0.24687865*nd0.y + -0.22705816*ne0.y + 0.03502431*nf0.y + -0.07323742*ng0.y + 0.05469924*nh0.y + 0.081741415*ni0.y;
    float s = 0.08213016*na0.z + 0.0768773*nb0.z + -0.03537941*nc0.z + -0.06633537*nd0.z + 0.114069745*ne0.z + -0.009495883*nf0.z + -0.018679574*ng0.z + 0.013978387*nh0.z + 0.026871966*ni0.z;
    float t = -0.050113708*na0.w + -0.017639171*nb0.w + 0.08944528*nc0.w + -0.06568055*nd0.w + 0.06749932*ne0.w + -0.001076881*nf0.w + 0.021033864*ng0.w + -0.029971706*nh0.w + -0.024673859*ni0.w;
    float u = -0.09274935*na1.x + -0.017219407*nb1.x + 0.07153254*nc1.x + -0.019134559*nd1.x + 0.010959568*ne1.x + 0.027879566*nf1.x + -0.05605097*ng1.x + 0.18517093*nh1.x + 0.24163705*ni1.x;
    float v = -0.030460613*na1.y + 0.23515613*nb1.y + -0.01676363*nc1.y + -0.21486633*nd1.y + 0.12725422*ne1.y + -0.035603005*nf1.y + -0.060448986*ng1.y + 0.14119609*nh1.y + -0.10942523*ni1.y;
    float w = -0.017671324*na1.z + 0.07077782*nb1.z + 0.047625095*nc1.z + -0.036915924*nd1.z + -0.034874*ne1.z + 0.04056334*nf1.z + -0.014123004*ng1.z + -0.13069338*nh1.z + -0.039977293*ni1.z;
    float x = -0.034061715*na1.w + 0.044890523*nb1.w + 0.027299663*nc1.w + 0.110332996*nd1.w + -0.1110489*ne1.w + -0.024894679*nf1.w + 0.0005082329*ng1.w + -0.09139057*nh1.w + 0.0022179424*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0010033762;
    i = 0.06580976*a0.x + 0.090325564*b0.x + -0.092303224*c0.x + -0.1921632*d0.x + 0.16887501*e0.x + 0.061186858*f0.x + -0.13799244*g0.x + -0.080583975*h0.x + 0.08009438*i0.x;
    j = 0.038827766*a0.y + 0.07129585*b0.y + 0.06457054*c0.y + 0.073699266*d0.y + 0.3741513*e0.y + 0.32814056*f0.y + -0.04161421*g0.y + -0.06328244*h0.y + -0.014121296*i0.y;
    k = -0.11162559*a0.z + 0.20382778*b0.z + -0.021276347*c0.z + -0.1364239*d0.z + -0.0548872*e0.z + -0.033816505*f0.z + -0.037953682*g0.z + 0.09243351*h0.z + 0.06231525*i0.z;
    l = 0.02048114*a0.w + 0.01175961*b0.w + 0.054151285*c0.w + -0.029600991*d0.w + -0.023824004*e0.w + -0.06510234*f0.w + 0.03927156*g0.w + 0.06499078*h0.w + -0.022784628*i0.w;
    m = 0.016850956*a1.x + 0.026961625*b1.x + -0.052743986*c1.x + 0.09705815*d1.x + 0.06611641*e1.x + -0.01187191*f1.x + 0.047533214*g1.x + 0.061463118*h1.x + 0.044322684*i1.x;
    n = 0.12926874*a1.y + 0.03249992*b1.y + 0.09031417*c1.y + -0.057206884*d1.y + 0.046107754*e1.y + 0.1735186*f1.y + -0.0065893475*g1.y + 0.013552741*h1.y + 0.069328934*i1.y;
    o = -0.016670505*a1.z + -0.021578414*b1.z + 0.02550263*c1.z + -0.07529392*d1.z + 0.3573727*e1.z + 0.17333965*f1.z + 0.10505426*g1.z + 0.09388872*h1.z + 0.040832248*i1.z;
    p = 0.0022655723*a1.w + 0.0432011*b1.w + -0.037488054*c1.w + -0.10123399*d1.w + -0.013312289*e1.w + 0.39810044*f1.w + 0.1703332*g1.w + 0.267194*h1.w + 0.057249423*i1.w;
    q = -0.09817141*na0.x + -0.12814802*nb0.x + -0.031350434*nc0.x + 0.05429472*nd0.x + 0.026484033*ne0.x + 0.008525635*nf0.x + -0.01994405*ng0.x + 0.018937474*nh0.x + 0.08722303*ni0.x;
    r = -0.045527373*na0.y + -0.03788133*nb0.y + 0.06380586*nc0.y + -0.14537066*nd0.y + -0.37773526*ne0.y + -0.13665448*nf0.y + 0.0038751678*ng0.y + 0.023434704*nh0.y + -0.0126121305*ni0.y;
    s = 0.032455314*na0.z + -0.07014963*nb0.z + -0.10840794*nc0.z + 0.056593336*nd0.z + 0.0997226*ne0.z + 0.073279805*nf0.z + 0.03609249*ng0.z + -0.09388379*nh0.z + 0.04320686*ni0.z;
    t = 0.02869842*na0.w + 0.019633632*nb0.w + -0.20761648*nc0.w + 0.007862745*nd0.w + 0.17206855*ne0.w + 0.115441*nf0.w + -0.023055*ng0.w + -0.107899405*nh0.w + 0.03358721*ni0.w;
    u = -0.15021364*na1.x + -0.058106124*nb1.x + -0.05313934*nc1.x + -0.21935156*nd1.x + -0.2837029*ne1.x + -0.32703993*nf1.x + 0.004271712*ng1.x + 0.011703954*nh1.x + -0.026351063*ni1.x;
    v = 0.089627355*na1.y + 0.10110276*nb1.y + -0.08566261*nc1.y + 0.08988744*nd1.y + 0.2736199*ne1.y + 0.061440755*nf1.y + -0.11867137*ng1.y + -0.13680026*nh1.y + -0.016994294*ni1.y;
    w = -0.012109746*na1.z + 0.14445293*nb1.z + 0.0195051*nc1.z + 0.02936328*nd1.z + -0.23767959*ne1.z + -0.062147606*nf1.z + -0.03837298*ng1.z + -0.09438165*nh1.z + -0.014003857*ni1.z;
    x = 0.04015821*na1.w + 0.08921114*nb1.w + -0.03781241*nc1.w + 0.04544161*nd1.w + -0.15047587*ne1.w + -0.113894925*nf1.w + -0.016270371*ng1.w + -0.14870341*nh1.w + -0.07838714*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.005233699;
    i = 0.20332266*a0.x + 0.23113528*b0.x + -0.10499726*c0.x + 0.21304177*d0.x + 0.45694575*e0.x + 0.36973694*f0.x + 0.006872644*g0.x + -0.03629579*h0.x + 0.20627238*i0.x;
    j = -0.018542264*a0.y + 0.028391898*b0.y + 0.21007666*c0.y + -0.09255135*d0.y + 0.18852337*e0.y + 0.0866432*f0.y + -0.011221141*g0.y + 0.018708965*h0.y + -0.032289498*i0.y;
    k = 0.15601139*a0.z + -0.17568673*b0.z + 0.24954684*c0.z + -0.110788256*d0.z + 0.11692911*e0.z + -0.12018874*f0.z + -0.00792691*g0.z + -0.09534362*h0.z + 0.02132795*i0.z;
    l = 0.08638691*a0.w + 0.19674756*b0.w + 0.016465437*c0.w + 0.13435258*d0.w + 0.90902215*e0.w + 0.07517919*f0.w + -0.049425308*g0.w + -0.008632366*h0.w + -0.054769877*i0.w;
    m = -0.07453417*a1.x + 0.21790457*b1.x + 0.008162849*c1.x + -0.12394449*d1.x + 0.0059843827*e1.x + 0.24361402*f1.x + -0.092146195*g1.x + 0.16333053*h1.x + 0.2316521*i1.x;
    n = -0.098842025*a1.y + 0.23345315*b1.y + -0.13376193*c1.y + -0.12635028*d1.y + 0.2304464*e1.y + -0.19060019*f1.y + 0.12952028*g1.y + -0.11751126*h1.y + 0.0019323531*i1.y;
    o = 0.004379882*a1.z + 0.017078549*b1.z + -0.007666424*c1.z + 0.11348806*d1.z + 0.3738288*e1.z + 0.044007506*f1.z + 0.06397631*g1.z + 0.21504378*h1.z + -0.0026930957*i1.z;
    p = 0.08295408*a1.w + 0.055759627*b1.w + -0.066816345*c1.w + -0.05859507*d1.w + -0.0877545*e1.w + -0.28591236*f1.w + -0.17089866*g1.w + 0.27644*h1.w + 0.0549539*i1.w;
    q = 0.08697659*na0.x + -0.20226933*nb0.x + 0.15128252*nc0.x + 0.039843*nd0.x + -0.2318923*ne0.x + -0.14413634*nf0.x + 0.109713756*ng0.x + 0.122127*nh0.x + -0.05870938*ni0.x;
    r = 0.017261934*na0.y + 0.016533656*nb0.y + -0.13422614*nc0.y + -0.13052954*nd0.y + -0.082109*ne0.y + -0.24890792*nf0.y + -0.17485248*ng0.y + 0.024029763*nh0.y + 0.083183855*ni0.y;
    s = 0.22126782*na0.z + -0.17896856*nb0.z + -0.08393778*nc0.z + 0.051395986*nd0.z + -0.38001397*ne0.z + 0.1924813*nf0.z + 0.04588781*ng0.z + -0.0063535552*nh0.z + -0.047122724*ni0.z;
    t = -0.14722922*na0.w + 0.097014315*nb0.w + -0.080777146*nc0.w + -0.20412444*nd0.w + -0.39001748*ne0.w + 0.06972371*nf0.w + -0.015583117*ng0.w + 0.0060410476*nh0.w + 0.002779453*ni0.w;
    u = -0.15266632*na1.x + 0.1406486*nb1.x + -0.023325102*nc1.x + 0.33111537*nd1.x + -0.26280713*ne1.x + -0.30597302*nf1.x + 0.03293922*ng1.x + -0.06366053*nh1.x + -0.2563068*ni1.x;
    v = 0.10465601*na1.y + 0.19904912*nb1.y + 0.35142493*nc1.y + 0.0524759*nd1.y + 0.26105863*ne1.y + 0.18162589*nf1.y + -0.13980812*ng1.y + 0.08652187*nh1.y + 0.08691816*ni1.y;
    w = -0.020547593*na1.z + 0.03622464*nb1.z + 0.1620944*nc1.z + -0.031112235*nd1.z + -0.3012553*ne1.z + 0.104967594*nf1.z + -0.04882421*ng1.z + 0.08929665*nh1.z + -0.12291634*ni1.z;
    x = -0.014448424*na1.w + 0.01894318*nb1.w + 0.07474613*nc1.w + -0.086192556*nd1.w + 0.053702205*ne1.w + 0.015262595*nf1.w + 0.0712923*ng1.w + -0.11414189*nh1.w + -0.11893973*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.022504877;
    i = 0.06429385*a0.x + -0.091512606*b0.x + -0.024693118*c0.x + -0.22510907*d0.x + -0.30308828*e0.x + -0.048171345*f0.x + -0.051559918*g0.x + -0.06886774*h0.x + -0.012772176*i0.x;
    j = -0.073987395*a0.y + -0.3457657*b0.y + -0.0025134888*c0.y + -0.04905519*d0.y + -0.3512132*e0.y + 0.123302355*f0.y + -0.19281262*g0.y + 0.0027089259*h0.y + -0.034404445*i0.y;
    k = -0.10127784*a0.z + -0.13300103*b0.z + -0.02991685*c0.z + -0.1664028*d0.z + -0.05791024*e0.z + -0.066117615*f0.z + -0.065625034*g0.z + 0.19767064*h0.z + -0.14864634*i0.z;
    l = -0.050169848*a0.w + 0.28215423*b0.w + 0.15401876*c0.w + -0.08515883*d0.w + 0.21773921*e0.w + -0.010577921*f0.w + 0.14295639*g0.w + 0.023680558*h0.w + 0.07321661*i0.w;
    m = -0.0017102464*a1.x + -0.08169556*b1.x + -0.0077006533*c1.x + 0.072557054*d1.x + -0.11251691*e1.x + 0.08526943*f1.x + -0.00020871482*g1.x + -0.044559553*h1.x + -0.08441698*i1.x;
    n = 0.11166287*a1.y + 0.13018124*b1.y + 0.12614363*c1.y + 0.17918706*d1.y + 0.138985*e1.y + -0.07021701*f1.y + -0.038741305*g1.y + 0.09958653*h1.y + 0.001882147*i1.y;
    o = 0.06696661*a1.z + 0.0031226731*b1.z + 0.018931026*c1.z + -0.2124317*d1.z + -0.039044634*e1.z + 0.09647277*f1.z + -0.023537027*g1.z + 0.1913286*h1.z + 0.06601882*i1.z;
    p = 0.11267788*a1.w + 0.07517228*b1.w + -0.011346144*c1.w + -0.23570742*d1.w + -0.29205522*e1.w + 0.054553967*f1.w + 0.03259228*g1.w + -0.019599134*h1.w + 0.033477396*i1.w;
    q = -0.20862566*na0.x + 0.013916686*nb0.x + 0.094481535*nc0.x + -0.16677813*nd0.x + 0.331288*ne0.x + -0.00072936434*nf0.x + -0.029819883*ng0.x + -0.08621884*nh0.x + 0.0015680068*ni0.x;
    r = 0.09338383*na0.y + 0.19255875*nb0.y + -0.05818667*nc0.y + 0.11013603*nd0.y + 0.31287682*ne0.y + -0.119134955*nf0.y + 0.19530609*ng0.y + -0.019883394*nh0.y + 0.057758797*ni0.y;
    s = 0.036111437*na0.z + 0.11467648*nb0.z + 0.14144741*nc0.z + 0.0014821922*nd0.z + 0.15492304*ne0.z + 0.07086891*nf0.z + 0.08650872*ng0.z + -0.09055274*nh0.z + 0.06259116*ni0.z;
    t = 0.13245824*na0.w + -0.33671287*nb0.w + -0.06967657*nc0.w + 0.21634886*nd0.w + -0.17046133*ne0.w + 0.24341889*nf0.w + -0.013452368*ng0.w + -0.027392244*nh0.w + 0.01873684*ni0.w;
    u = 0.060082868*na1.x + 0.2109921*nb1.x + 0.030791614*nc1.x + -0.1392062*nd1.x + -0.088582*ne1.x + -0.023536798*nf1.x + -0.046534453*ng1.x + 0.008117058*nh1.x + 0.12310186*ni1.x;
    v = 0.011159707*na1.y + -0.24601986*nb1.y + -0.06805425*nc1.y + 0.21778165*nd1.y + -0.20652544*ne1.y + 0.26376507*nf1.y + -0.030255495*ng1.y + -0.08734944*nh1.y + -0.0077105393*ni1.y;
    w = -0.062475488*na1.z + 0.072401844*nb1.z + -0.019962879*nc1.z + 0.16892117*nd1.z + 0.025962003*ne1.z + -0.110477984*nf1.z + 0.07653261*ng1.z + -0.2317498*nh1.z + -0.13628756*ni1.z;
    x = -0.0056055044*na1.w + -0.12222951*nb1.w + -0.05291652*nc1.w + 0.02045731*nd1.w + -0.25283408*ne1.w + -0.038071007*nf1.w + -0.09783437*ng1.w + -0.054983437*nh1.w + -0.0651251*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.04249854;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN81

#define L0_tex LUMAN70_tex
#define L1_tex LUMAN71_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.0066694217*a0.x + 0.11847723*b0.x + 0.027041575*c0.x + -0.096739955*d0.x + -0.2433321*e0.x + 0.32472065*f0.x + 0.17193161*g0.x + 0.25872856*h0.x + 0.16033795*i0.x;
    float j = 0.046591174*a0.y + 0.124460176*b0.y + -0.008698186*c0.y + 0.124230005*d0.y + -0.28624266*e0.y + 0.16834712*f0.y + -0.11461091*g0.y + 0.030672451*h0.y + -0.02390204*i0.y;
    float k = -0.1980102*a0.z + 0.14983565*b0.z + 0.13953343*c0.z + 0.040665563*d0.z + 0.4056147*e0.z + 0.12841807*f0.z + -0.039405465*g0.z + -0.016812282*h0.z + -0.018724015*i0.z;
    float l = -0.063325174*a0.w + -0.14346766*b0.w + 0.023345768*c0.w + 0.006257241*d0.w + 0.39503187*e0.w + 0.027097229*f0.w + 0.052904844*g0.w + -0.07785531*h0.w + -0.126849*i0.w;
    float m = 0.06949972*a1.x + -0.17687106*b1.x + -0.034545206*c1.x + 0.06276032*d1.x + -0.28677166*e1.x + 0.25227562*f1.x + -0.0658834*g1.x + 0.0790822*h1.x + 0.18264319*i1.x;
    float n = 0.20627318*a1.y + -0.04966547*b1.y + -0.14028211*c1.y + 0.06429192*d1.y + -0.41474065*e1.y + 0.009008643*f1.y + -0.004014575*g1.y + -0.08488616*h1.y + -0.027536016*i1.y;
    float o = -0.033429027*a1.z + -0.061252594*b1.z + -0.09639897*c1.z + -0.0541709*d1.z + -0.080302484*e1.z + 0.021496745*f1.z + 0.13290937*g1.z + -0.2129115*h1.z + -0.08675345*i1.z;
    float p = -0.05321618*a1.w + 0.16918896*b1.w + 0.017845973*c1.w + -0.0268489*d1.w + 0.35835636*e1.w + -0.019922512*f1.w + 0.010317201*g1.w + -0.08562699*h1.w + -0.15053023*i1.w;
    float q = 0.029751813*na0.x + -0.07666209*nb0.x + -0.051187597*nc0.x + 0.1488955*nd0.x + 0.14131892*ne0.x + -0.0017594409*nf0.x + -0.06904229*ng0.x + -0.18003106*nh0.x + -0.2109423*ni0.x;
    float r = -0.10874734*na0.y + -0.07052802*nb0.y + 0.028145788*nc0.y + -0.11203796*nd0.y + -0.18286729*ne0.y + -0.044190012*nf0.y + 0.14456281*ng0.y + 0.22468443*nh0.y + 0.06806424*ni0.y;
    float s = 0.0056482283*na0.z + 0.05038214*nb0.z + -0.054723658*nc0.z + 0.17140733*nd0.z + -0.20605274*ne0.z + 0.008235773*nf0.z + 0.00076351484*ng0.z + -0.014465802*nh0.z + -0.0011295063*ni0.z;
    float t = 0.03727619*na0.w + 0.009911164*nb0.w + -0.06400696*nc0.w + -0.118588045*nd0.w + -0.3762935*ne0.w + -0.049205016*nf0.w + -0.011016333*ng0.w + 0.045067854*nh0.w + 0.062944*ni0.w;
    float u = 0.0128412265*na1.x + 0.08549091*nb1.x + -0.11035337*nc1.x + -0.19317722*nd1.x + 0.32658654*ne1.x + -0.13700837*nf1.x + 0.16626875*ng1.x + 0.057037096*nh1.x + -0.20406239*ni1.x;
    float v = -0.0826136*na1.y + 0.09659021*nb1.y + -0.033466462*nc1.y + -0.35497645*nd1.y + 0.19551568*ne1.y + -0.08828759*nf1.y + -0.03977853*ng1.y + 0.031591333*nh1.y + 0.045049287*ni1.y;
    float w = -0.009541883*na1.z + 0.0649394*nb1.z + -0.005798986*nc1.z + -0.010381588*nd1.z + 0.008219264*ne1.z + 0.16208616*nf1.z + -0.06818159*ng1.z + 0.100467354*nh1.z + 0.060734566*ni1.z;
    float x = 0.1266532*na1.w + 0.061005235*nb1.w + 0.0046074055*nc1.w + 0.09715183*nd1.w + -0.3036943*ne1.w + 0.07832144*nf1.w + -0.003973035*ng1.w + 0.08835643*nh1.w + 0.04062082*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.02271852;
    i = 0.18110195*a0.x + -0.17357115*b0.x + 0.026732111*c0.x + 0.012301222*d0.x + -0.455591*e0.x + -0.26068583*f0.x + -0.08844089*g0.x + -0.0048143766*h0.x + -0.03246129*i0.x;
    j = -0.09655088*a0.y + 0.095917135*b0.y + 0.032161884*c0.y + 0.06800457*d0.y + 0.20549932*e0.y + -0.028239787*f0.y + 0.023079311*g0.y + -0.05668374*h0.y + -0.06884348*i0.y;
    k = 0.15276624*a0.z + -0.054857254*b0.z + -0.018425446*c0.z + -0.005746271*d0.z + 0.002684244*e0.z + 0.07194655*f0.z + 0.047085393*g0.z + -0.068998106*h0.z + 0.11390368*i0.z;
    l = -0.108120814*a0.w + -0.19515012*b0.w + -0.13582878*c0.w + 0.07356536*d0.w + 0.18283905*e0.w + -0.039374176*f0.w + 0.02256634*g0.w + 0.05627407*h0.w + 0.044026434*i0.w;
    m = -0.10994438*a1.x + 0.05130847*b1.x + -0.1455887*c1.x + 0.08437886*d1.x + 0.15179005*e1.x + -0.14680521*f1.x + 0.06338043*g1.x + 0.086142145*h1.x + 0.0077787247*i1.x;
    n = -0.29151785*a1.y + 0.03852581*b1.y + -0.041870143*c1.y + -0.08994941*d1.y + -0.41039798*e1.y + -0.048835553*f1.y + -0.05302519*g1.y + -0.020273345*h1.y + -0.0685774*i1.y;
    o = 0.040446658*a1.z + 0.05880254*b1.z + 0.1353693*c1.z + -0.005083114*d1.z + -0.40046036*e1.z + 0.09095645*f1.z + 0.033785086*g1.z + 0.045549124*h1.z + -0.018644862*i1.z;
    p = -0.062142696*a1.w + -0.15257972*b1.w + 0.28831935*c1.w + 0.27487394*d1.w + 0.82982075*e1.w + 0.4084299*f1.w + 0.21701102*g1.w + 0.12382357*h1.w + -0.06802407*i1.w;
    q = -0.0730035*na0.x + 0.12232848*nb0.x + -0.12472037*nc0.x + 0.12043143*nd0.x + 0.37559772*ne0.x + 0.017626943*nf0.x + -0.0844148*ng0.x + 0.062597916*nh0.x + 0.10833959*ni0.x;
    r = 0.18921937*na0.y + 0.0033235173*nb0.y + -0.062161192*nc0.y + -0.25184554*nd0.y + -0.14324915*ne0.y + 0.03589457*nf0.y + 0.051313072*ng0.y + 0.05705345*nh0.y + -0.14872095*ni0.y;
    s = -0.025778696*na0.z + 0.42599228*nb0.z + 0.1270628*nc0.z + 0.30984098*nd0.z + 0.2527526*ne0.z + 0.01553217*nf0.z + -0.012882554*ng0.z + -0.109922536*nh0.z + 0.04123468*ni0.z;
    t = -0.017181087*na0.w + -0.10710051*nb0.w + 0.009613792*nc0.w + -0.043247163*nd0.w + -0.16020131*ne0.w + -0.010467985*nf0.w + -0.03849282*ng0.w + -0.049011692*nh0.w + -0.011761578*ni0.w;
    u = 0.09972438*na1.x + -0.2580635*nb1.x + -0.017552543*nc1.x + 0.018904842*nd1.x + 0.39619398*ne1.x + 0.21503401*nf1.x + -0.07482423*ng1.x + -0.26168364*nh1.x + -0.009754018*ni1.x;
    v = -0.038097814*na1.y + -0.4189689*nb1.y + 0.059011087*nc1.y + 0.15903711*nd1.y + 0.19178723*ne1.y + -0.051329754*nf1.y + -0.09679991*ng1.y + 0.06918306*nh1.y + 0.06901496*ni1.y;
    w = -0.06428947*na1.z + -0.09784677*nb1.z + -0.057076678*nc1.z + -0.12429604*nd1.z + 0.5481482*ne1.z + -0.02944002*nf1.z + -0.021831183*ng1.z + -0.18884462*nh1.z + 0.09481327*ni1.z;
    x = -0.14835794*na1.w + -0.0015569549*nb1.w + -0.020120803*nc1.w + -0.0118614435*nd1.w + 0.10279072*ne1.w + 0.019891072*nf1.w + 0.024419032*ng1.w + -0.07522632*nh1.w + 0.0125360815*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.016688297;
    i = 0.022757962*a0.x + 0.02831483*b0.x + -0.024892079*c0.x + -0.043009497*d0.x + -0.36408705*e0.x + 0.022713907*f0.x + -0.0811036*g0.x + 0.08509479*h0.x + -0.0022488856*i0.x;
    j = 0.022810793*a0.y + 0.0048847296*b0.y + -0.028201994*c0.y + 0.03456093*d0.y + 0.059152238*e0.y + -0.01956595*f0.y + 0.14083938*g0.y + 0.022517703*h0.y + -0.03256878*i0.y;
    k = 0.08028264*a0.z + -0.043960344*b0.z + -0.05163768*c0.z + -0.053347483*d0.z + 0.1713494*e0.z + -0.08546151*f0.z + 0.12917145*g0.z + -0.11523469*h0.z + 0.04434896*i0.z;
    l = 0.0070776334*a0.w + 0.01771322*b0.w + 0.031519383*c0.w + 0.06731833*d0.w + 0.5843218*e0.w + 0.0075026383*f0.w + -0.007780201*g0.w + -0.09049023*h0.w + 0.0283541*i0.w;
    m = -0.051404253*a1.x + 0.06477344*b1.x + 0.011257389*c1.x + -0.018775849*d1.x + -0.15087715*e1.x + -0.051606953*f1.x + -0.05180129*g1.x + -0.07518411*h1.x + -0.05315761*i1.x;
    n = 0.03283867*a1.y + 0.2618311*b1.y + 0.18127936*c1.y + 0.09457198*d1.y + 0.022065504*e1.y + 0.17226379*f1.y + 0.039727535*g1.y + 0.053066168*h1.y + 0.0070788665*i1.y;
    o = 0.0069599035*a1.z + 0.115369335*b1.z + 0.02263262*c1.z + 0.020387944*d1.z + -0.19383186*e1.z + -0.028164485*f1.z + 0.019880418*g1.z + 0.24371304*h1.z + -0.0074491054*i1.z;
    p = -0.03378131*a1.w + 0.05114272*b1.w + 0.03528374*c1.w + 0.11546386*d1.w + 0.1651586*e1.w + 0.01913313*f1.w + -0.060500108*g1.w + -0.13903178*h1.w + 0.16105473*i1.w;
    q = -0.014397411*na0.x + -0.037639458*nb0.x + -0.06076013*nc0.x + 0.096218646*nd0.x + 0.20562719*ne0.x + -0.12546235*nf0.x + 0.013834853*ng0.x + -0.00888692*nh0.x + 0.0678355*ni0.x;
    r = 0.026385974*na0.y + 0.028375747*nb0.y + -0.0004898619*nc0.y + -0.087545976*nd0.y + -0.003575773*ne0.y + 0.013268005*nf0.y + -0.14466694*ng0.y + -0.25483954*nh0.y + -0.007429993*ni0.y;
    s = 0.021479474*na0.z + 0.13291408*nb0.z + -0.062883794*nc0.z + 0.04626535*nd0.z + -0.33509022*ne0.z + -0.0073142285*nf0.z + -0.09122149*ng0.z + 0.15395486*nh0.z + 0.011943047*ni0.z;
    t = -0.052496914*na0.w + 0.08686347*nb0.w + -0.053467993*nc0.w + -0.038849387*nd0.w + -0.4468472*ne0.w + -0.05134658*nf0.w + -0.01964563*ng0.w + 0.0945286*nh0.w + -0.07229256*ni0.w;
    u = -0.19383687*na1.x + -0.12413539*nb1.x + 0.12611891*nc1.x + -0.05177286*nd1.x + -0.15787035*ne1.x + -0.22586027*nf1.x + -0.02653507*ng1.x + -0.09208067*nh1.x + 0.0790026*ni1.x;
    v = 0.045514755*na1.y + -0.20552722*nb1.y + -0.06940295*nc1.y + -0.12299648*nd1.y + 0.22533223*ne1.y + 0.020092113*nf1.y + 0.022371564*ng1.y + -0.10912476*nh1.y + -0.010708719*ni1.y;
    w = 0.038367108*na1.z + -0.09583574*nb1.z + 0.034882225*nc1.z + 0.04124136*nd1.z + 0.08524068*ne1.z + -0.09192149*nf1.z + -0.010648737*ng1.z + -0.06619061*nh1.z + 0.0106395045*ni1.z;
    x = -0.015929854*na1.w + 0.012495014*nb1.w + 0.025708143*nc1.w + -0.023310695*nd1.w + 0.0024336246*ne1.w + -0.10202505*nf1.w + 0.01887081*ng1.w + 0.040374048*nh1.w + -0.058974277*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.014066884;
    i = 0.079134114*a0.x + 0.30642658*b0.x + 0.037026163*c0.x + -0.1397397*d0.x + -0.18622641*e0.x + -0.25758827*f0.x + 0.16240206*g0.x + 0.09670797*h0.x + 0.014849251*i0.x;
    j = 0.01725062*a0.y + -0.17767917*b0.y + -0.18663113*c0.y + 0.26138157*d0.y + 0.19073991*e0.y + -0.10480241*f0.y + 0.12942258*g0.y + 0.12483446*h0.y + 0.0077056396*i0.y;
    k = -0.12391253*a0.z + -0.26585296*b0.z + -0.26151463*c0.z + 0.032111064*d0.z + -0.03331119*e0.z + -0.17423038*f0.z + 0.08324542*g0.z + -0.16682643*h0.z + 0.060358673*i0.z;
    l = -0.008409101*a0.w + 0.14207964*b0.w + 0.099567175*c0.w + -0.20250678*d0.w + 0.41887495*e0.w + 0.0065913643*f0.w + -0.09693957*g0.w + -0.013416045*h0.w + -0.06445816*i0.w;
    m = 0.0032202955*a1.x + -0.17340574*b1.x + 0.03461825*c1.x + -0.09251894*d1.x + -0.29680246*e1.x + -0.07626895*f1.x + -0.041007422*g1.x + -0.21885623*h1.x + 0.0700853*i1.x;
    n = 0.24577692*a1.y + 0.4333059*b1.y + 0.29536775*c1.y + 0.4680353*d1.y + 0.11400569*e1.y + 0.45554742*f1.y + 0.13454184*g1.y + 0.15872881*h1.y + 0.07784182*i1.y;
    o = 0.009872529*a1.z + 0.124596514*b1.z + 0.018574009*c1.z + -0.072379544*d1.z + -0.04941264*e1.z + -0.00915017*f1.z + 0.027756197*g1.z + 0.33998618*h1.z + 0.116189346*i1.z;
    p = 0.1058891*a1.w + 0.05857415*b1.w + -0.039698068*c1.w + -0.19868894*d1.w + -0.069923036*e1.w + 0.02231115*f1.w + -0.13126382*g1.w + -0.029347654*h1.w + 0.39165783*i1.w;
    q = -0.025738433*na0.x + -0.28366303*nb0.x + -0.25851208*nc0.x + 0.24409194*nd0.x + -0.08504448*ne0.x + -0.024518859*nf0.x + -0.049040448*ng0.x + -0.17092372*nh0.x + 0.14129514*ni0.x;
    r = 0.03214811*na0.y + 0.1917868*nb0.y + 0.018803194*nc0.y + -0.20698068*nd0.y + -0.069450565*ne0.y + 0.20778154*nf0.y + 0.0216441*ng0.y + -0.2653748*nh0.y + 0.024219675*ni0.y;
    s = -0.053946424*na0.z + 0.096878186*nb0.z + -0.00033841882*nc0.z + -0.3057939*nd0.z + -0.05195126*ne0.z + -0.08680512*nf0.z + -0.14885134*ng0.z + 0.28472355*nh0.z + -0.08745689*ni0.z;
    t = -0.07490327*na0.w + -0.08654825*nb0.w + -0.17518339*nc0.w + 0.026284566*nd0.w + -0.30165738*ne0.w + -0.039188627*nf0.w + 0.022762645*ng0.w + 0.06316042*nh0.w + 0.02202224*ni0.w;
    u = 0.036116045*na1.x + 0.26480165*nb1.x + 0.10783618*nc1.x + -0.089616984*nd1.x + 0.0107042035*ne1.x + -0.06687872*nf1.x + 0.12741867*ng1.x + 0.003457752*nh1.x + -0.15184306*ni1.x;
    v = 0.1127287*na1.y + -0.041010577*nb1.y + -0.27225387*nc1.y + -0.41610608*nd1.y + -0.122540645*ne1.y + -0.120056964*nf1.y + 0.055733103*ng1.y + -0.16395383*nh1.y + 0.04145389*ni1.y;
    w = -0.04001325*na1.z + -0.06777769*nb1.z + 0.015195856*nc1.z + 0.033097956*nd1.z + 0.057564102*ne1.z + -0.099886894*nf1.z + -0.112823404*ng1.z + -0.23096414*nh1.z + 0.05393515*ni1.z;
    x = 0.0071186554*na1.w + -0.090610534*nb1.w + 0.027379468*nc1.w + 0.095270984*nd1.w + -0.29638094*ne1.w + -0.14165857*nf1.w + 0.015547657*ng1.w + -0.04642255*nh1.w + -0.088592134*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0047451044;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!SAVE LUMAN90

#define L0_tex LUMAN80_tex
#define L1_tex LUMAN81_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.01673993*a0.x + -0.037069164*b0.x + -0.021666236*c0.x + -0.054466546*d0.x + 0.11536388*e0.x + -0.11321502*f0.x + 0.022819944*g0.x + 0.17252871*h0.x + -0.057995472*i0.x;
    float j = -0.007967937*a0.y + -0.17712031*b0.y + 0.016880952*c0.y + -0.083251245*d0.y + -0.15771297*e0.y + -0.13910829*f0.y + 0.030402234*g0.y + -0.115201585*h0.y + -0.07342557*i0.y;
    float k = 0.085715905*a0.z + 0.07485739*b0.z + 0.054513015*c0.z + -0.05891022*d0.z + 0.19971131*e0.z + -0.022042107*f0.z + -0.06854997*g0.z + -0.010311588*h0.z + 0.057499334*i0.z;
    float l = 0.020319302*a0.w + 0.120197445*b0.w + 0.03553909*c0.w + 0.017385498*d0.w + 0.29975125*e0.w + -0.049928416*f0.w + 0.033703424*g0.w + 0.03045727*h0.w + 0.10002958*i0.w;
    float m = 0.084152445*a1.x + 0.08455505*b1.x + 0.02041311*c1.x + 0.102138616*d1.x + 0.40321913*e1.x + 0.28508592*f1.x + 0.106993325*g1.x + 0.05451918*h1.x + 0.09983337*i1.x;
    float n = 0.070165634*a1.y + -0.0591608*b1.y + 0.037770163*c1.y + -0.07990405*d1.y + 0.3184371*e1.y + -0.05943587*f1.y + -0.07691292*g1.y + 0.04498132*h1.y + 0.06921544*i1.y;
    float o = -0.1045011*a1.z + 0.07288938*b1.z + 0.055906463*c1.z + 0.021307817*d1.z + 0.44578484*e1.z + 0.2429832*f1.z + 0.06300683*g1.z + 0.29262158*h1.z + -0.09437396*i1.z;
    float p = 0.05430943*a1.w + 0.0139438715*b1.w + -0.050196573*c1.w + -0.09235537*d1.w + 0.13077335*e1.w + 0.017000332*f1.w + -0.13289788*g1.w + 0.034622394*h1.w + 0.0610517*i1.w;
    float q = 0.03385471*na0.x + 0.033639524*nb0.x + 0.05674448*nc0.x + 0.07767901*nd0.x + 0.02196186*ne0.x + 0.25706187*nf0.x + -0.0076677273*ng0.x + -0.09732604*nh0.x + 0.14318047*ni0.x;
    float r = 0.015254236*na0.y + 0.06871284*nb0.y + 0.051175963*nc0.y + 0.022096684*nd0.y + 0.15930523*ne0.y + 0.079166576*nf0.y + -0.042781763*ng0.y + 0.09532545*nh0.y + 0.13425186*ni0.y;
    float s = -0.071213774*na0.z + -0.053588025*nb0.z + -0.0053879456*nc0.z + -0.07423497*nd0.z + -0.35910574*ne0.z + -0.058686115*nf0.z + -0.0402255*ng0.z + -0.013840895*nh0.z + -0.11806706*ni0.z;
    float t = -0.015750997*na0.w + -0.00010075004*nb0.w + -0.034971394*nc0.w + 0.043374218*nd0.w + -0.34966478*ne0.w + 0.144251*nf0.w + 0.03849565*ng0.w + -0.036949884*nh0.w + -0.049831018*ni0.w;
    float u = -0.032960076*na1.x + -0.029984819*nb1.x + 0.0038729531*nc1.x + 0.04013631*nd1.x + -0.41830102*ne1.x + -0.062018484*nf1.x + -0.04079244*ng1.x + 0.011654456*nh1.x + -0.022535775*ni1.x;
    float v = -0.08759464*na1.y + -0.00021272714*nb1.y + -0.11620911*nc1.y + 0.03606701*nd1.y + -0.40236366*ne1.y + -0.045454267*nf1.y + 0.05412641*ng1.y + -0.13487701*nh1.y + -0.07317703*ni1.y;
    float w = 0.1449464*na1.z + -0.02041889*nb1.z + -0.010942047*nc1.z + -0.008885966*nd1.z + -0.34565923*ne1.z + -0.16011216*nf1.z + -0.08167504*ng1.z + -0.046127446*nh1.z + 0.039120726*ni1.z;
    float x = -0.01631185*na1.w + 0.0676745*nb1.w + -0.020729579*nc1.w + 0.10552644*nd1.w + -0.16281195*ne1.w + 0.009668374*nf1.w + 0.079011016*ng1.w + -0.00016317324*nh1.w + -0.0427317*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.027371084;
    i = 0.21151558*a0.x + -0.18965739*b0.x + 0.041234616*c0.x + -0.20431332*d0.x + -0.192977*e0.x + -0.3690884*f0.x + -0.028841114*g0.x + -0.025547253*h0.x + -0.2393515*i0.x;
    j = -0.16114618*a0.y + 0.02555935*b0.y + -0.055616144*c0.y + -0.22684114*d0.y + 0.13186994*e0.y + 0.12789656*f0.y + -0.20806582*g0.y + -0.09056336*h0.y + 0.118119605*i0.y;
    k = 0.056821354*a0.z + -0.076682806*b0.z + 0.038370475*c0.z + -0.07335088*d0.z + -0.3635085*e0.z + -0.03416517*f0.z + 0.04906234*g0.z + 0.11570622*h0.z + -0.08483406*i0.z;
    l = 0.1062231*a0.w + 0.14855738*b0.w + 0.112187356*c0.w + 0.23658897*d0.w + -0.1633562*e0.w + -0.057498056*f0.w + 0.09591738*g0.w + 0.13960145*h0.w + -0.013841925*i0.w;
    m = 0.011678073*a1.x + -0.23525913*b1.x + 0.0675899*c1.x + -0.18475027*d1.x + -0.2588696*e1.x + 0.0573932*f1.x + 0.07389367*g1.x + -0.35012266*h1.x + -0.027212784*i1.x;
    n = 0.14043884*a1.y + -0.16013291*b1.y + 0.007676279*c1.y + 0.3247241*d1.y + -0.057386484*e1.y + 0.05311225*f1.y + 0.116353445*g1.y + -0.07527317*h1.y + -0.026991287*i1.y;
    o = 0.07864914*a1.z + 0.18995948*b1.z + 0.08229445*c1.z + 0.16711219*d1.z + 0.027085537*e1.z + 0.074351706*f1.z + 0.024535442*g1.z + -0.018759357*h1.z + -0.0057313796*i1.z;
    p = -0.09812256*a1.w + -0.27372065*b1.w + -0.09263667*c1.w + 0.13855068*d1.w + -0.111439824*e1.w + -0.03597043*f1.w + -0.14000732*g1.w + -0.10901257*h1.w + -0.07922191*i1.w;
    q = 0.040044893*na0.x + 0.19487256*nb0.x + -0.13011783*nc0.x + 0.24166034*nd0.x + -0.17673162*ne0.x + -0.025188932*nf0.x + -0.0058249906*ng0.x + 0.16676581*nh0.x + 0.17515136*ni0.x;
    r = -0.20160529*na0.y + 0.14567824*nb0.y + 0.016001804*nc0.y + 0.1217445*nd0.y + -0.25463247*ne0.y + -0.100964166*nf0.y + 0.118399285*ng0.y + 0.13229755*nh0.y + -0.069706514*ni0.y;
    s = 0.09526997*na0.z + 0.14274715*nb0.z + -0.041326083*nc0.z + 0.10334673*nd0.z + 0.46550584*ne0.z + -0.012944695*nf0.z + -0.16464376*ng0.z + 0.056298282*nh0.z + 0.06888725*ni0.z;
    t = -0.107257456*na0.w + -0.11098056*nb0.w + -0.08392639*nc0.w + 0.19929354*nd0.w + 0.028095637*ne0.w + 0.00913141*nf0.w + -0.076629944*ng0.w + -0.13897711*nh0.w + 0.02622423*ni0.w;
    u = -0.0925085*na1.x + 0.06457904*nb1.x + -0.0049878457*nc1.x + 0.11465199*nd1.x + 0.22704247*ne1.x + -0.043633565*nf1.x + -0.10444418*ng1.x + 0.29974872*nh1.x + 0.06018791*ni1.x;
    v = -0.08709729*na1.y + 0.07285598*nb1.y + -0.01770537*nc1.y + -0.29214376*nd1.y + 0.22107948*ne1.y + 0.019745916*nf1.y + -0.14918393*ng1.y + -0.11788365*nh1.y + 0.12358068*ni1.y;
    w = -0.06538392*na1.z + -0.18160456*nb1.z + -0.04809002*nc1.z + -0.18138257*nd1.z + -0.027151896*ne1.z + -0.10860557*nf1.z + 0.020112576*ng1.z + -0.14805503*nh1.z + -0.10933812*ni1.z;
    x = 0.1827798*na1.w + 0.12197832*nb1.w + -0.009565886*nc1.w + -0.27849162*nd1.w + 0.22912863*ne1.w + 0.0802533*nf1.w + -0.10039779*ng1.w + 0.11130157*nh1.w + 0.09659571*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.052480474;
    i = 0.045794196*a0.x + 0.13822739*b0.x + 0.028153861*c0.x + 0.01838999*d0.x + -0.26929635*e0.x + -0.32540554*f0.x + -0.007450455*g0.x + -0.18232581*h0.x + 0.18821949*i0.x;
    j = -0.039932244*a0.y + -0.12997177*b0.y + -0.13555567*c0.y + -0.09634756*d0.y + -0.16149253*e0.y + -0.20098837*f0.y + 0.012647376*g0.y + -0.1371011*h0.y + 0.06029709*i0.y;
    k = 0.019579187*a0.z + 0.10097545*b0.z + 0.05210322*c0.z + 0.10484725*d0.z + 0.026984831*e0.z + -0.052300893*f0.z + 0.0020612779*g0.z + -0.0465344*h0.z + -0.026893035*i0.z;
    l = 0.06849055*a0.w + -0.083517805*b0.w + -0.13908811*c0.w + -0.020601919*d0.w + 0.33350495*e0.w + 0.21439402*f0.w + -0.01956267*g0.w + 0.012073342*h0.w + -0.0054884916*i0.w;
    m = 0.03604873*a1.x + 0.21375208*b1.x + 0.036831096*c1.x + 0.0046485276*d1.x + 0.20850915*e1.x + 0.11940648*f1.x + 0.06595058*g1.x + 0.12713948*h1.x + -0.05690868*i1.x;
    n = -0.026217025*a1.y + 0.08774772*b1.y + 0.07639648*c1.y + 0.06645757*d1.y + 0.1777672*e1.y + -0.010187055*f1.y + 0.016854076*g1.y + 0.06763791*h1.y + -0.0028121404*i1.y;
    o = 0.053403556*a1.z + 0.03793781*b1.z + 0.040200714*c1.z + -0.045618698*d1.z + 0.40721974*e1.z + 0.16023849*f1.z + 0.064655244*g1.z + 0.091353275*h1.z + 0.039854866*i1.z;
    p = 0.026788633*a1.w + 0.06319608*b1.w + 0.151287*c1.w + -0.007950356*d1.w + -0.20728241*e1.w + 0.0028189872*f1.w + 0.117827214*g1.w + 0.15493579*h1.w + 0.041015457*i1.w;
    q = -0.039269663*na0.x + 0.050309796*nb0.x + 0.087594524*nc0.x + -0.07746412*nd0.x + 0.19615553*ne0.x + 0.14228563*nf0.x + 0.021518724*ng0.x + 0.2964698*nh0.x + 0.0070668804*ni0.x;
    r = 0.0679682*na0.y + 0.044831708*nb0.y + 0.103279434*nc0.y + 0.21164313*nd0.y + 0.079107836*ne0.y + 0.19867145*nf0.y + 0.0008177772*ng0.y + 0.15454973*nh0.y + 0.02802561*ni0.y;
    s = 0.04692509*na0.z + -0.053589255*nb0.z + -0.0033790166*nc0.z + -0.093176946*nd0.z + -0.05238289*ne0.z + 0.10088563*nf0.z + -0.04555708*ng0.z + 0.06308933*nh0.z + 0.018524157*ni0.z;
    t = -0.057916578*na0.w + 0.061617002*nb0.w + 0.14458352*nc0.w + -0.054579273*nd0.w + -0.53670573*ne0.w + -0.228154*nf0.w + 0.02780815*ng0.w + 0.00490978*nh0.w + -0.020166898*ni0.w;
    u = -0.056519195*na1.x + -0.22715457*nb1.x + -0.02716323*nc1.x + -0.013233275*nd1.x + -0.24903058*ne1.x + -0.06436639*nf1.x + -0.0015489759*ng1.x + -0.14657818*nh1.x + -0.081550956*ni1.x;
    v = 0.033547156*na1.y + 0.038033575*nb1.y + 0.015526869*nc1.y + -0.021106038*nd1.y + -0.18488556*ne1.y + 0.12066344*nf1.y + 0.030849671*ng1.y + -0.13188018*nh1.y + -0.038346265*ni1.y;
    w = 0.008629792*na1.z + 0.04979525*nb1.z + 0.07539893*nc1.z + 0.18835813*nd1.z + -0.43886295*ne1.z + -0.11143093*nf1.z + 0.012449111*ng1.z + 0.108359024*nh1.z + -0.0559463*ni1.z;
    x = 0.009246566*na1.w + 0.11861902*nb1.w + -0.032966357*nc1.w + -0.03323096*nd1.w + 0.05179375*ne1.w + -0.022796564*nf1.w + -0.014877862*ng1.w + -0.03710343*nh1.w + -0.042962812*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.059826102;
    i = 0.031115327*a0.x + 0.188035*b0.x + -0.0015120074*c0.x + -0.131305*d0.x + -0.07819419*e0.x + 0.11171441*f0.x + -0.25416902*g0.x + -0.23302929*h0.x + 0.13815945*i0.x;
    j = 0.0237918*a0.y + -0.00224626*b0.y + -0.0049168402*c0.y + 0.0073136603*d0.y + -0.24698296*e0.y + 0.00880072*f0.y + -0.0756857*g0.y + 0.12252117*h0.y + -0.025413495*i0.y;
    k = -0.1162883*a0.z + 0.07945833*b0.z + 0.06966924*c0.z + 0.007765573*d0.z + -0.118527874*e0.z + 0.049568437*f0.z + -0.06863759*g0.z + 0.06234623*h0.z + 0.064663865*i0.z;
    l = -0.02149897*a0.w + -0.29959664*b0.w + -0.18817009*c0.w + -0.1439664*d0.w + 0.104499996*e0.w + -0.020972226*f0.w + -0.059752535*g0.w + -0.18361354*h0.w + 0.01439171*i0.w;
    m = 0.100922875*a1.x + 0.12474121*b1.x + -0.14212026*c1.x + -0.09471235*d1.x + -0.13905098*e1.x + -0.31022635*f1.x + -0.3038933*g1.x + 0.01049297*h1.x + -0.025776217*i1.x;
    n = -0.107000016*a1.y + 0.08123589*b1.y + 0.06011893*c1.y + 0.09692082*d1.y + -0.18460457*e1.y + 0.062181763*f1.y + -0.005365826*g1.y + 0.21681735*h1.y + 0.0449017*i1.y;
    o = 0.16393377*a1.z + -0.056784745*b1.z + -0.13678862*c1.z + 0.055320717*d1.z + -0.08491486*e1.z + 0.06182906*f1.z + -0.051199604*g1.z + -0.26727825*h1.z + -0.12346331*i1.z;
    p = 0.025211822*a1.w + -0.22271319*b1.w + -0.12196882*c1.w + 0.011243396*d1.w + -0.1590806*e1.w + 0.041453175*f1.w + 0.049322482*g1.w + 0.06001341*h1.w + 0.10338395*i1.w;
    q = 0.062355123*na0.x + -0.14010982*nb0.x + -0.013285964*nc0.x + 0.17744683*nd0.x + 0.33579433*ne0.x + 0.20541832*nf0.x + 0.23999332*ng0.x + 0.35488084*nh0.x + 0.054412443*ni0.x;
    r = -0.14752464*na0.y + 0.016193591*nb0.y + -0.036918044*nc0.y + -0.13732186*nd0.y + 0.026388014*ne0.y + -0.022620546*nf0.y + 0.04923403*ng0.y + -0.027308352*nh0.y + 0.03592577*ni0.y;
    s = 0.031187518*na0.z + 0.044220183*nb0.z + 0.0065388796*nc0.z + 0.09006831*nd0.z + 0.06268174*ne0.z + 0.070364945*nf0.z + 0.10115674*ng0.z + 0.12275451*nh0.z + -0.092501625*ni0.z;
    t = 0.100292124*na0.w + 0.12261562*nb0.w + 0.13493334*nc0.w + -0.031619906*nd0.w + -0.2335329*ne0.w + -0.058594678*nf0.w + 0.08104001*ng0.w + 0.1943844*nh0.w + 0.049995773*ni0.w;
    u = -0.117773786*na1.x + -0.21409196*nb1.x + 0.10084039*nc1.x + -0.056045495*nd1.x + -0.16103372*ne1.x + 0.07381369*nf1.x + 0.10142957*ng1.x + -0.1807354*nh1.x + -0.0010455581*ni1.x;
    v = 0.12607928*na1.y + 0.08553089*nb1.y + 0.031399067*nc1.y + -0.075404786*nd1.y + 0.4368805*ne1.y + 0.09070479*nf1.y + 0.113353856*ng1.y + 0.0416148*nh1.y + -0.058077883*ni1.y;
    w = -0.14058512*na1.z + 0.011479399*nb1.z + -0.0010025998*nc1.z + -0.052256066*nd1.z + 0.121283926*ne1.z + 0.086709*nf1.z + -0.15059915*ng1.z + 0.24566013*nh1.z + 0.11308803*ni1.z;
    x = 0.02165811*na1.w + 0.06249563*nb1.w + 0.10453432*nc1.w + 0.026702216*nd1.w + 0.30528623*ne1.w + -0.11512455*nf1.w + 0.005231443*ng1.w + -0.050155234*nh1.w + -0.12619454*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0350281;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!SAVE LUMAN91

#define L0_tex LUMAN80_tex
#define L1_tex LUMAN81_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.06470165*a0.x + -0.08358711*b0.x + 0.013491288*c0.x + 0.011742262*d0.x + -0.00771037*e0.x + -0.11896797*f0.x + 0.06461668*g0.x + 0.061307684*h0.x + 0.07116608*i0.x;
    float j = -0.03955721*a0.y + 0.28637338*b0.y + -0.082954586*c0.y + -0.2748898*d0.y + -0.22996616*e0.y + -0.14736032*f0.y + 0.11470954*g0.y + 0.11117193*h0.y + -0.10298252*i0.y;
    float k = -0.057315275*a0.z + 0.12893961*b0.z + 0.0063475855*c0.z + 0.08474854*d0.z + 0.09001076*e0.z + 0.08567542*f0.z + -0.056418125*g0.z + 0.05012468*h0.z + -0.045200672*i0.z;
    float l = 0.01666514*a0.w + -0.06555822*b0.w + 0.02927531*c0.w + 0.054559793*d0.w + 0.06740099*e0.w + 0.03187214*f0.w + -0.071890905*g0.w + -0.013122654*h0.w + 0.05740963*i0.w;
    float m = -0.11991389*a1.x + -0.11246538*b1.x + 0.033758763*c1.x + 0.014906028*d1.x + -0.0044450792*e1.x + 0.038439434*f1.x + -0.048276383*g1.x + 0.014512463*h1.x + -0.017534567*i1.x;
    float n = -0.033943206*a1.y + 0.045253187*b1.y + -0.009190007*c1.y + 0.025217501*d1.y + 0.13089441*e1.y + 0.058218688*f1.y + -0.029480472*g1.y + 0.016915878*h1.y + -0.0751522*i1.y;
    float o = 0.13308804*a1.z + -0.19329911*b1.z + 0.07438569*c1.z + -0.16606416*d1.z + 0.020418571*e1.z + -0.18963277*f1.z + -0.0749325*g1.z + -0.07508134*h1.z + -0.011499833*i1.z;
    float p = -0.11286829*a1.w + -0.11931518*b1.w + 0.016420303*c1.w + -0.057171043*d1.w + 0.0062648696*e1.w + 0.115521714*f1.w + -0.006577926*g1.w + -0.07811505*h1.w + -0.05461923*i1.w;
    float q = 0.10067804*na0.x + 0.07973617*nb0.x + 0.027652912*nc0.x + -0.07360306*nd0.x + -0.13135643*ne0.x + -0.0074246284*nf0.x + -0.00038905264*ng0.x + -0.17269708*nh0.x + -0.10112847*ni0.x;
    float r = -0.09158818*na0.y + -0.03690496*nb0.y + 0.045822922*nc0.y + 0.07835432*nd0.y + 0.10308012*ne0.y + 0.066562936*nf0.y + -0.12854502*ng0.y + 0.067591466*nh0.y + 0.09179545*ni0.y;
    float s = 0.101400144*na0.z + -0.083806686*nb0.z + -0.085281074*nc0.z + -0.21147355*nd0.z + 0.18145746*ne0.z + -0.13636465*nf0.z + 0.026483217*ng0.z + -0.004932833*nh0.z + 0.028615177*ni0.z;
    float t = -0.05400892*na0.w + 0.019047134*nb0.w + -0.02612906*nc0.w + -0.009508591*nd0.w + -0.07480499*ne0.w + 0.006003379*nf0.w + 0.049930554*ng0.w + -4.4581393e-05*nh0.w + -0.083937*ni0.w;
    float u = 0.14270985*na1.x + -0.03368466*nb1.x + -0.0005758635*nc1.x + 0.0043432894*nd1.x + -0.038472593*ne1.x + 0.010285344*nf1.x + -0.008681097*ng1.x + -0.067345016*nh1.x + 0.05746432*ni1.x;
    float v = -0.0005384013*na1.y + -0.13938713*nb1.y + 0.003350033*nc1.y + -0.069848955*nd1.y + -0.17162758*ne1.y + -0.15474541*nf1.y + 0.016965603*ng1.y + -0.0441896*nh1.y + 0.059310254*ni1.y;
    float w = -0.107777886*na1.z + 0.4298284*nb1.z + -0.055417135*nc1.z + 0.13713273*nd1.z + 0.2949338*ne1.z + 0.23024732*nf1.z + -0.03803199*ng1.z + 0.12479006*nh1.z + 0.111074045*ni1.z;
    float x = 0.13028695*na1.w + 0.041605808*nb1.w + -0.000780396*nc1.w + 0.06629394*nd1.w + -0.030616602*ne1.w + -0.12750441*nf1.w + -0.04776373*ng1.w + -0.11282136*nh1.w + 0.015392388*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0048413826;
    i = -0.1829601*a0.x + 0.13851579*b0.x + 0.05251664*c0.x + -0.029195292*d0.x + 0.10835054*e0.x + 0.11980737*f0.x + -0.020615224*g0.x + 0.23010024*h0.x + 0.15591237*i0.x;
    j = 0.06646273*a0.y + 0.08660124*b0.y + -0.12217587*c0.y + -0.2832269*d0.y + -0.073232226*e0.y + -0.09045713*f0.y + 0.0903346*g0.y + 0.051303506*h0.y + -0.13163151*i0.y;
    k = 0.089250736*a0.z + 0.17210086*b0.z + -0.17334868*c0.z + 0.0636137*d0.z + 0.18805827*e0.z + -0.17250285*f0.z + -0.044774864*g0.z + -0.02882258*h0.z + 0.06518661*i0.z;
    l = -0.1539726*a0.w + 0.27703896*b0.w + 0.15240592*c0.w + 0.14633532*d0.w + 0.10149569*e0.w + 0.15621641*f0.w + 0.052911468*g0.w + 0.14841467*h0.w + 0.10176992*i0.w;
    m = -0.002441106*a1.x + -0.16499574*b1.x + 0.12205949*c1.x + 0.048980992*d1.x + 0.15491192*e1.x + -0.05774106*f1.x + -0.26510295*g1.x + 0.049354106*h1.x + 0.1075961*i1.x;
    n = 0.09788552*a1.y + 0.15087374*b1.y + -0.1643212*c1.y + -0.12409809*d1.y + -0.12229354*e1.y + -0.16194592*f1.y + -0.08719358*g1.y + -0.031453002*h1.y + 0.13846967*i1.y;
    o = -0.2732155*a1.z + -0.20257822*b1.z + 0.08830974*c1.z + -0.17554928*d1.z + 0.44935164*e1.z + 0.1659096*f1.z + -0.2140584*g1.z + 0.08412646*h1.z + 0.11356992*i1.z;
    p = -0.004162997*a1.w + 0.34235054*b1.w + 0.22631416*c1.w + -0.013886235*d1.w + -0.017690673*e1.w + -0.15543605*f1.w + 0.075665236*g1.w + -0.13077445*h1.w + 0.039470974*i1.w;
    q = 0.08467723*na0.x + -0.17728072*nb0.x + 0.11084081*nc0.x + 0.002506899*nd0.x + 0.0554393*ne0.x + -0.20072418*nf0.x + -0.11415738*ng0.x + -0.31256598*nh0.x + -0.13746846*ni0.x;
    r = 0.16444927*na0.y + -0.14218701*nb0.y + 0.10822578*nc0.y + 0.24295563*nd0.y + 0.35401732*ne0.y + 0.32688105*nf0.y + 0.0372747*ng0.y + -0.14621079*nh0.y + 0.078144416*ni0.y;
    s = -0.15721494*na0.z + -0.2906935*nb0.z + 0.13447869*nc0.z + -0.052099284*nd0.z + 0.028965846*ne0.z + 0.20206948*nf0.z + -0.046471443*ng0.z + -0.13676575*nh0.z + -0.04567316*ni0.z;
    t = 0.056960203*na0.w + -0.31676304*nb0.w + -0.031032804*nc0.w + -0.31833902*nd0.w + 0.07669968*ne0.w + -0.15262993*nf0.w + 0.038909554*ng0.w + -0.11278675*nh0.w + 0.009159681*ni0.w;
    u = 0.07172047*na1.x + 0.09011544*nb1.x + -0.11960295*nc1.x + -0.12533994*nd1.x + -0.07057406*ne1.x + -0.061811112*nf1.x + 0.15623203*ng1.x + -0.06906789*nh1.x + -0.13188761*ni1.x;
    v = -0.15868309*na1.y + -0.062547915*nb1.y + 0.32852596*nc1.y + 0.15347436*nd1.y + 0.40474093*ne1.y + 0.25103953*nf1.y + 0.15425627*ng1.y + 0.13292617*nh1.y + -0.18120067*ni1.y;
    w = 0.34258303*na1.z + 0.030543402*nb1.z + -0.07673708*nc1.z + 0.37881675*nd1.z + -0.063546225*ne1.z + -0.21133995*nf1.z + 0.07185787*ng1.z + -0.24808413*nh1.z + -0.0833815*ni1.z;
    x = -0.022112627*na1.w + -0.3086634*nb1.w + -0.032956105*nc1.w + 0.03767927*nd1.w + 0.14323393*ne1.w + 0.2049924*nf1.w + -0.04453286*ng1.w + 0.13178921*nh1.w + 0.03475982*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.020809302;
    i = 0.029212562*a0.x + 0.04520052*b0.x + 0.19492471*c0.x + 0.08813598*d0.x + -0.19385792*e0.x + 0.22746195*f0.x + -0.05792946*g0.x + 0.098720476*h0.x + -0.078137845*i0.x;
    j = 0.11748217*a0.y + -0.15551092*b0.y + -0.041184764*c0.y + -0.11294156*d0.y + -0.48724166*e0.y + 0.06820542*f0.y + 0.10558965*g0.y + 0.2602658*h0.y + -0.046648268*i0.y;
    k = 0.055756707*a0.z + 0.023304457*b0.z + -0.017790463*c0.z + 0.06274627*d0.z + 0.19655561*e0.z + 0.14073813*f0.z + -0.050541375*g0.z + -0.09031988*h0.z + 0.048210446*i0.z;
    l = 0.09856984*a0.w + 0.2757346*b0.w + 0.12035966*c0.w + -0.07751128*d0.w + 0.08767396*e0.w + -0.098144054*f0.w + -0.11670308*g0.w + -0.10254689*h0.w + -0.07100567*i0.w;
    m = -0.07163324*a1.x + 0.029479492*b1.x + -0.107981086*c1.x + 0.0785065*d1.x + 0.47879705*e1.x + -0.5006183*f1.x + -0.113591515*g1.x + -0.28396955*h1.x + -0.09156115*i1.x;
    n = 0.010061719*a1.y + -0.06959705*b1.y + -0.023433782*c1.y + -0.061150227*d1.y + -0.20881256*e1.y + 0.06986817*f1.y + -0.024993578*g1.y + -0.23687747*h1.y + 0.048823558*i1.y;
    o = -0.12649736*a1.z + 0.16880566*b1.z + 0.056255385*c1.z + -0.13327794*d1.z + 0.5323194*e1.z + 0.13708395*f1.z + -0.17057353*g1.z + -0.5180934*h1.z + 0.2036042*i1.z;
    p = 0.025205363*a1.w + 0.0148605555*b1.w + -0.07160804*c1.w + -0.11104438*d1.w + -0.28952584*e1.w + -0.20536195*f1.w + -0.055619787*g1.w + -0.20000336*h1.w + -0.13830769*i1.w;
    q = -0.10966534*na0.x + -0.16984549*nb0.x + -0.12228675*nc0.x + -0.17389281*nd0.x + -0.03828372*ne0.x + -0.37848768*nf0.x + 0.14367533*ng0.x + 0.078726806*nh0.x + -0.05469816*ni0.x;
    r = 0.005045079*na0.y + 0.060812112*nb0.y + 0.12286593*nc0.y + 0.025669502*nd0.y + 0.41187903*ne0.y + 0.15332839*nf0.y + -0.12220754*ng0.y + -0.34907588*nh0.y + -0.15346427*ni0.y;
    s = -0.10867897*na0.z + -0.06867772*nb0.z + 0.04260707*nc0.z + 0.012931835*nd0.z + -0.2426067*ne0.z + 0.06771253*nf0.z + 0.08149514*ng0.z + -0.09523016*nh0.z + 0.089101076*ni0.z;
    t = -0.08355936*na0.w + -0.2323209*nb0.w + -0.10957743*nc0.w + -0.098291025*nd0.w + 0.00647761*ne0.w + 0.05178958*nf0.w + 0.049700283*ng0.w + 0.17216198*nh0.w + 0.15758623*ni0.w;
    u = -0.062969774*na1.x + -0.23237999*nb1.x + 0.025046721*nc1.x + -0.21818307*nd1.x + -0.44225112*ne1.x + 0.15906236*nf1.x + 0.060607016*ng1.x + 0.03830812*nh1.x + -0.01450312*ni1.x;
    v = -0.042574733*na1.y + 0.1477671*nb1.y + 0.1738519*nc1.y + 0.10186733*nd1.y + 0.4633304*ne1.y + 0.04933609*nf1.y + 0.0599997*ng1.y + 0.32341382*nh1.y + -0.02965749*ni1.y;
    w = 0.05251006*na1.z + -0.24486646*nb1.z + -0.19625907*nc1.z + 0.11287113*nd1.z + -0.2547342*ne1.z + -0.091655985*nf1.z + -0.08782904*ng1.z + -0.24473846*nh1.z + -0.17752169*ni1.z;
    x = -0.025825348*na1.w + 0.030143617*nb1.w + 0.03985646*nc1.w + 0.058778826*nd1.w + 0.6242806*ne1.w + 0.08659011*nf1.w + 0.011712522*ng1.w + 0.030967578*nh1.w + 0.19279975*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.031122295;
    i = -0.056274638*a0.x + 0.0994429*b0.x + 0.100331664*c0.x + 0.13507071*d0.x + -0.44366753*e0.x + 0.35566956*f0.x + -0.0155030945*g0.x + -0.111121856*h0.x + -0.08261402*i0.x;
    j = 0.1621978*a0.y + -0.13188677*b0.y + 0.09493277*c0.y + -0.22416183*d0.y + -0.19327287*e0.y + -0.017433945*f0.y + 0.055452533*g0.y + 0.019975124*h0.y + -0.022349617*i0.y;
    k = -0.04813199*a0.z + -0.044552036*b0.z + 0.009757977*c0.z + 0.15600084*d0.z + 0.06667113*e0.z + 0.07466154*f0.z + 0.02013024*g0.z + -0.05830345*h0.z + 0.0066436944*i0.z;
    l = 0.022262586*a0.w + 0.2051477*b0.w + 0.02359226*c0.w + -0.016940195*d0.w + -0.103408664*e0.w + -0.0143246995*f0.w + -0.04390832*g0.w + -0.19666824*h0.w + -0.037004247*i0.w;
    m = -0.12699056*a1.x + 0.007297183*b1.x + -0.116264924*c1.x + -0.07206143*d1.x + -0.177836*e1.x + -0.22506171*f1.x + -0.08196095*g1.x + -0.32255578*h1.x + -0.059720334*i1.x;
    n = -0.024888419*a1.y + -0.074888624*b1.y + 0.0148301255*c1.y + 0.080827035*d1.y + -0.12504773*e1.y + -0.006246837*f1.y + 0.0814444*g1.y + -0.1826526*h1.y + 0.038656585*i1.y;
    o = -0.078399174*a1.z + 0.11893796*b1.z + -0.05013238*c1.z + -0.27203092*d1.z + 0.039230514*e1.z + 0.20820205*f1.z + -0.1379687*g1.z + 0.07932462*h1.z + 0.0252875*i1.z;
    p = 0.087690495*a1.w + -0.06339423*b1.w + -0.1162743*c1.w + -0.050107308*d1.w + -0.46825767*e1.w + -0.16134012*f1.w + 0.16483293*g1.w + -0.027519228*h1.w + -0.021023685*i1.w;
    q = -0.038559947*na0.x + -0.15457825*nb0.x + -0.058549345*nc0.x + -0.18923534*nd0.x + -0.041225646*ne0.x + -0.4356616*nf0.x + -0.024729528*ng0.x + 0.36071044*nh0.x + 0.21629138*ni0.x;
    r = -0.06251338*na0.y + -0.16642195*nb0.y + 0.06348546*nc0.y + 0.08825678*nd0.y + 0.22040902*ne0.y + 0.045454938*nf0.y + -0.13521202*ng0.y + 0.061059624*nh0.y + 0.04230984*ni0.y;
    s = 0.12856871*na0.z + 0.033738554*nb0.z + 0.081973396*nc0.z + -0.11980315*nd0.z + -0.17240024*ne0.z + 0.035350345*nf0.z + -0.03828312*ng0.z + 0.08390367*nh0.z + -0.0007110002*ni0.z;
    t = -0.04138246*na0.w + -0.14146684*nb0.w + -0.07614185*nc0.w + -0.32412106*nd0.w + 0.14123203*ne0.w + 0.093974575*nf0.w + 0.039202336*ng0.w + 0.21533422*nh0.w + 0.10451938*ni0.w;
    u = 0.11685781*na1.x + -0.111199625*nb1.x + 0.031322613*nc1.x + -0.10094856*nd1.x + 0.061218377*ne1.x + 0.21430455*nf1.x + 0.04603686*ng1.x + 0.13180679*nh1.x + -0.006573115*ni1.x;
    v = -0.042008765*na1.y + 0.05046256*nb1.y + 0.054701287*nc1.y + -0.024479102*nd1.y + 0.23996788*ne1.y + 0.026132362*nf1.y + 0.044675305*ng1.y + 0.24155937*nh1.y + 0.007674547*ni1.y;
    w = 0.06194381*na1.z + -0.12647893*nb1.z + -0.06262424*nc1.z + 0.2765175*nd1.z + -0.13114145*ne1.z + -0.18654919*nf1.z + 0.13385575*ng1.z + -0.070887975*nh1.z + 0.03256101*ni1.z;
    x = -0.11918977*na1.w + 0.108421154*nb1.w + -0.04607389*nc1.w + 0.048322722*nd1.w + 0.56062996*ne1.w + 0.14422773*nf1.w + -0.06938887*ng1.w + -0.004306145*nh1.w + 0.0469783*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.021502014;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN90
//!BIND LUMAN91
//!SAVE LUMAN100

#define L0_tex LUMAN90_tex
#define L1_tex LUMAN91_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.07265925*a0.x + 0.023700966*b0.x + -0.15656962*c0.x + 0.07880878*d0.x + 0.19290538*e0.x + -0.05890005*f0.x + -0.07099894*g0.x + -0.22249503*h0.x + -0.064054154*i0.x;
    float j = -0.015663067*a0.y + -0.103533*b0.y + -0.08357721*c0.y + -0.09838063*d0.y + -0.009890742*e0.y + -0.20688708*f0.y + -0.012291536*g0.y + 0.103740424*h0.y + -0.18892547*i0.y;
    float k = -0.039948575*a0.z + -0.08890566*b0.z + 0.08356973*c0.z + -0.07202497*d0.z + 0.3098249*e0.z + 0.03797432*f0.z + 0.061603986*g0.z + -0.028556094*h0.z + -0.03887841*i0.z;
    float l = 0.061304227*a0.w + 0.0834474*b0.w + 0.0052142297*c0.w + 0.076062456*d0.w + -0.2550855*e0.w + -0.22246034*f0.w + -0.1461618*g0.w + -0.031381596*h0.w + -0.023259843*i0.w;
    float m = 0.10203523*a1.x + -0.10106587*b1.x + -0.09936241*c1.x + 0.0121586565*d1.x + -0.21350412*e1.x + 0.03773418*f1.x + -0.08036912*g1.x + 0.00054510345*h1.x + 0.082109995*i1.x;
    float n = -0.030281091*a1.y + -0.019464297*b1.y + -0.03343086*c1.y + -0.041807972*d1.y + -0.29519844*e1.y + 0.0011670708*f1.y + -0.005358335*g1.y + 0.13223964*h1.y + -0.026167693*i1.y;
    float o = 0.06085577*a1.z + -0.092274785*b1.z + 0.032507356*c1.z + 0.053823147*d1.z + 0.42793903*e1.z + 0.114983246*f1.z + -0.04069393*g1.z + -0.0006949501*h1.z + 0.02710441*i1.z;
    float p = 0.07505709*a1.w + 0.075499974*b1.w + -0.03323268*c1.w + 0.02439534*d1.w + 0.1352862*e1.w + -0.057262182*f1.w + 0.03444901*g1.w + -0.10126648*h1.w + 0.07005253*i1.w;
    float q = -0.056289457*na0.x + -0.088067494*nb0.x + 0.009072137*nc0.x + -0.16945772*nd0.x + 0.65056986*ne0.x + -0.09137104*nf0.x + -0.0958041*ng0.x + -0.0035324264*nh0.x + 0.22158822*ni0.x;
    float r = -0.023618907*na0.y + 0.040410213*nb0.y + 0.04133351*nc0.y + 0.0027878582*nd0.y + 0.13161965*ne0.y + 0.04786032*nf0.y + -0.032071363*ng0.y + 0.013592457*nh0.y + 0.04103818*ni0.y;
    float s = -0.083262034*na0.z + 0.038279414*nb0.z + -0.10495058*nc0.z + -0.0018889415*nd0.z + 0.4518251*ne0.z + -0.16235441*nf0.z + 0.025422582*ng0.z + -0.10999959*nh0.z + -0.0810986*ni0.z;
    float t = -0.017079756*na0.w + -0.07210158*nb0.w + 0.11943926*nc0.w + -0.04239276*nd0.w + 0.2123338*ne0.w + 0.19151181*nf0.w + 0.03208812*ng0.w + 0.08681117*nh0.w + -0.041525204*ni0.w;
    float u = -0.11309481*na1.x + 0.012464375*nb1.x + 0.090306304*nc1.x + 0.047231033*nd1.x + 0.38329974*ne1.x + -0.19688864*nf1.x + 0.121593945*ng1.x + -0.19659187*nh1.x + -0.17173418*ni1.x;
    float v = -0.054151945*na1.y + 0.14287822*nb1.y + -0.026752962*nc1.y + 0.08045844*nd1.y + -0.44710386*ne1.y + 0.10896626*nf1.y + -0.12193901*ng1.y + -0.009104244*nh1.y + -0.08056834*ni1.y;
    float w = -0.04259294*na1.z + 0.013424774*nb1.z + -0.02073511*nc1.z + -0.0671494*nd1.z + -0.742374*ne1.z + -0.013341901*nf1.z + 0.02841971*ng1.z + 0.028205762*nh1.z + -0.015515695*ni1.z;
    float x = -0.1253503*na1.w + -0.037713774*nb1.w + -0.047447044*nc1.w + 0.056887742*nd1.w + -0.25439355*ne1.w + 0.017710002*nf1.w + -0.060918324*ng1.w + 0.06975122*nh1.w + 0.018493392*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.060576435;
    i = -0.10078301*a0.x + -0.22060892*b0.x + -0.1408605*c0.x + 0.054186974*d0.x + 0.48175207*e0.x + 0.15784572*f0.x + -0.11044774*g0.x + 0.015674137*h0.x + -0.10430155*i0.x;
    j = -0.00055243395*a0.y + 0.07688996*b0.y + -0.02225426*c0.y + 0.02965376*d0.y + 0.1604641*e0.y + 0.036843646*f0.y + -0.03089809*g0.y + -0.028821243*h0.y + 0.07116369*i0.y;
    k = 0.04849076*a0.z + -0.051908575*b0.z + 0.11398473*c0.z + -0.11207367*d0.z + 0.17258276*e0.z + 0.072021425*f0.z + 0.08204*g0.z + 0.05697239*h0.z + 0.05384689*i0.z;
    l = 0.06526782*a0.w + -0.16998854*b0.w + -0.20337874*c0.w + -0.06894729*d0.w + -0.060269777*e0.w + 0.059943512*f0.w + -0.06256188*g0.w + -0.19321574*h0.w + 0.12563857*i0.w;
    m = 0.09504388*a1.x + 0.23444028*b1.x + 0.054108813*c1.x + -0.1511119*d1.x + -0.33046558*e1.x + -0.11355755*f1.x + 0.06791499*g1.x + -0.09154602*h1.x + 0.08613581*i1.x;
    n = -0.005308559*a1.y + -0.06617806*b1.y + -0.08029687*c1.y + -0.18528762*d1.y + 0.29541174*e1.y + -0.050635237*f1.y + -0.13667068*g1.y + 0.058555737*h1.y + 0.049990308*i1.y;
    o = 0.057100374*a1.z + -0.0053014755*b1.z + -0.036915854*c1.z + 0.048231576*d1.z + -0.08578811*e1.z + 0.0061042877*f1.z + 0.12712461*g1.z + -0.049631786*h1.z + -0.03644509*i1.z;
    p = -0.07754365*a1.w + 0.08114286*b1.w + 0.13754186*c1.w + 0.046926335*d1.w + -0.00015599096*e1.w + -0.06885081*f1.w + 0.002506939*g1.w + -0.0041841757*h1.w + -0.03963556*i1.w;
    q = 0.06525129*na0.x + 0.29605383*nb0.x + 0.17160998*nc0.x + -0.10999347*nd0.x + -0.4261982*ne0.x + 0.008851736*nf0.x + 0.17348845*ng0.x + -0.11618347*nh0.x + -0.0013678032*ni0.x;
    r = 0.004887045*na0.y + 0.09394849*nb0.y + -0.022832435*nc0.y + 0.0618829*nd0.y + -0.1206567*ne0.y + -0.047747064*nf0.y + -0.018334484*ng0.y + -0.15676217*nh0.y + -0.037948433*ni0.y;
    s = -0.05387299*na0.z + -0.07547661*nb0.z + -0.02826463*nc0.z + 0.19316924*nd0.z + -0.21108967*ne0.z + -0.07424726*nf0.z + -0.048655987*ng0.z + 0.011288455*nh0.z + 0.07454638*ni0.z;
    t = -0.02382715*na0.w + 0.04737313*nb0.w + 0.16604757*nc0.w + -0.1252276*nd0.w + -0.11555547*ne0.w + -0.117093794*nf0.w + 0.22003125*ng0.w + 0.050628174*nh0.w + -0.16738409*ni0.w;
    u = 0.14754699*na1.x + 0.17303196*nb1.x + 0.04876307*nc1.x + 0.17099535*nd1.x + 0.28009477*ne1.x + 0.09900106*nf1.x + -0.1232106*ng1.x + 0.120199144*nh1.x + -0.018348478*ni1.x;
    v = 0.06373986*na1.y + -0.16076994*nb1.y + 0.04006142*nc1.y + 0.039994188*nd1.y + 0.21252097*ne1.y + 0.009857251*nf1.y + 0.16954108*ng1.y + -0.18738723*nh1.y + -0.06068558*ni1.y;
    w = -0.023124985*na1.z + -0.13765894*nb1.z + 0.00794977*nc1.z + -0.043664034*nd1.z + 0.30050248*ne1.z + -0.0797709*nf1.z + -0.09831398*ng1.z + 0.0090835*nh1.z + 0.050792087*ni1.z;
    x = 0.16089995*na1.w + 0.18940108*nb1.w + -0.062164474*nc1.w + -0.009729548*nd1.w + 0.3687626*ne1.w + 0.11795869*nf1.w + 0.111944266*ng1.w + 0.030715724*nh1.w + -0.06897518*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0110156555;
    i = -0.09201335*a0.x + 0.35571313*b0.x + 0.03867107*c0.x + -0.52388316*d0.x + 0.26164815*e0.x + -0.003940324*f0.x + -0.034470525*g0.x + -0.38801426*h0.x + 0.007453677*i0.x;
    j = -0.025017906*a0.y + 0.11159069*b0.y + -0.083097436*c0.y + -0.087925516*d0.y + 0.41674057*e0.y + -0.09842924*f0.y + 0.016759802*g0.y + -0.043557372*h0.y + -0.09356397*i0.y;
    k = -0.07435264*a0.z + -0.027982665*b0.z + -0.2546462*c0.z + -0.15379149*d0.z + 0.0483275*e0.z + 0.33086976*f0.z + 0.17203465*g0.z + -0.011223424*h0.z + 0.059527423*i0.z;
    l = -0.084952295*a0.w + 0.13025886*b0.w + -0.04452213*c0.w + -0.03323946*d0.w + -0.44131833*e0.w + -0.098421805*f0.w + -0.14595895*g0.w + 0.0012506093*h0.w + 0.01602149*i0.w;
    m = -0.0002257706*a1.x + 0.049014594*b1.x + -0.06539944*c1.x + -0.06921464*d1.x + -0.08951907*e1.x + 0.00308963*f1.x + 0.24626851*g1.x + 0.024575666*h1.x + -0.17135943*i1.x;
    n = 0.04957859*a1.y + -0.005085414*b1.y + 0.17520362*c1.y + -0.25757977*d1.y + 0.29797918*e1.y + -0.36955053*f1.y + -0.05837521*g1.y + -0.009809658*h1.y + 0.08120866*i1.y;
    o = 0.038373098*a1.z + 0.43602607*b1.z + -0.33427376*c1.z + 0.11876386*d1.z + -0.015821876*e1.z + 0.23957412*f1.z + 0.21176071*g1.z + -0.04274422*h1.z + -0.0017289559*i1.z;
    p = -0.06806067*a1.w + -0.2152604*b1.w + 0.2839844*c1.w + -0.15799695*d1.w + 0.08067578*e1.w + -0.18562378*f1.w + -0.15009342*g1.w + 0.037688468*h1.w + -0.013841675*i1.w;
    q = 0.05784655*na0.x + -0.50880325*nb0.x + 0.00044681615*nc0.x + 0.23096287*nd0.x + 0.18685505*ne0.x + 0.033283934*nf0.x + 0.082515314*ng0.x + 0.34203875*nh0.x + 0.03886475*ni0.x;
    r = 0.065260865*na0.y + -0.01993688*nb0.y + -0.05383619*nc0.y + 0.008454464*nd0.y + -0.28584716*ne0.y + 0.279069*nf0.y + 0.011580153*ng0.y + 0.005640261*nh0.y + 0.016977433*ni0.y;
    s = 0.09752995*na0.z + -0.08544229*nb0.z + 0.20613973*nc0.z + 0.119378366*nd0.z + 0.2668687*ne0.z + -0.3592499*nf0.z + -0.13275231*ng0.z + -0.09630954*nh0.z + -0.07383545*ni0.z;
    t = -0.16881555*na0.w + -0.2374875*nb0.w + -0.15595317*nc0.w + 0.04898601*nd0.w + 0.6815287*ne0.w + -0.031822093*nf0.w + 0.07903932*ng0.w + -0.20907608*nh0.w + 0.16599762*ni0.w;
    u = 0.005852266*na1.x + -0.2368208*nb1.x + -0.23890223*nc1.x + 0.13112201*nd1.x + 0.26844802*ne1.x + 0.29751682*nf1.x + -0.08209781*ng1.x + 0.42122295*nh1.x + 0.20626803*ni1.x;
    v = -0.04461377*na1.y + 0.123583965*nb1.y + 0.25949335*nc1.y + 0.3643682*nd1.y + -0.31355467*ne1.y + 0.1577375*nf1.y + 0.17515017*ng1.y + 0.1719694*nh1.y + 0.050687797*ni1.y;
    w = 0.033197664*na1.z + -0.110326655*nb1.z + 0.16151339*nc1.z + -0.29232344*nd1.z + -0.043201648*ne1.z + -0.25910446*nf1.z + -0.17897853*ng1.z + 0.04508204*nh1.z + 0.024959387*ni1.z;
    x = -0.004740871*na1.w + 0.58068645*nb1.w + -0.13135849*nc1.w + 0.08470749*nd1.w + 0.5434785*ne1.w + -0.09824885*nf1.w + 0.175141*ng1.w + -0.031553842*nh1.w + 0.12030425*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.023395553;
    i = 0.2182098*a0.x + -0.17617948*b0.x + -0.016086245*c0.x + 0.01979135*d0.x + -0.038408197*e0.x + -0.052498348*f0.x + 0.06095527*g0.x + 0.13581404*h0.x + -0.073346384*i0.x;
    j = 0.049381066*a0.y + 0.027663233*b0.y + -0.08703131*c0.y + 0.079707064*d0.y + 0.019048419*e0.y + -0.11821768*f0.y + -0.03539825*g0.y + -0.00968409*h0.y + 0.14233379*i0.y;
    k = 0.042935178*a0.z + 0.32729605*b0.z + 0.014347606*c0.z + 0.118802175*d0.z + 0.038908485*e0.z + 0.047662012*f0.z + -0.23271957*g0.z + 0.1071721*h0.z + -5.6695158e-06*i0.z;
    l = 0.044800732*a0.w + 0.07532898*b0.w + 0.10070666*c0.w + -0.067275*d0.w + 0.34835663*e0.w + -0.00016411445*f0.w + 0.22446546*g0.w + -0.040508043*h0.w + 0.074288964*i0.w;
    m = -0.14405896*a1.x + -0.07136379*b1.x + -0.08497759*c1.x + -0.099492*d1.x + -0.44610918*e1.x + 0.016733484*f1.x + -0.019361196*g1.x + -0.122206904*h1.x + -0.033448443*i1.x;
    n = -0.037161253*a1.y + -0.104310274*b1.y + -0.101612695*c1.y + -0.08269007*d1.y + -0.196907*e1.y + 0.04373784*f1.y + -0.076424465*g1.y + -0.23708011*h1.y + -0.015432182*i1.y;
    o = -0.07932446*a1.z + -0.25158814*b1.z + 0.1456538*c1.z + -0.056997314*d1.z + -0.16408537*e1.z + -0.092957675*f1.z + -0.05784946*g1.z + 0.17916061*h1.z + -0.03714659*i1.z;
    p = 0.056439318*a1.w + 0.30886337*b1.w + -0.10099246*c1.w + 0.00921742*d1.w + 0.0060571055*e1.w + -0.0045387703*f1.w + 0.056307647*g1.w + -0.10007432*h1.w + 0.10579334*i1.w;
    q = -0.12815917*na0.x + 0.25816068*nb0.x + 0.005832022*nc0.x + 0.021733731*nd0.x + -0.002896373*ne0.x + -0.021967378*nf0.x + -0.08993149*ng0.x + 0.01349081*nh0.x + 0.14037557*ni0.x;
    r = -0.10641641*na0.y + -0.14336166*nb0.y + 0.13905756*nc0.y + -0.006768771*nd0.y + -0.20818397*ne0.y + -0.072607264*nf0.y + 0.0653376*ng0.y + -0.0009878871*nh0.y + -0.23695026*ni0.y;
    s = -0.011296526*na0.z + -0.1702861*nb0.z + -0.13592866*nc0.z + 0.08330013*nd0.z + -0.14053744*ne0.z + 0.04229139*nf0.z + 0.18999486*ng0.z + -0.06729747*nh0.z + -0.012406001*ni0.z;
    t = -0.053658824*na0.w + -0.011490368*nb0.w + -0.02576516*nc0.w + 0.025684359*nd0.w + -0.27654237*ne0.w + 0.2556309*nf0.w + -0.11121926*ng0.w + 0.021481138*nh0.w + 0.020300712*ni0.w;
    u = 0.056904268*na1.x + 0.1031669*nb1.x + 0.092109516*nc1.x + 0.1674974*nd1.x + 0.1272128*ne1.x + 0.051365383*nf1.x + 0.09436225*ng1.x + -0.1498395*nh1.x + 0.027604343*ni1.x;
    v = 0.14711578*na1.y + -0.04096398*nb1.y + 0.06807073*nc1.y + 0.07105637*nd1.y + 0.14142494*ne1.y + -0.039062362*nf1.y + 0.04731659*ng1.y + 0.16940498*nh1.y + 0.10303104*ni1.y;
    w = -0.0059321444*na1.z + 0.18455246*nb1.z + -0.10695806*nc1.z + 0.23861645*nd1.z + 0.04773088*ne1.z + 0.14045008*nf1.z + 4.7836074e-05*ng1.z + -0.16641098*nh1.z + 0.04553746*ni1.z;
    x = -0.11129073*na1.w + -0.43785414*nb1.w + 0.14205389*nc1.w + -0.07631603*nd1.w + -0.28033093*ne1.w + -0.061731882*nf1.w + -0.17013927*ng1.w + -0.018501334*nh1.w + -0.08734041*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0043154894;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN90
//!BIND LUMAN91
//!SAVE LUMAN101

#define L0_tex LUMAN90_tex
#define L1_tex LUMAN91_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.04086044*a0.x + 0.30147836*b0.x + -0.17311159*c0.x + 0.18290026*d0.x + 0.29126215*e0.x + 0.083450966*f0.x + 0.03202223*g0.x + -0.17335223*h0.x + 0.0129949255*i0.x;
    float j = -0.07097973*a0.y + 0.18275109*b0.y + -0.04680662*c0.y + 0.059881072*d0.y + -0.15083359*e0.y + 0.0364367*f0.y + 0.08146268*g0.y + 0.009621425*h0.y + 0.07292491*i0.y;
    float k = -0.1243348*a0.z + -0.08893849*b0.z + -0.04332789*c0.z + -0.31888697*d0.z + 0.103336014*e0.z + 0.26384127*f0.z + 0.023423515*g0.z + 0.016750999*h0.z + 0.10389888*i0.z;
    float l = -0.09181854*a0.w + 0.27054423*b0.w + -0.03821117*c0.w + 0.05981993*d0.w + -0.3537547*e0.w + 0.089075744*f0.w + 0.16270332*g0.w + 0.025306432*h0.w + 0.064135864*i0.w;
    float m = -0.003473569*a1.x + 0.22022933*b1.x + -0.10967152*c1.x + 0.09498084*d1.x + -0.108349755*e1.x + -0.32422996*f1.x + 0.17902786*g1.x + 0.39498124*h1.x + -0.4621785*i1.x;
    float n = 0.050144423*a1.y + 0.022015644*b1.y + -0.103678636*c1.y + -0.21861544*d1.y + -0.4575561*e1.y + -0.11950478*f1.y + -0.16512674*g1.y + -0.25170276*h1.y + -0.092178196*i1.y;
    float o = 0.07426705*a1.z + 0.20278463*b1.z + -0.12125511*c1.z + 0.13472858*d1.z + 0.2342844*e1.z + -0.00045797927*f1.z + 0.16019689*g1.z + 0.13096984*h1.z + 0.14349672*i1.z;
    float p = -0.1870569*a1.w + 0.17617738*b1.w + 0.12292782*c1.w + -0.037125535*d1.w + -0.07933675*e1.w + -0.25381994*f1.w + 0.0037806593*g1.w + 0.11210973*h1.w + -0.1399592*i1.w;
    float q = -0.08505993*na0.x + -0.1399554*nb0.x + 0.15090756*nc0.x + -0.2961579*nd0.x + 0.116405025*ne0.x + -0.22164461*nf0.x + 0.055569395*ng0.x + 0.28131577*nh0.x + 0.06910265*ni0.x;
    float r = 0.03829472*na0.y + -0.16269873*nb0.y + 0.11553206*nc0.y + 0.0879146*nd0.y + 0.09228102*ne0.y + -0.021050004*nf0.y + 0.029262071*ng0.y + -0.040860407*nh0.y + -0.19934064*ni0.y;
    float s = 0.1826632*na0.z + -0.019763405*nb0.z + 0.057691265*nc0.z + 0.23001699*nd0.z + 0.3764493*ne0.z + -0.18463586*nf0.z + -0.1123537*ng0.z + -0.22568218*nh0.z + -0.07268684*ni0.z;
    float t = -0.056782905*na0.w + -0.34061006*nb0.w + -0.13305256*nc0.w + 0.12895769*nd0.w + 0.105644956*ne0.w + 0.106645614*nf0.w + -0.04421649*ng0.w + 0.08628332*nh0.w + 0.09497531*ni0.w;
    float u = 0.25516704*na1.x + -0.09295428*nb1.x + 0.10734516*nc1.x + 0.22108944*nd1.x + 0.4646307*ne1.x + 0.3175236*nf1.x + 0.1708444*ng1.x + 0.3606606*nh1.x + 0.5949483*ni1.x;
    float v = 0.19442004*na1.y + 0.070592254*nb1.y + 0.112586305*nc1.y + 0.3487895*nd1.y + 0.013322714*ne1.y + 0.29852825*nf1.y + 0.52252096*ng1.y + 0.4961997*nh1.y + 0.24512465*ni1.y;
    float w = -0.050976038*na1.z + -0.21076718*nb1.z + 0.032281205*nc1.z + -0.11800584*nd1.z + -0.6611534*ne1.z + -0.1621408*nf1.z + -0.2365334*ng1.z + -0.19470689*nh1.z + -0.12453201*ni1.z;
    float x = 0.24511613*na1.w + 0.22603223*nb1.w + 0.0017550752*nc1.w + 0.047750197*nd1.w + 0.15508509*ne1.w + 0.28011647*nf1.w + 0.015352654*ng1.w + -0.16725023*nh1.w + 0.18291974*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.05279069;
    i = 0.008404003*a0.x + -0.10627176*b0.x + 0.09229888*c0.x + 0.13318692*d0.x + -0.24829465*e0.x + 0.025945714*f0.x + -0.03172702*g0.x + -0.2484376*h0.x + -0.12043164*i0.x;
    j = -0.06373101*a0.y + -0.13484426*b0.y + 0.05406028*c0.y + -0.06776945*d0.y + -0.37291196*e0.y + 0.0011398172*f0.y + -0.0439159*g0.y + -0.18156001*h0.y + 0.11207086*i0.y;
    k = 0.08483646*a0.z + -0.058685873*b0.z + 0.062697396*c0.z + 0.16926341*d0.z + -0.17863348*e0.z + 0.011582497*f0.z + 0.16292098*g0.z + -0.10258071*h0.z + 0.098842606*i0.z;
    l = 0.0444924*a0.w + -0.17097838*b0.w + -0.10876493*c0.w + 0.032117974*d0.w + 0.06896584*e0.w + -0.016933667*f0.w + 0.054590322*g0.w + -0.02500689*h0.w + -0.12707044*i0.w;
    m = 0.07611656*a1.x + -0.018643428*b1.x + -0.15429781*c1.x + 0.11813699*d1.x + -0.14487611*e1.x + -0.016811037*f1.x + 0.06799785*g1.x + 0.08665557*h1.x + -0.06913339*i1.x;
    n = 0.034149908*a1.y + -0.09554191*b1.y + 0.014189771*c1.y + -0.05355791*d1.y + 0.32009345*e1.y + -0.105629094*f1.y + -0.0029237983*g1.y + -0.08419368*h1.y + -0.047896426*i1.y;
    o = 0.14945614*a1.z + -0.028181762*b1.z + -0.07658237*c1.z + 0.20731671*d1.z + -0.30175722*e1.z + 0.047350425*f1.z + 0.16912727*g1.z + -0.04453804*h1.z + 0.04918582*i1.z;
    p = -0.11123826*a1.w + 0.17230445*b1.w + 0.08132904*c1.w + -0.0010809727*d1.w + 0.0515975*e1.w + 0.10869532*f1.w + -0.05706394*g1.w + 0.029299952*h1.w + -0.031174589*i1.w;
    q = 0.0028094754*na0.x + -0.008476241*nb0.x + -0.05977881*nc0.x + -0.24555667*nd0.x + 0.41245478*ne0.x + 0.011358212*nf0.x + -0.07180912*ng0.x + 0.055240646*nh0.x + 0.05751845*ni0.x;
    r = 0.15239914*na0.y + 0.053603504*nb0.y + 0.029692866*nc0.y + 0.05225717*nd0.y + 0.14193916*ne0.y + 0.3205421*nf0.y + 0.012476601*ng0.y + 0.127102*nh0.y + 0.049093354*ni0.y;
    s = -0.07585988*na0.z + 0.1699522*nb0.z + -0.08202527*nc0.z + -0.07837919*nd0.z + 0.31239763*ne0.z + -0.15695018*nf0.z + -0.19814327*ng0.z + 0.026116237*nh0.z + -0.08477578*ni0.z;
    t = -0.028754836*na0.w + 0.11850428*nb0.w + 0.04073512*nc0.w + 0.05534531*nd0.w + 0.07258342*ne0.w + 0.073158294*nf0.w + -0.032114208*ng0.w + 0.037527297*nh0.w + 0.14149861*ni0.w;
    u = -0.08361215*na1.x + -0.08683338*nb1.x + 0.07566075*nc1.x + -0.23667093*nd1.x + 0.11633339*ne1.x + 0.13111743*nf1.x + -0.05344559*ng1.x + -0.04330547*nh1.x + 0.059771866*ni1.x;
    v = -0.0070694364*na1.y + 0.048788145*nb1.y + 0.0056230226*nc1.y + 0.1291915*nd1.y + 0.041900184*ne1.y + 0.118090354*nf1.y + 0.0027303898*ng1.y + -0.11506767*nh1.y + 0.02518101*ni1.y;
    w = -0.066354156*na1.z + 0.11174939*nb1.z + 0.07267902*nc1.z + -0.20309606*nd1.z + 0.3313923*ne1.z + -0.044157956*nf1.z + -0.04583175*ng1.z + 0.051006425*nh1.z + -0.040038593*ni1.z;
    x = 0.10450858*na1.w + -0.31238818*nb1.w + -0.09804203*nc1.w + 0.20055936*nd1.w + -0.04483531*ne1.w + -0.15076743*nf1.w + 0.1274108*ng1.w + -0.04509676*nh1.w + 0.014934564*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.014012165;
    i = 0.116196275*a0.x + -0.12301849*b0.x + 0.037762836*c0.x + 0.07923946*d0.x + 0.52848935*e0.x + -0.22463503*f0.x + 0.12021454*g0.x + 0.08782382*h0.x + -0.1143211*i0.x;
    j = 0.0014436735*a0.y + 0.03878902*b0.y + 0.020114185*c0.y + 0.022503676*d0.y + 0.057359222*e0.y + -0.15808989*f0.y + 0.04650529*g0.y + 0.0057854573*h0.y + -0.12186424*i0.y;
    k = -0.056676134*a0.z + 0.39353767*b0.z + -0.084844075*c0.z + -0.40938848*d0.z + 0.43433994*e0.z + -0.0467868*f0.z + 0.05856174*g0.z + -0.0035573053*h0.z + 0.06727593*i0.z;
    l = 0.07382817*a0.w + 0.09749001*b0.w + 0.10126295*c0.w + 0.008741454*d0.w + 0.39640576*e0.w + -0.04807935*f0.w + -0.06656666*g0.w + 0.25684914*h0.w + 0.0019193583*i0.w;
    m = -0.11828054*a1.x + 0.0019712716*b1.x + -0.13174061*c1.x + -0.1187297*d1.x + 0.2771482*e1.x + -0.049998764*f1.x + -0.014556588*g1.x + 0.021141794*h1.x + -0.11514141*i1.x;
    n = 0.054093186*a1.y + 0.037061032*b1.y + 0.033518914*c1.y + -0.064772524*d1.y + 0.032749593*e1.y + -0.13419507*f1.y + 0.03170873*g1.y + -0.2231949*h1.y + -0.012648845*i1.y;
    o = -0.22901534*a1.z + 0.08525871*b1.z + 0.0018718509*c1.z + -0.24271463*d1.z + 0.16937853*e1.z + -0.010539479*f1.z + 0.051749635*g1.z + 0.021106198*h1.z + -0.00473413*i1.z;
    p = 0.121054955*a1.w + 0.017015804*b1.w + -0.16921929*c1.w + 0.17097035*d1.w + -0.17894094*e1.w + 0.09484096*f1.w + -0.036366504*g1.w + -0.17848694*h1.w + 0.08738928*i1.w;
    q = -0.056598846*na0.x + 0.08514117*nb0.x + -0.089687414*nc0.x + -0.11324739*nd0.x + -0.17677836*ne0.x + 0.09375303*nf0.x + -0.033391934*ng0.x + 0.015983*nh0.x + 0.18625529*ni0.x;
    r = 0.002394124*na0.y + 0.062107176*nb0.y + 0.096476205*nc0.y + 0.0063232374*nd0.y + 0.0089889495*ne0.y + 0.22078408*nf0.y + -0.020800646*ng0.y + 0.17141153*nh0.y + 0.015246565*ni0.y;
    s = 0.022962576*na0.z + -0.2124664*nb0.z + -0.029383652*nc0.z + 0.26072204*nd0.z + -0.075786315*ne0.z + -0.05708116*nf0.z + -0.08542466*ng0.z + -0.050992683*nh0.z + -0.12126194*ni0.z;
    t = 0.024848187*na0.w + -0.04938356*nb0.w + -0.077254295*nc0.w + 0.043234512*nd0.w + -0.15014283*ne0.w + 0.20598838*nf0.w + 0.046027232*ng0.w + -0.18911807*nh0.w + 0.123776875*ni0.w;
    u = 0.20604062*na1.x + -0.23251836*nb1.x + 0.081893235*nc1.x + 0.12732284*nd1.x + -0.5516895*ne1.x + 0.061047662*nf1.x + -0.0370991*ng1.x + -0.14647527*nh1.x + -0.0705801*ni1.x;
    v = 0.073026024*na1.y + -0.08535302*nb1.y + 0.05075408*nc1.y + 0.09554201*nd1.y + 0.0929716*ne1.y + 0.29073346*nf1.y + 0.12636878*ng1.y + 0.21003686*nh1.y + 0.09685778*ni1.y;
    w = 0.070990615*na1.z + 0.101455785*nb1.z + -0.020180527*nc1.z + 0.08770532*nd1.z + -0.3649432*ne1.z + 0.04242679*nf1.z + 0.0056111766*ng1.z + -0.07642413*nh1.z + 0.01310854*ni1.z;
    x = -0.10968941*na1.w + -0.08435011*nb1.w + 0.03254347*nc1.w + -0.37846026*nd1.w + 0.21967432*ne1.w + -0.18490723*nf1.w + 0.0048353807*ng1.w + 0.010850792*nh1.w + -0.017531307*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.00060440507;
    i = -0.013804354*a0.x + 0.021247795*b0.x + 0.061585147*c0.x + 0.09833304*d0.x + -0.30245215*e0.x + 0.008355005*f0.x + -0.13107775*g0.x + 0.21611948*h0.x + 0.06137902*i0.x;
    j = -0.098681964*a0.y + -0.037771676*b0.y + 0.047770564*c0.y + 0.13817668*d0.y + 0.040083956*e0.y + 0.025086235*f0.y + -0.019439515*g0.y + -0.045821697*h0.y + 0.0014383323*i0.y;
    k = 0.033921614*a0.z + -0.06321198*b0.z + -0.024385406*c0.z + 0.054660544*d0.z + -0.29555362*e0.z + -0.025737336*f0.z + 0.035136692*g0.z + -0.23046388*h0.z + 0.039965965*i0.z;
    l = 0.013431202*a0.w + -0.0061672954*b0.w + -0.060486417*c0.w + -0.24859713*d0.w + -0.13546251*e0.w + 0.076836795*f0.w + -0.002994137*g0.w + 0.07161491*h0.w + 0.06443895*i0.w;
    m = -0.017377341*a1.x + 0.12906437*b1.x + -0.020969361*c1.x + 0.15516324*d1.x + 0.21561222*e1.x + -0.20739709*f1.x + 0.091706246*g1.x + -0.10040115*h1.x + -0.034028374*i1.x;
    n = -0.0063148965*a1.y + 0.08987722*b1.y + 0.029218154*c1.y + -0.054101445*d1.y + -0.13817003*e1.y + -0.029354995*f1.y + 0.04757919*g1.y + -0.13517953*h1.y + -0.08134147*i1.y;
    o = 0.010582513*a1.z + 0.21907906*b1.z + -0.05613645*c1.z + 0.2769764*d1.z + -0.20559123*e1.z + -0.06640349*f1.z + 0.00692517*g1.z + -0.059551317*h1.z + 0.06395893*i1.z;
    p = -0.14352207*a1.w + -0.16687149*b1.w + 0.13081709*c1.w + -0.051290963*d1.w + 0.25922292*e1.w + -0.014545821*f1.w + -0.005920325*g1.w + 0.005911838*h1.w + -0.09514923*i1.w;
    q = -0.08228784*na0.x + 0.000581186*nb0.x + -0.09652686*nc0.x + 0.06880835*nd0.x + 0.0076048165*ne0.x + 0.12021452*nf0.x + 0.12102143*ng0.x + -0.17097168*nh0.x + -0.010007838*ni0.x;
    r = 0.036096275*na0.y + 0.14173397*nb0.y + -0.07032519*nc0.y + 0.004925754*nd0.y + -0.07576388*ne0.y + -0.0563072*nf0.y + -0.07073694*ng0.y + 0.039116677*nh0.y + -0.010859262*ni0.y;
    s = -0.0020870338*na0.z + -0.028113784*nb0.z + 0.04989161*nc0.z + -0.09156798*nd0.z + 0.07752935*ne0.z + -0.017505554*nf0.z + -0.025690995*ng0.z + 0.25614643*nh0.z + -0.083168246*ni0.z;
    t = -0.079945564*na0.w + -0.09527443*nb0.w + 0.03347835*nc0.w + 0.15164866*nd0.w + -0.10824011*ne0.w + -0.13326558*nf0.w + 0.15131363*ng0.w + -0.03776239*nh0.w + -0.033501238*ni0.w;
    u = 0.035662424*na1.x + -0.27835503*nb1.x + -0.016060097*nc1.x + -0.1452523*nd1.x + -0.07443286*ne1.x + -0.019472402*nf1.x + -0.1322107*ng1.x + 0.034941226*nh1.x + 0.052179255*ni1.x;
    v = -0.0181661*na1.y + 0.12392778*nb1.y + 0.097098775*nc1.y + -0.08682108*nd1.y + 0.27572918*ne1.y + 0.28702986*nf1.y + 0.124801435*ng1.y + 0.015296429*nh1.y + 0.017991979*ni1.y;
    w = -0.021040164*na1.z + -0.15109229*nb1.z + 0.07820955*nc1.z + -0.067696646*nd1.z + 0.4926855*ne1.z + 0.005093849*nf1.z + 0.01170877*ng1.z + -0.033637036*nh1.z + -0.029393932*ni1.z;
    x = 0.22366229*na1.w + 0.45942515*nb1.w + -0.17588852*nc1.w + 0.10926712*nd1.w + -0.074878484*ne1.w + 0.12930797*nf1.w + 0.042554796*ng1.w + 0.037292596*nh1.w + -0.024673386*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.010160626;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN100
//!BIND LUMAN101
//!SAVE LUMAN110

#define L0_tex LUMAN100_tex
#define L1_tex LUMAN101_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.03602069*a0.x + -0.0065346938*b0.x + 0.08521494*c0.x + -0.041519314*d0.x + -0.5841501*e0.x + 0.18409619*f0.x + -0.05032032*g0.x + 0.0011552947*h0.x + -0.005042036*i0.x;
    float j = 0.030269936*a0.y + 0.013622225*b0.y + 0.23117489*c0.y + -0.005249265*d0.y + -0.28945604*e0.y + 0.26844555*f0.y + -0.14357369*g0.y + -0.14488666*h0.y + -0.14479089*i0.y;
    float k = -0.12555563*a0.z + -0.09965008*b0.z + 0.017267741*c0.z + -0.119758226*d0.z + -0.4075112*e0.z + -0.18350755*f0.z + 0.04012238*g0.z + 0.00733259*h0.z + 0.07676842*i0.z;
    float l = -0.12535982*a0.w + 0.16426282*b0.w + -0.05104696*c0.w + -0.058004126*d0.w + -0.17966852*e0.w + -0.07398425*f0.w + -0.094065726*g0.w + -0.2342982*h0.w + -0.06416653*i0.w;
    float m = -0.05863216*a1.x + -0.13490738*b1.x + -0.046150867*c1.x + 0.17273849*d1.x + -0.009401783*e1.x + -0.036789127*f1.x + 0.0071901856*g1.x + -0.047581356*h1.x + -0.016197177*i1.x;
    float n = 0.06269741*a1.y + -0.016592018*b1.y + -0.043655146*c1.y + -0.06522069*d1.y + -0.30029792*e1.y + -0.04420866*f1.y + -0.04570528*g1.y + 0.0646861*h1.y + 0.030200183*i1.y;
    float o = 0.14399967*a1.z + 0.028651504*b1.z + 0.05778356*c1.z + 0.08821856*d1.z + 0.29038462*e1.z + 0.22381328*f1.z + -0.008642876*g1.z + -0.09654283*h1.z + -0.10973205*i1.z;
    float p = 0.12103744*a1.w + 0.2311598*b1.w + -0.036589112*c1.w + -0.04680214*d1.w + 0.26473337*e1.w + -0.18286628*f1.w + -0.050546758*g1.w + 0.27403802*h1.w + -0.005307289*i1.w;
    float q = -0.04546302*na0.x + -0.17213371*nb0.x + 0.003806862*nc0.x + 0.023668943*nd0.x + 0.36936614*ne0.x + -0.17300197*nf0.x + 0.030298656*ng0.x + 0.05799353*nh0.x + 0.08662349*ni0.x;
    float r = -0.04944561*na0.y + -0.056982957*nb0.y + -0.20022678*nc0.y + 0.017711869*nd0.y + 0.3456449*ne0.y + -0.29923084*nf0.y + 0.057976753*ng0.y + 0.19869696*nh0.y + 0.08283148*ni0.y;
    float s = 0.07260866*na0.z + 0.068223044*nb0.z + 0.06357076*nc0.z + 0.124097474*nd0.z + 0.78690267*ne0.z + 0.30145773*nf0.z + 0.030661518*ng0.z + -0.02760832*nh0.z + -0.112959*ni0.z;
    float t = 0.08632359*na0.w + -0.05515791*nb0.w + 0.07179812*nc0.w + 0.11407412*nd0.w + 0.2622368*ne0.w + -0.018783974*nf0.w + -0.0041560098*ng0.w + 0.03821421*nh0.w + 0.06326718*ni0.w;
    float u = 0.069282204*na1.x + 0.03544544*nb1.x + 0.025868848*nc1.x + -0.09281634*nd1.x + 0.058544382*ne1.x + 0.04652626*nf1.x + -0.07156491*ng1.x + 0.017106233*nh1.x + 0.047421742*ni1.x;
    float v = -0.044539373*na1.y + -0.042148568*nb1.y + 0.07050117*nc1.y + 0.053141985*nd1.y + 0.48459253*ne1.y + 0.11035981*nf1.y + 0.07965893*ng1.y + -0.17465805*nh1.y + -0.091129944*ni1.y;
    float w = -0.07218466*na1.z + -0.06529778*nb1.z + -0.039833274*nc1.z + -0.15487763*nd1.z + -0.43414643*ne1.z + -0.18884458*nf1.z + 0.011959076*ng1.z + 0.26235119*nh1.z + 0.13393946*ni1.z;
    float x = -0.17639084*na1.w + -0.48395765*nb1.w + -0.032830775*nc1.w + -0.021607742*nd1.w + 0.21255508*ne1.w + 0.11890606*nf1.w + -0.08791553*ng1.w + -0.22008047*nh1.w + -0.06060257*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.024112992;
    i = 0.015220411*a0.x + 0.00021640473*b0.x + 0.00384377*c0.x + 0.12334635*d0.x + 0.08264294*e0.x + 0.015325374*f0.x + 0.103720956*g0.x + -0.11786532*h0.x + -0.12656337*i0.x;
    j = -0.042295307*a0.y + -0.12803623*b0.y + 0.056015495*c0.y + 0.27728587*d0.y + 0.076958366*e0.y + -0.15539825*f0.y + 0.04920014*g0.y + 0.3072905*h0.y + -0.16387074*i0.y;
    k = -0.0845296*a0.z + 0.0045217043*b0.z + -0.00032858725*c0.z + -0.28042564*d0.z + -0.2551264*e0.z + 0.033419732*f0.z + 0.1324542*g0.z + -0.33311492*h0.z + -0.073407345*i0.z;
    l = 0.03763565*a0.w + -0.101808086*b0.w + 0.12194186*c0.w + -0.11221479*d0.w + 0.011986732*e0.w + 0.036151536*f0.w + 0.16944255*g0.w + -0.47388855*h0.w + -0.20185669*i0.w;
    m = 0.16554914*a1.x + -0.043454412*b1.x + 0.06277518*c1.x + 0.080631435*d1.x + 0.13178025*e1.x + -0.035219252*f1.x + -0.0050541796*g1.x + 0.16690767*h1.x + 0.13405177*i1.x;
    n = 0.017330913*a1.y + -0.10955309*b1.y + -0.039075293*c1.y + -0.19225971*d1.y + 0.24710307*e1.y + 0.0546898*f1.y + -0.020972615*g1.y + -0.10566769*h1.y + 0.13435537*i1.y;
    o = -0.09115333*a1.z + 0.028685523*b1.z + 0.059706703*c1.z + -0.013648075*d1.z + -0.22919676*e1.z + -0.18372746*f1.z + 0.023510983*g1.z + -0.0011091923*h1.z + 0.0075845607*i1.z;
    p = 0.037163705*a1.w + -0.04032177*b1.w + 0.036643118*c1.w + 0.26878777*d1.w + 0.3817339*e1.w + 0.07120527*f1.w + -0.09457787*g1.w + -0.07276129*h1.w + 0.0101238405*i1.w;
    q = 0.10527173*na0.x + 0.007218408*nb0.x + -0.01260221*nc0.x + -0.07497777*nd0.x + -0.13471922*ne0.x + -0.014607285*nf0.x + -0.085688256*ng0.x + 0.050644316*nh0.x + 0.22081862*ni0.x;
    r = 0.020645555*na0.y + 0.004109053*nb0.y + 0.024294011*nc0.y + -0.1366366*nd0.y + 0.230857*ne0.y + 0.2505362*nf0.y + 0.014395575*ng0.y + -0.20022038*nh0.y + 0.24387321*ni0.y;
    s = 0.022694416*na0.z + -0.0010274414*nb0.z + -0.018127205*nc0.z + 0.11808406*nd0.z + 0.067578726*ne0.z + -0.06129588*nf0.z + -0.1027712*ng0.z + -0.07272307*nh0.z + -0.036023825*ni0.z;
    t = 0.06470276*na0.w + 0.10388846*nb0.w + -0.0006190098*nc0.w + 0.07504703*nd0.w + 0.016774131*ne0.w + 0.012262067*nf0.w + -0.04258665*ng0.w + 0.46223727*nh0.w + 0.1648368*ni0.w;
    u = -0.19243379*na1.x + 0.12196685*nb1.x + 0.04699072*nc1.x + -0.116037935*nd1.x + -0.25312606*ne1.x + 0.07425659*nf1.x + 0.125147*ng1.x + -0.10115886*nh1.x + -0.08619349*ni1.x;
    v = 0.13461848*na1.y + 0.30897498*nb1.y + 0.049649116*nc1.y + 0.14223924*nd1.y + -0.3189692*ne1.y + 0.12078284*nf1.y + -0.13881688*ng1.y + 0.39585662*nh1.y + -0.121917404*ni1.y;
    w = 0.017644675*na1.z + -0.02583539*nb1.z + -0.03376057*nc1.z + 0.21698844*nd1.z + 0.20131592*ne1.z + 0.036263432*nf1.z + -0.12243008*ng1.z + 0.2662984*nh1.z + -0.05208568*ni1.z;
    x = -0.08311993*na1.w + 0.06898596*nb1.w + 0.1168798*nc1.w + 0.06794715*nd1.w + -0.2179697*ne1.w + -0.020453759*nf1.w + -0.22404517*ng1.w + 0.44327855*nh1.w + -0.084174156*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.021556964;
    i = 0.10353498*a0.x + 0.028292345*b0.x + -0.14651915*c0.x + 0.07447917*d0.x + 0.7510377*e0.x + 0.037376225*f0.x + -0.08991325*g0.x + -0.15310106*h0.x + 0.021130428*i0.x;
    j = -0.042429667*a0.y + -0.109997764*b0.y + -0.17000705*c0.y + -0.23916405*d0.y + -0.31910843*e0.y + 0.24798077*f0.y + -0.18227191*g0.y + 0.020335764*h0.y + 0.103075214*i0.y;
    k = 0.101871334*a0.z + -0.096882686*b0.z + -0.095259584*c0.z + 0.11459477*d0.z + -0.14924978*e0.z + -0.0914223*f0.z + 0.08352624*g0.z + -2.2024558e-05*h0.z + -0.10669735*i0.z;
    l = 0.07058873*a0.w + 0.055611346*b0.w + -0.27597594*c0.w + 0.060510594*d0.w + -0.06938622*e0.w + 0.031955447*f0.w + -0.06676932*g0.w + 0.015034923*h0.w + 0.13512042*i0.w;
    m = 0.005268731*a1.x + 0.06342999*b1.x + 0.17636086*c1.x + 0.07072773*d1.x + 0.2873334*e1.x + 0.0025959408*f1.x + -0.007068777*g1.x + 0.06448795*h1.x + -0.03921053*i1.x;
    n = -0.086861365*a1.y + -0.23956086*b1.y + 0.023615625*c1.y + -0.016472433*d1.y + 0.77977765*e1.y + -0.2707349*f1.y + 0.15484811*g1.y + -0.11511586*h1.y + 0.0015578099*i1.y;
    o = -0.009912772*a1.z + -0.018964097*b1.z + 0.02293317*c1.z + -0.043342438*d1.z + -0.003991376*e1.z + 0.14810553*f1.z + -0.04009368*g1.z + 0.11626676*h1.z + 0.08746776*i1.z;
    p = 0.1307143*a1.w + -0.38829568*b1.w + -0.04730003*c1.w + -0.3073631*d1.w + 0.0039590085*e1.w + -0.03159446*f1.w + -0.110455066*g1.w + -0.2890916*h1.w + 0.13814703*i1.w;
    q = -0.015642561*na0.x + 0.14379875*nb0.x + 0.22320704*nc0.x + 0.10343936*nd0.x + -0.37316132*ne0.x + -0.12211642*nf0.x + 0.151595*ng0.x + 0.08496525*nh0.x + -0.07385503*ni0.x;
    r = -0.005425541*na0.y + 0.25162533*nb0.y + 0.17031972*nc0.y + 0.37817922*nd0.y + 0.1751982*ne0.y + -0.19810377*nf0.y + 0.05232508*ng0.y + 0.071171805*nh0.y + -0.08274256*ni0.y;
    s = 0.04870444*na0.z + 0.069402404*nb0.z + 0.06612454*nc0.z + -0.16123009*nd0.z + 0.37446707*ne0.z + 0.17678879*nf0.z + 0.15383762*ng0.z + -0.017722199*nh0.z + 0.11936048*ni0.z;
    t = -0.04180779*na0.w + -0.006943261*nb0.w + 0.060121372*nc0.w + -0.2158157*nd0.w + -0.0751999*ne0.w + -0.059396897*nf0.w + -0.019060649*ng0.w + -0.20357497*nh0.w + 0.07698966*ni0.w;
    u = 0.08368119*na1.x + -0.12918562*nb1.x + -0.18324965*nc1.x + 0.10304961*nd1.x + -0.14763509*ne1.x + 0.10546128*nf1.x + -0.10853921*ng1.x + -0.16994037*nh1.x + 0.08002449*ni1.x;
    v = 0.023527468*na1.y + 0.31890285*nb1.y + 0.06943346*nc1.y + -0.061519075*nd1.y + -0.17082773*ne1.y + -0.0750498*nf1.y + -0.026083339*ng1.y + 0.050275475*nh1.y + -0.04482955*ni1.y;
    w = 0.13297354*na1.z + -0.25774565*nb1.z + 0.04645572*nc1.z + -0.21069203*nd1.z + -0.019796975*ne1.z + -0.19346039*nf1.z + 0.028876891*ng1.z + -0.22818841*nh1.z + -0.017355708*ni1.z;
    x = 0.099980265*na1.w + 0.20437594*nb1.w + 0.036823206*nc1.w + -0.035766415*nd1.w + 0.29052198*ne1.w + -0.0441845*nf1.w + 0.14488915*ng1.w + -0.095914885*nh1.w + 0.04632105*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.020339007;
    i = 0.018414905*a0.x + 0.051992606*b0.x + -0.026458269*c0.x + -0.056065753*d0.x + -0.57431364*e0.x + 0.14583828*f0.x + -0.20091495*g0.x + 0.036064938*h0.x + 0.24589996*i0.x;
    j = 0.12951489*a0.y + 0.22155547*b0.y + -0.03793838*c0.y + -0.37865022*d0.y + -0.8699486*e0.y + 0.30465844*f0.y + -0.05505082*g0.y + -0.1808131*h0.y + -0.043180563*i0.y;
    k = -0.093806*a0.z + -0.08082797*b0.z + -0.05212279*c0.z + 0.059532817*d0.z + 0.18182111*e0.z + -0.030775163*f0.z + -0.056424897*g0.z + -0.06331663*h0.z + 0.16157578*i0.z;
    l = -0.13735132*a0.w + 0.12328133*b0.w + -0.116585016*c0.w + -0.14569259*d0.w + -0.37743783*e0.w + 0.043045748*f0.w + -0.16366433*g0.w + 0.047612697*h0.w + 0.06902134*i0.w;
    m = -0.11859453*a1.x + 0.085688874*b1.x + -0.012032304*c1.x + 0.038115133*d1.x + -0.23642606*e1.x + -0.06443288*f1.x + 0.010304007*g1.x + -0.11454085*h1.x + -0.19266266*i1.x;
    n = -0.041277226*a1.y + 0.14278844*b1.y + 0.09594997*c1.y + 0.22554651*d1.y + -0.4707059*e1.y + -0.5767265*f1.y + -0.07657722*g1.y + 0.0763926*h1.y + 0.16180336*i1.y;
    o = 0.14852785*a1.z + -0.03800648*b1.z + -0.08576322*c1.z + 0.035554264*d1.z + -0.069700964*e1.z + 0.37610474*f1.z + 0.08681652*g1.z + 0.1506625*h1.z + -0.12656021*i1.z;
    p = -0.024719054*a1.w + 0.003164649*b1.w + -0.13945296*c1.w + -0.13508745*d1.w + 0.13328283*e1.w + -0.11239675*f1.w + -0.08487616*g1.w + 0.23727833*h1.w + 0.056444455*i1.w;
    q = -0.10184672*na0.x + -0.059290465*nb0.x + 0.0059381626*nc0.x + 0.013273808*nd0.x + 0.21650733*ne0.x + -0.2524956*nf0.x + 0.102933444*ng0.x + 0.035939015*nh0.x + -0.14319602*ni0.x;
    r = -0.022619557*na0.y + -0.018408645*nb0.y + 0.10522426*nc0.y + 0.32646754*nd0.y + 0.80208266*ne0.y + -0.46869853*nf0.y + -0.016906548*ng0.y + 0.17456181*nh0.y + -0.029142622*ni0.y;
    s = 0.096661486*na0.z + 0.18941526*nb0.z + 0.08153988*nc0.z + -0.10972477*nd0.z + -0.13448085*ne0.z + 0.057993986*nf0.z + -0.026086971*ng0.z + 0.09751599*nh0.z + 0.018404521*ni0.z;
    t = 0.044939417*na0.w + -0.066798955*nb0.w + 0.033069726*nc0.w + 0.08848126*nd0.w + 0.22031724*ne0.w + 0.21239568*nf0.w + -0.03176487*ng0.w + -0.08072932*nh0.w + -0.18890536*ni0.w;
    u = 0.20835902*na1.x + -0.18376575*nb1.x + -0.20231391*nc1.x + -0.039601583*nd1.x + 0.39764643*ne1.x + 0.14225262*nf1.x + -0.123099715*ng1.x + 0.09194234*nh1.x + 0.17620787*ni1.x;
    v = -0.005739508*na1.y + -0.20032057*nb1.y + -0.09430665*nc1.y + -0.11195265*nd1.y + 0.4117789*ne1.y + 0.29875347*nf1.y + 0.18852101*ng1.y + -0.25315195*nh1.y + -0.23462892*ni1.y;
    w = 0.07256975*na1.z + 0.063809015*nb1.z + 0.15035653*nc1.z + -0.13318999*nd1.z + -0.27948493*ne1.z + 0.008878333*nf1.z + -0.034100264*ng1.z + 0.09170595*nh1.z + 0.019607466*ni1.z;
    x = 0.122655496*na1.w + 0.16501404*nb1.w + -0.20922776*nc1.w + -0.35553262*nd1.w + -0.38473418*ne1.w + 0.33719665*nf1.w + 0.117218845*ng1.w + -0.20784451*nh1.w + -0.14332327*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.026562545;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN100
//!BIND LUMAN101
//!SAVE LUMAN111

#define L0_tex LUMAN100_tex
#define L1_tex LUMAN101_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.17383257*a0.x + 0.19359857*b0.x + -0.008506656*c0.x + -0.0024075257*d0.x + -0.0035203139*e0.x + -0.089835465*f0.x + 0.112369776*g0.x + -0.062991165*h0.x + -0.09123371*i0.x;
    float j = 0.18316449*a0.y + 0.016517052*b0.y + 0.06764748*c0.y + 0.046583068*d0.y + 0.24939087*e0.y + -0.19446205*f0.y + 0.02954913*g0.y + 0.13914897*h0.y + 0.061350036*i0.y;
    float k = -0.06663179*a0.z + 0.10225051*b0.z + -0.055374082*c0.z + -0.17434083*d0.z + 0.11235246*e0.z + -0.03738717*f0.z + 0.113932945*g0.z + -0.12036072*h0.z + 0.067093164*i0.z;
    float l = -0.35936478*a0.w + 0.25206113*b0.w + 0.062964626*c0.w + 0.18188629*d0.w + -0.06851797*e0.w + 0.0070859026*f0.w + 0.1354472*g0.w + -0.12759088*h0.w + 0.00045594518*i0.w;
    float m = 0.028956862*a1.x + -0.3117937*b1.x + 0.08079537*c1.x + 0.01991457*d1.x + -0.20107096*e1.x + 0.10075411*f1.x + -0.030672783*g1.x + -0.008995862*h1.x + 0.0033733798*i1.x;
    float n = 0.0636544*a1.y + 0.19053148*b1.y + 0.09280553*c1.y + -0.12814613*d1.y + 0.40875462*e1.y + -0.12533753*f1.y + 0.03432*g1.y + -0.10794891*h1.y + -0.115061335*i1.y;
    float o = -0.13256124*a1.z + -0.25365067*b1.z + -0.019771395*c1.z + -0.50099087*d1.z + -0.52115613*e1.z + 0.0525626*f1.z + -0.21533427*g1.z + -0.090868905*h1.z + 0.12670971*i1.z;
    float p = -0.098364204*a1.w + 0.42667642*b1.w + 0.019137595*c1.w + -0.143334*d1.w + 0.31880572*e1.w + -0.022834571*f1.w + 0.102781296*g1.w + -0.025588622*h1.w + -0.058978826*i1.w;
    float q = 0.17132543*na0.x + -0.3008873*nb0.x + -0.059462246*nc0.x + -0.119294114*nd0.x + 0.1022395*ne0.x + 0.014199865*nf0.x + -0.07571218*ng0.x + -0.11296554*nh0.x + 0.07032073*ni0.x;
    float r = 0.037491314*na0.y + -0.058757633*nb0.y + -0.06759223*nc0.y + 0.07403289*nd0.y + -0.049440965*ne0.y + 0.16491657*nf0.y + -0.1802418*ng0.y + 0.07016352*nh0.y + 0.10195126*ni0.y;
    float s = 0.071089566*na0.z + -0.16521877*nb0.z + 0.16861384*nc0.z + 0.05623844*nd0.z + -0.39791787*ne0.z + 0.05436925*nf0.z + 0.054514594*ng0.z + -0.06257326*nh0.z + -0.0682845*ni0.z;
    float t = 0.061884217*na0.w + -0.2286*nb0.w + 0.11185325*nc0.w + 0.1820207*nd0.w + -0.27744997*ne0.w + 0.17514008*nf0.w + -0.028395107*ng0.w + -0.07900793*nh0.w + 0.08224395*ni0.w;
    float u = -0.006974786*na1.x + 0.2775666*nb1.x + -0.05748193*nc1.x + -0.107195705*nd1.x + 0.13472128*ne1.x + -0.17489615*nf1.x + 0.08438403*ng1.x + 0.05627347*nh1.x + 0.014787926*ni1.x;
    float v = -0.10634387*na1.y + -0.21718432*nb1.y + -0.05429719*nc1.y + 0.39874536*nd1.y + 0.1328281*ne1.y + 0.07176977*nf1.y + 0.10495411*ng1.y + 0.03204737*nh1.y + 0.043627903*ni1.y;
    float w = 0.20148818*na1.z + 0.2715468*nb1.z + 0.027095042*nc1.z + 0.50055045*nd1.z + 0.12403425*ne1.z + 0.19137537*nf1.z + 0.107188895*ng1.z + -0.16039443*nh1.z + -0.11896027*ni1.z;
    float x = 0.22292997*na1.w + -0.32840404*nb1.w + 0.057060912*nc1.w + -0.102952555*nd1.w + -0.4768226*ne1.w + 0.13585155*nf1.w + -0.024274329*ng1.w + 0.045635037*nh1.w + 0.15334982*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.021949163;
    i = -0.057763852*a0.x + -0.08316332*b0.x + -0.11650133*c0.x + 0.08359192*d0.x + -0.30200738*e0.x + -0.20410018*f0.x + -0.056469277*g0.x + 0.03727088*h0.x + -0.23919475*i0.x;
    j = 0.24101874*a0.y + -0.19743818*b0.y + -0.22980976*c0.y + 0.17798895*d0.y + 0.41507307*e0.y + -0.56685776*f0.y + -0.2121568*g0.y + 0.29752794*h0.y + -0.12151107*i0.y;
    k = -0.07609526*a0.z + 0.021728436*b0.z + 0.0085501745*c0.z + -0.28034872*d0.z + 0.20530029*e0.z + 0.035212994*f0.z + -0.057961874*g0.z + 0.06513409*h0.z + 0.042886022*i0.z;
    l = 0.035863068*a0.w + -0.539069*b0.w + 0.004749654*c0.w + -0.13944298*d0.w + 0.15007691*e0.w + 0.01589523*f0.w + -0.1202698*g0.w + -0.5025889*h0.w + 0.013119389*i0.w;
    m = 0.009390274*a1.x + -0.059049968*b1.x + 0.050254676*c1.x + 0.16650045*d1.x + -0.22121963*e1.x + 0.10251527*f1.x + 0.066131234*g1.x + -0.019349663*h1.x + 0.011245998*i1.x;
    n = 0.072220445*a1.y + 0.04791526*b1.y + -0.033404786*c1.y + -0.04082059*d1.y + -0.07151034*e1.y + 0.025489205*f1.y + 0.16244847*g1.y + -0.31598613*h1.y + -0.3642761*i1.y;
    o = -0.23894922*a1.z + 0.06735179*b1.z + -0.0923391*c1.z + -0.48843756*d1.z + -0.39792565*e1.z + -0.18545644*f1.z + -0.176065*g1.z + -0.33453122*h1.z + 0.20319647*i1.z;
    p = -0.061228007*a1.w + -0.07530811*b1.w + -0.23172612*c1.w + -0.05970527*d1.w + -0.7531555*e1.w + -0.28645357*f1.w + -0.0015547524*g1.w + 0.11225589*h1.w + 0.056063578*i1.w;
    q = 0.038223065*na0.x + 0.111754596*nb0.x + 0.0130218845*nc0.x + -0.05061665*nd0.x + 0.41986698*ne0.x + 0.123574205*nf0.x + 0.06880718*ng0.x + -0.095840216*nh0.x + 0.12724164*ni0.x;
    r = -0.14341785*na0.y + -0.058098536*nb0.y + 0.22877641*nc0.y + 0.02612737*nd0.y + -0.2091377*ne0.y + 0.5626278*nf0.y + 0.061045192*ng0.y + -0.005432363*nh0.y + 0.25937176*ni0.y;
    s = -0.042168606*na0.z + -0.014749729*nb0.z + 0.079212315*nc0.z + 0.36512303*nd0.z + -0.38474083*ne0.z + -0.032575715*nf0.z + 0.24942294*ng0.z + -0.28649905*nh0.z + -0.13864756*ni0.z;
    t = 0.11840045*na0.w + 0.06969945*nb0.w + 0.017670378*nc0.w + 0.17346504*nd0.w + -0.48784158*ne0.w + 0.09433169*nf0.w + 0.13065694*ng0.w + 0.006293475*nh0.w + 0.20921776*ni0.w;
    u = -0.052700095*na1.x + 0.03280169*nb1.x + -0.041704353*nc1.x + -0.23268354*nd1.x + 0.3779702*ne1.x + -0.15453738*nf1.x + -0.100402474*ng1.x + -0.040295973*nh1.x + 0.05908061*ni1.x;
    v = 0.0090148505*na1.y + -0.09874868*nb1.y + 0.0287044*nc1.y + 0.37773392*nd1.y + -0.11349941*ne1.y + 0.060884114*nf1.y + 0.076751046*ng1.y + 0.16020733*nh1.y + 0.090913005*ni1.y;
    w = 0.03725819*na1.z + 0.08141571*nb1.z + 0.12553579*nc1.z + 0.17851456*nd1.z + 0.29002705*ne1.z + 0.45743072*nf1.z + 0.17406096*ng1.z + 0.13529126*nh1.z + -0.122617625*ni1.z;
    x = -0.06723492*na1.w + 0.108511336*nb1.w + 0.08086323*nc1.w + 0.3413091*nd1.w + -0.066336535*ne1.w + 0.030476777*nf1.w + 0.01769155*ng1.w + -0.20934762*nh1.w + 0.25853097*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.013970954;
    i = -0.13062532*a0.x + 0.14739287*b0.x + 0.13013633*c0.x + -0.15238641*d0.x + 0.41811723*e0.x + 0.09137209*f0.x + 0.008867647*g0.x + -0.18663251*h0.x + -0.025392555*i0.x;
    j = -0.080881484*a0.y + 0.13228063*b0.y + 0.14924963*c0.y + 0.013383812*d0.y + 0.646058*e0.y + -0.23729008*f0.y + -0.03326502*g0.y + 0.1341266*h0.y + 0.0050697867*i0.y;
    k = -0.07851864*a0.z + -0.003983806*b0.z + 0.03482352*c0.z + 0.12479716*d0.z + -0.28953743*e0.z + 0.13379917*f0.z + 0.08265414*g0.z + -0.22911206*h0.z + 0.076923214*i0.z;
    l = -0.18052709*a0.w + -0.08884755*b0.w + 0.20002027*c0.w + -0.04775166*d0.w + -0.47042155*e0.w + -0.037522048*f0.w + 0.022297889*g0.w + -0.554439*h0.w + -0.05526164*i0.w;
    m = 0.11441356*a1.x + -0.21099038*b1.x + -0.0595072*c1.x + -0.20941521*d1.x + -0.063228935*e1.x + -0.035564374*f1.x + 0.020967439*g1.x + 0.01850741*h1.x + -0.000115429575*i1.x;
    n = 0.06921214*a1.y + 0.02414473*b1.y + 0.06690077*c1.y + -0.06028668*d1.y + 0.21183336*e1.y + 0.07774993*f1.y + -0.046541408*g1.y + -0.037885994*h1.y + -0.0068330625*i1.y;
    o = 0.09289483*a1.z + -0.09876539*b1.z + -0.004070522*c1.z + 0.105470106*d1.z + 0.44143915*e1.z + -0.17103986*f1.z + -0.08861693*g1.z + 0.08426412*h1.z + 0.016740821*i1.z;
    p = 0.044459134*a1.w + 0.1889552*b1.w + -0.036764797*c1.w + -0.10289402*d1.w + 0.1978711*e1.w + -0.12065221*f1.w + -0.001048663*g1.w + -0.0873868*h1.w + 0.056002572*i1.w;
    q = 0.12984878*na0.x + -0.2310601*nb0.x + -0.15985721*nc0.x + 0.001380659*nd0.x + -0.40654126*ne0.x + -0.024795063*nf0.x + -0.020679224*ng0.x + 0.064191334*nh0.x + 0.086150564*ni0.x;
    r = 0.10204934*na0.y + -0.10334769*nb0.y + -0.07872581*nc0.y + 0.2238558*nd0.y + -0.5565347*ne0.y + 0.17858714*nf0.y + 0.004345275*ng0.y + 0.03389987*nh0.y + 0.10307973*ni0.y;
    s = -0.005913493*na0.z + -0.018920904*nb0.z + 0.04759889*nc0.z + -0.17818558*nd0.z + 0.1905599*ne0.z + -0.12743413*nf0.z + -0.10214076*ng0.z + -0.20663314*nh0.z + -0.14263868*ni0.z;
    t = 0.096049815*na0.w + 0.0089668585*nb0.w + 0.03275695*nc0.w + -0.046080954*nd0.w + 0.32457682*ne0.w + -0.09166253*nf0.w + 0.07651577*ng0.w + 0.3473302*nh0.w + 0.107547484*ni0.w;
    u = -0.06589269*na1.x + 0.11446591*nb1.x + 0.0869667*nc1.x + 0.23969674*nd1.x + 0.012473717*ne1.x + 0.028081264*nf1.x + 0.048592523*ng1.x + 0.0057853544*nh1.x + 0.11369988*ni1.x;
    v = -0.076878786*na1.y + -0.14412941*nb1.y + 0.06001701*nc1.y + -0.11859855*nd1.y + -0.3363305*ne1.y + -0.018759733*nf1.y + 0.035113666*ng1.y + 0.1236211*nh1.y + -0.20992972*ni1.y;
    w = 0.08501675*na1.z + 0.2189646*nb1.z + -0.03941925*nc1.z + 0.00064086955*nd1.z + -0.18323024*ne1.z + 0.1369047*nf1.z + -0.003876649*ng1.z + 0.10710443*nh1.z + -0.033321608*ni1.z;
    x = 0.04007519*na1.w + -0.35836148*nb1.w + -0.0013083797*nc1.w + -0.21432324*nd1.w + -0.115432896*ne1.w + -0.13674262*nf1.w + -0.12126403*ng1.w + 0.44424897*nh1.w + -0.044962328*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.012365917;
    i = 0.019780008*a0.x + 0.02274219*b0.x + 0.10404665*c0.x + 0.07233267*d0.x + 0.00033344718*e0.x + -0.11473831*f0.x + 0.007841103*g0.x + -0.09002325*h0.x + -0.014212253*i0.x;
    j = 0.14563526*a0.y + -0.35928094*b0.y + 0.027741157*c0.y + -0.13243575*d0.y + 0.33321407*e0.y + -0.04980373*f0.y + -0.060561076*g0.y + -0.1198479*h0.y + 0.00798767*i0.y;
    k = -0.06430791*a0.z + -0.11245109*b0.z + 0.009785175*c0.z + 0.110398166*d0.z + 0.11003975*e0.z + -0.0776389*f0.z + -0.028760761*g0.z + -0.23346215*h0.z + 0.06697744*i0.z;
    l = 0.08202895*a0.w + -0.24874268*b0.w + -0.04023727*c0.w + 0.12763147*d0.w + -0.30607232*e0.w + 0.032928344*f0.w + 0.045949936*g0.w + -0.17675872*h0.w + 0.029689215*i0.w;
    m = 0.13074832*a1.x + 0.08795887*b1.x + -0.08088709*c1.x + -0.15996866*d1.x + -0.13460127*e1.x + 0.07417794*f1.x + 0.06528235*g1.x + 0.05802189*h1.x + -0.016238518*i1.x;
    n = -0.10472487*a1.y + -0.13672562*b1.y + -0.15355995*c1.y + 0.116645455*d1.y + 0.07894707*e1.y + 0.16333249*f1.y + -0.08795837*g1.y + 0.08170686*h1.y + -0.084028274*i1.y;
    o = -0.06835426*a1.z + 0.04501379*b1.z + -0.13693433*c1.z + 0.05058851*d1.z + 0.24882804*e1.z + 0.24579862*f1.z + -0.07010665*g1.z + -0.08789114*h1.z + -0.076151535*i1.z;
    p = 0.020215815*a1.w + 0.10511275*b1.w + 0.11385788*c1.w + 0.15657057*d1.w + 0.31428078*e1.w + -0.13243453*f1.w + 0.06416473*g1.w + 0.08187778*h1.w + -0.11577077*i1.w;
    q = 0.015488034*na0.x + 0.040379517*nb0.x + -0.09120673*nc0.x + -0.014149155*nd0.x + 0.23621029*ne0.x + 0.14273776*nf0.x + -0.019648748*ng0.x + 0.0119334655*nh0.x + 0.018822623*ni0.x;
    r = -0.014699327*na0.y + 0.09688736*nb0.y + 0.06137839*nc0.y + -0.12673396*nd0.y + -0.15387636*ne0.y + -0.013648953*nf0.y + 0.083632514*ng0.y + 0.1163354*nh0.y + -0.012966456*ni0.y;
    s = -0.06854618*na0.z + -0.02779076*nb0.z + -0.04635937*nc0.z + -0.003767295*nd0.z + 0.20731288*ne0.z + 0.08137424*nf0.z + -0.039111614*ng0.z + 0.03876307*nh0.z + -0.18224968*ni0.z;
    t = 0.06683969*na0.w + 0.07981624*nb0.w + 0.08222712*nc0.w + -0.13783932*nd0.w + -0.0445704*ne0.w + -0.018779598*nf0.w + 0.03472594*ng0.w + 0.16947825*nh0.w + 0.020174187*ni0.w;
    u = -0.1262914*na1.x + -0.19105656*nb1.x + 0.12632288*nc1.x + 0.072970435*nd1.x + 0.24985978*ne1.x + -0.20835976*nf1.x + -0.030065924*ng1.x + -0.124369994*nh1.x + 0.011736978*ni1.x;
    v = 0.10787027*na1.y + 0.1833925*nb1.y + 0.23094161*nc1.y + -0.088033065*nd1.y + -0.373916*ne1.y + -0.167832*nf1.y + 0.04991799*ng1.y + 0.04659217*nh1.y + -0.014462782*ni1.y;
    w = 0.032293074*na1.z + -0.05536869*nb1.z + 0.13973999*nc1.z + -0.24594264*nd1.z + -0.303236*ne1.z + -0.1465525*nf1.z + 0.035377152*ng1.z + 0.1454314*nh1.z + 0.07324023*ni1.z;
    x = -0.01987264*na1.w + -0.33423734*nb1.w + -0.021509413*nc1.w + -0.13169123*nd1.w + -0.30786726*ne1.w + -0.0486691*nf1.w + 0.0018869397*ng1.w + 0.118683584*nh1.w + 0.06499663*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.009061854;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN110
//!BIND LUMAN111
//!SAVE LUMAN120

#define L0_tex LUMAN110_tex
#define L1_tex LUMAN111_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.03630481*a0.x + 0.042853218*b0.x + -0.0062229345*c0.x + 0.08429192*d0.x + 0.13565867*e0.x + -0.018807288*f0.x + -0.11221368*g0.x + -0.10852543*h0.x + 0.009985365*i0.x;
    float j = 0.14488101*a0.y + -0.1160535*b0.y + -0.13947323*c0.y + -0.018930992*d0.y + 0.16590987*e0.y + 0.18357886*f0.y + 0.032227106*g0.y + 0.080029584*h0.y + 0.044059783*i0.y;
    float k = -0.029785704*a0.z + 0.0791055*b0.z + -0.085092425*c0.z + -0.118694134*d0.z + -0.2608379*e0.z + 0.056919962*f0.z + 0.039711855*g0.z + -0.010369595*h0.z + 0.00017742845*i0.z;
    float l = -0.17972772*a0.w + -0.044206228*b0.w + -0.036466025*c0.w + 0.15869567*d0.w + 0.5135247*e0.w + 0.0132639455*f0.w + 0.087311976*g0.w + -0.06682728*h0.w + -0.047050804*i0.w;
    float m = 0.0092488015*a1.x + 0.045739576*b1.x + -0.05253328*c1.x + 0.020989254*d1.x + -0.071142375*e1.x + 0.110861145*f1.x + -0.045121893*g1.x + -0.0890038*h1.x + -0.07344975*i1.x;
    float n = -0.041313894*a1.y + 0.0865044*b1.y + -0.019986475*c1.y + -0.06508032*d1.y + -0.3258336*e1.y + -0.0133614205*f1.y + 0.08247431*g1.y + 0.12428612*h1.y + 0.009780545*i1.y;
    float o = -0.04787042*a1.z + 0.07645056*b1.z + -0.052095477*c1.z + -0.107472844*d1.z + -0.18740825*e1.z + 0.023972819*f1.z + 0.0010516763*g1.z + -0.07725984*h1.z + -0.03339135*i1.z;
    float p = -0.05169909*a1.w + 0.11179708*b1.w + 0.04700733*c1.w + 0.10380468*d1.w + -0.0051869787*e1.w + -0.024982737*f1.w + 0.19216102*g1.w + 0.13560702*h1.w + 0.023853956*i1.w;
    float q = -0.032461137*na0.x + -0.29817888*nb0.x + 0.009580925*nc0.x + -0.19076568*nd0.x + -0.06736066*ne0.x + 0.075534545*nf0.x + 0.1596698*ng0.x + 0.27802217*nh0.x + -0.020082833*ni0.x;
    float r = 0.04561214*na0.y + -0.2268211*nb0.y + -0.033104133*nc0.y + -0.18460363*nd0.y + 0.1687154*ne0.y + -0.203963*nf0.y + -0.0034705887*ng0.y + -0.054667573*nh0.y + 0.011704252*ni0.y;
    float s = -0.0025704687*na0.z + -0.076398775*nb0.z + 0.07168415*nc0.z + 0.16773182*nd0.z + 0.12653217*ne0.z + -0.030956728*nf0.z + -0.06234241*ng0.z + 0.1002548*nh0.z + 0.015520437*ni0.z;
    float t = -0.0015870314*na0.w + -0.013954021*nb0.w + 0.052499443*nc0.w + 0.06986832*nd0.w + -0.017726257*ne0.w + -0.06904766*nf0.w + -0.11802487*ng0.w + -0.15650262*nh0.w + -0.013071912*ni0.w;
    float u = -0.050452612*na1.x + 0.10086934*nb1.x + 0.017438639*nc1.x + 0.07873438*nd1.x + -0.24193725*ne1.x + 0.017887043*nf1.x + 0.057130046*ng1.x + 0.12398589*nh1.x + -0.0051867655*ni1.x;
    float v = 0.026148327*na1.y + -0.07549014*nb1.y + 0.007604178*nc1.y + 0.08956475*nd1.y + 0.29691312*ne1.y + 0.031737674*nf1.y + -0.08130795*ng1.y + -0.13281015*nh1.y + 0.0027009016*ni1.y;
    float w = -0.038594443*na1.z + -0.09979849*nb1.z + 0.02744579*nc1.z + 0.111809075*nd1.z + 0.08823714*ne1.z + -0.009796724*nf1.z + -0.0020764987*ng1.z + 0.027102355*nh1.z + 0.014978432*ni1.z;
    float x = -0.015462624*na1.w + -0.019302703*nb1.w + -0.010519787*nc1.w + 0.025670882*nd1.w + -0.27587906*ne1.w + -0.0023357677*nf1.w + -0.057278287*ng1.w + -0.17058408*nh1.w + -0.023692317*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0037216332;
    i = 0.06428213*a0.x + -0.039442237*b0.x + -0.00015441276*c0.x + 0.27578467*d0.x + -0.20546672*e0.x + 0.051709026*f0.x + 0.091907986*g0.x + -0.20595479*h0.x + 0.05069401*i0.x;
    j = -0.0015483696*a0.y + 0.084184326*b0.y + -0.082643285*c0.y + -0.020861834*d0.y + -0.09652075*e0.y + -0.0027274876*f0.y + -0.030430764*g0.y + 0.020421056*h0.y + 0.004766083*i0.y;
    k = 0.003211529*a0.z + -0.10061028*b0.z + 0.0075153783*c0.z + 0.07965502*d0.z + 0.16045961*e0.z + 0.27895573*f0.z + 0.058805324*g0.z + -0.094317034*h0.z + -0.0026893024*i0.z;
    l = -0.08095427*a0.w + 0.122727305*b0.w + -0.17080276*c0.w + 0.0702275*d0.w + -0.7364643*e0.w + 0.19323185*f0.w + -0.14044754*g0.w + 0.24313556*h0.w + -0.1266726*i0.w;
    m = -0.023697993*a1.x + 0.0018436237*b1.x + 0.056907523*c1.x + 0.03974732*d1.x + -0.16493993*e1.x + 0.15792988*f1.x + 0.1423698*g1.x + -0.0062908884*h1.x + -0.06975383*i1.x;
    n = 0.119774625*a1.y + -0.3077789*b1.y + 0.12898988*c1.y + 0.026241446*d1.y + -0.6198384*e1.y + -0.058987133*f1.y + 0.09120274*g1.y + -0.134381*h1.y + 0.043369815*i1.y;
    o = 0.16480406*a1.z + 0.12151589*b1.z + 0.025838127*c1.z + 0.2519131*d1.z + 0.08198142*e1.z + 0.3078468*f1.z + -0.052510783*g1.z + 0.15783007*h1.z + -0.0039160047*i1.z;
    p = 0.068643615*a1.w + -0.0060765394*b1.w + -0.15508175*c1.w + 0.20387188*d1.w + 0.1344372*e1.w + 0.2220656*f1.w + -0.29686332*g1.w + 0.10761737*h1.w + 0.08267347*i1.w;
    q = -0.1427859*na0.x + 0.13410714*nb0.x + 0.006750742*nc0.x + -0.119788475*nd0.x + 0.34537068*ne0.x + -0.090779886*nf0.x + -0.13245101*ng0.x + 0.06902025*nh0.x + 0.070811994*ni0.x;
    r = -0.023257682*na0.y + -0.48287916*nb0.y + -0.08024248*nc0.y + -0.23683101*nd0.y + -0.36748612*ne0.y + 0.09897269*nf0.y + 0.072566874*ng0.y + -0.06901731*nh0.y + -0.33572045*ni0.y;
    s = -0.031415988*na0.z + 0.16148424*nb0.z + 0.011690278*nc0.z + -0.21647319*nd0.z + -0.15012386*ne0.z + -0.12023273*nf0.z + 0.07779024*ng0.z + 0.08440504*nh0.z + 0.009941279*ni0.z;
    t = -0.013498529*na0.w + 0.07958699*nb0.w + -0.08360842*nc0.w + 0.05095159*nd0.w + 0.48715267*ne0.w + -0.052980598*nf0.w + 0.111399*ng0.w + -0.09430513*nh0.w + -0.11216889*ni0.w;
    u = -0.0034462619*na1.x + -0.0815332*nb1.x + 0.047141153*nc1.x + 0.0968686*nd1.x + 0.006086954*ne1.x + -0.07627388*nf1.x + 0.016371105*ng1.x + 1.5434503e-05*nh1.x + -0.08802993*ni1.x;
    v = -0.175829*na1.y + 0.08813627*nb1.y + 0.026431296*nc1.y + 0.05342739*nd1.y + 0.26712433*ne1.y + 0.0015671187*nf1.y + -0.009087923*ng1.y + 0.034405686*nh1.y + -0.014833625*ni1.y;
    w = -0.094343*na1.z + -0.02134733*nb1.z + -0.12081456*nc1.z + 0.0008002904*nd1.z + -0.837031*ne1.z + -0.024695735*nf1.z + 0.05592583*ng1.z + 0.049783334*nh1.z + 0.070664614*ni1.z;
    x = 0.02560576*na1.w + -0.0652353*nb1.w + -0.026176922*nc1.w + 0.027611544*nd1.w + 0.101991735*ne1.w + 0.16426045*nf1.w + -0.06456173*ng1.w + 0.04814978*nh1.w + -0.096576855*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.016174361;
    i = 0.024099488*a0.x + -0.04376103*b0.x + -0.02405819*c0.x + 0.12269029*d0.x + -0.1942582*e0.x + 0.015290831*f0.x + -0.11447452*g0.x + -0.10286806*h0.x + 0.063465975*i0.x;
    j = -0.006165612*a0.y + 0.036118105*b0.y + -0.08798518*c0.y + 0.047540434*d0.y + -0.09047972*e0.y + -0.022543581*f0.y + -0.09121134*g0.y + 0.07566583*h0.y + 0.13097523*i0.y;
    k = -0.027949635*a0.z + 0.007452225*b0.z + 0.07362078*c0.z + -0.15921377*d0.z + 0.14054917*e0.z + -0.039097846*f0.z + -0.036522493*g0.z + -0.03235028*h0.z + -0.07254958*i0.z;
    l = -0.06354746*a0.w + 0.0061436766*b0.w + 0.054778658*c0.w + 0.048113804*d0.w + 0.2520769*e0.w + 0.032121573*f0.w + 0.11395284*g0.w + 0.053529907*h0.w + -0.07020516*i0.w;
    m = -0.004473757*a1.x + -0.03699893*b1.x + 0.049494844*c1.x + 0.10144713*d1.x + -0.10123659*e1.x + -0.055154715*f1.x + -0.005653055*g1.x + -0.110076346*h1.x + 0.024537917*i1.x;
    n = -0.14722843*a1.y + 0.021588054*b1.y + -0.06555156*c1.y + -0.1452367*d1.y + 0.12776113*e1.y + -0.054516274*f1.y + 0.09456384*g1.y + -0.019024763*h1.y + -0.13002178*i1.y;
    o = -0.15221575*a1.z + -0.03642865*b1.z + 0.09059142*c1.z + 0.010224373*d1.z + 0.03270087*e1.z + 0.04611254*f1.z + 0.14100742*g1.z + -0.12469271*h1.z + -0.07808319*i1.z;
    p = -0.15530752*a1.w + -0.024299711*b1.w + 0.043005124*c1.w + -0.14870381*d1.w + -0.08807392*e1.w + -0.1681088*f1.w + 0.11866316*g1.w + 0.0023098018*h1.w + -0.11600331*i1.w;
    q = -0.030142544*na0.x + -0.023051897*nb0.x + 0.00072538806*nc0.x + -0.1408511*nd0.x + 0.24454293*ne0.x + 0.053074066*nf0.x + 0.05282571*ng0.x + 0.08888112*nh0.x + -0.008027229*ni0.x;
    r = -0.21948075*na0.y + -0.14563307*nb0.y + 0.045105882*nc0.y + 0.034859292*nd0.y + 0.0013962422*ne0.y + -0.14472541*nf0.y + 0.057272803*ng0.y + -0.2343438*nh0.y + 0.027103126*ni0.y;
    s = 0.056929775*na0.z + -0.04044756*nb0.z + -0.021619841*nc0.z + 0.093900874*nd0.z + -0.0845011*ne0.z + 0.015461744*nf0.z + 0.10533744*ng0.z + -0.12869626*nh0.z + 0.029572072*ni0.z;
    t = 0.054964267*na0.w + -0.052984565*nb0.w + -0.005397013*nc0.w + -0.0025362761*nd0.w + -0.11459516*ne0.w + -0.019547295*nf0.w + 0.033938434*ng0.w + -0.15661421*nh0.w + -0.005126746*ni0.w;
    u = -0.09801664*na1.x + 0.03373932*nb1.x + -0.013610346*nc1.x + -0.097029574*nd1.x + -0.025516622*ne1.x + -0.007453025*nf1.x + 0.15229116*ng1.x + -0.051520813*nh1.x + -0.02699927*ni1.x;
    v = 0.069439575*na1.y + 0.04628353*nb1.y + 0.0040131556*nc1.y + 0.02876258*nd1.y + -0.16168404*ne1.y + -0.019609036*nf1.y + -0.10225833*ng1.y + -0.0046634357*nh1.y + 0.01479129*ni1.y;
    w = 0.1177245*na1.z + 0.058011517*nb1.z + -0.01947146*nc1.z + -0.09292472*nd1.z + 0.34092692*ne1.z + -0.015576386*nf1.z + 0.038489033*ng1.z + 0.3955167*nh1.z + 0.012101536*ni1.z;
    x = 0.045038175*na1.w + -0.022596413*nb1.w + -0.03933641*nc1.w + 0.080800526*nd1.w + -0.02215942*ne1.w + -0.024267819*nf1.w + -0.035784304*ng1.w + -0.087287374*nh1.w + -0.02052485*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.00032290322;
    i = 0.070857085*a0.x + -0.01668739*b0.x + -0.043324713*c0.x + -0.06547115*d0.x + 0.11349051*e0.x + -0.005361818*f0.x + -0.111147895*g0.x + 0.08678277*h0.x + -0.0183157*i0.x;
    j = 0.11876117*a0.y + -0.2199258*b0.y + -0.1539111*c0.y + -0.28561905*d0.y + -0.11965133*e0.y + 0.111326285*f0.y + -0.025783801*g0.y + 0.040516805*h0.y + -0.06974189*i0.y;
    k = 0.006097977*a0.z + -0.03751161*b0.z + -0.053452376*c0.z + -0.21998845*d0.z + -0.5963481*e0.z + 0.13975018*f0.z + 0.02308284*g0.z + 0.09210324*h0.z + 0.022642707*i0.z;
    l = -0.06739223*a0.w + -0.2233416*b0.w + -0.020142328*c0.w + 0.015575219*d0.w + -0.13870761*e0.w + -0.019826427*f0.w + -0.024176579*g0.w + -0.021784797*h0.w + 0.010930772*i0.w;
    m = -0.05648233*a1.x + 0.055072162*b1.x + -0.050247695*c1.x + 0.14057279*d1.x + -0.3961134*e1.x + 0.24045974*f1.x + 0.04301311*g1.x + 0.3693387*h1.x + -0.06275665*i1.x;
    n = -0.08295624*a1.y + 0.064236194*b1.y + -0.10241233*c1.y + 0.050927226*d1.y + -0.383068*e1.y + -0.050085917*f1.y + 0.034017723*g1.y + 0.019846056*h1.y + -0.021734528*i1.y;
    o = -0.00295437*a1.z + 0.13545579*b1.z + 0.06447699*c1.z + 0.07401292*d1.z + -0.33343366*e1.z + 0.013114421*f1.z + 0.022527028*g1.z + 0.024657745*h1.z + 0.0600506*i1.z;
    p = -0.18444572*a1.w + 0.17483403*b1.w + 0.0592025*c1.w + 0.22725746*d1.w + -0.18361235*e1.w + 0.016755791*f1.w + -0.14157054*g1.w + 0.2188402*h1.w + 0.04028393*i1.w;
    q = -0.06708157*na0.x + -0.12640335*nb0.x + 0.09772259*nc0.x + 0.059448905*nd0.x + -0.06731923*ne0.x + -0.0049867667*nf0.x + -0.040434554*ng0.x + 0.031092996*nh0.x + -0.031176891*ni0.x;
    r = 0.07233832*na0.y + -0.08197527*nb0.y + 0.23841408*nc0.y + 0.21141063*nd0.y + -0.54487336*ne0.y + 0.043145727*nf0.y + 0.057069533*ng0.y + 0.046939872*nh0.y + -0.018745638*ni0.y;
    s = 0.063471414*na0.z + 0.06705344*nb0.z + 0.06628736*nc0.z + 0.059250414*nd0.z + 0.47430512*ne0.z + 0.07250447*nf0.z + 0.06917669*ng0.z + 0.025787285*nh0.z + -0.0953519*ni0.z;
    t = -0.05104128*na0.w + 0.010402208*nb0.w + 0.04540505*nc0.w + 0.124114424*nd0.w + 0.12031291*ne0.w + -0.04741522*nf0.w + 0.0006948206*ng0.w + 0.020641474*nh0.w + -0.054883998*ni0.w;
    u = -0.04498074*na1.x + 0.15552297*nb1.x + 0.018448073*nc1.x + 0.15998206*nd1.x + -0.029625095*ne1.x + -0.06423182*nf1.x + -0.026536018*ng1.x + -0.12014951*nh1.x + -0.03999141*ni1.x;
    v = -0.056055978*na1.y + -0.020384263*nb1.y + -0.040418874*nc1.y + -0.11311765*nd1.y + 0.075490616*ne1.y + 0.052754566*nf1.y + 0.06173458*ng1.y + -0.04975295*nh1.y + 0.02391373*ni1.y;
    w = -0.004391017*na1.z + -0.19458464*nb1.z + -0.06401953*nc1.z + 0.09041939*nd1.z + 0.18180522*ne1.z + 0.06055868*nf1.z + -0.04002065*ng1.z + 0.01991273*nh1.z + -0.012687855*ni1.z;
    x = -0.030503593*na1.w + -0.04218965*nb1.w + -0.029646637*nc1.w + 0.118616536*nd1.w + -0.20543875*ne1.w + 0.12086292*nf1.w + -0.16321474*ng1.w + 0.077902816*nh1.w + -0.10479198*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.009935257;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN110
//!BIND LUMAN111
//!SAVE LUMAN121

#define L0_tex LUMAN110_tex
#define L1_tex LUMAN111_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.016040666*a0.x + -0.079013824*b0.x + 0.012161549*c0.x + -0.18754423*d0.x + 0.10386809*e0.x + -0.05148479*f0.x + -0.021997137*g0.x + -0.08336444*h0.x + 0.067358404*i0.x;
    float j = 0.10831344*a0.y + 0.044687204*b0.y + 0.020710824*c0.y + -0.058832403*d0.y + 0.40822786*e0.y + 0.041033354*f0.y + -0.094072744*g0.y + 0.114720725*h0.y + -0.10669224*i0.y;
    float k = -0.0904427*a0.z + -0.11462908*b0.z + 0.12511547*c0.z + -0.109776616*d0.z + -0.7715242*e0.z + 0.24116163*f0.z + 0.061702237*g0.z + -0.33219382*h0.z + 0.014017773*i0.z;
    float l = 0.05424565*a0.w + 0.032643985*b0.w + -0.019493097*c0.w + 0.27252126*d0.w + -0.27409044*e0.w + 0.20315622*f0.w + 0.10155818*g0.w + -0.06734094*h0.w + -0.052686546*i0.w;
    float m = -0.10103298*a1.x + -0.086472794*b1.x + 0.071667865*c1.x + -0.1433287*d1.x + -0.17060891*e1.x + 0.30879197*f1.x + -0.028106824*g1.x + -0.10957076*h1.x + -0.14003031*i1.x;
    float n = 0.037159156*a1.y + -0.09297984*b1.y + 0.10879765*c1.y + 0.4043785*d1.y + -0.011262256*e1.y + 0.16364406*f1.y + 0.060078543*g1.y + -0.06293068*h1.y + 0.005272298*i1.y;
    float o = 0.05688141*a1.z + -0.036100924*b1.z + 0.020668587*c1.z + 0.21269542*d1.z + -0.8095734*e1.z + 0.030226132*f1.z + -0.006395501*g1.z + -0.085511655*h1.z + 0.06279881*i1.z;
    float p = 0.07261218*a1.w + 0.02863619*b1.w + -0.16154937*c1.w + 0.19046474*d1.w + -0.47981185*e1.w + 0.22103396*f1.w + 0.14944506*g1.w + -0.51756424*h1.w + 0.04801966*i1.w;
    float q = 0.053131744*na0.x + 0.10765578*nb0.x + -0.022114653*nc0.x + 0.36228356*nd0.x + -0.40098524*ne0.x + 0.028483007*nf0.x + -0.04952111*ng0.x + 0.0701001*nh0.x + -0.04002665*ni0.x;
    float r = -0.21960498*na0.y + -0.5954419*nb0.y + 0.017739328*nc0.y + 0.17854628*nd0.y + -0.568993*ne0.y + 1.2022981e-05*nf0.y + -0.014976303*ng0.y + -0.14732927*nh0.y + -0.037275933*ni0.y;
    float s = 0.013482193*na0.z + 0.2103902*nb0.z + -0.15309614*nc0.z + 0.020884098*nd0.z + 0.5714031*ne0.z + -0.07772716*nf0.z + -0.040384546*ng0.z + 0.23391339*nh0.z + -0.002278687*ni0.z;
    float t = -0.1575747*na0.w + 0.082207*nb0.w + -0.054898545*nc0.w + -0.21570413*nd0.w + -0.12128415*ne0.w + -0.03145261*nf0.w + 0.027723502*ng0.w + -0.009790279*nh0.w + -0.024533553*ni0.w;
    float u = 0.09017486*na1.x + 0.048559707*nb1.x + 0.050434425*nc1.x + 0.22550671*nd1.x + 0.057977412*ne1.x + -0.23715238*nf1.x + 0.1749362*ng1.x + -0.16195343*nh1.x + 0.044198424*ni1.x;
    float v = -0.016162207*na1.y + 0.08958053*nb1.y + -0.039311912*nc1.y + -0.36521596*nd1.y + 0.00661652*ne1.y + -0.06413147*nf1.y + -0.034688678*ng1.y + 0.01979752*nh1.y + -0.062167786*ni1.y;
    float w = -0.03062324*na1.z + -0.09115997*nb1.z + -0.14492631*nc1.z + 0.06484779*nd1.z + 0.28366563*ne1.z + 0.21266897*nf1.z + 0.17541467*ng1.z + 0.05103093*nh1.z + -0.111022934*ni1.z;
    float x = -0.037943065*na1.w + 0.115353756*nb1.w + -0.029521808*nc1.w + -0.09523847*nd1.w + 0.18609662*ne1.w + -0.14930874*nf1.w + -0.13944234*ng1.w + 0.4082743*nh1.w + -0.06819748*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.017916761;
    i = 0.078538805*a0.x + -0.014506211*b0.x + 0.007213099*c0.x + 0.23117511*d0.x + 0.5029679*e0.x + -0.024810337*f0.x + -0.11901346*g0.x + 0.37581027*h0.x + 0.04474014*i0.x;
    j = -0.24559873*a0.y + -0.031275712*b0.y + -0.027128898*c0.y + -0.27093834*d0.y + 0.30001357*e0.y + 0.29637352*f0.y + -0.0680391*g0.y + -0.2771114*h0.y + -0.19408922*i0.y;
    k = 0.14039402*a0.z + -0.068264335*b0.z + -0.01212566*c0.z + -0.21079351*d0.z + 0.055527776*e0.z + 0.07600091*f0.z + 0.030332029*g0.z + 0.020096777*h0.z + -0.0050814818*i0.z;
    l = -0.009181755*a0.w + 0.12588453*b0.w + -0.0070843413*c0.w + -0.14150868*d0.w + 0.2352925*e0.w + 0.18276747*f0.w + -0.1489265*g0.w + -0.17832929*h0.w + 0.110232346*i0.w;
    m = -0.11440625*a1.x + 0.08030438*b1.x + -0.05019389*c1.x + 0.055185206*d1.x + -0.1997354*e1.x + 0.06907418*f1.x + -0.030523853*g1.x + -0.028598374*h1.x + 0.00402331*i1.x;
    n = -0.01400436*a1.y + -0.24602963*b1.y + -0.02763552*c1.y + 0.09377703*d1.y + 0.46817556*e1.y + 0.0045891483*f1.y + -0.022928033*g1.y + -0.18903275*h1.y + -0.057461683*i1.y;
    o = 5.8573256e-05*a1.z + -0.11550677*b1.z + -0.021250665*c1.z + 0.12628284*d1.z + 0.100589834*e1.z + -0.043524556*f1.z + -0.010048345*g1.z + -0.015392035*h1.z + -0.027857235*i1.z;
    p = -0.13938811*a1.w + -0.21711211*b1.w + -0.058005977*c1.w + 0.23330635*d1.w + 0.4241299*e1.w + 0.269014*f1.w + -0.024776803*g1.w + -0.47112796*h1.w + -0.3242568*i1.w;
    q = -0.006770948*na0.x + 0.35251966*nb0.x + -0.025183031*nc0.x + 0.06321988*nd0.x + -0.41219017*ne0.x + 0.15581898*nf0.x + -0.004353107*ng0.x + -0.51320714*nh0.x + -0.012421451*ni0.x;
    r = 0.053276803*na0.y + 0.209102*nb0.y + -0.25939527*nc0.y + 0.2583048*nd0.y + -0.034931976*ne0.y + -0.16499095*nf0.y + 0.013150661*ng0.y + 0.06966307*nh0.y + 0.2715032*ni0.y;
    s = 0.034249242*na0.z + 0.1393413*nb0.z + 0.027955504*nc0.z + 0.014944762*nd0.z + -0.27539375*ne0.z + 0.059065677*nf0.z + 0.12535436*ng0.z + 0.0002367743*nh0.z + -0.03134692*ni0.z;
    t = 0.09574407*na0.w + -0.15512376*nb0.w + -0.1326283*nc0.w + 0.14824554*nd0.w + -0.48301983*ne0.w + -0.23208317*nf0.w + 0.04110218*ng0.w + 0.37239522*nh0.w + 0.054267284*ni0.w;
    u = -0.0373547*na1.x + -0.02183789*nb1.x + 0.09611865*nc1.x + 0.15454161*nd1.x + 0.15370527*ne1.x + -0.27192718*nf1.x + 0.037774384*ng1.x + -0.16705795*nh1.x + 0.06983236*ni1.x;
    v = -0.07095513*na1.y + 0.24687336*nb1.y + 0.0107697025*nc1.y + -0.0119912075*nd1.y + -0.5358361*ne1.y + 0.006414817*nf1.y + -0.00023970919*ng1.y + 0.17173849*nh1.y + 0.036765322*ni1.y;
    w = -0.085393295*na1.z + 0.1269853*nb1.z + -0.13470225*nc1.z + -0.01905929*nd1.z + -0.21131584*ne1.z + 0.24164923*nf1.z + -0.10498182*ng1.z + 0.23248348*nh1.z + -0.11942628*ni1.z;
    x = -0.06611594*na1.w + -0.22679096*nb1.w + 0.07775526*nc1.w + 0.04741113*nd1.w + -0.16081128*ne1.w + -0.015265322*nf1.w + -0.1981768*ng1.w + 0.121538855*nh1.w + -0.040517036*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0011177635;
    i = 0.02273682*a0.x + -0.088348575*b0.x + -0.08505771*c0.x + 0.11942239*d0.x + 0.030293586*e0.x + -0.036713593*f0.x + -0.07345445*g0.x + 0.013857765*h0.x + 0.0212622*i0.x;
    j = 0.0007158205*a0.y + -0.18034282*b0.y + -0.1834693*c0.y + 0.07001304*d0.y + 0.052562915*e0.y + -0.13766013*f0.y + -0.026889255*g0.y + -0.13756591*h0.y + 0.0137952035*i0.y;
    k = 0.064204454*a0.z + 0.047363076*b0.z + -0.10146915*c0.z + -0.036393903*d0.z + 0.32186893*e0.z + 0.03890354*f0.z + -0.11350703*g0.z + 0.17804417*h0.z + -0.018982997*i0.z;
    l = -0.25930753*a0.w + -0.18717201*b0.w + 0.0046631163*c0.w + -0.16714166*d0.w + 0.19198583*e0.w + -0.13205843*f0.w + -0.043268327*g0.w + -0.1133368*h0.w + -0.019991325*i0.w;
    m = 0.046559814*a1.x + -0.036047865*b1.x + -0.124785714*c1.x + 0.19851595*d1.x + 0.13792649*e1.x + 0.29890996*f1.x + 0.07801649*g1.x + 0.3574968*h1.x + -0.051048357*i1.x;
    n = -0.22643399*a1.y + 0.09982359*b1.y + -0.25325596*c1.y + -0.30298874*d1.y + -0.019899191*e1.y + -0.17703082*f1.y + -0.06602016*g1.y + 0.11570044*h1.y + -0.12564936*i1.y;
    o = -0.1295181*a1.z + 0.28571597*b1.z + 0.2268508*c1.z + -0.024426803*d1.z + 0.34369537*e1.z + -0.03543822*f1.z + 0.05623628*g1.z + 0.15945889*h1.z + 0.1357874*i1.z;
    p = -0.38786048*a1.w + 0.021101061*b1.w + 0.08719239*c1.w + -0.42795762*d1.w + -0.78074217*e1.w + -0.25849733*f1.w + 0.02313279*g1.w + 0.31115445*h1.w + -0.071271494*i1.w;
    q = -0.14247255*na0.x + -0.10166665*nb0.x + 0.103710435*nc0.x + -0.24971257*nd0.x + 0.10551559*ne0.x + -0.00049025*nf0.x + 0.006096725*ng0.x + 0.16235337*nh0.x + -0.04087*ni0.x;
    r = 0.086958386*na0.y + 0.10708686*nb0.y + 0.3118142*nc0.y + 0.07566404*nd0.y + 0.17142205*ne0.y + 0.22888596*nf0.y + 0.0071828454*ng0.y + 0.08257271*nh0.y + 0.15891534*ni0.y;
    s = 0.05018579*na0.z + -0.07106771*nb0.z + 0.12580445*nc0.z + 0.060565155*nd0.z + -0.61150587*ne0.z + 0.14322163*nf0.z + 0.17771058*ng0.z + 0.04116199*nh0.z + -0.081307195*ni0.z;
    t = 0.10838823*na0.w + -0.03343494*nb0.w + 0.048816755*nc0.w + 0.13234074*nd0.w + 0.10686867*ne0.w + 0.09964101*nf0.w + 0.08175459*ng0.w + -0.06954629*nh0.w + -0.029273745*ni0.w;
    u = -0.20302375*na1.x + 0.08947134*nb1.x + 0.03863508*nc1.x + -0.25542068*nd1.x + -0.09526631*ne1.x + -0.15511604*nf1.x + -0.018706609*ng1.x + 0.05693273*nh1.x + -0.04958124*ni1.x;
    v = 0.08167861*na1.y + 0.024107322*nb1.y + -0.017528*nc1.y + 0.12498806*nd1.y + -0.026749128*ne1.y + 0.04120715*nf1.y + 0.04201204*ng1.y + -0.07951507*nh1.y + 0.042167943*ni1.y;
    w = 0.12541983*na1.z + -0.18357356*nb1.z + -0.13145879*nc1.z + -0.11632926*nd1.z + -0.09411829*ne1.z + -0.01572608*nf1.z + -0.0408734*ng1.z + 0.0049628583*nh1.z + -0.098303616*ni1.z;
    x = 0.12511753*na1.w + -0.05077767*nb1.w + -0.03821508*nc1.w + 0.24773093*nd1.w + -0.35870612*ne1.w + 0.2990459*nf1.w + 0.09982773*ng1.w + -0.20098032*nh1.w + 0.05284909*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0033040443;
    i = -0.06944622*a0.x + -0.10423638*b0.x + 0.069951385*c0.x + 0.23499304*d0.x + -0.6945679*e0.x + 0.2103992*f0.x + 0.08824105*g0.x + -0.113604896*h0.x + -0.050930798*i0.x;
    j = -0.022496594*a0.y + 0.2566942*b0.y + -0.2720837*c0.y + 0.04151481*d0.y + 0.615091*e0.y + 0.031925738*f0.y + -0.01268215*g0.y + 0.13197616*h0.y + 0.057147793*i0.y;
    k = 0.023931816*a0.z + -0.060358107*b0.z + 0.13954204*c0.z + -0.00084565545*d0.z + 0.16548394*e0.z + -0.14032264*f0.z + -0.024453849*g0.z + -0.08643635*h0.z + 0.01871022*i0.z;
    l = 0.13153385*a0.w + -0.025538351*b0.w + -0.07633621*c0.w + -0.077443674*d0.w + 0.18425244*e0.w + -0.27681804*f0.w + -0.03891747*g0.w + 0.1728622*h0.w + 0.014027938*i0.w;
    m = -0.01709888*a1.x + -0.007245669*b1.x + -0.03169653*c1.x + -0.013408079*d1.x + -0.06904381*e1.x + -0.13671531*f1.x + 0.013620854*g1.x + -0.028004795*h1.x + 0.012526964*i1.x;
    n = 0.0021771193*a1.y + 0.008561536*b1.y + 0.097160086*c1.y + 0.14685316*d1.y + 0.087293826*e1.y + -0.15369013*f1.y + 0.0627115*g1.y + 0.05304755*h1.y + 0.067732826*i1.y;
    o = 0.032449223*a1.z + 0.22557947*b1.z + 0.1398121*c1.z + 0.10890622*d1.z + -0.25275087*e1.z + -0.010474938*f1.z + 0.0049850484*g1.z + -0.0447395*h1.z + -0.05385253*i1.z;
    p = -0.0591078*a1.w + 0.3782494*b1.w + 0.15983337*c1.w + 0.0970239*d1.w + 0.69504625*e1.w + -0.008993506*f1.w + -0.13960648*g1.w + -0.09371603*h1.w + 0.1152446*i1.w;
    q = 0.05103658*na0.x + 0.17705862*nb0.x + -0.07009867*nc0.x + -0.04754582*nd0.x + 0.5219954*ne0.x + -0.1565835*nf0.x + -0.0675379*ng0.x + 0.103392586*nh0.x + 0.04235708*ni0.x;
    r = -0.23430078*na0.y + -0.64712304*nb0.y + 0.12920478*nc0.y + -0.054820143*nd0.y + -0.97405654*ne0.y + -0.30315155*nf0.y + -0.016655972*ng0.y + -0.03896125*nh0.y + -0.173349*ni0.y;
    s = 0.05556909*na0.z + 0.053752027*nb0.z + -0.036756348*nc0.z + -0.0490644*nd0.z + 0.071526386*ne0.z + 0.068898395*nf0.z + -0.01937113*ng0.z + -0.0062772087*nh0.z + 0.0061466885*ni0.z;
    t = -0.045044784*na0.w + -0.18968368*nb0.w + 0.16444425*nc0.w + -0.035680916*nd0.w + -0.4223159*ne0.w + 0.16560689*nf0.w + 0.04517244*ng0.w + -0.14496626*nh0.w + -0.032995377*ni0.w;
    u = -0.06689851*na1.x + 0.13716511*nb1.x + 0.005473301*nc1.x + 0.0002938986*nd1.x + 0.18790975*ne1.x + 0.08589993*nf1.x + -0.04463413*ng1.x + -0.056907386*nh1.x + 0.061555363*ni1.x;
    v = -0.0131601775*na1.y + 0.0031908813*nb1.y + -0.13029572*nc1.y + -0.0044121663*nd1.y + 0.033651654*ne1.y + 0.0380712*nf1.y + 0.009084121*ng1.y + -0.04157535*nh1.y + -0.097756535*ni1.y;
    w = -0.04474378*na1.z + -0.3508171*nb1.z + 0.021858547*nc1.z + -0.028869407*nd1.z + 0.24122404*ne1.z + -0.06238071*nf1.z + 0.022699818*ng1.z + 0.08334816*nh1.z + 0.100933604*ni1.z;
    x = 0.009949947*na1.w + -0.110267356*nb1.w + 0.028339155*nc1.w + 0.019174134*nd1.w + -0.24451639*ne1.w + -0.04752991*nf1.w + 0.055869248*ng1.w + -0.019406948*nh1.w + -0.10016147*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.013138915;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN120
//!BIND LUMAN121
//!SAVE LUMAN130

#define L0_tex LUMAN120_tex
#define L1_tex LUMAN121_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = 0.0720364*a0.x + 0.053900342*b0.x + -0.21529675*c0.x + -0.12641624*d0.x + 0.30030486*e0.x + 0.551456*f0.x + 0.27861387*g0.x + -0.2737028*h0.x + -0.13878943*i0.x;
    float j = -0.02189806*a0.y + 0.1282205*b0.y + -0.051351424*c0.y + -0.057394408*d0.y + -0.26498213*e0.y + 0.083696656*f0.y + 0.07437768*g0.y + -0.035797276*h0.y + 0.0072549833*i0.y;
    float k = 0.3213268*a0.z + -0.101973765*b0.z + 0.5751187*c0.z + 0.02748092*d0.z + 0.20441727*e0.z + -0.32831758*f0.z + 0.006279489*g0.z + 0.1129889*h0.z + -0.07455723*i0.z;
    float l = -0.20170602*a0.w + -0.029677728*b0.w + 0.21061352*c0.w + -0.03956498*d0.w + 1.1667198*e0.w + -0.35484713*f0.w + 0.13235599*g0.w + 0.279684*h0.w + -0.0017781351*i0.w;
    float m = 0.11718651*a1.x + -0.5752775*b1.x + -0.020617453*c1.x + 0.06882931*d1.x + 0.7212933*e1.x + 0.08547659*f1.x + -0.17777194*g1.x + -0.021172713*h1.x + -0.0023153338*i1.x;
    float n = -0.01634213*a1.y + 0.036722466*b1.y + 0.06310859*c1.y + 0.29112598*d1.y + -0.86670053*e1.y + 0.47648278*f1.y + 0.04528508*g1.y + 0.055748977*h1.y + -0.2048171*i1.y;
    float o = -0.19556583*a1.z + 0.36164042*b1.z + -0.09667081*c1.z + 0.21346582*d1.z + -0.4927472*e1.z + 0.12774333*f1.z + 0.010652053*g1.z + -0.038168952*h1.z + -0.03643873*i1.z;
    float p = 0.10009163*a1.w + 0.038237605*b1.w + -0.20403148*c1.w + -0.020671103*d1.w + -0.38168794*e1.w + 0.17990908*f1.w + -0.051244512*g1.w + 0.084622525*h1.w + -0.027635513*i1.w;
    float q = -0.10643615*na0.x + 0.25769755*nb0.x + -0.03955322*nc0.x + -0.042580277*nd0.x + -0.08685573*ne0.x + 0.05128617*nf0.x + -0.024551174*ng0.x + -0.1028651*nh0.x + -0.030856699*ni0.x;
    float r = -0.0027716025*na0.y + 0.07249121*nb0.y + -0.13051115*nc0.y + -0.20297952*nd0.y + -0.41265818*ne0.y + -0.26338387*nf0.y + 0.015494835*ng0.y + 0.17138383*nh0.y + -0.041941557*ni0.y;
    float s = -0.05208767*na0.z + 0.19243212*nb0.z + 0.03244124*nc0.z + 0.05880827*nd0.z + 0.049452126*ne0.z + -0.036401723*nf0.z + 0.060772587*ng0.z + -0.020842567*nh0.z + 0.03108091*ni0.z;
    float t = 0.060901362*na0.w + -0.076049685*nb0.w + -0.048797954*nc0.w + -0.09112989*nd0.w + -0.19524314*ne0.w + -0.1572243*nf0.w + 0.10201878*ng0.w + -0.16085689*nh0.w + -0.04018849*ni0.w;
    float u = -0.19130763*na1.x + 0.08725573*nb1.x + 0.029222598*nc1.x + 0.18555334*nd1.x + 0.022093318*ne1.x + -0.02745416*nf1.x + -0.105766304*ng1.x + 0.12067458*nh1.x + -0.04069638*ni1.x;
    float v = -0.029775381*na1.y + 0.032387253*nb1.y + 0.03466246*nc1.y + 0.02369626*nd1.y + -0.16729066*ne1.y + -0.020458123*nf1.y + -0.01582285*ng1.y + -0.07273139*nh1.y + 0.040606122*ni1.y;
    float w = 0.06475696*na1.z + -0.16653204*nb1.z + -0.0077233436*nc1.z + 0.10893418*nd1.z + 0.65086246*ne1.z + -0.098068416*nf1.z + -0.0773279*ng1.z + 0.089927696*nh1.z + -0.02523359*ni1.z;
    float x = -0.12416535*na1.w + -0.09939505*nb1.w + 0.055258464*nc1.w + 0.07517963*nd1.w + 0.7682969*ne1.w + -0.16346167*nf1.w + -0.116884045*ng1.w + -0.19306831*nh1.w + 0.21045157*ni1.w;
    float o0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.014230527;
    i = 0.042195965*a0.x + 0.06986607*b0.x + -0.24697801*c0.x + 0.04542666*d0.x + 0.27491724*e0.x + 0.10283969*f0.x + -0.108544946*g0.x + 0.09708539*h0.x + 0.076082796*i0.x;
    j = -0.011562874*a0.y + -0.023208117*b0.y + -0.026359199*c0.y + 0.055193163*d0.y + 0.3459738*e0.y + 0.011495178*f0.y + -0.0134636685*g0.y + -0.03179513*h0.y + -0.042669583*i0.y;
    k = -0.21953447*a0.z + -0.04466294*b0.z + -0.020435272*c0.z + -0.025197655*d0.z + 0.21284917*e0.z + -0.36867225*f0.z + 0.029473593*g0.z + 0.069737464*h0.z + -0.2412335*i0.z;
    l = -0.0886459*a0.w + 4.3053482e-05*b0.w + 0.11051342*c0.w + 0.018638419*d0.w + -0.24568723*e0.w + 0.17777503*f0.w + 0.06575594*g0.w + 0.25569072*h0.w + -0.101264775*i0.w;
    m = 0.04524546*a1.x + -0.4179094*b1.x + 0.24467756*c1.x + 0.22226599*d1.x + -0.7805491*e1.x + 0.055788055*f1.x + 0.23372273*g1.x + -0.5262877*h1.x + -0.017132355*i1.x;
    n = -0.04794995*a1.y + 0.1435481*b1.y + -0.087677024*c1.y + 0.15902305*d1.y + -0.1106174*e1.y + 0.15267508*f1.y + -0.05356673*g1.y + 0.027613819*h1.y + -0.008245554*i1.y;
    o = 0.04367896*a1.z + -0.1107194*b1.z + 0.053921375*c1.z + 0.017062154*d1.z + -0.022771189*e1.z + 0.1649813*f1.z + 0.0182314*g1.z + -0.18771137*h1.z + 0.12790245*i1.z;
    p = -0.12690932*a1.w + 0.25788826*b1.w + -0.10910936*c1.w + 0.22243069*d1.w + 0.1625307*e1.w + 0.15770349*f1.w + -0.042958364*g1.w + -0.09920023*h1.w + 0.13091087*i1.w;
    q = 0.10414487*na0.x + -0.17305346*nb0.x + -0.06085659*nc0.x + 0.065868944*nd0.x + -0.09042784*ne0.x + 0.204011*nf0.x + -0.024687342*ng0.x + -0.059094653*nh0.x + 0.04609744*ni0.x;
    r = -0.056715347*na0.y + 0.057856467*nb0.y + 0.024845932*nc0.y + -0.08401126*nd0.y + -0.14726245*ne0.y + -0.025106642*nf0.y + 0.020385504*ng0.y + 0.082516894*nh0.y + 0.028151123*ni0.y;
    s = -0.20315938*na0.z + 0.362484*nb0.z + 0.014427934*nc0.z + -0.027487164*nd0.z + 0.08667763*ne0.z + 0.04351746*nf0.z + -0.004871366*ng0.z + -0.046117496*nh0.z + -0.037482645*ni0.z;
    t = 0.043089945*na0.w + 0.047222134*nb0.w + 0.0950088*nc0.w + 0.16747418*nd0.w + -0.10982015*ne0.w + 0.15402111*nf0.w + -0.1335398*ng0.w + -0.11832875*nh0.w + 0.026953021*ni0.w;
    u = 0.00231662*na1.x + -0.12017328*nb1.x + -0.04228793*nc1.x + 0.02145167*nd1.x + 0.5365495*ne1.x + 0.0565665*nf1.x + 0.13905151*ng1.x + 0.06894558*nh1.x + -0.02964981*ni1.x;
    v = -0.09530613*na1.y + 0.04113546*nb1.y + -0.024054382*nc1.y + 0.058662873*nd1.y + 0.20826623*ne1.y + -0.10249503*nf1.y + -0.01461215*ng1.y + -0.02553676*nh1.y + -0.049127422*ni1.y;
    w = 0.08890218*na1.z + -0.24309717*nb1.z + -0.056736678*nc1.z + 0.025733534*nd1.z + -0.30327016*ne1.z + -0.14851654*nf1.z + 0.035958145*ng1.z + -0.20333517*nh1.z + 0.12468914*ni1.z;
    x = -0.011648334*na1.w + 0.07754441*nb1.w + -0.013317935*nc1.w + 0.14822938*nd1.w + -0.5553622*ne1.w + -0.051771417*nf1.w + 0.05677903*ng1.w + -0.4363098*nh1.w + 0.21202224*ni1.w;
    float p0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.02925727;
    i = -0.05948352*a0.x + -0.06827033*b0.x + -0.05872591*c0.x + -0.16184679*d0.x + -0.32632825*e0.x + 0.13031824*f0.x + -0.06273351*g0.x + 0.0751629*h0.x + -0.018216845*i0.x;
    j = -0.0031350395*a0.y + -0.1708727*b0.y + 0.013089089*c0.y + 0.05907608*d0.y + 0.31262067*e0.y + -0.073811896*f0.y + -0.07709014*g0.y + 0.1276176*h0.y + 0.0058660284*i0.y;
    k = -0.24557771*a0.z + 0.16375028*b0.z + -0.22536363*c0.z + 0.07369996*d0.z + -0.057278607*e0.z + -0.39154586*f0.z + -0.04884829*g0.z + -0.1366349*h0.z + 0.24759868*i0.z;
    l = 0.10663502*a0.w + -0.12446211*b0.w + 0.1506388*c0.w + -0.01982975*d0.w + 0.20480362*e0.w + -0.41742992*f0.w + 0.049913086*g0.w + -0.1817123*h0.w + 0.22587766*i0.w;
    m = -0.061524637*a1.x + 0.022391686*b1.x + 0.038758367*c1.x + 0.00053620304*d1.x + -0.5066745*e1.x + 0.18239973*f1.x + -0.09501334*g1.x + 0.20157869*h1.x + -0.13881125*i1.x;
    n = -0.12882727*a1.y + 0.20879474*b1.y + -0.00059160107*c1.y + -0.014318971*d1.y + -0.5696044*e1.y + -0.35852292*f1.y + -0.03647296*g1.y + -0.06009444*h1.y + 0.15110119*i1.y;
    o = 0.12342001*a1.z + -0.18652305*b1.z + -0.0014908996*c1.z + -0.10899112*d1.z + -0.017930519*e1.z + 0.18477388*f1.z + -0.13977689*g1.z + 0.070096254*h1.z + -0.03545615*i1.z;
    p = -0.086738124*a1.w + 0.15161462*b1.w + 0.10906371*c1.w + 0.2625266*d1.w + -0.269705*e1.w + 0.025931107*f1.w + -0.11208182*g1.w + 0.08186576*h1.w + -0.07676666*i1.w;
    q = 0.09199121*na0.x + -0.27253303*nb0.x + 0.0879107*nc0.x + -0.02903099*nd0.x + 0.18778248*ne0.x + -0.03874832*nf0.x + 0.11142419*ng0.x + -0.023944143*nh0.x + 0.0322812*ni0.x;
    r = -0.05937444*na0.y + 0.11862651*nb0.y + 0.07161282*nc0.y + 0.25135022*nd0.y + -0.88968176*ne0.y + 0.118918404*nf0.y + -0.01776999*ng0.y + -0.327005*nh0.y + 0.05625477*ni0.y;
    s = 0.055206*na0.z + 0.12737331*nb0.z + -0.03233187*nc0.z + 0.023461618*nd0.z + -0.55450785*ne0.z + 0.100796655*nf0.z + -0.050018337*ng0.z + -0.0022815724*nh0.z + -0.014608387*ni0.z;
    t = -0.0479968*na0.w + 0.24388584*nb0.w + -0.1321874*nc0.w + -0.07816068*nd0.w + -0.18306968*ne0.w + 0.39243156*nf0.w + -0.07366988*ng0.w + 0.06475454*nh0.w + -0.06459748*ni0.w;
    u = 0.15943104*na1.x + -0.1733297*nb1.x + 0.05210581*nc1.x + -0.11547031*nd1.x + 0.4288051*ne1.x + -0.20570897*nf1.x + 0.058616944*ng1.x + -0.06744855*nh1.x + 0.10000475*ni1.x;
    v = -0.006472779*na1.y + -0.0043406556*nb1.y + 0.013603341*nc1.y + 0.061792597*nd1.y + 0.16454408*ne1.y + -0.016365727*nf1.y + 0.030575326*ng1.y + 0.021532707*nh1.y + -0.0021026765*ni1.y;
    w = -0.041022096*na1.z + -0.09020705*nb1.z + 0.09366692*nc1.z + 0.029392594*nd1.z + -0.29391944*ne1.z + -0.37208745*nf1.z + -0.047162127*ng1.z + 0.024105158*nh1.z + 0.13907216*ni1.z;
    x = 0.048761297*na1.w + 0.02027834*nb1.w + -0.011769053*nc1.w + 0.13861202*nd1.w + -0.93677044*ne1.w + 0.13267428*nf1.w + -0.0030979784*ng1.w + 0.3423763*nh1.w + -0.06951905*ni1.w;
    float q0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.005624808;
    i = 0.13118735*a0.x + 0.07113565*b0.x + 0.16039217*c0.x + -0.40914395*d0.x + -1.1901436*e0.x + -0.80681556*f0.x + 0.17610377*g0.x + 0.29843616*h0.x + 0.020422373*i0.x;
    j = -0.049343202*a0.y + -0.0517756*b0.y + 0.050104957*c0.y + -0.014763915*d0.y + 0.4998198*e0.y + 0.096728146*f0.y + -0.051926754*g0.y + 0.011204003*h0.y + -0.042198427*i0.y;
    k = -0.08628184*a0.z + 0.06601232*b0.z + -0.107486784*c0.z + 0.05744938*d0.z + 0.1578089*e0.z + -0.051302865*f0.z + -0.08990291*g0.z + -0.09367884*h0.z + -0.07134853*i0.z;
    l = -0.02123226*a0.w + 0.13681176*b0.w + 0.046004575*c0.w + -0.021490892*d0.w + -0.35558495*e0.w + 0.6628715*f0.w + 0.08220385*g0.w + -0.04994965*h0.w + 0.005171286*i0.w;
    m = 0.07417716*a1.x + 0.14565495*b1.x + -0.0264066*c1.x + 0.032688186*d1.x + 0.12341635*e1.x + 0.018151537*f1.x + -0.18696725*g1.x + 0.33744487*h1.x + 0.061498195*i1.x;
    n = -0.24309224*a1.y + -0.17748205*b1.y + 0.016042624*c1.y + 0.112358056*d1.y + -0.24729848*e1.y + 0.03562591*f1.y + 0.017833492*g1.y + -0.17484981*h1.y + -0.25359344*i1.y;
    o = 0.043698203*a1.z + 0.04489889*b1.z + -0.073181756*c1.z + 0.11985575*d1.z + 0.22422*e1.z + -0.12087687*f1.z + -0.22577973*g1.z + 0.09884975*h1.z + 0.063056536*i1.z;
    p = -0.124570355*a1.w + 0.093162924*b1.w + 0.14458434*c1.w + 0.37257236*d1.w + -0.069118515*e1.w + -0.5091309*f1.w + -0.18350491*g1.w + -0.2106979*h1.w + 0.18569984*i1.w;
    q = -0.065402165*na0.x + -0.009163924*nb0.x + 0.18047854*nc0.x + -0.040900815*nd0.x + 0.6451143*ne0.x + 0.13821948*nf0.x + 0.14300165*ng0.x + 0.18637063*nh0.x + -0.15026084*ni0.x;
    r = -0.11006149*na0.y + 0.108389065*nb0.y + -0.05199778*nc0.y + 0.16926324*nd0.y + -0.25438145*ne0.y + -0.015659789*nf0.y + -0.01217484*ng0.y + -0.011138012*nh0.y + -0.06696381*ni0.y;
    s = 0.010872508*na0.z + 0.13563438*nb0.z + -0.055016384*nc0.z + 0.060038235*nd0.z + -0.20824054*ne0.z + 0.049065523*nf0.z + 0.017672228*ng0.z + -0.057060678*nh0.z + 0.016657824*ni0.z;
    t = 0.024448738*na0.w + 0.21845391*nb0.w + -0.1874952*nc0.w + -0.12823004*nd0.w + 0.0062414245*ne0.w + -0.13627508*nf0.w + 0.005506856*ng0.w + 0.20545638*nh0.w + 0.017150477*ni0.w;
    u = 0.0687205*na1.x + -0.08278135*nb1.x + 0.005573482*nc1.x + -0.10245802*nd1.x + 0.13818142*ne1.x + 0.1382157*nf1.x + -0.05744559*ng1.x + -0.008268709*nh1.x + -0.01924858*ni1.x;
    v = -0.088420264*na1.y + 0.013855669*nb1.y + -0.00802846*nc1.y + 0.037918523*nd1.y + 0.44768977*ne1.y + 0.08474023*nf1.y + 0.06538366*ng1.y + 0.08541458*nh1.y + 0.016029092*ni1.y;
    w = -0.040740877*na1.z + -0.097147815*nb1.z + -0.01924434*nc1.z + 0.049527176*nd1.z + 0.008897777*ne1.z + 0.1514258*nf1.z + -0.097710766*ng1.z + -0.14009525*nh1.z + -0.0010996665*ni1.z;
    x = -0.04477202*na1.w + 0.0044697854*nb1.w + -0.015193141*nc1.w + 0.26928583*nd1.w + 0.20772855*ne1.w + 0.0049727107*nf1.w + -0.09731218*ng1.w + 0.05057508*nh1.w + 0.17789689*ni1.w;
    float r0 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.018371338;
    return vec4(o0, p0, q0, r0);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-4x3x3x16
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!COMPONENTS 4
//!BIND LUMAN120
//!BIND LUMAN121
//!SAVE LUMAN131

#define L0_tex LUMAN120_tex
#define L1_tex LUMAN121_tex

vec4 hook() {
    vec2 dp = HOOKED_pt;

    vec4 a0 = L0_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b0 = L0_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c0 = L0_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d0 = L0_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e0 = L0_tex(HOOKED_pos + vec2(0, 0));
    vec4 f0 = L0_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g0 = L0_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h0 = L0_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i0 = L0_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na0 = -min(a0, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 nh0 = -min(h0, 0);
    vec4 ni0 = -min(i0, 0);

    a0 = max(a0, 0);
    b0 = max(b0, 0);
    c0 = max(c0, 0);
    d0 = max(d0, 0);
    e0 = max(e0, 0);
    f0 = max(f0, 0);
    g0 = max(g0, 0);
    h0 = max(h0, 0);
    i0 = max(i0, 0);

    vec4 a1 = L1_tex(HOOKED_pos + vec2(-dp.x, -dp.y));
    vec4 b1 = L1_tex(HOOKED_pos + vec2(-dp.x, 0));
    vec4 c1 = L1_tex(HOOKED_pos + vec2(-dp.x, dp.y));
    vec4 d1 = L1_tex(HOOKED_pos + vec2(0, -dp.y));
    vec4 e1 = L1_tex(HOOKED_pos + vec2(0, 0));
    vec4 f1 = L1_tex(HOOKED_pos + vec2(0, dp.y));
    vec4 g1 = L1_tex(HOOKED_pos + vec2(dp.x, -dp.y));
    vec4 h1 = L1_tex(HOOKED_pos + vec2(dp.x, 0));
    vec4 i1 = L1_tex(HOOKED_pos + vec2(dp.x, dp.y));

    vec4 na1 = -min(a1, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng1 = -min(g1, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni1 = -min(i1, 0);

    a1 = max(a1, 0);
    b1 = max(b1, 0);
    c1 = max(c1, 0);
    d1 = max(d1, 0);
    e1 = max(e1, 0);
    f1 = max(f1, 0);
    g1 = max(g1, 0);
    h1 = max(h1, 0);
    i1 = max(i1, 0);
    float i = -0.00244338*a0.x + 0.11307278*b0.x + 0.12787521*c0.x + -0.2943862*d0.x + -0.2921561*e0.x + 0.008935062*f0.x + 0.06479446*g0.x + 0.13043961*h0.x + -0.1714768*i0.x;
    float j = 0.013158007*a0.y + 0.0006180399*b0.y + 0.02082021*c0.y + -0.0055130427*d0.y + -0.35134313*e0.y + 0.015023051*f0.y + 0.074687675*g0.y + 0.0017952712*h0.y + 0.008813734*i0.y;
    float k = 0.36869514*a0.z + -0.3975647*b0.z + 0.09764463*c0.z + -0.35800827*d0.z + 0.41010195*e0.z + -0.5792003*f0.z + 0.15331651*g0.z + -0.36079472*h0.z + 0.49991408*i0.z;
    float l = -0.11267275*a0.w + 0.2564035*b0.w + -0.3156238*c0.w + 0.03255897*d0.w + -0.046007052*e0.w + 0.20846844*f0.w + 0.045643665*g0.w + -0.101280876*h0.w + 0.13227348*i0.w;
    float m = 0.104666136*a1.x + -0.44706202*b1.x + -0.120112754*c1.x + 0.33853054*d1.x + -0.3021414*e1.x + 0.05516387*f1.x + -0.22213428*g1.x + -0.1561559*h1.x + -0.049735755*i1.x;
    float n = -0.24272442*a1.y + 0.22630493*b1.y + -0.14520976*c1.y + 0.39483866*d1.y + -0.5144888*e1.y + 0.19356416*f1.y + -0.10334906*g1.y + 0.17973821*h1.y + -0.11484032*i1.y;
    float o = -0.09583847*a1.z + -0.1129651*b1.z + 0.012596975*c1.z + 0.08921078*d1.z + -0.10718446*e1.z + -0.059247594*f1.z + -0.26023668*g1.z + 0.2826532*h1.z + 0.010967167*i1.z;
    float p = -0.13766983*a1.w + -0.104451194*b1.w + 0.16943164*c1.w + 0.35144225*d1.w + -0.19897774*e1.w + -0.16400898*f1.w + -0.3423532*g1.w + 0.07869511*h1.w + 0.030806515*i1.w;
    float q = -0.006596797*na0.x + -0.059110187*nb0.x + 0.002848751*nc0.x + 0.17357026*nd0.x + -0.14421764*ne0.x + -0.06304003*nf0.x + 0.13224718*ng0.x + -0.023200989*nh0.x + -0.12691686*ni0.x;
    float r = 0.11914472*na0.y + -0.19565365*nb0.y + -0.000771549*nc0.y + -0.25671166*nd0.y + 0.20033528*ne0.y + 0.0735273*nf0.y + 0.13748841*ng0.y + -0.37766397*nh0.y + 0.12674737*ni0.y;
    float s = -0.1831876*na0.z + 0.066708036*nb0.z + 0.10256126*nc0.z + 0.15450269*nd0.z + -0.20681731*ne0.z + -0.015312072*nf0.z + 0.043404207*ng0.z + -0.19648848*nh0.z + 0.01756101*ni0.z;
    float t = 0.015516292*na0.w + 0.033659857*nb0.w + 0.11546558*nc0.w + 0.009801586*nd0.w + -0.17479457*ne0.w + 0.0348424*nf0.w + -0.013284617*ng0.w + 0.105703555*nh0.w + -0.04040842*ni0.w;
    float u = 0.044866323*na1.x + 0.037231002*nb1.x + -0.117976025*nc1.x + 0.0068701687*nd1.x + 0.10561169*ne1.x + 0.084872715*nf1.x + 0.0064239427*ng1.x + -0.03047784*nh1.x + 0.029405242*ni1.x;
    float v = -0.07337999*na1.y + -0.06394039*nb1.y + -0.046697747*nc1.y + 0.036859673*nd1.y + 0.13936268*ne1.y + -0.075560674*nf1.y + -0.15364087*ng1.y + -0.18054913*nh1.y + 0.11931447*ni1.y;
    float w = -0.05103358*na1.z + 0.08348278*nb1.z + -0.28102404*nc1.z + -0.21405233*nd1.z + -0.54452616*ne1.z + 0.25575173*nf1.z + -0.30355924*ng1.z + -0.1978982*nh1.z + -0.094412416*ni1.z;
    float x = -0.016140953*na1.w + 0.09675898*nb1.w + 0.14103526*nc1.w + 0.23741934*nd1.w + 0.63036114*ne1.w + -0.07908827*nf1.w + -0.17087603*ng1.w + 0.33402947*nh1.w + 0.056142833*ni1.w;
    float o1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.0011128266;
    i = 0.16161652*a0.x + 0.12943652*b0.x + -0.13306782*c0.x + 0.2013924*d0.x + -0.57761663*e0.x + -0.12975514*f0.x + 0.055114973*g0.x + -0.13329576*h0.x + -0.018094175*i0.x;
    j = -0.030814277*a0.y + 0.08002339*b0.y + -0.005033146*c0.y + -0.02831855*d0.y + -0.5265581*e0.y + 0.019913586*f0.y + 0.03260515*g0.y + 0.011793753*h0.y + -0.041797128*i0.y;
    k = -0.25511903*a0.z + 0.25464353*b0.z + 0.21382432*c0.z + 0.11112703*d0.z + 0.16102943*e0.z + 0.1905486*f0.z + -0.00034825585*g0.z + 0.14595897*h0.z + -0.4637904*i0.z;
    l = -0.08947852*a0.w + 0.07941216*b0.w + 0.20093243*c0.w + 0.092082925*d0.w + -0.21647456*e0.w + 0.12925042*f0.w + -0.01412983*g0.w + 0.24494526*h0.w + -0.183682*i0.w;
    m = 0.13686138*a1.x + 0.02519254*b1.x + 0.06689273*c1.x + -0.011823985*d1.x + 0.258628*e1.x + 0.007803134*f1.x + 0.19866021*g1.x + -0.25535232*h1.x + 0.119317554*i1.x;
    n = 0.0047901995*a1.y + -0.13939868*b1.y + 0.060697857*c1.y + 0.14214286*d1.y + -0.21600221*e1.y + 0.14889002*f1.y + 0.06126688*g1.y + -0.07895497*h1.y + -0.119672194*i1.y;
    o = -0.0138838105*a1.z + 0.12933673*b1.z + -0.03332595*c1.z + 0.07831325*d1.z + -0.059107892*e1.z + 0.005517338*f1.z + 0.2374747*g1.z + -0.30386606*h1.z + 0.04849136*i1.z;
    p = -0.09577165*a1.w + 0.23200892*b1.w + -0.17583735*c1.w + 0.017538643*d1.w + 0.06286067*e1.w + -0.012105216*f1.w + 0.19660373*g1.w + -0.17324452*h1.w + 0.2364622*i1.w;
    q = -0.06426943*na0.x + 0.04773957*nb0.x + 0.0773234*nc0.x + -0.09523922*nd0.x + 0.13199873*ne0.x + -0.025846584*nf0.x + -0.20022635*ng0.x + 0.061152507*nh0.x + 0.088116445*ni0.x;
    r = -0.11550139*na0.y + 0.25616938*nb0.y + -0.097736865*nc0.y + -0.13098818*nd0.y + 0.89877933*ne0.y + -0.12454773*nf0.y + -0.06655521*ng0.y + 0.3536072*nh0.y + -0.14577657*ni0.y;
    s = -0.051433016*na0.z + 0.19780602*nb0.z + -0.14342086*nc0.z + -0.13246888*nd0.z + 0.4712179*ne0.z + -0.0760168*nf0.z + -0.04112054*ng0.z + 0.079995714*nh0.z + -0.058594123*ni0.z;
    t = 0.0016922381*na0.w + 0.00911373*nb0.w + -0.07531611*nc0.w + 0.04930686*nd0.w + -0.1493241*ne0.w + -0.12848157*nf0.w + 0.08809475*ng0.w + -0.121985435*nh0.w + -0.03775289*ni0.w;
    u = -0.07355293*na1.x + -0.039990127*nb1.x + 0.047119513*nc1.x + -0.03806374*nd1.x + -0.4200097*ne1.x + 0.09158625*nf1.x + 0.0069479328*ng1.x + 0.0620529*nh1.x + -0.08495328*ni1.x;
    v = -0.075022444*na1.y + -0.0073552867*nb1.y + 0.03055895*nc1.y + 0.009506485*nd1.y + -0.1973273*ne1.y + 0.027589366*nf1.y + 0.012759572*ng1.y + 0.07665317*nh1.y + -0.098346196*ni1.y;
    w = 0.16676155*na1.z + -0.14621955*nb1.z + 0.024160169*nc1.z + 0.23157723*nd1.z + -0.19967304*ne1.z + 0.12788779*nf1.z + 0.09393534*ng1.z + 0.01697747*nh1.z + 0.041690193*ni1.z;
    x = -0.080800764*na1.w + -0.030657865*nb1.w + -0.02087746*nc1.w + 0.12705413*nd1.w + -0.20709507*ne1.w + 0.028442968*nf1.w + 0.12675458*ng1.w + -0.5194139*nh1.w + 0.030896883*ni1.w;
    float p1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+0.021323992;
    i = -0.08442577*a0.x + -0.16754927*b0.x + -0.03041835*c0.x + 0.16821916*d0.x + -0.18141311*e0.x + 0.25875506*f0.x + -0.18979077*g0.x + -0.17813158*h0.x + 0.07395593*i0.x;
    j = 0.018562902*a0.y + -0.048745874*b0.y + -0.0027680758*c0.y + 0.045562364*d0.y + 0.2797026*e0.y + -0.07017949*f0.y + -0.08035512*g0.y + 0.023879478*h0.y + 0.057773773*i0.y;
    k = -0.09978134*a0.z + 0.20431131*b0.z + 0.0063662054*c0.z + 0.053208336*d0.z + 0.32056963*e0.z + -0.017122522*f0.z + -0.093939885*g0.z + 0.10500729*h0.z + -0.06635838*i0.z;
    l = 0.120458245*a0.w + -0.1402537*b0.w + 0.019860635*c0.w + 0.046299618*d0.w + 0.06872489*e0.w + -0.0447052*f0.w + -0.122726254*g0.w + -0.018221956*h0.w + 0.00511015*i0.w;
    m = -0.14980844*a1.x + 0.13525958*b1.x + 0.22277893*c1.x + 0.13094072*d1.x + 0.37916073*e1.x + 0.14051563*f1.x + 0.2966822*g1.x + 0.14121437*h1.x + -0.0024877277*i1.x;
    n = 0.16860826*a1.y + 0.07913927*b1.y + 0.026983129*c1.y + -0.28781673*d1.y + -0.74781907*e1.y + -0.2333515*f1.y + -0.025983952*g1.y + -0.06339631*h1.y + 0.17988972*i1.y;
    o = 0.094248205*a1.z + 0.09552581*b1.z + -0.10647933*c1.z + -0.15245505*d1.z + 0.18795626*e1.z + 0.056246266*f1.z + 0.022347486*g1.z + -0.032658946*h1.z + -0.06520757*i1.z;
    p = 0.07874395*a1.w + 0.008490275*b1.w + -0.077739514*c1.w + -0.33134314*d1.w + -0.17488837*e1.w + 0.17983681*f1.w + 0.16872159*g1.w + -0.033116516*h1.w + -0.31637248*i1.w;
    q = -0.02984741*na0.x + -0.033106074*nb0.x + -0.074626714*nc0.x + 0.05186759*nd0.x + 0.4411205*ne0.x + 0.19929363*nf0.x + -0.058961373*ng0.x + 0.101995006*nh0.x + 0.10353861*ni0.x;
    r = -0.009323741*na0.y + -0.058106888*nb0.y + -0.017135192*nc0.y + 0.059093058*nd0.y + -0.102931276*ne0.y + -0.06872296*nf0.y + -0.06365373*ng0.y + -0.077900395*nh0.y + -0.03728999*ni0.y;
    s = 0.12995155*na0.z + 0.01138708*nb0.z + -0.036738325*nc0.z + -0.10337543*nd0.z + -0.038482923*ne0.z + -0.013563022*nf0.z + -0.025379518*ng0.z + 0.042860765*nh0.z + 0.03405761*ni0.z;
    t = 0.005264784*na0.w + 0.09006554*nb0.w + -0.12094439*nc0.w + -0.009473829*nd0.w + 0.20297761*ne0.w + 0.011412984*nf0.w + -0.03707713*ng0.w + 0.0050331065*nh0.w + 0.060511*ni0.w;
    u = -0.014951561*na1.x + -0.13426088*nb1.x + 0.12397659*nc1.x + 0.011123405*nd1.x + 0.0801173*ne1.x + -0.14290653*nf1.x + -0.0031461562*ng1.x + -0.03238526*nh1.x + 0.022475414*ni1.x;
    v = 0.11766882*na1.y + 0.059661616*nb1.y + 0.011924227*nc1.y + -0.056074142*nd1.y + 0.27363485*ne1.y + -0.011868344*nf1.y + 0.078302376*ng1.y + 0.13220052*nh1.y + 0.009441565*ni1.y;
    w = 0.001944502*na1.z + -0.0788648*nb1.z + 0.31860432*nc1.z + -0.10753583*nd1.z + -0.68318206*ne1.z + -0.31693053*nf1.z + 0.18960947*ng1.z + 0.2173563*nh1.z + 0.085332215*ni1.z;
    x = 0.130883*na1.w + 0.003096905*nb1.w + -0.053123176*nc1.w + -0.13724625*nd1.w + 0.09753227*ne1.w + 0.1972498*nf1.w + 0.117141895*ng1.w + 0.22924557*nh1.w + -0.032398295*ni1.w;
    float q1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.0017100481;
    i = -0.2086925*a0.x + -0.0054902593*b0.x + 0.008958661*c0.x + 0.42889228*d0.x + -0.12530953*e0.x + 0.077938266*f0.x + -0.7147147*g0.x + -0.5884967*h0.x + -0.5328939*i0.x;
    j = 0.048498508*a0.y + 0.10627258*b0.y + 0.07233314*c0.y + 0.10546068*d0.y + -0.06300838*e0.y + -0.24016523*f0.y + 0.24212515*g0.y + 0.10866001*h0.y + 0.102079205*i0.y;
    k = 0.09554628*a0.z + -0.47269112*b0.z + 0.6283155*c0.z + -1.0036635*d0.z + 0.374161*e0.z + -0.6817927*f0.z + 0.45258063*g0.z + -0.678372*h0.z + 0.32231042*i0.z;
    l = -0.076917365*a0.w + 0.6876095*b0.w + -0.8204501*c0.w + 0.50143707*d0.w + -0.74970007*e0.w + 0.51672864*f0.w + -0.28516588*g0.w + -0.00871703*h0.w + 0.06765322*i0.w;
    m = 0.23171157*a1.x + -0.06027903*b1.x + 0.173762*c1.x + 0.6158802*d1.x + 0.3154452*e1.x + 0.45508003*f1.x + 0.9706311*g1.x + -1.6833194*h1.x + 0.113559*i1.x;
    n = -0.034078702*a1.y + 0.9735393*b1.y + -0.31849742*c1.y + 0.7111899*d1.y + -0.75236*e1.y + 0.27595088*f1.y + -0.2722964*g1.y + 1.0745589*h1.y + 0.26156154*i1.y;
    o = 0.05916842*a1.z + -0.533813*b1.z + -0.12367357*c1.z + -0.40096056*d1.z + 0.042316306*e1.z + -0.15953232*f1.z + 0.25937524*g1.z + -0.0830802*h1.z + -0.024787977*i1.z;
    p = -0.35923687*a1.w + -0.12255826*b1.w + 0.0049088905*c1.w + -0.14611141*d1.w + -0.25195587*e1.w + 0.049888752*f1.w + 0.13142404*g1.w + 0.02036451*h1.w + -0.032000273*i1.w;
    q = -0.052361045*na0.x + -0.169529*nb0.x + -0.22907723*nc0.x + 0.5950341*nd0.x + -0.55356836*ne0.x + -0.32379588*nf0.x + -0.47245145*ng0.x + 0.17733522*nh0.x + 0.1722754*ni0.x;
    r = 0.36969483*na0.y + -0.42018405*nb0.y + -0.14842306*nc0.y + -1.371239*nd0.y + 0.40536565*ne0.y + -0.0020769117*nf0.y + 0.10199822*ng0.y + -0.5455371*nh0.y + 0.024899451*ni0.y;
    s = -0.33689135*na0.z + -0.28642964*nb0.z + -0.1993493*nc0.z + -0.27277672*nd0.z + -0.043820284*ne0.z + -0.47440007*nf0.z + -0.08644334*ng0.z + -0.34078324*nh0.z + -0.072105184*ni0.z;
    t = -0.009965928*na0.w + -0.3160174*nb0.w + 0.27566355*nc0.w + 0.29919168*nd0.w + 0.029478045*ne0.w + 0.04593068*nf0.w + 0.021061787*ng0.w + -0.13073102*nh0.w + -0.20637748*ni0.w;
    u = 0.09760966*na1.x + 0.0013239577*nb1.x + -0.047888342*nc1.x + -0.12741305*nd1.x + 0.114507146*ne1.x + 0.04859413*nf1.x + 0.17341557*ng1.x + -0.036477488*nh1.x + 0.025525432*ni1.x;
    v = 0.012610979*na1.y + -0.20527816*nb1.y + -0.030312076*nc1.y + -0.075593516*nd1.y + -0.15593761*ne1.y + -0.19141406*nf1.y + -0.38559288*ng1.y + -0.19755952*nh1.y + 0.019317854*ni1.y;
    w = 0.28485414*na1.z + 0.5175772*nb1.z + -0.12245438*nc1.z + -0.2878212*nd1.z + 0.19877273*ne1.z + 0.66879386*nf1.z + -0.20288914*ng1.z + 0.06298292*nh1.z + -0.10582869*ni1.z;
    x = 0.015750764*na1.w + 0.40560052*nb1.w + 0.29314628*nc1.w + 0.3076136*nd1.w + -0.4744141*ne1.w + 0.5406656*nf1.w + 0.47665957*ng1.w + -0.21204963*nh1.w + -0.4425803*ni1.w;
    float r1 = i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+-0.36796984;
    return vec4(o1, p1, q1, r1);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!WIDTH LUMA.w
//!HEIGHT LUMA.h
//!COMPONENTS 4
//!BIND LUMAN10
//!BIND LUMAN11
//!BIND LUMAN20
//!BIND LUMAN21
//!BIND LUMAN30
//!BIND LUMAN31
//!BIND LUMAN40
//!BIND LUMAN41
//!BIND LUMAN50
//!BIND LUMAN51
//!BIND LUMAN60
//!BIND LUMAN61
//!BIND LUMAN70
//!BIND LUMAN71
//!SAVE LUMAN0

vec4 hook() {
    vec4 a0 = LUMAN10_tex(HOOKED_pos);
    vec4 a1 = LUMAN11_tex(HOOKED_pos);
    vec4 b0 = LUMAN20_tex(HOOKED_pos);
    vec4 b1 = LUMAN21_tex(HOOKED_pos);
    vec4 c0 = LUMAN30_tex(HOOKED_pos);
    vec4 c1 = LUMAN31_tex(HOOKED_pos);
    vec4 d0 = LUMAN40_tex(HOOKED_pos);
    vec4 d1 = LUMAN41_tex(HOOKED_pos);
    vec4 e0 = LUMAN50_tex(HOOKED_pos);
    vec4 e1 = LUMAN51_tex(HOOKED_pos);
    vec4 f0 = LUMAN60_tex(HOOKED_pos);
    vec4 f1 = LUMAN61_tex(HOOKED_pos);
    vec4 g0 = LUMAN70_tex(HOOKED_pos);
    vec4 g1 = LUMAN71_tex(HOOKED_pos);
    vec4 na0 = -min(a0, 0);
    vec4 na1 = -min(a1, 0);
    vec4 nb0 = -min(b0, 0);
    vec4 nb1 = -min(b1, 0);
    vec4 nc0 = -min(c0, 0);
    vec4 nc1 = -min(c1, 0);
    vec4 nd0 = -min(d0, 0);
    vec4 nd1 = -min(d1, 0);
    vec4 ne0 = -min(e0, 0);
    vec4 ne1 = -min(e1, 0);
    vec4 nf0 = -min(f0, 0);
    vec4 nf1 = -min(f1, 0);
    vec4 ng0 = -min(g0, 0);
    vec4 ng1 = -min(g1, 0);
    a0 = max(a0, 0);
    a1 = max(a1, 0);
    b0 = max(b0, 0);
    b1 = max(b1, 0);
    c0 = max(c0, 0);
    c1 = max(c1, 0);
    d0 = max(d0, 0);
    d1 = max(d1, 0);
    e0 = max(e0, 0);
    e1 = max(e1, 0);
    f0 = max(f0, 0);
    f1 = max(f1, 0);
    g0 = max(g0, 0);
    g1 = max(g1, 0);
    float o = -0.049245942*a0.x + -0.023370795*a0.y + -7.225961e-05*a0.z + 0.0019568612*a0.w + -0.00049920427*a1.x + -0.010696693*a1.y + -0.004388618*a1.z + 0.022109183*a1.w + 0.008315857*na0.x + 0.0069180024*na0.y + -0.007631315*na0.z + -0.007783451*na0.w + -0.0075604366*na1.x + 0.026377324*na1.y + -0.0029770704*na1.z + 0.011379547*na1.w + -0.0050308816*b0.x + -0.033095017*b0.y + 0.0063684434*b0.z + -0.020444078*b0.w + -0.00080785167*b1.x + -0.015184868*b1.y + 0.020060046*b1.z + -0.008944791*b1.w + 0.013595589*nb0.x + 0.061495364*nb0.y + 0.012803664*nb0.z + 0.019761315*nb0.w + 0.0051377523*nb1.x + 0.0017010213*nb1.y + -0.027974507*nb1.z + 0.008423463*nb1.w + 0.0024215514*c0.x + -0.006051995*c0.y + -0.00015901314*c0.z + 0.027880907*c0.w + 0.009972766*c1.x + -0.0074346033*c1.y + -0.0036655844*c1.z + -0.0062128934*c1.w + -0.00037509945*nc0.x + 0.01976033*nc0.y + 0.005408765*nc0.z + -0.018663349*nc0.w + -0.014102515*nc1.x + 0.012015511*nc1.y + 0.008370724*nc1.z + 0.023661008*nc1.w + -0.00367092*d0.x + 0.012974275*d0.y + 0.0073438482*d0.z + -0.0015102059*d0.w + 0.022306425*d1.x + -0.0013535774*d1.y + -0.0024372635*d1.z + 0.0016232622*d1.w + 0.010132437*nd0.x + -0.00309114*nd0.y + -0.011687519*nd0.z + -0.0048595825*nd0.w + -0.019726558*nd1.x + -0.0021050463*nd1.y + 0.0018076926*nd1.z + -0.0023482873*nd1.w + -0.024257407*e0.x + 0.029996531*e0.y + -0.0022063444*e0.z + -0.0003799291*e0.w + -0.030580392*e1.x + -0.011823871*e1.y + 0.00317984*e1.z + -0.0034969174*e1.w + 0.014147132*ne0.x + 0.0004943756*ne0.y + -0.011309435*ne0.z + 0.015305287*ne0.w + -0.011446511*ne1.x + 0.04074529*ne1.y + -0.01560624*ne1.z + -0.0014475479*ne1.w + 0.0049414146*f0.x + -0.0055082254*f0.y + 0.0031141897*f0.z + 0.0041451626*f0.w + -0.010021149*f1.x + 0.003212007*f1.y + 0.025077049*f1.z + 0.015682345*f1.w + -0.009822955*nf0.x + -0.006624521*nf0.y + -0.008527181*nf0.z + 0.021705732*nf0.w + 0.022870867*nf1.x + 0.0025929692*nf1.y + -0.0042776894*nf1.z + -0.014903406*nf1.w + -0.0028529165*g0.x + -0.008448063*g0.y + 0.0038560058*g0.z + 0.0027421543*g0.w + -0.0074425405*g1.x + -0.01334431*g1.y + -0.010088023*g1.z + -0.055267867*g1.w + -0.0031185371*ng0.x + 0.006812255*ng0.y + 0.012340063*ng0.z + 0.00865805*ng0.w + -0.022648849*ng1.x + 0.053120937*ng1.y + 0.008478949*ng1.z + 0.0018696731*ng1.w + 0;
    float p = -0.017464954*a0.x + -0.062101785*a0.y + 0.0072054444*a0.z + 0.0092836935*a0.w + 0.030784087*a1.x + -0.0009286972*a1.y + -0.025769833*a1.z + 0.0029487966*a1.w + 0.011547049*na0.x + 0.038597062*na0.y + -0.0055242833*na0.z + -0.014001495*na0.w + -0.004512439*na1.x + -0.0015175719*na1.y + 0.031619832*na1.z + 0.010452482*na1.w + -0.011093101*b0.x + -0.026935358*b0.y + 0.010374769*b0.z + -0.011456625*b0.w + -0.012582297*b1.x + -0.0039999993*b1.y + 0.008492968*b1.z + 0.0036855722*b1.w + 0.032127716*nb0.x + 0.032859474*nb0.y + -0.00094432937*nb0.z + 0.0121680675*nb0.w + 0.008618216*nb1.x + 0.020981947*nb1.y + -0.008120534*nb1.z + -0.009373491*nb1.w + -0.032179736*c0.x + -0.0020254073*c0.y + -0.015011599*c0.z + 0.019616578*c0.w + 0.008940445*c1.x + -0.0009415161*c1.y + -0.0045905844*c1.z + -0.0006653611*c1.w + 0.021794854*nc0.x + 0.015203587*nc0.y + 0.0048818532*nc0.z + -0.0049212994*nc0.w + -0.008172868*nc1.x + -0.00083788636*nc1.y + -0.002970197*nc1.z + 0.014330884*nc1.w + -0.022657929*d0.x + 0.0047842865*d0.y + -0.004193357*d0.z + -0.005666559*d0.w + 0.036750663*d1.x + 0.0012512826*d1.y + 0.0049374495*d1.z + -0.0039908453*d1.w + -0.0017866646*nd0.x + -0.004390495*nd0.y + -0.0028988542*nd0.z + 0.0032729157*nd0.w + -0.009221632*nd1.x + -0.006040727*nd1.y + 0.0049432437*nd1.z + 0.0003587606*nd1.w + -0.024484716*e0.x + -0.0030389426*e0.y + 0.0056222766*e0.z + 0.011582306*e0.w + 0.028530948*e1.x + -0.03800588*e1.y + -9.8310156e-05*e1.z + -0.002393195*e1.w + 0.0018349448*ne0.x + 0.0049751736*ne0.y + -0.0015016596*ne0.z + 0.0057502403*ne0.w + 0.01291333*ne1.x + -0.043678798*ne1.y + -0.01860552*ne1.z + 0.0075467303*ne1.w + -0.0067772456*f0.x + -0.0141757745*f0.y + -0.007010874*f0.z + 0.008192591*f0.w + -0.009293183*f1.x + -0.0022445754*f1.y + -0.0038566703*f1.z + -0.011925102*f1.w + 0.0045418083*nf0.x + 0.00095765846*nf0.y + -0.01474841*nf0.z + 0.01208856*nf0.w + 0.013340873*nf1.x + -0.011797794*nf1.y + -0.0035833723*nf1.z + 0.009597474*nf1.w + 0.022398442*g0.x + 0.008746581*g0.y + -0.0002473681*g0.z + 0.0032298858*g0.w + -0.011354966*g1.x + 0.003285763*g1.y + 0.014755322*g1.z + 0.019556405*g1.w + -0.0148762*ng0.x + -0.004329214*ng0.y + 0.015337845*ng0.z + 0.03924461*ng0.w + 0.037563473*ng1.x + -0.06123901*ng1.y + -0.004094344*ng1.z + -0.004294583*ng1.w + 0;
    float q = 0.0018004067*a0.x + -0.026203306*a0.y + -0.00039891893*a0.z + 0.010159007*a0.w + -0.03651082*a1.x + -0.007902821*a1.y + -0.007732508*a1.z + 0.027953705*a1.w + -0.002475687*na0.x + 0.008221053*na0.y + -0.005450067*na0.z + -0.011696027*na0.w + 0.0026707612*na1.x + 0.0019173208*na1.y + -0.008400457*na1.z + -0.008031958*na1.w + 0.035621405*b0.x + -0.0073195556*b0.y + -0.003661516*b0.z + -0.019455852*b0.w + -0.026372172*b1.x + 0.013939379*b1.y + 0.0082747955*b1.z + -0.0022468078*b1.w + -0.011789901*nb0.x + 0.0015583938*nb0.y + 0.0013948897*nb0.z + 0.019545833*nb0.w + 0.013844493*nb1.x + 0.012033381*nb1.y + -0.017193947*nb1.z + -0.016286712*nb1.w + 0.0006176892*c0.x + 0.0013999133*c0.y + -0.018609513*c0.z + 0.019960135*c0.w + 0.010915818*c1.x + 0.001732765*c1.y + -0.008637271*c1.z + -0.0027007023*c1.w + 0.015978742*nc0.x + 0.006627152*nc0.y + 0.045912735*nc0.z + -0.004495457*nc0.w + -0.010189089*nc1.x + 0.0023047698*nc1.y + 0.011235966*nc1.z + -0.05359617*nc1.w + -0.0002535656*d0.x + -0.0074861352*d0.y + 0.0072714468*d0.z + 0.016833195*d0.w + 0.022890443*d1.x + -0.009765689*d1.y + 0.009508351*d1.z + 0.0062339636*d1.w + -0.012663426*nd0.x + -0.005541378*nd0.y + -0.011128237*nd0.z + -0.022598132*nd0.w + -0.014917645*nd1.x + 0.011874683*nd1.y + -0.008611195*nd1.z + -0.01414024*nd1.w + 0.013602081*e0.x + 0.0031817604*e0.y + -0.004745976*e0.z + -0.007916127*e0.w + 0.041977737*e1.x + 0.007487502*e1.y + 0.014730856*e1.z + -0.0007972412*e1.w + 0.007999292*ne0.x + 0.0016938462*ne0.y + -0.017985921*ne0.z + 0.0017458921*ne0.w + -0.0006560395*ne1.x + -0.006504917*ne1.y + -0.016750248*ne1.z + 0.0015032388*ne1.w + 0.005011853*f0.x + -0.031059701*f0.y + 0.01985983*f0.z + 0.0015322289*f0.w + -0.0007681325*f1.x + -0.008150405*f1.y + 0.022249863*f1.z + 0.017525308*f1.w + -0.008532365*nf0.x + -0.028016925*nf0.y + -0.0025936463*nf0.z + 0.009671558*nf0.w + -0.010893107*nf1.x + -0.009454452*nf1.y + -0.0044735065*nf1.z + 0.002920707*nf1.w + -0.011938847*g0.x + 0.0061559035*g0.y + 0.003996976*g0.z + -0.01185357*g0.w + -0.012531663*g1.x + 0.020186577*g1.y + -0.019036353*g1.z + -0.016737767*g1.w + 0.017701386*ng0.x + 0.012132338*ng0.y + 0.012208775*ng0.z + 0.029298969*ng0.w + -0.0061062295*ng1.x + 0.0284989*ng1.y + -0.014577586*ng1.z + 0.013448756*ng1.w + 0;
    float r = -0.002185117*a0.x + -0.04247913*a0.y + 0.004220362*a0.z + 0.0076788394*a0.w + 0.0035369084*a1.x + 0.008566372*a1.y + -0.006938411*a1.z + 0.011668423*a1.w + 0.014652536*na0.x + 0.032199837*na0.y + -0.008722521*na0.z + -0.011981545*na0.w + -0.02009355*na1.x + 0.0014413322*na1.y + 0.019279627*na1.z + 0.004017313*na1.w + 0.037228394*b0.x + -0.009032077*b0.y + 0.0065939324*b0.z + -0.01897076*b0.w + -0.0244419*b1.x + 0.024367949*b1.y + 0.0075981435*b1.z + -0.005133444*b1.w + -0.021923918*nb0.x + 0.0018044459*nb0.y + -0.005583812*nb0.z + 0.01524464*nb0.w + 0.026689446*nb1.x + 0.013745508*nb1.y + -0.01277478*nb1.z + -0.00086198887*nb1.w + -0.0010721319*c0.x + 0.007368921*c0.y + -0.0069245184*c0.z + 0.014952648*c0.w + 0.013611681*c1.x + -0.0011588702*c1.y + 0.003343768*c1.z + -0.0043547642*c1.w + 0.0050957454*nc0.x + 0.006349954*nc0.y + 0.016560592*nc0.z + -0.011598952*nc0.w + -0.017487887*nc1.x + 0.005505784*nc1.y + 0.005762446*nc1.z + -0.053730555*nc1.w + -0.0006759549*d0.x + -0.01235309*d0.y + 0.019650614*d0.z + 0.013408972*d0.w + -0.007804249*d1.x + -0.004979333*d1.y + -1.3350682e-05*d1.z + 0.020800084*d1.w + -0.0022109053*nd0.x + -0.0041485596*nd0.y + -0.002133069*nd0.z + -0.009645172*nd0.w + 0.008907387*nd1.x + -0.0068519185*nd1.y + 0.0025965276*nd1.z + 0.016099922*nd1.w + 0.04939659*e0.x + -0.0060820593*e0.y + 0.010794697*e0.z + -0.006137374*e0.w + -0.01290872*e1.x + 0.0075298487*e1.y + 0.004041271*e1.z + 0.0064650383*e1.w + 0.00063551264*ne0.x + -0.0027215453*ne0.y + -0.008020362*ne0.z + 0.003695057*ne0.w + -0.018387295*ne1.x + 0.014318577*ne1.y + -0.006835443*ne1.z + -0.00326252*ne1.w + -0.010896453*f0.x + 0.026144367*f0.y + 0.0012133884*f0.z + 0.010121205*f0.w + -0.0072969613*f1.x + 0.0034968446*f1.y + 0.0045040734*f1.z + -0.008679804*f1.w + 0.008097594*nf0.x + -0.008647307*nf0.y + -0.023421394*nf0.z + 0.006397582*nf0.w + -0.012903569*nf1.x + -0.013746394*nf1.y + -0.005604688*nf1.z + 0.024614112*nf1.w + 0.006448986*g0.x + -0.0010337069*g0.y + -0.0021236644*g0.z + -0.02637876*g0.w + -0.017765772*g1.x + 0.009548466*g1.y + 0.009302046*g1.z + 0.055873007*g1.w + -0.023443764*ng0.x + 0.025910184*ng0.y + 0.02454128*ng0.z + -0.0014853663*ng0.w + 0.015091205*ng1.x + -0.097650506*ng1.y + -0.012416881*ng1.z + -0.0017395458*ng1.w + 0;
    return vec4(o, p, q, r);
}

//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)-Conv-Reduce
//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!WIDTH LUMA.w
//!HEIGHT LUMA.h
//!COMPONENTS 4
//!BIND LUMAN80
//!BIND LUMAN81
//!BIND LUMAN90
//!BIND LUMAN91
//!BIND LUMAN100
//!BIND LUMAN101
//!BIND LUMAN110
//!BIND LUMAN111
//!BIND LUMAN120
//!BIND LUMAN121
//!BIND LUMAN130
//!BIND LUMAN131
//!BIND LUMAN0
//!SAVE LUMAN0

vec4 hook() {
    vec4 h0 = LUMAN80_tex(HOOKED_pos);
    vec4 h1 = LUMAN81_tex(HOOKED_pos);
    vec4 i0 = LUMAN90_tex(HOOKED_pos);
    vec4 i1 = LUMAN91_tex(HOOKED_pos);
    vec4 j0 = LUMAN100_tex(HOOKED_pos);
    vec4 j1 = LUMAN101_tex(HOOKED_pos);
    vec4 k0 = LUMAN110_tex(HOOKED_pos);
    vec4 k1 = LUMAN111_tex(HOOKED_pos);
    vec4 l0 = LUMAN120_tex(HOOKED_pos);
    vec4 l1 = LUMAN121_tex(HOOKED_pos);
    vec4 m0 = LUMAN130_tex(HOOKED_pos);
    vec4 m1 = LUMAN131_tex(HOOKED_pos);
    vec4 nh0 = -min(h0, 0);
    vec4 nh1 = -min(h1, 0);
    vec4 ni0 = -min(i0, 0);
    vec4 ni1 = -min(i1, 0);
    vec4 nj0 = -min(j0, 0);
    vec4 nj1 = -min(j1, 0);
    vec4 nk0 = -min(k0, 0);
    vec4 nk1 = -min(k1, 0);
    vec4 nl0 = -min(l0, 0);
    vec4 nl1 = -min(l1, 0);
    vec4 nm0 = -min(m0, 0);
    vec4 nm1 = -min(m1, 0);
    h0 = max(h0, 0);
    h1 = max(h1, 0);
    i0 = max(i0, 0);
    i1 = max(i1, 0);
    j0 = max(j0, 0);
    j1 = max(j1, 0);
    k0 = max(k0, 0);
    k1 = max(k1, 0);
    l0 = max(l0, 0);
    l1 = max(l1, 0);
    m0 = max(m0, 0);
    m1 = max(m1, 0);
    float o = LUMAN0_tex(HOOKED_pos).x + 0.034401156*h0.x + 0.009962745*h0.y + 0.004650459*h0.z + -0.014043792*h0.w + -0.0045827245*h1.x + -0.0098359445*h1.y + -0.038034104*h1.z + 0.012327318*h1.w + 0.0052528363*nh0.x + -0.01484837*nh0.y + -0.0046127653*nh0.z + -0.017336814*nh0.w + 0.0017943914*nh1.x + 0.012748614*nh1.y + 0.045215413*nh1.z + -0.014139176*nh1.w + 0.008896243*i0.x + 0.03842194*i0.y + -0.03274889*i0.z + -0.0058000316*i0.w + -0.025357485*i1.x + -0.008246465*i1.y + 0.012221546*i1.z + 0.00085157016*i1.w + 0.006214815*ni0.x + 9.9459925e-05*ni0.y + 0.0038164293*ni0.z + -0.0022133805*ni0.w + -0.006646422*ni1.x + 0.028549185*ni1.y + 0.015540295*ni1.z + -0.0012580348*ni1.w + 0.010400454*j0.x + 0.009329043*j0.y + -0.0138742*j0.z + -0.021820448*j0.w + 0.0064277314*j1.x + 0.004760106*j1.y + 0.0067427587*j1.z + -0.0051277643*j1.w + -0.009292018*nj0.x + 0.0025945473*nj0.y + 0.0081010815*nj0.z + 0.01822323*nj0.w + 0.00030703348*nj1.x + -0.051875446*nj1.y + -0.019228334*nj1.z + 0.016917307*nj1.w + -0.0005357173*k0.x + -0.016460193*k0.y + -0.034852613*k0.z + -0.011156134*k0.w + 0.0127446605*k1.x + 0.021746593*k1.y + -0.024992103*k1.z + 0.08019326*k1.w + -0.023824502*nk0.x + -0.02147762*nk0.y + 0.045119874*nk0.z + 0.015192997*nk0.w + 0.019346148*nk1.x + -0.014151585*nk1.y + 0.019203197*nk1.z + -0.0044191247*nk1.w + -0.013625817*l0.x + 0.07165393*l0.y + -0.027658032*l0.z + -0.07151944*l0.w + -0.062443268*l1.x + 0.112457685*l1.y + 0.003210102*l1.z + -0.008732399*l1.w + -0.00975312*nl0.x + -0.057808086*nl0.y + -0.027749574*nl0.z + 0.02227914*nl0.w + 0.041571714*nl1.x + -0.0055755195*nl1.y + 0.108266085*nl1.z + -0.047125004*nl1.w + 0.00368833*m0.x + -0.013775068*m0.y + 0.009254338*m0.z + -0.01990427*m0.w + 0.08963279*m1.x + 0.14566979*m1.y + 0.05224272*m1.z + -0.014552166*m1.w + 0.02561676*nm0.x + -0.04545395*nm0.y + -0.04238542*nm0.z + -0.031158658*nm0.w + -0.08434943*nm1.x + -0.08503576*nm1.y + 0.022166187*nm1.z + 0.014980171*nm1.w + -0.00483469;
    float p = LUMAN0_tex(HOOKED_pos).y + -0.0020752167*h0.x + 0.0063545695*h0.y + 0.01010751*h0.z + -0.0072764643*h0.w + 0.014333199*h1.x + 0.006697225*h1.y + -0.0039110226*h1.z + 0.0051922174*h1.w + -0.0057791336*nh0.x + 0.007639546*nh0.y + 0.026147008*nh0.z + -0.010151784*nh0.w + -0.0034361628*nh1.x + -0.0078110364*nh1.y + 0.0014328938*nh1.z + 0.008421343*nh1.w + -0.022844987*i0.x + 0.010086591*i0.y + -0.018408401*i0.z + -0.004033717*i0.w + 0.0112133*i1.x + -0.002165153*i1.y + 0.013305925*i1.z + -0.010266089*i1.w + -0.023234507*ni0.x + -0.010901275*ni0.y + 0.027079165*ni0.z + -0.00265954*ni0.w + 0.013545362*ni1.x + -0.013553712*ni1.y + -0.0007794197*ni1.z + 0.0006961812*ni1.w + -0.012110603*j0.x + 0.00034297214*j0.y + -0.01231997*j0.z + -0.048298255*j0.w + 0.00949085*j1.x + -0.02060489*j1.y + 0.025083434*j1.z + 0.021471046*j1.w + -0.005938651*nj0.x + 0.014816684*nj0.y + -0.008995274*nj0.z + 0.020351132*nj0.w + -0.009883385*nj1.x + -0.03256145*nj1.y + -0.009079754*nj1.z + 0.03015216*nj1.w + -0.0018545875*k0.x + -0.05275722*k0.y + -0.022588806*k0.z + -0.018863019*k0.w + 0.0075146845*k1.x + 0.01169195*k1.y + -0.015616609*k1.z + -0.012367684*k1.w + -0.01055377*nk0.x + -0.012352354*nk0.y + 0.0029030296*nk0.z + 0.027570033*nk0.w + -0.0065908534*nk1.x + -0.005981111*nk1.y + 0.04049675*nk1.z + 0.0067684855*nk1.w + 0.062252034*l0.x + -0.049764156*l0.y + 0.044663634*l0.z + -0.061189957*l0.w + -0.036176555*l1.x + -0.07700532*l1.y + 0.039644565*l1.z + -0.0011335541*l1.w + -0.027153872*nl0.x + 0.08411512*nl0.y + 0.06614775*nl0.z + 0.05199803*nl0.w + -0.048121814*nl1.x + -0.0107329795*nl1.y + -0.1509652*nl1.z + 0.0063024173*nl1.w + 0.0059478707*m0.x + 0.0075850477*m0.y + 0.009046631*m0.z + 0.035324626*m0.w + -0.042710908*m1.x + -0.009776915*m1.y + -0.03474221*m1.z + 0.02385393*m1.w + -0.03071705*nm0.x + -0.07975045*nm0.y + 0.024966806*nm0.z + 0.020511841*nm0.w + 0.07649801*nm1.x + 0.053998437*nm1.y + -0.033258416*nm1.z + -0.028651386*nm1.w + 0.01118088;
    float q = LUMAN0_tex(HOOKED_pos).z + 0.027928034*h0.x + -0.00063064933*h0.y + 0.021734828*h0.z + 0.008412935*h0.w + -0.00065761775*h1.x + -0.0146809*h1.y + -0.03234976*h1.z + 0.013460963*h1.w + -0.0064559532*nh0.x + -0.011165762*nh0.y + -0.05918726*nh0.z + -0.0060834796*nh0.w + -0.004770562*nh1.x + 0.014993997*nh1.y + 0.0113063315*nh1.z + -0.00597723*nh1.w + -0.03202363*i0.x + -0.008795591*i0.y + -0.009579226*i0.z + -0.012104499*i0.w + -0.026801545*i1.x + -0.002506526*i1.y + 0.011310535*i1.z + -0.0018107444*i1.w + 0.0005081284*ni0.x + -0.0077190883*ni0.y + -0.0075142644*ni0.z + 0.014105534*ni0.w + -0.014206757*ni1.x + 0.018670745*ni1.y + -0.0050449176*ni1.z + 0.013789966*ni1.w + 0.0002744412*j0.x + 0.002148134*j0.y + -0.01950388*j0.z + 0.020904543*j0.w + 0.0054305815*j1.x + -0.016772006*j1.y + 0.0029093702*j1.z + 0.04141592*j1.w + -0.014153547*nj0.x + 0.01092091*nj0.y + 0.015726041*nj0.z + 0.022187172*nj0.w + 0.0046619656*nj1.x + 0.022695398*nj1.y + 0.040521663*nj1.z + 0.023822222*nj1.w + 0.0025603063*k0.x + -0.0328092*k0.y + -0.025544703*k0.z + -0.052972298*k0.w + -0.007406237*k1.x + -0.0014704907*k1.y + -0.007823923*k1.z + 0.046964526*k1.w + -0.010520701*nk0.x + -2.8234057e-05*nk0.y + -0.002981609*nk0.z + 0.021067832*nk0.w + 0.0069698454*nk1.x + -0.006944726*nk1.y + 0.011752712*nk1.z + -0.013274593*nk1.w + -0.0018958533*l0.x + 0.020418048*l0.y + -0.013365399*l0.z + 0.03520888*l0.w + 0.079659395*l1.x + -0.014603256*l1.y + 0.01026993*l1.z + -0.042973697*l1.w + 0.018409628*nl0.x + -0.10567821*nl0.y + 0.0065107034*nl0.z + 0.027540475*nl0.w + 0.0030548468*nl1.x + 0.010502121*nl1.y + -0.019647006*nl1.z + 0.04516226*nl1.w + -0.06554564*m0.x + -0.011442246*m0.y + -0.005114018*m0.z + -0.0024996835*m0.w + -0.017295208*m1.x + -0.055293165*m1.y + -0.031979002*m1.z + -0.0038506282*m1.w + 0.026960757*nm0.x + 0.07022051*nm0.y + 0.044133842*nm0.z + -0.055684086*nm0.w + -0.0016015825*nm1.x + -0.000436681*nm1.y + 0.082399815*nm1.z + 0.0022714457*nm1.w + -0.001444129;
    float r = LUMAN0_tex(HOOKED_pos).w + 0.0065791705*h0.x + -0.0015403025*h0.y + 0.0064169746*h0.z + 0.007963498*h0.w + 0.021180913*h1.x + -0.004136175*h1.y + 0.028494531*h1.z + -0.0008609896*h1.w + 0.00068162434*nh0.x + 0.005812571*nh0.y + 7.799883e-05*nh0.z + 0.00028619578*nh0.w + -0.015010334*nh1.x + -0.0044445735*nh1.y + 0.020106055*nh1.z + 0.021773782*nh1.w + 0.006280354*i0.x + 0.0071694613*i0.y + -0.032603383*i0.z + 0.0054596756*i0.w + 0.022585317*i1.x + 0.0045749573*i1.y + 0.007902826*i1.z + -0.024760662*i1.w + 0.010345332*ni0.x + 0.0003124174*ni0.y + 0.020316618*ni0.z + -0.0061475406*ni0.w + -0.01166553*ni1.x + -0.004341632*ni1.y + -0.0030678716*ni1.z + 0.0054059103*ni1.w + -0.031425413*j0.x + -0.015989859*j0.y + -0.002786248*j0.z + 0.013642373*j0.w + 0.0026142476*j1.x + -0.019014874*j1.y + -0.0077111414*j1.z + -0.00042229125*j1.w + -0.025821427*nj0.x + 0.0060142726*nj0.y + -0.0030788877*nj0.z + 0.002942042*nj0.w + -0.0059427544*nj1.x + 0.003509379*nj1.y + 0.028800465*nj1.z + 0.017977864*nj1.w + -0.013082354*k0.x + -0.029519752*k0.y + -0.006436361*k0.z + 0.019291043*k0.w + -0.011995411*k1.x + -0.0096671805*k1.y + -0.011445856*k1.z + -0.032207422*k1.w + -0.0072086384*nk0.x + 0.0104716765*nk0.y + -0.009410261*nk0.z + 0.01848859*nk0.w + -0.004418158*nk1.x + -0.0037927034*nk1.y + 0.02927223*nk1.z + -0.0026371046*nk1.w + -0.009728005*l0.x + 0.053604573*l0.y + -0.0477697*l0.z + -0.014545695*l0.w + 0.0729068*l1.x + 0.029571975*l1.y + 0.04266492*l1.z + 0.0028515104*l1.w + 0.035755076*nl0.x + 0.002351535*nl0.y + 0.056750543*nl0.z + 0.025379483*nl0.w + 0.008843858*nl1.x + 0.02538903*nl1.y + 0.009231505*nl1.z + 0.01620967*nl1.w + 0.024939101*m0.x + -0.031211093*m0.y + 0.051891036*m0.z + -0.05012903*m0.w + 0.026645886*m1.x + -0.0222343*m1.y + -0.008087572*m1.z + -0.0046961857*m1.w + -0.00022882015*nm0.x + 0.09123664*nm0.y + -0.093280986*nm0.z + 0.10796022*nm0.w + -0.02372915*nm1.x + -0.03217392*nm1.y + -0.047164705*nm1.z + 0.005004752*nm1.w + -0.0045874715;
    return vec4(o, p, q, r);
}

//!HOOK NATIVE
//!BIND HOOKED
//!WHEN OUTPUT.w NATIVE.w / 1.200 > OUTPUT.h NATIVE.h / 1.200 > *
//!BIND LUMAN0
//!WIDTH NATIVE.w 2 *
//!HEIGHT NATIVE.h 2 *
//!DESC Anime4K-v3.0-Upscale(x2)+Denoise-CNN(UL)

vec4 hook() {
	vec2 f = fract(LUMAN0_pos * LUMAN0_size);
	ivec2 i = ivec2(f * vec2(2));
	float c = LUMAN0_tex((vec2(0.5) - f) * LUMAN0_pt + LUMAN0_pos)[i.y * 2 + i.x];
	return vec4(c + HOOKED_tex(HOOKED_pos).x, HOOKED_tex(HOOKED_pos).yz, 0);
}

