from enum import Enum
import logging
import re


class Item(Enum):
    """Updated as of 30 July 2021"""
    Hammer = 1
    BaseballBat = 2
    Crowbar = 3
    KnuckleDusters = 4
    PenKnife = 5
    KitchenKnife = 6
    Dagger = 7
    Axe = 8
    Scimitar = 9
    Chainsaw = 10
    SamuraiSword = 11
    Glock17 = 12
    RavenMP25 = 13
    Ruger2245 = 14
    BerettaM9 = 15
    USP = 16
    Beretta92FS = 17
    Fiveseven = 18
    Magnum = 19
    DesertEagle = 20
    Dual92GBerettas = 21
    SawedOffShotgun = 22
    BenelliM1Tactical = 23
    MP5Navy = 24
    P90 = 25
    AK47 = 26
    M4A1ColtCarbine = 27
    BenelliM4Super = 28
    M16A2Rifle = 29
    SteyrAUG = 30
    M249PARALMG = 31
    LeatherVest = 32
    PoliceVest = 33
    BulletproofVest = 34
    BoxofChocolateBars = 35
    BigBoxofChocolateBars = 36
    BagofBonBons = 37
    BoxofBonBons = 38
    BoxofExtraStrongMints = 39
    PackofMusicCDs = 40
    DVDPlayer = 41
    MP3Player = 42
    CDPlayer = 43
    PackofBlankCDs100 = 44
    HardDrive = 45
    TankTop = 46
    Trainers = 47
    Jacket = 48
    FullBodyArmor = 49
    OuterTacticalVest = 50
    PlainSilverRing = 51
    SapphireRing = 52
    GoldRing = 53
    DiamondRing = 54
    PearlNecklace = 55
    SilverNecklace = 56
    GoldNecklace = 57
    PlasticWatch = 58
    StainlessSteelWatch = 59
    GoldWatch = 60
    PersonalComputer = 61
    Microwave = 62
    Minigun = 63
    PackofCubanCigars = 64
    Television = 65
    Morphine = 66
    FirstAidKit = 67
    SmallFirstAidKit = 68
    SimpleVirus = 69
    PolymorphicVirus = 70
    TunnelingVirus = 71
    ArmoredVirus = 72
    StealthVirus = 73
    SantaHat04 = 74
    ChristmasCracker04 = 75
    SnowCannon = 76
    ToyotaMR2 = 77
    HondaNSX = 78
    AudiTTQuattro = 79
    BMWM5 = 80
    BMWZ8 = 81
    ChevroletCorvetteZ06 = 82
    DodgeCharger = 83
    PontiacFirebird = 84
    FordGT40 = 85
    HummerH3 = 86
    AudiS4 = 87
    HondaIntegraR = 88
    HondaAccord = 89
    HondaCivic = 90
    VolkswagenBeetle = 91
    ChevroletCavalier = 92
    FordMustang = 93
    ReliantRobin = 94
    HoldenSS = 95
    CoatHanger = 96
    BunchofFlowers = 97
    Neutrilux2000 = 98
    Springfield1911 = 99
    EggPropelledLauncher = 100
    BunnySuit = 101
    ChocolateEgg05 = 102
    FirewalkVirus = 103
    GameConsole = 104
    Xbox = 105
    Parachute = 106
    TrenchCoat = 107
    _9mmUzi = 108
    RPGLauncher = 109
    LeatherBullwhip = 110
    NinjaClaws = 111
    TestTrophy = 112
    PetRock = 113
    NonAnonDoll = 114
    PokerDoll = 115
    YodaFigurine = 116
    TrojanHorse = 117
    EvilDoll = 118
    RubberDuckyofDoom = 119
    TeppicBear = 120
    RockerHeadDoll = 121
    MouserDoll = 122
    EliteActionMan = 123
    ToyReactor = 124
    RoyalDoll = 125
    BlueDragon = 126
    ChinaTeaSet = 127
    MufasaToy = 128
    DozenRoses = 129
    SkankyDoll = 130
    LegoHurin = 131
    MysticalSphere = 132
    _10TonPacifier = 133
    Horse = 134
    UrielsSpeakers = 135
    StrifeClown = 136
    LockedTeddy = 137
    RiddlesBat = 138
    SoupNaziDoll = 139
    PouncerDoll = 140
    SpammerDoll = 141
    CookieJar = 142
    VanityMirror = 143
    BananaPhone = 144
    Xbox360 = 145
    YasukuniSword = 146
    RustySword = 147
    DanceToy = 148
    LuckyDime = 149
    CrystalCarousel = 150
    PixieSticks = 151
    IceSculpture = 152
    CaseofWhiskey = 153
    Laptop = 154
    PurpleFrogDoll = 155
    SkeletonKey = 156
    PatriotWhip = 157
    StatueOfAeolus = 158
    BoltCutters = 159
    Photographs = 160
    BlackUnicorn = 161
    WarPaintKit = 162
    OfficialNinjaKit = 163
    LeukaemiaTeddyBear = 164
    ChocoboFlute = 165
    AnnoyingMan = 166
    ArticleonCrime = 167
    BarbieDoll = 169
    WandofDestruction = 170
    JackOnegLantern05 = 171
    GasCan = 172
    ButterflyKnife = 173
    XM8Rifle = 174
    Taser = 175
    ChainMail = 176
    CobraDerringer = 177
    FlakJacket = 178
    BirthdayCake05 = 179
    BottleofBeer = 180
    BottleofChampagne = 181
    SoaponaRope = 182
    SingleRedRose = 183
    BunchofBlackRoses = 184
    BunchofBalloons05 = 185
    SheepPlushie = 186
    TeddyBearPlushie = 187
    CrackedCrystalBall = 188
    SWRevolver = 189
    C4Explosive = 190
    MemoryLocket = 191
    RainbowStudEarring = 192
    HamsterToy = 193
    Snowflake05 = 194
    ChristmasTree05 = 195
    Cannabis = 196
    Ecstasy = 197
    Ketamine = 198
    LSD = 199
    Opium = 200
    PCP = 201
    MrTornCrown07 = 202
    Shrooms = 203
    Speed = 204
    Vicodin = 205
    Xanax = 206
    MsTornCrown07 = 207
    BoxofSweetHearts = 209
    BagofChocolateKisses = 210
    CrazyCow = 211
    LegendsUrn = 212
    Dreamcatcher = 213
    BrutusKeychain = 214
    KittenPlushie = 215
    SingleWhiteRose = 216
    ClaymoreSword = 217
    Crossbow = 218
    EnfieldSAneg80 = 219
    Grenade = 220
    StickGrenade = 221
    FlashGrenade = 222
    Jackhammer = 223
    SwissArmyKnife = 224
    Mag7 = 225
    SmokeGrenade = 226
    Spear = 227
    VektorCR21 = 228
    ClaymoreMine = 229
    FlareGun = 230
    HecklerKochSL8 = 231
    SIG550 = 232
    BTMP9 = 233
    ChainWhip = 234
    WoodenNunchakus = 235
    Kama = 236
    Kodachi = 237
    Sai = 238
    NinjaStars = 239
    AntiTank = 240
    BushmasterCarbon15 = 241
    HEG = 242
    Taurus = 243
    Blowgun = 244
    BoStaff = 245
    Fireworks = 246
    Katana = 247
    Qsz92 = 248
    SKSCarbine = 249
    TwinTigerHooks = 250
    WushuDoubleAxes = 251
    Ithaca37 = 252
    Lorcin380 = 253
    SWM29 = 254
    Flamethrower = 255
    TearGas = 256
    ThrowingKnife = 257
    JaguarPlushie = 258
    MayanStatue = 259
    Dahlia = 260
    WolverinePlushie = 261
    HockeyStick = 262
    Crocus = 263
    Orchid = 264
    PeleCharm = 265
    NessiePlushie = 266
    Heather = 267
    RedFoxPlushie = 268
    MonkeyPlushie = 269
    SoccerBall = 270
    CeiboFlower = 271
    Edelweiss = 272
    ChamoisPlushie = 273
    PandaPlushie = 274
    JadeBuddha = 275
    Peony = 276
    CherryBlossom = 277
    KabukiMask = 278
    ManekiNeko = 279
    ElephantStatue = 280
    LionPlushie = 281
    AfricanViolet = 282
    DonatorPack = 283
    BronzePaintBrush = 284
    SilverPaintBrush = 285
    GoldPaintBrush = 286
    Pand0rasBox = 287
    MrBrownstoneDoll = 288
    DualAxes = 289
    DualHammers = 290
    DualScimitars = 291
    DualSamuraiSwords = 292
    JapaneseEnglishDictionary = 293
    BottleofSake = 294
    OrientalLog = 295
    OrientalLogTranslation = 296
    YouYouYoYo = 297
    MonkeyCuffs = 298
    JestersCap = 299
    GibalsDragonfly = 300
    GreenOrnament = 301
    PurpleOrnament = 302
    BlueOrnament = 303
    PurpleBell = 304
    Mistletoe = 305
    MiniSleigh = 306
    Snowman = 307
    ChristmasGnome = 308
    GingerbreadHouse = 309
    Lollipop = 310
    MardiGrasBeads = 311
    DevilToy = 312
    CookieLauncher = 313
    CursedMoonPendant = 314
    ApartmentBlueprint = 315
    SemiDetachedHouseBlueprint = 316
    DetachedHouseBlueprint = 317
    BeachHouseBlueprint = 318
    ChaletBlueprint = 319
    VillaBlueprint = 320
    PenthouseBlueprint = 321
    MansionBlueprint = 322
    RanchBlueprint = 323
    PalaceBlueprint = 324
    CastleBlueprint = 325
    PrintingPaper = 326
    BlankTokens = 327
    BlankCreditCards = 328
    Skateboard = 329
    BoxingGloves = 330
    Dumbbells = 331
    CombatVest = 332
    LiquidBodyArmor = 333
    FlexibleBodyArmor = 334
    StickofDynamite = 335
    Cesium137 = 336
    DirtyBomb = 337
    Sh0rtysSurfboard = 338
    PuzzlePiece = 339
    HunnyPot = 340
    SeductiveStethoscope = 341
    DollarBillCollectible = 342
    BackstagePass = 343
    ChemisMagicPotion = 344
    PackofTrojans = 345
    PairofHighHeels = 346
    Thong = 347
    HazmatSuit = 348
    FleaCollar = 349
    DunkinsDonut = 350
    AmazonDoll = 351
    BBQSmoker = 352
    BagofCheetos = 353
    Motorbike = 354
    CitrusSqueezer = 355
    SupermanShades = 356
    KevlarHelmet = 357
    RawIvory = 358
    FineChisel = 359
    IvoryWalkingCane = 360
    NeumuneTablet = 361
    MrTornCrown08 = 362
    MsTornCrown08 = 363
    BoxofGrenades = 364
    BoxofMedicalSupplies = 365
    EroticDVD = 366
    FeatheryHotelCoupon = 367
    LawyerBusinessCard = 368
    LotteryVoucher = 369
    DrugPack = 370
    DarkDoll = 371
    EmptyBox = 372
    Parcel = 373
    BirthdayPresent = 374
    Present = 375
    ChristmasPresent = 376
    BirthdayWrappingPaper = 377
    GenericWrappingPaper = 378
    ChristmasWrappingPaper = 379
    SmallExplosiveDevice = 380
    GoldLaptop = 381
    GoldPlatedAK47 = 382
    PlatinumPDA = 383
    CamelPlushie = 384
    TribulusOmanense = 385
    SportsSneakers = 386
    Handbag = 387
    PinkMac10 = 388
    MrTornCrown09 = 389
    MsTornCrown09 = 390
    Macana = 391
    PepperSpray = 392
    Slingshot = 393
    Brick = 394
    MetalNunchakus = 395
    BusinessClassTicket = 396
    Flail = 397
    SIG552 = 398
    ArmaLiteM15A4 = 399
    Guandao = 400
    LeadPipe = 401
    IcePick = 402
    BoxofTissues = 403
    Bandana = 404
    LoafofBread = 405
    AfroComb = 406
    Compass = 407
    Sextant = 408
    YuccaPlant = 409
    FireHydrant = 410
    ModelSpaceShip = 411
    SportsShades = 412
    MountieHat = 413
    ProdaSunglasses = 414
    ShipinaBottle = 415
    PaperWeight = 416
    RS232Cable = 417
    TailorsDummy = 418
    SmallSuitcase = 419
    MediumSuitcase = 420
    LargeSuitcase = 421
    VanityHandMirror = 422
    PokerChip = 423
    RabbitFoot = 424
    VoodooDoll = 425
    BottleofTequila = 426
    SumoDoll = 427
    CasinoPass = 428
    Chopsticks = 429
    CoconutBra = 430
    DartBoard = 431
    CrazyStraw = 432
    Sensu = 433
    YakitoriLantern = 434
    DozenWhiteRoses = 435
    Snowboard = 436
    GlowStick = 437
    CricketBat = 438
    FryingPan = 439
    Pillow = 440
    KhinkehP0rnStarDoll = 441
    BlowUpDoll = 442
    StrawberryMilkshake = 443
    BreadfanDoll = 444
    ChaosMan = 445
    KarateMan = 446
    BurmeseFlag = 447
    Bl0ndiesDictionary = 448
    HydroponicGrowTent = 449
    LeopardCoin = 450
    FlorinCoin = 451
    GoldNobleCoin = 452
    GaneshaSculpture = 453
    VairocanaBuddhaSculpture = 454
    QuranScriptIbnMasud = 455
    QuranScriptUbayIbnKab = 456
    QuranScriptAli = 457
    ShabtiSculpture = 458
    EgyptianAmulet = 459
    WhiteSenetPawn = 460
    BlackSenetPawn = 461
    SenetBoard = 462
    Epinephrine = 463
    Melatonin = 464
    Serotonin = 465
    SnowGlobe09 = 466
    DancingSantaClaus09 = 467
    ChristmasStocking09 = 468
    SantasElf09 = 469
    ChristmasCard09 = 470
    AdminPortrait09 = 471
    BlueEasterEgg = 472
    GreenEasterEgg = 473
    RedEasterEgg = 474
    YellowEasterEgg = 475
    WhiteEasterEgg = 476
    BlackEasterEgg = 477
    GoldEasterEgg = 478
    MetalDogTag = 479
    BronzeDogTag = 480
    SilverDogTag = 481
    GoldDogTag = 482
    MP5k = 483
    AK74U = 484
    Skorpion = 485
    TMP = 486
    Thompson = 487
    MP40 = 488
    Luger = 489
    Blunderbuss = 490
    ZombieBrain = 491
    HumanHead = 492
    MedalofHonor = 493
    CitroenSaxo = 494
    ClassicMini = 495
    FiatPunto = 496
    NissanMicra = 497
    Peugeot106 = 498
    RenaultClio = 499
    VauxhallCorsa = 500
    Volvo850 = 501
    AlfaRomeo156 = 502
    BMWX5 = 503
    SeatLeonCupra = 504
    VauxhallAstraGSI = 505
    VolkswagenGolfGTI = 506
    AudiS3 = 507
    FordFocusRS = 508
    HondaS2000 = 509
    MiniCooperS = 510
    SierraCosworth = 511
    LotusExige = 512
    MitsubishiEvoX = 513
    Porsche911GT3 = 514
    SubaruImprezaSTI = 515
    TVRSagaris = 516
    AstonMartinOne77 = 517
    AudiR8 = 518
    BugattiVeyron = 519
    Ferrari458 = 520
    LamborghiniGallardo = 521
    LexusLFA = 522
    MercedesSLR = 523
    NissanGTR = 524
    MrTornCrown10 = 525
    MsTornCrown10 = 526
    BagofCandyKisses = 527
    BagofTootsieRolls = 528
    BagofChocolateTruffles = 529
    CanofMunster = 530
    BottleofPumpkinBrew = 531
    CanofRedCow = 532
    CanofTaurineElite = 533
    WitchsCauldron = 534
    ElectronicPumpkin = 535
    JackOLanternLamp = 536
    SpookyPaperWeight = 537
    MedievalHelmet = 538
    BloodSpatteredSickle = 539
    Cauldron = 540
    BottleofStinkySwampPunch = 541
    BottleofWickedWitch = 542
    DeputyStar = 543
    WindProofLighter = 544
    DualTMPs = 545
    DualBushmasters = 546
    DualMP5s = 547
    DualP90s = 548
    DualUzis = 549
    BottleofKandyKane = 550
    BottleofMintyMayhem = 551
    BottleofMistletoeMadness = 552
    CanofSantaShooters = 553
    CanofRockstarRudolph = 554
    CanofXMASS = 555
    BagofReindeerDroppings = 556
    AdventCalendar = 557
    SantasSnot = 558
    PolarBearToy = 559
    Fruitcake = 560
    BookofCarols = 561
    Sweater = 562
    GiftCard = 563
    Glasses = 564
    HighSpeedDrive = 565
    MountainBike = 566
    CutThroatRazor = 567
    SlimCrowbar = 568
    Balaclava = 569
    AdvancedDrivingTacticsManual = 570
    ErgonomicKeyboard = 571
    TrackingDevice = 572
    Screwdriver = 573
    FannyPack = 574
    TumbleDryer = 575
    Chloroform = 576
    HeavyDutyPadlock = 577
    DuctTape = 578
    WirelessDongle = 579
    HorsesHead = 580
    Book = 581
    TinFoilHat = 582
    BrownEasterEgg = 583
    OrangeEasterEgg = 584
    PinkEasterEgg = 585
    Jawbreaker = 586
    BagofSherbet = 587
    GoodieBag = 588
    MrTornCrown11 = 593
    MsTornCrown11 = 594
    PileofVomit = 595
    RustyDogTag = 596
    GoldNugget = 597
    WitchsHat = 598
    GoldenBroomstick = 599
    DevilsPitchfork = 600
    ChristmasLights = 601
    GingerbreadMan = 602
    GoldenWreath = 603
    PairofIceSkates = 604
    DiamondIcicle = 605
    SantaBoots = 606
    SantaGloves = 607
    SantaHat = 608
    SantaJacket = 609
    SantaTrousers = 610
    Snowball = 611
    TavorTAR21 = 612
    Harpoon = 613
    DiamondBladedKnife = 614
    NavalCutlass = 615
    Trout = 616
    BananaOrchid = 617
    StingrayPlushie = 618
    SteelDrum = 619
    NoddingTurtle = 620
    Snorkel = 621
    Flippers = 622
    Speedo = 623
    Bikini = 624
    Wetsuit = 625
    DivingGloves = 626
    DogPoop = 627
    StinkBombs = 628
    ToiletPaper = 629
    MrTornCrown12 = 630
    MsTornCrown12 = 631
    PetrifiedHumerus = 632
    LatexGloves = 633
    BagofBloodyEyeballs = 634
    Straitjacket = 635
    CinnamonOrnament = 636
    ChristmasExpress = 637
    BottleofChristmasCocktail = 638
    GoldenCandyCane = 639
    KevlarGloves = 640
    WWIIHelmet = 641
    MotorcycleHelmet = 642
    ConstructionHelmet = 643
    WeldingHelmet = 644
    SafetyBoots = 645
    HikingBoots = 646
    LeatherHelmet = 647
    LeatherPants = 648
    LeatherBoots = 649
    LeatherGloves = 650
    CombatHelmet = 651
    CombatPants = 652
    CombatBoots = 653
    CombatGloves = 654
    RiotHelmet = 655
    RiotBody = 656
    RiotPants = 657
    RiotBoots = 658
    RiotGloves = 659
    DuneHelmet = 660
    DuneVest = 661
    DunePants = 662
    DuneBoots = 663
    DuneGloves = 664
    AssaultHelmet = 665
    AssaultBody = 666
    AssaultPants = 667
    AssaultBoots = 668
    AssaultGloves = 669
    DeltaGasMask = 670
    DeltaBody = 671
    DeltaPants = 672
    DeltaBoots = 673
    DeltaGloves = 674
    MarauderFaceMask = 675
    MarauderBody = 676
    MarauderPants = 677
    MarauderBoots = 678
    MarauderGloves = 679
    EODHelmet = 680
    EODApron = 681
    EODPants = 682
    EODBoots = 683
    EODGloves = 684
    TornBible = 685
    FriendlyBotGuide = 686
    EgotisticalBear = 687
    BreweryKey = 688
    SignedJersey = 689
    MafiaKit = 690
    OctopusToy = 691
    BearSkinRug = 692
    TractorToy = 693
    MrTornCrown13 = 694
    MsTornCrown13 = 695
    PieceofCake = 696
    RottenEggs = 697
    PegLeg = 698
    Antidote = 699
    ChristmasAngel = 700
    Eggnog = 701
    SprigofHolly = 702
    FestiveSocks = 703
    RespoHoodie = 704
    StaffHaxxButton = 705
    BirthdayCake14 = 706
    LumpofCoal = 707
    GoldRibbon = 708
    SilverRibbon = 709
    BronzeRibbon = 710
    CoinFactions = 711
    CoinCasino = 712
    CoinEducation = 713
    CoinHospital = 714
    CoinJail = 715
    CoinTravelAgency = 716
    CoinCompanies = 717
    CoinStockExchange = 718
    CoinChurch = 719
    CoinAuctionHouse = 720
    CoinRaceTrack = 721
    CoinMuseum = 722
    CoinDrugs = 723
    CoinDump = 724
    CoinEstateAgents = 725
    ScroogesTopHat = 726
    ScroogesTopcoat = 727
    ScroogesTrousers = 728
    ScroogesBoots = 729
    ScroogesGloves = 730
    EmptyBloodBag = 731
    BloodBagApos = 732
    BloodBagAneg = 733
    BloodBagBpos = 734
    BloodBagBneg = 735
    BloodBagABpos = 736
    BloodBagABneg = 737
    BloodBagOpos = 738
    BloodBagOneg = 739
    MrTornCrown = 740
    MsTornCrown = 741
    MolotovCocktail = 742
    ChristmasSweater15 = 743
    BookBrawnOverBrains = 744
    BookTimeIsInTheMind = 745
    BookKeepingYourFaceHandsome = 746
    BookAJobForYourHands = 747
    BookWorking9Til5 = 748
    BookMakingFriendsEnemiesAndCakes = 749
    BookHighSchoolForAdults = 750
    BookMilkYourselfSober = 751
    BookFightLikeAnAsshole = 752
    BookMindOverMatter = 753
    BookNoShameNoPain = 754
    BookRunLikeTheWind = 755
    BookWeaselingOutOfTrouble = 756
    BookGetHardOrGoHome = 757
    BookGymGruntingShoutingToSuccess = 758
    BookSelfDefenseInTheWorkplace = 759
    BookSpeed3TheRejectedScript = 760
    BookLimboLovers101 = 761
    BookTheHamburglarsGuideToCrime = 762
    BookWhatAreOldFolkGoodForAnyway = 763
    BookMedicalDegreeSchmedicalDegree = 764
    BookNoMoreSoapOnARope = 765
    BookMailingYourselfAbroad = 766
    BookSmugglingForBeginners = 767
    BookStealthyStealingofUnderwear = 768
    BookShawshankSureAintForMe = 769
    BookIgnoranceIsBliss = 770
    BookWinkingToWin = 771
    BookFindersKeepers = 772
    BookHotTurkey = 773
    BookHigherDaddyHigher = 774
    BookTheRealDutchCourage = 775
    BookBecauseImHappyThePharrellStory = 776
    BookNoMoreSickDays = 777
    BookDukeMyStory = 778
    BookSelfControlIsForLosers = 779
    BookGoingBackForMore = 780
    BookGetDrunkAndLoseDignity = 781
    BookFuellingYourWayToFailure = 782
    BookYesPleaseDiabetes = 783
    BookUglyEnergy = 784
    BookMemoriesAndMammaries = 785
    BookBrownnosingTheBoss = 786
    BookRunningAwayFromTrouble = 787
    CertificateofAwesome = 788
    CertificateofLame = 789
    PlasticSword = 790
    MediocreTShirt = 791
    Penelope = 792
    CakeFrosting = 793
    LockPickingKit = 794
    SpecialFruitcake = 795
    Felovax = 796
    Zylkene = 797
    DukesSafe = 798
    DukesSelfies = 799
    DukesPoetry = 800
    DukesDogsAshes = 801
    DukesWill = 802
    DukesGimpMask = 803
    DukesHerpesMedication = 804
    DukesHammer = 805
    OldLadyMask = 806
    ExoticGentlemanMask = 807
    GingerKidMask = 808
    YoungLadyMask = 809
    MoustacheManMask = 810
    ScarredManMask = 811
    PsychoClownMask = 812
    NunMask = 813
    Tyrosine = 814
    KegofBeer = 815
    GlassofBeer = 816
    SixPackofAlcohol = 817
    SixPackofEnergyDrink = 818
    RosaryBeads = 819
    PiggyBank = 820
    EmptyVial = 821
    VialofBlood = 822
    VialofUrine = 823
    VialofSaliva = 824
    Questionnaire = 825
    Agreement = 826
    PerceptronCalibrator = 827
    DonaldTrumpMask16 = 828
    YellowSnowman16 = 829
    NockGun = 830
    BerettaPico = 831
    RidingCrop = 832
    Sand = 833
    Sweatpants = 834
    StringVest = 835
    BlackOxfords = 836
    RheinmetallMG3 = 837
    HomemadePocketShotgun = 838
    Madball = 839
    NailBomb = 840
    ClassicFedora = 841
    PinstripeSuitTrousers = 842
    Duster = 843
    TranquilizerGun = 844
    BoltGun = 845
    Scalpel = 846
    NerveGas = 847
    KevlarLabCoat = 848
    Loupes = 849
    Sledgehammer = 850
    Wifebeater = 851
    MetalDetector = 852
    GraveyardKey = 853
    QuestionnaireCompleted = 854
    AgreementSigned = 855
    SprayCanBlack = 856
    SprayCanRed = 857
    SprayCanPink = 858
    SprayCanPurple = 859
    SprayCanBlue = 860
    SprayCanGreen = 861
    SprayCanYellow = 862
    SprayCanOrange = 863
    SaltShaker = 864
    PoisonMistletoe = 865
    SantasList17 = 866
    Soapbox = 867
    TurkeyBaster = 868
    ElonMuskMask17 = 869
    LoveJuice = 870
    BugSwatter = 871
    Nothing = 872
    BottleofGreenStout = 873
    Prototype = 874
    RottenApple = 875
    FesteringChicken = 876
    MouldyPizza = 877
    SmellyCheese = 878
    SourMilk = 879
    StaleBread = 880
    SpoiledFish = 881
    InsurancePolicy = 882
    BankStatement = 883
    CarBattery = 884
    ScrapMetal = 885
    TornCityTimes = 886
    KarmaMagazine = 887
    Umbrella = 888
    TravelMug = 889
    Headphones = 890
    MixCD = 892
    LostandFoundOfficeKey = 893
    CosmeticsCase = 894
    PhoneCard = 895
    SubwaySeasonTicket = 896
    BottleCap = 897
    SilverCoin = 898
    SilverBead = 899
    LuckyQuarter = 900
    Daffodil = 901
    BunchofCarnations = 902
    WhiteLily = 903
    FuneralWreath = 904
    CarKeys = 905
    Handkerchief = 906
    Candle = 907
    PaperBag = 908
    TinCan = 909
    BettingSlip = 910
    FidgetSpinner = 911
    MajesticMoose = 912
    LegoWonderWoman = 913
    CR7Doll = 914
    StretchArmstrongDoll = 915
    BeefFemur = 916
    SnakesFang = 917
    IceyIgloo = 918
    FederalJailKey = 919
    HalloweenBasketSpooky = 920
    MichaelMyersMask18 = 921
    ToastJesus18 = 922
    Cheesus18 = 923
    BottleofChristmasSpirit = 924
    ScammerintheSlammer18 = 925
    GronchMask18 = 926
    BaseballCap = 927
    Bermudas = 928
    Blouse = 929
    BoobTube = 930
    BushHat = 931
    Camisole = 932
    CapriPants = 933
    Cardigan = 934
    CorkHat = 935
    CropTop = 936
    FishermanHat = 937
    GymShorts = 938
    Halterneck = 939
    Raincoat = 940
    Pantyhose = 941
    PencilSkirt = 942
    PeplumTop = 943
    PoloShirt = 944
    Poncho = 945
    PufferVest = 946
    Mackintosh = 947
    Shorts = 948
    Skirt = 949
    TravelSocks = 950
    Turtleneck = 951
    YogaPants = 952
    BronzeRacingTrophy = 953
    SilverRacingTrophy = 954
    GoldRacingTrophy = 955
    PackofBlankCDs250 = 956
    PackofBlankCDs50 = 957
    ChestHarness = 958
    Choker = 959
    FishnetStockings = 960
    KneehighBoots = 961
    Lingerie = 962
    Mankini = 963
    MiniSkirt = 964
    NippleTassels = 965
    BowlerHat = 966
    FittedShirt = 967
    BowTie = 968
    NeckTie = 969
    Waistcoat = 970
    Blazer = 971
    SuitTrousers = 972
    DerbyShoes = 973
    SmokingJacket = 974
    Monocle = 975
    BronzeMicrophone = 976
    SilverMicrophone = 977
    GoldMicrophone = 978
    PaintMask = 979
    Ladder = 980
    WireCutters = 981
    RippedJeans = 982
    BanditMask = 983
    BottleofMoonshine = 984
    CanofGooseJuice = 985
    CanofDampValley = 986
    CanofCrocozade = 987
    FurCoat = 988
    FurScarf = 989
    FurHat = 990
    PlatformShoes = 991
    SilverFlats = 992
    CrystalBracelet = 993
    CocktailRing = 994
    SunHat = 995
    SquareSunglasses = 996
    StatementNecklace = 997
    FloralDress = 998
    Shrug = 1001
    EyePatch = 1002
    HalloweenBasketCreepy = 1003
    HalloweenBasketFreaky = 1004
    HalloweenBasketFrightful = 1005
    HalloweenBasketHaunting = 1006
    HalloweenBasketShocking = 1007
    HalloweenBasketTerrifying = 1008
    HalloweenBasketHorrifying = 1009
    HalloweenBasketPetrifying = 1010
    HalloweenBasketNightmarish = 1011
    BloodBagIrradiated = 1012
    JigsawMask19 = 1013
    ReadingGlasses = 1014
    Chinos = 1015
    CollaredShawl = 1016
    PleatedSkirt = 1017
    FlipFlops = 1018
    BingoVisor = 1019
    Coverups = 1020
    Sandals = 1021
    GolfSocks = 1022
    FlatCap = 1023
    Slippers = 1024
    Bathrobe = 1025
    PartyHat19 = 1026
    Badge15thAnniversary = 1027
    BirthdayCupcake = 1028
    StrippogramVoucher = 1029
    DongThomas = 1030
    DongGreg = 1031
    DongEffy = 1032
    DongHolly = 1033
    DongJeremy = 1034
    AnniversaryPresent = 1035
    GretaMask19 = 1036
    AnatolyMask19 = 1037
    SantaBeard = 1038
    BagofHumbugs = 1039
    ChristmasCracker = 1040
    SpecialSnowflake = 1041
    ConcussionGrenade = 1042
    PaperCrownGreen = 1043
    PaperCrownYellow = 1044
    PaperCrownRed = 1045
    PaperCrownBlue = 1046
    DenimShirt = 1047
    DenimVest = 1048
    DenimJacket = 1049
    DenimJeans = 1050
    DenimShoes = 1051
    DenimCap = 1052
    BreadKnife = 1053
    Semtex = 1054
    PoisonUmbrella = 1055
    MillwallBrick = 1056
    GentlemanCache = 1057
    GoldChain = 1058
    SnapbackHat = 1059
    SaggyPants = 1060
    OversizedShirt = 1061
    BasketballShirt = 1062
    ParachutePants = 1063
    TubeDress = 1064
    GoldSneakers = 1065
    ShutterShades = 1066
    SilverHoodie = 1067
    BucketHat = 1068
    PufferJacket = 1069
    Durag = 1070
    Onesie = 1071
    BaseballJacket = 1072
    Braces = 1073
    PanamaHat = 1074
    Pipe = 1075
    ShoulderSweater = 1076
    SportsJacket = 1077
    OldWallet = 1078
    Cardholder = 1079
    Billfold = 1080
    CoinPurse = 1081
    ZipWallet = 1082
    Clutch = 1083
    CreditCard = 1084
    Lipstick = 1085
    License = 1086
    Tampon = 1087
    Receipt = 1088
    FamilyPhoto = 1089
    Lint = 1090
    Handcuffs = 1091
    Lubricant = 1092
    HitContract = 1093
    Syringe = 1094
    Spoon = 1095
    CellPhone = 1096
    AsslessChaps = 1097
    OperaGloves = 1098
    BootyShorts = 1099
    Collar = 1100
    BallGag = 1101
    Blindfold = 1102
    MaidUniform = 1103
    MaidHat = 1104
    BallGown = 1105
    FascinatorHat = 1106
    WeddingDress = 1107
    WeddingVeil = 1108
    HeadScarf = 1109
    Nightgown = 1110
    Pullover = 1111
    ElegantCache = 1112
    NaughtyCache = 1113
    ElderlyCache = 1114
    DenimCache = 1115
    WannabeCache = 1116
    CutesyCache = 1117
    ArmorCache = 1118
    MeleeCache = 1119
    SmallArmsCache = 1120
    MediumArmsCache = 1121
    HeavyArmsCache = 1122
    SpyCamera = 1123
    CloningDevice = 1124
    CardSkimmer = 1125
    Tutu = 1126
    KneeSocks = 1127
    KittyShoes = 1128
    CatEars = 1129
    BunnyEars = 1130
    PuppyEars = 1131
    HeartSunglasses = 1132
    HairBow = 1133
    LolitaDress = 1134
    UnicornHorn = 1135
    CheckSkirt = 1136
    PolkaDotDress = 1137
    BalletShoes = 1138
    Dungarees = 1139
    Tights = 1140
    PennywiseMask20 = 1141
    TigerKingMask20 = 1142
    MedicalMask = 1143
    ChinDiaper = 1144
    TightyWhities = 1145
    Tangerine = 1146
    HelmetofJustice = 1147
    BrokenBauble = 1148
    PurpleEasterEgg = 1149
    SkiMask = 1150
    BunnyNose = 1151

    def lowest_price(self, t):
        market_cost = t.itemmarket(self)['itemmarket'][0]['cost']
        bazaar_cost = t.itemmarket(self, 'bazaar')['bazaar'][0]['cost']
        return min(market_cost, bazaar_cost)

    def market_price(self, t):
        market_price = t.torn(id_=self.value, selections='items')["items"][str(self.value)]["market_value"]
        return market_price

    @staticmethod
    def from_string(s: str):
        r = {
            'é': 'e',
            'A+': 'Apos',
            'A-': 'Aneg',
            'B+': 'Bpos',
            'B-': 'Bneg',
            'AB+': 'ABpos',
            'AB-': 'ABneg',
            'O+': 'Opos',
            'O-': 'Oneg'
        }
        s_new = s[:]
        for a, b in r.items():
            s_new = s_new.replace(a, b)
        s_new = re.sub(r"[ \-'/&:?!,]", "", s_new)
        if s[0].isdigit():
            s_new = '_' + s_new
        try:
            return Item[s_new]
        except KeyError:
            logging.error('Invalid string or item not yet added:', f'{s=}, {s_new=}')
            return s, s_new


CARS = (Item.ChevroletCavalier, Item.Peugeot106, Item.ReliantRobin, Item.VolkswagenBeetle, Item.CitroenSaxo,
        Item.VauxhallAstraGSI, Item.HondaCivic, Item.ClassicMini, Item.VauxhallCorsa, Item.RenaultClio,
        Item.VolkswagenGolfGTI, Item.AlfaRomeo156, Item.AudiS4, Item.HondaIntegraR, Item.NissanMicra,
        Item.FordMustang, Item.SeatLeonCupra, Item.HummerH3, Item.LotusExige, Item.HondaS2000, Item.HondaAccord,
        Item.HoldenSS, Item.ToyotaMR2, Item.HondaNSX, Item.MiniCooperS, Item.BMWX5, Item.TVRSagaris,
        Item.SubaruImprezaSTI, Item.BMWM5, Item.ChevroletCorvetteZ06, Item.FordFocusRS, Item.AudiTTQuattro,
        Item.FiatPunto, Item.PontiacFirebird, Item.DodgeCharger, Item.Volvo850, Item.NissanGTR, Item.MitsubishiEvoX,
        Item.BMWZ8, Item.Porsche911GT3, Item.FordGT40, Item.AudiR8, Item.LexusLFA, Item.Ferrari458,
        Item.LamborghiniGallardo, Item.MercedesSLR, Item.AstonMartinOne77, Item.SierraCosworth, Item.AudiS3)


FLOWER_SET = (Item.AfricanViolet, Item.BananaOrchid, Item.CherryBlossom, Item.CeiboFlower, Item.Crocus, Item.Dahlia,
              Item.Edelweiss, Item.Heather, Item.Orchid, Item.Peony, Item.TribulusOmanense)

PLUSHIE_SET = (Item.CamelPlushie, Item.LionPlushie, Item.PandaPlushie, Item.ChamoisPlushie, Item.MonkeyPlushie,
               Item.RedFoxPlushie, Item.NessiePlushie, Item.JaguarPlushie, Item.StingrayPlushie, Item.WolverinePlushie,
               Item.SheepPlushie, Item.TeddyBearPlushie, Item.KittenPlushie)
