/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - ScanKeywords
 * - ScanKeywords_kw_string
 * - ScanKeywords_kw_offsets
 * - ScanKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2021, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"key\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"materialized\0"
	"maxvalue\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"placing\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	15,
	22,
	29,
	33,
	39,
	45,
	55,
	59,
	64,
	70,
	77,
	85,
	93,
	97,
	101,
	107,
	110,
	114,
	125,
	135,
	146,
	157,
	160,
	167,
	174,
	184,
	198,
	207,
	214,
	220,
	228,
	235,
	242,
	246,
	254,
	259,
	267,
	270,
	276,
	281,
	288,
	296,
	305,
	310,
	315,
	323,
	329,
	334,
	344,
	360,
	366,
	377,
	383,
	389,
	397,
	406,
	414,
	424,
	431,
	439,
	447,
	456,
	463,
	473,
	485,
	498,
	512,
	521,
	532,
	543,
	555,
	563,
	572,
	583,
	588,
	593,
	600,
	606,
	610,
	615,
	623,
	639,
	652,
	665,
	680,
	693,
	711,
	724,
	731,
	737,
	742,
	751,
	755,
	766,
	770,
	778,
	786,
	794,
	803,
	814,
	823,
	831,
	838,
	848,
	859,
	867,
	873,
	878,
	885,
	896,
	904,
	912,
	921,
	924,
	933,
	940,
	947,
	952,
	957,
	962,
	969,
	978,
	988,
	992,
	997,
	1004,
	1010,
	1017,
	1025,
	1035,
	1045,
	1053,
	1060,
	1068,
	1079,
	1089,
	1098,
	1106,
	1112,
	1119,
	1125,
	1132,
	1141,
	1147,
	1153,
	1163,
	1167,
	1173,
	1181,
	1189,
	1196,
	1201,
	1206,
	1215,
	1225,
	1235,
	1242,
	1248,
	1256,
	1265,
	1271,
	1280,
	1287,
	1295,
	1302,
	1309,
	1314,
	1319,
	1328,
	1331,
	1337,
	1347,
	1357,
	1366,
	1373,
	1376,
	1384,
	1394,
	1404,
	1410,
	1418,
	1426,
	1435,
	1445,
	1452,
	1458,
	1464,
	1470,
	1482,
	1489,
	1497,
	1501,
	1509,
	1519,
	1528,
	1533,
	1541,
	1544,
	1551,
	1561,
	1566,
	1570,
	1576,
	1585,
	1591,
	1596,
	1604,
	1612,
	1622,
	1628,
	1633,
	1639,
	1644,
	1650,
	1657,
	1662,
	1668,
	1678,
	1693,
	1702,
	1707,
	1714,
	1721,
	1729,
	1735,
	1748,
	1757,
	1764,
	1771,
	1780,
	1785,
	1791,
	1796,
	1801,
	1807,
	1816,
	1824,
	1830,
	1834,
	1839,
	1843,
	1847,
	1852,
	1857,
	1860,
	1865,
	1875,
	1886,
	1890,
	1898,
	1905,
	1913,
	1920,
	1925,
	1932,
	1938,
	1946,
	1953,
	1956,
	1960,
	1967,
	1972,
	1976,
	1979,
	1984,
	1993,
	2000,
	2008,
	2011,
	2017,
	2028,
	2035,
	2039,
	2045,
	2050,
	2059,
	2067,
	2078,
	2084,
	2090,
	2099,
	2106,
	2114,
	2124,
	2132,
	2141,
	2149,
	2155,
	2162,
	2171,
	2181,
	2191,
	2199,
	2208,
	2217,
	2225,
	2231,
	2242,
	2253,
	2263,
	2274,
	2282,
	2294,
	2300,
	2306,
	2311,
	2316,
	2325,
	2333,
	2343,
	2347,
	2358,
	2370,
	2378,
	2386,
	2395,
	2403,
	2410,
	2421,
	2429,
	2437,
	2443,
	2451,
	2460,
	2467,
	2477,
	2485,
	2492,
	2498,
	2503,
	2512,
	2519,
	2527,
	2536,
	2540,
	2545,
	2550,
	2560,
	2567,
	2575,
	2582,
	2589,
	2596,
	2605,
	2612,
	2621,
	2631,
	2644,
	2651,
	2659,
	2672,
	2676,
	2682,
	2687,
	2693,
	2698,
	2706,
	2713,
	2718,
	2727,
	2736,
	2741,
	2745,
	2752,
	2763,
	2769,
	2779,
	2790,
	2796,
	2803,
	2811,
	2818,
	2825,
	2831,
	2844,
	2854,
	2862,
	2872,
	2878,
	2885,
	2891,
	2898,
	2910,
	2921,
	2926,
	2935,
	2945,
	2950,
	2955,
	2960,
	2965,
	2975,
	2978,
	2987,
	2999,
	3009,
	3015,
	3023,
	3028,
	3033,
	3042,
	3050,
	3055,
	3061,
	3069,
	3079,
	3091,
	3103,
	3109,
	3116,
	3124,
	3133,
	3142,
	3148,
	3155,
	3160,
	3166,
	3173,
	3179,
	3188,
	3198,
	3204,
	3211,
	3219,
	3228,
	3236,
	3244,
	3252,
	3257,
	3263,
	3272,
	3277,
	3283,
	3294,
	3301,
	3306,
	3313,
	3321,
	3326,
	3334,
	3340,
	3344,
	3358,
	3368,
	3379,
	3389,
	3399,
	3413,
	3422,
	3428,
	3436,
	3449,
	3458,
	3463,
	3467,
};

#define SCANKEYWORDS_NUM_KEYWORDS 457

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[915] = {
		32767, 32767, 32767, 32767, 32767, -208,  338,   32767,
		378,   612,   289,   640,   0,     32767, 184,   32767,
		882,   32767, 362,   -196,  -25,   250,   32767, 179,
		-65,   32767, -70,   32767, 244,   32767, -55,   32767,
		-547,  0,     36,    0,     32767, 32767, 313,   32767,
		32767, 32767, -25,   32767, 100,   7,     32767, 32767,
		32767, 32767, 3,     32767, 32767, 0,     32767, 127,
		0,     279,   69,    243,   -245,  132,   63,    0,
		72,    32767, 32767, 32767, 0,     -311,  32767, -474,
		-53,   119,   32767, 178,   32767, 32767, 32767, 352,
		-169,  32767, 0,     32767, 32767, -234,  172,   234,
		89,    363,   32767, 32767, 74,    81,    827,   53,
		603,   0,     448,   32767, 183,   417,   550,   -170,
		32767, -179,  32767, 32767, 433,   -657,  271,   32767,
		32767, 32767, -149,  32767, 181,   32767, 32767, 32767,
		0,     0,     0,     -193,  -371,  32767, -45,   582,
		32767, 49,    30,    32767, 138,   32767, 36,    390,
		-126,  -24,   0,     996,   32767, 354,   296,   -765,
		-20,   598,   -404,  -577,  32767, 32767, 53,    -52,
		189,   32767, 43,    482,   70,    32767, 0,     539,
		287,   -249,  -20,   32767, 0,     32767, 94,    -387,
		32767, 32767, 32767, 427,   32767, 32767, -206,  32767,
		273,   101,   218,   32767, 2,     32767, 106,   32767,
		32767, 215,   32767, -427,  389,   -159,  -101,  809,
		41,    0,     0,     32767, 719,   32767, -215,  32767,
		651,   167,   32767, -380,  32767, 32767, 328,   -26,
		32767, 32767, 32767, 114,   0,     -290,  -182,  -192,
		32767, -809,  -476,  833,   67,    247,   119,   32767,
		32767, 200,   32767, 394,   -176,  98,    32767, 447,
		32767, 596,   438,   32767, -750,  32767, 0,     32767,
		0,     555,   -109,  83,    -34,   82,    32767, 32767,
		330,   32767, 0,     -17,   0,     21,    545,   286,
		32767, 32767, 124,   32767, 0,     32767, 137,   0,
		-354,  183,   351,   885,   0,     190,   -319,  224,
		-292,  0,     32767, 32767, 792,   32767, 37,    200,
		342,   671,   356,   0,     -163,  -511,  43,    32767,
		32767, 163,   0,     32767, 32767, 32767, -81,   -100,
		50,    18,    -525,  452,   32767, 32767, 32767, 543,
		332,   406,   32767, 32767, 197,   32767, 32767, 32767,
		32767, -236,  32767, 32767, 243,   244,   32767, 194,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-122,  684,   217,   32767, 360,   32767, 1085,  -155,
		0,     8,     350,   202,   635,   32767, 325,   398,
		336,   32767, 32767, 900,   32767, 417,   200,   32767,
		-44,   32767, 0,     32767, 32767, -361,  32767, 204,
		0,     0,     32767, 32767, 32767, 32767, -172,  32767,
		178,   32767, 93,    0,     151,   37,    32767, 32767,
		32767, 32767, 32767, 32767, 0,     98,    205,   32767,
		32767, 32767, -178,  -781,  0,     70,    32767, 219,
		301,   291,   0,     32767, 327,   -295,  32767, 32767,
		120,   291,   32767, -10,   32767, 32767, 32767, 317,
		32767, 32767, 453,   208,   32767, 174,   0,     32767,
		0,     0,     215,   32767, 370,   32767, 416,   0,
		32767, 32767, 32767, 130,   366,   -80,   32767, 32767,
		80,    212,   0,     267,   32767, 32767, 32767, 52,
		32767, 356,   0,     -43,   170,   -40,   369,   32767,
		252,   432,   62,    32767, 32767, 32767, 282,   19,
		26,    -244,  32767, 32767, 32767, 32767, 0,     0,
		-185,  -612,  271,   -14,   -182,  -122,  32767, 32767,
		-296,  0,     423,   32767, 32767, 32767, 32767, 26,
		0,     32767, 0,     262,   412,   118,   -138,  -385,
		32767, 134,   311,   -338,  309,   105,   754,   32767,
		762,   32767, 32767, 0,     32767, 32767, -509,  0,
		525,   803,   32767, -372,  32767, 524,   32767, -695,
		32767, 32767, 0,     253,   -202,  32767, 32767, 32767,
		489,   32767, 32767, 0,     -157,  130,   456,   200,
		32767, 32767, 26,    32767, -563,  32767, 392,   0,
		379,   373,   89,    70,    32767, 32767, 167,   241,
		553,   32767, 0,     -49,   32767, 0,     230,   -12,
		-102,  0,     -123,  32767, 32767, 0,     32767, 20,
		-664,  -249,  32767, 32767, 352,   53,    32767, 32767,
		249,   0,     -144,  -772,  0,     32767, 32767, 32767,
		268,   0,     101,   0,     32767, 44,    32767, 0,
		-765,  32767, 32767, 272,   32767, 32767, 680,   0,
		32767, 367,   9,     840,   -353,  677,   32767, 32767,
		145,   32767, 423,   65,    0,     0,     324,   32767,
		32767, 426,   332,   0,     32767, 32767, 189,   32767,
		-534,  32767, 32767, 40,    33,    0,     32767, 0,
		289,   -238,  182,   25,    0,     32767, 0,     140,
		206,   32767, 32767, 32767, 32767, 176,   -132,  229,
		127,   -578,  204,   393,   32767, 265,   32767, 189,
		32767, 0,     855,   32767, 0,     206,   -338,  224,
		32767, 235,   34,    330,   386,   419,   407,   32767,
		-28,   32767, -91,   0,     32767, 0,     32767, 32767,
		67,    352,   326,   290,   -78,   87,    54,    9,
		223,   -637,  133,   388,   32767, -123,  123,   32767,
		436,   613,   -260,  32767, 31,    32767, 32767, -126,
		32767, 556,   32767, 0,     94,    -523,  232,   -58,
		32767, -456,  32767, 172,   918,   32767, 415,   0,
		32767, 0,     167,   658,   32767, -158,  32767, -265,
		-1,    32767, 32767, 0,     32767, 0,     32767, 27,
		32767, 867,   189,   0,     155,   0,     386,   32767,
		32767, 0,     0,     32767, 246,   567,   32767, 32767,
		-214,  31,    239,   -474,  32767, 0,     159,   107,
		32767, 0,     49,    32767, -82,   -31,   330,   174,
		74,    32767, 32767, 109,   311,   32767, 32767, -478,
		151,   32767, 0,     323,   0,     32767, 32767, 248,
		32767, 32767, 32767, 0,     32767, 0,     452,   0,
		321,   0,     0,     0,     -12,   103,   32767, 103,
		32767, -261,  0,     32767, 398,   96,    32767, 32767,
		32767, -290,  566,   0,     32767, 0,     32767, 408,
		32767, 32767, 32767, 685,   32767, 42,    32767, 0,
		136,   0,     32767, 32767, 32767, 306,   32767, -180,
		124,   32767, 361,   32767, 0,     0,     0,     203,
		138,   321,   32767, 260,   32767, 32767, 32767, 766,
		32767, 0,     0,     14,    -232,  598,   32767, 32767,
		924,   0,     32767, 0,     32767, 295,   32767, 32767,
		32767, 32767, 32767, 32767, 57,    80,    0,     221,
		15,    288,   -3,    136,   426,   0,     32767, 32767,
		413,   32767, 32767, -771,  217,   801,   32767, 365,
		46,    32767, 32767, 0,     52,    405,   32767, 119,
		0,     32767, 308,   32767, 0,     10,    0,     32767,
		188,   32767, 0,     32767, 207,   32767, 146,   32767,
		308,   50,    305,   0,     32767, 32767, 425,   293,
		402,   375,   32767
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 5;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 915] + h[b % 915];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
