# 简介

用于同步协议管理系统上协议源码到本地，摆脱手动创建文件/复制粘贴源码/替换包名/人工核对协议是否更新等烦恼。 目前只支持Android侧使用，后续计划支持ios侧

## 配置

需要配置凭据用于登录[协议管理系统](http://protocol.client.bigo.inner/#/protocol)

建议直接配置用户名和密码，会话过期之后会触发自动登录

```
pcs-get --set-user your_account # 协议管理系统账号，应该也是oa账号
pcs-get --set-password your_password
```

当然也可配置浏览器中已有的cookie，但是过期之后需要再次手动更新

```
pcs-get --set-token your_csrftoken
pcs-get --set-session your_sessionid
```

![get-token-session](https://raw.githubusercontent.com/BladesOfTime/pure-img-holder/main/pcs-get/get-token-session.png)

## 使用

建议源码目录建新包存放协议类文件，比如需求包是livepass，新建protocol作为协议包，需要并cd到此路径再执行本脚本, 建议通过IDE的open-in-terminal来跳转
![open in terminal](https://raw.githubusercontent.com/BladesOfTime/pure-img-holder/main/pcs-get/open-in-terminal.png)

按需求编号下载该需求的所有协议代码

```
pcs-get -f 50308
pcs-get --feat 50308
```

按协议类名称下载协议代码

```
pcs-get -n PCS_QryLivePassDetailRes
pcs-get --name PCS_QryLivePassDetailRes,PCS_QryLivePassDetailReq # 多个名称英文逗号拼接
```

更新当前目录下协议类

```
pcs-get
pcs-get -u
pcs-get --update
```

## FAQ

**Q: 稳定性怎么样？**

A: 由于本脚本比较特殊，是客户端个人维护的爬虫模块，非协议管理系统官方出品。如果协议管理系统接口变更，可能就用不了了。因此请始终保证是最新版本，遇到问题请提 [Issues][issues-new]或者直接Q我。

**Q: 代码质量怎么样？**

A: Python小白力作，边看某菜鸟教程边敲的，所以你懂的！欢迎各位不吝赐教👏🏻