/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"4e90918c0a": function _(e,s,t,o,b){o();const i=e("tslib").__importStar(e("c4b9651916"));t.Panel=i;e("@bokehjs/base").register_models(i)},
"c4b9651916": function _(a,e,o,t,d){t();const c=a("tslib");d("AcePlot",a("abb1112c2c").AcePlot),d("Audio",a("66d52165db").Audio),d("Card",a("0106b0a1bf").Card),d("CommManager",a("684c940c17").CommManager),d("DeckGLPlot",a("d0d2aafca0").DeckGLPlot),d("ECharts",a("f940c92510").ECharts),d("HTML",a("ed08037ce5").HTML),d("IPyWidget",a("fad8d6fbd1").IPyWidget),d("JSON",a("284504a0cf").JSON),d("FileDownload",a("7a99dba4eb").FileDownload),d("KaTeX",a("7b859fb3cf").KaTeX),d("Location",a("aded270681").Location),d("MathJax",a("0c21036737").MathJax),d("Player",a("79c41bbf71").Player),d("PlotlyPlot",a("56da045fbd").PlotlyPlot),d("Progress",a("765e9cea08").Progress),d("SingleSelect",a("ff9dd91f7b").SingleSelect),d("State",a("38b2bc9574").State),d("VegaPlot",a("294adeb985").VegaPlot),d("Video",a("b0c3e9e9c2").Video),d("VideoStream",a("3c7145a2fa").VideoStream),c.__exportStar(a("c51f25e2a7"),o)},
"abb1112c2c": function _(e,t,i,o,s){o();const n=e("tslib").__importStar(e("@bokehjs/core/properties")),a=e("@bokehjs/models/layouts/html_box"),d=e("@bokehjs/core/dom"),h=e("7116a7a602");class _ extends h.PanelHTMLBoxView{initialize(){super.initialize(),this._ace=window.ace,this._container=d.div({id:"_"+Math.random().toString(36).substr(2,9),style:{width:"100%",height:"100%"}})}connect_signals(){super.connect_signals(),this.connect(this.model.properties.code.change,()=>this._update_code_from_model()),this.connect(this.model.properties.theme.change,()=>this._update_theme()),this.connect(this.model.properties.language.change,()=>this._update_language()),this.connect(this.model.properties.filename.change,()=>this._update_filename()),this.connect(this.model.properties.print_margin.change,()=>this._update_print_margin()),this.connect(this.model.properties.annotations.change,()=>this._add_annotations()),this.connect(this.model.properties.readonly.change,()=>{this._editor.setReadOnly(this.model.readonly)})}render(){super.render(),this._container!==this.el.childNodes[0]&&this.el.appendChild(this._container),this._container.textContent=this.model.code,this._editor=this._ace.edit(this._container.id),this._langTools=this._ace.require("ace/ext/language_tools"),this._modelist=this._ace.require("ace/ext/modelist"),this._editor.setOptions({enableBasicAutocompletion:!0,enableSnippets:!0,fontFamily:"monospace"}),this._update_theme(),this._update_filename(),this._update_language(),this._editor.setReadOnly(this.model.readonly),this._editor.setShowPrintMargin(this.model.print_margin),this._editor.on("change",()=>this._update_code_from_editor())}_update_code_from_model(){this._editor&&this._editor.getValue()!=this.model.code&&this._editor.setValue(this.model.code)}_update_print_margin(){this._editor.setShowPrintMargin(this.model.print_margin)}_update_code_from_editor(){this._editor.getValue()!=this.model.code&&(this.model.code=this._editor.getValue())}_update_theme(){this._editor.setTheme("ace/theme/"+this.model.theme)}_update_filename(){if(this.model.filename){const e=this._modelist.getModeForPath(this.model.filename).mode;this.model.language=e.slice(9)}}_update_language(){null!=this.model.language&&this._editor.session.setMode("ace/mode/"+this.model.language)}_add_annotations(){this._editor.session.setAnnotations(this.model.annotations)}after_layout(){super.after_layout(),this._editor.resize()}}i.AcePlotView=_,_.__name__="AcePlotView";class r extends a.HTMLBox{constructor(e){super(e)}static init_AcePlot(){this.prototype.default_view=_,this.define({code:[n.String],filename:[n.String],language:[n.String],theme:[n.String,"chrome"],annotations:[n.Array,[]],readonly:[n.Boolean,!1],print_margin:[n.Boolean,!1]}),this.override({height:300,width:300})}}i.AcePlot=r,r.__name__="AcePlot",r.__module__="panel.models.ace",r.init_AcePlot()},
"7116a7a602": function _(e,i,t,s,h){s();const o=e("@bokehjs/core/layout/html"),n=e("@bokehjs/core/layout/types"),_=e("@bokehjs/core/dom"),a=e("@bokehjs/models/widgets/markup"),d=e("@bokehjs/models/layouts/html_box");function l(e,i){let t=null!=i.width?"fixed":"fit",s=null!=i.height?"fixed":"fit";const{sizing_mode:h}=i;if(null!=h)if("fixed"==h)t=s="fixed";else if("stretch_both"==h)t=s="max";else if("stretch_width"==h)t="max";else if("stretch_height"==h)s="max";else switch(h){case"scale_width":t="max",s="min";break;case"scale_height":t="min",s="max";break;case"scale_both":t="max",s="max";break;default:throw new Error("unreachable")}"fixed"==t&&i.width?e.style.width=i.width+"px":"max"==t&&(e.style.width="100%"),"fixed"==s&&i.height?e.style.height=i.height+"px":"max"==s&&(e.style.height="100%")}t.set_size=l;class c extends o.VariadicBox{constructor(e,i,t){super(e),this.el=e,this.sizing_mode=i,this.changed=t,this._cache=new Map,this._cache_count=new Map}_measure(e){const i=[e.width,e.height,this.sizing_mode].toString(),t=this.changed&&"fixed"!=this.sizing_mode&&null!=this.sizing_mode?1:0,s=this._cache.get(i),h=this._cache_count.get(i);if(null!=s&&null!=h&&h>=t)return this._cache_count.set(i,h+1),s;const o=new n.Sizeable(e).bounded_to(this.sizing.size),a=_.sized(this.el,o,()=>{const e=new n.Sizeable(_.content_size(this.el)),{border:i,padding:t}=_.extents(this.el);return e.grow_by(i).grow_by(t).map(Math.ceil)});return this._cache.set(i,a),this._cache_count.set(i,0),a}invalidate_cache(){}}t.CachedVariadicBox=c,c.__name__="CachedVariadicBox";class r extends a.MarkupView{_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new c(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}render(){super.render(),l(this.markup_el,this.model)}}t.PanelMarkupView=r,r.__name__="PanelMarkupView";class m extends d.HTMLBoxView{_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new c(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}render(){super.render(),l(this.el,this.model)}}t.PanelHTMLBoxView=m,m.__name__="PanelHTMLBoxView"},
"66d52165db": function _(e,t,i,o,s){o();const l=e("tslib").__importStar(e("@bokehjs/core/properties")),d=e("@bokehjs/models/layouts/html_box"),u=e("7116a7a602");class a extends u.PanelHTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,()=>this.set_loop()),this.connect(this.model.properties.paused.change,()=>this.set_paused()),this.connect(this.model.properties.time.change,()=>this.set_time()),this.connect(this.model.properties.value.change,()=>this.set_value()),this.connect(this.model.properties.volume.change,()=>this.set_volume())}render(){super.render(),this.audioEl=document.createElement("audio"),this.audioEl.controls=!0,this.audioEl.src=this.model.value,this.audioEl.currentTime=this.model.time,this.audioEl.loop=this.model.loop,null!=this.model.volume?this.audioEl.volume=this.model.volume/100:this.model.volume=100*this.audioEl.volume,this.audioEl.onpause=()=>this.model.paused=!0,this.audioEl.onplay=()=>this.model.paused=!1,this.audioEl.ontimeupdate=()=>this.update_time(this),this.audioEl.onvolumechange=()=>this.update_volume(this),this.el.appendChild(this.audioEl),this.model.paused||this.audioEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.audioEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.audioEl.volume)}set_loop(){this.audioEl.loop=this.model.loop}set_paused(){!this.audioEl.paused&&this.model.paused&&this.audioEl.pause(),this.audioEl.paused&&!this.model.paused&&this.audioEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.audioEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.audioEl.currentTime=this.model.time)}set_value(){this.audioEl.src=this.model.value}}i.AudioView=a,a.__name__="AudioView";class h extends d.HTMLBox{constructor(e){super(e)}static init_Audio(){this.prototype.default_view=a,this.define({loop:[l.Boolean,!1],paused:[l.Boolean,!0],time:[l.Number,0],throttle:[l.Number,250],value:[l.Any,""],volume:[l.Number,null]})}}i.Audio=h,h.__name__="Audio",h.__module__="panel.models.widgets",h.init_Audio()},
"0106b0a1bf": function _(e,s,t,l,o){l();const a=e("tslib"),i=e("@bokehjs/models/layouts/column"),n=a.__importStar(e("@bokehjs/core/dom")),c=e("@bokehjs/core/dom"),r=e("@bokehjs/core/layout/grid"),d=a.__importStar(e("@bokehjs/core/properties"));class h extends r.Column{constructor(e,s=!1){super(e),this.collapsed=s}_measure_totals(e,s){const t=this.collapsed?e.slice(0,1):e,l=t.length-1;return this.collapsed||(t[l]=t[l]+5),super._measure_totals(t,s)}}t.CollapseableColumnLayout=h,h.__name__="CollapseableColumnLayout";class _ extends i.ColumnView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.collapsed.change,()=>this._collapse());const{active_header_background:e,header_background:s,header_color:t}=this.model.properties;this.on_change([e,s,t],()=>this.render())}_update_layout(){const e=this.child_views.map(e=>e.layout);this.layout=new h(e,this.model.collapsed),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0];const s=this.box_sizing();this.model.collapsed&&(s.height=void 0),this.layout.set_sizing(s)}render(){c.empty(this.el);const{background:e,button_css_classes:s,header_color:t,header_tag:l,header_css_classes:o}=this.model;this.el.style.backgroundColor=null!=e?e:"",c.classes(this.el).clear().add(...this.css_classes());let a=this.model.header_background;this.model.collapsed||null==this.model.active_header_background||(a=this.model.active_header_background);const i=this.child_views[0];let r;if(this.model.collapsible){this.button_el=n.createElement("button",{type:"button",class:o}),this.button_el.style.backgroundColor=null!=a?a:"",this.button_el.appendChild(i.el);const e=n.createElement("p",{class:s});e.innerHTML=this.model.collapsed?"+":"−",this.button_el.appendChild(e),this.button_el.onclick=()=>this._toggle_button(),r=this.button_el}else r=n.createElement(l,{class:o}),r.style.backgroundColor=null!=a?a:"",r.appendChild(i.el);r.style.color=null!=t?t:"",this.el.appendChild(r),i.render();for(const e of this.child_views.slice(1))this.model.collapsed||this.el.appendChild(e.el),e.render()}_toggle_button(){this.model.collapsed=!this.model.collapsed}_collapse(){this.invalidate_render(),this.resize_layout()}_createElement(){return n.createElement(this.model.tag,{class:this.css_classes()})}}t.CardView=_,_.__name__="CardView";class u extends i.Column{constructor(e){super(e)}static init_Card(){this.prototype.default_view=_,this.define({active_header_background:[d.String,null],button_css_classes:[d.Array,[]],collapsed:[d.Boolean,!0],collapsible:[d.Boolean,!0],header_background:[d.String,null],header_color:[d.String,null],header_css_classes:[d.Array,[]],header_tag:[d.String,"div"],tag:[d.String,"div"]})}}t.Card=u,u.__name__="Card",u.__module__="panel.models.layout",u.init_Card()},
"684c940c17": function _(e,t,n,o,i){o();const s=e("tslib").__importStar(e("@bokehjs/core/properties")),c=e("@bokehjs/document"),l=e("@bokehjs/core/view"),_=e("@bokehjs/model"),a=e("@bokehjs/protocol/message"),r=e("@bokehjs/protocol/receiver");class h extends l.View{renderTo(){}}n.CommManagerView=h,h.__name__="CommManagerView";class m extends _.Model{constructor(e){super(e),this._document_listener=e=>this._document_changed(e),this._receiver=new r.Receiver,this._event_buffer=[],this._blocked=!1,this._timeout=Date.now(),null!=window.PyViz&&window.PyViz.comm_manager?(this.ns=window.PyViz,this.ns.comm_manager.register_target(this.plot_id,this.comm_id,e=>this.msg_handler(e)),this._client_comm=this.ns.comm_manager.get_client_comm(this.plot_id,this.client_comm_id,e=>this.on_ack(e))):console.log("Could not find comm manager on window.PyViz, ensure the extension is loaded.")}_doc_attached(){super._doc_attached(),null!=this.document&&this.document.on_change(this._document_listener)}_document_changed(e){e.setter_id!==this.id&&(e instanceof c.ModelChangedEvent&&!(e.attr in e.model.serializable_attributes())||(this._event_buffer.push(e),(!this._blocked||Date.now()>this._timeout)&&(setTimeout(()=>this.process_events(),this.debounce),this._blocked=!0,this._timeout=Date.now()+this.timeout)))}process_events(){if(null==this.document||null==this._client_comm)return;const e=this.document.create_json_patch(this._event_buffer);this._event_buffer=[];const t=a.Message.create("PATCH-DOC",{},e);this._client_comm.send(t)}on_ack(e){const t=e.metadata;this._event_buffer.length?(this._blocked=!0,this._timeout=Date.now()+this.timeout,this.process_events()):this._blocked=!1,"Ready"==t.msg_type&&t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback)}msg_handler(e){const t=e.metadata,n=e.buffers,o=e.content.data,i=this.plot_id;if("Ready"==t.msg_type)t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback);else if(null!=i){let e=null;if(i in this.ns.plot_index&&null!=this.ns.plot_index[i]?e=this.ns.plot_index[i]:void 0!==window.Bokeh&&i in window.Bokeh.index&&(e=window.Bokeh.index[i]),null==e)return;null!=n&&n.length>0?this._receiver.consume(n[0].buffer):this._receiver.consume(o);const t=this._receiver.message;null!=t&&Object.keys(t.content).length>0&&null!=this.document&&this.document.apply_json_patch(t.content,t.buffers,this.id)}}static init_CommManager(){this.prototype.default_view=h,this.define({plot_id:[s.String,null],comm_id:[s.String,null],client_comm_id:[s.String,null],timeout:[s.Number,5e3],debounce:[s.Number,50]})}}n.CommManager=m,m.__name__="CommManager",m.__module__="panel.models.comm_manager",m.init_CommManager()},
"d0d2aafca0": function _(e,t,o,i,n){i();const a=e("tslib"),s=e("@bokehjs/core/dom"),c=a.__importStar(e("@bokehjs/core/properties")),r=e("@bokehjs/models/layouts/html_box"),d=e("7116a7a602"),l=e("064eac2866"),_=a.__importDefault(e("093eb75864"));function h(){const e={},t=window.deck,o=Object.keys(t).filter(e=>e.charAt(0)===e.charAt(0).toUpperCase());for(const i of o)e[i]=t[i];return e}class p extends d.PanelHTMLBoxView{connect_signals(){super.connect_signals();const{data:e,mapbox_api_key:t,tooltip:o,layers:i,initialViewState:n,data_sources:a}=this.model.properties;this.on_change([t,o],()=>this.render()),this.on_change([e,n],()=>this.updateDeck()),this.on_change([i],()=>this._update_layers()),this.on_change([a],()=>this._connect_sources(!0)),this._layer_map={},this._connected=[],this._connect_sources()}_update_layers(){this._layer_map={},this._update_data(!0)}_connect_sources(e=!1){for(const e of this.model.data_sources)this._connected.indexOf(e)<0&&(this.connect(e.properties.data.change,()=>this._update_data(!0)),this._connected.push(e));this._update_data(e)}initialize(){if(super.initialize(),window.deck.JSONConverter){const{CSVLoader:e,Tile3DLoader:t}=window.loaders;window.loaders.registerLoaders([t,e]);const o={classes:h(),enumerations:{COORDINATE_SYSTEM:window.deck.COORDINATE_SYSTEM,GL:_.default},constants:{Tile3DLoader:t}};this.jsonConverter=new window.deck.JSONConverter({configuration:o})}}_update_data(e=!0){let t=0;for(const e of this.model.layers){let o;if(t+=1,t-1 in this._layer_map)o=this.model.data_sources[this._layer_map[t-1]];else{if("number"!=typeof e.data)continue;this._layer_map[t-1]=e.data,o=this.model.data_sources[e.data]}const i=[],n=o.columns();for(let e=0;e<o.get_length();e++){const t={};for(const i of n){let n=o.get_array(i);const a=null==n[0].shape?null:n[0].shape;null!=a&&a.length>1&&"number"==typeof a[0]?t[i]=n.slice(e*a[1],e*a[1]+a[1]):t[i]=n[e]}i.push(t)}e.data=i}e&&this.updateDeck()}_on_click_event(e){const t={coordinate:e.coordinate,lngLat:e.lngLat,index:e.index};this.model.clickState=t}_on_hover_event(e){const t={coordinate:e.coordinate,lngLat:e.lngLat,index:e.index};this.model.hoverState=t}_on_viewState_event(e){this.model.viewState=e.viewState}getData(){return Object.assign(Object.assign({},this.model.data),{layers:this.model.layers,initialViewState:this.model.initialViewState,onViewStateChange:e=>this._on_viewState_event(e),onClick:e=>this._on_click_event(e),onHover:e=>this._on_hover_event(e)})}updateDeck(){if(!this.deckGL)return void this.render();const e=this.getData();if(window.deck.updateDeck)window.deck.updateDeck(e,this.deckGL);else{const t=this.jsonConverter.convert(e);this.deckGL.setProps(t)}}createDeck({mapboxApiKey:e,container:t,jsonInput:o,tooltip:i}){let n;try{const a=this.jsonConverter.convert(o),s=l.makeTooltip(i);n=new window.deck.DeckGL(Object.assign(Object.assign({},a),{map:window.mapboxgl,mapboxApiAccessToken:e,container:t,getTooltip:s}))}catch(e){console.error(e)}return n}render(){super.render();const e=s.div({class:"deckgl"});d.set_size(e,this.model);const t=this.model.mapbox_api_key,o=this.model.tooltip,i=this.getData();window.deck.createDeck?this.deckGL=window.deck.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}):this.deckGL=this.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}),this.el.appendChild(e)}}o.DeckGLPlotView=p,p.__name__="DeckGLPlotView";class u extends r.HTMLBox{constructor(e){super(e)}static init_DeckGLPlot(){this.prototype.default_view=p,this.define({data:[c.Any],data_sources:[c.Array,[]],clickState:[c.Any],hoverState:[c.Any],initialViewState:[c.Any],layers:[c.Array,[]],mapbox_api_key:[c.String],tooltip:[c.Any],viewState:[c.Any]}),this.override({height:400,width:600})}}o.DeckGLPlot=u,u.__name__="DeckGLPlot",u.__module__="panel.models.deckgl",u.init_DeckGLPlot()},
"064eac2866": function _(e,t,n,i,l){
/*
    This file was adapted from https://github.com/uber/deck.gl/ the LICENSE
    below is preserved to comply with the original license.
    
    Copyright (c) 2015 - 2017 Uber Technologies, Inc.
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    */
let o,r;i();const s={fontFamily:'"Helvetica Neue", Helvetica, Arial, sans-serif',display:"flex",flex:"wrap",maxWidth:"500px",flexDirection:"column",zIndex:2};function c(){return document.createElement("div")}function a(e){if(!e.picked)return null;if(e.object===o)return r;const t={html:u(e.object),style:s};return r=t,o=e.object,t}n.getTooltipDefault=a;const f=new Set(["position","index"]);function u(e){const t=c();for(const n in e){if(f.has(n))continue;const i=c();i.className="header",i.textContent=n;const l=c();l.className="value",l.textContent=h(e[n]);const o=c();p(o,i,l),o.appendChild(i),o.appendChild(l),t.appendChild(o)}return t.innerHTML}function p(e,t,n){Object.assign(t.style,{fontWeight:700,marginRight:"10px",flex:"1 1 0%"}),Object.assign(n.style,{flex:"none",maxWidth:"250px",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"}),Object.assign(e.style,{display:"flex",flexDirection:"row",justifyContent:"space-between",alignItems:"stretch"})}function h(e){let t;if(Array.isArray(e)&&e.length>4)t=`Array<${e.length}>`;else if("string"==typeof e)t=e;else if("number"==typeof e)t=String(e);else try{t=JSON.stringify(e)}catch(e){t="<Non-Serializable Object>"}return t.length>50&&(t=t.slice(0,50)),t}function x(e,t){let n=e;for(const e in t)n=n.replace(`{${e}}`,t[e]);return n}n.tabularize=u,n.toText=h,n.substituteIn=x,n.makeTooltip=function(e){return e?e.html||e.text?t=>{if(!t.picked)return null;const n={style:e.style||s};return e.html?n.html=x(e.html,t.object):n.text=x(e.text,t.object),n}:a:null}},
"093eb75864": function _(E,_,R,T,A){_.exports={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,FUNC_ADD:32774,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,BLEND_COLOR:32773,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,VENDOR:7936,RENDERER:7937,VERSION:7938,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,BROWSER_DEFAULT_WEBGL:37444,STATIC_DRAW:35044,STREAM_DRAW:35040,DYNAMIC_DRAW:35048,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,CULL_FACE:2884,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,BLEND:3042,DEPTH_TEST:2929,DITHER:3024,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,SCISSOR_TEST:3089,STENCIL_TEST:2960,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CONTEXT_LOST_WEBGL:37442,CW:2304,CCW:2305,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DOUBLE:5130,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,COMPILE_STATUS:35713,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_ATTRIBUTES:35721,ACTIVE_UNIFORMS:35718,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,ALWAYS:519,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,GEQUAL:518,NOTEQUAL:517,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,TEXTURE_WIDTH:4096,TEXTURE_HEIGHT:4097,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,MAX_3D_TEXTURE_SIZE:32883,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,MAX_TEXTURE_LOD_BIAS:34045,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,RASTERIZER_DISCARD:35977,VERTEX_ARRAY_BINDING:34229,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,MAX_ELEMENT_INDEX:36203,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,RGB9_E5:35901,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,RGB10_A2UI:36975,TEXTURE_IMMUTABLE_FORMAT:37167,TEXTURE_IMMUTABLE_LEVELS:33503,UNSIGNED_INT_2_10_10_10_REV:33640,UNSIGNED_INT_10F_11F_11F_REV:35899,UNSIGNED_INT_5_9_9_9_REV:35902,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,UNSIGNED_INT_24_8:34042,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,INT_2_10_10_10_REV:36255,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,MAX_SAMPLES:36183,SAMPLER_BINDING:35097,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,UNSIGNED_NORMALIZED:35863,SIGNED_NORMALIZED:36764,VERTEX_ATTRIB_ARRAY_INTEGER:35069,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,DEPTH24_STENCIL8:35056,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,COLOR:6144,DEPTH:6145,STENCIL:6146,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,INVALID_INDEX:4294967295,TIMEOUT_IGNORED:-1,MAX_CLIENT_WAIT_TIMEOUT_WEBGL:37447,VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE:35070,UNMASKED_VENDOR_WEBGL:37445,UNMASKED_RENDERER_WEBGL:37446,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047,TEXTURE_MAX_ANISOTROPY_EXT:34046,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_RGBA8_ETC2_EAC:37493,COMPRESSED_SRGB8_ETC2:37494,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37495,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37496,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37497,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGB_ATC_WEBGL:35986,COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL:35986,COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL:34798,UNSIGNED_INT_24_8_WEBGL:34042,HALF_FLOAT_OES:36193,RGBA32F_EXT:34836,RGB32F_EXT:34837,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT:33297,UNSIGNED_NORMALIZED_EXT:35863,MIN_EXT:32775,MAX_EXT:32776,SRGB_EXT:35904,SRGB_ALPHA_EXT:35906,SRGB8_ALPHA8_EXT:35907,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT:33296,FRAGMENT_SHADER_DERIVATIVE_HINT_OES:35723,COLOR_ATTACHMENT0_WEBGL:36064,COLOR_ATTACHMENT1_WEBGL:36065,COLOR_ATTACHMENT2_WEBGL:36066,COLOR_ATTACHMENT3_WEBGL:36067,COLOR_ATTACHMENT4_WEBGL:36068,COLOR_ATTACHMENT5_WEBGL:36069,COLOR_ATTACHMENT6_WEBGL:36070,COLOR_ATTACHMENT7_WEBGL:36071,COLOR_ATTACHMENT8_WEBGL:36072,COLOR_ATTACHMENT9_WEBGL:36073,COLOR_ATTACHMENT10_WEBGL:36074,COLOR_ATTACHMENT11_WEBGL:36075,COLOR_ATTACHMENT12_WEBGL:36076,COLOR_ATTACHMENT13_WEBGL:36077,COLOR_ATTACHMENT14_WEBGL:36078,COLOR_ATTACHMENT15_WEBGL:36079,DRAW_BUFFER0_WEBGL:34853,DRAW_BUFFER1_WEBGL:34854,DRAW_BUFFER2_WEBGL:34855,DRAW_BUFFER3_WEBGL:34856,DRAW_BUFFER4_WEBGL:34857,DRAW_BUFFER5_WEBGL:34858,DRAW_BUFFER6_WEBGL:34859,DRAW_BUFFER7_WEBGL:34860,DRAW_BUFFER8_WEBGL:34861,DRAW_BUFFER9_WEBGL:34862,DRAW_BUFFER10_WEBGL:34863,DRAW_BUFFER11_WEBGL:34864,DRAW_BUFFER12_WEBGL:34865,DRAW_BUFFER13_WEBGL:34866,DRAW_BUFFER14_WEBGL:34867,DRAW_BUFFER15_WEBGL:34868,MAX_COLOR_ATTACHMENTS_WEBGL:36063,MAX_DRAW_BUFFERS_WEBGL:34852,VERTEX_ARRAY_BINDING_OES:34229,QUERY_COUNTER_BITS_EXT:34916,CURRENT_QUERY_EXT:34917,QUERY_RESULT_EXT:34918,QUERY_RESULT_AVAILABLE_EXT:34919,TIME_ELAPSED_EXT:35007,TIMESTAMP_EXT:36392,GPU_DISJOINT_EXT:36795}},
"f940c92510": function _(e,t,s,i,h){i();const r=e("tslib").__importStar(e("@bokehjs/core/properties")),n=e("@bokehjs/models/layouts/html_box");class o extends n.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,()=>this._plot());const{width:e,height:t,renderer:s,theme:i}=this.model.properties;this.on_change([e,t],()=>this._resize()),this.on_change([i,s],()=>this._rerender())}render(){super.render();const e={width:this.model.width,height:this.model.height,renderer:this.model.renderer};this._chart=window.echarts.init(this.el,this.model.theme,e),this._plot()}after_layout(){super.after_layout(),this._chart.resize()}_plot(){null!=window.echarts&&this._chart.setOption(this.model.data)}_rerender(){window.echarts.dispose(this._chart),this.render()}_resize(){this._chart.resize({width:this.model.width,height:this.model.height})}}s.EChartsView=o,o.__name__="EChartsView";class a extends n.HTMLBox{constructor(e){super(e)}static init_ECharts(){this.prototype.default_view=o,this.define({data:[r.Any],theme:[r.String,"default"],renderer:[r.String,"canvas"]})}}s.ECharts=a,a.__name__="ECharts",a.__module__="panel.models.echarts",a.init_ECharts()},
"ed08037ce5": function _(e,t,r,n,a){n();const o=e("@bokehjs/models/widgets/markup"),s=e("7116a7a602");function i(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}r.htmlDecode=i;class l extends s.PanelMarkupView{render(){super.render();const e=i(this.model.text)||this.model.text;e?(this.markup_el.innerHTML=e,Array.from(this.markup_el.querySelectorAll("script")).forEach(e=>{const t=document.createElement("script");Array.from(e.attributes).forEach(e=>t.setAttribute(e.name,e.value)),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)})):this.markup_el.innerHTML=""}}r.HTMLView=l,l.__name__="HTMLView";class m extends o.Markup{constructor(e){super(e)}static init_HTML(){this.prototype.default_view=l}}r.HTML=m,m.__name__="HTML",m.__module__="panel.models.markup",m.init_HTML()},
"fad8d6fbd1": function _(e,i,t,n,d){n();const s=e("tslib").__importStar(e("@bokehjs/core/properties")),o=e("@bokehjs/models/layouts/html_box"),r=e("7116a7a602"),l=window.Jupyter;class a extends r.PanelHTMLBoxView{constructor(){super(...arguments),this.rendered=!1}render(){super.render(),this.rendered||this._render().then(()=>{this.rendered=!0,this.invalidate_layout(),this.notify_finished()})}has_finished(){return this.rendered&&super.has_finished()}async _render(){const{spec:e,state:i}=this.model.bundle;let t;if(null!=l&&null!=l.notebook?t=l.notebook.kernel.widget_manager:null!=window.PyViz.widget_manager&&(t=window.PyViz.widget_manager),!t)return void console.log("Panel IPyWidget model could not find a WidgetManager");const n=(await t.set_state(i)).find(i=>i.model_id==e.model_id);if(null!=n){const e=await t.create_view(n,{el:this.el});if(e.children_views)for(const i of e.children_views.views)await i;this.el.appendChild(e.el),e.trigger("displayed",e)}}}t.IPyWidgetView=a,a.__name__="IPyWidgetView";class _ extends o.HTMLBox{constructor(e){super(e)}static init_IPyWidget(){this.prototype.default_view=a,this.define({bundle:[s.Any,{}]})}}t.IPyWidget=_,_.__name__="IPyWidget",_.__module__="panel.models.ipywidget",_.init_IPyWidget()},
"284504a0cf": function _(e,t,r,s,n){s();const i=e("tslib"),o=i.__importStar(e("@bokehjs/core/properties")),a=e("@bokehjs/models/widgets/markup"),d=i.__importDefault(e("18bba7b7e1")),l=e("7116a7a602");class p extends l.PanelMarkupView{connect_signals(){super.connect_signals();const{depth:e,hover_preview:t,theme:r}=this.model.properties;this.on_change([e,t,r],()=>this.render())}render(){super.render();const e=this.model.text.replace(/(\r\n|\n|\r)/gm,"").replace("'",'"');let t;try{t=window.JSON.parse(e)}catch(e){return void(this.markup_el.innerHTML="<b>Invalid JSON:</b> "+e.toString())}const r={hoverPreviewEnabled:this.model.hover_preview,theme:this.model.theme},s=null==this.model.depth?1/0:this.model.depth,n=new d.default(t,s,r).render();let i="border-radius: 5px; padding: 10px;";"dark"==this.model.theme?n.style.cssText="background-color: rgb(30, 30, 30);"+i:n.style.cssText=i,this.markup_el.append(n)}}r.JSONView=p,p.__name__="JSONView";const h=["dark","light"];class _ extends a.Markup{constructor(e){super(e)}static init_JSON(){this.prototype.default_view=p,this.define({depth:[o.Number,1],hover_preview:[o.Boolean,!1],theme:[o.Enum(h),"dark"]})}}r.JSON=_,_.__name__="JSON",_.__module__="panel.models.markup",_.init_JSON()},
"18bba7b7e1": function _(t,e,r,n,o){function i(t){return null===t?"null":typeof t}function s(t){return!!t&&"object"==typeof t}function a(t){if(void 0===t)return"";if(null===t)return"Object";if("object"==typeof t&&!t.constructor)return"Object";var e=/function ([^(]*)/.exec(t.constructor.toString());return e&&e.length>1?e[1]:""}function f(t,e,r){return"null"===t||"undefined"===t?t:("string"!==t&&"stringifiable"!==t||(r='"'+r.replace(/"/g,'\\"')+'"'),"function"===t?e.toString().replace(/[\r\n]/g,"").replace(/\{.*\}/,"")+"{…}":r)}function m(t){var e="";return s(t)?(e=a(t),Array.isArray(t)&&(e+="["+t.length+"]")):e=f(i(t),t,t),e}function l(t){return"json-formatter-"+t}function d(t,e,r){var n=document.createElement(t);return e&&n.classList.add(l(e)),void 0!==r&&(r instanceof Node?n.appendChild(r):n.appendChild(document.createTextNode(String(r)))),n}n(),function(t){if("undefined"!=typeof window){var e=document.createElement("style");e.setAttribute("media","screen"),e.innerHTML=t,document.head.appendChild(e)}}('.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-row,\n.json-formatter-row a,\n.json-formatter-row a:hover {\n  color: black;\n  text-decoration: none;\n}\n.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-row .json-formatter-string,\n.json-formatter-row .json-formatter-stringifiable {\n  color: green;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-row .json-formatter-number {\n  color: blue;\n}\n.json-formatter-row .json-formatter-boolean {\n  color: red;\n}\n.json-formatter-row .json-formatter-null {\n  color: #855A00;\n}\n.json-formatter-row .json-formatter-undefined {\n  color: #ca0b69;\n}\n.json-formatter-row .json-formatter-function {\n  color: #FF20ED;\n}\n.json-formatter-row .json-formatter-date {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: blue;\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-bracket {\n  color: blue;\n}\n.json-formatter-row .json-formatter-key {\n  color: #00008B;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "►";\n}\n.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n.json-formatter-dark.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-dark.json-formatter-row,\n.json-formatter-dark.json-formatter-row a,\n.json-formatter-dark.json-formatter-row a:hover {\n  color: white;\n  text-decoration: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-string,\n.json-formatter-dark.json-formatter-row .json-formatter-stringifiable {\n  color: #31F031;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-number {\n  color: #66C2FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-boolean {\n  color: #EC4242;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-null {\n  color: #EEC97D;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-undefined {\n  color: #ef8fbe;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-function {\n  color: #FD48CB;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-date {\n  background-color: rgba(255, 255, 255, 0.05);\n}\n.json-formatter-dark.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: #027BFF;\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-bracket {\n  color: #9494FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-key {\n  color: #23A0DB;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "►";\n}\n.json-formatter-dark.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-dark.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n');var c=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/,p=/\d{2}:\d{2}:\d{2} GMT-\d{4}/,j=/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/,h=window.requestAnimationFrame||function(t){return t(),0},u={hoverPreviewEnabled:!1,hoverPreviewArrayCount:100,hoverPreviewFieldCount:5,animateOpen:!0,animateClose:!0,theme:null,useToJSON:!0,sortPropertiesBy:null},g=function(){function t(t,e,r,n){void 0===e&&(e=1),void 0===r&&(r=u),this.json=t,this.open=e,this.config=r,this.key=n,this._isOpen=null,void 0===this.config.hoverPreviewEnabled&&(this.config.hoverPreviewEnabled=u.hoverPreviewEnabled),void 0===this.config.hoverPreviewArrayCount&&(this.config.hoverPreviewArrayCount=u.hoverPreviewArrayCount),void 0===this.config.hoverPreviewFieldCount&&(this.config.hoverPreviewFieldCount=u.hoverPreviewFieldCount),void 0===this.config.useToJSON&&(this.config.useToJSON=u.useToJSON),""===this.key&&(this.key='""')}return Object.defineProperty(t.prototype,"isOpen",{get:function(){return null!==this._isOpen?this._isOpen:this.open>0},set:function(t){this._isOpen=t},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isDate",{get:function(){return this.json instanceof Date||"string"===this.type&&(c.test(this.json)||j.test(this.json)||p.test(this.json))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isUrl",{get:function(){return"string"===this.type&&0===this.json.indexOf("http")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isArray",{get:function(){return Array.isArray(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isObject",{get:function(){return s(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmptyObject",{get:function(){return!this.keys.length&&!this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmpty",{get:function(){return this.isEmptyObject||this.keys&&!this.keys.length&&this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"useToJSON",{get:function(){return this.config.useToJSON&&"stringifiable"===this.type},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasKey",{get:function(){return void 0!==this.key},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"constructorName",{get:function(){return a(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return this.config.useToJSON&&this.json&&this.json.toJSON?"stringifiable":i(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"keys",{get:function(){if(this.isObject){var t=Object.keys(this.json);return!this.isArray&&this.config.sortPropertiesBy?t.sort(this.config.sortPropertiesBy):t}return[]},enumerable:!0,configurable:!0}),t.prototype.toggleOpen=function(){this.isOpen=!this.isOpen,this.element&&(this.isOpen?this.appendChildren(this.config.animateOpen):this.removeChildren(this.config.animateClose),this.element.classList.toggle(l("open")))},t.prototype.openAtDepth=function(t){void 0===t&&(t=1),t<0||(this.open=t,this.isOpen=0!==t,this.element&&(this.removeChildren(!1),0===t?this.element.classList.remove(l("open")):(this.appendChildren(this.config.animateOpen),this.element.classList.add(l("open")))))},t.prototype.getInlinepreview=function(){var t=this;if(this.isArray)return this.json.length>this.config.hoverPreviewArrayCount?"Array["+this.json.length+"]":"["+this.json.map(m).join(", ")+"]";var e=this.keys,r=e.slice(0,this.config.hoverPreviewFieldCount).map((function(e){return e+":"+m(t.json[e])})),n=e.length>=this.config.hoverPreviewFieldCount?"…":"";return"{"+r.join(", ")+n+"}"},t.prototype.render=function(){this.element=d("div","row");var t=this.isObject?d("a","toggler-link"):d("span");if(this.isObject&&!this.useToJSON&&t.appendChild(d("span","toggler")),this.hasKey&&t.appendChild(d("span","key",this.key+":")),this.isObject&&!this.useToJSON){var e=d("span","value"),r=d("span"),n=d("span","constructor-name",this.constructorName);if(r.appendChild(n),this.isArray){var o=d("span");o.appendChild(d("span","bracket","[")),o.appendChild(d("span","number",this.json.length)),o.appendChild(d("span","bracket","]")),r.appendChild(o)}e.appendChild(r),t.appendChild(e)}else{(e=this.isUrl?d("a"):d("span")).classList.add(l(this.type)),this.isDate&&e.classList.add(l("date")),this.isUrl&&(e.classList.add(l("url")),e.setAttribute("href",this.json));var i=f(this.type,this.json,this.useToJSON?this.json.toJSON():this.json);e.appendChild(document.createTextNode(i)),t.appendChild(e)}if(this.isObject&&this.config.hoverPreviewEnabled){var s=d("span","preview-text");s.appendChild(document.createTextNode(this.getInlinepreview())),t.appendChild(s)}var a=d("div","children");return this.isObject&&a.classList.add(l("object")),this.isArray&&a.classList.add(l("array")),this.isEmpty&&a.classList.add(l("empty")),this.config&&this.config.theme&&this.element.classList.add(l(this.config.theme)),this.isOpen&&this.element.classList.add(l("open")),this.element.appendChild(t),this.element.appendChild(a),this.isObject&&this.isOpen&&this.appendChildren(),this.isObject&&!this.useToJSON&&t.addEventListener("click",this.toggleOpen.bind(this)),this.element},t.prototype.appendChildren=function(e){var r=this;void 0===e&&(e=!1);var n=this.element.querySelector("div."+l("children"));if(n&&!this.isEmpty)if(e){var o=0,i=function(){var e=r.keys[o],s=new t(r.json[e],r.open-1,r.config,e);n.appendChild(s.render()),(o+=1)<r.keys.length&&(o>10?i():h(i))};h(i)}else this.keys.forEach((function(e){var o=new t(r.json[e],r.open-1,r.config,e);n.appendChild(o.render())}))},t.prototype.removeChildren=function(t){void 0===t&&(t=!1);var e=this.element.querySelector("div."+l("children"));if(t){var r=0,n=function(){e&&e.children.length&&(e.removeChild(e.children[0]),(r+=1)>10?n():h(n))};h(n)}else e&&(e.innerHTML="")},t}();r.default=g},
"7a99dba4eb": function _(e,t,i,l,s){l();const o=e("tslib"),n=e("@bokehjs/models/widgets/input_widget"),a=e("@bokehjs/styles/buttons"),h=o.__importStar(e("@bokehjs/core/properties"));class _ extends n.InputWidgetView{constructor(){super(...arguments),this._downloadable=!1,this._embed=!1,this._prev_href="",this._prev_download=""}initialize(){super.initialize(),this.model.data&&this.model.filename&&(this._embed=!0)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.button_type.change,()=>this._update_button_style()),this.connect(this.model.properties.filename.change,()=>this._update_download()),this.connect(this.model.properties._transfers.change,()=>this._handle_click()),this.connect(this.model.properties.label.change,()=>this._update_label())}render(){super.render(),this.group_el.style.display="flex",this.group_el.style.alignItems="stretch",this.anchor_el=document.createElement("a"),this._update_button_style(),this._update_label(),this.model.disabled?(this.anchor_el.setAttribute("disabled",""),this._downloadable=!1):(this.anchor_el.removeAttribute("disabled"),this._prev_download&&(this.anchor_el.download=this._prev_download),this._prev_href&&(this.anchor_el.href=this._prev_href),this.anchor_el.download&&this.anchor_el.download&&(this._downloadable=!0)),this._embed?this._make_link_downloadable():(this._click_listener=this._increment_clicks.bind(this),this.anchor_el.addEventListener("click",this._click_listener)),this.group_el.appendChild(this.anchor_el)}_increment_clicks(){this.model.clicks=this.model.clicks+1}_handle_click(){!this.model.auto&&this._downloadable||(this._make_link_downloadable(),!this._embed&&this.model.auto&&(this.anchor_el.removeEventListener("click",this._click_listener),this.anchor_el.click(),this.anchor_el.removeAttribute("href"),this.anchor_el.removeAttribute("download"),this.anchor_el.addEventListener("click",this._click_listener)),this._prev_href=this.anchor_el.getAttribute("href"),this._prev_download=this.anchor_el.getAttribute("download"))}_make_link_downloadable(){this._update_href(),this._update_download(),this.anchor_el.download&&this.anchor_el.href&&(this._downloadable=!0)}_update_href(){if(this.model.data){const e=function(e){const t=atob(e.split(",")[1]),i=e.split(",")[0].split(":")[1].split(";")[0],l=new ArrayBuffer(t.length),s=new Uint8Array(l);for(let e=0;e<t.length;e++)s[e]=t.charCodeAt(e);return new Blob([l],{type:i})}(this.model.data);this.anchor_el.href=URL.createObjectURL(e)}}_update_download(){this.model.filename&&(this.anchor_el.download=this.model.filename)}_update_label(){this.anchor_el.textContent=this.model.label}_update_button_style(){if(this.anchor_el.hasAttribute("class")){const e=this.anchor_el.classList.item(1);e&&this.anchor_el.classList.replace(e,a.bk_btn_type(this.model.button_type))}else this.anchor_el.classList.add(a.bk_btn),this.anchor_el.classList.add(a.bk_btn_type(this.model.button_type))}}i.FileDownloadView=_,_.__name__="FileDownloadView";class d extends n.InputWidget{constructor(e){super(e)}static init_FileDownload(){this.prototype.default_view=_,this.define({auto:[h.Boolean,!1],clicks:[h.Number,0],data:[h.NullString,null],label:[h.String,"Download"],filename:[h.String,null],button_type:[h.ButtonType,"default"],_transfers:[h.Number,0]}),this.override({title:""})}}i.FileDownload=d,d.__name__="FileDownload",d.__module__="panel.models.widgets",d.init_FileDownload()},
"7b859fb3cf": function _(e,t,i,a,n){a();const s=e("@bokehjs/models/widgets/markup"),r=e("7116a7a602");class l extends r.PanelMarkupView{render(){super.render(),this.markup_el.innerHTML=this.model.text,window.renderMathInElement&&window.renderMathInElement(this.el,{delimiters:[{left:"$$",right:"$$",display:!0},{left:"\\[",right:"\\]",display:!0},{left:"$",right:"$",display:!1},{left:"\\(",right:"\\)",display:!1}]})}}i.KaTeXView=l,l.__name__="KaTeXView";class d extends s.Markup{constructor(e){super(e)}static init_KaTeX(){this.prototype.default_view=l}}i.KaTeX=d,d.__name__="KaTeX",d.__module__="panel.models.katex",d.init_KaTeX()},
"aded270681": function _(o,t,e,i,a){i();const n=o("tslib").__importStar(o("@bokehjs/core/properties")),h=o("@bokehjs/core/view"),s=o("@bokehjs/model");class c extends h.View{initialize(){super.initialize(),this.model.pathname=window.location.pathname,this.model.search=window.location.search,this.model.hash=window.location.hash,this.model.href=window.location.href,this.model.hostname=window.location.hostname,this.model.protocol=window.location.protocol,this.model.port=window.location.port}connect_signals(){super.connect_signals(),this.connect(this.model.properties.pathname.change,()=>this.update("pathname")),this.connect(this.model.properties.search.change,()=>this.update("search")),this.connect(this.model.properties.hash.change,()=>this.update("hash")),this.connect(this.model.properties.reload.change,()=>this.update("reload"))}update(o){this.model.reload&&"reload"!==o?("pathname"==o&&(window.location.pathname=this.model.pathname),"search"==o&&(window.location.search=this.model.search),"hash"==o&&(window.location.hash=this.model.hash)):(window.history.pushState({},"",`${this.model.pathname}${this.model.search}${this.model.hash}`),this.model.href=window.location.href,"reload"===o&&window.location.reload())}}e.LocationView=c,c.__name__="LocationView";class l extends s.Model{constructor(o){super(o)}static init_Location(){this.prototype.default_view=c,this.define({href:[n.String,""],hostname:[n.String,""],pathname:[n.String,""],protocol:[n.String,""],port:[n.String,""],search:[n.String,""],hash:[n.String,""],reload:[n.Boolean,!1]})}}e.Location=l,l.__name__="Location",l.__module__="panel.models.location",l.init_Location()},
"0c21036737": function _(e,t,a,i,s){i();const h=e("@bokehjs/models/widgets/markup"),_=e("7116a7a602");class n extends _.PanelMarkupView{initialize(){super.initialize(),this._hub=window.MathJax.Hub,this._hub.Config({tex2jax:{inlineMath:[["$","$"],["\\(","\\)"]]}})}render(){super.render(),this._hub&&(this.markup_el.innerHTML=this.model.text,this._hub.Queue(["Typeset",this._hub,this.markup_el]))}}a.MathJaxView=n,n.__name__="MathJaxView";class u extends h.Markup{constructor(e){super(e)}static init_MathJax(){this.prototype.default_view=n}}a.MathJax=u,u.__name__="MathJax",u.__module__="panel.models.mathjax",u.init_MathJax()},
"79c41bbf71": function _(e,t,s,i,o){i();const l=e("tslib").__importStar(e("@bokehjs/core/properties")),n=e("@bokehjs/core/dom"),a=e("@bokehjs/models/widgets/widget");function r(e){e.forEach(e=>e.style.borderStyle="inset")}function d(e){e.forEach(e=>e.style.borderStyle="outset")}class h extends a.WidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render()),this.connect(this.model.properties.value.change,()=>this.render()),this.connect(this.model.properties.loop_policy.change,()=>this.set_loop_state(this.model.loop_policy)),this.connect(this.model.properties.show_loop_controls.change,()=>{this.model.show_loop_controls&&this.loop_state.parentNode!=this.groupEl?this.groupEl.appendChild(this.loop_state):this.model.show_loop_controls||this.loop_state.parentNode!=this.groupEl||this.el.removeChild(this.loop_state)})}get_height(){return 250}render(){if(null!=this.sliderEl)return this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),void(this.sliderEl.value=String(this.model.value));super.render(),this.groupEl=n.div(),this.groupEl.style.display="flex",this.groupEl.style.flexDirection="column",this.groupEl.style.alignItems="center",this.sliderEl=document.createElement("input"),this.sliderEl.style.width="100%",this.sliderEl.setAttribute("type","range"),this.sliderEl.value=String(this.model.value),this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.onchange=e=>this.set_frame(parseInt(e.target.value));const e=n.div();e.style.cssText="margin: 0 auto; display: flex; padding: 5px; align-items: stretch; width: 100%;";const t="text-align: center; min-width: 20px; flex-grow: 1; margin: 2px",s="text-align: center; min-width: 40px; flex-grow: 2; margin: 2px",i=document.createElement("button");i.style.cssText=t,i.appendChild(document.createTextNode("–")),i.onclick=()=>this.slower(),e.appendChild(i);const o=document.createElement("button");o.style.cssText=s,o.appendChild(document.createTextNode("❚◀◀")),o.onclick=()=>this.first_frame(),e.appendChild(o);const l=document.createElement("button");l.style.cssText=s,l.appendChild(document.createTextNode("❚◀")),l.onclick=()=>this.previous_frame(),e.appendChild(l);const a=document.createElement("button");a.style.cssText=s,a.appendChild(document.createTextNode("◀")),a.onclick=()=>this.reverse_animation(),e.appendChild(a);const h=document.createElement("button");h.style.cssText=s,h.appendChild(document.createTextNode("❚❚")),h.onclick=()=>this.pause_animation(),e.appendChild(h);const p=document.createElement("button");p.style.cssText=s,p.appendChild(document.createTextNode("▶")),p.onclick=()=>this.play_animation(),e.appendChild(p);const c=document.createElement("button");c.style.cssText=s,c.appendChild(document.createTextNode("▶❚")),c.onclick=()=>this.next_frame(),e.appendChild(c);const m=document.createElement("button");m.style.cssText=s,m.appendChild(document.createTextNode("▶▶❚")),m.onclick=()=>this.last_frame(),e.appendChild(m);const _=document.createElement("button");_.style.cssText=t,_.appendChild(document.createTextNode("+")),_.onclick=()=>this.faster(),e.appendChild(_),this._toggle_reverse=()=>{d([h,p]),r([a])},this._toogle_pause=()=>{d([a,p]),r([h])},this._toggle_play=()=>{d([a,h]),r([p])},this.loop_state=document.createElement("form"),this.loop_state.style.cssText="margin: 0 auto; display: table";const u=document.createElement("input");u.type="radio",u.value="once",u.name="state";const g=document.createElement("label");g.innerHTML="Once",g.style.cssText="padding: 0 10px 0 5px; user-select:none;";const f=document.createElement("input");f.setAttribute("type","radio"),f.setAttribute("value","loop"),f.setAttribute("name","state");const v=document.createElement("label");v.innerHTML="Loop",v.style.cssText="padding: 0 10px 0 5px; user-select:none;";const y=document.createElement("input");y.setAttribute("type","radio"),y.setAttribute("value","reflect"),y.setAttribute("name","state");const x=document.createElement("label");x.innerHTML="Reflect",x.style.cssText="padding: 0 10px 0 5px; user-select:none;","once"==this.model.loop_policy?u.checked=!0:"loop"==this.model.loop_policy?f.checked=!0:y.checked=!0,this.loop_state.appendChild(u),this.loop_state.appendChild(g),this.loop_state.appendChild(f),this.loop_state.appendChild(v),this.loop_state.appendChild(y),this.loop_state.appendChild(x),this.groupEl.appendChild(this.sliderEl),this.groupEl.appendChild(e),this.model.show_loop_controls&&this.groupEl.appendChild(this.loop_state),this.el.appendChild(this.groupEl)}set_frame(e){this.model.value!=e&&(this.model.value=e),this.sliderEl.value!=String(e)&&(this.sliderEl.value=String(e))}get_loop_state(){for(var e=this.loop_state.state,t=0;t<e.length;t++){var s=e[t];if(s.checked)return s.value}return"once"}set_loop_state(e){for(var t=this.loop_state.state,s=0;s<t.length;s++){var i=t[s];i.value==e&&(i.checked=!0)}}next_frame(){this.set_frame(Math.min(this.model.end,this.model.value+this.model.step))}previous_frame(){this.set_frame(Math.max(this.model.start,this.model.value-this.model.step))}first_frame(){this.set_frame(this.model.start)}last_frame(){this.set_frame(this.model.end)}slower(){this.model.interval=Math.round(this.model.interval/.7),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}faster(){this.model.interval=Math.round(.7*this.model.interval),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}anim_step_forward(){if(this.model.value<this.model.end)this.next_frame();else{var e=this.get_loop_state();"loop"==e?this.first_frame():"reflect"==e?(this.last_frame(),this.reverse_animation()):(this.pause_animation(),this.last_frame())}}anim_step_reverse(){if(this.model.value>this.model.start)this.previous_frame();else{var e=this.get_loop_state();"loop"==e?this.last_frame():"reflect"==e?(this.first_frame(),this.play_animation()):(this.pause_animation(),this.first_frame())}}pause_animation(){this._toogle_pause(),this.model.direction=0,this.timer&&(clearInterval(this.timer),this.timer=null)}play_animation(){this.pause_animation(),this._toggle_play(),this.model.direction=1,this.timer||(this.timer=setInterval(()=>this.anim_step_forward(),this.model.interval))}reverse_animation(){this.pause_animation(),this._toggle_reverse(),this.model.direction=-1,this.timer||(this.timer=setInterval(()=>this.anim_step_reverse(),this.model.interval))}}s.PlayerView=h,h.__name__="PlayerView";class p extends a.Widget{constructor(e){super(e)}static init_Player(){this.prototype.default_view=h,this.define({direction:[l.Number,0],interval:[l.Number,500],start:[l.Number],end:[l.Number],step:[l.Number,1],loop_policy:[l.Any,"once"],value:[l.Any,0],show_loop_controls:[l.Boolean,!0]}),this.override({width:400})}}s.Player=p,p.__name__="Player",p.__module__="panel.models.widgets",p.init_Player()},
"56da045fbd": function _(t,e,o,i,l){i();const r=t("tslib").__importStar(t("@bokehjs/core/properties")),s=t("@bokehjs/core/util/object"),n=t("@bokehjs/core/util/eq"),a=t("@bokehjs/models/layouts/html_box"),p=t("99a25e6992"),h=t("990b5dd5c7"),_=t("7116a7a602"),d=(t,e,o)=>{let i=Array.isArray(e)?[]:{};if("click"===o||"hover"===o||"selected"===o){const o=[];if(null==e)return null;const l=t.data;for(let t=0;t<e.points.length;t++){const i=e.points[t];let r={};for(let t in i){const e=i[t];!i.hasOwnProperty(t)||Array.isArray(e)||h.isPlainObject(e)||(r[t]=e)}null!=i&&(i.hasOwnProperty("curveNumber")&&i.hasOwnProperty("pointNumber")&&l[i.curveNumber].hasOwnProperty("customdata")&&(r.customdata=l[i.curveNumber].customdata[i.pointNumber]),i.hasOwnProperty("pointNumbers")&&(r.pointNumbers=i.pointNumbers)),o[t]=r}i.points=o}else if("relayout"===o||"restyle"===o)for(let t in e)e.hasOwnProperty(t)&&(i[t]=e[t]);return e.hasOwnProperty("range")&&(i.range=e.range),e.hasOwnProperty("lassoPoints")&&(i.lassoPoints=e.lassoPoints),i};class u extends _.PanelHTMLBoxView{constructor(){super(...arguments),this._settingViewport=!1,this._plotInitialized=!1,this._reacting=!1,this._relayouting=!1,this._end_relayouting=p.debounce(()=>{this._relayouting=!1},2e3,!1)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.viewport_update_policy.change,this._updateSetViewportFunction),this.connect(this.model.properties.viewport_update_throttle.change,this._updateSetViewportFunction),this.connect(this.model.properties._render_count.change,this.plot),this.connect(this.model.properties.viewport.change,this._updateViewportFromProperty)}render(){super.render(),window.Plotly&&this.plot()}plot(){if(!window.Plotly)return;const t=[];for(let e=0;e<this.model.data.length;e++)t.push(this._get_trace(e,!1));let e=h.deepCopy(this.model.layout);if(this._relayouting){const t=this.el.layout;Object.keys(t).reduce((t,o)=>{"axis"===o.slice(1,5)&&"range"in t&&(e[o].range=t.range)},{})}this._reacting=!0,window.Plotly.react(this.el,t,e,this.model.config).then(()=>{this._updateSetViewportFunction(),this._updateViewportProperty(),this._plotInitialized||(this.el.on("plotly_relayout",t=>{!0!==t._update_from_property&&(this.model.relayout_data=d(this.el,t,"relayout"),this._updateViewportProperty(),this._end_relayouting())}),this.el.on("plotly_relayouting",()=>{"mouseup"!==this.model.viewport_update_policy&&(this._relayouting=!0,this._updateViewportProperty())}),this.el.on("plotly_restyle",t=>{this.model.restyle_data=d(this.el,t,"restyle"),this._updateViewportProperty()}),this.el.on("plotly_click",t=>{this.model.click_data=d(this.el,t,"click")}),this.el.on("plotly_hover",t=>{this.model.hover_data=d(this.el,t,"hover")}),this.el.on("plotly_selected",t=>{this.model.selected_data=d(this.el,t,"selected")}),this.el.on("plotly_clickannotation",t=>{delete t.event,delete t.fullAnnotation,this.model.clickannotation_data=t}),this.el.on("plotly_deselect",()=>{this.model.selected_data=null}),this.el.on("plotly_unhover",()=>{this.model.hover_data=null})),this._plotInitialized=!0,this._reacting=!1})}_get_trace(t,e){const o=s.clone(this.model.data[t]),i=this.model.data_sources[t];for(const t of i.columns()){let l=i.get_array(t)[0];if(null!=l.shape&&l.shape.length>1){const t=[],e=l.shape;for(let o=0;o<e[0];o++)t.push(l.slice(o*e[1],(o+1)*e[1]));l=t}let r=t.split("."),s=r[r.length-1],n=o;for(let t of r.slice(0,-1))n=n[t];e&&1==r.length?n[s]=[l]:n[s]=l}return o}_updateViewportFromProperty(){if(!window.Plotly||this._settingViewport||this._reacting||!this.model.viewport)return;const t=this.el._fullLayout;Object.keys(this.model.viewport).reduce((e,o)=>{if(n.isEqual(h.get(t,o),e))return!0;{let t=h.deepCopy(this.model.viewport);return t._update_from_property=!0,window.Plotly.relayout(this.el,t),!1}},{})}_updateViewportProperty(){const t=this.el._fullLayout;let e={};for(let o in t){if(!t.hasOwnProperty(o))continue;let i=o.slice(0,5);"xaxis"!==i&&"yaxis"!==i||(e[o+".range"]=h.deepCopy(t[o].range))}n.isEqual(e,this.model.viewport)||this._setViewport(e)}_updateSetViewportFunction(){"continuous"===this.model.viewport_update_policy||"mouseup"===this.model.viewport_update_policy?this._setViewport=t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}:this._setViewport=h.throttle(t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)},this.model.viewport_update_throttle)}}o.PlotlyPlotView=u,u.__name__="PlotlyPlotView";class c extends a.HTMLBox{constructor(t){super(t)}static init_PlotlyPlot(){this.prototype.default_view=u,this.define({data:[r.Array,[]],layout:[r.Any,{}],config:[r.Any,{}],data_sources:[r.Array,[]],relayout_data:[r.Any,{}],restyle_data:[r.Array,[]],click_data:[r.Any,{}],hover_data:[r.Any,{}],clickannotation_data:[r.Any,{}],selected_data:[r.Any,{}],viewport:[r.Any,{}],viewport_update_policy:[r.String,"mouseup"],viewport_update_throttle:[r.Number,200],_render_count:[r.Number,0]})}}o.PlotlyPlot=c,c.__name__="PlotlyPlot",c.__module__="panel.models.plotly",c.init_PlotlyPlot()},
"99a25e6992": function _(n,l,u,t,e){function o(n,l,u){var t,e,o,a,r;function i(){var c=Date.now()-a;c<l&&c>=0?t=setTimeout(i,l-c):(t=null,u||(r=n.apply(o,e),o=e=null))}null==l&&(l=100);var c=function(){o=this,e=arguments,a=Date.now();var c=u&&!t;return t||(t=setTimeout(i,l)),c&&(r=n.apply(o,e),o=e=null),r};return c.clear=function(){t&&(clearTimeout(t),t=null)},c.flush=function(){t&&(r=n.apply(o,e),o=e=null,clearTimeout(t),t=null)},c}o.debounce=o,l.exports=o},
"990b5dd5c7": function _(t,n,r,e,o){e(),r.get=(t,n,r)=>{const e=r=>String.prototype.split.call(n,r).filter(Boolean).reduce((t,n)=>null!=t?t[n]:t,t),o=e(/[,[\]]+?/)||e(/[,[\].]+?/);return void 0===o||o===t?r:o},r.throttle=function(t,n){var r=0;return function(){var e=Number(new Date);e-r>=n&&(t(),r=e)}},r.deepCopy=function t(n){var r;if(null==n||"object"!=typeof n)return n;if(n instanceof Array){r=[];for(var e=0,o=n.length;e<o;e++)r[e]=t(n[e]);return r}if(n instanceof Object){const r={};for(const e in n){const o=e;n.hasOwnProperty(o)&&(r[o]=t(n[o]))}return r}throw new Error("Unable to copy obj! Its type isn't supported.")},r.isPlainObject=function(t){return"[object Object]"===Object.prototype.toString.call(t)}},
"765e9cea08": function _(e,s,t,i,o){i();const r=e("tslib").__importStar(e("@bokehjs/core/properties")),h=e("@bokehjs/models/layouts/html_box"),l=e("7116a7a602");class n extends h.HTMLBoxView{connect_signals(){super.connect_signals();const e=()=>{this.render(),this.root.compute_layout()};this.connect(this.model.properties.height.change,e),this.connect(this.model.properties.width.change,e),this.connect(this.model.properties.height_policy.change,e),this.connect(this.model.properties.width_policy.change,e),this.connect(this.model.properties.sizing_mode.change,e),this.connect(this.model.properties.active.change,()=>this.setCSS()),this.connect(this.model.properties.bar_color.change,()=>this.setCSS()),this.connect(this.model.properties.css_classes.change,()=>this.setCSS()),this.connect(this.model.properties.value.change,()=>this.setValue()),this.connect(this.model.properties.max.change,()=>this.setMax())}render(){super.render();const e=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.progressEl=document.createElement("progress"),this.setValue(),this.setMax(),l.set_size(this.progressEl,this.model),this.setCSS();for(const s in e)this.progressEl.style.setProperty(s,e[s]);this.el.appendChild(this.progressEl)}setCSS(){let e=this.model.css_classes.join(" ")+" "+this.model.bar_color;this.model.active&&(e+=" active"),this.progressEl.className=e}setValue(){null!=this.model.value&&(this.progressEl.value=this.model.value)}setMax(){null!=this.model.max&&(this.progressEl.max=this.model.max)}_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new l.CachedVariadicBox(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}}t.ProgressView=n,n.__name__="ProgressView";class c extends h.HTMLBox{constructor(e){super(e)}static init_Progress(){this.prototype.default_view=n,this.define({active:[r.Boolean,!0],bar_color:[r.String,"primary"],style:[r.Any,{}],max:[r.Number,100],value:[r.Any,null]})}}t.Progress=c,c.__name__="Progress",c.__module__="panel.models.widgets",c.init_Progress()},
"ff9dd91f7b": function _(e,t,s,i,n){i();const l=e("tslib"),o=e("@bokehjs/core/dom"),c=e("@bokehjs/core/util/types"),r=l.__importStar(e("@bokehjs/core/properties")),h=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/styles/widgets/inputs");class p extends h.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,()=>this.render_selection()),this.connect(this.model.properties.options.change,()=>this.render()),this.connect(this.model.properties.name.change,()=>this.render()),this.connect(this.model.properties.title.change,()=>this.render()),this.connect(this.model.properties.size.change,()=>this.render()),this.connect(this.model.properties.disabled.change,()=>this.render())}render(){super.render();const e=this.model.options.map(e=>{let t,s;return c.isString(e)?t=s=e:[t,s]=e,o.option({value:t},s)});this.select_el=o.select({multiple:!1,class:d.bk_input,name:this.model.name,disabled:this.model.disabled},e),this.select_el.style.backgroundImage="none",this.select_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.select_el),this.render_selection()}render_selection(){const e=this.model.value;for(const t of this.el.querySelectorAll("option"))t.value===e&&(t.selected=!0);this.select_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus");let t=null;for(const e of this.el.querySelectorAll("option"))if(e.selected){t=e.value;break}this.model.value=t,super.change_input(),e&&this.select_el.focus()}}s.SingleSelectView=p,p.__name__="SingleSelectView";class a extends h.InputWidget{constructor(e){super(e)}static init_SingleSelect(){this.prototype.default_view=p,this.define({value:[r.String,""],options:[r.Array,[]],size:[r.Number,4]})}}s.SingleSelect=a,a.__name__="SingleSelect",a.__module__="panel.models.widgets",a.init_SingleSelect()},
"38b2bc9574": function _(e,t,s,i,a){i();const o=e("tslib").__importStar(e("@bokehjs/core/properties")),c=e("@bokehjs/core/view"),n=e("@bokehjs/core/util/array"),r=e("@bokehjs/model"),h=e("@bokehjs/protocol/receiver");class _ extends c.View{renderTo(){}}s.StateView=_,_.__name__="StateView";class p extends r.Model{constructor(e){super(e),this._receiver=new h.Receiver,this._cache={}}apply_state(e){this._receiver.consume(e.header),this._receiver.consume(e.metadata),this._receiver.consume(e.content),this._receiver.message&&this.document&&this.document.apply_json_patch(this._receiver.message.content)}_receive_json(e,t){const s=JSON.parse(e);this._cache[t]=s;let i=this.state;for(const e of this.values)i=i[e];i===t?this.apply_state(s):this._cache[i]&&this.apply_state(this._cache[i])}set_state(e,t){let s=n.copy(this.values);s[this.widgets[e.id]]=t;let i=this.state;for(const e of s)i=i[e];var a,o,c;this.values=s,this.json?this._cache[i]?this.apply_state(this._cache[i]):(a=i,o=e=>this._receive_json(e,i),(c=new XMLHttpRequest).overrideMimeType("application/json"),c.open("GET",a,!0),c.onreadystatechange=function(){4==c.readyState&&200==c.status&&o(c.responseText)},c.send(null)):this.apply_state(i)}static init_State(){this.prototype.default_view=_,this.define({json:[o.Boolean,!1],state:[o.Any,{}],widgets:[o.Any,{}],values:[o.Any,[]]})}}s.State=p,p.__name__="State",p.__module__="panel.models.state",p.init_State()},
"294adeb985": function _(t,e,s,o,a){o();const n=t("tslib").__importStar(t("@bokehjs/core/properties")),c=t("@bokehjs/core/util/types"),i=t("@bokehjs/models/layouts/html_box");class d extends i.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,this._plot),this.connect(this.model.properties.data_sources.change,()=>this._connect_sources()),this._connected=[],this._connect_sources()}_connect_sources(){for(const t in this.model.data_sources){const e=this.model.data_sources[t];this._connected.indexOf(t)<0&&(this.connect(e.properties.data.change,this._plot),this._connected.push(t))}}_fetch_datasets(){const t={};for(const e in this.model.data_sources){const s=this.model.data_sources[e],o=[],a=s.columns();for(let t=0;t<s.get_length();t++){const e={};for(const o of a)e[o]=s.data[o][t];o.push(e)}t[e]=o}return t}render(){super.render(),this._plot()}_plot(){const t=this.model.data;if(null!=t&&window.vegaEmbed){if(this.model.data_sources&&Object.keys(this.model.data_sources).length>0){const e=this._fetch_datasets();if("data"in e&&(t.data.values=e.data,delete e.data),null!=t.data){const s=c.isArray(t.data)?t.data:[t.data];for(const t of s)t.name in e&&(t.values=e[t.name],delete e[t.name])}this.model.data.datasets=e}window.vegaEmbed(this.el,this.model.data,{actions:!1})}}}s.VegaPlotView=d,d.__name__="VegaPlotView";class l extends i.HTMLBox{constructor(t){super(t)}static init_VegaPlot(){this.prototype.default_view=d,this.define({data:[n.Any],data_sources:[n.Any]})}}s.VegaPlot=l,l.__name__="VegaPlot",l.__module__="panel.models.vega",l.init_VegaPlot()},
"b0c3e9e9c2": function _(e,i,t,o,s){o();const l=e("tslib").__importStar(e("@bokehjs/core/properties")),d=e("@bokehjs/models/layouts/html_box"),h=e("7116a7a602");class m extends h.PanelHTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,()=>this.set_loop()),this.connect(this.model.properties.paused.change,()=>this.set_paused()),this.connect(this.model.properties.time.change,()=>this.set_time()),this.connect(this.model.properties.value.change,()=>this.set_value()),this.connect(this.model.properties.volume.change,()=>this.set_volume())}render(){super.render(),this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.videoEl.controls=!0,this.videoEl.src=this.model.value,this.videoEl.currentTime=this.model.time,this.videoEl.loop=this.model.loop,null!=this.model.volume?this.videoEl.volume=this.model.volume/100:this.model.volume=100*this.videoEl.volume,this.videoEl.onpause=()=>this.model.paused=!0,this.videoEl.onplay=()=>this.model.paused=!1,this.videoEl.ontimeupdate=()=>this.update_time(this),this.videoEl.onvolumechange=()=>this.update_volume(this),this.el.appendChild(this.videoEl),this.model.paused||this.videoEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.videoEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.videoEl.volume)}set_loop(){this.videoEl.loop=this.model.loop}set_paused(){!this.videoEl.paused&&this.model.paused&&this.videoEl.pause(),this.videoEl.paused&&!this.model.paused&&this.videoEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.videoEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.videoEl.currentTime=this.model.time)}set_value(){this.videoEl.src=this.model.value}}t.VideoView=m,m.__name__="VideoView";class n extends d.HTMLBox{constructor(e){super(e)}static init_Video(){this.prototype.default_view=m,this.define({loop:[l.Boolean,!1],paused:[l.Boolean,!0],time:[l.Number,0],throttle:[l.Number,250],value:[l.Any,""],volume:[l.Number,null]})}}t.Video=n,n.__name__="Video",n.__module__="panel.models.widgets",n.init_Video()},
"3c7145a2fa": function _(e,t,i,s,o){s();const h=e("tslib").__importStar(e("@bokehjs/core/properties")),a=e("@bokehjs/models/layouts/html_box"),l=e("7116a7a602");class n extends l.PanelHTMLBoxView{constructor(){super(...arguments),this.constraints={audio:!1,video:!0}}initialize(){super.initialize(),null!==this.model.timeout&&this.set_timeout()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.timeout.change,()=>this.set_timeout()),this.connect(this.model.properties.snapshot.change,()=>this.snapshot()),this.connect(this.model.properties.paused.change,()=>this.pause())}pause(){this.model.paused&&(null!=this.timer&&(clearInterval(this.timer),this.timer=null),this.videoEl.pause()),this.set_timeout()}set_timeout(){this.timer&&(clearInterval(this.timer),this.timer=null),this.model.timeout>0&&(this.timer=setInterval(()=>this.snapshot(),this.model.timeout))}snapshot(){this.canvasEl.width=this.videoEl.videoWidth,this.canvasEl.height=this.videoEl.videoHeight;const e=this.canvasEl.getContext("2d");e&&e.drawImage(this.videoEl,0,0,this.canvasEl.width,this.canvasEl.height),this.model.value=this.canvasEl.toDataURL("image/"+this.model.format,.95)}remove(){super.remove(),this.timer&&(clearInterval(this.timer),this.timer=null)}render(){super.render(),this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.canvasEl=document.createElement("canvas"),this.el.appendChild(this.videoEl),navigator.mediaDevices.getUserMedia&&navigator.mediaDevices.getUserMedia(this.constraints).then(e=>{this.videoEl.srcObject=e,this.model.paused||this.videoEl.play()}).catch(console.error))}}i.VideoStreamView=n,n.__name__="VideoStreamView";class d extends a.HTMLBox{constructor(e){super(e)}static init_VideoStream(){this.prototype.default_view=n,this.define({format:[h.String,"png"],paused:[h.Boolean,!1],snapshot:[h.Boolean,!1],timeout:[h.Number,0],value:[h.Any]}),this.override({height:240,width:320})}}i.VideoStream=d,d.__name__="VideoStream",d.__module__="panel.models.widgets",d.init_VideoStream()},
"c51f25e2a7": function _(o,V,l,K,T){K(),T("VTKJSPlot",o("01c83f92ba").VTKJSPlot),T("VTKVolumePlot",o("075632b08f").VTKVolumePlot),T("VTKAxes",o("3ae7537200").VTKAxes),T("VTKSynchronizedPlot",o("b2f9f50873").VTKSynchronizedPlot)},
"01c83f92ba": function _(e,t,n,i,s){i();const r=e("tslib").__importStar(e("@bokehjs/core/properties")),a=e("2035cdc8c2"),o=e("dd7268f5c4");class _ extends a.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,()=>{this.invalidate_render()})}render(){super.render(),this._create_orientation_widget(),this._set_axes()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=o.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._vtk_container})}plot(){if(!this.model.data)return void this._vtk_renwin.getRenderWindow().render();const e=o.vtkns.DataAccessHelper.get("zip",{zipContent:atob(this.model.data),callback:t=>{const n=o.vtkns.HttpSceneLoader.newInstance({renderer:this._vtk_renwin.getRenderer(),dataAccessHelper:e}),i=o.vtk.macro.debounce(()=>setTimeout(()=>{null==this._axes&&this.model.axes&&this._set_axes(),this._set_camera_state(),this.model.properties.camera.change.emit()},100),100);n.setUrl("index.json"),n.onReady(i)}})}}n.VTKJSPlotView=_,_.__name__="VTKJSPlotView";class c extends a.AbstractVTKPlot{static init_VTKJSPlot(){this.prototype.default_view=_,this.define({data:[r.String],enable_keybindings:[r.Boolean,!1]})}}n.VTKJSPlot=c,c.__name__="VTKJSPlot",c.init_VTKJSPlot()},
"2035cdc8c2": function _(e,t,i,n,s){n();const r=e("tslib").__importStar(e("@bokehjs/core/properties")),a=e("@bokehjs/core/dom"),o=e("@bokehjs/models/layouts/html_box"),_=e("@bokehjs/core/util/object"),d=e("7116a7a602"),c=e("dd7268f5c4"),h=e("e4fabdee71"),l={padding:"0px 2px 0px 2px",maxHeight:"150px",height:"auto",backgroundColor:"rgba(255, 255, 255, 0.4)",borderRadius:"10px",margin:"2px",boxSizing:"border-box",overflow:"hidden",overflowY:"auto",transition:"width 0.1s linear",bottom:"0px",position:"absolute"};class g extends d.PanelHTMLBoxView{initialize(){super.initialize(),this._camera_callbacks=[],this._renderable=!0,this._setting_camera=!1}_add_colorbars(){const e=this.el.querySelector(".vtk_info");if(e&&this.el.removeChild(e),this.model.color_mappers.length<1)return;const t=document.createElement("div"),i="350px",n="30px";t.classList.add("vtk_info"),c.applyStyle(t,l),c.applyStyle(t,{width:i}),this.el.appendChild(t);const s=[];this.model.color_mappers.forEach(e=>{const i=new h.VTKColorBar(t,e);s.push(i)});const r=document.createElement("div");c.applyStyle(r,{textAlign:"center",fontSize:"20px"}),r.innerText="...",t.addEventListener("click",()=>{t.style.width===n?(t.removeChild(r),c.applyStyle(t,{height:"auto",width:i}),s.forEach(e=>t.appendChild(e.canvas))):(s.forEach(e=>t.removeChild(e.canvas)),c.applyStyle(t,{height:n,width:n}),t.appendChild(r))}),t.click()}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.orientation_widget,()=>{this._orientation_widget_visibility(this.model.orientation_widget)}),this.on_change(this.model.properties.camera,()=>this._set_camera_state()),this.on_change(this.model.properties.axes,()=>{this._delete_axes(),this.model.axes&&this._set_axes(),this._vtk_render()}),this.on_change(this.model.properties.color_mappers,()=>this._add_colorbars())}render(){super.render(),this._vtk_renwin&&this._vtk_container?(d.set_size(this._vtk_container,this.model),this.el.appendChild(this._vtk_container)):(this._orientationWidget=null,this._axes=null,this._vtk_container=a.div(),this.init_vtk_renwin(),d.set_size(this._vtk_container,this.model),this.el.appendChild(this._vtk_container),this._connect_interactions_to_model(),this._remove_default_key_binding(),this._bind_key_events(),this.plot(),this._add_colorbars(),this.model.renderer_el=this._vtk_renwin)}after_layout(){super.after_layout(),this._renderable&&this._vtk_renwin.resize(),this._vtk_render()}invalidate_render(){this._unsubscribe_camera_cb(),super.invalidate_render()}remove(){this._unsubscribe_camera_cb(),window.removeEventListener("resize",this._vtk_renwin.resize),this._vtk_renwin.delete(),super.remove()}get _vtk_camera_state(){const e=this._vtk_renwin.getRenderer().getActiveCamera();let t;return e&&(t=_.clone(e.get()),delete t.classHierarchy,delete t.vtkObject,delete t.vtkCamera,delete t.viewPlaneNormal,delete t.flattenedDepIds,delete t.managedInstanceId,delete t.directionOfProjection,delete t.projectionMatrix,delete t.viewMatrix,delete t.physicalTranslation,delete t.physicalScale,delete t.physicalViewUp,delete t.physicalViewNorth,delete t.mtime),t}get _axes_canvas(){let e=this._vtk_container.querySelector(".axes-canvas");return e||(e=a.canvas({style:{position:"absolute",top:"0",left:"0",width:"100%",height:"100%"}}),e.classList.add("axes-canvas"),this._vtk_container.appendChild(e),this._vtk_renwin.setResizeCallback(()=>{if(this._axes_canvas){const e=this._vtk_container.getBoundingClientRect(),t=Math.floor(e.width*window.devicePixelRatio),i=Math.floor(e.height*window.devicePixelRatio);this._axes_canvas.setAttribute("width",t.toFixed()),this._axes_canvas.setAttribute("height",i.toFixed())}})),e}_bind_key_events(){this.el.addEventListener("mouseenter",()=>{const e=this._vtk_renwin.getInteractor();this.model.enable_keybindings&&(document.querySelector("body").addEventListener("keypress",e.handleKeyPress),document.querySelector("body").addEventListener("keydown",e.handleKeyDown),document.querySelector("body").addEventListener("keyup",e.handleKeyUp))}),this.el.addEventListener("mouseleave",()=>{const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)})}_connect_interactions_to_model(){const e=()=>{this._get_camera_state(),this.model.properties.camera.change.emit()},t=this._vtk_renwin.getInteractor();["LeftButtonRelease","RightButtonRelease","EndAnimation"].forEach(i=>t["on"+i](e))}_create_orientation_widget(){const e=c.vtkns.AxesActor.newInstance();this._orientationWidget=c.vtkns.OrientationMarkerWidget.newInstance({actor:e,interactor:this._vtk_renwin.getInteractor()}),this._orientationWidget.setEnabled(!0),this._orientationWidget.setViewportCorner(c.vtkns.OrientationMarkerWidget.Corners.BOTTOM_RIGHT),this._orientationWidget.setViewportSize(.15),this._orientationWidget.setMinPixelSize(75),this._orientationWidget.setMaxPixelSize(300),this._widgetManager=c.vtkns.WidgetManager.newInstance(),this._widgetManager.setRenderer(this._orientationWidget.getRenderer());const t=c.vtkns.InteractiveOrientationWidget.newInstance();t.placeWidget(e.getBounds()),t.setBounds(e.getBounds()),t.setPlaceFactor(1);this._widgetManager.addWidget(t).onOrientationChange(({direction:e})=>{const t=this._vtk_renwin.getRenderer().getActiveCamera(),i=t.getFocalPoint(),n=t.getPosition(),s=t.getViewUp(),r=Math.sqrt(Math.pow(n[0]-i[0],2)+Math.pow(n[1]-i[1],2)+Math.pow(n[2]-i[2],2));t.setPosition(i[0]+e[0]*r,i[1]+e[1]*r,i[2]+e[2]*r),e[0]&&t.setViewUp(c.majorAxis(s,1,2)),e[1]&&t.setViewUp(c.majorAxis(s,0,2)),e[2]&&t.setViewUp(c.majorAxis(s,0,1)),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render()}),this._orientation_widget_visibility(this.model.orientation_widget)}_delete_axes(){if(this._axes){Object.keys(this._axes).forEach(e=>this._vtk_renwin.getRenderer().removeActor(this._axes[e])),this._axes=null;const e=this._axes_canvas.getContext("2d");e&&e.clearRect(0,0,this._axes_canvas.clientWidth*window.devicePixelRatio,this._axes_canvas.clientHeight*window.devicePixelRatio)}}_get_camera_state(){this._setting_camera||(this._setting_camera=!0,this.model.camera=this._vtk_camera_state,this._setting_camera=!1)}_orientation_widget_visibility(e){this._orientationWidget.setEnabled(e),e?this._widgetManager.enablePicking():this._widgetManager.disablePicking(),this._vtk_render()}_remove_default_key_binding(){const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}_set_axes(){if(this.model.axes&&this._vtk_renwin.getRenderer()){const{psActor:e,axesActor:t,gridActor:i}=this.model.axes.create_axes(this._axes_canvas);this._axes={psActor:e,axesActor:t,gridActor:i},this._vtk_renwin.getRenderer().addActor(e),this._vtk_renwin.getRenderer().addActor(t),this._vtk_renwin.getRenderer().addActor(i)}}_set_camera_state(){this._setting_camera||(this._setting_camera=!0,this.model.camera&&JSON.stringify(this.model.camera)!=JSON.stringify(this._vtk_camera_state)&&this._vtk_renwin.getRenderer().getActiveCamera().set(this.model.camera),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render(),this._setting_camera=!1)}_unsubscribe_camera_cb(){this._camera_callbacks.splice(0,this._camera_callbacks.length).map(e=>e.unsubscribe())}_vtk_render(){this._renderable&&(this._orientationWidget&&this._orientationWidget.updateMarkerOrientation(),this._vtk_renwin.getRenderWindow().render())}}i.AbstractVTKView=g,g.__name__="AbstractVTKView";class v extends o.HTMLBox{constructor(e){super(e)}getActors(){return this.renderer_el.getRenderer().getActors()}static init_AbstractVTKPlot(){this.define({axes:[r.Instance],camera:[r.Instance],color_mappers:[r.Array,[]],orientation_widget:[r.Boolean,!1]}),this.override({height:300,width:300})}}i.AbstractVTKPlot=v,v.__name__="AbstractVTKPlot",v.__module__="panel.models.vtk",v.init_AbstractVTKPlot()},
"dd7268f5c4": function _(e,t,n,r,a){r();const o=e("@bokehjs/core/util/array"),k=e("298ed440f5"),i=e("f348d37cc5");if(n.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},n.vtk=window.vtk,n.vtkns={},n.vtk){n.vtkns.Actor=n.vtk.Rendering.Core.vtkActor,n.vtkns.AxesActor=n.vtk.Rendering.Core.vtkAxesActor,n.vtkns.Base64=n.vtk.Common.Core.vtkBase64,n.vtkns.BoundingBox=n.vtk.Common.DataModel.vtkBoundingBox,n.vtkns.Camera=n.vtk.Rendering.Core.vtkCamera,n.vtkns.ColorTransferFunction=n.vtk.Rendering.Core.vtkColorTransferFunction,n.vtkns.CubeSource=n.vtk.Filters.Sources.vtkCubeSource,n.vtkns.DataAccessHelper=n.vtk.IO.Core.DataAccessHelper,n.vtkns.DataArray=n.vtk.Common.Core.vtkDataArray,n.vtkns.Follower=k.Follower,n.vtkns.FullScreenRenderWindow=n.vtk.Rendering.Misc.vtkFullScreenRenderWindow,n.vtkns.Glyph3DMapper=n.vtk.Rendering.Core.vtkGlyph3DMapper,n.vtkns.HttpSceneLoader=n.vtk.IO.Core.vtkHttpSceneLoader,n.vtkns.ImageData=n.vtk.Common.DataModel.vtkImageData,n.vtkns.ImageMapper=n.vtk.Rendering.Core.vtkImageMapper,n.vtkns.ImageProperty=n.vtk.Rendering.Core.vtkImageProperty,n.vtkns.ImageSlice=n.vtk.Rendering.Core.vtkImageSlice,n.vtkns.InteractiveOrientationWidget=n.vtk.Widgets.Widgets3D.vtkInteractiveOrientationWidget,n.vtkns.InteractorStyleTrackballCamera=n.vtk.Interaction.Style.vtkInteractorStyleTrackballCamera,n.vtkns.Light=n.vtk.Rendering.Core.vtkLight,n.vtkns.LineSource=n.vtk.Filters.Sources.vtkLineSource,n.vtkns.LookupTable=n.vtk.Common.Core.vtkLookupTable,n.vtkns.macro=n.vtk.macro,n.vtkns.Mapper=n.vtk.Rendering.Core.vtkMapper,n.vtkns.OpenGLRenderWindow=n.vtk.Rendering.OpenGL.vtkRenderWindow,n.vtkns.OrientationMarkerWidget=n.vtk.Interaction.Widgets.vtkOrientationMarkerWidget,n.vtkns.OutlineFilter=n.vtk.Filters.General.vtkOutlineFilter,n.vtkns.PiecewiseFunction=n.vtk.Common.DataModel.vtkPiecewiseFunction,n.vtkns.PixelSpaceCallbackMapper=n.vtk.Rendering.Core.vtkPixelSpaceCallbackMapper,n.vtkns.PlaneSource=n.vtk.Filters.Sources.vtkPlaneSource,n.vtkns.PointSource=n.vtk.Filters.Sources.vtkPointSource,n.vtkns.PolyData=n.vtk.Common.DataModel.vtkPolyData,n.vtkns.Property=n.vtk.Rendering.Core.vtkProperty,n.vtkns.Renderer=n.vtk.Rendering.Core.vtkRenderer,n.vtkns.RenderWindow=n.vtk.Rendering.Core.vtkRenderWindow,n.vtkns.RenderWindowInteractor=i.RenderWindowInteractor,n.vtkns.SphereMapper=n.vtk.Rendering.Core.vtkSphereMapper,n.vtkns.SynchronizableRenderWindow=n.vtk.Rendering.Misc.vtkSynchronizableRenderWindow,n.vtkns.ThirdParty=n.vtk.ThirdParty,n.vtkns.Texture=n.vtk.Rendering.Core.vtkTexture,n.vtkns.Volume=n.vtk.Rendering.Core.vtkVolume,n.vtkns.VolumeController=n.vtk.Interaction.UI.vtkVolumeController,n.vtkns.VolumeMapper=n.vtk.Rendering.Core.vtkVolumeMapper,n.vtkns.VolumeProperty=n.vtk.Rendering.Core.vtkVolumeProperty,n.vtkns.WidgetManager=n.vtk.Widgets.Core.vtkWidgetManager;const{vtkObjectManager:e}=n.vtkns.SynchronizableRenderWindow;e.setTypeMapping("vtkVolumeMapper",n.vtkns.VolumeMapper.newInstance,e.oneTimeGenericUpdater),e.setTypeMapping("vtkSmartVolumeMapper",n.vtkns.VolumeMapper.newInstance,e.oneTimeGenericUpdater),e.setTypeMapping("vtkFollower",k.Follower.newInstance,e.genericUpdater)}function v(e){const t=Math.min(Math.max(Math.round(e),0),255).toString(16);return 2==t.length?t:"0"+t}function s(e,t,n){return"#"+v(e)+v(t)+v(n)}function c(e){for(var t=new ArrayBuffer(e.length),n=new Uint8Array(t),r=0,a=e.length;r<a;r++)n[r]=e.charCodeAt(r);return t}n.applyStyle=function(e,t){Object.keys(t).forEach(n=>{e.style[n]=t[n]})},n.hexToRGB=function(e){return[parseInt(e.slice(1,3),16)/255,parseInt(e.slice(3,5),16)/255,parseInt(e.slice(5,7),16)/255]},n.rgbToHex=s,n.vtkLutToMapper=function(e){const{scale:t,nodes:r}=e.get("scale","nodes");if(t!==n.vtkns.ColorTransferFunction.Scale.LINEAR)throw"Error transfer function scale not handle";const a=r.map(e=>e.x),k=Math.min(...a),i=Math.max(...a),v=o.linspace(k,i,255),c=[0,0,0];return{low:k,high:i,palette:v.map(t=>(e.getColor(t,c),s(255*c[0],255*c[1],255*c[2])))}},n.data2VTKImageData=function(e){const t=n.vtkns.ImageData.newInstance({spacing:e.spacing});t.setDimensions(e.dims),t.setOrigin(null!=e.origin?e.origin:e.dims.map(e=>e/2));const r=n.vtkns.DataArray.newInstance({name:"scalars",numberOfComponents:1,values:new n.ARRAY_TYPES[e.dtype](c(atob(e.buffer)))});return t.getPointData().setScalars(r),t},n.majorAxis=function(e,t,n){const r=[0,0,0],a=Math.abs(e[t])>Math.abs(e[n])?t:n,o=e[a]>0?1:-1;return r[a]=o,r},n.cartesian_product=function(...e){return e.reduce((e,t)=>e.flatMap(e=>t.map(t=>[].concat(e,t))))}},
"298ed440f5": function _(e,t,a,i,r){i();const o=e("2f3fd5db07"),m=window.vtk;if(m){const e=m.macro,t=m.Rendering.Core.vtkActor;const i={viewUp:[0,1,0],useViewUp:!1,camera:null};a.Follower={newInstance:e.newInstance((a,r,l={})=>{Object.assign(r,i,l),t.extend(a,r,l),r.followerMatrix=o.mat4.create(),r.camera=m.Rendering.Core.vtkCamera.newInstance(),o.mat4.identity(r.followerMatrix),e.setGet(a,r,["useViewUp","camera"]),e.setGetArray(a,r,["viewUp"],3),function(e,t){t.classHierarchy.push("vtkFollower");const a=Object.assign({},e);e.getMTime=()=>{let e=a.getMTime();if(null!==t.camera){const a=t.camera.getMTime();e=a>e?a:e}return e},e.computeMatrix=()=>{if(e.getMTime()>t.matrixMTime.getMTime()){if(o.mat4.identity(t.matrix),t.userMatrix&&o.mat4.multiply(t.matrix,t.matrix,t.userMatrix),o.mat4.translate(t.matrix,t.matrix,t.origin),o.mat4.translate(t.matrix,t.matrix,t.position),o.mat4.multiply(t.matrix,t.matrix,t.rotation),o.mat4.scale(t.matrix,t.matrix,t.scale),t.camera){const e=o.vec3.fromValues(t.viewUp[0],t.viewUp[1],t.viewUp[2]);if(!t.useViewUp){const a=t.camera.getViewUp();o.vec3.set(e,a[0],a[1],a[2])}const a=o.vec3.create();if(t.camera.getParallelProjection()){const e=t.camera.getViewPlaneNormal();o.vec3.set(a,e[0],e[1],e[2])}else{o.vec3.set(a,t.position[0],t.position[1],t.position[2]);const e=t.camera.getPosition(),i=o.vec3.fromValues(e[0],e[1],e[2]);o.vec3.subtract(a,i,a),o.vec3.normalize(a,a)}const i=o.vec3.create();o.vec3.cross(i,e,a),o.vec3.normalize(i,i),o.vec3.cross(a,i,e),o.vec3.normalize(a,a),t.followerMatrix[0]=i[0],t.followerMatrix[1]=i[1],t.followerMatrix[2]=i[2],t.followerMatrix[4]=e[0],t.followerMatrix[5]=e[1],t.followerMatrix[6]=e[2],t.followerMatrix[8]=a[0],t.followerMatrix[9]=a[1],t.followerMatrix[10]=a[2],o.mat4.multiply(t.matrix,t.followerMatrix,t.matrix)}o.mat4.translate(t.matrix,t.matrix,[-t.origin[0],-t.origin[1],-t.origin[2]]),o.mat4.transpose(t.matrix,t.matrix),t.isIdentity=!1,t.matrixMTime.modified()}}}(a,r)},"vtkFollower")}}},
"2f3fd5db07": function _(t,c,a,o,r){o();const _=t("tslib"),m=_.__importStar(t("68ca94c15c"));a.glMatrix=m;const i=_.__importStar(t("7c0b8e6048"));a.mat2=i;const n=_.__importStar(t("dc03f0a621"));a.mat2d=n;const s=_.__importStar(t("0285c50a7e"));a.mat3=s;const p=_.__importStar(t("a427635f32"));a.mat4=p;const S=_.__importStar(t("eb06fc032a"));a.quat=S;const e=_.__importStar(t("277615c682"));a.quat2=e;const f=_.__importStar(t("c56d9ff837"));a.vec2=f;const b=_.__importStar(t("2c5eb22089"));a.vec3=b;const d=_.__importStar(t("c1aa33d719"));a.vec4=d},
"68ca94c15c": function _(t,a,r,n,o){n(),r.EPSILON=1e-6,r.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,r.RANDOM=Math.random,r.setMatrixArrayType=function(t){r.ARRAY_TYPE=t};var h=Math.PI/180;r.toRadian=function(t){return t*h},r.equals=function(t,a){return Math.abs(t-a)<=r.EPSILON*Math.max(1,Math.abs(t),Math.abs(a))},Math.hypot||(Math.hypot=function(){for(var t=0,a=arguments.length;a--;)t+=arguments[a]*arguments[a];return Math.sqrt(t)})},
"7c0b8e6048": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1],f=r[2],s=r[3];return t[0]=a*c+e*i,t[1]=u*c+o*i,t[2]=a*f+e*s,t[3]=u*f+o*s,t}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}r.create=function(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.transpose=function(t,n){if(t===n){var r=n[1];t[1]=n[2],t[2]=r}else t[0]=n[0],t[1]=n[2],t[2]=n[1],t[3]=n[3];return t},r.invert=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*e-u*a;return o?(o=1/o,t[0]=e*o,t[1]=-a*o,t[2]=-u*o,t[3]=r*o,t):null},r.adjoint=function(t,n){var r=n[0];return t[0]=n[3],t[1]=-n[1],t[2]=-n[2],t[3]=r,t},r.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},r.multiply=o,r.rotate=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=Math.sin(r),i=Math.cos(r);return t[0]=a*i+e*c,t[1]=u*i+o*c,t[2]=a*-c+e*i,t[3]=u*-c+o*i,t},r.scale=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1];return t[0]=a*c,t[1]=u*c,t[2]=e*i,t[3]=o*i,t},r.fromRotation=function(t,n){var r=Math.sin(n),a=Math.cos(n);return t[0]=a,t[1]=r,t[2]=-r,t[3]=a,t},r.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t},r.str=function(t){return"mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},r.LDU=function(t,n,r,a){return t[2]=a[2]/a[0],r[0]=a[0],r[1]=a[1],r[3]=a[3]-t[2]*r[1],[t,n,r]},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=c,r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],c=n[0],i=n[1],f=n[2],s=n[3];return Math.abs(r-c)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-f)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(o-s)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(s))},r.multiplyScalar=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.multiplyScalarAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.mul=o,r.sub=c},
"dc03f0a621": function _(t,n,a,r,u){r();const o=t("tslib").__importStar(t("68ca94c15c"));function e(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1],f=a[2],M=a[3],b=a[4],l=a[5];return t[0]=r*s+o*h,t[1]=u*s+e*h,t[2]=r*f+o*M,t[3]=u*f+e*M,t[4]=r*b+o*l+c,t[5]=u*b+e*l+i,t}function c(t,n,a){return t[0]=n[0]-a[0],t[1]=n[1]-a[1],t[2]=n[2]-a[2],t[3]=n[3]-a[3],t[4]=n[4]-a[4],t[5]=n[5]-a[5],t}a.create=function(){var t=new o.ARRAY_TYPE(6);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},a.clone=function(t){var n=new o.ARRAY_TYPE(6);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n},a.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t},a.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},a.fromValues=function(t,n,a,r,u,e){var c=new o.ARRAY_TYPE(6);return c[0]=t,c[1]=n,c[2]=a,c[3]=r,c[4]=u,c[5]=e,c},a.set=function(t,n,a,r,u,o,e){return t[0]=n,t[1]=a,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t},a.invert=function(t,n){var a=n[0],r=n[1],u=n[2],o=n[3],e=n[4],c=n[5],i=a*o-r*u;return i?(i=1/i,t[0]=o*i,t[1]=-r*i,t[2]=-u*i,t[3]=a*i,t[4]=(u*c-o*e)*i,t[5]=(r*e-a*c)*i,t):null},a.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},a.multiply=e,a.rotate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=Math.sin(a),h=Math.cos(a);return t[0]=r*h+o*s,t[1]=u*h+e*s,t[2]=r*-s+o*h,t[3]=u*-s+e*h,t[4]=c,t[5]=i,t},a.scale=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r*s,t[1]=u*s,t[2]=o*h,t[3]=e*h,t[4]=c,t[5]=i,t},a.translate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=r*s+o*h+c,t[5]=u*s+e*h+i,t},a.fromRotation=function(t,n){var a=Math.sin(n),r=Math.cos(n);return t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t[4]=0,t[5]=0,t},a.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t[4]=0,t[5]=0,t},a.fromTranslation=function(t,n){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=n[0],t[5]=n[1],t},a.str=function(t){return"mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},a.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},a.add=function(t,n,a){return t[0]=n[0]+a[0],t[1]=n[1]+a[1],t[2]=n[2]+a[2],t[3]=n[3]+a[3],t[4]=n[4]+a[4],t[5]=n[5]+a[5],t},a.subtract=c,a.multiplyScalar=function(t,n,a){return t[0]=n[0]*a,t[1]=n[1]*a,t[2]=n[2]*a,t[3]=n[3]*a,t[4]=n[4]*a,t[5]=n[5]*a,t},a.multiplyScalarAndAdd=function(t,n,a,r){return t[0]=n[0]+a[0]*r,t[1]=n[1]+a[1]*r,t[2]=n[2]+a[2]*r,t[3]=n[3]+a[3]*r,t[4]=n[4]+a[4]*r,t[5]=n[5]+a[5]*r,t},a.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]&&t[4]===n[4]&&t[5]===n[5]},a.equals=function(t,n){var a=t[0],r=t[1],u=t[2],e=t[3],c=t[4],i=t[5],s=n[0],h=n[1],f=n[2],M=n[3],b=n[4],l=n[5];return Math.abs(a-s)<=o.EPSILON*Math.max(1,Math.abs(a),Math.abs(s))&&Math.abs(r-h)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(u-f)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(e-M)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(M))&&Math.abs(c-b)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(b))&&Math.abs(i-l)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))},a.mul=e,a.sub=c},
"0285c50a7e": function _(t,a,n,r,u){r();const o=t("tslib").__importStar(t("68ca94c15c"));function e(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1],l=n[2],m=n[3],v=n[4],E=n[5],P=n[6],S=n[7],A=n[8];return t[0]=f*r+b*e+l*s,t[1]=f*u+b*i+l*M,t[2]=f*o+b*c+l*h,t[3]=m*r+v*e+E*s,t[4]=m*u+v*i+E*M,t[5]=m*o+v*c+E*h,t[6]=P*r+S*e+A*s,t[7]=P*u+S*i+A*M,t[8]=P*o+S*c+A*h,t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t}n.create=function(){var t=new o.ARRAY_TYPE(9);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},n.fromMat4=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[4],t[4]=a[5],t[5]=a[6],t[6]=a[8],t[7]=a[9],t[8]=a[10],t},n.clone=function(t){var a=new o.ARRAY_TYPE(9);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromValues=function(t,a,n,r,u,e,i,c,s){var M=new o.ARRAY_TYPE(9);return M[0]=t,M[1]=a,M[2]=n,M[3]=r,M[4]=u,M[5]=e,M[6]=i,M[7]=c,M[8]=s,M},n.set=function(t,a,n,r,u,o,e,i,c,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t[6]=i,t[7]=c,t[8]=s,t},n.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],u=a[5];t[1]=a[3],t[2]=a[6],t[3]=n,t[5]=a[7],t[6]=r,t[7]=u}else t[0]=a[0],t[1]=a[3],t[2]=a[6],t[3]=a[1],t[4]=a[4],t[5]=a[7],t[6]=a[2],t[7]=a[5],t[8]=a[8];return t},n.invert=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=M*e-i*s,f=-M*o+i*c,b=s*o-e*c,l=n*h+r*f+u*b;return l?(l=1/l,t[0]=h*l,t[1]=(-M*r+u*s)*l,t[2]=(i*r-u*e)*l,t[3]=f*l,t[4]=(M*n-u*c)*l,t[5]=(-i*n+u*o)*l,t[6]=b*l,t[7]=(-s*n+r*c)*l,t[8]=(e*n-r*o)*l,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8];return t[0]=e*M-i*s,t[1]=u*s-r*M,t[2]=r*i-u*e,t[3]=i*c-o*M,t[4]=n*M-u*c,t[5]=u*o-n*i,t[6]=o*s-e*c,t[7]=r*c-n*s,t[8]=n*e-r*o,t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],u=t[3],o=t[4],e=t[5],i=t[6],c=t[7],s=t[8];return a*(s*o-e*c)+n*(-s*u+e*i)+r*(c*u-o*i)},n.multiply=e,n.translate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=i,t[5]=c,t[6]=f*r+b*e+s,t[7]=f*u+b*i+M,t[8]=f*o+b*c+h,t},n.rotate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=Math.sin(n),b=Math.cos(n);return t[0]=b*r+f*e,t[1]=b*u+f*i,t[2]=b*o+f*c,t[3]=b*e-f*r,t[4]=b*i-f*u,t[5]=b*c-f*o,t[6]=s,t[7]=M,t[8]=h,t},n.scale=function(t,a,n){var r=n[0],u=n[1];return t[0]=r*a[0],t[1]=r*a[1],t[2]=r*a[2],t[3]=u*a[3],t[4]=u*a[4],t[5]=u*a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=a[0],t[7]=a[1],t[8]=1,t},n.fromRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=-n,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=a[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromMat2d=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=0,t[3]=a[2],t[4]=a[3],t[5]=0,t[6]=a[4],t[7]=a[5],t[8]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=n+n,i=r+r,c=u+u,s=n*e,M=r*e,h=r*i,f=u*e,b=u*i,l=u*c,m=o*e,v=o*i,E=o*c;return t[0]=1-h-l,t[3]=M-E,t[6]=f+v,t[1]=M+E,t[4]=1-s-l,t[7]=b-m,t[2]=f-v,t[5]=b+m,t[8]=1-s-h,t},n.normalFromMat4=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],E=a[15],P=n*i-r*e,S=n*c-u*e,A=n*s-o*e,x=r*c-u*i,d=r*s-o*i,I=u*s-o*c,L=M*m-h*l,N=M*v-f*l,O=M*E-b*l,R=h*v-f*m,p=h*E-b*m,Y=f*E-b*v,y=P*Y-S*p+A*R+x*O-d*N+I*L;return y?(y=1/y,t[0]=(i*Y-c*p+s*R)*y,t[1]=(c*O-e*Y-s*N)*y,t[2]=(e*p-i*O+s*L)*y,t[3]=(u*p-r*Y-o*R)*y,t[4]=(n*Y-u*O+o*N)*y,t[5]=(r*O-n*p-o*L)*y,t[6]=(m*I-v*d+E*x)*y,t[7]=(v*A-l*I-E*S)*y,t[8]=(l*d-m*A+E*P)*y,t):null},n.projection=function(t,a,n){return t[0]=2/a,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/n,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},n.str=function(t){return"mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]},n.equals=function(t,a){var n=t[0],r=t[1],u=t[2],e=t[3],i=t[4],c=t[5],s=t[6],M=t[7],h=t[8],f=a[0],b=a[1],l=a[2],m=a[3],v=a[4],E=a[5],P=a[6],S=a[7],A=a[8];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-b)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(e-m)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(m))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(c-E)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(E))&&Math.abs(s-P)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(P))&&Math.abs(M-S)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(S))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))},n.mul=e,n.sub=i},
"a427635f32": function _(t,a,n,r,h){r();const o=t("tslib").__importStar(t("68ca94c15c"));function u(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function M(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],m=a[12],v=a[13],P=a[14],E=a[15],S=n[0],I=n[1],O=n[2],L=n[3];return t[0]=S*r+I*M+O*c+L*m,t[1]=S*h+I*s+O*f+L*v,t[2]=S*o+I*e+O*b+L*P,t[3]=S*u+I*i+O*l+L*E,S=n[4],I=n[5],O=n[6],L=n[7],t[4]=S*r+I*M+O*c+L*m,t[5]=S*h+I*s+O*f+L*v,t[6]=S*o+I*e+O*b+L*P,t[7]=S*u+I*i+O*l+L*E,S=n[8],I=n[9],O=n[10],L=n[11],t[8]=S*r+I*M+O*c+L*m,t[9]=S*h+I*s+O*f+L*v,t[10]=S*o+I*e+O*b+L*P,t[11]=S*u+I*i+O*l+L*E,S=n[12],I=n[13],O=n[14],L=n[15],t[12]=S*r+I*M+O*c+L*m,t[13]=S*h+I*s+O*f+L*v,t[14]=S*o+I*e+O*b+L*P,t[15]=S*u+I*i+O*l+L*E,t}function s(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=r+r,s=h+h,e=o+o,i=r*M,c=r*s,f=r*e,b=h*s,l=h*e,m=o*e,v=u*M,P=u*s,E=u*e;return t[0]=1-(b+m),t[1]=c+E,t[2]=f-P,t[3]=0,t[4]=c-E,t[5]=1-(i+m),t[6]=l+v,t[7]=0,t[8]=f+P,t[9]=l-v,t[10]=1-(i+b),t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t}function e(t,a){var n=a[0],r=a[1],h=a[2],o=a[4],u=a[5],M=a[6],s=a[8],e=a[9],i=a[10];return t[0]=Math.hypot(n,r,h),t[1]=Math.hypot(o,u,M),t[2]=Math.hypot(s,e,i),t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t[9]=a[9]-n[9],t[10]=a[10]-n[10],t[11]=a[11]-n[11],t[12]=a[12]-n[12],t[13]=a[13]-n[13],t[14]=a[14]-n[14],t[15]=a[15]-n[15],t}n.create=function(){var t=new o.ARRAY_TYPE(16);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(16);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a[9]=t[9],a[10]=t[10],a[11]=t[11],a[12]=t[12],a[13]=t[13],a[14]=t[14],a[15]=t[15],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.fromValues=function(t,a,n,r,h,u,M,s,e,i,c,f,b,l,m,v){var P=new o.ARRAY_TYPE(16);return P[0]=t,P[1]=a,P[2]=n,P[3]=r,P[4]=h,P[5]=u,P[6]=M,P[7]=s,P[8]=e,P[9]=i,P[10]=c,P[11]=f,P[12]=b,P[13]=l,P[14]=m,P[15]=v,P},n.set=function(t,a,n,r,h,o,u,M,s,e,i,c,f,b,l,m,v){return t[0]=a,t[1]=n,t[2]=r,t[3]=h,t[4]=o,t[5]=u,t[6]=M,t[7]=s,t[8]=e,t[9]=i,t[10]=c,t[11]=f,t[12]=b,t[13]=l,t[14]=m,t[15]=v,t},n.identity=u,n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],h=a[3],o=a[6],u=a[7],M=a[11];t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=n,t[6]=a[9],t[7]=a[13],t[8]=r,t[9]=o,t[11]=a[14],t[12]=h,t[13]=u,t[14]=M}else t[0]=a[0],t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=a[1],t[5]=a[5],t[6]=a[9],t[7]=a[13],t[8]=a[2],t[9]=a[6],t[10]=a[10],t[11]=a[14],t[12]=a[3],t[13]=a[7],t[14]=a[11],t[15]=a[15];return t},n.invert=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15],E=n*M-r*u,S=n*s-h*u,I=n*e-o*u,O=r*s-h*M,L=r*e-o*M,N=h*e-o*s,p=i*m-c*l,R=i*v-f*l,x=i*P-b*l,A=c*v-f*m,y=c*P-b*m,Y=f*P-b*v,g=E*Y-S*y+I*A+O*x-L*R+N*p;return g?(g=1/g,t[0]=(M*Y-s*y+e*A)*g,t[1]=(h*y-r*Y-o*A)*g,t[2]=(m*N-v*L+P*O)*g,t[3]=(f*L-c*N-b*O)*g,t[4]=(s*x-u*Y-e*R)*g,t[5]=(n*Y-h*x+o*R)*g,t[6]=(v*I-l*N-P*S)*g,t[7]=(i*N-f*I+b*S)*g,t[8]=(u*y-M*x+e*p)*g,t[9]=(r*x-n*y-o*p)*g,t[10]=(l*L-m*I+P*E)*g,t[11]=(c*I-i*L-b*E)*g,t[12]=(M*R-u*A-s*p)*g,t[13]=(n*A-r*R+h*p)*g,t[14]=(m*S-l*O-v*E)*g,t[15]=(i*O-c*S+f*E)*g,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15];return t[0]=M*(f*P-b*v)-c*(s*P-e*v)+m*(s*b-e*f),t[1]=-(r*(f*P-b*v)-c*(h*P-o*v)+m*(h*b-o*f)),t[2]=r*(s*P-e*v)-M*(h*P-o*v)+m*(h*e-o*s),t[3]=-(r*(s*b-e*f)-M*(h*b-o*f)+c*(h*e-o*s)),t[4]=-(u*(f*P-b*v)-i*(s*P-e*v)+l*(s*b-e*f)),t[5]=n*(f*P-b*v)-i*(h*P-o*v)+l*(h*b-o*f),t[6]=-(n*(s*P-e*v)-u*(h*P-o*v)+l*(h*e-o*s)),t[7]=n*(s*b-e*f)-u*(h*b-o*f)+i*(h*e-o*s),t[8]=u*(c*P-b*m)-i*(M*P-e*m)+l*(M*b-e*c),t[9]=-(n*(c*P-b*m)-i*(r*P-o*m)+l*(r*b-o*c)),t[10]=n*(M*P-e*m)-u*(r*P-o*m)+l*(r*e-o*M),t[11]=-(n*(M*b-e*c)-u*(r*b-o*c)+i*(r*e-o*M)),t[12]=-(u*(c*v-f*m)-i*(M*v-s*m)+l*(M*f-s*c)),t[13]=n*(c*v-f*m)-i*(r*v-h*m)+l*(r*f-h*c),t[14]=-(n*(M*v-s*m)-u*(r*v-h*m)+l*(r*s-h*M)),t[15]=n*(M*f-s*c)-u*(r*f-h*c)+i*(r*s-h*M),t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],h=t[3],o=t[4],u=t[5],M=t[6],s=t[7],e=t[8],i=t[9],c=t[10],f=t[11],b=t[12],l=t[13],m=t[14],v=t[15];return(a*u-n*o)*(c*v-f*m)-(a*M-r*o)*(i*v-f*l)+(a*s-h*o)*(i*m-c*l)+(n*M-r*u)*(e*v-f*b)-(n*s-h*u)*(e*m-c*b)+(r*s-h*M)*(e*l-i*b)},n.multiply=M,n.translate=function(t,a,n){var r,h,o,u,M,s,e,i,c,f,b,l,m=n[0],v=n[1],P=n[2];return a===t?(t[12]=a[0]*m+a[4]*v+a[8]*P+a[12],t[13]=a[1]*m+a[5]*v+a[9]*P+a[13],t[14]=a[2]*m+a[6]*v+a[10]*P+a[14],t[15]=a[3]*m+a[7]*v+a[11]*P+a[15]):(r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],t[0]=r,t[1]=h,t[2]=o,t[3]=u,t[4]=M,t[5]=s,t[6]=e,t[7]=i,t[8]=c,t[9]=f,t[10]=b,t[11]=l,t[12]=r*m+M*v+c*P+a[12],t[13]=h*m+s*v+f*P+a[13],t[14]=o*m+e*v+b*P+a[14],t[15]=u*m+i*v+l*P+a[15]),t},n.scale=function(t,a,n){var r=n[0],h=n[1],o=n[2];return t[0]=a[0]*r,t[1]=a[1]*r,t[2]=a[2]*r,t[3]=a[3]*r,t[4]=a[4]*h,t[5]=a[5]*h,t[6]=a[6]*h,t[7]=a[7]*h,t[8]=a[8]*o,t[9]=a[9]*o,t[10]=a[10]*o,t[11]=a[11]*o,t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.rotate=function(t,a,n,r){var h,u,M,s,e,i,c,f,b,l,m,v,P,E,S,I,O,L,N,p,R,x,A,y,Y=r[0],g=r[1],T=r[2],d=Math.hypot(Y,g,T);return d<o.EPSILON?null:(Y*=d=1/d,g*=d,T*=d,h=Math.sin(n),M=1-(u=Math.cos(n)),s=a[0],e=a[1],i=a[2],c=a[3],f=a[4],b=a[5],l=a[6],m=a[7],v=a[8],P=a[9],E=a[10],S=a[11],I=Y*Y*M+u,O=g*Y*M+T*h,L=T*Y*M-g*h,N=Y*g*M-T*h,p=g*g*M+u,R=T*g*M+Y*h,x=Y*T*M+g*h,A=g*T*M-Y*h,y=T*T*M+u,t[0]=s*I+f*O+v*L,t[1]=e*I+b*O+P*L,t[2]=i*I+l*O+E*L,t[3]=c*I+m*O+S*L,t[4]=s*N+f*p+v*R,t[5]=e*N+b*p+P*R,t[6]=i*N+l*p+E*R,t[7]=c*N+m*p+S*R,t[8]=s*x+f*A+v*y,t[9]=e*x+b*A+P*y,t[10]=i*x+l*A+E*y,t[11]=c*x+m*A+S*y,a!==t&&(t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t)},n.rotateX=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[4],u=a[5],M=a[6],s=a[7],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[4]=o*h+e*r,t[5]=u*h+i*r,t[6]=M*h+c*r,t[7]=s*h+f*r,t[8]=e*h-o*r,t[9]=i*h-u*r,t[10]=c*h-M*r,t[11]=f*h-s*r,t},n.rotateY=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h-e*r,t[1]=u*h-i*r,t[2]=M*h-c*r,t[3]=s*h-f*r,t[8]=o*r+e*h,t[9]=u*r+i*h,t[10]=M*r+c*h,t[11]=s*r+f*h,t},n.rotateZ=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[4],i=a[5],c=a[6],f=a[7];return a!==t&&(t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h+e*r,t[1]=u*h+i*r,t[2]=M*h+c*r,t[3]=s*h+f*r,t[4]=e*h-o*r,t[5]=i*h-u*r,t[6]=c*h-M*r,t[7]=f*h-s*r,t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=a[0],t[13]=a[1],t[14]=a[2],t[15]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=a[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotation=function(t,a,n){var r,h,u,M=n[0],s=n[1],e=n[2],i=Math.hypot(M,s,e);return i<o.EPSILON?null:(M*=i=1/i,s*=i,e*=i,r=Math.sin(a),u=1-(h=Math.cos(a)),t[0]=M*M*u+h,t[1]=s*M*u+e*r,t[2]=e*M*u-s*r,t[3]=0,t[4]=M*s*u-e*r,t[5]=s*s*u+h,t[6]=e*s*u+M*r,t[7]=0,t[8]=M*e*u+s*r,t[9]=s*e*u-M*r,t[10]=e*e*u+h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},n.fromXRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=r,t[6]=n,t[7]=0,t[8]=0,t[9]=-n,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromYRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=0,t[2]=-n,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=n,t[9]=0,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromZRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=0,t[4]=-n,t[5]=r,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotationTranslation=s,n.fromQuat2=function(t,a){var n=new o.ARRAY_TYPE(3),r=-a[0],h=-a[1],u=-a[2],M=a[3],e=a[4],i=a[5],c=a[6],f=a[7],b=r*r+h*h+u*u+M*M;return b>0?(n[0]=2*(e*M+f*r+i*u-c*h)/b,n[1]=2*(i*M+f*h+c*r-e*u)/b,n[2]=2*(c*M+f*u+e*h-i*r)/b):(n[0]=2*(e*M+f*r+i*u-c*h),n[1]=2*(i*M+f*h+c*r-e*u),n[2]=2*(c*M+f*u+e*h-i*r)),s(t,a,n),t},n.getTranslation=function(t,a){return t[0]=a[12],t[1]=a[13],t[2]=a[14],t},n.getScaling=e,n.getRotation=function(t,a){var n=new o.ARRAY_TYPE(3);e(n,a);var r=1/n[0],h=1/n[1],u=1/n[2],M=a[0]*r,s=a[1]*h,i=a[2]*u,c=a[4]*r,f=a[5]*h,b=a[6]*u,l=a[8]*r,m=a[9]*h,v=a[10]*u,P=M+f+v,E=0;return P>0?(E=2*Math.sqrt(P+1),t[3]=.25*E,t[0]=(b-m)/E,t[1]=(l-i)/E,t[2]=(s-c)/E):M>f&&M>v?(E=2*Math.sqrt(1+M-f-v),t[3]=(b-m)/E,t[0]=.25*E,t[1]=(s+c)/E,t[2]=(l+i)/E):f>v?(E=2*Math.sqrt(1+f-M-v),t[3]=(l-i)/E,t[0]=(s+c)/E,t[1]=.25*E,t[2]=(b+m)/E):(E=2*Math.sqrt(1+v-M-f),t[3]=(s-c)/E,t[0]=(l+i)/E,t[1]=(b+m)/E,t[2]=.25*E),t},n.fromRotationTranslationScale=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=a[3],s=h+h,e=o+o,i=u+u,c=h*s,f=h*e,b=h*i,l=o*e,m=o*i,v=u*i,P=M*s,E=M*e,S=M*i,I=r[0],O=r[1],L=r[2];return t[0]=(1-(l+v))*I,t[1]=(f+S)*I,t[2]=(b-E)*I,t[3]=0,t[4]=(f-S)*O,t[5]=(1-(c+v))*O,t[6]=(m+P)*O,t[7]=0,t[8]=(b+E)*L,t[9]=(m-P)*L,t[10]=(1-(c+l))*L,t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t},n.fromRotationTranslationScaleOrigin=function(t,a,n,r,h){var o=a[0],u=a[1],M=a[2],s=a[3],e=o+o,i=u+u,c=M+M,f=o*e,b=o*i,l=o*c,m=u*i,v=u*c,P=M*c,E=s*e,S=s*i,I=s*c,O=r[0],L=r[1],N=r[2],p=h[0],R=h[1],x=h[2],A=(1-(m+P))*O,y=(b+I)*O,Y=(l-S)*O,g=(b-I)*L,T=(1-(f+P))*L,d=(v+E)*L,_=(l+S)*N,q=(v-E)*N,w=(1-(f+m))*N;return t[0]=A,t[1]=y,t[2]=Y,t[3]=0,t[4]=g,t[5]=T,t[6]=d,t[7]=0,t[8]=_,t[9]=q,t[10]=w,t[11]=0,t[12]=n[0]+p-(A*p+g*R+_*x),t[13]=n[1]+R-(y*p+T*R+q*x),t[14]=n[2]+x-(Y*p+d*R+w*x),t[15]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=n+n,M=r+r,s=h+h,e=n*u,i=r*u,c=r*M,f=h*u,b=h*M,l=h*s,m=o*u,v=o*M,P=o*s;return t[0]=1-c-l,t[1]=i+P,t[2]=f-v,t[3]=0,t[4]=i-P,t[5]=1-e-l,t[6]=b+m,t[7]=0,t[8]=f+v,t[9]=b-m,t[10]=1-e-c,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.frustum=function(t,a,n,r,h,o,u){var M=1/(n-a),s=1/(h-r),e=1/(o-u);return t[0]=2*o*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*o*s,t[6]=0,t[7]=0,t[8]=(n+a)*M,t[9]=(h+r)*s,t[10]=(u+o)*e,t[11]=-1,t[12]=0,t[13]=0,t[14]=u*o*2*e,t[15]=0,t},n.perspective=function(t,a,n,r,h){var o,u=1/Math.tan(a/2);return t[0]=u/n,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=h&&h!==1/0?(o=1/(r-h),t[10]=(h+r)*o,t[14]=2*h*r*o):(t[10]=-1,t[14]=-2*r),t},n.perspectiveFromFieldOfView=function(t,a,n,r){var h=Math.tan(a.upDegrees*Math.PI/180),o=Math.tan(a.downDegrees*Math.PI/180),u=Math.tan(a.leftDegrees*Math.PI/180),M=Math.tan(a.rightDegrees*Math.PI/180),s=2/(u+M),e=2/(h+o);return t[0]=s,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=-(u-M)*s*.5,t[9]=(h-o)*e*.5,t[10]=r/(n-r),t[11]=-1,t[12]=0,t[13]=0,t[14]=r*n/(n-r),t[15]=0,t},n.ortho=function(t,a,n,r,h,o,u){var M=1/(a-n),s=1/(r-h),e=1/(o-u);return t[0]=-2*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*e,t[11]=0,t[12]=(a+n)*M,t[13]=(h+r)*s,t[14]=(u+o)*e,t[15]=1,t},n.lookAt=function(t,a,n,r){var h,M,s,e,i,c,f,b,l,m,v=a[0],P=a[1],E=a[2],S=r[0],I=r[1],O=r[2],L=n[0],N=n[1],p=n[2];return Math.abs(v-L)<o.EPSILON&&Math.abs(P-N)<o.EPSILON&&Math.abs(E-p)<o.EPSILON?u(t):(f=v-L,b=P-N,l=E-p,h=I*(l*=m=1/Math.hypot(f,b,l))-O*(b*=m),M=O*(f*=m)-S*l,s=S*b-I*f,(m=Math.hypot(h,M,s))?(h*=m=1/m,M*=m,s*=m):(h=0,M=0,s=0),e=b*s-l*M,i=l*h-f*s,c=f*M-b*h,(m=Math.hypot(e,i,c))?(e*=m=1/m,i*=m,c*=m):(e=0,i=0,c=0),t[0]=h,t[1]=e,t[2]=f,t[3]=0,t[4]=M,t[5]=i,t[6]=b,t[7]=0,t[8]=s,t[9]=c,t[10]=l,t[11]=0,t[12]=-(h*v+M*P+s*E),t[13]=-(e*v+i*P+c*E),t[14]=-(f*v+b*P+l*E),t[15]=1,t)},n.targetTo=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=r[0],s=r[1],e=r[2],i=h-n[0],c=o-n[1],f=u-n[2],b=i*i+c*c+f*f;b>0&&(i*=b=1/Math.sqrt(b),c*=b,f*=b);var l=s*f-e*c,m=e*i-M*f,v=M*c-s*i;return(b=l*l+m*m+v*v)>0&&(l*=b=1/Math.sqrt(b),m*=b,v*=b),t[0]=l,t[1]=m,t[2]=v,t[3]=0,t[4]=c*v-f*m,t[5]=f*l-i*v,t[6]=i*m-c*l,t[7]=0,t[8]=i,t[9]=c,t[10]=f,t[11]=0,t[12]=h,t[13]=o,t[14]=u,t[15]=1,t},n.str=function(t){return"mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t[9]=a[9]+n[9],t[10]=a[10]+n[10],t[11]=a[11]+n[11],t[12]=a[12]+n[12],t[13]=a[13]+n[13],t[14]=a[14]+n[14],t[15]=a[15]+n[15],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t[9]=a[9]*n,t[10]=a[10]*n,t[11]=a[11]*n,t[12]=a[12]*n,t[13]=a[13]*n,t[14]=a[14]*n,t[15]=a[15]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t[9]=a[9]+n[9]*r,t[10]=a[10]+n[10]*r,t[11]=a[11]+n[11]*r,t[12]=a[12]+n[12]*r,t[13]=a[13]+n[13]*r,t[14]=a[14]+n[14]*r,t[15]=a[15]+n[15]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]&&t[9]===a[9]&&t[10]===a[10]&&t[11]===a[11]&&t[12]===a[12]&&t[13]===a[13]&&t[14]===a[14]&&t[15]===a[15]},n.equals=function(t,a){var n=t[0],r=t[1],h=t[2],u=t[3],M=t[4],s=t[5],e=t[6],i=t[7],c=t[8],f=t[9],b=t[10],l=t[11],m=t[12],v=t[13],P=t[14],E=t[15],S=a[0],I=a[1],O=a[2],L=a[3],N=a[4],p=a[5],R=a[6],x=a[7],A=a[8],y=a[9],Y=a[10],g=a[11],T=a[12],d=a[13],_=a[14],q=a[15];return Math.abs(n-S)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(S))&&Math.abs(r-I)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(I))&&Math.abs(h-O)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(O))&&Math.abs(u-L)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(L))&&Math.abs(M-N)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(N))&&Math.abs(s-p)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))&&Math.abs(e-R)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(R))&&Math.abs(i-x)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(c-A)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(A))&&Math.abs(f-y)<=o.EPSILON*Math.max(1,Math.abs(f),Math.abs(y))&&Math.abs(b-Y)<=o.EPSILON*Math.max(1,Math.abs(b),Math.abs(Y))&&Math.abs(l-g)<=o.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(m-T)<=o.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(v-d)<=o.EPSILON*Math.max(1,Math.abs(v),Math.abs(d))&&Math.abs(P-_)<=o.EPSILON*Math.max(1,Math.abs(P),Math.abs(_))&&Math.abs(E-q)<=o.EPSILON*Math.max(1,Math.abs(E),Math.abs(q))},n.mul=M,n.sub=i},
"eb06fc032a": function _(t,a,r,n,e){n();const o=t("tslib"),s=o.__importStar(t("68ca94c15c")),u=o.__importStar(t("0285c50a7e")),c=o.__importStar(t("2c5eb22089")),i=o.__importStar(t("c1aa33d719"));function h(){var t=new s.ARRAY_TYPE(4);return s.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function M(t,a,r){r*=.5;var n=Math.sin(r);return t[0]=n*a[0],t[1]=n*a[1],t[2]=n*a[2],t[3]=Math.cos(r),t}function l(t,a,r){var n=a[0],e=a[1],o=a[2],s=a[3],u=r[0],c=r[1],i=r[2],h=r[3];return t[0]=n*h+s*u+e*i-o*c,t[1]=e*h+s*c+o*u-n*i,t[2]=o*h+s*i+n*c-e*u,t[3]=s*h-n*u-e*c-o*i,t}function f(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=Math.exp(o),c=s>0?u*Math.sin(s)/s:0;return t[0]=r*c,t[1]=n*c,t[2]=e*c,t[3]=u*Math.cos(s),t}function v(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=s>0?Math.atan2(s,o)/s:0;return t[0]=r*u,t[1]=n*u,t[2]=e*u,t[3]=.5*Math.log(r*r+n*n+e*e+o*o),t}function m(t,a,r,n){var e,o,u,c,i,h=a[0],M=a[1],l=a[2],f=a[3],v=r[0],m=r[1],q=r[2],d=r[3];return(o=h*v+M*m+l*q+f*d)<0&&(o=-o,v=-v,m=-m,q=-q,d=-d),1-o>s.EPSILON?(e=Math.acos(o),u=Math.sin(e),c=Math.sin((1-n)*e)/u,i=Math.sin(n*e)/u):(c=1-n,i=n),t[0]=c*h+i*v,t[1]=c*M+i*m,t[2]=c*l+i*q,t[3]=c*f+i*d,t}function q(t,a){var r,n=a[0]+a[4]+a[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,r=.5/r,t[0]=(a[5]-a[7])*r,t[1]=(a[6]-a[2])*r,t[2]=(a[1]-a[3])*r;else{var e=0;a[4]>a[0]&&(e=1),a[8]>a[3*e+e]&&(e=2);var o=(e+1)%3,s=(e+2)%3;r=Math.sqrt(a[3*e+e]-a[3*o+o]-a[3*s+s]+1),t[e]=.5*r,r=.5/r,t[3]=(a[3*o+s]-a[3*s+o])*r,t[o]=(a[3*o+e]+a[3*e+o])*r,t[s]=(a[3*s+e]+a[3*e+s])*r}return t}var d,p,A,g,_,P;r.create=h,r.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},r.setAxisAngle=M,r.getAxisAngle=function(t,a){var r=2*Math.acos(a[3]),n=Math.sin(r/2);return n>s.EPSILON?(t[0]=a[0]/n,t[1]=a[1]/n,t[2]=a[2]/n):(t[0]=1,t[1]=0,t[2]=0),r},r.getAngle=function(t,a){var n=r.dot(t,a);return Math.acos(2*n*n-1)},r.multiply=l,r.rotateX=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+s*u,t[1]=e*c+o*u,t[2]=o*c-e*u,t[3]=s*c-n*u,t},r.rotateY=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c-o*u,t[1]=e*c+s*u,t[2]=o*c+n*u,t[3]=s*c-e*u,t},r.rotateZ=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+e*u,t[1]=e*c-n*u,t[2]=o*c+s*u,t[3]=s*c-o*u,t},r.calculateW=function(t,a){var r=a[0],n=a[1],e=a[2];return t[0]=r,t[1]=n,t[2]=e,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-e*e)),t},r.exp=f,r.ln=v,r.pow=function(t,a,n){return v(t,a),r.scale(t,t,n),f(t,t),t},r.slerp=m,r.random=function(t){var a=s.RANDOM(),r=s.RANDOM(),n=s.RANDOM(),e=Math.sqrt(1-a),o=Math.sqrt(a);return t[0]=e*Math.sin(2*Math.PI*r),t[1]=e*Math.cos(2*Math.PI*r),t[2]=o*Math.sin(2*Math.PI*n),t[3]=o*Math.cos(2*Math.PI*n),t},r.invert=function(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=r*r+n*n+e*e+o*o,u=s?1/s:0;return t[0]=-r*u,t[1]=-n*u,t[2]=-e*u,t[3]=o*u,t},r.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t},r.fromMat3=q,r.fromEuler=function(t,a,r,n){var e=.5*Math.PI/180;a*=e,r*=e,n*=e;var o=Math.sin(a),s=Math.cos(a),u=Math.sin(r),c=Math.cos(r),i=Math.sin(n),h=Math.cos(n);return t[0]=o*c*h-s*u*i,t[1]=s*u*h+o*c*i,t[2]=s*c*i-o*u*h,t[3]=s*c*h+o*u*i,t},r.str=function(t){return"quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.clone=i.clone,r.fromValues=i.fromValues,r.copy=i.copy,r.set=i.set,r.add=i.add,r.mul=l,r.scale=i.scale,r.dot=i.dot,r.lerp=i.lerp,r.length=i.length,r.len=r.length,r.squaredLength=i.squaredLength,r.sqrLen=r.squaredLength,r.normalize=i.normalize,r.exactEquals=i.exactEquals,r.equals=i.equals,r.rotationTo=(d=c.create(),p=c.fromValues(1,0,0),A=c.fromValues(0,1,0),function(t,a,n){var e=c.dot(a,n);return e<-.999999?(c.cross(d,p,a),c.len(d)<1e-6&&c.cross(d,A,a),c.normalize(d,d),M(t,d,Math.PI),t):e>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(c.cross(d,a,n),t[0]=d[0],t[1]=d[1],t[2]=d[2],t[3]=1+e,r.normalize(t,t))}),r.sqlerp=(g=h(),_=h(),function(t,a,r,n,e,o){return m(g,a,e,o),m(_,r,n,o),m(t,g,_,2*o*(1-o)),t}),r.setAxes=(P=u.create(),function(t,a,n,e){return P[0]=n[0],P[3]=n[1],P[6]=n[2],P[1]=e[0],P[4]=e[1],P[7]=e[2],P[2]=-a[0],P[5]=-a[1],P[8]=-a[2],r.normalize(t,q(t,P))})},
"2c5eb22089": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){var n=t[0],r=t[1],a=t[2];return Math.hypot(n,r,a)}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t}function h(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t}function M(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t}function s(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return Math.hypot(r,a,u)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return r*r+a*a+u*u}function v(t){var n=t[0],r=t[1],a=t[2];return n*n+r*r+a*a}function l(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(3);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n},r.length=i,r.fromValues=function(t,n,r){var a=new e.ARRAY_TYPE(3);return a[0]=t,a[1]=n,a[2]=r,a},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t},r.set=function(t,n,r,a){return t[0]=n,t[1]=r,t[2]=a,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t},r.subtract=c,r.multiply=h,r.divide=M,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t},r.distance=s,r.squaredDistance=f,r.squaredLength=v,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=r*r+a*a+u*u;return e>0&&(e=1/Math.sqrt(e)),t[0]=n[0]*e,t[1]=n[1]*e,t[2]=n[2]*e,t},r.dot=l,r.cross=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2];return t[0]=u*c-e*i,t[1]=e*o-a*c,t[2]=a*i-u*o,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t},r.hermite=function(t,n,r,a,u,e){var o=e*e,i=o*(2*e-3)+1,c=o*(e-2)+e,h=o*(e-1),M=o*(3-2*e);return t[0]=n[0]*i+r[0]*c+a[0]*h+u[0]*M,t[1]=n[1]*i+r[1]*c+a[1]*h+u[1]*M,t[2]=n[2]*i+r[2]*c+a[2]*h+u[2]*M,t},r.bezier=function(t,n,r,a,u,e){var o=1-e,i=o*o,c=e*e,h=i*o,M=3*e*i,s=3*c*o,f=c*e;return t[0]=n[0]*h+r[0]*M+a[0]*s+u[0]*f,t[1]=n[1]*h+r[1]*M+a[1]*s+u[1]*f,t[2]=n[2]*h+r[2]*M+a[2]*s+u[2]*f,t},r.random=function(t,n){n=n||1;var r=2*e.RANDOM()*Math.PI,a=2*e.RANDOM()-1,u=Math.sqrt(1-a*a)*n;return t[0]=Math.cos(r)*u,t[1]=Math.sin(r)*u,t[2]=a*n,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[3]*a+r[7]*u+r[11]*e+r[15];return o=o||1,t[0]=(r[0]*a+r[4]*u+r[8]*e+r[12])/o,t[1]=(r[1]*a+r[5]*u+r[9]*e+r[13])/o,t[2]=(r[2]*a+r[6]*u+r[10]*e+r[14])/o,t},r.transformMat3=function(t,n,r){var a=n[0],u=n[1],e=n[2];return t[0]=a*r[0]+u*r[3]+e*r[6],t[1]=a*r[1]+u*r[4]+e*r[7],t[2]=a*r[2]+u*r[5]+e*r[8],t},r.transformQuat=function(t,n,r){var a=r[0],u=r[1],e=r[2],o=r[3],i=n[0],c=n[1],h=n[2],M=u*h-e*c,s=e*i-a*h,f=a*c-u*i,v=u*f-e*s,l=e*M-a*f,m=a*s-u*M,d=2*o;return M*=d,s*=d,f*=d,v*=2,l*=2,m*=2,t[0]=i+M+v,t[1]=c+s+l,t[2]=h+f+m,t},r.rotateX=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0],e[1]=u[1]*Math.cos(a)-u[2]*Math.sin(a),e[2]=u[1]*Math.sin(a)+u[2]*Math.cos(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateY=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[2]*Math.sin(a)+u[0]*Math.cos(a),e[1]=u[1],e[2]=u[2]*Math.cos(a)-u[0]*Math.sin(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateZ=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0]*Math.cos(a)-u[1]*Math.sin(a),e[1]=u[0]*Math.sin(a)+u[1]*Math.cos(a),e[2]=u[2],t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.angle=function(t,n){var r=t[0],a=t[1],u=t[2],e=n[0],o=n[1],i=n[2],c=Math.sqrt(r*r+a*a+u*u)*Math.sqrt(e*e+o*o+i*i),h=c&&l(t,n)/c;return Math.acos(Math.min(Math.max(h,-1),1))},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},r.str=function(t){return"vec3("+t[0]+", "+t[1]+", "+t[2]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=n[0],i=n[1],c=n[2];return Math.abs(r-o)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(o))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-c)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(c))},r.sub=c,r.mul=h,r.div=M,r.dist=s,r.sqrDist=f,r.len=i,r.sqrLen=v,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=3),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2];return t})},
"c1aa33d719": function _(t,n,r,a,u){a();const e=t("tslib").__importStar(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}function c(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t[3]=n[3]*r[3],t}function h(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t[3]=n[3]/r[3],t}function M(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return Math.hypot(r,a,u,e)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return r*r+a*a+u*u+e*e}function s(t){var n=t[0],r=t[1],a=t[2],u=t[3];return Math.hypot(n,r,a,u)}function l(t){var n=t[0],r=t[1],a=t[2],u=t[3];return n*n+r*r+a*a+u*u}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=i,r.multiply=c,r.divide=h,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t[3]=Math.ceil(n[3]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t[3]=Math.floor(n[3]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t[3]=Math.min(n[3],r[3]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t[3]=Math.max(n[3],r[3]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t[3]=Math.round(n[3]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.distance=M,r.squaredDistance=f,r.length=s,r.squaredLength=l,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t[3]=-n[3],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t[3]=1/n[3],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*r+a*a+u*u+e*e;return o>0&&(o=1/Math.sqrt(o)),t[0]=r*o,t[1]=a*o,t[2]=u*o,t[3]=e*o,t},r.dot=function(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]+t[3]*n[3]},r.cross=function(t,n,r,a){var u=r[0]*a[1]-r[1]*a[0],e=r[0]*a[2]-r[2]*a[0],o=r[0]*a[3]-r[3]*a[0],i=r[1]*a[2]-r[2]*a[1],c=r[1]*a[3]-r[3]*a[1],h=r[2]*a[3]-r[3]*a[2],M=n[0],f=n[1],s=n[2],l=n[3];return t[0]=f*h-s*c+l*i,t[1]=-M*h+s*o-l*e,t[2]=M*c-f*o+l*u,t[3]=-M*i+f*e-s*u,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2],i=n[3];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t[3]=i+a*(r[3]-i),t},r.random=function(t,n){var r,a,u,o,i,c;n=n||1;do{i=(r=2*e.RANDOM()-1)*r+(a=2*e.RANDOM()-1)*a}while(i>=1);do{c=(u=2*e.RANDOM()-1)*u+(o=2*e.RANDOM()-1)*o}while(c>=1);var h=Math.sqrt((1-i)/c);return t[0]=n*r,t[1]=n*a,t[2]=n*u*h,t[3]=n*o*h,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3];return t[0]=r[0]*a+r[4]*u+r[8]*e+r[12]*o,t[1]=r[1]*a+r[5]*u+r[9]*e+r[13]*o,t[2]=r[2]*a+r[6]*u+r[10]*e+r[14]*o,t[3]=r[3]*a+r[7]*u+r[11]*e+r[15]*o,t},r.transformQuat=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2],h=r[3],M=h*a+i*e-c*u,f=h*u+c*a-o*e,s=h*e+o*u-i*a,l=-o*a-i*u-c*e;return t[0]=M*h+l*-o+f*-c-s*-i,t[1]=f*h+l*-i+s*-o-M*-c,t[2]=s*h+l*-c+M*-i-f*-o,t[3]=n[3],t},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},r.str=function(t){return"vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],i=n[0],c=n[1],h=n[2],M=n[3];return Math.abs(r-i)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))&&Math.abs(u-h)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(h))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))},r.sub=i,r.mul=c,r.div=h,r.dist=M,r.sqrDist=f,r.len=s,r.sqrLen=l,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=4),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],m[3]=t[o+3],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2],t[o+3]=m[3];return t})},
"277615c682": function _(t,a,n,r,e){r();const u=t("tslib"),o=u.__importStar(t("68ca94c15c")),i=u.__importStar(t("eb06fc032a")),s=u.__importStar(t("a427635f32"));function c(t,a,n){var r=.5*n[0],e=.5*n[1],u=.5*n[2],o=a[0],i=a[1],s=a[2],c=a[3];return t[0]=o,t[1]=i,t[2]=s,t[3]=c,t[4]=r*c+e*s-u*i,t[5]=e*c+u*o-r*s,t[6]=u*c+r*i-e*o,t[7]=-r*o-e*i-u*s,t}function h(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t}function f(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[4],s=n[5],c=n[6],h=n[7],f=a[4],M=a[5],b=a[6],l=a[7],v=n[0],m=n[1],R=n[2],A=n[3];return t[0]=r*A+o*v+e*R-u*m,t[1]=e*A+o*m+u*v-r*R,t[2]=u*A+o*R+r*m-e*v,t[3]=o*A-r*v-e*m-u*R,t[4]=r*h+o*i+e*c-u*s+f*A+l*v+M*R-b*m,t[5]=e*h+o*s+u*i-r*c+M*A+l*m+b*v-f*R,t[6]=u*h+o*c+r*s-e*i+b*A+l*R+f*m-M*v,t[7]=o*h-r*i-e*s-u*c+l*A-f*v-M*m-b*R,t}n.create=function(){var t=new o.ARRAY_TYPE(8);return o.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(8);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a},n.fromValues=function(t,a,n,r,e,u,i,s){var c=new o.ARRAY_TYPE(8);return c[0]=t,c[1]=a,c[2]=n,c[3]=r,c[4]=e,c[5]=u,c[6]=i,c[7]=s,c},n.fromRotationTranslationValues=function(t,a,n,r,e,u,i){var s=new o.ARRAY_TYPE(8);s[0]=t,s[1]=a,s[2]=n,s[3]=r;var c=.5*e,h=.5*u,f=.5*i;return s[4]=c*r+h*n-f*a,s[5]=h*r+f*t-c*n,s[6]=f*r+c*a-h*t,s[7]=-c*t-h*a-f*n,s},n.fromRotationTranslation=c,n.fromTranslation=function(t,a){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*a[0],t[5]=.5*a[1],t[6]=.5*a[2],t[7]=0,t},n.fromRotation=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.fromMat4=function(t,a){var n=i.create();s.getRotation(n,a);var r=new o.ARRAY_TYPE(3);return s.getTranslation(r,a),c(t,n,r),t},n.copy=h,n.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.set=function(t,a,n,r,e,u,o,i,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=e,t[4]=u,t[5]=o,t[6]=i,t[7]=s,t},n.getReal=i.copy,n.getDual=function(t,a){return t[0]=a[4],t[1]=a[5],t[2]=a[6],t[3]=a[7],t},n.setReal=i.copy,n.setDual=function(t,a){return t[4]=a[0],t[5]=a[1],t[6]=a[2],t[7]=a[3],t},n.getTranslation=function(t,a){var n=a[4],r=a[5],e=a[6],u=a[7],o=-a[0],i=-a[1],s=-a[2],c=a[3];return t[0]=2*(n*c+u*o+r*s-e*i),t[1]=2*(r*c+u*i+e*o-n*s),t[2]=2*(e*c+u*s+n*i-r*o),t},n.translate=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=.5*n[0],s=.5*n[1],c=.5*n[2],h=a[4],f=a[5],M=a[6],b=a[7];return t[0]=r,t[1]=e,t[2]=u,t[3]=o,t[4]=o*i+e*c-u*s+h,t[5]=o*s+u*i-r*c+f,t[6]=o*c+r*s-e*i+M,t[7]=-r*i-e*s-u*c+b,t},n.rotateX=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateX(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateY=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateY(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateZ=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateZ(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateByQuatAppend=function(t,a,n){var r=n[0],e=n[1],u=n[2],o=n[3],i=a[0],s=a[1],c=a[2],h=a[3];return t[0]=i*o+h*r+s*u-c*e,t[1]=s*o+h*e+c*r-i*u,t[2]=c*o+h*u+i*e-s*r,t[3]=h*o-i*r-s*e-c*u,i=a[4],s=a[5],c=a[6],h=a[7],t[4]=i*o+h*r+s*u-c*e,t[5]=s*o+h*e+c*r-i*u,t[6]=c*o+h*u+i*e-s*r,t[7]=h*o-i*r-s*e-c*u,t},n.rotateByQuatPrepend=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[0],s=n[1],c=n[2],h=n[3];return t[0]=r*h+o*i+e*c-u*s,t[1]=e*h+o*s+u*i-r*c,t[2]=u*h+o*c+r*s-e*i,t[3]=o*h-r*i-e*s-u*c,i=n[4],s=n[5],c=n[6],h=n[7],t[4]=r*h+o*i+e*c-u*s,t[5]=e*h+o*s+u*i-r*c,t[6]=u*h+o*c+r*s-e*i,t[7]=o*h-r*i-e*s-u*c,t},n.rotateAroundAxis=function(t,a,n,r){if(Math.abs(r)<o.EPSILON)return h(t,a);var e=Math.hypot(n[0],n[1],n[2]);r*=.5;var u=Math.sin(r),i=u*n[0]/e,s=u*n[1]/e,c=u*n[2]/e,f=Math.cos(r),M=a[0],b=a[1],l=a[2],v=a[3];t[0]=M*f+v*i+b*c-l*s,t[1]=b*f+v*s+l*i-M*c,t[2]=l*f+v*c+M*s-b*i,t[3]=v*f-M*i-b*s-l*c;var m=a[4],R=a[5],A=a[6],E=a[7];return t[4]=m*f+E*i+R*c-A*s,t[5]=R*f+E*s+A*i-m*c,t[6]=A*f+E*c+m*s-R*i,t[7]=E*f-m*i-R*s-A*c,t},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t},n.multiply=f,n.mul=f,n.scale=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t},n.dot=i.dot,n.lerp=function(t,a,r,e){var u=1-e;return n.dot(a,r)<0&&(e=-e),t[0]=a[0]*u+r[0]*e,t[1]=a[1]*u+r[1]*e,t[2]=a[2]*u+r[2]*e,t[3]=a[3]*u+r[3]*e,t[4]=a[4]*u+r[4]*e,t[5]=a[5]*u+r[5]*e,t[6]=a[6]*u+r[6]*e,t[7]=a[7]*u+r[7]*e,t},n.invert=function(t,a){var r=n.squaredLength(a);return t[0]=-a[0]/r,t[1]=-a[1]/r,t[2]=-a[2]/r,t[3]=a[3]/r,t[4]=-a[4]/r,t[5]=-a[5]/r,t[6]=-a[6]/r,t[7]=a[7]/r,t},n.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t[4]=-a[4],t[5]=-a[5],t[6]=-a[6],t[7]=a[7],t},n.length=i.length,n.len=n.length,n.squaredLength=i.squaredLength,n.sqrLen=n.squaredLength,n.normalize=function(t,a){var r=n.squaredLength(a);if(r>0){r=Math.sqrt(r);var e=a[0]/r,u=a[1]/r,o=a[2]/r,i=a[3]/r,s=a[4],c=a[5],h=a[6],f=a[7],M=e*s+u*c+o*h+i*f;t[0]=e,t[1]=u,t[2]=o,t[3]=i,t[4]=(s-e*M)/r,t[5]=(c-u*M)/r,t[6]=(h-o*M)/r,t[7]=(f-i*M)/r}return t},n.str=function(t){return"quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]},n.equals=function(t,a){var n=t[0],r=t[1],e=t[2],u=t[3],i=t[4],s=t[5],c=t[6],h=t[7],f=a[0],M=a[1],b=a[2],l=a[3],v=a[4],m=a[5],R=a[6],A=a[7];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-M)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(M))&&Math.abs(e-b)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-m)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(c-R)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(R))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))}},
"c56d9ff837": function _(n,t,r,a,u){a();const e=n("tslib").__importStar(n("68ca94c15c"));function o(){var n=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(n[0]=0,n[1]=0),n}function c(n,t,r){return n[0]=t[0]-r[0],n[1]=t[1]-r[1],n}function i(n,t,r){return n[0]=t[0]*r[0],n[1]=t[1]*r[1],n}function f(n,t,r){return n[0]=t[0]/r[0],n[1]=t[1]/r[1],n}function s(n,t){var r=t[0]-n[0],a=t[1]-n[1];return Math.hypot(r,a)}function h(n,t){var r=t[0]-n[0],a=t[1]-n[1];return r*r+a*a}function M(n){var t=n[0],r=n[1];return Math.hypot(t,r)}function l(n){var t=n[0],r=n[1];return t*t+r*r}var v;r.create=o,r.clone=function(n){var t=new e.ARRAY_TYPE(2);return t[0]=n[0],t[1]=n[1],t},r.fromValues=function(n,t){var r=new e.ARRAY_TYPE(2);return r[0]=n,r[1]=t,r},r.copy=function(n,t){return n[0]=t[0],n[1]=t[1],n},r.set=function(n,t,r){return n[0]=t,n[1]=r,n},r.add=function(n,t,r){return n[0]=t[0]+r[0],n[1]=t[1]+r[1],n},r.subtract=c,r.multiply=i,r.divide=f,r.ceil=function(n,t){return n[0]=Math.ceil(t[0]),n[1]=Math.ceil(t[1]),n},r.floor=function(n,t){return n[0]=Math.floor(t[0]),n[1]=Math.floor(t[1]),n},r.min=function(n,t,r){return n[0]=Math.min(t[0],r[0]),n[1]=Math.min(t[1],r[1]),n},r.max=function(n,t,r){return n[0]=Math.max(t[0],r[0]),n[1]=Math.max(t[1],r[1]),n},r.round=function(n,t){return n[0]=Math.round(t[0]),n[1]=Math.round(t[1]),n},r.scale=function(n,t,r){return n[0]=t[0]*r,n[1]=t[1]*r,n},r.scaleAndAdd=function(n,t,r,a){return n[0]=t[0]+r[0]*a,n[1]=t[1]+r[1]*a,n},r.distance=s,r.squaredDistance=h,r.length=M,r.squaredLength=l,r.negate=function(n,t){return n[0]=-t[0],n[1]=-t[1],n},r.inverse=function(n,t){return n[0]=1/t[0],n[1]=1/t[1],n},r.normalize=function(n,t){var r=t[0],a=t[1],u=r*r+a*a;return u>0&&(u=1/Math.sqrt(u)),n[0]=t[0]*u,n[1]=t[1]*u,n},r.dot=function(n,t){return n[0]*t[0]+n[1]*t[1]},r.cross=function(n,t,r){var a=t[0]*r[1]-t[1]*r[0];return n[0]=n[1]=0,n[2]=a,n},r.lerp=function(n,t,r,a){var u=t[0],e=t[1];return n[0]=u+a*(r[0]-u),n[1]=e+a*(r[1]-e),n},r.random=function(n,t){t=t||1;var r=2*e.RANDOM()*Math.PI;return n[0]=Math.cos(r)*t,n[1]=Math.sin(r)*t,n},r.transformMat2=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u,n[1]=r[1]*a+r[3]*u,n},r.transformMat2d=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u+r[4],n[1]=r[1]*a+r[3]*u+r[5],n},r.transformMat3=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[3]*u+r[6],n[1]=r[1]*a+r[4]*u+r[7],n},r.transformMat4=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[4]*u+r[12],n[1]=r[1]*a+r[5]*u+r[13],n},r.rotate=function(n,t,r,a){var u=t[0]-r[0],e=t[1]-r[1],o=Math.sin(a),c=Math.cos(a);return n[0]=u*c-e*o+r[0],n[1]=u*o+e*c+r[1],n},r.angle=function(n,t){var r=n[0],a=n[1],u=t[0],e=t[1],o=Math.sqrt(r*r+a*a)*Math.sqrt(u*u+e*e),c=o&&(r*u+a*e)/o;return Math.acos(Math.min(Math.max(c,-1),1))},r.zero=function(n){return n[0]=0,n[1]=0,n},r.str=function(n){return"vec2("+n[0]+", "+n[1]+")"},r.exactEquals=function(n,t){return n[0]===t[0]&&n[1]===t[1]},r.equals=function(n,t){var r=n[0],a=n[1],u=t[0],o=t[1];return Math.abs(r-u)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(u))&&Math.abs(a-o)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(o))},r.len=M,r.sub=c,r.mul=i,r.div=f,r.dist=s,r.sqrDist=h,r.sqrLen=l,r.forEach=(v=o(),function(n,t,r,a,u,e){var o,c;for(t||(t=2),r||(r=0),c=a?Math.min(a*t+r,n.length):n.length,o=r;o<c;o+=t)v[0]=n[o],v[1]=n[o+1],u(v,v,e),n[o]=v[0],n[o+1]=v[1];return n})},
"f348d37cc5": function _(e,n,r,t,l){t();const i=window.vtk;if(i){const e=i.macro,n=i.Rendering.Core.vtkRenderWindowInteractor;r.RenderWindowInteractor={newInstance:e.newInstance((e,r,t={})=>{n.extend(e,r,t),function(e,n){n.classHierarchy.push("panelRenderWindowInteractor"),e.findPokedRenderer=(e=0,r=0)=>{if(!n.view)return null;const t=n.view.getRenderable().getRenderersByReference();t.sort((e,n)=>e.getLayer()-n.getLayer());let l=null,i=null,o=null,c=t.length;for(;c--;){const a=t[c];if(n.view.isInViewport(e,r,a)&&a.getInteractive()){o=a;break}null===l&&a.getInteractive()&&(l=a),null===i&&n.view.isInViewport(e,r,a)&&(i=a)}return null===o&&(o=l),null===o&&(o=i),null==o&&(o=t[0]),o}}(e,r)},"panelRenderWindowInteractor")}}},
"e4fabdee71": function _(t,i,e,s,h){s();const a=t("@bokehjs/models/mappers"),n=t("@bokehjs/core/util/array");class c{constructor(t,i,e={}){this.parent=t,this.mapper=i,this.options=e,e.ticksNum||(e.ticksNum=5),e.fontFamily||(e.fontFamily="Arial"),e.fontSize||(e.fontSize="12px"),e.ticksSize||(e.ticksSize=2),this.canvas=document.createElement("canvas"),this.canvas.style.width="100%",this.parent.appendChild(this.canvas),this.ctx=this.canvas.getContext("2d"),this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`,this.ctx.lineWidth=e.ticksSize,e.height||(e.height=4*(this.font_height+1)+"px"),this.canvas.style.height=e.height,this.draw_colorbar()}get values(){const{high:t,low:i}=this.mapper;return n.linspace(i,t,this.options.ticksNum)}get ticks(){return this.values.map(t=>t.toExponential(3))}get title(){return this.mapper.name?this.mapper.name:"scalars"}get font_height(){let t=0;return this.values.forEach(i=>{const{actualBoundingBoxAscent:e,actualBoundingBoxDescent:s}=this.ctx.measureText(""+i),h=e+s;t<h&&(t=h)}),t}draw_colorbar(){this.canvas.width=this.canvas.clientWidth,this.canvas.height=this.canvas.clientHeight;const{palette:t}=this.mapper;this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`;const i=this.font_height;this.ctx.save();const e=document.createElement("canvas"),s=t.length;e.width=s,e.height=1;const h=e.getContext("2d"),c=h.getImageData(0,0,s,1),o=new a.LinearColorMapper({palette:t}).rgba_mapper.v_compute(n.range(0,t.length));c.data.set(o),h.putImageData(c,0,0),this.ctx.drawImage(e,0,2*(this.font_height+1)+1,this.canvas.width,this.canvas.height),this.ctx.restore(),this.ctx.save(),this.ctx.textAlign="center",this.ctx.fillText(this.title,this.canvas.width/2,i+1),this.ctx.restore(),this.ctx.save();const r=n.linspace(0,this.canvas.width,5);r.forEach((t,e)=>{let s=t;0==e?(s=t+Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="left"):e==r.length-1?(s=t-Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="right"):this.ctx.textAlign="center",this.ctx.moveTo(s,2*(i+1)),this.ctx.lineTo(s,2*(i+1)+5),this.ctx.stroke(),this.ctx.fillText(""+this.ticks[e],t,2*(i+1))}),this.ctx.restore()}}e.VTKColorBar=c,c.__name__="VTKColorBar"},
"075632b08f": function _(e,t,i,s,n){s();const r=e("tslib").__importStar(e("@bokehjs/core/properties")),o=e("2035cdc8c2"),a=e("dd7268f5c4");class l extends o.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,()=>{this._vtk_image_data=a.data2VTKImageData(this.model.data),this.invalidate_render()}),this.connect(this.model.properties.colormap.change,()=>{this.colormap_selector.value=this.model.colormap;const e=new Event("change");this.colormap_selector.dispatchEvent(e)}),this.connect(this.model.properties.shadow.change,()=>{this.shadow_selector.value=this.model.shadow?"1":"0";const e=new Event("change");this.shadow_selector.dispatchEvent(e)}),this.connect(this.model.properties.sampling.change,()=>{this.sampling_slider.value=this.model.sampling.toFixed(2);const e=new Event("input");this.sampling_slider.dispatchEvent(e)}),this.connect(this.model.properties.edge_gradient.change,()=>{this.edge_gradient_slider.value=this.model.edge_gradient.toFixed(2);const e=new Event("input");this.edge_gradient_slider.dispatchEvent(e)}),this.connect(this.model.properties.rescale.change,()=>{this._controllerWidget.setRescaleColorMap(this.model.rescale),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.ambient.change,()=>{this.volume.getProperty().setAmbient(this.model.ambient),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.diffuse.change,()=>{this.volume.getProperty().setDiffuse(this.model.diffuse),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.specular.change,()=>{this.volume.getProperty().setSpecular(this.model.specular),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.specular_power.change,()=>{this.volume.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.display_volume.change,()=>{this._set_volume_visibility(this.model.display_volume),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.display_slices.change,()=>{this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.slice_i.change,()=>{void 0!==this.image_actor_i&&(this.image_actor_i.getMapper().setISlice(this.model.slice_i),this._vtk_renwin.getRenderWindow().render())}),this.connect(this.model.properties.slice_j.change,()=>{void 0!==this.image_actor_j&&(this.image_actor_j.getMapper().setJSlice(this.model.slice_j),this._vtk_renwin.getRenderWindow().render())}),this.connect(this.model.properties.slice_k.change,()=>{void 0!==this.image_actor_k&&(this.image_actor_k.getMapper().setKSlice(this.model.slice_k),this._vtk_renwin.getRenderWindow().render())}),this.connect(this.model.properties.render_background.change,()=>{this._vtk_renwin.getRenderer().setBackground(...a.hexToRGB(this.model.render_background)),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.interpolation.change,()=>{this._set_interpolation(this.model.interpolation),this._vtk_renwin.getRenderWindow().render()}),this.connect(this.model.properties.controller_expanded.change,()=>{null!=this._controllerWidget&&this._controllerWidget.setExpanded(this.model.controller_expanded)})}render(){this._vtk_renwin=null,this._orientationWidget=null,this._axes=null,super.render(),this._create_orientation_widget(),this._set_axes(),this.model.camera||this._vtk_renwin.getRenderer().resetCamera()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=a.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._vtk_container})}plot(){this._controllerWidget=a.vtkns.VolumeController.newInstance({size:[400,150],rescaleColorMap:this.model.rescale}),this._plot_volume(),this._plot_slices(),this._controllerWidget.setupContent(this._vtk_renwin.getRenderWindow(),this.volume,!0),this._controllerWidget.setContainer(this.el),this._controllerWidget.setExpanded(this.model.controller_expanded),this._connect_js_controls(),this._vtk_renwin.getRenderWindow().getInteractor(),this._vtk_renwin.getRenderWindow().getInteractor().setDesiredUpdateRate(45),this._set_volume_visibility(this.model.display_volume),this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderer().setBackground(...a.hexToRGB(this.model.render_background)),this._set_interpolation(this.model.interpolation),this._set_camera_state()}get vtk_image_data(){return this._vtk_image_data||(this._vtk_image_data=a.data2VTKImageData(this.model.data)),this._vtk_image_data}get volume(){return this._vtk_renwin.getRenderer().getVolumes()[0]}get image_actor_i(){return this._vtk_renwin.getRenderer().getActors()[0]}get image_actor_j(){return this._vtk_renwin.getRenderer().getActors()[1]}get image_actor_k(){return this._vtk_renwin.getRenderer().getActors()[2]}get shadow_selector(){return this.el.querySelector(".js-shadow")}get edge_gradient_slider(){return this.el.querySelector(".js-edge")}get sampling_slider(){return this.el.querySelector(".js-spacing")}get colormap_selector(){return this.el.querySelector(".js-color-preset")}_connect_js_controls(){const{el:e}=this._controllerWidget.get("el");if(void 0!==e){e.querySelector(".js-button").addEventListener("click",()=>this.model.controller_expanded=this._controllerWidget.getExpanded())}this.colormap_selector.addEventListener("change",()=>{this.model.colormap=this.colormap_selector.value}),this.model.colormap?this.model.properties.colormap.change.emit():this.model.colormap=this.colormap_selector.value,this.shadow_selector.addEventListener("change",()=>{this.model.shadow=!!Number(this.shadow_selector.value)}),(this.model.shadow=!!Number(this.shadow_selector.value))&&this.model.properties.shadow.change.emit(),this.sampling_slider.addEventListener("input",()=>{const e=Number(this.sampling_slider.value);Math.abs(this.model.sampling-e)>=.005&&(this.model.sampling=e)}),Math.abs(this.model.sampling-Number(this.shadow_selector.value))>=.005&&this.model.properties.sampling.change.emit(),this.edge_gradient_slider.addEventListener("input",()=>{const e=Number(this.edge_gradient_slider.value);Math.abs(this.model.edge_gradient-e)>=.005&&(this.model.edge_gradient=e)}),Math.abs(this.model.edge_gradient-Number(this.edge_gradient_slider.value))>=.005&&this.model.properties.edge_gradient.change.emit()}_plot_slices(){const e=this._vtk_image_data,t=a.vtkns.ImageSlice.newInstance(),i=a.vtkns.ImageSlice.newInstance(),s=a.vtkns.ImageSlice.newInstance(),n=a.vtkns.ImageMapper.newInstance(),r=a.vtkns.ImageMapper.newInstance(),o=a.vtkns.ImageMapper.newInstance();n.setInputData(e),n.setISlice(this.model.slice_i),t.setMapper(n),r.setInputData(e),r.setJSlice(this.model.slice_j),i.setMapper(r),o.setInputData(e),o.setKSlice(this.model.slice_k),s.setMapper(o);const l=a.vtkns.PiecewiseFunction.newInstance();l.removeAllPoints(),l.addPoint(0,1);const d=this.volume.getProperty().getRGBTransferFunction(0),c=t.getProperty();i.setProperty(c),s.setProperty(c),c.setRGBTransferFunction(d),c.setScalarOpacity(l);const _=this._vtk_renwin.getRenderer();_.addActor(t),_.addActor(i),_.addActor(s)}_plot_volume(){const e=this.vtk_image_data,t=a.vtkns.Volume.newInstance(),i=a.vtkns.VolumeMapper.newInstance();t.setMapper(i),i.setInputData(e);const s=(e.getPointData().getScalars()||e.getPointData().getArrays()[0]).getRange(),n=a.vtkns.ColorTransferFunction.newInstance();n.onModified(()=>this.model.mapper=a.vtkLutToMapper(n));const r=a.vtkns.PiecewiseFunction.newInstance(),o=.7*Math.sqrt(e.getSpacing().map(e=>e*e).reduce((e,t)=>e+t,0));i.setSampleDistance(o),t.getProperty().setRGBTransferFunction(0,n),t.getProperty().setScalarOpacity(0,r),t.getProperty().setInterpolationTypeToFastLinear(),t.getProperty().setScalarOpacityUnitDistance(0,a.vtkns.BoundingBox.getDiagonalLength(e.getBounds())/Math.max(...e.getDimensions())),t.getProperty().setGradientOpacityMinimumValue(0,0),t.getProperty().setGradientOpacityMaximumValue(0,.05*(s[1]-s[0])),t.getProperty().setShade(this.model.shadow),t.getProperty().setUseGradientOpacity(0,!0),t.getProperty().setGradientOpacityMinimumOpacity(0,0),t.getProperty().setGradientOpacityMaximumOpacity(0,1),t.getProperty().setAmbient(this.model.ambient),t.getProperty().setDiffuse(this.model.diffuse),t.getProperty().setSpecular(this.model.specular),t.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderer().addVolume(t)}_set_interpolation(e){"fast_linear"==e?(this.volume.getProperty().setInterpolationTypeToFastLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):"linear"==e?(this.volume.getProperty().setInterpolationTypeToLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):(this.volume.getProperty().setInterpolationTypeToNearest(),this.image_actor_i.getProperty().setInterpolationTypeToNearest())}_set_slices_visibility(e){this._vtk_renwin.getRenderer().getActors().map(t=>t.setVisibility(e))}_set_volume_visibility(e){this.volume.setVisibility(e)}}i.VTKVolumePlotView=l,l.__name__="VTKVolumePlotView";class d extends o.AbstractVTKPlot{constructor(e){super(e)}static init_VTKVolumePlot(){this.prototype.default_view=l,this.define({ambient:[r.Number,.2],colormap:[r.String],data:[r.Instance],diffuse:[r.Number,.7],display_slices:[r.Boolean,!1],display_volume:[r.Boolean,!0],edge_gradient:[r.Number,.2],interpolation:[r.Any,"fast_linear"],mapper:[r.Instance],render_background:[r.String,"#52576e"],rescale:[r.Boolean,!1],sampling:[r.Number,.4],shadow:[r.Boolean,!0],slice_i:[r.Int,0],slice_j:[r.Int,0],slice_k:[r.Int,0],specular:[r.Number,.3],specular_power:[r.Number,8],controller_expanded:[r.Boolean,!0]})}}i.VTKVolumePlot=d,d.__name__="VTKVolumePlot",d.init_VTKVolumePlot()},
"3ae7537200": function _(t,s,i,e,n){e();const a=t("tslib").__importStar(t("@bokehjs/core/properties")),c=t("@bokehjs/model"),r=t("2f3fd5db07"),h=t("dd7268f5c4");class l extends c.Model{constructor(t){super(t)}static init_VTKAxes(){this.define({origin:[a.Array],xticker:[a.Instance],yticker:[a.Instance],zticker:[a.Instance],digits:[a.Number,1],show_grid:[a.Boolean,!0],grid_opacity:[a.Number,.1],axes_opacity:[a.Number,1],fontsize:[a.Number,12]})}get xticks(){return this.xticker.ticks}get yticks(){return this.yticker.ticks}get zticks(){return this.zticker.ticks}get xlabels(){return this.xticker.labels?this.xticker.labels:this.xticks.map(t=>t.toFixed(this.digits))}get ylabels(){return this.yticker.labels?this.yticker.labels:this.yticks.map(t=>t.toFixed(this.digits))}get zlabels(){return this.zticker.labels?this.zticker.labels:this.zticks.map(t=>t.toFixed(this.digits))}_make_grid_lines(t,s,i){const e=[];for(let n=0;n<t-1;n++)for(let t=0;t<s-1;t++){const a=n*s+t+i,c=[5,a,n*s+t+1+i,(n+1)*s+t+1+i,(n+1)*s+t+i,a];e.push(c)}return e}_create_grid_axes(){const t=[];t.push(h.cartesian_product(this.xticks,this.yticks,[this.origin[2]])),t.push(h.cartesian_product([this.origin[0]],this.yticks,this.zticks)),t.push(h.cartesian_product(this.xticks,[this.origin[1]],this.zticks));const s=[];let i=0;s.push(this._make_grid_lines(this.xticks.length,this.yticks.length,i)),i+=this.xticks.length*this.yticks.length,s.push(this._make_grid_lines(this.yticks.length,this.zticks.length,i)),i+=this.yticks.length*this.zticks.length,s.push(this._make_grid_lines(this.xticks.length,this.zticks.length,i));const e=h.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:t.flat(2)},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:s.flat(2)}}),n=h.vtkns.Mapper.newInstance(),a=h.vtkns.Actor.newInstance();return n.setInputData(e),a.setMapper(n),a.getProperty().setOpacity(this.grid_opacity),a.setVisibility(this.show_grid),a}create_axes(t){const s=[this.xticks,this.yticks,this.zticks].map((t,s)=>{let i=null;switch(s){case 0:i=h.cartesian_product(t,[this.origin[1]],[this.origin[2]]);break;case 1:i=h.cartesian_product([this.origin[0]],t,[this.origin[2]]);break;case 2:i=h.cartesian_product([this.origin[0]],[this.origin[1]],t)}return i}).flat(2),i=h.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:s},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:[2,0,this.xticks.length-1,2,this.xticks.length,this.xticks.length+this.yticks.length-1,2,this.xticks.length+this.yticks.length,this.xticks.length+this.yticks.length+this.zticks.length-1]}}),e=h.vtkns.PixelSpaceCallbackMapper.newInstance();e.setInputData(i),e.setUseZValues(!0),e.setCallback((s,i,n)=>{const a=t.getContext("2d");if(a){const c={height:t.clientHeight*window.devicePixelRatio,width:t.clientWidth*window.devicePixelRatio},h=e.getInputData().getPoints(),l=i.getViewMatrix();r.mat4.transpose(l,l);const o=i.getProjectionMatrix(n,-1,1);r.mat4.transpose(o,o),a.clearRect(0,0,c.width,c.height),s.forEach((t,s)=>{const i=h.getPoint(s),e=r.vec3.fromValues(i[0],i[1],i[2]);if(r.vec3.transformMat4(e,e,l),e[2]+=.05,r.vec3.transformMat4(e,e,o),e[2]-.001<t[3]){let i;a.font="30px serif",a.textAlign="center",a.textBaseline="alphabetic",a.fillText(".",t[0],c.height-t[1]+2),a.font=this.fontsize*window.devicePixelRatio+"px serif",a.textAlign="right",a.textBaseline="top",i=s<this.xticks.length?this.xlabels[s]:s>=this.xticks.length&&s<this.xticks.length+this.yticks.length?this.ylabels[s-this.xticks.length]:this.zlabels[s-(this.xticks.length+this.yticks.length)],a.fillText(""+i,t[0],c.height-t[1])}})}});const n=h.vtkns.Actor.newInstance();n.setMapper(e);const a=h.vtkns.Mapper.newInstance();a.setInputData(i);const c=h.vtkns.Actor.newInstance();c.setMapper(a),c.getProperty().setOpacity(this.axes_opacity);return{psActor:n,axesActor:c,gridActor:this._create_grid_axes()}}}i.VTKAxes=l,l.__name__="VTKAxes",l.__module__="panel.models.vtk",l.init_VTKAxes()},
"b2f9f50873": function _(e,t,n,s,r){s();const i=e("tslib").__importStar(e("@bokehjs/core/properties")),o=e("@bokehjs/core/util/object"),_=e("2035cdc8c2"),a=e("dd7268f5c4"),c=e("11e0707a8f"),h="panel";class d extends _.AbstractVTKView{initialize(){super.initialize(),this._promises=[],this._renderable=!1,this._arrays={},this._decoded_arrays={},this._pending_arrays={},this.getArray=e=>this._arrays[e]?Promise.resolve(this._arrays[e]):new Promise((t,n)=>{this._pending_arrays[e]={resolve:t,reject:n}}),this.registerArray=(e,t)=>(this._arrays[e]=t,this._pending_arrays[e]&&this._pending_arrays[e].resolve(t),!0),this._synchronizer_context=a.vtkns.SynchronizableRenderWindow.getSynchronizerContext(h)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.arrays.change,()=>this._decode_arrays()),this.connect(this.model.properties.scene.change,()=>{if(this.model.rebuild)this._vtk_renwin=null,this.invalidate_render();else{const e=o.clone(this.model.scene);Promise.all(this._promises).then(()=>{this._sync_plot(e,()=>{this._on_scene_ready(),this._connect_interactions_to_model()})})}}),this.connect(this.model.properties.one_time_reset.change,()=>{this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters()})}init_vtk_renwin(){this._vtk_renwin=c.FullScreenRenderWindowSynchronized.newInstance({rootContainer:this.el,container:this._vtk_container,synchronizerContext:this._synchronizer_context})}plot(){this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters(),this._decode_arrays();const e=o.clone(this.model.scene);Promise.all(this._promises).then(()=>{this._sync_plot(e,()=>this._on_scene_ready())})}_decode_arrays(){const e=new a.vtkns.ThirdParty.JSZip,t=this.model.arrays,n=this.registerArray,s=this.model.arrays_processed,r=this.model;Object.keys(t).forEach(i=>{this._decoded_arrays[i]||(this._decoded_arrays[i]=!0,this._promises.push(function(i){return e.loadAsync(atob(t[i])).then(e=>e.file("data/"+i)).then(e=>e.async("arraybuffer")).then(e=>n(i,e)).then(()=>{s.push(i),r.properties.arrays_processed.change.emit()})}(i)))})}_on_scene_ready(){this._promises.length>0||(this._renderable=!0,this._camera_callbacks.push(this._vtk_renwin.getRenderer().getActiveCamera().onModified(()=>this._vtk_render())),this._orientationWidget||this._create_orientation_widget(),this._axes||this._set_axes(),this._vtk_renwin.resize(),this._vtk_render(),this._set_camera_state())}_sync_plot(e,t){this._renderable=!1,this._promises=[],this._unsubscribe_camera_cb(),this._synchronizer_context.setFetchArrayFunction(e=>Promise.resolve(this._arrays[e]));const n=this._synchronizer_context.getInstance(this.model.scene.dependencies[0].id);n&&!this._vtk_renwin.getRenderer()&&this._vtk_renwin.getRenderWindow().addRenderer(n),this._vtk_renwin.getRenderWindow().synchronize(e).then(t)}}n.VTKSynchronizedPlotView=d,d.__name__="VTKSynchronizedPlotView";class l extends _.AbstractVTKPlot{constructor(e){super(e),this.outline=a.vtkns.OutlineFilter.newInstance();const t=a.vtkns.Mapper.newInstance();t.setInputConnection(this.outline.getOutputPort()),this.outline_actor=a.vtkns.Actor.newInstance(),this.outline_actor.setMapper(t)}getActors(e){let t=this.renderer_el.getRenderer().getActors();if(e){const n=this.renderer_el.getSynchronizerContext(h);t=t.filter(t=>{const s=n.getInstanceId(t);return!!s&&s.slice(-16)==e.slice(1,17)})}return t}static init_VTKSynchronizedPlot(){this.prototype.default_view=d,this.define({arrays:[i.Any,{}],arrays_processed:[i.Array,[]],enable_keybindings:[i.Boolean,!1],one_time_reset:[i.Boolean],rebuild:[i.Boolean,!1],scene:[i.Any,{}]}),this.override({height:300,width:300})}}n.VTKSynchronizedPlot=l,l.__name__="VTKSynchronizedPlot",l.__module__="panel.models.vtk",l.init_VTKSynchronizedPlot()},
"11e0707a8f": function _(e,n,o,t,r){t();const i=e("dd7268f5c4");if(i.vtk){const e={containerStyle:null,controlPanelStyle:null,listenWindowResize:!0,resizeCallback:null,controllerVisibility:!0,synchronizerContextName:"default"},n={position:"absolute",left:"25px",top:"25px",backgroundColor:"white",borderRadius:"5px",listStyle:"none",padding:"5px 10px",margin:"0",display:"block",border:"solid 1px black",maxWidth:"calc(100vw - 70px)",maxHeight:"calc(100vh - 60px)",overflow:"auto"};o.FullScreenRenderWindowSynchronized={newInstance:i.vtk.macro.newInstance((o,t,r={})=>{Object.assign(t,e,r),i.vtk.macro.obj(o,t),i.vtk.macro.get(o,t,["renderWindow","openGLRenderWindow","interactor","rootContainer","container","controlContainer","synchronizerContext"]),function(e,o){o.renderWindow=i.vtkns.SynchronizableRenderWindow.newInstance({synchronizerContext:o.synchronizerContext}),o.openGLRenderWindow=i.vtkns.OpenGLRenderWindow.newInstance(),o.openGLRenderWindow.setContainer(o.container),o.renderWindow.addView(o.openGLRenderWindow),o.interactor=i.vtkns.RenderWindowInteractor.newInstance(),o.interactor.setInteractorStyle(i.vtkns.InteractorStyleTrackballCamera.newInstance()),o.interactor.setView(o.openGLRenderWindow),o.interactor.initialize(),o.interactor.bindEvents(o.container),e.getRenderer=()=>o.renderWindow.getRenderers()[0],e.removeController=()=>{const e=o.controlContainer;e&&e.parentNode.removeChild(e)},e.setControllerVisibility=e=>{o.controllerVisibility=e,o.controlContainer&&(o.controlContainer.style.display=e?"block":"none")},e.toggleControllerVisibility=()=>{e.setControllerVisibility(!o.controllerVisibility)},e.addController=t=>{o.controlContainer=document.createElement("div"),i.applyStyle(o.controlContainer,o.controlPanelStyle||n),o.rootContainer.appendChild(o.controlContainer),o.controlContainer.innerHTML=t,e.setControllerVisibility(o.controllerVisibility),o.rootContainer.addEventListener("keypress",n=>{"c"===String.fromCharCode(n.charCode)&&e.toggleControllerVisibility()})},e.delete=i.vtk.macro.chain(e.setContainer,o.openGLRenderWindow.delete,e.delete),e.resize=()=>{const e=o.container.getBoundingClientRect(),n=window.devicePixelRatio||1;o.openGLRenderWindow.setSize(Math.floor(e.width*n),Math.floor(e.height*n)),o.resizeCallback&&o.resizeCallback(e),o.renderWindow.render()},e.setResizeCallback=n=>{o.resizeCallback=n,e.resize()},o.listenWindowResize&&window.addEventListener("resize",e.resize),e.resize()}(o,t)})}}},
}, "4e90918c0a", {"index":"4e90918c0a","models/index":"c4b9651916","models/ace":"abb1112c2c","models/layout":"7116a7a602","models/audio":"66d52165db","models/card":"0106b0a1bf","models/comm_manager":"684c940c17","models/deckgl":"d0d2aafca0","models/tooltips":"064eac2866","models/echarts":"f940c92510","models/html":"ed08037ce5","models/ipywidget":"fad8d6fbd1","models/json":"284504a0cf","models/file_download":"7a99dba4eb","models/katex":"7b859fb3cf","models/location":"aded270681","models/mathjax":"0c21036737","models/player":"79c41bbf71","models/plotly":"56da045fbd","models/util":"990b5dd5c7","models/progress":"765e9cea08","models/singleselect":"ff9dd91f7b","models/state":"38b2bc9574","models/vega":"294adeb985","models/video":"b0c3e9e9c2","models/videostream":"3c7145a2fa","models/vtk/index":"c51f25e2a7","models/vtk/vtkjs":"01c83f92ba","models/vtk/vtklayout":"2035cdc8c2","models/vtk/util":"dd7268f5c4","models/vtk/vtkfollower":"298ed440f5","models/vtk/vtkrenderwindowinteractor":"f348d37cc5","models/vtk/vtkcolorbar":"e4fabdee71","models/vtk/vtkvolume":"075632b08f","models/vtk/vtkaxes":"3ae7537200","models/vtk/vtksynchronized":"b2f9f50873","models/vtk/panel_fullscreen_renwin_sync":"11e0707a8f"}, {});
})

