from otlpy.base.net import AsyncHttpClient, AsyncWebSocketClient
from otlpy.kis.common import Common
from otlpy.kis.domestic_future import (
    IndexFuture,
    IndexOption,
    StockFuture,
    StockOption,
)
from otlpy.kis.domestic_stock import DomesticStock, DomesticStockWS
from otlpy.kis.overseas_stock import AMEX, NASD, NYSE
from otlpy.kis.settings import Settings


class API:
    def __init__(self, settings: Settings, /) -> None:
        self.__common = Common(settings)

    @property
    def _common(self, /) -> Common:
        return self.__common

    @property
    def url_base(self, /) -> str:
        return self._common.url_base

    @property
    def url_ws(self, /) -> str:
        return self._common.url_ws

    def CreateDomesticStockWS(
        self, ws: AsyncWebSocketClient, /
    ) -> DomesticStockWS:
        return DomesticStockWS(self._common, ws)

    def CreateDomesticStock(self, client: AsyncHttpClient, /) -> DomesticStock:
        return DomesticStock(self._common, client)

    def CreateIndexFuture(self, client: AsyncHttpClient, /) -> IndexFuture:
        return IndexFuture(self._common, client)

    def CreateIndexOption(self, client: AsyncHttpClient, /) -> IndexOption:
        return IndexOption(self._common, client)

    def CreateStockFuture(self, client: AsyncHttpClient, /) -> StockFuture:
        return StockFuture(self._common, client)

    def CreateStockOption(self, client: AsyncHttpClient, /) -> StockOption:
        return StockOption(self._common, client)

    def CreateNASD(self, client: AsyncHttpClient, /) -> NASD:
        return NASD(self._common, client)

    def CreateNYSE(self, client: AsyncHttpClient, /) -> NYSE:
        return NYSE(self._common, client)

    def CreateAMEX(self, client: AsyncHttpClient, /) -> AMEX:
        return AMEX(self._common, client)
