from datetime import datetime
from decimal import Decimal
from enum import Enum, auto

from tompy.datetime import now as _now


class MARKET_TYPE(Enum):
    LIT_POOL = auto()
    DARK_POOL = auto()


class MARKET_EXECUTION(Enum):
    PRICE_TIME_PRIORITY = auto()
    PRO_RATA = auto()


class PQ:
    def __init__(
        self,
        price: Decimal,
        qty: Decimal,
        /,
    ) -> None:
        self.__price = price
        self.__qty = qty

    @property
    def price(self, /) -> Decimal:
        return self.__price

    @property
    def qty(self, /) -> Decimal:
        return self.__qty


class LimitOrderBook:
    def __init__(
        self,
        stime: str,
        ticker: str,
        /,
        bid: list[PQ],
        ask: list[PQ],
    ) -> None:
        self.__stime = stime
        self.__ticker = ticker
        self.__bid = bid
        self.__ask = ask
        self.__created_at = _now()

    @property
    def stime(self, /) -> str:
        return self.__stime

    @property
    def ticker(self, /) -> str:
        return self.__ticker

    @property
    def bid(self, /) -> list[PQ]:
        return self.__bid

    @property
    def ask(self, /) -> list[PQ]:
        return self.__ask

    @property
    def created_at(self, /) -> datetime:
        return self.__created_at
