from otlpy.base.net import AsyncHttpClient
from otlpy.binance.common import Common
from otlpy.binance.future import Future
from otlpy.binance.settings import Settings
from otlpy.binance.spot import Spot


class API:
    def __init__(self, settings: Settings, /) -> None:
        self.__common = Common(settings)

    @property
    def _common(self, /) -> Common:
        return self.__common

    @property
    def url_base_spot(self, /) -> str:
        return self._common.url_base_spot

    @property
    def url_base_future(self, /) -> str:
        return self._common.url_base_future

    def CreateSpot(self, client: AsyncHttpClient, /) -> Spot:
        return Spot(self._common, client)

    def CreateFuture(self, client: AsyncHttpClient, /) -> Future:
        return Future(self._common, client)
