from datetime import date, time
from enum import Enum, auto

from pytz import BaseTzInfo
from tompy.datetime import date_is_weekend, now_date, now_time


class TIMER_STATUS(Enum):
    NO_MARKET = auto()
    CONTINUOUS_ENTRY = auto()
    CONTINUOUS_EXIT = auto()
    CONTINUOUS_CLOSE = auto()


class Timer:
    def __init__(
        self,
        /,
        tz: BaseTzInfo,
        *,
        continuous_entry: time,
        continuous_exit: time,
        continuous_close: time,
        continuous_close_end: time,
    ) -> None:
        self.__tz = tz
        self.__continuous_entry = continuous_entry
        self.__continuous_exit = continuous_exit
        self.__continuous_close = continuous_close
        self.__continuous_close_end = continuous_close_end

    @property
    def tz(self, /) -> BaseTzInfo:
        return self.__tz

    @property
    def continuous_entry(self, /) -> time:
        return self.__continuous_entry

    @property
    def continuous_exit(self, /) -> time:
        return self.__continuous_exit

    @property
    def continuous_close(self, /) -> time:
        return self.__continuous_close

    @property
    def continuous_close_end(self, /) -> time:
        return self.__continuous_close_end

    def now_date(self, /) -> date:
        return now_date(tz=self.tz)

    def now_time(self, /) -> time:
        return now_time(tz=self.tz)

    def is_weekend(self, /) -> bool:
        return date_is_weekend(self.now_date())

    def status(self, /) -> TIMER_STATUS:
        t = self.now_time()
        if self.continuous_entry <= t < self.continuous_exit:
            return TIMER_STATUS.CONTINUOUS_ENTRY
        if self.continuous_exit <= t < self.continuous_close:
            return TIMER_STATUS.CONTINUOUS_EXIT
        if self.continuous_close <= t < self.continuous_close_end:
            return TIMER_STATUS.CONTINUOUS_CLOSE
        return TIMER_STATUS.NO_MARKET
