from datetime import datetime
from decimal import Decimal
from enum import Enum, auto
from typing import Optional

from tompy.datetime import now as _now


class MARKET_TYPE(Enum):
    LIT_POOL = auto()
    DARK_POOL = auto()


class MARKET_EXECUTION(Enum):
    PRICE_TIME_PRIORITY = auto()
    PRO_RATA = auto()


class PQN:
    def __init__(
        self,
        price: Decimal,
        qty: Decimal,
        /,
        *,
        num: Optional[Decimal] = None,
    ) -> None:
        self.__price = price
        self.__qty = qty
        self.__num = num

    @property
    def price(self, /) -> Decimal:
        return self.__price

    @property
    def qty(self, /) -> Decimal:
        return self.__qty

    @property
    def num(self, /) -> Optional[Decimal]:
        return self.__num


class LimitOrderBook:
    def __init__(
        self,
        stime: str,
        ticker: str,
        /,
        bid: list[PQN],
        ask: list[PQN],
    ) -> None:
        self.__stime = stime
        self.__ticker = ticker
        self.__bid = bid
        self.__ask = ask
        self.__created_at = _now()

    @property
    def stime(self, /) -> str:
        return self.__stime

    @property
    def ticker(self, /) -> str:
        return self.__ticker

    @property
    def bid(self, /) -> list[PQN]:
        return self.__bid

    @property
    def ask(self, /) -> list[PQN]:
        return self.__ask

    @property
    def created_at(self, /) -> datetime:
        return self.__created_at


class Price:
    def __init__(
        self,
        stime: str,
        ticker: str,
        /,
        trade: PQN,
        *,
        bid: Optional[PQN] = None,
        ask: Optional[PQN] = None,
    ) -> None:
        self.__stime = stime
        self.__ticker = ticker
        self.__trade = trade
        self.__bid = bid
        self.__ask = ask
        self.__created_at = _now()

    @property
    def stime(self, /) -> str:
        return self.__stime

    @property
    def ticker(self, /) -> str:
        return self.__ticker

    @property
    def trade(self, /) -> PQN:
        return self.__trade

    @property
    def bid(self, /) -> Optional[PQN]:
        return self.__bid

    @property
    def ask(self, /) -> Optional[PQN]:
        return self.__ask

    @property
    def created_at(self, /) -> datetime:
        return self.__created_at
