from abc import ABC, abstractmethod
from datetime import date, time
from enum import Enum, auto

from pytz import BaseTzInfo, timezone
from tompy.datetime import date_is_weekend, now_date, now_time


class TIMER_STATUS(Enum):
    NO_MARKET = auto()
    SINGLE_PRICE_OPEN = auto()
    CONTINUOUS_ENTRY = auto()
    CONTINUOUS_EXIT = auto()
    CONTINUOUS_CLOSE = auto()
    SINGLE_PRICE_CLOSE = auto()


class BaseTimer(ABC):
    def __init__(self, stz: str, /) -> None:
        self.__tz = timezone(stz)

    @property
    def tz(self, /) -> BaseTzInfo:
        return self.__tz

    def date(self, /) -> date:
        return now_date(tz=self.tz)

    def time(self, /) -> time:
        return now_time(tz=self.tz)

    def is_weekend(self, /) -> bool:
        return date_is_weekend(self.date())

    @abstractmethod
    def status(self, /) -> TIMER_STATUS:
        raise NotImplementedError
