from otlpy.base.net import AsyncHttpClient, AsyncWebSocketClient
from otlpy.kis.common import Common
from otlpy.kis.domestic_stock import DomesticStock, DomesticStockWS
from otlpy.kis.settings import Settings


class API:
    def __init__(self, settings: Settings, /) -> None:
        self.__common = Common(settings)

    @property
    def _common(self, /) -> Common:
        return self.__common

    @property
    def url_base(self, /) -> str:
        return self._common.url_base

    @property
    def url_ws(self, /) -> str:
        return self._common.url_ws

    async def token(self, client: AsyncHttpClient, /) -> None:
        await self._common.token(client)

    def CreateDomesticStockWS(
        self, ws: AsyncWebSocketClient, /
    ) -> DomesticStockWS:
        return DomesticStockWS(self._common, ws)

    def CreateDomesticStock(self, client: AsyncHttpClient, /) -> DomesticStock:
        return DomesticStock(self._common, client)
