from numpy import ceil as _ceil
from numpy import floor as _floor


def bid_ticksize(price: float, /, ticksize: float) -> float:
    return _floor(price / ticksize) * ticksize  # type: ignore


def ask_ticksize(price: float, /, ticksize: float) -> float:
    return _ceil(price / ticksize) * ticksize  # type: ignore
