from base64 import b64decode as _b64decode
from hashlib import sha256 as _sha256
from hmac import new as _new

from Crypto.Cipher import AES as _AES
from Crypto.Util.Padding import unpad as _unpad


def aes_cbc_base64_dec(key: str, iv: str, /, cipher_text: str) -> str:
    cipher = _AES.new(key.encode("utf-8"), _AES.MODE_CBC, iv.encode("utf-8"))
    return bytes.decode(
        _unpad(cipher.decrypt(_b64decode(cipher_text)), _AES.block_size)
    )


def hmac_sha256(key: str, /, msg: str) -> str:
    m = _new(key.encode("utf-8"), msg.encode("utf-8"), _sha256)
    return m.hexdigest()
