# type: ignore[attr-defined]
"""An open-source software library for numerical computation, data acquisition, and control of lower-limb robotic prosthesis."""

import sys
from importlib import metadata as importlib_metadata

from .osl import *
from .utils import *


def get_version() -> str:
    try:
        return importlib_metadata.version(__name__)
    except importlib_metadata.PackageNotFoundError:  # pragma: no cover
        return "unknown"


version: str = get_version()
