# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['orchid_python_api',
 'orchid_python_api.examples',
 'orchid_python_api.examples.low_level',
 'orchid_python_api.examples.manual',
 'orchid_python_api.examples.pythonnet3',
 'orchid_python_api.tutorials']

package_data = \
{'': ['*']}

install_requires = \
['deal>=4.23.4,<5.0.0',
 'ipython>=8.7.0,<9.0.0',
 'jupyter>=1.0.0,<2.0.0',
 'jupyterlab>=3.5.1,<4.0.0',
 'matplotlib>=3.6.2,<4.0.0',
 'numpy>=1.23.5,<2.0.0',
 'option>=2.1.0,<3.0.0',
 'packaging>=22.0,<23.0',
 'pandas>=1.5.2,<2.0.0',
 'pendulum>=2.1.2,<3.0.0',
 'pint>=0.20.1,<0.21.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'pythonnet==3.0.0-post1',
 'pyyaml>=6.0,<7.0',
 'scipy>=1.9.3,<2.0.0',
 'seaborn>=0.12.1,<0.13.0',
 'toolz>=0.12.0,<0.13.0',
 'typing-extensions>=4.4.0,<5.0.0']

entry_points = \
{'console_scripts': ['copy_orchid_examples = copy_orchid_examples:main',
                     'copy_orchid_low_level_examples = '
                     'copy_orchid_low_level_examples:main',
                     'copy_orchid_manual_examples = '
                     'copy_orchid_manual_examples:main',
                     'copy_orchid_tutorials = copy_orchid_tutorials:main']}

setup_kwargs = {
    'name': 'orchid-python-api',
    'version': '2022.4.252',
    'description': 'Defines and implements the Python API for Orchid*. (*Orchid is a mark of Reveal Energy Services, Inc.)',
    'long_description': '## Introduction \n\nThis project defines the implementation of the Python API for Orchid*.\n\nSpecifically, the `orchid` package makes Orchid features available to Python applications and to the\nPython REPL.\n\n(* Orchid is a mark of Reveal Energy Services, Inc.)\n\n### A Reading Suggestion\n\nThis document is one of several documents you may want to read:\n\n- [README](./README.md) - This file.\n- [README-dev.md](./README-dev.md) - A similar file targeting for package developers.\n- [ReleaseNotes.md](./ReleaseNotes.md) - The release notes for this project.\n\nAdditionally, as part of the 2022.4 release, we upgraded `pythonnet`, the package we use to expose .NET to the Python\nruntime, from version 2.5.2 to version 3.0.0.post1. This upgrade is a breaking upgrade. The document, \n[README-pythonnet3.md](./README-pythonnet3.md), describes the changes that we needed to make to the Orchid Python API to\nrepair failing internal tests. The document, [README-pythonnet3-low.md](./README-pythonnet3-low.md), describes the \nchanges that we needed to make to the Orchid Python API to repair failing low-level examples.\n\nAlthough one can read this document in any text editor since it is simply a text file, consider installing\nthe [Python grip utility](https://pypi.org/project/grip/). This application allows one to "render local readme\nfiles before sending off to GitHub". Although you need not send any of these file to `GitHub`, by using `grip` \nto render the file, you can much more easily navigate the document links.\n\n## Examples\n\n### High-level examples\n\nThis project includes eight scripts and six notebooks in the `examples` directory of the `orchid-python-api` package:\n\n| Name                            | Demonstrates...                                                                     |\n|---------------------------------|-------------------------------------------------------------------------------------|\n| `completion_analysis.ipynb`     | A detailed analysis of the completion performed on two different wells in a project |\n| `plot_trajectories.ipynb`       | Plotting the well trajectories for a project                                        |\n| `plot_time_series.ipynb`        | Plotting the monitor curves for a project                                           |\n| `plot_treatment.ipynb`          | Plotting the treatment curves for a specific stage of a well in a project           | \n| `search_data_frames.ipynb`      | Searching object collections and our data frame access                              | \n| `volume_2_first_response.ipynb` | Using derivatives to calculate the fluid volume pumped before the first response    | \n\nSix of the eight scripts contain the same code as the notebooks but run either at the command line or in a REPL. The\nlast three scripts:\n\n| Name                            | Demonstrates using the high-level Python API to...                               |\n|---------------------------------|----------------------------------------------------------------------------------|\n| `stage_qc_results.py`           | Read and write QC results for a stage. (Replaces low-level `stage_qc_status.py`) |\n| `change_stage_times.py`         | Change the start and stop times (the time range) of a stage                      |\n| `add_stages.py`                 | Add one or more stages to a well. (Improvement over `add_stages_low.py`)         |\n\n### Low-level examples\n\nIn addition, this project includes five scripts and a notebook in the `examples/low_level` directory of the\n`orchid-python-api` package:\n\n| Name                                      | Demonstrates...                                                  |\n|-------------------------------------------|------------------------------------------------------------------|\n| `auto_pick.py`                            | Automatically pick observations and save them to an .ifrac file  |\n| `auto_pick_and_create_stage_attribute.py` | Create and save stage attributes                                 |\n| `auto_pick_iterate_example.py`            | Use iteration to find visible stages instead of .NET method      |\n| `monitor_time_series.py`                  | Find high-level time series from a low-level monitor time series | \n| `add_stages_low.py`                       | Adds newly created stages to a well of a project                 | \n| `multi_picking_events.py`                 | Creates and adds a number of multi-picking events                |\n\nThe notebook, `auto_pick.ipynb` contain the same code as the script, `auto_pick.py`, but runs in a Jupyter\nnotebook.\n \nTo use these examples: \n\n- You may need to \n  [configure the Orchid Python API to find the Orchid installation](#configure-the-orchid-python-api)\n- You **must** \n  [configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data)\n- You may need to [view the Orchid API configuration details](#view-orchid-configuration-details)\n- You may want to invoke the command, `copy_orchid_examples`\n\n    This command copies the example files into an optionally specified (virtual environment) directory. (The \n    default destination is your current working directory.) Note that this command is a command-line script \n    that runs in a console or terminal. Additionally, this command supports a help flag, `-h` or `--help`, to \n    provide you with help on running this command.\n\nMore detailed instructions for running the examples can be found at:\n\n- [Run Orchid high-level examples](#run-orchid-high-level-examples).\n\n## Tutorials\n\nAdditionally, this project includes one notebook and one script in the `tutorials` directory of the\n`orchid-python-api` package:\n\n- `dom_navigation_tutorial.ipynb`\n- `dom_navigation_tutorial.py`\n\nThe notebook, `dom_navigation_tutorial.ipynb`, demonstrates using the Orchid Python API class,\n`SearchableProjectObjects`, to navigate a project. The `SearchableProjectObjects` provides:\n\n- Three query methods:\n    - `all_names()`\n    - `all_display_names()`\n    - `all_object_ids()`\n- Three specific search methods:\n    - `find_by_name()`\n    - `find_by_display_name()`\n    - `find_by_object_id()`\n- A general search method:\n    - `find()` - This method expects a predicate to identify project objects of interest\n- Two general iteration methods:\n  - `all_objects()`\n  - `SearchableProjectObjects` is an _iterator_\n\nThe script contains code similar to the notebook but runs either at the command line or in a REPL.\n\nTo use these tutorials:\n\n- You may need to\n  [configure the Orchid Python API to find the Orchid installation](#configure-the-orchid-python-api)\n- You **must**\n  [configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data)\n- You may need to [view the Orchid API configuration details](#view-orchid-configuration-details)\n- You may want to invoke the command, `copy_orchid_tutorials`\n\n  This command copies the tutorial files into an optionally specified (virtual environment) directory. (The\n  default destination is your current working directory.) Note that this command is a command-line script\n  that runs in a console or terminal. Additionally, this command supports a help flag, `-h` or `--help`, to\n  provide you with help on running this command.\n\nMore detailed instructions for running the tutorials can be found at:\n\n- [Run Orchid tutorials](#run-orchid-tutorials).\n\n## Getting Started\n\n### Virtual environments\n\nWe recommend the use of virtual environments to use the Orchid Python API. This choice avoids putting \nOrchid-specific packages in your system Python environment.\n\nYou have several options to create and manage virtual environments: `venv`, `pipenv`, `poetry`, and `conda`.\nThe `venv ` is available as a standard Python package and is a spartan tool to manage environments. `poetry`\nis a tool targeting developers but can be used by end-users. Our recommended tool is `pipenv`. It provides a \ngood balance between `venv ` and `poetry`. Remember, both `pipenv` and `poetry` must be installed in your \nPython environment separately from Python itself, but can be installed using `pip`. Finally, \n[conda](https://docs.conda.io/en/latest/)\n\n> is an open source package management system and environment management system that runs on Windows, macOS\n> and Linux. Conda quickly installs, runs and updates packages and their dependencies. Conda easily creates,\n> saves, loads and switches between environments on your local computer. It was created for Python programs,\n> but it can package and distribute software for any language.\n\nWe recommend the use of `pipenv`. This environment hides a number of details involved in managing a virtual\nenvironment and yet provides a fairly simple interface. We will assume in this document that you are using\n`pipenv`.\n\nAlthough we recommend `pipenv`, because we understand many of our users use `conda` (either Anaconda or\nMiniconda), we have a [section](#step-by-step-conda-install) for installing the `orchid-python-api` in a\n`conda` virtual environment.\n\nUsing any of `pipenv`, `venv` or `poetry`, your first step is to create a directory for **your** project.\nThen, change into that project directory.\n\n### Step-by-step pipenv install\n\n- Install python 3.10 by following [these installation instructions](https://docs.python.org/3/using/windows.html). To \n  ensure access from the command line, be sure to select the "Add Python 3.x to PATH" option on the\n  [installer start page](https://docs.python.org/3/_images/win_installer.png). \n- Open a console using either `powershell` or the Windows console.\n- Create a directory for the virtual environment. We will symbolically call it `/path/to/orchid-virtualenv`.\n- Change the current working directory by executing, `chdir /path/to/orchid-virtualenv`.\n- Create an empty virtual environment by running `pipenv install`.\n- Activate the virtual environment by running `pipenv shell`\n- Install Orchid by running `pip install orchid-python-api`.\n\n### Step-by-step conda install\n\n- Install [Anaconda](https://docs.anaconda.com/anaconda/install/) or\n  [Miniconda](https://docs.conda.io/en/latest/miniconda.html) following the corresponding instructions for\n  your operating system. \n- If installing on Windows, the installer will present \n  [this screen](https://docs.anaconda.com/_images/win-install-options.png). We have seen no need to install \n  Anaconda / Miniconda on your [PATH](https://en.wikipedia.org/wiki/PATH_(variable)). Although we do not\n  disagree with option to register the Anaconda / Miniconda version of Python as your default Python\n  executable, in some situations, accepting this choice can cause problems. \n- Since we will be using **both** `conda install` and `pip install` to install packages, read the article, \n  [Using Pip in a Conda Environment](https://www.anaconda.com/blog/using-pip-in-a-conda-environment). Our \n  subsequent instructions assume you have read this article and have chosen how you wish to manage these\n  two package installers together. \n  \nThe following instructions assume that you will use the simple (put perhaps not scalable) process of creating\nthe `conda` virtual environment with all packages you want to use available in the Anaconda/Miniconda\necosystem and, within that virtual environment, use `pip` to install `orchid-python-api`.\n\n- Open an Anaconda Powershell console.\n- Optionally create a directory for your work.\n    - We symbolically call it `/path/to/orchid-virtualenv`.\n    - Change to the current working directory by executing `chdir /path/to/orchid-virtualenv`.\n- Create an empty virtual environment by running `conda create --name <your-virtualenv-name> python=3.10`.\n- Activate the virtual environment by running `conda activate <your-virtualenv_name>`\n- Install Orchid by running `pip install orchid-python-api`.\n\n### Using a requirements file\n\nAn alternative method used by customers uses a requirements file, `requirements.txt`, that we create as part of our\nrelease process but **do not** include in our distribution. \n[This file](https://github.com/Reveal-Energy-Services/orchid-python-api/blob/master/requirements.txt) is available\nfrom our GitHub repository. For `pipenv`, use \n[these import instructions](https://pipenv-fork.readthedocs.io/en/latest/basics.html#importing-from-requirements-txt). For\n`conda`, read the accepted answer to this \n[Stack Overflow post](https://stackoverflow.com/questions/63379968/using-requirements-txt-to-automatically-install-packages-from-conda-channels-and)\nfor the correct command and additional options you may need to consider.\n\n### Configure the Orchid Python API\n\nThe Orchid Python API requires a licensed Orchid installation on your workstation. Depending on the details of\nthe installation, you may need to configure the Orchid Python API to refer to different locations.\n\n#### Using the fallback configuration\n\nIf you installed the latest version Orchid using the installation defaults, and you installed the\n`orchid-python-api` using the [pipenv installation instructions](#step-by-step-pipenv-install) or \nthe [conda installation instructions](#step-by-step-conda-install), you need to take **no** additional\nsteps to configure the Orchid Python API to find this installation. For your information, the default\ninstallation location is, `%ProgramFiles%\\Reveal Energy Services\\Orchid`. The Orchid Python API uses the API\nversion to find and use the corresponding version of Orchid.\n\n#### Using an environment variable\n\nThis mechanism is perhaps the easiest procedure to create an Orchid Python API configuration that changes \nrarely and is available to all your tools. It works best with a system restart. (Environment variables can be \nmade available for a narrow set of tools on your system or available to all your tools depending on arcane\ntechnical rules that you need not understand.) \n\nTo use environment variables to configure the Orchid Python API, you will need to create the environment\nvariable `ORCHID_ROOT` and set its value to the path of the `PythonApiLibs` directory beneath the Orchid\ninstallation directory. (For your information, the `PythonApiLibs` directory containing the version-specific\nOrchid binary and configuration files should be in a subdirectory like \n`ORCHID_ROOT/Orchid-2020.4.232/PythonApiLibs` when you accept the installation defaults.) \n\nThis section assumes you want to create a long-term configuration that survives a system restart and is\navailable to all your tools. Symbolically, this document will refer to the directory containing the binaries\nrequired by the Orchid Python API as `/path-to/orchid/version/python-api-libs`.\n\nTo create the required environment variable, enter the search term "environment variables" in the Windows-10 \nsearch box and select the item named, "Edit environment variables for your account." The system will then \npresent you with the "Environment Variables" dialog. Under the section named "User variables for \n<your.username>", click the "New" button. In the "Variable name" text box, enter "ORCHID_ROOT". (These two \nwords are separated by the underscore symbol.)\n\nNavigate to the "Variable Value" text box. Click the "Browse Directory" button to select the directory into\nwhich Orchid is installed, `/path-to/orchid/version/python-api-libs`. This action pastes the directory\nname into the "Variable Value" text box. Verify that the directory is correct, and then click "OK". Verify\nthat you see the name `ORCHID_ROOT` with the correct value in the "User variables for <your.username>" list.\nFinally, click "OK" to dismiss the "Environment Variables" dialog.\n\nAlthough you have created the `ORCHID_ROOT` environment variable with the appropriate value, only "new" opened\ntools can use that variable. However, the details of "new" is technical and may not correspond to what you\nexpect. If you understand these details, you can jump to \n[Verify Installation](#verify-installation). If you are not confident of these details, restart\nyour system before proceeding to [Verify Installation](#verify-installation).\n\n#### Using a configuration file\n\nAnother option to configure the Orchid Python API is by creating a configuration file. A configuration file is\neasier to change than an environment variable and does not require a system restart to work best. However, it\nrequires more knowledge and work on your part. In general, a configuration file is better if your requirements\nchange "often". For example, if you are working with multiple, side-by-side Orchid versions and Orchid Python \nAPI versions, you may find it faster and easier to create a configuration file once and change it as you \nchange Orchid / Orchid Python API versions.\n\nTo use a file to configure the Orchid Python API, you will need to create a configuration file named\n`python_api.yaml` and set the value of the `orchid` > `root` key to the path of the `PythonApiLibs` directory\nbeneath the Orchid installation directory. (For your information, the `PythonApiLibs` directory containing the\nversion-specific Orchid binary and configuration files should be in a subdirectory like\n`ORCHID_ROOT/Orchid-2020.4.232/PythonApiLibs` when you accept the installation defaults.)\n\nSymbolically, this document will refer to the directory containing the binaries required by the\nOrchid Python API as `/path-to/orchid/version/python-api-libs`.\n\nTo create a configuration file used by the Orchid Python API, you must:\n\n- Create the directory, `/path/to/home-directory/.orchid`, where `/path/to/home-directory` is a symbolic\n  reference to your home directory.\n- Create the file, `python_api.yaml` in `/path/to/home-directory/.orchid`.\n\nTechnically, the format of the file is `YAML` ("YAML Ain\'t Markup Language"), a "human friendly data\nserialization standard". (For technical details, visit [the website](https://yaml.org/). For a gentler\nintroduction, visit [the Wikipedia entry](https://en.wikipedia.org/wiki/YAML) or read / watch one of the many\n`YAML` introductions / tutorials.)\n\nBecause these articles describe `YAML` generally, they **do not** describe the details of the `YAML` document\nexpected by the Orchid Python API. We, however, distribute an example file name `python_api.yaml.example` in\neach installed `orchid-python-api` package. Assuming you created a virtual environment as described in\nthe step-by-step [pipenv installation instructions](#step-by-step-pipenv-install) or\nthe [conda installation instructions](#step-by-step-conda-install) section, you can find this example file,\n`python_api.yaml.example`, in the directory,\n`/path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples`. \n\nTo use this configuration file as an example:\n\n- Copy the file to the expected location. For example, assuming the symbolic names referenced above, execute:\n  ```\n  copy /path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples/python_api.yaml.example /path/to/home-directory/.orchid/python_api.yaml\n  ```\n- Edit the copied file, `/path/to/home-directory/.orchid/python_api.yaml`, using your favorite **text** editor.\n\nThe example file, contains comments, introduced by a leading octothorpe character (#, number sign, or hash),\nthat describe the information expected by the Orchid Python API. In summary, you\'ll need to provide a value\nfor the `orchid` > `root` key that contains (symbolically), `/path-to/orchid/version/python-api-libs`.\n\nIf you want to ensure your configuration is correct,\n[view the Orchid API configuration details](#view-orchid-configuration-details).\n\n### Configure the Orchid training data\n\nUsing the Orchid Python API **requires** a licensed Orchid installation on your workstation. However,\nto use the example Jupyter notebooks or scripts, you **must** configure the Orchid Python API to find the\nOrchid training data.\n\n#### Using an environment variable\n\nThis mechanism is perhaps the easiest procedure to create an Orchid Python API configuration that changes \nrarely and is available to all your tools. It works best with a system restart. (Environment variables can be \nmade available for a narrow set of tools on your system or available to all your tools depending on arcane\ntechnical rules that you need not understand.) \n\nTo use environment variables to configure the Orchid Python API to find the Orchid training data, you will \nneed to create the environment variable `ORCHID_TRAINING_DATA` and set its value to the location of the Orchid \ntraining data.\n\nThis document assumes you want to create a long-term configuration that survives a system restart and is \navailable to all your tools. Symbolically, this document will refer to the Orchid training data location as\n`/path-to/orchid/training-data`. \n\nTo create the required environment variable, enter the search term "environment variables" in the Windows-10 \nsearch box and select the item named, "Edit environment variables for your account." The system will then \npresent your with the "Environment Variables" dialog. Under the section named "User variables for \n<your.username>", click the "New" button. In the "Variable name" text box, enter "ORCHID_TRAINING_DATA".\n(These three words are separated by the underscore symbol.)\n\nNavigate to the "Variable Value" text box. Click the "Browse Directory" button to select the directory \ncontaining the Orchid training data, `/path-to/orchid/training-data`. This action pastes the directory name\ninto the "Variable Value" text box. Verify that the directory is correct, and then click "OK". Verify that\nyou see the name `ORCHID_TRAINING_DATA` with the correct value in the "User variables for <your.username>"\nlist. Finally, click "OK" to dismiss the "Environment Variables" dialog.\n\nAlthough you have now created the `ORCHID_TRAINING_DATA` environment variable with the appropriate value,\nonly "new" tools can now use that variable. However, the details of "new" is technical and may not correspond\nto your what you expect. If you understand these details, you can jump to\n[Verify Installation](#verify-installation). If you are not confident of these details, restart\nyour system before proceeding to [Verify Installation](#verify-installation).\n\n#### Using a configuration file\n\nAnother option to configure the Orchid Python API to find the Orchid training data is by creating a \nconfiguration file. A configuration file is easier to change than an environment variable and does not require \na system restart to work best. However, it requires more knowledge and work on your part. In general, a \nconfiguration file is better if your requirements change "often". For example, if you are working with \nmultiple, side-by-side Orchid versions and Orchid Python API versions, you may find it faster and easier to\ncreate a configuration file once and change it as you change Orchid / Orchid Python API versions or training\ndata locations.\n\nTo create a configuration file used by the Orchid Python API, you create a file named `python_api.yaml`\nand put it in the directory, `/path/to/home-directory/.orchid`, where `/path/to/home-directory` is a \nsymbolic reference to your home directory. Technically, the format of the file is `YAML` ("YAML Ain\'t Markup\nLanguage"), a "human friendly data serialization standard". (For technical details, visit\n[the website](https://yaml.org/). For a gentler introduction, visit \n[the Wikipedia entry](https://en.wikipedia.org/wiki/YAML) or read / watch on of the many `YAML` \nintroductions / tutorials.)\n\nBecause these articles describe `YAML` generally, they **do not** describe the details of the `YAML` document\nexpected by the Orchid Python API. We, however, distribute an example file name `python_api.yaml.example` in\neach installed `orchid-python-api` package. Assuming you created a virtual environment as described in\nthe step-by-step [pipenv installation instructions](#step-by-step-pipenv-install) or the \n[conda installation instructions](#step-by-step-conda-install), you can find this example file,\n`python_api.yaml.example`, in the directory,\n`/path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples`.\n\nTo use this configuration file as an example:\n\n- Copy the file to the expected location. For example, assuming the symbolic names referenced above, execute\n  the command\n  \n  ```\n  copy /path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples/python_api.yaml.example /path/to/home-directory/.orchid/python_api.yaml\n  ```  \n  \n- Edit the copied file, `/path/to/home-directory/.orchid/python_api.yaml`, using your favorite **text** editor.\n\nThe example file, contains comments, introduced by a leading octothorpe character (#, number sign, or hash),\nthat describe the information expected by the Orchid Python API. In summary, you\'ll need to provide a value\nfor the \'orchid\' > \'training_data\' key that contains the pathname of the directory containing the Orchid\ntraining data files.\n\nIf you want to ensure your configuration is correct,\n[view the Orchid API configuration details](#view-orchid-configuration-details).\n\n## Verify installation\n\n### Jupyter lab\n\n- In your activated virtual environment, run `jupyter lab` to open a browser tab.\n- In the first cell, enter `import orchid`.\n- Run the cell.\n- Wait patiently.\n\nThe import should complete with no errors.\n\n### Python REPL\n\n- In your activated virtual environment, run either `python` or `ipython` to open a REPL.\n- Enter `import orchid`.\n- Wait patiently.\n\nThe import should complete with no errors.\n\n## Run Orchid high-level examples\n\n- If you have not already done so, \n[configure the Orchid Python API to find the Orchid installation](#configure-the-orchid-python-api)\n- You **must** \n[configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data)\n- Navigate to the directory associated with the virtual environment\n- If necessary, activate the virtual environment by executing either \n    - `pipenv shell` or \n    - `conda activate <your-virtualenv_name>`.\n- Run `copy_orchid_examples`\n- If the script reports that it skipped notebooks or scripts, repeat the command with an additional argument:  \n  `copy_orchid_examples --overwrite`\n- Verify that the current directory has six example notebooks:\n    - `completion_analysis.ipynb`\n    - `plot_time_series.ipynb`\n    - `plot_trajectories.ipynb`\n    - `plot_treatment.ipynb`\n    - `search_data_frames.ipynb`\n    - `volume_2_first_response.ipynb`\n- Verify that the current directory has nine example scripts:\n    - `completion_analysis.py`\n    - `plot_time_series.py`\n    - `plot_trajectories.py`\n    - `plot_treatment.py`\n    - `search_data_frames.py`\n    - `volume_2_first_response.py`\n    - `stage_qc_results.py`\n    - `change_stage_times.py`\n    - `add_stages.py`\n\n### Run high-level example scripts\n\n- Run the first script\n    - Execute the command `python plot_trajectories.py`\n    - Wait patiently for the `matplotlib` plot window to appear.\n    - Ensure the plot is correct.\n    - Dismiss the `matplotlib` window.\n- Repeat for these scripts:\n    - `plot_treatment.py`\n    - `plot_time_series.py` \n    - `completion_analysis.py` (This script prints multiple messages and presents **multiple** plots.\n       You must dismiss each plot to continue.)\n    - `volume_2_first_response.py`\n    - `search_data_frames.py`\n- Run the `stage_qc_results.py` script.\n- Run the `change_stage_times.py` script.\n- Run the `add_stages.py` script.\n\nThe scripts, `stage_qc_results.py`, `change_stage_times.py`, and `add_stages.py`, differ from the other scripts. These\nscripts require a number of command line arguments to run correctly.\n\nFor example, to see an explanation of these arguments, execute any of this scripts with the `--help` option.\nThe most typical arguments are described in the following paragraphs.\n\nTo both read and write stage QC results, run the command:\n```\npython stage_qc_results.py -v2 /path/to/orchid-traing-data/frankNstein_Bakken_UTM13_FEET.v11.ifrac \n```\n\nTo only read the existing stage QC data, run the command\n```\npython stage_qc_results.py -v2 --read-only /path/to/orchid-traing-data/frankNstein_Bakken_UTM13_FEET.ifrac\n```\n\nTo change the stage start and stop times (the time range), run the command\n```\npython change_stage_times.py -v2 /path/to/orchid-traing-data/frankNstein_Bakken_UTM13_FEET.ifrac \n```\n\nTo add stages to a well, run the command\n```\npython add_stages.py -v2 /path/to/orchid-traing-data/frankNstein_Bakken_UTM13_FEET.v11.ifrac \n```\n\n### Run high-level example notebooks\n\n- Open Jupyter by running `jupyter lab` in the shell\n- Within Jupyter,\n    - Successfully run notebook, `plot_trajectories.ipynb`\n        1. Open notebook\n        2. Run all cells of notebook\n        3. Wait patiently\n        4. Verify that no exceptions occurred\n    - Repeat for remaining notebooks:\n        - `plot_time_series.ipynb`\n        - `plot_treatment.ipynb`\n        - `completion_analysis.ipynb`\n        - `volume_2_first_response.ipynb`\n        - `search_data_frames.ipynb`\n\n## Run Orchid tutorials\n\n- If you have not already done so,\n  [configure the Orchid Python API to find the Orchid installation](#configure-the-orchid-python-api)\n- You **must**\n  [configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data)\n- Navigate to the directory associated with the virtual environment\n- If necessary, activate the virtual environment by executing either\n    - `pipenv shell` or\n    - `conda activate <your-virtualenv_name>`.\n- Run `copy_orchid_tutorials.exe`\n- If the script reports that it skipped notebooks or scripts, repeat the command with an additional argument:  \n  `python </path/to/virtualenv/Lib/site-packages/copy_orchid_tutorials.py --overwrite`\n- Verify that the current directory has one tutorial notebooks:\n    - `dom_navigation_tutorial.ipynb`\n- Verify that the current directory has five example scripts:\n    - `dom_navigation_tutorial.py`\n\n### Run tutorial script\n\n- Run the `dom_navigation_tutorial.py` script\n    - Execute the command `python dom_navigation_tutorial.py`\n    - Follow the on-screen messages to advance through the tutorial\n\n### Run tutorial notebook\n\n- Open Jupyter by running `jupyter lab` in the shell\n- Within Jupyter,\n    - Run the notebook, `dom_navigation_tutorial.ipynb`\n        1. Open the notebook in `jupyter`\n        2. Run each cell of the notebook. Typically, this process involves\n            - Read the instructions or comments preceding the code cell(s)\n            - Observe the result of executing the code\n\n## View Orchid Configuration Details\n\nTo "debug" the Orchid Python API configuration, perform the following steps:\n\n- Change to the directory associated with your Python virtual environment.\n- If necessary, activate the virtual environment.\n- Within that virtual environment, invoke Python. It is important to create a new REPL so that you start with\n  a "clean" environment.\n- Within the Python REPL, execute the following commands.\n\n  ```\n  import logging\n  logging.basicConfig(level=logging.DEBUG)\n  import orchid\n  ```\n  \nEnabling logging **before** importing is critical. If you have already imported `orchid`, the simplest\nsolution is to close this REPL and create another, "clean" REPL.\n\nYou should see output like the following:\n\n```\nDEBUG:orchid.configuration:fallback configuration={\'orchid\': {\'root\': \'C:\\\\Program Files\\\\Reveal Energy Services\\\\Orchid\\\\Orchid-2020.4.361\'}}\nDEBUG:orchid.configuration:file configuration={\'orchid\': {\'root\': \'c:\\\\path-to\\\\bin\\\\x64\\\\Debug\\\\net48\', \'training_data \': \'c:\\\\path-to\\\\installed-training-data\'}}\nDEBUG:orchid.configuration:environment configuration = {\'orchid\': {\'root\': \'c:\\\\another\\\\path-to\\bin\\\\x64\\\\Debug\\\\net48\'}}\nDEBUG:orchid.configuration:result configuration={\'orchid\': {\'root\': \'c:\\\\another\\\\path-to\\bin\\\\x64\\\\Debug\\\\net48\'}}\n```\n\nThis output describes four details of the configuration.\n\n| Configuration | Explanation                                                            |\n|---------------|------------------------------------------------------------------------|\n| fallback      | The always available configuration (may be empty)                      |\n| file          | The configuration specified in your configuration file (may be empty)  |\n| environment   | The configuration specified using environment variables (may be empty) | \n| result        | The configuration used by the Orchid Python API (should not be empty)  |\n\n',
    'author': 'Reveal Energy Services, Inc.',
    'author_email': 'support@reveal-energy.com',
    'maintainer': 'Reveal Energy Services, Inc.',
    'maintainer_email': 'support@reveal-energy.com',
    'url': 'https://github.com/Reveal-Energy-Services/orchid-python-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
