# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


def _list_contains(array, item):
    if array is None:
        return False
    return item in array


def _list_contains_any(array, items):
    if array is None:
        return False
    return set(array).intersection(items) != set()


def _list_contains_all(array, items):
    if array is None:
        return False
    return set(array).issuperset(items)
