CREATE TABLE Pipeline_Conf
(
  algorithmMetadataCode char(100),
  codSource             char ( 6) NOT NULL CHECK (codSource IN ("ICD10", "WHO", "Tariff")),
  algorithm             char(  8) NOT NULL CHECK (algorithm IN ("InterVA", "InSilicoVA", "SmartVA")),
  workingDirectory      char(100)
);

INSERT INTO Pipeline_Conf
  (algorithmMetadataCode, codSource, algorithm, workingDirectory)
  VALUES("InterVA5|5|InterVA|5|2016 WHO Verbal Autopsy Form|v1_5_1", "WHO", "InterVA", ".");

CREATE TABLE VA_Storage
(
  id          char(100) NOT NULL,
  outcome     char( 19) NOT NULL CHECK (outcome IN ("Pushed to DHIS2", "No CoD Assigned")),
  record      blob,
  dateEntered date
);

CREATE TABLE EventLog
(
  eventDesc char(255),
  eventType char(255),
  eventTime char( 20)
);

CREATE TABLE ODK_Conf
(
  odkID            char(50),
  odkURL           char(50),
  odkUser          char(50),
  odkPassword      char(50),
  odkFormID        char(50),
  odkLastRun       date,
  odkUseCentral    char(5) NOT NULL CHECK (odkUseCentral IN ("True", "False")),
  odkProjectNumber char(6)
);

INSERT INTO ODK_Conf
  (odkURL, odkUser, odkPassword, odkFormID, odkLastRun, odkUseCentral, odkProjectNumber)
  VALUES("https://odk.swisstph.ch/ODKAggregateOpenVa", "odk_openva", "openVA2018", "va_who_v1_5_1", "1900-01-01_00:00:01", "False", "40");

CREATE TABLE InterVA_Conf
(
  version char(1) NOT NULL CHECK (version IN ("4", "5")),
  HIV     char(1) NOT NULL CHECK (HIV IN ("v", "l", "h")),
  Malaria char(1) NOT NULL CHECK (Malaria IN ("v", "l", "h"))
);

INSERT INTO InterVA_Conf (version, HIV, Malaria) VALUES("5", "v", "v");

CREATE TABLE Advanced_InterVA_Conf
(
  output         char( 8) NOT NULL CHECK (output    IN ("classic", "extended")),
  append         char( 5) NOT NULL CHECK (append    IN ("TRUE", "FALSE")),
  groupcode      char( 5) NOT NULL CHECK (groupcode IN ("TRUE", "FALSE")),
  replicate      char( 5) NOT NULL CHECK (replicate IN ("TRUE", "FALSE")),
  replicate_bug1 char( 5) NOT NULL CHECK (replicate_bug1 IN ("TRUE", "FALSE")),
  replicate_bug2 char( 5) NOT NULL CHECK (replicate_bug1 IN ("TRUE", "FALSE"))
);

INSERT INTO Advanced_InterVA_Conf
  (output, append, groupcode, replicate, replicate_bug1, replicate_bug2)
  VALUES("classic", "FALSE", "FALSE", "FALSE", "FALSE", "FALSE");

CREATE TABLE InSilicoVA_Conf
(
  data_type char(7) NOT NULL CHECK (data_type IN ("WHO2012", "WHO2016")),
  Nsim char(9)
);

INSERT INTO InSilicoVA_Conf (data_type, Nsim) VALUES("WHO2016", "4000");

CREATE TABLE Advanced_InSilicoVA_Conf
(
  isNumeric                  char( 5) NOT NULL CHECK (isNumeric                IN ("TRUE", "FALSE")),
  updateCondProb             char( 5) NOT NULL CHECK (updateCondProb           IN ("TRUE", "FALSE")),
  keepProbbase_level         char( 5) NOT NULL CHECK (keepProbbase_level       IN ("TRUE", "FALSE")),
  CondProb                   char(50),
  CondProbNum                char(50),
  datacheck                  char( 5) NOT NULL CHECK (datacheck                IN ("TRUE", "FALSE")),
  datacheck_missing          char( 5) NOT NULL CHECK (datacheck_missing        IN ("TRUE", "FALSE")),
  external_sep               char( 5) NOT NULL CHECK (external_sep             IN ("TRUE", "FALSE")),
  thin                       char( 9),
  burnin                     char( 9),
  auto_length                char( 5) NOT NULL CHECK (auto_length              IN ("TRUE", "FALSE")),
  conv_csmf                  char(10),
  jump_scale                 char(10),
  levels_prior               char(10),
  levels_strength            char(10),
  trunc_min                  char(10),
  trunc_max                  char(10),
  subpop                     char(50),
  java_option                char(10),
  seed                       char(10),
  phy_code                   char(50),
  phy_cat                    char(50),
  phy_unknown                char(50),
  phy_external               char(50),
  phy_debias                 char(50),
  exclude_impossible_cause   char( 5) NOT NULL CHECK (exclude_impossible_cause IN ("subset", "all", "InterVA", "none")),
  no_is_missing              char( 5) NOT NULL CHECK (no_is_missing            IN ("TRUE", "FALSE")),
  indiv_CI                   char(10),
  groupcode                  char( 5) NOT NULL CHECK (groupcode                IN ("TRUE", "FALSE"))
);

INSERT INTO Advanced_InSilicoVA_Conf
  (isNumeric, updateCondProb, keepProbbase_level, CondProb, CondProbNum, datacheck, datacheck_missing,
   external_sep, thin, burnin, auto_length, conv_csmf, jump_scale,
   levels_prior, levels_strength, trunc_min, trunc_max, subpop, java_option, seed,
   phy_code, phy_cat, phy_unknown, phy_external, phy_debias, exclude_impossible_cause, no_is_missing,
   indiv_CI, groupcode)
  VALUES
    ("FALSE", "TRUE", "TRUE", "NULL", "NULL", "TRUE", "TRUE",
     "TRUE", "10", "2000", "TRUE", "0.02", "0.1",
     "NULL", "1", "0.0001", "0.9999", "NULL", "-Xmx1g", "1",
     "NULL", "NULL", "NULL", "NULL", "NULL", "subset",
     "FALSE", "NULL", "FALSE");

CREATE TABLE SmartVA_Conf
(
  country       char(7),
  hiv           char(5) NOT NULL CHECK (hiv           IN ("True", "False")),
  malaria       char(5) NOT NULL CHECK (malaria       IN ("True", "False")),
  hce           char(5) NOT NULL CHECK (hce           IN ("True", "False")),
  freetext      char(5) NOT NULL CHECK (freetext      IN ("True", "False")),
  figures       char(5) NOT NULL CHECK (figures       IN ("True", "False")),
  language      char(7) NOT NULL CHECK (language      IN ("english", "chinese", "spanish"))
);

INSERT INTO SmartVA_Conf
  (country, hiv, malaria, hce, freetext, figures, language)
  VALUES ("Unknown", "False", "False", "False", "False", "False", "english");

CREATE TABLE SmartVA_Country
(
  name   char(50),
  abbrev char(7)
);

INSERT INTO SmartVA_Country
  (name, abbrev)
  VALUES
  ("Unknown", "Unknown"),
  ("Afghanistan", "AFG"),
  ("Albania", "ALB"),
  ("Algeria", "DZA"),
  ("Andorra", "AND"),
  ("Angola", "AGO"),
  ("Antigua and Barbuda", "ATG"),
  ("Argentina", "ARG"),
  ("Armenia", "ARM"),
  ("Australia", "AUS"),
  ("Austria", "AUT"),
  ("Azerbaijan", "AZE"),
  ("Bahrain", "BHR"),
  ("Bangladesh", "BGD"),
  ("Barbados", "BRB"),
  ("Belarus", "BLR"),
  ("Belgium", "BEL"),
  ("Belize", "BLZ"),
  ("Benin", "BEN"),
  ("Bhutan", "BTN"),
  ("Bolivia", "BOL"),
  ("Bosnia and Herzegovina", "BIH"),
  ("Botswana", "BWA"),
  ("Brazil", "BRA"),
  ("Brunei", "BRN"),
  ("Bulgaria", "BGR"),
  ("Burkina Faso", "BFA"),
  ("Burundi", "BDI"),
  ("Cambodia", "KHM"),
  ("Cameroon", "CMR"),
  ("Canada", "CAN"),
  ("Cape Verde", "CPV"),
  ("Central African Republic", "CAF"),
  ("Chad", "TCD"),
  ("Chile", "CHL"),
  ("China", "CHN"),
  ("Colombia", "COL"),
  ("Comoros", "COM"),
  ("Congo", "COG"),
  ("Costa Rica", "CRI"),
  ("Cote d’Ivoire", "CIV"),
  ("Croatia", "HRV"),
  ("Cuba", "CUB"),
  ("Cyprus", "CYP"),
  ("Czech Republic", "CZE"),
  ("Democratic Republic of the Congo", "COD"),
  ("Denmark", "DNK"),
  ("Djibouti", "DJI"),
  ("Dominica", "DMA"),
  ("Dominican Republic", "DOM"),
  ("Ecuador", "ECU"),
  ("Egypt", "EGY"),
  ("El Salvador", "SLV"),
  ("Equatorial Guinea", "GNQ"),
  ("Eritrea", "ERI"),
  ("Estonia", "EST"),
  ("Ethiopia", "ETH"),
  ("Federated States of Micronesia", "FSM"),
  ("Fiji", "FJI"),
  ("Finland", "FIN"),
  ("France", "FRA"),
  ("Gabon", "GAB"),
  ("Georgia", "GEO"),
  ("Germany", "DEU"),
  ("Ghana", "GHA"),
  ("Greece", "GRC"),
  ("Grenada", "GRD"),
  ("Guatemala", "GTM"),
  ("Guinea", "GIN"),
  ("Guinea-Bissau", "GNB"),
  ("Guyana", "GUY"),
  ("Haiti", "HTI"),
  ("Honduras", "HND"),
  ("Hungary", "HUN"),
  ("Iceland", "ISL"),
  ("India", "IND"),
  ("Indonesia", "IDN"),
  ("Iran", "IRN"),
  ("Iraq", "IRQ"),
  ("Ireland", "IRL"),
  ("Israel", "ISR"),
  ("Italy", "ITA"),
  ("Jamaica", "JAM"),
  ("Japan", "JPN"),
  ("Jordan", "JOR"),
  ("Kazakhstan", "KAZ"),
  ("Kenya", "KEN"),
  ("Kiribati", "KIR"),
  ("Kuwait", "KWT"),
  ("Kyrgyzstan", "KGZ"),
  ("Laos", "LAO"),
  ("Latvia", "LVA"),
  ("Lebanon", "LBN"),
  ("Lesotho", "LSO"),
  ("Liberia", "LBR"),
  ("Libya", "LBY"),
  ("Lithuania", "LTU"),
  ("Luxembourg", "LUX"),
  ("Macedonia", "MKD"),
  ("Madagascar", "MDG"),
  ("Malawi", "MWI"),
  ("Malaysia", "MYS"),
  ("Maldives", "MDV"),
  ("Mali", "MLI"),
  ("Malta", "MLT"),
  ("Marshall Islands", "MHL"),
  ("Mauritania", "MRT"),
  ("Mauritius", "MUS"),
  ("Mexico", "MEX"),
  ("Moldova", "MDA"),
  ("Mongolia", "MNG"),
  ("Montenegro", "MNE"),
  ("Morocco", "MAR"),
  ("Mozambique", "MOZ"),
  ("Myanmar", "MMR"),
  ("Namibia", "NAM"),
  ("Nepal", "NPL"),
  ("Netherlands", "NLD"),
  ("New Zealand", "NZL"),
  ("Nicaragua", "NIC"),
  ("Niger", "NER"),
  ("Nigeria", "NGA"),
  ("North Korea", "PRK"),
  ("Norway", "NOR"),
  ("Oman", "OMN"),
  ("Pakistan", "PAK"),
  ("Palestine", "PSE"),
  ("Panama", "PAN"),
  ("Papua New Guinea", "PNG"),
  ("Paraguay", "PRY"),
  ("Peru", "PER"),
  ("Philippines", "PHL"),
  ("Poland", "POL"),
  ("Portugal", "PRT"),
  ("Qatar", "QAT"),
  ("Romania", "ROU"),
  ("Russia", "RUS"),
  ("Rwanda", "RWA"),
  ("Saint Lucia", "LCA"),
  ("Saint Vincent and the Grenadines", "VCT"),
  ("Samoa", "WSM"),
  ("Sao Tome and Principe", "STP"),
  ("Saudi Arabia", "SAU"),
  ("Senegal", "SEN"),
  ("Serbia", "SRB"),
  ("Seychelles", "SYC"),
  ("Sierra Leone", "SLE"),
  ("Singapore", "SGP"),
  ("Slovakia", "SVK"),
  ("Slovenia", "SVN"),
  ("Solomon Islands", "SLB"),
  ("Somalia", "SOM"),
  ("South Africa", "ZAF"),
  ("South Korea", "KOR"),
  ("Spain", "ESP"),
  ("Sri Lanka", "LKA"),
  ("Sudan", "SDN"),
  ("Suriname", "SUR"),
  ("Swaziland", "SWZ"),
  ("Sweden", "SWE"),
  ("Switzerland", "CHE"),
  ("Syria", "SYR"),
  ("Taiwan", "TWN"),
  ("Tajikistan", "TJK"),
  ("Tanzania", "TZA"),
  ("Thailand", "THA"),
  ("The Bahamas", "BHS"),
  ("The Gambia", "GMB"),
  ("Timor-Leste", "TLS"),
  ("Togo", "TGO"),
  ("Tonga", "TON"),
  ("Trinidad and Tobago", "TTO"),
  ("Tunisia", "TUN"),
  ("Turkey", "TUR"),
  ("Turkmenistan", "TKM"),
  ("Uganda", "UGA"),
  ("Ukraine", "UKR"),
  ("United Arab Emirates", "ARE"),
  ("United Kingdom", "GBR"),
  ("United States", "USA"),
  ("Uruguay", "URY"),
  ("Uzbekistan", "UZB"),
  ("Vanuatu", "VUT"),
  ("Venezuela", "VEN"),
  ("Vietnam", "VNM"),
  ("Yemen", "YEM"),
  ("Zambia", "ZMB"),
  ("Zimbabwe", "ZWE");

CREATE TABLE DHIS_Conf
(
  dhisURL           char(50),
  dhisUser          char(50),
  dhisPassword      char(50),
  dhisOrgUnit       char(20)
);

INSERT INTO DHIS_Conf
  (dhisURL, dhisUser, dhisPassword, dhisOrgUnit)
  VALUES ("https://va30se.swisstph-mis.ch", "va-demo", "VerbalAutopsy99!", "SCVeBskgiK6");

CREATE TABLE COD_Codes_DHIS
(
  codSource  char(  6) NOT NULL CHECK (codSource IN ("ICD10", "WHO", "Tariff")),
  codCode    char( 20),
  codName    char(100),
  codID      char( 20)
);

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("Tariff", "A-1", "A-1 AIDS", "O34yESZR6OZ"),
    ("Tariff", "A-3", "A-3 Bite of Venomous Animal", "HSkdTFXEiK2"),
    ("Tariff", "A-4", "A-4 Breast Cancer", "mDCOzrLFyVR"),
    ("Tariff", "A-5", "A-5 Cervical Cancer", "FAY3ziTIjXk"),
    ("Tariff", "A-6", "A-6 Cirrhosis", "XjRDCzX7sXB"),
    ("Tariff", "A-7", "A-7 Colorectal Cancer", "TNSyAm9zihI"),
    ("Tariff", "A-9", "A-9 Diabetes", "HwAVgeK4gNV"),
    ("Tariff", "A-10", "A-10 Diarrhea/Dysentery", "FiIAH1dSDAt"),
    ("Tariff", "A-11", "A-11 Drowning", "LJLqYQU7Tsr"),
    ("Tariff", "A-12", "A-12 Epilepsy", "x4S6kmWqjpH"),
    ("Tariff", "A-13", "A-13 Esophageal Cancer", "frHQKNLLnpj"),
    ("Tariff", "A-14", "A-14 Falls", "Jmbjk4IUdam"),
    ("Tariff", "A-15", "A-15 Fires", "rcBwPFjzt1U"),
    ("Tariff", "A-16", "A-16 Homicide", "DdvyxgqZ1hT"),
    ("Tariff", "A-18", "A-18 Leukemia/Lymphomas", "KjFBmFTduOX"),
    ("Tariff", "A-19", "A-19 Lung Cancer", "ApQDHg1ILgM"),
    ("Tariff", "A-20", "A-20 Malaria", "UvbQRK3F61c"),
    ("Tariff", "A-21", "A-21 Maternal", "w5YqAoKwEBL"),
    ("Tariff", "A-22", "A-22 Other Cardiovascular Diseases", "YBzy88KDiX9"),
    ("Tariff", "A-23", "A-23 Other Infectious Diseases", "io2tRYlU3Zi"),
    ("Tariff", "A-24", "A-24 Other Injuries", "zYpZf8fRIIV"),
    ("Tariff", "A-25", "A-25 Other Non-communicable Diseases", "FWPZAfncH5P"),
    ("Tariff", "A-26", "A-26 Pneumonia", "OGOmBHPAJxP"),
    ("Tariff", "A-27", "A-27 Poisonings", "gu1xmFW1eIy"),
    ("Tariff", "A-28", "A-28 Prostate Cancer", "SMIeXMkTI38"),
    ("Tariff", "A-29", "A-29 Renal Failure", "mxjSSnJr1Yo"),
    ("Tariff", "A-30", "A-30 Road Traffic", "PuH5PRS2o45"),
    ("Tariff", "A-31", "A-31 Stomach Cancer", "RwCLqzjy9oz"),
    ("Tariff", "A-32", "A-32 Stroke", "t6eygKdkzS8"),
    ("Tariff", "A-33", "A-33 Suicide", "qrK026eO5Gp"),
    ("Tariff", "A-34", "A-34 TB", "p1XpkneCiSK"),
    ("Tariff", "A-35", "A-35 Chronic Respiratory", "Vb65y5JPJLZ"),
    ("Tariff", "A-36", "A-36 Ischemic Heart Disease", "nGP0pKAOhUx"),
    ("Tariff", "A-37", "A-37 Other Cancers ", "pM7Clmjux13"),
    ("Tariff", "C-1", "C-1 AIDS", "eTBb6PLwBTe"),
    ("Tariff", "C-2", "C-2 Bite of Venomous Animal", "DoZy5Ec0XbG"),
    ("Tariff", "C-3", "C-3 Diarrhea/Dysentery", "rxQMw0gUXVc"),
    ("Tariff", "C-4", "C-4 Drowning", "kG6vPSCO5Pd"),
    ("Tariff", "C-5", "C-5 Encephalitis", "eKpvKsehQSn"),
    ("Tariff", "C-6", "C-6 Falls", "D7Wnkx2tRW5"),
    ("Tariff", "C-7", "C-7 Fires", "ehYBDmA42gQ"),
    ("Tariff", "C-8", "C-8 Hemorrhagic fever", "iErIcFKpz6I"),
    ("Tariff", "C-9", "C-9 Malaria", "o448RBABWVD"),
    ("Tariff", "C-10", "C-10 Measles", "iJ5lrIIeiAP"),
    ("Tariff", "C-11", "C-11 Meningitis", "XdO5Gjgp6rg"),
    ("Tariff", "C-12", "C-12 Other Cancers", "kT0B8xrmZlQ"),
    ("Tariff", "C-13", "C-13 Other Cardiovascular Diseases", "VxcXH2YIdSG"),
    ("Tariff", "C-14", "C-14 Other Defined Causes of Child Deaths", "bMfYxjtW4QY"),
    ("Tariff", "C-15", "C-15 Other Digestive Diseases", "tgLjuTwmWPt"),
    ("Tariff", "C-16", "C-16 Other Infectious Diseases", "m2uaH3PekKR"),
    ("Tariff", "C-17", "C-17 Pneumonia", "rsUl8eALTfu"),
    ("Tariff", "C-18", "C-18 Poisonings", "i4FLHMM6Kx2"),
    ("Tariff", "C-19", "C-19 Road Traffic", "ik1hzVMTbhF"),
    ("Tariff", "C-20", "C-20 Sepsis", "lAy7XipwxTA"),
    ("Tariff", "C-21", "C-21 Violent Death", "eRgQmiyvFOU"),
    ("Tariff", "N-1", "N-1 Birth asphyxia", "lzYsYiNZ8CV"),
    ("Tariff", "N-2", "N-2 Congenital malformation", "TySM24LeeEB"),
    ("Tariff", "N-3", "N-3 Meningitis/Sepsis", "qf28E9sI0Wu"),
    ("Tariff", "N-4", "N-4 Pneumonia", "eEZCOpkfHs1"),
    ("Tariff", "N-5", "N-5 Preterm Delivery", "dQYlrCvMo90"),
    ("Tariff", "N-6", "N-6 Stillbirth", "DXAvi49NO5c");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("WHO", "1.01", "01.01 Sepsis (non-obstetric)", "jH7NEsolXEA"),
    ("WHO", "1.02", "01.02 Acute respiratory infection, including pneumonia", "x8emxOen5lP"),
    ("WHO", "1.03", "01.03 HIV/AIDS related death", "lGHuF0M8LBS"),
    ("WHO", "1.04", "01.04 Diarrhoeal diseases", "MDFiWekbno2"),
    ("WHO", "1.05", "01.05 Malaria", "MSLASIFt6GZ"),
    ("WHO", "1.06", "01.06 Measles", "Vel8Sqsh8A7"),
    ("WHO", "1.07", "01.07 Meningitis and encephalitis", "OJIn63f2yB3"),
    ("WHO", "01.08 10.05", "01.08 10.05 Tetanus", "lgGwjvB6ml4"),
    ("WHO", "1.09", "01.09 Pulmonary tuberculosis", "E0RMhOH45e3"),
    ("WHO", "1.1", "01.10 Pertussis", "V5QYzX7vCdG"),
    ("WHO", "1.11", "01.11 Haemorrhagic fever", "JnSgGjOJSHm"),
    ("WHO", "1.12", "01.12 Dengue fever", "AnYJVOKi45z"),
    ("WHO", "1.99", "01.99 Unspecified infectious disease", "OS4aA4epQBA"),
    ("WHO", "2.01", "02.01 Oral neoplasms", "hSJo2VUMVxk"),
    ("WHO", "2.02", "02.02 Digestive neoplasms", "z1uCgGCcSdi"),
    ("WHO", "2.03", "02.03 Respiratory neoplasms", "smKSu5z9cUu"),
    ("WHO", "2.04", "02.04 Breast neoplasms", "SPo6aQHfYCj"),
    ("WHO", "02.05 02.06", "02.05 02.06 Reproductive neoplasms M, F", "yB0qmB07G1A"),
    ("WHO", "2.99", "02.99 Other and unspecified neoplasms", "UYG5jp5ZgfL"),
    ("WHO", "3.01", "03.01 Severe anaemia", "QtULEnwuqko"),
    ("WHO", "3.02", "03.02 Severe malnutrition", "pHvz4D5OqIu"),
    ("WHO", "3.03", "03.03 Diabetes mellitus", "TeX8TnatThp"),
    ("WHO", "4.01", "04.01 Acute cardiac disease", "cDjYq34Rg9s"),
    ("WHO", "4.03", "04.03 Sickle cell with crisis", "f5kvs4Hm7Gr"),
    ("WHO", "4.02", "04.02 Stroke", "HV604qvW8nE"),
    ("WHO", "4.99", "04.99 Other and unspecified cardiac disease", "sTSxkeYPAzY"),
    ("WHO", "5.01", "05.01 Chronic obstructive pulmonary disease (COPD)", "YiiaJJEPtXw"),
    ("WHO", "5.02", "05.02 Asthma", "v8gECswynQe"),
    ("WHO", "6.01", "06.01 Acute abdomen", "N9ZzJa8gvhp"),
    ("WHO", "6.02", "06.02 Liver cirrhosis", "bWyYttBSGsI"),
    ("WHO", "7.01", "07.01 Renal failure", "Fr2sqVa2Qyw"),
    ("WHO", "8.01", "08.01 Epilepsy", "EqBTdzLRKRK"),
    ("WHO", "98", "98 Other and unspecified non-communicable disease", "sEqGVcTn5IE"),
    ("WHO", "9.01", "09.01 Ectopic pregnancy", "oTmK7YIS0N3"),
    ("WHO", "9.02", "09.02 Abortion-related death", "WN1sNGIPJgH"),
    ("WHO", "9.03", "09.03 Pregnancy-induced hypertension", "Ha54Amab5Ib"),
    ("WHO", "9.04", "09.04 Obstetric haemorrhage", "NyNN1QV1m0S"),
    ("WHO", "9.05", "09.05 Obstructed labour", "l4Q0QwfGOJf"),
    ("WHO", "9.06", "09.06 Pregnancy-related sepsis", "iLNOHsMgVQV"),
    ("WHO", "9.07", "09.07 Anaemia of pregnancy", "gb9XzSwCSfD"),
    ("WHO", "9.08", "09.08 Ruptured uterus", "vTDsdTiiowN"),
    ("WHO", "9.99", "09.99 Other and unspecified maternal cause", "KGP9h1zXoJq"),
    ("WHO", "10.01", "10.01 Prematurity ", "mxTwzZhOmxx"),
    ("WHO", "10.02", "10.02 Birth asphyxia ", "fq9OuZRYXIE"),
    ("WHO", "10.03", "10.03 Neonatal pneumonia ", "KhW8rwObq1j"),
    ("WHO", "10.04", "10.04 Neonatal sepsis ", "Ny0Nh8ofj9q"),
    ("WHO", "10.06", "10.06 Congenital malformation", "Fs1qArGibGp"),
    ("WHO", "10.99", "10.99 Other and unspecified perinatal cause of death", "oITpJX8pdXB"),
    ("WHO", "11.01", "11.01 Fresh stillbirth", "D4Oi1Ejzg1a"),
    ("WHO", "11.02", "11.02 Macerated stillbirth ", "sMHbDYh3dy7"),
    ("WHO", "12.01", "12.01 Road traffic accident ", "hwf6p0Z4I8z"),
    ("WHO", "12.02", "12.02 Other transport accident", "PCLtVbZ6fzP"),
    ("WHO", "12.03", "12.03 Accidental fall", "vMR4LKEjdQq"),
    ("WHO", "12.04", "12.04 Accidental drowning and submersion", "DcBpONZ9W0E"),
    ("WHO", "12.05", "12.05 Accidental exposure to smoke, fire and flames", "whmvBiSY9P1"),
    ("WHO", "12.06", "12.06 Contact with venomous plant/animal ", "vhqxIHS9mXb"),
    ("WHO", "12.07", "12.07Accidental poisoning and exposure to noxious substance", "BzyH4mbU1No"),
    ("WHO", "12.08", "12.08 Intentional self-harm", "VOeX6DB90lC"),
    ("WHO", "12.09", "12.09 Assault", "BE4Jc22VCvM"),
    ("WHO", "12.1", "12.10 Exposure to force of nature", "OqOoVE47VXY"),
    ("WHO", "12.99", "12.99 Other and unspecified external cause of death", "wHv4t7FZmtv"),
    ("WHO", "99", "99 Cause of death unknown", "r1sgBzRWLjE");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "A00", "A00 Cholera", "YrElhzkDv6W"),
    ("ICD10", "A00.0", "A00.0 Cholera due to Vibrio cholerae 01, biovar cholerae", "Ghd8Jbmz86M"),
    ("ICD10", "A00.1", "A00.1 Cholera due to Vibrio cholerae 01, biovar eltor", "P7OWLS5ecuv"),
    ("ICD10", "A00.9", "A00.9 Cholera, unspecified", "eci2YBDPbYP"),
    ("ICD10", "A01", "A01 Typhoid and paratyphoid fevers", "pDoBESL2fHw"),
    ("ICD10", "A01.0", "A01.0 Typhoid fever", "KSEpdBWOhck"),
    ("ICD10", "A01.1", "A01.1 Paratyphoid fever A", "tFG2GmmAgzE"),
    ("ICD10", "A01.2", "A01.2 Paratyphoid fever B", "EccwwnUjwZd"),
    ("ICD10", "A01.3", "A01.3 Paratyphoid fever C", "eeRbYrNOXrh"),
    ("ICD10", "A01.4", "A01.4 Paratyphoid fever, unspecified", "zccRPHFZh0z"),
    ("ICD10", "A02", "A02 Other salmonella infections", "O5lO9JiAH7D"),
    ("ICD10", "A02.0", "A02.0 Salmonella enteritis", "yti57PRKQ5z"),
    ("ICD10", "A02.1", "A02.1 Salmonella sepsis", "LiVtVpMImUB"),
    ("ICD10", "A02.2", "A02.2 Localized salmonella infections", "GJMtV6TCK48"),
    ("ICD10", "A02.8", "A02.8 Other specified salmonella infections", "ZqHf6qvZNAX"),
    ("ICD10", "A02.9", "A02.9 Salmonella infection, unspecified", "IlQDdBGJi1a"),
    ("ICD10", "A03", "A03 Shigellosis", "ErHxxz3UNrH"),
    ("ICD10", "A03.0", "A03.0 Shigellosis due to Shigella dysenteriae", "p5FLogUfruI"),
    ("ICD10", "A03.1", "A03.1 Shigellosis due to Shigella flexneri", "TXv2bn1DW1P"),
    ("ICD10", "A03.2", "A03.2 Shigellosis due to Shigella boydii", "nPue8lJ0ieY"),
    ("ICD10", "A03.3", "A03.3 Shigellosis due to Shigella sonnei", "qT98qNeoc9e"),
    ("ICD10", "A03.8", "A03.8 Other shigellosis", "Y12WBAIEo02"),
    ("ICD10", "A03.9", "A03.9 Shigellosis, unspecified", "dGgyiOyX5HY"),
    ("ICD10", "A04", "A04 Other bacterial intestinal infections", "Uddf3XgQLIO"),
    ("ICD10", "A04.0", "A04.0 Enteropathogenic Escherichia coli infection", "NJNHX4PCA6B"),
    ("ICD10", "A04.1", "A04.1 Enterotoxigenic Escherichia coli infection", "rha6tlpXuTW"),
    ("ICD10", "A04.2", "A04.2 Enteroinvasive Escherichia coli infection", "Sw27wwhPIKW"),
    ("ICD10", "A04.3", "A04.3 Enterohaemorrhagic Escherichia coli infection", "Ish2Sjd45oL"),
    ("ICD10", "A04.4", "A04.4 Other intestinal Escherichia coli infections", "m0go8gxcPnA"),
    ("ICD10", "A04.5", "A04.5 Campylobacter enteritis", "cBPrwMWjwvl"),
    ("ICD10", "A04.6", "A04.6 Enteritis due to Yersinia enterocolitica", "kCKzB29Gdz4"),
    ("ICD10", "A04.7", "A04.7 Enterocolitis due to Clostridium difficile", "bSBzAUBWnAp"),
    ("ICD10", "A04.8", "A04.8 Other specified bacterial intestinal infections", "uZT7fe7LL82"),
    ("ICD10", "A04.9", "A04.9 Bacterial intestinal infection, unspecified", "tC34VW9aoKO"),
    ("ICD10", "A05", "A05 Other bacterial foodborne intoxications, not elsewhere classified", "gfKCMAfP9eX"),
    ("ICD10", "A05.0", "A05.0 Foodborne staphylococcal intoxication", "YcLWTKiL845"),
    ("ICD10", "A05.1", "A05.1 Botulism", "cEU0ldlaYMV"),
    ("ICD10", "A05.2", "A05.2 Foodborne Clostridium perfringens [Clostridium welchii] intoxication", "U19eyreTFZU"),
    ("ICD10", "A05.3", "A05.3 Foodborne Vibrio parahaemolyticus intoxication", "LTM4LrjLYve"),
    ("ICD10", "A05.4", "A05.4 Foodborne Bacillus cereus intoxication", "RFCd2ZkTJ9Z"),
    ("ICD10", "A05.8", "A05.8 Other specified bacterial foodborne intoxications", "MHtDP6KBrfo"),
    ("ICD10", "A05.9", "A05.9 Bacterial foodborne intoxication, unspecified", "ZpoKiJn48tg"),
    ("ICD10", "A06", "A06 Amoebiasis", "ATaCPkLeEFF"),
    ("ICD10", "A06.0", "A06.0 Acute amoebic dysentery", "PM7bNhr6knC"),
    ("ICD10", "A06.1", "A06.1 Chronic intestinal amoebiasis", "PrcmVYiCaoD"),
    ("ICD10", "A06.2", "A06.2 Amoebic nondysenteric colitis", "GiK623MJvuK"),
    ("ICD10", "A06.3", "A06.3 Amoeboma of intestine", "fGhYzEefGHA"),
    ("ICD10", "A06.4", "A06.4 Amoebic liver abscess", "GYPttp6jxxl"),
    ("ICD10", "A06.5", "A06.5 Amoebic lung abscess", "SDXXJfs1S5q"),
    ("ICD10", "A06.6", "A06.6 Amoebic brain abscess", "TnWpaH04YHe"),
    ("ICD10", "A06.7", "A06.7 Cutaneous amoebiasis", "SkFMcLFtETA"),
    ("ICD10", "A06.8", "A06.8 Amoebic infection of other sites", "FTODE5hJ7g6"),
    ("ICD10", "A06.9", "A06.9 Amoebiasis, unspecified", "hhyVbuNY4iG"),
    ("ICD10", "A07", "A07 Other protozoal intestinal diseases", "tfoaFdryGLw"),
    ("ICD10", "A07.0", "A07.0 Balantidiasis", "O767qdwUk69"),
    ("ICD10", "A07.1", "A07.1 Giardiasis [lambliasis]", "AaoAIgTBi2Z"),
    ("ICD10", "A07.2", "A07.2 Cryptosporidiosis", "LUunjEt3y31"),
    ("ICD10", "A07.3", "A07.3 Isosporiasis", "Y7CRCqU73lB"),
    ("ICD10", "A07.8", "A07.8 Other specified protozoal intestinal diseases", "LYK8tVYMUPR"),
    ("ICD10", "A07.9", "A07.9 Protozoal intestinal disease, unspecified", "MG8Xqcru45R"),
    ("ICD10", "A08", "A08 Viral and other specified intestinal infections", "L0Y9K6XSnah"),
    ("ICD10", "A08.0", "A08.0 Rotaviral enteritis", "FYoBYOJpfwL"),
    ("ICD10", "A08.1", "A08.1 Acute gastroenteropathy due to Norwalk agent", "OCYYhWX81Mn"),
    ("ICD10", "A08.2", "A08.2 Adenoviral enteritis", "LEBVQLfaZB6"),
    ("ICD10", "A08.3", "A08.3 Other viral enteritis", "UvSuLNq4Hiv"),
    ("ICD10", "A08.4", "A08.4 Viral intestinal infection, unspecified", "iihkhhgmqeS"),
    ("ICD10", "A08.5", "A08.5 Other specified intestinal infections", "mBdhhEWt2PG"),
    ("ICD10", "A09", "A09 Other gastroenteritis and colitis of infectious and unspecified origin", "F7hfqY93rFk"),
    ("ICD10", "A09.0", "A09.0 Other and unspecified gastroenteritis and colitis of infectious origin", "duvbJP9P1iF"),
    ("ICD10", "A09.9", "A09.9 Gastroenteritis and colitis of unspecified origin", "lvMajN5UZyk"),
    ("ICD10", "A15", "A15 Respiratory tuberculosis, bacteriologically and histologically confirmed", "nuHAW818D9l"),
    ("ICD10", "A15.0", "A15.0 Tuberculosis of lung, confirmed by sputum microscopy with or without culture", "cJ3L20S7FCN"),
    ("ICD10", "A15.1", "A15.1 Tuberculosis of lung, confirmed by culture only", "JRXc65mYk4t"),
    ("ICD10", "A15.2", "A15.2 Tuberculosis of lung, confirmed histologically", "JNEaYL8Mzhx"),
    ("ICD10", "A15.3", "A15.3 Tuberculosis of lung, confirmed by unspecified means", "d21jXeCm9AY"),
    ("ICD10", "A15.4", "A15.4 Tuberculosis of intrathoracic lymph nodes, confirmed bacteriologically and histologically", "PFWNicGhWvF"),
    ("ICD10", "A15.5", "A15.5 Tuberculosis of larynx, trachea and bronchus, confirmed bacteriologically and histologically", "cmQHYjj3Ime"),
    ("ICD10", "A15.6", "A15.6 Tuberculous pleurisy, confirmed bacteriologically and histologically", "zyjLn7zgABY"),
    ("ICD10", "A15.7", "A15.7 Primary respiratory tuberculosis, confirmed bacteriologically and histologically", "dksjV8Q2V3o"),
    ("ICD10", "A15.8", "A15.8 Other respiratory tuberculosis, confirmed bacteriologically and histologically", "IE8WsDv0N4L"),
    ("ICD10", "A15.9", "A15.9 Respiratory tuberculosis unspecified, confirmed bacteriologically and histologically", "WnwnNAt1I81"),
    ("ICD10", "A16", "A16 Respiratory tuberculosis, not confirmed bacteriologically or histologically", "VKUBidm42y0"),
    ("ICD10", "A16.0", "A16.0 Tuberculosis of lung, bacteriologically and histologically negative", "rT68A3XDgB0"),
    ("ICD10", "A16.1", "A16.1 Tuberculosis of lung, bacteriological and histological examination not done", "S0H2cWiayU4"),
    ("ICD10", "A16.2", "A16.2 Tuberculosis of lung, without mention of bacteriological or histological confirmation", "ThnDUzCguy7"),
    ("ICD10", "A16.3", "A16.3 Tuberculosis of intrathoracic lymph nodes, without mention of bacteriological or histological confirmation", "g4QN9rnKK8e"),
    ("ICD10", "A16.4", "A16.4 Tuberculosis of larynx, trachea and bronchus, without mention of bacteriological or histological confirmation", "nF1CpNsagvU"),
    ("ICD10", "A16.5", "A16.5 Tuberculous pleurisy, without mention of bacteriological or histological confirmation", "dzuzfX5KAVy"),
    ("ICD10", "A16.7", "A16.7 Primary respiratory tuberculosis without mention of bacteriological or histological confirmation", "M0GlE6dP0vd"),
    ("ICD10", "A16.8", "A16.8 Other respiratory tuberculosis, without mention of bacteriological or histological confirmation", "ey3RipCNqNQ"),
    ("ICD10", "A16.9", "A16.9 Respiratory tuberculosis unspecified, without mention of bacteriological or histological confirmation", "ntGtcgULBKE"),
    ("ICD10", "A17", "A17 Tuberculosis of nervous system", "iATOEQWRVzX"),
    ("ICD10", "A17.0", "A17.0 Tuberculous meningitis", "Qneh91josU4"),
    ("ICD10", "A17.1", "A17.1 Meningeal tuberculoma", "cp7O6OCTbyc"),
    ("ICD10", "A17.8", "A17.8 Other tuberculosis of nervous system", "JPCu1FQ5BzN"),
    ("ICD10", "A17.9", "A17.9 Tuberculosis of nervous system, unspecified", "c2CtuyZ47El"),
    ("ICD10", "A18", "A18 Tuberculosis of other organs", "pkFt03v8m5K"),
    ("ICD10", "A18.0", "A18.0 Tuberculosis of bones and joints", "a23OAy2C1pJ"),
    ("ICD10", "A18.1", "A18.1 Tuberculosis of genitourinary system", "i6xrojAlUCY"),
    ("ICD10", "A18.2", "A18.2 Tuberculous peripheral lymphadenopathy", "qiBZ7DXKZKq"),
    ("ICD10", "A18.3", "A18.3 Tuberculosis of intestines, peritoneum and mesenteric glands", "tQTMCmkbFNk"),
    ("ICD10", "A18.4", "A18.4 Tuberculosis of skin and subcutaneous tissue", "zUYcqSJj1fO"),
    ("ICD10", "A18.5", "A18.5 Tuberculosis of eye", "WJFKyNhSAU2"),
    ("ICD10", "A18.6", "A18.6 Tuberculosis of ear", "uSFK2ir1LGD"),
    ("ICD10", "A18.7", "A18.7 Tuberculosis of adrenal glands", "Sd9ZiqkRF0Y"),
    ("ICD10", "A18.8", "A18.8 Tuberculosis of other specified organs", "Tcq2Rd1YShc"),
    ("ICD10", "A19", "A19 Miliary tuberculosis", "qvIGCONY23K"),
    ("ICD10", "A19.0", "A19.0 Acute miliary tuberculosis of a single specified site", "JICGiuZWhye"),
    ("ICD10", "A19.1", "A19.1 Acute miliary tuberculosis of multiple sites", "EBj2JTS8QuY"),
    ("ICD10", "A19.2", "A19.2 Acute miliary tuberculosis, unspecified", "VvmrKPrCdHE"),
    ("ICD10", "A19.8", "A19.8 Other miliary tuberculosis", "goGr7KdJsav"),
    ("ICD10", "A19.9", "A19.9 Miliary tuberculosis, unspecified", "XPoWtbXJnLr"),
    ("ICD10", "A20", "A20 Plague", "GcnLteiJIqd"),
    ("ICD10", "A20.0", "A20.0 Bubonic plague", "B1oGfMYkI2D"),
    ("ICD10", "A20.1", "A20.1 Cellulocutaneous plague", "ujORHt20Ul3"),
    ("ICD10", "A20.2", "A20.2 Pneumonic plague", "ACmWgGfC2DB"),
    ("ICD10", "A20.3", "A20.3 Plague meningitis", "TpnAHeBlSuy"),
    ("ICD10", "A20.7", "A20.7 Septicaemic plague", "d8sTzoBrVdR"),
    ("ICD10", "A20.8", "A20.8 Other forms of plague", "TCprq54UA5y"),
    ("ICD10", "A20.9", "A20.9 Plague, unspecified", "aUPWZL7pnWQ"),
    ("ICD10", "A21", "A21 Tularaemia", "RIPkbGg0xm6"),
    ("ICD10", "A21.0", "A21.0 Ulceroglandular tularaemia", "RJMq2bCujgd"),
    ("ICD10", "A21.1", "A21.1 Oculoglandular tularaemia", "SgOziaJWwI1"),
    ("ICD10", "A21.2", "A21.2 Pulmonary tularaemia", "iKAIhgjAAzT"),
    ("ICD10", "A21.3", "A21.3 Gastrointestinal tularaemia", "MDVU6uPLWxZ"),
    ("ICD10", "A21.7", "A21.7 Generalized tularaemia", "VbMimXXICFS"),
    ("ICD10", "A21.8", "A21.8 Other forms of tularaemia", "sGG886jLNkN"),
    ("ICD10", "A21.9", "A21.9 Tularaemia, unspecified", "rfLYJvSwbLL"),
    ("ICD10", "A22", "A22 Anthrax", "XEFiklyV4U6"),
    ("ICD10", "A22.0", "A22.0 Cutaneous anthrax", "yMqlUotFGzC"),
    ("ICD10", "A22.1", "A22.1 Pulmonary anthrax", "FcYe2pXYr0c"),
    ("ICD10", "A22.2", "A22.2 Gastrointestinal anthrax", "jVzOGzFrFjA"),
    ("ICD10", "A22.7", "A22.7 Anthrax sepsis", "lhisFZ1Kbu7"),
    ("ICD10", "A22.8", "A22.8 Other forms of anthrax", "kAiksjoOvJu"),
    ("ICD10", "A22.9", "A22.9 Anthrax, unspecified", "bKqoGU3Cl0C"),
    ("ICD10", "A23", "A23 Brucellosis", "OgnnLxikSaK"),
    ("ICD10", "A23.0", "A23.0 Brucellosis due to Brucella melitensis", "HQZ92qOiTJr"),
    ("ICD10", "A23.1", "A23.1 Brucellosis due to Brucella abortus", "qgmfjKz60vj"),
    ("ICD10", "A23.2", "A23.2 Brucellosis due to Brucella suis", "zedHqRrrJVX"),
    ("ICD10", "A23.3", "A23.3 Brucellosis due to Brucella canis", "g8zZlRaYMNC"),
    ("ICD10", "A23.8", "A23.8 Other brucellosis", "eue6faqeWRE"),
    ("ICD10", "A23.9", "A23.9 Brucellosis, unspecified", "SXKLJDor25I"),
    ("ICD10", "A24", "A24 Glanders and melioidosis", "uax4Fa5hVlX"),
    ("ICD10", "A24.0", "A24.0 Glanders", "cfAy9dUZ9G2"),
    ("ICD10", "A24.1", "A24.1 Acute and fulminating melioidosis", "aIdQGG0oXV9"),
    ("ICD10", "A24.2", "A24.2 Subacute and chronic melioidosis", "DeYt1RJWEny"),
    ("ICD10", "A24.3", "A24.3 Other melioidosis", "gibKBs1gf3s"),
    ("ICD10", "A24.4", "A24.4 Melioidosis, unspecified", "ivKPdUDkian"),
    ("ICD10", "A25", "A25 Rat-bite fevers", "g0b1yTYpLoC"),
    ("ICD10", "A25.0", "A25.0 Spirillosis", "IsZ8QAgk5yF"),
    ("ICD10", "A25.1", "A25.1 Streptobacillosis", "IgX3GVOPEt1"),
    ("ICD10", "A25.9", "A25.9 Rat-bite fever, unspecified", "eL75ergLenK"),
    ("ICD10", "A26", "A26 Erysipeloid", "cNBqOowcQFX"),
    ("ICD10", "A26.0", "A26.0 Cutaneous erysipeloid", "UYOB6Pv7Gvp"),
    ("ICD10", "A26.7", "A26.7 Erysipelothrix sepsis", "rbRJLk5Hqjb"),
    ("ICD10", "A26.8", "A26.8 Other forms of erysipeloid", "gqgYWMUHadI"),
    ("ICD10", "A26.9", "A26.9 Erysipeloid, unspecified", "fuUXP86MELV"),
    ("ICD10", "A27", "A27 Leptospirosis", "gJzBx5UygEl"),
    ("ICD10", "A27.0", "A27.0 Leptospirosis icterohaemorrhagica", "oB0bP6AmUeJ"),
    ("ICD10", "A27.8", "A27.8 Other forms of leptospirosis", "hS05rL08cXP"),
    ("ICD10", "A27.9", "A27.9 Leptospirosis, unspecified", "FrF2cWZ8vKK"),
    ("ICD10", "A28", "A28 Other zoonotic bacterial diseases, not elsewhere classified", "vPLCsCoQ8E4"),
    ("ICD10", "A28.0", "A28.0 Pasteurellosis", "LHc4TNtpN8P"),
    ("ICD10", "A28.1", "A28.1 Cat-scratch disease", "ilePkpd9350"),
    ("ICD10", "A28.2", "A28.2 Extraintestinal yersiniosis", "ylVj80lLLPZ"),
    ("ICD10", "A28.8", "A28.8 Other specified zoonotic bacterial diseases, not elsewhere classified", "PIm9BdFeckZ"),
    ("ICD10", "A28.9", "A28.9 Zoonotic bacterial disease, unspecified", "g5ZfAtEsxMb"),
    ("ICD10", "A30", "A30 Leprosy [Hansen disease]", "AaRLvilTvuU"),
    ("ICD10", "A30.0", "A30.0 Indeterminate leprosy", "fWmAI58CmMh"),
    ("ICD10", "A30.1", "A30.1 Tuberculoid leprosy", "LBJU4ASf1Dx"),
    ("ICD10", "A30.2", "A30.2 Borderline tuberculoid leprosy", "qsFsh2eN10G"),
    ("ICD10", "A30.3", "A30.3 Borderline leprosy", "rAVnHTGGwTG"),
    ("ICD10", "A30.4", "A30.4 Borderline lepromatous leprosy", "fVRmXFm9wsz"),
    ("ICD10", "A30.5", "A30.5 Lepromatous leprosy", "PqfdTTa12Kg"),
    ("ICD10", "A30.8", "A30.8 Other forms of leprosy", "IxXgr7i43na"),
    ("ICD10", "A30.9", "A30.9 Leprosy, unspecified", "flZ9J8s22fP"),
    ("ICD10", "A31", "A31 Infection due to other mycobacteria", "ZJXdDpnBcSO"),
    ("ICD10", "A31.0", "A31.0 Pulmonary mycobacterial infection", "gJ1PtT3sVEU"),
    ("ICD10", "A31.1", "A31.1 Cutaneous mycobacterial infection", "RLup08gsd7E"),
    ("ICD10", "A31.8", "A31.8 Other mycobacterial infections", "hc5X7jCZwyS"),
    ("ICD10", "A31.9", "A31.9 Mycobacterial infection, unspecified", "H5i8CqUWxIc"),
    ("ICD10", "A32", "A32 Listeriosis", "PlxjjalwHVP"),
    ("ICD10", "A32.0", "A32.0 Cutaneous listeriosis", "fLYck5kxrXH"),
    ("ICD10", "A32.1", "A32.1 Listerial meningitis and meningoencephalitis", "NUSbqzo1ile"),
    ("ICD10", "A32.7", "A32.7 Listerial sepsis", "sR871I5nIMa"),
    ("ICD10", "A32.8", "A32.8 Other forms of listeriosis", "QYqu9dnJhsn"),
    ("ICD10", "A32.9", "A32.9 Listeriosis, unspecified", "pmGp6Lp73s6"),
    ("ICD10", "A33", "A33 Tetanus neonatorum", "y3OqR30h4YV"),
    ("ICD10", "A34", "A34 Obstetrical tetanus", "UUoYX7peFtB"),
    ("ICD10", "A35", "A35 Other tetanus", "z4A9p45NqFm"),
    ("ICD10", "A36", "A36 Diphtheria", "bdIUfpSnhMB"),
    ("ICD10", "A36.0", "A36.0 Pharyngeal diphtheria", "m1SoeOucDjY"),
    ("ICD10", "A36.1", "A36.1 Nasopharyngeal diphtheria", "UlYqD6EMFO6"),
    ("ICD10", "A36.2", "A36.2 Laryngeal diphtheria", "tgO9cVkMqiW"),
    ("ICD10", "A36.3", "A36.3 Cutaneous diphtheria", "ltXvJ5GFmQt"),
    ("ICD10", "A36.8", "A36.8 Other diphtheria", "GfOdscAsMDe"),
    ("ICD10", "A36.9", "A36.9 Diphtheria, unspecified", "gL6c639DNiQ"),
    ("ICD10", "A37", "A37 Whooping cough", "AeISfcIASAG"),
    ("ICD10", "A37.0", "A37.0 Whooping cough due to Bordetella pertussis", "hercrnZB1wE"),
    ("ICD10", "A37.1", "A37.1 Whooping cough due to Bordetella parapertussis", "vOpGyp9XlAT"),
    ("ICD10", "A37.8", "A37.8 Whooping cough due to other Bordetella species", "fwQC1KUnTZB"),
    ("ICD10", "A37.9", "A37.9 Whooping cough, unspecified", "gFljtRvbFRM"),
    ("ICD10", "A38", "A38 Scarlet fever", "fQ3m354BZyG"),
    ("ICD10", "A39", "A39 Meningococcal infection", "MFRaGZyBBxz"),
    ("ICD10", "A39.0", "A39.0 Meningococcal meningitis", "VCgAM3QolQq"),
    ("ICD10", "A39.1", "A39.1 Waterhouse-Friderichsen syndrome", "FgZOb8GqjeU"),
    ("ICD10", "A39.2", "A39.2 Acute meningococcaemia", "PCcEgyR0G8W"),
    ("ICD10", "A39.3", "A39.3 Chronic meningococcaemia", "gl64sIaYPuR"),
    ("ICD10", "A39.4", "A39.4 Meningococcaemia, unspecified", "GXJeMm3E4zu"),
    ("ICD10", "A39.5", "A39.5 Meningococcal heart disease", "BCKY2q5MDPA"),
    ("ICD10", "A39.8", "A39.8 Other meningococcal infections", "GnBQwdYJ3mA"),
    ("ICD10", "A39.9", "A39.9 Meningococcal infection, unspecified", "VfNb4GmQx7A"),
    ("ICD10", "A40", "A40 Streptococcal sepsis", "ZJIIpTn1PPn"),
    ("ICD10", "A40.0", "A40.0 Sepsis due to streptococcus, group A", "AWZKOh5rcoR"),
    ("ICD10", "A40.1", "A40.1 Sepsis due to streptococcus, group B", "HFEgvXz8WL1"),
    ("ICD10", "A40.2", "A40.2 Sepsis due to streptococcus, group D", "xTReca5fWwZ"),
    ("ICD10", "A40.3", "A40.3 Sepsis due to Streptococcus pneumoniae", "IKKCOKwNZfq"),
    ("ICD10", "A40.8", "A40.8 Other streptococcal sepsis", "vuBFr00scYc"),
    ("ICD10", "A40.9", "A40.9 Streptococcal sepsis, unspecified", "qPsOMpTnVAr"),
    ("ICD10", "A41", "A41 Other sepsis", "qoQ3MuXg4qM"),
    ("ICD10", "A41.0", "A41.0 Sepsis due to Staphylococcus aureus", "pVPeSa9atM7"),
    ("ICD10", "A41.1", "A41.1 Sepsis due to other specified staphylococcus", "opspqeo9x5I"),
    ("ICD10", "A41.2", "A41.2 Sepsis due to unspecified staphylococcus", "LJ14axV9geH"),
    ("ICD10", "A41.3", "A41.3 Sepsis due to Haemophilus influenzae", "zUDolaOi6v1"),
    ("ICD10", "A41.4", "A41.4 Sepsis due to anaerobes", "HcaMCVAYtEd"),
    ("ICD10", "A41.5", "A41.5 Sepsis due to other Gram-negative organisms", "ArYlNMEERuN"),
    ("ICD10", "A41.8", "A41.8 Other specified sepsis", "qGnHVmbNi22"),
    ("ICD10", "A41.9", "A41.9 Sepsis, unspecified", "RjtmKroiGMU"),
    ("ICD10", "A42", "A42 Actinomycosis", "yOxK7bQClCc"),
    ("ICD10", "A42.0", "A42.0 Pulmonary actinomycosis", "jPwUWJDO6uJ"),
    ("ICD10", "A42.1", "A42.1 Abdominal actinomycosis", "vp09COntyw3"),
    ("ICD10", "A42.2", "A42.2 Cervicofacial actinomycosis", "r6zNJOKDiUI"),
    ("ICD10", "A42.7", "A42.7 Actinomycotic sepsis", "O3mxxTtqBee"),
    ("ICD10", "A42.8", "A42.8 Other forms of actinomycosis", "RPcQ8pawSR4"),
    ("ICD10", "A42.9", "A42.9 Actinomycosis, unspecified", "S0uWGte9rlu"),
    ("ICD10", "A43", "A43 Nocardiosis", "nyYWs2Vj9EV"),
    ("ICD10", "A43.0", "A43.0 Pulmonary nocardiosis", "NsS7OMgIkb5"),
    ("ICD10", "A43.1", "A43.1 Cutaneous nocardiosis", "YGfKHg68QGX"),
    ("ICD10", "A43.8", "A43.8 Other forms of nocardiosis", "yPgvDuqRNks"),
    ("ICD10", "A43.9", "A43.9 Nocardiosis, unspecified", "O1Mcfk95M3g"),
    ("ICD10", "A44", "A44 Bartonellosis", "PPOCA4La69u"),
    ("ICD10", "A44.0", "A44.0 Systemic bartonellosis", "dqWUQmQA8p1"),
    ("ICD10", "A44.1", "A44.1 Cutaneous and mucocutaneous bartonellosis", "itXZYwRcPOc"),
    ("ICD10", "A44.8", "A44.8 Other forms of bartonellosis", "uRwOwYaLtZU"),
    ("ICD10", "A44.9", "A44.9 Bartonellosis, unspecified", "MgLlZT81uxF"),
    ("ICD10", "A46", "A46 Erysipelas", "ZTclhhYYLVh"),
    ("ICD10", "A48", "A48 Other bacterial diseases, not elsewhere classified", "kyeEtJp8Hh2"),
    ("ICD10", "A48.0", "A48.0 Gas gangrene", "kNfNjzQUL3z"),
    ("ICD10", "A48.1", "A48.1 Legionnaires disease", "TVuQ6p5aATe"),
    ("ICD10", "A48.2", "A48.2 Nonpneumonic Legionnaires disease [Pontiac fever]", "RJ7Wyu5ilsY"),
    ("ICD10", "A48.3", "A48.3 Toxic shock syndrome", "EKryOmmc2W1"),
    ("ICD10", "A48.4", "A48.4 Brazilian purpuric fever", "H43nlENOCS7"),
    ("ICD10", "A48.8", "A48.8 Other specified bacterial diseases", "exAbp5EIAbS"),
    ("ICD10", "A49", "A49 Bacterial infection of unspecified site", "sEWJtsn17Li"),
    ("ICD10", "A49.0", "A49.0 Staphylococcal infection, unspecified site", "G5gGIDN3tUc"),
    ("ICD10", "A49.1", "A49.1 Streptococcal and enterococcal infection, unspecified site", "lRhwuSrKZfa"),
    ("ICD10", "A49.2", "A49.2 Haemophilus influenzae infection, unspecified site", "kKLToIjQkFg"),
    ("ICD10", "A49.3", "A49.3 Mycoplasma infection, unspecified site", "Qv2QLe0DfPl"),
    ("ICD10", "A49.8", "A49.8 Other bacterial infections of unspecified site", "nA3uZ89Qt0F"),
    ("ICD10", "A49.9", "A49.9 Bacterial infection, unspecified", "or7N3qEP1qN"),
    ("ICD10", "A50", "A50 Congenital syphilis", "r9Ur632xokH"),
    ("ICD10", "A50.0", "A50.0 Early congenital syphilis, symptomatic", "OJdHXvDDiPG"),
    ("ICD10", "A50.1", "A50.1 Early congenital syphilis, latent", "dLC4YldVXrD"),
    ("ICD10", "A50.2", "A50.2 Early congenital syphilis, unspecified", "oBoTO26cvot"),
    ("ICD10", "A50.3", "A50.3 Late congenital syphilitic oculopathy", "Rj6GvbLC6ZB"),
    ("ICD10", "A50.4", "A50.4 Late congenital neurosyphilis [juvenile neurosyphilis]", "EbmpdaZPAOQ"),
    ("ICD10", "A50.5", "A50.5 Other late congenital syphilis, symptomatic", "nbW2JgBrWYV"),
    ("ICD10", "A50.6", "A50.6 Late congenital syphilis, latent", "eACF7BEm8bB"),
    ("ICD10", "A50.7", "A50.7 Late congenital syphilis, unspecified", "b1Ylym1fQPh"),
    ("ICD10", "A50.9", "A50.9 Congenital syphilis, unspecified", "BLMnh4yqm4v"),
    ("ICD10", "A51", "A51 Early syphilis", "hogJo2ULzbf"),
    ("ICD10", "A51.0", "A51.0 Primary genital syphilis", "duPGvuKxP4R"),
    ("ICD10", "A51.1", "A51.1 Primary anal syphilis", "vTKZYgBsZ42"),
    ("ICD10", "A51.2", "A51.2 Primary syphilis of other sites", "NW6gwZ6Jtge"),
    ("ICD10", "A51.3", "A51.3 Secondary syphilis of skin and mucous membranes", "c73wKeLu7wD"),
    ("ICD10", "A51.4", "A51.4 Other secondary syphilis", "WtUzSCPa3v2"),
    ("ICD10", "A51.5", "A51.5 Early syphilis, latent", "OAHG52Pzr4g"),
    ("ICD10", "A51.9", "A51.9 Early syphilis, unspecified", "ubQm3YAc1yr"),
    ("ICD10", "A52", "A52 Late syphilis", "RaTrAvIEWbz"),
    ("ICD10", "A52.0", "A52.0 Cardiovascular syphilis", "to7skb39esb"),
    ("ICD10", "A52.1", "A52.1 Symptomatic neurosyphilis", "WVpayqgIoTY"),
    ("ICD10", "A52.2", "A52.2 Asymptomatic neurosyphilis", "uJuSD39oLWS"),
    ("ICD10", "A52.3", "A52.3 Neurosyphilis, unspecified", "osc68aG8NUz"),
    ("ICD10", "A52.7", "A52.7 Other symptomatic late syphilis", "wNAk1EoINUS"),
    ("ICD10", "A52.8", "A52.8 Late syphilis, latent", "dpLSxe2MgI7"),
    ("ICD10", "A52.9", "A52.9 Late syphilis, unspecified", "g5aX8kjyRY4"),
    ("ICD10", "A53", "A53 Other and unspecified syphilis", "rlVhGv77BJq"),
    ("ICD10", "A53.0", "A53.0 Latent syphilis, unspecified as early or late", "LI7EVUsuw8R"),
    ("ICD10", "A53.9", "A53.9 Syphilis, unspecified", "OGyYmtRvezI"),
    ("ICD10", "A54", "A54 Gonococcal infection", "BQhX5BT3tz2"),
    ("ICD10", "A54.0", "A54.0 Gonococcal infection of lower genitourinary tract without periurethral or accessory gland abscess", "jpFrFk3Hv64"),
    ("ICD10", "A54.1", "A54.1 Gonococcal infection of lower genitourinary tract with periurethral and accessory gland abscess", "UtmsEPOPNic"),
    ("ICD10", "A54.2", "A54.2 Gonococcal pelviperitonitis and other gonococcal genitourinary infections", "FjLJkKuhNDH"),
    ("ICD10", "A54.3", "A54.3 Gonococcal infection of eye", "wjBVCwCzn9c"),
    ("ICD10", "A54.4", "A54.4 Gonococcal infection of musculoskeletal system", "FcqL66iEkUg"),
    ("ICD10", "A54.5", "A54.5 Gonococcal pharyngitis", "vtJhCdFfT6Z"),
    ("ICD10", "A54.6", "A54.6 Gonococcal infection of anus and rectum", "smxA1Bs7FYF"),
    ("ICD10", "A54.8", "A54.8 Other gonococcal infections", "fAIuPT6ujBI"),
    ("ICD10", "A54.9", "A54.9 Gonococcal infection, unspecified", "cdybEBfCh0b"),
    ("ICD10", "A55", "A55 Chlamydial lymphogranuloma (venereum)", "AEsHiahpPXw"),
    ("ICD10", "A56", "A56 Other sexually transmitted chlamydial diseases", "nGVGKM4QHgl"),
    ("ICD10", "A56.0", "A56.0 Chlamydial infection of lower genitourinary tract", "N5GZNprByhf"),
    ("ICD10", "A56.1", "A56.1 Chlamydial infection of pelviperitoneum and other genitourinary organs", "c9la2rmymGP"),
    ("ICD10", "A56.2", "A56.2 Chlamydial infection of genitourinary tract, unspecified", "UXQPY7fXnuk"),
    ("ICD10", "A56.3", "A56.3 Chlamydial infection of anus and rectum", "TscoZNaXIyk"),
    ("ICD10", "A56.4", "A56.4 Chlamydial infection of pharynx", "aNzFpOyo6WY"),
    ("ICD10", "A56.8", "A56.8 Sexually transmitted chlamydial infection of other sites", "Ur4tIJsUYpW"),
    ("ICD10", "A57", "A57 Chancroid", "YDGoSeaobeT"),
    ("ICD10", "A58", "A58 Granuloma inguinale", "esbXwd2CKZn"),
    ("ICD10", "A59", "A59 Trichomoniasis", "f8yBiKUHEE8"),
    ("ICD10", "A59.0", "A59.0 Urogenital trichomoniasis", "t08z9xuMh7d"),
    ("ICD10", "A59.8", "A59.8 Trichomoniasis of other sites", "nxn0S1L5MX2"),
    ("ICD10", "A59.9", "A59.9 Trichomoniasis, unspecified", "SexXyqzacGj"),
    ("ICD10", "A60", "A60 Anogenital herpesviral [herpes simplex] infection", "c0X1cmnpzG8"),
    ("ICD10", "A60.0", "A60.0 Herpesviral infection of genitalia and urogenital tract", "OqPxpL0zWpf"),
    ("ICD10", "A60.1", "A60.1 Herpesviral infection of perianal skin and rectum", "A25HB7bSz3K"),
    ("ICD10", "A60.9", "A60.9 Anogenital herpesviral infection, unspecified", "pQwc8mZy9of"),
    ("ICD10", "A63", "A63 Other predominantly sexually transmitted diseases, not elsewhere classified", "sgDWGyOsVid"),
    ("ICD10", "A63.0", "A63.0 Anogenital (venereal) warts", "TPYBMVlRaBL"),
    ("ICD10", "A63.8", "A63.8 Other specified predominantly sexually transmitted diseases", "meDMVHTriEd"),
    ("ICD10", "A64", "A64 Unspecified sexually transmitted disease", "NOuXZZTtOkc"),
    ("ICD10", "A65", "A65 Nonvenereal syphilis", "nFkJjaX8AK8"),
    ("ICD10", "A66", "A66 Yaws", "ThVI5OQ0SZK"),
    ("ICD10", "A66.0", "A66.0 Initial lesions of yaws", "t3h2Xt6WC6K"),
    ("ICD10", "A66.1", "A66.1 Multiple papillomata and wet crab yaws", "bbdZfVVqTUk"),
    ("ICD10", "A66.2", "A66.2 Other early skin lesions of yaws", "JZV1ECZw9er"),
    ("ICD10", "A66.3", "A66.3 Hyperkeratosis of yaws", "I5PNBtxGH6B"),
    ("ICD10", "A66.4", "A66.4 Gummata and ulcers of yaws", "klZGLPfVqD1"),
    ("ICD10", "A66.5", "A66.5 Gangosa", "vbL1e8hjg2x"),
    ("ICD10", "A66.6", "A66.6 Bone and joint lesions of yaws", "Va6Ydo7nlA2"),
    ("ICD10", "A66.7", "A66.7 Other manifestations of yaws", "TokBfZlAM6z"),
    ("ICD10", "A66.8", "A66.8 Latent yaws", "HaawHo8RLax"),
    ("ICD10", "A66.9", "A66.9 Yaws, unspecified", "wcufsMpLtDs"),
    ("ICD10", "A67", "A67 Pinta [carate]", "wQpV6A45GEk"),
    ("ICD10", "A67.0", "A67.0 Primary lesions of pinta", "BoGDdnymhQg"),
    ("ICD10", "A67.1", "A67.1 Intermediate lesions of pinta", "LnkZHtTyfDk"),
    ("ICD10", "A67.2", "A67.2 Late lesions of pinta", "WWMn1Oo8ftz"),
    ("ICD10", "A67.3", "A67.3 Mixed lesions of pinta", "EBGLo8HrtzL"),
    ("ICD10", "A67.9", "A67.9 Pinta, unspecified", "QcITMH05e49"),
    ("ICD10", "A68", "A68 Relapsing fevers", "sl5KOycajDw"),
    ("ICD10", "A68.0", "A68.0 Louse-borne relapsing fever", "RBdNvls95U3"),
    ("ICD10", "A68.1", "A68.1 Tick-borne relapsing fever", "mmpQmDnIIQY"),
    ("ICD10", "A68.9", "A68.9 Relapsing fever, unspecified", "Nr2pyGlh0Rl"),
    ("ICD10", "A69", "A69 Other spirochaetal infections", "YmF4ECt8cBK"),
    ("ICD10", "A69.0", "A69.0 Necrotizing ulcerative stomatitis", "iTutSgSkdMm"),
    ("ICD10", "A69.1", "A69.1 Other Vincent infections", "daREj1i8IrD"),
    ("ICD10", "A69.2", "A69.2 Lyme disease", "jMLfERR6xgC"),
    ("ICD10", "A69.8", "A69.8 Other specified spirochaetal infections", "MV70vpE9M2u"),
    ("ICD10", "A69.9", "A69.9 Spirochaetal infection, unspecified", "uxofThs1pCl"),
    ("ICD10", "A70", "A70 Chlamydia psittaci infection", "C3MH4TEHWl9"),
    ("ICD10", "A71", "A71 Trachoma", "Tml0CiXP3ee"),
    ("ICD10", "A71.0", "A71.0 Initial stage of trachoma", "DvegFlwkGGQ"),
    ("ICD10", "A71.1", "A71.1 Active stage of trachoma", "E8zap0VItL8"),
    ("ICD10", "A71.9", "A71.9 Trachoma, unspecified", "OUt9K4VKBic"),
    ("ICD10", "A74", "A74 Other diseases caused by chlamydiae", "ZifEN4BkkX5"),
    ("ICD10", "A74.0", "A74.0 Chlamydial conjunctivitis", "rpmQLLeTbwp"),
    ("ICD10", "A74.8", "A74.8 Other chlamydial diseases", "PcSugoqK4uM"),
    ("ICD10", "A74.9", "A74.9 Chlamydial infection, unspecified", "LY5fAE6YfkT"),
    ("ICD10", "A75", "A75 Typhus fever", "ZgiFUIHDodc"),
    ("ICD10", "A75.0", "A75.0 Epidemic louse-borne typhus fever due to Rickettsia prowazekii", "R847qpy7QL2"),
    ("ICD10", "A75.1", "A75.1 Recrudescent typhus [Brill disease]", "uNe8d4jxWNt"),
    ("ICD10", "A75.2", "A75.2 Typhus fever due to Rickettsia typhi", "QTLEzf2D6Bq"),
    ("ICD10", "A75.3", "A75.3 Typhus fever due to Rickettsia tsutsugamushi", "iCBizcaC2JR"),
    ("ICD10", "A75.9", "A75.9 Typhus fever, unspecified", "lkBziHjRued"),
    ("ICD10", "A77", "A77 Spotted fever [tick-borne rickettsioses]", "fUEMnsUPOkc"),
    ("ICD10", "A77.0", "A77.0 Spotted fever due to Rickettsia rickettsii", "D6HPGPpHe1T"),
    ("ICD10", "A77.1", "A77.1 Spotted fever due to Rickettsia conorii", "irRzGksO1ur"),
    ("ICD10", "A77.2", "A77.2 Spotted fever due to Rickettsia sibirica", "MCRuJwnHn4J"),
    ("ICD10", "A77.3", "A77.3 Spotted fever due to Rickettsia australis", "RVoGCWIfIEn"),
    ("ICD10", "A77.8", "A77.8 Other spotted fevers", "HAE8HgA29og"),
    ("ICD10", "A77.9", "A77.9 Spotted fever, unspecified", "nuIeO45yEa9"),
    ("ICD10", "A78", "A78 Q fever", "Sy3uSoJjE8P"),
    ("ICD10", "A79", "A79 Other rickettsioses", "D7OSN7JRYri"),
    ("ICD10", "A79.0", "A79.0 Trench fever", "DKVI2UhStpI"),
    ("ICD10", "A79.1", "A79.1 Rickettsialpox due to Rickettsia akari", "z83e1rgNR80"),
    ("ICD10", "A79.8", "A79.8 Other specified rickettsioses", "uHqY8EdxnSI"),
    ("ICD10", "A79.9", "A79.9 Rickettsiosis, unspecified", "kKATkFdkQMG"),
    ("ICD10", "A80", "A80 Acute poliomyelitis", "AlKBdz84hUS"),
    ("ICD10", "A80.0", "A80.0 Acute paralytic poliomyelitis, vaccine-associated", "IOyltdRdq9L"),
    ("ICD10", "A80.1", "A80.1 Acute paralytic poliomyelitis, wild virus, imported", "Ns6bAPhJwUV"),
    ("ICD10", "A80.2", "A80.2 Acute paralytic poliomyelitis, wild virus, indigenous", "D43oCGgXLbG"),
    ("ICD10", "A80.3", "A80.3 Acute paralytic poliomyelitis, other and unspecified", "DDyrhOkdAnj"),
    ("ICD10", "A80.4", "A80.4 Acute nonparalytic poliomyelitis", "Lrl9GFG1nua"),
    ("ICD10", "A80.9", "A80.9 Acute poliomyelitis, unspecified", "unkeG96hU7w"),
    ("ICD10", "A81", "A81 Atypical virus infections of central nervous system", "cBW0Hv5qjTv"),
    ("ICD10", "A81.0", "A81.0 Creutzfeldt-Jakob disease", "cdEXyEZvwa6"),
    ("ICD10", "A81.1", "A81.1 Subacute sclerosing panencephalitis", "qLMQKgSdDdZ"),
    ("ICD10", "A81.2", "A81.2 Progressive multifocal leukoencephalopathy", "EszlXCSeUxQ"),
    ("ICD10", "A81.8", "A81.8 Other atypical virus infections of central nervous system", "gKdfwc7mtip"),
    ("ICD10", "A81.9", "A81.9 Atypical virus infection of central nervous system, unspecified", "e3ISFEea9KV"),
    ("ICD10", "A82", "A82 Rabies", "wkGOSZgBFQv"),
    ("ICD10", "A82.0", "A82.0 Sylvatic rabies", "C5pBB3cmvIw"),
    ("ICD10", "A82.1", "A82.1 Urban rabies", "y4PmzNtleJg"),
    ("ICD10", "A82.9", "A82.9 Rabies, unspecified", "QcV9hrxfZH4"),
    ("ICD10", "A83", "A83 Mosquito-borne viral encephalitis", "hXI7C3df2W8"),
    ("ICD10", "A83.0", "A83.0 Japanese encephalitis", "zYeRfwOkAdX"),
    ("ICD10", "A83.1", "A83.1 Western equine encephalitis", "HJafWSdzZWM"),
    ("ICD10", "A83.2", "A83.2 Eastern equine encephalitis", "GJWNGuLWIsA"),
    ("ICD10", "A83.3", "A83.3 St Louis encephalitis", "U2NERamNff0"),
    ("ICD10", "A83.4", "A83.4 Australian encephalitis", "suDKYPPnoMK"),
    ("ICD10", "A83.5", "A83.5 California encephalitis", "kTRWlkD7XiA"),
    ("ICD10", "A83.6", "A83.6 Rocio virus disease", "fhzCVuGotcS"),
    ("ICD10", "A83.8", "A83.8 Other mosquito-borne viral encephalitis", "qxkUxCwXJhX"),
    ("ICD10", "A83.9", "A83.9 Mosquito-borne viral encephalitis, unspecified", "CPSZ5PPCxdj"),
    ("ICD10", "A84", "A84 Tick-borne viral encephalitis", "AHxFnaBSp3D"),
    ("ICD10", "A84.0", "A84.0 Far Eastern tick-borne encephalitis [Russian spring-summer encephalitis]", "UngisD0WP0j"),
    ("ICD10", "A84.1", "A84.1 Central European tick-borne encephalitis", "UBiN1wqWMAo"),
    ("ICD10", "A84.8", "A84.8 Other tick-borne viral encephalitis", "pN3pggOrsn0"),
    ("ICD10", "A84.9", "A84.9 Tick-borne viral encephalitis, unspecified", "Y5USsxubPMf"),
    ("ICD10", "A85", "A85 Other viral encephalitis, not elsewhere classified", "Pza3LSwK3T0"),
    ("ICD10", "A85.0", "A85.0 Enteroviral encephalitis", "gI5o0jGHj2F"),
    ("ICD10", "A85.1", "A85.1 Adenoviral encephalitis", "iwJcO3FBh6c"),
    ("ICD10", "A85.2", "A85.2 Arthropod-borne viral encephalitis, unspecified", "BBKJwPBjqd5"),
    ("ICD10", "A85.8", "A85.8 Other specified viral encephalitis", "NyCcjAbqzKT"),
    ("ICD10", "A86", "A86 Unspecified viral encephalitis", "Y7NcuAKKqo7"),
    ("ICD10", "A87", "A87 Viral meningitis", "EkyfBPCW06H"),
    ("ICD10", "A87.0", "A87.0 Enteroviral meningitis", "UbTKLc18ch2"),
    ("ICD10", "A87.1", "A87.1 Adenoviral meningitis", "jOL0ghMRSMs"),
    ("ICD10", "A87.2", "A87.2 Lymphocytic choriomeningitis", "wklOQS4yi5y"),
    ("ICD10", "A87.8", "A87.8 Other viral meningitis", "VOnjcl55ytC"),
    ("ICD10", "A87.9", "A87.9 Viral meningitis, unspecified", "K0SS4vBSSYv"),
    ("ICD10", "A88", "A88 Other viral infections of central nervous system, not elsewhere classified", "CK80TXXzeh3"),
    ("ICD10", "A88.0", "A88.0 Enteroviral exanthematous fever [Boston exanthem]", "qbmIbRq1IAf"),
    ("ICD10", "A88.1", "A88.1 Epidemic vertigo", "fhnHDBZrdLl"),
    ("ICD10", "A88.8", "A88.8 Other specified viral infections of central nervous system", "IaTJKIQSDXx"),
    ("ICD10", "A89", "A89 Unspecified viral infection of central nervous system", "GdNT1GeU3To"),
    ("ICD10", "A92", "A92 Other mosquito-borne viral fevers", "lixsEanWSEg"),
    ("ICD10", "A92.0", "A92.0 Chikungunya virus disease", "I3iHM7PjRD9"),
    ("ICD10", "A92.1", "A92.1 O'nyong-nyong fever", "Jb6VjJMVvkM"),
    ("ICD10", "A92.2", "A92.2 Venezuelan equine fever", "Wo2QGgeD2Nj"),
    ("ICD10", "A92.3", "A92.3 West Nile virus infection", "LmrbORY2VDp"),
    ("ICD10", "A92.4", "A92.4 Rift Valley fever", "bhKfS2b61qk"),
    ("ICD10", "A92.8", "A92.8 Other specified mosquito-borne viral fevers", "OuxhOexzbFN"),
    ("ICD10", "A92.9", "A92.9 Mosquito-borne viral fever, unspecified", "gmXhzJIu2zA"),
    ("ICD10", "A93", "A93 Other arthropod-borne viral fevers, not elsewhere classified", "zvumWHjsELK"),
    ("ICD10", "A93.0", "A93.0 Oropouche virus disease", "D4TEuZuAxWf"),
    ("ICD10", "A93.1", "A93.1 Sandfly fever", "M1voIBiqIF2"),
    ("ICD10", "A93.2", "A93.2 Colorado tick fever", "VMpNvozY8mF"),
    ("ICD10", "A93.8", "A93.8 Other specified arthropod-borne viral fevers", "PExNyL7hOFT"),
    ("ICD10", "A94", "A94 Unspecified arthropod-borne viral fever", "oWWmG5pMAch"),
    ("ICD10", "A95", "A95 Yellow fever", "Ed8NQzd6j0Z"),
    ("ICD10", "A95.0", "A95.0 Sylvatic yellow fever", "JeIKHGQi9gb"),
    ("ICD10", "A95.1", "A95.1 Urban yellow fever", "lt9VL06vQtt"),
    ("ICD10", "A95.9", "A95.9 Yellow fever, unspecified", "G7i33CPBfJF"),
    ("ICD10", "A96", "A96 Arenaviral haemorrhagic fever", "KetmFzn5uyq"),
    ("ICD10", "A96.0", "A96.0 Junin haemorrhagic fever", "rVEKRysHxvq"),
    ("ICD10", "A96.1", "A96.1 Machupo haemorrhagic fever", "U9hxxGs9o1A"),
    ("ICD10", "A96.2", "A96.2 Lassa fever", "mRenG20QYRv"),
    ("ICD10", "A96.8", "A96.8 Other arenaviral haemorrhagic fevers", "CKWUJhXwi2K"),
    ("ICD10", "A96.9", "A96.9 Arenaviral haemorrhagic fever, unspecified", "YAKC1hOUj4D"),
    ("ICD10", "A97", "A97 Dengue", "u701nZydE6H"),
    ("ICD10", "A97.0", "A97.0 Dengue without warning signs", "TnVdg1UYV3K"),
    ("ICD10", "A97.1", "A97.1 Dengue with warning signs", "qrS8fMvLoqJ"),
    ("ICD10", "A97.2", "A97.2 Severe Dengue", "B3FmmM1EqBR"),
    ("ICD10", "A97.9", "A97.9 Dengue, unspecified", "ZJaTMUj7AVS"),
    ("ICD10", "A98", "A98 Other viral haemorrhagic fevers, not elsewhere classified", "xCShQIW39p8"),
    ("ICD10", "A98.0", "A98.0 Crimean-Congo haemorrhagic fever", "cEuP2YGBHTq"),
    ("ICD10", "A98.1", "A98.1 Omsk haemorrhagic fever", "jX3mMaVncf6"),
    ("ICD10", "A98.2", "A98.2 Kyasanur Forest disease", "vbojH7fWaFd"),
    ("ICD10", "A98.3", "A98.3 Marburg virus disease", "OeXNmuMBQYo"),
    ("ICD10", "A98.4", "A98.4 Ebola virus disease", "EaKWEXLOLEo"),
    ("ICD10", "A98.5", "A98.5 Haemorrhagic fever with renal syndrome", "dnk5ooQV2VS"),
    ("ICD10", "A98.8", "A98.8 Other specified viral haemorrhagic fevers", "R3JUEj1OVe3"),
    ("ICD10", "A99", "A99 Unspecified viral haemorrhagic fever", "bqEe7fgxlMs");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "B00", "B00 Herpesviral [herpes simplex] infections", "WoWqMjEwdij"),
    ("ICD10", "B00.0", "B00.0 Eczema herpeticum", "CBbMVWTwt7L"),
    ("ICD10", "B00.1", "B00.1 Herpesviral vesicular dermatitis", "Yj4vPpPWNv2"),
    ("ICD10", "B00.2", "B00.2 Herpesviral gingivostomatitis and pharyngotonsillitis", "VszfK3XOjXl"),
    ("ICD10", "B00.3", "B00.3 Herpesviral meningitis", "xhnq1L4JITX"),
    ("ICD10", "B00.4", "B00.4 Herpesviral encephalitis", "iDlayxcczkT"),
    ("ICD10", "B00.5", "B00.5 Herpesviral ocular disease", "cI3kzOW5zF6"),
    ("ICD10", "B00.7", "B00.7 Disseminated herpesviral disease", "pJygcOGF1cj"),
    ("ICD10", "B00.8", "B00.8 Other forms of herpesviral infection", "z26dZxWLnXU"),
    ("ICD10", "B00.9", "B00.9 Herpesviral infection, unspecified", "VeHBAqpI5uq"),
    ("ICD10", "B01", "B01 Varicella [chickenpox]", "XEoFvmoAEvp"),
    ("ICD10", "B01.0", "B01.0 Varicella meningitis", "SnbmusocINO"),
    ("ICD10", "B01.1", "B01.1 Varicella encephalitis", "YKiqRrSxReh"),
    ("ICD10", "B01.2", "B01.2 Varicella pneumonia", "RiUpn1AOkTe"),
    ("ICD10", "B01.8", "B01.8 Varicella with other complications", "tzWYhwlFErE"),
    ("ICD10", "B01.9", "B01.9 Varicella without complication", "NYgpeisSASb"),
    ("ICD10", "B02", "B02 Zoster [herpes zoster]", "elKFaj0eIBK"),
    ("ICD10", "B02.0", "B02.0 Zoster encephalitis", "CVCIIyQUbPq"),
    ("ICD10", "B02.1", "B02.1 Zoster meningitis", "o74JFRCygdQ"),
    ("ICD10", "B02.2", "B02.2 Zoster with other nervous system involvement", "YgwWN4tyBtC"),
    ("ICD10", "B02.3", "B02.3 Zoster ocular disease", "omk7dDPJ77y"),
    ("ICD10", "B02.7", "B02.7 Disseminated zoster", "cjVaZv6NAUx"),
    ("ICD10", "B02.8", "B02.8 Zoster with other complications", "pHKjS0gNv1V"),
    ("ICD10", "B02.9", "B02.9 Zoster without complication", "W61V9WLVaM9"),
    ("ICD10", "B03", "B03 Smallpox", "ib1fB8NUtOg"),
    ("ICD10", "B04", "B04 Monkeypox", "gNWdzP9egkL"),
    ("ICD10", "B05", "B05 Measles", "ra1WE5Y79M6"),
    ("ICD10", "B05.0", "B05.0 Measles complicated by encephalitis", "ly9KTG2ct1S"),
    ("ICD10", "B05.1", "B05.1 Measles complicated by meningitis", "ZuQwNsba9Hg"),
    ("ICD10", "B05.2", "B05.2 Measles complicated by pneumonia", "SymT0D3KigG"),
    ("ICD10", "B05.3", "B05.3 Measles complicated by otitis media", "s8HKXCvhJQd"),
    ("ICD10", "B05.4", "B05.4 Measles with intestinal complications", "HH91pNoYGVn"),
    ("ICD10", "B05.8", "B05.8 Measles with other complications", "D6wH3YrCDGC"),
    ("ICD10", "B05.9", "B05.9 Measles without complication", "Jesqllzbcrv"),
    ("ICD10", "B06", "B06 Rubella [German measles]", "yu0QjdcsEDj"),
    ("ICD10", "B06.0", "B06.0 Rubella with neurological complications", "dCLYHSGeEXQ"),
    ("ICD10", "B06.8", "B06.8 Rubella with other complications", "maz9tt1GJym"),
    ("ICD10", "B06.9", "B06.9 Rubella without complication", "MjCnllQQRfF"),
    ("ICD10", "B07", "B07 Viral warts", "K4aAp7fcPPs"),
    ("ICD10", "B08", "B08 Other viral infections characterized by skin and mucous membrane lesions, not elsewhere classified", "dTr4VMoXl8q"),
    ("ICD10", "B08.0", "B08.0 Other orthopoxvirus infections", "f93ngNxuSZV"),
    ("ICD10", "B08.1", "B08.1 Molluscum contagiosum", "qy0h0ZNPja5"),
    ("ICD10", "B08.2", "B08.2 Exanthema subitum [sixth disease]", "wXRJt8vFsgL"),
    ("ICD10", "B08.3", "B08.3 Erythema infectiosum [fifth disease]", "ovuJ4DJDFGc"),
    ("ICD10", "B08.4", "B08.4 Enteroviral vesicular stomatitis with exanthem", "ABsiknb52R9"),
    ("ICD10", "B08.5", "B08.5 Enteroviral vesicular pharyngitis", "wY5u7Vy6uMX"),
    ("ICD10", "B08.8", "B08.8 Other specified viral infections characterized by skin and mucous membrane lesions", "PAenUtNHs03"),
    ("ICD10", "B09", "B09 Unspecified viral infection characterized by skin and mucous membrane lesions", "k3aKZuA253s"),
    ("ICD10", "B15", "B15 Acute hepatitis A", "etqJuMRkZYI"),
    ("ICD10", "B15.0", "B15.0 Hepatitis A with hepatic coma", "ZtXiO5m6kTp"),
    ("ICD10", "B15.9", "B15.9 Hepatitis A without hepatic coma", "vqQRHVizZLP"),
    ("ICD10", "B16", "B16 Acute hepatitis B", "ukaGKCgDchL"),
    ("ICD10", "B16.0", "B16.0 Acute hepatitis B with delta-agent (coinfection) with hepatic coma", "SmET69yNJOH"),
    ("ICD10", "B16.1", "B16.1 Acute hepatitis B with delta-agent (coinfection) without hepatic coma", "m2tWgFzJrWR"),
    ("ICD10", "B16.2", "B16.2 Acute hepatitis B without delta-agent with hepatic coma", "oDxCENqb509"),
    ("ICD10", "B16.9", "B16.9 Acute hepatitis B without delta-agent and without hepatic coma", "CK7pjQUMIhC"),
    ("ICD10", "B17", "B17 Other acute viral hepatitis", "mTqQNbBZcGi"),
    ("ICD10", "B17.0", "B17.0 Acute delta-(super)infection of hepatitis B carrier", "XqS4zEY0we2"),
    ("ICD10", "B17.1", "B17.1 Acute hepatitis C", "mx4IbW1jgYh"),
    ("ICD10", "B17.2", "B17.2 Acute hepatitis E", "vMOX3B9SKL5"),
    ("ICD10", "B17.8", "B17.8 Other specified acute viral hepatitis", "FarYvUKzdaX"),
    ("ICD10", "B17.9", "B17.9 Acute viral hepatitis, unspecified", "qMVDAonZpwm"),
    ("ICD10", "B18", "B18 Chronic viral hepatitis", "kfbh4uGoEcz"),
    ("ICD10", "B18.0", "B18.0 Chronic viral hepatitis B with delta-agent", "VMVtonjEfDB"),
    ("ICD10", "B18.1", "B18.1 Chronic viral hepatitis B without delta-agent", "sEQTGF7HSKH"),
    ("ICD10", "B18.2", "B18.2 Chronic viral hepatitis C", "AjfRsktrbSG"),
    ("ICD10", "B18.8", "B18.8 Other chronic viral hepatitis", "zf1idhcTZTG"),
    ("ICD10", "B18.9", "B18.9 Chronic viral hepatitis, unspecified", "LoDyyGoupX1"),
    ("ICD10", "B19", "B19 Unspecified viral hepatitis", "nYlVPNjIupf"),
    ("ICD10", "B19.0", "B19.0 Unspecified viral hepatitis with hepatic coma", "alg573etdzT"),
    ("ICD10", "B19.9", "B19.9 Unspecified viral hepatitis without hepatic coma", "ek7JyJNWQd4"),
    ("ICD10", "B20", "B20 Human immunodeficiency virus [HIV] disease resulting in infectious and parasitic diseases", "Bilz9r76MEu"),
    ("ICD10", "B20.0", "B20.0 HIV disease resulting in mycobacterial infection", "cp5DbdkSe3i"),
    ("ICD10", "B20.1", "B20.1 HIV disease resulting in other bacterial infections", "fYYrxYq3ZLZ"),
    ("ICD10", "B20.2", "B20.2 HIV disease resulting in cytomegaloviral disease", "C9hy9w4QCBr"),
    ("ICD10", "B20.3", "B20.3 HIV disease resulting in other viral infections", "F1wlqSepUFx"),
    ("ICD10", "B20.4", "B20.4 HIV disease resulting in candidiasis", "FuDb67W7ntT"),
    ("ICD10", "B20.5", "B20.5 HIV disease resulting in other mycoses", "lTZcHTdBZLG"),
    ("ICD10", "B20.6", "B20.6 HIV disease resulting in Pneumocystis jirovecii pneumonia", "U23IVU4fAKb"),
    ("ICD10", "B20.7", "B20.7 HIV disease resulting in multiple infections", "RK55LONK0oS"),
    ("ICD10", "B20.8", "B20.8 HIV disease resulting in other infectious and parasitic diseases", "mXXYsv2nOe5"),
    ("ICD10", "B20.9", "B20.9 HIV disease resulting in unspecified infectious or parasitic disease", "uWa1kq5JmRe"),
    ("ICD10", "B21", "B21 Human immunodeficiency virus [HIV] disease resulting in malignant neoplasms", "t9iUiBxoYlx"),
    ("ICD10", "B21.0", "B21.0 HIV disease resulting in Kaposi sarcoma", "oEdHs8HAJz7"),
    ("ICD10", "B21.1", "B21.1 HIV disease resulting in Burkitt lymphoma", "kv2cNN5rxGS"),
    ("ICD10", "B21.2", "B21.2 HIV disease resulting in other types of non-Hodgkin lymphoma", "bIqwKJwiaWu"),
    ("ICD10", "B21.3", "B21.3 HIV disease resulting in other malignant neoplasms of lymphoid, haematopoietic and related tissue", "jcvqGmBtnCl"),
    ("ICD10", "B21.7", "B21.7 HIV disease resulting in multiple malignant neoplasms", "lQnGKa1q2R1"),
    ("ICD10", "B21.8", "B21.8 HIV disease resulting in other malignant neoplasms", "eOrXpirNsjj"),
    ("ICD10", "B21.9", "B21.9 HIV disease resulting in unspecified malignant neoplasm", "b7NmtdBJGI2"),
    ("ICD10", "B22", "B22 Human immunodeficiency virus [HIV] disease resulting in other specified diseases", "aXcMXfVze4T"),
    ("ICD10", "B22.0", "B22.0 HIV disease resulting in encephalopathy", "GENYNfhCvYK"),
    ("ICD10", "B22.1", "B22.1 HIV disease resulting in lymphoid interstitial pneumonitis", "K1BY4N2GEkK"),
    ("ICD10", "B22.2", "B22.2 HIV disease resulting in wasting syndrome", "y4SUCRnGtpZ"),
    ("ICD10", "B22.7", "B22.7 HIV disease resulting in multiple diseases classified elsewhere", "U7xUaQ5cu6d"),
    ("ICD10", "B23", "B23 Human immunodeficiency virus [HIV] disease resulting in other conditions", "YDP4X8pS67U"),
    ("ICD10", "B23.0", "B23.0 Acute HIV infection syndrome", "mZ6ZaWYeMLZ"),
    ("ICD10", "B23.1", "B23.1 HIV disease resulting in (persistent) generalized lymphadenopathy", "KUh5kG7OmSf"),
    ("ICD10", "B23.2", "B23.2 HIV disease resulting in haematological and immunological abnormalities, not elsewhere classified", "G9hYuiTOzzc"),
    ("ICD10", "B23.8", "B23.8 HIV disease resulting in other specified conditions", "uZLDw0Npg6V"),
    ("ICD10", "B24", "B24 Unspecified human immunodeficiency virus [HIV] disease", "zzWGBh94ruO"),
    ("ICD10", "B25", "B25 Cytomegaloviral disease", "GTeFPM1U8e8"),
    ("ICD10", "B25.0", "B25.0 Cytomegaloviral pneumonitis", "FVSHqhTLCZf"),
    ("ICD10", "B25.1", "B25.1 Cytomegaloviral hepatitis", "HTQNDB5c9nF"),
    ("ICD10", "B25.2", "B25.2 Cytomegaloviral pancreatitis", "L7R4efQZILK"),
    ("ICD10", "B25.8", "B25.8 Other cytomegaloviral diseases", "Uxz5180xg1I"),
    ("ICD10", "B25.9", "B25.9 Cytomegaloviral disease, unspecified", "lb7KK7NSlVW"),
    ("ICD10", "B26", "B26 Mumps", "CgyeAIXuaH3"),
    ("ICD10", "B26.0", "B26.0 Mumps orchitis", "GLbyin8GGBS"),
    ("ICD10", "B26.1", "B26.1 Mumps meningitis", "rAaxDKbsQaE"),
    ("ICD10", "B26.2", "B26.2 Mumps encephalitis", "pusRylAg8dA"),
    ("ICD10", "B26.3", "B26.3 Mumps pancreatitis", "OpTi1EnO3n2"),
    ("ICD10", "B26.8", "B26.8 Mumps with other complications", "DVYVMBODx1l"),
    ("ICD10", "B26.9", "B26.9 Mumps without complication", "sDXfTyXhnYD"),
    ("ICD10", "B27", "B27 Infectious mononucleosis", "aDW6eOxuZNH"),
    ("ICD10", "B27.0", "B27.0 Gammaherpesviral mononucleosis", "t5XwLqX9G4b"),
    ("ICD10", "B27.1", "B27.1 Cytomegaloviral mononucleosis", "mhAiVcXMi36"),
    ("ICD10", "B27.8", "B27.8 Other infectious mononucleosis", "lEzI4YnpKtV"),
    ("ICD10", "B27.9", "B27.9 Infectious mononucleosis, unspecified", "uMLGnilx4ck"),
    ("ICD10", "B30", "B30 Viral conjunctivitis", "WksCyX3GT9k"),
    ("ICD10", "B30.0", "B30.0 Keratoconjunctivitis due to adenovirus", "YsMsl0Kuefy"),
    ("ICD10", "B30.1", "B30.1 Conjunctivitis due to adenovirus", "yl5WWQLGVSM"),
    ("ICD10", "B30.2", "B30.2 Viral pharyngoconjunctivitis", "IcgIb1z8XDl"),
    ("ICD10", "B30.3", "B30.3 Acute epidemic haemorrhagic conjunctivitis (enteroviral)", "McOhTRlLbUK"),
    ("ICD10", "B30.8", "B30.8 Other viral conjunctivitis", "TCDvtIyaJ4u"),
    ("ICD10", "B30.9", "B30.9 Viral conjunctivitis, unspecified", "y5bqH09EQAr"),
    ("ICD10", "B33", "B33 Other viral diseases, not elsewhere classified", "uQSfOihlxA7"),
    ("ICD10", "B33.0", "B33.0 Epidemic myalgia", "h7LCQzUpoiG"),
    ("ICD10", "B33.1", "B33.1 Ross River disease", "q5XiH91ILzJ"),
    ("ICD10", "B33.2", "B33.2 Viral carditis", "xX4Ky78N57g"),
    ("ICD10", "B33.3", "B33.3 Retrovirus infections, not elsewhere classified", "l4c1Hy34mgS"),
    ("ICD10", "B33.4", "B33.4 Hantavirus (cardio-)pulmonary syndrome [HPS] [HCPS]", "tcIqYOiFXCq"),
    ("ICD10", "B33.8", "B33.8 Other specified viral diseases", "pTfFLgPJ3D9"),
    ("ICD10", "B34", "B34 Viral infection of unspecified site", "LonRz3IZrwN"),
    ("ICD10", "B34.0", "B34.0 Adenovirus infection, unspecified site", "resB5CijmoU"),
    ("ICD10", "B34.1", "B34.1 Enterovirus infection, unspecified site", "iMQi6y78kvO"),
    ("ICD10", "B34.2", "B34.2 Coronavirus infection, unspecified site", "MWNQ9hMjD7y"),
    ("ICD10", "B34.3", "B34.3 Parvovirus infection, unspecified site", "SDInTHlaf3v"),
    ("ICD10", "B34.4", "B34.4 Papovavirus infection, unspecified site", "mdpr7CqD46e"),
    ("ICD10", "B34.8", "B34.8 Other viral infections of unspecified site", "m0KLQgLxUJX"),
    ("ICD10", "B34.9", "B34.9 Viral infection, unspecified", "VPOeo9VPzZQ"),
    ("ICD10", "B35", "B35 Dermatophytosis", "qctc8iFJ3oV"),
    ("ICD10", "B35.0", "B35.0 Tinea barbae and tinea capitis", "auZNn0KJWMs"),
    ("ICD10", "B35.1", "B35.1 Tinea unguium", "Qm6pZekE8a1"),
    ("ICD10", "B35.2", "B35.2 Tinea manuum", "n7t2YQfwOC7"),
    ("ICD10", "B35.3", "B35.3 Tinea pedis", "BjZ5O0FWE2h"),
    ("ICD10", "B35.4", "B35.4 Tinea corporis", "RFRKxb6iFBo"),
    ("ICD10", "B35.5", "B35.5 Tinea imbricata", "jzrnelgVr4v"),
    ("ICD10", "B35.6", "B35.6 Tinea inguinalis [Tinea cruris]", "uEWAgjxw4Wp"),
    ("ICD10", "B35.8", "B35.8 Other dermatophytoses", "yW1DuYxbl8e"),
    ("ICD10", "B35.9", "B35.9 Dermatophytosis, unspecified", "CW5gtJW5lg3"),
    ("ICD10", "B36", "B36 Other superficial mycoses", "pCDOdAEqERw"),
    ("ICD10", "B36.0", "B36.0 Pityriasis versicolor", "WvtHxeKPEjO"),
    ("ICD10", "B36.1", "B36.1 Tinea nigra", "SUio5e2hBih"),
    ("ICD10", "B36.2", "B36.2 White piedra", "wfN3Qj3dVL8"),
    ("ICD10", "B36.3", "B36.3 Black piedra", "FwqU2G1F2QC"),
    ("ICD10", "B36.8", "B36.8 Other specified superficial mycoses", "jHbKuoQGxqS"),
    ("ICD10", "B36.9", "B36.9 Superficial mycosis, unspecified", "wT2lnoGrUxK"),
    ("ICD10", "B37", "B37 Candidiasis", "zw5L2VxDtnq"),
    ("ICD10", "B37.0", "B37.0 Candidal stomatitis", "XUt9kOH6rsS"),
    ("ICD10", "B37.1", "B37.1 Pulmonary candidiasis", "YFKxtptJ8wE"),
    ("ICD10", "B37.2", "B37.2 Candidiasis of skin and nail", "rOM7eSMg2VM"),
    ("ICD10", "B37.3", "B37.3 Candidiasis of vulva and vagina", "mLVRY0AmK46"),
    ("ICD10", "B37.4", "B37.4 Candidiasis of other urogenital sites", "GTAPorzqukE"),
    ("ICD10", "B37.5", "B37.5 Candidal meningitis", "IZtCG01qtGh"),
    ("ICD10", "B37.6", "B37.6 Candidal endocarditis", "FsUn348BF4C"),
    ("ICD10", "B37.7", "B37.7 Candidal sepsis", "aR8IDrDmBaJ"),
    ("ICD10", "B37.8", "B37.8 Candidiasis of other sites", "SHzuJUxC3JS"),
    ("ICD10", "B37.9", "B37.9 Candidiasis, unspecified", "bWGs6CPAYxx"),
    ("ICD10", "B38", "B38 Coccidioidomycosis", "SUmi4VO5SSG"),
    ("ICD10", "B38.0", "B38.0 Acute pulmonary coccidioidomycosis", "ykagnvQgX1A"),
    ("ICD10", "B38.1", "B38.1 Chronic pulmonary coccidioidomycosis", "thd2UNpSXWM"),
    ("ICD10", "B38.2", "B38.2 Pulmonary coccidioidomycosis, unspecified", "aXOwXdF071Z"),
    ("ICD10", "B38.3", "B38.3 Cutaneous coccidioidomycosis", "T3aXlzXh0BS"),
    ("ICD10", "B38.4", "B38.4 Coccidioidomycosis meningitis", "k15dApSmbT7"),
    ("ICD10", "B38.7", "B38.7 Disseminated coccidioidomycosis", "lW9rOsAuxoo"),
    ("ICD10", "B38.8", "B38.8 Other forms of coccidioidomycosis", "VtH6NijwDsU"),
    ("ICD10", "B38.9", "B38.9 Coccidioidomycosis, unspecified", "hRl36BBNti4"),
    ("ICD10", "B39", "B39 Histoplasmosis", "lPKQCf4Uuk3"),
    ("ICD10", "B39.0", "B39.0 Acute pulmonary histoplasmosis capsulati", "lkKhZlmvKno"),
    ("ICD10", "B39.1", "B39.1 Chronic pulmonary histoplasmosis capsulati", "r6y9n3cB7wU"),
    ("ICD10", "B39.2", "B39.2 Pulmonary histoplasmosis capsulati, unspecified", "t7Lx68v5kUg"),
    ("ICD10", "B39.3", "B39.3 Disseminated histoplasmosis capsulati", "vKC5yBsDD6z"),
    ("ICD10", "B39.4", "B39.4 Histoplasmosis capsulati, unspecified", "XlendqrBuGm"),
    ("ICD10", "B39.5", "B39.5 Histoplasmosis duboisii", "k908qw1771w"),
    ("ICD10", "B39.9", "B39.9 Histoplasmosis, unspecified", "TRz9PcteILE"),
    ("ICD10", "B40", "B40 Blastomycosis", "WZCbkTPjEoe"),
    ("ICD10", "B40.0", "B40.0 Acute pulmonary blastomycosis", "CUyav43XHsx"),
    ("ICD10", "B40.1", "B40.1 Chronic pulmonary blastomycosis", "pjqWdaBzOi2"),
    ("ICD10", "B40.2", "B40.2 Pulmonary blastomycosis, unspecified", "rZVMQSBfxDk"),
    ("ICD10", "B40.3", "B40.3 Cutaneous blastomycosis", "JdqldPybkAW"),
    ("ICD10", "B40.7", "B40.7 Disseminated blastomycosis", "ZUq9TVIai4e"),
    ("ICD10", "B40.8", "B40.8 Other forms of blastomycosis", "PjuB7eLNDIz"),
    ("ICD10", "B40.9", "B40.9 Blastomycosis, unspecified", "vdjTEugYEhQ"),
    ("ICD10", "B41", "B41 Paracoccidioidomycosis", "cP0VHLXZ9A4"),
    ("ICD10", "B41.0", "B41.0 Pulmonary paracoccidioidomycosis", "BOZRFTxXR2Z"),
    ("ICD10", "B41.7", "B41.7 Disseminated paracoccidioidomycosis", "s2ABqQ9LNmw"),
    ("ICD10", "B41.8", "B41.8 Other forms of paracoccidioidomycosis", "es1UCAudFku"),
    ("ICD10", "B41.9", "B41.9 Paracoccidioidomycosis, unspecified", "ziPA1DPNfQO"),
    ("ICD10", "B42", "B42 Sporotrichosis", "oRBBhCeKUZn"),
    ("ICD10", "B42.0", "B42.0 Pulmonary sporotrichosis", "JIflsqntIPC"),
    ("ICD10", "B42.1", "B42.1 Lymphocutaneous sporotrichosis", "vkafddG1jl3"),
    ("ICD10", "B42.7", "B42.7 Disseminated sporotrichosis", "mAVMtpWmhlY"),
    ("ICD10", "B42.8", "B42.8 Other forms of sporotrichosis", "OEbLDUTxELj"),
    ("ICD10", "B42.9", "B42.9 Sporotrichosis, unspecified", "obLFPesB7KS"),
    ("ICD10", "B43", "B43 Chromomycosis and phaeomycotic abscess", "xn0cLUZ7IVA"),
    ("ICD10", "B43.0", "B43.0 Cutaneous chromomycosis", "E6HOcwfUXpf"),
    ("ICD10", "B43.1", "B43.1 Phaeomycotic brain abscess", "q58bizEEboP"),
    ("ICD10", "B43.2", "B43.2 Subcutaneous phaeomycotic abscess and cyst", "t5mg1ZLSOIS"),
    ("ICD10", "B43.8", "B43.8 Other forms of chromomycosis", "usYwYRVRJ8e"),
    ("ICD10", "B43.9", "B43.9 Chromomycosis, unspecified", "aJMB0pJHYEJ"),
    ("ICD10", "B44", "B44 Aspergillosis", "t98gTuYNoVJ"),
    ("ICD10", "B44.0", "B44.0 Invasive pulmonary aspergillosis", "OG5mKCULi5A"),
    ("ICD10", "B44.1", "B44.1 Other pulmonary aspergillosis", "UnVdwsF8yPA"),
    ("ICD10", "B44.2", "B44.2 Tonsillar aspergillosis", "S5FBR9f1hYX"),
    ("ICD10", "B44.7", "B44.7 Disseminated aspergillosis", "TRkF7rQKXd8"),
    ("ICD10", "B44.8", "B44.8 Other forms of aspergillosis", "RtvSgv1BNdo"),
    ("ICD10", "B44.9", "B44.9 Aspergillosis, unspecified", "y3ZDyY3e0eK"),
    ("ICD10", "B45", "B45 Cryptococcosis", "zWTVu2yDJdg"),
    ("ICD10", "B45.0", "B45.0 Pulmonary cryptococcosis", "HFqUlAhNKpU"),
    ("ICD10", "B45.1", "B45.1 Cerebral cryptococcosis", "HcY1lS32xk0"),
    ("ICD10", "B45.2", "B45.2 Cutaneous cryptococcosis", "pYeTwzhwjqg"),
    ("ICD10", "B45.3", "B45.3 Osseous cryptococcosis", "LH4JCCgxwfx"),
    ("ICD10", "B45.7", "B45.7 Disseminated cryptococcosis", "o7obPc44LPj"),
    ("ICD10", "B45.8", "B45.8 Other forms of cryptococcosis", "LX33VBc7jLf"),
    ("ICD10", "B45.9", "B45.9 Cryptococcosis, unspecified", "T8MiCtI1f3a"),
    ("ICD10", "B46", "B46 Zygomycosis", "IVLx7Wtaad6"),
    ("ICD10", "B46.0", "B46.0 Pulmonary mucormycosis", "Yf94iI0HtF3"),
    ("ICD10", "B46.1", "B46.1 Rhinocerebral mucormycosis", "zL9hEBZwHci"),
    ("ICD10", "B46.2", "B46.2 Gastrointestinal mucormycosis", "CCzZktsrAYM"),
    ("ICD10", "B46.3", "B46.3 Cutaneous mucormycosis", "FjbsETtj46v"),
    ("ICD10", "B46.4", "B46.4 Disseminated mucormycosis", "Dejr1J5Bp8m"),
    ("ICD10", "B46.5", "B46.5 Mucormycosis, unspecified", "bEldYAU37hM"),
    ("ICD10", "B46.8", "B46.8 Other zygomycoses", "Sn2qTe9iQ0r"),
    ("ICD10", "B46.9", "B46.9 Zygomycosis, unspecified", "Bk5RtjODe9T"),
    ("ICD10", "B47", "B47 Mycetoma", "VlA22txQlio"),
    ("ICD10", "B47.0", "B47.0 Eumycetoma", "BnyDAJjJhDj"),
    ("ICD10", "B47.1", "B47.1 Actinomycetoma", "wKXoEKizGjY"),
    ("ICD10", "B47.9", "B47.9 Mycetoma, unspecified", "WUEJJ2MiS1n"),
    ("ICD10", "B48", "B48 Other mycoses, not elsewhere classified", "UMzuhUUvzj3"),
    ("ICD10", "B48.0", "B48.0 Lobomycosis", "BrSUTNzCqvl"),
    ("ICD10", "B48.1", "B48.1 Rhinosporidiosis", "OyOxK2xPOUB"),
    ("ICD10", "B48.2", "B48.2 Allescheriasis", "ak3wGMXoitL"),
    ("ICD10", "B48.3", "B48.3 Geotrichosis", "GeA5o3WueZl"),
    ("ICD10", "B48.4", "B48.4 Penicillosis", "o6CjYulnr4e"),
    ("ICD10", "B48.7", "B48.7 Opportunistic mycoses", "EGyoaAGsWaZ"),
    ("ICD10", "B48.8", "B48.8 Other specified mycoses", "gCnramLFyqv"),
    ("ICD10", "B49", "B49 Unspecified mycosis", "UbGwGmeHFBk"),
    ("ICD10", "B50", "B50 Plasmodium falciparum malaria", "t0uWPOyLTfD");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "B50.0", "B50.0 Plasmodium falciparum malaria with cerebral complications", "f6OTxy1s6Ax"),
    ("ICD10", "B50.8", "B50.8 Other severe and complicated Plasmodium falciparum malaria", "RL1HM5TZJYX"),
    ("ICD10", "B50.9", "B50.9 Plasmodium falciparum malaria, unspecified", "jo5pOfgKvmF"),
    ("ICD10", "B51", "B51 Plasmodium vivax malaria", "efYaddYmUmx"),
    ("ICD10", "B51.0", "B51.0 Plasmodium vivax malaria with rupture of spleen", "BQXLmQA1yRi"),
    ("ICD10", "B51.8", "B51.8 Plasmodium vivax malaria with other complications", "OXD5SHUIqyW"),
    ("ICD10", "B51.9", "B51.9 Plasmodium vivax malaria without complication", "GGqTlQ05hwn"),
    ("ICD10", "B52", "B52 Plasmodium malariae malaria", "IMDs6o3l6Pl"),
    ("ICD10", "B52.0", "B52.0 Plasmodium malariae malaria with nephropathy", "rjZxGjeD7Gi"),
    ("ICD10", "B52.8", "B52.8 Plasmodium malariae malaria with other complications", "diEiowX2Bdi"),
    ("ICD10", "B52.9", "B52.9 Plasmodium malariae malaria without complication", "cDf5143tgcQ"),
    ("ICD10", "B53", "B53 Other parasitologically confirmed malaria", "IvDNwq06YMc"),
    ("ICD10", "B53.0", "B53.0 Plasmodium ovale malaria", "jS8VvZKxgsm"),
    ("ICD10", "B53.1", "B53.1 Malaria due to simian plasmodia", "ivNrMWAu2sp"),
    ("ICD10", "B53.8", "B53.8 Other parasitologically confirmed malaria, not elsewhere classified", "p9wDK47wypI"),
    ("ICD10", "B54", "B54 Unspecified malaria", "fBlgmMAzs2J"),
    ("ICD10", "B55", "B55 Leishmaniasis", "Va4xwjAxdNa"),
    ("ICD10", "B55.0", "B55.0 Visceral leishmaniasis", "dD8OBAzmFyQ"),
    ("ICD10", "B55.1", "B55.1 Cutaneous leishmaniasis", "myq1rWAQPye"),
    ("ICD10", "B55.2", "B55.2 Mucocutaneous leishmaniasis", "BmYMxOVC3gi"),
    ("ICD10", "B55.9", "B55.9 Leishmaniasis, unspecified", "MaPzIs0pJgg"),
    ("ICD10", "B56", "B56 African trypanosomiasis", "dt0dF428Oa0"),
    ("ICD10", "B56.0", "B56.0 Gambiense trypanosomiasis", "dVsW3Kv7N2w"),
    ("ICD10", "B56.1", "B56.1 Rhodesiense trypanosomiasis", "avGnv56wqSj"),
    ("ICD10", "B56.9", "B56.9 African trypanosomiasis, unspecified", "IPSAhitHjcI"),
    ("ICD10", "B57", "B57 Chagas disease", "Kzi6uUevlhw"),
    ("ICD10", "B57.0", "B57.0 Acute Chagas disease with heart involvement", "IaCcN3bLCjR"),
    ("ICD10", "B57.1", "B57.1 Acute Chagas disease without heart involvement", "FysWIfAsJBL"),
    ("ICD10", "B57.2", "B57.2 Chagas disease (chronic) with heart involvement", "ijoRbVoqCW0"),
    ("ICD10", "B57.3", "B57.3 Chagas disease (chronic) with digestive system involvement", "SqjDKoO4BqS"),
    ("ICD10", "B57.4", "B57.4 Chagas disease (chronic) with nervous system involvement", "VMCgh0R1fcT"),
    ("ICD10", "B57.5", "B57.5 Chagas disease (chronic) with other organ involvement", "RW5FP12aaoQ"),
    ("ICD10", "B58", "B58 Toxoplasmosis", "MKmWBn3cOWR"),
    ("ICD10", "B58.0", "B58.0 Toxoplasma oculopathy", "u9r9h4Hq4tZ"),
    ("ICD10", "B58.1", "B58.1 Toxoplasma hepatitis", "lW6v0tyUx3d"),
    ("ICD10", "B58.2", "B58.2 Toxoplasma meningoencephalitis", "UsCwMmU2mnC"),
    ("ICD10", "B58.3", "B58.3 Pulmonary toxoplasmosis", "OoVaZ37TBI0"),
    ("ICD10", "B58.8", "B58.8 Toxoplasmosis with other organ involvement", "OdCXStmqo6t"),
    ("ICD10", "B58.9", "B58.9 Toxoplasmosis, unspecified", "MWaNXBU9RyB"),
    ("ICD10", "B59", "B59 Pneumocystosis", "fqYhXn4fhwm"),
    ("ICD10", "B60", "B60 Other protozoal diseases, not elsewhere classified", "KrRRqQqakni"),
    ("ICD10", "B60.0", "B60.0 Babesiosis", "w4qgGWsdD5M"),
    ("ICD10", "B60.1", "B60.1 Acanthamoebiasis", "JHAAmC29Pah"),
    ("ICD10", "B60.2", "B60.2 Naegleriasis", "oJMy1Sg6YXS"),
    ("ICD10", "B60.8", "B60.8 Other specified protozoal diseases", "f8BiaBV8oyG"),
    ("ICD10", "B64", "B64 Unspecified protozoal disease", "xMjte2bclBk"),
    ("ICD10", "B65", "B65 Schistosomiasis [bilharziasis]", "ls2hbN9p3ef"),
    ("ICD10", "B65.0", "B65.0 Schistosomiasis due to Schistosoma haematobium [urinary schistosomiasis]", "dEgbGp7PsU0"),
    ("ICD10", "B65.1", "B65.1 Schistosomiasis due to Schistosoma mansoni [intestinal schistosomiasis]", "UTZIabNfYWj"),
    ("ICD10", "B65.2", "B65.2 Schistosomiasis due to Schistosoma japonicum", "SSGsuoano1j"),
    ("ICD10", "B65.3", "B65.3 Cercarial dermatitis", "zGrxhWhYx4O"),
    ("ICD10", "B65.8", "B65.8 Other schistosomiases", "AXwGhGxufrx"),
    ("ICD10", "B65.9", "B65.9 Schistosomiasis, unspecified", "QOjNp9DMNDE"),
    ("ICD10", "B66", "B66 Other fluke infections", "Hgk83T4KxrZ"),
    ("ICD10", "B66.0", "B66.0 Opisthorchiasis", "fnSN021O1SJ"),
    ("ICD10", "B66.1", "B66.1 Clonorchiasis", "t3mrw86a4ve"),
    ("ICD10", "B66.2", "B66.2 Dicrocoeliasis", "Few38OlLgta"),
    ("ICD10", "B66.3", "B66.3 Fascioliasis", "g7FLwXCIaPw"),
    ("ICD10", "B66.4", "B66.4 Paragonimiasis", "BOkfZa7nxeN"),
    ("ICD10", "B66.5", "B66.5 Fasciolopsiasis", "U8QQfe3OMfh"),
    ("ICD10", "B66.8", "B66.8 Other specified fluke infections", "WhFRrKjY9aj"),
    ("ICD10", "B66.9", "B66.9 Fluke infection, unspecified", "hdU1SBmGreG"),
    ("ICD10", "B67", "B67 Echinococcosis", "EMmurfOHmyg"),
    ("ICD10", "B67.0", "B67.0 Echinococcus granulosus infection of liver", "L7HiakK723s"),
    ("ICD10", "B67.1", "B67.1 Echinococcus granulosus infection of lung", "KM5G4ThtkcW"),
    ("ICD10", "B67.2", "B67.2 Echinococcus granulosus infection of bone", "x9LXFuqz07l"),
    ("ICD10", "B67.3", "B67.3 Echinococcus granulosus infection, other and multiple sites", "Iwuc35WyERi"),
    ("ICD10", "B67.4", "B67.4 Echinococcus granulosus infection, unspecified", "nUituqdhJvU"),
    ("ICD10", "B67.5", "B67.5 Echinococcus multilocularis infection of liver", "jzboLu8j2ve"),
    ("ICD10", "B67.6", "B67.6 Echinococcus multilocularis infection, other and multiple sites", "BDQ9WeqvDn3"),
    ("ICD10", "B67.7", "B67.7 Echinococcus multilocularis infection, unspecified", "FLO9KtMjALI"),
    ("ICD10", "B67.8", "B67.8 Echinococcosis, unspecified, of liver", "Ex3NansGs9x"),
    ("ICD10", "B67.9", "B67.9 Echinococcosis, other and unspecified", "D3PZDv53BqM"),
    ("ICD10", "B68", "B68 Taeniasis", "GM7kA7pHq12"),
    ("ICD10", "B68.0", "B68.0 Taenia solium taeniasis", "RCka5m2TsKg"),
    ("ICD10", "B68.1", "B68.1 Taenia saginata taeniasis", "h8BQehZ5Sfa"),
    ("ICD10", "B68.9", "B68.9 Taeniasis, unspecified", "PhuXe5ct0q8"),
    ("ICD10", "B69", "B69 Cysticercosis", "NhdkhPX1hq5"),
    ("ICD10", "B69.0", "B69.0 Cysticercosis of central nervous system", "xsUvMHZf6lM"),
    ("ICD10", "B69.1", "B69.1 Cysticercosis of eye", "SZgnOf8RvY4"),
    ("ICD10", "B69.8", "B69.8 Cysticercosis of other sites", "fAybIrTGL6e"),
    ("ICD10", "B69.9", "B69.9 Cysticercosis, unspecified", "Itb8Fb0Uahw"),
    ("ICD10", "B70", "B70 Diphyllobothriasis and sparganosis", "FdTdaFih4zq"),
    ("ICD10", "B70.0", "B70.0 Diphyllobothriasis", "mt7S3XDenM7"),
    ("ICD10", "B70.1", "B70.1 Sparganosis", "d1oiUljdQhK"),
    ("ICD10", "B71", "B71 Other cestode infections", "UM81jT3tNtR"),
    ("ICD10", "B71.0", "B71.0 Hymenolepiasis", "n6cbEINksv0"),
    ("ICD10", "B71.1", "B71.1 Dipylidiasis", "tqO8gCKaQsO"),
    ("ICD10", "B71.8", "B71.8 Other specified cestode infections", "zysGMqMdOM8"),
    ("ICD10", "B71.9", "B71.9 Cestode infection, unspecified", "Ox3GETVCgdR"),
    ("ICD10", "B72", "B72 Dracunculiasis", "ylbKBTvZkNm"),
    ("ICD10", "B73", "B73 Onchocerciasis", "N9E3YWrTo9f"),
    ("ICD10", "B74", "B74 Filariasis", "Vvr6H2S46Ql"),
    ("ICD10", "B74.0", "B74.0 Filariasis due to Wuchereria bancrofti", "p42jfISqyn8"),
    ("ICD10", "B74.1", "B74.1 Filariasis due to Brugia malayi", "jGktoIDNf75"),
    ("ICD10", "B74.2", "B74.2 Filariasis due to Brugia timori", "ExEa9t94Rs0"),
    ("ICD10", "B74.3", "B74.3 Loiasis", "Cmb2k4FIqCa"),
    ("ICD10", "B74.4", "B74.4 Mansonelliasis", "YhpqXrC271r"),
    ("ICD10", "B74.8", "B74.8 Other filariases", "lwieNnppTdO"),
    ("ICD10", "B74.9", "B74.9 Filariasis, unspecified", "zKYACeeEkvt"),
    ("ICD10", "B75", "B75 Trichinellosis", "pvNHIvSgz7O"),
    ("ICD10", "B76", "B76 Hookworm diseases", "XIr9ewtA9Z3"),
    ("ICD10", "B76.0", "B76.0 Ancylostomiasis", "CWNUVrjTHJW"),
    ("ICD10", "B76.1", "B76.1 Necatoriasis", "CWyeb2ZuUaN"),
    ("ICD10", "B76.8", "B76.8 Other hookworm diseases", "oJuB60lBTfV"),
    ("ICD10", "B76.9", "B76.9 Hookworm disease, unspecified", "rtZij8QNTSE"),
    ("ICD10", "B77", "B77 Ascariasis", "hPYbyPCSECw"),
    ("ICD10", "B77.0", "B77.0 Ascariasis with intestinal complications", "LT5h6MN6PuI"),
    ("ICD10", "B77.8", "B77.8 Ascariasis with other complications", "B7wWTUPxyhD"),
    ("ICD10", "B77.9", "B77.9 Ascariasis, unspecified", "kVlKD5ppjEp"),
    ("ICD10", "B78", "B78 Strongyloidiasis", "nDHfUml0emo"),
    ("ICD10", "B78.0", "B78.0 Intestinal strongyloidiasis", "bFFPwQ1t7ou"),
    ("ICD10", "B78.1", "B78.1 Cutaneous strongyloidiasis", "XOpoI3ROgUu"),
    ("ICD10", "B78.7", "B78.7 Disseminated strongyloidiasis", "lpgLTHuJpC9"),
    ("ICD10", "B78.9", "B78.9 Strongyloidiasis, unspecified", "pNpicYSFBsn"),
    ("ICD10", "B79", "B79 Trichuriasis", "fMfya9D9IdP"),
    ("ICD10", "B80", "B80 Enterobiasis", "nSszi8hH3PU"),
    ("ICD10", "B81", "B81 Other intestinal helminthiases, not elsewhere classified", "cL76o0LQ2VZ"),
    ("ICD10", "B81.0", "B81.0 Anisakiasis", "EnGcJWUDQxx"),
    ("ICD10", "B81.1", "B81.1 Intestinal capillariasis", "ZuDdyiHb3CG"),
    ("ICD10", "B81.2", "B81.2 Trichostrongyliasis", "uiUEl08g6sa"),
    ("ICD10", "B81.3", "B81.3 Intestinal angiostrongyliasis", "C1E2w7zeT1d"),
    ("ICD10", "B81.4", "B81.4 Mixed intestinal helminthiases", "wNi7vtRcmRq"),
    ("ICD10", "B81.8", "B81.8 Other specified intestinal helminthiases", "xtngs6RQuNb"),
    ("ICD10", "B82", "B82 Unspecified intestinal parasitism", "dchFN9hctZD"),
    ("ICD10", "B82.0", "B82.0 Intestinal helminthiasis, unspecified", "flIZ6LgsmPU"),
    ("ICD10", "B82.9", "B82.9 Intestinal parasitism, unspecified", "NNoUXKCJIJ9"),
    ("ICD10", "B83", "B83 Other helminthiases", "ghbhiiAz1al"),
    ("ICD10", "B83.0", "B83.0 Visceral larva migrans", "gsR6F3D6w0J"),
    ("ICD10", "B83.1", "B83.1 Gnathostomiasis", "kgxpbevVBY1"),
    ("ICD10", "B83.2", "B83.2 Angiostrongyliasis due to Parastrongylus cantonensis", "VmZWub6qqPk"),
    ("ICD10", "B83.3", "B83.3 Syngamiasis", "Q7USMr5SxzG"),
    ("ICD10", "B83.4", "B83.4 Internal hirudiniasis", "KXwvuApxtw0"),
    ("ICD10", "B83.8", "B83.8 Other specified helminthiases", "wTsDolytlTO"),
    ("ICD10", "B83.9", "B83.9 Helminthiasis, unspecified", "pyfW7KhVKFr"),
    ("ICD10", "B85", "B85 Pediculosis and phthiriasis", "Y0h4gnk1NUD"),
    ("ICD10", "B85.0", "B85.0 Pediculosis due to Pediculus humanus capitis", "v5bOr2kvrrR"),
    ("ICD10", "B85.1", "B85.1 Pediculosis due to Pediculus humanus corporis", "nMXmFPXPd8g"),
    ("ICD10", "B85.2", "B85.2 Pediculosis, unspecified", "DbssUhuCZmL"),
    ("ICD10", "B85.3", "B85.3 Phthiriasis", "qlw2MIwgbmP"),
    ("ICD10", "B85.4", "B85.4 Mixed pediculosis and phthiriasis", "mAgeM9Lxgcq"),
    ("ICD10", "B86", "B86 Scabies", "W4HUEf9F854"),
    ("ICD10", "B87", "B87 Myiasis", "pW7KkJS4YRb"),
    ("ICD10", "B87.0", "B87.0 Cutaneous myiasis", "xFSewFIbc5m"),
    ("ICD10", "B87.1", "B87.1 Wound myiasis", "r08MZYFKF12"),
    ("ICD10", "B87.2", "B87.2 Ocular myiasis", "Hq7PDQMwKEg"),
    ("ICD10", "B87.3", "B87.3 Nasopharyngeal myiasis", "B3ZjaKJ5CjC"),
    ("ICD10", "B87.4", "B87.4 Aural myiasis", "tnHryWwd9ec"),
    ("ICD10", "B87.8", "B87.8 Myiasis of other sites", "pIeRFEOXqWt"),
    ("ICD10", "B87.9", "B87.9 Myiasis, unspecified", "eJHMEuIA5pP"),
    ("ICD10", "B88", "B88 Other infestations", "L5QIs4VQu7n"),
    ("ICD10", "B88.0", "B88.0 Other acariasis", "ecgHTuTmhDw"),
    ("ICD10", "B88.1", "B88.1 Tungiasis [sandflea infestation]", "X3dx3nP3NZA"),
    ("ICD10", "B88.2", "B88.2 Other arthropod infestations", "vIWfNvxiprV"),
    ("ICD10", "B88.3", "B88.3 External hirudiniasis", "eUr9uIvCGxD"),
    ("ICD10", "B88.8", "B88.8 Other specified infestations", "ubf9s864UlR"),
    ("ICD10", "B88.9", "B88.9 Infestation, unspecified", "sxHXLYlQ40L"),
    ("ICD10", "B89", "B89 Unspecified parasitic disease", "cBGqqVeOtXx"),
    ("ICD10", "B90", "B90 Sequelae of tuberculosis", "UxZ83S1fbZc"),
    ("ICD10", "B90.0", "B90.0 Sequelae of central nervous system tuberculosis", "KX33ULCJHYf"),
    ("ICD10", "B90.1", "B90.1 Sequelae of genitourinary tuberculosis", "UNhn4a84Osd"),
    ("ICD10", "B90.2", "B90.2 Sequelae of tuberculosis of bones and joints", "yN2ve88QwB3"),
    ("ICD10", "B90.8", "B90.8 Sequelae of tuberculosis of other organs", "Y5HmwmySJwC"),
    ("ICD10", "B90.9", "B90.9 Sequelae of respiratory and unspecified tuberculosis", "eXFOK3iccPa"),
    ("ICD10", "B91", "B91 Sequelae of poliomyelitis", "JtAwix8r9ct"),
    ("ICD10", "B92", "B92 Sequelae of leprosy", "AEDCSFXmFwd"),
    ("ICD10", "B94", "B94 Sequelae of other and unspecified infectious and parasitic diseases", "mRCMYgLCNKM"),
    ("ICD10", "B94.0", "B94.0 Sequelae of trachoma", "XaW5EGeshEm"),
    ("ICD10", "B94.1", "B94.1 Sequelae of viral encephalitis", "g5vPaEjOIqh"),
    ("ICD10", "B94.2", "B94.2 Sequelae of viral hepatitis", "SfxyVc9ZoEq"),
    ("ICD10", "B94.8", "B94.8 Sequelae of other specified infectious and parasitic diseases", "rlt5olWUG1J"),
    ("ICD10", "B94.9", "B94.9 Sequelae of unspecified infectious or parasitic disease", "amvneX8t0sf"),
    ("ICD10", "B95", "B95 Streptococcus and staphylococcus as the cause of diseases classified to other chapters", "CODctxtXJq0"),
    ("ICD10", "B95.0", "B95.0 Streptococcus, group A, as the cause of diseases classified to other chapters", "aImjVVSZrEU"),
    ("ICD10", "B95.1", "B95.1 Streptococcus, group B, as the cause of diseases classified to other chapters", "tPKqYiHGF6Y"),
    ("ICD10", "B95.2", "B95.2 Streptococcus group D and enterococcus as the cause of diseases classified to other chapters", "d3psVqjwWlu"),
    ("ICD10", "B95.3", "B95.3 Streptococcus pneumoniae as the cause of diseases classified to other chapters", "jIS6ryMC6X5"),
    ("ICD10", "B95.4", "B95.4 Other streptococcus as the cause of diseases classified to other chapters", "uyIB51RYufY"),
    ("ICD10", "B95.5", "B95.5 Unspecified streptococcus as the cause of diseases classified to other chapters", "xyeqFpawzVZ"),
    ("ICD10", "B95.6", "B95.6 Staphylococcus aureus as the cause of diseases classified to other chapters", "kOnaAmukZNq"),
    ("ICD10", "B95.7", "B95.7 Other staphylococcus as the cause of diseases classified to other chapters", "llpzb5tTA1e"),
    ("ICD10", "B95.8", "B95.8 Unspecified staphylococcus as the cause of diseases classified to other chapters", "zazbHva4nol"),
    ("ICD10", "B96", "B96 Other specified bacterial agents as the cause of diseases classified to other chapters", "BtXPur1RZsZ"),
    ("ICD10", "B96.0", "B96.0 Mycoplasma pneumoniae [M. pneumoniae] as the cause of diseases classified to other chapters", "K7iQMy8Fg2Q"),
    ("ICD10", "B96.1", "B96.1 Klebsiella pneumoniae [K. pneumoniae] as the cause of diseases classified to other chapters", "rSYWjoqnUjw"),
    ("ICD10", "B96.2", "B96.2 Escherichia coli [E. coli] as the cause of diseases classified to other chapters", "Pxh8S24oQ5i"),
    ("ICD10", "B96.3", "B96.3 Haemophilus influenzae [H. influenzae] as the cause of diseases classified to other chapters", "bGeLxlDD4mI"),
    ("ICD10", "B96.4", "B96.4 Proteus (mirabilis)(morganii) as the cause of diseases classified to other chapters", "YMX8TmTjzVh"),
    ("ICD10", "B96.5", "B96.5 Pseudomonas (aeruginosa) as the cause of diseases classified to other chapters", "C7ZWIYZHy0f"),
    ("ICD10", "B96.6", "B96.6 Bacillus fragilis [B. fragilis] as the cause of diseases classified to other chapters", "yifgiqqZRJA"),
    ("ICD10", "B96.7", "B96.7 Clostridium perfringens [C. perfringens] as the cause of diseases classified to other chapters", "M0rjj5xQ7Ak"),
    ("ICD10", "B96.8", "B96.8 Other specified bacterial agents as the cause of diseases classified to other chapters", "cuutErGO1pM"),
    ("ICD10", "B97", "B97 Viral agents as the cause of diseases classified to other chapters", "wXtGAqQLSA8"),
    ("ICD10", "B97.0", "B97.0 Adenovirus as the cause of diseases classified to other chapters", "ekDyvI5Dq29"),
    ("ICD10", "B97.1", "B97.1 Enterovirus as the cause of diseases classified to other chapters", "KyJfi8sQZLy"),
    ("ICD10", "B97.2", "B97.2 Coronavirus as the cause of diseases classified to other chapters", "ayYkZDgG1Lo"),
    ("ICD10", "B97.3", "B97.3 Retrovirus as the cause of diseases classified to other chapters", "rs9p8UXW3wN"),
    ("ICD10", "B97.4", "B97.4 Respiratory syncytial virus as the cause of diseases classified to other chapters", "HGEkYkzRmTN"),
    ("ICD10", "B97.5", "B97.5 Reovirus as the cause of diseases classified to other chapters", "ghFNP8HV6l0"),
    ("ICD10", "B97.6", "B97.6 Parvovirus as the cause of diseases classified to other chapters", "BUyDEM18udp"),
    ("ICD10", "B97.7", "B97.7 Papillomavirus as the cause of diseases classified to other chapters", "FOsANdVObbv"),
    ("ICD10", "B97.8", "B97.8 Other viral agents as the cause of diseases classified to other chapters", "pw222mWhntX"),
    ("ICD10", "B98", "B98 Other specified infectious agents as the cause of diseases classified to other chapters", "XqkDLpHrndH"),
    ("ICD10", "B98.0", "B98.0 Helicobacter pylori [H.pylori] as the cause of diseases classified to other chapters", "b0mS8MVDCyV"),
    ("ICD10", "B98.1", "B98.1 Vibrio vulnificus as the cause of diseases classified to other chapters", "baEZ1iwROYR"),
    ("ICD10", "B99", "B99 Other and unspecified infectious diseases", "NT8XMinuQea");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "C00", "C00 Malignant neoplasm of lip", "m80L3Uy6Vhi"),
    ("ICD10", "C00.0", "C00.0 Malignant neoplasm: External upper lip", "XH2yy97RjJb"),
    ("ICD10", "C00.1", "C00.1 Malignant neoplasm: External lower lip", "ea1a2aLhmwo"),
    ("ICD10", "C00.2", "C00.2 Malignant neoplasm: External lip, unspecified", "J9J02efZGXW"),
    ("ICD10", "C00.3", "C00.3 Malignant neoplasm: Upper lip, inner aspect", "RCZPSWTIOfm"),
    ("ICD10", "C00.4", "C00.4 Malignant neoplasm: Lower lip, inner aspect", "aOHEEueFdNw"),
    ("ICD10", "C00.5", "C00.5 Malignant neoplasm: Lip, unspecified, inner aspect", "LOYGs44GoKK"),
    ("ICD10", "C00.6", "C00.6 Malignant neoplasm: Commissure of lip", "nWkiUmvbHGE"),
    ("ICD10", "C00.8", "C00.8 Malignant neoplasm: Overlapping lesion of lip", "I31ZeWehp2P"),
    ("ICD10", "C00.9", "C00.9 Malignant neoplasm: Lip, unspecified", "X5SLnNQevDG"),
    ("ICD10", "C01", "C01 Malignant neoplasm of base of tongue", "mnbsbr6bSSE"),
    ("ICD10", "C02", "C02 Malignant neoplasm of other and unspecified parts of tongue", "mcZ18lKWFeY"),
    ("ICD10", "C02.0", "C02.0 Malignant neoplasm: Dorsal surface of tongue", "B8ZqYPvsa3S"),
    ("ICD10", "C02.1", "C02.1 Malignant neoplasm: Border of tongue", "IJc582PB1iC"),
    ("ICD10", "C02.2", "C02.2 Malignant neoplasm: Ventral surface of tongue", "WqNYyuYkApU"),
    ("ICD10", "C02.3", "C02.3 Malignant neoplasm: Anterior two-thirds of tongue, part unspecified", "iTTc5JrDPhw"),
    ("ICD10", "C02.4", "C02.4 Malignant neoplasm: Lingual tonsil", "ZE87IoBub0k"),
    ("ICD10", "C02.8", "C02.8 Malignant neoplasm: Overlapping lesion of tongue", "sw9TVcSpsJ3"),
    ("ICD10", "C02.9", "C02.9 Malignant neoplasm: Tongue, unspecified", "wyhlD155fUc"),
    ("ICD10", "C03", "C03 Malignant neoplasm of gum", "Q8NU8lifxqu"),
    ("ICD10", "C03.0", "C03.0 Malignant neoplasm: Upper gum", "XAEvN0PHnqe"),
    ("ICD10", "C03.1", "C03.1 Malignant neoplasm: Lower gum", "Yy41Zk6Ybod"),
    ("ICD10", "C03.9", "C03.9 Malignant neoplasm: Gum, unspecified", "qbo4vm3ySru"),
    ("ICD10", "C04", "C04 Malignant neoplasm of floor of mouth", "xBHGMyswO6H"),
    ("ICD10", "C04.0", "C04.0 Malignant neoplasm: Anterior floor of mouth", "uwrHkKH0CCN"),
    ("ICD10", "C04.1", "C04.1 Malignant neoplasm: Lateral floor of mouth", "CCcxdgzk9gF"),
    ("ICD10", "C04.8", "C04.8 Malignant neoplasm: Overlapping lesion of floor of mouth", "PO5a14kuEtu"),
    ("ICD10", "C04.9", "C04.9 Malignant neoplasm: Floor of mouth, unspecified", "VihGMuyHZml"),
    ("ICD10", "C05", "C05 Malignant neoplasm of palate", "mpfJOSQzH57"),
    ("ICD10", "C05.0", "C05.0 Malignant neoplasm: Hard palate", "Nbp3ykpKPVc"),
    ("ICD10", "C05.1", "C05.1 Malignant neoplasm: Soft palate", "Nwq8S3f8Xmi"),
    ("ICD10", "C05.2", "C05.2 Malignant neoplasm: Uvula", "MugSuhV86ko"),
    ("ICD10", "C05.8", "C05.8 Malignant neoplasm: Overlapping lesion of palate", "yG5C4ZAl8JV"),
    ("ICD10", "C05.9", "C05.9 Malignant neoplasm: Palate, unspecified", "bivatSzlHGt"),
    ("ICD10", "C06", "C06 Malignant neoplasm of other and unspecified parts of mouth", "emIjRj6BBkn"),
    ("ICD10", "C06.0", "C06.0 Malignant neoplasm: Cheek mucosa", "E8p3QM1LHTp"),
    ("ICD10", "C06.1", "C06.1 Malignant neoplasm: Vestibule of mouth", "oiI6stUHV9R"),
    ("ICD10", "C06.2", "C06.2 Malignant neoplasm: Retromolar area", "EoNbXOLtCRW"),
    ("ICD10", "C06.8", "C06.8 Malignant neoplasm: Overlapping lesion of other and unspecified parts of mouth", "md1bazDfDCU"),
    ("ICD10", "C06.9", "C06.9 Malignant neoplasm: Mouth, unspecified", "pLWZkOwZeW5"),
    ("ICD10", "C07", "C07 Malignant neoplasm of parotid gland", "Yn3FFFPKMCR"),
    ("ICD10", "C08", "C08 Malignant neoplasm of other and unspecified major salivary glands", "aNS9KKLLokg"),
    ("ICD10", "C08.0", "C08.0 Malignant neoplasm: Submandibular gland", "HUMEddkfIUD"),
    ("ICD10", "C08.1", "C08.1 Malignant neoplasm: Sublingual gland", "QxRPJpovQOb"),
    ("ICD10", "C08.8", "C08.8 Malignant neoplasm: Overlapping lesion of major salivary glands", "F581BPOD1aY"),
    ("ICD10", "C08.9", "C08.9 Malignant neoplasm: Major salivary gland, unspecified", "LJw2Vjh3agC"),
    ("ICD10", "C09", "C09 Malignant neoplasm of tonsil", "oR2jdJOUJs8"),
    ("ICD10", "C09.0", "C09.0 Malignant neoplasm: Tonsillar fossa", "XOcCkqr3sD3"),
    ("ICD10", "C09.1", "C09.1 Malignant neoplasm: Tonsillar pillar (anterior)(posterior)", "tMzDBbAMzjX"),
    ("ICD10", "C09.8", "C09.8 Malignant neoplasm: Overlapping lesion of tonsil", "lZHPnW7IoPN"),
    ("ICD10", "C09.9", "C09.9 Malignant neoplasm: Tonsil, unspecified", "Pm0oc3uZkkz"),
    ("ICD10", "C10", "C10 Malignant neoplasm of oropharynx", "CiubSCPJr0L"),
    ("ICD10", "C10.0", "C10.0 Malignant neoplasm: Vallecula", "C3q4QDBtWBA"),
    ("ICD10", "C10.1", "C10.1 Malignant neoplasm: Anterior surface of epiglottis", "mQjEt4tfeOM"),
    ("ICD10", "C10.2", "C10.2 Malignant neoplasm: Lateral wall of oropharynx", "SHNpMMBXFk2"),
    ("ICD10", "C10.3", "C10.3 Malignant neoplasm: Posterior wall of oropharynx", "hRYE5rwjn1M"),
    ("ICD10", "C10.4", "C10.4 Malignant neoplasm: Branchial cleft", "iXAJE9M5OyL"),
    ("ICD10", "C10.8", "C10.8 Malignant neoplasm: Overlapping lesion of oropharynx", "w2TzAiXy68E"),
    ("ICD10", "C10.9", "C10.9 Malignant neoplasm: Oropharynx, unspecified", "dNH0xlFJcrI"),
    ("ICD10", "C11", "C11 Malignant neoplasm of nasopharynx", "TAX8BIqZwkT"),
    ("ICD10", "C11.0", "C11.0 Malignant neoplasm: Superior wall of nasopharynx", "xjaJYnHajmI"),
    ("ICD10", "C11.1", "C11.1 Malignant neoplasm: Posterior wall of nasopharynx", "MOlK5mEZqE4"),
    ("ICD10", "C11.2", "C11.2 Malignant neoplasm: Lateral wall of nasopharynx", "sFJYGE7K49E"),
    ("ICD10", "C11.3", "C11.3 Malignant neoplasm: Anterior wall of nasopharynx", "uZhqOVqQHez"),
    ("ICD10", "C11.8", "C11.8 Malignant neoplasm: Overlapping lesion of nasopharynx", "ieie5U4loAj"),
    ("ICD10", "C11.9", "C11.9 Malignant neoplasm: Nasopharynx, unspecified", "G731xB8zmZC"),
    ("ICD10", "C12", "C12 Malignant neoplasm of piriform sinus", "xUvIITfPyeN"),
    ("ICD10", "C13", "C13 Malignant neoplasm of hypopharynx", "nfv0WQmUVae"),
    ("ICD10", "C13.0", "C13.0 Malignant neoplasm: Postcricoid region", "fg88PQq8nOk"),
    ("ICD10", "C13.1", "C13.1 Malignant neoplasm: Aryepiglottic fold, hypopharyngeal aspect", "pqMEI6eMM1q"),
    ("ICD10", "C13.2", "C13.2 Malignant neoplasm: Posterior wall of hypopharynx", "ICrOAfGzkcr"),
    ("ICD10", "C13.8", "C13.8 Malignant neoplasm: Overlapping lesion of hypopharynx", "osOHWThsoHC"),
    ("ICD10", "C13.9", "C13.9 Malignant neoplasm: Hypopharynx, unspecified", "tx1p12xvkla"),
    ("ICD10", "C14", "C14 Malignant neoplasm of other and ill-defined sites in the lip, oral cavity and pharynx", "Js0Q6dxhoDs"),
    ("ICD10", "C14.0", "C14.0 Malignant neoplasm: Pharynx, unspecified", "vDKSLb323du"),
    ("ICD10", "C14.2", "C14.2 Malignant neoplasm: Waldeyer ring", "JTAkf0iT9Mq"),
    ("ICD10", "C14.8", "C14.8 Malignant neoplasm: Overlapping lesion of lip, oral cavity and pharynx", "EnQwSLWRSWp"),
    ("ICD10", "C15", "C15 Malignant neoplasm of oesophagus", "ixFKPiKVYCZ"),
    ("ICD10", "C15.0", "C15.0 Malignant neoplasm: Cervical part of oesophagus", "PfIb8mtv46y"),
    ("ICD10", "C15.1", "C15.1 Malignant neoplasm: Thoracic part of oesophagus", "mfM8VMGAbOC"),
    ("ICD10", "C15.2", "C15.2 Malignant neoplasm: Abdominal part of oesophagus", "zJm0VAZlbHO"),
    ("ICD10", "C15.3", "C15.3 Malignant neoplasm: Upper third of oesophagus", "g2X1ZnP3IyO"),
    ("ICD10", "C15.4", "C15.4 Malignant neoplasm: Middle third of oesophagus", "lcdomuwWkoU"),
    ("ICD10", "C15.5", "C15.5 Malignant neoplasm: Lower third of oesophagus", "TRNRu57Iqvz");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "C15.8", "C15.8 Malignant neoplasm: Overlapping lesion of oesophagus", "BCyg27MEGhb"),
    ("ICD10", "C15.9", "C15.9 Malignant neoplasm: Oesophagus, unspecified", "pbqQoLFtJrN"),
    ("ICD10", "C16", "C16 Malignant neoplasm of stomach", "MTvas4RpAp3"),
    ("ICD10", "C16.0", "C16.0 Malignant neoplasm: Cardia", "cwBLfyBEvlk"),
    ("ICD10", "C16.1", "C16.1 Malignant neoplasm: Fundus of stomach", "ESpMBkbKFND"),
    ("ICD10", "C16.2", "C16.2 Malignant neoplasm: Body of stomach", "P3vEpJqdqoR"),
    ("ICD10", "C16.3", "C16.3 Malignant neoplasm: Pyloric antrum", "ihLOnwrZAbE"),
    ("ICD10", "C16.4", "C16.4 Malignant neoplasm: Pylorus", "oo0bBLqk2q3"),
    ("ICD10", "C16.5", "C16.5 Malignant neoplasm: Lesser curvature of stomach, unspecified", "Z0n5bFP6Hpa"),
    ("ICD10", "C16.6", "C16.6 Malignant neoplasm: Greater curvature of stomach, unspecified", "GmXWs6abh1U"),
    ("ICD10", "C16.8", "C16.8 Malignant neoplasm: Overlapping lesion of stomach", "RMkdj2x6KEs"),
    ("ICD10", "C16.9", "C16.9 Malignant neoplasm: Stomach, unspecified", "rBGFaVyDukP"),
    ("ICD10", "C17", "C17 Malignant neoplasm of small intestine", "cyFZtKG7WiS"),
    ("ICD10", "C17.0", "C17.0 Malignant neoplasm: Duodenum", "iuZYLadAtDu"),
    ("ICD10", "C17.1", "C17.1 Malignant neoplasm: Jejunum", "eLS0v5EvmSP"),
    ("ICD10", "C17.2", "C17.2 Malignant neoplasm: Ileum", "SHQYqzXR6iH"),
    ("ICD10", "C17.3", "C17.3 Malignant neoplasm: Meckel diverticulum", "DBXcMaggSfO"),
    ("ICD10", "C17.8", "C17.8 Malignant neoplasm: Overlapping lesion of small intestine", "oTMSGmU8dpI"),
    ("ICD10", "C17.9", "C17.9 Malignant neoplasm: Small intestine, unspecified", "OVd4lU6RmY7"),
    ("ICD10", "C18", "C18 Malignant neoplasm of colon", "NJlPudvx7cf"),
    ("ICD10", "C18.0", "C18.0 Malignant neoplasm: Caecum", "Ezd5L1XZT5L"),
    ("ICD10", "C18.1", "C18.1 Malignant neoplasm: Appendix", "TQYEGHabigT"),
    ("ICD10", "C18.2", "C18.2 Malignant neoplasm: Ascending colon", "piZ9SmC4Cp4"),
    ("ICD10", "C18.3", "C18.3 Malignant neoplasm: Hepatic flexure", "LlWb9Q9ptpA"),
    ("ICD10", "C18.4", "C18.4 Malignant neoplasm: Transverse colon", "cuF3nEw4Dgm"),
    ("ICD10", "C18.5", "C18.5 Malignant neoplasm: Splenic flexure", "Ji1JbaLNAg8"),
    ("ICD10", "C18.6", "C18.6 Malignant neoplasm: Descending colon", "FMG7aw7Qlp4"),
    ("ICD10", "C18.7", "C18.7 Malignant neoplasm: Sigmoid colon", "aJg4RCssvp5"),
    ("ICD10", "C18.8", "C18.8 Malignant neoplasm: Overlapping lesion of colon", "zc7f1yAsX4I"),
    ("ICD10", "C18.9", "C18.9 Malignant neoplasm: Colon, unspecified", "wXkmr1OXWrp"),
    ("ICD10", "C19", "C19 Malignant neoplasm of rectosigmoid junction", "NBRkpsMbYaE"),
    ("ICD10", "C20", "C20 Malignant neoplasm of rectum", "mLv8zwidoSW"),
    ("ICD10", "C21", "C21 Malignant neoplasm of anus and anal canal", "b8ZlRJxmwBM"),
    ("ICD10", "C21.0", "C21.0 Malignant neoplasm: Anus, unspecified", "M6Fzu8Khnxm"),
    ("ICD10", "C21.1", "C21.1 Malignant neoplasm: Anal canal", "Jn3fxsPV6KS"),
    ("ICD10", "C21.2", "C21.2 Malignant neoplasm: Cloacogenic zone", "juQu3t03xPT"),
    ("ICD10", "C21.8", "C21.8 Malignant neoplasm: Overlapping lesion of rectum, anus and anal canal", "cPvPbG5fHOn"),
    ("ICD10", "C22", "C22 Malignant neoplasm of liver and intrahepatic bile ducts", "ArKRKofxg4N"),
    ("ICD10", "C22.0", "C22.0 Malignant neoplasm: Liver cell carcinoma", "KXAl06ADK6n"),
    ("ICD10", "C22.1", "C22.1 Malignant neoplasm: Intrahepatic bile duct carcinoma", "wb5ZP78DsCi"),
    ("ICD10", "C22.2", "C22.2 Malignant neoplasm: Hepatoblastoma", "xnwOqMvgtBU"),
    ("ICD10", "C22.3", "C22.3 Malignant neoplasm: Angiosarcoma of liver", "Zl8PMoOmE5G"),
    ("ICD10", "C22.4", "C22.4 Malignant neoplasm: Other sarcomas of liver", "jrVgaTo6vA5"),
    ("ICD10", "C22.7", "C22.7 Malignant neoplasm: Other specified carcinomas of liver", "STV0YTIVAT4"),
    ("ICD10", "C22.9", "C22.9 Malignant neoplasm: Liver, unspecified", "oCV5UoCBvg4"),
    ("ICD10", "C23", "C23 Malignant neoplasm of gallbladder", "WSJuH20QjGY"),
    ("ICD10", "C24", "C24 Malignant neoplasm of other and unspecified parts of biliary tract", "DSGcuDm0H2w"),
    ("ICD10", "C24.0", "C24.0 Malignant neoplasm: Extrahepatic bile duct", "zsoM0fzP2xD"),
    ("ICD10", "C24.1", "C24.1 Malignant neoplasm: Ampulla of Vater", "jW42iNGd4DY"),
    ("ICD10", "C24.8", "C24.8 Malignant neoplasm: Overlapping lesion of biliary tract", "fgJaTBhgSj4"),
    ("ICD10", "C24.9", "C24.9 Malignant neoplasm: Biliary tract, unspecified", "uCsp5NRWSkJ"),
    ("ICD10", "C25", "C25 Malignant neoplasm of pancreas", "OnPMHUPtHEn"),
    ("ICD10", "C25.0", "C25.0 Malignant neoplasm: Head of pancreas", "K5Zhts0f346"),
    ("ICD10", "C25.1", "C25.1 Malignant neoplasm: Body of pancreas", "pZXWDz8onLe"),
    ("ICD10", "C25.2", "C25.2 Malignant neoplasm: Tail of pancreas", "fH9nL6hoFuE"),
    ("ICD10", "C25.3", "C25.3 Malignant neoplasm: Pancreatic duct", "UFjh8LJyt9B"),
    ("ICD10", "C25.4", "C25.4 Malignant neoplasm: Endocrine pancreas", "FZLeav2iaGL"),
    ("ICD10", "C25.7", "C25.7 Malignant neoplasm: Other parts of pancreas", "ctQJzk8NpEJ"),
    ("ICD10", "C25.8", "C25.8 Malignant neoplasm: Overlapping lesion of pancreas", "yMGnGriZuef"),
    ("ICD10", "C25.9", "C25.9 Malignant neoplasm: Pancreas, unspecified", "H0GNkiIGRIN"),
    ("ICD10", "C26", "C26 Malignant neoplasm of other and ill-defined digestive organs", "vUgg8ZtWjw3"),
    ("ICD10", "C26.0", "C26.0 Malignant neoplasm: Intestinal tract, part unspecified", "g39ukmGcPSJ"),
    ("ICD10", "C26.1", "C26.1 Malignant neoplasm: Spleen", "cjx0mM9fWQn"),
    ("ICD10", "C26.8", "C26.8 Malignant neoplasm: Overlapping lesion of digestive system", "JH6DXj3J7oN"),
    ("ICD10", "C26.9", "C26.9 Malignant neoplasm: Ill-defined sites within the digestive system", "EqZADYNFb64"),
    ("ICD10", "C30", "C30 Malignant neoplasm of nasal cavity and middle ear", "Ka56lNwdH9J"),
    ("ICD10", "C30.0", "C30.0 Malignant neoplasm: Nasal cavity", "YeqEAP0uSMj"),
    ("ICD10", "C30.1", "C30.1 Malignant neoplasm: Middle ear", "RrRKopVO1BB"),
    ("ICD10", "C31", "C31 Malignant neoplasm of accessory sinuses", "kGKAQw4YtJ4"),
    ("ICD10", "C31.0", "C31.0 Malignant neoplasm: Maxillary sinus", "BVmb9UZL9Xg"),
    ("ICD10", "C31.1", "C31.1 Malignant neoplasm: Ethmoidal sinus", "pyY2AMLEpyG"),
    ("ICD10", "C31.2", "C31.2 Malignant neoplasm: Frontal sinus", "QieK6erK2rb"),
    ("ICD10", "C31.3", "C31.3 Malignant neoplasm: Sphenoidal sinus", "goQj54gzagD"),
    ("ICD10", "C31.8", "C31.8 Malignant neoplasm: Overlapping lesion of accessory sinuses", "LO18vuu85K6"),
    ("ICD10", "C31.9", "C31.9 Malignant neoplasm: Accessory sinus, unspecified", "TuPal7upBqa"),
    ("ICD10", "C32", "C32 Malignant neoplasm of larynx", "vlStk5HPl97"),
    ("ICD10", "C32.0", "C32.0 Malignant neoplasm: Glottis", "YOgEQFiHuXj"),
    ("ICD10", "C32.1", "C32.1 Malignant neoplasm: Supraglottis", "TPlMGFRznOr"),
    ("ICD10", "C32.2", "C32.2 Malignant neoplasm: Subglottis", "spquJQHJRO5"),
    ("ICD10", "C32.3", "C32.3 Malignant neoplasm: Laryngeal cartilage", "HIfHPuqobnC"),
    ("ICD10", "C32.8", "C32.8 Malignant neoplasm: Overlapping lesion of larynx", "OSC3zBxq0wQ"),
    ("ICD10", "C32.9", "C32.9 Malignant neoplasm: Larynx, unspecified", "EKMCjob0b80"),
    ("ICD10", "C33", "C33 Malignant neoplasm of trachea", "t9gcU5RIhTB"),
    ("ICD10", "C34", "C34 Malignant neoplasm of bronchus and lung", "AXrzNVzxz75"),
    ("ICD10", "C34.0", "C34.0 Malignant neoplasm: Main bronchus", "lkFFfa6YanR"),
    ("ICD10", "C34.1", "C34.1 Malignant neoplasm: Upper lobe, bronchus or lung", "iavmEPTHlXX"),
    ("ICD10", "C34.2", "C34.2 Malignant neoplasm: Middle lobe, bronchus or lung", "SX5FZQW8Chj"),
    ("ICD10", "C34.3", "C34.3 Malignant neoplasm: Lower lobe, bronchus or lung", "Ouk0a7ZXBx4"),
    ("ICD10", "C34.8", "C34.8 Malignant neoplasm: Overlapping lesion of bronchus and lung", "jIpfp8X2hKc"),
    ("ICD10", "C34.9", "C34.9 Malignant neoplasm: Bronchus or lung, unspecified", "H0uS7DGnLLR"),
    ("ICD10", "C37", "C37 Malignant neoplasm of thymus", "zRlNIJagZee"),
    ("ICD10", "C38", "C38 Malignant neoplasm of heart, mediastinum and pleura", "vgRokoQjMNc"),
    ("ICD10", "C38.0", "C38.0 Malignant neoplasm: Heart", "x1eMOPFqcn4"),
    ("ICD10", "C38.1", "C38.1 Malignant neoplasm: Anterior mediastinum", "xtfEtGVNb4L"),
    ("ICD10", "C38.2", "C38.2 Malignant neoplasm: Posterior mediastinum", "Kl1mOAwGYvr"),
    ("ICD10", "C38.3", "C38.3 Malignant neoplasm: Mediastinum, part unspecified", "GsI4yqIWQpj"),
    ("ICD10", "C38.4", "C38.4 Malignant neoplasm: Pleura", "vP93Z35KiUZ"),
    ("ICD10", "C38.8", "C38.8 Malignant neoplasm: Overlapping lesion of heart, mediastinum and pleura", "aFaO2iXWLEP"),
    ("ICD10", "C39", "C39 Malignant neoplasm of other and ill-defined sites in the respiratory system and intrathoracic organs", "eTfoleiNI9T"),
    ("ICD10", "C39.0", "C39.0 Malignant neoplasm: Upper respiratory tract, part unspecified", "jKZjFqlp1nK"),
    ("ICD10", "C39.8", "C39.8 Malignant neoplasm: Overlapping lesion of respiratory and intrathoracic organs", "Gsh4lETmlvT"),
    ("ICD10", "C39.9", "C39.9 Malignant neoplasm: Ill-defined sites within the respiratory system", "KQDHwdyL7Cz"),
    ("ICD10", "C40", "C40 Malignant neoplasm of bone and articular cartilage of limbs", "tgwkOyJESH0"),
    ("ICD10", "C40.0", "C40.0 Malignant neoplasm: Scapula and long bones of upper limb", "eCK66A5KEfY"),
    ("ICD10", "C40.1", "C40.1 Malignant neoplasm: Short bones of upper limb", "YsOe10SRDDs"),
    ("ICD10", "C40.2", "C40.2 Malignant neoplasm: Long bones of lower limb", "et3NN9nm7kC"),
    ("ICD10", "C40.3", "C40.3 Malignant neoplasm: Short bones of lower limb", "JvrgvCEp7FP"),
    ("ICD10", "C40.8", "C40.8 Malignant neoplasm: Overlapping lesion of bone and articular cartilage of limbs", "nkCf0FAMoxb"),
    ("ICD10", "C40.9", "C40.9 Malignant neoplasm: Bone and articular cartilage of limb, unspecified", "eFDBnjia2An"),
    ("ICD10", "C41", "C41 Malignant neoplasm of bone and articular cartilage of other and unspecified sites", "eQ0LUaWT8Af"),
    ("ICD10", "C41.0", "C41.0 Malignant neoplasm: Bones of skull and face", "updQdTikCxM"),
    ("ICD10", "C41.1", "C41.1 Malignant neoplasm: Mandible", "pe8cYwutuAt"),
    ("ICD10", "C41.2", "C41.2 Malignant neoplasm: Vertebral column", "ZL8PtNDzSre"),
    ("ICD10", "C41.3", "C41.3 Malignant neoplasm: Ribs, sternum and clavicle", "aTGfjemccJM"),
    ("ICD10", "C41.4", "C41.4 Malignant neoplasm: Pelvic bones, sacrum and coccyx", "gCglNJqGMx9"),
    ("ICD10", "C41.8", "C41.8 Malignant neoplasm: Overlapping lesion of bone and articular cartilage", "rOV2i0I9y41"),
    ("ICD10", "C41.9", "C41.9 Malignant neoplasm: Bone and articular cartilage, unspecified", "AkAq7GsEvGu"),
    ("ICD10", "C43", "C43 Malignant melanoma of skin", "tBjPfREttkC"),
    ("ICD10", "C43.0", "C43.0 Malignant neoplasm: Malignant melanoma of lip", "kz66UUxHml1"),
    ("ICD10", "C43.1", "C43.1 Malignant neoplasm: Malignant melanoma of eyelid, including canthus", "gQbJ60fR30d"),
    ("ICD10", "C43.2", "C43.2 Malignant neoplasm: Malignant melanoma of ear and external auricular canal", "w5FmHXSqOEl"),
    ("ICD10", "C43.3", "C43.3 Malignant neoplasm: Malignant melanoma of other and unspecified parts of face", "qSRWfaOwHP5"),
    ("ICD10", "C43.4", "C43.4 Malignant neoplasm: Malignant melanoma of scalp and neck", "zrGhbD1o5uS"),
    ("ICD10", "C43.5", "C43.5 Malignant neoplasm: Malignant melanoma of trunk", "mlPmHVuHTS1"),
    ("ICD10", "C43.6", "C43.6 Malignant neoplasm: Malignant melanoma of upper limb, including shoulder", "RbPGWyN2Qy7"),
    ("ICD10", "C43.7", "C43.7 Malignant neoplasm: Malignant melanoma of lower limb, including hip", "rdz1O3Qoy5a"),
    ("ICD10", "C43.8", "C43.8 Malignant neoplasm: Overlapping malignant melanoma of skin", "yCGx1E6SZFg"),
    ("ICD10", "C43.9", "C43.9 Malignant neoplasm: Malignant melanoma of skin, unspecified", "ORFVorLuRFv"),
    ("ICD10", "C44", "C44 Other malignant neoplasms of skin", "Kq98LQUetau"),
    ("ICD10", "C44.0", "C44.0 Malignant neoplasm: Skin of lip", "Oanvp1Tvx9e"),
    ("ICD10", "C44.1", "C44.1 Malignant neoplasm: Skin of eyelid, including canthus", "YJiro7C1WvB"),
    ("ICD10", "C44.2", "C44.2 Malignant neoplasm: Skin of ear and external auricular canal", "F4luIBkvaYo"),
    ("ICD10", "C44.3", "C44.3 Malignant neoplasm: Skin of other and unspecified parts of face", "NJ1N4pwuZOZ"),
    ("ICD10", "C44.4", "C44.4 Malignant neoplasm: Skin of scalp and neck", "P2xyJwy2uCF"),
    ("ICD10", "C44.5", "C44.5 Malignant neoplasm: Skin of trunk", "KdM09ZvyE1N"),
    ("ICD10", "C44.6", "C44.6 Malignant neoplasm: Skin of upper limb, including shoulder", "F7AgCLfqGLS"),
    ("ICD10", "C44.7", "C44.7 Malignant neoplasm: Skin of lower limb, including hip", "zvLeHN4cTN1"),
    ("ICD10", "C44.8", "C44.8 Malignant neoplasm: Overlapping lesion of skin", "GtXgINhoUSY"),
    ("ICD10", "C44.9", "C44.9 Malignant neoplasm: Malignant neoplasm of skin, unspecified", "oJqq1byV401"),
    ("ICD10", "C45", "C45 Mesothelioma", "r2TuwBnMVrZ"),
    ("ICD10", "C45.0", "C45.0 Mesothelioma of pleura", "POEUWPdnMyf"),
    ("ICD10", "C45.1", "C45.1 Mesothelioma of peritoneum", "Gn78wiJLd8D"),
    ("ICD10", "C45.2", "C45.2 Mesothelioma of pericardium", "S8I4wJ6Lh5M"),
    ("ICD10", "C45.7", "C45.7 Mesothelioma of other sites", "H95u2gUvyqN"),
    ("ICD10", "C45.9", "C45.9 Mesothelioma, unspecified", "ca6mq9IucV1"),
    ("ICD10", "C46", "C46 Kaposi sarcoma", "o9G2e2reCEH"),
    ("ICD10", "C46.0", "C46.0 Kaposi sarcoma of skin", "lmmeQXcXnQU"),
    ("ICD10", "C46.1", "C46.1 Kaposi sarcoma of soft tissue", "xbuguCd9bPs"),
    ("ICD10", "C46.2", "C46.2 Kaposi sarcoma of palate", "zoOBbleFIvp"),
    ("ICD10", "C46.3", "C46.3 Kaposi sarcoma of lymph nodes", "kjhpjXWYiPN"),
    ("ICD10", "C46.7", "C46.7 Kaposi sarcoma of other sites", "adFmCpf3vBD"),
    ("ICD10", "C46.8", "C46.8 Kaposi sarcoma of multiple organs", "uaq2FH2xgQr"),
    ("ICD10", "C46.9", "C46.9 Kaposi sarcoma, unspecified", "qz3bPzq6n6l"),
    ("ICD10", "C47", "C47 Malignant neoplasm of peripheral nerves and autonomic nervous system", "l0ITz5l9HDN"),
    ("ICD10", "C47.0", "C47.0 Malignant neoplasm: Peripheral nerves of head, face and neck", "BHOJCl5CPkh"),
    ("ICD10", "C47.1", "C47.1 Malignant neoplasm: Peripheral nerves of upper limb, including shoulder", "Hw5y6J2jSQU"),
    ("ICD10", "C47.2", "C47.2 Malignant neoplasm: Peripheral nerves of lower limb, including hip", "ViEEpqp5wyl"),
    ("ICD10", "C47.3", "C47.3 Malignant neoplasm: Peripheral nerves of thorax", "KoR4QkMYQt5"),
    ("ICD10", "C47.4", "C47.4 Malignant neoplasm: Peripheral nerves of abdomen", "Qr0nhwxypSX"),
    ("ICD10", "C47.5", "C47.5 Malignant neoplasm: Peripheral nerves of pelvis", "KsO2Io7TS4Q"),
    ("ICD10", "C47.6", "C47.6 Malignant neoplasm: Peripheral nerves of trunk, unspecified", "c37I3hPGT6I"),
    ("ICD10", "C47.8", "C47.8 Malignant neoplasm: Overlapping lesion of peripheral nerves and autonomic nervous system", "fL4UytKib8n"),
    ("ICD10", "C47.9", "C47.9 Malignant neoplasm: Peripheral nerves and autonomic nervous system, unspecified", "gRU5IaVz1Ee"),
    ("ICD10", "C48", "C48 Malignant neoplasm of retroperitoneum and peritoneum", "S5UtbOG0KiO"),
    ("ICD10", "C48.0", "C48.0 Malignant neoplasm: Retroperitoneum", "F9wV7LIvJPu"),
    ("ICD10", "C48.1", "C48.1 Malignant neoplasm: Specified parts of peritoneum", "l176LUYL54x"),
    ("ICD10", "C48.2", "C48.2 Malignant neoplasm: Peritoneum, unspecified", "qAZgbjZDHBa"),
    ("ICD10", "C48.8", "C48.8 Malignant neoplasm: Overlapping lesion of retroperitoneum and peritoneum", "dKXVtXyqjw2"),
    ("ICD10", "C49", "C49 Malignant neoplasm of other connective and soft tissue", "ai4ODe31XwW"),
    ("ICD10", "C49.0", "C49.0 Malignant neoplasm: Connective and soft tissue of head, face and neck", "FwpddTI7DPb"),
    ("ICD10", "C49.1", "C49.1 Malignant neoplasm: Connective and soft tissue of upper limb, including shoulder", "MwEM1P0zlTY"),
    ("ICD10", "C49.2", "C49.2 Malignant neoplasm: Connective and soft tissue of lower limb, including hip", "gccKrhHRsey"),
    ("ICD10", "C49.3", "C49.3 Malignant neoplasm: Connective and soft tissue of thorax", "iGoE7uMEYpQ"),
    ("ICD10", "C49.4", "C49.4 Malignant neoplasm: Connective and soft tissue of abdomen", "Exqp8TqhS0m"),
    ("ICD10", "C49.5", "C49.5 Malignant neoplasm: Connective and soft tissue of pelvis", "ArmMGjraew0"),
    ("ICD10", "C49.6", "C49.6 Malignant neoplasm: Connective and soft tissue of trunk, unspecified", "qMYOG1fqBWf"),
    ("ICD10", "C49.8", "C49.8 Malignant neoplasm: Overlapping lesion of connective and soft tissue", "XvBr9DKHUeO"),
    ("ICD10", "C49.9", "C49.9 Malignant neoplasm: Connective and soft tissue, unspecified", "Ii54Sm4SOK5"),
    ("ICD10", "C50", "C50 Malignant neoplasm of breast", "m0PCtXz7Aip"),
    ("ICD10", "C50.0", "C50.0 Malignant neoplasm: Nipple and areola", "r67rkHgADOl"),
    ("ICD10", "C50.1", "C50.1 Malignant neoplasm: Central portion of breast", "Bq9fyW2GaQY"),
    ("ICD10", "C50.2", "C50.2 Malignant neoplasm: Upper-inner quadrant of breast", "PqOYDyNnuMr"),
    ("ICD10", "C50.3", "C50.3 Malignant neoplasm: Lower-inner quadrant of breast", "f5HWCt50okG"),
    ("ICD10", "C50.4", "C50.4 Malignant neoplasm: Upper-outer quadrant of breast", "dwm5AXV36pP"),
    ("ICD10", "C50.5", "C50.5 Malignant neoplasm: Lower-outer quadrant of breast", "lv4qqFvYynj"),
    ("ICD10", "C50.6", "C50.6 Malignant neoplasm: Axillary tail of breast", "xDjAuvlycx7"),
    ("ICD10", "C50.8", "C50.8 Malignant neoplasm: Overlapping lesion of breast", "bOYoM4Eb5z9"),
    ("ICD10", "C50.9", "C50.9 Malignant neoplasm: Breast, unspecified", "RZT1Hr8lY53"),
    ("ICD10", "C51", "C51 Malignant neoplasm of vulva", "kg72V67KDhf"),
    ("ICD10", "C51.0", "C51.0 Malignant neoplasm: Labium majus", "XlvC6jzWN37"),
    ("ICD10", "C51.1", "C51.1 Malignant neoplasm: Labium minus", "S1ejmJ5EmdJ"),
    ("ICD10", "C51.2", "C51.2 Malignant neoplasm: Clitoris", "vim88NsIuHf"),
    ("ICD10", "C51.8", "C51.8 Malignant neoplasm: Overlapping lesion of vulva", "NpGsgkvB8Tx"),
    ("ICD10", "C51.9", "C51.9 Malignant neoplasm: Vulva, unspecified", "m89DTl1SIcw"),
    ("ICD10", "C52", "C52 Malignant neoplasm of vagina", "UxyfgqOFPlb"),
    ("ICD10", "C53", "C53 Malignant neoplasm of cervix uteri", "GzoZrJxpD8w"),
    ("ICD10", "C53.0", "C53.0 Malignant neoplasm: Endocervix", "IDRBliagSeS"),
    ("ICD10", "C53.1", "C53.1 Malignant neoplasm: Exocervix", "tcvUJcwwSw8"),
    ("ICD10", "C53.8", "C53.8 Malignant neoplasm: Overlapping lesion of cervix uteri", "X0jIFsCme3Y"),
    ("ICD10", "C53.9", "C53.9 Malignant neoplasm: Cervix uteri, unspecified", "pl8NtrXmb3u"),
    ("ICD10", "C54", "C54 Malignant neoplasm of corpus uteri", "jQx31Zjih9G"),
    ("ICD10", "C54.0", "C54.0 Malignant neoplasm: Isthmus uteri", "P2ad427N4pk"),
    ("ICD10", "C54.1", "C54.1 Malignant neoplasm: Endometrium", "kXdc7V7t8Sl"),
    ("ICD10", "C54.2", "C54.2 Malignant neoplasm: Myometrium", "HfI8lZ0gKwZ"),
    ("ICD10", "C54.3", "C54.3 Malignant neoplasm: Fundus uteri", "FXFouutXJ8q"),
    ("ICD10", "C54.8", "C54.8 Malignant neoplasm: Overlapping lesion of corpus uteri", "ciXQsOSOjG0"),
    ("ICD10", "C54.9", "C54.9 Malignant neoplasm: Corpus uteri, unspecified", "V37zaWHVVyi"),
    ("ICD10", "C55", "C55 Malignant neoplasm of uterus, part unspecified", "jZgGcE6TWkJ"),
    ("ICD10", "C56", "C56 Malignant neoplasm of ovary", "Ay384jvSuXl"),
    ("ICD10", "C57", "C57 Malignant neoplasm of other and unspecified female genital organs", "r7Eigb3mUd1"),
    ("ICD10", "C57.0", "C57.0 Malignant neoplasm: Fallopian tube", "rOA3TjZ7wR3"),
    ("ICD10", "C57.1", "C57.1 Malignant neoplasm: Broad ligament", "Nbf9Wh4qGUi"),
    ("ICD10", "C57.2", "C57.2 Malignant neoplasm: Round ligament", "NhBqqtfebr4"),
    ("ICD10", "C57.3", "C57.3 Malignant neoplasm: Parametrium", "RGuwG5RwJyh"),
    ("ICD10", "C57.4", "C57.4 Malignant neoplasm: Uterine adnexa, unspecified", "bhzdaGqKTym"),
    ("ICD10", "C57.7", "C57.7 Malignant neoplasm: Other specified female genital organs", "a808Ssu9w8M"),
    ("ICD10", "C57.8", "C57.8 Malignant neoplasm: Overlapping lesion of female genital organs", "ijR11LHFtqa"),
    ("ICD10", "C57.9", "C57.9 Malignant neoplasm: Female genital organ, unspecified", "bFtiNFouul7"),
    ("ICD10", "C58", "C58 Malignant neoplasm of placenta", "jMplcogMOyH"),
    ("ICD10", "C60", "C60 Malignant neoplasm of penis", "yMku4WxEaQL"),
    ("ICD10", "C60.0", "C60.0 Malignant neoplasm: Prepuce", "uEwNw4KpwDx"),
    ("ICD10", "C60.1", "C60.1 Malignant neoplasm: Glans penis", "XVTzbi70Ktq"),
    ("ICD10", "C60.2", "C60.2 Malignant neoplasm: Body of penis", "qcYkzdLrKBL"),
    ("ICD10", "C60.8", "C60.8 Malignant neoplasm: Overlapping lesion of penis", "juT3ZLVhBhY"),
    ("ICD10", "C60.9", "C60.9 Malignant neoplasm: Penis, unspecified", "ShZQBkhkNno"),
    ("ICD10", "C61", "C61 Malignant neoplasm of prostate", "osJTq28X3OU"),
    ("ICD10", "C62", "C62 Malignant neoplasm of testis", "jcuSNC1xs72"),
    ("ICD10", "C62.0", "C62.0 Malignant neoplasm: Undescended testis", "xz6v89aZRSf"),
    ("ICD10", "C62.1", "C62.1 Malignant neoplasm: Descended testis", "nOeC9kAVCUZ"),
    ("ICD10", "C62.9", "C62.9 Malignant neoplasm: Testis, unspecified", "RhGijSWsxLW"),
    ("ICD10", "C63", "C63 Malignant neoplasm of other and unspecified male genital organs", "emasB4XLrRd"),
    ("ICD10", "C63.0", "C63.0 Malignant neoplasm: Epididymis", "gg1pDD0CYY3"),
    ("ICD10", "C63.1", "C63.1 Malignant neoplasm: Spermatic cord", "V6O9xKQlqrk"),
    ("ICD10", "C63.2", "C63.2 Malignant neoplasm: Scrotum", "dEuEf6RnXwP"),
    ("ICD10", "C63.7", "C63.7 Malignant neoplasm: Other specified male genital organs", "NMqxfzDqKFy"),
    ("ICD10", "C63.8", "C63.8 Malignant neoplasm: Overlapping lesion of male genital organs", "CHNvIwwdeH0"),
    ("ICD10", "C63.9", "C63.9 Malignant neoplasm: Male genital organ, unspecified", "bUvWVeb7DLw"),
    ("ICD10", "C64", "C64 Malignant neoplasm of kidney, except renal pelvis", "UbAdwtAe0gH"),
    ("ICD10", "C65", "C65 Malignant neoplasm of renal pelvis", "TCMI0VBaLip"),
    ("ICD10", "C66", "C66 Malignant neoplasm of ureter", "nhC7DagBd3m"),
    ("ICD10", "C67", "C67 Malignant neoplasm of bladder", "Ldz5Jgb2TBr"),
    ("ICD10", "C67.0", "C67.0 Malignant neoplasm: Trigone of bladder", "EoskkL91YMj"),
    ("ICD10", "C67.1", "C67.1 Malignant neoplasm: Dome of bladder", "qwlokM8RwJG"),
    ("ICD10", "C67.2", "C67.2 Malignant neoplasm: Lateral wall of bladder", "p4KFnCJAYNq"),
    ("ICD10", "C67.3", "C67.3 Malignant neoplasm: Anterior wall of bladder", "n2RoHc5g7A0"),
    ("ICD10", "C67.4", "C67.4 Malignant neoplasm: Posterior wall of bladder", "PQNhY3uBMSe"),
    ("ICD10", "C67.5", "C67.5 Malignant neoplasm: Bladder neck", "YUeSPuPCWTZ"),
    ("ICD10", "C67.6", "C67.6 Malignant neoplasm: Ureteric orifice", "OSC0BercFc9"),
    ("ICD10", "C67.7", "C67.7 Malignant neoplasm: Urachus", "qa6pBsJUfZY"),
    ("ICD10", "C67.8", "C67.8 Malignant neoplasm: Overlapping lesion of bladder", "ZLJBlSFqwEW"),
    ("ICD10", "C67.9", "C67.9 Malignant neoplasm: Bladder, unspecified", "ZFFw6ofA91x"),
    ("ICD10", "C68", "C68 Malignant neoplasm of other and unspecified urinary organs", "uYLngITUsDr"),
    ("ICD10", "C68.0", "C68.0 Malignant neoplasm: Urethra", "CYG7Lif22mU"),
    ("ICD10", "C68.1", "C68.1 Malignant neoplasm: Paraurethral gland", "Ln2BMQlTbdW"),
    ("ICD10", "C68.8", "C68.8 Malignant neoplasm: Overlapping lesion of urinary organs", "bnHQqVciqpt"),
    ("ICD10", "C68.9", "C68.9 Malignant neoplasm: Urinary organ, unspecified", "ZJrXGvmizLW"),
    ("ICD10", "C69", "C69 Malignant neoplasm of eye and adnexa", "rQ0FprAmkVg"),
    ("ICD10", "C69.0", "C69.0 Malignant neoplasm: Conjunctiva", "Vy91okHXy4I"),
    ("ICD10", "C69.1", "C69.1 Malignant neoplasm: Cornea", "syzJmMp5dX9"),
    ("ICD10", "C69.2", "C69.2 Malignant neoplasm: Retina", "JPyQFvFq5ir"),
    ("ICD10", "C69.3", "C69.3 Malignant neoplasm: Choroid", "xh6t81FHieJ"),
    ("ICD10", "C69.4", "C69.4 Malignant neoplasm: Ciliary body", "J8BxOXdHTgi"),
    ("ICD10", "C69.5", "C69.5 Malignant neoplasm: Lacrimal gland and duct", "sab4vie2TQx"),
    ("ICD10", "C69.6", "C69.6 Malignant neoplasm: Orbit", "RLE76LxwD6l"),
    ("ICD10", "C69.8", "C69.8 Malignant neoplasm: Overlapping lesion of eye and adnexa", "dNtvZPHIVbD"),
    ("ICD10", "C69.9", "C69.9 Malignant neoplasm: Eye, unspecified", "ZuBNmDvu3nC"),
    ("ICD10", "C70", "C70 Malignant neoplasm of meninges", "YXN5YC9DfKu"),
    ("ICD10", "C70.0", "C70.0 Malignant neoplasm: Cerebral meninges", "xB0J9GqIacL"),
    ("ICD10", "C70.1", "C70.1 Malignant neoplasm: Spinal meninges", "DeW1FcfEns6"),
    ("ICD10", "C70.9", "C70.9 Malignant neoplasm: Meninges, unspecified", "Udmw9YMb4qs"),
    ("ICD10", "C71", "C71 Malignant neoplasm of brain", "DjdJw8IHJxx"),
    ("ICD10", "C71.0", "C71.0 Malignant neoplasm: Cerebrum, except lobes and ventricles", "rT40YaNL1uM"),
    ("ICD10", "C71.1", "C71.1 Malignant neoplasm: Frontal lobe", "glqT5eWsSk7"),
    ("ICD10", "C71.2", "C71.2 Malignant neoplasm: Temporal lobe", "XwCIfSRR4OJ"),
    ("ICD10", "C71.3", "C71.3 Malignant neoplasm: Parietal lobe", "KkWCS3pxnka"),
    ("ICD10", "C71.4", "C71.4 Malignant neoplasm: Occipital lobe", "hkbPcK2rxyy"),
    ("ICD10", "C71.5", "C71.5 Malignant neoplasm: Cerebral ventricle", "XWXoQPXLmrn"),
    ("ICD10", "C71.6", "C71.6 Malignant neoplasm: Cerebellum", "FX7lXR43zws"),
    ("ICD10", "C71.7", "C71.7 Malignant neoplasm: Brain stem", "qbhug0hoXle"),
    ("ICD10", "C71.8", "C71.8 Malignant neoplasm: Overlapping lesion of brain", "RZ0kPWMAnrG"),
    ("ICD10", "C71.9", "C71.9 Malignant neoplasm: Brain, unspecified", "guBfsnlmCL9"),
    ("ICD10", "C72", "C72 Malignant neoplasm of spinal cord, cranial nerves and other parts of central nervous system", "hZdn1u6IWaA"),
    ("ICD10", "C72.0", "C72.0 Malignant neoplasm: Spinal cord", "m5SsdxJdDGu"),
    ("ICD10", "C72.1", "C72.1 Malignant neoplasm: Cauda equina", "qQUbqkWCZJW"),
    ("ICD10", "C72.2", "C72.2 Malignant neoplasm: Olfactory nerve", "T8swwuqJBhM"),
    ("ICD10", "C72.3", "C72.3 Malignant neoplasm: Optic nerve", "oIjfwhdoqMa"),
    ("ICD10", "C72.4", "C72.4 Malignant neoplasm: Acoustic nerve", "E39GMmLAVXS"),
    ("ICD10", "C72.5", "C72.5 Malignant neoplasm: Other and unspecified cranial nerves", "cUYXZgMO13R"),
    ("ICD10", "C72.8", "C72.8 Malignant neoplasm: Overlapping lesion of brain and other parts of central nervous system", "AWLhjk8F5Nc"),
    ("ICD10", "C72.9", "C72.9 Malignant neoplasm: Central nervous system, unspecified", "kkk0aGvFiG3"),
    ("ICD10", "C73", "C73 Malignant neoplasm of thyroid gland", "mNPb4oz4dSr"),
    ("ICD10", "C74", "C74 Malignant neoplasm of adrenal gland", "PyqlyTszUX2"),
    ("ICD10", "C74.0", "C74.0 Malignant neoplasm: Cortex of adrenal gland", "DNJWfDjeyhe"),
    ("ICD10", "C74.1", "C74.1 Malignant neoplasm: Medulla of adrenal gland", "Wi8zzStGlJ8"),
    ("ICD10", "C74.9", "C74.9 Malignant neoplasm: Adrenal gland, unspecified", "UTnbXg9sLAt"),
    ("ICD10", "C75", "C75 Malignant neoplasm of other endocrine glands and related structures", "cU4QarpDhgk");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "C75.0", "C75.0 Malignant neoplasm: Parathyroid gland", "Eh0QANs9ZPE"),
    ("ICD10", "C75.1", "C75.1 Malignant neoplasm: Pituitary gland", "NeVUAsV5mxZ"),
    ("ICD10", "C75.2", "C75.2 Malignant neoplasm: Craniopharyngeal duct", "V9kdptocact"),
    ("ICD10", "C75.3", "C75.3 Malignant neoplasm: Pineal gland", "xpJx2rb5PgC"),
    ("ICD10", "C75.4", "C75.4 Malignant neoplasm: Carotid body", "czohHAmeZx4"),
    ("ICD10", "C75.5", "C75.5 Malignant neoplasm: Aortic body and other paraganglia", "Q0DkFrmLQtf"),
    ("ICD10", "C75.8", "C75.8 Malignant neoplasm: Pluriglandular involvement, unspecified", "jHlzDuYqDFK"),
    ("ICD10", "C75.9", "C75.9 Malignant neoplasm: Endocrine gland, unspecified", "CFhml0E3VyE"),
    ("ICD10", "C76", "C76 Malignant neoplasm of other and ill-defined sites", "E7eWTXWlQ0L"),
    ("ICD10", "C76.0", "C76.0 Malignant neoplasm of other and ill-defined sites: Head, face and neck", "YEGj66TK5O2"),
    ("ICD10", "C76.1", "C76.1 Malignant neoplasm of other and ill-defined sites: Thorax", "hw0X1e1vGM4"),
    ("ICD10", "C76.2", "C76.2 Malignant neoplasm of other and ill-defined sites: Abdomen", "RCLvlBrpGFG"),
    ("ICD10", "C76.3", "C76.3 Malignant neoplasm of other and ill-defined sites: Pelvis", "LmG7YLaIpsF"),
    ("ICD10", "C76.4", "C76.4 Malignant neoplasm of other and ill-defined sites: Upper limb", "gOIAvwfp2b8"),
    ("ICD10", "C76.5", "C76.5 Malignant neoplasm of other and ill-defined sites: Lower limb", "wi4QVLgCmkS"),
    ("ICD10", "C76.7", "C76.7 Malignant neoplasm of other and ill-defined sites: Other ill-defined sites", "tk2gBeJChrl"),
    ("ICD10", "C76.8", "C76.8 Malignant neoplasm of other and ill-defined sites: Overlapping lesion of other and ill-defined sites", "Y7ErxcMwWbV"),
    ("ICD10", "C77", "C77 Secondary and unspecified malignant neoplasm of lymph nodes", "QDahDaFUxNi"),
    ("ICD10", "C77.0", "C77.0 Secondary and unspecified malignant neoplasm: Lymph nodes of head, face and neck", "rAYNDa251l6"),
    ("ICD10", "C77.1", "C77.1 Secondary and unspecified malignant neoplasm: Intrathoracic lymph nodes", "B4c12wseoya"),
    ("ICD10", "C77.2", "C77.2 Secondary and unspecified malignant neoplasm: Intra-abdominal lymph nodes", "iIDvy2gjwwr"),
    ("ICD10", "C77.3", "C77.3 Secondary and unspecified malignant neoplasm: Axillary and upper limb lymph nodes", "yxUuunnnWb7"),
    ("ICD10", "C77.4", "C77.4 Secondary and unspecified malignant neoplasm: Inguinal and lower limb lymph nodes", "eRsmEaCdgAA"),
    ("ICD10", "C77.5", "C77.5 Secondary and unspecified malignant neoplasm: Intrapelvic lymph nodes", "Rjywgphh2Lk"),
    ("ICD10", "C77.8", "C77.8 Secondary and unspecified malignant neoplasm: Lymph nodes of multiple regions", "oH5S6n6jg2J"),
    ("ICD10", "C77.9", "C77.9 Secondary and unspecified malignant neoplasm: Lymph node, unspecified", "KngFa0wUD72"),
    ("ICD10", "C78", "C78 Secondary malignant neoplasm of respiratory and digestive organs", "UqkC13Q61eN"),
    ("ICD10", "C78.0", "C78.0 Secondary malignant neoplasm of lung", "DUsrJ0SRe6O"),
    ("ICD10", "C78.1", "C78.1 Secondary malignant neoplasm of mediastinum", "UP40nkhpfVm"),
    ("ICD10", "C78.2", "C78.2 Secondary malignant neoplasm of pleura", "CEF6vETFzfQ"),
    ("ICD10", "C78.3", "C78.3 Secondary malignant neoplasm of other and unspecified respiratory organs", "CjQxouB0lDp"),
    ("ICD10", "C78.4", "C78.4 Secondary malignant neoplasm of small intestine", "PAuk2t8UADh"),
    ("ICD10", "C78.5", "C78.5 Secondary malignant neoplasm of large intestine and rectum", "cXDi8pDjA57"),
    ("ICD10", "C78.6", "C78.6 Secondary malignant neoplasm of retroperitoneum and peritoneum", "ciH4X37IrYA"),
    ("ICD10", "C78.7", "C78.7 Secondary malignant neoplasm of liver and intrahepatic bile duct", "D6CcWw7NiTW"),
    ("ICD10", "C78.8", "C78.8 Secondary malignant neoplasm of other and unspecified digestive organs", "jSaa5ckIxFX"),
    ("ICD10", "C79", "C79 Secondary malignant neoplasm of other and unspecified sites", "nrHJDPavtAO"),
    ("ICD10", "C79.0", "C79.0 Secondary malignant neoplasm of kidney and renal pelvis", "OY2gw3DL1p7"),
    ("ICD10", "C79.1", "C79.1 Secondary malignant neoplasm of bladder and other and unspecified urinary organs", "ZoDEx3oyKVX"),
    ("ICD10", "C79.2", "C79.2 Secondary malignant neoplasm of skin", "OHztA7r87Uu"),
    ("ICD10", "C79.3", "C79.3 Secondary malignant neoplasm of brain and cerebral meninges", "kTAWCguOR6Q"),
    ("ICD10", "C79.4", "C79.4 Secondary malignant neoplasm of other and unspecified parts of nervous system", "g4njwJqbcWM"),
    ("ICD10", "C79.5", "C79.5 Secondary malignant neoplasm of bone and bone marrow", "EZoD0w152uO"),
    ("ICD10", "C79.6", "C79.6 Secondary malignant neoplasm of ovary", "FKyKqjdTxji"),
    ("ICD10", "C79.7", "C79.7 Secondary malignant neoplasm of adrenal gland", "Q3pST1Wk4yD"),
    ("ICD10", "C79.8", "C79.8 Secondary malignant neoplasm of other specified sites", "UohC6nX07HE"),
    ("ICD10", "C79.9", "C79.9 Secondary malignant neoplasm, unspecified site", "KM1jH4UjbW9"),
    ("ICD10", "C80", "C80 Malignant neoplasm, without specification of site", "VLXEsb68Z2a"),
    ("ICD10", "C80.0", "C80.0 Malignant neoplasm, primary site unknown, so stated", "TSuXKCZdvlx"),
    ("ICD10", "C80.9", "C80.9 Malignant neoplasm, primary site unspecified", "ih9yubv33rR"),
    ("ICD10", "C81", "C81 Hodgkin lymphoma", "K1BQNjSZoHW"),
    ("ICD10", "C81.0", "C81.0 Nodular lymphocyte predominant Hodgkin lymphoma", "X0yV1xCuktC"),
    ("ICD10", "C81.1", "C81.1 Nodular sclerosis classical Hodgkin lymphoma", "vBsQejy5ZiN"),
    ("ICD10", "C81.2", "C81.2 Mixed cellularity classical Hodgkin lymphoma", "vp3XasA8ty3"),
    ("ICD10", "C81.3", "C81.3 Lymphocyte depleted classical Hodgkin lymphoma", "wJdlz3vQgnW"),
    ("ICD10", "C81.4", "C81.4 Lymphocyte-rich (classical) Hodgkin lymphoma", "AnEHKLymYGp"),
    ("ICD10", "C81.7", "C81.7 Other classical Hodgkin lymphoma", "V1hPd9LyZE1"),
    ("ICD10", "C81.9", "C81.9 Hodgkin lymphoma, unspecified", "uFgV6GPkJOq"),
    ("ICD10", "C82", "C82 Follicular lymphoma", "kcFDkh7kC2I"),
    ("ICD10", "C82.0", "C82.0 Follicular lymphoma grade I", "vk1JfXgdC3v"),
    ("ICD10", "C82.1", "C82.1 Follicular lymphoma grade II", "fxnnGjB0jwl"),
    ("ICD10", "C82.2", "C82.2 Follicular lymphoma grade III, unspecified", "cpYnyz3eGBn"),
    ("ICD10", "C82.3", "C82.3 Follicular lymphoma grade IIIa", "R0nie24OZPL"),
    ("ICD10", "C82.4", "C82.4 Follicular lymphoma grade IIIb", "KyR7AMmxiKa"),
    ("ICD10", "C82.5", "C82.5 Diffuse follicle centre lymphoma", "J1twIaz8CAS"),
    ("ICD10", "C82.6", "C82.6 Cutaneous follicle centre lymphoma", "xPESkweyRGh"),
    ("ICD10", "C82.7", "C82.7 Other types of follicular lymphoma", "pyAiMTuXl2f"),
    ("ICD10", "C82.9", "C82.9 Follicular lymphoma, unspecified", "G2sRWr42RKC"),
    ("ICD10", "C83", "C83 Non-follicular lymphoma", "fCOguVIhRX6"),
    ("ICD10", "C83.0", "C83.0 Small cell B-cell lymphoma", "uUi0LMXz6ww"),
    ("ICD10", "C83.1", "C83.1 Mantle cell lymphoma", "ByqRbzRmrzU"),
    ("ICD10", "C83.3", "C83.3 Diffuse large B-cell lymphoma", "agHIAj6XIsf"),
    ("ICD10", "C83.5", "C83.5 Lymphoblastic (diffuse) lymphoma", "JiJTLvdIhv7"),
    ("ICD10", "C83.7", "C83.7 Burkitt lymphoma", "DnGyce3V31C"),
    ("ICD10", "C83.8", "C83.8 Other non-follicular lymphoma", "e6gsjXUHlBx"),
    ("ICD10", "C83.9", "C83.9 Non-follicular (diffuse) lymphoma, unspecified", "Rh3mRxihFlx"),
    ("ICD10", "C84", "C84 Mature T/NK-cell lymphomas", "P7X0gT00euA"),
    ("ICD10", "C84.0", "C84.0 Mycosis fungoides", "WysphQglbpD"),
    ("ICD10", "C84.1", "C84.1 Sézary disease", "CY1jldp7fEj"),
    ("ICD10", "C84.4", "C84.4 Peripheral T-cell lymphoma, not elsewhere classified", "suVCae0LpOI"),
    ("ICD10", "C84.5", "C84.5 Other mature T/NK-cell lymphomas", "a5noyr1cIN8"),
    ("ICD10", "C84.6", "C84.6 Anaplastic large cell lymphoma, ALK-positive", "l1u8sWEq1nu"),
    ("ICD10", "C84.7", "C84.7 Anaplastic large cell lymphoma, ALK-negative", "mfbtF5M2kjn"),
    ("ICD10", "C84.8", "C84.8 Cutaneous T-cell lymphoma, unspecified", "syCxtIAZ9Ke"),
    ("ICD10", "C84.9", "C84.9 Mature T/NK-cell lymphoma, unspecified", "OgT0fTIoSqv"),
    ("ICD10", "C85", "C85 Other and unspecified types of non-Hodgkin lymphoma", "JiDo8mVrgU2"),
    ("ICD10", "C85.1", "C85.1 B-cell lymphoma, unspecified", "LLbpG9VjoMc"),
    ("ICD10", "C85.2", "C85.2 Mediastinal (thymic) large B-cell lymphoma", "UYYbYcrH4MU"),
    ("ICD10", "C85.7", "C85.7 Other specified types of non-Hodgkin lymphoma", "V0in3EMI2Wc"),
    ("ICD10", "C85.9", "C85.9 Non-Hodgkin lymphoma, unspecified", "A2ZaMIkjtuj"),
    ("ICD10", "C86", "C86 Other specified types of T/NK-cell lymphoma", "O5S9GTKSNRZ"),
    ("ICD10", "C86.0", "C86.0 Extranodal NK/T-cell lymphoma, nasal type", "yA3OhfXtTSV"),
    ("ICD10", "C86.1", "C86.1 Hepatosplenic T-cell lymphoma", "wQjcPbERFyr"),
    ("ICD10", "C86.2", "C86.2 Enteropathy-type (intestinal) T-cell lymphoma", "WcMD80eEdeO"),
    ("ICD10", "C86.3", "C86.3 Subcutaneous panniculitis-like T-cell lymphoma", "QRZDiZmfpxJ"),
    ("ICD10", "C86.4", "C86.4 Blastic NK-cell lymphoma", "CwQzzcDMS0x"),
    ("ICD10", "C86.5", "C86.5 Angioimmunoblastic T-cell lymphoma", "AXIYRoSj8zq"),
    ("ICD10", "C86.6", "C86.6 Primary cutaneous CD30-positive T-cell proliferations", "X0bvUaT8F6w"),
    ("ICD10", "C88", "C88 Malignant immunoproliferative diseases", "DGUCCy7OOip"),
    ("ICD10", "C88.0", "C88.0 Waldenström macroglobulinaemia", "FwwZ66yy4rW"),
    ("ICD10", "C88.2", "C88.2 Other heavy chain disease", "XB9k8Y1ciHq"),
    ("ICD10", "C88.3", "C88.3 Immunoproliferative small intestinal disease", "rSJPxv77Tx3"),
    ("ICD10", "C88.4", "C88.4 Extranodal marginal zone B-cell lymphoma of mucosa-associated lymphoid tissue [MALT-lyphoma]", "tKY5OwzsPzR"),
    ("ICD10", "C88.7", "C88.7 Other malignant immunoproliferative diseases", "MnYgmHcXuAh"),
    ("ICD10", "C88.9", "C88.9 Malignant immunoproliferative disease, unspecified", "KKI09wTCL2H"),
    ("ICD10", "C90", "C90 Multiple myeloma and malignant plasma cell neoplasms", "gY7qWpKjvf7"),
    ("ICD10", "C90.0", "C90.0 Multiple myeloma", "h6MsHT9sibF"),
    ("ICD10", "C90.1", "C90.1 Plasma cell leukaemia", "zpK7Xj5nZlu"),
    ("ICD10", "C90.2", "C90.2 Extramedullary plasmacytoma", "py0ULK9UcUE"),
    ("ICD10", "C90.3", "C90.3 Solitary plasmacytoma", "Dw4PG68XkHa"),
    ("ICD10", "C91", "C91 Lymphoid leukaemia", "cOWPUePECBw"),
    ("ICD10", "C91.0", "C91.0 Acute lymphoblastic leukaemia [ALL]", "yHPNuMSBBU0"),
    ("ICD10", "C91.1", "C91.1 Chronic lymphocytic leukaemia of B-cell type", "BkTfWARQHoj"),
    ("ICD10", "C91.3", "C91.3 Prolymphocytic leukaemia of B-cell type", "e48K9vWDeeH"),
    ("ICD10", "C91.4", "C91.4 Hairy-cell leukaemia", "zq89VXgQe9Q"),
    ("ICD10", "C91.5", "C91.5 Adult T-cell lymphoma/leukaemia [HTLV-1-associated]", "UydXrpA6nCi"),
    ("ICD10", "C91.6", "C91.6 Prolymphocytic leukaemia of T-cell type", "qzBdIXhMIh1"),
    ("ICD10", "C91.7", "C91.7 Other lymphoid leukaemia", "fZycZA2umq7"),
    ("ICD10", "C91.8", "C91.8 Mature B-cell leukaemia Burkitt-type", "vIyOHi7pp8W"),
    ("ICD10", "C91.9", "C91.9 Lymphoid leukaemia, unspecified", "rEHM4eAC8aA"),
    ("ICD10", "C92", "C92 Myeloid leukaemia", "XdeLgaJS50k"),
    ("ICD10", "C92.0", "C92.0 Acute myeloblastic leukaemia [AML]", "tnidJ1QgGE9"),
    ("ICD10", "C92.1", "C92.1 Chronic myeloid leukaemia [CML], BCR/ABL-positive", "M0U9aUd0lm7"),
    ("ICD10", "C92.2", "C92.2 Atypical chronic myeloid leukaemia, BCR/ABL- negative", "KAY0RTWI0r5"),
    ("ICD10", "C92.3", "C92.3 Myeloid sarcoma", "eBkA089oV2L"),
    ("ICD10", "C92.4", "C92.4 Acute promyelocytic leukaemia [PML]", "edmiUXuFu86"),
    ("ICD10", "C92.5", "C92.5 Acute myelomonocytic leukaemia", "VPvV6Zf5yrf"),
    ("ICD10", "C92.6", "C92.6 Acute myeloid leukaemia with 11q23-abnormality", "sID3219CJmr"),
    ("ICD10", "C92.7", "C92.7 Other myeloid leukaemia", "PUTq4oHcEJr"),
    ("ICD10", "C92.8", "C92.8 Acute myeloid leukaemia with multilineage dysplasia", "amgCDhrc13S"),
    ("ICD10", "C92.9", "C92.9 Myeloid leukaemia, unspecified", "lS4jPeULAFu"),
    ("ICD10", "C93", "C93 Monocytic leukaemia", "c0QlGUacyUE"),
    ("ICD10", "C93.0", "C93.0 Acute monoblastic/monocytic leukaemia", "D8mi9ix5XeB"),
    ("ICD10", "C93.1", "C93.1 Chronic myelomonocytic leukaemia", "X2kWik9hZFX"),
    ("ICD10", "C93.3", "C93.3 Juvenile myelomonocytic leukaemia", "mRV6HW9E12t"),
    ("ICD10", "C93.7", "C93.7 Other monocytic leukaemia", "HLYLgCEHJIn"),
    ("ICD10", "C93.9", "C93.9 Monocytic leukaemia, unspecified", "pnapAokOxRA"),
    ("ICD10", "C94", "C94 Other leukaemias of specified cell type", "kQPW9rcd8wL"),
    ("ICD10", "C94.0", "C94.0 Acute erythroid leukaemia", "xgS2Fu8ryBE"),
    ("ICD10", "C94.2", "C94.2 Acute megakaryoblastic leukaemia", "bUX6auGQqhZ"),
    ("ICD10", "C94.3", "C94.3 Mast cell leukaemia", "bLYnZWYRCJw"),
    ("ICD10", "C94.4", "C94.4 Acute panmyelosis with myelofibrosis", "RyY4X97DYUr"),
    ("ICD10", "C94.6", "C94.6 Myelodysplastic and myeloproliferative disease, not elsewhere classified", "Tej11Qt92ti"),
    ("ICD10", "C94.7", "C94.7 Other specified leukaemias", "nGjci6Jh2px"),
    ("ICD10", "C95", "C95 Leukaemia of unspecified cell type", "ZSfXpvYu7yb"),
    ("ICD10", "C95.0", "C95.0 Acute leukaemia of unspecified cell type", "H9QsqjacEWj"),
    ("ICD10", "C95.1", "C95.1 Chronic leukaemia of unspecified cell type", "CbiV95VuR27"),
    ("ICD10", "C95.7", "C95.7 Other leukaemia of unspecified cell type", "unmiWg69VjZ"),
    ("ICD10", "C95.9", "C95.9 Leukaemia, unspecified", "fuKxTR2zweS"),
    ("ICD10", "C96", "C96 Other and unspecified malignant neoplasms of lymphoid, haematopoietic and related tissue", "WgZRFmn5930"),
    ("ICD10", "C96.0", "C96.0 Multifocal and multisystemic (disseminated) Langerhans-cell histiocytosis [Letterer-Siwe disease]", "VJX7KnF8tQe"),
    ("ICD10", "C96.2", "C96.2 Malignant mast cell tumour", "r4aqLSP5azq"),
    ("ICD10", "C96.4", "C96.4 Sarcoma of dendritic cells (accessory cells)", "HPYODHSipXW"),
    ("ICD10", "C96.5", "C96.5 Multifocal and unisystemic Langerhans-cell histiocytosis", "iD2sLAWXrES"),
    ("ICD10", "C96.6", "C96.6 Unifocal Langerhans-cell histiocytosis", "A9k6R1fdMZb"),
    ("ICD10", "C96.7", "C96.7 Other specified malignant neoplasms of lymphoid, haematopoietic and related tissue", "vIEbirWfaBz"),
    ("ICD10", "C96.8", "C96.8 Histiocytic sarcoma", "fEwQJKZ5mGj"),
    ("ICD10", "C96.9", "C96.9 Malignant neoplasm of lymphoid, haematopoietic and related tissue, unspecified", "iCKSxu2XLGx"),
    ("ICD10", "C97", "C97 Malignant neoplasms of independent (primary) multiple sites", "FCNnu7Im4OM");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "D00", "D00 Carcinoma in situ of oral cavity, oesophagus and stomach", "nHYsBTLycba"),
    ("ICD10", "D00.0", "D00.0 Carcinoma in situ: Lip, oral cavity and pharynx", "DWGDQLYON9b"),
    ("ICD10", "D00.1", "D00.1 Carcinoma in situ: Oesophagus", "hsKLzeqWQ5R"),
    ("ICD10", "D00.2", "D00.2 Carcinoma in situ: Stomach", "w4zuTItgXVp"),
    ("ICD10", "D01", "D01 Carcinoma in situ of other and unspecified digestive organs", "umycxBbOoiR"),
    ("ICD10", "D01.0", "D01.0 Carcinoma in situ: Colon", "I9yZiOOVckx"),
    ("ICD10", "D01.1", "D01.1 Carcinoma in situ: Rectosigmoid junction", "xCAZz9irjYa"),
    ("ICD10", "D01.2", "D01.2 Carcinoma in situ: Rectum", "D8jyUKV8FhY"),
    ("ICD10", "D01.3", "D01.3 Carcinoma in situ: Anus and anal canal", "PoMU4xinoLz"),
    ("ICD10", "D01.4", "D01.4 Carcinoma in situ: Other and unspecified parts of intestine", "FB4Zv9YGggB"),
    ("ICD10", "D01.5", "D01.5 Carcinoma in situ: Liver, gallbladder and bile ducts", "Jnvxp7DI3cp"),
    ("ICD10", "D01.7", "D01.7 Carcinoma in situ: Other specified digestive organs", "EaQp4kQ9mqE"),
    ("ICD10", "D01.9", "D01.9 Carcinoma in situ: Digestive organ, unspecified", "lMZPcthH7Qa"),
    ("ICD10", "D02", "D02 Carcinoma in situ of middle ear and respiratory system", "JYLcvLtnS6o"),
    ("ICD10", "D02.0", "D02.0 Carcinoma in situ: Larynx", "rHHcW3wmB7v"),
    ("ICD10", "D02.1", "D02.1 Carcinoma in situ: Trachea", "uuZFnKZ2JVh"),
    ("ICD10", "D02.2", "D02.2 Carcinoma in situ: Bronchus and lung", "jqFK5O857ZN"),
    ("ICD10", "D02.3", "D02.3 Carcinoma in situ: Other parts of respiratory system", "aFXBPHOYwBl"),
    ("ICD10", "D02.4", "D02.4 Carcinoma in situ: Respiratory system, unspecified", "O2fnRmW9LSs"),
    ("ICD10", "D03", "D03 Melanoma in situ", "ol3DcgOQnXg"),
    ("ICD10", "D03.0", "D03.0 Melanoma in situ of lip", "VytxzgfmsQc"),
    ("ICD10", "D03.1", "D03.1 Melanoma in situ of eyelid, including canthus", "Fng6NDD0kdT"),
    ("ICD10", "D03.2", "D03.2 Melanoma in situ of ear and external auricular canal", "QW6MLTJ4rUq"),
    ("ICD10", "D03.3", "D03.3 Melanoma in situ of other and unspecified parts of face", "l7ACuLDoBW8"),
    ("ICD10", "D03.4", "D03.4 Melanoma in situ of scalp and neck", "JaQxowNv9LR"),
    ("ICD10", "D03.5", "D03.5 Melanoma in situ of trunk", "FTyMSZ3hv7M"),
    ("ICD10", "D03.6", "D03.6 Melanoma in situ of upper limb, including shoulder", "WfPMvfQ3ueV"),
    ("ICD10", "D03.7", "D03.7 Melanoma in situ of lower limb, including hip", "Q8xcOGIdoVf"),
    ("ICD10", "D03.8", "D03.8 Melanoma in situ of other sites", "VPGn7A2i07S"),
    ("ICD10", "D03.9", "D03.9 Melanoma in situ, unspecified", "tY2QN3PAprT"),
    ("ICD10", "D04", "D04 Carcinoma in situ of skin", "SK81NOF7zaK"),
    ("ICD10", "D04.0", "D04.0 Carcinoma in situ: Skin of lip", "lpqdDx3teH5"),
    ("ICD10", "D04.1", "D04.1 Carcinoma in situ: Skin of eyelid, including canthus", "o449l3JFhy5"),
    ("ICD10", "D04.2", "D04.2 Carcinoma in situ: Skin of ear and external auricular canal", "mIxryQiRSJN"),
    ("ICD10", "D04.3", "D04.3 Carcinoma in situ: Skin of other and unspecified parts of face", "VB8L19FgGVw"),
    ("ICD10", "D04.4", "D04.4 Carcinoma in situ: Skin of scalp and neck", "mSC5YS75ywP"),
    ("ICD10", "D04.5", "D04.5 Carcinoma in situ: Skin of trunk", "MdD00vU3xMg"),
    ("ICD10", "D04.6", "D04.6 Carcinoma in situ: Skin of upper limb, including shoulder", "WMnN1q8vMKj"),
    ("ICD10", "D04.7", "D04.7 Carcinoma in situ: Skin of lower limb, including hip", "sOtbARR5veL"),
    ("ICD10", "D04.8", "D04.8 Carcinoma in situ: Skin of other sites", "Oe5NP44vu9d"),
    ("ICD10", "D04.9", "D04.9 Carcinoma in situ: Skin, unspecified", "C69unArgqoh"),
    ("ICD10", "D05", "D05 Carcinoma in situ of breast", "RSGJxLZ39aO"),
    ("ICD10", "D05.0", "D05.0 Lobular carcinoma in situ", "iDzAyXM5PPp"),
    ("ICD10", "D05.1", "D05.1 Intraductal carcinoma in situ", "cP62hw7NHKn"),
    ("ICD10", "D05.7", "D05.7 Other carcinoma in situ of breast", "Cz4tkxBJIwG"),
    ("ICD10", "D05.9", "D05.9 Carcinoma in situ of breast, unspecified", "Wo9oUcb6mZw"),
    ("ICD10", "D06", "D06 Carcinoma in situ of cervix uteri", "fL25FAbrXzR"),
    ("ICD10", "D06.0", "D06.0 Carcinoma in situ: Endocervix", "LJwb7s8HXkJ"),
    ("ICD10", "D06.1", "D06.1 Carcinoma in situ: Exocervix", "yy3dqpKBACR"),
    ("ICD10", "D06.7", "D06.7 Carcinoma in situ: Other parts of cervix", "SBgfCwvAdD7"),
    ("ICD10", "D06.9", "D06.9 Carcinoma in situ: Cervix, unspecified", "oWFPeqyKOia"),
    ("ICD10", "D07", "D07 Carcinoma in situ of other and unspecified genital organs", "ZLePeybgnI1"),
    ("ICD10", "D07.0", "D07.0 Carcinoma in situ: Endometrium", "IyOHQUNtuS3"),
    ("ICD10", "D07.1", "D07.1 Carcinoma in situ: Vulva", "ch7dSOajcqq"),
    ("ICD10", "D07.2", "D07.2 Carcinoma in situ: Vagina", "n42KOuJEeNY"),
    ("ICD10", "D07.3", "D07.3 Carcinoma in situ: Other and unspecified female genital organs", "fp2k6DI9pBS"),
    ("ICD10", "D07.4", "D07.4 Carcinoma in situ: Penis", "HKeSvR1VYhI"),
    ("ICD10", "D07.5", "D07.5 Carcinoma in situ: Prostate", "dg8ZnyCa23V"),
    ("ICD10", "D07.6", "D07.6 Carcinoma in situ: Other and unspecified male genital organs", "swnmrn3N4NY"),
    ("ICD10", "D09", "D09 Carcinoma in situ of other and unspecified sites", "dLdw2WY8sa5"),
    ("ICD10", "D09.0", "D09.0 Carcinoma in situ: Bladder", "yn2gdjjAbm3"),
    ("ICD10", "D09.1", "D09.1 Carcinoma in situ: Other and unspecified urinary organs", "naI7eUwuZ3f"),
    ("ICD10", "D09.2", "D09.2 Carcinoma in situ: Eye", "UxGW5Ztga1a"),
    ("ICD10", "D09.3", "D09.3 Carcinoma in situ: Thyroid and other endocrine glands", "aXWxa6k15sN"),
    ("ICD10", "D09.7", "D09.7 Carcinoma in situ of other specified sites", "d9YaZT74xqI"),
    ("ICD10", "D09.9", "D09.9 Carcinoma in situ, unspecified", "CLzMrjfgANj"),
    ("ICD10", "D10", "D10 Benign neoplasm of mouth and pharynx", "Zf6B1CN9gko"),
    ("ICD10", "D10.0", "D10.0 Benign neoplasm: Lip", "kUKUySvEG3J"),
    ("ICD10", "D10.1", "D10.1 Benign neoplasm: Tongue", "nQCr5wkZIUN"),
    ("ICD10", "D10.2", "D10.2 Benign neoplasm: Floor of mouth", "RsfBuQfIEja"),
    ("ICD10", "D10.3", "D10.3 Benign neoplasm: Other and unspecified parts of mouth", "tcFEOBIxhnK"),
    ("ICD10", "D10.4", "D10.4 Benign neoplasm: Tonsil", "x8CXHV7zOHP"),
    ("ICD10", "D10.5", "D10.5 Benign neoplasm: Other parts of oropharynx", "F0akCklNTg5"),
    ("ICD10", "D10.6", "D10.6 Benign neoplasm: Nasopharynx", "oE1yqDZaEea"),
    ("ICD10", "D10.7", "D10.7 Benign neoplasm: Hypopharynx", "awfQH5NoiSu"),
    ("ICD10", "D10.9", "D10.9 Benign neoplasm: Pharynx, unspecified", "fTxANPj3xo6"),
    ("ICD10", "D11", "D11 Benign neoplasm of major salivary glands", "uNWlCZsNNYy"),
    ("ICD10", "D11.0", "D11.0 Benign neoplasm: Parotid gland", "J1zPhQMbegL"),
    ("ICD10", "D11.7", "D11.7 Benign neoplasm: Other major salivary glands", "DI9XGRZThZF"),
    ("ICD10", "D11.9", "D11.9 Benign neoplasm: Major salivary gland, unspecified", "ta8tgYuP4dM"),
    ("ICD10", "D12", "D12 Benign neoplasm of colon, rectum, anus and anal canal", "l4zaqyrmq9R"),
    ("ICD10", "D12.0", "D12.0 Benign neoplasm: Caecum", "e56TjmmBL6C"),
    ("ICD10", "D12.1", "D12.1 Benign neoplasm: Appendix", "M6hDWh29gG7"),
    ("ICD10", "D12.2", "D12.2 Benign neoplasm: Ascending colon", "kj7m0zuvNZs"),
    ("ICD10", "D12.3", "D12.3 Benign neoplasm: Transverse colon", "XUUDtSLeurl"),
    ("ICD10", "D12.4", "D12.4 Benign neoplasm: Descending colon", "Y3NjJ1dNEei"),
    ("ICD10", "D12.5", "D12.5 Benign neoplasm: Sigmoid colon", "TRcnPxcc2vz"),
    ("ICD10", "D12.6", "D12.6 Benign neoplasm: Colon, unspecified", "qWR4Jq6vEFT"),
    ("ICD10", "D12.7", "D12.7 Benign neoplasm: Rectosigmoid junction", "e4honNCIr4P"),
    ("ICD10", "D12.8", "D12.8 Benign neoplasm: Rectum", "FQ5wFhjScqJ"),
    ("ICD10", "D12.9", "D12.9 Benign neoplasm: Anus and anal canal", "Rxya5Wjcv18"),
    ("ICD10", "D13", "D13 Benign neoplasm of other and ill-defined parts of digestive system", "XRaxvDeuXDX"),
    ("ICD10", "D13.0", "D13.0 Benign neoplasm: Oesophagus", "V5Tnepl5cTk"),
    ("ICD10", "D13.1", "D13.1 Benign neoplasm: Stomach", "yWMlDWNqygu"),
    ("ICD10", "D13.2", "D13.2 Benign neoplasm: Duodenum", "nbYsfcooHtQ"),
    ("ICD10", "D13.3", "D13.3 Benign neoplasm: Other and unspecified parts of small intestine", "m340uVXCTws"),
    ("ICD10", "D13.4", "D13.4 Benign neoplasm: Liver", "tZE55RwU6Ks"),
    ("ICD10", "D13.5", "D13.5 Benign neoplasm: Extrahepatic bile ducts", "isw49dOzixn"),
    ("ICD10", "D13.6", "D13.6 Benign neoplasm: Pancreas", "wIzwwe1FzR4"),
    ("ICD10", "D13.7", "D13.7 Benign neoplasm: Endocrine pancreas", "VwD8Gh18f2m"),
    ("ICD10", "D13.9", "D13.9 Benign neoplasm: Ill-defined sites within the digestive system", "D2zOQACfZ8g"),
    ("ICD10", "D14", "D14 Benign neoplasm of middle ear and respiratory system", "kyw76pzVT92"),
    ("ICD10", "D14.0", "D14.0 Benign neoplasm: Middle ear, nasal cavity and accessory sinuses", "CmyPCZJl84k"),
    ("ICD10", "D14.1", "D14.1 Benign neoplasm: Larynx", "tFpOOWGWp93"),
    ("ICD10", "D14.2", "D14.2 Benign neoplasm: Trachea", "lJoJ2Ke21e2"),
    ("ICD10", "D14.3", "D14.3 Benign neoplasm: Bronchus and lung", "FLNvuSKKQAn"),
    ("ICD10", "D14.4", "D14.4 Benign neoplasm: Respiratory system, unspecified", "AZGQahekji6"),
    ("ICD10", "D15", "D15 Benign neoplasm of other and unspecified intrathoracic organs", "Lcgsv1EkDD7"),
    ("ICD10", "D15.0", "D15.0 Benign neoplasm: Thymus", "YSFA2YeoC3w"),
    ("ICD10", "D15.1", "D15.1 Benign neoplasm: Heart", "wZ4AcSit28g"),
    ("ICD10", "D15.2", "D15.2 Benign neoplasm: Mediastinum", "tLfIbZqRyhb"),
    ("ICD10", "D15.7", "D15.7 Benign neoplasm: Other specified intrathoracic organs", "HNm8pBQHrVJ"),
    ("ICD10", "D15.9", "D15.9 Benign neoplasm: Intrathoracic organ, unspecified", "Y6MiXGLSgtP"),
    ("ICD10", "D16", "D16 Benign neoplasm of bone and articular cartilage", "Lo3sdNoibWR"),
    ("ICD10", "D16.0", "D16.0 Benign neoplasm: Scapula and long bones of upper limb", "hQe8f9bj5zv"),
    ("ICD10", "D16.1", "D16.1 Benign neoplasm: Short bones of upper limb", "ltg0v6lmn6f"),
    ("ICD10", "D16.2", "D16.2 Benign neoplasm: Long bones of lower limb", "ogM8rE7wI2s"),
    ("ICD10", "D16.3", "D16.3 Benign neoplasm: Short bones of lower limb", "Gj9gJqVsIBF"),
    ("ICD10", "D16.4", "D16.4 Benign neoplasm: Bones of skull and face", "SY9DrOCTlGe"),
    ("ICD10", "D16.5", "D16.5 Benign neoplasm: Lower jaw bone", "Ow5RMabMLAQ"),
    ("ICD10", "D16.6", "D16.6 Benign neoplasm: Vertebral column", "F7LyEpzFeIQ"),
    ("ICD10", "D16.7", "D16.7 Benign neoplasm: Ribs, sternum and clavicle", "VxR0vRqnbRh"),
    ("ICD10", "D16.8", "D16.8 Benign neoplasm: Pelvic bones, sacrum and coccyx", "wp9QmeSGOSa"),
    ("ICD10", "D16.9", "D16.9 Benign neoplasm: Bone and articular cartilage, unspecified", "c9JdznXtM0c"),
    ("ICD10", "D17", "D17 Benign lipomatous neoplasm", "F5oXeaTRxYw"),
    ("ICD10", "D17.0", "D17.0 Benign lipomatous neoplasm of skin and subcutaneous tissue of head, face and neck", "ldYSPzlHCGS"),
    ("ICD10", "D17.1", "D17.1 Benign lipomatous neoplasm of skin and subcutaneous tissue of trunk", "MGz6tJhJmL9"),
    ("ICD10", "D17.2", "D17.2 Benign lipomatous neoplasm of skin and subcutaneous tissue of limbs", "bnbwKWEGsIK"),
    ("ICD10", "D17.3", "D17.3 Benign lipomatous neoplasm of skin and subcutaneous tissue of other and unspecified sites", "nwRrjhCpT5e"),
    ("ICD10", "D17.4", "D17.4 Benign lipomatous neoplasm of intrathoracic organs", "rV6zgAtwPbc"),
    ("ICD10", "D17.5", "D17.5 Benign lipomatous neoplasm of intra-abdominal organs", "xgRtMu9tg7I"),
    ("ICD10", "D17.6", "D17.6 Benign lipomatous neoplasm of spermatic cord", "Daq5PLW5Nh6"),
    ("ICD10", "D17.7", "D17.7 Benign lipomatous neoplasm of other sites", "AO6rq9udAx2");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "D17.9", "D17.9 Benign lipomatous neoplasm, unspecified", "wPiMhDQPr0N"),
    ("ICD10", "D18", "D18 Haemangioma and lymphangioma, any site", "pGjtIz2tgNg"),
    ("ICD10", "D18.0", "D18.0 Haemangioma, any site", "blAPNcnw0kV"),
    ("ICD10", "D18.1", "D18.1 Lymphangioma, any site", "egz7e1M7807"),
    ("ICD10", "D19", "D19 Benign neoplasm of mesothelial tissue", "b2sG25YKFbV"),
    ("ICD10", "D19.0", "D19.0 Benign neoplasm: Mesothelial tissue of pleura", "bt7QaoInZMF"),
    ("ICD10", "D19.1", "D19.1 Benign neoplasm: Mesothelial tissue of peritoneum", "vCePGKyg3oJ"),
    ("ICD10", "D19.7", "D19.7 Benign neoplasm: Mesothelial tissue of other sites", "t8EWxsgyRSK"),
    ("ICD10", "D19.9", "D19.9 Benign neoplasm: Mesothelial tissue, unspecified", "EDwQ8mX7Xfx"),
    ("ICD10", "D20", "D20 Benign neoplasm of soft tissue of retroperitoneum and peritoneum", "bcGDf8JnZnE"),
    ("ICD10", "D20.0", "D20.0 Benign neoplasm: Retroperitoneum", "EIhSMZcND8P"),
    ("ICD10", "D20.1", "D20.1 Benign neoplasm: Peritoneum", "XPs2pmYVVK8"),
    ("ICD10", "D21", "D21 Other benign neoplasms of connective and other soft tissue", "URpyzvsL73n"),
    ("ICD10", "D21.0", "D21.0 Benign neoplasm: Connective and other soft tissue of head, face and neck", "jAc7a8rYWQs"),
    ("ICD10", "D21.1", "D21.1 Benign neoplasm: Connective and other soft tissue of upper limb, including shoulder", "aSqAEsmzxaW"),
    ("ICD10", "D21.2", "D21.2 Benign neoplasm: Connective and other soft tissue of lower limb, including hip", "Qub4IKjTT3q"),
    ("ICD10", "D21.3", "D21.3 Benign neoplasm: Connective and other soft tissue of thorax", "icTNGOM8QA2"),
    ("ICD10", "D21.4", "D21.4 Benign neoplasm: Connective and other soft tissue of abdomen", "KizSpvbTIKI"),
    ("ICD10", "D21.5", "D21.5 Benign neoplasm: Connective and other soft tissue of pelvis", "ieXkJyk60KM"),
    ("ICD10", "D21.6", "D21.6 Benign neoplasm: Connective and other soft tissue of trunk, unspecified", "EggDFbvxeKk"),
    ("ICD10", "D21.9", "D21.9 Benign neoplasm: Connective and other soft tissue, unspecified", "VkZYmnYBqCJ"),
    ("ICD10", "D22", "D22 Melanocytic naevi", "bnCJSNIsaOA"),
    ("ICD10", "D22.0", "D22.0 Melanocytic naevi of lip", "gjIuV2RDn7k"),
    ("ICD10", "D22.1", "D22.1 Melanocytic naevi of eyelid, including canthus", "BzNLVMA18Mz"),
    ("ICD10", "D22.2", "D22.2 Melanocytic naevi of ear and external auricular canal", "h23Xyre5nZB"),
    ("ICD10", "D22.3", "D22.3 Melanocytic naevi of other and unspecified parts of face", "ma6fWDUBAuA"),
    ("ICD10", "D22.4", "D22.4 Melanocytic naevi of scalp and neck", "VcsOutucyaR"),
    ("ICD10", "D22.5", "D22.5 Melanocytic naevi of trunk", "PA0aocok0Sy"),
    ("ICD10", "D22.6", "D22.6 Melanocytic naevi of upper limb, including shoulder", "h0I345cgGZv"),
    ("ICD10", "D22.7", "D22.7 Melanocytic naevi of lower limb, including hip", "QItswIrblcz"),
    ("ICD10", "D22.9", "D22.9 Melanocytic naevi, unspecified", "zv6qFmFEDWE"),
    ("ICD10", "D23", "D23 Other benign neoplasms of skin", "EOXIK6c3bFk"),
    ("ICD10", "D23.0", "D23.0 Benign neoplasm: Skin of lip", "FHXkXSIKqGr"),
    ("ICD10", "D23.1", "D23.1 Benign neoplasm: Skin of eyelid, including canthus", "lrk3kTuewes"),
    ("ICD10", "D23.2", "D23.2 Benign neoplasm: Skin of ear and external auricular canal", "i6tvW1PFWIf"),
    ("ICD10", "D23.3", "D23.3 Benign neoplasm: Skin of other and unspecified parts of face", "G27UFpbazgV"),
    ("ICD10", "D23.4", "D23.4 Benign neoplasm: Skin of scalp and neck", "QGdoj8gAQ9D"),
    ("ICD10", "D23.5", "D23.5 Benign neoplasm: Skin of trunk", "nnT0SZBxNMp"),
    ("ICD10", "D23.6", "D23.6 Benign neoplasm: Skin of upper limb, including shoulder", "tcFvEOTY0gZ"),
    ("ICD10", "D23.7", "D23.7 Benign neoplasm: Skin of lower limb, including hip", "nkjH9bdZykJ"),
    ("ICD10", "D23.9", "D23.9 Benign neoplasm: Skin, unspecified", "QDKFVzIsavZ"),
    ("ICD10", "D24", "D24 Benign neoplasm of breast", "vGtnE0rvaxq"),
    ("ICD10", "D25", "D25 Leiomyoma of uterus", "j9RNfQGrLGx"),
    ("ICD10", "D25.0", "D25.0 Submucous leiomyoma of uterus", "vfWL8aVCilR"),
    ("ICD10", "D25.1", "D25.1 Intramural leiomyoma of uterus", "jJLceG7bMcO"),
    ("ICD10", "D25.2", "D25.2 Subserosal leiomyoma of uterus", "Bqk5yfW7uo2"),
    ("ICD10", "D25.9", "D25.9 Leiomyoma of uterus, unspecified", "x2fKbpVuPdn"),
    ("ICD10", "D26", "D26 Other benign neoplasms of uterus", "iFOJqIXQb8a"),
    ("ICD10", "D26.0", "D26.0 Other benign neoplasm: Cervix uteri", "xgL3KhHxaeD"),
    ("ICD10", "D26.1", "D26.1 Other benign neoplasm: Corpus uteri", "h9KVZfoVF1Z"),
    ("ICD10", "D26.7", "D26.7 Other benign neoplasm: Other parts of uterus", "DoCt4g0OxbX"),
    ("ICD10", "D26.9", "D26.9 Other benign neoplasm: Uterus, unspecified", "pNViu5Brd76"),
    ("ICD10", "D27", "D27 Benign neoplasm of ovary", "DCNleZI3IhA"),
    ("ICD10", "D28", "D28 Benign neoplasm of other and unspecified female genital organs", "nxEMgwvqyW8"),
    ("ICD10", "D28.0", "D28.0 Benign neoplasm: Vulva", "vvUzLFeKsPg"),
    ("ICD10", "D28.1", "D28.1 Benign neoplasm: Vagina", "UnYdrBF8caT"),
    ("ICD10", "D28.2", "D28.2 Benign neoplasm: Uterine tubes and ligaments", "O1cXKZMEFdy"),
    ("ICD10", "D28.7", "D28.7 Benign neoplasm: Other specified female genital organs", "nr4RizpGahC"),
    ("ICD10", "D28.9", "D28.9 Benign neoplasm: Female genital organ, unspecified", "ncDY1mv1Rob"),
    ("ICD10", "D29", "D29 Benign neoplasm of male genital organs", "lJ2C4zIsxw4"),
    ("ICD10", "D29.0", "D29.0 Benign neoplasm: Penis", "QpIb2jpjuzJ"),
    ("ICD10", "D29.1", "D29.1 Benign neoplasm: Prostate", "Yx4zK33s1qn"),
    ("ICD10", "D29.2", "D29.2 Benign neoplasm: Testis", "Aq4KOO50ICh"),
    ("ICD10", "D29.3", "D29.3 Benign neoplasm: Epididymis", "UKHURHXhNss"),
    ("ICD10", "D29.4", "D29.4 Benign neoplasm: Scrotum", "PcA7QOeXTYw"),
    ("ICD10", "D29.7", "D29.7 Benign neoplasm: Other male genital organs", "IxYz9VEtUwv"),
    ("ICD10", "D29.9", "D29.9 Benign neoplasm: Male genital organ, unspecified", "Q4Wuw8EtJ6S"),
    ("ICD10", "D30", "D30 Benign neoplasm of urinary organs", "B9bI5VVVaqf"),
    ("ICD10", "D30.0", "D30.0 Benign neoplasm: Kidney", "uA8QaEbDlB8"),
    ("ICD10", "D30.1", "D30.1 Benign neoplasm: Renal pelvis", "GHgW4TahHvM"),
    ("ICD10", "D30.2", "D30.2 Benign neoplasm: Ureter", "IiJ8leS41N3"),
    ("ICD10", "D30.3", "D30.3 Benign neoplasm: Bladder", "RFD480VNyfr"),
    ("ICD10", "D30.4", "D30.4 Benign neoplasm: Urethra", "oZKTNTmzppy"),
    ("ICD10", "D30.7", "D30.7 Benign neoplasm: Other urinary organs", "H0JyCGYWNNh"),
    ("ICD10", "D30.9", "D30.9 Benign neoplasm: Urinary organ, unspecified", "RwxnPHx12pV"),
    ("ICD10", "D31", "D31 Benign neoplasm of eye and adnexa", "gfxtiG5WoOd"),
    ("ICD10", "D31.0", "D31.0 Benign neoplasm: Conjunctiva", "HikRG1C4Zx7"),
    ("ICD10", "D31.1", "D31.1 Benign neoplasm: Cornea", "cYpQg2GdGAf"),
    ("ICD10", "D31.2", "D31.2 Benign neoplasm: Retina", "k1hx6Ic68Wo"),
    ("ICD10", "D31.3", "D31.3 Benign neoplasm: Choroid", "AegwBpBgzes"),
    ("ICD10", "D31.4", "D31.4 Benign neoplasm: Ciliary body", "nn38VzXojYD"),
    ("ICD10", "D31.5", "D31.5 Benign neoplasm: Lacrimal gland and duct", "cm1ZBGQzKOa"),
    ("ICD10", "D31.6", "D31.6 Benign neoplasm: Orbit, unspecified", "H6hqmaRuLks"),
    ("ICD10", "D31.9", "D31.9 Benign neoplasm: Eye, unspecified", "jWPZjQ8AA8d"),
    ("ICD10", "D32", "D32 Benign neoplasm of meninges", "u9dUpym04St"),
    ("ICD10", "D32.0", "D32.0 Benign neoplasm: Cerebral meninges", "HmSLpRj3quP"),
    ("ICD10", "D32.1", "D32.1 Benign neoplasm: Spinal meninges", "f6IDX8HFiTn"),
    ("ICD10", "D32.9", "D32.9 Benign neoplasm: Meninges, unspecified", "FsSiQQNks2I"),
    ("ICD10", "D33", "D33 Benign neoplasm of brain and other parts of central nervous system", "SyyOYlR4xf1"),
    ("ICD10", "D33.0", "D33.0 Benign neoplasm: Brain, supratentorial", "qflCtpeHcZV"),
    ("ICD10", "D33.1", "D33.1 Benign neoplasm: Brain, infratentorial", "EVvjTHvqFyP"),
    ("ICD10", "D33.2", "D33.2 Benign neoplasm: Brain, unspecified", "hOmUBjexlTx"),
    ("ICD10", "D33.3", "D33.3 Benign neoplasm: Cranial nerves", "scr2KB5whSk"),
    ("ICD10", "D33.4", "D33.4 Benign neoplasm: Spinal cord", "aLVVQ1Nevga"),
    ("ICD10", "D33.7", "D33.7 Benign neoplasm: Other specified parts of central nervous system", "qpuzZfeqN7X"),
    ("ICD10", "D33.9", "D33.9 Benign neoplasm: Central nervous system, unspecified", "PiicWeEnTQK"),
    ("ICD10", "D34", "D34 Benign neoplasm of thyroid gland", "qUg6i9svHrM"),
    ("ICD10", "D35", "D35 Benign neoplasm of other and unspecified endocrine glands", "d68McGe5rwM"),
    ("ICD10", "D35.0", "D35.0 Benign neoplasm: Adrenal gland", "UO6xbJdcjU5"),
    ("ICD10", "D35.1", "D35.1 Benign neoplasm: Parathyroid gland", "XYRUPyl8C29"),
    ("ICD10", "D35.2", "D35.2 Benign neoplasm: Pituitary gland", "E37D1Bs5vr4"),
    ("ICD10", "D35.3", "D35.3 Benign neoplasm: Craniopharyngeal duct", "JdjjwhrhRza"),
    ("ICD10", "D35.4", "D35.4 Benign neoplasm: Pineal gland", "Uyq3wpI6Old"),
    ("ICD10", "D35.5", "D35.5 Benign neoplasm: Carotid body", "kIL8oZoMzVY"),
    ("ICD10", "D35.6", "D35.6 Benign neoplasm: Aortic body and other paraganglia", "Cafe9TuTwPD"),
    ("ICD10", "D35.7", "D35.7 Benign neoplasm: Other specified endocrine glands", "WMRcdZaf9i3"),
    ("ICD10", "D35.8", "D35.8 Benign neoplasm: Pluriglandular involvement", "CV21PJjMDF2"),
    ("ICD10", "D35.9", "D35.9 Benign neoplasm: Endocrine gland, unspecified", "L6IZzS7aTxa"),
    ("ICD10", "D36", "D36 Benign neoplasm of other and unspecified sites", "h1HK0PmNfPt"),
    ("ICD10", "D36.0", "D36.0 Benign neoplasm: Lymph nodes", "CXl57MzMqLb"),
    ("ICD10", "D36.1", "D36.1 Benign neoplasm: Peripheral nerves and autonomic nervous system", "DR8YZ0c8suW"),
    ("ICD10", "D36.7", "D36.7 Benign neoplasm: Other specified sites", "gOhbKwLjmZQ"),
    ("ICD10", "D36.9", "D36.9 Benign neoplasm: Benign neoplasm of unspecified site", "G6dRuk6anQk"),
    ("ICD10", "D37", "D37 Neoplasm of uncertain or unknown behaviour of oral cavity and digestive organs", "ABmq6BIkDIa"),
    ("ICD10", "D37.0", "D37.0 Neoplasm of uncertain or unknown behaviour: Lip, oral cavity and pharynx", "N5Ruz9Fil8l"),
    ("ICD10", "D37.1", "D37.1 Neoplasm of uncertain or unknown behaviour: Stomach", "VgGeL56jCeS"),
    ("ICD10", "D37.2", "D37.2 Neoplasm of uncertain or unknown behaviour: Small intestine", "g7B8QLQ1wyz"),
    ("ICD10", "D37.3", "D37.3 Neoplasm of uncertain or unknown behaviour: Appendix", "gONTwDgHto5"),
    ("ICD10", "D37.4", "D37.4 Neoplasm of uncertain or unknown behaviour: Colon", "Jp8JycwgNDF"),
    ("ICD10", "D37.5", "D37.5 Neoplasm of uncertain or unknown behaviour: Rectum", "AEAnq7vbXlR"),
    ("ICD10", "D37.6", "D37.6 Neoplasm of uncertain or unknown behaviour: Liver, gallbladder and bile ducts", "rQbJTRe5nll"),
    ("ICD10", "D37.7", "D37.7 Neoplasm of uncertain or unknown behaviour: Other digestive organs", "HpBjqL8YCBe"),
    ("ICD10", "D37.9", "D37.9 Neoplasm of uncertain or unknown behaviour: Digestive organ, unspecified", "QlZyMu5bY7U"),
    ("ICD10", "D38", "D38 Neoplasm of uncertain or unknown behaviour of middle ear and respiratory and intrathoracic organs", "mjMwgP8vh09"),
    ("ICD10", "D38.0", "D38.0 Neoplasm of uncertain or unknown behaviour: Larynx", "pwvKwiOodyk"),
    ("ICD10", "D38.1", "D38.1 Neoplasm of uncertain or unknown behaviour: Trachea, bronchus and lung", "adhQUQMEgPv"),
    ("ICD10", "D38.2", "D38.2 Neoplasm of uncertain or unknown behaviour: Pleura", "SxZguCQ1fhp"),
    ("ICD10", "D38.3", "D38.3 Neoplasm of uncertain or unknown behaviour: Mediastinum", "NW6xqD51tLL"),
    ("ICD10", "D38.4", "D38.4 Neoplasm of uncertain or unknown behaviour: Thymus", "DLjTaqFWAmy"),
    ("ICD10", "D38.5", "D38.5 Neoplasm of uncertain or unknown behaviour: Other respiratory organs", "pps4FMoMGdw"),
    ("ICD10", "D38.6", "D38.6 Neoplasm of uncertain or unknown behaviour: Respiratory organ, unspecified", "LbqLrpZqE33"),
    ("ICD10", "D39", "D39 Neoplasm of uncertain or unknown behaviour of female genital organs", "IBSsN4QDvvC"),
    ("ICD10", "D39.0", "D39.0 Neoplasm of uncertain or unknown behaviour: Uterus", "dLHfrbx2pwR"),
    ("ICD10", "D39.1", "D39.1 Neoplasm of uncertain or unknown behaviour: Ovary", "aDLyJi0iw1w"),
    ("ICD10", "D39.2", "D39.2 Neoplasm of uncertain or unknown behaviour: Placenta", "Pf7DUpIkFop"),
    ("ICD10", "D39.7", "D39.7 Neoplasm of uncertain or unknown behaviour: Other female genital organs", "snZIgNuSkCW"),
    ("ICD10", "D39.9", "D39.9 Neoplasm of uncertain or unknown behaviour: Female genital organ, unspecified", "m59lxkSlORs"),
    ("ICD10", "D40", "D40 Neoplasm of uncertain or unknown behaviour of male genital organs", "gQ3qlimH1AO"),
    ("ICD10", "D40.0", "D40.0 Neoplasm of uncertain or unknown behaviour: Prostate", "F4mTKKY29lr"),
    ("ICD10", "D40.1", "D40.1 Neoplasm of uncertain or unknown behaviour: Testis", "VIMMMltBfiJ"),
    ("ICD10", "D40.7", "D40.7 Neoplasm of uncertain or unknown behaviour: Other male genital organs", "pv8WQrXVEYs"),
    ("ICD10", "D40.9", "D40.9 Neoplasm of uncertain or unknown behaviour: Male genital organ, unspecified", "vu1rlK7naLL"),
    ("ICD10", "D41", "D41 Neoplasm of uncertain or unknown behaviour of urinary organs", "VbR4W7DXRc9"),
    ("ICD10", "D41.0", "D41.0 Neoplasm of uncertain or unknown behaviour: Kidney", "f4zHqkz2Qha"),
    ("ICD10", "D41.1", "D41.1 Neoplasm of uncertain or unknown behaviour: Renal pelvis", "S4WpDJf3Cue"),
    ("ICD10", "D41.2", "D41.2 Neoplasm of uncertain or unknown behaviour: Ureter", "HiZF9GUmo1g"),
    ("ICD10", "D41.3", "D41.3 Neoplasm of uncertain or unknown behaviour: Urethra", "mDrWFftDml7"),
    ("ICD10", "D41.4", "D41.4 Neoplasm of uncertain or unknown behaviour: Bladder", "cJikWhNpzrc"),
    ("ICD10", "D41.7", "D41.7 Neoplasm of uncertain or unknown behaviour: Other urinary organs", "f25XZew6unl"),
    ("ICD10", "D41.9", "D41.9 Neoplasm of uncertain or unknown behaviour: Urinary organ, unspecified", "rSinYO9LyX1"),
    ("ICD10", "D42", "D42 Neoplasm of uncertain or unknown behaviour of meninges", "U3xTwqxQBu7"),
    ("ICD10", "D42.0", "D42.0 Neoplasm of uncertain or unknown behaviour: Cerebral meninges", "VG2kOX8x95D"),
    ("ICD10", "D42.1", "D42.1 Neoplasm of uncertain or unknown behaviour: Spinal meninges", "oiaUAl9gFBM"),
    ("ICD10", "D42.9", "D42.9 Neoplasm of uncertain or unknown behaviour: Meninges, unspecified", "MwQrZ9N7SOt"),
    ("ICD10", "D43", "D43 Neoplasm of uncertain or unknown behaviour of brain and central nervous system", "JJQptKB8pAV"),
    ("ICD10", "D43.0", "D43.0 Neoplasm of uncertain or unknown behaviour: Brain, supratentorial", "zjobhRfRdie"),
    ("ICD10", "D43.1", "D43.1 Neoplasm of uncertain or unknown behaviour: Brain, infratentorial", "CM2sQ8vAgid"),
    ("ICD10", "D43.2", "D43.2 Neoplasm of uncertain or unknown behaviour: Brain, unspecified", "rmq4CwJUXbK"),
    ("ICD10", "D43.3", "D43.3 Neoplasm of uncertain or unknown behaviour: Cranial nerves", "o4LBfweAZlY"),
    ("ICD10", "D43.4", "D43.4 Neoplasm of uncertain or unknown behaviour: Spinal cord", "HFeDQXZ5inc"),
    ("ICD10", "D43.7", "D43.7 Neoplasm of uncertain or unknown behaviour: Other parts of central nervous system", "CnT5WL4kzCl"),
    ("ICD10", "D43.9", "D43.9 Neoplasm of uncertain or unknown behaviour: Central nervous system, unspecified", "tmLCGe78xH3"),
    ("ICD10", "D44", "D44 Neoplasm of uncertain or unknown behaviour of endocrine glands", "LRdhUEj1RY0"),
    ("ICD10", "D44.0", "D44.0 Neoplasm of uncertain or unknown behaviour: Thyroid gland", "sdZmxx2jyLE"),
    ("ICD10", "D44.1", "D44.1 Neoplasm of uncertain or unknown behaviour: Adrenal gland", "hWyF5Zmps9N"),
    ("ICD10", "D44.2", "D44.2 Neoplasm of uncertain or unknown behaviour: Parathyroid gland", "Lw9UXRprKUi"),
    ("ICD10", "D44.3", "D44.3 Neoplasm of uncertain or unknown behaviour: Pituitary gland", "HPKlpovCLzm"),
    ("ICD10", "D44.4", "D44.4 Neoplasm of uncertain or unknown behaviour: Craniopharyngeal duct", "iveRDeLw5EU"),
    ("ICD10", "D44.5", "D44.5 Neoplasm of uncertain or unknown behaviour: Pineal gland", "oGbyodyH5Ml"),
    ("ICD10", "D44.6", "D44.6 Neoplasm of uncertain or unknown behaviour: Carotid body", "SBJ2kuDK3do"),
    ("ICD10", "D44.7", "D44.7 Neoplasm of uncertain or unknown behaviour: Aortic body and other paraganglia", "WX5gVg6gKuv"),
    ("ICD10", "D44.8", "D44.8 Neoplasm of uncertain or unknown behaviour: Pluriglandular involvement", "EItgptKnC8l"),
    ("ICD10", "D44.9", "D44.9 Neoplasm of uncertain or unknown behaviour: Endocrine gland, unspecified", "gBuxFNXFIbL"),
    ("ICD10", "D45", "D45 Polycythaemia vera", "AbgqvNjJHmc"),
    ("ICD10", "D46", "D46 Myelodysplastic syndromes", "KCvNKh28EvC"),
    ("ICD10", "D46.0", "D46.0 Refractory anaemia without ring sideroblasts, so stated", "WiaPeYWp70y"),
    ("ICD10", "D46.1", "D46.1 Refractory anaemia with ring sideroblasts", "uNGVEHBSCGF"),
    ("ICD10", "D46.2", "D46.2 Refractory anaemia with excess of blasts [RAEB]", "SqONzAyQRHZ"),
    ("ICD10", "D46.4", "D46.4 Refractory anaemia, unspecified", "nXjH0KuNFGk"),
    ("ICD10", "D46.5", "D46.5 Refractory anaemia with multi-lineage dysplasia", "jKmArfykukQ"),
    ("ICD10", "D46.6", "D46.6 Myelodysplastic syndrome with isolated del(5q) chromosomal abnormality", "bwBFtT9wfV3"),
    ("ICD10", "D46.7", "D46.7 Other myelodysplastic syndromes", "E2BX773T9e4"),
    ("ICD10", "D46.9", "D46.9 Myelodysplastic syndrome, unspecified", "WpdSIShq20z"),
    ("ICD10", "D47", "D47 Other neoplasms of uncertain or unknown behaviour of lymphoid, haematopoietic and related tissue", "WOamXah3RIR"),
    ("ICD10", "D47.0", "D47.0 Histiocytic and mast cell tumours of uncertain and unknown behaviour", "QfgkBoA7Arg"),
    ("ICD10", "D47.1", "D47.1 Chronic myeloproliferative disease", "JuHS4E6ciPQ"),
    ("ICD10", "D47.2", "D47.2 Monoclonal gammopathy of undetermined significance (MGUS)", "nLK3cSyuRI6"),
    ("ICD10", "D47.3", "D47.3 Essential (haemorrhagic) thrombocythaemia", "xhHGbsEG9DO"),
    ("ICD10", "D47.4", "D47.4 Osteomyelofibrosis", "ejcVPK6hQXn"),
    ("ICD10", "D47.5", "D47.5 Chronic eosinophilic leukaemia [hypereosinophilic syndrome]", "nVudnytqRcl"),
    ("ICD10", "D47.7", "D47.7 Other specified neoplasms of uncertain or unknown behaviour of lymphoid, haematopoietic and related tissue", "ZIID2iHhWCW"),
    ("ICD10", "D47.9", "D47.9 Neoplasm of uncertain or unknown behaviour of lymphoid, haematopoietic and related tissue, unspecified", "SGiWL9EG7QY"),
    ("ICD10", "D48", "D48 Neoplasm of uncertain or unknown behaviour of other and unspecified sites", "CiBCO0rOqKG"),
    ("ICD10", "D48.0", "D48.0 Neoplasm of uncertain or unknown behaviour: Bone and articular cartilage", "qpasRHChze2"),
    ("ICD10", "D48.1", "D48.1 Neoplasm of uncertain or unknown behaviour: Connective and other soft tissue", "G0nyKFAsj0S"),
    ("ICD10", "D48.2", "D48.2 Neoplasm of uncertain or unknown behaviour: Peripheral nerves and autonomic nervous system", "U0ahlCZ8g6k"),
    ("ICD10", "D48.3", "D48.3 Neoplasm of uncertain or unknown behaviour: Retroperitoneum", "fai90k0ZOGu"),
    ("ICD10", "D48.4", "D48.4 Neoplasm of uncertain or unknown behaviour: Peritoneum", "Gf7Wk9zeFRp"),
    ("ICD10", "D48.5", "D48.5 Neoplasm of uncertain or unknown behaviour: Skin", "fDwD8pXpiDN"),
    ("ICD10", "D48.6", "D48.6 Neoplasm of uncertain or unknown behaviour: Breast", "OtOncQju6Hc"),
    ("ICD10", "D48.7", "D48.7 Neoplasm of uncertain or unknown behaviour: Other specified sites", "sbRaFUOaPDA"),
    ("ICD10", "D48.9", "D48.9 Neoplasm of uncertain or unknown behaviour: Neoplasm of uncertain or unknown behaviour, unspecified", "SyfMbwFd5Tw"),
    ("ICD10", "D50", "D50 Iron deficiency anaemia", "ZdssS4PKSSF"),
    ("ICD10", "D50.0", "D50.0 Iron deficiency anaemia secondary to blood loss (chronic)", "zV47eav31A7"),
    ("ICD10", "D50.1", "D50.1 Sideropenic dysphagia", "Bg65xhDgBaz"),
    ("ICD10", "D50.8", "D50.8 Other iron deficiency anaemias", "FhnZ0xEK6KH"),
    ("ICD10", "D50.9", "D50.9 Iron deficiency anaemia, unspecified", "Jyd76QrSDsi"),
    ("ICD10", "D51", "D51 Vitamin B", "BoS6lZGTGP8"),
    ("ICD10", "D51.0", "D51.0 Vitamin B", "uModUrQmb3f"),
    ("ICD10", "D51.1", "D51.1 Vitamin B", "gNfT9TpDE4U"),
    ("ICD10", "D51.2", "D51.2 Transcobalamin II deficiency", "IYVaAH82Ouc"),
    ("ICD10", "D51.3", "D51.3 Other dietary vitamin B", "GZgtSC1VbT4"),
    ("ICD10", "D51.8", "D51.8 Other vitamin B", "OAhFbFB7KFi"),
    ("ICD10", "D51.9", "D51.9 Vitamin B", "gN63EH4WpCs"),
    ("ICD10", "D52", "D52 Folate deficiency anaemia", "kHYdTQAU9XJ"),
    ("ICD10", "D52.0", "D52.0 Dietary folate deficiency anaemia", "b55vdSuGvzJ"),
    ("ICD10", "D52.1", "D52.1 Drug-induced folate deficiency anaemia", "bvqCjJ9o4BR"),
    ("ICD10", "D52.8", "D52.8 Other folate deficiency anaemias", "xBsiCIlw5tw"),
    ("ICD10", "D52.9", "D52.9 Folate deficiency anaemia, unspecified", "erL5ADtMTbJ"),
    ("ICD10", "D53", "D53 Other nutritional anaemias", "tGQlWJQLjvY"),
    ("ICD10", "D53.0", "D53.0 Protein deficiency anaemia", "lSYRBe7qkzy"),
    ("ICD10", "D53.1", "D53.1 Other megaloblastic anaemias, not elsewhere classified", "Y2zUi4gZOpQ"),
    ("ICD10", "D53.2", "D53.2 Scorbutic anaemia", "hBKE2QL7ILB"),
    ("ICD10", "D53.8", "D53.8 Other specified nutritional anaemias", "DDOjYTCZAjU"),
    ("ICD10", "D53.9", "D53.9 Nutritional anaemia, unspecified", "xP50FLNxVJG"),
    ("ICD10", "D55", "D55 Anaemia due to enzyme disorders", "P7TIoZn8MPa"),
    ("ICD10", "D55.0", "D55.0 Anaemia due to glucose-6-phosphate dehydrogenase [G6PD] deficiency", "jNFhPediZI3"),
    ("ICD10", "D55.1", "D55.1 Anaemia due to other disorders of glutathione metabolism", "wsJJdS8JPFf"),
    ("ICD10", "D55.2", "D55.2 Anaemia due to disorders of glycolytic enzymes", "eTr1DVdpz0C"),
    ("ICD10", "D55.3", "D55.3 Anaemia due to disorders of nucleotide metabolism", "n1qj3akNMYh"),
    ("ICD10", "D55.8", "D55.8 Other anaemias due to enzyme disorders", "tdsXoGaCPol"),
    ("ICD10", "D55.9", "D55.9 Anaemia due to enzyme disorder, unspecified", "hBmUHdPiWWG"),
    ("ICD10", "D56", "D56 Thalassaemia", "RZ4SQ0kt3Jj"),
    ("ICD10", "D56.0", "D56.0 Alpha thalassaemia", "GYasY99R89w"),
    ("ICD10", "D56.1", "D56.1 Beta thalassaemia", "UxMC82NC2FU"),
    ("ICD10", "D56.2", "D56.2 Delta-beta thalassaemia", "EQMN8ZXBsQm"),
    ("ICD10", "D56.3", "D56.3 Thalassaemia trait", "euqshGwEnZX"),
    ("ICD10", "D56.4", "D56.4 Hereditary persistence of fetal haemoglobin [HPFH]", "vFuNDxpArEA"),
    ("ICD10", "D56.8", "D56.8 Other thalassaemias", "DeXUgnaUY58"),
    ("ICD10", "D56.9", "D56.9 Thalassaemia, unspecified", "AZMyxDR6W2g"),
    ("ICD10", "D57", "D57 Sickle-cell disorders", "i3PChKmYDll"),
    ("ICD10", "D57.0", "D57.0 Sickle-cell anaemia with crisis", "bZtNwesqWqV"),
    ("ICD10", "D57.1", "D57.1 Sickle-cell anaemia without crisis", "b86lygR4Qqo"),
    ("ICD10", "D57.2", "D57.2 Double heterozygous sickling disorders", "WNq1UsXhdjr"),
    ("ICD10", "D57.3", "D57.3 Sickle-cell trait", "V1t7vplzYfp"),
    ("ICD10", "D57.8", "D57.8 Other sickle-cell disorders", "Eh1SzqTR9Qr"),
    ("ICD10", "D58", "D58 Other hereditary haemolytic anaemias", "gfQnuuHmMJd"),
    ("ICD10", "D58.0", "D58.0 Hereditary spherocytosis", "XmSyFLgJWFF"),
    ("ICD10", "D58.1", "D58.1 Hereditary elliptocytosis", "NOncX1qy3tE"),
    ("ICD10", "D58.2", "D58.2 Other haemoglobinopathies", "Mo55O8qYedb"),
    ("ICD10", "D58.8", "D58.8 Other specified hereditary haemolytic anaemias", "SZm8jy0no5R"),
    ("ICD10", "D58.9", "D58.9 Hereditary haemolytic anaemia, unspecified", "sqqYmME1aZV"),
    ("ICD10", "D59", "D59 Acquired haemolytic anaemia", "bWCv4I1MfzK"),
    ("ICD10", "D59.0", "D59.0 Drug-induced autoimmune haemolytic anaemia", "nUwVvJY9Yg5"),
    ("ICD10", "D59.1", "D59.1 Other autoimmune haemolytic anaemias", "tZ9uApiHQgi"),
    ("ICD10", "D59.2", "D59.2 Drug-induced nonautoimmune haemolytic anaemia", "BxFwufVxSKp"),
    ("ICD10", "D59.3", "D59.3 Haemolytic-uraemic syndrome", "RVr5Me1Y8qX"),
    ("ICD10", "D59.4", "D59.4 Other nonautoimmune haemolytic anaemias", "QbsX8EQ2qAI"),
    ("ICD10", "D59.5", "D59.5 Paroxysmal nocturnal haemoglobinuria [Marchiafava-Micheli]", "FlqkYHGZOG2"),
    ("ICD10", "D59.6", "D59.6 Haemoglobinuria due to haemolysis from other external causes", "M4ugDdpdf42"),
    ("ICD10", "D59.8", "D59.8 Other acquired haemolytic anaemias", "ZWj7NIqJx6r"),
    ("ICD10", "D59.9", "D59.9 Acquired haemolytic anaemia, unspecified", "w4cjbztXRgz"),
    ("ICD10", "D60", "D60 Acquired pure red cell aplasia [erythroblastopenia]", "zGshTXlya6i"),
    ("ICD10", "D60.0", "D60.0 Chronic acquired pure red cell aplasia", "kYEHBuU1Ora"),
    ("ICD10", "D60.1", "D60.1 Transient acquired pure red cell aplasia", "pSSdGpxsGev"),
    ("ICD10", "D60.8", "D60.8 Other acquired pure red cell aplasias", "BvMRR9ilL4f"),
    ("ICD10", "D60.9", "D60.9 Acquired pure red cell aplasia, unspecified", "SsnZuqMLpsF"),
    ("ICD10", "D61", "D61 Other aplastic anaemias", "iwlFOcrnDfY"),
    ("ICD10", "D61.0", "D61.0 Constitutional aplastic anaemia", "L8lgGfjO67t"),
    ("ICD10", "D61.1", "D61.1 Drug-induced aplastic anaemia", "M0kV5ah663M"),
    ("ICD10", "D61.2", "D61.2 Aplastic anaemia due to other external agents", "iJtyPg9GaEO"),
    ("ICD10", "D61.3", "D61.3 Idiopathic aplastic anaemia", "AolzkS9wKJP"),
    ("ICD10", "D61.8", "D61.8 Other specified aplastic anaemias", "rY488usBfgy"),
    ("ICD10", "D61.9", "D61.9 Aplastic anaemia, unspecified", "A3LV3VNhrMq"),
    ("ICD10", "D62", "D62 Acute posthaemorrhagic anaemia", "FFyLZsTgtyG"),
    ("ICD10", "D63", "D63 Anaemia in chronic diseases classified elsewhere", "IZkqTHHIGT8"),
    ("ICD10", "D63.0", "D63.0 Anaemia in neoplastic disease", "WtOfevPVMIk"),
    ("ICD10", "D63.8", "D63.8 Anaemia in other chronic diseases classified elsewhere", "SkK0K49hCKb"),
    ("ICD10", "D64", "D64 Other anaemias", "JWYPkG5QFXQ"),
    ("ICD10", "D64.0", "D64.0 Hereditary sideroblastic anaemia", "fO4FGBweLkV"),
    ("ICD10", "D64.1", "D64.1 Secondary sideroblastic anaemia due to disease", "nLgpGIbfwfE"),
    ("ICD10", "D64.2", "D64.2 Secondary sideroblastic anaemia due to drugs and toxins", "rJcQb3r4h7d"),
    ("ICD10", "D64.3", "D64.3 Other sideroblastic anaemias", "mJIjzduXnfF"),
    ("ICD10", "D64.4", "D64.4 Congenital dyserythropoietic anaemia", "TuU8PGlGVGw"),
    ("ICD10", "D64.8", "D64.8 Other specified anaemias", "JK827p8Pf6n"),
    ("ICD10", "D64.9", "D64.9 Anaemia, unspecified", "KKztmQeYtQE"),
    ("ICD10", "D65", "D65 Disseminated intravascular coagulation [defibrination syndrome]", "O6E3yWeAHxZ"),
    ("ICD10", "D66", "D66 Hereditary factor VIII deficiency", "UZBAANtn1ee"),
    ("ICD10", "D67", "D67 Hereditary factor IX deficiency", "YDvccWzNcNa"),
    ("ICD10", "D68", "D68 Other coagulation defects", "UsrBrejyUwM"),
    ("ICD10", "D68.0", "D68.0 Von Willebrand disease", "JED8j521MK6"),
    ("ICD10", "D68.1", "D68.1 Hereditary factor XI deficiency", "c2GHdBVXH9n"),
    ("ICD10", "D68.2", "D68.2 Hereditary deficiency of other clotting factors", "ov4QKG2QCWW"),
    ("ICD10", "D68.3", "D68.3 Haemorrhagic disorder due to circulating anticoagulants", "byNHkjZp4z7"),
    ("ICD10", "D68.4", "D68.4 Acquired coagulation factor deficiency", "ZzeZSg7Ns7K"),
    ("ICD10", "D68.5", "D68.5 Primary thrombophilia", "b157KOoqPaV"),
    ("ICD10", "D68.6", "D68.6 Other thrombophilia", "gZKrQ27Vw0C"),
    ("ICD10", "D68.8", "D68.8 Other specified coagulation defects", "lTC7tcq2WJe"),
    ("ICD10", "D68.9", "D68.9 Coagulation defect, unspecified", "iOPQtKoNOvb");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "D69", "D69 Purpura and other haemorrhagic conditions", "XxAdG9cxfpw"),
    ("ICD10", "D69.0", "D69.0 Allergic purpura", "fXxaXIEnK2R"),
    ("ICD10", "D69.1", "D69.1 Qualitative platelet defects", "hN43PJbeVjZ"),
    ("ICD10", "D69.2", "D69.2 Other nonthrombocytopenic purpura", "mx16pvfFCXe"),
    ("ICD10", "D69.3", "D69.3 Idiopathic thrombocytopenic purpura", "nspleQYloLH"),
    ("ICD10", "D69.4", "D69.4 Other primary thrombocytopenia", "UJANSi0IB69"),
    ("ICD10", "D69.5", "D69.5 Secondary thrombocytopenia", "S5nFJzYHbp8"),
    ("ICD10", "D69.6", "D69.6 Thrombocytopenia, unspecified", "lJa5hGTEPo9"),
    ("ICD10", "D69.8", "D69.8 Other specified haemorrhagic conditions", "ZZlfV22m30r"),
    ("ICD10", "D69.9", "D69.9 Haemorrhagic condition, unspecified", "SGy1sU9dlaF"),
    ("ICD10", "D70", "D70 Agranulocytosis", "GzRFkhrcPG1"),
    ("ICD10", "D71", "D71 Functional disorders of polymorphonuclear neutrophils", "WpbN9HbZjP0"),
    ("ICD10", "D72", "D72 Other disorders of white blood cells", "NDuTOxGTuz5"),
    ("ICD10", "D72.0", "D72.0 Genetic anomalies of leukocytes", "rtaEnNJOquR"),
    ("ICD10", "D72.1", "D72.1 Eosinophilia", "jSzzUoJUGLd"),
    ("ICD10", "D72.8", "D72.8 Other specified disorders of white blood cells", "Brw988H498H"),
    ("ICD10", "D72.9", "D72.9 Disorder of white blood cells, unspecified", "XBTTlcI1u1J"),
    ("ICD10", "D73", "D73 Diseases of spleen", "PfHcgtVHjON"),
    ("ICD10", "D73.0", "D73.0 Hyposplenism", "wFVTN0terxi"),
    ("ICD10", "D73.1", "D73.1 Hypersplenism", "aKDsK7RiYTv"),
    ("ICD10", "D73.2", "D73.2 Chronic congestive splenomegaly", "YRPuvtfUw0Y"),
    ("ICD10", "D73.3", "D73.3 Abscess of spleen", "yABxvvTVZaP"),
    ("ICD10", "D73.4", "D73.4 Cyst of spleen", "cf42KvZ8D0y"),
    ("ICD10", "D73.5", "D73.5 Infarction of spleen", "m8u1twMyFeK"),
    ("ICD10", "D73.8", "D73.8 Other diseases of spleen", "sfLO4MVSH94"),
    ("ICD10", "D73.9", "D73.9 Disease of spleen, unspecified", "ORFPibkNOQA"),
    ("ICD10", "D74", "D74 Methaemoglobinaemia", "FJda5RTDwtK"),
    ("ICD10", "D74.0", "D74.0 Congenital methaemoglobinaemia", "RnjbyEHsqVZ"),
    ("ICD10", "D74.8", "D74.8 Other methaemoglobinaemias", "VQ8WK934Mwj"),
    ("ICD10", "D74.9", "D74.9 Methaemoglobinaemia, unspecified", "EzLGRz5FhdB"),
    ("ICD10", "D75", "D75 Other diseases of blood and blood-forming organs", "s5Sexfen1sI"),
    ("ICD10", "D75.0", "D75.0 Familial erythrocytosis", "o3BrE9yVZ5T"),
    ("ICD10", "D75.1", "D75.1 Secondary polycythaemia", "aVJslTVDIYd"),
    ("ICD10", "D75.8", "D75.8 Other specified diseases of blood and blood-forming organs", "VwPPwWqRYt9"),
    ("ICD10", "D75.9", "D75.9 Disease of blood and blood-forming organs, unspecified", "NL2Yg1tE3cb"),
    ("ICD10", "D76", "D76 Other specified diseases with participation of lymphoreticular and reticulohistiocytic tissue", "ciF9FifgBBE"),
    ("ICD10", "D76.1", "D76.1 Haemophagocytic lymphohistiocytosis", "F0Rc7vEkZEy"),
    ("ICD10", "D76.2", "D76.2 Haemophagocytic syndrome, infection-associated", "Duse7ViM2TY"),
    ("ICD10", "D76.3", "D76.3 Other histiocytosis syndromes", "exhZwKWpFnU"),
    ("ICD10", "D77", "D77 Other disorders of blood and blood-forming organs in diseases classified elsewhere", "KXod1ZwXTVo"),
    ("ICD10", "D80", "D80 Immunodeficiency with predominantly antibody defects", "JMMg6kBtWgn"),
    ("ICD10", "D80.0", "D80.0 Hereditary hypogammaglobulinaemia", "HbiDdnEO653"),
    ("ICD10", "D80.1", "D80.1 Nonfamilial hypogammaglobulinaemia", "b1BJ3gmd0vL"),
    ("ICD10", "D80.2", "D80.2 Selective deficiency of immunoglobulin A [IgA]", "g3QCCKfIBEj"),
    ("ICD10", "D80.3", "D80.3 Selective deficiency of immunoglobulin G [IgG] subclasses", "Wd0b2HHleut"),
    ("ICD10", "D80.4", "D80.4 Selective deficiency of immunoglobulin M [IgM]", "ZmpLzZww4sS"),
    ("ICD10", "D80.5", "D80.5 Immunodeficiency with increased immunoglobulin M [IgM]", "SQy9PATR6V6"),
    ("ICD10", "D80.6", "D80.6 Antibody deficiency with near-normal immunoglobulins or with hyperimmunoglobulinaemia", "blmsJQ8oO6w"),
    ("ICD10", "D80.7", "D80.7 Transient hypogammaglobulinaemia of infancy", "xo7pDYbg7xg"),
    ("ICD10", "D80.8", "D80.8 Other immunodeficiencies with predominantly antibody defects", "xIUEuRXhl4f"),
    ("ICD10", "D80.9", "D80.9 Immunodeficiency with predominantly antibody defects, unspecified", "cD6EAHMurBN"),
    ("ICD10", "D81", "D81 Combined immunodeficiencies", "oAKlOYh1fau"),
    ("ICD10", "D81.0", "D81.0 Severe combined immunodeficiency [SCID] with reticular dysgenesis", "Esgrtv70PBR"),
    ("ICD10", "D81.1", "D81.1 Severe combined immunodeficiency [SCID] with low T- and B-cell numbers", "iIRphNla9OU"),
    ("ICD10", "D81.2", "D81.2 Severe combined immunodeficiency [SCID] with low or normal B-cell numbers", "o65amdM60eT"),
    ("ICD10", "D81.3", "D81.3 Adenosine deaminase [ADA] deficiency", "fV677RMYJVH"),
    ("ICD10", "D81.4", "D81.4 Nezelof syndrome", "ggtotKcrhwB"),
    ("ICD10", "D81.5", "D81.5 Purine nucleoside phosphorylase [PNP] deficiency", "dOXtEAi3wI7"),
    ("ICD10", "D81.6", "D81.6 Major histocompatibility complex class I deficiency", "pfPPQ7vAUSI"),
    ("ICD10", "D81.7", "D81.7 Major histocompatibility complex class II deficiency", "hjqhYiDSx3X"),
    ("ICD10", "D81.8", "D81.8 Other combined immunodeficiencies", "In861oXOF0v"),
    ("ICD10", "D81.9", "D81.9 Combined immunodeficiency, unspecified", "c21MjqJLtwG"),
    ("ICD10", "D82", "D82 Immunodeficiency associated with other major defects", "q1O49lvFr0o"),
    ("ICD10", "D82.0", "D82.0 Wiskott-Aldrich syndrome", "bsmWV9bJaw2"),
    ("ICD10", "D82.1", "D82.1 Di George syndrome", "KePEatBVi0H"),
    ("ICD10", "D82.2", "D82.2 Immunodeficiency with short-limbed stature", "zDuCIY1GQdo"),
    ("ICD10", "D82.3", "D82.3 Immunodeficiency following hereditary defective response to Epstein-Barr virus", "FxHDgdU1u5M"),
    ("ICD10", "D82.4", "D82.4 Hyperimmunoglobulin E [IgE] syndrome", "SIgYbbP3zpz"),
    ("ICD10", "D82.8", "D82.8 Immunodeficiency associated with other specified major defects", "iIybOUsRhTe"),
    ("ICD10", "D82.9", "D82.9 Immunodeficiency associated with major defect, unspecified", "gEYVAvZ3Hil"),
    ("ICD10", "D83", "D83 Common variable immunodeficiency", "tTOvAqwVc6m"),
    ("ICD10", "D83.0", "D83.0 Common variable immunodeficiency with predominant abnormalities of B-cell numbers and function", "q9L4f4b68wC"),
    ("ICD10", "D83.1", "D83.1 Common variable immunodeficiency with predominant immunoregulatory T-cell disorders", "RHjGyDQPWtw"),
    ("ICD10", "D83.2", "D83.2 Common variable immunodeficiency with autoantibodies to B- or T-cells", "iccD1DcMMRT"),
    ("ICD10", "D83.8", "D83.8 Other common variable immunodeficiencies", "zh0YSeilXok"),
    ("ICD10", "D83.9", "D83.9 Common variable immunodeficiency, unspecified", "Xiqpq2ONzBe"),
    ("ICD10", "D84", "D84 Other immunodeficiencies", "niSzccqCffx"),
    ("ICD10", "D84.0", "D84.0 Lymphocyte function antigen-1 [LFA-1] defect", "esIufO1TIvW"),
    ("ICD10", "D84.1", "D84.1 Defects in the complement system", "kcUSIg22aSX"),
    ("ICD10", "D84.8", "D84.8 Other specified immunodeficiencies", "je09nto824k"),
    ("ICD10", "D84.9", "D84.9 Immunodeficiency, unspecified", "RyODCQ7O99N"),
    ("ICD10", "D86", "D86 Sarcoidosis", "iDR3YAOdwrv"),
    ("ICD10", "D86.0", "D86.0 Sarcoidosis of lung", "s0XAZZccwAx"),
    ("ICD10", "D86.1", "D86.1 Sarcoidosis of lymph nodes", "eSc5t55u9f8"),
    ("ICD10", "D86.2", "D86.2 Sarcoidosis of lung with sarcoidosis of lymph nodes", "KeFJwJ2GlHq"),
    ("ICD10", "D86.3", "D86.3 Sarcoidosis of skin", "kJP2rQl80nq"),
    ("ICD10", "D86.8", "D86.8 Sarcoidosis of other and combined sites", "IiRMxq96kJc"),
    ("ICD10", "D86.9", "D86.9 Sarcoidosis, unspecified", "ymxNPNhWeDL"),
    ("ICD10", "D89", "D89 Other disorders involving the immune mechanism, not elsewhere classified", "fP7IVEy1HOm"),
    ("ICD10", "D89.0", "D89.0 Polyclonal hypergammaglobulinaemia", "OSpHKjW1mug"),
    ("ICD10", "D89.1", "D89.1 Cryoglobulinaemia", "r6IB9DO7Zgz"),
    ("ICD10", "D89.2", "D89.2 Hypergammaglobulinaemia, unspecified", "gxxy2MElCYH"),
    ("ICD10", "D89.3", "D89.3 Immune reconstitution syndrome", "SggZS3C0OT1"),
    ("ICD10", "D89.8", "D89.8 Other specified disorders involving the immune mechanism, not elsewhere classified", "b7bUUKdPJkI"),
    ("ICD10", "D89.9", "D89.9 Disorder involving the immune mechanism, unspecified", "eaEMxN2k6Q8");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "E00", "E00 Congenital iodine-deficiency syndrome", "XOsWUrkLaCx"),
    ("ICD10", "E00.0", "E00.0 Congenital iodine-deficiency syndrome, neurological type", "th9OvZXh2DZ"),
    ("ICD10", "E00.1", "E00.1 Congenital iodine-deficiency syndrome, myxoedematous type", "JwLaCH9W2c1"),
    ("ICD10", "E00.2", "E00.2 Congenital iodine-deficiency syndrome, mixed type", "ud9rABcL1u8"),
    ("ICD10", "E00.9", "E00.9 Congenital iodine-deficiency syndrome, unspecified", "Plz9gaGDMQs"),
    ("ICD10", "E01", "E01 Iodine-deficiency-related thyroid disorders and allied conditions", "zU8jqFiEAm5"),
    ("ICD10", "E01.0", "E01.0 Iodine-deficiency-related diffuse (endemic) goitre", "tHISACPFFNn"),
    ("ICD10", "E01.1", "E01.1 Iodine-deficiency-related multinodular (endemic) goitre", "PIJZEBywZNw"),
    ("ICD10", "E01.2", "E01.2 Iodine-deficiency-related (endemic) goitre, unspecified", "PvPcu236WPT"),
    ("ICD10", "E01.8", "E01.8 Other iodine-deficiency-related thyroid disorders and allied conditions", "HJfW7mh6FdX"),
    ("ICD10", "E02", "E02 Subclinical iodine-deficiency hypothyroidism", "R8KW7lH1lLl"),
    ("ICD10", "E03", "E03 Other hypothyroidism", "W3zrfLskMEk"),
    ("ICD10", "E03.0", "E03.0 Congenital hypothyroidism with diffuse goitre", "cOo3OOObNxH"),
    ("ICD10", "E03.1", "E03.1 Congenital hypothyroidism without goitre", "a2iMp5Btvm0"),
    ("ICD10", "E03.2", "E03.2 Hypothyroidism due to medicaments and other exogenous substances", "fHxopopjdah"),
    ("ICD10", "E03.3", "E03.3 Postinfectious hypothyroidism", "pvcsYt0jKoV"),
    ("ICD10", "E03.4", "E03.4 Atrophy of thyroid (acquired)", "aXnMGesTWCp"),
    ("ICD10", "E03.5", "E03.5 Myxoedema coma", "kJ8RHz1YeQT"),
    ("ICD10", "E03.8", "E03.8 Other specified hypothyroidism", "DjsLGuo8atY"),
    ("ICD10", "E03.9", "E03.9 Hypothyroidism, unspecified", "ufqy5qfaTsz"),
    ("ICD10", "E04", "E04 Other nontoxic goitre", "aNA2pl1594D"),
    ("ICD10", "E04.0", "E04.0 Nontoxic diffuse goitre", "VzwvvcDCOZf"),
    ("ICD10", "E04.1", "E04.1 Nontoxic single thyroid nodule", "wJLD0xgCs1e"),
    ("ICD10", "E04.2", "E04.2 Nontoxic multinodular goitre", "lEGxW5mEvxA"),
    ("ICD10", "E04.8", "E04.8 Other specified nontoxic goitre", "H1njzLLWgSh"),
    ("ICD10", "E04.9", "E04.9 Nontoxic goitre, unspecified", "pn1tQlWclhu"),
    ("ICD10", "E05", "E05 Thyrotoxicosis [hyperthyroidism]", "mimhEQBQHN5"),
    ("ICD10", "E05.0", "E05.0 Thyrotoxicosis with diffuse goitre", "BFAWj2HC0TA"),
    ("ICD10", "E05.1", "E05.1 Thyrotoxicosis with toxic single thyroid nodule", "MIWEiBFEO4K"),
    ("ICD10", "E05.2", "E05.2 Thyrotoxicosis with toxic multinodular goitre", "LG0lZ5Bymse"),
    ("ICD10", "E05.3", "E05.3 Thyrotoxicosis from ectopic thyroid tissue", "SwwiEK27RUm"),
    ("ICD10", "E05.4", "E05.4 Thyrotoxicosis factitia", "WC3dTJsy5yh"),
    ("ICD10", "E05.5", "E05.5 Thyroid crisis or storm", "gPqpeRyuEMI"),
    ("ICD10", "E05.8", "E05.8 Other thyrotoxicosis", "RgGF3gsuINX"),
    ("ICD10", "E05.9", "E05.9 Thyrotoxicosis, unspecified", "lXGeIonLvi5"),
    ("ICD10", "E06", "E06 Thyroiditis", "NZKcBFgvwW2"),
    ("ICD10", "E06.0", "E06.0 Acute thyroiditis", "exXCCpq9Wd4"),
    ("ICD10", "E06.1", "E06.1 Subacute thyroiditis", "ukzBpsU4MzU"),
    ("ICD10", "E06.2", "E06.2 Chronic thyroiditis with transient thyrotoxicosis", "AVcwr1RQ30N"),
    ("ICD10", "E06.3", "E06.3 Autoimmune thyroiditis", "mWOdiT9b22C"),
    ("ICD10", "E06.4", "E06.4 Drug-induced thyroiditis", "lopMd3XyaGh"),
    ("ICD10", "E06.5", "E06.5 Other chronic thyroiditis", "p49w6oApwyh"),
    ("ICD10", "E06.9", "E06.9 Thyroiditis, unspecified", "SIyHb9Y5cSj"),
    ("ICD10", "E07", "E07 Other disorders of thyroid", "gKLh6rTE4qT"),
    ("ICD10", "E07.0", "E07.0 Hypersecretion of calcitonin", "fDSPcBggDQB"),
    ("ICD10", "E07.1", "E07.1 Dyshormogenetic goitre", "f8Nd8ebq08B"),
    ("ICD10", "E07.8", "E07.8 Other specified disorders of thyroid", "wilk8qBly8k"),
    ("ICD10", "E07.9", "E07.9 Disorder of thyroid, unspecified", "aDUVTwAg6VK"),
    ("ICD10", "E10", "E10 Type 1 diabetes mellitus", "fxNI54uckh5"),
    ("ICD10", "E11", "E11 Type 2 diabetes mellitus", "mg9QnOxi0ig"),
    ("ICD10", "E12", "E12 Malnutrition-related diabetes mellitus", "lnO7u1hM9vZ"),
    ("ICD10", "E13", "E13 Other specified diabetes mellitus", "ij6xltQO8GV"),
    ("ICD10", "E14", "E14 Unspecified diabetes mellitus", "Ve1Cy4jmse4"),
    ("ICD10", "E15", "E15 Nondiabetic hypoglycaemic coma", "ADhrHIpOZOO"),
    ("ICD10", "E16", "E16 Other disorders of pancreatic internal secretion", "Pd6FwxJEMTw"),
    ("ICD10", "E16.0", "E16.0 Drug-induced hypoglycaemia without coma", "JwqlPDsmnxx"),
    ("ICD10", "E16.1", "E16.1 Other hypoglycaemia", "CpYABeZbjXM"),
    ("ICD10", "E16.2", "E16.2 Hypoglycaemia, unspecified", "zYdxJvbZAw2"),
    ("ICD10", "E16.3", "E16.3 Increased secretion of glucagon", "LRgbb2YIj4V"),
    ("ICD10", "E16.4", "E16.4 Abnormal secretion of gastrin", "RSHJmW9dWt9"),
    ("ICD10", "E16.8", "E16.8 Other specified disorders of pancreatic internal secretion", "LjFSqNTSW81"),
    ("ICD10", "E16.9", "E16.9 Disorder of pancreatic internal secretion, unspecified", "hkECZa7MIIL"),
    ("ICD10", "E20", "E20 Hypoparathyroidism", "R6w9Rtdj8Tg"),
    ("ICD10", "E20.0", "E20.0 Idiopathic hypoparathyroidism", "kFpmQLOohYu"),
    ("ICD10", "E20.1", "E20.1 Pseudohypoparathyroidism", "LcOyeDXBCLb"),
    ("ICD10", "E20.8", "E20.8 Other hypoparathyroidism", "h8lpOaH17rR"),
    ("ICD10", "E20.9", "E20.9 Hypoparathyroidism, unspecified", "xqZRzpoj0H4"),
    ("ICD10", "E21", "E21 Hyperparathyroidism and other disorders of parathyroid gland", "mjWIYSURaGN"),
    ("ICD10", "E21.0", "E21.0 Primary hyperparathyroidism", "AHdqYAsgyuc"),
    ("ICD10", "E21.1", "E21.1 Secondary hyperparathyroidism, not elsewhere classified", "Tdpq60cSrqi"),
    ("ICD10", "E21.2", "E21.2 Other hyperparathyroidism", "lRoIpvZjFDl"),
    ("ICD10", "E21.3", "E21.3 Hyperparathyroidism, unspecified", "KBvhcL7P0Wm"),
    ("ICD10", "E21.4", "E21.4 Other specified disorders of parathyroid gland", "h8sH2RQgzJ1"),
    ("ICD10", "E21.5", "E21.5 Disorder of parathyroid gland, unspecified", "RqZOONrrSKp"),
    ("ICD10", "E22", "E22 Hyperfunction of pituitary gland", "SyqxYBDDVbr"),
    ("ICD10", "E22.0", "E22.0 Acromegaly and pituitary gigantism", "mu6hPuNbuhq"),
    ("ICD10", "E22.1", "E22.1 Hyperprolactinaemia", "zVi8DBIHBA0"),
    ("ICD10", "E22.2", "E22.2 Syndrome of inappropriate secretion of antidiuretic hormone", "TVfPCnFnUqy"),
    ("ICD10", "E22.8", "E22.8 Other hyperfunction of pituitary gland", "eIUQGz745QI"),
    ("ICD10", "E22.9", "E22.9 Hyperfunction of pituitary gland, unspecified", "eAGMedVTvui"),
    ("ICD10", "E23", "E23 Hypofunction and other disorders of pituitary gland", "J3jTOYlpfk8"),
    ("ICD10", "E23.0", "E23.0 Hypopituitarism", "BDO3x3WUJ8M"),
    ("ICD10", "E23.1", "E23.1 Drug-induced hypopituitarism", "yO6gSr2t2g1"),
    ("ICD10", "E23.2", "E23.2 Diabetes insipidus", "dq9KDbYkARG"),
    ("ICD10", "E23.3", "E23.3 Hypothalamic dysfunction, not elsewhere classified", "bVhGG4gkuCc"),
    ("ICD10", "E23.6", "E23.6 Other disorders of pituitary gland", "Z3ktd4rvT4c"),
    ("ICD10", "E23.7", "E23.7 Disorder of pituitary gland, unspecified", "rSn8RUK3VTc"),
    ("ICD10", "E24", "E24 Cushing syndrome", "wyLm41zYCbV"),
    ("ICD10", "E24.0", "E24.0 Pituitary-dependent Cushing disease", "H83k44MofVl"),
    ("ICD10", "E24.1", "E24.1 Nelson syndrome", "X9qwSGyX24q"),
    ("ICD10", "E24.2", "E24.2 Drug-induced Cushing syndrome", "v5TBBa5dB11"),
    ("ICD10", "E24.3", "E24.3 Ectopic ACTH syndrome", "ECC9QOEKW59"),
    ("ICD10", "E24.4", "E24.4 Alcohol-induced pseudo-Cushing syndrome", "nFxFitt9z8k"),
    ("ICD10", "E24.8", "E24.8 Other Cushing syndrome", "ohL6sFebf6k"),
    ("ICD10", "E24.9", "E24.9 Cushing syndrome, unspecified", "IHuxCyL0O0a"),
    ("ICD10", "E25", "E25 Adrenogenital disorders", "QmfKzIs8Ywk"),
    ("ICD10", "E25.0", "E25.0 Congenital adrenogenital disorders associated with enzyme deficiency", "Tli6dOaElpY"),
    ("ICD10", "E25.8", "E25.8 Other adrenogenital disorders", "ZrEWb7w6CPQ"),
    ("ICD10", "E25.9", "E25.9 Adrenogenital disorder, unspecified", "riZUahyaB6G"),
    ("ICD10", "E26", "E26 Hyperaldosteronism", "qH9wCyZvRhM"),
    ("ICD10", "E26.0", "E26.0 Primary hyperaldosteronism", "dRbOS0A6Shm"),
    ("ICD10", "E26.1", "E26.1 Secondary hyperaldosteronism", "GX7L1mm80Zb"),
    ("ICD10", "E26.8", "E26.8 Other hyperaldosteronism", "QAEmJgZsP7f"),
    ("ICD10", "E26.9", "E26.9 Hyperaldosteronism, unspecified", "UQGBHLVkhko"),
    ("ICD10", "E27", "E27 Other disorders of adrenal gland", "NZjtc0ZdVLt"),
    ("ICD10", "E27.0", "E27.0 Other adrenocortical overactivity", "xOCEQ0BFWyn"),
    ("ICD10", "E27.1", "E27.1 Primary adrenocortical insufficiency", "RchhQwuacH6"),
    ("ICD10", "E27.2", "E27.2 Addisonian crisis", "p3ejqFDZQGd"),
    ("ICD10", "E27.3", "E27.3 Drug-induced adrenocortical insufficiency", "qhw6yvSgoGp"),
    ("ICD10", "E27.4", "E27.4 Other and unspecified adrenocortical insufficiency", "evCGdQdtzai"),
    ("ICD10", "E27.5", "E27.5 Adrenomedullary hyperfunction", "BSJk5gtgXvA"),
    ("ICD10", "E27.8", "E27.8 Other specified disorders of adrenal gland", "pHjX0eRgmVf"),
    ("ICD10", "E27.9", "E27.9 Disorder of adrenal gland, unspecified", "Cf0J2ywagS3"),
    ("ICD10", "E28", "E28 Ovarian dysfunction", "D0JJ7OuF8Rl"),
    ("ICD10", "E28.0", "E28.0 Ovarian dysfunction: Estrogen excess", "jZS4r8GbGnA"),
    ("ICD10", "E28.1", "E28.1 Ovarian dysfunction: Androgen excess", "oXdBHC9Wazm"),
    ("ICD10", "E28.2", "E28.2 Polycystic ovarian syndrome", "zRmGtYSOgOm"),
    ("ICD10", "E28.3", "E28.3 Primary ovarian failure", "i5td2jeV7Zo"),
    ("ICD10", "E28.8", "E28.8 Other ovarian dysfunction", "pFh48WOR199"),
    ("ICD10", "E28.9", "E28.9 Ovarian dysfunction, unspecified", "rFRVjABPcbT"),
    ("ICD10", "E29", "E29 Testicular dysfunction", "jyBRMSxD0Rc"),
    ("ICD10", "E29.0", "E29.0 Testicular hyperfunction", "SKPUVSMD92U"),
    ("ICD10", "E29.1", "E29.1 Testicular hypofunction", "rRgayBdhCjQ"),
    ("ICD10", "E29.8", "E29.8 Other testicular dysfunction", "bE1YrnbdM31"),
    ("ICD10", "E29.9", "E29.9 Testicular dysfunction, unspecified", "VYIiQMilTJD"),
    ("ICD10", "E30", "E30 Disorders of puberty, not elsewhere classified", "QV5c0r2hXTX"),
    ("ICD10", "E30.0", "E30.0 Delayed puberty", "wA1IcuI3Hhg"),
    ("ICD10", "E30.1", "E30.1 Precocious puberty", "C7NrNYIsbsb"),
    ("ICD10", "E30.8", "E30.8 Other disorders of puberty", "DZTqdM1BUt7"),
    ("ICD10", "E30.9", "E30.9 Disorder of puberty, unspecified", "pUCG9JeeYDf"),
    ("ICD10", "E31", "E31 Polyglandular dysfunction", "WeeAcaPUPbA"),
    ("ICD10", "E31.0", "E31.0 Autoimmune polyglandular failure", "KzQeQMejkVW"),
    ("ICD10", "E31.1", "E31.1 Polyglandular hyperfunction", "nArnsI4Zq3X"),
    ("ICD10", "E31.8", "E31.8 Other polyglandular dysfunction", "YY3bjmbSSN1"),
    ("ICD10", "E31.9", "E31.9 Polyglandular dysfunction, unspecified", "zsy4qWuKGg3"),
    ("ICD10", "E32", "E32 Diseases of thymus", "hqBCsizKLsC"),
    ("ICD10", "E32.0", "E32.0 Persistent hyperplasia of thymus", "f25pA2hOMIG"),
    ("ICD10", "E32.1", "E32.1 Abscess of thymus", "GeDjf0ynjD0"),
    ("ICD10", "E32.8", "E32.8 Other diseases of thymus", "h1C9dcLAjmj"),
    ("ICD10", "E32.9", "E32.9 Disease of thymus, unspecified", "WyhtzcqTNq7"),
    ("ICD10", "E34", "E34 Other endocrine disorders", "mTkWD4rt9s4"),
    ("ICD10", "E34.0", "E34.0 Carcinoid syndrome", "bysmqOB7N6t"),
    ("ICD10", "E34.1", "E34.1 Other hypersecretion of intestinal hormones", "Zr4ByupMWrg"),
    ("ICD10", "E34.2", "E34.2 Ectopic hormone secretion, not elsewhere classified", "oIbN9zjifSD"),
    ("ICD10", "E34.3", "E34.3 Short stature, not elsewhere classified", "fEbsuyt80j1"),
    ("ICD10", "E34.4", "E34.4 Constitutional tall stature", "RnbGZRUJqJ7"),
    ("ICD10", "E34.5", "E34.5 Androgen resistance syndrome", "XnuYAOKhxyu"),
    ("ICD10", "E34.8", "E34.8 Other specified endocrine disorders", "QaG2RPdzWHC"),
    ("ICD10", "E34.9", "E34.9 Endocrine disorder, unspecified", "CWpDgOWZBEW"),
    ("ICD10", "E35", "E35 Disorders of endocrine glands in diseases classified elsewhere", "Bc7xvLHEHR4"),
    ("ICD10", "E35.0", "E35.0 Disorders of thyroid gland in diseases classified elsewhere", "frxLBXLggoh"),
    ("ICD10", "E35.1", "E35.1 Disorders of adrenal glands in diseases classified elsewhere", "c4mCjSzCd1q"),
    ("ICD10", "E35.8", "E35.8 Disorders of other endocrine glands in diseases classified elsewhere", "kul1t7KyHGE"),
    ("ICD10", "E40", "E40 Kwashiorkor", "oQQMjsCSoAc"),
    ("ICD10", "E41", "E41 Nutritional marasmus", "lV8elm8QrBA"),
    ("ICD10", "E42", "E42 Marasmic kwashiorkor", "pmbuxJqzEZd"),
    ("ICD10", "E43", "E43 Unspecified severe protein-energy malnutrition", "xz8qnaBhwrs"),
    ("ICD10", "E44", "E44 Protein-energy malnutrition of moderate and mild degree", "VeSbnuBkR4o"),
    ("ICD10", "E44.0", "E44.0 Moderate protein-energy malnutrition", "YWFlZKJ3aBc"),
    ("ICD10", "E44.1", "E44.1 Mild protein-energy malnutrition", "ErbzVeb1BQy"),
    ("ICD10", "E45", "E45 Retarded development following protein-energy malnutrition", "oEr2lxIVT4G"),
    ("ICD10", "E46", "E46 Unspecified protein-energy malnutrition", "mupCDQMBMFw"),
    ("ICD10", "E50", "E50 Vitamin A deficiency", "mViW4w3cJ03"),
    ("ICD10", "E50.0", "E50.0 Vitamin A deficiency with conjunctival xerosis", "WFSid20Oxy3"),
    ("ICD10", "E50.1", "E50.1 Vitamin A deficiency with Bitot spot and conjunctival xerosis", "DrNA8COe19q"),
    ("ICD10", "E50.2", "E50.2 Vitamin A deficiency with corneal xerosis", "eQKiNS03iYb"),
    ("ICD10", "E50.3", "E50.3 Vitamin A deficiency with corneal ulceration and xerosis", "YQQLy8FQUju"),
    ("ICD10", "E50.4", "E50.4 Vitamin A deficiency with keratomalacia", "NzcXqFQEXqc"),
    ("ICD10", "E50.5", "E50.5 Vitamin A deficiency with night blindness", "l0jwSYKnHyl"),
    ("ICD10", "E50.6", "E50.6 Vitamin A deficiency with xerophthalmic scars of cornea", "dQyRpXNlzIY"),
    ("ICD10", "E50.7", "E50.7 Other ocular manifestations of vitamin A deficiency", "mwA4zSEMfVf"),
    ("ICD10", "E50.8", "E50.8 Other manifestations of vitamin A deficiency", "CAHu0meGHcK"),
    ("ICD10", "E50.9", "E50.9 Vitamin A deficiency, unspecified", "QQGIxNyZ3IQ"),
    ("ICD10", "E51", "E51 Thiamine deficiency", "rlzLoBDDZgq"),
    ("ICD10", "E51.1", "E51.1 Beriberi", "ONhZQxFqoHH"),
    ("ICD10", "E51.2", "E51.2 Wernicke encephalopathy", "AHPMsmERZGm"),
    ("ICD10", "E51.8", "E51.8 Other manifestations of thiamine deficiency", "os6AF5T4kF5"),
    ("ICD10", "E51.9", "E51.9 Thiamine deficiency, unspecified", "B1sd59Nyr0U"),
    ("ICD10", "E52", "E52 Niacin deficiency [pellagra]", "fWbuTi7EjAj"),
    ("ICD10", "E53", "E53 Deficiency of other B group vitamins", "A2V5wm66Ffh"),
    ("ICD10", "E53.0", "E53.0 Riboflavin deficiency", "HrTDnz5stl3"),
    ("ICD10", "E53.1", "E53.1 Pyridoxine deficiency", "dP6cAwhGrWE"),
    ("ICD10", "E53.8", "E53.8 Deficiency of other specified B group vitamins", "gMdKq3gYHzx"),
    ("ICD10", "E53.9", "E53.9 Vitamin B deficiency, unspecified", "W1QN1tuvJ0B"),
    ("ICD10", "E54", "E54 Ascorbic acid deficiency", "WZD9Xw29Pay"),
    ("ICD10", "E55", "E55 Vitamin D deficiency", "riwB8GmF23z"),
    ("ICD10", "E55.0", "E55.0 Rickets, active", "W6unL99SvpJ"),
    ("ICD10", "E55.9", "E55.9 Vitamin D deficiency, unspecified", "On1rHFxFoJ9"),
    ("ICD10", "E56", "E56 Other vitamin deficiencies", "nIsIKjAAsZ5"),
    ("ICD10", "E56.0", "E56.0 Deficiency of vitamin E", "SqCMq1TAcZB"),
    ("ICD10", "E56.1", "E56.1 Deficiency of vitamin K", "PLrV8HgMIK3"),
    ("ICD10", "E56.8", "E56.8 Deficiency of other vitamins", "MFzNPKucFHd"),
    ("ICD10", "E56.9", "E56.9 Vitamin deficiency, unspecified", "zAU9cPmSLzY"),
    ("ICD10", "E58", "E58 Dietary calcium deficiency", "rvHHccrXQFJ"),
    ("ICD10", "E59", "E59 Dietary selenium deficiency", "WgQvWsLbGcj"),
    ("ICD10", "E60", "E60 Dietary zinc deficiency", "bvHxDl3mfVo"),
    ("ICD10", "E61", "E61 Deficiency of other nutrient elements", "OxossL577Er"),
    ("ICD10", "E61.0", "E61.0 Copper deficiency", "wUgpxB4VogV"),
    ("ICD10", "E61.1", "E61.1 Iron deficiency", "vBCBSLV2QXI"),
    ("ICD10", "E61.2", "E61.2 Magnesium deficiency", "vrUCFl26wGS"),
    ("ICD10", "E61.3", "E61.3 Manganese deficiency", "c2TsbbwPDz1"),
    ("ICD10", "E61.4", "E61.4 Chromium deficiency", "m3r8PPimRiz");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "E61.5", "E61.5 Molybdenum deficiency", "Tl1ljhMk0c1"),
    ("ICD10", "E61.6", "E61.6 Vanadium deficiency", "D2HjYq1B0on"),
    ("ICD10", "E61.7", "E61.7 Deficiency of multiple nutrient elements", "L7uL3z74u9L"),
    ("ICD10", "E61.8", "E61.8 Deficiency of other specified nutrient elements", "Fnsq9TE2BJb"),
    ("ICD10", "E61.9", "E61.9 Deficiency of nutrient element, unspecified", "SNUpTX3Z1LG"),
    ("ICD10", "E63", "E63 Other nutritional deficiencies", "c5JNlgGzxwa"),
    ("ICD10", "E63.0", "E63.0 Essential fatty acid [EFA] deficiency", "Q019TyOBhRv"),
    ("ICD10", "E63.1", "E63.1 Imbalance of constituents of food intake", "dPUhJ0lMzA8"),
    ("ICD10", "E63.8", "E63.8 Other specified nutritional deficiencies", "JORn6jiZaoB"),
    ("ICD10", "E63.9", "E63.9 Nutritional deficiency, unspecified", "isCZjZCCw6g"),
    ("ICD10", "E64", "E64 Sequelae of malnutrition and other nutritional deficiencies", "ZxhIz2daIYs"),
    ("ICD10", "E64.0", "E64.0 Sequelae of protein-energy malnutrition", "Hgd1fPbcyBr"),
    ("ICD10", "E64.1", "E64.1 Sequelae of vitamin A deficiency", "hUSnEYLx3uC"),
    ("ICD10", "E64.2", "E64.2 Sequelae of vitamin C deficiency", "U6zXDWiSPnJ"),
    ("ICD10", "E64.3", "E64.3 Sequelae of rickets", "DCFaCrtG7dP"),
    ("ICD10", "E64.8", "E64.8 Sequelae of other nutritional deficiencies", "a1hhlpbpIv9"),
    ("ICD10", "E64.9", "E64.9 Sequelae of unspecified nutritional deficiency", "HmGacMftFgi"),
    ("ICD10", "E65", "E65 Localized adiposity", "nfRRdLIqd6T"),
    ("ICD10", "E66", "E66 Obesity", "XwikO0h9RzZ"),
    ("ICD10", "E66.0", "E66.0 Obesity due to excess calories", "bU41anMRC4F"),
    ("ICD10", "E66.1", "E66.1 Drug-induced obesity", "pf7VMEFxQkm"),
    ("ICD10", "E66.2", "E66.2 Extreme obesity with alveolar hypoventilation", "D7HUsjfX2T6"),
    ("ICD10", "E66.8", "E66.8 Other obesity", "MpgDJdBXAWz"),
    ("ICD10", "E66.9", "E66.9 Obesity, unspecified", "PxlfYZXjb13"),
    ("ICD10", "E67", "E67 Other hyperalimentation", "zqzGfOHvvbF"),
    ("ICD10", "E67.0", "E67.0 Hypervitaminosis A", "wvZmephghrJ"),
    ("ICD10", "E67.1", "E67.1 Hypercarotenaemia", "qFW5ScPj242"),
    ("ICD10", "E67.2", "E67.2 Megavitamin-B", "rrNJ1AbAx6L"),
    ("ICD10", "E67.3", "E67.3 Hypervitaminosis D", "GyA1lpYGh32"),
    ("ICD10", "E67.8", "E67.8 Other specified hyperalimentation", "YM07jZ8uLBZ"),
    ("ICD10", "E68", "E68 Sequelae of hyperalimentation", "hC4DR0fJEGH"),
    ("ICD10", "E70", "E70 Disorders of aromatic amino-acid metabolism", "njKF9DGOBAO"),
    ("ICD10", "E70.0", "E70.0 Classical phenylketonuria", "MG0XIMDJJmB"),
    ("ICD10", "E70.1", "E70.1 Other hyperphenylalaninaemias", "hQciT4PqDkw"),
    ("ICD10", "E70.2", "E70.2 Disorders of tyrosine metabolism", "ZQw4GI7iUpz"),
    ("ICD10", "E70.3", "E70.3 Albinism", "RgvB937JVXf"),
    ("ICD10", "E70.8", "E70.8 Other disorders of aromatic amino-acid metabolism", "lfLmVpTSY1o"),
    ("ICD10", "E70.9", "E70.9 Disorder of aromatic amino-acid metabolism, unspecified", "PClKFbOd0H1"),
    ("ICD10", "E71", "E71 Disorders of branched-chain amino-acid metabolism and fatty-acid metabolism", "ec9tE4ZPy6W"),
    ("ICD10", "E71.0", "E71.0 Maple-syrup-urine disease", "r9a9lDGuLC2"),
    ("ICD10", "E71.1", "E71.1 Other disorders of branched-chain amino-acid metabolism", "VlSKw4EeXFx"),
    ("ICD10", "E71.2", "E71.2 Disorder of branched-chain amino-acid metabolism, unspecified", "S1JhLCgzbCy"),
    ("ICD10", "E71.3", "E71.3 Disorders of fatty-acid metabolism", "mIw5ETsyVZo"),
    ("ICD10", "E72", "E72 Other disorders of amino-acid metabolism", "RTPRZGRAuXh"),
    ("ICD10", "E72.0", "E72.0 Disorders of amino-acid transport", "PMjBzN9tLHf"),
    ("ICD10", "E72.1", "E72.1 Disorders of sulfur-bearing amino-acid metabolism", "i8JghieMluU"),
    ("ICD10", "E72.2", "E72.2 Disorders of urea cycle metabolism", "VsYBPI9LlPC"),
    ("ICD10", "E72.3", "E72.3 Disorders of lysine and hydroxylysine metabolism", "GM5I2yYCa6f"),
    ("ICD10", "E72.4", "E72.4 Disorders of ornithine metabolism", "g6sHmzcPq4m"),
    ("ICD10", "E72.5", "E72.5 Disorders of glycine metabolism", "A2BUkAGypIs"),
    ("ICD10", "E72.8", "E72.8 Other specified disorders of amino-acid metabolism", "vTvnJym6lxu"),
    ("ICD10", "E72.9", "E72.9 Disorder of amino-acid metabolism, unspecified", "fkFNWvZAuET"),
    ("ICD10", "E73", "E73 Lactose intolerance", "V1fY0qwe9zR"),
    ("ICD10", "E73.0", "E73.0 Congenital lactase deficiency", "GaV7vAV93Kn"),
    ("ICD10", "E73.1", "E73.1 Secondary lactase deficiency", "BqIeVPc8gBL"),
    ("ICD10", "E73.8", "E73.8 Other lactose intolerance", "KMoohKeknyJ"),
    ("ICD10", "E73.9", "E73.9 Lactose intolerance, unspecified", "IMUVFOAOx1I"),
    ("ICD10", "E74", "E74 Other disorders of carbohydrate metabolism", "ONcU0sIVMh1"),
    ("ICD10", "E74.0", "E74.0 Glycogen storage disease", "yMRCCIlFGRt"),
    ("ICD10", "E74.1", "E74.1 Disorders of fructose metabolism", "v6Pywf1eVBA"),
    ("ICD10", "E74.2", "E74.2 Disorders of galactose metabolism", "NtC3NkSlPze"),
    ("ICD10", "E74.3", "E74.3 Other disorders of intestinal carbohydrate absorption", "dVMYFLzFLDA"),
    ("ICD10", "E74.4", "E74.4 Disorders of pyruvate metabolism and gluconeogenesis", "ZUGGhO0K1xV"),
    ("ICD10", "E74.8", "E74.8 Other specified disorders of carbohydrate metabolism", "lzTtUUizwM8"),
    ("ICD10", "E74.9", "E74.9 Disorder of carbohydrate metabolism, unspecified", "JXO62WINoE0"),
    ("ICD10", "E75", "E75 Disorders of sphingolipid metabolism and other lipid storage disorders", "mV5cD8qJ77l"),
    ("ICD10", "E75.0", "E75.0 GM", "bdAnYdMSZ43"),
    ("ICD10", "E75.1", "E75.1 Other gangliosidosis", "ZRFUJJBX5s5"),
    ("ICD10", "E75.2", "E75.2 Other sphingolipidosis", "aDC4qSo4KSv"),
    ("ICD10", "E75.3", "E75.3 Sphingolipidosis, unspecified", "g0Dl7YBVORD"),
    ("ICD10", "E75.4", "E75.4 Neuronal ceroid lipofuscinosis", "UF0jt47tVi4"),
    ("ICD10", "E75.5", "E75.5 Other lipid storage disorders", "lkAfRFrKa4O"),
    ("ICD10", "E75.6", "E75.6 Lipid storage disorder, unspecified", "gOVwopaJ5KP"),
    ("ICD10", "E76", "E76 Disorders of glycosaminoglycan metabolism", "pNSDrYPY747"),
    ("ICD10", "E76.0", "E76.0 Mucopolysaccharidosis, type I", "EQbhAeaV5Kc"),
    ("ICD10", "E76.1", "E76.1 Mucopolysaccharidosis, type II", "UD1PfQAeLEP"),
    ("ICD10", "E76.2", "E76.2 Other mucopolysaccharidoses", "Z18GtqEg9Il"),
    ("ICD10", "E76.3", "E76.3 Mucopolysaccharidosis, unspecified", "mhoJpL5GIKP"),
    ("ICD10", "E76.8", "E76.8 Other disorders of glucosaminoglycan metabolism", "N6vKUFWL8hT"),
    ("ICD10", "E76.9", "E76.9 Disorder of glucosaminoglycan metabolism, unspecified", "SppEFCdjJNW"),
    ("ICD10", "E77", "E77 Disorders of glycoprotein metabolism", "MjVLRNpYpdy"),
    ("ICD10", "E77.0", "E77.0 Defects in post-translational modification of lysosomal enzymes", "xZe5Qcpxhsj"),
    ("ICD10", "E77.1", "E77.1 Defects in glycoprotein degradation", "wDcbgz4fiTE"),
    ("ICD10", "E77.8", "E77.8 Other disorders of glycoprotein metabolism", "M533sblh2RR"),
    ("ICD10", "E77.9", "E77.9 Disorder of glycoprotein metabolism, unspecified", "GUL67mgKGDW"),
    ("ICD10", "E78", "E78 Disorders of lipoprotein metabolism and other lipidaemias", "xJ6ZqNO7c4A"),
    ("ICD10", "E78.0", "E78.0 Pure hypercholesterolaemia", "iVPJWWAWylW"),
    ("ICD10", "E78.1", "E78.1 Pure hyperglyceridaemia", "bT06qii204L"),
    ("ICD10", "E78.2", "E78.2 Mixed hyperlipidaemia", "WafqP8d8AHN"),
    ("ICD10", "E78.3", "E78.3 Hyperchylomicronaemia", "jDSwkJ4M08r"),
    ("ICD10", "E78.4", "E78.4 Other hyperlipidaemia", "CcXwEJUKgYU"),
    ("ICD10", "E78.5", "E78.5 Hyperlipidaemia, unspecified", "TFhTJrLRJpf"),
    ("ICD10", "E78.6", "E78.6 Lipoprotein deficiency", "UBsjQXCMPIu"),
    ("ICD10", "E78.8", "E78.8 Other disorders of lipoprotein metabolism", "a80bftzCSmq"),
    ("ICD10", "E78.9", "E78.9 Disorder of lipoprotein metabolism, unspecified", "PmjS0aOACD5"),
    ("ICD10", "E79", "E79 Disorders of purine and pyrimidine metabolism", "cwwhugucqCA"),
    ("ICD10", "E79.0", "E79.0 Hyperuricaemia without signs of inflammatory arthritis and tophaceous disease", "ZvIyGAzMMtG"),
    ("ICD10", "E79.1", "E79.1 Lesch-Nyhan syndrome", "FkrDons7VrD"),
    ("ICD10", "E79.8", "E79.8 Other disorders of purine and pyrimidine metabolism", "kq6GTGEwDhU"),
    ("ICD10", "E79.9", "E79.9 Disorder of purine and pyrimidine metabolism, unspecified", "nXeeRcav5A4"),
    ("ICD10", "E80", "E80 Disorders of porphyrin and bilirubin metabolism", "aJBqPjAbV0m"),
    ("ICD10", "E80.0", "E80.0 Hereditary erythropoietic porphyria", "tRl5Q4a3f7m"),
    ("ICD10", "E80.1", "E80.1 Porphyria cutanea tarda", "u2IeOmaLQaT"),
    ("ICD10", "E80.2", "E80.2 Other porphyria", "OYHv7YYpQpk"),
    ("ICD10", "E80.3", "E80.3 Defects of catalase and peroxidase", "PaGOynrQo6G"),
    ("ICD10", "E80.4", "E80.4 Gilbert syndrome", "lIfnOd5Q1Fs"),
    ("ICD10", "E80.5", "E80.5 Crigler-Najjar syndrome", "EhzP44xuriv"),
    ("ICD10", "E80.6", "E80.6 Other disorders of bilirubin metabolism", "xKwZ3aOOztC"),
    ("ICD10", "E80.7", "E80.7 Disorder of bilirubin metabolism, unspecified", "f2Nlo6pm0VK"),
    ("ICD10", "E83", "E83 Disorders of mineral metabolism", "dwu7WmNBsja"),
    ("ICD10", "E83.0", "E83.0 Disorders of copper metabolism", "ya97qkOLKUv"),
    ("ICD10", "E83.1", "E83.1 Disorders of iron metabolism", "ohKn70YcHgH"),
    ("ICD10", "E83.2", "E83.2 Disorders of zinc metabolism", "Ze5XcsNTy3S"),
    ("ICD10", "E83.3", "E83.3 Disorders of phosphorus metabolism and phosphatases", "jozJ78ZbwwL"),
    ("ICD10", "E83.4", "E83.4 Disorders of magnesium metabolism", "wdectMy8N1G"),
    ("ICD10", "E83.5", "E83.5 Disorders of calcium metabolism", "hOi6iHcGNl3"),
    ("ICD10", "E83.8", "E83.8 Other disorders of mineral metabolism", "g79k38amyWh"),
    ("ICD10", "E83.9", "E83.9 Disorder of mineral metabolism, unspecified", "L8hDsqeS5va"),
    ("ICD10", "E84", "E84 Cystic fibrosis", "JziZmJA9yFL"),
    ("ICD10", "E84.0", "E84.0 Cystic fibrosis with pulmonary manifestations", "iJm6Po8V5IT"),
    ("ICD10", "E84.1", "E84.1 Cystic fibrosis with intestinal manifestations", "M5GUZWbbGnV"),
    ("ICD10", "E84.8", "E84.8 Cystic fibrosis with other manifestations", "PdnRTUK7aen"),
    ("ICD10", "E84.9", "E84.9 Cystic fibrosis, unspecified", "ErpMzVF2ehH"),
    ("ICD10", "E85", "E85 Amyloidosis", "Zf1eNN89H83"),
    ("ICD10", "E85.0", "E85.0 Non-neuropathic heredofamilial amyloidosis", "JYN3ypm0j0Y"),
    ("ICD10", "E85.1", "E85.1 Neuropathic heredofamilial amyloidosis", "yAF50aMI6Hq"),
    ("ICD10", "E85.2", "E85.2 Heredofamilial amyloidosis, unspecified", "ycQeVCnhXj6"),
    ("ICD10", "E85.3", "E85.3 Secondary systemic amyloidosis", "Yi1fN1jw8Kt"),
    ("ICD10", "E85.4", "E85.4 Organ-limited amyloidosis", "QXt3wpCfAH7"),
    ("ICD10", "E85.8", "E85.8 Other amyloidosis", "M3Bhaz6YU68"),
    ("ICD10", "E85.9", "E85.9 Amyloidosis, unspecified", "qr76OVUSHIi"),
    ("ICD10", "E86", "E86 Volume depletion", "O6kebfTsr2o"),
    ("ICD10", "E87", "E87 Other disorders of fluid, electrolyte and acid-base balance", "FfRPlPweKSa"),
    ("ICD10", "E87.0", "E87.0 Hyperosmolality and hypernatraemia", "xnrtnEpGVGq"),
    ("ICD10", "E87.1", "E87.1 Hypo-osmolality and hyponatraemia", "fcSQkHhwEsf"),
    ("ICD10", "E87.2", "E87.2 Acidosis", "NJJSsg9LLVz"),
    ("ICD10", "E87.3", "E87.3 Alkalosis", "D2Pu3JIjVjQ"),
    ("ICD10", "E87.4", "E87.4 Mixed disorder of acid-base balance", "nYSNpIux4dp"),
    ("ICD10", "E87.5", "E87.5 Hyperkalaemia", "CqrVtW5NaeS"),
    ("ICD10", "E87.6", "E87.6 Hypokalaemia", "nnzQUpQHQaN"),
    ("ICD10", "E87.7", "E87.7 Fluid overload", "uMtJS3g3I7G"),
    ("ICD10", "E87.8", "E87.8 Other disorders of electrolyte and fluid balance, not elsewhere classified", "of5oHMdraae"),
    ("ICD10", "E88", "E88 Other metabolic disorders", "E920yNRI773"),
    ("ICD10", "E88.0", "E88.0 Disorders of plasma-protein metabolism, not elsewhere classified", "dwL9wSCV7my"),
    ("ICD10", "E88.1", "E88.1 Lipodystrophy, not elsewhere classified", "ApecnqzGuI1"),
    ("ICD10", "E88.2", "E88.2 Lipomatosis, not elsewhere classified", "P45Sn0iyuqC"),
    ("ICD10", "E88.3", "E88.3 Tumour lysis syndrome", "PVptFXajXjK"),
    ("ICD10", "E88.8", "E88.8 Other specified metabolic disorders", "SLvdcPg839W"),
    ("ICD10", "E88.9", "E88.9 Metabolic disorder, unspecified", "wbh9Yaxef2j"),
    ("ICD10", "E89", "E89 Postprocedural endocrine and metabolic disorders, not elsewhere classified", "f68HZiegoNE"),
    ("ICD10", "E89.0", "E89.0 Postprocedural hypothyroidism", "EKRWT7ERkq6"),
    ("ICD10", "E89.1", "E89.1 Postprocedural hypoinsulinaemia", "wW8DbE5Sxjs"),
    ("ICD10", "E89.2", "E89.2 Postprocedural hypoparathyroidism", "ExYeaQVzRPk"),
    ("ICD10", "E89.3", "E89.3 Postprocedural hypopituitarism", "pRbemFYpFxS"),
    ("ICD10", "E89.4", "E89.4 Postprocedural ovarian failure", "VYVIOI5QCHR"),
    ("ICD10", "E89.5", "E89.5 Postprocedural testicular hypofunction", "NCHpvlLrWpH"),
    ("ICD10", "E89.6", "E89.6 Postprocedural adrenocortical(-medullary) hypofunction", "LUvYYHJIcOJ"),
    ("ICD10", "E89.8", "E89.8 Other postprocedural endocrine and metabolic disorders", "lQ396EjX9jG"),
    ("ICD10", "E89.9", "E89.9 Postprocedural endocrine and metabolic disorder, unspecified", "sxrzK4y767E"),
    ("ICD10", "E90", "E90 Nutritional and metabolic disorders in diseases classified elsewhere", "UNhiBbV4ud8");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "F00", "F00 Dementia in Alzheimer disease", "pjO4K2ymGLH"),
    ("ICD10", "F00.0", "F00.0 Dementia in Alzheimer disease with early onset", "BqRBekcT3of"),
    ("ICD10", "F00.1", "F00.1 Dementia in Alzheimer disease with late onset", "sdSzllIcTod"),
    ("ICD10", "F00.2", "F00.2 Dementia in Alzheimer disease, atypical or mixed type", "mrRDm3wjavi"),
    ("ICD10", "F00.9", "F00.9 Dementia in Alzheimer disease, unspecified", "FISpYdUdH45"),
    ("ICD10", "F01", "F01 Vascular dementia", "GK3lwPvj8hZ"),
    ("ICD10", "F01.0", "F01.0 Vascular dementia of acute onset", "d5r98XIUqkL"),
    ("ICD10", "F01.1", "F01.1 Multi-infarct dementia", "FIBmZdMjCdj"),
    ("ICD10", "F01.2", "F01.2 Subcortical vascular dementia", "x9tNL1smFWk"),
    ("ICD10", "F01.3", "F01.3 Mixed cortical and subcortical vascular dementia", "Emq4bgBUtG4"),
    ("ICD10", "F01.8", "F01.8 Other vascular dementia", "oRAuBVN2NSg"),
    ("ICD10", "F01.9", "F01.9 Vascular dementia, unspecified", "nrEul353msg"),
    ("ICD10", "F02", "F02 Dementia in other diseases classified elsewhere", "IsHdd3mXeSs"),
    ("ICD10", "F02.0", "F02.0 Dementia in Pick disease", "tldovgtPxjh"),
    ("ICD10", "F02.1", "F02.1 Dementia in Creutzfeldt-Jakob disease", "yOLxWk8s0Yg"),
    ("ICD10", "F02.2", "F02.2 Dementia in Huntington disease", "WigMLwtNO6h"),
    ("ICD10", "F02.3", "F02.3 Dementia in Parkinson disease", "QhWX1weRO9S"),
    ("ICD10", "F02.4", "F02.4 Dementia in human immunodeficiency virus [HIV] disease", "Y0gLpXCd8Xy"),
    ("ICD10", "F02.8", "F02.8 Dementia in other specified diseases classified elsewhere", "AfNpNCWQoeV"),
    ("ICD10", "F03", "F03 Unspecified dementia", "XAClopa68kk"),
    ("ICD10", "F04", "F04 Organic amnesic syndrome, not induced by alcohol and other psychoactive substances", "HwSz5NYQUHD"),
    ("ICD10", "F05", "F05 Delirium, not induced by alcohol and other psychoactive substances", "k7Z2CU6AF8s"),
    ("ICD10", "F05.0", "F05.0 Delirium not superimposed on dementia, so described", "fIXQGvtUh9k"),
    ("ICD10", "F05.1", "F05.1 Delirium superimposed on dementia", "Njesgrzwl2R"),
    ("ICD10", "F05.8", "F05.8 Other delirium", "sew0vl7mPC1"),
    ("ICD10", "F05.9", "F05.9 Delirium, unspecified", "EsMuO6oh7Eh"),
    ("ICD10", "F06", "F06 Other mental disorders due to brain damage and dysfunction and to physical disease", "LLD4xzTaX3r"),
    ("ICD10", "F06.0", "F06.0 Organic hallucinosis", "zGgvvfIctKR"),
    ("ICD10", "F06.1", "F06.1 Organic catatonic disorder", "HhI2BhpEFro"),
    ("ICD10", "F06.2", "F06.2 Organic delusional [schizophrenia-like] disorder", "aOyjYC04x1P"),
    ("ICD10", "F06.3", "F06.3 Organic mood [affective] disorders", "QLq4LZ7JqzQ"),
    ("ICD10", "F06.4", "F06.4 Organic anxiety disorder", "RNASQ9MFQqv"),
    ("ICD10", "F06.5", "F06.5 Organic dissociative disorder", "s4WWkjULS5K"),
    ("ICD10", "F06.6", "F06.6 Organic emotionally labile [asthenic] disorder", "EOjYschNJSG"),
    ("ICD10", "F06.7", "F06.7 Mild cognitive disorder", "TcJOa8TY93q"),
    ("ICD10", "F06.8", "F06.8 Other specified mental disorders due to brain damage and dysfunction and to physical disease", "sx2Rn2eD0FJ"),
    ("ICD10", "F06.9", "F06.9 Unspecified mental disorder due to brain damage and dysfunction and to physical disease", "Yo6tR7H2axO"),
    ("ICD10", "F07", "F07 Personality and behavioural disorders due to brain disease, damage and dysfunction", "F5fm49t8Q1C"),
    ("ICD10", "F07.0", "F07.0 Organic personality disorder", "h5CcXU6X3Gi"),
    ("ICD10", "F07.1", "F07.1 Postencephalitic syndrome", "vY0ZrcSQZiU"),
    ("ICD10", "F07.2", "F07.2 Postconcussional syndrome", "in6FJ4JKRCx"),
    ("ICD10", "F07.8", "F07.8 Other organic personality and behavioural disorders due to brain disease, damage and dysfunction", "TIfnFEtQ9Za"),
    ("ICD10", "F07.9", "F07.9 Unspecified organic personality and behavioural disorder due to brain disease, damage and dysfunction", "HQ86l2Q0UwO"),
    ("ICD10", "F09", "F09 Unspecified organic or symptomatic mental disorder", "VcBhaiOZxfs"),
    ("ICD10", "F10", "F10 Mental and behavioural disorders due to use of alcohol", "vjT6KsDixGJ"),
    ("ICD10", "F11", "F11 Mental and behavioural disorders due to use of opioids", "paISQORQWoN"),
    ("ICD10", "F12", "F12 Mental and behavioural disorders due to use of cannabinoids", "CRjXUzGx6s3"),
    ("ICD10", "F13", "F13 Mental and behavioural disorders due to use of sedatives or hypnotics", "YIIHL8UpDWw"),
    ("ICD10", "F14", "F14 Mental and behavioural disorders due to use of cocaine", "NSp0BMenJeL"),
    ("ICD10", "F15", "F15 Mental and behavioural disorders due to use of other stimulants, including caffeine", "CB4DKL8M3tZ"),
    ("ICD10", "F16", "F16 Mental and behavioural disorders due to use of hallucinogens", "IWNfUSVpgEU"),
    ("ICD10", "F17", "F17 Mental and behavioural disorders due to use of tobacco", "R0Xq5kDZiAb"),
    ("ICD10", "F18", "F18 Mental and behavioural disorders due to use of volatile solvents", "prNZhAG1HB6"),
    ("ICD10", "F19", "F19 Mental and behavioural disorders due to multiple drug use and use of other psychoactive substances", "mHQvwoJyDu0"),
    ("ICD10", "F20", "F20 Schizophrenia", "qFOHzPYsjf7"),
    ("ICD10", "F20.0", "F20.0 Paranoid schizophrenia", "YMfpn3isEBi"),
    ("ICD10", "F20.1", "F20.1 Hebephrenic schizophrenia", "N3UVv1PijTH"),
    ("ICD10", "F20.2", "F20.2 Catatonic schizophrenia", "cyblVRLR19i"),
    ("ICD10", "F20.3", "F20.3 Undifferentiated schizophrenia", "K0vvYaN3Rwt"),
    ("ICD10", "F20.4", "F20.4 Post-schizophrenic depression", "fSXWUhqFA9a"),
    ("ICD10", "F20.5", "F20.5 Residual schizophrenia", "gpqKuJJXlC3"),
    ("ICD10", "F20.6", "F20.6 Simple schizophrenia", "lnxORSUBOOj"),
    ("ICD10", "F20.8", "F20.8 Other schizophrenia", "jBpsRNj8R82"),
    ("ICD10", "F20.9", "F20.9 Schizophrenia, unspecified", "WbYvkAozWij"),
    ("ICD10", "F21", "F21 Schizotypal disorder", "fGCxq1XDBHZ"),
    ("ICD10", "F22", "F22 Persistent delusional disorders", "v8I5IRFwp5X"),
    ("ICD10", "F22.0", "F22.0 Delusional disorder", "kHfOqFdrkUf"),
    ("ICD10", "F22.8", "F22.8 Other persistent delusional disorders", "MoT931M5g6F"),
    ("ICD10", "F22.9", "F22.9 Persistent delusional disorder, unspecified", "bW5XQw9y8OJ"),
    ("ICD10", "F23", "F23 Acute and transient psychotic disorders", "A2vYrosghXQ"),
    ("ICD10", "F23.0", "F23.0 Acute polymorphic psychotic disorder without symptoms of schizophrenia", "Q0GVyOkoFLw"),
    ("ICD10", "F23.1", "F23.1 Acute polymorphic psychotic disorder with symptoms of schizophrenia", "toESlpCoYJd"),
    ("ICD10", "F23.2", "F23.2 Acute schizophrenia-like psychotic disorder", "nFUbOjOt3cc"),
    ("ICD10", "F23.3", "F23.3 Other acute predominantly delusional psychotic disorders", "hyB2sZYMxGF"),
    ("ICD10", "F23.8", "F23.8 Other acute and transient psychotic disorders", "kC7glZwu7IF"),
    ("ICD10", "F23.9", "F23.9 Acute and transient psychotic disorder, unspecified", "cRr6klRUmE3"),
    ("ICD10", "F24", "F24 Induced delusional disorder", "AA1GomBIZye"),
    ("ICD10", "F25", "F25 Schizoaffective disorders", "ml8IkSUNmPa"),
    ("ICD10", "F25.0", "F25.0 Schizoaffective disorder, manic type", "fO71RKG8xbi"),
    ("ICD10", "F25.1", "F25.1 Schizoaffective disorder, depressive type", "eO1ueiV7ANV"),
    ("ICD10", "F25.2", "F25.2 Schizoaffective disorder, mixed type", "OAuKhh6hSDk"),
    ("ICD10", "F25.8", "F25.8 Other schizoaffective disorders", "dINdTRgNbuU"),
    ("ICD10", "F25.9", "F25.9 Schizoaffective disorder, unspecified", "pTSqwRsAEFh"),
    ("ICD10", "F28", "F28 Other nonorganic psychotic disorders", "SVLbJ7Bhhet"),
    ("ICD10", "F29", "F29 Unspecified nonorganic psychosis", "LETDKw7Rcig"),
    ("ICD10", "F30", "F30 Manic episode", "YHZzydN2Flq"),
    ("ICD10", "F30.0", "F30.0 Hypomania", "R9YZewe9ipp"),
    ("ICD10", "F30.1", "F30.1 Mania without psychotic symptoms", "p47yjfkdbb5"),
    ("ICD10", "F30.2", "F30.2 Mania with psychotic symptoms", "MOu5dK7aVuI"),
    ("ICD10", "F30.8", "F30.8 Other manic episodes", "PfpnqJyGUYj"),
    ("ICD10", "F30.9", "F30.9 Manic episode, unspecified", "wV80rvv8arX"),
    ("ICD10", "F31", "F31 Bipolar affective disorder", "pxzo7ufum1S"),
    ("ICD10", "F31.0", "F31.0 Bipolar affective disorder, current episode hypomanic", "BH4loAHGNpC"),
    ("ICD10", "F31.1", "F31.1 Bipolar affective disorder, current episode manic without psychotic symptoms", "EIvhi1Rfdmn"),
    ("ICD10", "F31.2", "F31.2 Bipolar affective disorder, current episode manic with psychotic symptoms", "E0D9TK3ugu9"),
    ("ICD10", "F31.3", "F31.3 Bipolar affective disorder, current episode mild or moderate depression", "i8YZdMa7jzM"),
    ("ICD10", "F31.4", "F31.4 Bipolar affective disorder, current episode severe depression without psychotic symptoms", "ApQ4m8nThaQ"),
    ("ICD10", "F31.5", "F31.5 Bipolar affective disorder, current episode severe depression with psychotic symptoms", "f1wr6wZYp0S"),
    ("ICD10", "F31.6", "F31.6 Bipolar affective disorder, current episode mixed", "jfYmGxfEXjS"),
    ("ICD10", "F31.7", "F31.7 Bipolar affective disorder, currently in remission", "pnxfXi37vfN"),
    ("ICD10", "F31.8", "F31.8 Other bipolar affective disorders", "ZEZgKd5x8fS"),
    ("ICD10", "F31.9", "F31.9 Bipolar affective disorder, unspecified", "q6EBkOzsTjp"),
    ("ICD10", "F32", "F32 Depressive episode", "viNzcyI4P00"),
    ("ICD10", "F32.0", "F32.0 Mild depressive episode", "IsXfnhcmTAq"),
    ("ICD10", "F32.1", "F32.1 Moderate depressive episode", "cfeLRBuMBA2"),
    ("ICD10", "F32.2", "F32.2 Severe depressive episode without psychotic symptoms", "eVsSFgBoBml"),
    ("ICD10", "F32.3", "F32.3 Severe depressive episode with psychotic symptoms", "jCJYXzvEXdg"),
    ("ICD10", "F32.8", "F32.8 Other depressive episodes", "TXW0kifcaNw"),
    ("ICD10", "F32.9", "F32.9 Depressive episode, unspecified", "fldgv2PV4Tl"),
    ("ICD10", "F33", "F33 Recurrent depressive disorder", "M0IRzPNhvxE"),
    ("ICD10", "F33.0", "F33.0 Recurrent depressive disorder, current episode mild", "zsvtpgOp7d9"),
    ("ICD10", "F33.1", "F33.1 Recurrent depressive disorder, current episode moderate", "q0BLEa9D8lV"),
    ("ICD10", "F33.2", "F33.2 Recurrent depressive disorder, current episode severe without psychotic symptoms", "iq4yvOw55gb"),
    ("ICD10", "F33.3", "F33.3 Recurrent depressive disorder, current episode severe with psychotic symptoms", "NZRNuGurgEp"),
    ("ICD10", "F33.4", "F33.4 Recurrent depressive disorder, currently in remission", "JTP7vzDxkNe"),
    ("ICD10", "F33.8", "F33.8 Other recurrent depressive disorders", "exbBGNdGW5E"),
    ("ICD10", "F33.9", "F33.9 Recurrent depressive disorder, unspecified", "LpWnYYA3lv7"),
    ("ICD10", "F34", "F34 Persistent mood [affective] disorders", "KZJiRhrxZF1"),
    ("ICD10", "F34.0", "F34.0 Cyclothymia", "E42obRD2TgM"),
    ("ICD10", "F34.1", "F34.1 Dysthymia", "iLzK7AmHuJ8"),
    ("ICD10", "F34.8", "F34.8 Other persistent mood [affective] disorders", "vcbkprO9Uqu"),
    ("ICD10", "F34.9", "F34.9 Persistent mood [affective] disorder, unspecified", "SEvXPhbHG9P"),
    ("ICD10", "F38", "F38 Other mood [affective] disorders", "SOBo0Sqpr9y"),
    ("ICD10", "F38.0", "F38.0 Other single mood [affective] disorders", "EJLeXTRWhqR"),
    ("ICD10", "F38.1", "F38.1 Other recurrent mood [affective] disorders", "r1xrXwXLMNc"),
    ("ICD10", "F38.8", "F38.8 Other specified mood [affective] disorders", "j5yx0c1qMKM"),
    ("ICD10", "F39", "F39 Unspecified mood [affective] disorder", "CvDBCXdFC92"),
    ("ICD10", "F40", "F40 Phobic anxiety disorders", "dqSoZoN5OJZ"),
    ("ICD10", "F40.0", "F40.0 Agoraphobia", "kGebN40NTz4"),
    ("ICD10", "F40.1", "F40.1 Social phobias", "jZxrLWtd0V0"),
    ("ICD10", "F40.2", "F40.2 Specific (isolated) phobias", "j2mR16T4zpy"),
    ("ICD10", "F40.8", "F40.8 Other phobic anxiety disorders", "m8q809wLHzq"),
    ("ICD10", "F40.9", "F40.9 Phobic anxiety disorder, unspecified", "dltOJArfCxh"),
    ("ICD10", "F41", "F41 Other anxiety disorders", "ijJN69VOxBG"),
    ("ICD10", "F41.0", "F41.0 Panic disorder [episodic paroxysmal anxiety]", "oqJs2dlA965"),
    ("ICD10", "F41.1", "F41.1 Generalized anxiety disorder", "fCNrrxhwncd"),
    ("ICD10", "F41.2", "F41.2 Mixed anxiety and depressive disorder", "Nus4ULiLouZ"),
    ("ICD10", "F41.3", "F41.3 Other mixed anxiety disorders", "WRumeIDLja4"),
    ("ICD10", "F41.8", "F41.8 Other specified anxiety disorders", "eQgX2Xhu9nT"),
    ("ICD10", "F41.9", "F41.9 Anxiety disorder, unspecified", "PgsWkMKSGKq"),
    ("ICD10", "F42", "F42 Obsessive-compulsive disorder", "UyLXu3sTvYa"),
    ("ICD10", "F42.0", "F42.0 Predominantly obsessional thoughts or ruminations", "dbvicHacFfF"),
    ("ICD10", "F42.1", "F42.1 Predominantly compulsive acts [obsessional rituals]", "hCU1KYlsbFx"),
    ("ICD10", "F42.2", "F42.2 Mixed obsessional thoughts and acts", "fNsfyONEgns"),
    ("ICD10", "F42.8", "F42.8 Other obsessive-compulsive disorders", "YKI4NSrikuN"),
    ("ICD10", "F42.9", "F42.9 Obsessive-compulsive disorder, unspecified", "ZZm6Z8VDmf0"),
    ("ICD10", "F43", "F43 Reaction to severe stress, and adjustment disorders", "NItdBHKEJN5"),
    ("ICD10", "F43.0", "F43.0 Acute stress reaction", "MA7rgs3ZJyH"),
    ("ICD10", "F43.1", "F43.1 Post-traumatic stress disorder", "W8nXLT0u94N"),
    ("ICD10", "F43.2", "F43.2 Adjustment disorders", "UWF2HzngB9B"),
    ("ICD10", "F43.8", "F43.8 Other reactions to severe stress", "ReWKCdAtqO6"),
    ("ICD10", "F43.9", "F43.9 Reaction to severe stress, unspecified", "frdKhC0bxwv"),
    ("ICD10", "F44", "F44 Dissociative [conversion] disorders", "xjx7oxBBfbB"),
    ("ICD10", "F44.0", "F44.0 Dissociative amnesia", "wfgKp4S2SSd"),
    ("ICD10", "F44.1", "F44.1 Dissociative fugue", "PBmVo3a7aKP"),
    ("ICD10", "F44.2", "F44.2 Dissociative stupor", "DViDP8E2hHM"),
    ("ICD10", "F44.3", "F44.3 Trance and possession disorders", "bJYeB7xfhmE"),
    ("ICD10", "F44.4", "F44.4 Dissociative motor disorders", "wqMORGNIgxM"),
    ("ICD10", "F44.5", "F44.5 Dissociative convulsions", "RqqppglmQMO"),
    ("ICD10", "F44.6", "F44.6 Dissociative anaesthesia and sensory loss", "XPQpxoEgIFW"),
    ("ICD10", "F44.7", "F44.7 Mixed dissociative [conversion] disorders", "nKTePSZsjzH"),
    ("ICD10", "F44.8", "F44.8 Other dissociative [conversion] disorders", "eFO1w58YhID"),
    ("ICD10", "F44.9", "F44.9 Dissociative [conversion] disorder, unspecified", "EzvVQgOhx2e"),
    ("ICD10", "F45", "F45 Somatoform disorders", "aIvEeCokWIf"),
    ("ICD10", "F45.0", "F45.0 Somatization disorder", "O6OoXOqv2lc"),
    ("ICD10", "F45.1", "F45.1 Undifferentiated somatoform disorder", "rylRaFSFJ5J"),
    ("ICD10", "F45.2", "F45.2 Hypochondriacal disorder", "Alq8RcAZvm3"),
    ("ICD10", "F45.3", "F45.3 Somatoform autonomic dysfunction", "xTsiIf7uAx6"),
    ("ICD10", "F45.4", "F45.4 Persistent somatoform pain disorder", "yA0XML4TNa0"),
    ("ICD10", "F45.8", "F45.8 Other somatoform disorders", "zIg2yZeuZ1s"),
    ("ICD10", "F45.9", "F45.9 Somatoform disorder, unspecified", "iuYV4Q2c3dS"),
    ("ICD10", "F48", "F48 Other neurotic disorders", "vwmyzDTFoxQ"),
    ("ICD10", "F48.0", "F48.0 Neurasthenia", "V96i7phqlNv"),
    ("ICD10", "F48.1", "F48.1 Depersonalization-derealization syndrome", "J76pVvPcXit"),
    ("ICD10", "F48.8", "F48.8 Other specified neurotic disorders", "XRXfn4Tf5Js"),
    ("ICD10", "F48.9", "F48.9 Neurotic disorder, unspecified", "T9c7ikXqN6i"),
    ("ICD10", "F50", "F50 Eating disorders", "X4w5pWCZEuL"),
    ("ICD10", "F50.0", "F50.0 Anorexia nervosa", "JhwFX19V4LV"),
    ("ICD10", "F50.1", "F50.1 Atypical anorexia nervosa", "slPl1Rprngx"),
    ("ICD10", "F50.2", "F50.2 Bulimia nervosa", "iax3Jl1vtnO"),
    ("ICD10", "F50.3", "F50.3 Atypical bulimia nervosa", "c0RNADtFCmA"),
    ("ICD10", "F50.4", "F50.4 Overeating associated with other psychological disturbances", "I2nJf7mQCbI"),
    ("ICD10", "F50.5", "F50.5 Vomiting associated with other psychological disturbances", "JANvveWlzgz"),
    ("ICD10", "F50.8", "F50.8 Other eating disorders", "LQNJnJFXHjr"),
    ("ICD10", "F50.9", "F50.9 Eating disorder, unspecified", "HUn0ILt4Ub1"),
    ("ICD10", "F51", "F51 Nonorganic sleep disorders", "m4d2nrmrl7o"),
    ("ICD10", "F51.0", "F51.0 Nonorganic insomnia", "gexqxh6I0RD"),
    ("ICD10", "F51.1", "F51.1 Nonorganic hypersomnia", "KP4Sdhyeq7k"),
    ("ICD10", "F51.2", "F51.2 Nonorganic disorder of the sleep-wake schedule", "AOOeq1m24pH"),
    ("ICD10", "F51.3", "F51.3 Sleepwalking [somnambulism]", "j1CQO3VnZ5Z"),
    ("ICD10", "F51.4", "F51.4 Sleep terrors [night terrors]", "S1vyR4w323P"),
    ("ICD10", "F51.5", "F51.5 Nightmares", "IF3TE9ora59"),
    ("ICD10", "F51.8", "F51.8 Other nonorganic sleep disorders", "WVKkpUQWpYf"),
    ("ICD10", "F51.9", "F51.9 Nonorganic sleep disorder, unspecified", "f5hvL5ATdnX"),
    ("ICD10", "F52", "F52 Sexual dysfunction, not caused by organic disorder or disease", "DKh60T0ZWt9"),
    ("ICD10", "F52.0", "F52.0 Lack or loss of sexual desire", "HPxL5Rn0a2z"),
    ("ICD10", "F52.1", "F52.1 Sexual aversion and lack of sexual enjoyment", "qYLc2JBXiy5"),
    ("ICD10", "F52.2", "F52.2 Failure of genital response", "ABu1Nx7pHRG"),
    ("ICD10", "F52.3", "F52.3 Orgasmic dysfunction", "fpV5kRL9gDc"),
    ("ICD10", "F52.4", "F52.4 Premature ejaculation", "l7alzRGbVOA"),
    ("ICD10", "F52.5", "F52.5 Nonorganic vaginismus", "QCmvj9pLVTI"),
    ("ICD10", "F52.6", "F52.6 Nonorganic dyspareunia", "j4ms13YMHxH"),
    ("ICD10", "F52.7", "F52.7 Excessive sexual drive", "IPLd2wTEqSI"),
    ("ICD10", "F52.8", "F52.8 Other sexual dysfunction, not caused by organic disorder or disease", "g232UpRfLcv"),
    ("ICD10", "F52.9", "F52.9 Unspecified sexual dysfunction, not caused by organic disorder or disease", "Ud4V6rneMLc"),
    ("ICD10", "F53", "F53 Mental and behavioural disorders associated with the puerperium, not elsewhere classified", "fJSYqkRWOsU"),
    ("ICD10", "F53.0", "F53.0 Mild mental and behavioural disorders associated with the puerperium, not elsewhere classified", "ZaS3LdQB3kJ"),
    ("ICD10", "F53.1", "F53.1 Severe mental and behavioural disorders associated with the puerperium, not elsewhere classified", "v0XoGnrRDZQ"),
    ("ICD10", "F53.8", "F53.8 Other mental and behavioural disorders associated with the puerperium, not elsewhere classified", "pMDWXhyyppo"),
    ("ICD10", "F53.9", "F53.9 Puerperal mental disorder, unspecified", "j9DHpEKPzVm"),
    ("ICD10", "F54", "F54 Psychological and behavioural factors associated with disorders or diseases classified elsewhere", "cAHbaxzqFR6"),
    ("ICD10", "F55", "F55 Abuse of non-dependence-producing substances", "vtlLgBBux2y"),
    ("ICD10", "F59", "F59 Unspecified behavioural syndromes associated with physiological disturbances and physical factors", "YxplDZgmGaq"),
    ("ICD10", "F60", "F60 Specific personality disorders", "mtt1PhIB49S"),
    ("ICD10", "F60.0", "F60.0 Paranoid personality disorder", "wT0SqGZxqo4"),
    ("ICD10", "F60.1", "F60.1 Schizoid personality disorder", "nH1lXRCYY3s"),
    ("ICD10", "F60.2", "F60.2 Dissocial personality disorder", "bP2eMnptkCV"),
    ("ICD10", "F60.3", "F60.3 Emotionally unstable personality disorder", "w0YRevvLMkD"),
    ("ICD10", "F60.4", "F60.4 Histrionic personality disorder", "E53Nr99Qr30"),
    ("ICD10", "F60.5", "F60.5 Anankastic personality disorder", "w5r6MZ9MFtH"),
    ("ICD10", "F60.6", "F60.6 Anxious [avoidant] personality disorder", "u6XeX1YSozd"),
    ("ICD10", "F60.7", "F60.7 Dependent personality disorder", "LHOmFOfsuHz"),
    ("ICD10", "F60.8", "F60.8 Other specific personality disorders", "e3SXL72wctF"),
    ("ICD10", "F60.9", "F60.9 Personality disorder, unspecified", "s7GXUqcOtBT"),
    ("ICD10", "F61", "F61 Mixed and other personality disorders", "mEiXbKeitJ4"),
    ("ICD10", "F62", "F62 Enduring personality changes, not attributable to brain damage and disease", "l2oI4vqzTWy"),
    ("ICD10", "F62.0", "F62.0 Enduring personality change after catastrophic experience", "xI9x6Leeq48"),
    ("ICD10", "F62.1", "F62.1 Enduring personality change after psychiatric illness", "ULFbvRLSevq"),
    ("ICD10", "F62.8", "F62.8 Other enduring personality changes", "M0NV5XT9uPT"),
    ("ICD10", "F62.9", "F62.9 Enduring personality change, unspecified", "aW7EN7kVtk5"),
    ("ICD10", "F63", "F63 Habit and impulse disorders", "ljxgR7gK6dX"),
    ("ICD10", "F63.0", "F63.0 Pathological gambling", "xN97SScIlZj"),
    ("ICD10", "F63.1", "F63.1 Pathological fire-setting [pyromania]", "yajCBvmK8lS"),
    ("ICD10", "F63.2", "F63.2 Pathological stealing [kleptomania]", "iPdOzmRAoca"),
    ("ICD10", "F63.3", "F63.3 Trichotillomania", "Qvot6UXCAKP"),
    ("ICD10", "F63.8", "F63.8 Other habit and impulse disorders", "nn9egf5yfuv"),
    ("ICD10", "F63.9", "F63.9 Habit and impulse disorder, unspecified", "gFmEBU1MPG5"),
    ("ICD10", "F64", "F64 Gender identity disorders", "DtAai04Q1YO"),
    ("ICD10", "F64.0", "F64.0 Transsexualism", "Oz0GmVAHMFk"),
    ("ICD10", "F64.1", "F64.1 Dual-role transvestism", "LpZ0CTywOTH"),
    ("ICD10", "F64.2", "F64.2 Gender identity disorder of childhood", "n8ovVSxnmrp"),
    ("ICD10", "F64.8", "F64.8 Other gender identity disorders", "KjbtuXoPKWk"),
    ("ICD10", "F64.9", "F64.9 Gender identity disorder, unspecified", "Ldv03Psx29w"),
    ("ICD10", "F65", "F65 Disorders of sexual preference", "j6HU8xYQhEA"),
    ("ICD10", "F65.0", "F65.0 Fetishism", "HBg9Q9VSLvl"),
    ("ICD10", "F65.1", "F65.1 Fetishistic transvestism", "xiZgbuTclm8"),
    ("ICD10", "F65.2", "F65.2 Exhibitionism", "t62I7yN4f8b"),
    ("ICD10", "F65.3", "F65.3 Voyeurism", "QshHMRp5dcm"),
    ("ICD10", "F65.4", "F65.4 Paedophilia", "PE6fTDerMR5"),
    ("ICD10", "F65.5", "F65.5 Sadomasochism", "A28sFcfPoM9"),
    ("ICD10", "F65.6", "F65.6 Multiple disorders of sexual preference", "iPjvzYPo6CZ"),
    ("ICD10", "F65.8", "F65.8 Other disorders of sexual preference", "j7It5J3O9n5"),
    ("ICD10", "F65.9", "F65.9 Disorder of sexual preference, unspecified", "gjFvRbCARrP"),
    ("ICD10", "F66", "F66 Psychological and behavioural disorders associated with sexual development and orientation", "YWrv2EfQtaL"),
    ("ICD10", "F66.0", "F66.0 Sexual maturation disorder", "yFe0UKNxfdu"),
    ("ICD10", "F66.1", "F66.1 Egodystonic sexual orientation", "LYkPUMw57Jl"),
    ("ICD10", "F66.2", "F66.2 Sexual relationship disorder", "Q2lNdj09XuY"),
    ("ICD10", "F66.8", "F66.8 Other psychosexual development disorders", "ue9vvOc6Mhs"),
    ("ICD10", "F66.9", "F66.9 Psychosexual development disorder, unspecified", "NhUYje2tnq8"),
    ("ICD10", "F68", "F68 Other disorders of adult personality and behaviour", "z7mmNmGNzUy"),
    ("ICD10", "F68.0", "F68.0 Elaboration of physical symptoms for psychological reasons", "fpfzWekRYhQ"),
    ("ICD10", "F68.1", "F68.1 Intentional production or feigning of symptoms or disabilities, either physical or psychological [factitious disorder]", "qha5HLG1od4"),
    ("ICD10", "F68.8", "F68.8 Other specified disorders of adult personality and behaviour", "qXSiIch8T63"),
    ("ICD10", "F69", "F69 Unspecified disorder of adult personality and behaviour", "PzHoxKszjAI"),
    ("ICD10", "F70", "F70 Mild mental retardation", "XjGWxMs5o0d"),
    ("ICD10", "F71", "F71 Moderate mental retardation", "n50h0sV5HyY"),
    ("ICD10", "F72", "F72 Severe mental retardation", "dv80Av9SGVT"),
    ("ICD10", "F73", "F73 Profound mental retardation", "YooqbrltbUn"),
    ("ICD10", "F78", "F78 Other mental retardation", "xLIGDMoLw44"),
    ("ICD10", "F79", "F79 Unspecified mental retardation", "kIMMgw0DQfC"),
    ("ICD10", "F80", "F80 Specific developmental disorders of speech and language", "YRFYDouxSOc"),
    ("ICD10", "F80.0", "F80.0 Specific speech articulation disorder", "iyLyHphUFsb"),
    ("ICD10", "F80.1", "F80.1 Expressive language disorder", "n3mf1hgrK9X"),
    ("ICD10", "F80.2", "F80.2 Receptive language disorder", "Q3LPXbLWbIt"),
    ("ICD10", "F80.3", "F80.3 Acquired aphasia with epilepsy [Landau-Kleffner]", "JsETU6bs5sc"),
    ("ICD10", "F80.8", "F80.8 Other developmental disorders of speech and language", "Xv5R5feK38D"),
    ("ICD10", "F80.9", "F80.9 Developmental disorder of speech and language, unspecified", "E0dzcbcVz45"),
    ("ICD10", "F81", "F81 Specific developmental disorders of scholastic skills", "DnoC48D7glA"),
    ("ICD10", "F81.0", "F81.0 Specific reading disorder", "ZqqNVaw89JM"),
    ("ICD10", "F81.1", "F81.1 Specific spelling disorder", "GzOq4bd3Bfn"),
    ("ICD10", "F81.2", "F81.2 Specific disorder of arithmetical skills", "yyJXyQGGe3K"),
    ("ICD10", "F81.3", "F81.3 Mixed disorder of scholastic skills", "d7k16COnXHo"),
    ("ICD10", "F81.8", "F81.8 Other developmental disorders of scholastic skills", "hinN4K3Jdty"),
    ("ICD10", "F81.9", "F81.9 Developmental disorder of scholastic skills, unspecified", "PGhGh4UiSaT"),
    ("ICD10", "F82", "F82 Specific developmental disorder of motor function", "r9br4XO0HtE"),
    ("ICD10", "F83", "F83 Mixed specific developmental disorders", "aCa6qtg3HeG"),
    ("ICD10", "F84", "F84 Pervasive developmental disorders", "IfzCgAq2q8G"),
    ("ICD10", "F84.0", "F84.0 Childhood autism", "BsKQIdXdQos"),
    ("ICD10", "F84.1", "F84.1 Atypical autism", "YALJlbnsd5d"),
    ("ICD10", "F84.2", "F84.2 Rett syndrome", "re82rZqxI84"),
    ("ICD10", "F84.3", "F84.3 Other childhood disintegrative disorder", "F9FXlbh32Dg");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "F84.4", "F84.4 Overactive disorder associated with mental retardation and stereotyped movements", "MrmwuPtrM5p"),
    ("ICD10", "F84.5", "F84.5 Asperger syndrome", "VxjoQIXwQnC"),
    ("ICD10", "F84.8", "F84.8 Other pervasive developmental disorders", "aFwe1Oc4aHk"),
    ("ICD10", "F84.9", "F84.9 Pervasive developmental disorder, unspecified", "wyodo4wDS40"),
    ("ICD10", "F88", "F88 Other disorders of psychological development", "gWGPh2eve65"),
    ("ICD10", "F89", "F89 Unspecified disorder of psychological development", "O94hgtUfJMZ"),
    ("ICD10", "F90", "F90 Hyperkinetic disorders", "OGIJDVEb6iF"),
    ("ICD10", "F90.0", "F90.0 Disturbance of activity and attention", "KG0WyLaHITA"),
    ("ICD10", "F90.1", "F90.1 Hyperkinetic conduct disorder", "RHH1nRYhaPF"),
    ("ICD10", "F90.8", "F90.8 Other hyperkinetic disorders", "Hw0VhaCTCL2"),
    ("ICD10", "F90.9", "F90.9 Hyperkinetic disorder, unspecified", "vFwM65KP9Qd"),
    ("ICD10", "F91", "F91 Conduct disorders", "IeRRGEiEzdG"),
    ("ICD10", "F91.0", "F91.0 Conduct disorder confined to the family context", "l1Vhm1z1aYA"),
    ("ICD10", "F91.1", "F91.1 Unsocialized conduct disorder", "TZLh5l9FEk7"),
    ("ICD10", "F91.2", "F91.2 Socialized conduct disorder", "qaSz5aFSwEn"),
    ("ICD10", "F91.3", "F91.3 Oppositional defiant disorder", "uoH7SO4Xa3F"),
    ("ICD10", "F91.8", "F91.8 Other conduct disorders", "fuGpYsjxmgC"),
    ("ICD10", "F91.9", "F91.9 Conduct disorder, unspecified", "XRcCEmTjgfy"),
    ("ICD10", "F92", "F92 Mixed disorders of conduct and emotions", "VviOj0zwZEQ"),
    ("ICD10", "F92.0", "F92.0 Depressive conduct disorder", "rsdnneiWxfD"),
    ("ICD10", "F92.8", "F92.8 Other mixed disorders of conduct and emotions", "MsfpmKwuTo8"),
    ("ICD10", "F92.9", "F92.9 Mixed disorder of conduct and emotions, unspecified", "FLhyUgfsUV5"),
    ("ICD10", "F93", "F93 Emotional disorders with onset specific to childhood", "ZHAZOROa3BI"),
    ("ICD10", "F93.0", "F93.0 Separation anxiety disorder of childhood", "zhHYDhnwaBs"),
    ("ICD10", "F93.1", "F93.1 Phobic anxiety disorder of childhood", "mUSXgWa10Ot"),
    ("ICD10", "F93.2", "F93.2 Social anxiety disorder of childhood", "WgoWqJ5PhyY"),
    ("ICD10", "F93.3", "F93.3 Sibling rivalry disorder", "Qy2tEEGFBcz"),
    ("ICD10", "F93.8", "F93.8 Other childhood emotional disorders", "We9q7vt33xJ"),
    ("ICD10", "F93.9", "F93.9 Childhood emotional disorder, unspecified", "CYSl90b3M31"),
    ("ICD10", "F94", "F94 Disorders of social functioning with onset specific to childhood and adolescence", "HgNRxoqYV70"),
    ("ICD10", "F94.0", "F94.0 Elective mutism", "sEkNKSOk0CJ"),
    ("ICD10", "F94.1", "F94.1 Reactive attachment disorder of childhood", "FDB2iOa4T5R"),
    ("ICD10", "F94.2", "F94.2 Disinhibited attachment disorder of childhood", "XkcvXGCvHoC"),
    ("ICD10", "F94.8", "F94.8 Other childhood disorders of social functioning", "OxPpzUzc7A6"),
    ("ICD10", "F94.9", "F94.9 Childhood disorder of social functioning, unspecified", "NQXvHqE6rG4"),
    ("ICD10", "F95", "F95 Tic disorders", "dj2aO6AGojA"),
    ("ICD10", "F95.0", "F95.0 Transient tic disorder", "D3rMKacowGP"),
    ("ICD10", "F95.1", "F95.1 Chronic motor or vocal tic disorder", "WQ8uQ8c2sFq"),
    ("ICD10", "F95.2", "F95.2 Combined vocal and multiple motor tic disorder [de la Tourette]", "GvYrHrSCuzS"),
    ("ICD10", "F95.8", "F95.8 Other tic disorders", "uDmXztLjQQS"),
    ("ICD10", "F95.9", "F95.9 Tic disorder, unspecified", "qO47BCKeltB"),
    ("ICD10", "F98", "F98 Other behavioural and emotional disorders with onset usually occurring in childhood and adolescence", "Gjs0OeV92Ek"),
    ("ICD10", "F98.0", "F98.0 Nonorganic enuresis", "kA3EAxOJpGH"),
    ("ICD10", "F98.1", "F98.1 Nonorganic encopresis", "VYHNv39wPCd"),
    ("ICD10", "F98.2", "F98.2 Feeding disorder of infancy and childhood", "nZG5ZHpJVSp"),
    ("ICD10", "F98.3", "F98.3 Pica of infancy and childhood", "xlY2adqqe5A"),
    ("ICD10", "F98.4", "F98.4 Stereotyped movement disorders", "vYoOjWvFPqL"),
    ("ICD10", "F98.5", "F98.5 Stuttering [stammering]", "coNHXqvqdoc"),
    ("ICD10", "F98.6", "F98.6 Cluttering", "FQ2aPhDw8FS"),
    ("ICD10", "F98.8", "F98.8 Other specified behavioural and emotional disorders with onset usually occurring in childhood and adolescence", "sXJJz3UFp4U"),
    ("ICD10", "F98.9", "F98.9 Unspecified behavioural and emotional disorders with onset usually occurring in childhood and adolescence", "C7lPFnSOhAo"),
    ("ICD10", "F99", "F99 Mental disorder, not otherwise specified", "UnRlDaXGJld");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "G00", "G00 Bacterial meningitis, not elsewhere classified", "F8OxiXQgJpJ"),
    ("ICD10", "G00.0", "G00.0 Haemophilus meningitis", "tedyHg1rTda"),
    ("ICD10", "G00.1", "G00.1 Pneumococcal meningitis", "Xm100oJYQ0i"),
    ("ICD10", "G00.2", "G00.2 Streptococcal meningitis", "WrKtgRZtUAp"),
    ("ICD10", "G00.3", "G00.3 Staphylococcal meningitis", "glzKEhSYexg"),
    ("ICD10", "G00.8", "G00.8 Other bacterial meningitis", "C4KIKkXBHGB"),
    ("ICD10", "G00.9", "G00.9 Bacterial meningitis, unspecified", "HicScTppsC5"),
    ("ICD10", "G01", "G01 Meningitis in bacterial diseases classified elsewhere", "fe4mUoyGhRn"),
    ("ICD10", "G02", "G02 Meningitis in other infectious and parasitic diseases classified elsewhere", "sg2nwpuKTOM"),
    ("ICD10", "G02.0", "G02.0 Meningitis in viral diseases classified elsewhere", "oE97GcMHeWi"),
    ("ICD10", "G02.1", "G02.1 Meningitis in mycoses", "hnctLHP6yEb"),
    ("ICD10", "G02.8", "G02.8 Meningitis in other specified infectious and parasitic diseases classified elsewhere", "xy8KLqCpxJp"),
    ("ICD10", "G03", "G03 Meningitis due to other and unspecified causes", "MqXpcCgc9Lg"),
    ("ICD10", "G03.0", "G03.0 Nonpyogenic meningitis", "cD8WO1XpEQa"),
    ("ICD10", "G03.1", "G03.1 Chronic meningitis", "A76NIu3Zos2"),
    ("ICD10", "G03.2", "G03.2 Benign recurrent meningitis [Mollaret]", "s3z8Dig3BjC"),
    ("ICD10", "G03.8", "G03.8 Meningitis due to other specified causes", "LF79M9ZdH9Z"),
    ("ICD10", "G03.9", "G03.9 Meningitis, unspecified", "P4SUYj3qVwQ"),
    ("ICD10", "G04", "G04 Encephalitis, myelitis and encephalomyelitis", "IicrfEw1DNt"),
    ("ICD10", "G04.0", "G04.0 Acute disseminated encephalitis", "rNfzJ7KWHPY"),
    ("ICD10", "G04.1", "G04.1 Tropical spastic paraplegia", "SBV9Z5bQwW5"),
    ("ICD10", "G04.2", "G04.2 Bacterial meningoencephalitis and meningomyelitis, not elsewhere classified", "flSTP7s0ejM"),
    ("ICD10", "G04.8", "G04.8 Other encephalitis, myelitis and encephalomyelitis", "CLejPsFmrer"),
    ("ICD10", "G04.9", "G04.9 Encephalitis, myelitis and encephalomyelitis, unspecified", "M1I0YT07evD"),
    ("ICD10", "G05", "G05 Encephalitis, myelitis and encephalomyelitis in diseases classified elsewhere", "bwveKw6IDJ0"),
    ("ICD10", "G05.0", "G05.0 Encephalitis, myelitis and encephalomyelitis in bacterial diseases classified elsewhere", "RXGJ2gmRod5"),
    ("ICD10", "G05.1", "G05.1 Encephalitis, myelitis and encephalomyelitis in viral diseases classified elsewhere", "o4aBJCYcjrr"),
    ("ICD10", "G05.2", "G05.2 Encephalitis, myelitis and encephalomyelitis in other infectious and parasitic diseases classified elsewhere", "kZ9WgZiNTpG"),
    ("ICD10", "G05.8", "G05.8 Encephalitis, myelitis and encephalomyelitis in other diseases classified elsewhere", "y9IYqQUrtlz"),
    ("ICD10", "G06", "G06 Intracranial and intraspinal abscess and granuloma", "elyUWvDLaPy"),
    ("ICD10", "G06.0", "G06.0 Intracranial abscess and granuloma", "PE6BW9WOal7"),
    ("ICD10", "G06.1", "G06.1 Intraspinal abscess and granuloma", "frHDCr8L1Tq"),
    ("ICD10", "G06.2", "G06.2 Extradural and subdural abscess, unspecified", "uPmTHKTguQs"),
    ("ICD10", "G07", "G07 Intracranial and intraspinal abscess and granuloma in diseases classified elsewhere", "cVdmU5VOl2G"),
    ("ICD10", "G08", "G08 Intracranial and intraspinal phlebitis and thrombophlebitis", "sgNIlEG5FMD"),
    ("ICD10", "G09", "G09 Sequelae of inflammatory diseases of central nervous system", "TBfsFV7vpi9"),
    ("ICD10", "G10", "G10 Huntington disease", "ZTS23AQFLxn"),
    ("ICD10", "G11", "G11 Hereditary ataxia", "VbRFDyIJDaU"),
    ("ICD10", "G11.0", "G11.0 Congenital nonprogressive ataxia", "Eyhsxou958T"),
    ("ICD10", "G11.1", "G11.1 Early-onset cerebellar ataxia", "wZJS4Qtucwi"),
    ("ICD10", "G11.2", "G11.2 Late-onset cerebellar ataxia", "QoUN6PIBvJJ"),
    ("ICD10", "G11.3", "G11.3 Cerebellar ataxia with defective DNA repair", "F0iUBitWGeZ"),
    ("ICD10", "G11.4", "G11.4 Hereditary spastic paraplegia", "ujLeZ3a8BgQ"),
    ("ICD10", "G11.8", "G11.8 Other hereditary ataxias", "vjp6wkyRn5X"),
    ("ICD10", "G11.9", "G11.9 Hereditary ataxia, unspecified", "A2SeuHbh64j"),
    ("ICD10", "G12", "G12 Spinal muscular atrophy and related syndromes", "kfeUzr8ciP7"),
    ("ICD10", "G12.0", "G12.0 Infantile spinal muscular atrophy, type I [Werdnig-Hoffman]", "Csf14GsMWz6"),
    ("ICD10", "G12.1", "G12.1 Other inherited spinal muscular atrophy", "Dm7mXlVX6MN"),
    ("ICD10", "G12.2", "G12.2 Motor neuron disease", "ZI6bpsvwuV4"),
    ("ICD10", "G12.8", "G12.8 Other spinal muscular atrophies and related syndromes", "QC9B821Ct9Q"),
    ("ICD10", "G12.9", "G12.9 Spinal muscular atrophy, unspecified", "U2mjTRRlIkx"),
    ("ICD10", "G13", "G13 Systemic atrophies primarily affecting central nervous system in diseases classified elsewhere", "jwuKKKzL9gk"),
    ("ICD10", "G13.0", "G13.0 Paraneoplastic neuromyopathy and neuropathy", "WnEK9bafXqW"),
    ("ICD10", "G13.1", "G13.1 Other systemic atrophy primarily affecting central nervous system in neoplastic disease", "eZ9DpTbvOxW"),
    ("ICD10", "G13.2", "G13.2 Systemic atrophy primarily affecting central nervous system in myxoedema", "utPnfdTVdvS"),
    ("ICD10", "G13.8", "G13.8 Systemic atrophy primarily affecting central nervous system in other diseases classified elsewhere", "plweypO296t"),
    ("ICD10", "G14", "G14 Postpolio syndrome", "NnXogGKyDcS"),
    ("ICD10", "G20", "G20 Parkinson disease", "qZqDnRdtGs5"),
    ("ICD10", "G21", "G21 Secondary parkinsonism", "Ntp585dBB7T"),
    ("ICD10", "G21.0", "G21.0 Malignant neuroleptic syndrome", "YXLgfiz7epr"),
    ("ICD10", "G21.1", "G21.1 Other drug-induced secondary parkinsonism", "yU5cLWKQKMZ"),
    ("ICD10", "G21.2", "G21.2 Secondary parkinsonism due to other external agents", "LnowNIFXLrh"),
    ("ICD10", "G21.3", "G21.3 Postencephalitic parkinsonism", "S5oAhu5dL6e"),
    ("ICD10", "G21.4", "G21.4 Vascular parkinsonism", "mZ14YQY8fYS"),
    ("ICD10", "G21.8", "G21.8 Other secondary parkinsonism", "f1E4ApbP6Fs"),
    ("ICD10", "G21.9", "G21.9 Secondary parkinsonism, unspecified", "qsJNG6rMR45"),
    ("ICD10", "G22", "G22 Parkinsonism in diseases classified elsewhere", "GxAoGByoSCg"),
    ("ICD10", "G23", "G23 Other degenerative diseases of basal ganglia", "OJxaVFOV7Ag"),
    ("ICD10", "G23.0", "G23.0 Hallervorden-Spatz disease", "t5rUT3k5p4n"),
    ("ICD10", "G23.1", "G23.1 Progressive supranuclear ophthalmoplegia [Steele-Richardson-Olszewski]", "edTSHuLOw8Y"),
    ("ICD10", "G23.2", "G23.2 Multiple system atrophy, parkinsonian type [MSA-P]", "SxMKbL7y1wg"),
    ("ICD10", "G23.3", "G23.3 Multiple system atrophy, cerebellar type [MSA-C]", "pWdoqyioEkD"),
    ("ICD10", "G23.8", "G23.8 Other specified degenerative diseases of basal ganglia", "kl4soYk6PGs"),
    ("ICD10", "G23.9", "G23.9 Degenerative disease of basal ganglia, unspecified", "PI9JmJgtgGj"),
    ("ICD10", "G24", "G24 Dystonia", "qF0yBJwVxIl"),
    ("ICD10", "G24.0", "G24.0 Drug-induced dystonia", "Xzq86T3rZyD"),
    ("ICD10", "G24.1", "G24.1 Idiopathic familial dystonia", "DLtdDg9WUCh"),
    ("ICD10", "G24.2", "G24.2 Idiopathic nonfamilial dystonia", "K0WFnPRthRt"),
    ("ICD10", "G24.3", "G24.3 Spasmodic torticollis", "gCkf2BtwOet"),
    ("ICD10", "G24.4", "G24.4 Idiopathic orofacial dystonia", "cZ8AJdzeLEh"),
    ("ICD10", "G24.5", "G24.5 Blepharospasm", "kxryMfIlkP0"),
    ("ICD10", "G24.8", "G24.8 Other dystonia", "Fh69uVud8WT"),
    ("ICD10", "G24.9", "G24.9 Dystonia, unspecified", "aPyT9TTR35h"),
    ("ICD10", "G25", "G25 Other extrapyramidal and movement disorders", "W90SnGQpqtM"),
    ("ICD10", "G25.0", "G25.0 Essential tremor", "eRh0Ti07FUs"),
    ("ICD10", "G25.1", "G25.1 Drug-induced tremor", "V8P0EdBvbP8"),
    ("ICD10", "G25.2", "G25.2 Other specified forms of tremor", "xJo4xFcX1zR"),
    ("ICD10", "G25.3", "G25.3 Myoclonus", "RSkaRjA7VSr"),
    ("ICD10", "G25.4", "G25.4 Drug-induced chorea", "R3bcvJKKTP1"),
    ("ICD10", "G25.5", "G25.5 Other chorea", "tNFUs7i8W59"),
    ("ICD10", "G25.6", "G25.6 Drug-induced tics and other tics of organic origin", "q9v3r2is8yQ"),
    ("ICD10", "G25.8", "G25.8 Other specified extrapyramidal and movement disorders", "ERM02wE1rAg"),
    ("ICD10", "G25.9", "G25.9 Extrapyramidal and movement disorder, unspecified", "tE3ZGIztalo"),
    ("ICD10", "G26", "G26 Extrapyramidal and movement disorders in diseases classified elsewhere", "XxKShoCw56l"),
    ("ICD10", "G30", "G30 Alzheimer disease", "ZMhODgT43t9"),
    ("ICD10", "G30.0", "G30.0 Alzheimer disease with early onset", "iMIzDTQsKeo"),
    ("ICD10", "G30.1", "G30.1 Alzheimer disease with late onset", "vDcnAgP1JVY"),
    ("ICD10", "G30.8", "G30.8 Other Alzheimer disease", "T26uD6zEaA8"),
    ("ICD10", "G30.9", "G30.9 Alzheimer disease, unspecified", "MtSevpYGjWE"),
    ("ICD10", "G31", "G31 Other degenerative diseases of nervous system, not elsewhere classified", "UAKB8vnyVPb"),
    ("ICD10", "G31.0", "G31.0 Circumscribed brain atrophy", "WcBZaTHbEOj"),
    ("ICD10", "G31.1", "G31.1 Senile degeneration of brain, not elsewhere classified", "Q3XJLcSveNq"),
    ("ICD10", "G31.2", "G31.2 Degeneration of nervous system due to alcohol", "erffqVcT7mh"),
    ("ICD10", "G31.8", "G31.8 Other specified degenerative diseases of nervous system", "tNgM396tMA8"),
    ("ICD10", "G31.9", "G31.9 Degenerative disease of nervous system, unspecified", "a1IRPTUzGgI"),
    ("ICD10", "G32", "G32 Other degenerative disorders of nervous system in diseases classified elsewhere", "YeIgf9zfAZc"),
    ("ICD10", "G32.0", "G32.0 Subacute combined degeneration of spinal cord in diseases classified elsewhere", "Q1P4rdKCTZ2"),
    ("ICD10", "G32.8", "G32.8 Other specified degenerative disorders of nervous system in diseases classified elsewhere", "wNWI6TsYHiS"),
    ("ICD10", "G35", "G35 Multiple sclerosis", "wQ8IXnBRdHm"),
    ("ICD10", "G36", "G36 Other acute disseminated demyelination", "ApJaUZrhgIe"),
    ("ICD10", "G36.0", "G36.0 Neuromyelitis optica [Devic]", "hRlofUix7Vq"),
    ("ICD10", "G36.1", "G36.1 Acute and subacute haemorrhagic leukoencephalitis [Hurst]", "T1sK7fkHqwI"),
    ("ICD10", "G36.8", "G36.8 Other specified acute disseminated demyelination", "wjXBjGjjwMo"),
    ("ICD10", "G36.9", "G36.9 Acute disseminated demyelination, unspecified", "RqcLvfEUEi1"),
    ("ICD10", "G37", "G37 Other demyelinating diseases of central nervous system", "yaW5KLYtSmE"),
    ("ICD10", "G37.0", "G37.0 Diffuse sclerosis", "yl4zlsgi8hC"),
    ("ICD10", "G37.1", "G37.1 Central demyelination of corpus callosum", "cEKYnkyUDmz"),
    ("ICD10", "G37.2", "G37.2 Central pontine myelinolysis", "C2Zm9h1CCQi"),
    ("ICD10", "G37.3", "G37.3 Acute transverse myelitis in demyelinating disease of central nervous system", "Pry7D1x9mUK"),
    ("ICD10", "G37.4", "G37.4 Subacute necrotizing myelitis", "Wv9qMQe5x8H"),
    ("ICD10", "G37.5", "G37.5 Concentric sclerosis [Baló]", "hGvUva7aFTq"),
    ("ICD10", "G37.8", "G37.8 Other specified demyelinating diseases of central nervous system", "iPH6daPtwE0"),
    ("ICD10", "G37.9", "G37.9 Demyelinating disease of central nervous system, unspecified", "HzzBoeeXUNo"),
    ("ICD10", "G40", "G40 Epilepsy", "llmBtKhJk0F"),
    ("ICD10", "G40.0", "G40.0 Localization-related (focal)(partial) idiopathic epilepsy and epileptic syndromes with seizures of localized onset", "swdbgRAv9OS"),
    ("ICD10", "G40.1", "G40.1 Localization-related (focal)(partial) symptomatic epilepsy and epileptic syndromes with simple partial seizures", "c3RHAcPVG69"),
    ("ICD10", "G40.2", "G40.2 Localization-related (focal)(partial) symptomatic epilepsy and epileptic syndromes with complex partial seizures", "i9cFlbsPrIR"),
    ("ICD10", "G40.3", "G40.3 Generalized idiopathic epilepsy and epileptic syndromes", "wmOC1EDdV4f"),
    ("ICD10", "G40.4", "G40.4 Other generalized epilepsy and epileptic syndromes", "rV8aDdshhrt"),
    ("ICD10", "G40.5", "G40.5 Special epileptic syndromes", "lRQsqD86pQ0"),
    ("ICD10", "G40.6", "G40.6 Grand mal seizures, unspecified (with or without petit mal)", "qrcYqa6pOPB"),
    ("ICD10", "G40.7", "G40.7 Petit mal, unspecified, without grand mal seizures", "SOlzbvDvrTZ"),
    ("ICD10", "G40.8", "G40.8 Other epilepsy", "A7pzCfQA8No"),
    ("ICD10", "G40.9", "G40.9 Epilepsy, unspecified", "mSVAkOsTvHf"),
    ("ICD10", "G41", "G41 Status epilepticus", "nnFLWuDDTzy"),
    ("ICD10", "G41.0", "G41.0 Grand mal status epilepticus", "CB51Isrxqv2"),
    ("ICD10", "G41.1", "G41.1 Petit mal status epilepticus", "KsnV2shIlOx"),
    ("ICD10", "G41.2", "G41.2 Complex partial status epilepticus", "unrEQtdGsJF"),
    ("ICD10", "G41.8", "G41.8 Other status epilepticus", "AY7Ju4Fy0vj"),
    ("ICD10", "G41.9", "G41.9 Status epilepticus, unspecified", "k0UURt5mfdr"),
    ("ICD10", "G43", "G43 Migraine", "y1i7DgiTPXA"),
    ("ICD10", "G43.0", "G43.0 Migraine without aura [common migraine]", "vLm0MCMsUtH"),
    ("ICD10", "G43.1", "G43.1 Migraine with aura [classical migraine]", "tdVlXpTkcSP"),
    ("ICD10", "G43.2", "G43.2 Status migrainosus", "lMXi9bmmUBB"),
    ("ICD10", "G43.3", "G43.3 Complicated migraine", "aYMsehJrSkN"),
    ("ICD10", "G43.8", "G43.8 Other migraine", "dfruo6ReVcZ"),
    ("ICD10", "G43.9", "G43.9 Migraine, unspecified", "Y7dEyz7FQgX"),
    ("ICD10", "G44", "G44 Other headache syndromes", "C3LS9OPpBT3"),
    ("ICD10", "G44.0", "G44.0 Cluster headache syndrome", "UAdDBqzKvhA"),
    ("ICD10", "G44.1", "G44.1 Vascular headache, not elsewhere classified", "wOhyiPyYa2v"),
    ("ICD10", "G44.2", "G44.2 Tension-type headache", "mc4WnnM9wQ3"),
    ("ICD10", "G44.3", "G44.3 Chronic post-traumatic headache", "emZsHZrEd2K"),
    ("ICD10", "G44.4", "G44.4 Drug-induced headache, not elsewhere classified", "S7qMQTckmvC"),
    ("ICD10", "G44.8", "G44.8 Other specified headache syndromes", "DQlirZ35Lbs"),
    ("ICD10", "G45", "G45 Transient cerebral ischaemic attacks and related syndromes", "YrcsgqJy20S"),
    ("ICD10", "G45.0", "G45.0 Vertebro-basilar artery syndrome", "ztd7y5N8cG9"),
    ("ICD10", "G45.1", "G45.1 Carotid artery syndrome (hemispheric)", "ItE8hn6dQks"),
    ("ICD10", "G45.2", "G45.2 Multiple and bilateral precerebral artery syndromes", "y5kKE6iZt4X"),
    ("ICD10", "G45.3", "G45.3 Amaurosis fugax", "J2mqW7btPWm"),
    ("ICD10", "G45.4", "G45.4 Transient global amnesia", "tMZODW7SgfX"),
    ("ICD10", "G45.8", "G45.8 Other transient cerebral ischaemic attacks and related syndromes", "yWpgleUwYEl"),
    ("ICD10", "G45.9", "G45.9 Transient cerebral ischaemic attack, unspecified", "Ch4rCFcvdW2"),
    ("ICD10", "G46", "G46 Vascular syndromes of brain in cerebrovascular diseases", "yNhIIAnI7v2"),
    ("ICD10", "G46.0", "G46.0 Middle cerebral artery syndrome", "WVg1q9MenBr"),
    ("ICD10", "G46.1", "G46.1 Anterior cerebral artery syndrome", "wkWrXMVUxQj"),
    ("ICD10", "G46.2", "G46.2 Posterior cerebral artery syndrome", "qGfRuRlG1Uc"),
    ("ICD10", "G46.3", "G46.3 Brain stem stroke syndrome", "ElSz4HxE6GB"),
    ("ICD10", "G46.4", "G46.4 Cerebellar stroke syndrome", "x69o3nPO9pR"),
    ("ICD10", "G46.5", "G46.5 Pure motor lacunar syndrome", "PvN2s7aOLUT"),
    ("ICD10", "G46.6", "G46.6 Pure sensory lacunar syndrome", "ur5mIagWcNU"),
    ("ICD10", "G46.7", "G46.7 Other lacunar syndromes", "PKQLOS2bk4w"),
    ("ICD10", "G46.8", "G46.8 Other vascular syndromes of brain in cerebrovascular diseases", "NudCz5kDcpG"),
    ("ICD10", "G47", "G47 Sleep disorders", "Tpv77TTntLa"),
    ("ICD10", "G47.0", "G47.0 Disorders of initiating and maintaining sleep [insomnias]", "T8SKHuI2jhn"),
    ("ICD10", "G47.1", "G47.1 Disorders of excessive somnolence [hypersomnias]", "A8rzjjzjTmw"),
    ("ICD10", "G47.2", "G47.2 Disorders of the sleep-wake schedule", "yCdMWWFJ0wW"),
    ("ICD10", "G47.3", "G47.3 Sleep apnoea", "kLND4mle0bN"),
    ("ICD10", "G47.4", "G47.4 Narcolepsy and cataplexy", "ywV0AR79iOq"),
    ("ICD10", "G47.8", "G47.8 Other sleep disorders", "jplsFyCnB6a"),
    ("ICD10", "G47.9", "G47.9 Sleep disorder, unspecified", "KXtdzvXQo2g"),
    ("ICD10", "G50", "G50 Disorders of trigeminal nerve", "R0pULmmuqCl"),
    ("ICD10", "G50.0", "G50.0 Trigeminal neuralgia", "X3DDRafzDer"),
    ("ICD10", "G50.1", "G50.1 Atypical facial pain", "xwk4FuZG3mp"),
    ("ICD10", "G50.8", "G50.8 Other disorders of trigeminal nerve", "liFzccPyXg0"),
    ("ICD10", "G50.9", "G50.9 Disorder of trigeminal nerve, unspecified", "uAizDE5yIRO"),
    ("ICD10", "G51", "G51 Facial nerve disorders", "Fe3EFgZyW0V"),
    ("ICD10", "G51.0", "G51.0 Bell palsy", "PHzouwoldbu"),
    ("ICD10", "G51.1", "G51.1 Geniculate ganglionitis", "MpAXLYwbVBo"),
    ("ICD10", "G51.2", "G51.2 Melkersson syndrome", "tygY1qsMv5V"),
    ("ICD10", "G51.3", "G51.3 Clonic hemifacial spasm", "m7UrBITaugy"),
    ("ICD10", "G51.4", "G51.4 Facial myokymia", "ipbmM1n4Pfx"),
    ("ICD10", "G51.8", "G51.8 Other disorders of facial nerve", "cBO4dxKGb74"),
    ("ICD10", "G51.9", "G51.9 Disorder of facial nerve, unspecified", "dGfxT5N7Igq"),
    ("ICD10", "G52", "G52 Disorders of other cranial nerves", "XweQBhLKfw9"),
    ("ICD10", "G52.0", "G52.0 Disorders of olfactory nerve", "j3CdUoKHtbd"),
    ("ICD10", "G52.1", "G52.1 Disorders of glossopharyngeal nerve", "wFMwBOVjz3E"),
    ("ICD10", "G52.2", "G52.2 Disorders of vagus nerve", "myghHO2tVSX"),
    ("ICD10", "G52.3", "G52.3 Disorders of hypoglossal nerve", "afK9fCpIwbp"),
    ("ICD10", "G52.7", "G52.7 Disorders of multiple cranial nerves", "tv8UTcOiGlF"),
    ("ICD10", "G52.8", "G52.8 Disorders of other specified cranial nerves", "xKssc8oSmI2"),
    ("ICD10", "G52.9", "G52.9 Cranial nerve disorder, unspecified", "lFIT89jksU3"),
    ("ICD10", "G53", "G53 Cranial nerve disorders in diseases classified elsewhere", "wKKZ1QJbhCd"),
    ("ICD10", "G53.0", "G53.0 Postzoster neuralgia", "tGfora4hbW6"),
    ("ICD10", "G53.1", "G53.1 Multiple cranial nerve palsies in infectious and parasitic diseases classified elsewhere", "PqS7a3NyAkw"),
    ("ICD10", "G53.2", "G53.2 Multiple cranial nerve palsies in sarcoidosis", "O5zydf4Hz4l"),
    ("ICD10", "G53.3", "G53.3 Multiple cranial nerve palsies in neoplastic disease", "K0UUOfwFRVB"),
    ("ICD10", "G53.8", "G53.8 Other cranial nerve disorders in other diseases classified elsewhere", "fyi4TtcKq61"),
    ("ICD10", "G54", "G54 Nerve root and plexus disorders", "EnwEabV0Dk1"),
    ("ICD10", "G54.0", "G54.0 Brachial plexus disorders", "zW5imEj1TgB"),
    ("ICD10", "G54.1", "G54.1 Lumbosacral plexus disorders", "hgJ0raPmd9s"),
    ("ICD10", "G54.2", "G54.2 Cervical root disorders, not elsewhere classified", "NstSQQ3RCF7"),
    ("ICD10", "G54.3", "G54.3 Thoracic root disorders, not elsewhere classified", "CYItq7H2Fl2"),
    ("ICD10", "G54.4", "G54.4 Lumbosacral root disorders, not elsewhere classified", "AtCZjMloaju"),
    ("ICD10", "G54.5", "G54.5 Neuralgic amyotrophy", "skNkdfZ6E3K"),
    ("ICD10", "G54.6", "G54.6 Phantom limb syndrome with pain", "ut0NQLtqe1s"),
    ("ICD10", "G54.7", "G54.7 Phantom limb syndrome without pain", "tT0quiQrE6H"),
    ("ICD10", "G54.8", "G54.8 Other nerve root and plexus disorders", "kWJ3r4Tj7YF"),
    ("ICD10", "G54.9", "G54.9 Nerve root and plexus disorder, unspecified", "BBEPGOgqHAe"),
    ("ICD10", "G55", "G55 Nerve root and plexus compressions in diseases classified elsewhere", "ZOvO0378wBQ"),
    ("ICD10", "G55.0", "G55.0 Nerve root and plexus compressions in neoplastic disease", "fsDTwM0BScd"),
    ("ICD10", "G55.1", "G55.1 Nerve root and plexus compressions in intervertebral disc disorders", "BwlPrEUo5RG"),
    ("ICD10", "G55.2", "G55.2 Nerve root and plexus compressions in spondylosis", "pMyi2JcFBU2"),
    ("ICD10", "G55.3", "G55.3 Nerve root and plexus compressions in other dorsopathies", "M8AwDieW1xq"),
    ("ICD10", "G55.8", "G55.8 Nerve root and plexus compressions in other diseases classified elsewhere", "nHcomDwyEGM"),
    ("ICD10", "G56", "G56 Mononeuropathies of upper limb", "i8n0OI19jOn"),
    ("ICD10", "G56.0", "G56.0 Carpal tunnel syndrome", "ssJRBp4cu3e"),
    ("ICD10", "G56.1", "G56.1 Other lesions of median nerve", "UhS15HvhhCL"),
    ("ICD10", "G56.2", "G56.2 Lesion of ulnar nerve", "tiHzKOEJIXs"),
    ("ICD10", "G56.3", "G56.3 Lesion of radial nerve", "F3oWsTXTgNC"),
    ("ICD10", "G56.4", "G56.4 Causalgia", "Qo2129l6mv5"),
    ("ICD10", "G56.8", "G56.8 Other mononeuropathies of upper limb", "oW4svCjdUKF"),
    ("ICD10", "G56.9", "G56.9 Mononeuropathy of upper limb, unspecified", "QYnQF7ADtbu"),
    ("ICD10", "G57", "G57 Mononeuropathies of lower limb", "Ym9n0L9SsWm"),
    ("ICD10", "G57.0", "G57.0 Lesion of sciatic nerve", "eoTue5Y9t28"),
    ("ICD10", "G57.1", "G57.1 Meralgia paraesthetica", "h2Nqtcr293t"),
    ("ICD10", "G57.2", "G57.2 Lesion of femoral nerve", "IL0FjDVxzzU"),
    ("ICD10", "G57.3", "G57.3 Lesion of lateral popliteal nerve", "FHIG5pZgJzZ"),
    ("ICD10", "G57.4", "G57.4 Lesion of medial popliteal nerve", "m7liHAFGExc"),
    ("ICD10", "G57.5", "G57.5 Tarsal tunnel syndrome", "LRbP2rmvoN2"),
    ("ICD10", "G57.6", "G57.6 Lesion of plantar nerve", "r3OSKEqGQZz"),
    ("ICD10", "G57.8", "G57.8 Other mononeuropathies of lower limb", "EKwDXGwjINi"),
    ("ICD10", "G57.9", "G57.9 Mononeuropathy of lower limb, unspecified", "peA96yHvMUT"),
    ("ICD10", "G58", "G58 Other mononeuropathies", "xzCu2h1u4J4"),
    ("ICD10", "G58.0", "G58.0 Intercostal neuropathy", "g72Rigws7Fd"),
    ("ICD10", "G58.7", "G58.7 Mononeuritis multiplex", "GAfSHAjDmyP"),
    ("ICD10", "G58.8", "G58.8 Other specified mononeuropathies", "zzXEC3Q6Fgb"),
    ("ICD10", "G58.9", "G58.9 Mononeuropathy, unspecified", "VcNLOaYKbx1"),
    ("ICD10", "G59", "G59 Mononeuropathy in diseases classified elsewhere", "HWGakiqRlhh"),
    ("ICD10", "G59.0", "G59.0 Diabetic mononeuropathy", "qcQ5aC2y2HC"),
    ("ICD10", "G59.8", "G59.8 Other mononeuropathies in diseases classified elsewhere", "jdR2vUaRTiy"),
    ("ICD10", "G60", "G60 Hereditary and idiopathic neuropathy", "qRo0BThmcKD"),
    ("ICD10", "G60.0", "G60.0 Hereditary motor and sensory neuropathy", "WAEcksD3saz"),
    ("ICD10", "G60.1", "G60.1 Refsum disease", "Tywf0xJLUKG"),
    ("ICD10", "G60.2", "G60.2 Neuropathy in association with hereditary ataxia", "X8dFXxRHriv"),
    ("ICD10", "G60.3", "G60.3 Idiopathic progressive neuropathy", "N1FIuV53Jw1"),
    ("ICD10", "G60.8", "G60.8 Other hereditary and idiopathic neuropathies", "edkGqJIsEri"),
    ("ICD10", "G60.9", "G60.9 Hereditary and idiopathic neuropathy, unspecified", "BkKr4MPWwpA"),
    ("ICD10", "G61", "G61 Inflammatory polyneuropathy", "l3tAyCkuO6c"),
    ("ICD10", "G61.0", "G61.0 Guillain-Barré syndrome", "Whm1tZgTK5t"),
    ("ICD10", "G61.1", "G61.1 Serum neuropathy", "ymc8oc8xmf6"),
    ("ICD10", "G61.8", "G61.8 Other inflammatory polyneuropathies", "qnGXZRpZBk3"),
    ("ICD10", "G61.9", "G61.9 Inflammatory polyneuropathy, unspecified", "D4ys6NsuiT3"),
    ("ICD10", "G62", "G62 Other polyneuropathies", "BMAbv9Coueb"),
    ("ICD10", "G62.0", "G62.0 Drug-induced polyneuropathy", "jMoudbnKDi3"),
    ("ICD10", "G62.1", "G62.1 Alcoholic polyneuropathy", "jZwtRvbuzun"),
    ("ICD10", "G62.2", "G62.2 Polyneuropathy due to other toxic agents", "xgFuJNjgqeW"),
    ("ICD10", "G62.8", "G62.8 Other specified polyneuropathies", "dZ7S8X2MRls"),
    ("ICD10", "G62.9", "G62.9 Polyneuropathy, unspecified", "D1XA7A8UmnJ"),
    ("ICD10", "G63", "G63 Polyneuropathy in diseases classified elsewhere", "UUeyYoHWZUo"),
    ("ICD10", "G63.0", "G63.0 Polyneuropathy in infectious and parasitic diseases classified elsewhere", "zAeeR2Te3pp"),
    ("ICD10", "G63.1", "G63.1 Polyneuropathy in neoplastic disease", "v2rxcoHoqEy"),
    ("ICD10", "G63.2", "G63.2 Diabetic polyneuropathy", "priJ2Rg0LsJ"),
    ("ICD10", "G63.3", "G63.3 Polyneuropathy in other endocrine and metabolic diseases", "ON65Wp0Qzi1"),
    ("ICD10", "G63.4", "G63.4 Polyneuropathy in nutritional deficiency", "nf7seurOJSO"),
    ("ICD10", "G63.5", "G63.5 Polyneuropathy in systemic connective tissue disorders", "aKwGbWAjbkq"),
    ("ICD10", "G63.6", "G63.6 Polyneuropathy in other musculoskeletal disorders", "qquSLV3ieNX"),
    ("ICD10", "G63.8", "G63.8 Polyneuropathy in other diseases classified elsewhere", "Ja4mNRdBOAC"),
    ("ICD10", "G64", "G64 Other disorders of peripheral nervous system", "mhtf1vsooam"),
    ("ICD10", "G70", "G70 Myasthenia gravis and other myoneural disorders", "bGByeFAHRV9"),
    ("ICD10", "G70.0", "G70.0 Myasthenia gravis", "cFacHVjUojF"),
    ("ICD10", "G70.1", "G70.1 Toxic myoneural disorders", "SX9epgJOI9C"),
    ("ICD10", "G70.2", "G70.2 Congenital and developmental myasthenia", "VspQgmxykwO"),
    ("ICD10", "G70.8", "G70.8 Other specified myoneural disorders", "ykpha0fywxa"),
    ("ICD10", "G70.9", "G70.9 Myoneural disorder, unspecified", "i1HlSFctSTT"),
    ("ICD10", "G71", "G71 Primary disorders of muscles", "ff7qtN8Gclx"),
    ("ICD10", "G71.0", "G71.0 Muscular dystrophy", "xRjKlrjEOkw"),
    ("ICD10", "G71.1", "G71.1 Myotonic disorders", "D1M9PYvVqjW"),
    ("ICD10", "G71.2", "G71.2 Congenital myopathies", "qk0SgP4ZiJJ"),
    ("ICD10", "G71.3", "G71.3 Mitochondrial myopathy, not elsewhere classified", "XIT201YojXq"),
    ("ICD10", "G71.8", "G71.8 Other primary disorders of muscles", "ZhWOXDPx4v1"),
    ("ICD10", "G71.9", "G71.9 Primary disorder of muscle, unspecified", "lctDTGEysOX"),
    ("ICD10", "G72", "G72 Other myopathies", "rm2CNfGoD16"),
    ("ICD10", "G72.0", "G72.0 Drug-induced myopathy", "tVxntdt4Q8f"),
    ("ICD10", "G72.1", "G72.1 Alcoholic myopathy", "Mr3Q0WhAzfl"),
    ("ICD10", "G72.2", "G72.2 Myopathy due to other toxic agents", "ysoYl2tBzqP"),
    ("ICD10", "G72.3", "G72.3 Periodic paralysis", "Ut4FLKlRQXI"),
    ("ICD10", "G72.4", "G72.4 Inflammatory myopathy, not elsewhere classified", "I46xLmXWIFO"),
    ("ICD10", "G72.8", "G72.8 Other specified myopathies", "yIbmnG5yCgh"),
    ("ICD10", "G72.9", "G72.9 Myopathy, unspecified", "FUKqQvh97PL"),
    ("ICD10", "G73", "G73 Disorders of myoneural junction and muscle in diseases classified elsewhere", "QaYZJr7lhZV"),
    ("ICD10", "G73.0", "G73.0 Myasthenic syndromes in endocrine diseases", "Cip9RgkrpWZ"),
    ("ICD10", "G73.1", "G73.1 Lambert-Eaton syndrome", "ZU0DhKzqCNk"),
    ("ICD10", "G73.2", "G73.2 Other myasthenic syndromes in neoplastic disease", "NWIYPVy1BEM"),
    ("ICD10", "G73.3", "G73.3 Myasthenic syndromes in other diseases classified elsewhere", "PF6EaQMRWIJ"),
    ("ICD10", "G73.4", "G73.4 Myopathy in infectious and parasitic diseases classified elsewhere", "fmk2vWgKqhU"),
    ("ICD10", "G73.5", "G73.5 Myopathy in endocrine diseases", "Uyr4JJJTz4G"),
    ("ICD10", "G73.6", "G73.6 Myopathy in metabolic diseases", "JrllWYDERks"),
    ("ICD10", "G73.7", "G73.7 Myopathy in other diseases classified elsewhere", "K8Br3PZn7zg"),
    ("ICD10", "G80", "G80 Cerebral palsy", "VaHrpmPXXKf"),
    ("ICD10", "G80.0", "G80.0 Spastic quadriplegic cerebral palsy", "AHsYHmHR2QV"),
    ("ICD10", "G80.1", "G80.1 Spastic diplegic cerebral palsy", "WJoUZNSYVnL"),
    ("ICD10", "G80.2", "G80.2 Spastic hemiplegic cerebral palsy", "gx9O8yn4bzH"),
    ("ICD10", "G80.3", "G80.3 Dyskinetic cerebral palsy", "ePvYpOFEXbz"),
    ("ICD10", "G80.4", "G80.4 Ataxic cerebral palsy", "BP0v4qqnZHv"),
    ("ICD10", "G80.8", "G80.8 Other cerebral palsy", "lv1VQYWyEny"),
    ("ICD10", "G80.9", "G80.9 Cerebral palsy, unspecified", "UMGSGSyKr9H"),
    ("ICD10", "G81", "G81 Hemiplegia", "ygp9euDEiDo"),
    ("ICD10", "G81.0", "G81.0 Flaccid hemiplegia", "W7SJlL70iI1"),
    ("ICD10", "G81.1", "G81.1 Spastic hemiplegia", "NdtvIGubvKN"),
    ("ICD10", "G81.9", "G81.9 Hemiplegia, unspecified", "L3BxGkXS2dJ"),
    ("ICD10", "G82", "G82 Paraplegia and tetraplegia", "QW9YwvKOXEh"),
    ("ICD10", "G82.0", "G82.0 Flaccid paraplegia", "W9rxCtnOVHQ"),
    ("ICD10", "G82.1", "G82.1 Spastic paraplegia", "sKiIdXY2niw"),
    ("ICD10", "G82.2", "G82.2 Paraplegia, unspecified", "ElOjZiPFbrs"),
    ("ICD10", "G82.3", "G82.3 Flaccid tetraplegia", "yZNuDCi5Plx"),
    ("ICD10", "G82.4", "G82.4 Spastic tetraplegia", "rObszyPdhaW"),
    ("ICD10", "G82.5", "G82.5 Tetraplegia, unspecified", "hyQAu8LkpDj"),
    ("ICD10", "G83", "G83 Other paralytic syndromes", "cOZNK3zdyFZ"),
    ("ICD10", "G83.0", "G83.0 Diplegia of upper limbs", "iMmUgpXXNL8"),
    ("ICD10", "G83.1", "G83.1 Monoplegia of lower limb", "nJic0E5E4Hu"),
    ("ICD10", "G83.2", "G83.2 Monoplegia of upper limb", "rtNOw3Ptk7f"),
    ("ICD10", "G83.3", "G83.3 Monoplegia, unspecified", "TlbpSZPFBn5"),
    ("ICD10", "G83.4", "G83.4 Cauda equina syndrome", "dcA77b5iuLx"),
    ("ICD10", "G83.5", "G83.5 Locked-in syndrome", "zCfNzU5vdW8"),
    ("ICD10", "G83.8", "G83.8 Other specified paralytic syndromes", "o2mJKzXofPA"),
    ("ICD10", "G83.9", "G83.9 Paralytic syndrome, unspecified", "MOjEvWmrkMG"),
    ("ICD10", "G90", "G90 Disorders of autonomic nervous system", "bVNCZN11vGt"),
    ("ICD10", "G90.0", "G90.0 Idiopathic peripheral autonomic neuropathy", "ExJIktfpsWC"),
    ("ICD10", "G90.1", "G90.1 Familial dysautonomia [Riley-Day]", "JiSfMI4CQJU"),
    ("ICD10", "G90.2", "G90.2 Horner syndrome", "xXD5ZJ8gLEP"),
    ("ICD10", "G90.4", "G90.4 Autonomic dysreflexia", "hNnJlbzeP7D"),
    ("ICD10", "G90.8", "G90.8 Other disorders of autonomic nervous system", "VtIaUazG3Y8"),
    ("ICD10", "G90.9", "G90.9 Disorder of autonomic nervous system, unspecified", "HcNpOJ24K5a"),
    ("ICD10", "G91", "G91 Hydrocephalus", "pPZJM5YFSkG"),
    ("ICD10", "G91.0", "G91.0 Communicating hydrocephalus", "tmiDXYu8q9p"),
    ("ICD10", "G91.1", "G91.1 Obstructive hydrocephalus", "E5iqw5JRpEA"),
    ("ICD10", "G91.2", "G91.2 Normal-pressure hydrocephalus", "Diy7shJZwj2"),
    ("ICD10", "G91.3", "G91.3 Post-traumatic hydrocephalus, unspecified", "bQZyy8fgwxh"),
    ("ICD10", "G91.8", "G91.8 Other hydrocephalus", "jNDvB2aFb71"),
    ("ICD10", "G91.9", "G91.9 Hydrocephalus, unspecified", "spDMIHmz9oN"),
    ("ICD10", "G92", "G92 Toxic encephalopathy", "PX2x5ir1FAE"),
    ("ICD10", "G93", "G93 Other disorders of brain", "gOhSNN3Tb9q"),
    ("ICD10", "G93.0", "G93.0 Cerebral cysts", "RYyODQlCIUM"),
    ("ICD10", "G93.1", "G93.1 Anoxic brain damage, not elsewhere classified", "bWiXeYeRN2j"),
    ("ICD10", "G93.2", "G93.2 Benign intracranial hypertension", "NNLj5Zl4x0J"),
    ("ICD10", "G93.3", "G93.3 Postviral fatigue syndrome", "EIOZPmulDVr"),
    ("ICD10", "G93.4", "G93.4 Encephalopathy, unspecified", "b5GTj0yQ3xu"),
    ("ICD10", "G93.5", "G93.5 Compression of brain", "qLmDXyRHbC4"),
    ("ICD10", "G93.6", "G93.6 Cerebral oedema", "xszJ0RaontR"),
    ("ICD10", "G93.7", "G93.7 Reye syndrome", "npyWri1Z8q3"),
    ("ICD10", "G93.8", "G93.8 Other specified disorders of brain", "SzJ9BYcwnKR"),
    ("ICD10", "G93.9", "G93.9 Disorder of brain, unspecified", "Y5uy7DJeIcL"),
    ("ICD10", "G94", "G94 Other disorders of brain in diseases classified elsewhere", "R8y7rBeVCGs"),
    ("ICD10", "G94.0", "G94.0 Hydrocephalus in infectious and parasitic diseases classified elsewhere", "vXKxhSj3FxW"),
    ("ICD10", "G94.1", "G94.1 Hydrocephalus in neoplastic disease", "bWMHpI09mIz"),
    ("ICD10", "G94.2", "G94.2 Hydrocephalus in other diseases classified elsewhere", "bAjMKCUhzqB"),
    ("ICD10", "G94.8", "G94.8 Other specified disorders of brain in diseases classified elsewhere", "gzK7tnQ95pB"),
    ("ICD10", "G95", "G95 Other diseases of spinal cord", "A1Ub6q6EigC"),
    ("ICD10", "G95.0", "G95.0 Syringomyelia and syringobulbia", "Y7D5eODJxNL"),
    ("ICD10", "G95.1", "G95.1 Vascular myelopathies", "kKd503j9mNw"),
    ("ICD10", "G95.2", "G95.2 Cord compression, unspecified", "YWQAOYnsDnX"),
    ("ICD10", "G95.8", "G95.8 Other specified diseases of spinal cord", "pcM5GlIWsVm"),
    ("ICD10", "G95.9", "G95.9 Disease of spinal cord, unspecified", "IvRX16IbUeK"),
    ("ICD10", "G96", "G96 Other disorders of central nervous system", "ZwEsYQH7BJf"),
    ("ICD10", "G96.0", "G96.0 Cerebrospinal fluid leak", "ge6NQvy1hnm"),
    ("ICD10", "G96.1", "G96.1 Disorders of meninges, not elsewhere classified", "KPjGWqnhhcX"),
    ("ICD10", "G96.8", "G96.8 Other specified disorders of central nervous system", "KNTXITTXiLJ"),
    ("ICD10", "G96.9", "G96.9 Disorder of central nervous system, unspecified", "u0B1CJlzMir"),
    ("ICD10", "G97", "G97 Postprocedural disorders of nervous system, not elsewhere classified", "ggCtk2JzXJR"),
    ("ICD10", "G97.0", "G97.0 Cerebrospinal fluid leak from spinal puncture", "lLBTOV0qXF7"),
    ("ICD10", "G97.1", "G97.1 Other reaction to spinal and lumbar puncture", "j0H7YzQJWZC"),
    ("ICD10", "G97.2", "G97.2 Intracranial hypotension following ventricular shunting", "BjUB8czVf0e"),
    ("ICD10", "G97.8", "G97.8 Other postprocedural disorders of nervous system", "FQnaRVpjQO3"),
    ("ICD10", "G97.9", "G97.9 Postprocedural disorder of nervous system, unspecified", "zgyulFOQie8"),
    ("ICD10", "G98", "G98 Other disorders of nervous system, not elsewhere classified", "mtSnXgmglLJ"),
    ("ICD10", "G99", "G99 Other disorders of nervous system in diseases classified elsewhere", "uLWMhJftX4p"),
    ("ICD10", "G99.0", "G99.0 Autonomic neuropathy in endocrine and metabolic diseases", "UADIrKs5LBt"),
    ("ICD10", "G99.1", "G99.1 Other disorders of autonomic nervous system in other diseases classified elsewhere", "BO78XFrFqTk"),
    ("ICD10", "G99.2", "G99.2 Myelopathy in diseases classified elsewhere", "BFz9QItiyyt"),
    ("ICD10", "G99.8", "G99.8 Other specified disorders of nervous system in diseases classified elsewhere", "kGxmGgARDW5");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "H00", "H00 Hordeolum and chalazion", "I51yuTnKAUQ"),
    ("ICD10", "H00.0", "H00.0 Hordeolum and other deep inflammation of eyelid", "nkhQIRJDtHm"),
    ("ICD10", "H00.1", "H00.1 Chalazion", "MFMVXuqdYgP"),
    ("ICD10", "H01", "H01 Other inflammation of eyelid", "cLf7lvRExwy"),
    ("ICD10", "H01.0", "H01.0 Blepharitis", "I345Vi7gHmU"),
    ("ICD10", "H01.1", "H01.1 Noninfectious dermatoses of eyelid", "FoV00LMG1b7"),
    ("ICD10", "H01.8", "H01.8 Other specified inflammation of eyelid", "O7QRYHUGExu"),
    ("ICD10", "H01.9", "H01.9 Inflammation of eyelid, unspecified", "O6x9FsCtK9Q"),
    ("ICD10", "H02", "H02 Other disorders of eyelid", "HScoS1Uyg5r"),
    ("ICD10", "H02.0", "H02.0 Entropion and trichiasis of eyelid", "O5hEpxXeq3L"),
    ("ICD10", "H02.1", "H02.1 Ectropion of eyelid", "PLv4e2YmvsU"),
    ("ICD10", "H02.2", "H02.2 Lagophthalmos", "NWyekGAWraf"),
    ("ICD10", "H02.3", "H02.3 Blepharochalasis", "xqURSJ5zpwC"),
    ("ICD10", "H02.4", "H02.4 Ptosis of eyelid", "qf4O2a6Ga9P"),
    ("ICD10", "H02.5", "H02.5 Other disorders affecting eyelid function", "N4lx3nYBnZ4"),
    ("ICD10", "H02.6", "H02.6 Xanthelasma of eyelid", "r1CqOu4cJcA"),
    ("ICD10", "H02.7", "H02.7 Other degenerative disorders of eyelid and periocular area", "KXsM7mDIaeo"),
    ("ICD10", "H02.8", "H02.8 Other specified disorders of eyelid", "L5j5kAyulRi"),
    ("ICD10", "H02.9", "H02.9 Disorder of eyelid, unspecified", "h9cjbOvy18Y"),
    ("ICD10", "H03", "H03 Disorders of eyelid in diseases classified elsewhere", "pMk81y24dSV"),
    ("ICD10", "H03.0", "H03.0 Parasitic infestation of eyelid in diseases classified elsewhere", "ONwr8GS9q2t"),
    ("ICD10", "H03.1", "H03.1 Involvement of eyelid in other infectious diseases classified elsewhere", "FTvM3o4Yxx1"),
    ("ICD10", "H03.8", "H03.8 Involvement of eyelid in other diseases classified elsewhere", "qhAMBCIPedz"),
    ("ICD10", "H04", "H04 Disorders of lacrimal system", "N881bMVkQ6K"),
    ("ICD10", "H04.0", "H04.0 Dacryoadenitis", "eFKvabXKhiV"),
    ("ICD10", "H04.1", "H04.1 Other disorders of lacrimal gland", "sqvGEteX2lC"),
    ("ICD10", "H04.2", "H04.2 Epiphora", "kS7mpSMD9mh"),
    ("ICD10", "H04.3", "H04.3 Acute and unspecified inflammation of lacrimal passages", "zec2Vwbb4N1"),
    ("ICD10", "H04.4", "H04.4 Chronic inflammation of lacrimal passages", "uc6yz8ld9TO"),
    ("ICD10", "H04.5", "H04.5 Stenosis and insufficiency of lacrimal passages", "D02m4BC2iFG"),
    ("ICD10", "H04.6", "H04.6 Other changes in lacrimal passages", "Sto8H6s0ynd"),
    ("ICD10", "H04.8", "H04.8 Other disorders of lacrimal system", "IpkJ582lr1B"),
    ("ICD10", "H04.9", "H04.9 Disorder of lacrimal system, unspecified", "k5Q8NtVLi5R"),
    ("ICD10", "H05", "H05 Disorders of orbit", "KaQqpo1olks"),
    ("ICD10", "H05.0", "H05.0 Acute inflammation of orbit", "ZbDmOdFjRnr"),
    ("ICD10", "H05.1", "H05.1 Chronic inflammatory disorders of orbit", "ER46ikl0MTH"),
    ("ICD10", "H05.2", "H05.2 Exophthalmic conditions", "XFr8rUkp8wN"),
    ("ICD10", "H05.3", "H05.3 Deformity of orbit", "q626Kluecwz"),
    ("ICD10", "H05.4", "H05.4 Enophthalmos", "nhrXjmYIB42"),
    ("ICD10", "H05.5", "H05.5 Retained (old) foreign body following penetrating wound of orbit", "rDEzzEiYkPT"),
    ("ICD10", "H05.8", "H05.8 Other disorders of orbit", "m2Ap11QgRmb"),
    ("ICD10", "H05.9", "H05.9 Disorder of orbit, unspecified", "ULOI9t36Vqf"),
    ("ICD10", "H06", "H06 Disorders of lacrimal system and orbit in diseases classified elsewhere", "Kq4UBZTvw0R"),
    ("ICD10", "H06.0", "H06.0 Disorders of lacrimal system in diseases classified elsewhere", "IKwOR8cW5ry"),
    ("ICD10", "H06.1", "H06.1 Parasitic infestation of orbit in diseases classified elsewhere", "JISKH9Ns0wR"),
    ("ICD10", "H06.2", "H06.2 Dysthyroid exophthalmos", "KnaXylWttUT"),
    ("ICD10", "H06.3", "H06.3 Other disorders of orbit in diseases classified elsewhere", "BydkxGrRl5u"),
    ("ICD10", "H10", "H10 Conjunctivitis", "UqnFL7HzLbC"),
    ("ICD10", "H10.0", "H10.0 Mucopurulent conjunctivitis", "MfaFYAeGoIW"),
    ("ICD10", "H10.1", "H10.1 Acute atopic conjunctivitis", "TGTRBtuSMCz"),
    ("ICD10", "H10.2", "H10.2 Other acute conjunctivitis", "KTEYiwhlnNu"),
    ("ICD10", "H10.3", "H10.3 Acute conjunctivitis, unspecified", "T0vnvImYJZq"),
    ("ICD10", "H10.4", "H10.4 Chronic conjunctivitis", "bd1YxnJ8KfP"),
    ("ICD10", "H10.5", "H10.5 Blepharoconjunctivitis", "mOAWN8LjQIn"),
    ("ICD10", "H10.8", "H10.8 Other conjunctivitis", "TV1Lqcz6OBo"),
    ("ICD10", "H10.9", "H10.9 Conjunctivitis, unspecified", "zIZec1qq1RI"),
    ("ICD10", "H11", "H11 Other disorders of conjunctiva", "m74hjcbCjb6"),
    ("ICD10", "H11.0", "H11.0 Pterygium", "logJ3qcM2Yl"),
    ("ICD10", "H11.1", "H11.1 Conjunctival degenerations and deposits", "OPDZYRx5CJv"),
    ("ICD10", "H11.2", "H11.2 Conjunctival scars", "h32z9sOmPoy"),
    ("ICD10", "H11.3", "H11.3 Conjunctival haemorrhage", "ARNdDXfrj7f"),
    ("ICD10", "H11.4", "H11.4 Other conjunctival vascular disorders and cysts", "byiapB3h0yk"),
    ("ICD10", "H11.8", "H11.8 Other specified disorders of conjunctiva", "yrcBCRD0Sp2"),
    ("ICD10", "H11.9", "H11.9 Disorder of conjunctiva, unspecified", "DKXcqT1fhd0"),
    ("ICD10", "H13", "H13 Disorders of conjunctiva in diseases classified elsewhere", "wD7jHGjb8KF"),
    ("ICD10", "H13.0", "H13.0 Filarial infection of conjunctiva", "zdeQ1Rum1QE"),
    ("ICD10", "H13.1", "H13.1 Conjunctivitis in infectious and parasitic diseases classified elsewhere", "PhEZMYDVFFd"),
    ("ICD10", "H13.2", "H13.2 Conjunctivitis in other diseases classified elsewhere", "lrUD51MDwWi"),
    ("ICD10", "H13.3", "H13.3 Ocular pemphigoid", "BGsj4acMdQb"),
    ("ICD10", "H13.8", "H13.8 Other disorders of conjunctiva in diseases classified elsewhere", "HTh3OnVBxwu"),
    ("ICD10", "H15", "H15 Disorders of sclera", "GaXaLa1Sfa7"),
    ("ICD10", "H15.0", "H15.0 Scleritis", "DNdtePQCKSp"),
    ("ICD10", "H15.1", "H15.1 Episcleritis", "bpq6GAA8jMv"),
    ("ICD10", "H15.8", "H15.8 Other disorders of sclera", "zjTwTZXYO6d"),
    ("ICD10", "H15.9", "H15.9 Disorder of sclera, unspecified", "V76e2yQ9N8p"),
    ("ICD10", "H16", "H16 Keratitis", "GYWW1jNoDt7"),
    ("ICD10", "H16.0", "H16.0 Corneal ulcer", "lbTvzTlVx3v"),
    ("ICD10", "H16.1", "H16.1 Other superficial keratitis without conjunctivitis", "VUnNY1lxBKe"),
    ("ICD10", "H16.2", "H16.2 Keratoconjunctivitis", "URWepJuoCJM"),
    ("ICD10", "H16.3", "H16.3 Interstitial and deep keratitis", "Pa5o33YeL0h"),
    ("ICD10", "H16.4", "H16.4 Corneal neovascularization", "QQWW3NaiJhR"),
    ("ICD10", "H16.8", "H16.8 Other keratitis", "Di2bPU1I4dK"),
    ("ICD10", "H16.9", "H16.9 Keratitis, unspecified", "oet9Isximae"),
    ("ICD10", "H17", "H17 Corneal scars and opacities", "WH8JBYJAjJu"),
    ("ICD10", "H17.0", "H17.0 Adherent leukoma", "wdu0OQ16GZ8"),
    ("ICD10", "H17.1", "H17.1 Other central corneal opacity", "Wel7QQhyEnw"),
    ("ICD10", "H17.8", "H17.8 Other corneal scars and opacities", "x7KBnWpIv22"),
    ("ICD10", "H17.9", "H17.9 Corneal scar and opacity, unspecified", "JYSKbltoq3r"),
    ("ICD10", "H18", "H18 Other disorders of cornea", "WxSIUx5VtBs"),
    ("ICD10", "H18.0", "H18.0 Corneal pigmentations and deposits", "orisXvq7juM"),
    ("ICD10", "H18.1", "H18.1 Bullous keratopathy", "zqfW3vXwc8u"),
    ("ICD10", "H18.2", "H18.2 Other corneal oedema", "eHushP8OYSp"),
    ("ICD10", "H18.3", "H18.3 Changes in corneal membranes", "XL2PafBkBqO"),
    ("ICD10", "H18.4", "H18.4 Corneal degeneration", "sFoxJhXBUwa"),
    ("ICD10", "H18.5", "H18.5 Hereditary corneal dystrophies", "PSuTyjCFTCv"),
    ("ICD10", "H18.6", "H18.6 Keratoconus", "xvXRTjtgt5O"),
    ("ICD10", "H18.7", "H18.7 Other corneal deformities", "yCe8BQe1RZD"),
    ("ICD10", "H18.8", "H18.8 Other specified disorders of cornea", "li8CPQKOQqL"),
    ("ICD10", "H18.9", "H18.9 Disorder of cornea, unspecified", "dmN80iwOJIp"),
    ("ICD10", "H19", "H19 Disorders of sclera and cornea in diseases classified elsewhere", "Tke6q7W21f5"),
    ("ICD10", "H19.0", "H19.0 Scleritis and episcleritis in diseases classified elsewhere", "DUew5smANjl"),
    ("ICD10", "H19.1", "H19.1 Herpesviral keratitis and keratoconjunctivitis", "T1bLyxQ5jLn"),
    ("ICD10", "H19.2", "H19.2 Keratitis and keratoconjunctivitis in other infectious and parasitic diseases classified elsewhere", "YX9RQHOTH0d"),
    ("ICD10", "H19.3", "H19.3 Keratitis and keratoconjunctivitis in other diseases classified elsewhere", "HRJVjBjpJbL"),
    ("ICD10", "H19.8", "H19.8 Other disorders of sclera and cornea in diseases classified elsewhere", "w5YHGwcA8PA"),
    ("ICD10", "H20", "H20 Iridocyclitis", "nWb24AszW8u"),
    ("ICD10", "H20.0", "H20.0 Acute and subacute iridocyclitis", "f7qm2gWm4II"),
    ("ICD10", "H20.1", "H20.1 Chronic iridocyclitis", "wjBvnv6qcD3"),
    ("ICD10", "H20.2", "H20.2 Lens-induced iridocyclitis", "TyCrZoQafIL"),
    ("ICD10", "H20.8", "H20.8 Other iridocyclitis", "Andkf8KreF2"),
    ("ICD10", "H20.9", "H20.9 Iridocyclitis, unspecified", "oGaQtePxAEG"),
    ("ICD10", "H21", "H21 Other disorders of iris and ciliary body", "gNxzXXws4sS"),
    ("ICD10", "H21.0", "H21.0 Hyphaema", "UZvkKUya3c6"),
    ("ICD10", "H21.1", "H21.1 Other vascular disorders of iris and ciliary body", "QtYYo7TgpOL"),
    ("ICD10", "H21.2", "H21.2 Degeneration of iris and ciliary body", "C7MwHKbXRgv"),
    ("ICD10", "H21.3", "H21.3 Cyst of iris, ciliary body and anterior chamber", "PZub3ksGrsS"),
    ("ICD10", "H21.4", "H21.4 Pupillary membranes", "Q8dsQ1V22QD"),
    ("ICD10", "H21.5", "H21.5 Other adhesions and disruptions of iris and ciliary body", "DMv3U5ESNkM"),
    ("ICD10", "H21.8", "H21.8 Other specified disorders of iris and ciliary body", "H4UUnznkPkt"),
    ("ICD10", "H21.9", "H21.9 Disorder of iris and ciliary body, unspecified", "X67KumEWYKS"),
    ("ICD10", "H22", "H22 Disorders of iris and ciliary body in diseases classified elsewhere", "oyqbHNGjafQ"),
    ("ICD10", "H22.0", "H22.0 Iridocyclitis in infectious and parasitic diseases classified elsewhere", "P2OWjlZgJHP"),
    ("ICD10", "H22.1", "H22.1 Iridocyclitis in other diseases classified elsewhere", "k6NY6Czkhae"),
    ("ICD10", "H22.8", "H22.8 Other disorders of iris and ciliary body in diseases classified elsewhere", "Cc3V7qU8A3n"),
    ("ICD10", "H25", "H25 Senile cataract", "QWXAhxbYZlw"),
    ("ICD10", "H25.0", "H25.0 Senile incipient cataract", "DL11byDQFxh"),
    ("ICD10", "H25.1", "H25.1 Senile nuclear cataract", "AOBhRraIhpI"),
    ("ICD10", "H25.2", "H25.2 Senile cataract, morgagnian type", "iZSFh0VPd60"),
    ("ICD10", "H25.8", "H25.8 Other senile cataract", "w7wlLfd3sHH"),
    ("ICD10", "H25.9", "H25.9 Senile cataract, unspecified", "zdb1fTXI9VE"),
    ("ICD10", "H26", "H26 Other cataract", "Jn5qJEPshSr"),
    ("ICD10", "H26.0", "H26.0 Infantile, juvenile and presenile cataract", "SaHeUwvZswy"),
    ("ICD10", "H26.1", "H26.1 Traumatic cataract", "o922hGsnu6l"),
    ("ICD10", "H26.2", "H26.2 Complicated cataract", "ALSljOehfeG"),
    ("ICD10", "H26.3", "H26.3 Drug-induced cataract", "i14sptvBLjx"),
    ("ICD10", "H26.4", "H26.4 After-cataract", "BfWsBdzMxZr"),
    ("ICD10", "H26.8", "H26.8 Other specified cataract", "oYnHrFgyJhy"),
    ("ICD10", "H26.9", "H26.9 Cataract, unspecified", "xzVnOlElh9f"),
    ("ICD10", "H27", "H27 Other disorders of lens", "d5J81AXxbfu"),
    ("ICD10", "H27.0", "H27.0 Aphakia", "qGVPj8AYFMA"),
    ("ICD10", "H27.1", "H27.1 Dislocation of lens", "lbBz5x0tBUG"),
    ("ICD10", "H27.8", "H27.8 Other specified disorders of lens", "ORVjxh779oZ"),
    ("ICD10", "H27.9", "H27.9 Disorder of lens, unspecified", "T4BtgDjLC5C"),
    ("ICD10", "H28", "H28 Cataract and other disorders of lens in diseases classified elsewhere", "v0yHiALzC4p"),
    ("ICD10", "H28.0", "H28.0 Diabetic cataract", "npnXuXLvBsE"),
    ("ICD10", "H28.1", "H28.1 Cataract in other endocrine, nutritional and metabolic diseases", "Rsbo17E74lX"),
    ("ICD10", "H28.2", "H28.2 Cataract in other diseases classified elsewhere", "aBGrlMOzPkl"),
    ("ICD10", "H28.8", "H28.8 Other disorders of lens in diseases classified elsewhere", "cF7irJkJdIb"),
    ("ICD10", "H30", "H30 Chorioretinal inflammation", "NptlM3jK5TP"),
    ("ICD10", "H30.0", "H30.0 Focal chorioretinal inflammation", "MMUcYo0GMC1"),
    ("ICD10", "H30.1", "H30.1 Disseminated chorioretinal inflammation", "tUy7DxiqwTy"),
    ("ICD10", "H30.2", "H30.2 Posterior cyclitis", "jQBOk8Kxn2l"),
    ("ICD10", "H30.8", "H30.8 Other chorioretinal inflammations", "NxXm2PsUPBw"),
    ("ICD10", "H30.9", "H30.9 Chorioretinal inflammation, unspecified", "aCwMIjYLz72"),
    ("ICD10", "H31", "H31 Other disorders of choroid", "Z8Vms88zmDP"),
    ("ICD10", "H31.0", "H31.0 Chorioretinal scars", "Oa9Muab7Scs"),
    ("ICD10", "H31.1", "H31.1 Choroidal degeneration", "kdLexZ6liy0"),
    ("ICD10", "H31.2", "H31.2 Hereditary choroidal dystrophy", "IdlSRlHXHgg"),
    ("ICD10", "H31.3", "H31.3 Choroidal haemorrhage and rupture", "YvDzjRHyvCy"),
    ("ICD10", "H31.4", "H31.4 Choroidal detachment", "bedhYfWWOus"),
    ("ICD10", "H31.8", "H31.8 Other specified disorders of choroid", "D5kMWcRsoQM"),
    ("ICD10", "H31.9", "H31.9 Disorder of choroid, unspecified", "LSL7hS0wWDz"),
    ("ICD10", "H32", "H32 Chorioretinal disorders in diseases classified elsewhere", "jlcdmKw6vGp"),
    ("ICD10", "H32.0", "H32.0 Chorioretinal inflammation in infectious and parasitic diseases classified elsewhere", "W7J4HismhjC"),
    ("ICD10", "H32.8", "H32.8 Other chorioretinal disorders in diseases classified elsewhere", "RDZKWb2NChE"),
    ("ICD10", "H33", "H33 Retinal detachments and breaks", "kS5XbuKgnSV"),
    ("ICD10", "H33.0", "H33.0 Retinal detachment with retinal break", "dARockRZuK8"),
    ("ICD10", "H33.1", "H33.1 Retinoschisis and retinal cysts", "lBJuTmuGXHK"),
    ("ICD10", "H33.2", "H33.2 Serous retinal detachment", "merRXu5Eg1Y"),
    ("ICD10", "H33.3", "H33.3 Retinal breaks without detachment", "JMViB3u1FvV"),
    ("ICD10", "H33.4", "H33.4 Traction detachment of retina", "hyPwQV2LW1J"),
    ("ICD10", "H33.5", "H33.5 Other retinal detachments", "VmWfWOyaqqy"),
    ("ICD10", "H34", "H34 Retinal vascular occlusions", "nzBSNDYV3tN"),
    ("ICD10", "H34.0", "H34.0 Transient retinal artery occlusion", "tcC138jY8kp"),
    ("ICD10", "H34.1", "H34.1 Central retinal artery occlusion", "cNsmpoNWGVz"),
    ("ICD10", "H34.2", "H34.2 Other retinal artery occlusions", "cegn8LvAc5F"),
    ("ICD10", "H34.8", "H34.8 Other retinal vascular occlusions", "l5IYZfWCR3k"),
    ("ICD10", "H34.9", "H34.9 Retinal vascular occlusion, unspecified", "uGLsZyTVhZE"),
    ("ICD10", "H35", "H35 Other retinal disorders", "NIQie91Jfbi"),
    ("ICD10", "H35.0", "H35.0 Background retinopathy and retinal vascular changes", "ig9mGBMbEIY"),
    ("ICD10", "H35.1", "H35.1 Retinopathy of prematurity", "T3DKjPh4rcT"),
    ("ICD10", "H35.2", "H35.2 Other proliferative retinopathy", "UJ3LwQuzvrh"),
    ("ICD10", "H35.3", "H35.3 Degeneration of macula and posterior pole", "qpwppbQtBzy"),
    ("ICD10", "H35.4", "H35.4 Peripheral retinal degeneration", "EfdNoWIkNaX"),
    ("ICD10", "H35.5", "H35.5 Hereditary retinal dystrophy", "Kz0nON9l5Ba"),
    ("ICD10", "H35.6", "H35.6 Retinal haemorrhage", "Q9RoffcCBrE"),
    ("ICD10", "H35.7", "H35.7 Separation of retinal layers", "EkI8hFUfQ4K"),
    ("ICD10", "H35.8", "H35.8 Other specified retinal disorders", "nnqA0Cc31CP"),
    ("ICD10", "H35.9", "H35.9 Retinal disorder, unspecified", "r2qVUDqrZkP"),
    ("ICD10", "H36", "H36 Retinal disorders in diseases classified elsewhere", "qNJfZ7Rqwyw"),
    ("ICD10", "H36.0", "H36.0 Diabetic retinopathy", "BtcstwYvRtM"),
    ("ICD10", "H36.8", "H36.8 Other retinal disorders in diseases classified elsewhere", "vAGw677VBqR"),
    ("ICD10", "H40", "H40 Glaucoma", "vzec4cxf2pq"),
    ("ICD10", "H40.0", "H40.0 Glaucoma suspect", "eqYwBv30L1c"),
    ("ICD10", "H40.1", "H40.1 Primary open-angle glaucoma", "GK5dxA3Jbcw"),
    ("ICD10", "H40.2", "H40.2 Primary angle-closure glaucoma", "CSsDzvJH6os"),
    ("ICD10", "H40.3", "H40.3 Glaucoma secondary to eye trauma", "DMLBgtcUcGL"),
    ("ICD10", "H40.4", "H40.4 Glaucoma secondary to eye inflammation", "zJnXZOQxF73"),
    ("ICD10", "H40.5", "H40.5 Glaucoma secondary to other eye disorders", "t0FzYh4y17h"),
    ("ICD10", "H40.6", "H40.6 Glaucoma secondary to drugs", "QrYl6EZyfKv"),
    ("ICD10", "H40.8", "H40.8 Other glaucoma", "FBRM94m5hKj"),
    ("ICD10", "H40.9", "H40.9 Glaucoma, unspecified", "THTisuIrWqs"),
    ("ICD10", "H42", "H42 Glaucoma in diseases classified elsewhere", "BGzC3KQCqRv"),
    ("ICD10", "H42.0", "H42.0 Glaucoma in endocrine, nutritional and metabolic diseases", "yuVu8YjxgRy"),
    ("ICD10", "H42.8", "H42.8 Glaucoma in other diseases classified elsewhere", "zeJiKidnNb2"),
    ("ICD10", "H43", "H43 Disorders of vitreous body", "izwvonjeG4L"),
    ("ICD10", "H43.0", "H43.0 Vitreous prolapse", "KZr8yWXDhT4"),
    ("ICD10", "H43.1", "H43.1 Vitreous haemorrhage", "xfe7WXp9jDH"),
    ("ICD10", "H43.2", "H43.2 Crystalline deposits in vitreous body", "a8dwShox2SF"),
    ("ICD10", "H43.3", "H43.3 Other vitreous opacities", "iL2RcWhAlSI"),
    ("ICD10", "H43.8", "H43.8 Other disorders of vitreous body", "uWqL1w7QYm1"),
    ("ICD10", "H43.9", "H43.9 Disorder of vitreous body, unspecified", "u1dBeN9XTjD"),
    ("ICD10", "H44", "H44 Disorders of globe", "j7LmtubBL9T"),
    ("ICD10", "H44.0", "H44.0 Purulent endophthalmitis", "PuLkz1XKCwz"),
    ("ICD10", "H44.1", "H44.1 Other endophthalmitis", "vKxabZExk7l"),
    ("ICD10", "H44.2", "H44.2 Degenerative myopia", "qI8YgNwxijL"),
    ("ICD10", "H44.3", "H44.3 Other degenerative disorders of globe", "tz2xB10slEG"),
    ("ICD10", "H44.4", "H44.4 Hypotony of eye", "BMlftJnL1z1"),
    ("ICD10", "H44.5", "H44.5 Degenerated conditions of globe", "zi0lFJ0byXW"),
    ("ICD10", "H44.6", "H44.6 Retained (old) intraocular foreign body, magnetic", "Ax8jGdi8SSC"),
    ("ICD10", "H44.7", "H44.7 Retained (old) intraocular foreign body, nonmagnetic", "KLqr3B27gLw"),
    ("ICD10", "H44.8", "H44.8 Other disorders of globe", "ZRLXXpeRoMy"),
    ("ICD10", "H44.9", "H44.9 Disorder of globe, unspecified", "xNQ8aeBXxuB"),
    ("ICD10", "H45", "H45 Disorders of vitreous body and globe in diseases classified elsewhere", "UZ6SjbUWrII"),
    ("ICD10", "H45.0", "H45.0 Vitreous haemorrhage in diseases classified elsewhere", "YiDzKisyAqY"),
    ("ICD10", "H45.1", "H45.1 Endophthalmitis in diseases classified elsewhere", "XJfMLq3dg6q"),
    ("ICD10", "H45.8", "H45.8 Other disorders of vitreous body and globe in diseases classified elsewhere", "kgE79mjfZkK"),
    ("ICD10", "H46", "H46 Optic neuritis", "TK773C3Lszn"),
    ("ICD10", "H47", "H47 Other disorders of optic [2nd] nerve and visual pathways", "aypPfRAaadw"),
    ("ICD10", "H47.0", "H47.0 Disorders of optic nerve, not elsewhere classified", "a8hmZ6EMEp7"),
    ("ICD10", "H47.1", "H47.1 Papilloedema, unspecified", "H4P9WvtcL7U"),
    ("ICD10", "H47.2", "H47.2 Optic atrophy", "uJg316j5BW2"),
    ("ICD10", "H47.3", "H47.3 Other disorders of optic disc", "HbbevxTn9SV"),
    ("ICD10", "H47.4", "H47.4 Disorders of optic chiasm", "wnz52N3hIDh"),
    ("ICD10", "H47.5", "H47.5 Disorders of other visual pathways", "o1naaAymWIK"),
    ("ICD10", "H47.6", "H47.6 Disorders of visual cortex", "aKVV9PvcDPm"),
    ("ICD10", "H47.7", "H47.7 Disorder of visual pathways, unspecified", "XH6py9rUJ7S"),
    ("ICD10", "H48", "H48 Disorders of optic [2nd] nerve and visual pathways in diseases classified elsewhere", "KqNLUF9UOaw"),
    ("ICD10", "H48.0", "H48.0 Optic atrophy in diseases classified elsewhere", "ka7pQpCDg6t"),
    ("ICD10", "H48.1", "H48.1 Retrobulbar neuritis in diseases classified elsewhere", "alOhQemlu7u"),
    ("ICD10", "H48.8", "H48.8 Other disorders of optic nerve and visual pathways in diseases classified elsewhere", "gACSldonLn9"),
    ("ICD10", "H49", "H49 Paralytic strabismus", "pzRpzRcXhlD"),
    ("ICD10", "H49.0", "H49.0 Third [oculomotor] nerve palsy", "jigozOpB8Fv"),
    ("ICD10", "H49.1", "H49.1 Fourth [trochlear] nerve palsy", "FleyrhBi4xc"),
    ("ICD10", "H49.2", "H49.2 Sixth [abducent] nerve palsy", "V0rswoUr05w"),
    ("ICD10", "H49.3", "H49.3 Total (external) ophthalmoplegia", "JrkvdrOoaZn"),
    ("ICD10", "H49.4", "H49.4 Progressive external ophthalmoplegia", "qaffZ1h1VYH"),
    ("ICD10", "H49.8", "H49.8 Other paralytic strabismus", "hHjguuDcOxh"),
    ("ICD10", "H49.9", "H49.9 Paralytic strabismus, unspecified", "sUDxvEqG3qC"),
    ("ICD10", "H50", "H50 Other strabismus", "QYwyFEJvweM"),
    ("ICD10", "H50.0", "H50.0 Convergent concomitant strabismus", "ooGe2LxLigi"),
    ("ICD10", "H50.1", "H50.1 Divergent concomitant strabismus", "WyaczM0fSEf"),
    ("ICD10", "H50.2", "H50.2 Vertical strabismus", "zHoxTr3Xyen"),
    ("ICD10", "H50.3", "H50.3 Intermittent heterotropia", "PyUZkoJHfd6"),
    ("ICD10", "H50.4", "H50.4 Other and unspecified heterotropia", "LDkXG4GBF3m"),
    ("ICD10", "H50.5", "H50.5 Heterophoria", "Nxgk3eRrpPZ"),
    ("ICD10", "H50.6", "H50.6 Mechanical strabismus", "TlBMc9pFI9S"),
    ("ICD10", "H50.8", "H50.8 Other specified strabismus", "tbV3OmRdQOB"),
    ("ICD10", "H50.9", "H50.9 Strabismus, unspecified", "peHmOoQlq4e"),
    ("ICD10", "H51", "H51 Other disorders of binocular movement", "wY9U5PFVhpt"),
    ("ICD10", "H51.0", "H51.0 Palsy of conjugate gaze", "oxm23P04RaR"),
    ("ICD10", "H51.1", "H51.1 Convergence insufficiency and excess", "A3wJzb522po"),
    ("ICD10", "H51.2", "H51.2 Internuclear ophthalmoplegia", "aR3sEixhCaZ"),
    ("ICD10", "H51.8", "H51.8 Other specified disorders of binocular movement", "hRVcV6YT1ni"),
    ("ICD10", "H51.9", "H51.9 Disorder of binocular movement, unspecified", "Nfbd7QutlAq"),
    ("ICD10", "H52", "H52 Disorders of refraction and accommodation", "vxDumphl5mX"),
    ("ICD10", "H52.0", "H52.0 Hypermetropia", "FIESAQQi9r9"),
    ("ICD10", "H52.1", "H52.1 Myopia", "t9PENLzpBfK"),
    ("ICD10", "H52.2", "H52.2 Astigmatism", "jMBiAVLwDqI"),
    ("ICD10", "H52.3", "H52.3 Anisometropia and aniseikonia", "xEG14GCeMoE"),
    ("ICD10", "H52.4", "H52.4 Presbyopia", "T1mwVIAyvgQ"),
    ("ICD10", "H52.5", "H52.5 Disorders of accommodation", "DUyvg5iPmCd"),
    ("ICD10", "H52.6", "H52.6 Other disorders of refraction", "eleh3E6z1Cj"),
    ("ICD10", "H52.7", "H52.7 Disorder of refraction, unspecified", "OJxDzunOq0Y"),
    ("ICD10", "H53", "H53 Visual disturbances", "ZPWLtLx4mNl"),
    ("ICD10", "H53.0", "H53.0 Amblyopia ex anopsia", "mD3uTN10csM"),
    ("ICD10", "H53.1", "H53.1 Subjective visual disturbances", "prijhYmMC75"),
    ("ICD10", "H53.2", "H53.2 Diplopia", "ZEnFsstRDBm"),
    ("ICD10", "H53.3", "H53.3 Other disorders of binocular vision", "OAwnt79D1Kk");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "H53.4", "H53.4 Visual field defects", "w6TZv4QYiSg"),
    ("ICD10", "H53.5", "H53.5 Colour vision deficiencies", "Ryl30y4xFji"),
    ("ICD10", "H53.6", "H53.6 Night blindness", "bhUUfx6dHEk"),
    ("ICD10", "H53.8", "H53.8 Other visual disturbances", "JG91xtpGVh6"),
    ("ICD10", "H53.9", "H53.9 Visual disturbance, unspecified", "S1gMYGaNOzC"),
    ("ICD10", "H54", "H54 Visual impairment including blindness (binocular or monocular)", "ziNuNNGEeh4"),
    ("ICD10", "H54.0", "H54.0 Blindness, binocular", "iWAcFvdbh0f"),
    ("ICD10", "H54.1", "H54.1 Severe visual impairment, binocular", "NUIc9LJlGlz"),
    ("ICD10", "H54.2", "H54.2 Moderate visual impairment, binocular", "YvebA6wyZpl"),
    ("ICD10", "H54.3", "H54.3 Mild or no visual impairment, binocular", "sGd74ik20cv"),
    ("ICD10", "H54.4", "H54.4 Blindness, monocular", "Cs8xQVvrl3s"),
    ("ICD10", "H54.5", "H54.5 Severe visual impairment, monocular", "yclLNJmIxyg"),
    ("ICD10", "H54.6", "H54.6 Moderate visual impairment, monocular", "N5ntxMhtoFT"),
    ("ICD10", "H54.9", "H54.9 Unspecified visual impairment (binocular)", "icYwdxBEifj"),
    ("ICD10", "H55", "H55 Nystagmus and other irregular eye movements", "j5g7AlYsprX"),
    ("ICD10", "H57", "H57 Other disorders of eye and adnexa", "GrkyISNF8y1"),
    ("ICD10", "H57.0", "H57.0 Anomalies of pupillary function", "EYRYHMdFTcy"),
    ("ICD10", "H57.1", "H57.1 Ocular pain", "yaIAlfbY1ZX"),
    ("ICD10", "H57.8", "H57.8 Other specified disorders of eye and adnexa", "KOxUsuWjrwJ"),
    ("ICD10", "H57.9", "H57.9 Disorder of eye and adnexa, unspecified", "Y6HTilBCvn4"),
    ("ICD10", "H58", "H58 Other disorders of eye and adnexa in diseases classified elsewhere", "n0v73HBb94J"),
    ("ICD10", "H58.0", "H58.0 Anomalies of pupillary function in diseases classified elsewhere", "pLtE9cqPQCR"),
    ("ICD10", "H58.1", "H58.1 Visual disturbances in diseases classified elsewhere", "IwZ2qPHQAiy"),
    ("ICD10", "H58.8", "H58.8 Other specified disorders of eye and adnexa in diseases classified elsewhere", "qCMKzx5fbrW"),
    ("ICD10", "H59", "H59 Postprocedural disorders of eye and adnexa, not elsewhere classified", "LZ3SmqCRpO6"),
    ("ICD10", "H59.0", "H59.0 Keratopathy (bullous aphakic) following cataract surgery", "pnl4I8MAnlO"),
    ("ICD10", "H59.8", "H59.8 Other postprocedural disorders of eye and adnexa", "Noc1xDWHcm6"),
    ("ICD10", "H59.9", "H59.9 Postprocedural disorder of eye and adnexa, unspecified", "h4hmqbQtZHt"),
    ("ICD10", "H60", "H60 Otitis externa", "biRSv1L63Rr"),
    ("ICD10", "H60.0", "H60.0 Abscess of external ear", "PbiGI5kHHmv"),
    ("ICD10", "H60.1", "H60.1 Cellulitis of external ear", "fDRf26ZMn3I"),
    ("ICD10", "H60.2", "H60.2 Malignant otitis externa", "TlLygJJatxk"),
    ("ICD10", "H60.3", "H60.3 Other infective otitis externa", "Or8NYuLol3g"),
    ("ICD10", "H60.4", "H60.4 Cholesteatoma of external ear", "GAilXADQHix"),
    ("ICD10", "H60.5", "H60.5 Acute otitis externa, noninfective", "Y3lQUbX8jb9"),
    ("ICD10", "H60.8", "H60.8 Other otitis externa", "dz0dCMJjCGG"),
    ("ICD10", "H60.9", "H60.9 Otitis externa, unspecified", "XuKuZVYBq6h"),
    ("ICD10", "H61", "H61 Other disorders of external ear", "usbF5UKkxuE"),
    ("ICD10", "H61.0", "H61.0 Perichondritis of external ear", "t65kLG38C65"),
    ("ICD10", "H61.1", "H61.1 Noninfective disorders of pinna", "ygzEUFfUD16"),
    ("ICD10", "H61.2", "H61.2 Impacted cerumen", "qPotmMXq7LG"),
    ("ICD10", "H61.3", "H61.3 Acquired stenosis of external ear canal", "ZRetXx6Pr9t"),
    ("ICD10", "H61.8", "H61.8 Other specified disorders of external ear", "BEkxU4uJ50H"),
    ("ICD10", "H61.9", "H61.9 Disorder of external ear, unspecified", "URHMVO4Vrv0"),
    ("ICD10", "H62", "H62 Disorders of external ear in diseases classified elsewhere", "hpt9e0zCxtG"),
    ("ICD10", "H62.0", "H62.0 Otitis externa in bacterial diseases classified elsewhere", "PjYaaM67vcg"),
    ("ICD10", "H62.1", "H62.1 Otitis externa in viral diseases classified elsewhere", "GOBjYezxkg4"),
    ("ICD10", "H62.2", "H62.2 Otitis externa in mycoses", "rvxJhYSgCVB"),
    ("ICD10", "H62.3", "H62.3 Otitis externa in other infectious and parasitic diseases classified elsewhere", "G6NHl1CTjcG"),
    ("ICD10", "H62.4", "H62.4 Otitis externa in other diseases classified elsewhere", "vlF56iM2sQP"),
    ("ICD10", "H62.8", "H62.8 Other disorders of external ear in diseases classified elsewhere", "OK5QhyMgjT6"),
    ("ICD10", "H65", "H65 Nonsuppurative otitis media", "SSfiWZwvKU2"),
    ("ICD10", "H65.0", "H65.0 Acute serous otitis media", "h5BR9YnP2Qb"),
    ("ICD10", "H65.1", "H65.1 Other acute nonsuppurative otitis media", "T2mFRKprT4H"),
    ("ICD10", "H65.2", "H65.2 Chronic serous otitis media", "k8en1qSzUr6"),
    ("ICD10", "H65.3", "H65.3 Chronic mucoid otitis media", "Wsfhon0audl"),
    ("ICD10", "H65.4", "H65.4 Other chronic nonsuppurative otitis media", "D4eyMleqzO9"),
    ("ICD10", "H65.9", "H65.9 Nonsuppurative otitis media, unspecified", "K3KnRTOCC6y"),
    ("ICD10", "H66", "H66 Suppurative and unspecified otitis media", "NTsNCP3iACI"),
    ("ICD10", "H66.0", "H66.0 Acute suppurative otitis media", "LnuFmYBRUoK"),
    ("ICD10", "H66.1", "H66.1 Chronic tubotympanic suppurative otitis media", "TuzYiFJSjTn"),
    ("ICD10", "H66.2", "H66.2 Chronic atticoantral suppurative otitis media", "hpDrM8qykk1"),
    ("ICD10", "H66.3", "H66.3 Other chronic suppurative otitis media", "iZSUJeHTLFY"),
    ("ICD10", "H66.4", "H66.4 Suppurative otitis media, unspecified", "HDBzsSFbW1g"),
    ("ICD10", "H66.9", "H66.9 Otitis media, unspecified", "pxsVBInu7Pf"),
    ("ICD10", "H67", "H67 Otitis media in diseases classified elsewhere", "vsXNExNksGs"),
    ("ICD10", "H67.0", "H67.0 Otitis media in bacterial diseases classified elsewhere", "xGrZIEkKj1y"),
    ("ICD10", "H67.1", "H67.1 Otitis media in viral diseases classified elsewhere", "dQqlRJhuyxS"),
    ("ICD10", "H67.8", "H67.8 Otitis media in other diseases classified elsewhere", "yeXciYcOMqX"),
    ("ICD10", "H68", "H68 Eustachian salpingitis and obstruction", "s5k8GmNqFQb"),
    ("ICD10", "H68.0", "H68.0 Eustachian salpingitis", "OsZCqCQWAM9"),
    ("ICD10", "H68.1", "H68.1 Obstruction of Eustachian tube", "iDss741jWz0"),
    ("ICD10", "H69", "H69 Other disorders of Eustachian tube", "f336ZjdmLNg"),
    ("ICD10", "H69.0", "H69.0 Patulous Eustachian tube", "YcjaacP18xm"),
    ("ICD10", "H69.8", "H69.8 Other specified disorders of Eustachian tube", "pN73eT2j6WV"),
    ("ICD10", "H69.9", "H69.9 Eustachian tube disorder, unspecified", "xPrsFip97MM"),
    ("ICD10", "H70", "H70 Mastoiditis and related conditions", "SoYkt9TTfLy"),
    ("ICD10", "H70.0", "H70.0 Acute mastoiditis", "WvApv3yht4y"),
    ("ICD10", "H70.1", "H70.1 Chronic mastoiditis", "BSG6DzKEcNb"),
    ("ICD10", "H70.2", "H70.2 Petrositis", "Mz6oOkfJHnQ"),
    ("ICD10", "H70.8", "H70.8 Other mastoiditis and related conditions", "iKPiQOEIQH7"),
    ("ICD10", "H70.9", "H70.9 Mastoiditis, unspecified", "iVn7NNu9j5V"),
    ("ICD10", "H71", "H71 Cholesteatoma of middle ear", "pwxiQSu1hvJ"),
    ("ICD10", "H72", "H72 Perforation of tympanic membrane", "FP3sQx31XQv"),
    ("ICD10", "H72.0", "H72.0 Central perforation of tympanic membrane", "JP17t69cRpr"),
    ("ICD10", "H72.1", "H72.1 Attic perforation of tympanic membrane", "uP8VgLzPgeQ"),
    ("ICD10", "H72.2", "H72.2 Other marginal perforations of tympanic membrane", "pXaAN8AzSC6"),
    ("ICD10", "H72.8", "H72.8 Other perforations of tympanic membrane", "NUidFoUD1Ij"),
    ("ICD10", "H72.9", "H72.9 Perforation of tympanic membrane, unspecified", "krAI0hlJPZ3"),
    ("ICD10", "H73", "H73 Other disorders of tympanic membrane", "DOt9fxh0NS7"),
    ("ICD10", "H73.0", "H73.0 Acute myringitis", "XuG7hufcdiM"),
    ("ICD10", "H73.1", "H73.1 Chronic myringitis", "aiMsGh2Vhwf"),
    ("ICD10", "H73.8", "H73.8 Other specified disorders of tympanic membrane", "DU9mKEycXz8"),
    ("ICD10", "H73.9", "H73.9 Disorder of tympanic membrane, unspecified", "hJYcCWp8CHH"),
    ("ICD10", "H74", "H74 Other disorders of middle ear and mastoid", "Rld23znrvoZ"),
    ("ICD10", "H74.0", "H74.0 Tympanosclerosis", "QxdfJ3AsO0x"),
    ("ICD10", "H74.1", "H74.1 Adhesive middle ear disease", "cHl13Fy1qWc"),
    ("ICD10", "H74.2", "H74.2 Discontinuity and dislocation of ear ossicles", "WrwAvxllFnO"),
    ("ICD10", "H74.3", "H74.3 Other acquired abnormalities of ear ossicles", "CQE7cPr4ZoD"),
    ("ICD10", "H74.4", "H74.4 Polyp of middle ear", "gn12pWA1PEK"),
    ("ICD10", "H74.8", "H74.8 Other specified disorders of middle ear and mastoid", "iwcuaLcissw"),
    ("ICD10", "H74.9", "H74.9 Disorder of middle ear and mastoid, unspecified", "qqMvA5GykCx"),
    ("ICD10", "H75", "H75 Other disorders of middle ear and mastoid in diseases classified elsewhere", "NXJUdoeph1n"),
    ("ICD10", "H75.0", "H75.0 Mastoiditis in infectious and parasitic diseases classified elsewhere", "YzdC6DHsT74"),
    ("ICD10", "H75.8", "H75.8 Other specified disorders of middle ear and mastoid in diseases classified elsewhere", "iS3iwpJqpaz"),
    ("ICD10", "H80", "H80 Otosclerosis", "I3sIqlsixIz"),
    ("ICD10", "H80.0", "H80.0 Otosclerosis involving oval window, nonobliterative", "W2EnpIKWpsB"),
    ("ICD10", "H80.1", "H80.1 Otosclerosis involving oval window, obliterative", "EJcoMYhbZ4F"),
    ("ICD10", "H80.2", "H80.2 Cochlear otosclerosis", "fMcHlxtGRVo"),
    ("ICD10", "H80.8", "H80.8 Other otosclerosis", "JCRYXYzp6UT"),
    ("ICD10", "H80.9", "H80.9 Otosclerosis, unspecified", "hvFDBfK8rSV"),
    ("ICD10", "H81", "H81 Disorders of vestibular function", "V0vsN5lJtxm"),
    ("ICD10", "H81.0", "H81.0 Ménière disease", "gJTAoZntzzd"),
    ("ICD10", "H81.1", "H81.1 Benign paroxysmal vertigo", "J5570F8zdYa"),
    ("ICD10", "H81.2", "H81.2 Vestibular neuronitis", "e0zgmdoaJuZ"),
    ("ICD10", "H81.3", "H81.3 Other peripheral vertigo", "kKJ6D5O7myZ"),
    ("ICD10", "H81.4", "H81.4 Vertigo of central origin", "kIaoIixwJB9"),
    ("ICD10", "H81.8", "H81.8 Other disorders of vestibular function", "dQ29K3zNyju"),
    ("ICD10", "H81.9", "H81.9 Disorder of vestibular function, unspecified", "Bq3uMjunZ88"),
    ("ICD10", "H82", "H82 Vertiginous syndromes in diseases classified elsewhere", "orke1XfZWd7"),
    ("ICD10", "H83", "H83 Other diseases of inner ear", "luKyUxyzUey"),
    ("ICD10", "H83.0", "H83.0 Labyrinthitis", "APHgjyzDayM"),
    ("ICD10", "H83.1", "H83.1 Labyrinthine fistula", "VGzb5I8zNV9"),
    ("ICD10", "H83.2", "H83.2 Labyrinthine dysfunction", "dsd1ougW2iO"),
    ("ICD10", "H83.3", "H83.3 Noise effects on inner ear", "yzbuhYsCHhq"),
    ("ICD10", "H83.8", "H83.8 Other specified diseases of inner ear", "PXLQkUqutzn"),
    ("ICD10", "H83.9", "H83.9 Disease of inner ear, unspecified", "rgHXeAWOD3r"),
    ("ICD10", "H90", "H90 Conductive and sensorineural hearing loss", "zu8WyvVTwCT"),
    ("ICD10", "H90.0", "H90.0 Conductive hearing loss, bilateral", "WqE7D5rVfKq"),
    ("ICD10", "H90.1", "H90.1 Conductive hearing loss, unilateral with unrestricted hearing on the contralateral side", "KVidwUcWozQ"),
    ("ICD10", "H90.2", "H90.2 Conductive hearing loss, unspecified", "m0WW9Q7MicQ"),
    ("ICD10", "H90.3", "H90.3 Sensorineural hearing loss, bilateral", "wxW0FK9eoq8"),
    ("ICD10", "H90.4", "H90.4 Sensorineural hearing loss, unilateral with unrestricted hearing on the contralateral side", "L7Nv91XDbLE"),
    ("ICD10", "H90.5", "H90.5 Sensorineural hearing loss, unspecified", "bfPCeGEy0Iy"),
    ("ICD10", "H90.6", "H90.6 Mixed conductive and sensorineural hearing loss, bilateral", "UEbEmOZJ7CJ"),
    ("ICD10", "H90.7", "H90.7 Mixed conductive and sensorineural hearing loss, unilateral with unrestricted hearing on the contralateral side", "NswaI6sjQvu"),
    ("ICD10", "H90.8", "H90.8 Mixed conductive and sensorineural hearing loss, unspecified", "tgkIJY8NMdy"),
    ("ICD10", "H91", "H91 Other hearing loss", "TMdcds3l9Wm"),
    ("ICD10", "H91.0", "H91.0 Ototoxic hearing loss", "iNtgZFFXCBY"),
    ("ICD10", "H91.1", "H91.1 Presbycusis", "SYEvk0Bv18J"),
    ("ICD10", "H91.2", "H91.2 Sudden idiopathic hearing loss", "kjehfCOMOdi"),
    ("ICD10", "H91.3", "H91.3 Deaf mutism, not elsewhere classified", "SV23WTFx4qe"),
    ("ICD10", "H91.8", "H91.8 Other specified hearing loss", "n3K0AQlZgSt"),
    ("ICD10", "H91.9", "H91.9 Hearing loss, unspecified", "sKu0K6zSlbH"),
    ("ICD10", "H92", "H92 Otalgia and effusion of ear", "MyLNzDkCUAL"),
    ("ICD10", "H92.0", "H92.0 Otalgia", "it57GBj3lcz"),
    ("ICD10", "H92.1", "H92.1 Otorrhoea", "F2sgrICzmMI"),
    ("ICD10", "H92.2", "H92.2 Otorrhagia", "GamnDiraoHZ"),
    ("ICD10", "H93", "H93 Other disorders of ear, not elsewhere classified", "zVnKwopj9Lo"),
    ("ICD10", "H93.0", "H93.0 Degenerative and vascular disorders of ear", "PJI8LQmsYwq"),
    ("ICD10", "H93.1", "H93.1 Tinnitus", "cUQcvM7uoQ6"),
    ("ICD10", "H93.2", "H93.2 Other abnormal auditory perceptions", "IzmCxU0rWoJ"),
    ("ICD10", "H93.3", "H93.3 Disorders of acoustic nerve", "RSjTWRVRbUF"),
    ("ICD10", "H93.8", "H93.8 Other specified disorders of ear", "t8cNYN4HENS"),
    ("ICD10", "H93.9", "H93.9 Disorder of ear, unspecified", "z1rb0f2rgJB"),
    ("ICD10", "H94", "H94 Other disorders of ear in diseases classified elsewhere", "lwLpzGGiejk"),
    ("ICD10", "H94.0", "H94.0 Acoustic neuritis in infectious and parasitic diseases classified elsewhere", "WDkxnrr6Cja"),
    ("ICD10", "H94.8", "H94.8 Other specified disorders of ear in diseases classified elsewhere", "Hl9W5DgHNls"),
    ("ICD10", "H95", "H95 Postprocedural disorders of ear and mastoid process, not elsewhere classified", "zfIMStBoCRk"),
    ("ICD10", "H95.0", "H95.0 Recurrent cholesteatoma of postmastoidectomy cavity", "HjoJ5b1KXCW"),
    ("ICD10", "H95.1", "H95.1 Other disorders following mastoidectomy", "GT1w1TpeLAv"),
    ("ICD10", "H95.8", "H95.8 Other postprocedural disorders of ear and mastoid process", "OV01UELm00j"),
    ("ICD10", "H95.9", "H95.9 Postprocedural disorder of ear and mastoid process, unspecified", "hrlH6japTgX");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "I00", "I00 Rheumatic fever without mention of heart involvement", "E17F69V3Lfi"),
    ("ICD10", "I01", "I01 Rheumatic fever with heart involvement", "xrMcpbNYXZY"),
    ("ICD10", "I01.0", "I01.0 Acute rheumatic pericarditis", "Wm11SWPjYk8"),
    ("ICD10", "I01.1", "I01.1 Acute rheumatic endocarditis", "T8j23XynOWL"),
    ("ICD10", "I01.2", "I01.2 Acute rheumatic myocarditis", "JMiMF5xO9iS"),
    ("ICD10", "I01.8", "I01.8 Other acute rheumatic heart disease", "f31koRrOXRJ"),
    ("ICD10", "I01.9", "I01.9 Acute rheumatic heart disease, unspecified", "vuCOzfG7hP9"),
    ("ICD10", "I02", "I02 Rheumatic chorea", "UfVigKihwPg"),
    ("ICD10", "I02.0", "I02.0 Rheumatic chorea with heart involvement", "e5qCnfWVVlX"),
    ("ICD10", "I02.9", "I02.9 Rheumatic chorea without heart involvement", "zfiKpCda2LU"),
    ("ICD10", "I05", "I05 Rheumatic mitral valve diseases", "GF0uyvRr08P"),
    ("ICD10", "I05.0", "I05.0 Mitral stenosis", "dN2oWeB1GCO"),
    ("ICD10", "I05.1", "I05.1 Rheumatic mitral insufficiency", "sWQ2d1HyOTb"),
    ("ICD10", "I05.2", "I05.2 Mitral stenosis with insufficiency", "i8Yji1K0LH5"),
    ("ICD10", "I05.8", "I05.8 Other mitral valve diseases", "hqHc4LhDy2v"),
    ("ICD10", "I05.9", "I05.9 Mitral valve disease, unspecified", "ZMtziYYnZ9l"),
    ("ICD10", "I06", "I06 Rheumatic aortic valve diseases", "Iz1Z7n6vjZh"),
    ("ICD10", "I06.0", "I06.0 Rheumatic aortic stenosis", "kXWpyxsh7iJ"),
    ("ICD10", "I06.1", "I06.1 Rheumatic aortic insufficiency", "XLz26dFFdLf"),
    ("ICD10", "I06.2", "I06.2 Rheumatic aortic stenosis with insufficiency", "d5x2oyw3uah"),
    ("ICD10", "I06.8", "I06.8 Other rheumatic aortic valve diseases", "Bd4oz8vqvYR"),
    ("ICD10", "I06.9", "I06.9 Rheumatic aortic valve disease, unspecified", "eZ1UfCr6lUG"),
    ("ICD10", "I07", "I07 Rheumatic tricuspid valve diseases", "AIgTyc6VG2S"),
    ("ICD10", "I07.0", "I07.0 Tricuspid stenosis", "e59mv0Xu7oR"),
    ("ICD10", "I07.1", "I07.1 Tricuspid insufficiency", "Rkw31Cvj8yG"),
    ("ICD10", "I07.2", "I07.2 Tricuspid stenosis with insufficiency", "yVxTRXoTnCx"),
    ("ICD10", "I07.8", "I07.8 Other tricuspid valve diseases", "U9OuiJewKFN"),
    ("ICD10", "I07.9", "I07.9 Tricuspid valve disease, unspecified", "Lc2ovfhvnLS"),
    ("ICD10", "I08", "I08 Multiple valve diseases", "N824BOOq1B7"),
    ("ICD10", "I08.0", "I08.0 Disorders of both mitral and aortic valves", "BpYQWqLoJ0t"),
    ("ICD10", "I08.1", "I08.1 Disorders of both mitral and tricuspid valves", "Nw7uy3lbEn7"),
    ("ICD10", "I08.2", "I08.2 Disorders of both aortic and tricuspid valves", "KPyX4CpFDKn"),
    ("ICD10", "I08.3", "I08.3 Combined disorders of mitral, aortic and tricuspid valves", "V4VUJKQzvwA"),
    ("ICD10", "I08.8", "I08.8 Other multiple valve diseases", "HScKmFYETNY"),
    ("ICD10", "I08.9", "I08.9 Multiple valve disease, unspecified", "g0pulYB1ko9"),
    ("ICD10", "I09", "I09 Other rheumatic heart diseases", "Tzr3Bh1HLzS"),
    ("ICD10", "I09.0", "I09.0 Rheumatic myocarditis", "LdmdQjnYhqc"),
    ("ICD10", "I09.1", "I09.1 Rheumatic diseases of endocardium, valve unspecified", "uMVxG2T9nMI"),
    ("ICD10", "I09.2", "I09.2 Chronic rheumatic pericarditis", "opHJpC7yzJi"),
    ("ICD10", "I09.8", "I09.8 Other specified rheumatic heart diseases", "ZTTq4Ia2vHn"),
    ("ICD10", "I09.9", "I09.9 Rheumatic heart disease, unspecified", "dEQuHk2wlmB"),
    ("ICD10", "I10", "I10 Essential (primary) hypertension", "rnI7lQTLu34"),
    ("ICD10", "I11", "I11 Hypertensive heart disease", "ewPsNvzUkTp"),
    ("ICD10", "I11.0", "I11.0 Hypertensive heart disease with (congestive) heart failure", "fPrWLt0gsoR"),
    ("ICD10", "I11.9", "I11.9 Hypertensive heart disease without (congestive) heart failure", "HKdGq5sOrtW"),
    ("ICD10", "I12", "I12 Hypertensive renal disease", "Q8syYn5Nbjt"),
    ("ICD10", "I12.0", "I12.0 Hypertensive renal disease with renal failure", "QdN26TzuX0G"),
    ("ICD10", "I12.9", "I12.9 Hypertensive renal disease without renal failure", "dlqLAi5O7XS"),
    ("ICD10", "I13", "I13 Hypertensive heart and renal disease", "Kn8MCYzTY04"),
    ("ICD10", "I13.0", "I13.0 Hypertensive heart and renal disease with (congestive) heart failure", "LautodIPtPt"),
    ("ICD10", "I13.1", "I13.1 Hypertensive heart and renal disease with renal failure", "JArRfObN3id"),
    ("ICD10", "I13.2", "I13.2 Hypertensive heart and renal disease with both (congestive) heart failure and renal failure", "oxAuHeinWFO"),
    ("ICD10", "I13.9", "I13.9 Hypertensive heart and renal disease, unspecified", "Zhpltj5h6Vg"),
    ("ICD10", "I15", "I15 Secondary hypertension", "jVy48fSqEF0"),
    ("ICD10", "I15.0", "I15.0 Renovascular hypertension", "zDzn1vPhHMQ"),
    ("ICD10", "I15.1", "I15.1 Hypertension secondary to other renal disorders", "viCbb0cqbma"),
    ("ICD10", "I15.2", "I15.2 Hypertension secondary to endocrine disorders", "GA67DSkFn3L"),
    ("ICD10", "I15.8", "I15.8 Other secondary hypertension", "obtMcdDvPeQ"),
    ("ICD10", "I15.9", "I15.9 Secondary hypertension, unspecified", "eBo0UA7lxDT"),
    ("ICD10", "I20", "I20 Angina pectoris", "mU7O2cdjzzh"),
    ("ICD10", "I20.0", "I20.0 Unstable angina", "HHbaxtNri6B"),
    ("ICD10", "I20.1", "I20.1 Angina pectoris with documented spasm", "zcW2t5dnKqX"),
    ("ICD10", "I20.8", "I20.8 Other forms of angina pectoris", "I2q5jGlUJT0"),
    ("ICD10", "I20.9", "I20.9 Angina pectoris, unspecified", "eEuJt2jdzYS"),
    ("ICD10", "I21", "I21 Acute myocardial infarction", "tyykp7PiUsC"),
    ("ICD10", "I21.0", "I21.0 Acute transmural myocardial infarction of anterior wall", "QgZ4CySefEF"),
    ("ICD10", "I21.1", "I21.1 Acute transmural myocardial infarction of inferior wall", "dSIC0i0sFN7"),
    ("ICD10", "I21.2", "I21.2 Acute transmural myocardial infarction of other sites", "uCazH8B3cy8"),
    ("ICD10", "I21.3", "I21.3 Acute transmural myocardial infarction of unspecified site", "z9DPoZW9J54"),
    ("ICD10", "I21.4", "I21.4 Acute subendocardial myocardial infarction", "ybHSUVcntaW"),
    ("ICD10", "I21.9", "I21.9 Acute myocardial infarction, unspecified", "tk0J5AyCY6T"),
    ("ICD10", "I22", "I22 Subsequent myocardial infarction", "CMU5zHxqy2l"),
    ("ICD10", "I22.0", "I22.0 Subsequent myocardial infarction of anterior wall", "dTqIO1fwDIg"),
    ("ICD10", "I22.1", "I22.1 Subsequent myocardial infarction of inferior wall", "TQ4ghrWEiOO"),
    ("ICD10", "I22.8", "I22.8 Subsequent myocardial infarction of other sites", "Vd2GHhUaezY"),
    ("ICD10", "I22.9", "I22.9 Subsequent myocardial infarction of unspecified site", "L6wZxj5lhCH"),
    ("ICD10", "I23", "I23 Certain current complications following acute myocardial infarction", "vvIenqBxXPk"),
    ("ICD10", "I23.0", "I23.0 Haemopericardium as current complication following acute myocardial infarction", "YvnFOibIrlC"),
    ("ICD10", "I23.1", "I23.1 Atrial septal defect as current complication following acute myocardial infarction", "wuV8yV15XsD"),
    ("ICD10", "I23.2", "I23.2 Ventricular septal defect as current complication following acute myocardial infarction", "VHCLZzNmS4I"),
    ("ICD10", "I23.3", "I23.3 Rupture of cardiac wall without haemopericardium as current complication following acute myocardial infarction", "RATSazH7q9c"),
    ("ICD10", "I23.4", "I23.4 Rupture of chordae tendineae as current complication following acute myocardial infarction", "Jv4thliBUyW"),
    ("ICD10", "I23.5", "I23.5 Rupture of papillary muscle as current complication following acute myocardial infarction", "XwOroTt01mx"),
    ("ICD10", "I23.6", "I23.6 Thrombosis of atrium, auricular appendage, and ventricle as current complications following acute myocardial infarction", "A2iR4aENzPf"),
    ("ICD10", "I23.8", "I23.8 Other current complications following acute myocardial infarction", "qCVI0Ac0A9E"),
    ("ICD10", "I24", "I24 Other acute ischaemic heart diseases", "VjFmWHJYPXg"),
    ("ICD10", "I24.0", "I24.0 Coronary thrombosis not resulting in myocardial infarction", "aCMRUgLEPRs"),
    ("ICD10", "I24.1", "I24.1 Dressler syndrome", "oKRL9GGRzF3"),
    ("ICD10", "I24.8", "I24.8 Other forms of acute ischaemic heart disease", "YZgIIs2tdmZ"),
    ("ICD10", "I24.9", "I24.9 Acute ischaemic heart disease, unspecified", "iFhlT40aZMj"),
    ("ICD10", "I25", "I25 Chronic ischaemic heart disease", "y2jQTWj5XOE"),
    ("ICD10", "I25.0", "I25.0 Atherosclerotic cardiovascular disease, so described", "xxsUTooFRcA"),
    ("ICD10", "I25.1", "I25.1 Atherosclerotic heart disease", "ScOFCOVeNsu"),
    ("ICD10", "I25.2", "I25.2 Old myocardial infarction", "Dp9pIOeH5Ka"),
    ("ICD10", "I25.3", "I25.3 Aneurysm of heart", "llvnTioKmR2"),
    ("ICD10", "I25.4", "I25.4 Coronary artery aneurysm and dissection", "ePf4eH8NNk8"),
    ("ICD10", "I25.5", "I25.5 Ischaemic cardiomyopathy", "px1wsywEntN"),
    ("ICD10", "I25.6", "I25.6 Silent myocardial ischaemia", "v5SOTdyjyuH"),
    ("ICD10", "I25.8", "I25.8 Other forms of chronic ischaemic heart disease", "NahGucN68aa"),
    ("ICD10", "I25.9", "I25.9 Chronic ischaemic heart disease, unspecified", "l5E8EaHZibM"),
    ("ICD10", "I26", "I26 Pulmonary embolism", "HKolq5DB8nn"),
    ("ICD10", "I26.0", "I26.0 Pulmonary embolism with mention of acute cor pulmonale", "jlZj0f4u5fk"),
    ("ICD10", "I26.9", "I26.9 Pulmonary embolism without mention of acute cor pulmonale", "mxzpv367lKZ"),
    ("ICD10", "I27", "I27 Other pulmonary heart diseases", "RiCu0hqx1mu"),
    ("ICD10", "I27.0", "I27.0 Primary pulmonary hypertension", "LLpkJsoB7n5"),
    ("ICD10", "I27.1", "I27.1 Kyphoscoliotic heart disease", "jyl27rxlEjR"),
    ("ICD10", "I27.2", "I27.2 Other secondary pulmonary hypertension", "VvZHupc05yX"),
    ("ICD10", "I27.8", "I27.8 Other specified pulmonary heart diseases", "wpBho8i8r38"),
    ("ICD10", "I27.9", "I27.9 Pulmonary heart disease, unspecified", "EulfgIM9p8t"),
    ("ICD10", "I28", "I28 Other diseases of pulmonary vessels", "jM1QY2Fv9Nb"),
    ("ICD10", "I28.0", "I28.0 Arteriovenous fistula of pulmonary vessels", "AN5aqlB7T7s"),
    ("ICD10", "I28.1", "I28.1 Aneurysm of pulmonary artery", "mYTlX5xGRmh"),
    ("ICD10", "I28.8", "I28.8 Other specified diseases of pulmonary vessels", "w1xQEoEvrin"),
    ("ICD10", "I28.9", "I28.9 Disease of pulmonary vessels, unspecified", "gTLn20CsQSd"),
    ("ICD10", "I30", "I30 Acute pericarditis", "gBozR8H9So3"),
    ("ICD10", "I30.0", "I30.0 Acute nonspecific idiopathic pericarditis", "R96GfEsgltz"),
    ("ICD10", "I30.1", "I30.1 Infective pericarditis", "miNXvRTi0sx"),
    ("ICD10", "I30.8", "I30.8 Other forms of acute pericarditis", "Zn4smY2kDye"),
    ("ICD10", "I30.9", "I30.9 Acute pericarditis, unspecified", "yILPZjigCvx"),
    ("ICD10", "I31", "I31 Other diseases of pericardium", "VetyW7Miwk4"),
    ("ICD10", "I31.0", "I31.0 Chronic adhesive pericarditis", "VDDwshmchU7"),
    ("ICD10", "I31.1", "I31.1 Chronic constrictive pericarditis", "Aks7pDefk21"),
    ("ICD10", "I31.2", "I31.2 Haemopericardium, not elsewhere classified", "qz0aNNYRqYF"),
    ("ICD10", "I31.3", "I31.3 Pericardial effusion (noninflammatory)", "BQXYU9z6f0v"),
    ("ICD10", "I31.8", "I31.8 Other specified diseases of pericardium", "PYpLOgClXW7"),
    ("ICD10", "I31.9", "I31.9 Disease of pericardium, unspecified", "VZ0oeOc72rp"),
    ("ICD10", "I32", "I32 Pericarditis in diseases classified elsewhere", "NAVfuLZLX27"),
    ("ICD10", "I32.0", "I32.0 Pericarditis in bacterial diseases classified elsewhere", "kwbfWs6ZGCM"),
    ("ICD10", "I32.1", "I32.1 Pericarditis in other infectious and parasitic diseases classified elsewhere", "HHSAas62iKF"),
    ("ICD10", "I32.8", "I32.8 Pericarditis in other diseases classified elsewhere", "tKbldNrV6v8"),
    ("ICD10", "I33", "I33 Acute and subacute endocarditis", "lWkc5xlb8CG"),
    ("ICD10", "I33.0", "I33.0 Acute and subacute infective endocarditis", "Do2EmBTGinq"),
    ("ICD10", "I33.9", "I33.9 Acute endocarditis, unspecified", "Af2DD7bfLkA"),
    ("ICD10", "I34", "I34 Nonrheumatic mitral valve disorders", "k1fv1hkA86Q"),
    ("ICD10", "I34.0", "I34.0 Mitral (valve) insufficiency", "zy5VzZt1jNC"),
    ("ICD10", "I34.1", "I34.1 Mitral (valve) prolapse", "TfwgumFrp04"),
    ("ICD10", "I34.2", "I34.2 Nonrheumatic mitral (valve) stenosis", "pdfy6ih0uuN"),
    ("ICD10", "I34.8", "I34.8 Other nonrheumatic mitral valve disorders", "I5QapVBLXB8"),
    ("ICD10", "I34.9", "I34.9 Nonrheumatic mitral valve disorder, unspecified", "wyFmfApmBKu"),
    ("ICD10", "I35", "I35 Nonrheumatic aortic valve disorders", "aX0v6Ec9C2l"),
    ("ICD10", "I35.0", "I35.0 Aortic (valve) stenosis", "nvb77Ir0CzA"),
    ("ICD10", "I35.1", "I35.1 Aortic (valve) insufficiency", "ssNxGUuNYhQ"),
    ("ICD10", "I35.2", "I35.2 Aortic (valve) stenosis with insufficiency", "d6bCfInq93s"),
    ("ICD10", "I35.8", "I35.8 Other aortic valve disorders", "zyrJC3CeCay"),
    ("ICD10", "I35.9", "I35.9 Aortic valve disorder, unspecified", "FKQLmK4yVLD"),
    ("ICD10", "I36", "I36 Nonrheumatic tricuspid valve disorders", "DPm5cKFE41Y"),
    ("ICD10", "I36.0", "I36.0 Nonrheumatic tricuspid (valve) stenosis", "BKdCz2w4JYn"),
    ("ICD10", "I36.1", "I36.1 Nonrheumatic tricuspid (valve) insufficiency", "yFmHqj5u5wC"),
    ("ICD10", "I36.2", "I36.2 Nonrheumatic tricuspid (valve) stenosis with insufficiency", "SmQNVI9wFCf"),
    ("ICD10", "I36.8", "I36.8 Other nonrheumatic tricuspid valve disorders", "HSRpjzQ0buD"),
    ("ICD10", "I36.9", "I36.9 Nonrheumatic tricuspid valve disorder, unspecified", "zW6mHUI70cj"),
    ("ICD10", "I37", "I37 Pulmonary valve disorders", "qw92aVXHgqQ"),
    ("ICD10", "I37.0", "I37.0 Pulmonary valve stenosis", "UlSP7GrGjL9"),
    ("ICD10", "I37.1", "I37.1 Pulmonary valve insufficiency", "kMibfl94dGL"),
    ("ICD10", "I37.2", "I37.2 Pulmonary valve stenosis with insufficiency", "DIBOldtWglP"),
    ("ICD10", "I37.8", "I37.8 Other pulmonary valve disorders", "JVFtOFXDNIt"),
    ("ICD10", "I37.9", "I37.9 Pulmonary valve disorder, unspecified", "Ozgr620O72L"),
    ("ICD10", "I38", "I38 Endocarditis, valve unspecified", "BxvmdlxaGHj"),
    ("ICD10", "I39", "I39 Endocarditis and heart valve disorders in diseases classified elsewhere", "pezuTovLF50"),
    ("ICD10", "I39.0", "I39.0 Mitral valve disorders in diseases classified elsewhere", "md366gBSoAL"),
    ("ICD10", "I39.1", "I39.1 Aortic valve disorders in diseases classified elsewhere", "FeWly9pxLHu"),
    ("ICD10", "I39.2", "I39.2 Tricuspid valve disorders in diseases classified elsewhere", "XEdzQmaQuH2"),
    ("ICD10", "I39.3", "I39.3 Pulmonary valve disorders in diseases classified elsewhere", "xPKJgJrVKDy"),
    ("ICD10", "I39.4", "I39.4 Multiple valve disorders in diseases classified elsewhere", "q9W8h6LEzWj"),
    ("ICD10", "I39.8", "I39.8 Endocarditis, valve unspecified, in diseases classified elsewhere", "zrkSA9PlRPL"),
    ("ICD10", "I40", "I40 Acute myocarditis", "n0V96Zgxxpm"),
    ("ICD10", "I40.0", "I40.0 Infective myocarditis", "f7F0WmwaVR9"),
    ("ICD10", "I40.1", "I40.1 Isolated myocarditis", "JQMxOkseYg7"),
    ("ICD10", "I40.8", "I40.8 Other acute myocarditis", "jPfqsUXN2nJ"),
    ("ICD10", "I40.9", "I40.9 Acute myocarditis, unspecified", "dSdxlrqpJjK"),
    ("ICD10", "I41", "I41 Myocarditis in diseases classified elsewhere", "DpK3tdQUimY"),
    ("ICD10", "I41.0", "I41.0 Myocarditis in bacterial diseases classified elsewhere", "jfNVmZikP9q"),
    ("ICD10", "I41.1", "I41.1 Myocarditis in viral diseases classified elsewhere", "ZqSqZPqu5VC"),
    ("ICD10", "I41.2", "I41.2 Myocarditis in other infectious and parasitic diseases classified elsewhere", "Pb1AQjpq4fx"),
    ("ICD10", "I41.8", "I41.8 Myocarditis in other diseases classified elsewhere", "SD46fzhv0bn"),
    ("ICD10", "I42", "I42 Cardiomyopathy", "F3mVntYJdzb"),
    ("ICD10", "I42.0", "I42.0 Dilated cardiomyopathy", "kGZ0E1Zx7ut"),
    ("ICD10", "I42.1", "I42.1 Obstructive hypertrophic cardiomyopathy", "yhz3qjXXYCm"),
    ("ICD10", "I42.2", "I42.2 Other hypertrophic cardiomyopathy", "nf9WfRJD8Fl"),
    ("ICD10", "I42.3", "I42.3 Endomyocardial (eosinophilic) disease", "uGl019E5Lee"),
    ("ICD10", "I42.4", "I42.4 Endocardial fibroelastosis", "QiHJRcbQh9p"),
    ("ICD10", "I42.5", "I42.5 Other restrictive cardiomyopathy", "IfCSMq91v1R"),
    ("ICD10", "I42.6", "I42.6 Alcoholic cardiomyopathy", "vP5z5rkimLv"),
    ("ICD10", "I42.7", "I42.7 Cardiomyopathy due to drugs and other external agents", "aRnuDyJsJjy"),
    ("ICD10", "I42.8", "I42.8 Other cardiomyopathies", "hRfk5LM4QJK"),
    ("ICD10", "I42.9", "I42.9 Cardiomyopathy, unspecified", "ofMi4ybGsWW"),
    ("ICD10", "I43", "I43 Cardiomyopathy in diseases classified elsewhere", "BklEsQ2H9Uc"),
    ("ICD10", "I43.0", "I43.0 Cardiomyopathy in infectious and parasitic diseases classified elsewhere", "s0C4XCxFBlB"),
    ("ICD10", "I43.1", "I43.1 Cardiomyopathy in metabolic diseases", "TWMnwML49j2"),
    ("ICD10", "I43.2", "I43.2 Cardiomyopathy in nutritional diseases", "qSr0nld7t14"),
    ("ICD10", "I43.8", "I43.8 Cardiomyopathy in other diseases classified elsewhere", "z0TerhwaGe8"),
    ("ICD10", "I44", "I44 Atrioventricular and left bundle-branch block", "FK6qqZGmySq"),
    ("ICD10", "I44.0", "I44.0 Atrioventricular block, first degree", "ftAeGkngkLU"),
    ("ICD10", "I44.1", "I44.1 Atrioventricular block, second degree", "ejRczIsW5aS"),
    ("ICD10", "I44.2", "I44.2 Atrioventricular block, complete", "fT1K2ni6p0M"),
    ("ICD10", "I44.3", "I44.3 Other and unspecified atrioventricular block", "BJlk6uLTak7"),
    ("ICD10", "I44.4", "I44.4 Left anterior fascicular block", "H01Qe57bO16"),
    ("ICD10", "I44.5", "I44.5 Left posterior fascicular block", "FE7unwFOoEo"),
    ("ICD10", "I44.6", "I44.6 Other and unspecified fascicular block", "GkIzzyhX5ur"),
    ("ICD10", "I44.7", "I44.7 Left bundle-branch block, unspecified", "xGDi7VnONK0"),
    ("ICD10", "I45", "I45 Other conduction disorders", "tyIbR6Bf2wL"),
    ("ICD10", "I45.0", "I45.0 Right fascicular block", "vSIA0thDtrC"),
    ("ICD10", "I45.1", "I45.1 Other and unspecified right bundle-branch block", "ELj7SAomXsH"),
    ("ICD10", "I45.2", "I45.2 Bifascicular block", "i6Awb2nKNPz"),
    ("ICD10", "I45.3", "I45.3 Trifascicular block", "zUmgCeOXELa"),
    ("ICD10", "I45.4", "I45.4 Nonspecific intraventricular block", "W7HfXMPRgi5"),
    ("ICD10", "I45.5", "I45.5 Other specified heart block", "yuWKS1kHZav"),
    ("ICD10", "I45.6", "I45.6 Pre-excitation syndrome", "ksG7MrDBTd6"),
    ("ICD10", "I45.8", "I45.8 Other specified conduction disorders", "ZdLwz1hDaFe"),
    ("ICD10", "I45.9", "I45.9 Conduction disorder, unspecified", "U7vFfJKj9YO"),
    ("ICD10", "I46", "I46 Cardiac arrest", "mgxEzANweAX"),
    ("ICD10", "I46.0", "I46.0 Cardiac arrest with successful resuscitation", "N3nSszadJk8"),
    ("ICD10", "I46.1", "I46.1 Sudden cardiac death, so described", "PUjtjlhMCCo"),
    ("ICD10", "I46.9", "I46.9 Cardiac arrest, unspecified", "ZJR6cjcjPEW"),
    ("ICD10", "I47", "I47 Paroxysmal tachycardia", "qUnHcuK4hkg"),
    ("ICD10", "I47.0", "I47.0 Re-entry ventricular arrhythmia", "HufPK1mk2uD"),
    ("ICD10", "I47.1", "I47.1 Supraventricular tachycardia", "ianzTbfvMfa"),
    ("ICD10", "I47.2", "I47.2 Ventricular tachycardia", "fWkNyvr1HGw"),
    ("ICD10", "I47.9", "I47.9 Paroxysmal tachycardia, unspecified", "NSZhxdnR4Sx"),
    ("ICD10", "I48", "I48 Atrial fibrillation and flutter", "pdMmUihkw7b"),
    ("ICD10", "I48.0", "I48.0 Paroxysmal atrial fibrillation", "ECW3a90eIuq"),
    ("ICD10", "I48.1", "I48.1 Persistent atrial fibrillation", "acNxeqGX4ma"),
    ("ICD10", "I48.2", "I48.2 Chronic atrial fibrillation", "bmOEtVmLllW"),
    ("ICD10", "I48.3", "I48.3 Typical atrial flutter", "B0Qt66TIdtI"),
    ("ICD10", "I48.4", "I48.4 Atypical atrial flutter", "A3zuz9YbfC4"),
    ("ICD10", "I48.9", "I48.9 Atrial fibrillation and atrial flutter, unspecified", "F7lLbVKYbNq"),
    ("ICD10", "I49", "I49 Other cardiac arrhythmias", "aVUlYA7lYNp"),
    ("ICD10", "I49.0", "I49.0 Ventricular fibrillation and flutter", "kmLAm6WGMTW"),
    ("ICD10", "I49.1", "I49.1 Atrial premature depolarization", "zYLnXY6g2gD"),
    ("ICD10", "I49.2", "I49.2 Junctional premature depolarization", "FpAVCFc2dD5"),
    ("ICD10", "I49.3", "I49.3 Ventricular premature depolarization", "AIq2OyIcCmb"),
    ("ICD10", "I49.4", "I49.4 Other and unspecified premature depolarization", "R1raiAuto8W"),
    ("ICD10", "I49.5", "I49.5 Sick sinus syndrome", "kNVrL8eNcgT"),
    ("ICD10", "I49.8", "I49.8 Other specified cardiac arrhythmias", "Z2vjKnBlFVa"),
    ("ICD10", "I49.9", "I49.9 Cardiac arrhythmia, unspecified", "Grk5L46jC1T"),
    ("ICD10", "I50", "I50 Heart failure", "uOUpB6bNBRv"),
    ("ICD10", "I50.0", "I50.0 Congestive heart failure", "HztoCEn3B66"),
    ("ICD10", "I50.1", "I50.1 Left ventricular failure", "jH3opFE6t1h"),
    ("ICD10", "I50.9", "I50.9 Heart failure, unspecified", "CNfQGNXD4iT"),
    ("ICD10", "I51", "I51 Complications and ill-defined descriptions of heart disease", "FWrzrpCR1m6"),
    ("ICD10", "I51.0", "I51.0 Cardiac septal defect, acquired", "dLvcbAGHZHS"),
    ("ICD10", "I51.1", "I51.1 Rupture of chordae tendineae, not elsewhere classified", "pQiJNnVAGNH"),
    ("ICD10", "I51.2", "I51.2 Rupture of papillary muscle, not elsewhere classified", "JHrAP0VCy56"),
    ("ICD10", "I51.3", "I51.3 Intracardiac thrombosis, not elsewhere classified", "U9sbVRw4MpL"),
    ("ICD10", "I51.4", "I51.4 Myocarditis, unspecified", "gMJHak2Aedw"),
    ("ICD10", "I51.5", "I51.5 Myocardial degeneration", "ih7xFE2UuUE"),
    ("ICD10", "I51.6", "I51.6 Cardiovascular disease, unspecified", "Bqwqk5kpIOX"),
    ("ICD10", "I51.7", "I51.7 Cardiomegaly", "C0Q1L2Wn1vT"),
    ("ICD10", "I51.8", "I51.8 Other ill-defined heart diseases", "i7JdXBiLmtY"),
    ("ICD10", "I51.9", "I51.9 Heart disease, unspecified", "CRwSTM1T7Gq"),
    ("ICD10", "I52", "I52 Other heart disorders in diseases classified elsewhere", "OYr4UgRvizD"),
    ("ICD10", "I52.0", "I52.0 Other heart disorders in bacterial diseases classified elsewhere", "adexAfTf4sU"),
    ("ICD10", "I52.1", "I52.1 Other heart disorders in other infectious and parasitic diseases classified elsewhere", "jiInXd3gTvc"),
    ("ICD10", "I52.8", "I52.8 Other heart disorders in other diseases classified elsewhere", "XNgbvAbUWrq"),
    ("ICD10", "I60", "I60 Subarachnoid haemorrhage", "R31SmHwnk4s"),
    ("ICD10", "I60.0", "I60.0 Subarachnoid haemorrhage from carotid siphon and bifurcation", "SoU4lsLZ7XC"),
    ("ICD10", "I60.1", "I60.1 Subarachnoid haemorrhage from middle cerebral artery", "ieC8MJicqkK"),
    ("ICD10", "I60.2", "I60.2 Subarachnoid haemorrhage from anterior communicating artery", "g7qCHexDiET"),
    ("ICD10", "I60.3", "I60.3 Subarachnoid haemorrhage from posterior communicating artery", "AGym6INFAbS"),
    ("ICD10", "I60.4", "I60.4 Subarachnoid haemorrhage from basilar artery", "YMcILlgTgkJ"),
    ("ICD10", "I60.5", "I60.5 Subarachnoid haemorrhage from vertebral artery", "WpqmNtx0mXz"),
    ("ICD10", "I60.6", "I60.6 Subarachnoid haemorrhage from other intracranial arteries", "b7aHGY0cP3X"),
    ("ICD10", "I60.7", "I60.7 Subarachnoid haemorrhage from intracranial artery, unspecified", "nrklWCrugud"),
    ("ICD10", "I60.8", "I60.8 Other subarachnoid haemorrhage", "cmlpmFROJBw"),
    ("ICD10", "I60.9", "I60.9 Subarachnoid haemorrhage, unspecified", "oV8SZpLZg3O"),
    ("ICD10", "I61", "I61 Intracerebral haemorrhage", "r5J4wA1m905"),
    ("ICD10", "I61.0", "I61.0 Intracerebral haemorrhage in hemisphere, subcortical", "Nnsk4Cl5Io8"),
    ("ICD10", "I61.1", "I61.1 Intracerebral haemorrhage in hemisphere, cortical", "IhRwhYEgPnG"),
    ("ICD10", "I61.2", "I61.2 Intracerebral haemorrhage in hemisphere, unspecified", "FA0pKkOkl9t"),
    ("ICD10", "I61.3", "I61.3 Intracerebral haemorrhage in brain stem", "uJCL3lMLqil"),
    ("ICD10", "I61.4", "I61.4 Intracerebral haemorrhage in cerebellum", "lQ1mLf3tM8h"),
    ("ICD10", "I61.5", "I61.5 Intracerebral haemorrhage, intraventricular", "aR0yg1IpbV9"),
    ("ICD10", "I61.6", "I61.6 Intracerebral haemorrhage, multiple localized", "tyLtDNjuqQO"),
    ("ICD10", "I61.8", "I61.8 Other intracerebral haemorrhage", "tuMXTOLw7tb"),
    ("ICD10", "I61.9", "I61.9 Intracerebral haemorrhage, unspecified", "oueJcpdmCAY"),
    ("ICD10", "I62", "I62 Other nontraumatic intracranial haemorrhage", "hJlUQp6Bvtr"),
    ("ICD10", "I62.0", "I62.0 Subdural haemorrhage (acute)(nontraumatic)", "ntB6e0U05LW"),
    ("ICD10", "I62.1", "I62.1 Nontraumatic extradural haemorrhage", "z9FVt1WqPab"),
    ("ICD10", "I62.9", "I62.9 Intracranial haemorrhage (nontraumatic), unspecified", "BmelNb87eC0"),
    ("ICD10", "I63", "I63 Cerebral infarction", "uLHwDvLMVW0"),
    ("ICD10", "I63.0", "I63.0 Cerebral infarction due to thrombosis of precerebral arteries", "FQhgOtScW2y"),
    ("ICD10", "I63.1", "I63.1 Cerebral infarction due to embolism of precerebral arteries", "LWFaAjfz1mq"),
    ("ICD10", "I63.2", "I63.2 Cerebral infarction due to unspecified occlusion or stenosis of precerebral arteries", "BcP6vdQrb9x"),
    ("ICD10", "I63.3", "I63.3 Cerebral infarction due to thrombosis of cerebral arteries", "JpQ3zFZtfkV"),
    ("ICD10", "I63.4", "I63.4 Cerebral infarction due to embolism of cerebral arteries", "IouRBc2QwFZ"),
    ("ICD10", "I63.5", "I63.5 Cerebral infarction due to unspecified occlusion or stenosis of cerebral arteries", "har2N8jzgIL"),
    ("ICD10", "I63.6", "I63.6 Cerebral infarction due to cerebral venous thrombosis, nonpyogenic", "Hr8Gh47FtM0"),
    ("ICD10", "I63.8", "I63.8 Other cerebral infarction", "yKA06ZpZuxA"),
    ("ICD10", "I63.9", "I63.9 Cerebral infarction, unspecified", "X0g5QJtZVeY"),
    ("ICD10", "I64", "I64 Stroke, not specified as haemorrhage or infarction", "vwm7JF7cWUs"),
    ("ICD10", "I65", "I65 Occlusion and stenosis of precerebral arteries, not resulting in cerebral infarction", "vD7AyfDzDEt"),
    ("ICD10", "I65.0", "I65.0 Occlusion and stenosis of vertebral artery", "URkRShfzEwS"),
    ("ICD10", "I65.1", "I65.1 Occlusion and stenosis of basilar artery", "oufEUmAkNTX"),
    ("ICD10", "I65.2", "I65.2 Occlusion and stenosis of carotid artery", "O18pRxj1PdC"),
    ("ICD10", "I65.3", "I65.3 Occlusion and stenosis of multiple and bilateral precerebral arteries", "o6TqodiBoz3"),
    ("ICD10", "I65.8", "I65.8 Occlusion and stenosis of other precerebral artery", "s4SlbddFPQ8"),
    ("ICD10", "I65.9", "I65.9 Occlusion and stenosis of unspecified precerebral artery", "QJNgzHOeqQy"),
    ("ICD10", "I66", "I66 Occlusion and stenosis of cerebral arteries, not resulting in cerebral infarction", "wfzDcJaYlCu"),
    ("ICD10", "I66.0", "I66.0 Occlusion and stenosis of middle cerebral artery", "hqLvfjvTxa1");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "I66.1", "I66.1 Occlusion and stenosis of anterior cerebral artery", "IDqXM1hVAtN"),
    ("ICD10", "I66.2", "I66.2 Occlusion and stenosis of posterior cerebral artery", "CGOaKL3Hqbm"),
    ("ICD10", "I66.3", "I66.3 Occlusion and stenosis of cerebellar arteries", "t36nnYLud3U"),
    ("ICD10", "I66.4", "I66.4 Occlusion and stenosis of multiple and bilateral cerebral arteries", "GNYr92wS8Sc"),
    ("ICD10", "I66.8", "I66.8 Occlusion and stenosis of other cerebral artery", "r0vz7EwE7Bm"),
    ("ICD10", "I66.9", "I66.9 Occlusion and stenosis of unspecified cerebral artery", "DJJqbbLKIDw"),
    ("ICD10", "I67", "I67 Other cerebrovascular diseases", "Iy4KvcOqq2G"),
    ("ICD10", "I67.0", "I67.0 Dissection of cerebral arteries, nonruptured", "CY7EYAqW8Aq"),
    ("ICD10", "I67.1", "I67.1 Cerebral aneurysm, nonruptured", "NaGRsKev4F3"),
    ("ICD10", "I67.2", "I67.2 Cerebral atherosclerosis", "hBLr8Nk1gLa"),
    ("ICD10", "I67.3", "I67.3 Progressive vascular leukoencephalopathy", "jiUTUJbIZgi"),
    ("ICD10", "I67.4", "I67.4 Hypertensive encephalopathy", "qYpcOib0X59"),
    ("ICD10", "I67.5", "I67.5 Moyamoya disease", "qOGMxepbevg"),
    ("ICD10", "I67.6", "I67.6 Nonpyogenic thrombosis of intracranial venous system", "MQDm59EcG0a"),
    ("ICD10", "I67.7", "I67.7 Cerebral arteritis, not elsewhere classified", "GkvJRDmuLg6"),
    ("ICD10", "I67.8", "I67.8 Other specified cerebrovascular diseases", "dg6Sf8dr7Dc"),
    ("ICD10", "I67.9", "I67.9 Cerebrovascular disease, unspecified", "n8qAVpftbW8"),
    ("ICD10", "I68", "I68 Cerebrovascular disorders in diseases classified elsewhere", "no3GBXwTIgA"),
    ("ICD10", "I68.0", "I68.0 Cerebral amyloid angiopathy", "nmfSO6j1UQc"),
    ("ICD10", "I68.1", "I68.1 Cerebral arteritis in infectious and parasitic diseases classified elsewhere", "gSNQ6764O8o"),
    ("ICD10", "I68.2", "I68.2 Cerebral arteritis in other diseases classified elsewhere", "kXOVNBrRb4k"),
    ("ICD10", "I68.8", "I68.8 Other cerebrovascular disorders in diseases classified elsewhere", "SX1ffI19J5o"),
    ("ICD10", "I69", "I69 Sequelae of cerebrovascular disease", "xW2ZVT9SyYS"),
    ("ICD10", "I69.0", "I69.0 Sequelae of subarachnoid haemorrhage", "n8bSvTR4Bj6"),
    ("ICD10", "I69.1", "I69.1 Sequelae of intracerebral haemorrhage", "RNMSa2cKdnf"),
    ("ICD10", "I69.2", "I69.2 Sequelae of other nontraumatic intracranial haemorrhage", "RMkoxLUziJc"),
    ("ICD10", "I69.3", "I69.3 Sequelae of cerebral infarction", "TKJcEsVhrLd"),
    ("ICD10", "I69.4", "I69.4 Sequelae of stroke, not specified as haemorrhage or infarction", "MYeR9Qj4MJr"),
    ("ICD10", "I69.8", "I69.8 Sequelae of other and unspecified cerebrovascular diseases", "hpyQHq1fk9G"),
    ("ICD10", "I70", "I70 Atherosclerosis", "vfIL1MN3zzR"),
    ("ICD10", "I70.0", "I70.0 Atherosclerosis of aorta", "jw7xwqmjH6M"),
    ("ICD10", "I70.1", "I70.1 Atherosclerosis of renal artery", "Nzhg6e8SgnG"),
    ("ICD10", "I70.2", "I70.2 Atherosclerosis of arteries of extremities", "Q4MLXoZcjUV"),
    ("ICD10", "I70.8", "I70.8 Atherosclerosis of other arteries", "KM5JtCFsgpI"),
    ("ICD10", "I70.9", "I70.9 Generalized and unspecified atherosclerosis", "gKXms0jvtSE"),
    ("ICD10", "I71", "I71 Aortic aneurysm and dissection", "anqmTRZYgCy"),
    ("ICD10", "I71.0", "I71.0 Dissection of aorta [any part]", "WIBI7Ts0sx4"),
    ("ICD10", "I71.1", "I71.1 Thoracic aortic aneurysm, ruptured", "utF4SGS3fYj"),
    ("ICD10", "I71.2", "I71.2 Thoracic aortic aneurysm, without mention of rupture", "P2mCU7TsFVW"),
    ("ICD10", "I71.3", "I71.3 Abdominal aortic aneurysm, ruptured", "U2vJY9tBegu"),
    ("ICD10", "I71.4", "I71.4 Abdominal aortic aneurysm, without mention of rupture", "TikFqbVDm2j"),
    ("ICD10", "I71.5", "I71.5 Thoracoabdominal aortic aneurysm, ruptured", "w26FC2x9vgY"),
    ("ICD10", "I71.6", "I71.6 Thoracoabdominal aortic aneurysm, without mention of rupture", "uYTjOLSYInb"),
    ("ICD10", "I71.8", "I71.8 Aortic aneurysm of unspecified site, ruptured", "V72OhurqsII"),
    ("ICD10", "I71.9", "I71.9 Aortic aneurysm of unspecified site, without mention of rupture", "icsc3hk2e2n"),
    ("ICD10", "I72", "I72 Other aneurysm and dissection", "PglZzRIdno3"),
    ("ICD10", "I72.0", "I72.0 Aneurysm and dissection of carotid artery", "xY0gF9qExOe"),
    ("ICD10", "I72.1", "I72.1 Aneurysm and dissection of artery of upper extremity", "xK50UK2ZIPq"),
    ("ICD10", "I72.2", "I72.2 Aneurysm and dissection of renal artery", "tV1v0qasSQ9"),
    ("ICD10", "I72.3", "I72.3 Aneurysm and dissection of iliac artery", "CsUj6RTSMwA"),
    ("ICD10", "I72.4", "I72.4 Aneurysm and dissection of artery of lower extremity", "W5M1A1qnPc8"),
    ("ICD10", "I72.5", "I72.5 Aneurysm and dissection of other precerebral arteries", "aZpbUjV21TT"),
    ("ICD10", "I72.6", "I72.6 Aneurysm and dissection of vertebral artery", "opUBsKTMaJV"),
    ("ICD10", "I72.8", "I72.8 Aneurysm and dissection of other specified arteries", "r5M2XrM68sz"),
    ("ICD10", "I72.9", "I72.9 Aneurysm and dissection of unspecified site", "Yq0v4sCg6wz"),
    ("ICD10", "I73", "I73 Other peripheral vascular diseases", "yAGY7kbhnCo"),
    ("ICD10", "I73.0", "I73.0 Raynaud syndrome", "toOR0k0tfKz"),
    ("ICD10", "I73.1", "I73.1 Thromboangiitis obliterans [Buerger]", "Q5NfYGRcW3A"),
    ("ICD10", "I73.8", "I73.8 Other specified peripheral vascular diseases", "YSgvcQwCFWI"),
    ("ICD10", "I73.9", "I73.9 Peripheral vascular disease, unspecified", "zkBfHodnJVS"),
    ("ICD10", "I74", "I74 Arterial embolism and thrombosis", "IlZr8MinPjD"),
    ("ICD10", "I74.0", "I74.0 Embolism and thrombosis of abdominal aorta", "IwnYMmh6o0I"),
    ("ICD10", "I74.1", "I74.1 Embolism and thrombosis of other and unspecified parts of aorta", "sH8uN5zXlL1"),
    ("ICD10", "I74.2", "I74.2 Embolism and thrombosis of arteries of upper extremities", "lgNmqJDgU1C"),
    ("ICD10", "I74.3", "I74.3 Embolism and thrombosis of arteries of lower extremities", "rn2aSxq9I7q"),
    ("ICD10", "I74.4", "I74.4 Embolism and thrombosis of arteries of extremities, unspecified", "os85SlrTPnV"),
    ("ICD10", "I74.5", "I74.5 Embolism and thrombosis of iliac artery", "eQ2NTSFHcQC"),
    ("ICD10", "I74.8", "I74.8 Embolism and thrombosis of other arteries", "Cn7ET2lUczn"),
    ("ICD10", "I74.9", "I74.9 Embolism and thrombosis of unspecified artery", "FSEIZxY7bQ8"),
    ("ICD10", "I77", "I77 Other disorders of arteries and arterioles", "tdNUeHUxI1J"),
    ("ICD10", "I77.0", "I77.0 Arteriovenous fistula, acquired", "MtsElnXBgzH"),
    ("ICD10", "I77.1", "I77.1 Stricture of artery", "A4Qsp6l3wuM"),
    ("ICD10", "I77.2", "I77.2 Rupture of artery", "jzvNStRHxL6"),
    ("ICD10", "I77.3", "I77.3 Arterial fibromuscular dysplasia", "CkhanOxmATw"),
    ("ICD10", "I77.4", "I77.4 Coeliac artery compression syndrome", "Eu4lnmV1W9W"),
    ("ICD10", "I77.5", "I77.5 Necrosis of artery", "mqaf8zpaf5d"),
    ("ICD10", "I77.6", "I77.6 Arteritis, unspecified", "oIlbn3EUh4n"),
    ("ICD10", "I77.8", "I77.8 Other specified disorders of arteries and arterioles", "ZOSHE7J1K52"),
    ("ICD10", "I77.9", "I77.9 Disorder of arteries and arterioles, unspecified", "gPB1h9JM1Iz"),
    ("ICD10", "I78", "I78 Diseases of capillaries", "M2Wv0rnxNIE"),
    ("ICD10", "I78.0", "I78.0 Hereditary haemorrhagic telangiectasia", "hA1oZUetw4Z"),
    ("ICD10", "I78.1", "I78.1 Naevus, non-neoplastic", "FLqnsHQc5MP"),
    ("ICD10", "I78.8", "I78.8 Other diseases of capillaries", "JgO7LtkUpFb"),
    ("ICD10", "I78.9", "I78.9 Disease of capillaries, unspecified", "ps28wOg6TE0"),
    ("ICD10", "I79", "I79 Disorders of arteries, arterioles and capillaries in diseases classified elsewhere", "EK3jbVJn6oo"),
    ("ICD10", "I79.0", "I79.0 Aneurysm of aorta in diseases classified elsewhere", "XcfJSK4Rjmv"),
    ("ICD10", "I79.1", "I79.1 Aortitis in diseases classified elsewhere", "KAshv1PkVVN"),
    ("ICD10", "I79.2", "I79.2 Peripheral angiopathy in diseases classified elsewhere", "pwMwNfwYXxS"),
    ("ICD10", "I79.8", "I79.8 Other disorders of arteries, arterioles and capillaries in diseases classified elsewhere", "cRqCXKjtNdW"),
    ("ICD10", "I80", "I80 Phlebitis and thrombophlebitis", "VRpfp3KKpzq"),
    ("ICD10", "I80.0", "I80.0 Phlebitis and thrombophlebitis of superficial vessels of lower extremities", "Z6WHAISkH0j"),
    ("ICD10", "I80.1", "I80.1 Phlebitis and thrombophlebitis of femoral vein", "YJNHiW47K5r"),
    ("ICD10", "I80.2", "I80.2 Phlebitis and thrombophlebitis of other deep vessels of lower extremities", "frNJ3JxE1vH"),
    ("ICD10", "I80.3", "I80.3 Phlebitis and thrombophlebitis of lower extremities, unspecified", "FoAEgeNvdPs"),
    ("ICD10", "I80.8", "I80.8 Phlebitis and thrombophlebitis of other sites", "W8cS9nq2LPY"),
    ("ICD10", "I80.9", "I80.9 Phlebitis and thrombophlebitis of unspecified site", "LNZ0VOf1Ilc"),
    ("ICD10", "I81", "I81 Portal vein thrombosis", "Szl51E0emWC"),
    ("ICD10", "I82", "I82 Other venous embolism and thrombosis", "Gf2mx2TN0aY"),
    ("ICD10", "I82.0", "I82.0 Budd-Chiari syndrome", "MPzjr5UmBm3"),
    ("ICD10", "I82.1", "I82.1 Thrombophlebitis migrans", "x9ResizYaEB"),
    ("ICD10", "I82.2", "I82.2 Embolism and thrombosis of vena cava", "Dy4uHOi7MeF"),
    ("ICD10", "I82.3", "I82.3 Embolism and thrombosis of renal vein", "ULxP0o7Ium8"),
    ("ICD10", "I82.8", "I82.8 Embolism and thrombosis of other specified veins", "sl2eI5VF8Bh"),
    ("ICD10", "I82.9", "I82.9 Embolism and thrombosis of unspecified vein", "YlzghaXaWbW"),
    ("ICD10", "I83", "I83 Varicose veins of lower extremities", "PfZ7oYmuyZN"),
    ("ICD10", "I83.0", "I83.0 Varicose veins of lower extremities with ulcer", "JPrlyB0thmp"),
    ("ICD10", "I83.1", "I83.1 Varicose veins of lower extremities with inflammation", "tfLOK6vZcr0"),
    ("ICD10", "I83.2", "I83.2 Varicose veins of lower extremities with both ulcer and inflammation", "RA08UVBHaru"),
    ("ICD10", "I83.9", "I83.9 Varicose veins of lower extremities without ulcer or inflammation", "eQUN5GGepkL"),
    ("ICD10", "I85", "I85 Oesophageal varices", "C07dX0PePf6"),
    ("ICD10", "I85.0", "I85.0 Oesophageal varices with bleeding", "k1StRJqaAAt"),
    ("ICD10", "I85.9", "I85.9 Oesophageal varices without bleeding", "hPPW1uzeHCP"),
    ("ICD10", "I86", "I86 Varicose veins of other sites", "vznTuvRJ5o6"),
    ("ICD10", "I86.0", "I86.0 Sublingual varices", "BxY6HcFGUWX"),
    ("ICD10", "I86.1", "I86.1 Scrotal varices", "k1cuF7OaBpG"),
    ("ICD10", "I86.2", "I86.2 Pelvic varices", "pzfx51WHIla"),
    ("ICD10", "I86.3", "I86.3 Vulval varices", "fe3yKpCiCEZ"),
    ("ICD10", "I86.4", "I86.4 Gastric varices", "zXWRSGEpjAI"),
    ("ICD10", "I86.8", "I86.8 Varicose veins of other specified sites", "aboanzYznbc"),
    ("ICD10", "I87", "I87 Other disorders of veins", "gdLht6SoY7P"),
    ("ICD10", "I87.0", "I87.0 Postthrombotic syndrome", "a8qWT9M11BM"),
    ("ICD10", "I87.1", "I87.1 Compression of vein", "EhV7skjzehO"),
    ("ICD10", "I87.2", "I87.2 Venous insufficiency (chronic)(peripheral)", "JbtyVzqq3HW"),
    ("ICD10", "I87.8", "I87.8 Other specified disorders of veins", "lKO67Z5npSv"),
    ("ICD10", "I87.9", "I87.9 Disorder of vein, unspecified", "TNI4ttpRohc"),
    ("ICD10", "I88", "I88 Nonspecific lymphadenitis", "qZgfFhn0EGF"),
    ("ICD10", "I88.0", "I88.0 Nonspecific mesenteric lymphadenitis", "EjZXWfuRLhU"),
    ("ICD10", "I88.1", "I88.1 Chronic lymphadenitis, except mesenteric", "ZSFrC6NVEKR"),
    ("ICD10", "I88.8", "I88.8 Other nonspecific lymphadenitis", "e59DmqqyZga"),
    ("ICD10", "I88.9", "I88.9 Nonspecific lymphadenitis, unspecified", "mZXI0cMlSKV"),
    ("ICD10", "I89", "I89 Other noninfective disorders of lymphatic vessels and lymph nodes", "yxCVzDaVVaC"),
    ("ICD10", "I89.0", "I89.0 Lymphoedema, not elsewhere classified", "al3I5llJpGr"),
    ("ICD10", "I89.1", "I89.1 Lymphangitis", "TnEOtZBQlYT"),
    ("ICD10", "I89.8", "I89.8 Other specified noninfective disorders of lymphatic vessels and lymph nodes", "XWfQ50Yid1D"),
    ("ICD10", "I89.9", "I89.9 Noninfective disorder of lymphatic vessels and lymph nodes, unspecified", "YW63cv49iBa"),
    ("ICD10", "I95", "I95 Hypotension", "cFMYzeRs39Z"),
    ("ICD10", "I95.0", "I95.0 Idiopathic hypotension", "rojWlruyMQl"),
    ("ICD10", "I95.1", "I95.1 Orthostatic hypotension", "sIT1hjgCoJD"),
    ("ICD10", "I95.2", "I95.2 Hypotension due to drugs", "ULOA2cEHUJh"),
    ("ICD10", "I95.8", "I95.8 Other hypotension", "XjyBEMej1m4"),
    ("ICD10", "I95.9", "I95.9 Hypotension, unspecified", "tgXPUkpGwtG"),
    ("ICD10", "I97", "I97 Postprocedural disorders of circulatory system, not elsewhere classified", "eesB9CsBRnH"),
    ("ICD10", "I97.0", "I97.0 Postcardiotomy syndrome", "L2p28YggFtL"),
    ("ICD10", "I97.1", "I97.1 Other functional disturbances following cardiac surgery", "wDIOHdvQbsd"),
    ("ICD10", "I97.2", "I97.2 Postmastectomy lymphoedema syndrome", "t5vQ69xkOPX"),
    ("ICD10", "I97.8", "I97.8 Other postprocedural disorders of circulatory system, not elsewhere classified", "g6YMEeGVAET"),
    ("ICD10", "I97.9", "I97.9 Postprocedural disorder of circulatory system, unspecified", "p9Lbw8nd1lU"),
    ("ICD10", "I98", "I98 Other disorders of circulatory system in diseases classified elsewhere", "yJU7pt9YLa4"),
    ("ICD10", "I98.0", "I98.0 Cardiovascular syphilis", "bSforFTXAmb"),
    ("ICD10", "I98.1", "I98.1 Cardiovascular disorders in other infectious and parasitic diseases classified elsewhere", "hBPKqOvdUzx"),
    ("ICD10", "I98.2", "I98.2 Oesophageal varices without bleeding in diseases classified elsewhere", "PcUZWnAS4bE"),
    ("ICD10", "I98.3", "I98.3 Oesophageal varices with bleeding in diseases classified elsewhere", "uij5YkLZ0Wa"),
    ("ICD10", "I98.8", "I98.8 Other specified disorders of circulatory system in diseases classified elsewhere", "uvK33TqQoW8"),
    ("ICD10", "I99", "I99 Other and unspecified disorders of circulatory system", "m7AKx4FWitr");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "J00", "J00 Acute nasopharyngitis [common cold]", "OjijHDExgAJ"),
    ("ICD10", "J01", "J01 Acute sinusitis", "Tx7QCeeVlZo"),
    ("ICD10", "J01.0", "J01.0 Acute maxillary sinusitis", "rs227iLfUWu"),
    ("ICD10", "J01.1", "J01.1 Acute frontal sinusitis", "GqhaLwIUGBu"),
    ("ICD10", "J01.2", "J01.2 Acute ethmoidal sinusitis", "XnNWZVNZ2gW"),
    ("ICD10", "J01.3", "J01.3 Acute sphenoidal sinusitis", "d4BqgU8Sbjw"),
    ("ICD10", "J01.4", "J01.4 Acute pansinusitis", "BjfSLQF8QW3"),
    ("ICD10", "J01.8", "J01.8 Other acute sinusitis", "TX3i3suQMbL"),
    ("ICD10", "J01.9", "J01.9 Acute sinusitis, unspecified", "CNtJIYAFKFf"),
    ("ICD10", "J02", "J02 Acute pharyngitis", "jwpeqQrDbaJ"),
    ("ICD10", "J02.0", "J02.0 Streptococcal pharyngitis", "AsgJ5PQu4bb"),
    ("ICD10", "J02.8", "J02.8 Acute pharyngitis due to other specified organisms", "TIPlbPMFukA"),
    ("ICD10", "J02.9", "J02.9 Acute pharyngitis, unspecified", "YBRdnkJdzkq"),
    ("ICD10", "J03", "J03 Acute tonsillitis", "bvW4uvVWnYh"),
    ("ICD10", "J03.0", "J03.0 Streptococcal tonsillitis", "izOVImjk3d5"),
    ("ICD10", "J03.8", "J03.8 Acute tonsillitis due to other specified organisms", "LKcvTk7gI8v"),
    ("ICD10", "J03.9", "J03.9 Acute tonsillitis, unspecified", "cccjrELCXPY"),
    ("ICD10", "J04", "J04 Acute laryngitis and tracheitis", "F6h8QEORoWt"),
    ("ICD10", "J04.0", "J04.0 Acute laryngitis", "dMZb6OefgS3"),
    ("ICD10", "J04.1", "J04.1 Acute tracheitis", "AatZ3clkNs7"),
    ("ICD10", "J04.2", "J04.2 Acute laryngotracheitis", "Hz7v6uyMvOT"),
    ("ICD10", "J05", "J05 Acute obstructive laryngitis [croup] and epiglottitis", "mp2v7SgcE6P"),
    ("ICD10", "J05.0", "J05.0 Acute obstructive laryngitis [croup]", "YPJYY5DYbTh"),
    ("ICD10", "J05.1", "J05.1 Acute epiglottitis", "tOBOv6Gxsmv"),
    ("ICD10", "J06", "J06 Acute upper respiratory infections of multiple and unspecified sites", "jvzwBE8RPl9"),
    ("ICD10", "J06.0", "J06.0 Acute laryngopharyngitis", "EysWVqeqyRo"),
    ("ICD10", "J06.8", "J06.8 Other acute upper respiratory infections of multiple sites", "Nqtuh8ES0Q7"),
    ("ICD10", "J06.9", "J06.9 Acute upper respiratory infection, unspecified", "rIP2QdUsWqf"),
    ("ICD10", "J09", "J09 Influenza due to identified zoonotic or pandemic influenza virus", "QadDOe355Uv"),
    ("ICD10", "J10", "J10 influenza due to identified seasonal influenza virus", "vaRL8eqnUZA"),
    ("ICD10", "J10.0", "J10.0 Influenza with pneumonia, seasonal influenza virus identified", "ipexGdgVVQw"),
    ("ICD10", "J10.1", "J10.1 Influenza with other respiratory manifestations, seasonal influenza virus identified", "nFJffUtFWqX"),
    ("ICD10", "J10.8", "J10.8 Influenza with other manifestations, seasonal influenza virus identified", "Amn5OXeTLTP"),
    ("ICD10", "J11", "J11 Influenza, virus not identified", "NBfMNptsmeJ"),
    ("ICD10", "J11.0", "J11.0 Influenza with pneumonia, virus not identified", "wjHNWeojTcg"),
    ("ICD10", "J11.1", "J11.1 Influenza with other respiratory manifestations, virus not identified", "ezzMSrGOcTL"),
    ("ICD10", "J11.8", "J11.8 Influenza with other manifestations, virus not identified", "EnHTJZMKOxE"),
    ("ICD10", "J12", "J12 Viral pneumonia, not elsewhere classified", "Rokk2J8IDlr"),
    ("ICD10", "J12.0", "J12.0 Adenoviral pneumonia", "GGVk19Teqot"),
    ("ICD10", "J12.1", "J12.1 Respiratory syncytial virus pneumonia", "zvvVpFRI6o6"),
    ("ICD10", "J12.2", "J12.2 Parainfluenza virus pneumonia", "W3DLXB823OG"),
    ("ICD10", "J12.3", "J12.3 Human metapneumovirus pneumonia", "C3XcF9WivDU"),
    ("ICD10", "J12.8", "J12.8 Other viral pneumonia", "KpIlGPtC98a"),
    ("ICD10", "J12.9", "J12.9 Viral pneumonia, unspecified", "W3lF1tLmRWo"),
    ("ICD10", "J13", "J13 Pneumonia due to Streptococcus pneumoniae", "rVYjs36LvO8"),
    ("ICD10", "J14", "J14 Pneumonia due to Haemophilus influenzae", "z6zodzMuqhO"),
    ("ICD10", "J15", "J15 Bacterial pneumonia, not elsewhere classified", "AsBZ0WiEB3r"),
    ("ICD10", "J15.0", "J15.0 Pneumonia due to Klebsiella pneumoniae", "N0paiX9rOeF"),
    ("ICD10", "J15.1", "J15.1 Pneumonia due to Pseudomonas", "uMfE7cT0pEC"),
    ("ICD10", "J15.2", "J15.2 Pneumonia due to staphylococcus", "WZAM7alVLFK"),
    ("ICD10", "J15.3", "J15.3 Pneumonia due to streptococcus, group B", "AHNyqe40Vct"),
    ("ICD10", "J15.4", "J15.4 Pneumonia due to other streptococci", "wTu08zuZtxk"),
    ("ICD10", "J15.5", "J15.5 Pneumonia due to Escherichia coli", "R0BuriMTyBI"),
    ("ICD10", "J15.6", "J15.6 Pneumonia due to other Gram-negative bacteria", "jeUWu3JJsXR"),
    ("ICD10", "J15.7", "J15.7 Pneumonia due to Mycoplasma pneumoniae", "HMrwX8pfejA"),
    ("ICD10", "J15.8", "J15.8 Other bacterial pneumonia", "oFukOJUqpR9"),
    ("ICD10", "J15.9", "J15.9 Bacterial pneumonia, unspecified", "eTMm4fcGmyR"),
    ("ICD10", "J16", "J16 Pneumonia due to other infectious organisms, not elsewhere classified", "SJt7f8dfXeC"),
    ("ICD10", "J16.0", "J16.0 Chlamydial pneumonia", "CL9dOCYPCr9"),
    ("ICD10", "J16.8", "J16.8 Pneumonia due to other specified infectious organisms", "ZNMQJsdC985"),
    ("ICD10", "J17", "J17 Pneumonia in diseases classified elsewhere", "GSNjS7Rfa3M"),
    ("ICD10", "J17.0", "J17.0 Pneumonia in bacterial diseases classified elsewhere", "Hcxa6SPyD5V"),
    ("ICD10", "J17.1", "J17.1 Pneumonia in viral diseases classified elsewhere", "k7LYVAbESXg"),
    ("ICD10", "J17.2", "J17.2 Pneumonia in mycoses", "vJgQ7JWiZoA"),
    ("ICD10", "J17.3", "J17.3 Pneumonia in parasitic diseases", "aIr23RO5ygd"),
    ("ICD10", "J17.8", "J17.8 Pneumonia in other diseases classified elsewhere", "tx1PSUdssnE"),
    ("ICD10", "J18", "J18 Pneumonia, organism unspecified", "p0iPvstIg11"),
    ("ICD10", "J18.0", "J18.0 Bronchopneumonia, unspecified", "ngPTBr1qDdk"),
    ("ICD10", "J18.1", "J18.1 Lobar pneumonia, unspecified", "d8qzoCzY8Wq"),
    ("ICD10", "J18.2", "J18.2 Hypostatic pneumonia, unspecified", "WudmFK2VAh0"),
    ("ICD10", "J18.8", "J18.8 Other pneumonia, organism unspecified", "RwLiVMCyZgz"),
    ("ICD10", "J18.9", "J18.9 Pneumonia, unspecified", "QcblzlLUdNl"),
    ("ICD10", "J20", "J20 Acute bronchitis", "m9Q0rSjhLBJ"),
    ("ICD10", "J20.0", "J20.0 Acute bronchitis due to Mycoplasma pneumoniae", "N4vgpNsXW4L"),
    ("ICD10", "J20.1", "J20.1 Acute bronchitis due to Haemophilus influenzae", "pUR9QtVWUl7"),
    ("ICD10", "J20.2", "J20.2 Acute bronchitis due to streptococcus", "VK6CYaXJYWl"),
    ("ICD10", "J20.3", "J20.3 Acute bronchitis due to coxsackievirus", "m52MTWBtjNB"),
    ("ICD10", "J20.4", "J20.4 Acute bronchitis due to parainfluenza virus", "KMwtJo7UHvo"),
    ("ICD10", "J20.5", "J20.5 Acute bronchitis due to respiratory syncytial virus", "b7hu9fU7Wny"),
    ("ICD10", "J20.6", "J20.6 Acute bronchitis due to rhinovirus", "nEtS80IVKbf"),
    ("ICD10", "J20.7", "J20.7 Acute bronchitis due to echovirus", "UtaByIb31la"),
    ("ICD10", "J20.8", "J20.8 Acute bronchitis due to other specified organisms", "B2v6vqMftVt"),
    ("ICD10", "J20.9", "J20.9 Acute bronchitis, unspecified", "P5p4lXKm5D6"),
    ("ICD10", "J21", "J21 Acute bronchiolitis", "kzEWTRNwwPM"),
    ("ICD10", "J21.0", "J21.0 Acute bronchiolitis due to respiratory syncytial virus", "ddA89JS3dJ4"),
    ("ICD10", "J21.1", "J21.1 Acute bronchiolitis due to human metapneumovirus", "L4B5shiwwO5"),
    ("ICD10", "J21.8", "J21.8 Acute bronchiolitis due to other specified organisms", "bGuOgGaWSSg"),
    ("ICD10", "J21.9", "J21.9 Acute bronchiolitis, unspecified", "M8fQuf3JAgp"),
    ("ICD10", "J22", "J22 Unspecified acute lower respiratory infection", "JASMyXpwLEI"),
    ("ICD10", "J30", "J30 Vasomotor and allergic rhinitis", "pfCsOHdfv0C"),
    ("ICD10", "J30.0", "J30.0 Vasomotor rhinitis", "IttjtukilyN"),
    ("ICD10", "J30.1", "J30.1 Allergic rhinitis due to pollen", "KOOWtJBBBMD"),
    ("ICD10", "J30.2", "J30.2 Other seasonal allergic rhinitis", "VTWQ1HVL5z1"),
    ("ICD10", "J30.3", "J30.3 Other allergic rhinitis", "dWTJ4vnsGbU"),
    ("ICD10", "J30.4", "J30.4 Allergic rhinitis, unspecified", "Vvxe6ni3WQf"),
    ("ICD10", "J31", "J31 Chronic rhinitis, nasopharyngitis and pharyngitis", "e9CNi73MTH2"),
    ("ICD10", "J31.0", "J31.0 Chronic rhinitis", "hzUx54H61jf"),
    ("ICD10", "J31.1", "J31.1 Chronic nasopharyngitis", "NNXO2ehgzTh"),
    ("ICD10", "J31.2", "J31.2 Chronic pharyngitis", "X7oRDJgGjXn"),
    ("ICD10", "J32", "J32 Chronic sinusitis", "t1SbjQhbmly"),
    ("ICD10", "J32.0", "J32.0 Chronic maxillary sinusitis", "xWIWFpyZYU6"),
    ("ICD10", "J32.1", "J32.1 Chronic frontal sinusitis", "bWL7Jwg0f9Q"),
    ("ICD10", "J32.2", "J32.2 Chronic ethmoidal sinusitis", "zjRgsNIv6Hg"),
    ("ICD10", "J32.3", "J32.3 Chronic sphenoidal sinusitis", "W5JTITSi5eK"),
    ("ICD10", "J32.4", "J32.4 Chronic pansinusitis", "QcxBX1dHFdH"),
    ("ICD10", "J32.8", "J32.8 Other chronic sinusitis", "fg8lleoPCD2"),
    ("ICD10", "J32.9", "J32.9 Chronic sinusitis, unspecified", "RDYEofmEe5o"),
    ("ICD10", "J33", "J33 Nasal polyp", "ZSFMuGtmsa2"),
    ("ICD10", "J33.0", "J33.0 Polyp of nasal cavity", "upwtazyEawr"),
    ("ICD10", "J33.1", "J33.1 Polypoid sinus degeneration", "IgaS8zjf2Qg"),
    ("ICD10", "J33.8", "J33.8 Other polyp of sinus", "IMWTM0LDwiL"),
    ("ICD10", "J33.9", "J33.9 Nasal polyp, unspecified", "LqvDppJfBV0"),
    ("ICD10", "J34", "J34 Other disorders of nose and nasal sinuses", "x60FCNUYGUC"),
    ("ICD10", "J34.0", "J34.0 Abscess, furuncle and carbuncle of nose", "FObSKAPmGUd"),
    ("ICD10", "J34.1", "J34.1 Cyst and mucocele of nose and nasal sinus", "n8H25BxfzGk"),
    ("ICD10", "J34.2", "J34.2 Deviated nasal septum", "EVy3t0ZngEW"),
    ("ICD10", "J34.3", "J34.3 Hypertrophy of nasal turbinates", "NudERPN4d3M"),
    ("ICD10", "J34.8", "J34.8 Other specified disorders of nose and nasal sinuses", "hIkaPYXtfoP"),
    ("ICD10", "J35", "J35 Chronic diseases of tonsils and adenoids", "KItr1fvIY7N"),
    ("ICD10", "J35.0", "J35.0 Chronic tonsillitis", "jDxUdV6wuwL"),
    ("ICD10", "J35.1", "J35.1 Hypertrophy of tonsils", "GTxWaVbmXFv"),
    ("ICD10", "J35.2", "J35.2 Hypertrophy of adenoids", "GDLReOmWBkL"),
    ("ICD10", "J35.3", "J35.3 Hypertrophy of tonsils with hypertrophy of adenoids", "CxeZtTcb3SS"),
    ("ICD10", "J35.8", "J35.8 Other chronic diseases of tonsils and adenoids", "OPwWVIRV4gA"),
    ("ICD10", "J35.9", "J35.9 Chronic disease of tonsils and adenoids, unspecified", "pdyTnQLxzPr"),
    ("ICD10", "J36", "J36 Peritonsillar abscess", "D5YMWeR7bjq"),
    ("ICD10", "J37", "J37 Chronic laryngitis and laryngotracheitis", "FunpJJq7HCT"),
    ("ICD10", "J37.0", "J37.0 Chronic laryngitis", "JynSgTZBcIv"),
    ("ICD10", "J37.1", "J37.1 Chronic laryngotracheitis", "icPHEGLhuZ9"),
    ("ICD10", "J38", "J38 Diseases of vocal cords and larynx, not elsewhere classified", "VB9mnJwJXdH"),
    ("ICD10", "J38.0", "J38.0 Paralysis of vocal cords and larynx", "DYHXlhelKoX"),
    ("ICD10", "J38.1", "J38.1 Polyp of vocal cord and larynx", "arh6lBhaU22"),
    ("ICD10", "J38.2", "J38.2 Nodules of vocal cords", "dwbIA4TdklU"),
    ("ICD10", "J38.3", "J38.3 Other diseases of vocal cords", "IRi2p63qeEr"),
    ("ICD10", "J38.4", "J38.4 Oedema of larynx", "qg5U33NpUKB"),
    ("ICD10", "J38.5", "J38.5 Laryngeal spasm", "tYcp3seCpb0"),
    ("ICD10", "J38.6", "J38.6 Stenosis of larynx", "pGKSAjAkKww"),
    ("ICD10", "J38.7", "J38.7 Other diseases of larynx", "i60vO416o0b"),
    ("ICD10", "J39", "J39 Other diseases of upper respiratory tract", "KCrnCzLXDVf"),
    ("ICD10", "J39.0", "J39.0 Retropharyngeal and parapharyngeal abscess", "MFdWtfKiMES"),
    ("ICD10", "J39.1", "J39.1 Other abscess of pharynx", "ugm2XoT9nRk"),
    ("ICD10", "J39.2", "J39.2 Other diseases of pharynx", "pLLbzxhsuRc"),
    ("ICD10", "J39.3", "J39.3 Upper respiratory tract hypersensitivity reaction, site unspecified", "mcSz2wHS7I0"),
    ("ICD10", "J39.8", "J39.8 Other specified diseases of upper respiratory tract", "t3cpsunGo6J"),
    ("ICD10", "J39.9", "J39.9 Disease of upper respiratory tract, unspecified", "gUzfKHwfhpY"),
    ("ICD10", "J40", "J40 Bronchitis, not specified as acute or chronic", "ztiLDSgp8kV"),
    ("ICD10", "J41", "J41 Simple and mucopurulent chronic bronchitis", "rlGJgaRWLLb"),
    ("ICD10", "J41.0", "J41.0 Simple chronic bronchitis", "gDSzrbpYj6c"),
    ("ICD10", "J41.1", "J41.1 Mucopurulent chronic bronchitis", "skzLV97KSnh"),
    ("ICD10", "J41.8", "J41.8 Mixed simple and mucopurulent chronic bronchitis", "kuiVSYZWzEO"),
    ("ICD10", "J42", "J42 Unspecified chronic bronchitis", "rE8ED8LikmL"),
    ("ICD10", "J43", "J43 Emphysema", "l6ZsGYNZuE2"),
    ("ICD10", "J43.0", "J43.0 MacLeod syndrome", "mDfRGTeD1nR"),
    ("ICD10", "J43.1", "J43.1 Panlobular emphysema", "lIP7TaYNGZY"),
    ("ICD10", "J43.2", "J43.2 Centrilobular emphysema", "VGuruB8wuAw"),
    ("ICD10", "J43.8", "J43.8 Other emphysema", "uFrDSipAUEI"),
    ("ICD10", "J43.9", "J43.9 Emphysema, unspecified", "I7VRuMwJ8Cj"),
    ("ICD10", "J44", "J44 Other chronic obstructive pulmonary disease", "jrn31FTfmr5"),
    ("ICD10", "J44.0", "J44.0 Chronic obstructive pulmonary disease with acute lower respiratory infection", "oMfyoVv2YMD"),
    ("ICD10", "J44.1", "J44.1 Chronic obstructive pulmonary disease with acute exacerbation, unspecified", "VWHzFph9WXR"),
    ("ICD10", "J44.8", "J44.8 Other specified chronic obstructive pulmonary disease", "U93ozgFFMMR"),
    ("ICD10", "J44.9", "J44.9 Chronic obstructive pulmonary disease, unspecified", "Yc4fFK9hXEN"),
    ("ICD10", "J45", "J45 Asthma", "GNO3wjQrD8Y"),
    ("ICD10", "J45.0", "J45.0 Predominantly allergic asthma", "CpuWPzKZvCn"),
    ("ICD10", "J45.1", "J45.1 Nonallergic asthma", "Azts62Tiqpt"),
    ("ICD10", "J45.8", "J45.8 Mixed asthma", "dTLtniyRsm7"),
    ("ICD10", "J45.9", "J45.9 Asthma, unspecified", "CgtnlvyIS1K"),
    ("ICD10", "J46", "J46 Status asthmaticus", "CLFlm513rnK"),
    ("ICD10", "J47", "J47 Bronchiectasis", "avMFcTGEMSG"),
    ("ICD10", "J60", "J60 Coalworker pneumoconiosis", "rvOO3io7Ak7"),
    ("ICD10", "J61", "J61 Pneumoconiosis due to asbestos and other mineral fibres", "huXaVwA0TKd"),
    ("ICD10", "J62", "J62 Pneumoconiosis due to dust containing silica", "EWCBFXIqkcW"),
    ("ICD10", "J62.0", "J62.0 Pneumoconiosis due to talc dust", "VAAvMc9rYXS"),
    ("ICD10", "J62.8", "J62.8 Pneumoconiosis due to other dust containing silica", "cmlGdMP2k6F"),
    ("ICD10", "J63", "J63 Pneumoconiosis due to other inorganic dusts", "nE9mJ5g0V9W"),
    ("ICD10", "J63.0", "J63.0 Aluminosis (of lung)", "MEtPtfXKFS5"),
    ("ICD10", "J63.1", "J63.1 Bauxite fibrosis (of lung)", "dziA0TnDUSF"),
    ("ICD10", "J63.2", "J63.2 Berylliosis", "WAI1t93SUNu"),
    ("ICD10", "J63.3", "J63.3 Graphite fibrosis (of lung)", "g0ixMNfsrOH"),
    ("ICD10", "J63.4", "J63.4 Siderosis", "tGMrDY2eOrm"),
    ("ICD10", "J63.5", "J63.5 Stannosis", "gsZ8BblkL2H"),
    ("ICD10", "J63.8", "J63.8 Pneumoconiosis due to other specified inorganic dusts", "UqWFwJWWpgI"),
    ("ICD10", "J64", "J64 Unspecified pneumoconiosis", "LX63xpIBLpi"),
    ("ICD10", "J65", "J65 Pneumoconiosis associated with tuberculosis", "K4raJTnthZH"),
    ("ICD10", "J66", "J66 Airway disease due to specific organic dust", "fuvbzAiniQR"),
    ("ICD10", "J66.0", "J66.0 Byssinosis", "VTOhMAXTZPY"),
    ("ICD10", "J66.1", "J66.1 Flax-dresser disease", "Q3vz76QwK66"),
    ("ICD10", "J66.2", "J66.2 Cannabinosis", "Bocqj3MD2X3"),
    ("ICD10", "J66.8", "J66.8 Airway disease due to other specific organic dusts", "ogTVJtE4McB"),
    ("ICD10", "J67", "J67 Hypersensitivity pneumonitis due to organic dust", "jGpr5SIYGCG"),
    ("ICD10", "J67.0", "J67.0 Farmer lung", "WFPmwy0cEBP"),
    ("ICD10", "J67.1", "J67.1 Bagassosis", "BHWygQnstzO"),
    ("ICD10", "J67.2", "J67.2 Bird fancier lung", "yrnNBHmwjng"),
    ("ICD10", "J67.3", "J67.3 Suberosis", "nm4rLUkcRJL"),
    ("ICD10", "J67.4", "J67.4 Maltworker lung", "wMJfWlfLjds"),
    ("ICD10", "J67.5", "J67.5 Mushroom-worker lung", "cTZ4dhcAool"),
    ("ICD10", "J67.6", "J67.6 Maple-bark-stripper lung", "aNQyO3DDYlb"),
    ("ICD10", "J67.7", "J67.7 Air-conditioner and humidifier lung", "IxfQ7Slti8X"),
    ("ICD10", "J67.8", "J67.8 Hypersensitivity pneumonitis due to other organic dusts", "aT1PJgv0Uq6"),
    ("ICD10", "J67.9", "J67.9 Hypersensitivity pneumonitis due to unspecified organic dust", "r2ibYs8zR1g"),
    ("ICD10", "J68", "J68 Respiratory conditions due to inhalation of chemicals, gases, fumes and vapours", "Ptzno3UmjMi"),
    ("ICD10", "J68.0", "J68.0 Bronchitis and pneumonitis due to chemicals, gases, fumes and vapours", "PIoM9SfNPlA"),
    ("ICD10", "J68.1", "J68.1 Pulmonary oedema due to chemicals, gases, fumes and vapours", "SFceGJqGsgN"),
    ("ICD10", "J68.2", "J68.2 Upper respiratory inflammation due to chemicals, gases, fumes and vapours, not elsewhere classified", "WWHF0Bw51vZ"),
    ("ICD10", "J68.3", "J68.3 Other acute and subacute respiratory conditions due to chemicals, gases, fumes and vapours", "R5iKhjcnsp4"),
    ("ICD10", "J68.4", "J68.4 Chronic respiratory conditions due to chemicals, gases, fumes and vapours", "NVADAVvVWWZ"),
    ("ICD10", "J68.8", "J68.8 Other respiratory conditions due to chemicals, gases, fumes and vapours", "nMAfuMvYKLN"),
    ("ICD10", "J68.9", "J68.9 Unspecified respiratory condition due to chemicals, gases, fumes and vapours", "oq8uN3lj1aE"),
    ("ICD10", "J69", "J69 Pneumonitis due to solids and liquids", "DK2ilggfega"),
    ("ICD10", "J69.0", "J69.0 Pneumonitis due to food and vomit", "arjnjyJ39NX"),
    ("ICD10", "J69.1", "J69.1 Pneumonitis due to oils and essences", "iT7KhQF5GmD"),
    ("ICD10", "J69.8", "J69.8 Pneumonitis due to other solids and liquids", "MWaDzPK8QYW"),
    ("ICD10", "J70", "J70 Respiratory conditions due to other external agents", "bVuhMZCNNMj"),
    ("ICD10", "J70.0", "J70.0 Acute pulmonary manifestations due to radiation", "HgVzwm0Hzso"),
    ("ICD10", "J70.1", "J70.1 Chronic and other pulmonary manifestations due to radiation", "BR17VJR54h5"),
    ("ICD10", "J70.2", "J70.2 Acute drug-induced interstitial lung disorders", "TfJgYKfSuBI"),
    ("ICD10", "J70.3", "J70.3 Chronic drug-induced interstitial lung disorders", "Iysa3WdBwHm"),
    ("ICD10", "J70.4", "J70.4 Drug-induced interstitial lung disorders, unspecified", "ObyXztYjzfL"),
    ("ICD10", "J70.8", "J70.8 Respiratory conditions due to other specified external agents", "yhyvGEFsQZJ"),
    ("ICD10", "J70.9", "J70.9 Respiratory conditions due to unspecified external agent", "oLR3rYyw8Fv"),
    ("ICD10", "J80", "J80 Adult respiratory distress syndrome", "lDLyCosZafb"),
    ("ICD10", "J81", "J81 Pulmonary oedema", "aWQE8T3dSJL"),
    ("ICD10", "J82", "J82 Pulmonary eosinophilia, not elsewhere classified", "nbIg7zjsnRE"),
    ("ICD10", "J84", "J84 Other interstitial pulmonary diseases", "tNyTEoXbqA2"),
    ("ICD10", "J84.0", "J84.0 Alveolar and parietoalveolar conditions", "ck4a5pbopR8"),
    ("ICD10", "J84.1", "J84.1 Other interstitial pulmonary diseases with fibrosis", "bYte0Vi9A5l"),
    ("ICD10", "J84.8", "J84.8 Other specified interstitial pulmonary diseases", "tN3RUcb37K1"),
    ("ICD10", "J84.9", "J84.9 Interstitial pulmonary disease, unspecified", "kIcq522MoCG"),
    ("ICD10", "J85", "J85 Abscess of lung and mediastinum", "CRnl49KxP0Q"),
    ("ICD10", "J85.0", "J85.0 Gangrene and necrosis of lung", "OtgD8m6eTrQ"),
    ("ICD10", "J85.1", "J85.1 Abscess of lung with pneumonia", "OgmNxfyqkWV"),
    ("ICD10", "J85.2", "J85.2 Abscess of lung without pneumonia", "PZCrggAl7JV"),
    ("ICD10", "J85.3", "J85.3 Abscess of mediastinum", "Kk1V35mDmgm"),
    ("ICD10", "J86", "J86 Pyothorax", "zV7bXEU4iGu"),
    ("ICD10", "J86.0", "J86.0 Pyothorax with fistula", "VSyTaeow016"),
    ("ICD10", "J86.9", "J86.9 Pyothorax without fistula", "jIEWWzjd2dU"),
    ("ICD10", "J90", "J90 Pleural effusion, not elsewhere classified", "X5GfqVC35IJ"),
    ("ICD10", "J91", "J91 Pleural effusion in conditions classified elsewhere", "aFKCHnbOPij"),
    ("ICD10", "J92", "J92 Pleural plaque", "WvEazKLgnYg"),
    ("ICD10", "J92.0", "J92.0 Pleural plaque with presence of asbestos", "lghpKtPQvxW"),
    ("ICD10", "J92.9", "J92.9 Pleural plaque without asbestos", "AMIFzsMnROE"),
    ("ICD10", "J93", "J93 Pneumothorax", "M5GVxUEOvRM"),
    ("ICD10", "J93.0", "J93.0 Spontaneous tension pneumothorax", "HpDN4Wr0GXn"),
    ("ICD10", "J93.1", "J93.1 Other spontaneous pneumothorax", "Ckk1xmSM6Rf"),
    ("ICD10", "J93.8", "J93.8 Other pneumothorax", "aKNHyxSQtvM"),
    ("ICD10", "J93.9", "J93.9 Pneumothorax, unspecified", "Zx1uvTGixuk"),
    ("ICD10", "J94", "J94 Other pleural conditions", "KCVwNi1JFmV"),
    ("ICD10", "J94.0", "J94.0 Chylous effusion", "rpVkpyj3Nl2"),
    ("ICD10", "J94.1", "J94.1 Fibrothorax", "uoWrtsCYupi"),
    ("ICD10", "J94.2", "J94.2 Haemothorax", "BZ6u4JoSarA"),
    ("ICD10", "J94.8", "J94.8 Other specified pleural conditions", "Khc6yTFo1Ek"),
    ("ICD10", "J94.9", "J94.9 Pleural condition, unspecified", "wJmfVqtNoBz"),
    ("ICD10", "J95", "J95 Postprocedural respiratory disorders, not elsewhere classified", "USRLjwbWyCp"),
    ("ICD10", "J95.0", "J95.0 Tracheostomy malfunction", "rwVX81dT7Ke"),
    ("ICD10", "J95.1", "J95.1 Acute pulmonary insufficiency following thoracic surgery", "DV0U0JRLLFM"),
    ("ICD10", "J95.2", "J95.2 Acute pulmonary insufficiency following nonthoracic surgery", "cKpoaNlEnJY"),
    ("ICD10", "J95.3", "J95.3 Chronic pulmonary insufficiency following surgery", "UWvKNZpSWgc"),
    ("ICD10", "J95.4", "J95.4 Mendelson syndrome", "kn6El1wyw8t"),
    ("ICD10", "J95.5", "J95.5 Postprocedural subglottic stenosis", "wmOqz7cLhQS"),
    ("ICD10", "J95.8", "J95.8 Other postprocedural respiratory disorders", "zxaOGctwcZI"),
    ("ICD10", "J95.9", "J95.9 Postprocedural respiratory disorder, unspecified", "C0m9RpBoHYK"),
    ("ICD10", "J96", "J96 Respiratory failure, not elsewhere classified", "fWaZoyfZIW2"),
    ("ICD10", "J96.0", "J96.0 Acute respiratory failure", "Q4Nre0wD3VB"),
    ("ICD10", "J96.1", "J96.1 Chronic respiratory failure", "sQPtQtkSwY8"),
    ("ICD10", "J96.9", "J96.9 Respiratory failure, unspecified", "uOZz5h6SGZC"),
    ("ICD10", "J98", "J98 Other respiratory disorders", "ZOSdn7WWVeg"),
    ("ICD10", "J98.0", "J98.0 Diseases of bronchus, not elsewhere classified", "zVdt7byTh0w");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "J98.1", "J98.1 Pulmonary collapse", "J1MK98YhyBe"),
    ("ICD10", "J98.2", "J98.2 Interstitial emphysema", "yoLMxGinFcF"),
    ("ICD10", "J98.3", "J98.3 Compensatory emphysema", "RyVPAAfB2Ly"),
    ("ICD10", "J98.4", "J98.4 Other disorders of lung", "rgPauiDgDD4"),
    ("ICD10", "J98.5", "J98.5 Diseases of mediastinum, not elsewhere classified", "wEy56lszAGW"),
    ("ICD10", "J98.6", "J98.6 Disorders of diaphragm", "AkUVK5sHV7a"),
    ("ICD10", "J98.8", "J98.8 Other specified respiratory disorders", "h0wDgfryNKT"),
    ("ICD10", "J98.9", "J98.9 Respiratory disorder, unspecified", "DhhWZRAvStX"),
    ("ICD10", "J99", "J99 Respiratory disorders in diseases classified elsewhere", "wwoeotTPk24"),
    ("ICD10", "J99.0", "J99.0 Rheumatoid lung disease", "Ono0xZJEJS0"),
    ("ICD10", "J99.1", "J99.1 Respiratory disorders in other diffuse connective tissue disorders", "Os3JbKUlaRQ"),
    ("ICD10", "J99.8", "J99.8 Respiratory disorders in other diseases classified elsewhere", "gwcst6PTISk");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "K00", "K00 Disorders of tooth development and eruption", "bhm2uh99T9i"),
    ("ICD10", "K00.0", "K00.0 Anodontia", "sFkLp0hypBK"),
    ("ICD10", "K00.1", "K00.1 Supernumerary teeth", "WqwzZR4xxfo"),
    ("ICD10", "K00.2", "K00.2 Abnormalities of size and form of teeth", "mTCr3ZVwji8"),
    ("ICD10", "K00.3", "K00.3 Mottled teeth", "o1Ts2Q61JYR"),
    ("ICD10", "K00.4", "K00.4 Disturbances in tooth formation", "J5CxGMjlIf2"),
    ("ICD10", "K00.5", "K00.5 Hereditary disturbances in tooth structure, not elsewhere classified", "t6cNLrOJpUF"),
    ("ICD10", "K00.6", "K00.6 Disturbances in tooth eruption", "bbGJyNNDOV2"),
    ("ICD10", "K00.7", "K00.7 Teething syndrome", "putwCumRQ0H"),
    ("ICD10", "K00.8", "K00.8 Other disorders of tooth development", "k3Qc6hUwnqI"),
    ("ICD10", "K00.9", "K00.9 Disorder of tooth development, unspecified", "vmWDRZpXNHu"),
    ("ICD10", "K01", "K01 Embedded and impacted teeth", "ixXR9SjoFxn"),
    ("ICD10", "K01.0", "K01.0 Embedded teeth", "KurwIfnX9Pu"),
    ("ICD10", "K01.1", "K01.1 Impacted teeth", "tUUbUl3vmzn"),
    ("ICD10", "K02", "K02 Dental caries", "S2Fn5p808XQ"),
    ("ICD10", "K02.0", "K02.0 Caries limited to enamel", "vsvOSPmckRn"),
    ("ICD10", "K02.1", "K02.1 Caries of dentine", "gg2jwXZiGpy"),
    ("ICD10", "K02.2", "K02.2 Caries of cementum", "kGyQIybgWwx"),
    ("ICD10", "K02.3", "K02.3 Arrested dental caries", "ahxEwkccBza"),
    ("ICD10", "K02.4", "K02.4 Odontoclasia", "eMdPdNoftgR"),
    ("ICD10", "K02.5", "K02.5 Caries with pulp exposure", "chfezVxN16V"),
    ("ICD10", "K02.8", "K02.8 Other dental caries", "C4XuX5xnoru"),
    ("ICD10", "K02.9", "K02.9 Dental caries, unspecified", "HOVyJanuE5i"),
    ("ICD10", "K03", "K03 Other diseases of hard tissues of teeth", "DrG0WHRy93D"),
    ("ICD10", "K03.0", "K03.0 Excessive attrition of teeth", "tRx6yquMFjq"),
    ("ICD10", "K03.1", "K03.1 Abrasion of teeth", "gxFJA2QUpFI"),
    ("ICD10", "K03.2", "K03.2 Erosion of teeth", "h2Ops9uqjCz"),
    ("ICD10", "K03.3", "K03.3 Pathological resorption of teeth", "vcjHzZE84d4"),
    ("ICD10", "K03.4", "K03.4 Hypercementosis", "WlMl5lQLwF2"),
    ("ICD10", "K03.5", "K03.5 Ankylosis of teeth", "qdeueATvOHc"),
    ("ICD10", "K03.6", "K03.6 Deposits [accretions] on teeth", "uTUe5j2bayw"),
    ("ICD10", "K03.7", "K03.7 Posteruptive colour changes of dental hard tissues", "yvSUzIYnHRp"),
    ("ICD10", "K03.8", "K03.8 Other specified diseases of hard tissues of teeth", "lpnuih9u6Hy"),
    ("ICD10", "K03.9", "K03.9 Disease of hard tissues of teeth, unspecified", "FYnglk3do4r"),
    ("ICD10", "K04", "K04 Diseases of pulp and periapical tissues", "QQSHe9R5veV"),
    ("ICD10", "K04.0", "K04.0 Pulpitis", "wYVolLxBVkV"),
    ("ICD10", "K04.1", "K04.1 Necrosis of pulp", "OLOyQyzrVhg"),
    ("ICD10", "K04.2", "K04.2 Pulp degeneration", "u0nmp7PSF6I"),
    ("ICD10", "K04.3", "K04.3 Abnormal hard tissue formation in pulp", "SqzFbwVRaDu"),
    ("ICD10", "K04.4", "K04.4 Acute apical periodontitis of pulpal origin", "ohDghLvYtF0"),
    ("ICD10", "K04.5", "K04.5 Chronic apical periodontitis", "obpfXR4XLc6"),
    ("ICD10", "K04.6", "K04.6 Periapical abscess with sinus", "y92801oukYr"),
    ("ICD10", "K04.7", "K04.7 Periapical abscess without sinus", "O2ZY7DDSu70"),
    ("ICD10", "K04.8", "K04.8 Radicular cyst", "r3UmQ3zirCV"),
    ("ICD10", "K04.9", "K04.9 Other and unspecified diseases of pulp and periapical tissues", "e9NOYhamVat"),
    ("ICD10", "K05", "K05 Gingivitis and periodontal diseases", "is3k43xsmTH"),
    ("ICD10", "K05.0", "K05.0 Acute gingivitis", "xnLPYCQo8b0"),
    ("ICD10", "K05.1", "K05.1 Chronic gingivitis", "wYUYOpxhPA5"),
    ("ICD10", "K05.2", "K05.2 Acute periodontitis", "llZi9S8LcQQ"),
    ("ICD10", "K05.3", "K05.3 Chronic periodontitis", "Ws58fJ81yAQ"),
    ("ICD10", "K05.4", "K05.4 Periodontosis", "f3bfuNb1RQI"),
    ("ICD10", "K05.5", "K05.5 Other periodontal diseases", "YvI5h4CcKHD"),
    ("ICD10", "K05.6", "K05.6 Periodontal disease, unspecified", "wtzYf0lK1Up"),
    ("ICD10", "K06", "K06 Other disorders of gingiva and edentulous alveolar ridge", "TSxSJTTIIHo"),
    ("ICD10", "K06.0", "K06.0 Gingival recession", "tFZ1TZPu5x8"),
    ("ICD10", "K06.1", "K06.1 Gingival enlargement", "W4wBzhvDkQ4"),
    ("ICD10", "K06.2", "K06.2 Gingival and edentulous alveolar ridge lesions associated with trauma", "ygw81LlhgSC"),
    ("ICD10", "K06.8", "K06.8 Other specified disorders of gingiva and edentulous alveolar ridge", "A51kU5vNX5J"),
    ("ICD10", "K06.9", "K06.9 Disorder of gingiva and edentulous alveolar ridge, unspecified", "DSHkQ1tUGVD"),
    ("ICD10", "K07", "K07 Dentofacial anomalies [including malocclusion]", "uNUdURIcbR7"),
    ("ICD10", "K07.0", "K07.0 Major anomalies of jaw size", "SyKpdarbfq8"),
    ("ICD10", "K07.1", "K07.1 Anomalies of jaw-cranial base relationship", "c8vb9PcAlOc"),
    ("ICD10", "K07.2", "K07.2 Anomalies of dental arch relationship", "E2P2Y9ZuYss"),
    ("ICD10", "K07.3", "K07.3 Anomalies of tooth position", "xDxYdq3kpzC"),
    ("ICD10", "K07.4", "K07.4 Malocclusion, unspecified", "z0g5rAx2kyL"),
    ("ICD10", "K07.5", "K07.5 Dentofacial functional abnormalities", "qrXbFrcOjep"),
    ("ICD10", "K07.6", "K07.6 Temporomandibular joint disorders", "xVcSPpQpYhF"),
    ("ICD10", "K07.8", "K07.8 Other dentofacial anomalies", "yautTobYVxl"),
    ("ICD10", "K07.9", "K07.9 Dentofacial anomaly, unspecified", "mbL6xrjXEaJ"),
    ("ICD10", "K08", "K08 Other disorders of teeth and supporting structures", "zWPuvW9CFg7"),
    ("ICD10", "K08.0", "K08.0 Exfoliation of teeth due to systemic causes", "shJrvDR5VDw"),
    ("ICD10", "K08.1", "K08.1 Loss of teeth due to accident, extraction or local periodontal disease", "qW4B5ESfwwl"),
    ("ICD10", "K08.2", "K08.2 Atrophy of edentulous alveolar ridge", "iQhwiVZh2ow"),
    ("ICD10", "K08.3", "K08.3 Retained dental root", "FpTbJnDJa6f"),
    ("ICD10", "K08.8", "K08.8 Other specified disorders of teeth and supporting structures", "BNix607cR65"),
    ("ICD10", "K08.9", "K08.9 Disorder of teeth and supporting structures, unspecified", "tIyCEFG1w2S"),
    ("ICD10", "K09", "K09 Cysts of oral region, not elsewhere classified", "B1DnTUk2Q0D"),
    ("ICD10", "K09.0", "K09.0 Developmental odontogenic cysts", "Fe8oqZWjQMi"),
    ("ICD10", "K09.1", "K09.1 Developmental (nonodontogenic) cysts of oral region", "bSFS4zpvCzH"),
    ("ICD10", "K09.2", "K09.2 Other cysts of jaw", "VAjmJ507soG"),
    ("ICD10", "K09.8", "K09.8 Other cysts of oral region, not elsewhere classified", "GTeHAhCJY3w"),
    ("ICD10", "K09.9", "K09.9 Cyst of oral region, unspecified", "OQ5OgbEJBSb"),
    ("ICD10", "K10", "K10 Other diseases of jaws", "yHBcIEqfZDz"),
    ("ICD10", "K10.0", "K10.0 Developmental disorders of jaws", "Ncqjle0hRHP"),
    ("ICD10", "K10.1", "K10.1 Giant cell granuloma, central", "OSOYyTjUHFi"),
    ("ICD10", "K10.2", "K10.2 Inflammatory conditions of jaws", "YATPYFm8tKi"),
    ("ICD10", "K10.3", "K10.3 Alveolitis of jaws", "CUzWw3CFF6c"),
    ("ICD10", "K10.8", "K10.8 Other specified diseases of jaws", "IOtlgd42uBr"),
    ("ICD10", "K10.9", "K10.9 Disease of jaws, unspecified", "SIfr1EhKCmS"),
    ("ICD10", "K11", "K11 Diseases of salivary glands", "x2QM8gFIXXr"),
    ("ICD10", "K11.0", "K11.0 Atrophy of salivary gland", "rhLPzafb6PR"),
    ("ICD10", "K11.1", "K11.1 Hypertrophy of salivary gland", "PjbzIW2wdc9"),
    ("ICD10", "K11.2", "K11.2 Sialoadenitis", "w50XoVrOx2a"),
    ("ICD10", "K11.3", "K11.3 Abscess of salivary gland", "GZ3l1BepCqR"),
    ("ICD10", "K11.4", "K11.4 Fistula of salivary gland", "X8PWTlcKXir"),
    ("ICD10", "K11.5", "K11.5 Sialolithiasis", "gaaqNUvbTfG"),
    ("ICD10", "K11.6", "K11.6 Mucocele of salivary gland", "PoB9LdQtOul"),
    ("ICD10", "K11.7", "K11.7 Disturbances of salivary secretion", "kfiD2XNWHdJ"),
    ("ICD10", "K11.8", "K11.8 Other diseases of salivary glands", "IfNX0hUoxNe"),
    ("ICD10", "K11.9", "K11.9 Disease of salivary gland, unspecified", "MozLrDA71il"),
    ("ICD10", "K12", "K12 Stomatitis and related lesions", "XM1Gm9DINck"),
    ("ICD10", "K12.0", "K12.0 Recurrent oral aphthae", "oSDRnvkAon5"),
    ("ICD10", "K12.1", "K12.1 Other forms of stomatitis", "Bq4X401G0fO"),
    ("ICD10", "K12.2", "K12.2 Cellulitis and abscess of mouth", "dDXmfTWolOZ"),
    ("ICD10", "K12.3", "K12.3 Oral mucositis (ulcerative)", "r5jbkXwPdYJ"),
    ("ICD10", "K13", "K13 Other diseases of lip and oral mucosa", "yIqhmGry19w"),
    ("ICD10", "K13.0", "K13.0 Diseases of lips", "zMxd3qcDxJ1"),
    ("ICD10", "K13.1", "K13.1 Cheek and lip biting", "ARF3jjdV6Wr"),
    ("ICD10", "K13.2", "K13.2 Leukoplakia and other disturbances of oral epithelium, including tongue", "ooiOwB8XOYu"),
    ("ICD10", "K13.3", "K13.3 Hairy leukoplakia", "wvctoKNPmQt"),
    ("ICD10", "K13.4", "K13.4 Granuloma and granuloma-like lesions of oral mucosa", "EA0MNJwnjpv"),
    ("ICD10", "K13.5", "K13.5 Oral submucous fibrosis", "smD2pTj70lG"),
    ("ICD10", "K13.6", "K13.6 Irritative hyperplasia of oral mucosa", "o7CClXRskzD"),
    ("ICD10", "K13.7", "K13.7 Other and unspecified lesions of oral mucosa", "jFcA7CjTOuK"),
    ("ICD10", "K14", "K14 Diseases of tongue", "tlbONiAc73h"),
    ("ICD10", "K14.0", "K14.0 Glossitis", "JoIrg0gTyHy"),
    ("ICD10", "K14.1", "K14.1 Geographic tongue", "BV1EgD18EvX"),
    ("ICD10", "K14.2", "K14.2 Median rhomboid glossitis", "Ee9VTzDtVUb"),
    ("ICD10", "K14.3", "K14.3 Hypertrophy of tongue papillae", "uY3ZgsOBwOs"),
    ("ICD10", "K14.4", "K14.4 Atrophy of tongue papillae", "xNbEiLg5kHX"),
    ("ICD10", "K14.5", "K14.5 Plicated tongue", "n8ZWXnibnLq"),
    ("ICD10", "K14.6", "K14.6 Glossodynia", "xC048zH7ajY"),
    ("ICD10", "K14.8", "K14.8 Other diseases of tongue", "KP33TKnmgQs"),
    ("ICD10", "K14.9", "K14.9 Disease of tongue, unspecified", "Xj8VVQrYgTF"),
    ("ICD10", "K20", "K20 Oesophagitis", "xsAzCeOVRHp"),
    ("ICD10", "K21", "K21 Gastro-oesophageal reflux disease", "aiPlBGZuZnh"),
    ("ICD10", "K21.0", "K21.0 Gastro-oesophageal reflux disease with oesophagitis", "SMeAccuE7OP"),
    ("ICD10", "K21.9", "K21.9 Gastro-oesophageal reflux disease without oesophagitis", "yA3pXyBLQiV"),
    ("ICD10", "K22", "K22 Other diseases of oesophagus", "xB0EJsCJfBy"),
    ("ICD10", "K22.0", "K22.0 Achalasia of cardia", "JeqLzhVvb8y"),
    ("ICD10", "K22.1", "K22.1 Ulcer of oesophagus", "Dh7OSN9Di2H"),
    ("ICD10", "K22.2", "K22.2 Oesophageal obstruction", "lbAVRAhexW0"),
    ("ICD10", "K22.3", "K22.3 Perforation of oesophagus", "ijtb8L2ENvk"),
    ("ICD10", "K22.4", "K22.4 Dyskinesia of oesophagus", "DKRH3H7J5ye"),
    ("ICD10", "K22.5", "K22.5 Diverticulum of oesophagus, acquired", "WCsjx5oO5cq"),
    ("ICD10", "K22.6", "K22.6 Gastro-oesophageal laceration-haemorrhage syndrome", "Nuj9AzyxMm0"),
    ("ICD10", "K22.7", "K22.7 Barrett oesophagus", "Kx7a0DusFdc"),
    ("ICD10", "K22.8", "K22.8 Other specified diseases of oesophagus", "i6kThcQcAsF"),
    ("ICD10", "K22.9", "K22.9 Disease of oesophagus, unspecified", "eXHvkgKPHab"),
    ("ICD10", "K23", "K23 Disorders of oesophagus in diseases classified elsewhere", "lT6NgL6quxg"),
    ("ICD10", "K23.0", "K23.0 Tuberculous oesophagitis", "ES4xzlN1fPQ"),
    ("ICD10", "K23.1", "K23.1 Megaoesophagus in Chagas disease", "obp5gYaIdYQ"),
    ("ICD10", "K23.8", "K23.8 Disorders of oesophagus in other diseases classified elsewhere", "cQp1UvQNFJf"),
    ("ICD10", "K25", "K25 Gastric ulcer", "o6U2xWCl3wE"),
    ("ICD10", "K26", "K26 Duodenal ulcer", "Hd78XgIFdrZ"),
    ("ICD10", "K27", "K27 Peptic ulcer, site unspecified", "ZsZWcv9DNix"),
    ("ICD10", "K28", "K28 Gastrojejunal ulcer", "fbztIusH5k6"),
    ("ICD10", "K29", "K29 Gastritis and duodenitis", "ZfuiZ0UCVPl"),
    ("ICD10", "K29.0", "K29.0 Acute haemorrhagic gastritis", "zHPSaZdaJ71"),
    ("ICD10", "K29.1", "K29.1 Other acute gastritis", "nB6e5D9hvlt"),
    ("ICD10", "K29.2", "K29.2 Alcoholic gastritis", "VS4EoWtXja3"),
    ("ICD10", "K29.3", "K29.3 Chronic superficial gastritis", "lFHCSFZt1Rq"),
    ("ICD10", "K29.4", "K29.4 Chronic atrophic gastritis", "t8kg6USp4et"),
    ("ICD10", "K29.5", "K29.5 Chronic gastritis, unspecified", "HZlNpiik0sU"),
    ("ICD10", "K29.6", "K29.6 Other gastritis", "FkeKFpUevnP"),
    ("ICD10", "K29.7", "K29.7 Gastritis, unspecified", "m5BnonrT1we"),
    ("ICD10", "K29.8", "K29.8 Duodenitis", "ALPg6E7qyxw"),
    ("ICD10", "K29.9", "K29.9 Gastroduodenitis, unspecified", "kSJaajO2Pn0"),
    ("ICD10", "K30", "K30 Functional dyspepsia", "GzxfIiLNamh"),
    ("ICD10", "K31", "K31 Other diseases of stomach and duodenum", "RIHIdNnZQSu"),
    ("ICD10", "K31.0", "K31.0 Acute dilatation of stomach", "qpYcWdYn3AS"),
    ("ICD10", "K31.1", "K31.1 Adult hypertrophic pyloric stenosis", "pc6R8vFZn7g"),
    ("ICD10", "K31.2", "K31.2 Hourglass stricture and stenosis of stomach", "GhwIPEb3U0g"),
    ("ICD10", "K31.3", "K31.3 Pylorospasm, not elsewhere classified", "GnmYxXifySg"),
    ("ICD10", "K31.4", "K31.4 Gastric diverticulum", "n21xFrCL4yv"),
    ("ICD10", "K31.5", "K31.5 Obstruction of duodenum", "IfSdeHcCerc"),
    ("ICD10", "K31.6", "K31.6 Fistula of stomach and duodenum", "e3PrztXN6rB"),
    ("ICD10", "K31.7", "K31.7 Polyp of stomach and duodenum", "s0cw1eJSFMV"),
    ("ICD10", "K31.8", "K31.8 Other specified diseases of stomach and duodenum", "Gkl3s8VerEY"),
    ("ICD10", "K31.9", "K31.9 Disease of stomach and duodenum, unspecified", "zEcZ3GqoX03"),
    ("ICD10", "K35", "K35 Acute appendicitis", "Oy6U4bQWMNm"),
    ("ICD10", "K35.2", "K35.2 Acute appendicitis with generalized peritonitis", "mjoLomqcA30"),
    ("ICD10", "K35.3", "K35.3 Acute appendicitis with localized peritonitis", "y466VAIQVEL"),
    ("ICD10", "K35.8", "K35.8 Acute appendicitis, other and unspecified", "UkRYTtNzEoc"),
    ("ICD10", "K36", "K36 Other appendicitis", "DRqy4XnqP0n"),
    ("ICD10", "K37", "K37 Unspecified appendicitis", "VclW4SHZRYo"),
    ("ICD10", "K38", "K38 Other diseases of appendix", "nbITaIJ4wQU"),
    ("ICD10", "K38.0", "K38.0 Hyperplasia of appendix", "FLzgOlf6NBi"),
    ("ICD10", "K38.1", "K38.1 Appendicular concretions", "jwEWeYpb4bM"),
    ("ICD10", "K38.2", "K38.2 Diverticulum of appendix", "R7GKunlkZED"),
    ("ICD10", "K38.3", "K38.3 Fistula of appendix", "JJ4l7aXQla1"),
    ("ICD10", "K38.8", "K38.8 Other specified diseases of appendix", "v5rcbbVkj9a"),
    ("ICD10", "K38.9", "K38.9 Disease of appendix, unspecified", "V0H7BnIsawc"),
    ("ICD10", "K40", "K40 Inguinal hernia", "mgUW2nvFU6Z"),
    ("ICD10", "K40.0", "K40.0 Bilateral inguinal hernia, with obstruction, without gangrene", "LY23o3ZDE0a"),
    ("ICD10", "K40.1", "K40.1 Bilateral inguinal hernia, with gangrene", "kzIlcbux4Fx"),
    ("ICD10", "K40.2", "K40.2 Bilateral inguinal hernia, without obstruction or gangrene", "mZqON9RHVi0"),
    ("ICD10", "K40.3", "K40.3 Unilateral or unspecified inguinal hernia, with obstruction, without gangrene", "p0YF4azV0Rt"),
    ("ICD10", "K40.4", "K40.4 Unilateral or unspecified inguinal hernia, with gangrene", "Pb3OfbH2E6l"),
    ("ICD10", "K40.9", "K40.9 Unilateral or unspecified inguinal hernia, without obstruction or gangrene", "SxJDmMpKmC7"),
    ("ICD10", "K41", "K41 Femoral hernia", "uDok1hKd58x"),
    ("ICD10", "K41.0", "K41.0 Bilateral femoral hernia, with obstruction, without gangrene", "xSp0KKv8LPx"),
    ("ICD10", "K41.1", "K41.1 Bilateral femoral hernia, with gangrene", "lkqXdReFTrl"),
    ("ICD10", "K41.2", "K41.2 Bilateral femoral hernia, without obstruction or gangrene", "N0iiEpbJzSk"),
    ("ICD10", "K41.3", "K41.3 Unilateral or unspecified femoral hernia, with obstruction, without gangrene", "kCmjsi5hnBk"),
    ("ICD10", "K41.4", "K41.4 Unilateral or unspecified femoral hernia, with gangrene", "lvUbx5Kd1Hq"),
    ("ICD10", "K41.9", "K41.9 Unilateral or unspecified femoral hernia, without obstruction or gangrene", "YiyEVTDY7SQ"),
    ("ICD10", "K42", "K42 Umbilical hernia", "E8DY5IUK3Wk"),
    ("ICD10", "K42.0", "K42.0 Umbilical hernia with obstruction, without gangrene", "MaH1oBeQUKK"),
    ("ICD10", "K42.1", "K42.1 Umbilical hernia with gangrene", "gqPRGo0PvBn"),
    ("ICD10", "K42.9", "K42.9 Umbilical hernia without obstruction or gangrene", "e5XX8M2PURO"),
    ("ICD10", "K43", "K43 Ventral hernia", "inwA0j5CW7A"),
    ("ICD10", "K43.0", "K43.0 Incisional hernia with obstruction, without gangrene", "hYnyo1GJ5eA"),
    ("ICD10", "K43.1", "K43.1 Incisional hernia with gangrene", "riOnlXJly3A"),
    ("ICD10", "K43.2", "K43.2 Incisional hernia without obstruction or gangrene", "YSDCR7obtPT"),
    ("ICD10", "K43.3", "K43.3 Parastomal hernia with obstruction, without gangrene", "pwCjESDjBaw"),
    ("ICD10", "K43.4", "K43.4 Parastomal hernia with gangrene", "sDQ7DIFLF6n"),
    ("ICD10", "K43.5", "K43.5 Parastomal hernia without obstruction or gangrene", "A6mmOCx3aAF"),
    ("ICD10", "K43.6", "K43.6 Other and unspecified ventral hernia with obstruction without gangrene", "qO9kcwr9V2c"),
    ("ICD10", "K43.7", "K43.7 Other and unspecified ventral hernia with gangrene", "aVpNl9BWmtc"),
    ("ICD10", "K43.9", "K43.9 Other and unspecified ventral hernia without obstruction or gangrene", "yU2qfS5gDWt"),
    ("ICD10", "K44", "K44 Diaphragmatic hernia", "uuSdyPr1JiV"),
    ("ICD10", "K44.0", "K44.0 Diaphragmatic hernia with obstruction, without gangrene", "wjReIjks4Rs"),
    ("ICD10", "K44.1", "K44.1 Diaphragmatic hernia with gangrene", "tMEOIwlHUl4"),
    ("ICD10", "K44.9", "K44.9 Diaphragmatic hernia without obstruction or gangrene", "Lan4kHzm6dO"),
    ("ICD10", "K45", "K45 Other abdominal hernia", "TYMyjawdzf2"),
    ("ICD10", "K45.0", "K45.0 Other specified abdominal hernia with obstruction, without gangrene", "EfFJhOk0nQ5"),
    ("ICD10", "K45.1", "K45.1 Other specified abdominal hernia with gangrene", "IRGcuAxxi2K"),
    ("ICD10", "K45.8", "K45.8 Other specified abdominal hernia without obstruction or gangrene", "SOdA6JJZK6m"),
    ("ICD10", "K46", "K46 Unspecified abdominal hernia", "vwxqEMCaEYq"),
    ("ICD10", "K46.0", "K46.0 Unspecified abdominal hernia with obstruction, without gangrene", "T3kXIAZ3jBl"),
    ("ICD10", "K46.1", "K46.1 Unspecified abdominal hernia with gangrene", "HKQIVDpFpwS"),
    ("ICD10", "K46.9", "K46.9 Unspecified abdominal hernia without obstruction or gangrene", "TjEzEgVJk6X"),
    ("ICD10", "K50", "K50 Crohn disease [regional enteritis]", "gDeaV0iBjCr"),
    ("ICD10", "K50.0", "K50.0 Crohn disease of small intestine", "f8JUdclIZJV"),
    ("ICD10", "K50.1", "K50.1 Crohn disease of large intestine", "DuhcVGftTar"),
    ("ICD10", "K50.8", "K50.8 Other Crohn disease", "NUh9yA2P1mA"),
    ("ICD10", "K50.9", "K50.9 Crohn disease, unspecified", "rpuZm3rpPl6"),
    ("ICD10", "K51", "K51 Ulcerative colitis", "mO5e4gNmgXn"),
    ("ICD10", "K51.0", "K51.0 Ulcerative (chronic) pancolitis", "HFtT0i3uctm"),
    ("ICD10", "K51.2", "K51.2 Ulcerative (chronic) proctitis", "UOHJ0gnm8hW"),
    ("ICD10", "K51.3", "K51.3 Ulcerative (chronic) rectosigmoiditis", "K3KU3CvkE7P"),
    ("ICD10", "K51.4", "K51.4 Inflammatory polyps", "TD7mGk4rEpp"),
    ("ICD10", "K51.5", "K51.5 Left sided colitis", "ZPMivVuGy7Y"),
    ("ICD10", "K51.8", "K51.8 Other ulcerative colitis", "HIYTgHMvGOy"),
    ("ICD10", "K51.9", "K51.9 Ulcerative colitis, unspecified", "Kc8WHLcFYH7"),
    ("ICD10", "K52", "K52 Other noninfective gastroenteritis and colitis", "oOXKfuXHS9e"),
    ("ICD10", "K52.0", "K52.0 Gastroenteritis and colitis due to radiation", "mmXUmoKcCH2"),
    ("ICD10", "K52.1", "K52.1 Toxic gastroenteritis and colitis", "SBiIi5tfqzB"),
    ("ICD10", "K52.2", "K52.2 Allergic and dietetic gastroenteritis and colitis", "bqvlsvnG51c"),
    ("ICD10", "K52.3", "K52.3 Indeterminate colitis", "jz2e6pD6ua4"),
    ("ICD10", "K52.8", "K52.8 Other specified noninfective gastroenteritis and colitis", "Jg70x2ud1S3"),
    ("ICD10", "K52.9", "K52.9 Noninfective gastroenteritis and colitis, unspecified", "Qn2gmsobIZw"),
    ("ICD10", "K55", "K55 Vascular disorders of intestine", "yyr7ZHcB3Mj"),
    ("ICD10", "K55.0", "K55.0 Acute vascular disorders of intestine", "rp6vQ51KMqK"),
    ("ICD10", "K55.1", "K55.1 Chronic vascular disorders of intestine", "FXQL0WI0bWv"),
    ("ICD10", "K55.2", "K55.2 Angiodysplasia of colon", "OlG0ZVVatOi"),
    ("ICD10", "K55.8", "K55.8 Other vascular disorders of intestine", "hsityPI0Tw6"),
    ("ICD10", "K55.9", "K55.9 Vascular disorder of intestine, unspecified", "tKcA7eTOuqB"),
    ("ICD10", "K56", "K56 Paralytic ileus and intestinal obstruction without hernia", "VyOY9mkGE5H"),
    ("ICD10", "K56.0", "K56.0 Paralytic ileus", "OlVGp8dE7Or"),
    ("ICD10", "K56.1", "K56.1 Intussusception", "VBLpQGjraHc"),
    ("ICD10", "K56.2", "K56.2 Volvulus", "BdYtIZMuO7X"),
    ("ICD10", "K56.3", "K56.3 Gallstone ileus", "HQGqsvghk80"),
    ("ICD10", "K56.4", "K56.4 Other impaction of intestine", "ftFpNiEGsgy"),
    ("ICD10", "K56.5", "K56.5 Intestinal adhesions [bands] with obstruction", "xeeJNkqdygN"),
    ("ICD10", "K56.6", "K56.6 Other and unspecified intestinal obstruction", "FTGTcNPyavL"),
    ("ICD10", "K56.7", "K56.7 Ileus, unspecified", "lFzTdejNU0T"),
    ("ICD10", "K57", "K57 Diverticular disease of intestine", "qfidlpdVh5k"),
    ("ICD10", "K57.0", "K57.0 Diverticular disease of small intestine with perforation and abscess", "V3FhnS9W5xU"),
    ("ICD10", "K57.1", "K57.1 Diverticular disease of small intestine without perforation or abscess", "d7m3kVYQrzL"),
    ("ICD10", "K57.2", "K57.2 Diverticular disease of large intestine with perforation and abscess", "Tl7UtXnpi1W"),
    ("ICD10", "K57.3", "K57.3 Diverticular disease of large intestine without perforation or abscess", "qMATJ2vMJt5"),
    ("ICD10", "K57.4", "K57.4 Diverticular disease of both small and large intestine with perforation and abscess", "JKXTDkAGpdd"),
    ("ICD10", "K57.5", "K57.5 Diverticular disease of both small and large intestine without perforation or abscess", "sfmEEfBlAzI"),
    ("ICD10", "K57.8", "K57.8 Diverticular disease of intestine, part unspecified, with perforation and abscess", "d1201fUtidY"),
    ("ICD10", "K57.9", "K57.9 Diverticular disease of intestine, part unspecified, without perforation or abscess", "stpWjpp74ZI"),
    ("ICD10", "K58", "K58 Irritable bowel syndrome", "yDv22LZiGXM"),
    ("ICD10", "K58.0", "K58.0 Irritable bowel syndrome with diarrhoea", "zjtjCCav6od"),
    ("ICD10", "K58.9", "K58.9 Irritable bowel syndrome without diarrhoea", "Fop23ekZEdu"),
    ("ICD10", "K59", "K59 Other functional intestinal disorders", "oIl8xuYPGqR"),
    ("ICD10", "K59.0", "K59.0 Constipation", "FJjFm1orN8n"),
    ("ICD10", "K59.1", "K59.1 Functional diarrhoea", "VGaGbjExH4E"),
    ("ICD10", "K59.2", "K59.2 Neurogenic bowel, not elsewhere classified", "TZHQx9TvOdU"),
    ("ICD10", "K59.3", "K59.3 Megacolon, not elsewhere classified", "aOMIsT6znRm"),
    ("ICD10", "K59.4", "K59.4 Anal spasm", "zFBD2dvNlYa"),
    ("ICD10", "K59.8", "K59.8 Other specified functional intestinal disorders", "qH3wYx02Q55"),
    ("ICD10", "K59.9", "K59.9 Functional intestinal disorder, unspecified", "xuc68vsacGE"),
    ("ICD10", "K60", "K60 Fissure and fistula of anal and rectal regions", "Ltn7Mf5R7m1"),
    ("ICD10", "K60.0", "K60.0 Acute anal fissure", "XMPSy6LojTz");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "K60.1", "K60.1 Chronic anal fissure", "yPaYL9M5iSZ"),
    ("ICD10", "K60.2", "K60.2 Anal fissure, unspecified", "skbhggSHkpE"),
    ("ICD10", "K60.3", "K60.3 Anal fistula", "tmz2bH1b6qD"),
    ("ICD10", "K60.4", "K60.4 Rectal fistula", "i4w8Wf7sg4K"),
    ("ICD10", "K60.5", "K60.5 Anorectal fistula", "p63Wfo2xDuf"),
    ("ICD10", "K61", "K61 Abscess of anal and rectal regions", "cL4mFCURZv2"),
    ("ICD10", "K61.0", "K61.0 Anal abscess", "PPMdrFEOvY4"),
    ("ICD10", "K61.1", "K61.1 Rectal abscess", "yZv7cAnhZfp"),
    ("ICD10", "K61.2", "K61.2 Anorectal abscess", "mlOW8ZJWGfA"),
    ("ICD10", "K61.3", "K61.3 Ischiorectal abscess", "uIs5IvhzNcZ"),
    ("ICD10", "K61.4", "K61.4 Intrasphincteric abscess", "Yen1DvX9QZF"),
    ("ICD10", "K62", "K62 Other diseases of anus and rectum", "kprSUFcBRdD"),
    ("ICD10", "K62.0", "K62.0 Anal polyp", "Q3zFcZduiMK"),
    ("ICD10", "K62.1", "K62.1 Rectal polyp", "vD3NR9CFaKU"),
    ("ICD10", "K62.2", "K62.2 Anal prolapse", "xLHyEQ8oucI"),
    ("ICD10", "K62.3", "K62.3 Rectal prolapse", "YGpo2r51taI"),
    ("ICD10", "K62.4", "K62.4 Stenosis of anus and rectum", "h33JEbv5TZD"),
    ("ICD10", "K62.5", "K62.5 Haemorrhage of anus and rectum", "kjbkzbgOEtU"),
    ("ICD10", "K62.6", "K62.6 Ulcer of anus and rectum", "w3rNJ4yLNrw"),
    ("ICD10", "K62.7", "K62.7 Radiation proctitis", "q9FBhX1V7Kr"),
    ("ICD10", "K62.8", "K62.8 Other specified diseases of anus and rectum", "Mv8yCIasbXY"),
    ("ICD10", "K62.9", "K62.9 Disease of anus and rectum, unspecified", "WIefKdNkeqE"),
    ("ICD10", "K63", "K63 Other diseases of intestine", "mXJi6m3hAp4"),
    ("ICD10", "K63.0", "K63.0 Abscess of intestine", "Jrz0vhBz4hS"),
    ("ICD10", "K63.1", "K63.1 Perforation of intestine (nontraumatic)", "QtKLs0N3aSF"),
    ("ICD10", "K63.2", "K63.2 Fistula of intestine", "wv1tkBzImC5"),
    ("ICD10", "K63.3", "K63.3 Ulcer of intestine", "KRlh8p8eFt9"),
    ("ICD10", "K63.4", "K63.4 Enteroptosis", "GOGEJw8LvwS"),
    ("ICD10", "K63.5", "K63.5 Polyp of colon", "mZEtTwGdf1q"),
    ("ICD10", "K63.8", "K63.8 Other specified diseases of intestine", "LW3Xv4wTABz"),
    ("ICD10", "K63.9", "K63.9 Disease of intestine, unspecified", "ELsVSb93qgQ"),
    ("ICD10", "K64", "K64 Haemorrhoids and perianal venous thrombosis", "sRbC7VTCzpR"),
    ("ICD10", "K64.0", "K64.0 First degree haemorrhoids", "yRgPgZUx6hE"),
    ("ICD10", "K64.1", "K64.1 Second degree haemorrhoids", "k2VijUCoI4I"),
    ("ICD10", "K64.2", "K64.2 Third degree haemorrhoids", "P6GLfxtnsef"),
    ("ICD10", "K64.3", "K64.3 Fourth degree haemorrhoids", "O3eIiNSVEIo"),
    ("ICD10", "K64.4", "K64.4 Residual haemorrhoidal skin tags", "BK9N0gkXyMw"),
    ("ICD10", "K64.5", "K64.5 Perianal venous thrombosis", "BxePWyA2gcX"),
    ("ICD10", "K64.8", "K64.8 Other specified haemorrhoids", "YiQTHc0LaGz"),
    ("ICD10", "K64.9", "K64.9 Haemorrhoids, unspecified", "KB2mQVj8OLd"),
    ("ICD10", "K65", "K65 Peritonitis", "fgShiHttKtV"),
    ("ICD10", "K65.0", "K65.0 Acute peritonitis", "LW6oE3mrJvX"),
    ("ICD10", "K65.8", "K65.8 Other peritonitis", "t9Jwbr0Ky5v"),
    ("ICD10", "K65.9", "K65.9 Peritonitis, unspecified", "EW6654FNpzL"),
    ("ICD10", "K66", "K66 Other disorders of peritoneum", "bUezyk5uMId"),
    ("ICD10", "K66.0", "K66.0 Peritoneal adhesions", "nKRSVFySWAq"),
    ("ICD10", "K66.1", "K66.1 Haemoperitoneum", "zCtPNwulLgs"),
    ("ICD10", "K66.8", "K66.8 Other specified disorders of peritoneum", "iMVvevgpcRx"),
    ("ICD10", "K66.9", "K66.9 Disorder of peritoneum, unspecified", "C0NP30RNKfL"),
    ("ICD10", "K67", "K67 Disorders of peritoneum in infectious diseases classified elsewhere", "UBL2xBeVI7E"),
    ("ICD10", "K67.0", "K67.0 Chlamydial peritonitis", "dcv1nm6NpOR"),
    ("ICD10", "K67.1", "K67.1 Gonococcal peritonitis", "ChI1grBTlL9"),
    ("ICD10", "K67.2", "K67.2 Syphilitic peritonitis", "e5uzRMmEwRL"),
    ("ICD10", "K67.3", "K67.3 Tuberculous peritonitis", "bnQv9ncIuaw"),
    ("ICD10", "K67.8", "K67.8 Other disorders of peritoneum in infectious diseases classified elsewhere", "sShD8C0OwLA"),
    ("ICD10", "K70", "K70 Alcoholic liver disease", "FJZE3SNt8Uw"),
    ("ICD10", "K70.0", "K70.0 Alcoholic fatty liver", "pSCsAPxXEYI"),
    ("ICD10", "K70.1", "K70.1 Alcoholic hepatitis", "uEeN1GhpRjz"),
    ("ICD10", "K70.2", "K70.2 Alcoholic fibrosis and sclerosis of liver", "RBDEFpv1tfV"),
    ("ICD10", "K70.3", "K70.3 Alcoholic cirrhosis of liver", "prqGhCwevOh"),
    ("ICD10", "K70.4", "K70.4 Alcoholic hepatic failure", "j3VyhPDwRUH"),
    ("ICD10", "K70.9", "K70.9 Alcoholic liver disease, unspecified", "W4tToBPy7wz"),
    ("ICD10", "K71", "K71 Toxic liver disease", "wkx652YcRDi"),
    ("ICD10", "K71.0", "K71.0 Toxic liver disease with cholestasis", "bCqG1elYKt6"),
    ("ICD10", "K71.1", "K71.1 Toxic liver disease with hepatic necrosis", "XCvRrvye4uV"),
    ("ICD10", "K71.2", "K71.2 Toxic liver disease with acute hepatitis", "RQJhVSDfqjZ"),
    ("ICD10", "K71.3", "K71.3 Toxic liver disease with chronic persistent hepatitis", "JmVvv0QpDtm"),
    ("ICD10", "K71.4", "K71.4 Toxic liver disease with chronic lobular hepatitis", "gWP7owJjuNe"),
    ("ICD10", "K71.5", "K71.5 Toxic liver disease with chronic active hepatitis", "cPfdQZcLZ9u"),
    ("ICD10", "K71.6", "K71.6 Toxic liver disease with hepatitis, not elsewhere classified", "k8Gw8jb1bcd"),
    ("ICD10", "K71.7", "K71.7 Toxic liver disease with fibrosis and cirrhosis of liver", "INwR0yTZulV"),
    ("ICD10", "K71.8", "K71.8 Toxic liver disease with other disorders of liver", "SHrEZZy1ohr"),
    ("ICD10", "K71.9", "K71.9 Toxic liver disease, unspecified", "hCMrsmgdVgG"),
    ("ICD10", "K72", "K72 Hepatic failure, not elsewhere classified", "woEYtlVoILk"),
    ("ICD10", "K72.0", "K72.0 Acute and subacute hepatic failure", "GfIuGr3CNSz"),
    ("ICD10", "K72.1", "K72.1 Chronic hepatic failure", "lcaYyriPqEn"),
    ("ICD10", "K72.9", "K72.9 Hepatic failure, unspecified", "FrUdYQzT6Tj"),
    ("ICD10", "K73", "K73 Chronic hepatitis, not elsewhere classified", "frSlDYxjzVL"),
    ("ICD10", "K73.0", "K73.0 Chronic persistent hepatitis, not elsewhere classified", "v3sBsYCNLNa"),
    ("ICD10", "K73.1", "K73.1 Chronic lobular hepatitis, not elsewhere classified", "dyw3ObBTeZL"),
    ("ICD10", "K73.2", "K73.2 Chronic active hepatitis, not elsewhere classified", "bPRkCPuRuCd"),
    ("ICD10", "K73.8", "K73.8 Other chronic hepatitis, not elsewhere classified", "gg9OYTYAj9J"),
    ("ICD10", "K73.9", "K73.9 Chronic hepatitis, unspecified", "rjifNI5ONH7"),
    ("ICD10", "K74", "K74 Fibrosis and cirrhosis of liver", "kN9ojICWuEB"),
    ("ICD10", "K74.0", "K74.0 Hepatic fibrosis", "untc8oa10iD"),
    ("ICD10", "K74.1", "K74.1 Hepatic sclerosis", "or5ZCpVYYlJ"),
    ("ICD10", "K74.2", "K74.2 Hepatic fibrosis with hepatic sclerosis", "ce5gBrW62kf"),
    ("ICD10", "K74.3", "K74.3 Primary biliary cirrhosis", "FUNQ8ls1R9d"),
    ("ICD10", "K74.4", "K74.4 Secondary biliary cirrhosis", "kk4FtvJ92n7"),
    ("ICD10", "K74.5", "K74.5 Biliary cirrhosis, unspecified", "QwHhA2NE5XZ"),
    ("ICD10", "K74.6", "K74.6 Other and unspecified cirrhosis of liver", "TFzZn5AZWgw"),
    ("ICD10", "K75", "K75 Other inflammatory liver diseases", "ypkn8EffC7c"),
    ("ICD10", "K75.0", "K75.0 Abscess of liver", "CAkDQVEBXne"),
    ("ICD10", "K75.1", "K75.1 Phlebitis of portal vein", "WH2vKdSK8pL"),
    ("ICD10", "K75.2", "K75.2 Nonspecific reactive hepatitis", "kUxLPxpIoPB"),
    ("ICD10", "K75.3", "K75.3 Granulomatous hepatitis, not elsewhere classified", "SxOi3z6ho4o"),
    ("ICD10", "K75.4", "K75.4 Autoimmune hepatitis", "S6ph6XPeMoC"),
    ("ICD10", "K75.8", "K75.8 Other specified inflammatory liver diseases", "I1X2bEPItsd"),
    ("ICD10", "K75.9", "K75.9 Inflammatory liver disease, unspecified", "fzq4ZFZwF7e"),
    ("ICD10", "K76", "K76 Other diseases of liver", "QTZnKskI8kc"),
    ("ICD10", "K76.0", "K76.0 Fatty (change of) liver, not elsewhere classified", "H3wG2N6tcZY"),
    ("ICD10", "K76.1", "K76.1 Chronic passive congestion of liver", "FFLYpBoelS4"),
    ("ICD10", "K76.2", "K76.2 Central haemorrhagic necrosis of liver", "XHfvxvPRwh6"),
    ("ICD10", "K76.3", "K76.3 Infarction of liver", "QipfGhIHG6H"),
    ("ICD10", "K76.4", "K76.4 Peliosis hepatis", "kbYdikCy9fj"),
    ("ICD10", "K76.5", "K76.5 Hepatic veno-occlusive disease", "udCSwC1eM2r"),
    ("ICD10", "K76.6", "K76.6 Portal hypertension", "ytl3Gax9cbh"),
    ("ICD10", "K76.7", "K76.7 Hepatorenal syndrome", "NVQ5TNUMqMk"),
    ("ICD10", "K76.8", "K76.8 Other specified diseases of liver", "RYbVhzU15Pt"),
    ("ICD10", "K76.9", "K76.9 Liver disease, unspecified", "O7Jk38d3Kog"),
    ("ICD10", "K77", "K77 Liver disorders in diseases classified elsewhere", "Q9aGhZgalZ2"),
    ("ICD10", "K77.0", "K77.0 Liver disorders in infectious and parasitic diseases classified elsewhere", "otIAjQa1iTY"),
    ("ICD10", "K77.8", "K77.8 Liver disorders in other diseases classified elsewhere", "g0sNTycdhEz"),
    ("ICD10", "K80", "K80 Cholelithiasis", "iMFKMMmkHuY"),
    ("ICD10", "K80.0", "K80.0 Calculus of gallbladder with acute cholecystitis", "WLKopfs8Ic9"),
    ("ICD10", "K80.1", "K80.1 Calculus of gallbladder with other cholecystitis", "qrNGKs87Ikw"),
    ("ICD10", "K80.2", "K80.2 Calculus of gallbladder without cholecystitis", "LsO4eVaYego"),
    ("ICD10", "K80.3", "K80.3 Calculus of bile duct with cholangitis", "mAF1yNMd664"),
    ("ICD10", "K80.4", "K80.4 Calculus of bile duct with cholecystitis", "Ziwv2bBIt1c"),
    ("ICD10", "K80.5", "K80.5 Calculus of bile duct without cholangitis or cholecystitis", "JlRusQfdKM9"),
    ("ICD10", "K80.8", "K80.8 Other cholelithiasis", "w4R0RnkrQrL"),
    ("ICD10", "K81", "K81 Cholecystitis", "Zvtxt8jWy83"),
    ("ICD10", "K81.0", "K81.0 Acute cholecystitis", "QrS94HlJNxC"),
    ("ICD10", "K81.1", "K81.1 Chronic cholecystitis", "JcPr0AWrGvn"),
    ("ICD10", "K81.8", "K81.8 Other cholecystitis", "EDLu1qHn5eX"),
    ("ICD10", "K81.9", "K81.9 Cholecystitis, unspecified", "E0uZ2ooQntO"),
    ("ICD10", "K82", "K82 Other diseases of gallbladder", "D9Qi0HKo8gF"),
    ("ICD10", "K82.0", "K82.0 Obstruction of gallbladder", "T4WMPPF8yKC"),
    ("ICD10", "K82.1", "K82.1 Hydrops of gallbladder", "WX2GoqTPBAv"),
    ("ICD10", "K82.2", "K82.2 Perforation of gallbladder", "vnFqfJ4M4he"),
    ("ICD10", "K82.3", "K82.3 Fistula of gallbladder", "Ym5ebdCneIJ"),
    ("ICD10", "K82.4", "K82.4 Cholesterolosis of gallbladder", "b35s6EmLSbc"),
    ("ICD10", "K82.8", "K82.8 Other specified diseases of gallbladder", "JJZVgcUiLny"),
    ("ICD10", "K82.9", "K82.9 Disease of gallbladder, unspecified", "mEsL9CtcKe2"),
    ("ICD10", "K83", "K83 Other diseases of biliary tract", "cTjdSNIIQwk"),
    ("ICD10", "K83.0", "K83.0 Cholangitis", "LQ8h6E3wq4B"),
    ("ICD10", "K83.1", "K83.1 Obstruction of bile duct", "Tvv3R8UGa8a"),
    ("ICD10", "K83.2", "K83.2 Perforation of bile duct", "qF4uBMEMcOP"),
    ("ICD10", "K83.3", "K83.3 Fistula of bile duct", "dFaIhm3F0s7"),
    ("ICD10", "K83.4", "K83.4 Spasm of sphincter of Oddi", "bQcxQCwLCbo"),
    ("ICD10", "K83.5", "K83.5 Biliary cyst", "O0fXkJU6zhz"),
    ("ICD10", "K83.8", "K83.8 Other specified diseases of biliary tract", "lpt96i9ABPl"),
    ("ICD10", "K83.9", "K83.9 Disease of biliary tract, unspecified", "sFdl10bVN3c"),
    ("ICD10", "K85", "K85 Acute pancreatitis", "efbNfERnI26"),
    ("ICD10", "K85.0", "K85.0 Idiopathic acute pancreatitis", "nimzqMBeNjx"),
    ("ICD10", "K85.1", "K85.1 Biliary acute pancreatitis", "kdxuKCuFJMG"),
    ("ICD10", "K85.2", "K85.2 Alcohol-induced acute pancreatitis", "BqxWcScnbBa"),
    ("ICD10", "K85.3", "K85.3 Drug-induced acute pancreatitis", "skoE7SKXass"),
    ("ICD10", "K85.8", "K85.8 Other acute pancreatitis", "bOzUWw4xP6X"),
    ("ICD10", "K85.9", "K85.9 Acute pancreatitis, unspecified", "zPnLHsAeHd6"),
    ("ICD10", "K86", "K86 Other diseases of pancreas", "YRDKsnvdnYN"),
    ("ICD10", "K86.0", "K86.0 Alcohol-induced chronic pancreatitis", "yWj3m0ey27V"),
    ("ICD10", "K86.1", "K86.1 Other chronic pancreatitis", "CBEa8gs8yTA"),
    ("ICD10", "K86.2", "K86.2 Cyst of pancreas", "eqNNsSPwWSV"),
    ("ICD10", "K86.3", "K86.3 Pseudocyst of pancreas", "yQcwWwvI7t9"),
    ("ICD10", "K86.8", "K86.8 Other specified diseases of pancreas", "uj63RttqhPf"),
    ("ICD10", "K86.9", "K86.9 Disease of pancreas, unspecified", "dQGZUGCZfWr"),
    ("ICD10", "K87", "K87 Disorders of gallbladder, biliary tract and pancreas in diseases classified elsewhere", "ZD4SZH2Xn4Y"),
    ("ICD10", "K87.0", "K87.0 Disorders of gallbladder and biliary tract in diseases classified elsewhere", "IARmlojgB6m"),
    ("ICD10", "K87.1", "K87.1 Disorders of pancreas in diseases classified elsewhere", "TZnlZ0rbuyT"),
    ("ICD10", "K90", "K90 Intestinal malabsorption", "bm8R1fzgWRH"),
    ("ICD10", "K90.0", "K90.0 Coeliac disease", "EglVJUbNAvr"),
    ("ICD10", "K90.1", "K90.1 Tropical sprue", "e3vR53mVYfR"),
    ("ICD10", "K90.2", "K90.2 Blind loop syndrome, not elsewhere classified", "HXy5MxjIE70"),
    ("ICD10", "K90.3", "K90.3 Pancreatic steatorrhoea", "zSvYdNLrTuW"),
    ("ICD10", "K90.4", "K90.4 Malabsorption due to intolerance, not elsewhere classified", "pQYs2mizhSI"),
    ("ICD10", "K90.8", "K90.8 Other intestinal malabsorption", "Et7gAWjJUhs"),
    ("ICD10", "K90.9", "K90.9 Intestinal malabsorption, unspecified", "LWNkAkMDhHv"),
    ("ICD10", "K91", "K91 Postprocedural disorders of digestive system, not elsewhere classified", "VAvGdqVuuFH"),
    ("ICD10", "K91.0", "K91.0 Vomiting following gastrointestinal surgery", "DQui1PNQrGg"),
    ("ICD10", "K91.1", "K91.1 Postgastric surgery syndromes", "p2zoEsoFJiF"),
    ("ICD10", "K91.2", "K91.2 Postsurgical malabsorption, not elsewhere classified", "sPpPpCN4bZS"),
    ("ICD10", "K91.3", "K91.3 Postoperative intestinal obstruction", "Q4o2yYOqSEv"),
    ("ICD10", "K91.4", "K91.4 Colostomy and enterostomy malfunction", "reCcwzxnSnS"),
    ("ICD10", "K91.5", "K91.5 Postcholecystectomy syndrome", "gO23v4R7Qcs"),
    ("ICD10", "K91.8", "K91.8 Other postprocedural disorders of digestive system, not elsewhere classified", "BjkcG4g0xbG"),
    ("ICD10", "K91.9", "K91.9 Postprocedural disorder of digestive system, unspecified", "g3MZHNfxncS"),
    ("ICD10", "K92", "K92 Other diseases of digestive system", "xdmC2IM2ugV"),
    ("ICD10", "K92.0", "K92.0 Haematemesis", "FADQl54YGSr"),
    ("ICD10", "K92.1", "K92.1 Melaena", "liLFPFcfxtD"),
    ("ICD10", "K92.2", "K92.2 Gastrointestinal haemorrhage, unspecified", "a3fBtHLJ8Ap"),
    ("ICD10", "K92.8", "K92.8 Other specified diseases of digestive system", "QtzJm89aa6c"),
    ("ICD10", "K92.9", "K92.9 Disease of digestive system, unspecified", "eHyI61UkMwz"),
    ("ICD10", "K93", "K93 Disorders of other digestive organs in diseases classified elsewhere", "C6VTnVyvoSi"),
    ("ICD10", "K93.0", "K93.0 Tuberculous disorders of intestines, peritoneum and mesenteric glands", "yQySgDhtFJa"),
    ("ICD10", "K93.1", "K93.1 Megacolon in Chagas disease", "RkxWkR0SZWe"),
    ("ICD10", "K93.8", "K93.8 Disorders of other specified digestive organs in diseases classified elsewhere", "T3iVpVptWNB");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "L00", "L00 Staphylococcal scalded skin syndrome", "XAFwh4oyjZf"),
    ("ICD10", "L01", "L01 Impetigo", "MFxYTmH4JkF"),
    ("ICD10", "L01.0", "L01.0 Impetigo [any organism] [any site]", "za4jhWniATn"),
    ("ICD10", "L01.1", "L01.1 Impetiginization of other dermatoses", "pT5vabhqe6u"),
    ("ICD10", "L02", "L02 Cutaneous abscess, furuncle and carbuncle", "olxynblKFkD"),
    ("ICD10", "L02.0", "L02.0 Cutaneous abscess, furuncle and carbuncle of face", "vn0qF41zbG7"),
    ("ICD10", "L02.1", "L02.1 Cutaneous abscess, furuncle and carbuncle of neck", "aVQ3m1bTPRX"),
    ("ICD10", "L02.2", "L02.2 Cutaneous abscess, furuncle and carbuncle of trunk", "QdYDD3REPtE"),
    ("ICD10", "L02.3", "L02.3 Cutaneous abscess, furuncle and carbuncle of buttock", "l7CZxbwMbV8"),
    ("ICD10", "L02.4", "L02.4 Cutaneous abscess, furuncle and carbuncle of limb", "zjbzjKrDAsu"),
    ("ICD10", "L02.8", "L02.8 Cutaneous abscess, furuncle and carbuncle of other sites", "bR9fVshkHAh"),
    ("ICD10", "L02.9", "L02.9 Cutaneous abscess, furuncle and carbuncle, unspecified", "IjxecfQkcDM"),
    ("ICD10", "L03", "L03 Cellulitis", "ysmTUms664Q"),
    ("ICD10", "L03.0", "L03.0 Cellulitis of finger and toe", "Jm0ryIolWlj"),
    ("ICD10", "L03.1", "L03.1 Cellulitis of other parts of limb", "ICNvhzzLMVw"),
    ("ICD10", "L03.2", "L03.2 Cellulitis of face", "HarEc00zox1"),
    ("ICD10", "L03.3", "L03.3 Cellulitis of trunk", "DSw9gNZUZiM"),
    ("ICD10", "L03.8", "L03.8 Cellulitis of other sites", "e34L87vaoC7"),
    ("ICD10", "L03.9", "L03.9 Cellulitis, unspecified", "TBBmhA75ndN"),
    ("ICD10", "L04", "L04 Acute lymphadenitis", "fT5BIlHHez2"),
    ("ICD10", "L04.0", "L04.0 Acute lymphadenitis of face, head and neck", "bAYiuwiScVT"),
    ("ICD10", "L04.1", "L04.1 Acute lymphadenitis of trunk", "XGVyxkvb0Ts"),
    ("ICD10", "L04.2", "L04.2 Acute lymphadenitis of upper limb", "fKVrLwaUTei"),
    ("ICD10", "L04.3", "L04.3 Acute lymphadenitis of lower limb", "zbS9vmIRMYT"),
    ("ICD10", "L04.8", "L04.8 Acute lymphadenitis of other sites", "WgmL3f7SwqV"),
    ("ICD10", "L04.9", "L04.9 Acute lymphadenitis, unspecified", "fYYuKdEYEK8"),
    ("ICD10", "L05", "L05 Pilonidal cyst", "mJPD0qvadZA"),
    ("ICD10", "L05.0", "L05.0 Pilonidal cyst with abscess", "ySoecEmMWWk"),
    ("ICD10", "L05.9", "L05.9 Pilonidal cyst without abscess", "M92VXefCgt2"),
    ("ICD10", "L08", "L08 Other local infections of skin and subcutaneous tissue", "g05tmMMHMfb"),
    ("ICD10", "L08.0", "L08.0 Pyoderma", "qqgOG5RFdkJ"),
    ("ICD10", "L08.1", "L08.1 Erythrasma", "LPfHePa83br"),
    ("ICD10", "L08.8", "L08.8 Other specified local infections of skin and subcutaneous tissue", "z2XZqFuuupU"),
    ("ICD10", "L08.9", "L08.9 Local infection of skin and subcutaneous tissue, unspecified", "d6TW07kZXwT"),
    ("ICD10", "L10", "L10 Pemphigus", "jRK8XNkI9Cd"),
    ("ICD10", "L10.0", "L10.0 Pemphigus vulgaris", "zPGm5p8eaIB"),
    ("ICD10", "L10.1", "L10.1 Pemphigus vegetans", "xlb2UnFtp50"),
    ("ICD10", "L10.2", "L10.2 Pemphigus foliaceus", "bsWYErTuq2g"),
    ("ICD10", "L10.3", "L10.3 Brazilian pemphigus [fogo selvagem]", "wh17guRiG9I"),
    ("ICD10", "L10.4", "L10.4 Pemphigus erythematosus", "SgrrEUMONr9"),
    ("ICD10", "L10.5", "L10.5 Drug-induced pemphigus", "aXviYilXLEz"),
    ("ICD10", "L10.8", "L10.8 Other pemphigus", "Tku8NiQ6ZLj"),
    ("ICD10", "L10.9", "L10.9 Pemphigus, unspecified", "ch7HTpZeckM"),
    ("ICD10", "L11", "L11 Other acantholytic disorders", "ROmP5hqlEN4"),
    ("ICD10", "L11.0", "L11.0 Acquired keratosis follicularis", "wtvl7tNyEC2"),
    ("ICD10", "L11.1", "L11.1 Transient acantholytic dermatosis [Grover]", "x8khzCNEfLy"),
    ("ICD10", "L11.8", "L11.8 Other specified acantholytic disorders", "eWmBIO7Zjjm"),
    ("ICD10", "L11.9", "L11.9 Acantholytic disorder, unspecified", "akMJzEcKNGU"),
    ("ICD10", "L12", "L12 Pemphigoid", "LyzorwQK9jT"),
    ("ICD10", "L12.0", "L12.0 Bullous pemphigoid", "GCHqAIi5Rol"),
    ("ICD10", "L12.1", "L12.1 Cicatricial pemphigoid", "qYr3ShrZFIr"),
    ("ICD10", "L12.2", "L12.2 Chronic bullous disease of childhood", "ZKZbbrwhbcD"),
    ("ICD10", "L12.3", "L12.3 Acquired epidermolysis bullosa", "RoTTz5bP0w5"),
    ("ICD10", "L12.8", "L12.8 Other pemphigoid", "G3oKXtlXkCM"),
    ("ICD10", "L12.9", "L12.9 Pemphigoid, unspecified", "zAyFvRY2bqM"),
    ("ICD10", "L13", "L13 Other bullous disorders", "uB7NWbBHQaY"),
    ("ICD10", "L13.0", "L13.0 Dermatitis herpetiformis", "wnqZmKRFSOl"),
    ("ICD10", "L13.1", "L13.1 Subcorneal pustular dermatitis", "VXCI3ccDu57"),
    ("ICD10", "L13.8", "L13.8 Other specified bullous disorders", "Xo4HyhdvHTQ"),
    ("ICD10", "L13.9", "L13.9 Bullous disorder, unspecified", "OUjA7GWXNMi"),
    ("ICD10", "L14", "L14 Bullous disorders in diseases classified elsewhere", "WfBWyPtxDpu"),
    ("ICD10", "L20", "L20 Atopic dermatitis", "z0i2EtHngzH"),
    ("ICD10", "L20.0", "L20.0 Besnier prurigo", "TxZgi7Dy6xP"),
    ("ICD10", "L20.8", "L20.8 Other atopic dermatitis", "ffRTAsY6itG"),
    ("ICD10", "L20.9", "L20.9 Atopic dermatitis, unspecified", "OkqVB0SSkPn"),
    ("ICD10", "L21", "L21 Seborrhoeic dermatitis", "XfxapMLvjOM"),
    ("ICD10", "L21.0", "L21.0 Seborrhoea capitis", "zyXCP8gbdsW"),
    ("ICD10", "L21.1", "L21.1 Seborrhoeic infantile dermatitis", "tV91Nd6IxQO"),
    ("ICD10", "L21.8", "L21.8 Other seborrhoeic dermatitis", "jMc9eoxqfFM"),
    ("ICD10", "L21.9", "L21.9 Seborrhoeic dermatitis, unspecified", "XnV8EOXm4QL"),
    ("ICD10", "L22", "L22 Diaper [napkin] dermatitis", "n2t4KqwOJzs"),
    ("ICD10", "L23", "L23 Allergic contact dermatitis", "UwHsSk4SPqn"),
    ("ICD10", "L23.0", "L23.0 Allergic contact dermatitis due to metals", "h0evSM4Ad5M"),
    ("ICD10", "L23.1", "L23.1 Allergic contact dermatitis due to adhesives", "CjaKd7SOkpz"),
    ("ICD10", "L23.2", "L23.2 Allergic contact dermatitis due to cosmetics", "PAjpNcjIxfV"),
    ("ICD10", "L23.3", "L23.3 Allergic contact dermatitis due to drugs in contact with skin", "eIaQqAeWsB3"),
    ("ICD10", "L23.4", "L23.4 Allergic contact dermatitis due to dyes", "IELf0CcJvr9"),
    ("ICD10", "L23.5", "L23.5 Allergic contact dermatitis due to other chemical products", "VxgXx4JhWwy"),
    ("ICD10", "L23.6", "L23.6 Allergic contact dermatitis due to food in contact with skin", "DdLUkCieoJz"),
    ("ICD10", "L23.7", "L23.7 Allergic contact dermatitis due to plants, except food", "UezFH3yzFaB"),
    ("ICD10", "L23.8", "L23.8 Allergic contact dermatitis due to other agents", "qML12wyMdxr"),
    ("ICD10", "L23.9", "L23.9 Allergic contact dermatitis, unspecified cause", "qnFLfKIwN9h"),
    ("ICD10", "L24", "L24 Irritant contact dermatitis", "hOtbc4z9PuA"),
    ("ICD10", "L24.0", "L24.0 Irritant contact dermatitis due to detergents", "vHVzr8c3uJA"),
    ("ICD10", "L24.1", "L24.1 Irritant contact dermatitis due to oils and greases", "mpMaI9Hsycm"),
    ("ICD10", "L24.2", "L24.2 Irritant contact dermatitis due to solvents", "sJXfYZZQlx8"),
    ("ICD10", "L24.3", "L24.3 Irritant contact dermatitis due to cosmetics", "rzRVpjr0HEV"),
    ("ICD10", "L24.4", "L24.4 Irritant contact dermatitis due to drugs in contact with skin", "KvxkzuWHe1t"),
    ("ICD10", "L24.5", "L24.5 Irritant contact dermatitis due to other chemical products", "LtpyKoadotZ"),
    ("ICD10", "L24.6", "L24.6 Irritant contact dermatitis due to food in contact with skin", "Dww0wXham89"),
    ("ICD10", "L24.7", "L24.7 Irritant contact dermatitis due to plants, except food", "oeKiYuG1joU"),
    ("ICD10", "L24.8", "L24.8 Irritant contact dermatitis due to other agents", "UC6bQyzWiHB"),
    ("ICD10", "L24.9", "L24.9 Irritant contact dermatitis, unspecified cause", "nCHmhA0EtSQ"),
    ("ICD10", "L25", "L25 Unspecified contact dermatitis", "zpNLr8Ggdn4"),
    ("ICD10", "L25.0", "L25.0 Unspecified contact dermatitis due to cosmetics", "g5V5FT4mzwo"),
    ("ICD10", "L25.1", "L25.1 Unspecified contact dermatitis due to drugs in contact with skin", "qiqlKfpDybb"),
    ("ICD10", "L25.2", "L25.2 Unspecified contact dermatitis due to dyes", "EBP0F6PFtdR"),
    ("ICD10", "L25.3", "L25.3 Unspecified contact dermatitis due to other chemical products", "c1mEpGzPyzN"),
    ("ICD10", "L25.4", "L25.4 Unspecified contact dermatitis due to food in contact with skin", "WwEqITADS2Y"),
    ("ICD10", "L25.5", "L25.5 Unspecified contact dermatitis due to plants, except food", "cWGs0VpVRLZ"),
    ("ICD10", "L25.8", "L25.8 Unspecified contact dermatitis due to other agents", "Ia371Xw9fNw"),
    ("ICD10", "L25.9", "L25.9 Unspecified contact dermatitis, unspecified cause", "no0tKN3dClW"),
    ("ICD10", "L26", "L26 Exfoliative dermatitis", "b00kQbe4Qpo"),
    ("ICD10", "L27", "L27 Dermatitis due to substances taken internally", "DnS1dCUUgF5"),
    ("ICD10", "L27.0", "L27.0 Generalized skin eruption due to drugs and medicaments", "pUAe9VGuEZn"),
    ("ICD10", "L27.1", "L27.1 Localized skin eruption due to drugs and medicaments", "GIIYKgIncJl"),
    ("ICD10", "L27.2", "L27.2 Dermatitis due to ingested food", "EjCZyMOR4Er"),
    ("ICD10", "L27.8", "L27.8 Dermatitis due to other substances taken internally", "UAIFXKPJ8kA"),
    ("ICD10", "L27.9", "L27.9 Dermatitis due to unspecified substance taken internally", "Zg7ENhNYVI1"),
    ("ICD10", "L28", "L28 Lichen simplex chronicus and prurigo", "dE2ZgKdyeKO"),
    ("ICD10", "L28.0", "L28.0 Lichen simplex chronicus", "t64huyW7jsS"),
    ("ICD10", "L28.1", "L28.1 Prurigo nodularis", "JGvgre4ATxH"),
    ("ICD10", "L28.2", "L28.2 Other prurigo", "wsKcY6wfUm6"),
    ("ICD10", "L29", "L29 Pruritus", "y7wzxSBMBRP"),
    ("ICD10", "L29.0", "L29.0 Pruritus ani", "RoZ03Zr9g0T"),
    ("ICD10", "L29.1", "L29.1 Pruritus scroti", "S8DpkGj8Zvf"),
    ("ICD10", "L29.2", "L29.2 Pruritus vulvae", "DeIqlGPZF0c"),
    ("ICD10", "L29.3", "L29.3 Anogenital pruritus, unspecified", "WAzD4bz9tJt"),
    ("ICD10", "L29.8", "L29.8 Other pruritus", "x6SQvG4cRAc"),
    ("ICD10", "L29.9", "L29.9 Pruritus, unspecified", "Ei6ovdgbdNg"),
    ("ICD10", "L30", "L30 Other dermatitis", "iUIhSgpn2mi"),
    ("ICD10", "L30.0", "L30.0 Nummular dermatitis", "nOhnF9Ssrtp"),
    ("ICD10", "L30.1", "L30.1 Dyshidrosis [pompholyx]", "QFCrxfVO2sa"),
    ("ICD10", "L30.2", "L30.2 Cutaneous autosensitization", "UrXBGnblKlx"),
    ("ICD10", "L30.3", "L30.3 Infective dermatitis", "bflTHRrPQdL"),
    ("ICD10", "L30.4", "L30.4 Erythema intertrigo", "Mmp74LmQZqV"),
    ("ICD10", "L30.5", "L30.5 Pityriasis alba", "tHNS9BkSMZf"),
    ("ICD10", "L30.8", "L30.8 Other specified dermatitis", "QTwdbDRd3VC"),
    ("ICD10", "L30.9", "L30.9 Dermatitis, unspecified", "B1nuuFnzm5W"),
    ("ICD10", "L40", "L40 Psoriasis", "I5kxWSMnsz2"),
    ("ICD10", "L40.0", "L40.0 Psoriasis vulgaris", "K8X1McH5joi"),
    ("ICD10", "L40.1", "L40.1 Generalized pustular psoriasis", "SQQViVEseNZ"),
    ("ICD10", "L40.2", "L40.2 Acrodermatitis continua", "RzXzval6ES7"),
    ("ICD10", "L40.3", "L40.3 Pustulosis palmaris et plantaris", "zzCrXD14dn3"),
    ("ICD10", "L40.4", "L40.4 Guttate psoriasis", "vrK7IeQcS4E"),
    ("ICD10", "L40.5", "L40.5 Arthropathic psoriasis", "ekqzmQ4uOFs"),
    ("ICD10", "L40.8", "L40.8 Other psoriasis", "fA5eRLGJpYn"),
    ("ICD10", "L40.9", "L40.9 Psoriasis, unspecified", "XJVHMQUfUrC"),
    ("ICD10", "L41", "L41 Parapsoriasis", "YJ3wiSeP2jb"),
    ("ICD10", "L41.0", "L41.0 Pityriasis lichenoides et varioliformis acuta", "IBxaVzKhqbs"),
    ("ICD10", "L41.1", "L41.1 Pityriasis lichenoides chronica", "pLPmH22kkeN"),
    ("ICD10", "L41.3", "L41.3 Small plaque parapsoriasis", "tP9AOIB3YIh"),
    ("ICD10", "L41.4", "L41.4 Large plaque parapsoriasis", "dUaegzZdVlT"),
    ("ICD10", "L41.5", "L41.5 Retiform parapsoriasis", "QD2IvkmY6uB"),
    ("ICD10", "L41.8", "L41.8 Other parapsoriasis", "M36RTui1vep"),
    ("ICD10", "L41.9", "L41.9 Parapsoriasis, unspecified", "V9CFYsd8k2a"),
    ("ICD10", "L42", "L42 Pityriasis rosea", "iQUJXuKRWUP"),
    ("ICD10", "L43", "L43 Lichen planus", "XEU1qLOwjWK"),
    ("ICD10", "L43.0", "L43.0 Hypertrophic lichen planus", "bDoPgOvOzkJ"),
    ("ICD10", "L43.1", "L43.1 Bullous lichen planus", "mjmWhZlNf77"),
    ("ICD10", "L43.2", "L43.2 Lichenoid drug reaction", "ltybWqyuyxG"),
    ("ICD10", "L43.3", "L43.3 Subacute (active) lichen planus", "vWkSUvNSlIt"),
    ("ICD10", "L43.8", "L43.8 Other lichen planus", "NZWG7nGR0z6"),
    ("ICD10", "L43.9", "L43.9 Lichen planus, unspecified", "sdYkS3pjHwg"),
    ("ICD10", "L44", "L44 Other papulosquamous disorders", "c1uszLxDgqt"),
    ("ICD10", "L44.0", "L44.0 Pityriasis rubra pilaris", "ELtopc9Lcis"),
    ("ICD10", "L44.1", "L44.1 Lichen nitidus", "ilhC6hTGTrX"),
    ("ICD10", "L44.2", "L44.2 Lichen striatus", "zjez1eK1kVo"),
    ("ICD10", "L44.3", "L44.3 Lichen ruber moniliformis", "f4V6vAY0tVl"),
    ("ICD10", "L44.4", "L44.4 Infantile papular acrodermatitis [Giannotti-Crosti]", "pdwN5AnO5wZ"),
    ("ICD10", "L44.8", "L44.8 Other specified papulosquamous disorders", "uf56UCbI9AK"),
    ("ICD10", "L44.9", "L44.9 Papulosquamous disorder, unspecified", "zfyh8Mkduz9"),
    ("ICD10", "L45", "L45 Papulosquamous disorders in diseases classified elsewhere", "QRYVuk40RVD"),
    ("ICD10", "L50", "L50 Urticaria", "W5ExB9orzf3"),
    ("ICD10", "L50.0", "L50.0 Allergic urticaria", "XBry9JHcz5W"),
    ("ICD10", "L50.1", "L50.1 Idiopathic urticaria", "OndZnYNBwfU"),
    ("ICD10", "L50.2", "L50.2 Urticaria due to cold and heat", "aCuP0Z0U020"),
    ("ICD10", "L50.3", "L50.3 Dermatographic urticaria", "c6EJaYnEy3I"),
    ("ICD10", "L50.4", "L50.4 Vibratory urticaria", "PxA7oXcd9k5"),
    ("ICD10", "L50.5", "L50.5 Cholinergic urticaria", "b4oXHbpOihg"),
    ("ICD10", "L50.6", "L50.6 Contact urticaria", "vYpF8TP12Rw"),
    ("ICD10", "L50.8", "L50.8 Other urticaria", "B2r23TJEMJg"),
    ("ICD10", "L50.9", "L50.9 Urticaria, unspecified", "QwSl7qI1SaT"),
    ("ICD10", "L51", "L51 Erythema multiforme", "ABG289wvaMV"),
    ("ICD10", "L51.0", "L51.0 Nonbullous erythema multiforme", "vq29b7zpgcs"),
    ("ICD10", "L51.1", "L51.1 Bullous erythema multiforme", "KOwN3SAV4j1"),
    ("ICD10", "L51.2", "L51.2 Toxic epidermal necrolysis [Lyell]", "x15uABExpIu"),
    ("ICD10", "L51.8", "L51.8 Other erythema multiforme", "vNnuqEF8fnw"),
    ("ICD10", "L51.9", "L51.9 Erythema multiforme, unspecified", "X0fD6jc1D1s"),
    ("ICD10", "L52", "L52 Erythema nodosum", "DR8M3f6xmuD"),
    ("ICD10", "L53", "L53 Other erythematous conditions", "lVxeVT6peha"),
    ("ICD10", "L53.0", "L53.0 Toxic erythema", "x1QMWX0IxgI"),
    ("ICD10", "L53.1", "L53.1 Erythema annulare centrifugum", "yzrb8maSw6t"),
    ("ICD10", "L53.2", "L53.2 Erythema marginatum", "QwLL0YCNXWE"),
    ("ICD10", "L53.3", "L53.3 Other chronic figurate erythema", "ttjMenqWCmz"),
    ("ICD10", "L53.8", "L53.8 Other specified erythematous conditions", "C5T6EhZrJEK"),
    ("ICD10", "L53.9", "L53.9 Erythematous condition, unspecified", "kcfb13Lw8d5"),
    ("ICD10", "L54", "L54 Erythema in diseases classified elsewhere", "RSS0UxeP6GE"),
    ("ICD10", "L54.0", "L54.0 Erythema marginatum in acute rheumatic fever", "MR12tbXCp92"),
    ("ICD10", "L54.8", "L54.8 Erythema in other diseases classified elsewhere", "K4UhGiNiZ0z"),
    ("ICD10", "L55", "L55 Sunburn", "fpcyYoCqCxs"),
    ("ICD10", "L55.0", "L55.0 Sunburn of first degree", "O66EY32r3GM"),
    ("ICD10", "L55.1", "L55.1 Sunburn of second degree", "FV1PqGbwIJS"),
    ("ICD10", "L55.2", "L55.2 Sunburn of third degree", "prS7LmYOZQ4"),
    ("ICD10", "L55.8", "L55.8 Other sunburn", "TTJJslbtEGf"),
    ("ICD10", "L55.9", "L55.9 Sunburn, unspecified", "K4QEybk8IXP"),
    ("ICD10", "L56", "L56 Other acute skin changes due to ultraviolet radiation", "KaNEmOfzv90"),
    ("ICD10", "L56.0", "L56.0 Drug phototoxic response", "B4UbxHHoDhg"),
    ("ICD10", "L56.1", "L56.1 Drug photoallergic response", "WGd2z5DMoNp"),
    ("ICD10", "L56.2", "L56.2 Photocontact dermatitis [berloque dermatitis]", "tRnUyFDWPES"),
    ("ICD10", "L56.3", "L56.3 Solar urticaria", "xWidio7LlDx"),
    ("ICD10", "L56.4", "L56.4 Polymorphous light eruption", "BnWjuXa535I"),
    ("ICD10", "L56.8", "L56.8 Other specified acute skin changes due to ultraviolet radiation", "LYNgj4oKx5w"),
    ("ICD10", "L56.9", "L56.9 Acute skin change due to ultraviolet radiation, unspecified", "FnRUIg04u1Q"),
    ("ICD10", "L57", "L57 Skin changes due to chronic exposure to nonionizing radiation", "GNC5QxlguNC"),
    ("ICD10", "L57.0", "L57.0 Actinic keratosis", "gdJiHEaCKUi");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "L57.1", "L57.1 Actinic reticuloid", "wQcPFOrvcn9"),
    ("ICD10", "L57.2", "L57.2 Cutis rhomboidalis nuchae", "mmDlnNznAuG"),
    ("ICD10", "L57.3", "L57.3 Poikiloderma of Civatte", "PtqpAvrC4L9"),
    ("ICD10", "L57.4", "L57.4 Cutis laxa senilis", "NLFqnUc0o7p"),
    ("ICD10", "L57.5", "L57.5 Actinic granuloma", "IEm6SYg66oZ"),
    ("ICD10", "L57.8", "L57.8 Other skin changes due to chronic exposure to nonionizing radiation", "gWMYw93C0XJ"),
    ("ICD10", "L57.9", "L57.9 Skin changes due to chronic exposure to nonionizing radiation, unspecified", "dUYqqCGP78q"),
    ("ICD10", "L58", "L58 Radiodermatitis", "m9pfmJsJMlZ"),
    ("ICD10", "L58.0", "L58.0 Acute radiodermatitis", "RKUhuNLOqie"),
    ("ICD10", "L58.1", "L58.1 Chronic radiodermatitis", "fjQtBUXdikm"),
    ("ICD10", "L58.9", "L58.9 Radiodermatitis, unspecified", "ehb5ur7vkVW"),
    ("ICD10", "L59", "L59 Other disorders of skin and subcutaneous tissue related to radiation", "jdJcIMq9HLb"),
    ("ICD10", "L59.0", "L59.0 Erythema ab igne [dermatitis ab igne]", "B4tZVRmNOto"),
    ("ICD10", "L59.8", "L59.8 Other specified disorders of skin and subcutaneous tissue related to radiation", "SJBvFXV39YV"),
    ("ICD10", "L59.9", "L59.9 Disorder of skin and subcutaneous tissue related to radiation, unspecified", "dqbSyvTrga1"),
    ("ICD10", "L60", "L60 Nail disorders", "b6wLBDccEki"),
    ("ICD10", "L60.0", "L60.0 Ingrowing nail", "AYF9F9YEGrM"),
    ("ICD10", "L60.1", "L60.1 Onycholysis", "jUTReeksO1s"),
    ("ICD10", "L60.2", "L60.2 Onychogryphosis", "ji4uc18ut00"),
    ("ICD10", "L60.3", "L60.3 Nail dystrophy", "snCICHSRfUv"),
    ("ICD10", "L60.4", "L60.4 Beau lines", "UamsUT4SAcE"),
    ("ICD10", "L60.5", "L60.5 Yellow nail syndrome", "BBHe3Wpkx4W"),
    ("ICD10", "L60.8", "L60.8 Other nail disorders", "JkZSA8Oscwv"),
    ("ICD10", "L60.9", "L60.9 Nail disorder, unspecified", "VfJDXndBGbw"),
    ("ICD10", "L62", "L62 Nail disorders in diseases classified elsewhere", "MzlSpslL31C"),
    ("ICD10", "L62.0", "L62.0 Clubbed nail pachydermoperiostosis", "KCdBW6yXVO6"),
    ("ICD10", "L62.8", "L62.8 Nail disorders in other diseases classified elsewhere", "MWePpW6YcEp"),
    ("ICD10", "L63", "L63 Alopecia areata", "lMYck784DRF"),
    ("ICD10", "L63.0", "L63.0 Alopecia (capitis) totalis", "Mr9Yr2Pvzpe"),
    ("ICD10", "L63.1", "L63.1 Alopecia universalis", "rKPolO8qaVu"),
    ("ICD10", "L63.2", "L63.2 Ophiasis", "pNOlOcWiIXo"),
    ("ICD10", "L63.8", "L63.8 Other alopecia areata", "rksIa49j4Mz"),
    ("ICD10", "L63.9", "L63.9 Alopecia areata, unspecified", "ic8qQHZZJed"),
    ("ICD10", "L64", "L64 Androgenic alopecia", "CZCdyUC1PMP"),
    ("ICD10", "L64.0", "L64.0 Drug-induced androgenic alopecia", "V22Gj0QoL2d"),
    ("ICD10", "L64.8", "L64.8 Other androgenic alopecia", "ylg1MqfUh5X"),
    ("ICD10", "L64.9", "L64.9 Androgenic alopecia, unspecified", "mkvCA0Aml8F"),
    ("ICD10", "L65", "L65 Other nonscarring hair loss", "TrhFwwqZ2fw"),
    ("ICD10", "L65.0", "L65.0 Telogen effluvium", "Kq57uHCwjhj"),
    ("ICD10", "L65.1", "L65.1 Anagen effluvium", "A0bGnA5ICkT"),
    ("ICD10", "L65.2", "L65.2 Alopecia mucinosa", "IcwaAsZMkji"),
    ("ICD10", "L65.8", "L65.8 Other specified nonscarring hair loss", "WnBnQWwR6T2"),
    ("ICD10", "L65.9", "L65.9 Nonscarring hair loss, unspecified", "XBXWX630MJM"),
    ("ICD10", "L66", "L66 Cicatricial alopecia [scarring hair loss]", "HSRTa4aQnSD"),
    ("ICD10", "L66.0", "L66.0 Pseudopelade", "iJx68MivRlN"),
    ("ICD10", "L66.1", "L66.1 Lichen planopilaris", "HEwVpvdWPBo"),
    ("ICD10", "L66.2", "L66.2 Folliculitis decalvans", "ArzglyvWL51"),
    ("ICD10", "L66.3", "L66.3 Perifolliculitis capitis abscedens", "J6TtvFQUZZS"),
    ("ICD10", "L66.4", "L66.4 Folliculitis ulerythematosa reticulata", "BZYnpdUWXJl"),
    ("ICD10", "L66.8", "L66.8 Other cicatricial alopecia", "fjNNxQP9xcW"),
    ("ICD10", "L66.9", "L66.9 Cicatricial alopecia, unspecified", "G1Ll7nZu26X"),
    ("ICD10", "L67", "L67 Hair colour and hair shaft abnormalities", "GQpC3Rkkx9y"),
    ("ICD10", "L67.0", "L67.0 Trichorrhexis nodosa", "gQkfGWflNUo"),
    ("ICD10", "L67.1", "L67.1 Variations in hair colour", "GTfVQxWasZM"),
    ("ICD10", "L67.8", "L67.8 Other hair colour and hair shaft abnormalities", "yGpbYmYni1W"),
    ("ICD10", "L67.9", "L67.9 Hair colour and hair shaft abnormality, unspecified", "pIT8FKvtIzv"),
    ("ICD10", "L68", "L68 Hypertrichosis", "Jwzr0xfwmdm"),
    ("ICD10", "L68.0", "L68.0 Hirsutism", "mGlxMb43vkO"),
    ("ICD10", "L68.1", "L68.1 Acquired hypertrichosis lanuginosa", "UidHsS9I2tT"),
    ("ICD10", "L68.2", "L68.2 Localized hypertrichosis", "VLLtFDH092o"),
    ("ICD10", "L68.3", "L68.3 Polytrichia", "idUjA6pgz1o"),
    ("ICD10", "L68.8", "L68.8 Other hypertrichosis", "UHtiZtkEIf8"),
    ("ICD10", "L68.9", "L68.9 Hypertrichosis, unspecified", "Xk0cn6yjFtP"),
    ("ICD10", "L70", "L70 Acne", "Z6IDoT1w4bW"),
    ("ICD10", "L70.0", "L70.0 Acne vulgaris", "JhaEzspU7VB"),
    ("ICD10", "L70.1", "L70.1 Acne conglobata", "fBkUgthjPR9"),
    ("ICD10", "L70.2", "L70.2 Acne varioliformis", "D2Bs7sKfu8M"),
    ("ICD10", "L70.3", "L70.3 Acne tropica", "JgcfSnHfize"),
    ("ICD10", "L70.4", "L70.4 Infantile acne", "nrip5Ti1jKi"),
    ("ICD10", "L70.5", "L70.5 Acné excoriée", "gfzu7EBnylq"),
    ("ICD10", "L70.8", "L70.8 Other acne", "PsDDmwj9qJV"),
    ("ICD10", "L70.9", "L70.9 Acne, unspecified", "hna1Ta5DZrn"),
    ("ICD10", "L71", "L71 Rosacea", "yYGf7JWeleu"),
    ("ICD10", "L71.0", "L71.0 Perioral dermatitis", "fMHJyLXa2cs"),
    ("ICD10", "L71.1", "L71.1 Rhinophyma", "vm45xK0ge8E"),
    ("ICD10", "L71.8", "L71.8 Other rosacea", "SoLIszXu0OU"),
    ("ICD10", "L71.9", "L71.9 Rosacea, unspecified", "SQzBL21iahM"),
    ("ICD10", "L72", "L72 Follicular cysts of skin and subcutaneous tissue", "jyBdx7X2n9W"),
    ("ICD10", "L72.0", "L72.0 Epidermal cyst", "IP92yqtFwpG"),
    ("ICD10", "L72.1", "L72.1 Trichilemmal cyst", "PByXOzW3W7V"),
    ("ICD10", "L72.2", "L72.2 Steatocystoma multiplex", "m97V5KJGSdG"),
    ("ICD10", "L72.8", "L72.8 Other follicular cysts of skin and subcutaneous tissue", "wKhlXz0ol5a"),
    ("ICD10", "L72.9", "L72.9 Follicular cyst of skin and subcutaneous tissue, unspecified", "uYJgnPPG6mt"),
    ("ICD10", "L73", "L73 Other follicular disorders", "iWbzIUFMWva"),
    ("ICD10", "L73.0", "L73.0 Acne keloid", "Xfjzd1isIMd"),
    ("ICD10", "L73.1", "L73.1 Pseudofolliculitis barbae", "cPxmqQwSe7N"),
    ("ICD10", "L73.2", "L73.2 Hidradenitis suppurativa", "P62kPXXZu9x"),
    ("ICD10", "L73.8", "L73.8 Other specified follicular disorders", "rFsejOKympU"),
    ("ICD10", "L73.9", "L73.9 Follicular disorder, unspecified", "nbpt34ntVze"),
    ("ICD10", "L74", "L74 Eccrine sweat disorders", "frEXbYtfnrq"),
    ("ICD10", "L74.0", "L74.0 Miliaria rubra", "kSqLbaWLKng"),
    ("ICD10", "L74.1", "L74.1 Miliaria crystallina", "XSzcG7RjzeF"),
    ("ICD10", "L74.2", "L74.2 Miliaria profunda", "wHxGxGoK4oy"),
    ("ICD10", "L74.3", "L74.3 Miliaria, unspecified", "u0dYa57Fvjc"),
    ("ICD10", "L74.4", "L74.4 Anhidrosis", "zeQ4AyNzt3w"),
    ("ICD10", "L74.8", "L74.8 Other eccrine sweat disorders", "GkXwGUWiAZC"),
    ("ICD10", "L74.9", "L74.9 Eccrine sweat disorder, unspecified", "ICP7GoSUL6R"),
    ("ICD10", "L75", "L75 Apocrine sweat disorders", "eePlYYdGM6t"),
    ("ICD10", "L75.0", "L75.0 Bromhidrosis", "jTr4FpDuK0g"),
    ("ICD10", "L75.1", "L75.1 Chromhidrosis", "jpldtt7nDBC"),
    ("ICD10", "L75.2", "L75.2 Apocrine miliaria", "kGdWKd4Ga3k"),
    ("ICD10", "L75.8", "L75.8 Other apocrine sweat disorders", "o6OI7b2XwHy"),
    ("ICD10", "L75.9", "L75.9 Apocrine sweat disorder, unspecified", "TgraVKeO1sc"),
    ("ICD10", "L80", "L80 Vitiligo", "yU3EJgOHVaG"),
    ("ICD10", "L81", "L81 Other disorders of pigmentation", "e4yQTgVEWcK"),
    ("ICD10", "L81.0", "L81.0 Postinflammatory hyperpigmentation", "uEe09hGPzzS"),
    ("ICD10", "L81.1", "L81.1 Chloasma", "DGc2xkdU1UZ"),
    ("ICD10", "L81.2", "L81.2 Freckles", "zxP6wMvkbtj"),
    ("ICD10", "L81.3", "L81.3 Café au lait spots", "FTx3g80mDZc"),
    ("ICD10", "L81.4", "L81.4 Other melanin hyperpigmentation", "Z5NZnuSuGHZ"),
    ("ICD10", "L81.5", "L81.5 Leukoderma, not elsewhere classified", "bQIHKFeYEz9"),
    ("ICD10", "L81.6", "L81.6 Other disorders of diminished melanin formation", "m3tnyQVo8mC"),
    ("ICD10", "L81.7", "L81.7 Pigmented purpuric dermatosis", "pgNgRuHCAPi"),
    ("ICD10", "L81.8", "L81.8 Other specified disorders of pigmentation", "m8r30Gq7NhC"),
    ("ICD10", "L81.9", "L81.9 Disorder of pigmentation, unspecified", "QiKRxGZ1mF6"),
    ("ICD10", "L82", "L82 Seborrhoeic keratosis", "GNaYqN7I2JM"),
    ("ICD10", "L83", "L83 Acanthosis nigricans", "imktkOeXCou"),
    ("ICD10", "L84", "L84 Corns and callosities", "dbxY6aJguEG"),
    ("ICD10", "L85", "L85 Other epidermal thickening", "uzdMdlfMVRi"),
    ("ICD10", "L85.0", "L85.0 Acquired ichthyosis", "C2OwtQ8JDCO"),
    ("ICD10", "L85.1", "L85.1 Acquired keratosis [keratoderma] palmaris et plantaris", "FTS9OaQkGde"),
    ("ICD10", "L85.2", "L85.2 Keratosis punctata (palmaris et plantaris)", "QWSJrxHZH2p"),
    ("ICD10", "L85.3", "L85.3 Xerosis cutis", "ipb69EYbkzK"),
    ("ICD10", "L85.8", "L85.8 Other specified epidermal thickening", "l6uQXR2TSZn"),
    ("ICD10", "L85.9", "L85.9 Epidermal thickening, unspecified", "gHOJk8EXFTO"),
    ("ICD10", "L86", "L86 Keratoderma in diseases classified elsewhere", "IOwyZ3c5ilm"),
    ("ICD10", "L87", "L87 Transepidermal elimination disorders", "pKEoQTiSQ90"),
    ("ICD10", "L87.0", "L87.0 Keratosis follicularis et parafollicularis in cutem penetrans [Kyrle]", "WraL7dgAtLv"),
    ("ICD10", "L87.1", "L87.1 Reactive perforating collagenosis", "lnsDrOHWIJH"),
    ("ICD10", "L87.2", "L87.2 Elastosis perforans serpiginosa", "G00oQJTfytI"),
    ("ICD10", "L87.8", "L87.8 Other transepidermal elimination disorders", "P1Ty0BkkOW8"),
    ("ICD10", "L87.9", "L87.9 Transepidermal elimination disorder, unspecified", "J0XvvTJdMvD"),
    ("ICD10", "L88", "L88 Pyoderma gangrenosum", "ON4KRbeItmN"),
    ("ICD10", "L89", "L89 Decubitus ulcer and pressure area", "wvP1yksiMy8"),
    ("ICD10", "L89.0", "L89.0 Stage I decubitus ulcer and pressure area", "ktSCFVQWIqE"),
    ("ICD10", "L89.1", "L89.1 Stage II decubitus ulcer", "lQNskBaRfBW"),
    ("ICD10", "L89.2", "L89.2 Stage III decubitus ulcer", "tZM0lYGyISu"),
    ("ICD10", "L89.3", "L89.3 Stage IV decubitus ulcer", "QZRNBcMkeMC"),
    ("ICD10", "L89.9", "L89.9 Decubitus ulcer and pressure area, unspecified", "FzBzkcBrTDy"),
    ("ICD10", "L90", "L90 Atrophic disorders of skin", "bmloDNbDeVs"),
    ("ICD10", "L90.0", "L90.0 Lichen sclerosus et atrophicus", "FutsJm8oeRk"),
    ("ICD10", "L90.1", "L90.1 Anetoderma of Schweninger-Buzzi", "GQx3zqEFPFw"),
    ("ICD10", "L90.2", "L90.2 Anetoderma of Jadassohn-Pellizzari", "U5DeYmqtIND"),
    ("ICD10", "L90.3", "L90.3 Atrophoderma of Pasini and Pierini", "lgBPyGcoCSE"),
    ("ICD10", "L90.4", "L90.4 Acrodermatitis chronica atrophicans", "Zrz0ZLay40T"),
    ("ICD10", "L90.5", "L90.5 Scar conditions and fibrosis of skin", "PoQG2UHNz2g"),
    ("ICD10", "L90.6", "L90.6 Striae atrophicae", "Pd5R804WWvs"),
    ("ICD10", "L90.8", "L90.8 Other atrophic disorders of skin", "JUYqrkrkm7D"),
    ("ICD10", "L90.9", "L90.9 Atrophic disorder of skin, unspecified", "Y7LJd5tUeKb"),
    ("ICD10", "L91", "L91 Hypertrophic disorders of skin", "icBtnvkkwrd"),
    ("ICD10", "L91.0", "L91.0 Hypertrophic scar", "qJlAGEITqxv"),
    ("ICD10", "L91.8", "L91.8 Other hypertrophic disorders of skin", "pnDcAqQGNud"),
    ("ICD10", "L91.9", "L91.9 Hypertrophic disorder of skin, unspecified", "nBPKAqh5md6"),
    ("ICD10", "L92", "L92 Granulomatous disorders of skin and subcutaneous tissue", "QXy2odSPByi"),
    ("ICD10", "L92.0", "L92.0 Granuloma annulare", "UXzWmtrn8nn"),
    ("ICD10", "L92.1", "L92.1 Necrobiosis lipoidica, not elsewhere classified", "PmAixc3ujnS"),
    ("ICD10", "L92.2", "L92.2 Granuloma faciale [eosinophilic granuloma of skin]", "AEbXMUhv21o"),
    ("ICD10", "L92.3", "L92.3 Foreign body granuloma of skin and subcutaneous tissue", "sreZ4huF6V2"),
    ("ICD10", "L92.8", "L92.8 Other granulomatous disorders of skin and subcutaneous tissue", "LAgQuxYTbU7"),
    ("ICD10", "L92.9", "L92.9 Granulomatous disorder of skin and subcutaneous tissue, unspecified", "U5zWRyMqyge"),
    ("ICD10", "L93", "L93 Lupus erythematosus", "n9rJgaGEnDX"),
    ("ICD10", "L93.0", "L93.0 Discoid lupus erythematosus", "b7Z2U4aow6G"),
    ("ICD10", "L93.1", "L93.1 Subacute cutaneous lupus erythematosus", "uCadG3fz36m"),
    ("ICD10", "L93.2", "L93.2 Other local lupus erythematosus", "q8oTgmOGOLf"),
    ("ICD10", "L94", "L94 Other localized connective tissue disorders", "HqlzMSXeTd2"),
    ("ICD10", "L94.0", "L94.0 Localized scleroderma [morphea]", "HZuxLhYNuAX"),
    ("ICD10", "L94.1", "L94.1 Linear scleroderma", "OXiX8yqg4UE"),
    ("ICD10", "L94.2", "L94.2 Calcinosis cutis", "getV4JtHxxM"),
    ("ICD10", "L94.3", "L94.3 Sclerodactyly", "Bz9BVSJBlWy"),
    ("ICD10", "L94.4", "L94.4 Gottron papules", "L8I62E2LwVt"),
    ("ICD10", "L94.5", "L94.5 Poikiloderma vasculare atrophicans", "lzpba6IKQRx"),
    ("ICD10", "L94.6", "L94.6 Ainhum", "YeKJtomVUTa"),
    ("ICD10", "L94.8", "L94.8 Other specified localized connective tissue disorders", "daAbozx0Atw"),
    ("ICD10", "L94.9", "L94.9 Localized connective tissue disorder, unspecified", "G5pL7UMHsyz"),
    ("ICD10", "L95", "L95 Vasculitis limited to skin, not elsewhere classified", "QymD6hzrTs3"),
    ("ICD10", "L95.0", "L95.0 Livedoid vasculitis", "Zy9pnGTfmRc"),
    ("ICD10", "L95.1", "L95.1 Erythema elevatum diutinum", "x8IoQj5nyps"),
    ("ICD10", "L95.8", "L95.8 Other vasculitis limited to skin", "eTkeEauoRkJ"),
    ("ICD10", "L95.9", "L95.9 Vasculitis limited to skin, unspecified", "zYeOPcBDPhh"),
    ("ICD10", "L97", "L97 Ulcer of lower limb, not elsewhere classified", "jHdoKkJ8AbF"),
    ("ICD10", "L98", "L98 Other disorders of skin and subcutaneous tissue, not elsewhere classified", "uO1y1oh3moO"),
    ("ICD10", "L98.0", "L98.0 Pyogenic granuloma", "ChWdxFKFuPh"),
    ("ICD10", "L98.1", "L98.1 Factitial dermatitis", "BrcygM8ky85"),
    ("ICD10", "L98.2", "L98.2 Febrile neutrophilic dermatosis [Sweet]", "vZyRdzeNaOF"),
    ("ICD10", "L98.3", "L98.3 Eosinophilic cellulitis [Wells]", "okg6HHviLJ5"),
    ("ICD10", "L98.4", "L98.4 Chronic ulcer of skin, not elsewhere classified", "bnNLVrPnqzk"),
    ("ICD10", "L98.5", "L98.5 Mucinosis of skin", "dRvl8FvXrFP"),
    ("ICD10", "L98.6", "L98.6 Other infiltrative disorders of skin and subcutaneous tissue", "uPlGdkbEYdO"),
    ("ICD10", "L98.7", "L98.7 Excessive and redundant skin and subcutaneous tissue", "s49RVHHkyVI"),
    ("ICD10", "L98.8", "L98.8 Other specified disorders of skin and subcutaneous tissue", "pL8wwkvnAEl"),
    ("ICD10", "L98.9", "L98.9 Disorder of skin and subcutaneous tissue, unspecified", "G80VWcyaFOp"),
    ("ICD10", "L99", "L99 Other disorders of skin and subcutaneous tissue in diseases classified elsewhere", "dFws854JQq8"),
    ("ICD10", "L99.0", "L99.0 Amyloidosis of skin", "o6mpFk1OXpp"),
    ("ICD10", "L99.8", "L99.8 Other specified disorders of skin and subcutaneous tissue in diseases classified elsewhere", "uAMeCtCyd7q");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "M00", "M00 Pyogenic arthritis", "lqRLcQmRO5a"),
    ("ICD10", "M00.0", "M00.0 Staphylococcal arthritis and polyarthritis", "Zk6wClnHgka"),
    ("ICD10", "M00.1", "M00.1 Pneumococcal arthritis and polyarthritis", "iV4AUjPVCcX"),
    ("ICD10", "M00.2", "M00.2 Other streptococcal arthritis and polyarthritis", "skZiq8F7wDO"),
    ("ICD10", "M00.8", "M00.8 Arthritis and polyarthritis due to other specified bacterial agents", "S9uqQyhPB9f"),
    ("ICD10", "M00.9", "M00.9 Pyogenic arthritis, unspecified", "SzH6XGJRn0T"),
    ("ICD10", "M01", "M01 Direct infections of joint in infectious and parasitic diseases classified elsewhere", "ZLg0ZZOyOIg"),
    ("ICD10", "M01.0", "M01.0 Meningococcal arthritis", "p21U058NJkt"),
    ("ICD10", "M01.1", "M01.1 Tuberculous arthritis", "NgDN4ySAC5G"),
    ("ICD10", "M01.2", "M01.2 Arthritis in Lyme disease", "Ws17ReCEtAd"),
    ("ICD10", "M01.3", "M01.3 Arthritis in other bacterial diseases classified elsewhere", "HN83TXEUESq"),
    ("ICD10", "M01.4", "M01.4 Rubella arthritis", "B7GdZDZIYmT"),
    ("ICD10", "M01.5", "M01.5 Arthritis in other viral diseases classified elsewhere", "MtnZF8jXMe3"),
    ("ICD10", "M01.6", "M01.6 Arthritis in mycoses", "vIbkIZdSkPF"),
    ("ICD10", "M01.8", "M01.8 Arthritis in other infectious and parasitic diseases classified elsewhere", "zWU94v4KXfr"),
    ("ICD10", "M02", "M02 Reactive arthropathies", "w3mvhqjaG08"),
    ("ICD10", "M02.0", "M02.0 Arthropathy following intestinal bypass", "HAfSb68Z2wP"),
    ("ICD10", "M02.1", "M02.1 Postdysenteric arthropathy", "SV60iBG1mzw"),
    ("ICD10", "M02.2", "M02.2 Postimmunization arthropathy", "qdc26PNQ1bh"),
    ("ICD10", "M02.3", "M02.3 Reiter disease", "Hmr7gLECZcS"),
    ("ICD10", "M02.8", "M02.8 Other reactive arthropathies", "CSrny32o6PV"),
    ("ICD10", "M02.9", "M02.9 Reactive arthropathy, unspecified", "Q9MhtuN6LJn"),
    ("ICD10", "M03", "M03 Postinfective and reactive arthropathies in diseases classified elsewhere", "lbH2jnzMFCL"),
    ("ICD10", "M03.0", "M03.0 Postmeningococcal arthritis", "hLd1tid5anc"),
    ("ICD10", "M03.1", "M03.1 Postinfective arthropathy in syphilis", "ijYRLzeJhwP"),
    ("ICD10", "M03.2", "M03.2 Other postinfectious arthropathies in diseases classified elsewhere", "RthYBvW4NUG"),
    ("ICD10", "M03.6", "M03.6 Reactive arthropathy in other diseases classified elsewhere", "oGbvojjLNgM"),
    ("ICD10", "M05", "M05 Seropositive rheumatoid arthritis", "EFZK0QzZlAc"),
    ("ICD10", "M05.0", "M05.0 Felty syndrome", "aamFc1pxy3Y"),
    ("ICD10", "M05.1", "M05.1 Rheumatoid lung disease", "cZzYqZ6XjxP"),
    ("ICD10", "M05.2", "M05.2 Rheumatoid vasculitis", "l89CiQCDXy8"),
    ("ICD10", "M05.3", "M05.3 Rheumatoid arthritis with involvement of other organs and systems", "UVhfISsy8mL"),
    ("ICD10", "M05.8", "M05.8 Other seropositive rheumatoid arthritis", "CZVHCNCEClK"),
    ("ICD10", "M05.9", "M05.9 Seropositive rheumatoid arthritis, unspecified", "vBgeJDG6ZOY"),
    ("ICD10", "M06", "M06 Other rheumatoid arthritis", "vTglJyvSR05"),
    ("ICD10", "M06.0", "M06.0 Seronegative rheumatoid arthritis", "UQLhoWsAIDQ"),
    ("ICD10", "M06.1", "M06.1 Adult-onset Still disease", "G8BLJQeuNJv"),
    ("ICD10", "M06.2", "M06.2 Rheumatoid bursitis", "Ca34JeCvFUB"),
    ("ICD10", "M06.3", "M06.3 Rheumatoid nodule", "dkhU49AlDh9"),
    ("ICD10", "M06.4", "M06.4 Inflammatory polyarthropathy", "Mk9jbskzVmh"),
    ("ICD10", "M06.8", "M06.8 Other specified rheumatoid arthritis", "VnLXLQHWbN0"),
    ("ICD10", "M06.9", "M06.9 Rheumatoid arthritis, unspecified", "iI2SQAOJ4TS"),
    ("ICD10", "M07", "M07 Psoriatic and enteropathic arthropathies", "Vu7dcIOa5X3"),
    ("ICD10", "M07.0", "M07.0 Distal interphalangeal psoriatic arthropathy", "PDn0Lk5U8gO"),
    ("ICD10", "M07.1", "M07.1 Arthritis mutilans", "wB7C9WVzfRd"),
    ("ICD10", "M07.2", "M07.2 Psoriatic spondylitis", "dLcI4G4tQud"),
    ("ICD10", "M07.3", "M07.3 Other psoriatic arthropathies", "kjuMGzKOLFA"),
    ("ICD10", "M07.4", "M07.4 Arthropathy in Crohn disease [regional enteritis]", "J3sKaVDH3xg"),
    ("ICD10", "M07.5", "M07.5 Arthropathy in ulcerative colitis", "e5zX9UBKQqF"),
    ("ICD10", "M07.6", "M07.6 Other enteropathic arthropathies", "YFq2ZnDFCHC"),
    ("ICD10", "M08", "M08 Juvenile arthritis", "zCvoLmzmi2w"),
    ("ICD10", "M08.0", "M08.0 Juvenile rheumatoid arthritis", "f7VMrIelZrA"),
    ("ICD10", "M08.1", "M08.1 Juvenile ankylosing spondylitis", "NA9gMzO6lAo"),
    ("ICD10", "M08.2", "M08.2 Juvenile arthritis with systemic onset", "rA6MpgQTlNQ"),
    ("ICD10", "M08.3", "M08.3 Juvenile polyarthritis (seronegative)", "pXBTVwmbWkh"),
    ("ICD10", "M08.4", "M08.4 Pauciarticular juvenile arthritis", "XZvyCYmqgtM"),
    ("ICD10", "M08.8", "M08.8 Other juvenile arthritis", "lUrD8rCG1iT"),
    ("ICD10", "M08.9", "M08.9 Juvenile arthritis, unspecified", "La4LIDPtgcr"),
    ("ICD10", "M09", "M09 Juvenile arthritis in diseases classified elsewhere", "skdomxpA7iE"),
    ("ICD10", "M09.0", "M09.0 Juvenile arthritis in psoriasis", "czPB1JDQzeY"),
    ("ICD10", "M09.1", "M09.1 Juvenile arthritis in Crohn disease [regional enteritis]", "UnsCrNjU006"),
    ("ICD10", "M09.2", "M09.2 Juvenile arthritis in ulcerative colitis", "idz160nnckY"),
    ("ICD10", "M09.8", "M09.8 Juvenile arthritis in other diseases classified elsewhere", "ngfWCpZEJ9H"),
    ("ICD10", "M10", "M10 Gout", "fPCrts8xFW2"),
    ("ICD10", "M10.0", "M10.0 Idiopathic gout", "evsJWBRMrCo"),
    ("ICD10", "M10.1", "M10.1 Lead-induced gout", "v1nTaXCoEyO"),
    ("ICD10", "M10.2", "M10.2 Drug-induced gout", "iDgHbcw94ax"),
    ("ICD10", "M10.3", "M10.3 Gout due to impairment of renal function", "bDmtjmvxSqA"),
    ("ICD10", "M10.4", "M10.4 Other secondary gout", "HkDlRaIlIpl"),
    ("ICD10", "M10.9", "M10.9 Gout, unspecified", "vFbxa7s3YJ3"),
    ("ICD10", "M11", "M11 Other crystal arthropathies", "in3URl33nYp"),
    ("ICD10", "M11.0", "M11.0 Hydroxyapatite deposition disease", "C1oKyz5sIhu"),
    ("ICD10", "M11.1", "M11.1 Familial chondrocalcinosis", "L1K1ddhuBqC"),
    ("ICD10", "M11.2", "M11.2 Other chondrocalcinosis", "Egb6RBgcVUe"),
    ("ICD10", "M11.8", "M11.8 Other specified crystal arthropathies", "jG6Dqu0WcJm"),
    ("ICD10", "M11.9", "M11.9 Crystal arthropathy, unspecified", "AnaWzq4Wwwl"),
    ("ICD10", "M12", "M12 Other specific arthropathies", "PRdzP63jqjn"),
    ("ICD10", "M12.0", "M12.0 Chronic postrheumatic arthropathy [Jaccoud]", "ho86qPOxcoM"),
    ("ICD10", "M12.1", "M12.1 Kaschin-Beck disease", "wNJOzFxW2Ga"),
    ("ICD10", "M12.2", "M12.2 Villonodular synovitis (pigmented)", "wOHLNBchU13"),
    ("ICD10", "M12.3", "M12.3 Palindromic rheumatism", "hiLdWiDSFZq"),
    ("ICD10", "M12.4", "M12.4 Intermittent hydrarthrosis", "cYsGpxOT6QJ"),
    ("ICD10", "M12.5", "M12.5 Traumatic arthropathy", "FrFc2VWD4sy"),
    ("ICD10", "M12.8", "M12.8 Other specific arthropathies, not elsewhere classified", "Q7AxAEUIhh1"),
    ("ICD10", "M13", "M13 Other arthritis", "NRq22NAgg15"),
    ("ICD10", "M13.0", "M13.0 Polyarthritis, unspecified", "UnDNDNCggI8"),
    ("ICD10", "M13.1", "M13.1 Monoarthritis, not elsewhere classified", "d01fbOJ8B2N"),
    ("ICD10", "M13.8", "M13.8 Other specified arthritis", "MnhzkEOMZb6"),
    ("ICD10", "M13.9", "M13.9 Arthritis, unspecified", "S4ky341QTwA"),
    ("ICD10", "M14", "M14 Arthropathies in other diseases classified elsewhere", "jJYWja69Vty"),
    ("ICD10", "M14.0", "M14.0 Gouty arthropathy due to enzyme defects and other inherited disorders", "mNOW00OhhD6"),
    ("ICD10", "M14.1", "M14.1 Crystal arthropathy in other metabolic disorders", "siFXRS12zDB"),
    ("ICD10", "M14.2", "M14.2 Diabetic arthropathy", "y64jL0TNMYb"),
    ("ICD10", "M14.3", "M14.3 Lipoid dermatoarthritis", "oJYBCoGrQdv"),
    ("ICD10", "M14.4", "M14.4 Arthropathy in amyloidosis", "JdLXvrkWiM2"),
    ("ICD10", "M14.5", "M14.5 Arthropathies in other endocrine, nutritional and metabolic disorders", "FWW8vYleE8c"),
    ("ICD10", "M14.6", "M14.6 Neuropathic arthropathy", "KEX3wW60zWS"),
    ("ICD10", "M14.8", "M14.8 Arthropathies in other specified diseases classified elsewhere", "ZcEXdl4Xhbi"),
    ("ICD10", "M15", "M15 Polyarthrosis", "mdRdCcVzCBy"),
    ("ICD10", "M15.0", "M15.0 Primary generalized (osteo)arthrosis", "SbKslPBmeNn"),
    ("ICD10", "M15.1", "M15.1 Heberden nodes (with arthropathy)", "JnkXN29nyIJ"),
    ("ICD10", "M15.2", "M15.2 Bouchard nodes (with arthropathy)", "OPtHazcJTY9"),
    ("ICD10", "M15.3", "M15.3 Secondary multiple arthrosis", "A90pCoXgrRO"),
    ("ICD10", "M15.4", "M15.4 Erosive (osteo)arthrosis", "Cs88xnPtmLm"),
    ("ICD10", "M15.8", "M15.8 Other polyarthrosis", "CaHhCYrFueR"),
    ("ICD10", "M15.9", "M15.9 Polyarthrosis, unspecified", "pcTMZGQCyxr"),
    ("ICD10", "M16", "M16 Coxarthrosis [arthrosis of hip]", "D9XANsiPEk3"),
    ("ICD10", "M16.0", "M16.0 Primary coxarthrosis, bilateral", "UKLHboC25E6"),
    ("ICD10", "M16.1", "M16.1 Other primary coxarthrosis", "sXKb3yv8z3Q"),
    ("ICD10", "M16.2", "M16.2 Coxarthrosis resulting from dysplasia, bilateral", "ZXWtD71danY"),
    ("ICD10", "M16.3", "M16.3 Other dysplastic coxarthrosis", "Gcf18bySV68"),
    ("ICD10", "M16.4", "M16.4 Post-traumatic coxarthrosis, bilateral", "NUD0Hz8SCaB"),
    ("ICD10", "M16.5", "M16.5 Other post-traumatic coxarthrosis", "xdj4Kd9X6oC"),
    ("ICD10", "M16.6", "M16.6 Other secondary coxarthrosis, bilateral", "McYPlIeHzOy"),
    ("ICD10", "M16.7", "M16.7 Other secondary coxarthrosis", "Hw3kRXO4po2"),
    ("ICD10", "M16.9", "M16.9 Coxarthrosis, unspecified", "vtQrDMsKB6H"),
    ("ICD10", "M17", "M17 Gonarthrosis [arthrosis of knee]", "IFlO7n0BeSU"),
    ("ICD10", "M17.0", "M17.0 Primary gonarthrosis, bilateral", "eSqzR6lEdlq"),
    ("ICD10", "M17.1", "M17.1 Other primary gonarthrosis", "SslbZr9obON"),
    ("ICD10", "M17.2", "M17.2 Post-traumatic gonarthrosis, bilateral", "do0nfshLB09"),
    ("ICD10", "M17.3", "M17.3 Other post-traumatic gonarthrosis", "ARhfLtHraRZ"),
    ("ICD10", "M17.4", "M17.4 Other secondary gonarthrosis, bilateral", "YgnNj6QjvYY"),
    ("ICD10", "M17.5", "M17.5 Other secondary gonarthrosis", "tiXSXODw49a"),
    ("ICD10", "M17.9", "M17.9 Gonarthrosis, unspecified", "VWpKoJeANIz"),
    ("ICD10", "M18", "M18 Arthrosis of first carpometacarpal joint", "kh8ywclKm61"),
    ("ICD10", "M18.0", "M18.0 Primary arthrosis of first carpometacarpal joints, bilateral", "cFPo7UjmyuO"),
    ("ICD10", "M18.1", "M18.1 Other primary arthrosis of first carpometacarpal joint", "aqwGQf0DeYk"),
    ("ICD10", "M18.2", "M18.2 Post-traumatic arthrosis of first carpometacarpal joints, bilateral", "lxLFlzEpUni"),
    ("ICD10", "M18.3", "M18.3 Other post-traumatic arthrosis of first carpometacarpal joint", "HD56hINOfp1"),
    ("ICD10", "M18.4", "M18.4 Other secondary arthrosis of first carpometacarpal joints, bilateral", "uVmjAuTw2RE"),
    ("ICD10", "M18.5", "M18.5 Other secondary arthrosis of first carpometacarpal joint", "ETZT3mUXC4G"),
    ("ICD10", "M18.9", "M18.9 Arthrosis of first carpometacarpal joint, unspecified", "dOvdc2Cwx59"),
    ("ICD10", "M19", "M19 Other arthrosis", "TPQinuDmyqP"),
    ("ICD10", "M19.0", "M19.0 Primary arthrosis of other joints", "FzMeNiIQ6ZA"),
    ("ICD10", "M19.1", "M19.1 Post-traumatic arthrosis of other joints", "YpsIb5nWX0r"),
    ("ICD10", "M19.2", "M19.2 Other secondary arthrosis", "syXTJ2lO5da"),
    ("ICD10", "M19.8", "M19.8 Other specified arthrosis", "CqmZT7a86rP"),
    ("ICD10", "M19.9", "M19.9 Arthrosis, unspecified", "c3mGktBefrH"),
    ("ICD10", "M20", "M20 Acquired deformities of fingers and toes", "s09T1tFboMM"),
    ("ICD10", "M20.0", "M20.0 Deformity of finger(s)", "gQy85KhKg5C"),
    ("ICD10", "M20.1", "M20.1 Hallux valgus (acquired)", "SxQHyTrouRc"),
    ("ICD10", "M20.2", "M20.2 Hallux rigidus", "mXB6ZwzOYUI"),
    ("ICD10", "M20.3", "M20.3 Other deformity of hallux (acquired)", "HzsYMtMgs6R"),
    ("ICD10", "M20.4", "M20.4 Other hammer toe(s) (acquired)", "CiC2Il0AuQb"),
    ("ICD10", "M20.5", "M20.5 Other deformities of toe(s) (acquired)", "ztF7upRroUV"),
    ("ICD10", "M20.6", "M20.6 Acquired deformity of toe(s), unspecified", "PdMWRdgQj0L"),
    ("ICD10", "M21", "M21 Other acquired deformities of limbs", "lul0zABiBax"),
    ("ICD10", "M21.0", "M21.0 Valgus deformity, not elsewhere classified", "cigA5lR4NJ9"),
    ("ICD10", "M21.1", "M21.1 Varus deformity, not elsewhere classified", "smWebdvnSB9"),
    ("ICD10", "M21.2", "M21.2 Flexion deformity", "Lp89obwyEdf"),
    ("ICD10", "M21.3", "M21.3 Wrist or foot drop (acquired)", "N1uO51d61bx"),
    ("ICD10", "M21.4", "M21.4 Flat foot [pes planus] (acquired)", "G2TZBLhn26W"),
    ("ICD10", "M21.5", "M21.5 Acquired clawhand, clubhand, clawfoot and clubfoot", "cglwWB0cz3V"),
    ("ICD10", "M21.6", "M21.6 Other acquired deformities of ankle and foot", "RdvzjSE27xS"),
    ("ICD10", "M21.7", "M21.7 Unequal limb length (acquired)", "MzrDnn2cqY9"),
    ("ICD10", "M21.8", "M21.8 Other specified acquired deformities of limbs", "qG7NQGC18HG"),
    ("ICD10", "M21.9", "M21.9 Acquired deformity of limb, unspecified", "udmcbzkDUcc"),
    ("ICD10", "M22", "M22 Disorders of patella", "lVO7jVrwM7P"),
    ("ICD10", "M22.0", "M22.0 Recurrent dislocation of patella", "G9YoRVFgYRU"),
    ("ICD10", "M22.1", "M22.1 Recurrent subluxation of patella", "wYccaJd1UVz"),
    ("ICD10", "M22.2", "M22.2 Patellofemoral disorders", "AItHfuFB9iR"),
    ("ICD10", "M22.3", "M22.3 Other derangements of patella", "tcKp7rhE6u6"),
    ("ICD10", "M22.4", "M22.4 Chondromalacia patellae", "ZHDIhvgg4U9"),
    ("ICD10", "M22.8", "M22.8 Other disorders of patella", "U6poKHMcN6v"),
    ("ICD10", "M22.9", "M22.9 Disorder of patella, unspecified", "Wm3NijXaxpV"),
    ("ICD10", "M23", "M23 Internal derangement of knee", "HXVIO4rUcEy"),
    ("ICD10", "M23.0", "M23.0 Cystic meniscus", "LH3vFeuS3LH"),
    ("ICD10", "M23.1", "M23.1 Discoid meniscus (congenital)", "vYOm1oirVv1"),
    ("ICD10", "M23.2", "M23.2 Derangement of meniscus due to old tear or injury", "pWKhPrHkY2k"),
    ("ICD10", "M23.3", "M23.3 Other meniscus derangements", "ZJF2ktiESf2"),
    ("ICD10", "M23.4", "M23.4 Loose body in knee", "z0VdG3Jbqgg"),
    ("ICD10", "M23.5", "M23.5 Chronic instability of knee", "ktnUxAA6OpR"),
    ("ICD10", "M23.6", "M23.6 Other spontaneous disruption of ligament(s) of knee", "w2rcMqevhGs"),
    ("ICD10", "M23.8", "M23.8 Other internal derangements of knee", "iT03rUCf7Xb"),
    ("ICD10", "M23.9", "M23.9 Internal derangement of knee, unspecified", "L4QvRaghHFj"),
    ("ICD10", "M24", "M24 Other specific joint derangements", "HlRJ70mQkcI"),
    ("ICD10", "M24.0", "M24.0 Loose body in joint", "S6lZzG7XCyj"),
    ("ICD10", "M24.1", "M24.1 Other articular cartilage disorders", "xZY9ZwDOSFR"),
    ("ICD10", "M24.2", "M24.2 Disorder of ligament", "UY9UnLiT7Bb"),
    ("ICD10", "M24.3", "M24.3 Pathological dislocation and subluxation of joint, not elsewhere classified", "AqdmMdx5oXx"),
    ("ICD10", "M24.4", "M24.4 Recurrent dislocation and subluxation of joint", "fVet0gKveJQ"),
    ("ICD10", "M24.5", "M24.5 Contracture of joint", "FHw1g5ovUf9"),
    ("ICD10", "M24.6", "M24.6 Ankylosis of joint", "Z7olhsWUl5h"),
    ("ICD10", "M24.7", "M24.7 Protrusio acetabuli", "Syt5BMS4ZI1"),
    ("ICD10", "M24.8", "M24.8 Other specific joint derangements, not elsewhere classified", "H6CjAAC8XXb"),
    ("ICD10", "M24.9", "M24.9 Joint derangement, unspecified", "CHTnK8z1hvf"),
    ("ICD10", "M25", "M25 Other joint disorders, not elsewhere classified", "NaD1bE7Ycfk"),
    ("ICD10", "M25.0", "M25.0 Haemarthrosis", "LrRZCWC0fiJ"),
    ("ICD10", "M25.1", "M25.1 Fistula of joint", "CjrNWjqlIki"),
    ("ICD10", "M25.2", "M25.2 Flail joint", "adYUBNCICvH"),
    ("ICD10", "M25.3", "M25.3 Other instability of joint", "yeC2cHryvAt"),
    ("ICD10", "M25.4", "M25.4 Effusion of joint", "tFkSI2QuwZl"),
    ("ICD10", "M25.5", "M25.5 Pain in joint", "liUOdtm0Lru"),
    ("ICD10", "M25.6", "M25.6 Stiffness of joint, not elsewhere classified", "ZyXcfhYYZfe"),
    ("ICD10", "M25.7", "M25.7 Osteophyte", "kNAujEKK0Mv"),
    ("ICD10", "M25.8", "M25.8 Other specified joint disorders", "Xh9UIj4GnZf"),
    ("ICD10", "M25.9", "M25.9 Joint disorder, unspecified", "aOh10eu82wM"),
    ("ICD10", "M30", "M30 Polyarteritis nodosa and related conditions", "fIgIwzDjGc1"),
    ("ICD10", "M30.0", "M30.0 Polyarteritis nodosa", "ip7AFanlBAW"),
    ("ICD10", "M30.1", "M30.1 Polyarteritis with lung involvement [Churg-Strauss]", "PPCF6xR72Dd"),
    ("ICD10", "M30.2", "M30.2 Juvenile polyarteritis", "P5En9CdxbbG"),
    ("ICD10", "M30.3", "M30.3 Mucocutaneous lymph node syndrome [Kawasaki]", "Fzn449WjMer"),
    ("ICD10", "M30.8", "M30.8 Other conditions related to polyarteritis nodosa", "f4JqDfvjO2l"),
    ("ICD10", "M31", "M31 Other necrotizing vasculopathies", "CHRhkwn6Tt0"),
    ("ICD10", "M31.0", "M31.0 Hypersensitivity angiitis", "wLPQ1MhVN6Q"),
    ("ICD10", "M31.1", "M31.1 Thrombotic microangiopathy", "RdIzXtjpiwA"),
    ("ICD10", "M31.2", "M31.2 Lethal midline granuloma", "NxdJuxPoRe2"),
    ("ICD10", "M31.3", "M31.3 Wegener granulomatosis", "xdqy7ZOFqxE"),
    ("ICD10", "M31.4", "M31.4 Aortic arch syndrome [Takayasu]", "AU6hZnsaCD9"),
    ("ICD10", "M31.5", "M31.5 Giant cell arteritis with polymyalgia rheumatica", "LaJoBtuaRBr"),
    ("ICD10", "M31.6", "M31.6 Other giant cell arteritis", "p55jDvjm3pz"),
    ("ICD10", "M31.7", "M31.7 Microscopic polyangiitis", "jqQKRI3crWc"),
    ("ICD10", "M31.8", "M31.8 Other specified necrotizing vasculopathies", "dZwHkBnR8bR"),
    ("ICD10", "M31.9", "M31.9 Necrotizing vasculopathy, unspecified", "z49exAIb0WX"),
    ("ICD10", "M32", "M32 Systemic lupus erythematosus", "FPwQLBkGYic"),
    ("ICD10", "M32.0", "M32.0 Drug-induced systemic lupus erythematosus", "Nqg6qCy7PnQ"),
    ("ICD10", "M32.1", "M32.1 Systemic lupus erythematosus with organ or system involvement", "cW5Cp06ZXQ9"),
    ("ICD10", "M32.8", "M32.8 Other forms of systemic lupus erythematosus", "e5mktFEEAwd"),
    ("ICD10", "M32.9", "M32.9 Systemic lupus erythematosus, unspecified", "Knx1M2okHSh"),
    ("ICD10", "M33", "M33 Dermatopolymyositis", "JCjADdcLmmO"),
    ("ICD10", "M33.0", "M33.0 Juvenile dermatomyositis", "aY7fDmgiet5"),
    ("ICD10", "M33.1", "M33.1 Other dermatomyositis", "D7hxWM70i1x"),
    ("ICD10", "M33.2", "M33.2 Polymyositis", "RtipqfF27rG"),
    ("ICD10", "M33.9", "M33.9 Dermatopolymyositis, unspecified", "cUmU46qHwDr"),
    ("ICD10", "M34", "M34 Systemic sclerosis", "KfwEhyH39Cb"),
    ("ICD10", "M34.0", "M34.0 Progressive systemic sclerosis", "LdbscNORxt7"),
    ("ICD10", "M34.1", "M34.1 CR(E)ST syndrome", "Lxjsiye5S3X"),
    ("ICD10", "M34.2", "M34.2 Systemic sclerosis induced by drugs and chemicals", "FfdNiI967eC"),
    ("ICD10", "M34.8", "M34.8 Other forms of systemic sclerosis", "WfgWNPAjjbh"),
    ("ICD10", "M34.9", "M34.9 Systemic sclerosis, unspecified", "u2fck7mh2KE"),
    ("ICD10", "M35", "M35 Other systemic involvement of connective tissue", "SBgxKBnjOmE"),
    ("ICD10", "M35.0", "M35.0 Sicca syndrome [Sjögren]", "yPtIa4vc1Zy"),
    ("ICD10", "M35.1", "M35.1 Other overlap syndromes", "AD3X4uQPftY"),
    ("ICD10", "M35.2", "M35.2 Behçet disease", "WdXFdxg0eP1"),
    ("ICD10", "M35.3", "M35.3 Polymyalgia rheumatica", "hybGnZF6eJW"),
    ("ICD10", "M35.4", "M35.4 Diffuse (eosinophilic) fasciitis", "e5QbPH4rc6z"),
    ("ICD10", "M35.5", "M35.5 Multifocal fibrosclerosis", "Idx7Gtl6Wgz"),
    ("ICD10", "M35.6", "M35.6 Relapsing panniculitis [Weber-Christian]", "M24H0HxWuLN"),
    ("ICD10", "M35.7", "M35.7 Hypermobility syndrome", "m814VtvEFmc"),
    ("ICD10", "M35.8", "M35.8 Other specified systemic involvement of connective tissue", "k4DUJcsnddb"),
    ("ICD10", "M35.9", "M35.9 Systemic involvement of connective tissue, unspecified", "H4c3La30FDV"),
    ("ICD10", "M36", "M36 Systemic disorders of connective tissue in diseases classified elsewhere", "ONeHYVVwJEF"),
    ("ICD10", "M36.0", "M36.0 Dermato(poly)myositis in neoplastic disease", "FlrZK0GnPR7"),
    ("ICD10", "M36.1", "M36.1 Arthropathy in neoplastic disease", "Xu8xDqrgHBs"),
    ("ICD10", "M36.2", "M36.2 Haemophilic arthropathy", "QgDmeCF5t3W"),
    ("ICD10", "M36.3", "M36.3 Arthropathy in other blood disorders", "cWlUerQc8Hw"),
    ("ICD10", "M36.4", "M36.4 Arthropathy in hypersensitivity reactions classified elsewhere", "TvNZ5f0Cn8b"),
    ("ICD10", "M36.8", "M36.8 Systemic disorders of connective tissue in other diseases classified elsewhere", "noHoiG1ltir"),
    ("ICD10", "M40", "M40 Kyphosis and lordosis", "PskLOeDnJ7D"),
    ("ICD10", "M40.0", "M40.0 Postural kyphosis", "WHvTCVB4iB6"),
    ("ICD10", "M40.1", "M40.1 Other secondary kyphosis", "XPZfQgS0LiM"),
    ("ICD10", "M40.2", "M40.2 Other and unspecified kyphosis", "cT1o2jWROrw"),
    ("ICD10", "M40.3", "M40.3 Flatback syndrome", "O7dYhkTrzSD"),
    ("ICD10", "M40.4", "M40.4 Other lordosis", "wWkUVMb9jRf"),
    ("ICD10", "M40.5", "M40.5 Lordosis, unspecified", "a8WDfKy0YgD"),
    ("ICD10", "M41", "M41 Scoliosis", "PF871xnid5b"),
    ("ICD10", "M41.0", "M41.0 Infantile idiopathic scoliosis", "NKWshQBWwCU"),
    ("ICD10", "M41.1", "M41.1 Juvenile idiopathic scoliosis", "M7HHREaBCbu"),
    ("ICD10", "M41.2", "M41.2 Other idiopathic scoliosis", "KgsmCMxCkwf"),
    ("ICD10", "M41.3", "M41.3 Thoracogenic scoliosis", "CkErycWEW0O"),
    ("ICD10", "M41.4", "M41.4 Neuromuscular scoliosis", "vfBBCoVLrnm"),
    ("ICD10", "M41.5", "M41.5 Other secondary scoliosis", "QNpNYAXJH0b"),
    ("ICD10", "M41.8", "M41.8 Other forms of scoliosis", "vWVcpjt8HXL"),
    ("ICD10", "M41.9", "M41.9 Scoliosis, unspecified", "s5FmTqZRPqz"),
    ("ICD10", "M42", "M42 Spinal osteochondrosis", "sywghpWAmHK"),
    ("ICD10", "M42.0", "M42.0 Juvenile osteochondrosis of spine", "CDZEy9itL0Z"),
    ("ICD10", "M42.1", "M42.1 Adult osteochondrosis of spine", "oVTJVGnpktp"),
    ("ICD10", "M42.9", "M42.9 Spinal osteochondrosis, unspecified", "izP2c8fHdHi"),
    ("ICD10", "M43", "M43 Other deforming dorsopathies", "YAgVOaeTykJ"),
    ("ICD10", "M43.0", "M43.0 Spondylolysis", "tlAEO99FHTK"),
    ("ICD10", "M43.1", "M43.1 Spondylolisthesis", "q0m4Ny5CLjq"),
    ("ICD10", "M43.2", "M43.2 Other fusion of spine", "oAF1rSRcdAa"),
    ("ICD10", "M43.3", "M43.3 Recurrent atlantoaxial subluxation with myelopathy", "AS9KV1re7SM"),
    ("ICD10", "M43.4", "M43.4 Other recurrent atlantoaxial subluxation", "AavjnVCTlh0"),
    ("ICD10", "M43.5", "M43.5 Other recurrent vertebral subluxation", "S7ensG8CeJn"),
    ("ICD10", "M43.6", "M43.6 Torticollis", "OMOLmbX6n6m"),
    ("ICD10", "M43.8", "M43.8 Other specified deforming dorsopathies", "xwy15neu8mx"),
    ("ICD10", "M43.9", "M43.9 Deforming dorsopathy, unspecified", "w8iAeWVXLFi"),
    ("ICD10", "M45", "M45 Ankylosing spondylitis", "cro6m2BWNsr"),
    ("ICD10", "M46", "M46 Other inflammatory spondylopathies", "jOf7TtlKvqM"),
    ("ICD10", "M46.0", "M46.0 Spinal enthesopathy", "bCVx8munYLL"),
    ("ICD10", "M46.1", "M46.1 Sacroiliitis, not elsewhere classified", "KWixbbvrIAA"),
    ("ICD10", "M46.2", "M46.2 Osteomyelitis of vertebra", "yQQsCGxzGUb"),
    ("ICD10", "M46.3", "M46.3 Infection of intervertebral disc (pyogenic)", "VB9ePaguYLZ"),
    ("ICD10", "M46.4", "M46.4 Discitis, unspecified", "zCQ0NEiM9D0"),
    ("ICD10", "M46.5", "M46.5 Other infective spondylopathies", "sDIc7CLFs3o"),
    ("ICD10", "M46.8", "M46.8 Other specified inflammatory spondylopathies", "q5Vkskmera1"),
    ("ICD10", "M46.9", "M46.9 Inflammatory spondylopathy, unspecified", "R97c6W49pRK"),
    ("ICD10", "M47", "M47 Spondylosis", "CcfPKI4MvqQ"),
    ("ICD10", "M47.0", "M47.0 Anterior spinal and vertebral artery compression syndromes", "LM3S3uA6EwJ"),
    ("ICD10", "M47.1", "M47.1 Other spondylosis with myelopathy", "wPy5lVONGDd"),
    ("ICD10", "M47.2", "M47.2 Other spondylosis with radiculopathy", "IBJOGTU7e3e"),
    ("ICD10", "M47.8", "M47.8 Other spondylosis", "kHVhnRx5F6f"),
    ("ICD10", "M47.9", "M47.9 Spondylosis, unspecified", "p1KdbGbMDR5");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "M48", "M48 Other spondylopathies", "OorPTZbxpys"),
    ("ICD10", "M48.0", "M48.0 Spinal stenosis", "ja32I5gcCsk"),
    ("ICD10", "M48.1", "M48.1 Ankylosing hyperostosis [Forestier]", "acSv1dBbtyc"),
    ("ICD10", "M48.2", "M48.2 Kissing spine", "e3DchcRyhhj"),
    ("ICD10", "M48.3", "M48.3 Traumatic spondylopathy", "aEl7H8HSG92"),
    ("ICD10", "M48.4", "M48.4 Fatigue fracture of vertebra", "NLK7ZydegJI"),
    ("ICD10", "M48.5", "M48.5 Collapsed vertebra, not elsewhere classified", "yFiyMlWwoYF"),
    ("ICD10", "M48.8", "M48.8 Other specified spondylopathies", "z9hj0AKL7Ts"),
    ("ICD10", "M48.9", "M48.9 Spondylopathy, unspecified", "swUPYoEC1YI"),
    ("ICD10", "M49", "M49 Spondylopathies in diseases classified elsewhere", "YxrvK7TQXwc"),
    ("ICD10", "M49.0", "M49.0 Tuberculosis of spine", "SfXB5Ujp9TN"),
    ("ICD10", "M49.1", "M49.1 Brucella spondylitis", "llMJvVXQ2tb"),
    ("ICD10", "M49.2", "M49.2 Enterobacterial spondylitis", "t0yEGaqg1Vj"),
    ("ICD10", "M49.3", "M49.3 Spondylopathy in other infectious and parasitic diseases classified elsewhere", "wm72x6sPjgk"),
    ("ICD10", "M49.4", "M49.4 Neuropathic spondylopathy", "dLebluNtjQH"),
    ("ICD10", "M49.5", "M49.5 Collapsed vertebra in diseases classified elsewhere", "Lzw4cBbGMVC"),
    ("ICD10", "M49.8", "M49.8 Spondylopathy in other diseases classified elsewhere", "e3GI9P7GD4R"),
    ("ICD10", "M50", "M50 Cervical disc disorders", "OgHdFznwiVb"),
    ("ICD10", "M50.0", "M50.0 Cervical disc disorder with myelopathy", "vyEXwvEf81f"),
    ("ICD10", "M50.1", "M50.1 Cervical disc disorder with radiculopathy", "u5imcf240M2"),
    ("ICD10", "M50.2", "M50.2 Other cervical disc displacement", "e0jXTsQLQOL"),
    ("ICD10", "M50.3", "M50.3 Other cervical disc degeneration", "vgZ7GIDd7SR"),
    ("ICD10", "M50.8", "M50.8 Other cervical disc disorders", "ONKLukFuJrz"),
    ("ICD10", "M50.9", "M50.9 Cervical disc disorder, unspecified", "lZOIDvb4Cdj"),
    ("ICD10", "M51", "M51 Other intervertebral disc disorders", "xRDIH1IQfPz"),
    ("ICD10", "M51.0", "M51.0 Lumbar and other intervertebral disc disorders with myelopathy", "rigMBtBVny6"),
    ("ICD10", "M51.1", "M51.1 Lumbar and other intervertebral disc disorders with radiculopathy", "eJ1M88q4E4t"),
    ("ICD10", "M51.2", "M51.2 Other specified intervertebral disc displacement", "ziOxFXaU5VG"),
    ("ICD10", "M51.3", "M51.3 Other specified intervertebral disc degeneration", "H4SGiWtVOBx"),
    ("ICD10", "M51.4", "M51.4 Schmorl nodes", "vHVVvypPGLl"),
    ("ICD10", "M51.8", "M51.8 Other specified intervertebral disc disorders", "PiY7C0FGQ33"),
    ("ICD10", "M51.9", "M51.9 Intervertebral disc disorder, unspecified", "P5PsMwOpmZc"),
    ("ICD10", "M53", "M53 Other dorsopathies, not elsewhere classified", "iEL988BDlIw"),
    ("ICD10", "M53.0", "M53.0 Cervicocranial syndrome", "dlkvDy5Gdzs"),
    ("ICD10", "M53.1", "M53.1 Cervicobrachial syndrome", "jA8w408dr1f"),
    ("ICD10", "M53.2", "M53.2 Spinal instabilities", "jEVNspQPfqM"),
    ("ICD10", "M53.3", "M53.3 Sacrococcygeal disorders, not elsewhere classified", "p5jLFc8wjg9"),
    ("ICD10", "M53.8", "M53.8 Other specified dorsopathies", "XeVTEiMJ1UW"),
    ("ICD10", "M53.9", "M53.9 Dorsopathy, unspecified", "NTrtxLFja6U"),
    ("ICD10", "M54", "M54 Dorsalgia", "zo74I0iakAv"),
    ("ICD10", "M54.0", "M54.0 Panniculitis affecting regions of neck and back", "isjyyA4GkRk"),
    ("ICD10", "M54.1", "M54.1 Radiculopathy", "QbiiTUsTRMx"),
    ("ICD10", "M54.2", "M54.2 Cervicalgia", "WweWtKvzzHB"),
    ("ICD10", "M54.3", "M54.3 Sciatica", "kKgsxCiN9JQ"),
    ("ICD10", "M54.4", "M54.4 Lumbago with sciatica", "nUCyHzg41F3"),
    ("ICD10", "M54.5", "M54.5 Low back pain", "aCJd5auxw4V"),
    ("ICD10", "M54.6", "M54.6 Pain in thoracic spine", "fSNXrN5ZSuI"),
    ("ICD10", "M54.8", "M54.8 Other dorsalgia", "dpSsWBbIsPL"),
    ("ICD10", "M54.9", "M54.9 Dorsalgia, unspecified", "DNrZUDVdsK9"),
    ("ICD10", "M60", "M60 Myositis", "cKrWLf8t0Ua"),
    ("ICD10", "M60.0", "M60.0 Infective myositis", "GWPWLtx6p2a"),
    ("ICD10", "M60.1", "M60.1 Interstitial myositis", "bltXQocnZGF"),
    ("ICD10", "M60.2", "M60.2 Foreign body granuloma of soft tissue, not elsewhere classified", "blwTeHXaFb1"),
    ("ICD10", "M60.8", "M60.8 Other myositis", "lK0d60CE5L3"),
    ("ICD10", "M60.9", "M60.9 Myositis, unspecified", "kqzB6a4VilZ"),
    ("ICD10", "M61", "M61 Calcification and ossification of muscle", "O5FcA2WC4nJ"),
    ("ICD10", "M61.0", "M61.0 Myositis ossificans traumatica", "HmuaIpaR7RX"),
    ("ICD10", "M61.1", "M61.1 Myositis ossificans progressiva", "KLTkfsACSjX"),
    ("ICD10", "M61.2", "M61.2 Paralytic calcification and ossification of muscle", "qqACdC0ZpBE"),
    ("ICD10", "M61.3", "M61.3 Calcification and ossification of muscles associated with burns", "oqGaguObiCW"),
    ("ICD10", "M61.4", "M61.4 Other calcification of muscle", "bPJ4NoaHNYb"),
    ("ICD10", "M61.5", "M61.5 Other ossification of muscle", "O88PcPQACbS"),
    ("ICD10", "M61.9", "M61.9 Calcification and ossification of muscle, unspecified", "m9XZwcDwFVf"),
    ("ICD10", "M62", "M62 Other disorders of muscle", "lDcv6WT0ZjY"),
    ("ICD10", "M62.0", "M62.0 Diastasis of muscle", "HIBxSzMCisQ"),
    ("ICD10", "M62.1", "M62.1 Other rupture of muscle (nontraumatic)", "gqzk4OQzgjR"),
    ("ICD10", "M62.2", "M62.2 Ischaemic infarction of muscle", "iqfGUVNKE2C"),
    ("ICD10", "M62.3", "M62.3 Immobility syndrome (paraplegic)", "inNfoYTYbhE"),
    ("ICD10", "M62.4", "M62.4 Contracture of muscle", "gDZylkZYbie"),
    ("ICD10", "M62.5", "M62.5 Muscle wasting and atrophy, not elsewhere classified", "HVGOnmeXABA"),
    ("ICD10", "M62.6", "M62.6 Muscle strain", "Sk0sJEXaQaP"),
    ("ICD10", "M62.8", "M62.8 Other specified disorders of muscle", "Nf6tiKrzhXQ"),
    ("ICD10", "M62.9", "M62.9 Disorder of muscle, unspecified", "GKSdgOG5slT"),
    ("ICD10", "M63", "M63 Disorders of muscle in diseases classified elsewhere", "n8xpoWDoz0S"),
    ("ICD10", "M63.0", "M63.0 Myositis in bacterial diseases classified elsewhere", "It71Q68iVjQ"),
    ("ICD10", "M63.1", "M63.1 Myositis in protozoal and parasitic infections classified elsewhere", "GGS0ceWgJj5"),
    ("ICD10", "M63.2", "M63.2 Myositis in other infectious diseases classified elsewhere", "A2XkAT0JNUc"),
    ("ICD10", "M63.3", "M63.3 Myositis in sarcoidosis", "mfVxsrmjD8y"),
    ("ICD10", "M63.8", "M63.8 Other disorders of muscle in diseases classified elsewhere", "biJGoU8XRA0"),
    ("ICD10", "M65", "M65 Synovitis and tenosynovitis", "LfAwhXyqDtE"),
    ("ICD10", "M65.0", "M65.0 Abscess of tendon sheath", "HX8AQydQjaV"),
    ("ICD10", "M65.1", "M65.1 Other infective (teno)synovitis", "sheqSq6dsbO"),
    ("ICD10", "M65.2", "M65.2 Calcific tendinitis", "vucBdkugmF9"),
    ("ICD10", "M65.3", "M65.3 Trigger finger", "gSqiy95g4Fu"),
    ("ICD10", "M65.4", "M65.4 Radial styloid tenosynovitis [de Quervain]", "oGPUq2fYXqn"),
    ("ICD10", "M65.8", "M65.8 Other synovitis and tenosynovitis", "IG7N6MDOY7Q"),
    ("ICD10", "M65.9", "M65.9 Synovitis and tenosynovitis, unspecified", "EyJ6aBrMzU4"),
    ("ICD10", "M66", "M66 Spontaneous rupture of synovium and tendon", "y9bCuIfbqTf"),
    ("ICD10", "M66.0", "M66.0 Rupture of popliteal cyst", "xlOJMkzE13f"),
    ("ICD10", "M66.1", "M66.1 Rupture of synovium", "FER0D3OdFkS"),
    ("ICD10", "M66.2", "M66.2 Spontaneous rupture of extensor tendons", "riy7couYvoS"),
    ("ICD10", "M66.3", "M66.3 Spontaneous rupture of flexor tendons", "IiivZN3NcEb"),
    ("ICD10", "M66.4", "M66.4 Spontaneous rupture of other tendons", "dU17rMrvCi8"),
    ("ICD10", "M66.5", "M66.5 Spontaneous rupture of unspecified tendon", "KlMdIHvXiYD"),
    ("ICD10", "M67", "M67 Other disorders of synovium and tendon", "ggDjQBw8nt1"),
    ("ICD10", "M67.0", "M67.0 Short Achilles tendon (acquired)", "sgU4D4zvAgc"),
    ("ICD10", "M67.1", "M67.1 Other contracture of tendon (sheath)", "eVK3PkrosDH"),
    ("ICD10", "M67.2", "M67.2 Synovial hypertrophy, not elsewhere classified", "e9lYHmJtHYt"),
    ("ICD10", "M67.3", "M67.3 Transient synovitis", "o0zM2DYxcE6"),
    ("ICD10", "M67.4", "M67.4 Ganglion", "s1RinDp9htE"),
    ("ICD10", "M67.8", "M67.8 Other specified disorders of synovium and tendon", "RD1IiEGWsWu"),
    ("ICD10", "M67.9", "M67.9 Disorder of synovium and tendon, unspecified", "fo9NKc4Kh2G"),
    ("ICD10", "M68", "M68 Disorders of synovium and tendon in diseases classified elsewhere", "HzDaTVZIufW"),
    ("ICD10", "M68.0", "M68.0 Synovitis and tenosynovitis in bacterial diseases classified elsewhere", "PPylAJBpSs8"),
    ("ICD10", "M68.8", "M68.8 Other disorders of synovium and tendon in diseases classified elsewhere", "xWjFWHpUOzR"),
    ("ICD10", "M70", "M70 Soft tissue disorders related to use, overuse and pressure", "iCUaYSq7C5O"),
    ("ICD10", "M70.0", "M70.0 Chronic crepitant synovitis of hand and wrist", "gP2sGpzU4pK"),
    ("ICD10", "M70.1", "M70.1 Bursitis of hand", "YplSxY4BtNj"),
    ("ICD10", "M70.2", "M70.2 Olecranon bursitis", "iOyTOEjcFD0"),
    ("ICD10", "M70.3", "M70.3 Other bursitis of elbow", "lh8Erpdthhz"),
    ("ICD10", "M70.4", "M70.4 Prepatellar bursitis", "eRNQ5ruNWH6"),
    ("ICD10", "M70.5", "M70.5 Other bursitis of knee", "geblteXZVGq"),
    ("ICD10", "M70.6", "M70.6 Trochanteric bursitis", "y2rzKXQTKXs"),
    ("ICD10", "M70.7", "M70.7 Other bursitis of hip", "Cjbt1tnhm5R"),
    ("ICD10", "M70.8", "M70.8 Other soft tissue disorders related to use, overuse and pressure", "ER510LfPLxL"),
    ("ICD10", "M70.9", "M70.9 Unspecified soft tissue disorder related to use, overuse and pressure", "ayvTKohWscx"),
    ("ICD10", "M71", "M71 Other bursopathies", "msgqBMnrCyR"),
    ("ICD10", "M71.0", "M71.0 Abscess of bursa", "H9kARjT9oJX"),
    ("ICD10", "M71.1", "M71.1 Other infective bursitis", "webAVCkMDLz"),
    ("ICD10", "M71.2", "M71.2 Synovial cyst of popliteal space [Baker]", "PyLFNYjNyC0"),
    ("ICD10", "M71.3", "M71.3 Other bursal cyst", "UcimX8PNZj6"),
    ("ICD10", "M71.4", "M71.4 Calcium deposit in bursa", "GbyhKqExPR9"),
    ("ICD10", "M71.5", "M71.5 Other bursitis, not elsewhere classified", "j1z4gv0THQs"),
    ("ICD10", "M71.8", "M71.8 Other specified bursopathies", "Iw8a5YZ3fXU"),
    ("ICD10", "M71.9", "M71.9 Bursopathy, unspecified", "xRvUQPjUdSw"),
    ("ICD10", "M72", "M72 Fibroblastic disorders", "GOm48YS6qCn"),
    ("ICD10", "M72.0", "M72.0 Palmar fascial fibromatosis [Dupuytren]", "LfIGZYBTHAk"),
    ("ICD10", "M72.1", "M72.1 Knuckle pads", "HTAapHngT2I"),
    ("ICD10", "M72.2", "M72.2 Plantar fascial fibromatosis", "MfkZ6Y1iYhh"),
    ("ICD10", "M72.4", "M72.4 Pseudosarcomatous fibromatosis", "hfTd9Qyo34K"),
    ("ICD10", "M72.6", "M72.6 Necrotizing fasciitis", "G4K7KnDijy8"),
    ("ICD10", "M72.8", "M72.8 Other fibroblastic disorders", "RLXiKNsExaB"),
    ("ICD10", "M72.9", "M72.9 Fibroblastic disorder, unspecified", "AJpi6cukJ98"),
    ("ICD10", "M73", "M73 Soft tissue disorders in diseases classified elsewhere", "dvYBdkRsS6J"),
    ("ICD10", "M73.0", "M73.0 Gonococcal bursitis", "j9TIUZ3eanT"),
    ("ICD10", "M73.1", "M73.1 Syphilitic bursitis", "IQYzLpzSsDV"),
    ("ICD10", "M73.8", "M73.8 Other soft tissue disorders in diseases classified elsewhere", "BdEDh8sIVMC"),
    ("ICD10", "M75", "M75 Shoulder lesions", "PjWruXzYDYN"),
    ("ICD10", "M75.0", "M75.0 Adhesive capsulitis of shoulder", "YtvH2FFjN0g"),
    ("ICD10", "M75.1", "M75.1 Rotator cuff syndrome", "GcVFkS115LJ"),
    ("ICD10", "M75.2", "M75.2 Bicipital tendinitis", "arwWP1Dsk5p"),
    ("ICD10", "M75.3", "M75.3 Calcific tendinitis of shoulder", "Q9rqDwzmpDq"),
    ("ICD10", "M75.4", "M75.4 Impingement syndrome of shoulder", "O8uvkUpqCgQ"),
    ("ICD10", "M75.5", "M75.5 Bursitis of shoulder", "qFfUsX38R60"),
    ("ICD10", "M75.8", "M75.8 Other shoulder lesions", "lmf092dWHLJ"),
    ("ICD10", "M75.9", "M75.9 Shoulder lesion, unspecified", "pPKhsRGYZuj"),
    ("ICD10", "M76", "M76 Enthesopathies of lower limb, excluding foot", "OOQfoufKAOb"),
    ("ICD10", "M76.0", "M76.0 Gluteal tendinitis", "VGF0ghReJGP"),
    ("ICD10", "M76.1", "M76.1 Psoas tendinitis", "INcRSMZoJDc"),
    ("ICD10", "M76.2", "M76.2 Iliac crest spur", "cUTNcX3S7rN"),
    ("ICD10", "M76.3", "M76.3 Iliotibial band syndrome", "hzlIR88vh01"),
    ("ICD10", "M76.4", "M76.4 Tibial collateral bursitis [Pellegrini-Stieda]", "mOXsXyoQuDf"),
    ("ICD10", "M76.5", "M76.5 Patellar tendinitis", "TTl2jNGpIUu"),
    ("ICD10", "M76.6", "M76.6 Achilles tendinitis", "kmsS6vZPHNE"),
    ("ICD10", "M76.7", "M76.7 Peroneal tendinitis", "bdaKuFE6Trg"),
    ("ICD10", "M76.8", "M76.8 Other enthesopathies of lower limb, excluding foot", "Duyu3va73qM"),
    ("ICD10", "M76.9", "M76.9 Enthesopathy of lower limb, unspecified", "V90vBeGVJ0N"),
    ("ICD10", "M77", "M77 Other enthesopathies", "iWAxn42uTIX"),
    ("ICD10", "M77.0", "M77.0 Medial epicondylitis", "JLtg5BBMG2S"),
    ("ICD10", "M77.1", "M77.1 Lateral epicondylitis", "EjiR6ex90Ir"),
    ("ICD10", "M77.2", "M77.2 Periarthritis of wrist", "KS3Hdtwz09K"),
    ("ICD10", "M77.3", "M77.3 Calcaneal spur", "AnSimXq5HOw"),
    ("ICD10", "M77.4", "M77.4 Metatarsalgia", "SiqzSblkime"),
    ("ICD10", "M77.5", "M77.5 Other enthesopathy of foot", "iGIYAO9GckG"),
    ("ICD10", "M77.8", "M77.8 Other enthesopathies, not elsewhere classified", "XwLbOPTUuj7"),
    ("ICD10", "M77.9", "M77.9 Enthesopathy, unspecified", "dA91dBLH7ag"),
    ("ICD10", "M79", "M79 Other soft tissue disorders, not elsewhere classified", "yOKN6cBNTC8"),
    ("ICD10", "M79.0", "M79.0 Rheumatism, unspecified", "gzLxn3iDtaZ"),
    ("ICD10", "M79.1", "M79.1 Myalgia", "njhexewWyow"),
    ("ICD10", "M79.2", "M79.2 Neuralgia and neuritis, unspecified", "IBC9jXfVoeR"),
    ("ICD10", "M79.3", "M79.3 Panniculitis, unspecified", "ckqrWT3RfjQ"),
    ("ICD10", "M79.4", "M79.4 Hypertrophy of (infrapatellar) fat pad", "AC6qcYXlByM"),
    ("ICD10", "M79.5", "M79.5 Residual foreign body in soft tissue", "JTIuSFC9bSQ"),
    ("ICD10", "M79.6", "M79.6 Pain in limb", "OqR1AtySTtq"),
    ("ICD10", "M79.7", "M79.7 Fibromyalgia", "zKIi1K3YgUk"),
    ("ICD10", "M79.8", "M79.8 Other specified soft tissue disorders", "Utm8tVPw6xF"),
    ("ICD10", "M79.9", "M79.9 Soft tissue disorder, unspecified", "isB3M8XcWMd"),
    ("ICD10", "M80", "M80 Osteoporosis with pathological fracture", "Bl9O7yeFybF"),
    ("ICD10", "M80.0", "M80.0 Postmenopausal osteoporosis with pathological fracture", "Sg2oBkImwnj"),
    ("ICD10", "M80.1", "M80.1 Postoophorectomy osteoporosis with pathological fracture", "bAshMjQMSg6"),
    ("ICD10", "M80.2", "M80.2 Osteoporosis of disuse with pathological fracture", "TIVVLZGewZP"),
    ("ICD10", "M80.3", "M80.3 Postsurgical malabsorption osteoporosis with pathological fracture", "YuiovACDWG9"),
    ("ICD10", "M80.4", "M80.4 Drug-induced osteoporosis with pathological fracture", "Ak2yf24xzQZ"),
    ("ICD10", "M80.5", "M80.5 Idiopathic osteoporosis with pathological fracture", "FKv7QEWKkWT"),
    ("ICD10", "M80.8", "M80.8 Other osteoporosis with pathological fracture", "F7RLvwBAoT5"),
    ("ICD10", "M80.9", "M80.9 Unspecified osteoporosis with pathological fracture", "fKDCgKmdOJi"),
    ("ICD10", "M81", "M81 Osteoporosis without pathological fracture", "tJ3WI5FFgwG"),
    ("ICD10", "M81.0", "M81.0 Postmenopausal osteoporosis", "wtZym14f7CO"),
    ("ICD10", "M81.1", "M81.1 Postoophorectomy osteoporosis", "v2ufRgXUzNg"),
    ("ICD10", "M81.2", "M81.2 Osteoporosis of disuse", "ysh98eBFN4G"),
    ("ICD10", "M81.3", "M81.3 Postsurgical malabsorption osteoporosis", "WJih1oNx0XJ"),
    ("ICD10", "M81.4", "M81.4 Drug-induced osteoporosis", "TpPpTfpD489"),
    ("ICD10", "M81.5", "M81.5 Idiopathic osteoporosis", "VSPz8HBX5Gz"),
    ("ICD10", "M81.6", "M81.6 Localized osteoporosis [Lequesne]", "t9ZWG0ZM85o"),
    ("ICD10", "M81.8", "M81.8 Other osteoporosis", "EB2k8QFIddh"),
    ("ICD10", "M81.9", "M81.9 Osteoporosis, unspecified", "NRGCxoMKzb0"),
    ("ICD10", "M82", "M82 Osteoporosis in diseases classified elsewhere", "UmrunIcrSj3"),
    ("ICD10", "M82.0", "M82.0 Osteoporosis in multiple myelomatosis", "arejHyICW7x"),
    ("ICD10", "M82.1", "M82.1 Osteoporosis in endocrine disorders", "S3pWnAXYReB"),
    ("ICD10", "M82.8", "M82.8 Osteoporosis in other diseases classified elsewhere", "u8m2GzvO81c"),
    ("ICD10", "M83", "M83 Adult osteomalacia", "DjvYD2OYHTj"),
    ("ICD10", "M83.0", "M83.0 Puerperal osteomalacia", "QR55ey60EYa"),
    ("ICD10", "M83.1", "M83.1 Senile osteomalacia", "cGEADp7I8gl"),
    ("ICD10", "M83.2", "M83.2 Adult osteomalacia due to malabsorption", "e0w4K2nCzOP"),
    ("ICD10", "M83.3", "M83.3 Adult osteomalacia due to malnutrition", "kXsnYCHfdc0"),
    ("ICD10", "M83.4", "M83.4 Aluminium bone disease", "VUtPRI0GZeq"),
    ("ICD10", "M83.5", "M83.5 Other drug-induced osteomalacia in adults", "OpEmWwuSogt"),
    ("ICD10", "M83.8", "M83.8 Other adult osteomalacia", "UEWKJT26kU1"),
    ("ICD10", "M83.9", "M83.9 Adult osteomalacia, unspecified", "nyySubRbSpX"),
    ("ICD10", "M84", "M84 Disorders of continuity of bone", "xozFunc5RYi"),
    ("ICD10", "M84.0", "M84.0 Malunion of fracture", "DBKmAVZwQD8"),
    ("ICD10", "M84.1", "M84.1 Nonunion of fracture [pseudarthrosis]", "EIGnx2Eb8Rd"),
    ("ICD10", "M84.2", "M84.2 Delayed union of fracture", "Jc1u5MHCk4z"),
    ("ICD10", "M84.3", "M84.3 Stress fracture, not elsewhere classified", "X4sKyoFhLcu"),
    ("ICD10", "M84.4", "M84.4 Pathological fracture, not elsewhere classified", "vGs120QWX3G"),
    ("ICD10", "M84.8", "M84.8 Other disorders of continuity of bone", "J40il2HlfWH"),
    ("ICD10", "M84.9", "M84.9 Disorder of continuity of bone, unspecified", "QgpbcuixwrR"),
    ("ICD10", "M85", "M85 Other disorders of bone density and structure", "RbHtEVaTP8E"),
    ("ICD10", "M85.0", "M85.0 Fibrous dysplasia (monostotic)", "ZTTmQEyfzEe"),
    ("ICD10", "M85.1", "M85.1 Skeletal fluorosis", "ZWZrBL2TkQL"),
    ("ICD10", "M85.2", "M85.2 Hyperostosis of skull", "wMZ1vnX99V7"),
    ("ICD10", "M85.3", "M85.3 Osteitis condensans", "ehDAha9FgJU"),
    ("ICD10", "M85.4", "M85.4 Solitary bone cyst", "HW4UzFkg3PN"),
    ("ICD10", "M85.5", "M85.5 Aneurysmal bone cyst", "n7H9qfjFMOl"),
    ("ICD10", "M85.6", "M85.6 Other cyst of bone", "m516gOQWtCO"),
    ("ICD10", "M85.8", "M85.8 Other specified disorders of bone density and structure", "yq6uounlvvB"),
    ("ICD10", "M85.9", "M85.9 Disorder of bone density and structure, unspecified", "D5muROBbf0x"),
    ("ICD10", "M86", "M86 Osteomyelitis", "vlgXdfCuTcb"),
    ("ICD10", "M86.0", "M86.0 Acute haematogenous osteomyelitis", "uymVUytYvQN"),
    ("ICD10", "M86.1", "M86.1 Other acute osteomyelitis", "l0Tm66zCUcU"),
    ("ICD10", "M86.2", "M86.2 Subacute osteomyelitis", "idBdAWXkXNN"),
    ("ICD10", "M86.3", "M86.3 Chronic multifocal osteomyelitis", "tGudPSM4x1m"),
    ("ICD10", "M86.4", "M86.4 Chronic osteomyelitis with draining sinus", "twwv2cqTxkI"),
    ("ICD10", "M86.5", "M86.5 Other chronic haematogenous osteomyelitis", "sVsNsxfgIhC"),
    ("ICD10", "M86.6", "M86.6 Other chronic osteomyelitis", "o3pyYPPjR3p"),
    ("ICD10", "M86.8", "M86.8 Other osteomyelitis", "zIhsu8zWhyX"),
    ("ICD10", "M86.9", "M86.9 Osteomyelitis, unspecified", "CWLumplNszk"),
    ("ICD10", "M87", "M87 Osteonecrosis", "zZwYOxmwSza"),
    ("ICD10", "M87.0", "M87.0 Idiopathic aseptic necrosis of bone", "w6yWmI9YeB2"),
    ("ICD10", "M87.1", "M87.1 Osteonecrosis due to drugs", "HDKkO0EHalg"),
    ("ICD10", "M87.2", "M87.2 Osteonecrosis due to previous trauma", "KdZX6kDrOcf"),
    ("ICD10", "M87.3", "M87.3 Other secondary osteonecrosis", "UUQWxiadgWv"),
    ("ICD10", "M87.8", "M87.8 Other osteonecrosis", "TzB636bHYgv"),
    ("ICD10", "M87.9", "M87.9 Osteonecrosis, unspecified", "GizUKCk3n5f"),
    ("ICD10", "M88", "M88 Paget disease of bone [osteitis deformans]", "dDR2DzHSVCn"),
    ("ICD10", "M88.0", "M88.0 Paget disease of skull", "KbfO0fzsZrW"),
    ("ICD10", "M88.8", "M88.8 Paget disease of other bones", "GGsPJNEqx5H"),
    ("ICD10", "M88.9", "M88.9 Paget disease of bone, unspecified", "mkBtuZuTObU"),
    ("ICD10", "M89", "M89 Other disorders of bone", "U5rBlmLaWbH"),
    ("ICD10", "M89.0", "M89.0 Algoneurodystrophy", "PCSrYMuxVdX"),
    ("ICD10", "M89.1", "M89.1 Epiphyseal arrest", "zrFwp3N8Orj"),
    ("ICD10", "M89.2", "M89.2 Other disorders of bone development and growth", "MCcMQ6NrL5Z"),
    ("ICD10", "M89.3", "M89.3 Hypertrophy of bone", "jwXK7bT4fXi"),
    ("ICD10", "M89.4", "M89.4 Other hypertrophic osteoarthropathy", "R0OgbzWbJMd"),
    ("ICD10", "M89.5", "M89.5 Osteolysis", "HVAp3q5WdCu"),
    ("ICD10", "M89.6", "M89.6 Osteopathy after poliomyelitis", "tJNWpQ6jSDy"),
    ("ICD10", "M89.8", "M89.8 Other specified disorders of bone", "PKxyiUV97jg"),
    ("ICD10", "M89.9", "M89.9 Disorder of bone, unspecified", "sCKzKUdZoPB"),
    ("ICD10", "M90", "M90 Osteopathies in diseases classified elsewhere", "t9F9midOjQt"),
    ("ICD10", "M90.0", "M90.0 Tuberculosis of bone", "VngFyQ48psj"),
    ("ICD10", "M90.1", "M90.1 Periostitis in other infectious diseases classified elsewhere", "Co1zJI5VnnB"),
    ("ICD10", "M90.2", "M90.2 Osteopathy in other infectious diseases classified elsewhere", "ekJoPHHwjwO"),
    ("ICD10", "M90.3", "M90.3 Osteonecrosis in caisson disease", "nOLp2AV0VN0"),
    ("ICD10", "M90.4", "M90.4 Osteonecrosis due to haemoglobinopathy", "vdpFVXrP3jL"),
    ("ICD10", "M90.5", "M90.5 Osteonecrosis in other diseases classified elsewhere", "WFRQ6J2k4ZF"),
    ("ICD10", "M90.6", "M90.6 Osteitis deformans in neoplastic disease", "fNhPrq0H0R8"),
    ("ICD10", "M90.7", "M90.7 Fracture of bone in neoplastic disease", "sHzTsXvRWrN"),
    ("ICD10", "M90.8", "M90.8 Osteopathy in other diseases classified elsewhere", "ex2xYfe8mLz"),
    ("ICD10", "M91", "M91 Juvenile osteochondrosis of hip and pelvis", "T8piqAprDhJ"),
    ("ICD10", "M91.0", "M91.0 Juvenile osteochondrosis of pelvis", "VoIH6S4DMBz"),
    ("ICD10", "M91.1", "M91.1 Juvenile osteochondrosis of head of femur [Legg-Calvé-Perthes]", "JxWOOFHatXl"),
    ("ICD10", "M91.2", "M91.2 Coxa plana", "VyUbdB0MG2l"),
    ("ICD10", "M91.3", "M91.3 Pseudocoxalgia", "Ays2oMufrgB"),
    ("ICD10", "M91.8", "M91.8 Other juvenile osteochondrosis of hip and pelvis", "mWDPMFHXrTp"),
    ("ICD10", "M91.9", "M91.9 Juvenile osteochondrosis of hip and pelvis, unspecified", "VdRKuQ54g95"),
    ("ICD10", "M92", "M92 Other juvenile osteochondrosis", "SVsbAV3chSU"),
    ("ICD10", "M92.0", "M92.0 Juvenile osteochondrosis of humerus", "UZsxbnCjY8n"),
    ("ICD10", "M92.1", "M92.1 Juvenile osteochondrosis of radius and ulna", "Cj8A9Bc4xOo"),
    ("ICD10", "M92.2", "M92.2 Juvenile osteochondrosis of hand", "O9AMoTzL734"),
    ("ICD10", "M92.3", "M92.3 Other juvenile osteochondrosis of upper limb", "XhZnCaBZHXJ"),
    ("ICD10", "M92.4", "M92.4 Juvenile osteochondrosis of patella", "f0jubOFoGdE"),
    ("ICD10", "M92.5", "M92.5 Juvenile osteochondrosis of tibia and fibula", "nTSlT7PfBdw"),
    ("ICD10", "M92.6", "M92.6 Juvenile osteochondrosis of tarsus", "FK9L5nojd4E"),
    ("ICD10", "M92.7", "M92.7 Juvenile osteochondrosis of metatarsus", "RwgEcjNPxqp"),
    ("ICD10", "M92.8", "M92.8 Other specified juvenile osteochondrosis", "hhYVTOiSKaY"),
    ("ICD10", "M92.9", "M92.9 Juvenile osteochondrosis, unspecified", "L5162oq3Zzx"),
    ("ICD10", "M93", "M93 Other osteochondropathies", "o0wD29uzZvq"),
    ("ICD10", "M93.0", "M93.0 Slipped upper femoral epiphysis (nontraumatic)", "ltDHN5dAy1G"),
    ("ICD10", "M93.1", "M93.1 Kienböck disease of adults", "fYvSRBVV9ji"),
    ("ICD10", "M93.2", "M93.2 Osteochondritis dissecans", "DswCIlCYWwb"),
    ("ICD10", "M93.8", "M93.8 Other specified osteochondropathies", "kWJphy1GjQP"),
    ("ICD10", "M93.9", "M93.9 Osteochondropathy, unspecified", "TL6peCfFzai"),
    ("ICD10", "M94", "M94 Other disorders of cartilage", "iCXCYbTpf5x"),
    ("ICD10", "M94.0", "M94.0 Chondrocostal junction syndrome [Tietze]", "pb3BzdHqhVB"),
    ("ICD10", "M94.1", "M94.1 Relapsing polychondritis", "H64xnVvDrcf"),
    ("ICD10", "M94.2", "M94.2 Chondromalacia", "ni2ceXk9NpV"),
    ("ICD10", "M94.3", "M94.3 Chondrolysis", "vE785MLrklq"),
    ("ICD10", "M94.8", "M94.8 Other specified disorders of cartilage", "Hlvzk01eh12"),
    ("ICD10", "M94.9", "M94.9 Disorder of cartilage, unspecified", "mija2CHmt11"),
    ("ICD10", "M95", "M95 Other acquired deformities of musculoskeletal system and connective tissue", "R0QmryuY54n"),
    ("ICD10", "M95.0", "M95.0 Acquired deformity of nose", "U6VCJ7rPmF3"),
    ("ICD10", "M95.1", "M95.1 Cauliflower ear", "mYYwWy06TUD"),
    ("ICD10", "M95.2", "M95.2 Other acquired deformity of head", "tblfURpaxgX"),
    ("ICD10", "M95.3", "M95.3 Acquired deformity of neck", "jk1N0EYseR5"),
    ("ICD10", "M95.4", "M95.4 Acquired deformity of chest and rib", "oZInFZ32RYP"),
    ("ICD10", "M95.5", "M95.5 Acquired deformity of pelvis", "zOMdffEVRP7"),
    ("ICD10", "M95.8", "M95.8 Other specified acquired deformities of musculoskeletal system", "us0yvkqTgMC"),
    ("ICD10", "M95.9", "M95.9 Acquired deformity of musculoskeletal system, unspecified", "fQzg1lIcV9w"),
    ("ICD10", "M96", "M96 Postprocedural musculoskeletal disorders, not elsewhere classified", "lxEMHKoaXTJ"),
    ("ICD10", "M96.0", "M96.0 Pseudarthrosis after fusion or arthrodesis", "a0VfABBeS3o"),
    ("ICD10", "M96.1", "M96.1 Postlaminectomy syndrome, not elsewhere classified", "GpoYQJI6n1u"),
    ("ICD10", "M96.2", "M96.2 Postradiation kyphosis", "Bk2cFdEZKx3"),
    ("ICD10", "M96.3", "M96.3 Postlaminectomy kyphosis", "AVFiNAlezyb"),
    ("ICD10", "M96.4", "M96.4 Postsurgical lordosis", "JECFfrmlvm5"),
    ("ICD10", "M96.5", "M96.5 Postradiation scoliosis", "dB1zLwzm7Xk"),
    ("ICD10", "M96.6", "M96.6 Fracture of bone following insertion of orthopaedic implant, joint prosthesis, or bone plate", "ZjRemtctP5a"),
    ("ICD10", "M96.8", "M96.8 Other postprocedural musculoskeletal disorders", "MzSEvmGvB5c"),
    ("ICD10", "M96.9", "M96.9 Postprocedural musculoskeletal disorder, unspecified", "s7CmoUmQrMG"),
    ("ICD10", "M99", "M99 Biomechanical lesions, not elsewhere classified", "nC2MWDEinaW"),
    ("ICD10", "M99.0", "M99.0 Segmental and somatic dysfunction", "rcOgSExIUYv"),
    ("ICD10", "M99.1", "M99.1 Subluxation complex (vertebral)", "EdM3wT5AZcC"),
    ("ICD10", "M99.2", "M99.2 Subluxation stenosis of neural canal", "uq19UEWQDpz"),
    ("ICD10", "M99.3", "M99.3 Osseous stenosis of neural canal", "TZk05nVH75X"),
    ("ICD10", "M99.4", "M99.4 Connective tissue stenosis of neural canal", "b2xljZAz0lr"),
    ("ICD10", "M99.5", "M99.5 Intervertebral disc stenosis of neural canal", "hy3OvyjVMpL"),
    ("ICD10", "M99.6", "M99.6 Osseous and subluxation stenosis of intervertebral foramina", "Lzm5a4xWYhn"),
    ("ICD10", "M99.7", "M99.7 Connective tissue and disc stenosis of intervertebral foramina", "C1VZWjXrqjt"),
    ("ICD10", "M99.8", "M99.8 Other biomechanical lesions", "cymTEqxl8YY"),
    ("ICD10", "M99.9", "M99.9 Biomechanical lesion, unspecified", "l6jK3NS3T2Q");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "N00", "N00 Acute nephritic syndrome", "eGHOaCLeNZv"),
    ("ICD10", "N01", "N01 Rapidly progressive nephritic syndrome", "xukZHUaSZJk"),
    ("ICD10", "N02", "N02 Recurrent and persistent haematuria", "HIfWHWOcp6q"),
    ("ICD10", "N03", "N03 Chronic nephritic syndrome", "CHr7lgKiguo"),
    ("ICD10", "N04", "N04 Nephrotic syndrome", "dnr47yBZjOc"),
    ("ICD10", "N05", "N05 Unspecified nephritic syndrome", "v344MsIxjWF"),
    ("ICD10", "N06", "N06 Isolated proteinuria with specified morphological lesion", "OYE5X301Udk"),
    ("ICD10", "N07", "N07 Hereditary nephropathy, not elsewhere classified", "HHF6MId65Ot"),
    ("ICD10", "N08", "N08 Glomerular disorders in diseases classified elsewhere", "sroHJaWUJmO"),
    ("ICD10", "N08.0", "N08.0 Glomerular disorders in infectious and parasitic diseases classified elsewhere", "PnsbIR0TnAa"),
    ("ICD10", "N08.1", "N08.1 Glomerular disorders in neoplastic diseases", "JxjGAX9VBgz"),
    ("ICD10", "N08.2", "N08.2 Glomerular disorders in blood diseases and disorders involving the immune mechanism", "P1cHbOFMIqX"),
    ("ICD10", "N08.3", "N08.3 Glomerular disorders in diabetes mellitus", "MxjVIsSlhUN"),
    ("ICD10", "N08.4", "N08.4 Glomerular disorders in other endocrine, nutritional and metabolic diseases", "dlPVjCbl6Hc"),
    ("ICD10", "N08.5", "N08.5 Glomerular disorders in systemic connective tissue disorders", "z6Ewu2doW7O"),
    ("ICD10", "N08.8", "N08.8 Glomerular disorders in other diseases classified elsewhere", "L7jBz9xKANW"),
    ("ICD10", "N10", "N10 Acute tubulo-interstitial nephritis", "pWfW7iW8dUK"),
    ("ICD10", "N11", "N11 Chronic tubulo-interstitial nephritis", "OfwXFVfop8E"),
    ("ICD10", "N11.0", "N11.0 Nonobstructive reflux-associated chronic pyelonephritis", "Xbf8KZ0J0EU"),
    ("ICD10", "N11.1", "N11.1 Chronic obstructive pyelonephritis", "nXJniDd0Y6z"),
    ("ICD10", "N11.8", "N11.8 Other chronic tubulo-interstitial nephritis", "OyIsTeYxvku"),
    ("ICD10", "N11.9", "N11.9 Chronic tubulo-interstitial nephritis, unspecified", "KuqhOrkDOC4"),
    ("ICD10", "N12", "N12 Tubulo-interstitial nephritis, not specified as acute or chronic", "PDR19hS1f55"),
    ("ICD10", "N13", "N13 Obstructive and reflux uropathy", "YKqBdFIHd0X"),
    ("ICD10", "N13.0", "N13.0 Hydronephrosis with ureteropelvic junction obstruction", "Zl4veiIS0eR"),
    ("ICD10", "N13.1", "N13.1 Hydronephrosis with ureteral stricture, not elsewhere classified", "pne7XYGlYqO"),
    ("ICD10", "N13.2", "N13.2 Hydronephrosis with renal and ureteral calculous obstruction", "PlFkZJl7Pb7"),
    ("ICD10", "N13.3", "N13.3 Other and unspecified hydronephrosis", "oYDFhnuulTV"),
    ("ICD10", "N13.4", "N13.4 Hydroureter", "QTZDh22ir80"),
    ("ICD10", "N13.5", "N13.5 Kinking and stricture of ureter without hydronephrosis", "BQLdGameGlf"),
    ("ICD10", "N13.6", "N13.6 Pyonephrosis", "eImVK23ny4Q"),
    ("ICD10", "N13.7", "N13.7 Vesicoureteral-reflux-associated uropathy", "sdGT4y0jbkx"),
    ("ICD10", "N13.8", "N13.8 Other obstructive and reflux uropathy", "ixD2335k8AB"),
    ("ICD10", "N13.9", "N13.9 Obstructive and reflux uropathy, unspecified", "MrF6M6bhcxu"),
    ("ICD10", "N14", "N14 Drug- and heavy-metal-induced tubulo-interstitial and tubular conditions", "yLg20CgHysG"),
    ("ICD10", "N14.0", "N14.0 Analgesic nephropathy", "ONizEbpN7dz"),
    ("ICD10", "N14.1", "N14.1 Nephropathy induced by other drugs, medicaments and biological substances", "gEPno27IgSL"),
    ("ICD10", "N14.2", "N14.2 Nephropathy induced by unspecified drug, medicament or biological substance", "xrHn7AjrcHU"),
    ("ICD10", "N14.3", "N14.3 Nephropathy induced by heavy metals", "eunTSnz9gj8"),
    ("ICD10", "N14.4", "N14.4 Toxic nephropathy, not elsewhere classified", "QuHEEYyuYal"),
    ("ICD10", "N15", "N15 Other renal tubulo-interstitial diseases", "kdur0d2fkLs"),
    ("ICD10", "N15.0", "N15.0 Balkan nephropathy", "npBon5RKoka"),
    ("ICD10", "N15.1", "N15.1 Renal and perinephric abscess", "Q6oCv4Jvi1N"),
    ("ICD10", "N15.8", "N15.8 Other specified renal tubulo-interstitial diseases", "KUggNaMKjcb"),
    ("ICD10", "N15.9", "N15.9 Renal tubulo-interstitial disease, unspecified", "R1OvlwjIrxK"),
    ("ICD10", "N16", "N16 Renal tubulo-interstitial disorders in diseases classified elsewhere", "OcyHUiGiRcU"),
    ("ICD10", "N16.0", "N16.0 Renal tubulo-interstitial disorders in infectious and parasitic diseases classified elsewhere", "d1vD86RUa2i"),
    ("ICD10", "N16.1", "N16.1 Renal tubulo-interstitial disorders in neoplastic diseases", "ByhvA2dMe24"),
    ("ICD10", "N16.2", "N16.2 Renal tubulo-interstitial disorders in blood diseases and disorders involving the immune mechanism", "hybX1A8HsZh"),
    ("ICD10", "N16.3", "N16.3 Renal tubulo-interstitial disorders in metabolic diseases", "WEnqLMsOGgD"),
    ("ICD10", "N16.4", "N16.4 Renal tubulo-interstitial disorders in systemic connective tissue disorders", "PsNQSOugtpc"),
    ("ICD10", "N16.5", "N16.5 Renal tubulo-interstitial disorders in transplant rejection", "Rd5u3lboDgy"),
    ("ICD10", "N16.8", "N16.8 Renal tubulo-interstitial disorders in other diseases classified elsewhere", "WyDxgzmxRZi"),
    ("ICD10", "N17", "N17 Acute renal failure", "A0be0762Prt"),
    ("ICD10", "N17.0", "N17.0 Acute renal failure with tubular necrosis", "icw3bThVMG4"),
    ("ICD10", "N17.1", "N17.1 Acute renal failure with acute cortical necrosis", "JQepOz9YQXp"),
    ("ICD10", "N17.2", "N17.2 Acute renal failure with medullary necrosis", "xyM8WeMcbRx"),
    ("ICD10", "N17.8", "N17.8 Other acute renal failure", "gdSlfEyOdZU"),
    ("ICD10", "N17.9", "N17.9 Acute renal failure, unspecified", "NKHft0cfpn2"),
    ("ICD10", "N18", "N18 Chronic kidney disease", "hjix1oiUhyv"),
    ("ICD10", "N18.1", "N18.1 Chronic kidney disease, stage 1", "fb9ll9VRppx"),
    ("ICD10", "N18.2", "N18.2 Chronic kidney disease, stage 2", "jLv5p2SkogB"),
    ("ICD10", "N18.3", "N18.3 Chronic kidney disease, stage 3", "tebBaYkAX6O"),
    ("ICD10", "N18.4", "N18.4 Chronic kidney disease, stage 4", "QHN3gMTwOLf"),
    ("ICD10", "N18.5", "N18.5 Chronic kidney disease, stage 5", "tFgZ9qhMFwz"),
    ("ICD10", "N18.9", "N18.9 Chronic kidney disease, unspecified", "kNh8sYT8Bcp"),
    ("ICD10", "N19", "N19 Unspecified kidney failure", "kBzcrLduxYp"),
    ("ICD10", "N20", "N20 Calculus of kidney and ureter", "PZ1ancBzrTt"),
    ("ICD10", "N20.0", "N20.0 Calculus of kidney", "j2IRKAQmA96"),
    ("ICD10", "N20.1", "N20.1 Calculus of ureter", "r5ORNF7TeRw"),
    ("ICD10", "N20.2", "N20.2 Calculus of kidney with calculus of ureter", "kZeHdbN6pwL"),
    ("ICD10", "N20.9", "N20.9 Urinary calculus, unspecified", "uBnq2YjG1i4"),
    ("ICD10", "N21", "N21 Calculus of lower urinary tract", "tgrK4EgdS2O"),
    ("ICD10", "N21.0", "N21.0 Calculus in bladder", "W4mU4rkTL4W"),
    ("ICD10", "N21.1", "N21.1 Calculus in urethra", "LRV1u64mTzM"),
    ("ICD10", "N21.8", "N21.8 Other lower urinary tract calculus", "iUJ1f46LdEH"),
    ("ICD10", "N21.9", "N21.9 Calculus of lower urinary tract, unspecified", "DSuOpBCq9pY"),
    ("ICD10", "N22", "N22 Calculus of urinary tract in diseases classified elsewhere", "iq28U4qhAXP"),
    ("ICD10", "N22.0", "N22.0 Urinary calculus in schistosomiasis [bilharziasis]", "tYnTR2HmB5G"),
    ("ICD10", "N22.8", "N22.8 Calculus of urinary tract in other diseases classified elsewhere", "PGylI8nFirQ"),
    ("ICD10", "N23", "N23 Unspecified renal colic", "nU6h4ZNFCq9"),
    ("ICD10", "N25", "N25 Disorders resulting from impaired renal tubular function", "BXHsAbjR8t4"),
    ("ICD10", "N25.0", "N25.0 Renal osteodystrophy", "uBOmOobCQ6G"),
    ("ICD10", "N25.1", "N25.1 Nephrogenic diabetes insipidus", "bVKjxfRBbs8"),
    ("ICD10", "N25.8", "N25.8 Other disorders resulting from impaired renal tubular function", "PbSPs3quxY5"),
    ("ICD10", "N25.9", "N25.9 Disorder resulting from impaired renal tubular function, unspecified", "fKrmZ86l4rP"),
    ("ICD10", "N26", "N26 Unspecified contracted kidney", "xy0NvEfwYHV"),
    ("ICD10", "N27", "N27 Small kidney of unknown cause", "S8DwciC7FjJ"),
    ("ICD10", "N27.0", "N27.0 Small kidney, unilateral", "yToxUCgxAIv"),
    ("ICD10", "N27.1", "N27.1 Small kidney, bilateral", "HD9NZxcvbJA"),
    ("ICD10", "N27.9", "N27.9 Small kidney, unspecified", "i7Jeu2wrP2C"),
    ("ICD10", "N28", "N28 Other disorders of kidney and ureter, not elsewhere classified", "bPWRSzocRfQ"),
    ("ICD10", "N28.0", "N28.0 Ischaemia and infarction of kidney", "yX8OUHMvAfk"),
    ("ICD10", "N28.1", "N28.1 Cyst of kidney", "JTZhlHz4lvq"),
    ("ICD10", "N28.8", "N28.8 Other specified disorders of kidney and ureter", "THUaUbwNPCM"),
    ("ICD10", "N28.9", "N28.9 Disorder of kidney and ureter, unspecified", "OsZLkK4uLiQ"),
    ("ICD10", "N29", "N29 Other disorders of kidney and ureter in diseases classified elsewhere", "xQhZqNIsKYV"),
    ("ICD10", "N29.0", "N29.0 Late syphilis of kidney", "Xh4x6IVbk88"),
    ("ICD10", "N29.1", "N29.1 Other disorders of kidney and ureter in infectious and parasitic diseases classified elsewhere", "TP6r24glxSL"),
    ("ICD10", "N29.8", "N29.8 Other disorders of kidney and ureter in other diseases classified elsewhere", "vYBNsQjEEoV"),
    ("ICD10", "N30", "N30 Cystitis", "LsP2IVQkcoM"),
    ("ICD10", "N30.0", "N30.0 Acute cystitis", "m0QiDX2m26I"),
    ("ICD10", "N30.1", "N30.1 Interstitial cystitis (chronic)", "jE4MJcgh4IA"),
    ("ICD10", "N30.2", "N30.2 Other chronic cystitis", "fmQXmgyvYq0"),
    ("ICD10", "N30.3", "N30.3 Trigonitis", "yfr2AmMuwGT"),
    ("ICD10", "N30.4", "N30.4 Irradiation cystitis", "Sm8yy04LHBk"),
    ("ICD10", "N30.8", "N30.8 Other cystitis", "VCgDF3BqZaN"),
    ("ICD10", "N30.9", "N30.9 Cystitis, unspecified", "qzBJtSK397e"),
    ("ICD10", "N31", "N31 Neuromuscular dysfunction of bladder, not elsewhere classified", "ZpVspk3J3SS"),
    ("ICD10", "N31.0", "N31.0 Uninhibited neuropathic bladder, not elsewhere classified", "XJU0tHISOcG"),
    ("ICD10", "N31.1", "N31.1 Reflex neuropathic bladder, not elsewhere classified", "epUcJDzic5q"),
    ("ICD10", "N31.2", "N31.2 Flaccid neuropathic bladder, not elsewhere classified", "Byh11zRwZiV"),
    ("ICD10", "N31.8", "N31.8 Other neuromuscular dysfunction of bladder", "rMrd9qTRPsM"),
    ("ICD10", "N31.9", "N31.9 Neuromuscular dysfunction of bladder, unspecified", "WWBxnNH3GER"),
    ("ICD10", "N32", "N32 Other disorders of bladder", "vpD5yB2Drel"),
    ("ICD10", "N32.0", "N32.0 Bladder-neck obstruction", "XqgUpfL81es"),
    ("ICD10", "N32.1", "N32.1 Vesicointestinal fistula", "r58fOa2B7rk"),
    ("ICD10", "N32.2", "N32.2 Vesical fistula, not elsewhere classified", "LuAb31hIj7V"),
    ("ICD10", "N32.3", "N32.3 Diverticulum of bladder", "GoT9fGcZaql"),
    ("ICD10", "N32.4", "N32.4 Rupture of bladder, nontraumatic", "Ui8pMjaMqdD"),
    ("ICD10", "N32.8", "N32.8 Other specified disorders of bladder", "cMH0NiVeRFQ"),
    ("ICD10", "N32.9", "N32.9 Bladder disorder, unspecified", "KySdtl8nEq7"),
    ("ICD10", "N33", "N33 Bladder disorders in diseases classified elsewhere", "PxrKRUAwc31"),
    ("ICD10", "N33.0", "N33.0 Tuberculous cystitis", "yjD5kETYDrp"),
    ("ICD10", "N33.8", "N33.8 Bladder disorders in other diseases classified elsewhere", "C2rMmuT2K3d"),
    ("ICD10", "N34", "N34 Urethritis and urethral syndrome", "ewnSeQDtN3E"),
    ("ICD10", "N34.0", "N34.0 Urethral abscess", "Y4WzH8xEypA"),
    ("ICD10", "N34.1", "N34.1 Nonspecific urethritis", "eYghqIZzQ6w"),
    ("ICD10", "N34.2", "N34.2 Other urethritis", "yNHY4HtZnR1"),
    ("ICD10", "N34.3", "N34.3 Urethral syndrome, unspecified", "a8O5GxCrLpB"),
    ("ICD10", "N35", "N35 Urethral stricture", "Xk1sDvqOGPk"),
    ("ICD10", "N35.0", "N35.0 Post-traumatic urethral stricture", "fEPIgpkEPdy"),
    ("ICD10", "N35.1", "N35.1 Postinfective urethral stricture, not elsewhere classified", "nKOfGSoKgAb"),
    ("ICD10", "N35.8", "N35.8 Other urethral stricture", "xosw3B0zn2y"),
    ("ICD10", "N35.9", "N35.9 Urethral stricture, unspecified", "w3ORY1PEtQ5"),
    ("ICD10", "N36", "N36 Other disorders of urethra", "lLfgcoH2Bfb"),
    ("ICD10", "N36.0", "N36.0 Urethral fistula", "qSUMbHjHE2o"),
    ("ICD10", "N36.1", "N36.1 Urethral diverticulum", "V63fB5qnBn0"),
    ("ICD10", "N36.2", "N36.2 Urethral caruncle", "WhO6Z5VvQBA"),
    ("ICD10", "N36.3", "N36.3 Prolapsed urethral mucosa", "WE0SvxIfIoX"),
    ("ICD10", "N36.8", "N36.8 Other specified disorders of urethra", "BC73Cc3Y7ns"),
    ("ICD10", "N36.9", "N36.9 Urethral disorder, unspecified", "W61v8ynpTO1"),
    ("ICD10", "N37", "N37 Urethral disorders in diseases classified elsewhere", "qy3cYG1lA2h"),
    ("ICD10", "N37.0", "N37.0 Urethritis in diseases classified elsewhere", "XFhpCoNias3"),
    ("ICD10", "N37.8", "N37.8 Other urethral disorders in diseases classified elsewhere", "OkMDlnixI7S"),
    ("ICD10", "N39", "N39 Other disorders of urinary system", "GKQRzNOtwP2"),
    ("ICD10", "N39.0", "N39.0 Urinary tract infection, site not specified", "rx9siTx7I0r"),
    ("ICD10", "N39.1", "N39.1 Persistent proteinuria, unspecified", "q2hzlke0KCo"),
    ("ICD10", "N39.2", "N39.2 Orthostatic proteinuria, unspecified", "beEevvjHKFU"),
    ("ICD10", "N39.3", "N39.3 Stress incontinence", "H5unkT9D2pC"),
    ("ICD10", "N39.4", "N39.4 Other specified urinary incontinence", "OtLuVDiau1C"),
    ("ICD10", "N39.8", "N39.8 Other specified disorders of urinary system", "sLSKaKWwVkN"),
    ("ICD10", "N39.9", "N39.9 Disorder of urinary system, unspecified", "udEYZmNfbEu"),
    ("ICD10", "N40", "N40 Hyperplasia of prostate", "AbGGdNozcIh"),
    ("ICD10", "N41", "N41 Inflammatory diseases of prostate", "BIB8UWzuQEv"),
    ("ICD10", "N41.0", "N41.0 Acute prostatitis", "xpRsDa3sNIo"),
    ("ICD10", "N41.1", "N41.1 Chronic prostatitis", "I6Nu5oapsy0"),
    ("ICD10", "N41.2", "N41.2 Abscess of prostate", "b3ELiMuRgx0"),
    ("ICD10", "N41.3", "N41.3 Prostatocystitis", "rTVgzkO3yyR"),
    ("ICD10", "N41.8", "N41.8 Other inflammatory diseases of prostate", "G1lXrejbojS"),
    ("ICD10", "N41.9", "N41.9 Inflammatory disease of prostate, unspecified", "DX9nUjjRV5n"),
    ("ICD10", "N42", "N42 Other disorders of prostate", "m7Rgq7hln2u"),
    ("ICD10", "N42.0", "N42.0 Calculus of prostate", "BHYRil5j1xY"),
    ("ICD10", "N42.1", "N42.1 Congestion and haemorrhage of prostate", "nQc5ENgqA9W"),
    ("ICD10", "N42.2", "N42.2 Atrophy of prostate", "h4i4Y23dGtI"),
    ("ICD10", "N42.3", "N42.3 Dysplasia of prostate", "bpEQo1lVOm8"),
    ("ICD10", "N42.8", "N42.8 Other specified disorders of prostate", "jGJr53Kwq8L"),
    ("ICD10", "N42.9", "N42.9 Disorder of prostate, unspecified", "aXiMaBl4hci"),
    ("ICD10", "N43", "N43 Hydrocele and spermatocele", "G9fTjJwFc6H"),
    ("ICD10", "N43.0", "N43.0 Encysted hydrocele", "VdxfojHvBEA"),
    ("ICD10", "N43.1", "N43.1 Infected hydrocele", "w092mH2o2Bx"),
    ("ICD10", "N43.2", "N43.2 Other hydrocele", "Gc0RHwixC68"),
    ("ICD10", "N43.3", "N43.3 Hydrocele, unspecified", "ZVbRypiuZIN"),
    ("ICD10", "N43.4", "N43.4 Spermatocele", "SdjAMvA9dUO"),
    ("ICD10", "N44", "N44 Torsion of testis", "MOdTrothV83"),
    ("ICD10", "N45", "N45 Orchitis and epididymitis", "iBYc4zF27yz"),
    ("ICD10", "N45.0", "N45.0 Orchitis, epididymitis and epididymo-orchitis with abscess", "FoNGStZewWj"),
    ("ICD10", "N45.9", "N45.9 Orchitis, epididymitis and epididymo-orchitis without abscess", "jQPYJEskxFU"),
    ("ICD10", "N46", "N46 Male infertility", "YZb404JIKkO"),
    ("ICD10", "N47", "N47 Redundant prepuce, phimosis and paraphimosis", "YY7GPVFd8FQ"),
    ("ICD10", "N48", "N48 Other disorders of penis", "izhUDTEe67p"),
    ("ICD10", "N48.0", "N48.0 Leukoplakia of penis", "ilgxZWAuZ1r"),
    ("ICD10", "N48.1", "N48.1 Balanoposthitis", "i9KEvnLMku6"),
    ("ICD10", "N48.2", "N48.2 Other inflammatory disorders of penis", "ahsLXI3sP9q"),
    ("ICD10", "N48.3", "N48.3 Priapism", "hRyG1XD6ROy"),
    ("ICD10", "N48.4", "N48.4 Impotence of organic origin", "WMyiugjvM1o"),
    ("ICD10", "N48.5", "N48.5 Ulcer of penis", "COWjGHAM0po"),
    ("ICD10", "N48.6", "N48.6 Induratio penis plastica", "EjwFG82HPkG"),
    ("ICD10", "N48.8", "N48.8 Other specified disorders of penis", "GpunFpPHVs8"),
    ("ICD10", "N48.9", "N48.9 Disorder of penis, unspecified", "cu13lFrrA3O"),
    ("ICD10", "N49", "N49 Inflammatory disorders of male genital organs, not elsewhere classified", "mdiZM48sHh4"),
    ("ICD10", "N49.0", "N49.0 Inflammatory disorders of seminal vesicle", "yrcTfFIbeno"),
    ("ICD10", "N49.1", "N49.1 Inflammatory disorders of spermatic cord, tunica vaginalis and vas deferens", "kDcih5eHS4B"),
    ("ICD10", "N49.2", "N49.2 Inflammatory disorders of scrotum", "AMXfzsRMaXY"),
    ("ICD10", "N49.8", "N49.8 Inflammatory disorders of other specified male genital organs", "FVToCaYNGvy"),
    ("ICD10", "N49.9", "N49.9 Inflammatory disorder of unspecified male genital organ", "tMqArnNqwYA"),
    ("ICD10", "N50", "N50 Other disorders of male genital organs", "YXwgfvHkjHR"),
    ("ICD10", "N50.0", "N50.0 Atrophy of testis", "A2vbUVV2JMt"),
    ("ICD10", "N50.1", "N50.1 Vascular disorders of male genital organs", "o5csk12gQnK"),
    ("ICD10", "N50.8", "N50.8 Other specified disorders of male genital organs", "qy6MJX85Vte"),
    ("ICD10", "N50.9", "N50.9 Disorder of male genital organs, unspecified", "P8q9lS1jAjN"),
    ("ICD10", "N51", "N51 Disorders of male genital organs in diseases classified elsewhere", "Otder5W35Ig"),
    ("ICD10", "N51.0", "N51.0 Disorders of prostate in diseases classified elsewhere", "ieyADKptStx"),
    ("ICD10", "N51.1", "N51.1 Disorders of testis and epididymis in diseases classified elsewhere", "ccib3cOwbWw"),
    ("ICD10", "N51.2", "N51.2 Balanitis in diseases classified elsewhere", "gqU127PaiGm"),
    ("ICD10", "N51.8", "N51.8 Other disorders of male genital organs in diseases classified elsewhere", "shn3gbgie1o"),
    ("ICD10", "N60", "N60 Benign mammary dysplasia", "LuThC485KLr"),
    ("ICD10", "N60.0", "N60.0 Solitary cyst of breast", "QrBi2LKvlKE"),
    ("ICD10", "N60.1", "N60.1 Diffuse cystic mastopathy", "Iftt5uFrODh"),
    ("ICD10", "N60.2", "N60.2 Fibroadenosis of breast", "V0qIqnpIpze"),
    ("ICD10", "N60.3", "N60.3 Fibrosclerosis of breast", "o9n7xcNi0SV"),
    ("ICD10", "N60.4", "N60.4 Mammary duct ectasia", "lmAngsKcl3c"),
    ("ICD10", "N60.8", "N60.8 Other benign mammary dysplasias", "sgGluW8bJEZ"),
    ("ICD10", "N60.9", "N60.9 Benign mammary dysplasia, unspecified", "COYCa9nvw0x"),
    ("ICD10", "N61", "N61 Inflammatory disorders of breast", "X6SscYdVcXk"),
    ("ICD10", "N62", "N62 Hypertrophy of breast", "YZJmB9DAlcN"),
    ("ICD10", "N63", "N63 Unspecified lump in breast", "ku4HqSUYmiZ"),
    ("ICD10", "N64", "N64 Other disorders of breast", "d4hbPqWr8jk"),
    ("ICD10", "N64.0", "N64.0 Fissure and fistula of nipple", "ZZPShPAmSmA"),
    ("ICD10", "N64.1", "N64.1 Fat necrosis of breast", "durOOedn4v0"),
    ("ICD10", "N64.2", "N64.2 Atrophy of breast", "eNIFE0CjOzd"),
    ("ICD10", "N64.3", "N64.3 Galactorrhoea not associated with childbirth", "FwYqQ2Pdyn5"),
    ("ICD10", "N64.4", "N64.4 Mastodynia", "cLZCiDUZlsr"),
    ("ICD10", "N64.5", "N64.5 Other signs and symptoms in breast", "PhYmhOy9u5h"),
    ("ICD10", "N64.8", "N64.8 Other specified disorders of breast", "KfbflsPRCWK"),
    ("ICD10", "N64.9", "N64.9 Disorder of breast, unspecified", "wbf4aT89poa"),
    ("ICD10", "N70", "N70 Salpingitis and oophoritis", "Hscfiq9oZr4"),
    ("ICD10", "N70.0", "N70.0 Acute salpingitis and oophoritis", "s23hKWGk3b4"),
    ("ICD10", "N70.1", "N70.1 Chronic salpingitis and oophoritis", "WnTrjmsqPPN"),
    ("ICD10", "N70.9", "N70.9 Salpingitis and oophoritis, unspecified", "hUPzFguU3Is"),
    ("ICD10", "N71", "N71 Inflammatory disease of uterus, except cervix", "AzReqnO81Fn"),
    ("ICD10", "N71.0", "N71.0 Acute inflammatory disease of uterus", "kvr5HEehJXd"),
    ("ICD10", "N71.1", "N71.1 Chronic inflammatory disease of uterus", "AYuleNKMNq7"),
    ("ICD10", "N71.9", "N71.9 Inflammatory disease of uterus, unspecified", "spDphHuTCvm"),
    ("ICD10", "N72", "N72 Inflammatory disease of cervix uteri", "M22i525WVTJ"),
    ("ICD10", "N73", "N73 Other female pelvic inflammatory diseases", "LlO3geE3GWw"),
    ("ICD10", "N73.0", "N73.0 Acute parametritis and pelvic cellulitis", "ir1yvtvFPla"),
    ("ICD10", "N73.1", "N73.1 Chronic parametritis and pelvic cellulitis", "UqF4L2dLHUH"),
    ("ICD10", "N73.2", "N73.2 Unspecified parametritis and pelvic cellulitis", "cHerkCCmGVD"),
    ("ICD10", "N73.3", "N73.3 Female acute pelvic peritonitis", "XkgRrgcuF6A"),
    ("ICD10", "N73.4", "N73.4 Female chronic pelvic peritonitis", "PKdDRzGkXTi"),
    ("ICD10", "N73.5", "N73.5 Female pelvic peritonitis, unspecified", "SNuiYgf4E4f"),
    ("ICD10", "N73.6", "N73.6 Female pelvic peritoneal adhesions", "ovJGIFDouL2"),
    ("ICD10", "N73.8", "N73.8 Other specified female pelvic inflammatory diseases", "JN2jvVlnCXw"),
    ("ICD10", "N73.9", "N73.9 Female pelvic inflammatory disease, unspecified", "jP30wojQLM3"),
    ("ICD10", "N74", "N74 Female pelvic inflammatory disorders in diseases classified elsewhere", "BKWiybS0886"),
    ("ICD10", "N74.0", "N74.0 Tuberculous infection of cervix uteri", "jlYMisODKRX"),
    ("ICD10", "N74.1", "N74.1 Female tuberculous pelvic inflammatory disease", "GZTNQJHxthM"),
    ("ICD10", "N74.2", "N74.2 Female syphilitic pelvic inflammatory disease", "ha5Ro3RutVO"),
    ("ICD10", "N74.3", "N74.3 Female gonococcal pelvic inflammatory disease", "MIkwQEFY00L"),
    ("ICD10", "N74.4", "N74.4 Female chlamydial pelvic inflammatory disease", "GDluK8LYjqW"),
    ("ICD10", "N74.8", "N74.8 Female pelvic inflammatory disorders in other diseases classified elsewhere", "izpTJVfichr"),
    ("ICD10", "N75", "N75 Diseases of Bartholin gland", "mqzcDGDZ1JX"),
    ("ICD10", "N75.0", "N75.0 Cyst of Bartholin gland", "FkUobetCF9D"),
    ("ICD10", "N75.1", "N75.1 Abscess of Bartholin gland", "KDGkJaFZ9ex"),
    ("ICD10", "N75.8", "N75.8 Other diseases of Bartholin gland", "M8pxGm9lc8q"),
    ("ICD10", "N75.9", "N75.9 Disease of Bartholin gland, unspecified", "BbvMSYScfGF"),
    ("ICD10", "N76", "N76 Other inflammation of vagina and vulva", "JBvS7KcCIqO"),
    ("ICD10", "N76.0", "N76.0 Acute vaginitis", "EeNHCIa7smf"),
    ("ICD10", "N76.1", "N76.1 Subacute and chronic vaginitis", "t0E9ogTjMl6"),
    ("ICD10", "N76.2", "N76.2 Acute vulvitis", "eIgewa0XtNT"),
    ("ICD10", "N76.3", "N76.3 Subacute and chronic vulvitis", "d62YrdweOYg"),
    ("ICD10", "N76.4", "N76.4 Abscess of vulva", "sQnbEuFgbFs"),
    ("ICD10", "N76.5", "N76.5 Ulceration of vagina", "ADsQIDSMJJ7"),
    ("ICD10", "N76.6", "N76.6 Ulceration of vulva", "JR8d2fu9ykz"),
    ("ICD10", "N76.8", "N76.8 Other specified inflammation of vagina and vulva", "WeJ9P30vPZ0"),
    ("ICD10", "N77", "N77 Vulvovaginal ulceration and inflammation in diseases classified elsewhere", "Pz5WTcFhDF8"),
    ("ICD10", "N77.0", "N77.0 Ulceration of vulva in infectious and parasitic diseases classified elsewhere", "lcNHv9TW89y"),
    ("ICD10", "N77.1", "N77.1 Vaginitis, vulvitis and vulvovaginitis in infectious and parasitic diseases classified elsewhere", "cDcRQ7wPdZp"),
    ("ICD10", "N77.8", "N77.8 Vulvovaginal ulceration and inflammation in other diseases classified elsewhere", "sTlyfLghHWd"),
    ("ICD10", "N80", "N80 Endometriosis", "IjVG4urEp8y"),
    ("ICD10", "N80.0", "N80.0 Endometriosis of uterus", "QT1U0aYmXAf"),
    ("ICD10", "N80.1", "N80.1 Endometriosis of ovary", "tt089v3XwRD"),
    ("ICD10", "N80.2", "N80.2 Endometriosis of fallopian tube", "yun0faHdXm0"),
    ("ICD10", "N80.3", "N80.3 Endometriosis of pelvic peritoneum", "wV2g5eeON6W"),
    ("ICD10", "N80.4", "N80.4 Endometriosis of rectovaginal septum and vagina", "cLzVEH6Hhap"),
    ("ICD10", "N80.5", "N80.5 Endometriosis of intestine", "WIBnAeCv3Q1"),
    ("ICD10", "N80.6", "N80.6 Endometriosis in cutaneous scar", "vfkhsx0vW4l"),
    ("ICD10", "N80.8", "N80.8 Other endometriosis", "OW8gER5eqni"),
    ("ICD10", "N80.9", "N80.9 Endometriosis, unspecified", "MNVXmOOuX4v"),
    ("ICD10", "N81", "N81 Female genital prolapse", "Oxw8a78L0QP"),
    ("ICD10", "N81.0", "N81.0 Female urethrocele", "iDZLEIJFDdU"),
    ("ICD10", "N81.1", "N81.1 Cystocele", "byCI4GACgtB"),
    ("ICD10", "N81.2", "N81.2 Incomplete uterovaginal prolapse", "WgmDVKb60Zz"),
    ("ICD10", "N81.3", "N81.3 Complete uterovaginal prolapse", "VeJsbICWXF5"),
    ("ICD10", "N81.4", "N81.4 Uterovaginal prolapse, unspecified", "xsrg0uSao39"),
    ("ICD10", "N81.5", "N81.5 Vaginal enterocele", "ae77HYEYM14"),
    ("ICD10", "N81.6", "N81.6 Rectocele", "YMhijWnI8Rl"),
    ("ICD10", "N81.8", "N81.8 Other female genital prolapse", "JC6ycrOZrwa"),
    ("ICD10", "N81.9", "N81.9 Female genital prolapse, unspecified", "RjfF5yiteLP"),
    ("ICD10", "N82", "N82 Fistulae involving female genital tract", "sYEbTPaKr9H"),
    ("ICD10", "N82.0", "N82.0 Vesicovaginal fistula", "LXY1o7r1e3U"),
    ("ICD10", "N82.1", "N82.1 Other female urinary-genital tract fistulae", "iBk0Vz9i4dL"),
    ("ICD10", "N82.2", "N82.2 Fistula of vagina to small intestine", "l336n5jzJtM"),
    ("ICD10", "N82.3", "N82.3 Fistula of vagina to large intestine", "t8IorkUidS9"),
    ("ICD10", "N82.4", "N82.4 Other female intestinal-genital tract fistulae", "B2hy7oKbfF6"),
    ("ICD10", "N82.5", "N82.5 Female genital tract-skin fistulae", "ZIJSmDwaBuP"),
    ("ICD10", "N82.8", "N82.8 Other female genital tract fistulae", "HJczYHv7qIF"),
    ("ICD10", "N82.9", "N82.9 Female genital tract fistula, unspecified", "NYkiNAquSSV"),
    ("ICD10", "N83", "N83 Noninflammatory disorders of ovary, fallopian tube and broad ligament", "o90P4FD3vZc"),
    ("ICD10", "N83.0", "N83.0 Follicular cyst of ovary", "V1ZoTp5xHhp"),
    ("ICD10", "N83.1", "N83.1 Corpus luteum cyst", "AkkZZ1kliHF"),
    ("ICD10", "N83.2", "N83.2 Other and unspecified ovarian cysts", "LKaTAmo4kfH"),
    ("ICD10", "N83.3", "N83.3 Acquired atrophy of ovary and fallopian tube", "jxp6vIOLjos"),
    ("ICD10", "N83.4", "N83.4 Prolapse and hernia of ovary and fallopian tube", "Ke4NBO1JQ4l"),
    ("ICD10", "N83.5", "N83.5 Torsion of ovary, ovarian pedicle and fallopian tube", "YjqIX1KgkOG"),
    ("ICD10", "N83.6", "N83.6 Haematosalpinx", "J4x7txIZskM"),
    ("ICD10", "N83.7", "N83.7 Haematoma of broad ligament", "fMQwvIwNd75"),
    ("ICD10", "N83.8", "N83.8 Other noninflammatory disorders of ovary, fallopian tube and broad ligament", "iM9sr3d6GzD"),
    ("ICD10", "N83.9", "N83.9 Noninflammatory disorder of ovary, fallopian tube and broad ligament, unspecified", "lZwH2y0vSyg"),
    ("ICD10", "N84", "N84 Polyp of female genital tract", "FKvn021IW6z"),
    ("ICD10", "N84.0", "N84.0 Polyp of corpus uteri", "zCvB5r1mEoA");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "N84.1", "N84.1 Polyp of cervix uteri", "QJ7zoPU1if6"),
    ("ICD10", "N84.2", "N84.2 Polyp of vagina", "TTIFG3sGHI1"),
    ("ICD10", "N84.3", "N84.3 Polyp of vulva", "yanZMdGUpqx"),
    ("ICD10", "N84.8", "N84.8 Polyp of other parts of female genital tract", "Ew0O8MlnY0w"),
    ("ICD10", "N84.9", "N84.9 Polyp of female genital tract, unspecified", "kjzH44ZwWTk"),
    ("ICD10", "N85", "N85 Other noninflammatory disorders of uterus, except cervix", "rmkhn3PRvgb"),
    ("ICD10", "N85.0", "N85.0 Endometrial glandular hyperplasia", "UTNlfvDQ2ID"),
    ("ICD10", "N85.1", "N85.1 Endometrial adenomatous hyperplasia", "qYlc0hBI2d5"),
    ("ICD10", "N85.2", "N85.2 Hypertrophy of uterus", "Ej9Q7aM5sbi"),
    ("ICD10", "N85.3", "N85.3 Subinvolution of uterus", "Opc2p8hMclg"),
    ("ICD10", "N85.4", "N85.4 Malposition of uterus", "XqU8pfteu5T"),
    ("ICD10", "N85.5", "N85.5 Inversion of uterus", "MXmg0Elcfyh"),
    ("ICD10", "N85.6", "N85.6 Intrauterine synechiae", "rTLlbqmHIwS"),
    ("ICD10", "N85.7", "N85.7 Haematometra", "QI4vAv2w9Xb"),
    ("ICD10", "N85.8", "N85.8 Other specified noninflammatory disorders of uterus", "TzOiHfbqsO3"),
    ("ICD10", "N85.9", "N85.9 Noninflammatory disorder of uterus, unspecified", "rttVFijqW8E"),
    ("ICD10", "N86", "N86 Erosion and ectropion of cervix uteri", "O2ogedpaBPL"),
    ("ICD10", "N87", "N87 Dysplasia of cervix uteri", "N0djkqpAlSU"),
    ("ICD10", "N87.0", "N87.0 Mild cervical dysplasia", "JyRVHP8twXy"),
    ("ICD10", "N87.1", "N87.1 Moderate cervical dysplasia", "b5c7TuYdhN6"),
    ("ICD10", "N87.2", "N87.2 Severe cervical dysplasia, not elsewhere classified", "Xs4lQ9DGO9T"),
    ("ICD10", "N87.9", "N87.9 Dysplasia of cervix uteri, unspecified", "QAhYRXklfrr"),
    ("ICD10", "N88", "N88 Other noninflammatory disorders of cervix uteri", "MdCBYUqLAlL"),
    ("ICD10", "N88.0", "N88.0 Leukoplakia of cervix uteri", "BIjJ092vdM1"),
    ("ICD10", "N88.1", "N88.1 Old laceration of cervix uteri", "IqrDvVXCejl"),
    ("ICD10", "N88.2", "N88.2 Stricture and stenosis of cervix uteri", "ewiwYgfeEkR"),
    ("ICD10", "N88.3", "N88.3 Incompetence of cervix uteri", "Q2ZMQQymmz6"),
    ("ICD10", "N88.4", "N88.4 Hypertrophic elongation of cervix uteri", "sTWcbe7ExDc"),
    ("ICD10", "N88.8", "N88.8 Other specified noninflammatory disorders of cervix uteri", "GFWQu3KOMp2"),
    ("ICD10", "N88.9", "N88.9 Noninflammatory disorder of cervix uteri, unspecified", "HVOjiBdUZO3"),
    ("ICD10", "N89", "N89 Other noninflammatory disorders of vagina", "EQ91MJh86kl"),
    ("ICD10", "N89.0", "N89.0 Mild vaginal dysplasia", "HxSPog3VxQZ"),
    ("ICD10", "N89.1", "N89.1 Moderate vaginal dysplasia", "lIvoeJURgp4"),
    ("ICD10", "N89.2", "N89.2 Severe vaginal dysplasia, not elsewhere classified", "C1IfDI3R4cR"),
    ("ICD10", "N89.3", "N89.3 Dysplasia of vagina, unspecified", "rvuBFe3vhI0"),
    ("ICD10", "N89.4", "N89.4 Leukoplakia of vagina", "KYXDWuAYQrc"),
    ("ICD10", "N89.5", "N89.5 Stricture and atresia of vagina", "py6g1LMfCEW"),
    ("ICD10", "N89.6", "N89.6 Tight hymenal ring", "OghMrfAiMHR"),
    ("ICD10", "N89.7", "N89.7 Haematocolpos", "BB0tmlI2mqS"),
    ("ICD10", "N89.8", "N89.8 Other specified noninflammatory disorders of vagina", "SMpFGl0UhRs"),
    ("ICD10", "N89.9", "N89.9 Noninflammatory disorder of vagina, unspecified", "P5b3olfu6Tt"),
    ("ICD10", "N90", "N90 Other noninflammatory disorders of vulva and perineum", "uV0tkSLeRm4"),
    ("ICD10", "N90.0", "N90.0 Mild vulvar dysplasia", "vbUGpwS9CVR"),
    ("ICD10", "N90.1", "N90.1 Moderate vulvar dysplasia", "EMiknLnA0n7"),
    ("ICD10", "N90.2", "N90.2 Severe vulvar dysplasia, not elsewhere classified", "DPoKYv49ohm"),
    ("ICD10", "N90.3", "N90.3 Dysplasia of vulva, unspecified", "cSburuTPMju"),
    ("ICD10", "N90.4", "N90.4 Leukoplakia of vulva", "SSCEvq2RLu7"),
    ("ICD10", "N90.5", "N90.5 Atrophy of vulva", "YvR4SipbUjy"),
    ("ICD10", "N90.6", "N90.6 Hypertrophy of vulva", "wK1hIeVP5k6"),
    ("ICD10", "N90.7", "N90.7 Vulvar cyst", "x8EXr9JU77C"),
    ("ICD10", "N90.8", "N90.8 Other specified noninflammatory disorders of vulva and perineum", "cKx9i1vnoRc"),
    ("ICD10", "N90.9", "N90.9 Noninflammatory disorder of vulva and perineum, unspecified", "EwuLnBjtV7M"),
    ("ICD10", "N91", "N91 Absent, scanty and rare menstruation", "VYRvGHvXvug"),
    ("ICD10", "N91.0", "N91.0 Primary amenorrhoea", "BhHUwhEh9Bp"),
    ("ICD10", "N91.1", "N91.1 Secondary amenorrhoea", "YQxI7JtunRe"),
    ("ICD10", "N91.2", "N91.2 Amenorrhoea, unspecified", "NAd8HWwfvgi"),
    ("ICD10", "N91.3", "N91.3 Primary oligomenorrhoea", "IsHjAIKNKiz"),
    ("ICD10", "N91.4", "N91.4 Secondary oligomenorrhoea", "IqDEtMzZVMc"),
    ("ICD10", "N91.5", "N91.5 Oligomenorrhoea, unspecified", "V07BVKWRMVV"),
    ("ICD10", "N92", "N92 Excessive, frequent and irregular menstruation", "MLX0qWg85Rk"),
    ("ICD10", "N92.0", "N92.0 Excessive and frequent menstruation with regular cycle", "WMHXyX5XIw5"),
    ("ICD10", "N92.1", "N92.1 Excessive and frequent menstruation with irregular cycle", "z0qYaDwoALo"),
    ("ICD10", "N92.2", "N92.2 Excessive menstruation at puberty", "eiw5k8TIhF1"),
    ("ICD10", "N92.3", "N92.3 Ovulation bleeding", "GeX6g0e2oqR"),
    ("ICD10", "N92.4", "N92.4 Excessive bleeding in the premenopausal period", "pGfrZzJKjmX"),
    ("ICD10", "N92.5", "N92.5 Other specified irregular menstruation", "i533gIQqAGw"),
    ("ICD10", "N92.6", "N92.6 Irregular menstruation, unspecified", "f3N9d0XMjR4"),
    ("ICD10", "N93", "N93 Other abnormal uterine and vaginal bleeding", "nGH5grU5ewp"),
    ("ICD10", "N93.0", "N93.0 Postcoital and contact bleeding", "zgBjtsCRciC"),
    ("ICD10", "N93.8", "N93.8 Other specified abnormal uterine and vaginal bleeding", "FoaAzg0cLc1"),
    ("ICD10", "N93.9", "N93.9 Abnormal uterine and vaginal bleeding, unspecified", "Y0E4TEhT1vY"),
    ("ICD10", "N94", "N94 Pain and other conditions associated with female genital organs and menstrual cycle", "wqbGAZl1WAP"),
    ("ICD10", "N94.0", "N94.0 Mittelschmerz", "x8FSP2Cof6R"),
    ("ICD10", "N94.1", "N94.1 Dyspareunia", "ZWrogc7ULYC"),
    ("ICD10", "N94.2", "N94.2 Vaginismus", "ICilpxQNvE5"),
    ("ICD10", "N94.3", "N94.3 Premenstrual tension syndrome", "FWh1Sb3wJGq"),
    ("ICD10", "N94.4", "N94.4 Primary dysmenorrhoea", "n4pLdgd8Y08"),
    ("ICD10", "N94.5", "N94.5 Secondary dysmenorrhoea", "InQhRJz3pjx"),
    ("ICD10", "N94.6", "N94.6 Dysmenorrhoea, unspecified", "xi3NMpKeLQI"),
    ("ICD10", "N94.8", "N94.8 Other specified conditions associated with female genital organs and menstrual cycle", "dpHrUJHDqQO"),
    ("ICD10", "N94.9", "N94.9 Unspecified condition associated with female genital organs and menstrual cycle", "qLP1Zqj3SyF"),
    ("ICD10", "N95", "N95 Menopausal and other perimenopausal disorders", "vT0f2dcTkue"),
    ("ICD10", "N95.0", "N95.0 Postmenopausal bleeding", "rPZ4aKrUxSn"),
    ("ICD10", "N95.1", "N95.1 Menopausal and female climacteric states", "Ex2zqrNkDwE"),
    ("ICD10", "N95.2", "N95.2 Postmenopausal atrophic vaginitis", "J1aPV7t31Ms"),
    ("ICD10", "N95.3", "N95.3 States associated with artificial menopause", "dbL02UFlGS6"),
    ("ICD10", "N95.8", "N95.8 Other specified menopausal and perimenopausal disorders", "pzvk31jpjQ9"),
    ("ICD10", "N95.9", "N95.9 Menopausal and perimenopausal disorder, unspecified", "O3SOjdg05xs"),
    ("ICD10", "N96", "N96 Habitual aborter", "mzrJ3biV9OB"),
    ("ICD10", "N97", "N97 Female infertility", "Krd5YMxaihu"),
    ("ICD10", "N97.0", "N97.0 Female infertility associated with anovulation", "Ii8P5zR7Lnx"),
    ("ICD10", "N97.1", "N97.1 Female infertility of tubal origin", "UDiZZ0BVRSC"),
    ("ICD10", "N97.2", "N97.2 Female infertility of uterine origin", "Oq5cUJNzUAB"),
    ("ICD10", "N97.3", "N97.3 Female infertility of cervical origin", "V5QFPcAGGjQ"),
    ("ICD10", "N97.4", "N97.4 Female infertility associated with male factors", "g4km0Hy5LM1"),
    ("ICD10", "N97.8", "N97.8 Female infertility of other origin", "pgBjZU9A0DH"),
    ("ICD10", "N97.9", "N97.9 Female infertility, unspecified", "HjBBe6i7JNd"),
    ("ICD10", "N98", "N98 Complications associated with artificial fertilization", "i8guUgnaHyW"),
    ("ICD10", "N98.0", "N98.0 Infection associated with artificial insemination", "EUZuZV2sP3N"),
    ("ICD10", "N98.1", "N98.1 Hyperstimulation of ovaries", "QrnH59MTQXA"),
    ("ICD10", "N98.2", "N98.2 Complications of attempted introduction of fertilized ovum following in vitro fertilization", "q2A9PLpjz9v"),
    ("ICD10", "N98.3", "N98.3 Complications of attempted introduction of embryo in embryo transfer", "dbydMMil7HI"),
    ("ICD10", "N98.8", "N98.8 Other complications associated with artificial fertilization", "wW7QHyjxwgS"),
    ("ICD10", "N98.9", "N98.9 Complication associated with artificial fertilization, unspecified", "AJ8UUA076E4"),
    ("ICD10", "N99", "N99 Postprocedural disorders of genitourinary system, not elsewhere classified", "lJ5NOJKxiL7"),
    ("ICD10", "N99.0", "N99.0 Postprocedural renal failure", "uJvNKxRtIrX"),
    ("ICD10", "N99.1", "N99.1 Postprocedural urethral stricture", "gyZfm4DueUy"),
    ("ICD10", "N99.2", "N99.2 Postoperative adhesions of vagina", "nYtLSMn3M2W"),
    ("ICD10", "N99.3", "N99.3 Prolapse of vaginal vault after hysterectomy", "eY3RWlU9kMd"),
    ("ICD10", "N99.4", "N99.4 Postprocedural pelvic peritoneal adhesions", "DThzurJuRWu"),
    ("ICD10", "N99.5", "N99.5 Malfunction of external stoma of urinary tract", "A6bFPGfjNlz"),
    ("ICD10", "N99.8", "N99.8 Other postprocedural disorders of genitourinary system", "nxPWGLDcPSO"),
    ("ICD10", "N99.9", "N99.9 Postprocedural disorder of genitourinary system, unspecified", "dIIv4oMir2a");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "O00", "O00 Ectopic pregnancy", "H6w2ahJxjxj"),
    ("ICD10", "O00.0", "O00.0 Abdominal pregnancy", "lvhi0Tg2av0"),
    ("ICD10", "O00.1", "O00.1 Tubal pregnancy", "zDi5YB4THi1"),
    ("ICD10", "O00.2", "O00.2 Ovarian pregnancy", "L4pFz7GErQg"),
    ("ICD10", "O00.8", "O00.8 Other ectopic pregnancy", "UBifKPrLoAw"),
    ("ICD10", "O00.9", "O00.9 Ectopic pregnancy, unspecified", "Um2q1MfjEFj"),
    ("ICD10", "O01", "O01 Hydatidiform mole", "pAobeRujvza"),
    ("ICD10", "O01.0", "O01.0 Classical hydatidiform mole", "n2KwdsXdk8b"),
    ("ICD10", "O01.1", "O01.1 Incomplete and partial hydatidiform mole", "Q3Pd6Ejj5pw"),
    ("ICD10", "O01.9", "O01.9 Hydatidiform mole, unspecified", "fgPnyrKtq7D"),
    ("ICD10", "O02", "O02 Other abnormal products of conception", "OcP8IU1TG3V"),
    ("ICD10", "O02.0", "O02.0 Blighted ovum and nonhydatidiform mole", "QgWH1OfPFRw"),
    ("ICD10", "O02.1", "O02.1 Missed abortion", "FTmPSsHkCdq"),
    ("ICD10", "O02.8", "O02.8 Other specified abnormal products of conception", "FVOG2Tbs8vN"),
    ("ICD10", "O02.9", "O02.9 Abnormal product of conception, unspecified", "x28iU4lGqa5"),
    ("ICD10", "O03", "O03 Spontaneous abortion", "JDOWPyLtzeh"),
    ("ICD10", "O04", "O04 Medical abortion", "WoJqQleaZ7O"),
    ("ICD10", "O05", "O05 Other abortion", "O8B5jE8JLdy"),
    ("ICD10", "O06", "O06 Unspecified abortion", "WTgDnuIKPgP"),
    ("ICD10", "O07", "O07 Failed attempted abortion", "oIEE5ZIm5Uw"),
    ("ICD10", "O07.0", "O07.0 Failed medical abortion, complicated by genital tract and pelvic infection", "exwPb6TcONK"),
    ("ICD10", "O07.1", "O07.1 Failed medical abortion, complicated by delayed or excessive haemorrhage", "U6ZG3vEIGtf"),
    ("ICD10", "O07.2", "O07.2 Failed medical abortion, complicated by embolism", "ZhWXPnRngIM"),
    ("ICD10", "O07.3", "O07.3 Failed medical abortion, with other and unspecified complications", "IZDqkFowOKI"),
    ("ICD10", "O07.4", "O07.4 Failed medical abortion, without complication", "cYR5ALhgOId"),
    ("ICD10", "O07.5", "O07.5 Other and unspecified failed attempted abortion, complicated by genital tract and pelvic infection", "FOzQ6hrceC9"),
    ("ICD10", "O07.6", "O07.6 Other and unspecified failed attempted abortion, complicated by delayed or excessive haemorrhage", "nmz9QQJNiM2"),
    ("ICD10", "O07.7", "O07.7 Other and unspecified failed attempted abortion, complicated by embolism", "deooiOJ2tv2"),
    ("ICD10", "O07.8", "O07.8 Other and unspecified failed attempted abortion, with other and unspecified complications", "LGo7okveMY9"),
    ("ICD10", "O07.9", "O07.9 Other and unspecified failed attempted abortion, without complication", "K8tE51SJoIu"),
    ("ICD10", "O08", "O08 Complications following abortion and ectopic and molar pregnancy", "QSlgRss4SkP"),
    ("ICD10", "O08.0", "O08.0 Genital tract and pelvic infection following abortion and ectopic and molar pregnancy", "tJz19ttNKJK"),
    ("ICD10", "O08.1", "O08.1 Delayed or excessive haemorrhage following abortion and ectopic and molar pregnancy", "RiF3OWfIilu"),
    ("ICD10", "O08.2", "O08.2 Embolism following abortion and ectopic and molar pregnancy", "jz2kpb5jcmG"),
    ("ICD10", "O08.3", "O08.3 Shock following abortion and ectopic and molar pregnancy", "MiTWhFRdY2c"),
    ("ICD10", "O08.4", "O08.4 Renal failure following abortion and ectopic and molar pregnancy", "npHxTKxeNBq"),
    ("ICD10", "O08.5", "O08.5 Metabolic disorders following abortion and ectopic and molar pregnancy", "Q0SQfS3qXEp"),
    ("ICD10", "O08.6", "O08.6 Damage to pelvic organs and tissues following abortion and ectopic and molar pregnancy", "zP0xrPpKukZ"),
    ("ICD10", "O08.7", "O08.7 Other venous complications following abortion and ectopic and molar pregnancy", "sHj8Y775Znk"),
    ("ICD10", "O08.8", "O08.8 Other complications following abortion and ectopic and molar pregnancy", "ggEAefqC4uw"),
    ("ICD10", "O08.9", "O08.9 Complication following abortion and ectopic and molar pregnancy, unspecified", "NuRn9dCfIFe"),
    ("ICD10", "O10", "O10 Pre-existing hypertension complicating pregnancy, childbirth and the puerperium", "QLmCSsEutk7"),
    ("ICD10", "O10.0", "O10.0 Pre-existing essential hypertension complicating pregnancy, childbirth and the puerperium", "iIa0QFZ7tg0"),
    ("ICD10", "O10.1", "O10.1 Pre-existing hypertensive heart disease complicating pregnancy, childbirth and the puerperium", "R3uy5I1WEK9"),
    ("ICD10", "O10.2", "O10.2 Pre-existing hypertensive renal disease complicating pregnancy, childbirth and the puerperium", "DKx8Xehm55P"),
    ("ICD10", "O10.3", "O10.3 Pre-existing hypertensive heart and renal disease complicating pregnancy, childbirth and the puerperium", "wf6bC8NByO3"),
    ("ICD10", "O10.4", "O10.4 Pre-existing secondary hypertension complicating pregnancy, childbirth and the puerperium", "JvGpWUSnd13"),
    ("ICD10", "O10.9", "O10.9 Unspecified pre-existing hypertension complicating pregnancy, childbirth and the puerperium", "m7tRGr1HK6l"),
    ("ICD10", "O11", "O11 Pre-eclampsia superimposed on chronic hypertension", "mzP7B4W4dgm"),
    ("ICD10", "O12", "O12 Gestational [pregnancy-induced] oedema and proteinuria without hypertension", "a0xloHtl1fZ"),
    ("ICD10", "O12.0", "O12.0 Gestational oedema", "eF3C72V3d3m"),
    ("ICD10", "O12.1", "O12.1 Gestational proteinuria", "Z8vVieE1aKx"),
    ("ICD10", "O12.2", "O12.2 Gestational oedema with proteinuria", "AexAGErrEeO"),
    ("ICD10", "O13", "O13 Gestational [pregnancy-induced] hypertension", "miSqsXm04Ie"),
    ("ICD10", "O14", "O14 Pre-eclampsia", "HCa6YSsblxR"),
    ("ICD10", "O14.0", "O14.0 Mild to moderate pre-eclampsia", "CCQWQUQmGlk"),
    ("ICD10", "O14.1", "O14.1 Severe pre-eclampsia", "urW9jCHCu2U"),
    ("ICD10", "O14.2", "O14.2 HELLP syndrome", "Qr6ptFeBy81"),
    ("ICD10", "O14.9", "O14.9 Pre-eclampsia, unspecified", "NkoboqKvUwA"),
    ("ICD10", "O15", "O15 Eclampsia", "h5axGQouFLk"),
    ("ICD10", "O15.0", "O15.0 Eclampsia in pregnancy", "JNCybUtfa5o"),
    ("ICD10", "O15.1", "O15.1 Eclampsia in labour", "AJ1nWmuwsi0"),
    ("ICD10", "O15.2", "O15.2 Eclampsia in the puerperium", "sc606YNdibk"),
    ("ICD10", "O15.9", "O15.9 Eclampsia, unspecified as to time period", "BtD4zLpAkUn"),
    ("ICD10", "O16", "O16 Unspecified maternal hypertension", "INwhcnHTadE"),
    ("ICD10", "O20", "O20 Haemorrhage in early pregnancy", "MjflPGmhAax"),
    ("ICD10", "O20.0", "O20.0 Threatened abortion", "k8qKS54FuiR"),
    ("ICD10", "O20.8", "O20.8 Other haemorrhage in early pregnancy", "pNUslkW47kT"),
    ("ICD10", "O20.9", "O20.9 Haemorrhage in early pregnancy, unspecified", "DIgDYiWBRP4"),
    ("ICD10", "O21", "O21 Excessive vomiting in pregnancy", "lNDEeY7RQb3"),
    ("ICD10", "O21.0", "O21.0 Mild hyperemesis gravidarum", "vOb48wduEJ6"),
    ("ICD10", "O21.1", "O21.1 Hyperemesis gravidarum with metabolic disturbance", "Ao4VLEvRIRY"),
    ("ICD10", "O21.2", "O21.2 Late vomiting of pregnancy", "ZBzqbOpROc9"),
    ("ICD10", "O21.8", "O21.8 Other vomiting complicating pregnancy", "FWAqyRQMU3D"),
    ("ICD10", "O21.9", "O21.9 Vomiting of pregnancy, unspecified", "EVTrHFTnjTV"),
    ("ICD10", "O22", "O22 Venous complications and haemorrhoids in pregnancy", "pW3Z7V4mL96"),
    ("ICD10", "O22.0", "O22.0 Varicose veins of lower extremity in pregnancy", "XMmlwk3gMyR"),
    ("ICD10", "O22.1", "O22.1 Genital varices in pregnancy", "i7C0GiH61Es"),
    ("ICD10", "O22.2", "O22.2 Superficial thrombophlebitis in pregnancy", "ZQEl3zPaelj"),
    ("ICD10", "O22.3", "O22.3 Deep phlebothrombosis in pregnancy", "npe6JFbrWe2"),
    ("ICD10", "O22.4", "O22.4 Haemorrhoids in pregnancy", "tRWY0WQEoEs"),
    ("ICD10", "O22.5", "O22.5 Cerebral venous thrombosis in pregnancy", "RIMBtsmcw5w"),
    ("ICD10", "O22.8", "O22.8 Other venous complications in pregnancy", "j6oeHx0tXRq"),
    ("ICD10", "O22.9", "O22.9 Venous complication in pregnancy, unspecified", "ArxBoqgw91i"),
    ("ICD10", "O23", "O23 Infections of genitourinary tract in pregnancy", "iFhNp5tgEOs"),
    ("ICD10", "O23.0", "O23.0 Infections of kidney in pregnancy", "xQ8zErL9vdI"),
    ("ICD10", "O23.1", "O23.1 Infections of bladder in pregnancy", "ctonrJV4Mb9"),
    ("ICD10", "O23.2", "O23.2 Infections of urethra in pregnancy", "puzYyC9lhMa"),
    ("ICD10", "O23.3", "O23.3 Infections of other parts of urinary tract in pregnancy", "ZL0QJeLs2Gs"),
    ("ICD10", "O23.4", "O23.4 Unspecified infection of urinary tract in pregnancy", "BJU1bL3Xfcf"),
    ("ICD10", "O23.5", "O23.5 Infections of the genital tract in pregnancy", "hvPXRXXMyfb"),
    ("ICD10", "O23.9", "O23.9 Other and unspecified genitourinary tract infection in pregnancy", "v1tHhsyeERO"),
    ("ICD10", "O24", "O24 Diabetes mellitus in pregnancy", "dPHEr7bGnql"),
    ("ICD10", "O24.0", "O24.0 Diabetes mellitus in pregnancy: Pre-existing diabetes mellitus, insulin-dependent", "BMWzSBuLjUO"),
    ("ICD10", "O24.1", "O24.1 Diabetes mellitus in pregnancy: Pre-existing diabetes mellitus, non-insulin-dependent", "ekRuL36GWGJ"),
    ("ICD10", "O24.2", "O24.2 Diabetes mellitus in pregnancy: Pre-existing malnutrition-related diabetes mellitus", "sccM4U5qlcw"),
    ("ICD10", "O24.3", "O24.3 Diabetes mellitus in pregnancy: Pre-existing diabetes mellitus, unspecified", "IrBQbLLCdMw"),
    ("ICD10", "O24.4", "O24.4 Diabetes mellitus arising in pregnancy", "sgWDLsP0DrA"),
    ("ICD10", "O24.9", "O24.9 Diabetes mellitus in pregnancy, unspecified", "aOmAEqYFNpW"),
    ("ICD10", "O25", "O25 Malnutrition in pregnancy", "VfcR8xk2V7a"),
    ("ICD10", "O26", "O26 Maternal care for other conditions predominantly related to pregnancy", "woYGWKqzOXH"),
    ("ICD10", "O26.0", "O26.0 Excessive weight gain in pregnancy", "F27CCzNt3XL"),
    ("ICD10", "O26.1", "O26.1 Low weight gain in pregnancy", "SEhNcsOu6Hn"),
    ("ICD10", "O26.2", "O26.2 Pregnancy care of habitual aborter", "hx4HN2GJlzV"),
    ("ICD10", "O26.3", "O26.3 Retained intrauterine contraceptive device in pregnancy", "eY0LZiurQ1D"),
    ("ICD10", "O26.4", "O26.4 Herpes gestationis", "LyvsMDMqxKr"),
    ("ICD10", "O26.5", "O26.5 Maternal hypotension syndrome", "RgP6lHAHVyc"),
    ("ICD10", "O26.6", "O26.6 Liver disorders in pregnancy, childbirth and the puerperium", "Gj73vwedcKV"),
    ("ICD10", "O26.7", "O26.7 Subluxation of symphysis (pubis) in pregnancy, childbirth and the puerperium", "u5BU0upCAJz"),
    ("ICD10", "O26.8", "O26.8 Other specified pregnancy-related conditions", "Eo2BmFLFgAz"),
    ("ICD10", "O26.9", "O26.9 Pregnancy-related condition, unspecified", "O1dx1vmw7JD"),
    ("ICD10", "O28", "O28 Abnormal findings on antenatal screening of mother", "he4sfdDoJFr"),
    ("ICD10", "O28.0", "O28.0 Abnormal haematological finding on antenatal screening of mother", "yBZ34IvcGVp"),
    ("ICD10", "O28.1", "O28.1 Abnormal biochemical finding on antenatal screening of mother", "fdbboPsDMKr"),
    ("ICD10", "O28.2", "O28.2 Abnormal cytological finding on antenatal screening of mother", "T3ylopKi4Ej"),
    ("ICD10", "O28.3", "O28.3 Abnormal ultrasonic finding on antenatal screening of mother", "BX2qU263RZS"),
    ("ICD10", "O28.4", "O28.4 Abnormal radiological finding on antenatal screening of mother", "ZeXPyaBcDbS"),
    ("ICD10", "O28.5", "O28.5 Abnormal chromosomal and genetic finding on antenatal screening of mother", "mnbM0KAenAZ"),
    ("ICD10", "O28.8", "O28.8 Other abnormal findings on antenatal screening of mother", "KPb1e25pB3D"),
    ("ICD10", "O28.9", "O28.9 Abnormal finding on antenatal screening of mother, unspecified", "jRnFC4Ea9Ik"),
    ("ICD10", "O29", "O29 Complications of anaesthesia during pregnancy", "qO1kTdBgyqm"),
    ("ICD10", "O29.0", "O29.0 Pulmonary complications of anaesthesia during pregnancy", "qMpD8GRFDjb"),
    ("ICD10", "O29.1", "O29.1 Cardiac complications of anaesthesia during pregnancy", "HmJBdaFTOmV"),
    ("ICD10", "O29.2", "O29.2 Central nervous system complications of anaesthesia during pregnancy", "DNIcUbey6XL"),
    ("ICD10", "O29.3", "O29.3 Toxic reaction to local anaesthesia during pregnancy", "HNW0YYWlXZf"),
    ("ICD10", "O29.4", "O29.4 Spinal and epidural anaesthesia-induced headache during pregnancy", "yVburLP1gwX"),
    ("ICD10", "O29.5", "O29.5 Other complications of spinal and epidural anaesthesia during pregnancy", "O2T5pSyB6a4"),
    ("ICD10", "O29.6", "O29.6 Failed or difficult intubation during pregnancy", "wnCr8NmnRfK"),
    ("ICD10", "O29.8", "O29.8 Other complications of anaesthesia during pregnancy", "zObKFtQwaSv"),
    ("ICD10", "O29.9", "O29.9 Complication of anaesthesia during pregnancy, unspecified", "fMUsVjq7V6B"),
    ("ICD10", "O30", "O30 Multiple gestation", "Je8pi2Nj85r"),
    ("ICD10", "O30.0", "O30.0 Twin pregnancy", "HlQYluFBIit"),
    ("ICD10", "O30.1", "O30.1 Triplet pregnancy", "Lvm3hgYY7T2"),
    ("ICD10", "O30.2", "O30.2 Quadruplet pregnancy", "enQz2KlceL1"),
    ("ICD10", "O30.8", "O30.8 Other multiple gestation", "PrLAjGqQ91f"),
    ("ICD10", "O30.9", "O30.9 Multiple gestation, unspecified", "b12uTom7SiX"),
    ("ICD10", "O31", "O31 Complications specific to multiple gestation", "SpSGvkjjkHx"),
    ("ICD10", "O31.0", "O31.0 Papyraceous fetus", "y0TPRgpyDIR"),
    ("ICD10", "O31.1", "O31.1 Continuing pregnancy after abortion of one fetus or more", "sprtD9P43XL"),
    ("ICD10", "O31.2", "O31.2 Continuing pregnancy after intrauterine death of one fetus or more", "wt5uvd7JQnY"),
    ("ICD10", "O31.8", "O31.8 Other complications specific to multiple gestation", "OsoUq3Nkbkg"),
    ("ICD10", "O32", "O32 Maternal care for known or suspected malpresentation of fetus", "ik1q8H5vbRd"),
    ("ICD10", "O32.0", "O32.0 Maternal care for unstable lie", "tU9MDqdSzqN"),
    ("ICD10", "O32.1", "O32.1 Maternal care for breech presentation", "jH6a7rvwv0H"),
    ("ICD10", "O32.2", "O32.2 Maternal care for transverse and oblique lie", "I58yHMzgBYN"),
    ("ICD10", "O32.3", "O32.3 Maternal care for face, brow and chin presentation", "eFQlEYhw4Dq"),
    ("ICD10", "O32.4", "O32.4 Maternal care for high head at term", "zi8Jb6gTRpM"),
    ("ICD10", "O32.5", "O32.5 Maternal care for multiple gestation with malpresentation of one fetus or more", "Pf0DfAZsSpF"),
    ("ICD10", "O32.6", "O32.6 Maternal care for compound presentation", "IvbgCztqyS3"),
    ("ICD10", "O32.8", "O32.8 Maternal care for other malpresentation of fetus", "HeLISbxAEBf"),
    ("ICD10", "O32.9", "O32.9 Maternal care for malpresentation of fetus, unspecified", "QTCGRQZjP4y"),
    ("ICD10", "O33", "O33 Maternal care for known or suspected disproportion", "TxRqKirZ3OE"),
    ("ICD10", "O33.0", "O33.0 Maternal care for disproportion due to deformity of maternal pelvic bones", "jySnBVR5UVt"),
    ("ICD10", "O33.1", "O33.1 Maternal care for disproportion due to generally contracted pelvis", "eizJWxOtQsA"),
    ("ICD10", "O33.2", "O33.2 Maternal care for disproportion due to inlet contraction of pelvis", "EkySkxNc9wh"),
    ("ICD10", "O33.3", "O33.3 Maternal care for disproportion due to outlet contraction of pelvis", "PdQ0wcMs3Hl"),
    ("ICD10", "O33.4", "O33.4 Maternal care for disproportion of mixed maternal and fetal origin", "c8RFy8Rn3jM"),
    ("ICD10", "O33.5", "O33.5 Maternal care for disproportion due to unusually large fetus", "HH4CvNv1M09"),
    ("ICD10", "O33.6", "O33.6 Maternal care for disproportion due to hydrocephalic fetus", "D5a3mHdoDDq"),
    ("ICD10", "O33.7", "O33.7 Maternal care for disproportion due to other fetal deformities", "FrPJ2rODnk7"),
    ("ICD10", "O33.8", "O33.8 Maternal care for disproportion of other origin", "vmAwql3dtbA"),
    ("ICD10", "O33.9", "O33.9 Maternal care for disproportion, unspecified", "FdaVilgCBFN"),
    ("ICD10", "O34", "O34 Maternal care for known or suspected abnormality of pelvic organs", "dDsfqIE2JLn"),
    ("ICD10", "O34.0", "O34.0 Maternal care for congenital malformation of uterus", "joVXaQZ9I2m"),
    ("ICD10", "O34.1", "O34.1 Maternal care for tumour of corpus uteri", "mETa3IkLnS5"),
    ("ICD10", "O34.2", "O34.2 Maternal care due to uterine scar from previous surgery", "Pzpjh9iHFc1"),
    ("ICD10", "O34.3", "O34.3 Maternal care for cervical incompetence", "sxzy2yRsOmw"),
    ("ICD10", "O34.4", "O34.4 Maternal care for other abnormalities of cervix", "IaHn750AtYA"),
    ("ICD10", "O34.5", "O34.5 Maternal care for other abnormalities of gravid uterus", "OAocfNWxsaV"),
    ("ICD10", "O34.6", "O34.6 Maternal care for abnormality of vagina", "rrJ1bGvjjQR"),
    ("ICD10", "O34.7", "O34.7 Maternal care for abnormality of vulva and perineum", "HZDPTfPnz0H"),
    ("ICD10", "O34.8", "O34.8 Maternal care for other abnormalities of pelvic organs", "zQsVEKomNP2"),
    ("ICD10", "O34.9", "O34.9 Maternal care for abnormality of pelvic organ, unspecified", "Rf7rP305yCv"),
    ("ICD10", "O35", "O35 Maternal care for known or suspected fetal abnormality and damage", "h0AyvzgYuet"),
    ("ICD10", "O35.0", "O35.0 Maternal care for (suspected) central nervous system malformation in fetus", "yTEsyD4HaL7"),
    ("ICD10", "O35.1", "O35.1 Maternal care for (suspected) chromosomal abnormality in fetus", "duzDLLr8q4V"),
    ("ICD10", "O35.2", "O35.2 Maternal care for (suspected) hereditary disease in fetus", "wmsN1B5xhKe"),
    ("ICD10", "O35.3", "O35.3 Maternal care for (suspected) damage to fetus from viral disease in mother", "RstdhfTAw3m"),
    ("ICD10", "O35.4", "O35.4 Maternal care for (suspected) damage to fetus from alcohol", "XFYL8Mwrc8R"),
    ("ICD10", "O35.5", "O35.5 Maternal care for (suspected) damage to fetus by drugs", "HeCNqtbA3mc"),
    ("ICD10", "O35.6", "O35.6 Maternal care for (suspected) damage to fetus by radiation", "rNY8uNvXjQU"),
    ("ICD10", "O35.7", "O35.7 Maternal care for (suspected) damage to fetus by other medical procedures", "iHcma7HlHgU"),
    ("ICD10", "O35.8", "O35.8 Maternal care for other (suspected) fetal abnormality and damage", "CeFXk1mO5x5"),
    ("ICD10", "O35.9", "O35.9 Maternal care for (suspected) fetal abnormality and damage, unspecified", "Ib0OikUpawQ"),
    ("ICD10", "O36", "O36 Maternal care for other known or suspected fetal problems", "ekE0ev1QdGa"),
    ("ICD10", "O36.0", "O36.0 Maternal care for rhesus isoimmunization", "uxBRQ2VFyic"),
    ("ICD10", "O36.1", "O36.1 Maternal care for other isoimmunization", "XQUArDWJc8u"),
    ("ICD10", "O36.2", "O36.2 Maternal care for hydrops fetalis", "oH1VYnhdirW"),
    ("ICD10", "O36.3", "O36.3 Maternal care for signs of fetal hypoxia", "NAJ2Ec36jqL"),
    ("ICD10", "O36.4", "O36.4 Maternal care for intrauterine death", "jB5rvrz9k7a"),
    ("ICD10", "O36.5", "O36.5 Maternal care for poor fetal growth", "iND9UAipAMb"),
    ("ICD10", "O36.6", "O36.6 Maternal care for excessive fetal growth", "KfCLE6jeTdp"),
    ("ICD10", "O36.7", "O36.7 Maternal care for viable fetus in abdominal pregnancy", "psJKny5zEw9"),
    ("ICD10", "O36.8", "O36.8 Maternal care for other specified fetal problems", "Gt9irh8toa8"),
    ("ICD10", "O36.9", "O36.9 Maternal care for fetal problem, unspecified", "pHMrJQTg6gk"),
    ("ICD10", "O40", "O40 Polyhydramnios", "HDKcCL9PlHx"),
    ("ICD10", "O41", "O41 Other disorders of amniotic fluid and membranes", "FiI1roSc7zw"),
    ("ICD10", "O41.0", "O41.0 Oligohydramnios", "e21afnG3iIj"),
    ("ICD10", "O41.1", "O41.1 Infection of amniotic sac and membranes", "OhESqvkEtmK"),
    ("ICD10", "O41.8", "O41.8 Other specified disorders of amniotic fluid and membranes", "Bqb2twudZbA"),
    ("ICD10", "O41.9", "O41.9 Disorder of amniotic fluid and membranes, unspecified", "rh9YQqh5lJX"),
    ("ICD10", "O42", "O42 Premature rupture of membranes", "HEPp7DtqTs0"),
    ("ICD10", "O42.0", "O42.0 Premature rupture of membranes, onset of labour within 24 hours", "FtyN5eKQsE4"),
    ("ICD10", "O42.1", "O42.1 Premature rupture of membranes, onset of labour after 24 hours", "PZgkoXShI88"),
    ("ICD10", "O42.2", "O42.2 Premature rupture of membranes, labour delayed by therapy", "PjKWUtoSELs"),
    ("ICD10", "O42.9", "O42.9 Premature rupture of membranes, unspecified", "ZOhtdYgkupA"),
    ("ICD10", "O43", "O43 Placental disorders", "hIThm7mMdFq"),
    ("ICD10", "O43.0", "O43.0 Placental transfusion syndromes", "yZIg4AKQJDM"),
    ("ICD10", "O43.1", "O43.1 Malformation of placenta", "lvOoe5evGj2"),
    ("ICD10", "O43.2", "O43.2 Morbidly adherent placenta", "tgXC3t4xYxk"),
    ("ICD10", "O43.8", "O43.8 Other placental disorders", "sUuvKviZQD1"),
    ("ICD10", "O43.9", "O43.9 Placental disorder, unspecified", "w7VZvHdMm8R"),
    ("ICD10", "O44", "O44 Placenta praevia", "H6BirqdQkYp"),
    ("ICD10", "O44.0", "O44.0 Placenta praevia specified as without haemorrhage", "iYbIBMaW0tj"),
    ("ICD10", "O44.1", "O44.1 Placenta praevia with haemorrhage", "IaiRRhAuc8z"),
    ("ICD10", "O45", "O45 Premature separation of placenta [abruptio placentae]", "rjiEdtUjpb5"),
    ("ICD10", "O45.0", "O45.0 Premature separation of placenta with coagulation defect", "o8FZGScfLMP"),
    ("ICD10", "O45.8", "O45.8 Other premature separation of placenta", "U8OmHMIBIyf"),
    ("ICD10", "O45.9", "O45.9 Premature separation of placenta, unspecified", "OBcAZBbyfxH"),
    ("ICD10", "O46", "O46 Antepartum haemorrhage, not elsewhere classified", "YxcGU3ALfwD"),
    ("ICD10", "O46.0", "O46.0 Antepartum haemorrhage with coagulation defect", "flTzxJR6tm1"),
    ("ICD10", "O46.8", "O46.8 Other antepartum haemorrhage", "ZiduLJc7Tfr"),
    ("ICD10", "O46.9", "O46.9 Antepartum haemorrhage, unspecified", "A2ucguWjoP8"),
    ("ICD10", "O47", "O47 False labour", "tsOaaCgK3Ln"),
    ("ICD10", "O47.0", "O47.0 False labour before 37 completed weeks of gestation", "oeIE2vZSGh2"),
    ("ICD10", "O47.1", "O47.1 False labour at or after 37 completed weeks of gestation", "WMrfkyyGXBZ"),
    ("ICD10", "O47.9", "O47.9 False labour, unspecified", "MBmPzWdYLMu"),
    ("ICD10", "O48", "O48 Prolonged pregnancy", "SD58g84EdlM"),
    ("ICD10", "O60", "O60 Preterm labour and delivery", "Ep4aFiuL4oN"),
    ("ICD10", "O60.0", "O60.0 Preterm labour without delivery", "TJqFPnGJHb3"),
    ("ICD10", "O60.1", "O60.1 Preterm spontaneous labour with preterm delivery", "HGCcgDXRXJR"),
    ("ICD10", "O60.2", "O60.2 Preterm spontaneous labour with term delivery", "OOouyRQonP7"),
    ("ICD10", "O60.3", "O60.3 Preterm delivery without spontaneous labour", "xU3sAoJQlGu"),
    ("ICD10", "O61", "O61 Failed induction of labour", "Qc2pWLPEX9K"),
    ("ICD10", "O61.0", "O61.0 Failed medical induction of labour", "Cv4H6Poiv2c"),
    ("ICD10", "O61.1", "O61.1 Failed instrumental induction of labour", "DNrUY8UhS0n"),
    ("ICD10", "O61.8", "O61.8 Other failed induction of labour", "ua9zPl2Nxcc"),
    ("ICD10", "O61.9", "O61.9 Failed induction of labour, unspecified", "WO6gGoEXnBd"),
    ("ICD10", "O62", "O62 Abnormalities of forces of labour", "ATvcHfYFyJN"),
    ("ICD10", "O62.0", "O62.0 Primary inadequate contractions", "zE0bPrJUSM7"),
    ("ICD10", "O62.1", "O62.1 Secondary uterine inertia", "s9YnAw0Nqq5"),
    ("ICD10", "O62.2", "O62.2 Other uterine inertia", "fq0PdSy1zYD"),
    ("ICD10", "O62.3", "O62.3 Precipitate labour", "F20cET4pzVX"),
    ("ICD10", "O62.4", "O62.4 Hypertonic, incoordinate, and prolonged uterine contractions", "BQTcNgC1jgk"),
    ("ICD10", "O62.8", "O62.8 Other abnormalities of forces of labour", "FeJSi23iZXf"),
    ("ICD10", "O62.9", "O62.9 Abnormality of forces of labour, unspecified", "gIt9zsJ9z26"),
    ("ICD10", "O63", "O63 Long labour", "KsloUOx9mwW"),
    ("ICD10", "O63.0", "O63.0 Prolonged first stage (of labour)", "V1JDBSYVY4S"),
    ("ICD10", "O63.1", "O63.1 Prolonged second stage (of labour)", "oyhZV3rulDW"),
    ("ICD10", "O63.2", "O63.2 Delayed delivery of second twin, triplet, etc.", "ddiiJYLBdvB"),
    ("ICD10", "O63.9", "O63.9 Long labour, unspecified", "uVTy3vOIuSQ"),
    ("ICD10", "O64", "O64 Obstructed labour due to malposition and malpresentation of fetus", "gP5TAaR8vct"),
    ("ICD10", "O64.0", "O64.0 Obstructed labour due to incomplete rotation of fetal head", "KKoJCWIE9GV"),
    ("ICD10", "O64.1", "O64.1 Obstructed labour due to breech presentation", "mL2ymZDBvNS"),
    ("ICD10", "O64.2", "O64.2 Obstructed labour due to face presentation", "JCqA50HEmIt"),
    ("ICD10", "O64.3", "O64.3 Obstructed labour due to brow presentation", "T0cceyvc6sl"),
    ("ICD10", "O64.4", "O64.4 Obstructed labour due to shoulder presentation", "j6LfDm9jFSV"),
    ("ICD10", "O64.5", "O64.5 Obstructed labour due to compound presentation", "fqcWzLYar7s"),
    ("ICD10", "O64.8", "O64.8 Obstructed labour due to other malposition and malpresentation", "A1YaNdF0cce"),
    ("ICD10", "O64.9", "O64.9 Obstructed labour due to malposition and malpresentation, unspecified", "qturcsQ2aCW"),
    ("ICD10", "O65", "O65 Obstructed labour due to maternal pelvic abnormality", "Mj7zJZJ3aYp"),
    ("ICD10", "O65.0", "O65.0 Obstructed labour due to deformed pelvis", "QfqKueYU12A"),
    ("ICD10", "O65.1", "O65.1 Obstructed labour due to generally contracted pelvis", "RVVkaxWOvR4"),
    ("ICD10", "O65.2", "O65.2 Obstructed labour due to pelvic inlet contraction", "sOGkFnosPeG"),
    ("ICD10", "O65.3", "O65.3 Obstructed labour due to pelvic outlet and mid-cavity contraction", "jsPygDNWrsD"),
    ("ICD10", "O65.4", "O65.4 Obstructed labour due to fetopelvic disproportion, unspecified", "fVGhjJiycrc"),
    ("ICD10", "O65.5", "O65.5 Obstructed labour due to abnormality of maternal pelvic organs", "yPV6P3bbEAu"),
    ("ICD10", "O65.8", "O65.8 Obstructed labour due to other maternal pelvic abnormalities", "qt3B1lFF2Eu"),
    ("ICD10", "O65.9", "O65.9 Obstructed labour due to maternal pelvic abnormality, unspecified", "gA5zbwyYilY"),
    ("ICD10", "O66", "O66 Other obstructed labour", "KGawIL8UCcl"),
    ("ICD10", "O66.0", "O66.0 Obstructed labour due to shoulder dystocia", "UIiuLqRp3Gs"),
    ("ICD10", "O66.1", "O66.1 Obstructed labour due to locked twins", "r5znsMbm9d9"),
    ("ICD10", "O66.2", "O66.2 Obstructed labour due to unusually large fetus", "YZ5Qt5PEhqa"),
    ("ICD10", "O66.3", "O66.3 Obstructed labour due to other abnormalities of fetus", "rAZrZLFkpFB"),
    ("ICD10", "O66.4", "O66.4 Failed trial of labour, unspecified", "Chydk1p4K6c"),
    ("ICD10", "O66.5", "O66.5 Failed application of vacuum extractor and forceps, unspecified", "k8dx44tiV5l"),
    ("ICD10", "O66.8", "O66.8 Other specified obstructed labour", "ug3HBrE4RVU"),
    ("ICD10", "O66.9", "O66.9 Obstructed labour, unspecified", "HDSfReTSHrl"),
    ("ICD10", "O67", "O67 Labour and delivery complicated by intrapartum haemorrhage, not elsewhere classified", "AG4E41ivf0F"),
    ("ICD10", "O67.0", "O67.0 Intrapartum haemorrhage with coagulation defect", "S8qBK6HiT4h"),
    ("ICD10", "O67.8", "O67.8 Other intrapartum haemorrhage", "UjgmNQUdURf"),
    ("ICD10", "O67.9", "O67.9 Intrapartum haemorrhage, unspecified", "yG8a97bmICA"),
    ("ICD10", "O68", "O68 Labour and delivery complicated by fetal stress [distress]", "aWUBQC4MDZk"),
    ("ICD10", "O68.0", "O68.0 Labour and delivery complicated by fetal heart rate anomaly", "doOB4CobGzQ"),
    ("ICD10", "O68.1", "O68.1 Labour and delivery complicated by meconium in amniotic fluid", "ieglTjB50pS"),
    ("ICD10", "O68.2", "O68.2 Labour and delivery complicated by fetal heart rate anomaly with meconium in amniotic fluid", "j3P45vJdZot"),
    ("ICD10", "O68.3", "O68.3 Labour and delivery complicated by biochemical evidence of fetal stress", "lBJ86cV1lNF"),
    ("ICD10", "O68.8", "O68.8 Labour and delivery complicated by other evidence of fetal stress", "UOQtF6wth5I"),
    ("ICD10", "O68.9", "O68.9 Labour and delivery complicated by fetal stress, unspecified", "uFHaQoJX60h"),
    ("ICD10", "O69", "O69 Labour and delivery complicated by umbilical cord complications", "yiDmCRMZy2O"),
    ("ICD10", "O69.0", "O69.0 Labour and delivery complicated by prolapse of cord", "yVhqGz3B6hs"),
    ("ICD10", "O69.1", "O69.1 Labour and delivery complicated by cord around neck, with compression", "FsdcRB8IB47"),
    ("ICD10", "O69.2", "O69.2 Labour and delivery complicated by other cord entanglement, with compression", "gBST7t0XMsp"),
    ("ICD10", "O69.3", "O69.3 Labour and delivery complicated by short cord", "EgwPDUPVywf"),
    ("ICD10", "O69.4", "O69.4 Labour and delivery complicated by vasa praevia", "sWHPRnK32Td"),
    ("ICD10", "O69.5", "O69.5 Labour and delivery complicated by vascular lesion of cord", "NCVMtSxTexJ"),
    ("ICD10", "O69.8", "O69.8 Labour and delivery complicated by other cord complications", "YMObgeBjiUG"),
    ("ICD10", "O69.9", "O69.9 Labour and delivery complicated by cord complication, unspecified", "X4webxMOuTO"),
    ("ICD10", "O70", "O70 Perineal laceration during delivery", "iGJdXQiaidX"),
    ("ICD10", "O70.0", "O70.0 First degree perineal laceration during delivery", "DwwjF9OLAyo"),
    ("ICD10", "O70.1", "O70.1 Second degree perineal laceration during delivery", "QVRb8Rk2lzq"),
    ("ICD10", "O70.2", "O70.2 Third degree perineal laceration during delivery", "Vma9k9w4pvB"),
    ("ICD10", "O70.3", "O70.3 Fourth degree perineal laceration during delivery", "QrI7WUxujJW"),
    ("ICD10", "O70.9", "O70.9 Perineal laceration during delivery, unspecified", "c7o0JM75t4n"),
    ("ICD10", "O71", "O71 Other obstetric trauma", "CW5gG45yAN5"),
    ("ICD10", "O71.0", "O71.0 Rupture of uterus before onset of labour", "DorxNbfwD3g"),
    ("ICD10", "O71.1", "O71.1 Rupture of uterus during labour", "bYANKHt47tn"),
    ("ICD10", "O71.2", "O71.2 Postpartum inversion of uterus", "hB8UiM6r8tM"),
    ("ICD10", "O71.3", "O71.3 Obstetric laceration of cervix", "YJrZuvTgHQ9"),
    ("ICD10", "O71.4", "O71.4 Obstetric high vaginal laceration", "zMzOi6TM9zN");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "O71.5", "O71.5 Other obstetric injury to pelvic organs", "d6A3d2uBaCZ"),
    ("ICD10", "O71.6", "O71.6 Obstetric damage to pelvic joints and ligaments", "DepA4vPxiwG"),
    ("ICD10", "O71.7", "O71.7 Obstetric haematoma of pelvis", "Sa3SeM8TrzT"),
    ("ICD10", "O71.8", "O71.8 Other specified obstetric trauma", "zREoXsCy6hA"),
    ("ICD10", "O71.9", "O71.9 Obstetric trauma, unspecified", "qc5tMQhIBxw"),
    ("ICD10", "O72", "O72 Postpartum haemorrhage", "EJeKiNG7jGo"),
    ("ICD10", "O72.0", "O72.0 Third-stage haemorrhage", "mnLN5F710nU"),
    ("ICD10", "O72.1", "O72.1 Other immediate postpartum haemorrhage", "t8pj69TK1o2"),
    ("ICD10", "O72.2", "O72.2 Delayed and secondary postpartum haemorrhage", "csjSn06aaq8"),
    ("ICD10", "O72.3", "O72.3 Postpartum coagulation defects", "z7AujzxurAk"),
    ("ICD10", "O73", "O73 Retained placenta and membranes, without haemorrhage", "Ek3eIusvrim"),
    ("ICD10", "O73.0", "O73.0 Retained placenta without haemorrhage", "eP1FP1mZ3jK"),
    ("ICD10", "O73.1", "O73.1 Retained portions of placenta and membranes, without haemorrhage", "k105yhwwsfl"),
    ("ICD10", "O74", "O74 Complications of anaesthesia during labour and delivery", "vzJu5TAFTl6"),
    ("ICD10", "O74.0", "O74.0 Aspiration pneumonitis due to anaesthesia during labour and delivery", "y3vfOcE0xoQ"),
    ("ICD10", "O74.1", "O74.1 Other pulmonary complications of anaesthesia during labour and delivery", "ed4zmhmStlM"),
    ("ICD10", "O74.2", "O74.2 Cardiac complications of anaesthesia during labour and delivery", "qlKlCdBVxyX"),
    ("ICD10", "O74.3", "O74.3 Central nervous system complications of anaesthesia during labour and delivery", "D14CuSyzFtE"),
    ("ICD10", "O74.4", "O74.4 Toxic reaction to local anaesthesia during labour and delivery", "ELnqutrtrca"),
    ("ICD10", "O74.5", "O74.5 Spinal and epidural anaesthesia-induced headache during labour and delivery", "TR0bQNUiweR"),
    ("ICD10", "O74.6", "O74.6 Other complications of spinal and epidural anaesthesia during labour and delivery", "cJV9GF6jJg3"),
    ("ICD10", "O74.7", "O74.7 Failed or difficult intubation during labour and delivery", "zuLbTck6R9d"),
    ("ICD10", "O74.8", "O74.8 Other complications of anaesthesia during labour and delivery", "Yvp6O1FJIeV"),
    ("ICD10", "O74.9", "O74.9 Complication of anaesthesia during labour and delivery, unspecified", "KR1TlmDLIhi"),
    ("ICD10", "O75", "O75 Other complications of labour and delivery, not elsewhere classified", "o74icZEJazm"),
    ("ICD10", "O75.0", "O75.0 Maternal distress during labour and delivery", "o9nHrDOA5R5"),
    ("ICD10", "O75.1", "O75.1 Shock during or following labour and delivery", "Dsd7UhLd1c3"),
    ("ICD10", "O75.2", "O75.2 Pyrexia during labour, not elsewhere classified", "szMzYfi1HQJ"),
    ("ICD10", "O75.3", "O75.3 Other infection during labour", "htnoMJLZvEN"),
    ("ICD10", "O75.4", "O75.4 Other complications of obstetric surgery and procedures", "CgUbK8FG2II"),
    ("ICD10", "O75.5", "O75.5 Delayed delivery after artificial rupture of membranes", "ldYqCePnOv3"),
    ("ICD10", "O75.6", "O75.6 Delayed delivery after spontaneous or unspecified rupture of membranes", "tZomzi9lyRz"),
    ("ICD10", "O75.7", "O75.7 Vaginal delivery following previous caesarean section", "R1LXAsecVfV"),
    ("ICD10", "O75.8", "O75.8 Other specified complications of labour and delivery", "T4OKkytAWqA"),
    ("ICD10", "O75.9", "O75.9 Complication of labour and delivery, unspecified", "XUFK2gsfL91"),
    ("ICD10", "O80", "O80 Single spontaneous delivery", "z7x1W2SKoqa"),
    ("ICD10", "O80.0", "O80.0 Spontaneous vertex delivery", "d7MvoX4q3qU"),
    ("ICD10", "O80.1", "O80.1 Spontaneous breech delivery", "TpfVqyyC9sZ"),
    ("ICD10", "O80.8", "O80.8 Other single spontaneous delivery", "QKVcH2OFuw9"),
    ("ICD10", "O80.9", "O80.9 Single spontaneous delivery, unspecified", "Thsx90ygAs0"),
    ("ICD10", "O81", "O81 Single delivery by forceps and vacuum extractor", "mDWTKibFsMa"),
    ("ICD10", "O81.0", "O81.0 Low forceps delivery", "VW4mK688hA9"),
    ("ICD10", "O81.1", "O81.1 Mid-cavity forceps delivery", "EfFdYwME4k9"),
    ("ICD10", "O81.2", "O81.2 Mid-cavity forceps with rotation", "cE4gjpbz9k7"),
    ("ICD10", "O81.3", "O81.3 Other and unspecified forceps delivery", "WP9YcT1LFl8"),
    ("ICD10", "O81.4", "O81.4 Vacuum extractor delivery", "ggAVnrw0Cc6"),
    ("ICD10", "O81.5", "O81.5 Delivery by combination of forceps and vacuum extractor", "Xk4TWdE3HYm"),
    ("ICD10", "O82", "O82 Single delivery by caesarean section", "KLTluGammwK"),
    ("ICD10", "O82.0", "O82.0 Delivery by elective caesarean section", "ztvG9FUa0UG"),
    ("ICD10", "O82.1", "O82.1 Delivery by emergency caesarean section", "j86XMF9Sz6R"),
    ("ICD10", "O82.2", "O82.2 Delivery by caesarean hysterectomy", "eet94RtwQuq"),
    ("ICD10", "O82.8", "O82.8 Other single delivery by caesarean section", "lZpCEM4GoZd"),
    ("ICD10", "O82.9", "O82.9 Delivery by caesarean section, unspecified", "KUihxxGXm6b"),
    ("ICD10", "O83", "O83 Other assisted single delivery", "gcuTbpQac47"),
    ("ICD10", "O83.0", "O83.0 Breech extraction", "MsGn3D8uTID"),
    ("ICD10", "O83.1", "O83.1 Other assisted breech delivery", "nouARdbTi2I"),
    ("ICD10", "O83.2", "O83.2 Other manipulation-assisted delivery", "mh1wrqBMZdz"),
    ("ICD10", "O83.3", "O83.3 Delivery of viable fetus in abdominal pregnancy", "FrbhMSrF0f7"),
    ("ICD10", "O83.4", "O83.4 Destructive operation for delivery", "UpCwiBDPAQP"),
    ("ICD10", "O83.8", "O83.8 Other specified assisted single delivery", "o570IPvVSPB"),
    ("ICD10", "O83.9", "O83.9 Assisted single delivery, unspecified", "Wphr2N03YyC"),
    ("ICD10", "O84", "O84 Multiple delivery", "mo2QDuhPhQu"),
    ("ICD10", "O84.0", "O84.0 Multiple delivery, all spontaneous", "Ax46v4MR8oq"),
    ("ICD10", "O84.1", "O84.1 Multiple delivery, all by forceps and vacuum extractor", "nR6dAysCKMG"),
    ("ICD10", "O84.2", "O84.2 Multiple delivery, all by caesarean section", "awsQhy1weSS"),
    ("ICD10", "O84.8", "O84.8 Other multiple delivery", "rwjkcjngS6k"),
    ("ICD10", "O84.9", "O84.9 Multiple delivery, unspecified", "DgcGmyxUXc0"),
    ("ICD10", "O85", "O85 Puerperal sepsis", "MzovRJxAAuN"),
    ("ICD10", "O86", "O86 Other puerperal infections", "y6jqu6tBeI1"),
    ("ICD10", "O86.0", "O86.0 Infection of obstetric surgical wound", "S6Zjtu3kyBL"),
    ("ICD10", "O86.1", "O86.1 Other infection of genital tract following delivery", "b5nmFZFAQPq"),
    ("ICD10", "O86.2", "O86.2 Urinary tract infection following delivery", "G9LGju8enEL"),
    ("ICD10", "O86.3", "O86.3 Other genitourinary tract infections following delivery", "rdH1xvHj1Xt"),
    ("ICD10", "O86.4", "O86.4 Pyrexia of unknown origin following delivery", "O6aLKUu6oE5"),
    ("ICD10", "O86.8", "O86.8 Other specified puerperal infections", "BBVDjAfjIj6"),
    ("ICD10", "O87", "O87 Venous complications and haemorrhoids in the puerperium", "f6EfqJoVC2x"),
    ("ICD10", "O87.0", "O87.0 Superficial thrombophlebitis in the puerperium", "T6eQHLKbEVJ"),
    ("ICD10", "O87.1", "O87.1 Deep phlebothrombosis in the puerperium", "CYgTucBcNSa"),
    ("ICD10", "O87.2", "O87.2 Haemorrhoids in the puerperium", "EUyl5Ecf9v4"),
    ("ICD10", "O87.3", "O87.3 Cerebral venous thrombosis in the puerperium", "iFYEgXB5ENT"),
    ("ICD10", "O87.8", "O87.8 Other venous complications in the puerperium", "xzPsBCUhVcC"),
    ("ICD10", "O87.9", "O87.9 Venous complication in the puerperium, unspecified", "HzSJADGj1E1"),
    ("ICD10", "O88", "O88 Obstetric embolism", "V3AVDYJQ0XG"),
    ("ICD10", "O88.0", "O88.0 Obstetric air embolism", "pIxr4mGH38Q"),
    ("ICD10", "O88.1", "O88.1 Amniotic fluid embolism", "CvOpuGZVNMh"),
    ("ICD10", "O88.2", "O88.2 Obstetric blood-clot embolism", "HSLWHIloBS9"),
    ("ICD10", "O88.3", "O88.3 Obstetric pyaemic and septic embolism", "V7C8pSCivYf"),
    ("ICD10", "O88.8", "O88.8 Other obstetric embolism", "vdHnXdXODGs"),
    ("ICD10", "O89", "O89 Complications of anaesthesia during the puerperium", "hVA4oQXLHCN"),
    ("ICD10", "O89.0", "O89.0 Pulmonary complications of anaesthesia during the puerperium", "gXJ0BwGl5V3"),
    ("ICD10", "O89.1", "O89.1 Cardiac complications of anaesthesia during the puerperium", "w7L7TGMB3ET"),
    ("ICD10", "O89.2", "O89.2 Central nervous system complications of anaesthesia during the puerperium", "e9tibKw17OX"),
    ("ICD10", "O89.3", "O89.3 Toxic reaction to local anaesthesia during the puerperium", "nynBMuyty0d"),
    ("ICD10", "O89.4", "O89.4 Spinal and epidural anaesthesia-induced headache during the puerperium", "S2GyIJTl2de"),
    ("ICD10", "O89.5", "O89.5 Other complications of spinal and epidural anaesthesia during the puerperium", "isFs2IIm5G3"),
    ("ICD10", "O89.6", "O89.6 Failed or difficult intubation during the puerperium", "A0TOv97f2A1"),
    ("ICD10", "O89.8", "O89.8 Other complications of anaesthesia during the puerperium", "HN1vq2WKTbQ"),
    ("ICD10", "O89.9", "O89.9 Complication of anaesthesia during the puerperium, unspecified", "uyDos1KOsqm"),
    ("ICD10", "O90", "O90 Complications of the puerperium, not elsewhere classified", "R3g3Zdglwfs"),
    ("ICD10", "O90.0", "O90.0 Disruption of caesarean section wound", "aXPJRa790fU"),
    ("ICD10", "O90.1", "O90.1 Disruption of perineal obstetric wound", "dd5y7ZptEbu"),
    ("ICD10", "O90.2", "O90.2 Haematoma of obstetric wound", "oJPf2R6ubIG"),
    ("ICD10", "O90.3", "O90.3 Cardiomyopathy in the puerperium", "wDDKqxcGqSl"),
    ("ICD10", "O90.4", "O90.4 Postpartum acute renal failure", "JEKWA9Ua4KK"),
    ("ICD10", "O90.5", "O90.5 Postpartum thyroiditis", "qZjbmD9pGv9"),
    ("ICD10", "O90.8", "O90.8 Other complications of the puerperium, not elsewhere classified", "Ta8KnYWKnpa"),
    ("ICD10", "O90.9", "O90.9 Complication of the puerperium, unspecified", "zJoybgvOnnE"),
    ("ICD10", "O91", "O91 Infections of breast associated with childbirth", "ImmjsfDdL1p"),
    ("ICD10", "O91.0", "O91.0 Infection of nipple associated with childbirth", "q9psUXDaFDx"),
    ("ICD10", "O91.1", "O91.1 Abscess of breast associated with childbirth", "r7dkXMVsHE0"),
    ("ICD10", "O91.2", "O91.2 Nonpurulent mastitis associated with childbirth", "hFGdfHoUB1Z"),
    ("ICD10", "O92", "O92 Other disorders of breast and lactation associated with childbirth", "FFRMSHp3xoh"),
    ("ICD10", "O92.0", "O92.0 Retracted nipple associated with childbirth", "bCLmXFcIx6l"),
    ("ICD10", "O92.1", "O92.1 Cracked nipple associated with childbirth", "oUUgcMLz8cY"),
    ("ICD10", "O92.2", "O92.2 Other and unspecified disorders of breast associated with childbirth", "r6caAWdgTWQ"),
    ("ICD10", "O92.3", "O92.3 Agalactia", "M6pWaOdqIrI"),
    ("ICD10", "O92.4", "O92.4 Hypogalactia", "phbgLsRwP27"),
    ("ICD10", "O92.5", "O92.5 Suppressed lactation", "wuVUAq1zyLf"),
    ("ICD10", "O92.6", "O92.6 Galactorrhoea", "Wsjm5bkFJR6"),
    ("ICD10", "O92.7", "O92.7 Other and unspecified disorders of lactation", "uhwiXtRHHyS"),
    ("ICD10", "O94", "O94 Sequelae of complication of pregnancy, childbirth and the puerperium", "davjFQSYzfs"),
    ("ICD10", "O95", "O95 Obstetric death of unspecified cause", "YKZFHJB4umy"),
    ("ICD10", "O96", "O96 Death from any obstetric cause occurring more than 42 days but less than one year after delivery", "NZJYRVv69Se"),
    ("ICD10", "O96.0", "O96.0 Death from direct obstetric cause occurring more than 42 days but less than one year after delivery", "gda6z7jT86c"),
    ("ICD10", "O96.1", "O96.1 Death from indirect obstetric cause occurring more than 42 days but less than one year after delivery", "gwDOF9APGLp"),
    ("ICD10", "O96.9", "O96.9 Death from unspecified obstetric cause occurring more than 42 days but less than one year after delivery", "TRmZEn6JqlH"),
    ("ICD10", "O97", "O97 Death from sequelae of obstetric causes", "P5UblFPIfRs"),
    ("ICD10", "O97.0", "O97.0 Death from sequelae of direct obstetric cause", "niPKfDTjzua"),
    ("ICD10", "O97.1", "O97.1 Death from sequelae of indirect obstetric cause", "tns5rwOG7D5"),
    ("ICD10", "O97.9", "O97.9 Death from sequelae of obstetric cause, unspecified", "YfEmjJVYmfD"),
    ("ICD10", "O98", "O98 Maternal infectious and parasitic diseases classifiable elsewhere but complicating pregnancy, childbirth and the puerperium", "wE4bgckjAvH"),
    ("ICD10", "O98.0", "O98.0 Tuberculosis complicating pregnancy, childbirth and the puerperium", "vdhHdOgEO4L"),
    ("ICD10", "O98.1", "O98.1 Syphilis complicating pregnancy, childbirth and the puerperium", "zQ5GishC9ja"),
    ("ICD10", "O98.2", "O98.2 Gonorrhoea complicating pregnancy, childbirth and the puerperium", "imej3qFvu6X"),
    ("ICD10", "O98.3", "O98.3 Other infections with a predominantly sexual mode of transmission complicating pregnancy, childbirth and the puerperium", "N10HIzJU0sE"),
    ("ICD10", "O98.4", "O98.4 Viral hepatitis complicating pregnancy, childbirth and the puerperium", "ShR8ZaKAkzK"),
    ("ICD10", "O98.5", "O98.5 Other viral diseases complicating pregnancy, childbirth and the puerperium", "l5W5u2JEOfi"),
    ("ICD10", "O98.6", "O98.6 Protozoal diseases complicating pregnancy, childbirth and the puerperium", "abZdQRMFPhZ"),
    ("ICD10", "O98.7", "O98.7 Human immunodeficiency virus [HIV] disease complicating pregnancy, childbirth and the puerperium", "nZ8T7LXH16l"),
    ("ICD10", "O98.8", "O98.8 Other maternal infectious and parasitic diseases complicating pregnancy, childbirth and the puerperium", "BZLrQl0tWFg"),
    ("ICD10", "O98.9", "O98.9 Unspecified maternal infectious or parasitic disease complicating pregnancy, childbirth and the puerperium", "DEVhpgvrp6t"),
    ("ICD10", "O99", "O99 Other maternal diseases classifiable elsewhere but complicating pregnancy, childbirth and the puerperium", "faq7rBwnT2A"),
    ("ICD10", "O99.0", "O99.0 Anaemia complicating pregnancy, childbirth and the puerperium", "xpnDlM7jHOO"),
    ("ICD10", "O99.1", "O99.1 Other diseases of the blood and blood-forming organs and certain disorders involving the immune mechanism complicating pregnancy, childbirth and the puerperium", "FOnATd1tQ6K"),
    ("ICD10", "O99.2", "O99.2 Endocrine, nutritional and metabolic diseases complicating pregnancy, childbirth and the puerperium", "GD5u9Wt88Su"),
    ("ICD10", "O99.3", "O99.3 Mental disorders and diseases of the nervous system complicating pregnancy, childbirth and the puerperium", "CDUYQ8VNfJY"),
    ("ICD10", "O99.4", "O99.4 Diseases of the circulatory system complicating pregnancy, childbirth and the puerperium", "FA4Lfd8mPSH"),
    ("ICD10", "O99.5", "O99.5 Diseases of the respiratory system complicating pregnancy, childbirth and the puerperium", "Pd2s3tEO53i"),
    ("ICD10", "O99.6", "O99.6 Diseases of the digestive system complicating pregnancy, childbirth and the puerperium", "IJpz6Fm3ash"),
    ("ICD10", "O99.7", "O99.7 Diseases of the skin and subcutaneous tissue complicating pregnancy, childbirth and the puerperium", "DZAm4hCwfpn"),
    ("ICD10", "O99.8", "O99.8 Other specified diseases and conditions complicating pregnancy, childbirth and the puerperium", "Csl35HPwwDZ");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "P00", "P00 Fetus and newborn affected by maternal conditions that may be unrelated to present pregnancy", "b60lyZOV6iO"),
    ("ICD10", "P00.0", "P00.0 Fetus and newborn affected by maternal hypertensive disorders", "A9dZedy6dRj"),
    ("ICD10", "P00.1", "P00.1 Fetus and newborn affected by maternal renal and urinary tract diseases", "jtyKyVEU4cf"),
    ("ICD10", "P00.2", "P00.2 Fetus and newborn affected by maternal infectious and parasitic diseases", "AicwguZGeBu"),
    ("ICD10", "P00.3", "P00.3 Fetus and newborn affected by other maternal circulatory and respiratory diseases", "WvPezShKkCm"),
    ("ICD10", "P00.4", "P00.4 Fetus and newborn affected by maternal nutritional disorders", "WLKYrfjAHaF"),
    ("ICD10", "P00.5", "P00.5 Fetus and newborn affected by maternal injury", "eVdgx4cCuwp"),
    ("ICD10", "P00.6", "P00.6 Fetus and newborn affected by surgical procedure on mother", "bieBS3a4lyy"),
    ("ICD10", "P00.7", "P00.7 Fetus and newborn affected by other medical procedures on mother, not elsewhere classified", "Hj16YCotNL6"),
    ("ICD10", "P00.8", "P00.8 Fetus and newborn affected by other maternal conditions", "ukijG7MGIDT"),
    ("ICD10", "P00.9", "P00.9 Fetus and newborn affected by unspecified maternal condition", "CUIZ8ftvrP0"),
    ("ICD10", "P01", "P01 Fetus and newborn affected by maternal complications of pregnancy", "KCOdtY1O5yA"),
    ("ICD10", "P01.0", "P01.0 Fetus and newborn affected by incompetent cervix", "vsPhovAEsee"),
    ("ICD10", "P01.1", "P01.1 Fetus and newborn affected by premature rupture of membranes", "KQ5RRHyrDU5"),
    ("ICD10", "P01.2", "P01.2 Fetus and newborn affected by oligohydramnios", "cepfH8M62oR"),
    ("ICD10", "P01.3", "P01.3 Fetus and newborn affected by polyhydramnios", "c8vYvKvCZBE"),
    ("ICD10", "P01.4", "P01.4 Fetus and newborn affected by ectopic pregnancy", "XxRoUHvtsgL"),
    ("ICD10", "P01.5", "P01.5 Fetus and newborn affected by multiple pregnancy", "R08stFWBCK3"),
    ("ICD10", "P01.6", "P01.6 Fetus and newborn affected by maternal death", "g7nKnbUxgTN"),
    ("ICD10", "P01.7", "P01.7 Fetus and newborn affected by malpresentation before labour", "YQe3F6beX07"),
    ("ICD10", "P01.8", "P01.8 Fetus and newborn affected by other maternal complications of pregnancy", "kVN92wlUq0i"),
    ("ICD10", "P01.9", "P01.9 Fetus and newborn affected by maternal complication of pregnancy, unspecified", "t8tqrMB4sqI"),
    ("ICD10", "P02", "P02 Fetus and newborn affected by complications of placenta, cord and membranes", "rlvrY5wb46B"),
    ("ICD10", "P02.0", "P02.0 Fetus and newborn affected by placenta praevia", "AUMfoM9sw7x"),
    ("ICD10", "P02.1", "P02.1 Fetus and newborn affected by other forms of placental separation and haemorrhage", "j2xfcQGqDzO"),
    ("ICD10", "P02.2", "P02.2 Fetus and newborn affected by other and unspecified morphological and functional abnormalities of placenta", "jVkOgPArNYZ"),
    ("ICD10", "P02.3", "P02.3 Fetus and newborn affected by placental transfusion syndromes", "yw2vfpQcJoJ"),
    ("ICD10", "P02.4", "P02.4 Fetus and newborn affected by prolapsed cord", "Y2q7JmT7npE"),
    ("ICD10", "P02.5", "P02.5 Fetus and newborn affected by other compression of umbilical cord", "KItGFydaZte"),
    ("ICD10", "P02.6", "P02.6 Fetus and newborn affected by other and unspecified conditions of umbilical cord", "ouHBNrCOUvK"),
    ("ICD10", "P02.7", "P02.7 Fetus and newborn affected by chorioamnionitis", "AWtfDyvrNin"),
    ("ICD10", "P02.8", "P02.8 Fetus and newborn affected by other abnormalities of membranes", "hcVYPHCwsdZ"),
    ("ICD10", "P02.9", "P02.9 Fetus and newborn affected by abnormality of membranes, unspecified", "d93XM0YXt7E"),
    ("ICD10", "P03", "P03 Fetus and newborn affected by other complications of labour and delivery", "Ht519n8mRah"),
    ("ICD10", "P03.0", "P03.0 Fetus and newborn affected by breech delivery and extraction", "LACdYP15tnT"),
    ("ICD10", "P03.1", "P03.1 Fetus and newborn affected by other malpresentation, malposition and disproportion during labour and delivery", "GoPdttXOfcS"),
    ("ICD10", "P03.2", "P03.2 Fetus and newborn affected by forceps delivery", "vrtzbcaHgFo"),
    ("ICD10", "P03.3", "P03.3 Fetus and newborn affected by delivery by vacuum extractor [ventouse]", "llnM5y8kC5p"),
    ("ICD10", "P03.4", "P03.4 Fetus and newborn affected by caesarean delivery", "ReGpqtOLpJA"),
    ("ICD10", "P03.5", "P03.5 Fetus and newborn affected by precipitate delivery", "HR3TKSQjn5S"),
    ("ICD10", "P03.6", "P03.6 Fetus and newborn affected by abnormal uterine contractions", "wNXIWWk18SO"),
    ("ICD10", "P03.8", "P03.8 Fetus and newborn affected by other specified complications of labour and delivery", "MOUyoiXPxqa"),
    ("ICD10", "P03.9", "P03.9 Fetus and newborn affected by complication of labour and delivery, unspecified", "o3husR4jhIb"),
    ("ICD10", "P04", "P04 Fetus and newborn affected by noxious influences transmitted via placenta or breast milk", "Fz9bXDyRFSg"),
    ("ICD10", "P04.0", "P04.0 Fetus and newborn affected by maternal anaesthesia and analgesia in pregnancy, labour and delivery", "HJLZLtAS6lw"),
    ("ICD10", "P04.1", "P04.1 Fetus and newborn affected by other maternal medication", "MiG1xai5zbb"),
    ("ICD10", "P04.2", "P04.2 Fetus and newborn affected by maternal use of tobacco", "wkpThy2id4b"),
    ("ICD10", "P04.3", "P04.3 Fetus and newborn affected by maternal use of alcohol", "kKfTxIGLJcL"),
    ("ICD10", "P04.4", "P04.4 Fetus and newborn affected by maternal use of drugs of addiction", "e6oOetnTiRl"),
    ("ICD10", "P04.5", "P04.5 Fetus and newborn affected by maternal use of nutritional chemical substances", "jucZN5BOxFO"),
    ("ICD10", "P04.6", "P04.6 Fetus and newborn affected by maternal exposure to environmental chemical substances", "PvMSjfXARbo"),
    ("ICD10", "P04.8", "P04.8 Fetus and newborn affected by other maternal noxious influences", "uQVUhEwbjy8"),
    ("ICD10", "P04.9", "P04.9 Fetus and newborn affected by maternal noxious influence, unspecified", "SDwyP7VqDf3"),
    ("ICD10", "P05", "P05 Slow fetal growth and fetal malnutrition", "zOQY5iuctRS"),
    ("ICD10", "P05.0", "P05.0 Light for gestational age", "gfvHsVd9hGl"),
    ("ICD10", "P05.1", "P05.1 Small for gestational age", "dWsbKWpEnLh"),
    ("ICD10", "P05.2", "P05.2 Fetal malnutrition without mention of light or small for gestational age", "MIdhEElazY7"),
    ("ICD10", "P05.9", "P05.9 Slow fetal growth, unspecified", "KR7yrMxPKDj"),
    ("ICD10", "P07", "P07 Disorders related to short gestation and low birth weight, not elsewhere classified", "GQWBSOcOaSG"),
    ("ICD10", "P07.0", "P07.0 Extremely low birth weight", "xSyaR7LzjFs"),
    ("ICD10", "P07.1", "P07.1 Other low birth weight", "bPZJBOAtrGx"),
    ("ICD10", "P07.2", "P07.2 Extreme immaturity", "jweAlqBZSO7"),
    ("ICD10", "P07.3", "P07.3 Other preterm infants", "ffuhVQccH86"),
    ("ICD10", "P08", "P08 Disorders related to long gestation and high birth weight", "pjllcfHzeU6"),
    ("ICD10", "P08.0", "P08.0 Exceptionally large baby", "FyQmZCo5oGC"),
    ("ICD10", "P08.1", "P08.1 Other heavy for gestational age infants", "yNkXcNZa0wW"),
    ("ICD10", "P08.2", "P08.2 Post-term infant, not heavy for gestational age", "tDPFGHbCSck"),
    ("ICD10", "P10", "P10 Intracranial laceration and haemorrhage due to birth injury", "bQR7hqimKz7"),
    ("ICD10", "P10.0", "P10.0 Subdural haemorrhage due to birth injury", "PVl7tlhsCHm"),
    ("ICD10", "P10.1", "P10.1 Cerebral haemorrhage due to birth injury", "tahAjYwTYEl"),
    ("ICD10", "P10.2", "P10.2 Intraventricular haemorrhage due to birth injury", "I0s5e27gaJL"),
    ("ICD10", "P10.3", "P10.3 Subarachnoid haemorrhage due to birth injury", "hMYYW59uERp"),
    ("ICD10", "P10.4", "P10.4 Tentorial tear due to birth injury", "rvanvptuBWu"),
    ("ICD10", "P10.8", "P10.8 Other intracranial lacerations and haemorrhages due to birth injury", "dZJMWV4VUOE"),
    ("ICD10", "P10.9", "P10.9 Unspecified intracranial laceration and haemorrhage due to birth injury", "EFexHQ6stD7"),
    ("ICD10", "P11", "P11 Other birth injuries to central nervous system", "rs6TSuBc4LD"),
    ("ICD10", "P11.0", "P11.0 Cerebral oedema due to birth injury", "vwYs4I1eHnD"),
    ("ICD10", "P11.1", "P11.1 Other specified brain damage due to birth injury", "mESSxGoVQ0A"),
    ("ICD10", "P11.2", "P11.2 Unspecified brain damage due to birth injury", "CaYmHjEknYD"),
    ("ICD10", "P11.3", "P11.3 Birth injury to facial nerve", "LuiiYE2ghYN"),
    ("ICD10", "P11.4", "P11.4 Birth injury to other cranial nerves", "v30Nj8J4pLw"),
    ("ICD10", "P11.5", "P11.5 Birth injury to spine and spinal cord", "Mht2ep6Fj4G"),
    ("ICD10", "P11.9", "P11.9 Birth injury to central nervous system, unspecified", "GkhwuzhMczk"),
    ("ICD10", "P12", "P12 Birth injury to scalp", "AB4fr8cWIEs"),
    ("ICD10", "P12.0", "P12.0 Cephalhaematoma due to birth injury", "uu1FPaayarn"),
    ("ICD10", "P12.1", "P12.1 Chignon due to birth injury", "BRSjyK6znY7"),
    ("ICD10", "P12.2", "P12.2 Epicranial subaponeurotic haemorrhage due to birth injury", "r8I4wuXNj9L"),
    ("ICD10", "P12.3", "P12.3 Bruising of scalp due to birth injury", "N0axchsKcMU"),
    ("ICD10", "P12.4", "P12.4 Monitoring injury of scalp of newborn", "VnhsFrf29pC"),
    ("ICD10", "P12.8", "P12.8 Other birth injuries to scalp", "BNqeiLbO25H"),
    ("ICD10", "P12.9", "P12.9 Birth injury to scalp, unspecified", "F49Qs5Nb7kk"),
    ("ICD10", "P13", "P13 Birth injury to skeleton", "uWYmpRU49EB"),
    ("ICD10", "P13.0", "P13.0 Fracture of skull due to birth injury", "sk2auXZB6lr"),
    ("ICD10", "P13.1", "P13.1 Other birth injuries to skull", "WBgEHpjX7wy"),
    ("ICD10", "P13.2", "P13.2 Birth injury to femur", "NEpugkShRT4"),
    ("ICD10", "P13.3", "P13.3 Birth injury to other long bones", "IAqPtuJVUU1"),
    ("ICD10", "P13.4", "P13.4 Fracture of clavicle due to birth injury", "PZRRsrFcAs8"),
    ("ICD10", "P13.8", "P13.8 Birth injuries to other parts of skeleton", "RcDt2oYgFQn"),
    ("ICD10", "P13.9", "P13.9 Birth injury to skeleton, unspecified", "TK7681qPYnx"),
    ("ICD10", "P14", "P14 Birth injury to peripheral nervous system", "FL6kcqsWS9x"),
    ("ICD10", "P14.0", "P14.0 Erb paralysis due to birth injury", "DLtCNS4TXYn"),
    ("ICD10", "P14.1", "P14.1 Klumpke paralysis due to birth injury", "eVB1K5618HN"),
    ("ICD10", "P14.2", "P14.2 Phrenic nerve paralysis due to birth injury", "fA0c8Zdjct6"),
    ("ICD10", "P14.3", "P14.3 Other brachial plexus birth injuries", "kbNWi5LHggs"),
    ("ICD10", "P14.8", "P14.8 Birth injuries to other parts of peripheral nervous system", "OH8tZkTa2cE"),
    ("ICD10", "P14.9", "P14.9 Birth injury to peripheral nervous system, unspecified", "cnNMkJ2bdkW"),
    ("ICD10", "P15", "P15 Other birth injuries", "HGJVkW9PfXS"),
    ("ICD10", "P15.0", "P15.0 Birth injury to liver", "oZXDWRcbACQ"),
    ("ICD10", "P15.1", "P15.1 Birth injury to spleen", "LMMv4NyqD8f"),
    ("ICD10", "P15.2", "P15.2 Sternomastoid injury due to birth injury", "eGMZtDuHgh7"),
    ("ICD10", "P15.3", "P15.3 Birth injury to eye", "pbC79wZYxBE"),
    ("ICD10", "P15.4", "P15.4 Birth injury to face", "VWNsnS9MnfD"),
    ("ICD10", "P15.5", "P15.5 Birth injury to external genitalia", "lmopOS917Lr"),
    ("ICD10", "P15.6", "P15.6 Subcutaneous fat necrosis due to birth injury", "Vy2tbb9h4ET"),
    ("ICD10", "P15.8", "P15.8 Other specified birth injuries", "GzYNdcPyyl2"),
    ("ICD10", "P15.9", "P15.9 Birth injury, unspecified", "PskGTfi3vv3"),
    ("ICD10", "P20", "P20 Intrauterine hypoxia", "j6f3hvitnyp"),
    ("ICD10", "P20.0", "P20.0 Intrauterine hypoxia first noted before onset of labour", "X4JfIgZp1St"),
    ("ICD10", "P20.1", "P20.1 Intrauterine hypoxia first noted during labour and delivery", "GNSS3aL0cy4"),
    ("ICD10", "P20.9", "P20.9 Intrauterine hypoxia, unspecified", "fkOnDbJPBI4"),
    ("ICD10", "P21", "P21 Birth asphyxia", "O4XjWsDw7ol"),
    ("ICD10", "P21.0", "P21.0 Severe birth asphyxia", "uk3UZSgauvk"),
    ("ICD10", "P21.1", "P21.1 Mild and moderate birth asphyxia", "mMbXMLSGv3j"),
    ("ICD10", "P21.9", "P21.9 Birth asphyxia, unspecified", "wjQ2t0N7TtY"),
    ("ICD10", "P22", "P22 Respiratory distress of newborn", "I1vpNyyLux5"),
    ("ICD10", "P22.0", "P22.0 Respiratory distress syndrome of newborn", "kYPOMIt22gE"),
    ("ICD10", "P22.1", "P22.1 Transient tachypnoea of newborn", "faYjFi3mp87"),
    ("ICD10", "P22.8", "P22.8 Other respiratory distress of newborn", "boGwWikyq08"),
    ("ICD10", "P22.9", "P22.9 Respiratory distress of newborn, unspecified", "VaRaNT6ptQd"),
    ("ICD10", "P23", "P23 Congenital pneumonia", "FHRQmVCIoms"),
    ("ICD10", "P23.0", "P23.0 Congenital pneumonia due to viral agent", "xqYRk9Yb3gK"),
    ("ICD10", "P23.1", "P23.1 Congenital pneumonia due to Chlamydia", "TfMBpWHy5Yu"),
    ("ICD10", "P23.2", "P23.2 Congenital pneumonia due to staphylococcus", "wD88ZwO1nmC"),
    ("ICD10", "P23.3", "P23.3 Congenital pneumonia due to streptococcus, group B", "kF3qFNhMlJX"),
    ("ICD10", "P23.4", "P23.4 Congenital pneumonia due to Escherichia coli", "bAwvgllhr6F"),
    ("ICD10", "P23.5", "P23.5 Congenital pneumonia due to Pseudomonas", "qEB4XD71tbw"),
    ("ICD10", "P23.6", "P23.6 Congenital pneumonia due to other bacterial agents", "sqi97BTq4Te"),
    ("ICD10", "P23.8", "P23.8 Congenital pneumonia due to other organisms", "hSmXr1Cu7pN"),
    ("ICD10", "P23.9", "P23.9 Congenital pneumonia, unspecified", "jzbNK131WUv"),
    ("ICD10", "P24", "P24 Neonatal aspiration syndromes", "D4JnBhJkdvb"),
    ("ICD10", "P24.0", "P24.0 Neonatal aspiration of meconium", "K3D4NP95JTA"),
    ("ICD10", "P24.1", "P24.1 Neonatal aspiration of amniotic fluid and mucus", "BWpl44uIkjR"),
    ("ICD10", "P24.2", "P24.2 Neonatal aspiration of blood", "VdWDOU4ATZY"),
    ("ICD10", "P24.3", "P24.3 Neonatal aspiration of milk and regurgitated food", "QTQ9mJ8D9Zt"),
    ("ICD10", "P24.8", "P24.8 Other neonatal aspiration syndromes", "fGdMdW5sGt1"),
    ("ICD10", "P24.9", "P24.9 Neonatal aspiration syndrome, unspecified", "GJIXOEhbJ8j"),
    ("ICD10", "P25", "P25 Interstitial emphysema and related conditions originating in the perinatal period", "sKYkhQP5Iq9"),
    ("ICD10", "P25.0", "P25.0 Interstitial emphysema originating in the perinatal period", "bSsuCTkexp0"),
    ("ICD10", "P25.1", "P25.1 Pneumothorax originating in the perinatal period", "Gn3rAchWckE"),
    ("ICD10", "P25.2", "P25.2 Pneumomediastinum originating in the perinatal period", "IxOxSuQR1uj"),
    ("ICD10", "P25.3", "P25.3 Pneumopericardium originating in the perinatal period", "ibT5p8gKOEy"),
    ("ICD10", "P25.8", "P25.8 Other conditions related to interstitial emphysema originating in the perinatal period", "mx68WvAgxCZ"),
    ("ICD10", "P26", "P26 Pulmonary haemorrhage originating in the perinatal period", "ESMZsGuqtdj"),
    ("ICD10", "P26.0", "P26.0 Tracheobronchial haemorrhage originating in the perinatal period", "RVbw0k9pcSu"),
    ("ICD10", "P26.1", "P26.1 Massive pulmonary haemorrhage originating in the perinatal period", "WdrxF3KiLqz"),
    ("ICD10", "P26.8", "P26.8 Other pulmonary haemorrhages originating in the perinatal period", "I4OWT8Q7ORE"),
    ("ICD10", "P26.9", "P26.9 Unspecified pulmonary haemorrhage originating in the perinatal period", "kjbqGicXDQ2"),
    ("ICD10", "P27", "P27 Chronic respiratory disease originating in the perinatal period", "RxoEZjBUY30"),
    ("ICD10", "P27.0", "P27.0 Wilson-Mikity syndrome", "KbmIsFvkRCI"),
    ("ICD10", "P27.1", "P27.1 Bronchopulmonary dysplasia originating in the perinatal period", "jH4tZxoHzjw"),
    ("ICD10", "P27.8", "P27.8 Other chronic respiratory diseases originating in the perinatal period", "STSK24u50Ud"),
    ("ICD10", "P27.9", "P27.9 Unspecified chronic respiratory disease originating in the perinatal period", "TKEk7L0OwLm"),
    ("ICD10", "P28", "P28 Other respiratory conditions originating in the perinatal period", "fSWPMZR45Fi"),
    ("ICD10", "P28.0", "P28.0 Primary atelectasis of newborn", "Oqmj9K09ggT"),
    ("ICD10", "P28.1", "P28.1 Other and unspecified atelectasis of newborn", "ewESWcL3UIB"),
    ("ICD10", "P28.2", "P28.2 Cyanotic attacks of newborn", "aOYxrQ7L2nl"),
    ("ICD10", "P28.3", "P28.3 Primary sleep apnoea of newborn", "NmEBij52NDF"),
    ("ICD10", "P28.4", "P28.4 Other apnoea of newborn", "nbb0I6naI6y"),
    ("ICD10", "P28.5", "P28.5 Respiratory failure of newborn", "QCw9wGfMqOW"),
    ("ICD10", "P28.8", "P28.8 Other specified respiratory conditions of newborn", "zNDbRdbLNCe"),
    ("ICD10", "P28.9", "P28.9 Respiratory condition of newborn, unspecified", "Fawcgz9gdSn"),
    ("ICD10", "P29", "P29 Cardiovascular disorders originating in the perinatal period", "WFJLduDnYym"),
    ("ICD10", "P29.0", "P29.0 Neonatal cardiac failure", "BjOW5RpeVZ3"),
    ("ICD10", "P29.1", "P29.1 Neonatal cardiac dysrhythmia", "alcrPXMQLh1"),
    ("ICD10", "P29.2", "P29.2 Neonatal hypertension", "Nx0EnV3eL7U"),
    ("ICD10", "P29.3", "P29.3 Persistent fetal circulation", "gTfKj7hFVnI"),
    ("ICD10", "P29.4", "P29.4 Transient myocardial ischaemia of newborn", "V7M4lCXnKI3"),
    ("ICD10", "P29.8", "P29.8 Other cardiovascular disorders originating in the perinatal period", "nc0F00MMFGL"),
    ("ICD10", "P29.9", "P29.9 Cardiovascular disorder originating in the perinatal period, unspecified", "WgCN0UfczLe"),
    ("ICD10", "P35", "P35 Congenital viral diseases", "oDV92lbCR7C"),
    ("ICD10", "P35.0", "P35.0 Congenital rubella syndrome", "NEgYAWmHcpX"),
    ("ICD10", "P35.1", "P35.1 Congenital cytomegalovirus infection", "iKBU9QziLmc"),
    ("ICD10", "P35.2", "P35.2 Congenital herpesviral [herpes simplex] infection", "kuISgPQ3JVO"),
    ("ICD10", "P35.3", "P35.3 Congenital viral hepatitis", "fU8G2nDiLYL"),
    ("ICD10", "P35.8", "P35.8 Other congenital viral diseases", "UP1GRo1XTSY"),
    ("ICD10", "P35.9", "P35.9 Congenital viral disease, unspecified", "yOV3s2djNvb"),
    ("ICD10", "P36", "P36 Bacterial sepsis of newborn", "gjtafcXdyNQ"),
    ("ICD10", "P36.0", "P36.0 Sepsis of newborn due to streptococcus, group B", "QaeI9KBB7nf"),
    ("ICD10", "P36.1", "P36.1 Sepsis of newborn due to other and unspecified streptococci", "hJEGvpZG82b"),
    ("ICD10", "P36.2", "P36.2 Sepsis of newborn due to Staphylococcus aureus", "LDB7jZ4ARU4"),
    ("ICD10", "P36.3", "P36.3 Sepsis of newborn due to other and unspecified staphylococci", "RqI6UTzqhtT"),
    ("ICD10", "P36.4", "P36.4 Sepsis of newborn due to Escherichia coli", "ogMMY8dgDgh"),
    ("ICD10", "P36.5", "P36.5 Sepsis of newborn due to anaerobes", "W8Ni6QZVAFj"),
    ("ICD10", "P36.8", "P36.8 Other bacterial sepsis of newborn", "xXa9FGXX0Pp"),
    ("ICD10", "P36.9", "P36.9 Bacterial sepsis of newborn, unspecified", "NQKGOKcRpel"),
    ("ICD10", "P37", "P37 Other congenital infectious and parasitic diseases", "BxXK3takv9z"),
    ("ICD10", "P37.0", "P37.0 Congenital tuberculosis", "J2VBuii9lA2"),
    ("ICD10", "P37.1", "P37.1 Congenital toxoplasmosis", "la9ivakz9N2"),
    ("ICD10", "P37.2", "P37.2 Neonatal (disseminated) listeriosis", "D7tDnXzy63w"),
    ("ICD10", "P37.3", "P37.3 Congenital falciparum malaria", "oOSjojFvBTG"),
    ("ICD10", "P37.4", "P37.4 Other congenital malaria", "COEsl38mXFH"),
    ("ICD10", "P37.5", "P37.5 Neonatal candidiasis", "wCva0Fc5HGm"),
    ("ICD10", "P37.8", "P37.8 Other specified congenital infectious and parasitic diseases", "er24DClUyu8"),
    ("ICD10", "P37.9", "P37.9 Congenital infectious and parasitic disease, unspecified", "Ta3CrxsxECQ"),
    ("ICD10", "P38", "P38 Omphalitis of newborn with or without mild haemorrhage", "bYs2LqTTRCn"),
    ("ICD10", "P39", "P39 Other infections specific to the perinatal period", "y3UwvztHHaO"),
    ("ICD10", "P39.0", "P39.0 Neonatal infective mastitis", "u6Q7dvcabam"),
    ("ICD10", "P39.1", "P39.1 Neonatal conjunctivitis and dacryocystitis", "wLWHX4QKHAU"),
    ("ICD10", "P39.2", "P39.2 Intra-amniotic infection of fetus, not elsewhere classified", "p5Ol5GXw0nH"),
    ("ICD10", "P39.3", "P39.3 Neonatal urinary tract infection", "jmqNdbwnJ7F"),
    ("ICD10", "P39.4", "P39.4 Neonatal skin infection", "Sg3i0iejwJJ"),
    ("ICD10", "P39.8", "P39.8 Other specified infections specific to the perinatal period", "GlfLYnzjLEU"),
    ("ICD10", "P39.9", "P39.9 Infection specific to the perinatal period, unspecified", "T8Oo6Pp4lPw"),
    ("ICD10", "P50", "P50 Fetal blood loss", "OxFuUhwvPt0"),
    ("ICD10", "P50.0", "P50.0 Fetal blood loss from vasa praevia", "sINzhKyXkmT"),
    ("ICD10", "P50.1", "P50.1 Fetal blood loss from ruptured cord", "GSZVOp58xOV"),
    ("ICD10", "P50.2", "P50.2 Fetal blood loss from placenta", "ICFFtVitPsj"),
    ("ICD10", "P50.3", "P50.3 Haemorrhage into co-twin", "xE9gh9sHgik"),
    ("ICD10", "P50.4", "P50.4 Haemorrhage into maternal circulation", "z5KcFhNffJ1"),
    ("ICD10", "P50.5", "P50.5 Fetal blood loss from cut end of co-twin's cord", "PuMZ39V6FxT"),
    ("ICD10", "P50.8", "P50.8 Other fetal blood loss", "Mf1zROQZtlf"),
    ("ICD10", "P50.9", "P50.9 Fetal blood loss, unspecified", "RwfwUOi1cwC"),
    ("ICD10", "P51", "P51 Umbilical haemorrhage of newborn", "y7vZsuFeWJl"),
    ("ICD10", "P51.0", "P51.0 Massive umbilical haemorrhage of newborn", "qmV1IxKgnHW"),
    ("ICD10", "P51.8", "P51.8 Other umbilical haemorrhages of newborn", "HnvReiEFk32"),
    ("ICD10", "P51.9", "P51.9 Umbilical haemorrhage of newborn, unspecified", "VTAHST4A2wH"),
    ("ICD10", "P52", "P52 Intracranial nontraumatic haemorrhage of fetus and newborn", "ICdRnj7hwH3"),
    ("ICD10", "P52.0", "P52.0 Intraventricular (nontraumatic) haemorrhage, grade 1, of fetus and newborn", "TtY133wNiNk"),
    ("ICD10", "P52.1", "P52.1 Intraventricular (nontraumatic) haemorrhage, grade 2, of fetus and newborn", "jkexBCNv6h0"),
    ("ICD10", "P52.2", "P52.2 Intraventricular (nontraumatic) haemorrhage, grade 3, and grade 4 of fetus and newborn", "HRsDGmiGPo0"),
    ("ICD10", "P52.3", "P52.3 Unspecified intraventricular (nontraumatic) haemorrhage of fetus and newborn", "zCgtyMRgwFw"),
    ("ICD10", "P52.4", "P52.4 Intracerebral (nontraumatic) haemorrhage of fetus and newborn", "rPdeCTRsDVe"),
    ("ICD10", "P52.5", "P52.5 Subarachnoid (nontraumatic) haemorrhage of fetus and newborn", "doFeIGr5lfd"),
    ("ICD10", "P52.6", "P52.6 Cerebellar (nontraumatic) and posterior fossa haemorrhage of fetus and newborn", "c7Vga9l8LeH"),
    ("ICD10", "P52.8", "P52.8 Other intracranial (nontraumatic) haemorrhages of fetus and newborn", "YRs316ZkMUi"),
    ("ICD10", "P52.9", "P52.9 Intracranial (nontraumatic) haemorrhage of fetus and newborn, unspecified", "eaA8141XzSU"),
    ("ICD10", "P53", "P53 Haemorrhagic disease of fetus and newborn", "PSkNhs89U4x"),
    ("ICD10", "P54", "P54 Other neonatal haemorrhages", "sPC3x6YTo04"),
    ("ICD10", "P54.0", "P54.0 Neonatal haematemesis", "DhREEUCC9r6"),
    ("ICD10", "P54.1", "P54.1 Neonatal melaena", "WAejbc39vHo"),
    ("ICD10", "P54.2", "P54.2 Neonatal rectal haemorrhage", "Nbr0X4esRnX"),
    ("ICD10", "P54.3", "P54.3 Other neonatal gastrointestinal haemorrhage", "eBog2JhdgfO"),
    ("ICD10", "P54.4", "P54.4 Neonatal adrenal haemorrhage", "wgasPDw4d6T"),
    ("ICD10", "P54.5", "P54.5 Neonatal cutaneous haemorrhage", "o1muEQTJG9a"),
    ("ICD10", "P54.6", "P54.6 Neonatal vaginal haemorrhage", "nJhz4rhx5Kw"),
    ("ICD10", "P54.8", "P54.8 Other specified neonatal haemorrhages", "udY1ujWB65T"),
    ("ICD10", "P54.9", "P54.9 Neonatal haemorrhage, unspecified", "t3aMrnJdSbi"),
    ("ICD10", "P55", "P55 Haemolytic disease of fetus and newborn", "pLG7pyddlS7"),
    ("ICD10", "P55.0", "P55.0 Rh isoimmunization of fetus and newborn", "WXnOF0Zls1J"),
    ("ICD10", "P55.1", "P55.1 ABO isoimmunization of fetus and newborn", "awrXgtLOwAR"),
    ("ICD10", "P55.8", "P55.8 Other haemolytic diseases of fetus and newborn", "GDJ5xX98jnv"),
    ("ICD10", "P55.9", "P55.9 Haemolytic disease of fetus and newborn, unspecified", "g3wi4H8hicd"),
    ("ICD10", "P56", "P56 Hydrops fetalis due to haemolytic disease", "KftUdIq0u1s"),
    ("ICD10", "P56.0", "P56.0 Hydrops fetalis due to isoimmunization", "gqDaRK06uqN"),
    ("ICD10", "P56.9", "P56.9 Hydrops fetalis due to other and unspecified haemolytic disease", "n7QvFQm8JAk"),
    ("ICD10", "P57", "P57 Kernicterus", "RUlOVNKo2u3"),
    ("ICD10", "P57.0", "P57.0 Kernicterus due to isoimmunization", "wlA2HL6EFea"),
    ("ICD10", "P57.8", "P57.8 Other specified kernicterus", "bqXFXHWhNGN"),
    ("ICD10", "P57.9", "P57.9 Kernicterus, unspecified", "biDDaYYR0gl"),
    ("ICD10", "P58", "P58 Neonatal jaundice due to other excessive haemolysis", "XLjZFIRDZ4c"),
    ("ICD10", "P58.0", "P58.0 Neonatal jaundice due to bruising", "nH0Cxuhf1ch"),
    ("ICD10", "P58.1", "P58.1 Neonatal jaundice due to bleeding", "Bjh2OdpmrOF"),
    ("ICD10", "P58.2", "P58.2 Neonatal jaundice due to infection", "ByEGKALq77R"),
    ("ICD10", "P58.3", "P58.3 Neonatal jaundice due to polycythaemia", "vT1OIWxzYi2"),
    ("ICD10", "P58.4", "P58.4 Neonatal jaundice due to drugs or toxins transmitted from mother or given to newborn", "oybOEiwaUHM"),
    ("ICD10", "P58.5", "P58.5 Neonatal jaundice due to swallowed maternal blood", "oeLmd9ilUuq"),
    ("ICD10", "P58.8", "P58.8 Neonatal jaundice due to other specified excessive haemolysis", "Vp7YohZYyrS"),
    ("ICD10", "P58.9", "P58.9 Neonatal jaundice due to excessive haemolysis, unspecified", "MEcM3INN0og"),
    ("ICD10", "P59", "P59 Neonatal jaundice from other and unspecified causes", "w82OZC1gmxp"),
    ("ICD10", "P59.0", "P59.0 Neonatal jaundice associated with preterm delivery", "BUd046q3LDS"),
    ("ICD10", "P59.1", "P59.1 Inspissated bile syndrome", "NpZddh8TjbQ"),
    ("ICD10", "P59.2", "P59.2 Neonatal jaundice from other and unspecified hepatocellular damage", "on14tLQb24h"),
    ("ICD10", "P59.3", "P59.3 Neonatal jaundice from breast milk inhibitor", "lbmP2igclGB"),
    ("ICD10", "P59.8", "P59.8 Neonatal jaundice from other specified causes", "aCJggMSIZxf"),
    ("ICD10", "P59.9", "P59.9 Neonatal jaundice, unspecified", "ZhUaTSxFr3i"),
    ("ICD10", "P60", "P60 Disseminated intravascular coagulation of fetus and newborn", "RWEDUy4JloK"),
    ("ICD10", "P61", "P61 Other perinatal haematological disorders", "TZioFvOw2wF"),
    ("ICD10", "P61.0", "P61.0 Transient neonatal thrombocytopenia", "N0JVqOHUDUJ"),
    ("ICD10", "P61.1", "P61.1 Polycythaemia neonatorum", "mNIKWJ5epSB"),
    ("ICD10", "P61.2", "P61.2 Anaemia of prematurity", "jrzBwzD0ADZ"),
    ("ICD10", "P61.3", "P61.3 Congenital anaemia from fetal blood loss", "o3jb44M79qi"),
    ("ICD10", "P61.4", "P61.4 Other congenital anaemias, not elsewhere classified", "aNZOnyYjXKj"),
    ("ICD10", "P61.5", "P61.5 Transient neonatal neutropenia", "BJXjkvGR6q9"),
    ("ICD10", "P61.6", "P61.6 Other transient neonatal disorders of coagulation", "aXbpCaQdQ15"),
    ("ICD10", "P61.8", "P61.8 Other specified perinatal haematological disorders", "QxI38C7fo14"),
    ("ICD10", "P61.9", "P61.9 Perinatal haematological disorder, unspecified", "M5YDwCz1d5t"),
    ("ICD10", "P70", "P70 Transitory disorders of carbohydrate metabolism specific to fetus and newborn", "rvfZoMbTZiP"),
    ("ICD10", "P70.0", "P70.0 Syndrome of infant of mother with gestational diabetes", "Wvs17u05RLe"),
    ("ICD10", "P70.1", "P70.1 Syndrome of infant of a diabetic mother", "nDW8VL3UTyl"),
    ("ICD10", "P70.2", "P70.2 Neonatal diabetes mellitus", "BqM4h1uRRzv"),
    ("ICD10", "P70.3", "P70.3 Iatrogenic neonatal hypoglycaemia", "YHN7vOyvuqP"),
    ("ICD10", "P70.4", "P70.4 Other neonatal hypoglycaemia", "uOJzTXSxtYY"),
    ("ICD10", "P70.8", "P70.8 Other transitory disorders of carbohydrate metabolism of fetus and newborn", "hc5hTQZh1Xy"),
    ("ICD10", "P70.9", "P70.9 Transitory disorder of carbohydrate metabolism of fetus and newborn, unspecified", "XUYJlkOfzBo"),
    ("ICD10", "P71", "P71 Transitory neonatal disorders of calcium and magnesium metabolism", "QaffBYfYtSV"),
    ("ICD10", "P71.0", "P71.0 Cow milk hypocalcaemia in newborn", "Yt6orD1uhA8"),
    ("ICD10", "P71.1", "P71.1 Other neonatal hypocalcaemia", "O1KpxdS5Rmg"),
    ("ICD10", "P71.2", "P71.2 Neonatal hypomagnesaemia", "yMCfHEDXXNk"),
    ("ICD10", "P71.3", "P71.3 Neonatal tetany without calcium or magnesium deficiency", "OQoh6pIrwqV"),
    ("ICD10", "P71.4", "P71.4 Transitory neonatal hypoparathyroidism", "IeTxGpFWF1P"),
    ("ICD10", "P71.8", "P71.8 Other transitory neonatal disorders of calcium and magnesium metabolism", "zbR3pFEjrHd"),
    ("ICD10", "P71.9", "P71.9 Transitory neonatal disorder of calcium and magnesium metabolism, unspecified", "UVoFyJvbjwe"),
    ("ICD10", "P72", "P72 Other transitory neonatal endocrine disorders", "JnucuhMvKf1"),
    ("ICD10", "P72.0", "P72.0 Neonatal goitre, not elsewhere classified", "uCjRebgoDtZ"),
    ("ICD10", "P72.1", "P72.1 Transitory neonatal hyperthyroidism", "Vfjdy9OHf4r"),
    ("ICD10", "P72.2", "P72.2 Other transitory neonatal disorders of thyroid function, not elsewhere classified", "ceWVagIcm4K"),
    ("ICD10", "P72.8", "P72.8 Other specified transitory neonatal endocrine disorders", "sntqm5slHFi"),
    ("ICD10", "P72.9", "P72.9 Transitory neonatal endocrine disorder, unspecified", "ewBhlbWyFF4"),
    ("ICD10", "P74", "P74 Other transitory neonatal electrolyte and metabolic disturbances", "YNXOUkM57J1"),
    ("ICD10", "P74.0", "P74.0 Late metabolic acidosis of newborn", "EB85YB0vf2m"),
    ("ICD10", "P74.1", "P74.1 Dehydration of newborn", "sqUmINZoTh9"),
    ("ICD10", "P74.2", "P74.2 Disturbances of sodium balance of newborn", "rsoABWcYBev"),
    ("ICD10", "P74.3", "P74.3 Disturbances of potassium balance of newborn", "o5Q0pa1Qos6"),
    ("ICD10", "P74.4", "P74.4 Other transitory electrolyte disturbances of newborn", "QnDTSiTBhYS"),
    ("ICD10", "P74.5", "P74.5 Transitory tyrosinaemia of newborn", "yroUJKVUktJ"),
    ("ICD10", "P74.8", "P74.8 Other transitory metabolic disturbances of newborn", "hj8rarU7S7j");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "P74.9", "P74.9 Transitory metabolic disturbance of newborn, unspecified", "QzIPChctYdo"),
    ("ICD10", "P75", "P75 Meconium ileus in cystic fibrosis", "Ga2erS9yKFT"),
    ("ICD10", "P76", "P76 Other intestinal obstruction of newborn", "UTGzQesnKhh"),
    ("ICD10", "P76.0", "P76.0 Meconium plug syndrome", "j2KrAMj1JP9"),
    ("ICD10", "P76.1", "P76.1 Transitory ileus of newborn", "WPY8RYuoYz7"),
    ("ICD10", "P76.2", "P76.2 Intestinal obstruction due to inspissated milk", "LOcJFtmXa75"),
    ("ICD10", "P76.8", "P76.8 Other specified intestinal obstruction of newborn", "AbvgDQ88NFx"),
    ("ICD10", "P76.9", "P76.9 Intestinal obstruction of newborn, unspecified", "eflwJCOXaxQ"),
    ("ICD10", "P77", "P77 Necrotizing enterocolitis of fetus and newborn", "BnPbQz9GgEv"),
    ("ICD10", "P78", "P78 Other perinatal digestive system disorders", "CR3a5FGWLet"),
    ("ICD10", "P78.0", "P78.0 Perinatal intestinal perforation", "qFTpJOGFgQJ"),
    ("ICD10", "P78.1", "P78.1 Other neonatal peritonitis", "dZ8zAbAuZ1g"),
    ("ICD10", "P78.2", "P78.2 Neonatal haematemesis and melaena due to swallowed maternal blood", "X7CiCyBruqA"),
    ("ICD10", "P78.3", "P78.3 Noninfective neonatal diarrhoea", "rPc782Mv9TZ"),
    ("ICD10", "P78.8", "P78.8 Other specified perinatal digestive system disorders", "q8vKUfhnWHu"),
    ("ICD10", "P78.9", "P78.9 Perinatal digestive system disorder, unspecified", "Yxg6C4LGZm4"),
    ("ICD10", "P80", "P80 Hypothermia of newborn", "f1hGXEoZMeg"),
    ("ICD10", "P80.0", "P80.0 Cold injury syndrome", "XtO7kLuBulR"),
    ("ICD10", "P80.8", "P80.8 Other hypothermia of newborn", "pgLdXazNqiB"),
    ("ICD10", "P80.9", "P80.9 Hypothermia of newborn, unspecified", "A5VH24eMqdl"),
    ("ICD10", "P81", "P81 Other disturbances of temperature regulation of newborn", "blxjDQ2ZlhX"),
    ("ICD10", "P81.0", "P81.0 Environmental hyperthermia of newborn", "euW5uJaRg94"),
    ("ICD10", "P81.8", "P81.8 Other specified disturbances of temperature regulation of newborn", "yg7qgfM6WUF"),
    ("ICD10", "P81.9", "P81.9 Disturbance of temperature regulation of newborn, unspecified", "NePNPyoVr5q"),
    ("ICD10", "P83", "P83 Other conditions of integument specific to fetus and newborn", "BBuNOILYcdk"),
    ("ICD10", "P83.0", "P83.0 Sclerema neonatorum", "e9IxrU2VmAi"),
    ("ICD10", "P83.1", "P83.1 Neonatal erythema toxicum", "ooUYSWPSMJL"),
    ("ICD10", "P83.2", "P83.2 Hydrops fetalis not due to haemolytic disease", "oiiBjNe1G0z"),
    ("ICD10", "P83.3", "P83.3 Other and unspecified oedema specific to fetus and newborn", "YUmByybGPow"),
    ("ICD10", "P83.4", "P83.4 Breast engorgement of newborn", "zRrTnAaUSuC"),
    ("ICD10", "P83.5", "P83.5 Congenital hydrocele", "ucA2NrIbeVD"),
    ("ICD10", "P83.6", "P83.6 Umbilical polyp of newborn", "TEJgiOLNvne"),
    ("ICD10", "P83.8", "P83.8 Other specified conditions of integument specific to fetus and newborn", "nz8aTQ0sjUH"),
    ("ICD10", "P83.9", "P83.9 Condition of integument specific to fetus and newborn, unspecified", "MoA082zNT8n"),
    ("ICD10", "P90", "P90 Convulsions of newborn", "YbSqQRoAKln"),
    ("ICD10", "P91", "P91 Other disturbances of cerebral status of newborn", "LwcG5dgdi77"),
    ("ICD10", "P91.0", "P91.0 Neonatal cerebral ischaemia", "e2XWsahbA2z"),
    ("ICD10", "P91.1", "P91.1 Acquired periventricular cysts of newborn", "i3QAWDUy05o"),
    ("ICD10", "P91.2", "P91.2 Neonatal cerebral leukomalacia", "XEvq1n2BVkG"),
    ("ICD10", "P91.3", "P91.3 Neonatal cerebral irritability", "e332CIZWtjQ"),
    ("ICD10", "P91.4", "P91.4 Neonatal cerebral depression", "iI8wsa8KpGq"),
    ("ICD10", "P91.5", "P91.5 Neonatal coma", "TdMHXBOBy3Y"),
    ("ICD10", "P91.6", "P91.6 Hypoxic ischaemic encephalopathy of newborn", "tlAXVF6GbiS"),
    ("ICD10", "P91.7", "P91.7 Acquired hydrocephalus of newborn", "Ovtda9QQ0ip"),
    ("ICD10", "P91.8", "P91.8 Other specified disturbances of cerebral status of newborn", "yggpOCdH0Iy"),
    ("ICD10", "P91.9", "P91.9 Disturbance of cerebral status of newborn, unspecified", "PFW3Ye5fDcI"),
    ("ICD10", "P92", "P92 Feeding problems of newborn", "lkRdMl0WsvP"),
    ("ICD10", "P92.0", "P92.0 Vomiting in newborn", "COhfGjVt32V"),
    ("ICD10", "P92.1", "P92.1 Regurgitation and rumination in newborn", "OHwAWdp9OWv"),
    ("ICD10", "P92.2", "P92.2 Slow feeding of newborn", "RFAI93fphLX"),
    ("ICD10", "P92.3", "P92.3 Underfeeding of newborn", "EMucTiAimYI"),
    ("ICD10", "P92.4", "P92.4 Overfeeding of newborn", "Q2qVZHkX0nD"),
    ("ICD10", "P92.5", "P92.5 Neonatal difficulty in feeding at breast", "mEYOByXkBx6"),
    ("ICD10", "P92.8", "P92.8 Other feeding problems of newborn", "aaKdmRv6cPt"),
    ("ICD10", "P92.9", "P92.9 Feeding problem of newborn, unspecified", "ALESx22hCXQ"),
    ("ICD10", "P93", "P93 Reactions and intoxications due to drugs administered to fetus and newborn", "VNvTgybc6Ur"),
    ("ICD10", "P94", "P94 Disorders of muscle tone of newborn", "pMuMdIBQMni"),
    ("ICD10", "P94.0", "P94.0 Transient neonatal myasthenia gravis", "qzWK7PACpKO"),
    ("ICD10", "P94.1", "P94.1 Congenital hypertonia", "ydiyui5iBaq"),
    ("ICD10", "P94.2", "P94.2 Congenital hypotonia", "udUcZfM4fZQ"),
    ("ICD10", "P94.8", "P94.8 Other disorders of muscle tone of newborn", "kmi5WJdkkO3"),
    ("ICD10", "P94.9", "P94.9 Disorder of muscle tone of newborn, unspecified", "nt2WdrHDOvA"),
    ("ICD10", "P95", "P95 Fetal death of unspecified cause", "kTaRnieUakV"),
    ("ICD10", "P96", "P96 Other conditions originating in the perinatal period", "iBroJO4vNXY"),
    ("ICD10", "P96.0", "P96.0 Congenital renal failure", "tRDmNPwsgUZ"),
    ("ICD10", "P96.1", "P96.1 Neonatal withdrawal symptoms from maternal use of drugs of addiction", "xs3bCKLrKVf"),
    ("ICD10", "P96.2", "P96.2 Withdrawal symptoms from therapeutic use of drugs in newborn", "cdW1yzedkRi"),
    ("ICD10", "P96.3", "P96.3 Wide cranial sutures of newborn", "KRhBR4CqyQ3"),
    ("ICD10", "P96.4", "P96.4 Termination of pregnancy, affecting fetus and newborn", "ViZIQGgQUIb"),
    ("ICD10", "P96.5", "P96.5 Complications of intrauterine procedures, not elsewhere classified", "jk0zRGXDcYi"),
    ("ICD10", "P96.8", "P96.8 Other specified conditions originating in the perinatal period", "IEkfBEOLV27"),
    ("ICD10", "P96.9", "P96.9 Condition originating in the perinatal period, unspecified", "LHXmEq0iHvP");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Q00", "Q00 Anencephaly and similar malformations", "mb78pRuzjm0"),
    ("ICD10", "Q00.0", "Q00.0 Anencephaly", "VIz8G8reE1k"),
    ("ICD10", "Q00.1", "Q00.1 Craniorachischisis", "EnauMITrM9Y"),
    ("ICD10", "Q00.2", "Q00.2 Iniencephaly", "VsuDYvliQSw"),
    ("ICD10", "Q01", "Q01 Encephalocele", "Na3NBAW7Z1P"),
    ("ICD10", "Q01.0", "Q01.0 Frontal encephalocele", "oRCeYMTgb8M"),
    ("ICD10", "Q01.1", "Q01.1 Nasofrontal encephalocele", "yKxlbkijqn0"),
    ("ICD10", "Q01.2", "Q01.2 Occipital encephalocele", "I2l1CEIc2xC"),
    ("ICD10", "Q01.8", "Q01.8 Encephalocele of other sites", "rLXf22ZFlUN"),
    ("ICD10", "Q01.9", "Q01.9 Encephalocele, unspecified", "zTfX1h9youX"),
    ("ICD10", "Q02", "Q02 Microcephaly", "tFjCBqOyRYJ"),
    ("ICD10", "Q03", "Q03 Congenital hydrocephalus", "CWf0usbedgO"),
    ("ICD10", "Q03.0", "Q03.0 Malformations of aqueduct of Sylvius", "uFldWgsRxtn"),
    ("ICD10", "Q03.1", "Q03.1 Atresia of foramina of Magendie and Luschka", "Pn1n9MJScY6"),
    ("ICD10", "Q03.8", "Q03.8 Other congenital hydrocephalus", "eIgyJHA3lmH"),
    ("ICD10", "Q03.9", "Q03.9 Congenital hydrocephalus, unspecified", "LP2AZojAXNx"),
    ("ICD10", "Q04", "Q04 Other congenital malformations of brain", "vkCJTgidqeP"),
    ("ICD10", "Q04.0", "Q04.0 Congenital malformations of corpus callosum", "hw6XdMe52VB"),
    ("ICD10", "Q04.1", "Q04.1 Arhinencephaly", "vkqoDiuhyTC"),
    ("ICD10", "Q04.2", "Q04.2 Holoprosencephaly", "Fci695ly4uT"),
    ("ICD10", "Q04.3", "Q04.3 Other reduction deformities of brain", "U2aFColIo6w"),
    ("ICD10", "Q04.4", "Q04.4 Septo-optic dysplasia", "XHDvY1BQDgW"),
    ("ICD10", "Q04.5", "Q04.5 Megalencephaly", "qmnym5sC2iO"),
    ("ICD10", "Q04.6", "Q04.6 Congenital cerebral cysts", "bJXBFveKR8X"),
    ("ICD10", "Q04.8", "Q04.8 Other specified congenital malformations of brain", "I36JkTkXGBE"),
    ("ICD10", "Q04.9", "Q04.9 Congenital malformation of brain, unspecified", "p7KOcLsDTE4"),
    ("ICD10", "Q05", "Q05 Spina bifida", "FNWRToGo37C"),
    ("ICD10", "Q05.0", "Q05.0 Cervical spina bifida with hydrocephalus", "kVDlJTIi2HU"),
    ("ICD10", "Q05.1", "Q05.1 Thoracic spina bifida with hydrocephalus", "MuDYaEcdF8V"),
    ("ICD10", "Q05.2", "Q05.2 Lumbar spina bifida with hydrocephalus", "aoIT0BF2PH2"),
    ("ICD10", "Q05.3", "Q05.3 Sacral spina bifida with hydrocephalus", "flTtiW2cnK0"),
    ("ICD10", "Q05.4", "Q05.4 Unspecified spina bifida with hydrocephalus", "CwtXuiZztiG"),
    ("ICD10", "Q05.5", "Q05.5 Cervical spina bifida without hydrocephalus", "DrZtnS0joQk"),
    ("ICD10", "Q05.6", "Q05.6 Thoracic spina bifida without hydrocephalus", "ggKQDQABMDa"),
    ("ICD10", "Q05.7", "Q05.7 Lumbar spina bifida without hydrocephalus", "LN6yhul6bxq"),
    ("ICD10", "Q05.8", "Q05.8 Sacral spina bifida without hydrocephalus", "qlwkVfSD2Xk"),
    ("ICD10", "Q05.9", "Q05.9 Spina bifida, unspecified", "GE6co0EyjXA"),
    ("ICD10", "Q06", "Q06 Other congenital malformations of spinal cord", "L7D09adull0"),
    ("ICD10", "Q06.0", "Q06.0 Amyelia", "IekGKj8v0Js"),
    ("ICD10", "Q06.1", "Q06.1 Hypoplasia and dysplasia of spinal cord", "Bf3TivKhcNq"),
    ("ICD10", "Q06.2", "Q06.2 Diastematomyelia", "bIRJghXkEcT"),
    ("ICD10", "Q06.3", "Q06.3 Other congenital cauda equina malformations", "U0Lwp2feXRo"),
    ("ICD10", "Q06.4", "Q06.4 Hydromyelia", "ZgUhrn9vqiz"),
    ("ICD10", "Q06.8", "Q06.8 Other specified congenital malformations of spinal cord", "cNYMPCrIfMS"),
    ("ICD10", "Q06.9", "Q06.9 Congenital malformation of spinal cord, unspecified", "AKuYRDKWQh3"),
    ("ICD10", "Q07", "Q07 Other congenital malformations of nervous system", "MWEcgZZecbl"),
    ("ICD10", "Q07.0", "Q07.0 Arnold-Chiari syndrome", "O8XAD2eAAKW"),
    ("ICD10", "Q07.8", "Q07.8 Other specified congenital malformations of nervous system", "tyK6iAsmwRI"),
    ("ICD10", "Q07.9", "Q07.9 Congenital malformation of nervous system, unspecified", "qlVm91K9GuL"),
    ("ICD10", "Q10", "Q10 Congenital malformations of eyelid, lacrimal apparatus and orbit", "gRHEwkeAEgy"),
    ("ICD10", "Q10.0", "Q10.0 Congenital ptosis", "kNcuhDE7hv2"),
    ("ICD10", "Q10.1", "Q10.1 Congenital ectropion", "Co95YfsBwki"),
    ("ICD10", "Q10.2", "Q10.2 Congenital entropion", "rIgC6yFQ0oU"),
    ("ICD10", "Q10.3", "Q10.3 Other congenital malformations of eyelid", "UbtILzYCzsS"),
    ("ICD10", "Q10.4", "Q10.4 Absence and agenesis of lacrimal apparatus", "G72JDBWXUDh"),
    ("ICD10", "Q10.5", "Q10.5 Congenital stenosis and stricture of lacrimal duct", "NXK1lXqUfZI"),
    ("ICD10", "Q10.6", "Q10.6 Other congenital malformations of lacrimal apparatus", "LEtwUbcUljU"),
    ("ICD10", "Q10.7", "Q10.7 Congenital malformation of orbit", "Ri9vK481smv"),
    ("ICD10", "Q11", "Q11 Anophthalmos, microphthalmos and macrophthalmos", "NZi2ZaKYql8"),
    ("ICD10", "Q11.0", "Q11.0 Cystic eyeball", "Ocjdoww8R0Q"),
    ("ICD10", "Q11.1", "Q11.1 Other anophthalmos", "EYoDFNmXHJG"),
    ("ICD10", "Q11.2", "Q11.2 Microphthalmos", "AB25e3tJPcj"),
    ("ICD10", "Q11.3", "Q11.3 Macrophthalmos", "VjszSWWDNLP"),
    ("ICD10", "Q12", "Q12 Congenital lens malformations", "BkF1GUvoURa"),
    ("ICD10", "Q12.0", "Q12.0 Congenital cataract", "d6L4Fyd6NOT"),
    ("ICD10", "Q12.1", "Q12.1 Congenital displaced lens", "Pl8nEM0H2tv"),
    ("ICD10", "Q12.2", "Q12.2 Coloboma of lens", "ilbjBSyBxtv"),
    ("ICD10", "Q12.3", "Q12.3 Congenital aphakia", "RgHZSHXqsGB"),
    ("ICD10", "Q12.4", "Q12.4 Spherophakia", "Rdy8KuwZjwQ"),
    ("ICD10", "Q12.8", "Q12.8 Other congenital lens malformations", "oVFgUNyJbAE"),
    ("ICD10", "Q12.9", "Q12.9 Congenital lens malformation, unspecified", "nWKsd6JK42k"),
    ("ICD10", "Q13", "Q13 Congenital malformations of anterior segment of eye", "VHZwOXzJrzr"),
    ("ICD10", "Q13.0", "Q13.0 Coloboma of iris", "uO41krSvg7G"),
    ("ICD10", "Q13.1", "Q13.1 Absence of iris", "YYPvgIkWc7n"),
    ("ICD10", "Q13.2", "Q13.2 Other congenital malformations of iris", "FBAPFKHvtNv"),
    ("ICD10", "Q13.3", "Q13.3 Congenital corneal opacity", "cNzgXY9xaQi"),
    ("ICD10", "Q13.4", "Q13.4 Other congenital corneal malformations", "HnnWP924OSE"),
    ("ICD10", "Q13.5", "Q13.5 Blue sclera", "oYBiE7b8bPH"),
    ("ICD10", "Q13.8", "Q13.8 Other congenital malformations of anterior segment of eye", "aBOfgt5L2td"),
    ("ICD10", "Q13.9", "Q13.9 Congenital malformation of anterior segment of eye, unspecified", "sBN5wDEJwjf"),
    ("ICD10", "Q14", "Q14 Congenital malformations of posterior segment of eye", "rFEWIze4YtA"),
    ("ICD10", "Q14.0", "Q14.0 Congenital malformation of vitreous humour", "JqfwHLoQ9PS"),
    ("ICD10", "Q14.1", "Q14.1 Congenital malformation of retina", "RDtSBiPtAPX"),
    ("ICD10", "Q14.2", "Q14.2 Congenital malformation of optic disc", "HCzBGpnllq3"),
    ("ICD10", "Q14.3", "Q14.3 Congenital malformation of choroid", "gzTDG2kCjuu"),
    ("ICD10", "Q14.8", "Q14.8 Other congenital malformations of posterior segment of eye", "AIEVxA4B4d7"),
    ("ICD10", "Q14.9", "Q14.9 Congenital malformation of posterior segment of eye, unspecified", "xBvr0SiojAV"),
    ("ICD10", "Q15", "Q15 Other congenital malformations of eye", "flAMK2qKnG8"),
    ("ICD10", "Q15.0", "Q15.0 Congenital glaucoma", "KmzPmNMvUV2"),
    ("ICD10", "Q15.8", "Q15.8 Other specified congenital malformations of eye", "ZYL9gJH3GJb"),
    ("ICD10", "Q15.9", "Q15.9 Congenital malformation of eye, unspecified", "QI2i2SYC4jD"),
    ("ICD10", "Q16", "Q16 Congenital malformations of ear causing impairment of hearing", "dB2c4YwGmUJ"),
    ("ICD10", "Q16.0", "Q16.0 Congenital absence of (ear) auricle", "VL2mf1xXBx8"),
    ("ICD10", "Q16.1", "Q16.1 Congenital absence, atresia and stricture of auditory canal (external)", "tilwbUnWRL5"),
    ("ICD10", "Q16.2", "Q16.2 Absence of eustachian tube", "buTkS9DbtPA"),
    ("ICD10", "Q16.3", "Q16.3 Congenital malformation of ear ossicles", "FW7QpSm4OyJ"),
    ("ICD10", "Q16.4", "Q16.4 Other congenital malformations of middle ear", "qcr2RiK9s0H"),
    ("ICD10", "Q16.5", "Q16.5 Congenital malformation of inner ear", "Z9epxuEHZOp"),
    ("ICD10", "Q16.9", "Q16.9 Congenital malformation of ear causing impairment of hearing, unspecified", "goVfpMy5ZSZ"),
    ("ICD10", "Q17", "Q17 Other congenital malformations of ear", "uUVRAljGa0G"),
    ("ICD10", "Q17.0", "Q17.0 Accessory auricle", "DeZ92t6Nn9f"),
    ("ICD10", "Q17.1", "Q17.1 Macrotia", "tHJxtUeGQVi"),
    ("ICD10", "Q17.2", "Q17.2 Microtia", "nyLacoTdGmi"),
    ("ICD10", "Q17.3", "Q17.3 Other misshapen ear", "nkYblcMZVvY"),
    ("ICD10", "Q17.4", "Q17.4 Misplaced ear", "JHaixChGwgG"),
    ("ICD10", "Q17.5", "Q17.5 Prominent ear", "SaWT1YBCmal"),
    ("ICD10", "Q17.8", "Q17.8 Other specified congenital malformations of ear", "cFXoFL7bmQx"),
    ("ICD10", "Q17.9", "Q17.9 Congenital malformation of ear, unspecified", "D8sahUdqhXP"),
    ("ICD10", "Q18", "Q18 Other congenital malformations of face and neck", "QIjvumNkWzs"),
    ("ICD10", "Q18.0", "Q18.0 Sinus, fistula and cyst of branchial cleft", "x9hkevuWEIh"),
    ("ICD10", "Q18.1", "Q18.1 Preauricular sinus and cyst", "lwPVjs6YkKM"),
    ("ICD10", "Q18.2", "Q18.2 Other branchial cleft malformations", "yc52UdGriBb"),
    ("ICD10", "Q18.3", "Q18.3 Webbing of neck", "FDAnIt3YpaZ"),
    ("ICD10", "Q18.4", "Q18.4 Macrostomia", "aFFR00jRodT"),
    ("ICD10", "Q18.5", "Q18.5 Microstomia", "ymiKsi5R9xM"),
    ("ICD10", "Q18.6", "Q18.6 Macrocheilia", "kRDN7ydxWKb"),
    ("ICD10", "Q18.7", "Q18.7 Microcheilia", "ytSwPFeED5E"),
    ("ICD10", "Q18.8", "Q18.8 Other specified congenital malformations of face and neck", "yHGcE15WmDO"),
    ("ICD10", "Q18.9", "Q18.9 Congenital malformation of face and neck, unspecified", "WffTaxXo8bX"),
    ("ICD10", "Q20", "Q20 Congenital malformations of cardiac chambers and connections", "O0Lqevqk0PX"),
    ("ICD10", "Q20.0", "Q20.0 Common arterial trunk", "sjLThhvEwVX"),
    ("ICD10", "Q20.1", "Q20.1 Double outlet right ventricle", "X9NchawCVqu"),
    ("ICD10", "Q20.2", "Q20.2 Double outlet left ventricle", "R7OMkUylXFP"),
    ("ICD10", "Q20.3", "Q20.3 Discordant ventriculoarterial connection", "zwq0q8L1FxP"),
    ("ICD10", "Q20.4", "Q20.4 Double inlet ventricle", "Qg6trkwvCgq"),
    ("ICD10", "Q20.5", "Q20.5 Discordant atrioventricular connection", "ZQaDQX5hVPe"),
    ("ICD10", "Q20.6", "Q20.6 Isomerism of atrial appendages", "fTlNLD4Yk5M"),
    ("ICD10", "Q20.8", "Q20.8 Other congenital malformations of cardiac chambers and connections", "JuI7EBE4r5I"),
    ("ICD10", "Q20.9", "Q20.9 Congenital malformation of cardiac chambers and connections, unspecified", "Pye5Peozoae"),
    ("ICD10", "Q21", "Q21 Congenital malformations of cardiac septa", "cLMRw7oO0A5"),
    ("ICD10", "Q21.0", "Q21.0 Ventricular septal defect", "qvhrhdLFkzt"),
    ("ICD10", "Q21.1", "Q21.1 Atrial septal defect", "kFTgqa8Xsjv"),
    ("ICD10", "Q21.2", "Q21.2 Atrioventricular septal defect", "kFYylQwUvsd"),
    ("ICD10", "Q21.3", "Q21.3 Tetralogy of Fallot", "jTVElZ8xEWF"),
    ("ICD10", "Q21.4", "Q21.4 Aortopulmonary septal defect", "J5RhBXz4xGg"),
    ("ICD10", "Q21.8", "Q21.8 Other congenital malformations of cardiac septa", "GU2MLvd9fuS"),
    ("ICD10", "Q21.9", "Q21.9 Congenital malformation of cardiac septum, unspecified", "t2GYaEwQqig"),
    ("ICD10", "Q22", "Q22 Congenital malformations of pulmonary and tricuspid valves", "GQzAywEN5t5"),
    ("ICD10", "Q22.0", "Q22.0 Pulmonary valve atresia", "nynYF3XWywU"),
    ("ICD10", "Q22.1", "Q22.1 Congenital pulmonary valve stenosis", "A4RDk80Iuu2"),
    ("ICD10", "Q22.2", "Q22.2 Congenital pulmonary valve insufficiency", "u7IC4SaIVY0"),
    ("ICD10", "Q22.3", "Q22.3 Other congenital malformations of pulmonary valve", "fTHq1MDCBRX"),
    ("ICD10", "Q22.4", "Q22.4 Congenital tricuspid stenosis", "WVqHDP79XI1"),
    ("ICD10", "Q22.5", "Q22.5 Ebstein anomaly", "j2jt8FW0UEg"),
    ("ICD10", "Q22.6", "Q22.6 Hypoplastic right heart syndrome", "DcZv49fZWGZ"),
    ("ICD10", "Q22.8", "Q22.8 Other congenital malformations of tricuspid valve", "mAGUbpNDvYo"),
    ("ICD10", "Q22.9", "Q22.9 Congenital malformation of tricuspid valve, unspecified", "QRHEd2l3uTa"),
    ("ICD10", "Q23", "Q23 Congenital malformations of aortic and mitral valves", "MKSqKYiUWlh"),
    ("ICD10", "Q23.0", "Q23.0 Congenital stenosis of aortic valve", "dVOUCWu5EEt"),
    ("ICD10", "Q23.1", "Q23.1 Congenital insufficiency of aortic valve", "BYxdBMcZjjz"),
    ("ICD10", "Q23.2", "Q23.2 Congenital mitral stenosis", "hFXs0VER21O"),
    ("ICD10", "Q23.3", "Q23.3 Congenital mitral insufficiency", "JesZ8PdULQb"),
    ("ICD10", "Q23.4", "Q23.4 Hypoplastic left heart syndrome", "MSLjhIPWX53"),
    ("ICD10", "Q23.8", "Q23.8 Other congenital malformations of aortic and mitral valves", "gvXUGWIsc9m"),
    ("ICD10", "Q23.9", "Q23.9 Congenital malformation of aortic and mitral valves, unspecified", "ylh87AcEBmP"),
    ("ICD10", "Q24", "Q24 Other congenital malformations of heart", "MBf1ePBj5xk"),
    ("ICD10", "Q24.0", "Q24.0 Dextrocardia", "uNhPhEi2Tcs"),
    ("ICD10", "Q24.1", "Q24.1 Laevocardia", "RlLWcymysMb"),
    ("ICD10", "Q24.2", "Q24.2 Cor triatriatum", "KuUAyvEYv97"),
    ("ICD10", "Q24.3", "Q24.3 Pulmonary infundibular stenosis", "lBnJaWiIu5f"),
    ("ICD10", "Q24.4", "Q24.4 Congenital subaortic stenosis", "pXWKbsl7NCF"),
    ("ICD10", "Q24.5", "Q24.5 Malformation of coronary vessels", "jkzBIyY3C0u"),
    ("ICD10", "Q24.6", "Q24.6 Congenital heart block", "PvDYLHlbyuI"),
    ("ICD10", "Q24.8", "Q24.8 Other specified congenital malformations of heart", "Nj96tzVdJsx"),
    ("ICD10", "Q24.9", "Q24.9 Congenital malformation of heart, unspecified", "aQjwwTyyVzl"),
    ("ICD10", "Q25", "Q25 Congenital malformations of great arteries", "UpfRYwmyEOK"),
    ("ICD10", "Q25.0", "Q25.0 Patent ductus arteriosus", "dK2gtTzprxb"),
    ("ICD10", "Q25.1", "Q25.1 Coarctation of aorta", "W2fIVCdJyXJ"),
    ("ICD10", "Q25.2", "Q25.2 Atresia of aorta", "sAmiskqjlsX"),
    ("ICD10", "Q25.3", "Q25.3 Stenosis of aorta", "a34kmDYU6gu"),
    ("ICD10", "Q25.4", "Q25.4 Other congenital malformations of aorta", "r61Mobvg71X"),
    ("ICD10", "Q25.5", "Q25.5 Atresia of pulmonary artery", "eSC082GivNN"),
    ("ICD10", "Q25.6", "Q25.6 Stenosis of pulmonary artery", "uNuxV0O3875"),
    ("ICD10", "Q25.7", "Q25.7 Other congenital malformations of pulmonary artery", "g9afhMc7Zvh"),
    ("ICD10", "Q25.8", "Q25.8 Other congenital malformations of great arteries", "Ye6wenOdSgx"),
    ("ICD10", "Q25.9", "Q25.9 Congenital malformation of great arteries, unspecified", "x9QhyGAtN3K"),
    ("ICD10", "Q26", "Q26 Congenital malformations of great veins", "vfC2MRQt53Z"),
    ("ICD10", "Q26.0", "Q26.0 Congenital stenosis of vena cava", "dvZ2ImGz64L"),
    ("ICD10", "Q26.1", "Q26.1 Persistent left superior vena cava", "WYyn8MlYJZn"),
    ("ICD10", "Q26.2", "Q26.2 Total anomalous pulmonary venous connection", "gXOjOPFytTY"),
    ("ICD10", "Q26.3", "Q26.3 Partial anomalous pulmonary venous connection", "eLpbhy9UzSO"),
    ("ICD10", "Q26.4", "Q26.4 Anomalous pulmonary venous connection, unspecified", "eJSYYtoR2WI"),
    ("ICD10", "Q26.5", "Q26.5 Anomalous portal venous connection", "nVQF5rK8gps"),
    ("ICD10", "Q26.6", "Q26.6 Portal vein-hepatic artery fistula", "X447rN9E7he"),
    ("ICD10", "Q26.8", "Q26.8 Other congenital malformations of great veins", "omHmP1j4Kq1"),
    ("ICD10", "Q26.9", "Q26.9 Congenital malformation of great vein, unspecified", "NlQBDk5wzon"),
    ("ICD10", "Q27", "Q27 Other congenital malformations of peripheral vascular system", "bKhkJ0L36lk"),
    ("ICD10", "Q27.0", "Q27.0 Congenital absence and hypoplasia of umbilical artery", "EDdwdyFRFj3"),
    ("ICD10", "Q27.1", "Q27.1 Congenital renal artery stenosis", "DR0hrpzvolq"),
    ("ICD10", "Q27.2", "Q27.2 Other congenital malformations of renal artery", "npmhA9XT8lQ"),
    ("ICD10", "Q27.3", "Q27.3 Peripheral arteriovenous malformation", "RY3LAKYay2a"),
    ("ICD10", "Q27.4", "Q27.4 Congenital phlebectasia", "y5T7sUKRtCx"),
    ("ICD10", "Q27.8", "Q27.8 Other specified congenital malformations of peripheral vascular system", "fZuBNQtgeU2"),
    ("ICD10", "Q27.9", "Q27.9 Congenital malformation of peripheral vascular system, unspecified", "onJASQ8SeD9"),
    ("ICD10", "Q28", "Q28 Other congenital malformations of circulatory system", "vRCaLSujp01"),
    ("ICD10", "Q28.0", "Q28.0 Arteriovenous malformation of precerebral vessels", "FdLLGjiQdMP"),
    ("ICD10", "Q28.1", "Q28.1 Other malformations of precerebral vessels", "OZnQjBZuQOo"),
    ("ICD10", "Q28.2", "Q28.2 Arteriovenous malformation of cerebral vessels", "hqIEu0NbkG3"),
    ("ICD10", "Q28.3", "Q28.3 Other malformations of cerebral vessels", "fPa9cmlgd3I"),
    ("ICD10", "Q28.8", "Q28.8 Other specified congenital malformations of circulatory system", "QKopWQbK7qW"),
    ("ICD10", "Q28.9", "Q28.9 Congenital malformation of circulatory system, unspecified", "B51c9bzpMXq"),
    ("ICD10", "Q30", "Q30 Congenital malformations of nose", "iEiWg0JCSPF"),
    ("ICD10", "Q30.0", "Q30.0 Choanal atresia", "aNwoUayBVfF"),
    ("ICD10", "Q30.1", "Q30.1 Agenesis and underdevelopment of nose", "GzbxwFjDyCl"),
    ("ICD10", "Q30.2", "Q30.2 Fissured, notched and cleft nose", "B11QrJuwu5c"),
    ("ICD10", "Q30.3", "Q30.3 Congenital perforated nasal septum", "TLrVRzdHJsO"),
    ("ICD10", "Q30.8", "Q30.8 Other congenital malformations of nose", "U0jB5axJAd2"),
    ("ICD10", "Q30.9", "Q30.9 Congenital malformation of nose, unspecified", "dJuMxxBUlIT"),
    ("ICD10", "Q31", "Q31 Congenital malformations of larynx", "zlxcOJdIrIH"),
    ("ICD10", "Q31.0", "Q31.0 Web of larynx", "cCaM9DVaPbP"),
    ("ICD10", "Q31.1", "Q31.1 Congenital subglottic stenosis", "BE05qLRbTXl"),
    ("ICD10", "Q31.2", "Q31.2 Laryngeal hypoplasia", "bBzIjGJgq9a"),
    ("ICD10", "Q31.3", "Q31.3 Laryngocele", "BkFvHCZl9d3"),
    ("ICD10", "Q31.5", "Q31.5 Congenital laryngomalacia", "gBJxwFWbe6D"),
    ("ICD10", "Q31.8", "Q31.8 Other congenital malformations of larynx", "zTvhuDHXznl"),
    ("ICD10", "Q31.9", "Q31.9 Congenital malformation of larynx, unspecified", "rumkC17LFpO"),
    ("ICD10", "Q32", "Q32 Congenital malformations of trachea and bronchus", "AtDkIJd0HXC"),
    ("ICD10", "Q32.0", "Q32.0 Congenital tracheomalacia", "f7ZxUCdHtM8"),
    ("ICD10", "Q32.1", "Q32.1 Other congenital malformations of trachea", "pNuhH7igGyg"),
    ("ICD10", "Q32.2", "Q32.2 Congenital bronchomalacia", "jU6C5F8DER2"),
    ("ICD10", "Q32.3", "Q32.3 Congenital stenosis of bronchus", "EFixYgnnVZ9"),
    ("ICD10", "Q32.4", "Q32.4 Other congenital malformations of bronchus", "NTkNhIZuCH1"),
    ("ICD10", "Q33", "Q33 Congenital malformations of lung", "S5GdMJZ27nd"),
    ("ICD10", "Q33.0", "Q33.0 Congenital cystic lung", "BlI79CAQTyd"),
    ("ICD10", "Q33.1", "Q33.1 Accessory lobe of lung", "FPM3nxPz6mR"),
    ("ICD10", "Q33.2", "Q33.2 Sequestration of lung", "GbAkSBEU8lw"),
    ("ICD10", "Q33.3", "Q33.3 Agenesis of lung", "ZyI79o1lHTY"),
    ("ICD10", "Q33.4", "Q33.4 Congenital bronchiectasis", "jE3l6zLOGhb"),
    ("ICD10", "Q33.5", "Q33.5 Ectopic tissue in lung", "cJOFHrHnRNX"),
    ("ICD10", "Q33.6", "Q33.6 Hypoplasia and dysplasia of lung", "Wzd9IaryYbQ"),
    ("ICD10", "Q33.8", "Q33.8 Other congenital malformations of lung", "octYxuyjPAB"),
    ("ICD10", "Q33.9", "Q33.9 Congenital malformation of lung, unspecified", "HXepUhAb6sO"),
    ("ICD10", "Q34", "Q34 Other congenital malformations of respiratory system", "lL7OzQ4dLUI"),
    ("ICD10", "Q34.0", "Q34.0 Anomaly of pleura", "iCNEtPfmwyx"),
    ("ICD10", "Q34.1", "Q34.1 Congenital cyst of mediastinum", "s1Il63PbucQ"),
    ("ICD10", "Q34.8", "Q34.8 Other specified congenital malformations of respiratory system", "RCXC3oOWt0K"),
    ("ICD10", "Q34.9", "Q34.9 Congenital malformation of respiratory system, unspecified", "UVR3dAiAJAV"),
    ("ICD10", "Q35", "Q35 Cleft palate", "BGlfRmu9sa9"),
    ("ICD10", "Q35.1", "Q35.1 Cleft hard palate", "vTx87kocslf"),
    ("ICD10", "Q35.3", "Q35.3 Cleft soft palate", "or8Kux9rmvX"),
    ("ICD10", "Q35.5", "Q35.5 Cleft hard palate with cleft soft palate", "nngzbuDZvHy"),
    ("ICD10", "Q35.7", "Q35.7 Cleft uvula", "JhR6WK1nIIU"),
    ("ICD10", "Q35.9", "Q35.9 Cleft palate, unspecified", "YEXEDihDPBE"),
    ("ICD10", "Q36", "Q36 Cleft lip", "blKTRalv6ZJ"),
    ("ICD10", "Q36.0", "Q36.0 Cleft lip, bilateral", "NKWKOlPS5EN"),
    ("ICD10", "Q36.1", "Q36.1 Cleft lip, median", "uUuRgDkIWGs"),
    ("ICD10", "Q36.9", "Q36.9 Cleft lip, unilateral", "FdgLpVX1kxL"),
    ("ICD10", "Q37", "Q37 Cleft palate with cleft lip", "Yad4WX4kaDi"),
    ("ICD10", "Q37.0", "Q37.0 Cleft hard palate with bilateral cleft lip", "jTCRtU221Ct"),
    ("ICD10", "Q37.1", "Q37.1 Cleft hard palate with unilateral cleft lip", "d5jb7K8myVn"),
    ("ICD10", "Q37.2", "Q37.2 Cleft soft palate with bilateral cleft lip", "epBxYgjoaGe"),
    ("ICD10", "Q37.3", "Q37.3 Cleft soft palate with unilateral cleft lip", "jg4gD4C6I12"),
    ("ICD10", "Q37.4", "Q37.4 Cleft hard and soft palate with bilateral cleft lip", "vqW7T2etVhL"),
    ("ICD10", "Q37.5", "Q37.5 Cleft hard and soft palate with unilateral cleft lip", "qqiuVSVKXM0"),
    ("ICD10", "Q37.8", "Q37.8 Unspecified cleft palate with bilateral cleft lip", "cSnfwTD2Uat"),
    ("ICD10", "Q37.9", "Q37.9 Unspecified cleft palate with unilateral cleft lip", "TUAdi1ISaPL"),
    ("ICD10", "Q38", "Q38 Other congenital malformations of tongue, mouth and pharynx", "YKiyEsIkTrW"),
    ("ICD10", "Q38.0", "Q38.0 Congenital malformations of lips, not elsewhere classified", "YBql1i3i1E7"),
    ("ICD10", "Q38.1", "Q38.1 Ankyloglossia", "xTkZAwBShJv"),
    ("ICD10", "Q38.2", "Q38.2 Macroglossia", "VjRyVGrRni0"),
    ("ICD10", "Q38.3", "Q38.3 Other congenital malformations of tongue", "psoevITzFEn"),
    ("ICD10", "Q38.4", "Q38.4 Congenital malformations of salivary glands and ducts", "G8T2jcvYCL5"),
    ("ICD10", "Q38.5", "Q38.5 Congenital malformations of palate, not elsewhere classified", "Sg4BvPbqe59"),
    ("ICD10", "Q38.6", "Q38.6 Other congenital malformations of mouth", "DhZr9NPef2u"),
    ("ICD10", "Q38.7", "Q38.7 Pharyngeal pouch", "EJBavhd6TCn"),
    ("ICD10", "Q38.8", "Q38.8 Other congenital malformations of pharynx", "MtLqXRV525V"),
    ("ICD10", "Q39", "Q39 Congenital malformations of oesophagus", "nLRETojlXBj"),
    ("ICD10", "Q39.0", "Q39.0 Atresia of oesophagus without fistula", "mwA1uZuPIKQ"),
    ("ICD10", "Q39.1", "Q39.1 Atresia of oesophagus with tracheo-oesophageal fistula", "V97YjyKR4mW"),
    ("ICD10", "Q39.2", "Q39.2 Congenital tracheo-oesophageal fistula without atresia", "HdlA3aa46ej"),
    ("ICD10", "Q39.3", "Q39.3 Congenital stenosis and stricture of oesophagus", "jjgVwY7iYoB"),
    ("ICD10", "Q39.4", "Q39.4 Oesophageal web", "i8PmyEWTrer"),
    ("ICD10", "Q39.5", "Q39.5 Congenital dilatation of oesophagus", "ToWC8c1EO0D"),
    ("ICD10", "Q39.6", "Q39.6 Diverticulum of oesophagus", "YaujWfKy5Fl"),
    ("ICD10", "Q39.8", "Q39.8 Other congenital malformations of oesophagus", "nuzjdOYeyuE"),
    ("ICD10", "Q39.9", "Q39.9 Congenital malformation of oesophagus, unspecified", "sSPX7gy1uji"),
    ("ICD10", "Q40", "Q40 Other congenital malformations of upper alimentary tract", "Zq6Ku0xy1P5"),
    ("ICD10", "Q40.0", "Q40.0 Congenital hypertrophic pyloric stenosis", "VjxkAAcy6ft"),
    ("ICD10", "Q40.1", "Q40.1 Congenital hiatus hernia", "MVjgofu0ebJ"),
    ("ICD10", "Q40.2", "Q40.2 Other specified congenital malformations of stomach", "lAoQS8b3dKJ"),
    ("ICD10", "Q40.3", "Q40.3 Congenital malformation of stomach, unspecified", "lda4UHMvtBm"),
    ("ICD10", "Q40.8", "Q40.8 Other specified congenital malformations of upper alimentary tract", "xtFYq02tj0X"),
    ("ICD10", "Q40.9", "Q40.9 Congenital malformation of upper alimentary tract, unspecified", "Jf8zIkXuF4X"),
    ("ICD10", "Q41", "Q41 Congenital absence, atresia and stenosis of small intestine", "z8PnYiQQ3SS"),
    ("ICD10", "Q41.0", "Q41.0 Congenital absence, atresia and stenosis of duodenum", "b9DBTLQESKy"),
    ("ICD10", "Q41.1", "Q41.1 Congenital absence, atresia and stenosis of jejunum", "Yg0lBCiGdrW"),
    ("ICD10", "Q41.2", "Q41.2 Congenital absence, atresia and stenosis of ileum", "SJ6Beq4BYFi"),
    ("ICD10", "Q41.8", "Q41.8 Congenital absence, atresia and stenosis of other specified parts of small intestine", "WUAmW3VXHoZ"),
    ("ICD10", "Q41.9", "Q41.9 Congenital absence, atresia and stenosis of small intestine, part unspecified", "yGmjRlMI6UO"),
    ("ICD10", "Q42", "Q42 Congenital absence, atresia and stenosis of large intestine", "tpm4p5rEBi5"),
    ("ICD10", "Q42.0", "Q42.0 Congenital absence, atresia and stenosis of rectum with fistula", "jV7tef0fFyt"),
    ("ICD10", "Q42.1", "Q42.1 Congenital absence, atresia and stenosis of rectum without fistula", "l0NWK3YTHTc"),
    ("ICD10", "Q42.2", "Q42.2 Congenital absence, atresia and stenosis of anus with fistula", "TANmGIog8XJ"),
    ("ICD10", "Q42.3", "Q42.3 Congenital absence, atresia and stenosis of anus without fistula", "e5wuGu8YczA"),
    ("ICD10", "Q42.8", "Q42.8 Congenital absence, atresia and stenosis of other parts of large intestine", "LnFMGoFCgmH"),
    ("ICD10", "Q42.9", "Q42.9 Congenital absence, atresia and stenosis of large intestine, part unspecified", "kQoFQKYS2P2"),
    ("ICD10", "Q43", "Q43 Other congenital malformations of intestine", "ZnO7IeWSYIx"),
    ("ICD10", "Q43.0", "Q43.0 Meckel diverticulum", "eUajT5parTc"),
    ("ICD10", "Q43.1", "Q43.1 Hirschsprung disease", "C3inrIDzpEX");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Q43.2", "Q43.2 Other congenital functional disorders of colon", "aifkvJszRKK"),
    ("ICD10", "Q43.3", "Q43.3 Congenital malformations of intestinal fixation", "VeQ0MKNqcJ5"),
    ("ICD10", "Q43.4", "Q43.4 Duplication of intestine", "AdX9adWkdg3"),
    ("ICD10", "Q43.5", "Q43.5 Ectopic anus", "bZtbQydPhTQ"),
    ("ICD10", "Q43.6", "Q43.6 Congenital fistula of rectum and anus", "mnPfSO5D6At"),
    ("ICD10", "Q43.7", "Q43.7 Persistent cloaca", "Gdjws4JNlAn"),
    ("ICD10", "Q43.8", "Q43.8 Other specified congenital malformations of intestine", "ElIAadoclQ3"),
    ("ICD10", "Q43.9", "Q43.9 Congenital malformation of intestine, unspecified", "ShuFnJyB8jx"),
    ("ICD10", "Q44", "Q44 Congenital malformations of gallbladder, bile ducts and liver", "oxne8zCTlFa"),
    ("ICD10", "Q44.0", "Q44.0 Agenesis, aplasia and hypoplasia of gallbladder", "tF53RWHfnKf"),
    ("ICD10", "Q44.1", "Q44.1 Other congenital malformations of gallbladder", "woJDoXWMi5f"),
    ("ICD10", "Q44.2", "Q44.2 Atresia of bile ducts", "Wp47zGfiMNp"),
    ("ICD10", "Q44.3", "Q44.3 Congenital stenosis and stricture of bile ducts", "Mf9B9lPuERO"),
    ("ICD10", "Q44.4", "Q44.4 Choledochal cyst", "ySkm4CLHATj"),
    ("ICD10", "Q44.5", "Q44.5 Other congenital malformations of bile ducts", "ETxl8tfPIXq"),
    ("ICD10", "Q44.6", "Q44.6 Cystic disease of liver", "tgNC3Anp1ff"),
    ("ICD10", "Q44.7", "Q44.7 Other congenital malformations of liver", "eyk0G59SZbT"),
    ("ICD10", "Q45", "Q45 Other congenital malformations of digestive system", "kUfA23XR0Uf"),
    ("ICD10", "Q45.0", "Q45.0 Agenesis, aplasia and hypoplasia of pancreas", "bP7VMP2Bjeo"),
    ("ICD10", "Q45.1", "Q45.1 Annular pancreas", "Y2TFLQQIJi2"),
    ("ICD10", "Q45.2", "Q45.2 Congenital pancreatic cyst", "weU0TpbTcaL"),
    ("ICD10", "Q45.3", "Q45.3 Other congenital malformations of pancreas and pancreatic duct", "Eb4EsQwt31z"),
    ("ICD10", "Q45.8", "Q45.8 Other specified congenital malformations of digestive system", "z5DwHZ5Xoev"),
    ("ICD10", "Q45.9", "Q45.9 Congenital malformation of digestive system, unspecified", "oGC0EAZdFHs"),
    ("ICD10", "Q50", "Q50 Congenital malformations of ovaries, fallopian tubes and broad ligaments", "GVES4PjBlT0"),
    ("ICD10", "Q50.0", "Q50.0 Congenital absence of ovary", "KsH4JRfD5mg"),
    ("ICD10", "Q50.1", "Q50.1 Developmental ovarian cyst", "jV0wTJsMCro"),
    ("ICD10", "Q50.2", "Q50.2 Congenital torsion of ovary", "I6g5fACGtFJ"),
    ("ICD10", "Q50.3", "Q50.3 Other congenital malformations of ovary", "ip4LVc8KyX1"),
    ("ICD10", "Q50.4", "Q50.4 Embryonic cyst of fallopian tube", "e24FZZM6bO0"),
    ("ICD10", "Q50.5", "Q50.5 Embryonic cyst of broad ligament", "W2PdxwONUoI"),
    ("ICD10", "Q50.6", "Q50.6 Other congenital malformations of fallopian tube and broad ligament", "mpsPLhwQ7eT"),
    ("ICD10", "Q51", "Q51 Congenital malformations of uterus and cervix", "BmRKdY5RHfX"),
    ("ICD10", "Q51.0", "Q51.0 Agenesis and aplasia of uterus", "YXPOvIiJVbE"),
    ("ICD10", "Q51.1", "Q51.1 Doubling of uterus with doubling of cervix and vagina", "aQF8cf3PX26"),
    ("ICD10", "Q51.2", "Q51.2 Other doubling of uterus", "V7Ssz0fwnsm"),
    ("ICD10", "Q51.3", "Q51.3 Bicornate uterus", "lXfRGuVwboL"),
    ("ICD10", "Q51.4", "Q51.4 Unicornate uterus", "wbxLQ7MYPQw"),
    ("ICD10", "Q51.5", "Q51.5 Agenesis and aplasia of cervix", "gZOMhwxp1Vl"),
    ("ICD10", "Q51.6", "Q51.6 Embryonic cyst of cervix", "wMyK2WUTXzJ"),
    ("ICD10", "Q51.7", "Q51.7 Congenital fistulae between uterus and digestive and urinary tracts", "ouLBYu8HprC"),
    ("ICD10", "Q51.8", "Q51.8 Other congenital malformations of uterus and cervix", "KPLGSl3WHEz"),
    ("ICD10", "Q51.9", "Q51.9 Congenital malformation of uterus and cervix, unspecified", "mXtdOxuE819"),
    ("ICD10", "Q52", "Q52 Other congenital malformations of female genitalia", "TdVWaVC5yoS"),
    ("ICD10", "Q52.0", "Q52.0 Congenital absence of vagina", "stHXMionHkw"),
    ("ICD10", "Q52.1", "Q52.1 Doubling of vagina", "hFNNqvNoehq"),
    ("ICD10", "Q52.2", "Q52.2 Congenital rectovaginal fistula", "zKcmjLPWIUX"),
    ("ICD10", "Q52.3", "Q52.3 Imperforate hymen", "p01gVyKlqoC"),
    ("ICD10", "Q52.4", "Q52.4 Other congenital malformations of vagina", "JuBpNWTkEip"),
    ("ICD10", "Q52.5", "Q52.5 Fusion of labia", "aqVIEdUKRAx"),
    ("ICD10", "Q52.6", "Q52.6 Congenital malformation of clitoris", "K6xOlpreHWx"),
    ("ICD10", "Q52.7", "Q52.7 Other congenital malformations of vulva", "S1atZMhBUIC"),
    ("ICD10", "Q52.8", "Q52.8 Other specified congenital malformations of female genitalia", "GGwwMIpsTSh"),
    ("ICD10", "Q52.9", "Q52.9 Congenital malformation of female genitalia, unspecified", "jpqDPH1DwFa"),
    ("ICD10", "Q53", "Q53 Undescended testicle", "rjgViKlGUL3"),
    ("ICD10", "Q53.0", "Q53.0 Ectopic testis", "TcY9ViHfL0F"),
    ("ICD10", "Q53.1", "Q53.1 Undescended testicle, unilateral", "ChuBCR16ADc"),
    ("ICD10", "Q53.2", "Q53.2 Undescended testicle, bilateral", "ce0rKCM906d"),
    ("ICD10", "Q53.9", "Q53.9 Undescended testicle, unspecified", "MV8tXZrUdY0"),
    ("ICD10", "Q54", "Q54 Hypospadias", "RBguFY2e1g4"),
    ("ICD10", "Q54.0", "Q54.0 Hypospadias, balanic", "RZYOzz6Lv9O"),
    ("ICD10", "Q54.1", "Q54.1 Hypospadias, penile", "nd4ydJinLTW"),
    ("ICD10", "Q54.2", "Q54.2 Hypospadias, penoscrotal", "FMZcCBk5tFa"),
    ("ICD10", "Q54.3", "Q54.3 Hypospadias, perineal", "qwfIOGRPCyv"),
    ("ICD10", "Q54.4", "Q54.4 Congenital chordee", "hYMXndloWpd"),
    ("ICD10", "Q54.8", "Q54.8 Other hypospadias", "tvodfsOK5wK"),
    ("ICD10", "Q54.9", "Q54.9 Hypospadias, unspecified", "L2RgNWvq3ar"),
    ("ICD10", "Q55", "Q55 Other congenital malformations of male genital organs", "kuO1yWWkBRu"),
    ("ICD10", "Q55.0", "Q55.0 Absence and aplasia of testis", "e8rKd8pt8i8"),
    ("ICD10", "Q55.1", "Q55.1 Hypoplasia of testis and scrotum", "fKCnGQeVbxL"),
    ("ICD10", "Q55.2", "Q55.2 Other congenital malformations of testis and scrotum", "Oity3nacmFs"),
    ("ICD10", "Q55.3", "Q55.3 Atresia of vas deferens", "Jhmy7ANlAHQ"),
    ("ICD10", "Q55.4", "Q55.4 Other congenital malformations of vas deferens, epididymis, seminal vesicles and prostate", "vkMD8uM7mVU"),
    ("ICD10", "Q55.5", "Q55.5 Congenital absence and aplasia of penis", "pYUtdw9MuDy"),
    ("ICD10", "Q55.6", "Q55.6 Other congenital malformations of penis", "MPv9mA4fVEw"),
    ("ICD10", "Q55.8", "Q55.8 Other specified congenital malformations of male genital organs", "U46By3GikhP"),
    ("ICD10", "Q55.9", "Q55.9 Congenital malformation of male genital organ, unspecified", "Or9rccEGYFx"),
    ("ICD10", "Q56", "Q56 Indeterminate sex and pseudohermaphroditism", "ck5PNZmHQdn"),
    ("ICD10", "Q56.0", "Q56.0 Hermaphroditism, not elsewhere classified", "MASeAtoGgIS"),
    ("ICD10", "Q56.1", "Q56.1 Male pseudohermaphroditism, not elsewhere classified", "cG1QTE2rgll"),
    ("ICD10", "Q56.2", "Q56.2 Female pseudohermaphroditism, not elsewhere classified", "KdqcaQjacJQ"),
    ("ICD10", "Q56.3", "Q56.3 Pseudohermaphroditism, unspecified", "ln8c1nrqbke"),
    ("ICD10", "Q56.4", "Q56.4 Indeterminate sex, unspecified", "SuRdMVYKWo0"),
    ("ICD10", "Q60", "Q60 Renal agenesis and other reduction defects of kidney", "iP6lZkvw1it"),
    ("ICD10", "Q60.0", "Q60.0 Renal agenesis, unilateral", "POa7EcTLQy6"),
    ("ICD10", "Q60.1", "Q60.1 Renal agenesis, bilateral", "GhuPeIpGp4f"),
    ("ICD10", "Q60.2", "Q60.2 Renal agenesis, unspecified", "nwIwkFCAG0g"),
    ("ICD10", "Q60.3", "Q60.3 Renal hypoplasia, unilateral", "reDkAtkZVqy"),
    ("ICD10", "Q60.4", "Q60.4 Renal hypoplasia, bilateral", "Ikb7r338lLW"),
    ("ICD10", "Q60.5", "Q60.5 Renal hypoplasia, unspecified", "Z2V11DUpUMC"),
    ("ICD10", "Q60.6", "Q60.6 Potter syndrome", "oVJZQORELGr"),
    ("ICD10", "Q61", "Q61 Cystic kidney disease", "CkwtxxJWZIX"),
    ("ICD10", "Q61.0", "Q61.0 Congenital single renal cyst", "JHq83yO76Ge"),
    ("ICD10", "Q61.1", "Q61.1 Polycystic kidney, autosomal recessive", "OsMF2LysT7O"),
    ("ICD10", "Q61.2", "Q61.2 Polycystic kidney, autosomal dominant", "Y2r9acjFEgj"),
    ("ICD10", "Q61.3", "Q61.3 Polycystic kidney, unspecified", "VxAqIuA68Vw"),
    ("ICD10", "Q61.4", "Q61.4 Renal dysplasia", "OKcTGZi9WUr"),
    ("ICD10", "Q61.5", "Q61.5 Medullary cystic kidney", "kldXosZrQ9d"),
    ("ICD10", "Q61.8", "Q61.8 Other cystic kidney diseases", "WpBrAs3QyEY"),
    ("ICD10", "Q61.9", "Q61.9 Cystic kidney disease, unspecified", "JFYpOtPfxtx"),
    ("ICD10", "Q62", "Q62 Congenital obstructive defects of renal pelvis and congenital malformations of ureter", "Ai3knBb2o4w"),
    ("ICD10", "Q62.0", "Q62.0 Congenital hydronephrosis", "Nl6xtvqp7VO"),
    ("ICD10", "Q62.1", "Q62.1 Atresia and stenosis of ureter", "HfT743DqM42"),
    ("ICD10", "Q62.2", "Q62.2 Congenital megaloureter", "mYBRYzh6hch"),
    ("ICD10", "Q62.3", "Q62.3 Other obstructive defects of renal pelvis and ureter", "p09VOULtY2m"),
    ("ICD10", "Q62.4", "Q62.4 Agenesis of ureter", "USTY7hvg4sn"),
    ("ICD10", "Q62.5", "Q62.5 Duplication of ureter", "VUHlseWLV8u"),
    ("ICD10", "Q62.6", "Q62.6 Malposition of ureter", "oXBfNoj1CHV"),
    ("ICD10", "Q62.7", "Q62.7 Congenital vesico-uretero-renal reflux", "AXI8zUQTnsz"),
    ("ICD10", "Q62.8", "Q62.8 Other congenital malformations of ureter", "PYKnxCXGvml"),
    ("ICD10", "Q63", "Q63 Other congenital malformations of kidney", "wF84YvHGhP6"),
    ("ICD10", "Q63.0", "Q63.0 Accessory kidney", "DI7HpeftBvK"),
    ("ICD10", "Q63.1", "Q63.1 Lobulated, fused and horseshoe kidney", "rwqvGoDt53g"),
    ("ICD10", "Q63.2", "Q63.2 Ectopic kidney", "CjDwiyOxU78"),
    ("ICD10", "Q63.3", "Q63.3 Hyperplastic and giant kidney", "OBmXDeqm9EJ"),
    ("ICD10", "Q63.8", "Q63.8 Other specified congenital malformations of kidney", "QP1knORAI02"),
    ("ICD10", "Q63.9", "Q63.9 Congenital malformation of kidney, unspecified", "qkdrQ2K7UP7"),
    ("ICD10", "Q64", "Q64 Other congenital malformations of urinary system", "mKtCkrCHz1E"),
    ("ICD10", "Q64.0", "Q64.0 Epispadias", "EHXsyq4q9mT"),
    ("ICD10", "Q64.1", "Q64.1 Exstrophy of urinary bladder", "HeKfzn9iNSb"),
    ("ICD10", "Q64.2", "Q64.2 Congenital posterior urethral valves", "wRVpop5scWP"),
    ("ICD10", "Q64.3", "Q64.3 Other atresia and stenosis of urethra and bladder neck", "fjhBJFXqf09"),
    ("ICD10", "Q64.4", "Q64.4 Malformation of urachus", "jBea1IeKGPx"),
    ("ICD10", "Q64.5", "Q64.5 Congenital absence of bladder and urethra", "o9xSuAItVKn"),
    ("ICD10", "Q64.6", "Q64.6 Congenital diverticulum of bladder", "NbKe4DXx0OC"),
    ("ICD10", "Q64.7", "Q64.7 Other congenital malformations of bladder and urethra", "cswJzfPAUXt"),
    ("ICD10", "Q64.8", "Q64.8 Other specified congenital malformations of urinary system", "SSXk8hCGm6k"),
    ("ICD10", "Q64.9", "Q64.9 Congenital malformation of urinary system, unspecified", "p0oYJ2yFerk"),
    ("ICD10", "Q65", "Q65 Congenital deformities of hip", "EVOLOF4HdzW"),
    ("ICD10", "Q65.0", "Q65.0 Congenital dislocation of hip, unilateral", "vR58a8H20Wb"),
    ("ICD10", "Q65.1", "Q65.1 Congenital dislocation of hip, bilateral", "xIwvBWvoErv"),
    ("ICD10", "Q65.2", "Q65.2 Congenital dislocation of hip, unspecified", "YCwqoriXOd9"),
    ("ICD10", "Q65.3", "Q65.3 Congenital subluxation of hip, unilateral", "T3sYpm8wSBt"),
    ("ICD10", "Q65.4", "Q65.4 Congenital subluxation of hip, bilateral", "yTqoPGkg7sL"),
    ("ICD10", "Q65.5", "Q65.5 Congenital subluxation of hip, unspecified", "R5j7Et5ZZGl"),
    ("ICD10", "Q65.6", "Q65.6 Unstable hip", "kgZKI4lAyxq"),
    ("ICD10", "Q65.8", "Q65.8 Other congenital deformities of hip", "cYupfuQ4sxz"),
    ("ICD10", "Q65.9", "Q65.9 Congenital deformity of hip, unspecified", "Ry1kc39Z7rw"),
    ("ICD10", "Q66", "Q66 Congenital deformities of feet", "IqyjpZJAKG6"),
    ("ICD10", "Q66.0", "Q66.0 Talipes equinovarus", "Py7i9NNHnYz"),
    ("ICD10", "Q66.1", "Q66.1 Talipes calcaneovarus", "DYh2hFb2ZyR"),
    ("ICD10", "Q66.2", "Q66.2 Metatarsus varus", "xLMbHZD5b04"),
    ("ICD10", "Q66.3", "Q66.3 Other congenital varus deformities of feet", "zgACu9nZ2yD"),
    ("ICD10", "Q66.4", "Q66.4 Talipes calcaneovalgus", "jpSq9HO7oHu"),
    ("ICD10", "Q66.5", "Q66.5 Congenital pes planus", "cNdO6s2X2rw"),
    ("ICD10", "Q66.6", "Q66.6 Other congenital valgus deformities of feet", "QjDEKrTnpx1"),
    ("ICD10", "Q66.7", "Q66.7 Pes cavus", "AkD5ENLkqDA"),
    ("ICD10", "Q66.8", "Q66.8 Other congenital deformities of feet", "qvU6TbylMaV"),
    ("ICD10", "Q66.9", "Q66.9 Congenital deformity of feet, unspecified", "fIMDdofNVMg"),
    ("ICD10", "Q67", "Q67 Congenital musculoskeletal deformities of head, face, spine and chest", "vRtB6yiJvDx"),
    ("ICD10", "Q67.0", "Q67.0 Facial asymmetry", "mg1agkw79rk"),
    ("ICD10", "Q67.1", "Q67.1 Compression facies", "ZQZw0k1BoRp"),
    ("ICD10", "Q67.2", "Q67.2 Dolichocephaly", "R3A4I55weMR"),
    ("ICD10", "Q67.3", "Q67.3 Plagiocephaly", "tULuYGYkA1y"),
    ("ICD10", "Q67.4", "Q67.4 Other congenital deformities of skull, face and jaw", "tPvtkVmPTtw"),
    ("ICD10", "Q67.5", "Q67.5 Congenital deformity of spine", "Rj91gbd4RQc"),
    ("ICD10", "Q67.6", "Q67.6 Pectus excavatum", "GVaQ7ealwfb"),
    ("ICD10", "Q67.7", "Q67.7 Pectus carinatum", "fA68lR7BpZm"),
    ("ICD10", "Q67.8", "Q67.8 Other congenital deformities of chest", "o4ObTszDHXj"),
    ("ICD10", "Q68", "Q68 Other congenital musculoskeletal deformities", "m0KY8beWkiT"),
    ("ICD10", "Q68.0", "Q68.0 Congenital deformity of sternocleidomastoid muscle", "CB8l2cET06K"),
    ("ICD10", "Q68.1", "Q68.1 Congenital deformity of hand", "OPC1sYWIDPv"),
    ("ICD10", "Q68.2", "Q68.2 Congenital deformity of knee", "j48UL8eCISr"),
    ("ICD10", "Q68.3", "Q68.3 Congenital bowing of femur", "trxKv1Mb5Np"),
    ("ICD10", "Q68.4", "Q68.4 Congenital bowing of tibia and fibula", "mrKW32L6IlN"),
    ("ICD10", "Q68.5", "Q68.5 Congenital bowing of long bones of leg, unspecified", "KbYIcpKFWi0"),
    ("ICD10", "Q68.8", "Q68.8 Other specified congenital musculoskeletal deformities", "Fo8Ev8D9Y3I"),
    ("ICD10", "Q69", "Q69 Polydactyly", "noatL6yqL0x"),
    ("ICD10", "Q69.0", "Q69.0 Accessory finger(s)", "g9XhzpQ9DMC"),
    ("ICD10", "Q69.1", "Q69.1 Accessory thumb(s)", "oBZGhX2W7C5"),
    ("ICD10", "Q69.2", "Q69.2 Accessory toe(s)", "nvbUEcwB9ZZ"),
    ("ICD10", "Q69.9", "Q69.9 Polydactyly, unspecified", "i82GFthwCKg"),
    ("ICD10", "Q70", "Q70 Syndactyly", "BJi2wSB0227"),
    ("ICD10", "Q70.0", "Q70.0 Fused fingers", "SFNTvjDPFU2"),
    ("ICD10", "Q70.1", "Q70.1 Webbed fingers", "eDd2ikeGYMW"),
    ("ICD10", "Q70.2", "Q70.2 Fused toes", "AqpdSqb0R2e"),
    ("ICD10", "Q70.3", "Q70.3 Webbed toes", "SbDCnFTCVrI"),
    ("ICD10", "Q70.4", "Q70.4 Polysyndactyly", "XAXS9UkfcLS"),
    ("ICD10", "Q70.9", "Q70.9 Syndactyly, unspecified", "BxOFDJ9c1aK"),
    ("ICD10", "Q71", "Q71 Reduction defects of upper limb", "HBk3kupNECR"),
    ("ICD10", "Q71.0", "Q71.0 Congenital complete absence of upper limb(s)", "rsgemmXQmrY"),
    ("ICD10", "Q71.1", "Q71.1 Congenital absence of upper arm and forearm with hand present", "zoJCXQpJ4BD"),
    ("ICD10", "Q71.2", "Q71.2 Congenital absence of both forearm and hand", "fBWpHYWy0JN"),
    ("ICD10", "Q71.3", "Q71.3 Congenital absence of hand and finger(s)", "ytKGMrOafSJ"),
    ("ICD10", "Q71.4", "Q71.4 Longitudinal reduction defect of radius", "fs6nSarcsQL"),
    ("ICD10", "Q71.5", "Q71.5 Longitudinal reduction defect of ulna", "drNmBx2jep3"),
    ("ICD10", "Q71.6", "Q71.6 Lobster-claw hand", "k6u1foUKeNB"),
    ("ICD10", "Q71.8", "Q71.8 Other reduction defects of upper limb(s)", "vA2EZxIbFeA"),
    ("ICD10", "Q71.9", "Q71.9 Reduction defect of upper limb, unspecified", "mNUITfyHwMt"),
    ("ICD10", "Q72", "Q72 Reduction defects of lower limb", "nxFtGLFkFSW"),
    ("ICD10", "Q72.0", "Q72.0 Congenital complete absence of lower limb(s)", "bF6HhYzQ8r6"),
    ("ICD10", "Q72.1", "Q72.1 Congenital absence of thigh and lower leg with foot present", "vVVktyZNKM0"),
    ("ICD10", "Q72.2", "Q72.2 Congenital absence of both lower leg and foot", "Wa71ZJArkc3"),
    ("ICD10", "Q72.3", "Q72.3 Congenital absence of foot and toe(s)", "pENJpbRA47i"),
    ("ICD10", "Q72.4", "Q72.4 Longitudinal reduction defect of femur", "E5AYuoDJHr6"),
    ("ICD10", "Q72.5", "Q72.5 Longitudinal reduction defect of tibia", "JVvzwwwJf60"),
    ("ICD10", "Q72.6", "Q72.6 Longitudinal reduction defect of fibula", "jMyYHz5kUgD"),
    ("ICD10", "Q72.7", "Q72.7 Split foot", "U1LvilmUw2q"),
    ("ICD10", "Q72.8", "Q72.8 Other reduction defects of lower limb(s)", "qzxadUuEHnx"),
    ("ICD10", "Q72.9", "Q72.9 Reduction defect of lower limb, unspecified", "lJ4e3pfHKR0"),
    ("ICD10", "Q73", "Q73 Reduction defects of unspecified limb", "hJWYBNQrgqi"),
    ("ICD10", "Q73.0", "Q73.0 Congenital absence of unspecified limb(s)", "HYasrHcoAlc"),
    ("ICD10", "Q73.1", "Q73.1 Phocomelia, unspecified limb(s)", "W0GWtWoAFwC"),
    ("ICD10", "Q73.8", "Q73.8 Other reduction defects of unspecified limb(s)", "X2ObhpUnaoE"),
    ("ICD10", "Q74", "Q74 Other congenital malformations of limb(s)", "Qo9Rg90VaRB"),
    ("ICD10", "Q74.0", "Q74.0 Other congenital malformations of upper limb(s), including shoulder girdle", "M5PXL6DjT8E"),
    ("ICD10", "Q74.1", "Q74.1 Congenital malformation of knee", "wjrKPssNQN9"),
    ("ICD10", "Q74.2", "Q74.2 Other congenital malformations of lower limb(s), including pelvic girdle", "hkTxGGizMEw"),
    ("ICD10", "Q74.3", "Q74.3 Arthrogryposis multiplex congenita", "g5xiI861mNN"),
    ("ICD10", "Q74.8", "Q74.8 Other specified congenital malformations of limb(s)", "lkdRNIQWEH5"),
    ("ICD10", "Q74.9", "Q74.9 Unspecified congenital malformation of limb(s)", "wMtvzIlQumZ"),
    ("ICD10", "Q75", "Q75 Other congenital malformations of skull and face bones", "udjAZ6StblF"),
    ("ICD10", "Q75.0", "Q75.0 Craniosynostosis", "m9hJvrtXj5Z"),
    ("ICD10", "Q75.1", "Q75.1 Craniofacial dysostosis", "mshcWaWV2j2"),
    ("ICD10", "Q75.2", "Q75.2 Hypertelorism", "BTNbptkG1ak"),
    ("ICD10", "Q75.3", "Q75.3 Macrocephaly", "BC02O1DIHxv"),
    ("ICD10", "Q75.4", "Q75.4 Mandibulofacial dysostosis", "lL2mChm3XuA"),
    ("ICD10", "Q75.5", "Q75.5 Oculomandibular dysostosis", "k5wAKAQf0uc"),
    ("ICD10", "Q75.8", "Q75.8 Other specified congenital malformations of skull and face bones", "bmBCDsI6bah"),
    ("ICD10", "Q75.9", "Q75.9 Congenital malformation of skull and face bones, unspecified", "YZ5jns9EcLF"),
    ("ICD10", "Q76", "Q76 Congenital malformations of spine and bony thorax", "J7CGaXA2D3o"),
    ("ICD10", "Q76.0", "Q76.0 Spina bifida occulta", "DlvYriKJFO9"),
    ("ICD10", "Q76.1", "Q76.1 Klippel-Feil syndrome", "gZJpy0VAaje"),
    ("ICD10", "Q76.2", "Q76.2 Congenital spondylolisthesis", "nyYaqbNxRna"),
    ("ICD10", "Q76.3", "Q76.3 Congenital scoliosis due to congenital bony malformation", "kGqOvIH6r5P"),
    ("ICD10", "Q76.4", "Q76.4 Other congenital malformations of spine, not associated with scoliosis", "NKghh6135Bf"),
    ("ICD10", "Q76.5", "Q76.5 Cervical rib", "kzWx5QONzzO"),
    ("ICD10", "Q76.6", "Q76.6 Other congenital malformations of ribs", "ER8atSflsB3"),
    ("ICD10", "Q76.7", "Q76.7 Congenital malformation of sternum", "sOV1kUilZpm"),
    ("ICD10", "Q76.8", "Q76.8 Other congenital malformations of bony thorax", "HvTA30fqRuX"),
    ("ICD10", "Q76.9", "Q76.9 Congenital malformation of bony thorax, unspecified", "GbsQkISlO9L"),
    ("ICD10", "Q77", "Q77 Osteochondrodysplasia with defects of growth of tubular bones and spine", "aZcX74TtGOt"),
    ("ICD10", "Q77.0", "Q77.0 Achondrogenesis", "BjIlr4AcZoJ"),
    ("ICD10", "Q77.1", "Q77.1 Thanatophoric short stature", "vfIuEsKMVbG"),
    ("ICD10", "Q77.2", "Q77.2 Short rib syndrome", "gytO6lxJ9o5"),
    ("ICD10", "Q77.3", "Q77.3 Chondrodysplasia punctata", "OgUq8UDf6D1"),
    ("ICD10", "Q77.4", "Q77.4 Achondroplasia", "TWxOOzIplUQ"),
    ("ICD10", "Q77.5", "Q77.5 Dystrophic dysplasia", "i4AfrVhZOLk"),
    ("ICD10", "Q77.6", "Q77.6 Chondroectodermal dysplasia", "WIloLjSq77L"),
    ("ICD10", "Q77.7", "Q77.7 Spondyloepiphyseal dysplasia", "hHEUesNvZ9P"),
    ("ICD10", "Q77.8", "Q77.8 Other osteochondrodysplasia with defects of growth of tubular bones and spine", "OvufL7OXkCb"),
    ("ICD10", "Q77.9", "Q77.9 Osteochondrodysplasia with defects of growth of tubular bones and spine, unspecified", "TETciJWnNe6"),
    ("ICD10", "Q78", "Q78 Other osteochondrodysplasias", "AATiUmR1MCy"),
    ("ICD10", "Q78.0", "Q78.0 Osteogenesis imperfecta", "lyjXKLtwMaT"),
    ("ICD10", "Q78.1", "Q78.1 Polyostotic fibrous dysplasia", "TiNVvn6dqdj"),
    ("ICD10", "Q78.2", "Q78.2 Osteopetrosis", "Wwb35O8kJsS"),
    ("ICD10", "Q78.3", "Q78.3 Progressive diaphyseal dysplasia", "zs9zhpn409l"),
    ("ICD10", "Q78.4", "Q78.4 Enchondromatosis", "e8PYslo3oHe"),
    ("ICD10", "Q78.5", "Q78.5 Metaphyseal dysplasia", "BG0bAUE9V48"),
    ("ICD10", "Q78.6", "Q78.6 Multiple congenital exostoses", "Pbxxu3JuSDU"),
    ("ICD10", "Q78.8", "Q78.8 Other specified osteochondrodysplasias", "kIvwOW7Eq5G"),
    ("ICD10", "Q78.9", "Q78.9 Osteochondrodysplasia, unspecified", "BvRrm22ji28"),
    ("ICD10", "Q79", "Q79 Congenital malformations of the musculoskeletal system, not elsewhere classified", "BAUN6vaB3iN"),
    ("ICD10", "Q79.0", "Q79.0 Congenital diaphragmatic hernia", "EMHpT6CbvjQ"),
    ("ICD10", "Q79.1", "Q79.1 Other congenital malformations of diaphragm", "hbwqzQGul3G"),
    ("ICD10", "Q79.2", "Q79.2 Exomphalos", "JZqnOFOA5oA"),
    ("ICD10", "Q79.3", "Q79.3 Gastroschisis", "PYEj1NlTvcu"),
    ("ICD10", "Q79.4", "Q79.4 Prune belly syndrome", "X3qDGpDPFYa"),
    ("ICD10", "Q79.5", "Q79.5 Other congenital malformations of abdominal wall", "P7pRziV5G2Q"),
    ("ICD10", "Q79.6", "Q79.6 Ehlers-Danlos syndrome", "fVP5xVk3gw6"),
    ("ICD10", "Q79.8", "Q79.8 Other congenital malformations of musculoskeletal system", "LoohUR4XUPn"),
    ("ICD10", "Q79.9", "Q79.9 Congenital malformation of musculoskeletal system, unspecified", "a83YMLqbpDA"),
    ("ICD10", "Q80", "Q80 Congenital ichthyosis", "tPOLVirrjDe"),
    ("ICD10", "Q80.0", "Q80.0 Ichthyosis vulgaris", "RL1W5EIZpFF"),
    ("ICD10", "Q80.1", "Q80.1 X-linked ichthyosis", "UHMvND6sSJh"),
    ("ICD10", "Q80.2", "Q80.2 Lamellar ichthyosis", "yO78iDpcgzG"),
    ("ICD10", "Q80.3", "Q80.3 Congenital bullous ichthyosiform erythroderma", "jiuKhaNK6KI"),
    ("ICD10", "Q80.4", "Q80.4 Harlequin fetus", "walrbjbsbCm");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Q80.8", "Q80.8 Other congenital ichthyosis", "J7yYeBqIQSn"),
    ("ICD10", "Q80.9", "Q80.9 Congenital ichthyosis, unspecified", "srDsID0MrEm"),
    ("ICD10", "Q81", "Q81 Epidermolysis bullosa", "zfdQBsc3Lyv"),
    ("ICD10", "Q81.0", "Q81.0 Epidermolysis bullosa simplex", "YBTmxJb87ZE"),
    ("ICD10", "Q81.1", "Q81.1 Epidermolysis bullosa letalis", "feseDTmJ5Y8"),
    ("ICD10", "Q81.2", "Q81.2 Epidermolysis bullosa dystrophica", "brrEowOzfz3"),
    ("ICD10", "Q81.8", "Q81.8 Other epidermolysis bullosa", "sdKLNHcySri"),
    ("ICD10", "Q81.9", "Q81.9 Epidermolysis bullosa, unspecified", "GyGYjoePloK"),
    ("ICD10", "Q82", "Q82 Other congenital malformations of skin", "DdA1vbWtJee"),
    ("ICD10", "Q82.0", "Q82.0 Hereditary lymphoedema", "kGjMSSnyZQD"),
    ("ICD10", "Q82.1", "Q82.1 Xeroderma pigmentosum", "fMjSTreyJV6"),
    ("ICD10", "Q82.2", "Q82.2 Mastocytosis", "o2QBXBdKl1N"),
    ("ICD10", "Q82.3", "Q82.3 Incontinentia pigmenti", "kHoILPCYB3r"),
    ("ICD10", "Q82.4", "Q82.4 Ectodermal dysplasia (anhidrotic)", "b6wLMHL40Ft"),
    ("ICD10", "Q82.5", "Q82.5 Congenital non-neoplastic naevus", "bSBvXlhKONs"),
    ("ICD10", "Q82.8", "Q82.8 Other specified congenital malformations of skin", "EWu54aj0v6Z"),
    ("ICD10", "Q82.9", "Q82.9 Congenital malformation of skin, unspecified", "RxuH0ykt1rP"),
    ("ICD10", "Q83", "Q83 Congenital malformations of breast", "uZRFyyaPBPW"),
    ("ICD10", "Q83.0", "Q83.0 Congenital absence of breast with absent nipple", "ptc2M7WYWf6"),
    ("ICD10", "Q83.1", "Q83.1 Accessory breast", "LJqnNFoN2z7"),
    ("ICD10", "Q83.2", "Q83.2 Absent nipple", "Tx3tPOJ6wCY"),
    ("ICD10", "Q83.3", "Q83.3 Accessory nipple", "KV8D6fMTeOy"),
    ("ICD10", "Q83.8", "Q83.8 Other congenital malformations of breast", "ZgF5OVY3kM8"),
    ("ICD10", "Q83.9", "Q83.9 Congenital malformation of breast, unspecified", "U5wznhxe241"),
    ("ICD10", "Q84", "Q84 Other congenital malformations of integument", "llZcaqDJLLq"),
    ("ICD10", "Q84.0", "Q84.0 Congenital alopecia", "TI9PuHVX9If"),
    ("ICD10", "Q84.1", "Q84.1 Congenital morphological disturbances of hair, not elsewhere classified", "hwWoRndOaQF"),
    ("ICD10", "Q84.2", "Q84.2 Other congenital malformations of hair", "AYCRzqml6Xc"),
    ("ICD10", "Q84.3", "Q84.3 Anonychia", "Ra7Axs2VbSu"),
    ("ICD10", "Q84.4", "Q84.4 Congenital leukonychia", "QDiI3TReCwI"),
    ("ICD10", "Q84.5", "Q84.5 Enlarged and hypertrophic nails", "w9s5qJtpIJ2"),
    ("ICD10", "Q84.6", "Q84.6 Other congenital malformations of nails", "SWBSYfbi6Au"),
    ("ICD10", "Q84.8", "Q84.8 Other specified congenital malformations of integument", "SLS3xzdeAij"),
    ("ICD10", "Q84.9", "Q84.9 Congenital malformation of integument, unspecified", "oHa7XC2iT9F"),
    ("ICD10", "Q85", "Q85 Phakomatoses, not elsewhere classified", "SSwLBLHyjX1"),
    ("ICD10", "Q85.0", "Q85.0 Neurofibromatosis (nonmalignant)", "G3PGSztrIeT"),
    ("ICD10", "Q85.1", "Q85.1 Tuberous sclerosis", "wqSYb3qGI8B"),
    ("ICD10", "Q85.8", "Q85.8 Other phakomatoses, not elsewhere classified", "K1YczptHuDU"),
    ("ICD10", "Q85.9", "Q85.9 Phakomatosis, unspecified", "X6Yk4e2bcHp"),
    ("ICD10", "Q86", "Q86 Congenital malformation syndromes due to known exogenous causes, not elsewhere classified", "ALZAjlHcJjT"),
    ("ICD10", "Q86.0", "Q86.0 Fetal alcohol syndrome (dysmorphic)", "eZzLio4X0OS"),
    ("ICD10", "Q86.1", "Q86.1 Fetal hydantoin syndrome", "JmPBrFL7OQg"),
    ("ICD10", "Q86.2", "Q86.2 Dysmorphism due to warfarin", "TcWT0mNj0RM"),
    ("ICD10", "Q86.8", "Q86.8 Other congenital malformation syndromes due to known exogenous causes", "a3doXfgaLFe"),
    ("ICD10", "Q87", "Q87 Other specified congenital malformation syndromes affecting multiple systems", "hDOp2wJxKpf"),
    ("ICD10", "Q87.0", "Q87.0 Congenital malformation syndromes predominantly affecting facial appearance", "DducWxLt4bd"),
    ("ICD10", "Q87.1", "Q87.1 Congenital malformation syndromes predominantly associated with short stature", "XUhAvLr0Yxu"),
    ("ICD10", "Q87.2", "Q87.2 Congenital malformation syndromes predominantly involving limbs", "o6xdW4Vse21"),
    ("ICD10", "Q87.3", "Q87.3 Congenital malformation syndromes involving early overgrowth", "HqSlxWu0ijS"),
    ("ICD10", "Q87.4", "Q87.4 Marfan syndrome", "lBIkgcLydUb"),
    ("ICD10", "Q87.5", "Q87.5 Other congenital malformation syndromes with other skeletal changes", "haK0PPeasLM"),
    ("ICD10", "Q87.8", "Q87.8 Other specified congenital malformation syndromes, not elsewhere classified", "ZE7DNlvZLAm"),
    ("ICD10", "Q89", "Q89 Other congenital malformations, not elsewhere classified", "LNGnp7wNrcO"),
    ("ICD10", "Q89.0", "Q89.0 Congenital malformations of spleen", "moRu7GpZ931"),
    ("ICD10", "Q89.1", "Q89.1 Congenital malformations of adrenal gland", "mubR905z2Bs"),
    ("ICD10", "Q89.2", "Q89.2 Congenital malformations of other endocrine glands", "ZCleSd91zw5"),
    ("ICD10", "Q89.3", "Q89.3 Situs inversus", "GHSUJRQFTG4"),
    ("ICD10", "Q89.4", "Q89.4 Conjoined twins", "DUOVL4V5UHD"),
    ("ICD10", "Q89.7", "Q89.7 Multiple congenital malformations, not elsewhere classified", "HZIxu0ItUNS"),
    ("ICD10", "Q89.8", "Q89.8 Other specified congenital malformations", "gBO75eKzQlN"),
    ("ICD10", "Q89.9", "Q89.9 Congenital malformation, unspecified", "bXHIq64igPG"),
    ("ICD10", "Q90", "Q90 Down syndrome", "CHZdZadeliv"),
    ("ICD10", "Q90.0", "Q90.0 Trisomy 21, meiotic nondisjunction", "zecdYVptEbu"),
    ("ICD10", "Q90.1", "Q90.1 Trisomy 21, mosaicism (mitotic nondisjunction)", "ItZXXBYhQc3"),
    ("ICD10", "Q90.2", "Q90.2 Trisomy 21, translocation", "Pr5m813HbAN"),
    ("ICD10", "Q90.9", "Q90.9 Down syndrome, unspecified", "dyBCSunsc9b"),
    ("ICD10", "Q91", "Q91 Edwards syndrome and Patau syndrome", "wE14vfb8vd7"),
    ("ICD10", "Q91.0", "Q91.0 Trisomy 18, meiotic nondisjunction", "lPRDRMLLVmz"),
    ("ICD10", "Q91.1", "Q91.1 Trisomy 18, mosaicism (mitotic nondisjunction)", "TnipwGgRtBg"),
    ("ICD10", "Q91.2", "Q91.2 Trisomy 18, translocation", "r45GH5DMA4Z"),
    ("ICD10", "Q91.3", "Q91.3 Edwards syndrome, unspecified", "bH3xLRDwa1C"),
    ("ICD10", "Q91.4", "Q91.4 Trisomy 13, meiotic nondisjunction", "qo3kEgosfG6"),
    ("ICD10", "Q91.5", "Q91.5 Trisomy 13, mosaicism (mitotic nondisjunction)", "pHaXdR1yimj"),
    ("ICD10", "Q91.6", "Q91.6 Trisomy 13, translocation", "HQHgHzTAJVN"),
    ("ICD10", "Q91.7", "Q91.7 Patau syndrome, unspecified", "y6CyloUZuJ8"),
    ("ICD10", "Q92", "Q92 Other trisomies and partial trisomies of the autosomes, not elsewhere classified", "vk4Vzfd64u3"),
    ("ICD10", "Q92.0", "Q92.0 Whole chromosome trisomy, meiotic nondisjunction", "COqkIM9DmQH"),
    ("ICD10", "Q92.1", "Q92.1 Whole chromosome trisomy, mosaicism (mitotic nondisjunction)", "cVQshzTCfRC"),
    ("ICD10", "Q92.2", "Q92.2 Major partial trisomy", "FSDSiii4A9M"),
    ("ICD10", "Q92.3", "Q92.3 Minor partial trisomy", "fS9b9Gzls0R"),
    ("ICD10", "Q92.4", "Q92.4 Duplications seen only at prometaphase", "mS8tQAlyKt4"),
    ("ICD10", "Q92.5", "Q92.5 Duplications with other complex rearrangements", "ibS0uH1Skun"),
    ("ICD10", "Q92.6", "Q92.6 Extra marker chromosomes", "D6GnozfwWPQ"),
    ("ICD10", "Q92.7", "Q92.7 Triploidy and polyploidy", "W3RpEt7qtrD"),
    ("ICD10", "Q92.8", "Q92.8 Other specified trisomies and partial trisomies of autosomes", "txLOhcZsVrU"),
    ("ICD10", "Q92.9", "Q92.9 Trisomy and partial trisomy of autosomes, unspecified", "HC3SZkXI5XA"),
    ("ICD10", "Q93", "Q93 Monosomies and deletions from the autosomes, not elsewhere classified", "e5XTIpGuubc"),
    ("ICD10", "Q93.0", "Q93.0 Whole chromosome monosomy, meiotic nondisjunction", "Yju3ztuuWu2"),
    ("ICD10", "Q93.1", "Q93.1 Whole chromosome monosomy, mosaicism (mitotic nondisjunction)", "ZbXZKtaKD5J"),
    ("ICD10", "Q93.2", "Q93.2 Chromosome replaced with ring or dicentric", "PpljoTCpvo8"),
    ("ICD10", "Q93.3", "Q93.3 Deletion of short arm of chromosome 4", "PuVlFw0bl46"),
    ("ICD10", "Q93.4", "Q93.4 Deletion of short arm of chromosome 5", "LyrBbxpHdg3"),
    ("ICD10", "Q93.5", "Q93.5 Other deletions of part of a chromosome", "y4ggieKLsyg"),
    ("ICD10", "Q93.6", "Q93.6 Deletions seen only at prometaphase", "mE1n2OLiWsD"),
    ("ICD10", "Q93.7", "Q93.7 Deletions with other complex rearrangements", "efqF1iUCCxq"),
    ("ICD10", "Q93.8", "Q93.8 Other deletions from the autosomes", "CYzbYkHzVv1"),
    ("ICD10", "Q93.9", "Q93.9 Deletion from autosomes, unspecified", "TA412s3kZhB"),
    ("ICD10", "Q95", "Q95 Balanced rearrangements and structural markers, not elsewhere classified", "ggYqL6oLnBS"),
    ("ICD10", "Q95.0", "Q95.0 Balanced translocation and insertion in normal individual", "ofwzhlxseTF"),
    ("ICD10", "Q95.1", "Q95.1 Chromosome inversion in normal individual", "HcOPuFrg2mf"),
    ("ICD10", "Q95.2", "Q95.2 Balanced autosomal rearrangement in abnormal individual", "aFX79m1zEwZ"),
    ("ICD10", "Q95.3", "Q95.3 Balanced sex/autosomal rearrangement in abnormal individual", "CkSjj6eb4wr"),
    ("ICD10", "Q95.4", "Q95.4 Individuals with marker heterochromatin", "tcHFBmcp3hu"),
    ("ICD10", "Q95.5", "Q95.5 Individuals with autosomal fragile site", "ZU5ZLExPROO"),
    ("ICD10", "Q95.8", "Q95.8 Other balanced rearrangements and structural markers", "UrqyiPq6E2v"),
    ("ICD10", "Q95.9", "Q95.9 Balanced rearrangement and structural marker, unspecified", "Jkawr6oATre"),
    ("ICD10", "Q96", "Q96 Turner syndrome", "OOVp8xO4Em3"),
    ("ICD10", "Q96.0", "Q96.0 Karyotype 45, X", "SJ08LNGe9ph"),
    ("ICD10", "Q96.1", "Q96.1 Karyotype 46, X iso (Xq)", "aH4xxRCdEXw"),
    ("ICD10", "Q96.2", "Q96.2 Karyotype 46, X with abnormal sex chromosome, except iso (Xq)", "GOtrNGLtuIc"),
    ("ICD10", "Q96.3", "Q96.3 Mosaicism, 45, X/46, XX or XY", "cRMJyEwVFxh"),
    ("ICD10", "Q96.4", "Q96.4 Mosaicism, 45, X/other cell line(s) with abnormal sex chromosome", "LA3ISGVxk7z"),
    ("ICD10", "Q96.8", "Q96.8 Other variants of Turner syndrome", "CGp2mGzpLuc"),
    ("ICD10", "Q96.9", "Q96.9 Turner syndrome, unspecified", "eOEmxQqTJSa"),
    ("ICD10", "Q97", "Q97 Other sex chromosome abnormalities, female phenotype, not elsewhere classified", "jSMziH30Ehs"),
    ("ICD10", "Q97.0", "Q97.0 Karyotype 47, XXX", "Xr840IdWN1p"),
    ("ICD10", "Q97.1", "Q97.1 Female with more than three X chromosomes", "i7hdOvSw6gH"),
    ("ICD10", "Q97.2", "Q97.2 Mosaicism, lines with various numbers of X chromosomes", "hhTJRLG6YBv"),
    ("ICD10", "Q97.3", "Q97.3 Female with 46, XY karyotype", "yX92jQj7YaB"),
    ("ICD10", "Q97.8", "Q97.8 Other specified sex chromosome abnormalities, female phenotype", "TDSc8uF0Jjk"),
    ("ICD10", "Q97.9", "Q97.9 Sex chromosome abnormality, female phenotype, unspecified", "nTGKB0b7Mfa"),
    ("ICD10", "Q98", "Q98 Other sex chromosome abnormalities, male phenotype, not elsewhere classified", "UpsQqkPDN2P"),
    ("ICD10", "Q98.0", "Q98.0 Klinefelter syndrome karyotype 47, XXY", "vHWYDoppmmr"),
    ("ICD10", "Q98.1", "Q98.1 Klinefelter syndrome, male with more than two X chromosomes", "pCXum3rc99m"),
    ("ICD10", "Q98.2", "Q98.2 Klinefelter syndrome, male with 46, XX karyotype", "X26Y39HYCvK"),
    ("ICD10", "Q98.3", "Q98.3 Other male with 46, XX karyotype", "Jm49DyF1zvV"),
    ("ICD10", "Q98.4", "Q98.4 Klinefelter syndrome, unspecified", "uxZbzwDtuSl"),
    ("ICD10", "Q98.5", "Q98.5 Karyotype 47, XYY", "E8Wgl2SeHkI"),
    ("ICD10", "Q98.6", "Q98.6 Male with structurally abnormal sex chromosome", "KVAHdPBypzV"),
    ("ICD10", "Q98.7", "Q98.7 Male with sex chromosome mosaicism", "Y0tuuWOm2hR"),
    ("ICD10", "Q98.8", "Q98.8 Other specified sex chromosome abnormalities, male phenotype", "CGz33sHde9l"),
    ("ICD10", "Q98.9", "Q98.9 Sex chromosome abnormality, male phenotype, unspecified", "GSX2KEb9dOQ"),
    ("ICD10", "Q99", "Q99 Other chromosome abnormalities, not elsewhere classified", "OgrOrVTFX6N"),
    ("ICD10", "Q99.0", "Q99.0 Chimera 46, XX/46, XY", "xMgfibNy7ZP"),
    ("ICD10", "Q99.1", "Q99.1 46, XX true hermaphrodite", "xcX2bl9FhlM"),
    ("ICD10", "Q99.2", "Q99.2 Fragile X chromosome", "E9koDuWG75h"),
    ("ICD10", "Q99.8", "Q99.8 Other specified chromosome abnormalities", "NU533vkMGGu"),
    ("ICD10", "Q99.9", "Q99.9 Chromosomal abnormality, unspecified", "lYYpkBTAVu0");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "R00", "R00 Abnormalities of heart beat", "xtQFZNJ9Vwr"),
    ("ICD10", "R00.0", "R00.0 Tachycardia, unspecified", "B1clmSVbCgz"),
    ("ICD10", "R00.1", "R00.1 Bradycardia, unspecified", "WCgZmizBJ9a"),
    ("ICD10", "R00.2", "R00.2 Palpitations", "pfeI0W56zMn"),
    ("ICD10", "R00.8", "R00.8 Other and unspecified abnormalities of heart beat", "fuh0v1FMJSf"),
    ("ICD10", "R01", "R01 Cardiac murmurs and other cardiac sounds", "d4Ns5DUo3mo"),
    ("ICD10", "R01.0", "R01.0 Benign and innocent cardiac murmurs", "hcqBd7SlEu8"),
    ("ICD10", "R01.1", "R01.1 Cardiac murmur, unspecified", "R8p0LD2RCQm"),
    ("ICD10", "R01.2", "R01.2 Other cardiac sounds", "R6QYwQ96Pzw"),
    ("ICD10", "R02", "R02 Gangrene, not elsewhere classified", "Pu3kcLPCrj5"),
    ("ICD10", "R03", "R03 Abnormal blood-pressure reading, without diagnosis", "iRHGq9MFlde"),
    ("ICD10", "R03.0", "R03.0 Elevated blood-pressure reading, without diagnosis of hypertension", "mXp5XbbMcVn"),
    ("ICD10", "R03.1", "R03.1 Nonspecific low blood-pressure reading", "z0ectmycZvr"),
    ("ICD10", "R04", "R04 Haemorrhage from respiratory passages", "N6MH7RaC0Ls"),
    ("ICD10", "R04.0", "R04.0 Epistaxis", "CDpxPIX0F3c"),
    ("ICD10", "R04.1", "R04.1 Haemorrhage from throat", "mBRkLXZUFlk"),
    ("ICD10", "R04.2", "R04.2 Haemoptysis", "MmCG16WbwVE"),
    ("ICD10", "R04.8", "R04.8 Haemorrhage from other sites in respiratory passages", "uh129hC4ltq"),
    ("ICD10", "R04.9", "R04.9 Haemorrhage from respiratory passages, unspecified", "dOw04ltjpAJ"),
    ("ICD10", "R05", "R05 Cough", "aJTEUWqbNM1"),
    ("ICD10", "R06", "R06 Abnormalities of breathing", "FrsCFl1CrrN"),
    ("ICD10", "R06.0", "R06.0 Dyspnoea", "aukXu1jL50O"),
    ("ICD10", "R06.1", "R06.1 Stridor", "zNUCh541RzC"),
    ("ICD10", "R06.2", "R06.2 Wheezing", "JyyLN0zPpXD"),
    ("ICD10", "R06.3", "R06.3 Periodic breathing", "pNOjFi7Gln8"),
    ("ICD10", "R06.4", "R06.4 Hyperventilation", "tITocIEjfhf"),
    ("ICD10", "R06.5", "R06.5 Mouth breathing", "YY3LB29mAJw"),
    ("ICD10", "R06.6", "R06.6 Hiccough", "FIavJa5E01v"),
    ("ICD10", "R06.7", "R06.7 Sneezing", "aOvF5NpV1HW"),
    ("ICD10", "R06.8", "R06.8 Other and unspecified abnormalities of breathing", "NcHxabNeDYb"),
    ("ICD10", "R07", "R07 Pain in throat and chest", "FIXHvHmvv0S"),
    ("ICD10", "R07.0", "R07.0 Pain in throat", "l1IvkMDcJRz"),
    ("ICD10", "R07.1", "R07.1 Chest pain on breathing", "jDoEaAuZ6hO"),
    ("ICD10", "R07.2", "R07.2 Precordial pain", "C9PnJH5kjd8"),
    ("ICD10", "R07.3", "R07.3 Other chest pain", "xS6CyXlIFrM"),
    ("ICD10", "R07.4", "R07.4 Chest pain, unspecified", "hfujO8F1pEd"),
    ("ICD10", "R09", "R09 Other symptoms and signs involving the circulatory and respiratory systems", "B5ytwwfKX0O"),
    ("ICD10", "R09.0", "R09.0 Asphyxia", "ECMDvrWMrpi"),
    ("ICD10", "R09.1", "R09.1 Pleurisy", "PpvwL8GIUGB"),
    ("ICD10", "R09.2", "R09.2 Respiratory arrest", "jrde7KlDXHT"),
    ("ICD10", "R09.3", "R09.3 Abnormal sputum", "ZmgVdrzJ7of"),
    ("ICD10", "R09.8", "R09.8 Other specified symptoms and signs involving the circulatory and respiratory systems", "TCj3HEcvfR3"),
    ("ICD10", "R10", "R10 Abdominal and pelvic pain", "Acwyi8ZR4y9"),
    ("ICD10", "R10.0", "R10.0 Acute abdomen", "bgSBaKlDISq"),
    ("ICD10", "R10.1", "R10.1 Pain localized to upper abdomen", "s7WF2kmf7Iq"),
    ("ICD10", "R10.2", "R10.2 Pelvic and perineal pain", "Gfj9Nm7XUMU"),
    ("ICD10", "R10.3", "R10.3 Pain localized to other parts of lower abdomen", "NNzFfAjBudG"),
    ("ICD10", "R10.4", "R10.4 Other and unspecified abdominal pain", "NXNx8gwfliQ"),
    ("ICD10", "R11", "R11 Nausea and vomiting", "d9IyVVrH0S0"),
    ("ICD10", "R12", "R12 Heartburn", "nnQs4V94SU5"),
    ("ICD10", "R13", "R13 Dysphagia", "L28mAbdf1JD"),
    ("ICD10", "R14", "R14 Flatulence and related conditions", "fCtieMq2041"),
    ("ICD10", "R15", "R15 Faecal incontinence", "fBCqCeSTlHl"),
    ("ICD10", "R16", "R16 Hepatomegaly and splenomegaly, not elsewhere classified", "ZBCrRo09LZw"),
    ("ICD10", "R16.0", "R16.0 Hepatomegaly, not elsewhere classified", "rjBZZo7XUvo"),
    ("ICD10", "R16.1", "R16.1 Splenomegaly, not elsewhere classified", "b8f6tcuWgSS"),
    ("ICD10", "R16.2", "R16.2 Hepatomegaly with splenomegaly, not elsewhere classified", "S7RUtKoW5UR"),
    ("ICD10", "R17", "R17 Unspecified jaundice", "CWzAq8aBBgx"),
    ("ICD10", "R18", "R18 Ascites", "PuEjfj5vWZN"),
    ("ICD10", "R19", "R19 Other symptoms and signs involving the digestive system and abdomen", "m57Vc5xj9N9"),
    ("ICD10", "R19.0", "R19.0 Intra-abdominal and pelvic swelling, mass and lump", "NBfQSLX5MLQ"),
    ("ICD10", "R19.1", "R19.1 Abnormal bowel sounds", "bvt7lQMHfDU"),
    ("ICD10", "R19.2", "R19.2 Visible peristalsis", "Lk10SwM6ez7"),
    ("ICD10", "R19.3", "R19.3 Abdominal rigidity", "mUVDtApmdzA"),
    ("ICD10", "R19.4", "R19.4 Change in bowel habit", "MB3S4xLvHNO"),
    ("ICD10", "R19.5", "R19.5 Other faecal abnormalities", "cyyyiVzRwKg"),
    ("ICD10", "R19.6", "R19.6 Halitosis", "swmIG9CCKvt"),
    ("ICD10", "R19.8", "R19.8 Other specified symptoms and signs involving the digestive system and abdomen", "mHGLHpgFXwY"),
    ("ICD10", "R20", "R20 Disturbances of skin sensation", "ZDmtimM61HL"),
    ("ICD10", "R20.0", "R20.0 Anaesthesia of skin", "sntSMVn8A6l"),
    ("ICD10", "R20.1", "R20.1 Hypoaesthesia of skin", "OZmESi41t5V"),
    ("ICD10", "R20.2", "R20.2 Paraesthesia of skin", "tVaasj8ZILk"),
    ("ICD10", "R20.3", "R20.3 Hyperaesthesia", "lfEZyuoqd0Z"),
    ("ICD10", "R20.8", "R20.8 Other and unspecified disturbances of skin sensation", "FbgOuzvwBHt"),
    ("ICD10", "R21", "R21 Rash and other nonspecific skin eruption", "Apy4SnlFjlS"),
    ("ICD10", "R22", "R22 Localized swelling, mass and lump of skin and subcutaneous tissue", "VjvBMZcvv8y"),
    ("ICD10", "R22.0", "R22.0 Localized swelling, mass and lump, head", "fTesBuzeZIH"),
    ("ICD10", "R22.1", "R22.1 Localized swelling, mass and lump, neck", "ZieeNTl3UPQ"),
    ("ICD10", "R22.2", "R22.2 Localized swelling, mass and lump, trunk", "YVtNa8POSPn"),
    ("ICD10", "R22.3", "R22.3 Localized swelling, mass and lump, upper limb", "XhWpBn1Nu7k"),
    ("ICD10", "R22.4", "R22.4 Localized swelling, mass and lump, lower limb", "mPdX4Ii4Fqi"),
    ("ICD10", "R22.7", "R22.7 Localized swelling, mass and lump, multiple sites", "RoUnUKot8fV"),
    ("ICD10", "R22.9", "R22.9 Localized swelling, mass and lump, unspecified", "J0qz3UvzxFm"),
    ("ICD10", "R23", "R23 Other skin changes", "nMxEdVipeGI"),
    ("ICD10", "R23.0", "R23.0 Cyanosis", "UuWwJMb9uCb"),
    ("ICD10", "R23.1", "R23.1 Pallor", "jONBu9W3S2V"),
    ("ICD10", "R23.2", "R23.2 Flushing", "n83McMG8FBP"),
    ("ICD10", "R23.3", "R23.3 Spontaneous ecchymoses", "cRCAOQ8vDVW"),
    ("ICD10", "R23.4", "R23.4 Changes in skin texture", "wwFift16o6f"),
    ("ICD10", "R23.8", "R23.8 Other and unspecified skin changes", "RwtjDbIdC7Z"),
    ("ICD10", "R25", "R25 Abnormal involuntary movements", "AR3SkMPwfUV"),
    ("ICD10", "R25.0", "R25.0 Abnormal head movements", "kegn6j0TtK0"),
    ("ICD10", "R25.1", "R25.1 Tremor, unspecified", "Cw6ao7uOJiM"),
    ("ICD10", "R25.2", "R25.2 Cramp and spasm", "XTp2yDlrru2"),
    ("ICD10", "R25.3", "R25.3 Fasciculation", "OX02Z2vbabC"),
    ("ICD10", "R25.8", "R25.8 Other and unspecified abnormal involuntary movements", "D5x8ipXDigl"),
    ("ICD10", "R26", "R26 Abnormalities of gait and mobility", "LK5PVEvkD9S"),
    ("ICD10", "R26.0", "R26.0 Ataxic gait", "BDby2AH2UJo"),
    ("ICD10", "R26.1", "R26.1 Paralytic gait", "mh9PaINRCmM"),
    ("ICD10", "R26.2", "R26.2 Difficulty in walking, not elsewhere classified", "ifzY3eDHVT3"),
    ("ICD10", "R26.3", "R26.3 Immobility", "oiYdByzSxVt"),
    ("ICD10", "R26.8", "R26.8 Other and unspecified abnormalities of gait and mobility", "Wx5meVGJT37"),
    ("ICD10", "R27", "R27 Other lack of coordination", "y9UCzBJ9bX2"),
    ("ICD10", "R27.0", "R27.0 Ataxia, unspecified", "fGlAgFeKEBU"),
    ("ICD10", "R27.8", "R27.8 Other and unspecified lack of coordination", "wCwTftP92Xr"),
    ("ICD10", "R29", "R29 Other symptoms and signs involving the nervous and musculoskeletal systems", "kmNg5i3Wqfg"),
    ("ICD10", "R29.0", "R29.0 Tetany", "nRjcnjwqor6"),
    ("ICD10", "R29.1", "R29.1 Meningismus", "cacXAW5cj1C"),
    ("ICD10", "R29.2", "R29.2 Abnormal reflex", "lywsTUG5rpf"),
    ("ICD10", "R29.3", "R29.3 Abnormal posture", "SW4BjXTZdnK"),
    ("ICD10", "R29.4", "R29.4 Clicking hip", "qrojyty3zwl"),
    ("ICD10", "R29.6", "R29.6 Tendency to fall, not elsewhere classified", "ulvNbW9TjEk"),
    ("ICD10", "R29.8", "R29.8 Other and unspecified symptoms and signs involving the nervous and musculoskeletal systems", "Vot2v20EVQ1"),
    ("ICD10", "R30", "R30 Pain associated with micturition", "qsLee0duBqv"),
    ("ICD10", "R30.0", "R30.0 Dysuria", "AMUBcjzufl7"),
    ("ICD10", "R30.1", "R30.1 Vesical tenesmus", "AiT9qAYOaUg"),
    ("ICD10", "R30.9", "R30.9 Painful micturition, unspecified", "J2pbd1PZLAf"),
    ("ICD10", "R31", "R31 Unspecified haematuria", "PfEzMhstwjR"),
    ("ICD10", "R32", "R32 Unspecified urinary incontinence", "RCUqM8XETbi"),
    ("ICD10", "R33", "R33 Retention of urine", "JPS0do11nyF"),
    ("ICD10", "R34", "R34 Anuria and oliguria", "QOtwRrOADKF"),
    ("ICD10", "R35", "R35 Polyuria", "XfaSnZ7Zlym"),
    ("ICD10", "R36", "R36 Urethral discharge", "xw7P2euYCbx"),
    ("ICD10", "R39", "R39 Other symptoms and signs involving the urinary system", "FmnStwbRAU5"),
    ("ICD10", "R39.0", "R39.0 Extravasation of urine", "HY8vUsjLbOr"),
    ("ICD10", "R39.1", "R39.1 Other difficulties with micturition", "wtXni4JGS0b"),
    ("ICD10", "R39.2", "R39.2 Extrarenal uraemia", "bpeV2zXH48f"),
    ("ICD10", "R39.8", "R39.8 Other and unspecified symptoms and signs involving the urinary system", "QW3e4zsthAC"),
    ("ICD10", "R40", "R40 Somnolence, stupor and coma", "gC80dTwbnTm"),
    ("ICD10", "R40.0", "R40.0 Somnolence", "wfeOwRQxQBS"),
    ("ICD10", "R40.1", "R40.1 Stupor", "LbEgm9F0e5w"),
    ("ICD10", "R40.2", "R40.2 Coma, unspecified", "RdvrHZykGQd"),
    ("ICD10", "R41", "R41 Other symptoms and signs involving cognitive functions and awareness", "d9YfGLNIe1P"),
    ("ICD10", "R41.0", "R41.0 Disorientation, unspecified", "dYikzIrtJvg"),
    ("ICD10", "R41.1", "R41.1 Anterograde amnesia", "H2B0wqwpD9Y"),
    ("ICD10", "R41.2", "R41.2 Retrograde amnesia", "Kz34OilRKWR"),
    ("ICD10", "R41.3", "R41.3 Other amnesia", "wq1kSdUv2dT"),
    ("ICD10", "R41.8", "R41.8 Other and unspecified symptoms and signs involving cognitive functions and awareness", "h1oFqYs0BeT"),
    ("ICD10", "R42", "R42 Dizziness and giddiness", "e0FspUAIZWY"),
    ("ICD10", "R43", "R43 Disturbances of smell and taste", "pE42oN93c1Y"),
    ("ICD10", "R43.0", "R43.0 Anosmia", "ncF8D5wFHGY"),
    ("ICD10", "R43.1", "R43.1 Parosmia", "dWeGAeGWunk"),
    ("ICD10", "R43.2", "R43.2 Parageusia", "UBv7wcb34MP"),
    ("ICD10", "R43.8", "R43.8 Other and unspecified disturbances of smell and taste", "eQvNPLHIbGK"),
    ("ICD10", "R44", "R44 Other symptoms and signs involving general sensations and perceptions", "Q0oviWA3D6a"),
    ("ICD10", "R44.0", "R44.0 Auditory hallucinations", "vnwsP1LOnaD"),
    ("ICD10", "R44.1", "R44.1 Visual hallucinations", "RYfaiuJ0oft"),
    ("ICD10", "R44.2", "R44.2 Other hallucinations", "Yqg6gGKCtIH"),
    ("ICD10", "R44.3", "R44.3 Hallucinations, unspecified", "BjiOZmQHNTy"),
    ("ICD10", "R44.8", "R44.8 Other and unspecified symptoms and signs involving general sensations and perceptions", "VLVp3dSiC1i"),
    ("ICD10", "R45", "R45 Symptoms and signs involving emotional state", "tELba2AVPNA"),
    ("ICD10", "R45.0", "R45.0 Nervousness", "sLefDvsDr5H"),
    ("ICD10", "R45.1", "R45.1 Restlessness and agitation", "yEAcprQh2EI"),
    ("ICD10", "R45.2", "R45.2 Unhappiness", "vGdECI9GI6Z"),
    ("ICD10", "R45.3", "R45.3 Demoralization and apathy", "hth4fa9IalE"),
    ("ICD10", "R45.4", "R45.4 Irritability and anger", "CaWP4hSSKaz"),
    ("ICD10", "R45.5", "R45.5 Hostility", "VmURSCAR5Ig"),
    ("ICD10", "R45.6", "R45.6 Physical violence", "XjNai4rkfAH"),
    ("ICD10", "R45.7", "R45.7 State of emotional shock and stress, unspecified", "ISYIU5lVQrh"),
    ("ICD10", "R45.8", "R45.8 Other symptoms and signs involving emotional state", "JM5pJgQPMLW"),
    ("ICD10", "R46", "R46 Symptoms and signs involving appearance and behaviour", "n3YAVz13dz4"),
    ("ICD10", "R46.0", "R46.0 Very low level of personal hygiene", "U92db1vMsaI"),
    ("ICD10", "R46.1", "R46.1 Bizarre personal appearance", "WrkszEI2lV5"),
    ("ICD10", "R46.2", "R46.2 Strange and inexplicable behaviour", "dRor4xpt5tz"),
    ("ICD10", "R46.3", "R46.3 Overactivity", "XiWboZMlLFz"),
    ("ICD10", "R46.4", "R46.4 Slowness and poor responsiveness", "tFgqOWqOXmg"),
    ("ICD10", "R46.5", "R46.5 Suspiciousness and marked evasiveness", "dmQAxk5TpR1"),
    ("ICD10", "R46.6", "R46.6 Undue concern and preoccupation with stressful events", "hYZM43gdgQb"),
    ("ICD10", "R46.7", "R46.7 Verbosity and circumstantial detail obscuring reason for contact", "LrF4gWCUcC7"),
    ("ICD10", "R46.8", "R46.8 Other symptoms and signs involving appearance and behaviour", "vD6uA7XWdOb"),
    ("ICD10", "R47", "R47 Speech disturbances, not elsewhere classified", "HdG8aHVpts3"),
    ("ICD10", "R47.0", "R47.0 Dysphasia and aphasia", "snyyA6fiVil"),
    ("ICD10", "R47.1", "R47.1 Dysarthria and anarthria", "tUmOQ4KBHXV"),
    ("ICD10", "R47.8", "R47.8 Other and unspecified speech disturbances", "BKDdGWlEnBH"),
    ("ICD10", "R48", "R48 Dyslexia and other symbolic dysfunctions, not elsewhere classified", "QaDPvQZCpjF"),
    ("ICD10", "R48.0", "R48.0 Dyslexia and alexia", "g1FiZsDcWEZ"),
    ("ICD10", "R48.1", "R48.1 Agnosia", "KzPaukNmjSD"),
    ("ICD10", "R48.2", "R48.2 Apraxia", "rzw8jzBEtzD"),
    ("ICD10", "R48.8", "R48.8 Other and unspecified symbolic dysfunctions", "zwFeI8Dcq7K"),
    ("ICD10", "R49", "R49 Voice disturbances", "la9zjcYhbSh"),
    ("ICD10", "R49.0", "R49.0 Dysphonia", "ZwidL8x7Y3q"),
    ("ICD10", "R49.1", "R49.1 Aphonia", "j3dhYpspwJH"),
    ("ICD10", "R49.2", "R49.2 Hypernasality and hyponasality", "emLrtKaLyVi"),
    ("ICD10", "R49.8", "R49.8 Other and unspecified voice disturbances", "E58BMH2ROSJ"),
    ("ICD10", "R50", "R50 Fever of other and unknown origin", "sclauPwr9fE"),
    ("ICD10", "R50.2", "R50.2 Drug-induced fever", "g4aRseWeDAn"),
    ("ICD10", "R50.8", "R50.8 Other specified fever", "xHygJ2y14ZJ"),
    ("ICD10", "R50.9", "R50.9 Fever, unspecified", "GvQTClQgw4q"),
    ("ICD10", "R51", "R51 Headache", "Cp7j3tQzHHB"),
    ("ICD10", "R52", "R52 Pain, not elsewhere classified", "JbLGSDnjLC4"),
    ("ICD10", "R52.0", "R52.0 Acute pain", "BaZ2y1Msk05"),
    ("ICD10", "R52.1", "R52.1 Chronic intractable pain", "do1gGNTSIqY"),
    ("ICD10", "R52.2", "R52.2 Other chronic pain", "WM5xcTQJayN"),
    ("ICD10", "R52.9", "R52.9 Pain, unspecified", "wSsUbcjofQF"),
    ("ICD10", "R53", "R53 Malaise and fatigue", "ovx5xMTl1TK"),
    ("ICD10", "R54", "R54 Senility", "GecpgGBHO1l"),
    ("ICD10", "R55", "R55 Syncope and collapse", "I7kjhoVnPHV"),
    ("ICD10", "R56", "R56 Convulsions, not elsewhere classified", "QZwoaeia1Vl"),
    ("ICD10", "R56.0", "R56.0 Febrile convulsions", "HpwmnaSgHXn"),
    ("ICD10", "R56.8", "R56.8 Other and unspecified convulsions", "wEnwlbXDKVy"),
    ("ICD10", "R57", "R57 Shock, not elsewhere classified", "h2Z4ndeJyLR"),
    ("ICD10", "R57.0", "R57.0 Cardiogenic shock", "CjyPYHhYWZ8"),
    ("ICD10", "R57.1", "R57.1 Hypovolaemic shock", "uZx1xaDZDu6"),
    ("ICD10", "R57.2", "R57.2 Septic shock", "eesGz1c6DD3"),
    ("ICD10", "R57.8", "R57.8 Other shock", "nn2Hj4Zjob9"),
    ("ICD10", "R57.9", "R57.9 Shock, unspecified", "eA2TJe4d1D3"),
    ("ICD10", "R58", "R58 Haemorrhage, not elsewhere classified", "uKd1Qcl6RET"),
    ("ICD10", "R59", "R59 Enlarged lymph nodes", "RqrFmwOpytE"),
    ("ICD10", "R59.0", "R59.0 Localized enlarged lymph nodes", "GqcprCtRZhc"),
    ("ICD10", "R59.1", "R59.1 Generalized enlarged lymph nodes", "sVRGTEYlEGJ"),
    ("ICD10", "R59.9", "R59.9 Enlarged lymph nodes, unspecified", "q7UtmO3ACVB"),
    ("ICD10", "R60", "R60 Oedema, not elsewhere classified", "JpiA9GRZskx"),
    ("ICD10", "R60.0", "R60.0 Localized oedema", "BSaVtEQIFfq"),
    ("ICD10", "R60.1", "R60.1 Generalized oedema", "CugFt6LUl2y"),
    ("ICD10", "R60.9", "R60.9 Oedema, unspecified", "Bj6bUIObosI"),
    ("ICD10", "R61", "R61 Hyperhidrosis", "dzQJEmqCbgF"),
    ("ICD10", "R61.0", "R61.0 Localized hyperhidrosis", "AFe9jZ1UQC7"),
    ("ICD10", "R61.1", "R61.1 Generalized hyperhidrosis", "Vo0H6xbrGAy"),
    ("ICD10", "R61.9", "R61.9 Hyperhidrosis, unspecified", "RbnClVm33GN"),
    ("ICD10", "R62", "R62 Lack of expected normal physiological development", "s6VMoe0wnUA"),
    ("ICD10", "R62.0", "R62.0 Delayed milestone", "rCa4tWIRqjd"),
    ("ICD10", "R62.8", "R62.8 Other lack of expected normal physiological development", "Xvnk5HlDwUG"),
    ("ICD10", "R62.9", "R62.9 Lack of expected normal physiological development, unspecified", "kSYgSemqjfP"),
    ("ICD10", "R63", "R63 Symptoms and signs concerning food and fluid intake", "lQsGkGw0e6Y"),
    ("ICD10", "R63.0", "R63.0 Anorexia", "hV74Zvp7YnX"),
    ("ICD10", "R63.1", "R63.1 Polydipsia", "DrO1fQgyvUh"),
    ("ICD10", "R63.2", "R63.2 Polyphagia", "ipshSrvF5s8"),
    ("ICD10", "R63.3", "R63.3 Feeding difficulties and mismanagement", "IjDOoCoafJR"),
    ("ICD10", "R63.4", "R63.4 Abnormal weight loss", "ixLvY7mvFFa"),
    ("ICD10", "R63.5", "R63.5 Abnormal weight gain", "BbdK401v5J9"),
    ("ICD10", "R63.6", "R63.6 Insufficient intake of food and water due to self neglect", "PuVfO1CL0A0"),
    ("ICD10", "R63.8", "R63.8 Other symptoms and signs concerning food and fluid intake", "Z3fkFnn0yLs"),
    ("ICD10", "R64", "R64 Cachexia", "I9t5FcEfZU3"),
    ("ICD10", "R65", "R65 Systemic Inflammatory Response Syndrome [SIRS]", "NPxv4P3kpnG"),
    ("ICD10", "R65.0", "R65.0 Systemic Inflammatory Response Syndrome of infectious origin without organ failure", "QAdORIswuBZ"),
    ("ICD10", "R65.1", "R65.1 Systemic Inflammatory Response Syndrome of infectious origin with organ failure", "KdcOdCIHn84"),
    ("ICD10", "R65.2", "R65.2 Systemic Inflammatory Response Syndrome of non-infectious origin without organ failure", "xZhyMmcbcu0"),
    ("ICD10", "R65.3", "R65.3 Systemic Inflammatory Response Syndrome of non-infectious origin with organ failure", "OPJAsJlrakG"),
    ("ICD10", "R65.9", "R65.9 Systemic Inflammatory Response Syndrome, unspecified", "snsDbVtqMyp"),
    ("ICD10", "R68", "R68 Other general symptoms and signs", "iFX5iur6KP0"),
    ("ICD10", "R68.0", "R68.0 Hypothermia, not associated with low environmental temperature", "DxvkZAHbzcg"),
    ("ICD10", "R68.1", "R68.1 Nonspecific symptoms peculiar to infancy", "gQ4Hq0p31pB"),
    ("ICD10", "R68.2", "R68.2 Dry mouth, unspecified", "hXn9QiUmD9C"),
    ("ICD10", "R68.3", "R68.3 Clubbing of fingers", "HmWuKJT3EWD"),
    ("ICD10", "R68.8", "R68.8 Other specified general symptoms and signs", "mGhyec96swV"),
    ("ICD10", "R69", "R69 Unknown and unspecified causes of morbidity", "s5PMjZ7pSTm"),
    ("ICD10", "R70", "R70 Elevated erythrocyte sedimentation rate and abnormality of plasma viscosity", "avrOreQYxmi"),
    ("ICD10", "R70.0", "R70.0 Elevated erythrocyte sedimentation rate", "HlwNrqWfVWk"),
    ("ICD10", "R70.1", "R70.1 Abnormal plasma viscosity", "iCUxbHWpK9E"),
    ("ICD10", "R71", "R71 Abnormality of red blood cells", "XKkH2ltvcMi"),
    ("ICD10", "R72", "R72 Abnormality of white blood cells, not elsewhere classified", "L4OqqKy2HdT"),
    ("ICD10", "R73", "R73 Elevated blood glucose level", "V89JTTUQA3T"),
    ("ICD10", "R73.0", "R73.0 Abnormal glucose tolerance test", "UGqh1quZZwg"),
    ("ICD10", "R73.9", "R73.9 Hyperglycaemia, unspecified", "HwtB1bNeZqA"),
    ("ICD10", "R74", "R74 Abnormal serum enzyme levels", "a1PNGtrhxe8"),
    ("ICD10", "R74.0", "R74.0 Elevation of levels of transaminase and lactic acid dehydrogenase [LDH]", "jfPvC2PVAIX"),
    ("ICD10", "R74.8", "R74.8 Abnormal levels of other serum enzymes", "tXGlCP69iK6"),
    ("ICD10", "R74.9", "R74.9 Abnormal level of unspecified serum enzyme", "aIm92UikRyu"),
    ("ICD10", "R75", "R75 Laboratory evidence of human immunodeficiency virus [HIV]", "pqpiR3baa81"),
    ("ICD10", "R76", "R76 Other abnormal immunological findings in serum", "fUZDNsnR6zU"),
    ("ICD10", "R76.0", "R76.0 Raised antibody titre", "s6W9KcwgYyd"),
    ("ICD10", "R76.1", "R76.1 Abnormal reaction to tuberculin test", "lA65r0y5TqU"),
    ("ICD10", "R76.2", "R76.2 False-positive serological test for syphilis", "EIi4wYTaJlU"),
    ("ICD10", "R76.8", "R76.8 Other specified abnormal immunological findings in serum", "DjD2Qz1Hn7O"),
    ("ICD10", "R76.9", "R76.9 Abnormal immunological finding in serum, unspecified", "SL3RvEounIz"),
    ("ICD10", "R77", "R77 Other abnormalities of plasma proteins", "KTu899sexf9"),
    ("ICD10", "R77.0", "R77.0 Abnormality of albumin", "uJeb7Bu54Dd"),
    ("ICD10", "R77.1", "R77.1 Abnormality of globulin", "CyuPfM8yV7S"),
    ("ICD10", "R77.2", "R77.2 Abnormality of alphafetoprotein", "BPFaSnQrwQj"),
    ("ICD10", "R77.8", "R77.8 Other specified abnormalities of plasma proteins", "UGb5DkoygBN"),
    ("ICD10", "R77.9", "R77.9 Abnormality of plasma protein, unspecified", "IkUtkarFMpM"),
    ("ICD10", "R78", "R78 Findings of drugs and other substances, not normally found in blood", "UqntjuvEsUN"),
    ("ICD10", "R78.0", "R78.0 Finding of alcohol in blood", "buh78WdRj8k"),
    ("ICD10", "R78.1", "R78.1 Finding of opiate drug in blood", "TDVG9Et2aNQ"),
    ("ICD10", "R78.2", "R78.2 Finding of cocaine in blood", "d2z9eYURo7l"),
    ("ICD10", "R78.3", "R78.3 Finding of hallucinogen in blood", "MTL95jwWtxq"),
    ("ICD10", "R78.4", "R78.4 Finding of other drugs of addictive potential in blood", "jFjqzuzneT1"),
    ("ICD10", "R78.5", "R78.5 Finding of psychotropic drug in blood", "h9hOWYleBnL"),
    ("ICD10", "R78.6", "R78.6 Finding of steroid agent in blood", "uTuudyI8xGu"),
    ("ICD10", "R78.7", "R78.7 Finding of abnormal level of heavy metals in blood", "UAuDLOMp0pX"),
    ("ICD10", "R78.8", "R78.8 Finding of other specified substances, not normally found in blood", "DULRltpjP1c"),
    ("ICD10", "R78.9", "R78.9 Finding of unspecified substance, not normally found in blood", "Q2pDGm6KuoN"),
    ("ICD10", "R79", "R79 Other abnormal findings of blood chemistry", "myFAI6RCvta"),
    ("ICD10", "R79.0", "R79.0 Abnormal level of blood mineral", "FADOqzDHQeO"),
    ("ICD10", "R79.8", "R79.8 Other specified abnormal findings of blood chemistry", "fsjzMVg1QSP"),
    ("ICD10", "R79.9", "R79.9 Abnormal finding of blood chemistry, unspecified", "bR3qek1dJzH"),
    ("ICD10", "R80", "R80 Isolated proteinuria", "N5rU1kTuLSk"),
    ("ICD10", "R81", "R81 Glycosuria", "meoR0G6qDGl"),
    ("ICD10", "R82", "R82 Other abnormal findings in urine", "BTEWCK5Qf3A"),
    ("ICD10", "R82.0", "R82.0 Chyluria", "bp34dzOCgLx"),
    ("ICD10", "R82.1", "R82.1 Myoglobinuria", "TZF2n5q9HVs"),
    ("ICD10", "R82.2", "R82.2 Biliuria", "p3pe2WlEE2x"),
    ("ICD10", "R82.3", "R82.3 Haemoglobinuria", "ipeHU0UsbfK"),
    ("ICD10", "R82.4", "R82.4 Acetonuria", "XQbetDIrZYY"),
    ("ICD10", "R82.5", "R82.5 Elevated urine levels of drugs, medicaments and biological substances", "Mu9810zDYzr"),
    ("ICD10", "R82.6", "R82.6 Abnormal urine levels of substances chiefly nonmedicinal as to source", "K2LcTakIfj4"),
    ("ICD10", "R82.7", "R82.7 Abnormal findings on microbiological examination of urine", "xic2WekEoFF"),
    ("ICD10", "R82.8", "R82.8 Abnormal findings on cytological and histological examination of urine", "eN2dDFK0e4b"),
    ("ICD10", "R82.9", "R82.9 Other and unspecified abnormal findings in urine", "bZbHqym8H9j");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "R83", "R83 Abnormal findings in cerebrospinal fluid", "kxjFtpQL5rG"),
    ("ICD10", "R84", "R84 Abnormal findings in specimens from respiratory organs and thorax", "cStz9JTCEf9"),
    ("ICD10", "R85", "R85 Abnormal findings in specimens from digestive organs and abdominal cavity", "gOqXTzxfY1V"),
    ("ICD10", "R86", "R86 Abnormal findings in specimens from male genital organs", "k5QiUwaKh52"),
    ("ICD10", "R87", "R87 Abnormal findings in specimens from female genital organs", "FgKMqX8NQAf"),
    ("ICD10", "R89", "R89 Abnormal findings in specimens from other organs, systems and tissues", "NvBzF6JCp4n"),
    ("ICD10", "R90", "R90 Abnormal findings on diagnostic imaging of central nervous system", "ZS25AM5DP2V"),
    ("ICD10", "R90.0", "R90.0 Intracranial space-occupying lesion", "te8n3y3JjSy"),
    ("ICD10", "R90.8", "R90.8 Other abnormal findings on diagnostic imaging of central nervous system", "QrOokQUSLV0"),
    ("ICD10", "R91", "R91 Abnormal findings on diagnostic imaging of lung", "anXZdskbnz2"),
    ("ICD10", "R92", "R92 Abnormal findings on diagnostic imaging of breast", "wvb8Xjbn6dQ"),
    ("ICD10", "R93", "R93 Abnormal findings on diagnostic imaging of other body structures", "iuiJVdyQUIL"),
    ("ICD10", "R93.0", "R93.0 Abnormal findings on diagnostic imaging of skull and head, not elsewhere classified", "AoccSti02Hn"),
    ("ICD10", "R93.1", "R93.1 Abnormal findings on diagnostic imaging of heart and coronary circulation", "o1AJbyV1YbK"),
    ("ICD10", "R93.2", "R93.2 Abnormal findings on diagnostic imaging of liver and biliary tract", "KGFUxoPkSxr"),
    ("ICD10", "R93.3", "R93.3 Abnormal findings on diagnostic imaging of other parts of digestive tract", "JLnAg6TMPqm"),
    ("ICD10", "R93.4", "R93.4 Abnormal findings on diagnostic imaging of urinary organs", "Tq65n2plfKH"),
    ("ICD10", "R93.5", "R93.5 Abnormal findings on diagnostic imaging of other abdominal regions, including retroperitoneum", "NUujIR0nsSk"),
    ("ICD10", "R93.6", "R93.6 Abnormal findings on diagnostic imaging of limbs", "hHWa81L7pkY"),
    ("ICD10", "R93.7", "R93.7 Abnormal findings on diagnostic imaging of other parts of musculoskeletal system", "rkOZjHZQV4S"),
    ("ICD10", "R93.8", "R93.8 Abnormal findings on diagnostic imaging of other specified body structures", "bp2ZkZz0v5D"),
    ("ICD10", "R94", "R94 Abnormal results of function studies", "StXb6eJJRLc"),
    ("ICD10", "R94.0", "R94.0 Abnormal results of function studies of central nervous system", "oBinyrMe3Zq"),
    ("ICD10", "R94.1", "R94.1 Abnormal results of function studies of peripheral nervous system and special senses", "akBSblBQOJp"),
    ("ICD10", "R94.2", "R94.2 Abnormal results of pulmonary function studies", "tQ4UuhVreYX"),
    ("ICD10", "R94.3", "R94.3 Abnormal results of cardiovascular function studies", "zv8Zbm1SrUo"),
    ("ICD10", "R94.4", "R94.4 Abnormal results of kidney function studies", "H1DocUwd1j0"),
    ("ICD10", "R94.5", "R94.5 Abnormal results of liver function studies", "wbMJsomSW6d"),
    ("ICD10", "R94.6", "R94.6 Abnormal results of thyroid function studies", "WqMc326GSin"),
    ("ICD10", "R94.7", "R94.7 Abnormal results of other endocrine function studies", "dgjjlZtgWPH"),
    ("ICD10", "R94.8", "R94.8 Abnormal results of function studies of other organs and systems", "HOg6imiPTjL"),
    ("ICD10", "R95", "R95 Sudden infant death syndrome", "gCKTKebqYXc"),
    ("ICD10", "R95.0", "R95.0 Sudden infant death syndrome with mention of autopsy", "JgFedLqJV7K"),
    ("ICD10", "R95.9", "R95.9 Sudden infant death syndrome without mention of autopsy", "KaiRQFCNowG"),
    ("ICD10", "R96", "R96 Other sudden death, cause unknown", "k5cPZB5I5Mh"),
    ("ICD10", "R96.0", "R96.0 Instantaneous death", "FsWOfHOrkDI"),
    ("ICD10", "R96.1", "R96.1 Death occurring less than 24 hours from onset of symptoms, not otherwise explained", "TWXurQ4oqcr"),
    ("ICD10", "R98", "R98 Unattended death", "olXcaLcyJy0"),
    ("ICD10", "R99", "R99 Other ill-defined and unspecified causes of mortality", "BpXBjID7ToT");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "S00", "S00 Superficial injury of head", "JQeS3DcM1V6"),
    ("ICD10", "S00.0", "S00.0 Superficial injury of scalp", "xcAUnWAMcrm"),
    ("ICD10", "S00.1", "S00.1 Contusion of eyelid and periocular area", "dxANrN9z9st"),
    ("ICD10", "S00.2", "S00.2 Other superficial injuries of eyelid and periocular area", "bQHRewWU3rK"),
    ("ICD10", "S00.3", "S00.3 Superficial injury of nose", "gF7LaMlnBR0"),
    ("ICD10", "S00.4", "S00.4 Superficial injury of ear", "AWWKi3UQBYz"),
    ("ICD10", "S00.5", "S00.5 Superficial injury of lip and oral cavity", "de6UJFQHYWA"),
    ("ICD10", "S00.7", "S00.7 Multiple superficial injuries of head", "SJt2Ltnd4B7"),
    ("ICD10", "S00.8", "S00.8 Superficial injury of other parts of head", "geMBOC43u5o"),
    ("ICD10", "S00.9", "S00.9 Superficial injury of head, part unspecified", "V23ME9GqTUf"),
    ("ICD10", "S01", "S01 Open wound of head", "BqbcNRC8C1I"),
    ("ICD10", "S01.0", "S01.0 Open wound of scalp", "d7IbqS6MLYv"),
    ("ICD10", "S01.1", "S01.1 Open wound of eyelid and periocular area", "bIm1tMrKdM7"),
    ("ICD10", "S01.2", "S01.2 Open wound of nose", "yLZMIK3Ft7o"),
    ("ICD10", "S01.3", "S01.3 Open wound of ear", "Kc46i6no3ju"),
    ("ICD10", "S01.4", "S01.4 Open wound of cheek and temporomandibular area", "vPvOQ9EOlE8"),
    ("ICD10", "S01.5", "S01.5 Open wound of lip and oral cavity", "upK82hWae5P"),
    ("ICD10", "S01.7", "S01.7 Multiple open wounds of head", "ZgLtKFYHxF1"),
    ("ICD10", "S01.8", "S01.8 Open wound of other parts of head", "wLq6CGmPia4"),
    ("ICD10", "S01.9", "S01.9 Open wound of head, part unspecified", "jNxGrePitDq"),
    ("ICD10", "S02", "S02 Fracture of skull and facial bones", "cN0VKt2vhpH"),
    ("ICD10", "S02.0", "S02.0 Fracture of vault of skull", "q9RY8wHc4vV"),
    ("ICD10", "S02.1", "S02.1 Fracture of base of skull", "hEBOejrjYCi"),
    ("ICD10", "S02.2", "S02.2 Fracture of nasal bones", "ol4AGJ3Csbe"),
    ("ICD10", "S02.3", "S02.3 Fracture of orbital floor", "UjJsB6G4OaJ"),
    ("ICD10", "S02.4", "S02.4 Fracture of malar and maxillary bones", "baBc4TiRt9j"),
    ("ICD10", "S02.5", "S02.5 Fracture of tooth", "e3DaHwmTrGl"),
    ("ICD10", "S02.6", "S02.6 Fracture of mandible", "cL4VsqPfckA"),
    ("ICD10", "S02.7", "S02.7 Multiple fractures involving skull and facial bones", "NdYzkMfHWEg"),
    ("ICD10", "S02.8", "S02.8 Fractures of other skull and facial bones", "C9GlDtlXD8C"),
    ("ICD10", "S02.9", "S02.9 Fracture of skull and facial bones, part unspecified", "g71cjBo2rpb"),
    ("ICD10", "S03", "S03 Dislocation, sprain and strain of joints and ligaments of head", "UziQWeBvhpr"),
    ("ICD10", "S03.0", "S03.0 Dislocation of jaw", "A6NKBeu2bhM"),
    ("ICD10", "S03.1", "S03.1 Dislocation of septal cartilage of nose", "qmfRGQ0fYzN"),
    ("ICD10", "S03.2", "S03.2 Dislocation of tooth", "xs1vQ1T83UJ"),
    ("ICD10", "S03.3", "S03.3 Dislocation of other and unspecified parts of head", "UdnSkAm8FCE"),
    ("ICD10", "S03.4", "S03.4 Sprain and strain of jaw", "a09Rdi9LSId"),
    ("ICD10", "S03.5", "S03.5 Sprain and strain of joints and ligaments of other and unspecified parts of head", "ZW0FPDHOVjG"),
    ("ICD10", "S04", "S04 Injury of cranial nerves", "GNlSbz6ZGr7"),
    ("ICD10", "S04.0", "S04.0 Injury of optic nerve and pathways", "tuXh2kPvrRo"),
    ("ICD10", "S04.1", "S04.1 Injury of oculomotor nerve", "iWZOeiSahvV"),
    ("ICD10", "S04.2", "S04.2 Injury of trochlear nerve", "lAWJGkGXiYf"),
    ("ICD10", "S04.3", "S04.3 Injury of trigeminal nerve", "QkuQHhX2gv7"),
    ("ICD10", "S04.4", "S04.4 Injury of abducent nerve", "x6j3RsDplmk"),
    ("ICD10", "S04.5", "S04.5 Injury of facial nerve", "mCx2A2LhGBw"),
    ("ICD10", "S04.6", "S04.6 Injury of acoustic nerve", "JXtG03p9XGe"),
    ("ICD10", "S04.7", "S04.7 Injury of accessory nerve", "CbouRXmwB1C"),
    ("ICD10", "S04.8", "S04.8 Injury of other cranial nerves", "JogtKNcdh4v"),
    ("ICD10", "S04.9", "S04.9 Injury of unspecified cranial nerve", "UsiJsSaubkO"),
    ("ICD10", "S05", "S05 Injury of eye and orbit", "tAgwbCzf6Lg"),
    ("ICD10", "S05.0", "S05.0 Injury of conjunctiva and corneal abrasion without mention of foreign body", "UeF6NV6KGEJ"),
    ("ICD10", "S05.1", "S05.1 Contusion of eyeball and orbital tissues", "DTmiFk89wIm"),
    ("ICD10", "S05.2", "S05.2 Ocular laceration and rupture with prolapse or loss of intraocular tissue", "jTBTekLJYu8"),
    ("ICD10", "S05.3", "S05.3 Ocular laceration without prolapse or loss of intraocular tissue", "iYlwuyCIBkI"),
    ("ICD10", "S05.4", "S05.4 Penetrating wound of orbit with or without foreign body", "R9JGjChWlUG"),
    ("ICD10", "S05.5", "S05.5 Penetrating wound of eyeball with foreign body", "JfqkTxgFzFZ"),
    ("ICD10", "S05.6", "S05.6 Penetrating wound of eyeball without foreign body", "Y3piJPAs6aa"),
    ("ICD10", "S05.7", "S05.7 Avulsion of eye", "Q0CHQEvuWMb"),
    ("ICD10", "S05.8", "S05.8 Other injuries of eye and orbit", "LxUejgN7joi"),
    ("ICD10", "S05.9", "S05.9 Injury of eye and orbit, unspecified", "j1VWS5JO6As"),
    ("ICD10", "S06", "S06 Intracranial injury", "D6s3KpE1PWd"),
    ("ICD10", "S06.0", "S06.0 Concussion", "ZIxfWLbDVm4"),
    ("ICD10", "S06.1", "S06.1 Traumatic cerebral oedema", "qKlEPRKfDRN"),
    ("ICD10", "S06.2", "S06.2 Diffuse brain injury", "kxNBCoKk20v"),
    ("ICD10", "S06.3", "S06.3 Focal brain injury", "lDCe5xQucD1"),
    ("ICD10", "S06.4", "S06.4 Epidural haemorrhage", "ZrSQlMkUhNU"),
    ("ICD10", "S06.5", "S06.5 Traumatic subdural haemorrhage", "tHqhLlgPuv4"),
    ("ICD10", "S06.6", "S06.6 Traumatic subarachnoid haemorrhage", "iT4vzhGt80C"),
    ("ICD10", "S06.7", "S06.7 Intracranial injury with prolonged coma", "bv9LC2Ph6UK"),
    ("ICD10", "S06.8", "S06.8 Other intracranial injuries", "MRTUhKajhCc"),
    ("ICD10", "S06.9", "S06.9 Intracranial injury, unspecified", "rOlKVMt5ewf"),
    ("ICD10", "S07", "S07 Crushing injury of head", "DdxBJi1PzU4"),
    ("ICD10", "S07.0", "S07.0 Crushing injury of face", "EQuu1AeRlfR"),
    ("ICD10", "S07.1", "S07.1 Crushing injury of skull", "Kxjv9BNoHJ4"),
    ("ICD10", "S07.8", "S07.8 Crushing injury of other parts of head", "fEZDCWjVSf7"),
    ("ICD10", "S07.9", "S07.9 Crushing injury of head, part unspecified", "ofEtkrko83H"),
    ("ICD10", "S08", "S08 Traumatic amputation of part of head", "hpYLSqOcyQ6"),
    ("ICD10", "S08.0", "S08.0 Avulsion of scalp", "HNGdsKVps5h"),
    ("ICD10", "S08.1", "S08.1 Traumatic amputation of ear", "MFyrZeVgaRC"),
    ("ICD10", "S08.8", "S08.8 Traumatic amputation of other parts of head", "h5qWp9entjQ"),
    ("ICD10", "S08.9", "S08.9 Traumatic amputation of unspecified part of head", "zsG39eHLvqh"),
    ("ICD10", "S09", "S09 Other and unspecified injuries of head", "bA5sEQS7aAQ"),
    ("ICD10", "S09.0", "S09.0 Injury of blood vessels of head, not elsewhere classified", "JTnrU675wFE"),
    ("ICD10", "S09.1", "S09.1 Injury of muscle and tendon of head", "XiPZtcbdxgw"),
    ("ICD10", "S09.2", "S09.2 Traumatic rupture of ear drum", "FIAfdxYJhiZ"),
    ("ICD10", "S09.7", "S09.7 Multiple injuries of head", "Kp1mfPNW91O"),
    ("ICD10", "S09.8", "S09.8 Other specified injuries of head", "ZKorAJnWXPX"),
    ("ICD10", "S09.9", "S09.9 Unspecified injury of head", "mgccDOarGVf"),
    ("ICD10", "S10", "S10 Superficial injury of neck", "ELYBmq08JUm"),
    ("ICD10", "S10.0", "S10.0 Contusion of throat", "lg54GBtxkAf"),
    ("ICD10", "S10.1", "S10.1 Other and unspecified superficial injuries of throat", "j7jdvHI3rjp"),
    ("ICD10", "S10.7", "S10.7 Multiple superficial injuries of neck", "iJer9PVkMtt"),
    ("ICD10", "S10.8", "S10.8 Superficial injury of other parts of neck", "PmEJalvh2eV"),
    ("ICD10", "S10.9", "S10.9 Superficial injury of neck, part unspecified", "h4iY0qPdgo5"),
    ("ICD10", "S11", "S11 Open wound of neck", "QQr1f1lWF4l"),
    ("ICD10", "S11.0", "S11.0 Open wound involving larynx and trachea", "YuKloSZdDYz"),
    ("ICD10", "S11.1", "S11.1 Open wound involving thyroid gland", "wVn2nF03Euf"),
    ("ICD10", "S11.2", "S11.2 Open wound involving pharynx and cervical oesophagus", "sGeVH1d048i"),
    ("ICD10", "S11.7", "S11.7 Multiple open wounds of neck", "bT0ZQOj51dn"),
    ("ICD10", "S11.8", "S11.8 Open wound of other parts of neck", "pezN239U4T4"),
    ("ICD10", "S11.9", "S11.9 Open wound of neck, part unspecified", "b1JCU8qro1R"),
    ("ICD10", "S12", "S12 Fracture of neck", "Fxy1pkAYGGT"),
    ("ICD10", "S12.0", "S12.0 Fracture of first cervical vertebra", "gBhJmAjYJmh"),
    ("ICD10", "S12.1", "S12.1 Fracture of second cervical vertebra", "gCfkc6scbeU"),
    ("ICD10", "S12.2", "S12.2 Fracture of other specified cervical vertebra", "w6u2QLh881i"),
    ("ICD10", "S12.7", "S12.7 Multiple fractures of cervical spine", "CjAeTYQic4U"),
    ("ICD10", "S12.8", "S12.8 Fracture of other parts of neck", "fdTDydfUsAx"),
    ("ICD10", "S12.9", "S12.9 Fracture of neck, part unspecified", "SfBic3S357r"),
    ("ICD10", "S13", "S13 Dislocation, sprain and strain of joints and ligaments at neck level", "S2kZiC9l3N8"),
    ("ICD10", "S13.0", "S13.0 Traumatic rupture of cervical intervertebral disc", "MSd8Z3l71SL"),
    ("ICD10", "S13.1", "S13.1 Dislocation of cervical vertebra", "ifjACnFjNdM"),
    ("ICD10", "S13.2", "S13.2 Dislocation of other and unspecified parts of neck", "hvHXMLjBct3"),
    ("ICD10", "S13.3", "S13.3 Multiple dislocations of neck", "rGNNcDjst09"),
    ("ICD10", "S13.4", "S13.4 Sprain and strain of cervical spine", "DkT8g8Fbcg0"),
    ("ICD10", "S13.5", "S13.5 Sprain and strain of thyroid region", "o4e568Gn8xx"),
    ("ICD10", "S13.6", "S13.6 Sprain and strain of joints and ligaments of other and unspecified parts of neck", "aJeVF7wPOaS"),
    ("ICD10", "S14", "S14 Injury of nerves and spinal cord at neck level", "GwS9RX2zk0r"),
    ("ICD10", "S14.0", "S14.0 Concussion and oedema of cervical spinal cord", "mkInXK6x6E6"),
    ("ICD10", "S14.1", "S14.1 Other and unspecified injuries of cervical spinal cord", "umDKoRd7lO4"),
    ("ICD10", "S14.2", "S14.2 Injury of nerve root of cervical spine", "nOFRDTmekFp"),
    ("ICD10", "S14.3", "S14.3 Injury of brachial plexus", "Y324SKkTtfW"),
    ("ICD10", "S14.4", "S14.4 Injury of peripheral nerves of neck", "MD3Ann4Bi0g"),
    ("ICD10", "S14.5", "S14.5 Injury of cervical sympathetic nerves", "kaErEWuJrvU"),
    ("ICD10", "S14.6", "S14.6 Injury of other and unspecified nerves of neck", "CrsO13fM2fB"),
    ("ICD10", "S15", "S15 Injury of blood vessels at neck level", "iSCSr3HexwY"),
    ("ICD10", "S15.0", "S15.0 Injury of carotid artery", "HyX2u0Cr6Qn"),
    ("ICD10", "S15.1", "S15.1 Injury of vertebral artery", "mTqo6VxuvVc"),
    ("ICD10", "S15.2", "S15.2 Injury of external jugular vein", "nqgovJpTYHm"),
    ("ICD10", "S15.3", "S15.3 Injury of internal jugular vein", "y3fG5mNq50F"),
    ("ICD10", "S15.7", "S15.7 Injury of multiple blood vessels at neck level", "djHdCRnvBEu"),
    ("ICD10", "S15.8", "S15.8 Injury of other blood vessels at neck level", "ceXtdiV6ZnT"),
    ("ICD10", "S15.9", "S15.9 Injury of unspecified blood vessel at neck level", "YdFg8zO65e8"),
    ("ICD10", "S16", "S16 Injury of muscle and tendon at neck level", "J4ZfgfuC3PD"),
    ("ICD10", "S17", "S17 Crushing injury of neck", "Q2kuRLBG6z3"),
    ("ICD10", "S17.0", "S17.0 Crushing injury of larynx and trachea", "gx7NogabVaT"),
    ("ICD10", "S17.8", "S17.8 Crushing injury of other parts of neck", "RKUJDcwmLGc"),
    ("ICD10", "S17.9", "S17.9 Crushing injury of neck, part unspecified", "QgatXYVbPyO"),
    ("ICD10", "S18", "S18 Traumatic amputation at neck level", "k6YxKHSH9xV"),
    ("ICD10", "S19", "S19 Other and unspecified injuries of neck", "ysCWLHgOz0y"),
    ("ICD10", "S19.7", "S19.7 Multiple injuries of neck", "XtZHwYVWbvb"),
    ("ICD10", "S19.8", "S19.8 Other specified injuries of neck", "uizdA1zynGU"),
    ("ICD10", "S19.9", "S19.9 Unspecified injury of neck", "k3c8jo1o9Yl"),
    ("ICD10", "S20", "S20 Superficial injury of thorax", "YlGaZ6og2Tm"),
    ("ICD10", "S20.0", "S20.0 Contusion of breast", "dVKox9zc6hG"),
    ("ICD10", "S20.1", "S20.1 Other and unspecified superficial injuries of breast", "UESoaegFLFd"),
    ("ICD10", "S20.2", "S20.2 Contusion of thorax", "WJceAQwX1pL"),
    ("ICD10", "S20.3", "S20.3 Other superficial injuries of front wall of thorax", "CSMDspT07zZ"),
    ("ICD10", "S20.4", "S20.4 Other superficial injuries of back wall of thorax", "rtCoOWCjktP"),
    ("ICD10", "S20.7", "S20.7 Multiple superficial injuries of thorax", "yIEl5TRknxC"),
    ("ICD10", "S20.8", "S20.8 Superficial injury of other and unspecified parts of thorax", "wvWVS4WeQAe"),
    ("ICD10", "S21", "S21 Open wound of thorax", "JkzNuEYgXEd"),
    ("ICD10", "S21.0", "S21.0 Open wound of breast", "VQAJdlLIXvN"),
    ("ICD10", "S21.1", "S21.1 Open wound of front wall of thorax", "gvAfF6YtbT5"),
    ("ICD10", "S21.2", "S21.2 Open wound of back wall of thorax", "qtcLRy306Dk"),
    ("ICD10", "S21.7", "S21.7 Multiple open wounds of thoracic wall", "pRa5KaDHA6g"),
    ("ICD10", "S21.8", "S21.8 Open wound of other parts of thorax", "C49Jn1XOu7J"),
    ("ICD10", "S21.9", "S21.9 Open wound of thorax, part unspecified", "BpZcoWMJU36"),
    ("ICD10", "S22", "S22 Fracture of rib(s), sternum and thoracic spine", "YcPikHXKmtc"),
    ("ICD10", "S22.0", "S22.0 Fracture of thoracic vertebra", "HEwKArvO7xT"),
    ("ICD10", "S22.1", "S22.1 Multiple fractures of thoracic spine", "EaN3bKSbHLn"),
    ("ICD10", "S22.2", "S22.2 Fracture of sternum", "KfnNQi9FwlL"),
    ("ICD10", "S22.3", "S22.3 Fracture of rib", "WniXKdN86iB"),
    ("ICD10", "S22.4", "S22.4 Multiple fractures of ribs", "Gqr3GukocMi"),
    ("ICD10", "S22.5", "S22.5 Flail chest", "sb7aMSsorIb"),
    ("ICD10", "S22.8", "S22.8 Fracture of other parts of bony thorax", "i2VJvFP5dPm"),
    ("ICD10", "S22.9", "S22.9 Fracture of bony thorax, part unspecified", "KAuNSUrrTjv"),
    ("ICD10", "S23", "S23 Dislocation, sprain and strain of joints and ligaments of thorax", "lbvwzpGoZVJ"),
    ("ICD10", "S23.0", "S23.0 Traumatic rupture of thoracic intervertebral disc", "L9Teq5UIaKz"),
    ("ICD10", "S23.1", "S23.1 Dislocation of thoracic vertebra", "HKDosm3rjA7"),
    ("ICD10", "S23.2", "S23.2 Dislocation of other and unspecified parts of thorax", "Cb0p4KSZIlq"),
    ("ICD10", "S23.3", "S23.3 Sprain and strain of thoracic spine", "O1yYkb8FrwI"),
    ("ICD10", "S23.4", "S23.4 Sprain and strain of ribs and sternum", "VfRU2LOE62T"),
    ("ICD10", "S23.5", "S23.5 Sprain and strain of other and unspecified parts of thorax", "N8PdrqScsDL"),
    ("ICD10", "S24", "S24 Injury of nerves and spinal cord at thorax level", "bAs9GJsGELn"),
    ("ICD10", "S24.0", "S24.0 Concussion and oedema of thoracic spinal cord", "bfZuUsa2ZE9"),
    ("ICD10", "S24.1", "S24.1 Other and unspecified injuries of thoracic spinal cord", "bJCyk7o7TA4"),
    ("ICD10", "S24.2", "S24.2 Injury of nerve root of thoracic spine", "bPVxMW6nxct"),
    ("ICD10", "S24.3", "S24.3 Injury of peripheral nerves of thorax", "gXvWtRTb6YS"),
    ("ICD10", "S24.4", "S24.4 Injury of thoracic sympathetic nerves", "uiCmYA3FsgH"),
    ("ICD10", "S24.5", "S24.5 Injury of other nerves of thorax", "OwjYJOqMjOj"),
    ("ICD10", "S24.6", "S24.6 Injury of unspecified nerve of thorax", "U5nfU9Vw4Nd"),
    ("ICD10", "S25", "S25 Injury of blood vessels of thorax", "fyRhM7BSVrX"),
    ("ICD10", "S25.0", "S25.0 Injury of thoracic aorta", "w8wx3DUyKBT"),
    ("ICD10", "S25.1", "S25.1 Injury of innominate or subclavian artery", "q6Tf2WrYpMq"),
    ("ICD10", "S25.2", "S25.2 Injury of superior vena cava", "M1pxK1T9alk"),
    ("ICD10", "S25.3", "S25.3 Injury of innominate or subclavian vein", "e3DZKXEvgKF"),
    ("ICD10", "S25.4", "S25.4 Injury of pulmonary blood vessels", "b2176lpPqkC"),
    ("ICD10", "S25.5", "S25.5 Injury of intercostal blood vessels", "e1GQyYKUarN"),
    ("ICD10", "S25.7", "S25.7 Injury of multiple blood vessels of thorax", "QqJW64uxVZN"),
    ("ICD10", "S25.8", "S25.8 Injury of other blood vessels of thorax", "zvJy8GQlalR"),
    ("ICD10", "S25.9", "S25.9 Injury of unspecified blood vessel of thorax", "n0iriVO4e5p"),
    ("ICD10", "S26", "S26 Injury of heart", "U617U2z0jkq"),
    ("ICD10", "S26.0", "S26.0 Injury of heart with haemopericardium", "XAvlhKTVb8S"),
    ("ICD10", "S26.8", "S26.8 Other injuries of heart", "kpj0xnxNes7"),
    ("ICD10", "S26.9", "S26.9 Injury of heart, unspecified", "FuvtQ1V7mZu"),
    ("ICD10", "S27", "S27 Injury of other and unspecified intrathoracic organs", "QSom71rMvLy"),
    ("ICD10", "S27.0", "S27.0 Traumatic pneumothorax", "P1LOgSFqyNZ"),
    ("ICD10", "S27.1", "S27.1 Traumatic haemothorax", "fy3w9wOdsZV"),
    ("ICD10", "S27.2", "S27.2 Traumatic haemopneumothorax", "tYkjWsE3GOS"),
    ("ICD10", "S27.3", "S27.3 Other injuries of lung", "ULyMw5rvrVQ"),
    ("ICD10", "S27.4", "S27.4 Injury of bronchus", "OJfT4u2tocF"),
    ("ICD10", "S27.5", "S27.5 Injury of thoracic trachea", "MxWo3CPTcPp"),
    ("ICD10", "S27.6", "S27.6 Injury of pleura", "h1KhWmX5uSC"),
    ("ICD10", "S27.7", "S27.7 Multiple injuries of intrathoracic organs", "aVgMnu4Rue6"),
    ("ICD10", "S27.8", "S27.8 Injury of other specified intrathoracic organs", "rqrddiRd1s6"),
    ("ICD10", "S27.9", "S27.9 Injury of unspecified intrathoracic organ", "N4wxvwsTuVt"),
    ("ICD10", "S28", "S28 Crushing injury of thorax and traumatic amputation of part of thorax", "rkrT08azbxG"),
    ("ICD10", "S28.0", "S28.0 Crushed chest", "OA82hLM2dZo"),
    ("ICD10", "S28.1", "S28.1 Traumatic amputation of part of thorax", "iaxRPXfuxCu"),
    ("ICD10", "S29", "S29 Other and unspecified injuries of thorax", "TwlzQJt0wey"),
    ("ICD10", "S29.0", "S29.0 Injury of muscle and tendon at thorax level", "UBnz5sSKFtR"),
    ("ICD10", "S29.7", "S29.7 Multiple injuries of thorax", "G8soholip7q"),
    ("ICD10", "S29.8", "S29.8 Other specified injuries of thorax", "M6uAMnfBO4Z"),
    ("ICD10", "S29.9", "S29.9 Unspecified injury of thorax", "P1eq34T7dy1"),
    ("ICD10", "S30", "S30 Superficial injury of abdomen, lower back and pelvis", "BqUaPklYtVd"),
    ("ICD10", "S30.0", "S30.0 Contusion of lower back and pelvis", "gN6Vtu2kmVo"),
    ("ICD10", "S30.1", "S30.1 Contusion of abdominal wall", "EwoAVw6GtAQ"),
    ("ICD10", "S30.2", "S30.2 Contusion of external genital organs", "ttL0ejdWndY"),
    ("ICD10", "S30.7", "S30.7 Multiple superficial injuries of abdomen, lower back and pelvis", "hLWokCVVqaE"),
    ("ICD10", "S30.8", "S30.8 Other superficial injuries of abdomen, lower back and pelvis", "Hh0xirA1cfi"),
    ("ICD10", "S30.9", "S30.9 Superficial injury of abdomen, lower back and pelvis, part unspecified", "yvn8TZnaojW"),
    ("ICD10", "S31", "S31 Open wound of abdomen, lower back and pelvis", "OnKKOlWXVcd"),
    ("ICD10", "S31.0", "S31.0 Open wound of lower back and pelvis", "jArcld7XzLv"),
    ("ICD10", "S31.1", "S31.1 Open wound of abdominal wall", "lW0GYr42u1A"),
    ("ICD10", "S31.2", "S31.2 Open wound of penis", "vlHm60gmFXR"),
    ("ICD10", "S31.3", "S31.3 Open wound of scrotum and testes", "zO23cPiEQgC"),
    ("ICD10", "S31.4", "S31.4 Open wound of vagina and vulva", "UU10Wfi1wcs"),
    ("ICD10", "S31.5", "S31.5 Open wound of other and unspecified external genital organs", "pbMarHWWOV7"),
    ("ICD10", "S31.7", "S31.7 Multiple open wounds of abdomen, lower back and pelvis", "QhwfTQmOVvC"),
    ("ICD10", "S31.8", "S31.8 Open wound of other and unspecified parts of abdomen", "Pbfqpzrdde1"),
    ("ICD10", "S32", "S32 Fracture of lumbar spine and pelvis", "yvuYuvKJlfW"),
    ("ICD10", "S32.0", "S32.0 Fracture of lumbar vertebra", "m9cmNEVTpqg"),
    ("ICD10", "S32.1", "S32.1 Fracture of sacrum", "W33XlIv2oJa"),
    ("ICD10", "S32.2", "S32.2 Fracture of coccyx", "vcxjj9U6d7U"),
    ("ICD10", "S32.3", "S32.3 Fracture of ilium", "Ufvj4xDPeD5"),
    ("ICD10", "S32.4", "S32.4 Fracture of acetabulum", "Qewi2fLEfZI"),
    ("ICD10", "S32.5", "S32.5 Fracture of pubis", "Nt4M5LAiw6E"),
    ("ICD10", "S32.7", "S32.7 Multiple fractures of lumbar spine and pelvis", "WbWZcjBVKQF"),
    ("ICD10", "S32.8", "S32.8 Fracture of other and unspecified parts of lumbar spine and pelvis", "M8MFIEQhSbd"),
    ("ICD10", "S33", "S33 Dislocation, sprain and strain of joints and ligaments of lumbar spine and pelvis", "QQlc6JZUXb2"),
    ("ICD10", "S33.0", "S33.0 Traumatic rupture of lumbar intervertebral disc", "xVnjoWvwDLt"),
    ("ICD10", "S33.1", "S33.1 Dislocation of lumbar vertebra", "tj8rIDvFZIn"),
    ("ICD10", "S33.2", "S33.2 Dislocation of sacroiliac and sacrococcygeal joint", "xtsuYKCb5Ac"),
    ("ICD10", "S33.3", "S33.3 Dislocation of other and unspecified parts of lumbar spine and pelvis", "h6SHGmSjf8h"),
    ("ICD10", "S33.4", "S33.4 Traumatic rupture of symphysis pubis", "JyfHLQshZoA"),
    ("ICD10", "S33.5", "S33.5 Sprain and strain of lumbar spine", "hhjplILgJUI"),
    ("ICD10", "S33.6", "S33.6 Sprain and strain of sacroiliac joint", "hOaj5h568ES"),
    ("ICD10", "S33.7", "S33.7 Sprain and strain of other and unspecified parts of lumbar spine and pelvis", "AIIkDQ6nXPx"),
    ("ICD10", "S34", "S34 Injury of nerves and lumbar spinal cord at abdomen, lower back and pelvis level", "Sfi0ycTnzui"),
    ("ICD10", "S34.0", "S34.0 Concussion and oedema of lumbar spinal cord", "fdUO0PrJ81R"),
    ("ICD10", "S34.1", "S34.1 Other injury of lumbar spinal cord", "FXEuX9F5xdz"),
    ("ICD10", "S34.2", "S34.2 Injury of nerve root of lumbar and sacral spine", "TsVBIFpo5kr"),
    ("ICD10", "S34.3", "S34.3 Injury of cauda equina", "evppRe4Fnfj"),
    ("ICD10", "S34.4", "S34.4 Injury of lumbosacral plexus", "ZybzBvZnWPz"),
    ("ICD10", "S34.5", "S34.5 Injury of lumbar, sacral and pelvic sympathetic nerves", "RFsUVec5Xtr"),
    ("ICD10", "S34.6", "S34.6 Injury of peripheral nerve(s) of abdomen, lower back and pelvis", "gS55iSuQOHO"),
    ("ICD10", "S34.8", "S34.8 Injury of other and unspecified nerves at abdomen, lower back and pelvis level", "BMJIrJgTXTc"),
    ("ICD10", "S35", "S35 Injury of blood vessels at abdomen, lower back and pelvis level", "Qm6gKxakK64"),
    ("ICD10", "S35.0", "S35.0 Injury of abdominal aorta", "O6KrlLu9fCL"),
    ("ICD10", "S35.1", "S35.1 Injury of inferior vena cava", "jD2JI9LajLl"),
    ("ICD10", "S35.2", "S35.2 Injury of coeliac or mesenteric artery", "H6Lj11PGw4N"),
    ("ICD10", "S35.3", "S35.3 Injury of portal or splenic vein", "ZxYjbfvNRjz"),
    ("ICD10", "S35.4", "S35.4 Injury of renal blood vessels", "fsL8vZ9OPr0"),
    ("ICD10", "S35.5", "S35.5 Injury of iliac blood vessels", "PkBbdwMU9JH"),
    ("ICD10", "S35.7", "S35.7 Injury of multiple blood vessels at abdomen, lower back and pelvis level", "vHyMMcPHfDs"),
    ("ICD10", "S35.8", "S35.8 Injury of other blood vessels at abdomen, lower back and pelvis level", "sHckttQVISy"),
    ("ICD10", "S35.9", "S35.9 Injury of unspecified blood vessel at abdomen, lower back and pelvis level", "lVmYrc9U3Nu"),
    ("ICD10", "S36", "S36 Injury of intra-abdominal organs", "O9QU8bSAhID"),
    ("ICD10", "S36.0", "S36.0 Injury of spleen", "k91ILf0BmQI"),
    ("ICD10", "S36.1", "S36.1 Injury of liver or gallbladder", "Jrx7rsk7h8H"),
    ("ICD10", "S36.2", "S36.2 Injury of pancreas", "jZXSSPLDlwd"),
    ("ICD10", "S36.3", "S36.3 Injury of stomach", "TegVGBWfnZf"),
    ("ICD10", "S36.4", "S36.4 Injury of small intestine", "QYu83wYmwoG"),
    ("ICD10", "S36.5", "S36.5 Injury of colon", "wHHfyxgsQrm"),
    ("ICD10", "S36.6", "S36.6 Injury of rectum", "xbFzerVcZmo"),
    ("ICD10", "S36.7", "S36.7 Injury of multiple intra-abdominal organs", "Cur94rtJwKC"),
    ("ICD10", "S36.8", "S36.8 Injury of other intra-abdominal organs", "JRz3p4DAYEp"),
    ("ICD10", "S36.9", "S36.9 Injury of unspecified intra-abdominal organ", "olNZdNKwNwR"),
    ("ICD10", "S37", "S37 Injury of urinary and pelvic organs", "gLDePmZJk40"),
    ("ICD10", "S37.0", "S37.0 Injury of kidney", "GxFHAComFAt"),
    ("ICD10", "S37.1", "S37.1 Injury of ureter", "PgsWfTYIZir"),
    ("ICD10", "S37.2", "S37.2 Injury of bladder", "akM3YAtT3cA"),
    ("ICD10", "S37.3", "S37.3 Injury of urethra", "v2N3oxf8GlE"),
    ("ICD10", "S37.4", "S37.4 Injury of ovary", "vEVhnZSPy8G"),
    ("ICD10", "S37.5", "S37.5 Injury of fallopian tube", "Ef5HMtOj2ix"),
    ("ICD10", "S37.6", "S37.6 Injury of uterus", "ZMGJWkMZ4fW"),
    ("ICD10", "S37.7", "S37.7 Injury of multiple pelvic organs", "GwEXfttR3D7"),
    ("ICD10", "S37.8", "S37.8 Injury of other pelvic organs", "EWnPHUrdAbh"),
    ("ICD10", "S37.9", "S37.9 Injury of unspecified pelvic organ", "CIXXrZWjpOV"),
    ("ICD10", "S38", "S38 Crushing injury and traumatic amputation of part of abdomen, lower back and pelvis", "py6baHFUmex"),
    ("ICD10", "S38.0", "S38.0 Crushing injury of external genital organs", "IvkyUIvwgc6"),
    ("ICD10", "S38.1", "S38.1 Crushing injury of other and unspecified parts of abdomen, lower back and pelvis", "CXJZdABGe5K"),
    ("ICD10", "S38.2", "S38.2 Traumatic amputation of external genital organs", "sb3ODNppzqu"),
    ("ICD10", "S38.3", "S38.3 Traumatic amputation of other and unspecified parts of abdomen, lower back and pelvis", "nobCfQvApYq"),
    ("ICD10", "S39", "S39 Other and unspecified injuries of abdomen, lower back and pelvis", "GeAggGSu2aP"),
    ("ICD10", "S39.0", "S39.0 Injury of muscle and tendon of abdomen, lower back and pelvis", "MRwifzHeqYu"),
    ("ICD10", "S39.6", "S39.6 Injury of intra-abdominal organ(s) with pelvic organ(s)", "bvG7CaasPjO"),
    ("ICD10", "S39.7", "S39.7 Other multiple injuries of abdomen, lower back and pelvis", "aOKcIOlcmt9"),
    ("ICD10", "S39.8", "S39.8 Other specified injuries of abdomen, lower back and pelvis", "dEfSw1oi0ag"),
    ("ICD10", "S39.9", "S39.9 Unspecified injury of abdomen, lower back and pelvis", "JcbZMI0hQCi");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "S40", "S40 Superficial injury of shoulder and upper arm", "jStMiwCUDci"),
    ("ICD10", "S40.0", "S40.0 Contusion of shoulder and upper arm", "dggyicnD32z"),
    ("ICD10", "S40.7", "S40.7 Multiple superficial injuries of shoulder and upper arm", "y9mhIRuTzQo"),
    ("ICD10", "S40.8", "S40.8 Other superficial injuries of shoulder and upper arm", "z8hq4L1Uawj"),
    ("ICD10", "S40.9", "S40.9 Superficial injury of shoulder and upper arm, unspecified", "hcMlxtRk8L8"),
    ("ICD10", "S41", "S41 Open wound of shoulder and upper arm", "dAIBIFYuy2z"),
    ("ICD10", "S41.0", "S41.0 Open wound of shoulder", "sqSrofPSDwo"),
    ("ICD10", "S41.1", "S41.1 Open wound of upper arm", "yvHQmS9SUuj"),
    ("ICD10", "S41.7", "S41.7 Multiple open wounds of shoulder and upper arm", "zvHVWZEt3fD"),
    ("ICD10", "S41.8", "S41.8 Open wound of other and unspecified parts of shoulder girdle", "oEAaLaSva95"),
    ("ICD10", "S42", "S42 Fracture of shoulder and upper arm", "liY93zIALRS"),
    ("ICD10", "S42.0", "S42.0 Fracture of clavicle", "kicYa6mL0xm"),
    ("ICD10", "S42.1", "S42.1 Fracture of scapula", "ih6hlmdWyU3"),
    ("ICD10", "S42.2", "S42.2 Fracture of upper end of humerus", "iE7UewfSiv4"),
    ("ICD10", "S42.3", "S42.3 Fracture of shaft of humerus", "RqMJhDkJJNv"),
    ("ICD10", "S42.4", "S42.4 Fracture of lower end of humerus", "evlggTJyuKr"),
    ("ICD10", "S42.7", "S42.7 Multiple fractures of clavicle, scapula and humerus", "gkk9FBuuEj9"),
    ("ICD10", "S42.8", "S42.8 Fracture of other parts of shoulder and upper arm", "EP0taWxT58c"),
    ("ICD10", "S42.9", "S42.9 Fracture of shoulder girdle, part unspecified", "GGS0bYONAHH"),
    ("ICD10", "S43", "S43 Dislocation, sprain and strain of joints and ligaments of shoulder girdle", "pHWqUVU5OJN"),
    ("ICD10", "S43.0", "S43.0 Dislocation of shoulder joint", "EgvmcJSUkrE"),
    ("ICD10", "S43.1", "S43.1 Dislocation of acromioclavicular joint", "k6zGnqC31eu"),
    ("ICD10", "S43.2", "S43.2 Dislocation of sternoclavicular joint", "wKlOTzvwnAY"),
    ("ICD10", "S43.3", "S43.3 Dislocation of other and unspecified parts of shoulder girdle", "x1AmrjCBzHh"),
    ("ICD10", "S43.4", "S43.4 Sprain and strain of shoulder joint", "nPi5AaghpPq"),
    ("ICD10", "S43.5", "S43.5 Sprain and strain of acromioclavicular joint", "L3gNNeqBzPY"),
    ("ICD10", "S43.6", "S43.6 Sprain and strain of sternoclavicular joint", "gQeyMh81NN9"),
    ("ICD10", "S43.7", "S43.7 Sprain and strain of other and unspecified parts of shoulder girdle", "dK8KYLOWtfg"),
    ("ICD10", "S44", "S44 Injury of nerves at shoulder and upper arm level", "CpWQpF4cNZx"),
    ("ICD10", "S44.0", "S44.0 Injury of ulnar nerve at upper arm level", "xJpNT5zqsdW"),
    ("ICD10", "S44.1", "S44.1 Injury of median nerve at upper arm level", "sVapGsuLigM"),
    ("ICD10", "S44.2", "S44.2 Injury of radial nerve at upper arm level", "B5ajOPsNZBI"),
    ("ICD10", "S44.3", "S44.3 Injury of axillary nerve", "JLFabPJhBmd"),
    ("ICD10", "S44.4", "S44.4 Injury of musculocutaneous nerve", "NgLIAqhXZ2u"),
    ("ICD10", "S44.5", "S44.5 Injury of cutaneous sensory nerve at shoulder and upper arm level", "PZrPup1tnEG"),
    ("ICD10", "S44.7", "S44.7 Injury of multiple nerves at shoulder and upper arm level", "dfbFFk7NuD3"),
    ("ICD10", "S44.8", "S44.8 Injury of other nerves at shoulder and upper arm level", "lycN3WZ0sjQ"),
    ("ICD10", "S44.9", "S44.9 Injury of unspecified nerve at shoulder and upper arm level", "XLUDPwR5FIH"),
    ("ICD10", "S45", "S45 Injury of blood vessels at shoulder and upper arm level", "wbeDopE9tGU"),
    ("ICD10", "S45.0", "S45.0 Injury of axillary artery", "A5sKNgUhKcK"),
    ("ICD10", "S45.1", "S45.1 Injury of brachial artery", "dNK035gr1nr"),
    ("ICD10", "S45.2", "S45.2 Injury of axillary or brachial vein", "oWioy3grLkC"),
    ("ICD10", "S45.3", "S45.3 Injury of superficial vein at shoulder and upper arm level", "psCwVUlAdjk"),
    ("ICD10", "S45.7", "S45.7 Injury of multiple blood vessels at shoulder and upper arm level", "ptxJoYTUfBl"),
    ("ICD10", "S45.8", "S45.8 Injury of other blood vessels at shoulder and upper arm level", "LVc8iBF6EHZ"),
    ("ICD10", "S45.9", "S45.9 Injury of unspecified blood vessel at shoulder and upper arm level", "tZfNKMrwarH"),
    ("ICD10", "S46", "S46 Injury of muscle and tendon at shoulder and upper arm level", "GFAVAoinj1R"),
    ("ICD10", "S46.0", "S46.0 Injury of muscle(s) and tendon(s) of the rotator cuff of shoulder", "Tq3Q0rwjLOg"),
    ("ICD10", "S46.1", "S46.1 Injury of muscle and tendon of long head of biceps", "VTyFHEStCNI"),
    ("ICD10", "S46.2", "S46.2 Injury of muscle and tendon of other parts of biceps", "H9lGOp9VvUM"),
    ("ICD10", "S46.3", "S46.3 Injury of muscle and tendon of triceps", "V5fU6S4FE8Y"),
    ("ICD10", "S46.7", "S46.7 Injury of multiple muscles and tendons at shoulder and upper arm level", "FgRsa1tHOy6"),
    ("ICD10", "S46.8", "S46.8 Injury of other muscles and tendons at shoulder and upper arm level", "DeJ0LAhMYjP"),
    ("ICD10", "S46.9", "S46.9 Injury of unspecified muscle and tendon at shoulder and upper arm level", "r8ihWkPPAKO"),
    ("ICD10", "S47", "S47 Crushing injury of shoulder and upper arm", "HqEX8Fp6MON"),
    ("ICD10", "S48", "S48 Traumatic amputation of shoulder and upper arm", "S2Jggrt3dXM"),
    ("ICD10", "S48.0", "S48.0 Traumatic amputation at shoulder joint", "xoiJgziD5hu"),
    ("ICD10", "S48.1", "S48.1 Traumatic amputation at level between shoulder and elbow", "pNq3UY8KWyF"),
    ("ICD10", "S48.9", "S48.9 Traumatic amputation of shoulder and upper arm, level unspecified", "yu7CXJOrlwT"),
    ("ICD10", "S49", "S49 Other and unspecified injuries of shoulder and upper arm", "olMIbwhiGN0"),
    ("ICD10", "S49.7", "S49.7 Multiple injuries of shoulder and upper arm", "L5YVJupVsRL"),
    ("ICD10", "S49.8", "S49.8 Other specified injuries of shoulder and upper arm", "ABHRQG1gwuh"),
    ("ICD10", "S49.9", "S49.9 Unspecified injury of shoulder and upper arm", "weRAo2qygRx"),
    ("ICD10", "S50", "S50 Superficial injury of forearm", "uMz56gMstn3"),
    ("ICD10", "S50.0", "S50.0 Contusion of elbow", "BGecWbXk1gN"),
    ("ICD10", "S50.1", "S50.1 Contusion of other and unspecified parts of forearm", "m7WC8DMrn4u"),
    ("ICD10", "S50.7", "S50.7 Multiple superficial injuries of forearm", "wMaHwH7NJMC"),
    ("ICD10", "S50.8", "S50.8 Other superficial injuries of forearm", "Kpah0RCJaRB"),
    ("ICD10", "S50.9", "S50.9 Superficial injury of forearm, unspecified", "Mdp5PLpmzJA"),
    ("ICD10", "S51", "S51 Open wound of forearm", "iGMvUtpbRVv"),
    ("ICD10", "S51.0", "S51.0 Open wound of elbow", "ZVcjhvw8vYj"),
    ("ICD10", "S51.7", "S51.7 Multiple open wounds of forearm", "u8FI8SiIvYS"),
    ("ICD10", "S51.8", "S51.8 Open wound of other parts of forearm", "UVTnYEcw3R3"),
    ("ICD10", "S51.9", "S51.9 Open wound of forearm, part unspecified", "lTmMHUPSTmL"),
    ("ICD10", "S52", "S52 Fracture of forearm", "nlw13UYsh0G"),
    ("ICD10", "S52.0", "S52.0 Fracture of upper end of ulna", "SYgn4PHWoXM"),
    ("ICD10", "S52.1", "S52.1 Fracture of upper end of radius", "gV4N0IynKXY"),
    ("ICD10", "S52.2", "S52.2 Fracture of shaft of ulna", "ehD1iNT4Z1m"),
    ("ICD10", "S52.3", "S52.3 Fracture of shaft of radius", "ix8EFbB8JF9"),
    ("ICD10", "S52.4", "S52.4 Fracture of shafts of both ulna and radius", "tLRVWRzLhbC"),
    ("ICD10", "S52.5", "S52.5 Fracture of lower end of radius", "hsgjVXPEhSg"),
    ("ICD10", "S52.6", "S52.6 Fracture of lower end of both ulna and radius", "dXD0ymMGsvA"),
    ("ICD10", "S52.7", "S52.7 Multiple fractures of forearm", "uVAtnCVtpqK"),
    ("ICD10", "S52.8", "S52.8 Fracture of other parts of forearm", "BKc2OJepTv0"),
    ("ICD10", "S52.9", "S52.9 Fracture of forearm, part unspecified", "U2Lhm2vYMAL"),
    ("ICD10", "S53", "S53 Dislocation, sprain and strain of joints and ligaments of elbow", "he1QKZHWKjx"),
    ("ICD10", "S53.0", "S53.0 Dislocation of radial head", "i1DcyWNIIIc"),
    ("ICD10", "S53.1", "S53.1 Dislocation of elbow, unspecified", "hfyDltATjb8"),
    ("ICD10", "S53.2", "S53.2 Traumatic rupture of radial collateral ligament", "MV11EzLIzz0"),
    ("ICD10", "S53.3", "S53.3 Traumatic rupture of ulnar collateral ligament", "vydesZcPxIy"),
    ("ICD10", "S53.4", "S53.4 Sprain and strain of elbow", "SuHdbJeANJX"),
    ("ICD10", "S54", "S54 Injury of nerves at forearm level", "WGqK6y8mvh9"),
    ("ICD10", "S54.0", "S54.0 Injury of ulnar nerve at forearm level", "lQbnI2kRxV4"),
    ("ICD10", "S54.1", "S54.1 Injury of median nerve at forearm level", "GGYnjC6VdwZ"),
    ("ICD10", "S54.2", "S54.2 Injury of radial nerve at forearm level", "vUZhgfW57Zl"),
    ("ICD10", "S54.3", "S54.3 Injury of cutaneous sensory nerve at forearm level", "twd4Ls4SguL"),
    ("ICD10", "S54.7", "S54.7 Injury of multiple nerves at forearm level", "OH30e4S4C4Z"),
    ("ICD10", "S54.8", "S54.8 Injury of other nerves at forearm level", "mdxuthpbvlb"),
    ("ICD10", "S54.9", "S54.9 Injury of unspecified nerve at forearm level", "rLxSdmspSsK"),
    ("ICD10", "S55", "S55 Injury of blood vessels at forearm level", "eOGA2Yhr2wW"),
    ("ICD10", "S55.0", "S55.0 Injury of ulnar artery at forearm level", "BmW3AkPqixP"),
    ("ICD10", "S55.1", "S55.1 Injury of radial artery at forearm level", "FJNK9YpAew2"),
    ("ICD10", "S55.2", "S55.2 Injury of vein at forearm level", "U29poFHxJ8i"),
    ("ICD10", "S55.7", "S55.7 Injury of multiple blood vessels at forearm level", "hwePXqyCmEh"),
    ("ICD10", "S55.8", "S55.8 Injury of other blood vessels at forearm level", "UKBGdLM1mJ2"),
    ("ICD10", "S55.9", "S55.9 Injury of unspecified blood vessel at forearm level", "wTN5yjfAtpz"),
    ("ICD10", "S56", "S56 Injury of muscle and tendon at forearm level", "VcqBAT6pKJ4"),
    ("ICD10", "S56.0", "S56.0 Injury of flexor muscle and tendon of thumb at forearm level", "z5NLOauIdI8"),
    ("ICD10", "S56.1", "S56.1 Injury of long flexor muscle and tendon of other finger(s) at forearm level", "F4iAzUHMSnS"),
    ("ICD10", "S56.2", "S56.2 Injury of other flexor muscle and tendon at forearm level", "W88cLJE2FHI"),
    ("ICD10", "S56.3", "S56.3 Injury of extensor or abductor muscles and tendons of thumb at forearm level", "j8MI7A7sr6C"),
    ("ICD10", "S56.4", "S56.4 Injury of extensor muscle and tendon of other finger(s) at forearm level", "gmVp6EwZLpz"),
    ("ICD10", "S56.5", "S56.5 Injury of other extensor muscle and tendon at forearm level", "VztpDtXxKr2"),
    ("ICD10", "S56.7", "S56.7 Injury of multiple muscles and tendons at forearm level", "E4OHAA5uccz"),
    ("ICD10", "S56.8", "S56.8 Injury of other and unspecified muscles and tendons at forearm level", "cTl9gLkVEBM"),
    ("ICD10", "S57", "S57 Crushing injury of forearm", "PEo5HQiZHKI"),
    ("ICD10", "S57.0", "S57.0 Crushing injury of elbow", "LC6HhLkMWsI"),
    ("ICD10", "S57.8", "S57.8 Crushing injury of other parts of forearm", "JpAIKlwTTMu"),
    ("ICD10", "S57.9", "S57.9 Crushing injury of forearm, part unspecified", "adBMrOUMjTB"),
    ("ICD10", "S58", "S58 Traumatic amputation of forearm", "LuxvxND3hy2"),
    ("ICD10", "S58.0", "S58.0 Traumatic amputation at elbow level", "l0fyYNAbPh4"),
    ("ICD10", "S58.1", "S58.1 Traumatic amputation at level between elbow and wrist", "yQPypdGz2aT"),
    ("ICD10", "S58.9", "S58.9 Traumatic amputation of forearm, level unspecified", "dRcTAv2sx3e"),
    ("ICD10", "S59", "S59 Other and unspecified injuries of forearm", "PU2pD0fMiA7"),
    ("ICD10", "S59.7", "S59.7 Multiple injuries of forearm", "ETgXkEBrGVo"),
    ("ICD10", "S59.8", "S59.8 Other specified injuries of forearm", "B6I3ZQgU9WO"),
    ("ICD10", "S59.9", "S59.9 Unspecified injury of forearm", "C77nkz4899d"),
    ("ICD10", "S60", "S60 Superficial injury of wrist and hand", "CwkW4Lc97qx"),
    ("ICD10", "S60.0", "S60.0 Contusion of finger(s) without damage to nail", "gc8STx6XGzM"),
    ("ICD10", "S60.1", "S60.1 Contusion of finger(s) with damage to nail", "XWOT54wJOZn"),
    ("ICD10", "S60.2", "S60.2 Contusion of other parts of wrist and hand", "uIj9jeTcXOZ"),
    ("ICD10", "S60.7", "S60.7 Multiple superficial injuries of wrist and hand", "KZ0NDLFMn0x"),
    ("ICD10", "S60.8", "S60.8 Other superficial injuries of wrist and hand", "beU4wln6sz6"),
    ("ICD10", "S60.9", "S60.9 Superficial injury of wrist and hand, unspecified", "ovY5VGLJdb5"),
    ("ICD10", "S61", "S61 Open wound of wrist and hand", "Kll22ghLj5n"),
    ("ICD10", "S61.0", "S61.0 Open wound of finger(s) without damage to nail", "V3dntwXbFzk"),
    ("ICD10", "S61.1", "S61.1 Open wound of finger(s) with damage to nail", "fnfKCayIaVe"),
    ("ICD10", "S61.7", "S61.7 Multiple open wounds of wrist and hand", "I8HNnIy7cm0"),
    ("ICD10", "S61.8", "S61.8 Open wound of other parts of wrist and hand", "rJiezS10Twq"),
    ("ICD10", "S61.9", "S61.9 Open wound of wrist and hand, part unspecified", "ncIpt5hVeqV"),
    ("ICD10", "S62", "S62 Fracture at wrist and hand level", "WfejkJEKI0M"),
    ("ICD10", "S62.0", "S62.0 Fracture of navicular [scaphoid] bone of hand", "YRQurm4clpN"),
    ("ICD10", "S62.1", "S62.1 Fracture of other carpal bone(s)", "fmTurs8DVxa"),
    ("ICD10", "S62.2", "S62.2 Fracture of first metacarpal bone", "lg5Z8xXDGuO"),
    ("ICD10", "S62.3", "S62.3 Fracture of other metacarpal bone", "LROL8bApDli"),
    ("ICD10", "S62.4", "S62.4 Multiple fractures of metacarpal bones", "Epxjk7xksdn"),
    ("ICD10", "S62.5", "S62.5 Fracture of thumb", "NtsGsMW9MPh"),
    ("ICD10", "S62.6", "S62.6 Fracture of other finger", "xSCVniFc4DT"),
    ("ICD10", "S62.7", "S62.7 Multiple fractures of fingers", "NiPP2OnpSdu"),
    ("ICD10", "S62.8", "S62.8 Fracture of other and unspecified parts of wrist and hand", "lDc8ZcQW7S4"),
    ("ICD10", "S63", "S63 Dislocation, sprain and strain of joints and ligaments at wrist and hand level", "LWMN95EsbJm"),
    ("ICD10", "S63.0", "S63.0 Dislocation of wrist", "jBrm68UZPoD"),
    ("ICD10", "S63.1", "S63.1 Dislocation of finger", "gVTlq86NViY"),
    ("ICD10", "S63.2", "S63.2 Multiple dislocations of fingers", "QGXqiVjAHQM"),
    ("ICD10", "S63.3", "S63.3 Traumatic rupture of ligament of wrist and carpus", "vdyJBuBu2cT"),
    ("ICD10", "S63.4", "S63.4 Traumatic rupture of ligament of finger at metacarpophalangeal and interphalangeal joint(s)", "NDQKGwo0Bh0"),
    ("ICD10", "S63.5", "S63.5 Sprain and strain of wrist", "voUlxtv1xrz"),
    ("ICD10", "S63.6", "S63.6 Sprain and strain of finger(s)", "Dih7coZ1P07"),
    ("ICD10", "S63.7", "S63.7 Sprain and strain of other and unspecified parts of hand", "f4sryancWrh"),
    ("ICD10", "S64", "S64 Injury of nerves at wrist and hand level", "pg1HwGnGZHH"),
    ("ICD10", "S64.0", "S64.0 Injury of ulnar nerve at wrist and hand level", "kiVaspjig6e"),
    ("ICD10", "S64.1", "S64.1 Injury of median nerve at wrist and hand level", "B40jHy9xFp2"),
    ("ICD10", "S64.2", "S64.2 Injury of radial nerve at wrist and hand level", "KAkCiC4AJYm"),
    ("ICD10", "S64.3", "S64.3 Injury of digital nerve of thumb", "GE5PJToVhSG"),
    ("ICD10", "S64.4", "S64.4 Injury of digital nerve of other finger", "PmjBnvJaoIJ"),
    ("ICD10", "S64.7", "S64.7 Injury of multiple nerves at wrist and hand level", "dXcXM6VRgM4"),
    ("ICD10", "S64.8", "S64.8 Injury of other nerves at wrist and hand level", "lEqtGlqqMDG"),
    ("ICD10", "S64.9", "S64.9 Injury of unspecified nerve at wrist and hand level", "rU9B4Ne9gte"),
    ("ICD10", "S65", "S65 Injury of blood vessels at wrist and hand level", "FcugUdqUU5f"),
    ("ICD10", "S65.0", "S65.0 Injury of ulnar artery at wrist and hand level", "RrD7plSRf0z"),
    ("ICD10", "S65.1", "S65.1 Injury of radial artery at wrist and hand level", "Ta7CcgwMYwp"),
    ("ICD10", "S65.2", "S65.2 Injury of superficial palmar arch", "yc222A3t7nN"),
    ("ICD10", "S65.3", "S65.3 Injury of deep palmar arch", "kNy3tOLaczy"),
    ("ICD10", "S65.4", "S65.4 Injury of blood vessel(s) of thumb", "cuI5REjly6J"),
    ("ICD10", "S65.5", "S65.5 Injury of blood vessel(s) of other finger", "NggiieVxKzc"),
    ("ICD10", "S65.7", "S65.7 Injury of multiple blood vessels at wrist and hand level", "wQhJFn8tCdY"),
    ("ICD10", "S65.8", "S65.8 Injury of other blood vessels at wrist and hand level", "nla3acetNx7"),
    ("ICD10", "S65.9", "S65.9 Injury of unspecified blood vessel at wrist and hand level", "zWXRToppjC7"),
    ("ICD10", "S66", "S66 Injury of muscle and tendon at wrist and hand level", "bsSiUxssley"),
    ("ICD10", "S66.0", "S66.0 Injury of long flexor muscle and tendon of thumb at wrist and hand level", "Vg7D6REGDdN"),
    ("ICD10", "S66.1", "S66.1 Injury of flexor muscle and tendon of other finger at wrist and hand level", "UQQsT6LZJWp"),
    ("ICD10", "S66.2", "S66.2 Injury of extensor muscle and tendon of thumb at wrist and hand level", "w5nPvzREJ4M"),
    ("ICD10", "S66.3", "S66.3 Injury of extensor muscle and tendon of other finger at wrist and hand level", "sq8KpEcvXnk"),
    ("ICD10", "S66.4", "S66.4 Injury of intrinsic muscle and tendon of thumb at wrist and hand level", "DQfluWddjHL"),
    ("ICD10", "S66.5", "S66.5 Injury of intrinsic muscle and tendon of other finger at wrist and hand level", "fQkTDzk9vV7"),
    ("ICD10", "S66.6", "S66.6 Injury of multiple flexor muscles and tendons at wrist and hand level", "w3IP2qDgZHm"),
    ("ICD10", "S66.7", "S66.7 Injury of multiple extensor muscles and tendons at wrist and hand level", "jm7pmdUcGS1"),
    ("ICD10", "S66.8", "S66.8 Injury of other muscles and tendons at wrist and hand level", "mu3zm4IwGYl"),
    ("ICD10", "S66.9", "S66.9 Injury of unspecified muscle and tendon at wrist and hand level", "eNpJFRvcD4h"),
    ("ICD10", "S67", "S67 Crushing injury of wrist and hand", "dMsHmL9xWM6"),
    ("ICD10", "S67.0", "S67.0 Crushing injury of thumb and other finger(s)", "mLDrBLBXjsz"),
    ("ICD10", "S67.8", "S67.8 Crushing injury of other and unspecified parts of wrist and hand", "Md3A3pXBaYa"),
    ("ICD10", "S68", "S68 Traumatic amputation of wrist and hand", "B6ctubZvdwi"),
    ("ICD10", "S68.0", "S68.0 Traumatic amputation of thumb (complete)(partial)", "ER2HqTIa9aI"),
    ("ICD10", "S68.1", "S68.1 Traumatic amputation of other single finger (complete)(partial)", "ufsrwAGPpqz"),
    ("ICD10", "S68.2", "S68.2 Traumatic amputation of two or more fingers alone (complete)(partial)", "pIL35VFc2s7"),
    ("ICD10", "S68.3", "S68.3 Combined traumatic amputation of (part of) finger(s) with other parts of wrist and hand", "JmvALQkG3Qz"),
    ("ICD10", "S68.4", "S68.4 Traumatic amputation of hand at wrist level", "G8WBUeyT35r"),
    ("ICD10", "S68.8", "S68.8 Traumatic amputation of other parts of wrist and hand", "DDsBseastxf"),
    ("ICD10", "S68.9", "S68.9 Traumatic amputation of wrist and hand, level unspecified", "U5zZ0sceZeO"),
    ("ICD10", "S69", "S69 Other and unspecified injuries of wrist and hand", "jy7W5D3Suqz"),
    ("ICD10", "S69.7", "S69.7 Multiple injuries of wrist and hand", "dQ0ExvJXrkN"),
    ("ICD10", "S69.8", "S69.8 Other specified injuries of wrist and hand", "mHZcACFzYa2"),
    ("ICD10", "S69.9", "S69.9 Unspecified injury of wrist and hand", "hZHFNH6x1Hq"),
    ("ICD10", "S70", "S70 Superficial injury of hip and thigh", "Ey70WxjWMpq"),
    ("ICD10", "S70.0", "S70.0 Contusion of hip", "oLQLd9NOwz5"),
    ("ICD10", "S70.1", "S70.1 Contusion of thigh", "q1H0PfZbQ1z"),
    ("ICD10", "S70.7", "S70.7 Multiple superficial injuries of hip and thigh", "zmTt1GrUwR0"),
    ("ICD10", "S70.8", "S70.8 Other superficial injuries of hip and thigh", "Cf526mxPdms"),
    ("ICD10", "S70.9", "S70.9 Superficial injury of hip and thigh, unspecified", "gqKcAIhTjwC"),
    ("ICD10", "S71", "S71 Open wound of hip and thigh", "hwQRGI6e4c4"),
    ("ICD10", "S71.0", "S71.0 Open wound of hip", "sGiP0PHSbyN"),
    ("ICD10", "S71.1", "S71.1 Open wound of thigh", "YU1L78KlLu0"),
    ("ICD10", "S71.7", "S71.7 Multiple open wounds of hip and thigh", "gU1LCKaNjpz"),
    ("ICD10", "S71.8", "S71.8 Open wound of other and unspecified parts of pelvic girdle", "k2CVJ5JEUHK"),
    ("ICD10", "S72", "S72 Fracture of femur", "N3loPaqcxn7"),
    ("ICD10", "S72.0", "S72.0 Fracture of neck of femur", "oSKRiyWwbVg"),
    ("ICD10", "S72.1", "S72.1 Pertrochanteric fracture", "t25cStb1pGB"),
    ("ICD10", "S72.2", "S72.2 Subtrochanteric fracture", "fJEDB0zygaS"),
    ("ICD10", "S72.3", "S72.3 Fracture of shaft of femur", "G6S8CQxTYHE"),
    ("ICD10", "S72.4", "S72.4 Fracture of lower end of femur", "odGlXIPnjID"),
    ("ICD10", "S72.7", "S72.7 Multiple fractures of femur", "cpC5HgyqrGN"),
    ("ICD10", "S72.8", "S72.8 Fractures of other parts of femur", "PU7i3mC5dwc"),
    ("ICD10", "S72.9", "S72.9 Fracture of femur, part unspecified", "jgDhmqkzSbn"),
    ("ICD10", "S73", "S73 Dislocation, sprain and strain of joint and ligaments of hip", "B34kY3CS79z"),
    ("ICD10", "S73.0", "S73.0 Dislocation of hip", "Wb7E86j7vHz"),
    ("ICD10", "S73.1", "S73.1 Sprain and strain of hip", "Zcg9nKyFABO"),
    ("ICD10", "S74", "S74 Injury of nerves at hip and thigh level", "xlJFVcllrzK"),
    ("ICD10", "S74.0", "S74.0 Injury of sciatic nerve at hip and thigh level", "H5a7dIP9LcS"),
    ("ICD10", "S74.1", "S74.1 Injury of femoral nerve at hip and thigh level", "E0WlCxliYnl"),
    ("ICD10", "S74.2", "S74.2 Injury of cutaneous sensory nerve at hip and thigh level", "GKFCyzJfHgY"),
    ("ICD10", "S74.7", "S74.7 Injury of multiple nerves at hip and thigh level", "NUfSviq2f49"),
    ("ICD10", "S74.8", "S74.8 Injury of other nerves at hip and thigh level", "DHWnIcrHHZN"),
    ("ICD10", "S74.9", "S74.9 Injury of unspecified nerve at hip and thigh level", "MAgzRacrs1L"),
    ("ICD10", "S75", "S75 Injury of blood vessels at hip and thigh level", "e7fX2FcjjBL"),
    ("ICD10", "S75.0", "S75.0 Injury of femoral artery", "DNxT1YiDNar"),
    ("ICD10", "S75.1", "S75.1 Injury of femoral vein at hip and thigh level", "DVIQqdpYbSY"),
    ("ICD10", "S75.2", "S75.2 Injury of greater saphenous vein at hip and thigh level", "e3mVZHp2uvB"),
    ("ICD10", "S75.7", "S75.7 Injury of multiple blood vessels at hip and thigh level", "mKaD4EDytJ8"),
    ("ICD10", "S75.8", "S75.8 Injury of other blood vessels at hip and thigh level", "Vw9guLVXtVJ"),
    ("ICD10", "S75.9", "S75.9 Injury of unspecified blood vessel at hip and thigh level", "en4TPjY7k3y"),
    ("ICD10", "S76", "S76 Injury of muscle and tendon at hip and thigh level", "fmyixnpkqmc"),
    ("ICD10", "S76.0", "S76.0 Injury of muscle and tendon of hip", "UGsdbr7WIin"),
    ("ICD10", "S76.1", "S76.1 Injury of quadriceps muscle and tendon", "gf4GWw2Q1kE"),
    ("ICD10", "S76.2", "S76.2 Injury of adductor muscle and tendon of thigh", "GkYu23dxTCT"),
    ("ICD10", "S76.3", "S76.3 Injury of muscle and tendon of the posterior muscle group at thigh level", "IasfMQO0d8W"),
    ("ICD10", "S76.4", "S76.4 Injury of other and unspecified muscles and tendons at thigh level", "s21lFFgGLxN"),
    ("ICD10", "S76.7", "S76.7 Injury of multiple muscles and tendons at hip and thigh level", "YNRdblRmRNL"),
    ("ICD10", "S77", "S77 Crushing injury of hip and thigh", "ewQoWvW6O95"),
    ("ICD10", "S77.0", "S77.0 Crushing injury of hip", "nHXYf0192wk"),
    ("ICD10", "S77.1", "S77.1 Crushing injury of thigh", "Z56UZjFXYvK"),
    ("ICD10", "S77.2", "S77.2 Crushing injury of hip with thigh", "IMDD4DQfqmU"),
    ("ICD10", "S78", "S78 Traumatic amputation of hip and thigh", "RTPhtOLUYlT"),
    ("ICD10", "S78.0", "S78.0 Traumatic amputation at hip joint", "LbJ9qz4Hptk"),
    ("ICD10", "S78.1", "S78.1 Traumatic amputation at level between hip and knee", "f4rSOssHniI"),
    ("ICD10", "S78.9", "S78.9 Traumatic amputation of hip and thigh, level unspecified", "co6PjvRbtEJ"),
    ("ICD10", "S79", "S79 Other and unspecified injuries of hip and thigh", "XICS05WuRlD"),
    ("ICD10", "S79.7", "S79.7 Multiple injuries of hip and thigh", "Hu1DulgDAwi"),
    ("ICD10", "S79.8", "S79.8 Other specified injuries of hip and thigh", "UZpToyHi8yO"),
    ("ICD10", "S79.9", "S79.9 Unspecified injury of hip and thigh", "Np1lG2X2Fw4"),
    ("ICD10", "S80", "S80 Superficial injury of lower leg", "J3RFWnp3o5j"),
    ("ICD10", "S80.0", "S80.0 Contusion of knee", "cWJamdtgMvx"),
    ("ICD10", "S80.1", "S80.1 Contusion of other and unspecified parts of lower leg", "tz1NXCmvBlv"),
    ("ICD10", "S80.7", "S80.7 Multiple superficial injuries of lower leg", "pb4Woor0bwW"),
    ("ICD10", "S80.8", "S80.8 Other superficial injuries of lower leg", "B2XV7prTm5n"),
    ("ICD10", "S80.9", "S80.9 Superficial injury of lower leg, unspecified", "JUEjoFTKDAS"),
    ("ICD10", "S81", "S81 Open wound of lower leg", "dANtSjKNAwX"),
    ("ICD10", "S81.0", "S81.0 Open wound of knee", "H0dPwFh4Jeg"),
    ("ICD10", "S81.7", "S81.7 Multiple open wounds of lower leg", "zJl1zdKuvOo"),
    ("ICD10", "S81.8", "S81.8 Open wound of other parts of lower leg", "O3CZtfnSkYT"),
    ("ICD10", "S81.9", "S81.9 Open wound of lower leg, part unspecified", "Ts426pSjyxU"),
    ("ICD10", "S82", "S82 Fracture of lower leg, including ankle", "FC1ALKaBHmq"),
    ("ICD10", "S82.0", "S82.0 Fracture of patella", "skKioLHtwI3"),
    ("ICD10", "S82.1", "S82.1 Fracture of upper end of tibia", "C10ZBInSxQN"),
    ("ICD10", "S82.2", "S82.2 Fracture of shaft of tibia", "G1L0Pbdpuum"),
    ("ICD10", "S82.3", "S82.3 Fracture of lower end of tibia", "eCenD6FsBgv"),
    ("ICD10", "S82.4", "S82.4 Fracture of fibula alone", "XCAWo9EIbYZ"),
    ("ICD10", "S82.5", "S82.5 Fracture of medial malleolus", "DtxQbJKMuNw"),
    ("ICD10", "S82.6", "S82.6 Fracture of lateral malleolus", "uKmhguf06mZ"),
    ("ICD10", "S82.7", "S82.7 Multiple fractures of lower leg", "ocySoYIePwE"),
    ("ICD10", "S82.8", "S82.8 Fractures of other parts of lower leg", "AOjhiJRnoUt"),
    ("ICD10", "S82.9", "S82.9 Fracture of lower leg, part unspecified", "cFgGqzMAnXN"),
    ("ICD10", "S83", "S83 Dislocation, sprain and strain of joints and ligaments of knee", "a0HqMUiDK1u"),
    ("ICD10", "S83.0", "S83.0 Dislocation of patella", "MTORk4GUDlm"),
    ("ICD10", "S83.1", "S83.1 Dislocation of knee", "cLBIl30RHha"),
    ("ICD10", "S83.2", "S83.2 Tear of meniscus, current", "Ld7uiiUKGj6"),
    ("ICD10", "S83.3", "S83.3 Tear of articular cartilage of knee, current", "LI7QHjL4dO8"),
    ("ICD10", "S83.4", "S83.4 Sprain and strain involving (fibular)(tibial) collateral ligament of knee", "dPrCSa0A6Yb"),
    ("ICD10", "S83.5", "S83.5 Sprain and strain involving (anterior)(posterior) cruciate ligament of knee", "pEjcL0RCAeg"),
    ("ICD10", "S83.6", "S83.6 Sprain and strain of other and unspecified parts of knee", "bFR6ORmpP9e"),
    ("ICD10", "S83.7", "S83.7 Injury to multiple structures of knee", "KvjUzfBD1BS"),
    ("ICD10", "S84", "S84 Injury of nerves at lower leg level", "ECOKahonOjc"),
    ("ICD10", "S84.0", "S84.0 Injury of tibial nerve at lower leg level", "RejkPfgyxhR"),
    ("ICD10", "S84.1", "S84.1 Injury of peroneal nerve at lower leg level", "bMKWzKebkeG"),
    ("ICD10", "S84.2", "S84.2 Injury of cutaneous sensory nerve at lower leg level", "xS9bXk27LmG"),
    ("ICD10", "S84.7", "S84.7 Injury of multiple nerves at lower leg level", "ewVIdVmR3n7"),
    ("ICD10", "S84.8", "S84.8 Injury of other nerves at lower leg level", "PvxyGL2ekPJ"),
    ("ICD10", "S84.9", "S84.9 Injury of unspecified nerve at lower leg level", "fd96C1KTwRn"),
    ("ICD10", "S85", "S85 Injury of blood vessels at lower leg level", "TxyKIPWu5Eo"),
    ("ICD10", "S85.0", "S85.0 Injury of popliteal artery", "ZlvlqxqFs7h"),
    ("ICD10", "S85.1", "S85.1 Injury of (anterior)(posterior) tibial artery", "YTTQwspPuza");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "S85.2", "S85.2 Injury of peroneal artery", "ZCUMh7otmYP"),
    ("ICD10", "S85.3", "S85.3 Injury of greater saphenous vein at lower leg level", "sQ3YzXv9HoF"),
    ("ICD10", "S85.4", "S85.4 Injury of lesser saphenous vein at lower leg level", "TBZpJwJhEeB"),
    ("ICD10", "S85.5", "S85.5 Injury of popliteal vein", "M0n6pBz9Rmh"),
    ("ICD10", "S85.7", "S85.7 Injury of multiple blood vessels at lower leg level", "cA7tsMGkyva"),
    ("ICD10", "S85.8", "S85.8 Injury of other blood vessels at lower leg level", "Zwu4cMA4oHC"),
    ("ICD10", "S85.9", "S85.9 Injury of unspecified blood vessel at lower leg level", "xBSPpd56jyZ"),
    ("ICD10", "S86", "S86 Injury of muscle and tendon at lower leg level", "JuaHqMBedk2"),
    ("ICD10", "S86.0", "S86.0 Injury of Achilles tendon", "iar4qK2gbNv"),
    ("ICD10", "S86.1", "S86.1 Injury of other muscle(s) and tendon(s) of posterior muscle group at lower leg level", "ed8jRPhPBTj"),
    ("ICD10", "S86.2", "S86.2 Injury of muscle(s) and tendon(s) of anterior muscle group at lower leg level", "wrvaSlKPEDk"),
    ("ICD10", "S86.3", "S86.3 Injury of muscle(s) and tendon(s) of peroneal muscle group at lower leg level", "klMPL06AIRW"),
    ("ICD10", "S86.7", "S86.7 Injury of multiple muscles and tendons at lower leg level", "OZsA0Vw1v8l"),
    ("ICD10", "S86.8", "S86.8 Injury of other muscles and tendons at lower leg level", "AuG9UqmXeQH"),
    ("ICD10", "S86.9", "S86.9 Injury of unspecified muscle and tendon at lower leg level", "WDGWNfX2U6y"),
    ("ICD10", "S87", "S87 Crushing injury of lower leg", "dD7pPint4yi"),
    ("ICD10", "S87.0", "S87.0 Crushing injury of knee", "wSTJDvRXIRp"),
    ("ICD10", "S87.8", "S87.8 Crushing injury of other and unspecified parts of lower leg", "I6bRQpzAjzn"),
    ("ICD10", "S88", "S88 Traumatic amputation of lower leg", "DqecYtaxtJj"),
    ("ICD10", "S88.0", "S88.0 Traumatic amputation at knee level", "sZrToZjeh1E"),
    ("ICD10", "S88.1", "S88.1 Traumatic amputation at level between knee and ankle", "YoF3a2wnURF"),
    ("ICD10", "S88.9", "S88.9 Traumatic amputation of lower leg, level unspecified", "oYbD8UhC4HK"),
    ("ICD10", "S89", "S89 Other and unspecified injuries of lower leg", "CcECJPQ3il5"),
    ("ICD10", "S89.7", "S89.7 Multiple injuries of lower leg", "ZFiipRtlHTJ"),
    ("ICD10", "S89.8", "S89.8 Other specified injuries of lower leg", "djYjWmY4j49"),
    ("ICD10", "S89.9", "S89.9 Unspecified injury of lower leg", "KEE9EFi9VV7"),
    ("ICD10", "S90", "S90 Superficial injury of ankle and foot", "rC6iiDZIdMh"),
    ("ICD10", "S90.0", "S90.0 Contusion of ankle", "U8us9seKtnn"),
    ("ICD10", "S90.1", "S90.1 Contusion of toe(s) without damage to nail", "nZbOX7KPKMO"),
    ("ICD10", "S90.2", "S90.2 Contusion of toe(s) with damage to nail", "bNV6IlZePrO"),
    ("ICD10", "S90.3", "S90.3 Contusion of other and unspecified parts of foot", "JMkNZXzoioG"),
    ("ICD10", "S90.7", "S90.7 Multiple superficial injuries of ankle and foot", "adcnabnVkXb"),
    ("ICD10", "S90.8", "S90.8 Other superficial injuries of ankle and foot", "QR7eNpJ2x75"),
    ("ICD10", "S90.9", "S90.9 Superficial injury of ankle and foot, unspecified", "jnwWrIdNTnW"),
    ("ICD10", "S91", "S91 Open wound of ankle and foot", "iOdIjDEdzDF"),
    ("ICD10", "S91.0", "S91.0 Open wound of ankle", "VED49qjOBBl"),
    ("ICD10", "S91.1", "S91.1 Open wound of toe(s) without damage to nail", "ws0GpedegfV"),
    ("ICD10", "S91.2", "S91.2 Open wound of toe(s) with damage to nail", "GkaKVzWerd5"),
    ("ICD10", "S91.3", "S91.3 Open wound of other parts of foot", "UH1NoAdEvfg"),
    ("ICD10", "S91.7", "S91.7 Multiple open wounds of ankle and foot", "LCMcZxKYIxe"),
    ("ICD10", "S92", "S92 Fracture of foot, except ankle", "SqzyuQHl1iJ"),
    ("ICD10", "S92.0", "S92.0 Fracture of calcaneus", "YnyQEU7l1as"),
    ("ICD10", "S92.1", "S92.1 Fracture of talus", "WN94NfPVAHf"),
    ("ICD10", "S92.2", "S92.2 Fracture of other tarsal bone(s)", "EZp2DSXqUgd"),
    ("ICD10", "S92.3", "S92.3 Fracture of metatarsal bone", "bKVkQk8MkNs"),
    ("ICD10", "S92.4", "S92.4 Fracture of great toe", "SfP7ZPejbCl"),
    ("ICD10", "S92.5", "S92.5 Fracture of other toe", "ZyPo9yhfOur"),
    ("ICD10", "S92.7", "S92.7 Multiple fractures of foot", "Sl3zM9Ptz2c"),
    ("ICD10", "S92.9", "S92.9 Fracture of foot, unspecified", "EOpGbwyF1ZF"),
    ("ICD10", "S93", "S93 Dislocation, sprain and strain of joints and ligaments at ankle and foot level", "t5D40yxfGX6"),
    ("ICD10", "S93.0", "S93.0 Dislocation of ankle joint", "qQYZ9QUFm2Z"),
    ("ICD10", "S93.1", "S93.1 Dislocation of toe(s)", "oVp0R2h1nW3"),
    ("ICD10", "S93.2", "S93.2 Rupture of ligaments at ankle and foot level", "E4X9WBJSPQ6"),
    ("ICD10", "S93.3", "S93.3 Dislocation of other and unspecified parts of foot", "xJ8ZL2hYwgs"),
    ("ICD10", "S93.4", "S93.4 Sprain and strain of ankle", "wrpJnsVmcHM"),
    ("ICD10", "S93.5", "S93.5 Sprain and strain of toe(s)", "c6AM6MZMFuW"),
    ("ICD10", "S93.6", "S93.6 Sprain and strain of other and unspecified parts of foot", "Qx96FvDsOaS"),
    ("ICD10", "S94", "S94 Injury of nerves at ankle and foot level", "F6gy7OiO0od"),
    ("ICD10", "S94.0", "S94.0 Injury of lateral plantar nerve", "BGySxmnRsBS"),
    ("ICD10", "S94.1", "S94.1 Injury of medial plantar nerve", "Y2IhMWoWZeQ"),
    ("ICD10", "S94.2", "S94.2 Injury of deep peroneal nerve at ankle and foot level", "XjJrC6vJqGQ"),
    ("ICD10", "S94.3", "S94.3 Injury of cutaneous sensory nerve at ankle and foot level", "QtJdn6oO47R"),
    ("ICD10", "S94.7", "S94.7 Injury of multiple nerves at ankle and foot level", "sFNI9nTl3nQ"),
    ("ICD10", "S94.8", "S94.8 Injury of other nerves at ankle and foot level", "JOxlhmJr2ky"),
    ("ICD10", "S94.9", "S94.9 Injury of unspecified nerve at ankle and foot level", "chncEt7YnJC"),
    ("ICD10", "S95", "S95 Injury of blood vessels at ankle and foot level", "RjfgU2zrw4o"),
    ("ICD10", "S95.0", "S95.0 Injury of dorsal artery of foot", "H47qamC62Kz"),
    ("ICD10", "S95.1", "S95.1 Injury of plantar artery of foot", "s9H2ZZdOQ54"),
    ("ICD10", "S95.2", "S95.2 Injury of dorsal vein of foot", "sEw6hSs4iu7"),
    ("ICD10", "S95.7", "S95.7 Injury of multiple blood vessels at ankle and foot level", "cQGgo27E2iQ"),
    ("ICD10", "S95.8", "S95.8 Injury of other blood vessels at ankle and foot level", "vzYutHxhi74"),
    ("ICD10", "S95.9", "S95.9 Injury of unspecified blood vessel at ankle and foot level", "enwScvvKNbi"),
    ("ICD10", "S96", "S96 Injury of muscle and tendon at ankle and foot level", "uUCZ0AkB1ro"),
    ("ICD10", "S96.0", "S96.0 Injury of muscle and tendon of long flexor muscle of toe at ankle and foot level", "Kkef7sbqtJC"),
    ("ICD10", "S96.1", "S96.1 Injury of muscle and tendon of long extensor muscle of toe at ankle and foot level", "piOons524yc"),
    ("ICD10", "S96.2", "S96.2 Injury of intrinsic muscle and tendon at ankle and foot level", "Sn3kC9xLznw"),
    ("ICD10", "S96.7", "S96.7 Injury of multiple muscles and tendons at ankle and foot level", "efvejaRN3EY"),
    ("ICD10", "S96.8", "S96.8 Injury of other muscles and tendons at ankle and foot level", "Sqr1yDNUFiC"),
    ("ICD10", "S96.9", "S96.9 Injury of unspecified muscle and tendon at ankle and foot level", "lZDbMx3GcqZ"),
    ("ICD10", "S97", "S97 Crushing injury of ankle and foot", "hT2sCjqSXoA"),
    ("ICD10", "S97.0", "S97.0 Crushing injury of ankle", "QktffTLetk6"),
    ("ICD10", "S97.1", "S97.1 Crushing injury of toe(s)", "AJVvr9gvIwN"),
    ("ICD10", "S97.8", "S97.8 Crushing injury of other parts of ankle and foot", "sReSG91L1PR"),
    ("ICD10", "S98", "S98 Traumatic amputation of ankle and foot", "uM8Q1rvXA9U"),
    ("ICD10", "S98.0", "S98.0 Traumatic amputation of foot at ankle level", "vKsMGXk3cMV"),
    ("ICD10", "S98.1", "S98.1 Traumatic amputation of one toe", "kbqzsvSAo9a"),
    ("ICD10", "S98.2", "S98.2 Traumatic amputation of two or more toes", "Mo5o6Q2l1vC"),
    ("ICD10", "S98.3", "S98.3 Traumatic amputation of other parts of foot", "xI3CJSrXKD9"),
    ("ICD10", "S98.4", "S98.4 Traumatic amputation of foot, level unspecified", "N4423UJSUvZ"),
    ("ICD10", "S99", "S99 Other and unspecified injuries of ankle and foot", "dAwV5OkAMs8"),
    ("ICD10", "S99.7", "S99.7 Multiple injuries of ankle and foot", "LNYfyTcdVWK"),
    ("ICD10", "S99.8", "S99.8 Other specified injuries of ankle and foot", "WzpvWreQgfD"),
    ("ICD10", "S99.9", "S99.9 Unspecified injury of ankle and foot", "CX5k7k5Jgwy");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "T00", "T00 Superficial injuries involving multiple body regions", "ZETkFWCwHun"),
    ("ICD10", "T00.0", "T00.0 Superficial injuries involving head with neck", "c3HHWKJR6VP"),
    ("ICD10", "T00.1", "T00.1 Superficial injuries involving thorax with abdomen, lower back and pelvis", "KVNUjX5ylgC"),
    ("ICD10", "T00.2", "T00.2 Superficial injuries involving multiple regions of upper limb(s)", "z12pbH8zOP9"),
    ("ICD10", "T00.3", "T00.3 Superficial injuries involving multiple regions of lower limb(s)", "cGbDLswTlAy"),
    ("ICD10", "T00.6", "T00.6 Superficial injuries involving multiple regions of upper limb(s) with lower limb(s)", "db9sIi6yfhM"),
    ("ICD10", "T00.8", "T00.8 Superficial injuries involving other combinations of body regions", "c4wpFsvDPdw"),
    ("ICD10", "T00.9", "T00.9 Multiple superficial injuries, unspecified", "Vpwj3nxTWQ0"),
    ("ICD10", "T01", "T01 Open wounds involving multiple body regions", "o2jSmX6Um19"),
    ("ICD10", "T01.0", "T01.0 Open wounds involving head with neck", "lC0aTSI7Xxv"),
    ("ICD10", "T01.1", "T01.1 Open wounds involving thorax with abdomen, lower back and pelvis", "OyY8Ddmk7Qj"),
    ("ICD10", "T01.2", "T01.2 Open wounds involving multiple regions of upper limb(s)", "bX4LkUqtafg"),
    ("ICD10", "T01.3", "T01.3 Open wounds involving multiple regions of lower limb(s)", "bUIMra6pLR7"),
    ("ICD10", "T01.6", "T01.6 Open wounds involving multiple regions of upper limb(s) with lower limb(s)", "TP8gn1SvVKI"),
    ("ICD10", "T01.8", "T01.8 Open wounds involving other combinations of body regions", "i3mm2ci46KY"),
    ("ICD10", "T01.9", "T01.9 Multiple open wounds, unspecified", "YfQUFrfxRbo"),
    ("ICD10", "T02", "T02 Fractures involving multiple body regions", "CqgvU3UdK7M"),
    ("ICD10", "T02.0", "T02.0 Fractures involving head with neck", "oPx99CTiFa2"),
    ("ICD10", "T02.1", "T02.1 Fractures involving thorax with lower back and pelvis", "kdjj0ykT0gI"),
    ("ICD10", "T02.2", "T02.2 Fractures involving multiple regions of one upper limb", "hDFNHb0lmiA"),
    ("ICD10", "T02.3", "T02.3 Fractures involving multiple regions of one lower limb", "T5UBs5AccPl"),
    ("ICD10", "T02.4", "T02.4 Fractures involving multiple regions of both upper limbs", "X9WqrK85zvF"),
    ("ICD10", "T02.5", "T02.5 Fractures involving multiple regions of both lower limbs", "rT0JmfzbRfi"),
    ("ICD10", "T02.6", "T02.6 Fractures involving multiple regions of upper limb(s) with lower limb(s)", "p7RtobDgP4h"),
    ("ICD10", "T02.7", "T02.7 Fractures involving thorax with lower back and pelvis with limb(s)", "llD5okQYNLB"),
    ("ICD10", "T02.8", "T02.8 Fractures involving other combinations of body regions", "BgbyttINyx1"),
    ("ICD10", "T02.9", "T02.9 Multiple fractures, unspecified", "JnVKr45hQdP"),
    ("ICD10", "T03", "T03 Dislocations, sprains and strains involving multiple body regions", "LmsZ9EJ0uGz"),
    ("ICD10", "T03.0", "T03.0 Dislocations, sprains and strains involving head with neck", "qmwxPWCGoRU"),
    ("ICD10", "T03.1", "T03.1 Dislocations, sprains and strains involving thorax with lower back and pelvis", "wVRi1j4SDj5"),
    ("ICD10", "T03.2", "T03.2 Dislocations, sprains and strains involving multiple regions of upper limb(s)", "T02lUp6JqRM"),
    ("ICD10", "T03.3", "T03.3 Dislocations, sprains and strains involving multiple regions of lower limb(s)", "xRC3bFzjyjE"),
    ("ICD10", "T03.4", "T03.4 Dislocations, sprains and strains involving multiple regions of upper limb(s) with lower limb(s)", "bwJ6JjJZxKv"),
    ("ICD10", "T03.8", "T03.8 Dislocations, sprains and strains involving other combinations of body regions", "g8kEarjQ9Pj"),
    ("ICD10", "T03.9", "T03.9 Multiple dislocations, sprains and strains, unspecified", "Vti2VN6o8ot"),
    ("ICD10", "T04", "T04 Crushing injuries involving multiple body regions", "qcQFemixh7i"),
    ("ICD10", "T04.0", "T04.0 Crushing injuries involving head with neck", "KQxjXqxYpXM"),
    ("ICD10", "T04.1", "T04.1 Crushing injuries involving thorax with abdomen, lower back and pelvis", "idv5GkRWLo6"),
    ("ICD10", "T04.2", "T04.2 Crushing injuries involving multiple regions of upper limb(s)", "IYDlcSqMn4G"),
    ("ICD10", "T04.3", "T04.3 Crushing injuries involving multiple regions of lower limb(s)", "pOHKvRVNgj7"),
    ("ICD10", "T04.4", "T04.4 Crushing injuries involving multiple regions of upper limb(s) with lower limb(s)", "RQkFsz7lgtB"),
    ("ICD10", "T04.7", "T04.7 Crushing injuries of thorax with abdomen, lower back and pelvis with limb(s)", "d5rH60gjxpX"),
    ("ICD10", "T04.8", "T04.8 Crushing injuries involving other combinations of body regions", "RXCnuDJr4kG"),
    ("ICD10", "T04.9", "T04.9 Multiple crushing injuries, unspecified", "UEWMdmqoMjc"),
    ("ICD10", "T05", "T05 Traumatic amputations involving multiple body regions", "j4WjxVx006G"),
    ("ICD10", "T05.0", "T05.0 Traumatic amputation of both hands", "rfaFSqgvLTq"),
    ("ICD10", "T05.1", "T05.1 Traumatic amputation of one hand and other arm [any level, except hand]", "So0IV9WEaG9"),
    ("ICD10", "T05.2", "T05.2 Traumatic amputation of both arms [any level]", "gGLFHz2pIMU"),
    ("ICD10", "T05.3", "T05.3 Traumatic amputation of both feet", "LbuxZ1U3Vgk"),
    ("ICD10", "T05.4", "T05.4 Traumatic amputation of one foot and other leg [any level, except foot]", "WuT90SNDVyX"),
    ("ICD10", "T05.5", "T05.5 Traumatic amputation of both legs [any level]", "yVqesY8dmYB"),
    ("ICD10", "T05.6", "T05.6 Traumatic amputation of upper and lower limbs, any combination [any level]", "PuYJ2D7qqzv"),
    ("ICD10", "T05.8", "T05.8 Traumatic amputations involving other combinations of body regions", "LcKY8TQTgRN"),
    ("ICD10", "T05.9", "T05.9 Multiple traumatic amputations, unspecified", "rIBnKhlgZQ8"),
    ("ICD10", "T06", "T06 Other injuries involving multiple body regions, not elsewhere classified", "JlcFR29akCN"),
    ("ICD10", "T06.0", "T06.0 Injuries of brain and cranial nerves with injuries of nerves and spinal cord at neck level", "HoObnHiL6sl"),
    ("ICD10", "T06.1", "T06.1 Injuries of nerves and spinal cord involving other multiple body regions", "jkN7LBaMdtq"),
    ("ICD10", "T06.2", "T06.2 Injuries of nerves involving multiple body regions", "e7DIZAIFg6O"),
    ("ICD10", "T06.3", "T06.3 Injuries of blood vessels involving multiple body regions", "iwVrSxze5iI"),
    ("ICD10", "T06.4", "T06.4 Injuries of muscles and tendons involving multiple body regions", "pmZJAZmRkNG"),
    ("ICD10", "T06.5", "T06.5 Injuries of intrathoracic organs with intra-abdominal and pelvic organs", "aUzd7YUEnzP"),
    ("ICD10", "T06.8", "T06.8 Other specified injuries involving multiple body regions", "ddbiGGnGEg8"),
    ("ICD10", "T07", "T07 Unspecified multiple injuries", "uBnfaD4M2GO"),
    ("ICD10", "T08", "T08 Fracture of spine, level unspecified", "M4AnVe0d8GR"),
    ("ICD10", "T09", "T09 Other injuries of spine and trunk, level unspecified", "jikdhwTusuW"),
    ("ICD10", "T09.0", "T09.0 Superficial injury of trunk, level unspecified", "teaoSsNsLtO"),
    ("ICD10", "T09.1", "T09.1 Open wound of trunk, level unspecified", "AVfX6dj5ult"),
    ("ICD10", "T09.2", "T09.2 Dislocation, sprain and strain of unspecified joint and ligament of trunk", "PZsWhXk0z6Y"),
    ("ICD10", "T09.3", "T09.3 Injury of spinal cord, level unspecified", "zGPiKc6CGZx"),
    ("ICD10", "T09.4", "T09.4 Injury of unspecified nerve, spinal nerve root and plexus of trunk", "e3UgEbKee0B"),
    ("ICD10", "T09.5", "T09.5 Injury of unspecified muscle and tendon of trunk", "Ts43xey8fgP"),
    ("ICD10", "T09.6", "T09.6 Traumatic amputation of trunk, level unspecified", "QYYV028o25S"),
    ("ICD10", "T09.8", "T09.8 Other specified injuries of trunk, level unspecified", "qkG1x7JVHHs"),
    ("ICD10", "T09.9", "T09.9 Unspecified injury of trunk, level unspecified", "pha8H5oeIVn"),
    ("ICD10", "T10", "T10 Fracture of upper limb, level unspecified", "YqMT9kMgE50"),
    ("ICD10", "T11", "T11 Other injuries of upper limb, level unspecified", "JcvnWJmwyrw"),
    ("ICD10", "T11.0", "T11.0 Superficial injury of upper limb, level unspecified", "XIqiRF4K4Lw"),
    ("ICD10", "T11.1", "T11.1 Open wound of upper limb, level unspecified", "a8eOfDQKXCh"),
    ("ICD10", "T11.2", "T11.2 Dislocation, sprain and strain of unspecified joint and ligament of upper limb, level unspecified", "N2ADYQoMufq"),
    ("ICD10", "T11.3", "T11.3 Injury of unspecified nerve of upper limb, level unspecified", "RMOla5bBAfr"),
    ("ICD10", "T11.4", "T11.4 Injury of unspecified blood vessel of upper limb, level unspecified", "qY7LtNj7JEL"),
    ("ICD10", "T11.5", "T11.5 Injury of unspecified muscle and tendon of upper limb, level unspecified", "iWYnmbodUg9"),
    ("ICD10", "T11.6", "T11.6 Traumatic amputation of upper limb, level unspecified", "Q8H35n5DLcM"),
    ("ICD10", "T11.8", "T11.8 Other specified injuries of upper limb, level unspecified", "zhKPZWcV79f"),
    ("ICD10", "T11.9", "T11.9 Unspecified injury of upper limb, level unspecified", "xKXwMdJFBWS"),
    ("ICD10", "T12", "T12 Fracture of lower limb, level unspecified", "p51iwl3LUoN"),
    ("ICD10", "T13", "T13 Other injuries of lower limb, level unspecified", "BT43ljCYHlK"),
    ("ICD10", "T13.0", "T13.0 Superficial injury of lower limb, level unspecified", "G5abeRZi6aW"),
    ("ICD10", "T13.1", "T13.1 Open wound of lower limb, level unspecified", "MGNmthYBhPT"),
    ("ICD10", "T13.2", "T13.2 Dislocation, sprain and strain of unspecified joint and ligament of lower limb, level unspecified", "nWQQTNzZpYZ"),
    ("ICD10", "T13.3", "T13.3 Injury of unspecified nerve of lower limb, level unspecified", "Fxd3Hj8f9hJ"),
    ("ICD10", "T13.4", "T13.4 Injury of unspecified blood vessel of lower limb, level unspecified", "xjrydbfzlwX"),
    ("ICD10", "T13.5", "T13.5 Injury of unspecified muscle and tendon of lower limb, level unspecified", "MYYY8IdMwc8"),
    ("ICD10", "T13.6", "T13.6 Traumatic amputation of lower limb, level unspecified", "X2bKCeQ8q3y"),
    ("ICD10", "T13.8", "T13.8 Other specified injuries of lower limb, level unspecified", "xpIvkkoevyo"),
    ("ICD10", "T13.9", "T13.9 Unspecified injury of lower limb, level unspecified", "NkT8pqQkVVq"),
    ("ICD10", "T14", "T14 Injury of unspecified body region", "vNBSk4S6HeG"),
    ("ICD10", "T14.0", "T14.0 Superficial injury of unspecified body region", "MnlDS14GkFa"),
    ("ICD10", "T14.1", "T14.1 Open wound of unspecified body region", "j621QioL8bS"),
    ("ICD10", "T14.2", "T14.2 Fracture of unspecified body region", "nPvAZ1RZ8A6"),
    ("ICD10", "T14.3", "T14.3 Dislocation, sprain and strain of unspecified body region", "VqLm2X0Xox5"),
    ("ICD10", "T14.4", "T14.4 Injury of nerve(s) of unspecified body region", "bvNIMAcRjgQ"),
    ("ICD10", "T14.5", "T14.5 Injury of blood vessel(s) of unspecified body region", "fZnX2izkIC3"),
    ("ICD10", "T14.6", "T14.6 Injury of muscles and tendons of unspecified body region", "wU86zQrseMH"),
    ("ICD10", "T14.7", "T14.7 Crushing injury and traumatic amputation of unspecified body region", "eY3QRtlVYP4"),
    ("ICD10", "T14.8", "T14.8 Other injuries of unspecified body region", "H9eXDIhBquK"),
    ("ICD10", "T14.9", "T14.9 Injury, unspecified", "Fj49gaiI3JD"),
    ("ICD10", "T15", "T15 Foreign body on external eye", "jPFsCWjkpWL"),
    ("ICD10", "T15.0", "T15.0 Foreign body in cornea", "J4dPFFQymph"),
    ("ICD10", "T15.1", "T15.1 Foreign body in conjunctival sac", "NoTKOmpjxvp"),
    ("ICD10", "T15.8", "T15.8 Foreign body in other and multiple parts of external eye", "n6TPE7XSHAv"),
    ("ICD10", "T15.9", "T15.9 Foreign body on external eye, part unspecified", "hGdleEHjyEM"),
    ("ICD10", "T16", "T16 Foreign body in ear", "TcPRwv9AsBU"),
    ("ICD10", "T17", "T17 Foreign body in respiratory tract", "SbwKlKDWuRb"),
    ("ICD10", "T17.0", "T17.0 Foreign body in nasal sinus", "PFHmGiIsvLN"),
    ("ICD10", "T17.1", "T17.1 Foreign body in nostril", "Q6sWHcLIPvD"),
    ("ICD10", "T17.2", "T17.2 Foreign body in pharynx", "nlXYz3F46XY"),
    ("ICD10", "T17.3", "T17.3 Foreign body in larynx", "CudrShBR7HU"),
    ("ICD10", "T17.4", "T17.4 Foreign body in trachea", "UU4gOI0l4nF"),
    ("ICD10", "T17.5", "T17.5 Foreign body in bronchus", "JnULt0OjHyr"),
    ("ICD10", "T17.8", "T17.8 Foreign body in other and multiple parts of respiratory tract", "SoTFO6YyC1t"),
    ("ICD10", "T17.9", "T17.9 Foreign body in respiratory tract, part unspecified", "pzXgCaDImFb"),
    ("ICD10", "T18", "T18 Foreign body in alimentary tract", "DZPFLszWw0U"),
    ("ICD10", "T18.0", "T18.0 Foreign body in mouth", "kthRMsMogk9"),
    ("ICD10", "T18.1", "T18.1 Foreign body in oesophagus", "x5UsnJTKQsW"),
    ("ICD10", "T18.2", "T18.2 Foreign body in stomach", "A35TcUK7Ek7"),
    ("ICD10", "T18.3", "T18.3 Foreign body in small intestine", "relT8piyW4E"),
    ("ICD10", "T18.4", "T18.4 Foreign body in colon", "S77DCrSEp65"),
    ("ICD10", "T18.5", "T18.5 Foreign body in anus and rectum", "n3zaokNfX5z"),
    ("ICD10", "T18.8", "T18.8 Foreign body in other and multiple parts of alimentary tract", "UXAtA6W3vTj"),
    ("ICD10", "T18.9", "T18.9 Foreign body in alimentary tract, part unspecified", "lGJnKJDI9DE"),
    ("ICD10", "T19", "T19 Foreign body in genitourinary tract", "dzfrerZTw7K"),
    ("ICD10", "T19.0", "T19.0 Foreign body in urethra", "IjG6gCEdAU8"),
    ("ICD10", "T19.1", "T19.1 Foreign body in bladder", "JZuUQVWR3bu"),
    ("ICD10", "T19.2", "T19.2 Foreign body in vulva and vagina", "ZWMEzQFefMr"),
    ("ICD10", "T19.3", "T19.3 Foreign body in uterus [any part]", "gn2kk8JS3Ri"),
    ("ICD10", "T19.8", "T19.8 Foreign body in other and multiple parts of genitourinary tract", "vMoh0nUSGIb"),
    ("ICD10", "T19.9", "T19.9 Foreign body in genitourinary tract, part unspecified", "TTMYR07b3Vc"),
    ("ICD10", "T20", "T20 Burn and corrosion of head and neck", "RDRi4KZ9ufz"),
    ("ICD10", "T20.0", "T20.0 Burn of unspecified degree of head and neck", "ChVPKh5AI6o"),
    ("ICD10", "T20.1", "T20.1 Burn of first degree of head and neck", "uuY44cyYdTe"),
    ("ICD10", "T20.2", "T20.2 Burn of second degree of head and neck", "TGxq7jmckBk"),
    ("ICD10", "T20.3", "T20.3 Burn of third degree of head and neck", "rzSLZLjQUkP"),
    ("ICD10", "T20.4", "T20.4 Corrosion of unspecified degree of head and neck", "SwfM7l6rvtj"),
    ("ICD10", "T20.5", "T20.5 Corrosion of first degree of head and neck", "QZ9I3eGWThv"),
    ("ICD10", "T20.6", "T20.6 Corrosion of second degree of head and neck", "DKWsLF5WMFc"),
    ("ICD10", "T20.7", "T20.7 Corrosion of third degree of head and neck", "tmSYMqMedYm"),
    ("ICD10", "T21", "T21 Burn and corrosion of trunk", "faVWd2Nn67U"),
    ("ICD10", "T21.0", "T21.0 Burn of unspecified degree of trunk", "mwRMqURlyAO"),
    ("ICD10", "T21.1", "T21.1 Burn of first degree of trunk", "vqKYCNsH5u3"),
    ("ICD10", "T21.2", "T21.2 Burn of second degree of trunk", "dpdb6dWs7Cd"),
    ("ICD10", "T21.3", "T21.3 Burn of third degree of trunk", "gegWtbKjqg8"),
    ("ICD10", "T21.4", "T21.4 Corrosion of unspecified degree of trunk", "uS3ry1iwoV4"),
    ("ICD10", "T21.5", "T21.5 Corrosion of first degree of trunk", "QCg4j5x0a1t"),
    ("ICD10", "T21.6", "T21.6 Corrosion of second degree of trunk", "YPNGxkfXNYT"),
    ("ICD10", "T21.7", "T21.7 Corrosion of third degree of trunk", "aBk1S5QSUXw"),
    ("ICD10", "T22", "T22 Burn and corrosion of shoulder and upper limb, except wrist and hand", "x5u7JYH2IVW"),
    ("ICD10", "T22.0", "T22.0 Burn of unspecified degree of shoulder and upper limb, except wrist and hand", "nnO2HdigoLR"),
    ("ICD10", "T22.1", "T22.1 Burn of first degree of shoulder and upper limb, except wrist and hand", "ke4V4mexdfT"),
    ("ICD10", "T22.2", "T22.2 Burn of second degree of shoulder and upper limb, except wrist and hand", "wMz6frWPa8B"),
    ("ICD10", "T22.3", "T22.3 Burn of third degree of shoulder and upper limb, except wrist and hand", "KFiobYpAqdX"),
    ("ICD10", "T22.4", "T22.4 Corrosion of unspecified degree of shoulder and upper limb, except wrist and hand", "adTZqGBjCdq"),
    ("ICD10", "T22.5", "T22.5 Corrosion of first degree of shoulder and upper limb, except wrist and hand", "O1WsbCuALzX"),
    ("ICD10", "T22.6", "T22.6 Corrosion of second degree of shoulder and upper limb, except wrist and hand", "G4IRWmbfcUz"),
    ("ICD10", "T22.7", "T22.7 Corrosion of third degree of shoulder and upper limb, except wrist and hand", "DqfPcajPLBF"),
    ("ICD10", "T23", "T23 Burn and corrosion of wrist and hand", "EgQ3niv4pNg"),
    ("ICD10", "T23.0", "T23.0 Burn of unspecified degree of wrist and hand", "ZHTnLSjrRlg"),
    ("ICD10", "T23.1", "T23.1 Burn of first degree of wrist and hand", "nx9SGfNtRfu"),
    ("ICD10", "T23.2", "T23.2 Burn of second degree of wrist and hand", "Pjlah6vS84V"),
    ("ICD10", "T23.3", "T23.3 Burn of third degree of wrist and hand", "X2XmcUI6R23"),
    ("ICD10", "T23.4", "T23.4 Corrosion of unspecified degree of wrist and hand", "VuB3c7mkTfo"),
    ("ICD10", "T23.5", "T23.5 Corrosion of first degree of wrist and hand", "CDOl92XEuPy"),
    ("ICD10", "T23.6", "T23.6 Corrosion of second degree of wrist and hand", "DnXJ1dIWgVn"),
    ("ICD10", "T23.7", "T23.7 Corrosion of third degree of wrist and hand", "gSUC9DS257Z"),
    ("ICD10", "T24", "T24 Burn and corrosion of hip and lower limb, except ankle and foot", "j71Ah6Q0nfd"),
    ("ICD10", "T24.0", "T24.0 Burn of unspecified degree of hip and lower limb, except ankle and foot", "cTOOfIkMC8c"),
    ("ICD10", "T24.1", "T24.1 Burn of first degree of hip and lower limb, except ankle and foot", "fZ8icAxNeZY"),
    ("ICD10", "T24.2", "T24.2 Burn of second degree of hip and lower limb, except ankle and foot", "YM3TdcZRNiK"),
    ("ICD10", "T24.3", "T24.3 Burn of third degree of hip and lower limb, except ankle and foot", "gmf5sPx4P8S"),
    ("ICD10", "T24.4", "T24.4 Corrosion of unspecified degree of hip and lower limb, except ankle and foot", "L16GI05MC5L"),
    ("ICD10", "T24.5", "T24.5 Corrosion of first degree of hip and lower limb, except ankle and foot", "xuoLr8ILhi7"),
    ("ICD10", "T24.6", "T24.6 Corrosion of second degree of hip and lower limb, except ankle and foot", "SVcNnbscWDR"),
    ("ICD10", "T24.7", "T24.7 Corrosion of third degree of hip and lower limb, except ankle and foot", "x3kaHLOFQBZ"),
    ("ICD10", "T25", "T25 Burn and corrosion of ankle and foot", "HdrdYR0RYQr"),
    ("ICD10", "T25.0", "T25.0 Burn of unspecified degree of ankle and foot", "RvuMAA1xJXh"),
    ("ICD10", "T25.1", "T25.1 Burn of first degree of ankle and foot", "xxkcIxtapEY"),
    ("ICD10", "T25.2", "T25.2 Burn of second degree of ankle and foot", "wlAIL5TxzvT"),
    ("ICD10", "T25.3", "T25.3 Burn of third degree of ankle and foot", "IATZR9mQWZl"),
    ("ICD10", "T25.4", "T25.4 Corrosion of unspecified degree of ankle and foot", "ugXdjfsquBd"),
    ("ICD10", "T25.5", "T25.5 Corrosion of first degree of ankle and foot", "V1kUZZd5Mw8"),
    ("ICD10", "T25.6", "T25.6 Corrosion of second degree of ankle and foot", "O8UbE1uyhZO"),
    ("ICD10", "T25.7", "T25.7 Corrosion of third degree of ankle and foot", "c3nkuhBmLwJ"),
    ("ICD10", "T26", "T26 Burn and corrosion confined to eye and adnexa", "R3UrulyvaoI"),
    ("ICD10", "T26.0", "T26.0 Burn of eyelid and periocular area", "zxnJRsux55r"),
    ("ICD10", "T26.1", "T26.1 Burn of cornea and conjunctival sac", "HaFWagqvNx1"),
    ("ICD10", "T26.2", "T26.2 Burn with resulting rupture and destruction of eyeball", "fMBZ8F3kHZn"),
    ("ICD10", "T26.3", "T26.3 Burn of other parts of eye and adnexa", "N0NA8lP3JIS"),
    ("ICD10", "T26.4", "T26.4 Burn of eye and adnexa, part unspecified", "ubWRxxhkqxZ"),
    ("ICD10", "T26.5", "T26.5 Corrosion of eyelid and periocular area", "uY7LTUm0Eot"),
    ("ICD10", "T26.6", "T26.6 Corrosion of cornea and conjunctival sac", "GsIvQIEcjlT"),
    ("ICD10", "T26.7", "T26.7 Corrosion with resulting rupture and destruction of eyeball", "UKp75X3zTq4"),
    ("ICD10", "T26.8", "T26.8 Corrosion of other parts of eye and adnexa", "pxI4MYUVtQr"),
    ("ICD10", "T26.9", "T26.9 Corrosion of eye and adnexa, part unspecified", "lmH0MZDTIQL"),
    ("ICD10", "T27", "T27 Burn and corrosion of respiratory tract", "LoqXhpyhrDV"),
    ("ICD10", "T27.0", "T27.0 Burn of larynx and trachea", "P9S68QeIwtC"),
    ("ICD10", "T27.1", "T27.1 Burn involving larynx and trachea with lung", "QpVE3OAzVPe"),
    ("ICD10", "T27.2", "T27.2 Burn of other parts of respiratory tract", "rzwEjG4T9Qi"),
    ("ICD10", "T27.3", "T27.3 Burn of respiratory tract, part unspecified", "GiQfsKulQDB"),
    ("ICD10", "T27.4", "T27.4 Corrosion of larynx and trachea", "zbGbvvWRDOV"),
    ("ICD10", "T27.5", "T27.5 Corrosion involving larynx and trachea with lung", "Ik9Dti6vavt"),
    ("ICD10", "T27.6", "T27.6 Corrosion of other parts of respiratory tract", "KcQNgc4iggg"),
    ("ICD10", "T27.7", "T27.7 Corrosion of respiratory tract, part unspecified", "nRk3ECdjdZJ"),
    ("ICD10", "T28", "T28 Burn and corrosion of other internal organs", "vfLWPkIZWvj"),
    ("ICD10", "T28.0", "T28.0 Burn of mouth and pharynx", "mIFILR8NPpK"),
    ("ICD10", "T28.1", "T28.1 Burn of oesophagus", "zCf7xxZK8UG"),
    ("ICD10", "T28.2", "T28.2 Burn of other parts of alimentary tract", "RDeCSluFiWF"),
    ("ICD10", "T28.3", "T28.3 Burn of internal genitourinary organs", "zS1tKkRqLVB"),
    ("ICD10", "T28.4", "T28.4 Burn of other and unspecified internal organs", "Ku7umQw3PlH"),
    ("ICD10", "T28.5", "T28.5 Corrosion of mouth and pharynx", "rpufmPH3Nk1"),
    ("ICD10", "T28.6", "T28.6 Corrosion of oesophagus", "FPP3YniACJo"),
    ("ICD10", "T28.7", "T28.7 Corrosion of other parts of alimentary tract", "efHODNkE1Nu"),
    ("ICD10", "T28.8", "T28.8 Corrosion of internal genitourinary organs", "iYyIhjQow8o"),
    ("ICD10", "T28.9", "T28.9 Corrosion of other and unspecified internal organs", "DY6wYa6WzHF"),
    ("ICD10", "T29", "T29 Burns and corrosions of multiple body regions", "fy8JCAZhZ5C"),
    ("ICD10", "T29.0", "T29.0 Burns of multiple regions, unspecified degree", "elr7LdS1M07"),
    ("ICD10", "T29.1", "T29.1 Burns of multiple regions, no more than first-degree burns mentioned", "FTlGOQqk5YN"),
    ("ICD10", "T29.2", "T29.2 Burns of multiple regions, no more than second-degree burns mentioned", "G0no42x2I0G"),
    ("ICD10", "T29.3", "T29.3 Burns of multiple regions, at least one burn of third degree mentioned", "ihJz9WxIR87"),
    ("ICD10", "T29.4", "T29.4 Corrosions of multiple regions, unspecified degree", "H9JwfwddUo2"),
    ("ICD10", "T29.5", "T29.5 Corrosions of multiple regions, no more than first-degree corrosions mentioned", "xrDRuQ1ySoo"),
    ("ICD10", "T29.6", "T29.6 Corrosions of multiple regions, no more than second-degree corrosions mentioned", "RzFdkF3q199"),
    ("ICD10", "T29.7", "T29.7 Corrosions of multiple regions, at least one corrosion of third degree mentioned", "DoQgVYOY0uu"),
    ("ICD10", "T30", "T30 Burn and corrosion, body region unspecified", "VkM5y53WfCj"),
    ("ICD10", "T30.0", "T30.0 Burn of unspecified body region, unspecified degree", "dulhycmDv2t"),
    ("ICD10", "T30.1", "T30.1 Burn of first degree, body region unspecified", "FqdkBTC44l7"),
    ("ICD10", "T30.2", "T30.2 Burn of second degree, body region unspecified", "JGqlNnFG42O"),
    ("ICD10", "T30.3", "T30.3 Burn of third degree, body region unspecified", "drNFbCajPDL"),
    ("ICD10", "T30.4", "T30.4 Corrosion of unspecified body region, unspecified degree", "IS91X7uRuV8"),
    ("ICD10", "T30.5", "T30.5 Corrosion of first degree, body region unspecified", "PozCL5NLcNN"),
    ("ICD10", "T30.6", "T30.6 Corrosion of second degree, body region unspecified", "mOQJB7E0hls"),
    ("ICD10", "T30.7", "T30.7 Corrosion of third degree, body region unspecified", "w7fc5REhrP9"),
    ("ICD10", "T31", "T31 Burns classified according to extent of body surface involved", "c00Jb12Z925"),
    ("ICD10", "T31.0", "T31.0 Burns involving less than 10% of body surface", "kHgZAP6ZqaS"),
    ("ICD10", "T31.1", "T31.1 Burns involving 10-19% of body surface", "VCyVuTciGuI"),
    ("ICD10", "T31.2", "T31.2 Burns involving 20-29% of body surface", "doscMrPl4lD"),
    ("ICD10", "T31.3", "T31.3 Burns involving 30-39% of body surface", "j1j17lJ4reN"),
    ("ICD10", "T31.4", "T31.4 Burns involving 40-49% of body surface", "wPdHhyZ0G90"),
    ("ICD10", "T31.5", "T31.5 Burns involving 50-59% of body surface", "VZH4iDgeZ7l"),
    ("ICD10", "T31.6", "T31.6 Burns involving 60-69% of body surface", "lhGCAnTDdgx"),
    ("ICD10", "T31.7", "T31.7 Burns involving 70-79% of body surface", "xZFn7BLhkhK"),
    ("ICD10", "T31.8", "T31.8 Burns involving 80-89% of body surface", "Zbaj2R36uer"),
    ("ICD10", "T31.9", "T31.9 Burns involving 90% or more of body surface", "gYdtTSZtaK3"),
    ("ICD10", "T32", "T32 Corrosions classified according to extent of body surface involved", "g2gOfTQcp9F"),
    ("ICD10", "T32.0", "T32.0 Corrosions involving less than 10% of body surface", "umJZy8BXNtx"),
    ("ICD10", "T32.1", "T32.1 Corrosions involving 10-19% of body surface", "sl5ZK8IJPYr"),
    ("ICD10", "T32.2", "T32.2 Corrosions involving 20-29% of body surface", "Qx28EGzV47U"),
    ("ICD10", "T32.3", "T32.3 Corrosions involving 30-39% of body surface", "tMqMt7cZW3b"),
    ("ICD10", "T32.4", "T32.4 Corrosions involving 40-49% of body surface", "ZxesP5kVCbm"),
    ("ICD10", "T32.5", "T32.5 Corrosions involving 50-59% of body surface", "hIOYKOtXPCL"),
    ("ICD10", "T32.6", "T32.6 Corrosions involving 60-69% of body surface", "F5BfF2BanJ1"),
    ("ICD10", "T32.7", "T32.7 Corrosions involving 70-79% of body surface", "rEo3XkUuC6G"),
    ("ICD10", "T32.8", "T32.8 Corrosions involving 80-89% of body surface", "h2Hdm7hVnIN"),
    ("ICD10", "T32.9", "T32.9 Corrosions involving 90% or more of body surface", "RwxVv47bbji"),
    ("ICD10", "T33", "T33 Superficial frostbite", "LJdjW2oucMr"),
    ("ICD10", "T33.0", "T33.0 Superficial frostbite of head", "WefgNUFmQ0s"),
    ("ICD10", "T33.1", "T33.1 Superficial frostbite of neck", "gFFhre9rzpn"),
    ("ICD10", "T33.2", "T33.2 Superficial frostbite of thorax", "r4NXbWUyijm"),
    ("ICD10", "T33.3", "T33.3 Superficial frostbite of abdominal wall, lower back and pelvis", "WEuEYwjmir7"),
    ("ICD10", "T33.4", "T33.4 Superficial frostbite of arm", "zgYtLur6bvq"),
    ("ICD10", "T33.5", "T33.5 Superficial frostbite of wrist and hand", "uoL4wkc5gRE"),
    ("ICD10", "T33.6", "T33.6 Superficial frostbite of hip and thigh", "ffyuxRlImkG"),
    ("ICD10", "T33.7", "T33.7 Superficial frostbite of knee and lower leg", "l41sYVX1uby"),
    ("ICD10", "T33.8", "T33.8 Superficial frostbite of ankle and foot", "cF5fJpNOPVm"),
    ("ICD10", "T33.9", "T33.9 Superficial frostbite of other and unspecified sites", "QtpQNhIKJGy"),
    ("ICD10", "T34", "T34 Frostbite with tissue necrosis", "hLbrELt1vmM"),
    ("ICD10", "T34.0", "T34.0 Frostbite with tissue necrosis of head", "B8mTHumTLyq"),
    ("ICD10", "T34.1", "T34.1 Frostbite with tissue necrosis of neck", "wAmznis8KS9"),
    ("ICD10", "T34.2", "T34.2 Frostbite with tissue necrosis of thorax", "x0uRUECJxLD"),
    ("ICD10", "T34.3", "T34.3 Frostbite with tissue necrosis of abdominal wall, lower back and pelvis", "RZtzwk0ho5R"),
    ("ICD10", "T34.4", "T34.4 Frostbite with tissue necrosis of arm", "NCxpLEvQAp0"),
    ("ICD10", "T34.5", "T34.5 Frostbite with tissue necrosis of wrist and hand", "VEb4zMsuo2a"),
    ("ICD10", "T34.6", "T34.6 Frostbite with tissue necrosis of hip and thigh", "AK0COO4yq8Z"),
    ("ICD10", "T34.7", "T34.7 Frostbite with tissue necrosis of knee and lower leg", "cJ4rWimv1SF"),
    ("ICD10", "T34.8", "T34.8 Frostbite with tissue necrosis of ankle and foot", "WXmc1ahy4U4"),
    ("ICD10", "T34.9", "T34.9 Frostbite with tissue necrosis of other and unspecified sites", "KA0HSsB0b3Z"),
    ("ICD10", "T35", "T35 Frostbite involving multiple body regions and unspecified frostbite", "wPEZt2Br6l5"),
    ("ICD10", "T35.0", "T35.0 Superficial frostbite involving multiple body regions", "HwCt8VoIaem"),
    ("ICD10", "T35.1", "T35.1 Frostbite with tissue necrosis involving multiple body regions", "w5DdqKueu5t"),
    ("ICD10", "T35.2", "T35.2 Unspecified frostbite of head and neck", "n2pK33OzH7T"),
    ("ICD10", "T35.3", "T35.3 Unspecified frostbite of thorax, abdomen, lower back and pelvis", "qajdGGpK4GG"),
    ("ICD10", "T35.4", "T35.4 Unspecified frostbite of upper limb", "iUFHPDC8IEY"),
    ("ICD10", "T35.5", "T35.5 Unspecified frostbite of lower limb", "X9nzQ1eyusJ"),
    ("ICD10", "T35.6", "T35.6 Unspecified frostbite involving multiple body regions", "l1gUOcFTm0O"),
    ("ICD10", "T35.7", "T35.7 Unspecified frostbite of unspecified site", "znBPwXsQbsb"),
    ("ICD10", "T36", "T36 Poisoning by systemic antibiotics", "TqkBrWqvFlV"),
    ("ICD10", "T36.0", "T36.0 Poisoning: Penicillins", "zWfdJRIaLPL"),
    ("ICD10", "T36.1", "T36.1 Poisoning: Cefalosporins and other beta-lactam antibiotics", "oaZRY8l6BsY"),
    ("ICD10", "T36.2", "T36.2 Poisoning: Chloramphenicol group", "F3TeL622Gai"),
    ("ICD10", "T36.3", "T36.3 Poisoning: Macrolides", "mZn8eJIDCQK"),
    ("ICD10", "T36.4", "T36.4 Poisoning: Tetracyclines", "NuM3mJ8hs9C"),
    ("ICD10", "T36.5", "T36.5 Poisoning: Aminoglycosides", "MKUJSEwgWUF"),
    ("ICD10", "T36.6", "T36.6 Poisoning: Rifamycins", "aZEKkmJUoUF");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "T36.7", "T36.7 Poisoning: Antifungal antibiotics, systemically used", "WAP2qy2wAdj"),
    ("ICD10", "T36.8", "T36.8 Poisoning: Other systemic antibiotics", "A4afzSDzwHp"),
    ("ICD10", "T36.9", "T36.9 Poisoning: Systemic antibiotic, unspecified", "HCHZhY2beuy"),
    ("ICD10", "T37", "T37 Poisoning by other systemic anti-infectives and antiparasitics", "IK9XiNttmef"),
    ("ICD10", "T37.0", "T37.0 Poisoning: Sulfonamides", "NLpmrJvAQHL"),
    ("ICD10", "T37.1", "T37.1 Poisoning: Antimycobacterial drugs", "ZAhvzJvZ888"),
    ("ICD10", "T37.2", "T37.2 Poisoning: Antimalarials and drugs acting on other blood protozoa", "DK7zYAZ41SR"),
    ("ICD10", "T37.3", "T37.3 Poisoning: Other antiprotozoal drugs", "zZ7Xrpmhhws"),
    ("ICD10", "T37.4", "T37.4 Poisoning: Anthelminthics", "HLB0NN40AJ4"),
    ("ICD10", "T37.5", "T37.5 Poisoning: Antiviral drugs", "uVa6a0kvAi1"),
    ("ICD10", "T37.8", "T37.8 Poisoning: Other specified systemic anti-infectives and antiparasitics", "vV727Fy735R"),
    ("ICD10", "T37.9", "T37.9 Poisoning: Systemic anti-infective and antiparasitic, unspecified", "fxICM2YM3e7"),
    ("ICD10", "T38", "T38 Poisoning by hormones and their synthetic substitutes and antagonists, not elsewhere classified", "p2fQeEBwgIq"),
    ("ICD10", "T38.0", "T38.0 Poisoning: Glucocorticoids and synthetic analogues", "BknNK7dKLD9"),
    ("ICD10", "T38.1", "T38.1 Poisoning: Thyroid hormones and substitutes", "a1w8PbrzwVq"),
    ("ICD10", "T38.2", "T38.2 Poisoning: Antithyroid drugs", "n1zyYxF8JxI"),
    ("ICD10", "T38.3", "T38.3 Poisoning: Insulin and oral hypoglycaemic [antidiabetic] drugs", "hslsKKdE4GD"),
    ("ICD10", "T38.4", "T38.4 Poisoning: Oral contraceptives", "AedaEXO3LJx"),
    ("ICD10", "T38.5", "T38.5 Poisoning: Other estrogens and progestogens", "OgUhtRO5Nqu"),
    ("ICD10", "T38.6", "T38.6 Poisoning: Antigonadotrophins, antiestrogens, antiandrogens, not elsewhere classified", "qxtaj1X6qKL"),
    ("ICD10", "T38.7", "T38.7 Poisoning: Androgens and anabolic congeners", "vCHFG7Vu3YB"),
    ("ICD10", "T38.8", "T38.8 Poisoning: Other and unspecified hormones and their synthetic substitutes", "IZCfsNGxdgT"),
    ("ICD10", "T38.9", "T38.9 Poisoning: Other and unspecified hormone antagonists", "IYkySrEcKXz"),
    ("ICD10", "T39", "T39 Poisoning by nonopioid analgesics, antipyretics and antirheumatics", "SIzSz1NYW3F"),
    ("ICD10", "T39.0", "T39.0 Poisoning: Salicylates", "pmYMVfrFTav"),
    ("ICD10", "T39.1", "T39.1 Poisoning: 4-Aminophenol derivatives", "rjOATRUkunx"),
    ("ICD10", "T39.2", "T39.2 Poisoning: Pyrazolone derivatives", "Yry7w8OygeA"),
    ("ICD10", "T39.3", "T39.3 Poisoning: Other nonsteroidal anti-inflammatory drugs [NSAID]", "HFhbPHi6wZo"),
    ("ICD10", "T39.4", "T39.4 Poisoning: Antirheumatics, not elsewhere classified", "GsHzSORZLuP"),
    ("ICD10", "T39.8", "T39.8 Poisoning: Other nonopioid analgesics and antipyretics, not elsewhere classified", "pNPUDNAwzfe"),
    ("ICD10", "T39.9", "T39.9 Poisoning: Nonopioid analgesic, antipyretic and antirheumatic, unspecified", "nAPfOJg8Duc"),
    ("ICD10", "T40", "T40 Poisoning by narcotics and psychodysleptics [hallucinogens]", "zFG4tnQUKgj"),
    ("ICD10", "T40.0", "T40.0 Poisoning: Opium", "Qj2s4oetSvN"),
    ("ICD10", "T40.1", "T40.1 Poisoning: Heroin", "fB1jvqoEh6q"),
    ("ICD10", "T40.2", "T40.2 Poisoning: Other opioids", "QGFnaqUrGzn"),
    ("ICD10", "T40.3", "T40.3 Poisoning: Methadone", "CfrP9RE5ubt"),
    ("ICD10", "T40.4", "T40.4 Poisoning: Other synthetic narcotics", "vZ1vLApQO17"),
    ("ICD10", "T40.5", "T40.5 Poisoning: Cocaine", "pc03mdMzjCK"),
    ("ICD10", "T40.6", "T40.6 Poisoning: Other and unspecified narcotics", "dIN0BN915bX"),
    ("ICD10", "T40.7", "T40.7 Poisoning: Cannabis (derivatives)", "TSaon3MrTZy"),
    ("ICD10", "T40.8", "T40.8 Poisoning: Lysergide [LSD]", "VxyupfPWUux"),
    ("ICD10", "T40.9", "T40.9 Poisoning: Other and unspecified psychodysleptics [hallucinogens]", "F6XE2OxtzA8"),
    ("ICD10", "T41", "T41 Poisoning by anaesthetics and therapeutic gases", "x0cSTlGSUFz"),
    ("ICD10", "T41.0", "T41.0 Poisoning: Inhaled anaesthetics", "VP3IDRAzPYa"),
    ("ICD10", "T41.1", "T41.1 Poisoning: Intravenous anaesthetics", "reOdQxhr99k"),
    ("ICD10", "T41.2", "T41.2 Poisoning: Other and unspecified general anaesthetics", "rXO8we3jtvh"),
    ("ICD10", "T41.3", "T41.3 Poisoning: Local anaesthetics", "qJJiDBHR13d"),
    ("ICD10", "T41.4", "T41.4 Poisoning: Anaesthetic, unspecified", "i5G6RcYDV3a"),
    ("ICD10", "T41.5", "T41.5 Poisoning: Therapeutic gases", "Bwl8Gdw06oB"),
    ("ICD10", "T42", "T42 Poisoning by antiepileptic, sedative-hypnotic and antiparkinsonism drugs", "TI6eXQ23jgm"),
    ("ICD10", "T42.0", "T42.0 Poisoning: Hydantoin derivatives", "Q6WgjZCGWte"),
    ("ICD10", "T42.1", "T42.1 Poisoning: Iminostilbenes", "TQxZ15FC3TG"),
    ("ICD10", "T42.2", "T42.2 Poisoning: Succinimides and oxazolidinediones", "OJ1XRPhtxNX"),
    ("ICD10", "T42.3", "T42.3 Poisoning: Barbiturates", "XVq3grWpULZ"),
    ("ICD10", "T42.4", "T42.4 Poisoning: Benzodiazepines", "yR0VLICaLYX"),
    ("ICD10", "T42.5", "T42.5 Poisoning: Mixed antiepileptics, not elsewhere classified", "EXWeMiSmQdD"),
    ("ICD10", "T42.6", "T42.6 Poisoning: Other antiepileptic and sedative-hypnotic drugs", "bhuUyJKy3N5"),
    ("ICD10", "T42.7", "T42.7 Poisoning: Antiepileptic and sedative-hypnotic drugs, unspecified", "W3yrLUxWxyg"),
    ("ICD10", "T42.8", "T42.8 Poisoning: Antiparkinsonism drugs and other central muscle-tone depressants", "mZgV7VFF9Gx"),
    ("ICD10", "T43", "T43 Poisoning by psychotropic drugs, not elsewhere classified", "nnL9tkcUX7g"),
    ("ICD10", "T43.0", "T43.0 Poisoning: Tricyclic and tetracyclic antidepressants", "GcCjjvKDks1"),
    ("ICD10", "T43.1", "T43.1 Poisoning: Monoamine-oxidase-inhibitor antidepressants", "SiJLIvBSg9f"),
    ("ICD10", "T43.2", "T43.2 Poisoning: Other and unspecified antidepressants", "a3RAB97mmtq"),
    ("ICD10", "T43.3", "T43.3 Poisoning: Phenothiazine antipsychotics and neuroleptics", "FWT2PsQRqxX"),
    ("ICD10", "T43.4", "T43.4 Poisoning: Butyrophenone and thioxanthene neuroleptics", "DMk3hDcB9LR"),
    ("ICD10", "T43.5", "T43.5 Poisoning: Other and unspecified antipsychotics and neuroleptics", "U3m28rvEPlK"),
    ("ICD10", "T43.6", "T43.6 Poisoning: Psychostimulants with abuse potential", "JwCDzH7dhWT"),
    ("ICD10", "T43.8", "T43.8 Poisoning: Other psychotropic drugs, not elsewhere classified", "seEESpMSPqN"),
    ("ICD10", "T43.9", "T43.9 Poisoning: Psychotropic drug, unspecified", "kNhUxr6Synh"),
    ("ICD10", "T44", "T44 Poisoning by drugs primarily affecting the autonomic nervous system", "gs9aw17LAg4"),
    ("ICD10", "T44.0", "T44.0 Poisoning: Anticholinesterase agents", "HVAjfNU3H72"),
    ("ICD10", "T44.1", "T44.1 Poisoning: Other parasympathomimetics [cholinergics]", "BIrcNSUIJe7"),
    ("ICD10", "T44.2", "T44.2 Poisoning: Ganglionic blocking drugs, not elsewhere classified", "fpwYEgrnvac"),
    ("ICD10", "T44.3", "T44.3 Poisoning: Other parasympatholytics [anticholinergics and antimuscarinics] and spasmolytics, not elsewhere classified", "yxHPRpLL6ve"),
    ("ICD10", "T44.4", "T44.4 Poisoning: Predominantly alpha-adrenoreceptor agonists, not elsewhere classified", "KuzBIrGDnHk"),
    ("ICD10", "T44.5", "T44.5 Poisoning: Predominantly beta-adrenoreceptor agonists, not elsewhere classified", "RXiXymo690L"),
    ("ICD10", "T44.6", "T44.6 Poisoning: Alpha-adrenoreceptor antagonists, not elsewhere classified", "CM3rO5tT59h"),
    ("ICD10", "T44.7", "T44.7 Poisoning: Beta-adrenoreceptor antagonists, not elsewhere classified", "barSpWEE24t"),
    ("ICD10", "T44.8", "T44.8 Poisoning: Centrally acting and adrenergic-neuron-blocking agents, not elsewhere classified", "HLPyaWcu1Oq"),
    ("ICD10", "T44.9", "T44.9 Poisoning: Other and unspecified drugs primarily affecting the autonomic nervous system", "EKkm8oi3uZQ"),
    ("ICD10", "T45", "T45 Poisoning by primarily systemic and haematological agents, not elsewhere classified", "H2OgllNKmzh"),
    ("ICD10", "T45.0", "T45.0 Poisoning: Antiallergic and antiemetic drugs", "vCQwy0M1AJn"),
    ("ICD10", "T45.1", "T45.1 Poisoning: Antineoplastic and immunosuppressive drugs", "Laxxin9YTwO"),
    ("ICD10", "T45.2", "T45.2 Poisoning: Vitamins, not elsewhere classified", "Vrbpz3zQsGP"),
    ("ICD10", "T45.3", "T45.3 Poisoning: Enzymes, not elsewhere classified", "S6172IjKqv1"),
    ("ICD10", "T45.4", "T45.4 Poisoning: Iron and its compounds", "lxkCwQtbt60"),
    ("ICD10", "T45.5", "T45.5 Poisoning: Anticoagulants", "P54DknPqibp"),
    ("ICD10", "T45.6", "T45.6 Poisoning: Fibrinolysis-affecting drugs", "e2oahqlIIhR"),
    ("ICD10", "T45.7", "T45.7 Poisoning: Anticoagulant antagonists, vitamin K and other coagulants", "IgVkoYdeNGb"),
    ("ICD10", "T45.8", "T45.8 Poisoning: Other primarily systemic and haematological agents", "YNDjuDPzMJJ"),
    ("ICD10", "T45.9", "T45.9 Poisoning: Primarily systemic and haematological agent, unspecified", "THF3buP1UM7"),
    ("ICD10", "T46", "T46 Poisoning by agents primarily affecting the cardiovascular system", "xKajW9ZUP7j"),
    ("ICD10", "T46.0", "T46.0 Poisoning: Cardiac-stimulant glycosides and drugs of similar action", "fW2g5uVtCED"),
    ("ICD10", "T46.1", "T46.1 Poisoning: Calcium-channel blockers", "oC8P9YwhBoU"),
    ("ICD10", "T46.2", "T46.2 Poisoning: Other antidysrhythmic drugs, not elsewhere classified", "YqN7jnTc0RF"),
    ("ICD10", "T46.3", "T46.3 Poisoning: Coronary vasodilators, not elsewhere classified", "wsT4ULWjtWX"),
    ("ICD10", "T46.4", "T46.4 Poisoning: Angiotensin-converting-enzyme inhibitors", "HqCTst5ctiG"),
    ("ICD10", "T46.5", "T46.5 Poisoning: Other antihypertensive drugs, not elsewhere classified", "T1jWbRaLcAh"),
    ("ICD10", "T46.6", "T46.6 Poisoning: Antihyperlipidaemic and antiarteriosclerotic drugs", "czXxEVRDovu"),
    ("ICD10", "T46.7", "T46.7 Poisoning: Peripheral vasodilators", "vzaoh3O1QHO"),
    ("ICD10", "T46.8", "T46.8 Poisoning: Antivaricose drugs, including sclerosing agents", "pc4TN5RUxnV"),
    ("ICD10", "T46.9", "T46.9 Poisoning: Other and unspecified agents primarily affecting the cardiovascular system", "RXvGwfJce0f"),
    ("ICD10", "T47", "T47 Poisoning by agents primarily affecting the gastrointestinal system", "VtiZy1H1rJt"),
    ("ICD10", "T47.0", "T47.0 Poisoning: Histamine H", "ZenhIeliDB0"),
    ("ICD10", "T47.1", "T47.1 Poisoning: Other antacids and anti-gastric-secretion drugs", "eQt6qPloHCh"),
    ("ICD10", "T47.2", "T47.2 Poisoning: Stimulant laxatives", "B5SBXAHDJ1O"),
    ("ICD10", "T47.3", "T47.3 Poisoning: Saline and osmotic laxatives", "blpK7hQP8we"),
    ("ICD10", "T47.4", "T47.4 Poisoning: Other laxatives", "AmTpQBGsxVH"),
    ("ICD10", "T47.5", "T47.5 Poisoning: Digestants", "vKu1mheHvhI"),
    ("ICD10", "T47.6", "T47.6 Poisoning: Antidiarrhoeal drugs", "AqeQN4azCrC"),
    ("ICD10", "T47.7", "T47.7 Poisoning: Emetics", "a1yoZ5w8quq"),
    ("ICD10", "T47.8", "T47.8 Poisoning: Other agents primarily affecting the gastrointestinal system", "lkMSWD51gLK"),
    ("ICD10", "T47.9", "T47.9 Poisoning: Agent primarily affecting the gastrointestinal system, unspecified", "VLBdNk2kz2n"),
    ("ICD10", "T48", "T48 Poisoning by agents primarily acting on smooth and skeletal muscles and the respiratory system", "vmiI86Sat2I"),
    ("ICD10", "T48.0", "T48.0 Poisoning: Oxytocic drugs", "xVwWv655LMz"),
    ("ICD10", "T48.1", "T48.1 Poisoning: Skeletal muscle relaxants [neuromuscular blocking agents]", "oQHpNa0x8nx"),
    ("ICD10", "T48.2", "T48.2 Poisoning: Other and unspecified agents primarily acting on muscles", "VSTB0sQGl84"),
    ("ICD10", "T48.3", "T48.3 Poisoning: Antitussives", "eGxF6kgGG08"),
    ("ICD10", "T48.4", "T48.4 Poisoning: Expectorants", "giCkhnHgCOX"),
    ("ICD10", "T48.5", "T48.5 Poisoning: Anti-common-cold drugs", "FlFbMEPL9XA"),
    ("ICD10", "T48.6", "T48.6 Poisoning: Antiasthmatics, not elsewhere classified", "QUdD1Ia6t8c"),
    ("ICD10", "T48.7", "T48.7 Poisoning: Other and unspecified agents primarily acting on the respiratory system", "UzoSvtS0kTn"),
    ("ICD10", "T49", "T49 Poisoning by topical agents primarily affecting skin and mucous membrane and by ophthalmological, otorhinolaryngological and dental drugs", "ERQT55d7wnj"),
    ("ICD10", "T49.0", "T49.0 Poisoning: Local antifungal, anti-infective and anti-inflammatory drugs, not elsewhere classified", "nFN8wMIfIls"),
    ("ICD10", "T49.1", "T49.1 Poisoning: Antipruritics", "EcvHTSh9dMZ"),
    ("ICD10", "T49.2", "T49.2 Poisoning: Local astringents and local detergents", "CDDD4nWTiOY"),
    ("ICD10", "T49.3", "T49.3 Poisoning: Emollients, demulcents and protectants", "qBvHo0L3lwY"),
    ("ICD10", "T49.4", "T49.4 Poisoning: Keratolytics, keratoplastics and other hair treatment drugs and preparations", "tyFakbcgtu6"),
    ("ICD10", "T49.5", "T49.5 Poisoning: Ophthalmological drugs and preparations", "hGXMSL97qaD"),
    ("ICD10", "T49.6", "T49.6 Poisoning: Otorhinolaryngological drugs and preparations", "IQ28ZHQoyuL"),
    ("ICD10", "T49.7", "T49.7 Poisoning: Dental drugs, topically applied", "WndcE3c8n5l"),
    ("ICD10", "T49.8", "T49.8 Poisoning: Other topical agents", "g6L0ChJv3An"),
    ("ICD10", "T49.9", "T49.9 Poisoning: Topical agent, unspecified", "KlXGAeS2tTo"),
    ("ICD10", "T50", "T50 Poisoning by diuretics and other and unspecified drugs, medicaments and biological substances", "YxLk3BT4bsf"),
    ("ICD10", "T50.0", "T50.0 Poisoning: Mineralocorticoids and their antagonists", "WP2QSHhPu0i"),
    ("ICD10", "T50.1", "T50.1 Poisoning: Loop [high-ceiling] diuretics", "UxbYWlqAUCY"),
    ("ICD10", "T50.2", "T50.2 Poisoning: Carbonic-anhydrase inhibitors, benzothiadiazides and other diuretics", "awJ4YpB0MQY"),
    ("ICD10", "T50.3", "T50.3 Poisoning: Electrolytic, caloric and water-balance agents", "lcsIVLCBdOM"),
    ("ICD10", "T50.4", "T50.4 Poisoning: Drugs affecting uric acid metabolism", "ZcaWOmwo7NH"),
    ("ICD10", "T50.5", "T50.5 Poisoning: Appetite depressants", "oSBru3n5RhE"),
    ("ICD10", "T50.6", "T50.6 Poisoning: Antidotes and chelating agents, not elsewhere classified", "uwZuMwOPBlW"),
    ("ICD10", "T50.7", "T50.7 Poisoning: Analeptics and opioid receptor antagonists", "SyGI3Ccg2LK"),
    ("ICD10", "T50.8", "T50.8 Poisoning: Diagnostic agents", "yCcwhb2Hjb4"),
    ("ICD10", "T50.9", "T50.9 Poisoning: Other and unspecified drugs, medicaments and biological substances", "JaVgkw1aJHK"),
    ("ICD10", "T51", "T51 Toxic effect of alcohol", "f2vveCSYh6d"),
    ("ICD10", "T51.0", "T51.0 Toxic effect: Ethanol", "U35BFzHfVIF"),
    ("ICD10", "T51.1", "T51.1 Toxic effect: Methanol", "LvmqOXZb15g"),
    ("ICD10", "T51.2", "T51.2 Toxic effect: 2-Propanol", "hM6vB3KFnbh"),
    ("ICD10", "T51.3", "T51.3 Toxic effect: Fusel oil", "NtmOJP0lCf2"),
    ("ICD10", "T51.8", "T51.8 Toxic effect: Other alcohols", "mot6kM3TA33"),
    ("ICD10", "T51.9", "T51.9 Toxic effect: Alcohol, unspecified", "yKPAX8py8rh"),
    ("ICD10", "T52", "T52 Toxic effect of organic solvents", "k6Y3kNjvtps"),
    ("ICD10", "T52.0", "T52.0 Toxic effect: Petroleum products", "qQsJHTYB4rS"),
    ("ICD10", "T52.1", "T52.1 Toxic effect: Benzene", "tSx6YDoteN9"),
    ("ICD10", "T52.2", "T52.2 Toxic effect: Homologues of benzene", "TB7fLzILIQh"),
    ("ICD10", "T52.3", "T52.3 Toxic effect: Glycols", "yzJpEt0B1tF"),
    ("ICD10", "T52.4", "T52.4 Toxic effect: Ketones", "jHtpalIasUx"),
    ("ICD10", "T52.8", "T52.8 Toxic effect: Other organic solvents", "iyK073KzExv"),
    ("ICD10", "T52.9", "T52.9 Toxic effect: Organic solvent, unspecified", "KvLNyo37cG0"),
    ("ICD10", "T53", "T53 Toxic effect of halogen derivatives of aliphatic and aromatic hydrocarbons", "TbAtzqJstFG"),
    ("ICD10", "T53.0", "T53.0 Toxic effect: Carbon tetrachloride", "qtNDulHSb0W"),
    ("ICD10", "T53.1", "T53.1 Toxic effect: Chloroform", "MXJAWTthlrz"),
    ("ICD10", "T53.2", "T53.2 Toxic effect: Trichloroethylene", "F6XeRmJg2nE"),
    ("ICD10", "T53.3", "T53.3 Toxic effect: Tetrachloroethylene", "ZpH9pCvyAaZ"),
    ("ICD10", "T53.4", "T53.4 Toxic effect: Dichloromethane", "y6bb3GIGjYh"),
    ("ICD10", "T53.5", "T53.5 Toxic effect: Chlorofluorocarbons", "FphFS1bV4fu"),
    ("ICD10", "T53.6", "T53.6 Toxic effect: Other halogen derivatives of aliphatic hydrocarbons", "KTb4ri8rcEB"),
    ("ICD10", "T53.7", "T53.7 Toxic effect: Other halogen derivatives of aromatic hydrocarbons", "JGSCdBfNQ3P"),
    ("ICD10", "T53.9", "T53.9 Toxic effect: Halogen derivative of aliphatic and aromatic hydrocarbons, unspecified", "U2legRmh95B"),
    ("ICD10", "T54", "T54 Toxic effect of corrosive substances", "mJ8AOjRqSUg"),
    ("ICD10", "T54.0", "T54.0 Toxic effect: Phenol and phenol homologues", "JHznPg1oFSL"),
    ("ICD10", "T54.1", "T54.1 Toxic effect: Other corrosive organic compounds", "f4HHzIHZkV1"),
    ("ICD10", "T54.2", "T54.2 Toxic effect: Corrosive acids and acid-like substances", "VoDcAOAMFLW"),
    ("ICD10", "T54.3", "T54.3 Toxic effect: Corrosive alkalis and alkali-like substances", "PFYSwEnUmJT"),
    ("ICD10", "T54.9", "T54.9 Toxic effect: Corrosive substance, unspecified", "PMckXY3fYR6"),
    ("ICD10", "T55", "T55 Toxic effect of soaps and detergents", "U4IQ2WvwC2S"),
    ("ICD10", "T56", "T56 Toxic effect of metals", "UbG9EWforXt"),
    ("ICD10", "T56.0", "T56.0 Toxic effect: Lead and its compounds", "KX7xPnPiMB5"),
    ("ICD10", "T56.1", "T56.1 Toxic effect: Mercury and its compounds", "VSxj6YkT13c"),
    ("ICD10", "T56.2", "T56.2 Toxic effect: Chromium and its compounds", "cugxtlyPvu8"),
    ("ICD10", "T56.3", "T56.3 Toxic effect: Cadmium and its compounds", "aOvcIHatAZe"),
    ("ICD10", "T56.4", "T56.4 Toxic effect: Copper and its compounds", "S22D5v8Gakf"),
    ("ICD10", "T56.5", "T56.5 Toxic effect: Zinc and its compounds", "JEeMe2JmGLv"),
    ("ICD10", "T56.6", "T56.6 Toxic effect: Tin and its compounds", "oZ9f3J4B2X1"),
    ("ICD10", "T56.7", "T56.7 Toxic effect: Beryllium and its compounds", "eJzGS2a90dl"),
    ("ICD10", "T56.8", "T56.8 Toxic effect: Other metals", "BaGxgtIUy0B"),
    ("ICD10", "T56.9", "T56.9 Toxic effect: Metal, unspecified", "oJrRKdPF0oa"),
    ("ICD10", "T57", "T57 Toxic effect of other inorganic substances", "gl0Od7OdQqx"),
    ("ICD10", "T57.0", "T57.0 Toxic effect: Arsenic and its compounds", "e2RPYTDpU4m"),
    ("ICD10", "T57.1", "T57.1 Toxic effect: Phosphorus and its compounds", "mc3VbANoVEA"),
    ("ICD10", "T57.2", "T57.2 Toxic effect: Manganese and its compounds", "P6FGchQVpJ2"),
    ("ICD10", "T57.3", "T57.3 Toxic effect: Hydrogen cyanide", "bFxJ73Oqfp9"),
    ("ICD10", "T57.8", "T57.8 Toxic effect: Other specified inorganic substances", "YIxllODQ9tC"),
    ("ICD10", "T57.9", "T57.9 Toxic effect: Inorganic substance, unspecified", "Lqra5YPalAn"),
    ("ICD10", "T58", "T58 Toxic effect of carbon monoxide", "eeFZTuqZ38d"),
    ("ICD10", "T59", "T59 Toxic effect of other gases, fumes and vapours", "pW3sejLpHNr"),
    ("ICD10", "T59.0", "T59.0 Toxic effect: Nitrogen oxides", "ENsoIdMmbHE"),
    ("ICD10", "T59.1", "T59.1 Toxic effect: Sulfur dioxide", "rH2gbTvX3bW"),
    ("ICD10", "T59.2", "T59.2 Toxic effect: Formaldehyde", "UZZSU9ARFFF"),
    ("ICD10", "T59.3", "T59.3 Toxic effect: Lacrimogenic gas", "S9W6tjBTgva"),
    ("ICD10", "T59.4", "T59.4 Toxic effect: Chlorine gas", "N7YfRvKd261"),
    ("ICD10", "T59.5", "T59.5 Toxic effect: Fluorine gas and hydrogen fluoride", "dvqLn7eKFm4"),
    ("ICD10", "T59.6", "T59.6 Toxic effect: Hydrogen sulfide", "cXAnRleDLUB"),
    ("ICD10", "T59.7", "T59.7 Toxic effect: Carbon dioxide", "GKhuKcu11dv"),
    ("ICD10", "T59.8", "T59.8 Toxic effect: Other specified gases, fumes and vapours", "VZHg9mRTXZ9"),
    ("ICD10", "T59.9", "T59.9 Toxic effect: Gases, fumes and vapours, unspecified", "pMBf37vJbvh"),
    ("ICD10", "T60", "T60 Toxic effect of pesticides", "LBANP4rmvcP"),
    ("ICD10", "T60.0", "T60.0 Toxic effect: Organophosphate and carbamate insecticides", "THzIE555kEk"),
    ("ICD10", "T60.1", "T60.1 Toxic effect: Halogenated insecticides", "BDDPiziWrMs"),
    ("ICD10", "T60.2", "T60.2 Toxic effect: Other insecticides", "FckYb5DEqrt"),
    ("ICD10", "T60.3", "T60.3 Toxic effect: Herbicides and fungicides", "jQ1PqLDKCgW"),
    ("ICD10", "T60.4", "T60.4 Toxic effect: Rodenticides", "UlbPuMH7rET"),
    ("ICD10", "T60.8", "T60.8 Toxic effect: Other pesticides", "RlRm1l8c1CK"),
    ("ICD10", "T60.9", "T60.9 Toxic effect: Pesticide, unspecified", "sJ5Wr8PzE0T"),
    ("ICD10", "T61", "T61 Toxic effect of noxious substances eaten as seafood", "s9XOt3h4uKe"),
    ("ICD10", "T61.0", "T61.0 Toxic effect: Ciguatera fish poisoning", "ogvNZRe4YRp"),
    ("ICD10", "T61.1", "T61.1 Toxic effect: Scombroid fish poisoning", "fuKWeboelAZ"),
    ("ICD10", "T61.2", "T61.2 Toxic effect: Other fish and shellfish poisoning", "TIedP4gHENl"),
    ("ICD10", "T61.8", "T61.8 Toxic effect: Toxic effect of other seafoods", "TeR082M5GS4"),
    ("ICD10", "T61.9", "T61.9 Toxic effect: Toxic effect of unspecified seafood", "WUo7CS6JX7S"),
    ("ICD10", "T62", "T62 Toxic effect of other noxious substances eaten as food", "sxUJUfhZNaA"),
    ("ICD10", "T62.0", "T62.0 Toxic effect: Ingested mushrooms", "HJAT6tACFs1"),
    ("ICD10", "T62.1", "T62.1 Toxic effect: Ingested berries", "xZ2awxzoi1U"),
    ("ICD10", "T62.2", "T62.2 Toxic effect: Other ingested (parts of) plant(s)", "cg5QiufjeRp"),
    ("ICD10", "T62.8", "T62.8 Toxic effect: Other specified noxious substances eaten as food", "rMJtES26meU"),
    ("ICD10", "T62.9", "T62.9 Toxic effect: Noxious substance eaten as food, unspecified", "qdDNXLvAlR9"),
    ("ICD10", "T63", "T63 Toxic effect of contact with venomous animals", "yrynXHVIZUr"),
    ("ICD10", "T63.0", "T63.0 Toxic effect: Snake venom", "VmWnCZAlCFv"),
    ("ICD10", "T63.1", "T63.1 Toxic effect: Venom of other reptiles", "vQ1TvAwAzzn"),
    ("ICD10", "T63.2", "T63.2 Toxic effect: Venom of scorpion", "I7RyKrm4X6W"),
    ("ICD10", "T63.3", "T63.3 Toxic effect: Venom of spider", "ofput13iI7N"),
    ("ICD10", "T63.4", "T63.4 Toxic effect: Venom of other arthropods", "U5fEdlbRzsI"),
    ("ICD10", "T63.5", "T63.5 Toxic effect: Toxic effect of contact with fish", "cYRJtUEPEEp"),
    ("ICD10", "T63.6", "T63.6 Toxic effect: Toxic effect of contact with other marine animals", "ArBAQ4xBGYg"),
    ("ICD10", "T63.8", "T63.8 Toxic effect: Toxic effect of contact with other venomous animals", "m9Xmzgej7gF"),
    ("ICD10", "T63.9", "T63.9 Toxic effect: Toxic effect of contact with unspecified venomous animal", "Sq4KToLu5fq"),
    ("ICD10", "T64", "T64 Toxic effect of aflatoxin and other mycotoxin food contaminants", "rIhEDoGaOWn"),
    ("ICD10", "T65", "T65 Toxic effect of other and unspecified substances", "k101aGM3uD2"),
    ("ICD10", "T65.0", "T65.0 Toxic effect: Cyanides", "r90HIv0XqCh"),
    ("ICD10", "T65.1", "T65.1 Toxic effect: Strychnine and its salts", "zGkxJCHGaZz"),
    ("ICD10", "T65.2", "T65.2 Toxic effect: Tobacco and nicotine", "JQHrWhUDvuf"),
    ("ICD10", "T65.3", "T65.3 Toxic effect: Nitroderivatives and aminoderivatives of benzene and its homologues", "XpbVJ8kEOn1"),
    ("ICD10", "T65.4", "T65.4 Toxic effect: Carbon disulfide", "MfNf600V4HJ"),
    ("ICD10", "T65.5", "T65.5 Toxic effect: Nitroglycerin and other nitric acids and esters", "janSQEHnqQW"),
    ("ICD10", "T65.6", "T65.6 Toxic effect: Paints and dyes, not elsewhere classified", "fuMbn2OYKAZ"),
    ("ICD10", "T65.8", "T65.8 Toxic effect: Toxic effect of other specified substances", "UZszSQRrDne"),
    ("ICD10", "T65.9", "T65.9 Toxic effect: Toxic effect of unspecified substance", "nKMDsqCTFRk"),
    ("ICD10", "T66", "T66 Unspecified effects of radiation", "YXlwMsPTMl7"),
    ("ICD10", "T67", "T67 Effects of heat and light", "pzXP5wiaNJd"),
    ("ICD10", "T67.0", "T67.0 Heatstroke and sunstroke", "MJrnFjzRr3x"),
    ("ICD10", "T67.1", "T67.1 Heat syncope", "RbAnxFLyYjZ"),
    ("ICD10", "T67.2", "T67.2 Heat cramp", "qNwRJm7Hegq"),
    ("ICD10", "T67.3", "T67.3 Heat exhaustion, anhydrotic", "bLYrrvReChw"),
    ("ICD10", "T67.4", "T67.4 Heat exhaustion due to salt depletion", "IlbQALacSqz"),
    ("ICD10", "T67.5", "T67.5 Heat exhaustion, unspecified", "CB6eoGSb8dm"),
    ("ICD10", "T67.6", "T67.6 Heat fatigue, transient", "KI8gG4BE1s6"),
    ("ICD10", "T67.7", "T67.7 Heat oedema", "VGu5tpGLEXZ"),
    ("ICD10", "T67.8", "T67.8 Other effects of heat and light", "ADxVkigpYyw"),
    ("ICD10", "T67.9", "T67.9 Effect of heat and light, unspecified", "TFMT6erziX5"),
    ("ICD10", "T68", "T68 Hypothermia", "cvDWaGRReKt"),
    ("ICD10", "T69", "T69 Other effects of reduced temperature", "PjYaqHS3rEF"),
    ("ICD10", "T69.0", "T69.0 Immersion hand and foot", "LVF1AHArsuV"),
    ("ICD10", "T69.1", "T69.1 Chilblains", "uoKe0tTx1sh"),
    ("ICD10", "T69.8", "T69.8 Other specified effects of reduced temperature", "IhWFfQNQpoM"),
    ("ICD10", "T69.9", "T69.9 Effect of reduced temperature, unspecified", "xzmysqfzv3O"),
    ("ICD10", "T70", "T70 Effects of air pressure and water pressure", "GiIVwLJFC7K"),
    ("ICD10", "T70.0", "T70.0 Otitic barotrauma", "NST0t56abVL"),
    ("ICD10", "T70.1", "T70.1 Sinus barotrauma", "edOsEFtta4Y"),
    ("ICD10", "T70.2", "T70.2 Other and unspecified effects of high altitude", "jP2QFzhnRNB"),
    ("ICD10", "T70.3", "T70.3 Caisson disease [decompression sickness]", "oa93N1426Kk"),
    ("ICD10", "T70.4", "T70.4 Effects of high-pressure fluids", "BPefRxo5Kvz"),
    ("ICD10", "T70.8", "T70.8 Other effects of air pressure and water pressure", "Fsmh3wuiWTL"),
    ("ICD10", "T70.9", "T70.9 Effect of air pressure and water pressure, unspecified", "Wbb05T4j0zD"),
    ("ICD10", "T71", "T71 Asphyxiation", "tKZpyu4wmpz"),
    ("ICD10", "T73", "T73 Effects of other deprivation", "nbQ5nfNtEqC"),
    ("ICD10", "T73.0", "T73.0 Effects of hunger", "oMmBQ5NStD2"),
    ("ICD10", "T73.1", "T73.1 Effects of thirst", "fuFp3v7Ad2w"),
    ("ICD10", "T73.2", "T73.2 Exhaustion due to exposure", "PFiojkPU1LN"),
    ("ICD10", "T73.3", "T73.3 Exhaustion due to excessive exertion", "dMnwD1L9KqF"),
    ("ICD10", "T73.8", "T73.8 Other effects of deprivation", "jDFPjKn9gBN"),
    ("ICD10", "T73.9", "T73.9 Effect of deprivation, unspecified", "sz2qQoTI4zX"),
    ("ICD10", "T74", "T74 Maltreatment syndromes", "BqxMwee2d02"),
    ("ICD10", "T74.0", "T74.0 Neglect or abandonment", "ADV5Hw1DMPh"),
    ("ICD10", "T74.1", "T74.1 Physical abuse", "T2RVYaSI0Ns"),
    ("ICD10", "T74.2", "T74.2 Sexual abuse", "HFqJnfAPVxK"),
    ("ICD10", "T74.3", "T74.3 Psychological abuse", "m8sGu6iljFw"),
    ("ICD10", "T74.8", "T74.8 Other maltreatment syndromes", "vuGjH9aqqQW"),
    ("ICD10", "T74.9", "T74.9 Maltreatment syndrome, unspecified", "YC0cotDRfNP"),
    ("ICD10", "T75", "T75 Effects of other external causes", "EfnfgpzO7xS"),
    ("ICD10", "T75.0", "T75.0 Effects of lightning", "iZhipMbYFS2"),
    ("ICD10", "T75.1", "T75.1 Drowning and nonfatal submersion", "orE9cHPs6Z6"),
    ("ICD10", "T75.2", "T75.2 Effects of vibration", "SACQMSFOZrQ"),
    ("ICD10", "T75.3", "T75.3 Motion sickness", "JM0DcrXSuCi"),
    ("ICD10", "T75.4", "T75.4 Effects of electric current", "gggQrWNvJSl"),
    ("ICD10", "T75.8", "T75.8 Other specified effects of external causes", "Q8tZdof6lj9"),
    ("ICD10", "T78", "T78 Adverse effects, not elsewhere classified", "uQDgv5uXZUb"),
    ("ICD10", "T78.0", "T78.0 Anaphylactic shock due to adverse food reaction", "ONAr8lPevWO"),
    ("ICD10", "T78.1", "T78.1 Other adverse food reactions, not elsewhere classified", "h3AYrdbCBst"),
    ("ICD10", "T78.2", "T78.2 Anaphylactic shock, unspecified", "Ib7csxnJdXv"),
    ("ICD10", "T78.3", "T78.3 Angioneurotic oedema", "AH7OMPIyOTI"),
    ("ICD10", "T78.4", "T78.4 Allergy, unspecified", "Jeo8mX73lW3"),
    ("ICD10", "T78.8", "T78.8 Other adverse effects, not elsewhere classified", "Yt1CLpP93u4"),
    ("ICD10", "T78.9", "T78.9 Adverse effect, unspecified", "sz2YGmtMuxK"),
    ("ICD10", "T79", "T79 Certain early complications of trauma, not elsewhere classified", "RbruBYBWRrg"),
    ("ICD10", "T79.0", "T79.0 Air embolism (traumatic)", "eNaeZ5edgqW"),
    ("ICD10", "T79.1", "T79.1 Fat embolism (traumatic)", "pdKkYtl3Ws5"),
    ("ICD10", "T79.2", "T79.2 Traumatic secondary and recurrent haemorrhage", "ENHEnzVda5f"),
    ("ICD10", "T79.3", "T79.3 Post-traumatic wound infection, not elsewhere classified", "jEd2Yn628zV");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "T79.4", "T79.4 Traumatic shock", "vs72qZChN1m"),
    ("ICD10", "T79.5", "T79.5 Traumatic anuria", "XE8WjNsMX8D"),
    ("ICD10", "T79.6", "T79.6 Traumatic ischaemia of muscle", "DVZHYdZ82id"),
    ("ICD10", "T79.7", "T79.7 Traumatic subcutaneous emphysema", "ShvJEaZGzGy"),
    ("ICD10", "T79.8", "T79.8 Other early complications of trauma", "V1HowvLJNoM"),
    ("ICD10", "T79.9", "T79.9 Unspecified early complication of trauma", "qRKmpE9sUMS"),
    ("ICD10", "T80", "T80 Complications following infusion, transfusion and therapeutic injection", "kWiC6GEPHD3"),
    ("ICD10", "T80.0", "T80.0 Air embolism following infusion, transfusion and therapeutic injection", "OIluqeeItpM"),
    ("ICD10", "T80.1", "T80.1 Vascular complications following infusion, transfusion and therapeutic injection", "c4GCTGaMP4Z"),
    ("ICD10", "T80.2", "T80.2 Infections following infusion, transfusion and therapeutic injection", "Cr4jtOhZT9b"),
    ("ICD10", "T80.3", "T80.3 ABO incompatibility reaction", "hoFCxgjBePK"),
    ("ICD10", "T80.4", "T80.4 Rh incompatibility reaction", "GksvkpFU7RS"),
    ("ICD10", "T80.5", "T80.5 Anaphylactic shock due to serum", "AerbF6HwDtz"),
    ("ICD10", "T80.6", "T80.6 Other serum reactions", "gW6B9QWlNiS"),
    ("ICD10", "T80.8", "T80.8 Other complications following infusion, transfusion and therapeutic injection", "wu7tFMmJOeT"),
    ("ICD10", "T80.9", "T80.9 Unspecified complication following infusion, transfusion and therapeutic injection", "kQSa6ZJgxTg"),
    ("ICD10", "T81", "T81 Complications of procedures, not elsewhere classified", "o6NtWF0p9GA"),
    ("ICD10", "T81.0", "T81.0 Haemorrhage and haematoma complicating a procedure, not elsewhere classified", "JvedgzV6BrK"),
    ("ICD10", "T81.1", "T81.1 Shock during or resulting from a procedure, not elsewhere classified", "HAs1TyQFCBH"),
    ("ICD10", "T81.2", "T81.2 Accidental puncture and laceration during a procedure, not elsewhere classified", "hTLaEXk3neO"),
    ("ICD10", "T81.3", "T81.3 Disruption of operation wound, not elsewhere classified", "s1TPD5XAzxl"),
    ("ICD10", "T81.4", "T81.4 Infection following a procedure, not elsewhere classified", "SjWiuABlYOT"),
    ("ICD10", "T81.5", "T81.5 Foreign body accidentally left in body cavity or operation wound following a procedure", "WXrrhF8gM0u"),
    ("ICD10", "T81.6", "T81.6 Acute reaction to foreign substance accidentally left during a procedure", "wnvVpWMiziz"),
    ("ICD10", "T81.7", "T81.7 Vascular complications following a procedure, not elsewhere classified", "dUZlz83o9d8"),
    ("ICD10", "T81.8", "T81.8 Other complications of procedures, not elsewhere classified", "q2IyoXLxx0E"),
    ("ICD10", "T81.9", "T81.9 Unspecified complication of procedure", "iHawmqS6hA6"),
    ("ICD10", "T82", "T82 Complications of cardiac and vascular prosthetic devices, implants and grafts", "gzEGSbqBpdr"),
    ("ICD10", "T82.0", "T82.0 Mechanical complication of heart valve prosthesis", "HJbowpkpVRj"),
    ("ICD10", "T82.1", "T82.1 Mechanical complication of cardiac electronic device", "sJ6p5Z6pxby"),
    ("ICD10", "T82.2", "T82.2 Mechanical complication of coronary artery bypass and valve grafts", "cB4XMqx3O6X"),
    ("ICD10", "T82.3", "T82.3 Mechanical complication of other vascular grafts", "nb477oV9qpg"),
    ("ICD10", "T82.4", "T82.4 Mechanical complication of vascular dialysis catheter", "G8b2eFFnfK0"),
    ("ICD10", "T82.5", "T82.5 Mechanical complication of other cardiac and vascular devices and implants", "cwsulRcj3uc"),
    ("ICD10", "T82.6", "T82.6 Infection and inflammatory reaction due to cardiac valve prosthesis", "caIQ0adtCq4"),
    ("ICD10", "T82.7", "T82.7 Infection and inflammatory reaction due to other cardiac and vascular devices, implants and grafts", "hUJClAof4V7"),
    ("ICD10", "T82.8", "T82.8 Other specified complications of cardiac and vascular prosthetic devices, implants and grafts", "rCHt1A7UhEn"),
    ("ICD10", "T82.9", "T82.9 Unspecified complication of cardiac and vascular prosthetic device, implant and graft", "iAkE35gOqTN"),
    ("ICD10", "T83", "T83 Complications of genitourinary prosthetic devices, implants and grafts", "tW9xR56nswk"),
    ("ICD10", "T83.0", "T83.0 Mechanical complication of urinary (indwelling) catheter", "FyO2ZShEoP1"),
    ("ICD10", "T83.1", "T83.1 Mechanical complication of other urinary devices and implants", "R0Qi7eMWv1h"),
    ("ICD10", "T83.2", "T83.2 Mechanical complication of graft of urinary organ", "uM1txNdDURm"),
    ("ICD10", "T83.3", "T83.3 Mechanical complication of intrauterine contraceptive device", "caPlQ9N4NsD"),
    ("ICD10", "T83.4", "T83.4 Mechanical complication of other prosthetic devices, implants and grafts in genital tract", "nOnuyv3EW8P"),
    ("ICD10", "T83.5", "T83.5 Infection and inflammatory reaction due to prosthetic device, implant and graft in urinary system", "OCkxfzrodv6"),
    ("ICD10", "T83.6", "T83.6 Infection and inflammatory reaction due to prosthetic device, implant and graft in genital tract", "j7UinirZwVV"),
    ("ICD10", "T83.8", "T83.8 Other complications of genitourinary prosthetic devices, implants and grafts", "uIUA2cpjCBX"),
    ("ICD10", "T83.9", "T83.9 Unspecified complication of genitourinary prosthetic device, implant and graft", "qpXEKXZlqlX"),
    ("ICD10", "T84", "T84 Complications of internal orthopaedic prosthetic devices, implants and grafts", "bW1GBhhK8Pg"),
    ("ICD10", "T84.0", "T84.0 Mechanical complication of internal joint prosthesis", "bYa9J66NiHD"),
    ("ICD10", "T84.1", "T84.1 Mechanical complication of internal fixation device of bones of limb", "wROodw1WWej"),
    ("ICD10", "T84.2", "T84.2 Mechanical complication of internal fixation device of other bones", "MVAYQeepqkm"),
    ("ICD10", "T84.3", "T84.3 Mechanical complication of other bone devices, implants and grafts", "wtlzZKTdxXz"),
    ("ICD10", "T84.4", "T84.4 Mechanical complication of other internal orthopaedic devices, implants and grafts", "ZyB8gD0W2zm"),
    ("ICD10", "T84.5", "T84.5 Infection and inflammatory reaction due to internal joint prosthesis", "HNLD8sadW9d"),
    ("ICD10", "T84.6", "T84.6 Infection and inflammatory reaction due to internal fixation device [any site]", "u3un0X77kVr"),
    ("ICD10", "T84.7", "T84.7 Infection and inflammatory reaction due to other internal orthopaedic prosthetic devices, implants and grafts", "Vym4hhulFpt"),
    ("ICD10", "T84.8", "T84.8 Other complications of internal orthopaedic prosthetic devices, implants and grafts", "PGtfKhrebtU"),
    ("ICD10", "T84.9", "T84.9 Unspecified complication of internal orthopaedic prosthetic device, implant and graft", "y5dPj0K3wzJ"),
    ("ICD10", "T85", "T85 Complications of other internal prosthetic devices, implants and grafts", "DsyEzPkD6tA"),
    ("ICD10", "T85.0", "T85.0 Mechanical complication of ventricular intracranial (communicating) shunt", "YMfk4daBnAX"),
    ("ICD10", "T85.1", "T85.1 Mechanical complication of implanted electronic stimulator of nervous system", "NwTsRJxneqF"),
    ("ICD10", "T85.2", "T85.2 Mechanical complication of intraocular lens", "hL3ZuPmAKl8"),
    ("ICD10", "T85.3", "T85.3 Mechanical complication of other ocular prosthetic devices, implants and grafts", "qLtYXqtTeBl"),
    ("ICD10", "T85.4", "T85.4 Mechanical complication of breast prosthesis and implant", "I59S75BS2Vy"),
    ("ICD10", "T85.5", "T85.5 Mechanical complication of gastrointestinal prosthetic devices, implants and grafts", "VmOH3e1AgaK"),
    ("ICD10", "T85.6", "T85.6 Mechanical complication of other specified internal prosthetic devices, implants and grafts", "SKJROkJHBLA"),
    ("ICD10", "T85.7", "T85.7 Infection and inflammatory reaction due to other internal prosthetic devices, implants and grafts", "Bweh81IGil8"),
    ("ICD10", "T85.8", "T85.8 Other complications of internal prosthetic devices, implants and grafts, not elsewhere classified", "NzPLTrkSuTv"),
    ("ICD10", "T85.9", "T85.9 Unspecified complication of internal prosthetic device, implant and graft", "brwTt6Vf0GS"),
    ("ICD10", "T86", "T86 Failure and rejection of transplanted organs and tissues", "eNIR6qHkAWn"),
    ("ICD10", "T86.0", "T86.0 Bone-marrow transplant rejection", "eIhPlrPAbsG"),
    ("ICD10", "T86.1", "T86.1 Kidney transplant failure and rejection", "zCHkfzHZv88"),
    ("ICD10", "T86.2", "T86.2 Heart transplant failure and rejection", "g4rP1k4uTHK"),
    ("ICD10", "T86.3", "T86.3 Heart-lung transplant failure and rejection", "x8GwJRV0mZ2"),
    ("ICD10", "T86.4", "T86.4 Liver transplant failure and rejection", "bEzTpwWNXrp"),
    ("ICD10", "T86.8", "T86.8 Failure and rejection of other transplanted organs and tissues", "ZWYQLpMBaMb"),
    ("ICD10", "T86.9", "T86.9 Failure and rejection of unspecified transplanted organ and tissue", "SxBaXpjC3Oe"),
    ("ICD10", "T87", "T87 Complications peculiar to reattachment and amputation", "ulHneCbyATw"),
    ("ICD10", "T87.0", "T87.0 Complications of reattached (part of) upper extremity", "BE34AEiPOT4"),
    ("ICD10", "T87.1", "T87.1 Complications of reattached (part of) lower extremity", "EiSBww32FaD"),
    ("ICD10", "T87.2", "T87.2 Complications of other reattached body part", "LO2fKwJIbtf"),
    ("ICD10", "T87.3", "T87.3 Neuroma of amputation stump", "FNaSO7ymhF7"),
    ("ICD10", "T87.4", "T87.4 Infection of amputation stump", "FsGWGlvKYop"),
    ("ICD10", "T87.5", "T87.5 Necrosis of amputation stump", "Q2KnczvKtR3"),
    ("ICD10", "T87.6", "T87.6 Other and unspecified complications of amputation stump", "NAfqSCWNCFP"),
    ("ICD10", "T88", "T88 Other complications of surgical and medical care, not elsewhere classified", "wSqqX1IwUEU"),
    ("ICD10", "T88.0", "T88.0 Infection following immunization", "Jt50gnCxnVg"),
    ("ICD10", "T88.1", "T88.1 Other complications following immunization, not elsewhere classified", "nCs7mb5VRkR"),
    ("ICD10", "T88.2", "T88.2 Shock due to anaesthesia", "t0tHUGNsiCT"),
    ("ICD10", "T88.3", "T88.3 Malignant hyperthermia due to anaesthesia", "U09QW3hgcVB"),
    ("ICD10", "T88.4", "T88.4 Failed or difficult intubation", "thfJQTQsLKT"),
    ("ICD10", "T88.5", "T88.5 Other complications of anaesthesia", "KBwaD0XV7tY"),
    ("ICD10", "T88.6", "T88.6 Anaphylactic shock due to adverse effect of correct drug or medicament properly administered", "kQ0m7WU1WMn"),
    ("ICD10", "T88.7", "T88.7 Unspecified adverse effect of drug or medicament", "rHO4Osgg3v2"),
    ("ICD10", "T88.8", "T88.8 Other specified complications of surgical and medical care, not elsewhere classified", "yqCGUsj9IPV"),
    ("ICD10", "T88.9", "T88.9 Complication of surgical and medical care, unspecified", "uAq5hdj91ZF"),
    ("ICD10", "T90", "T90 Sequelae of injuries of head", "y2NVyHfj1aZ"),
    ("ICD10", "T90.0", "T90.0 Sequelae of superficial injury of head", "eRfB4jKp01Y"),
    ("ICD10", "T90.1", "T90.1 Sequelae of open wound of head", "KQkhXdaUYsx"),
    ("ICD10", "T90.2", "T90.2 Sequelae of fracture of skull and facial bones", "phpUh0CVJTd"),
    ("ICD10", "T90.3", "T90.3 Sequelae of injury of cranial nerves", "TOzl8DF4iSH"),
    ("ICD10", "T90.4", "T90.4 Sequelae of injury of eye and orbit", "GsYOQcJCF5J"),
    ("ICD10", "T90.5", "T90.5 Sequelae of intracranial injury", "yA3U1jaHX7L"),
    ("ICD10", "T90.8", "T90.8 Sequelae of other specified injuries of head", "JDYKVfBTmD5"),
    ("ICD10", "T90.9", "T90.9 Sequelae of unspecified injury of head", "c5yZfp8rtLz"),
    ("ICD10", "T91", "T91 Sequelae of injuries of neck and trunk", "rRRrEmDGHiS"),
    ("ICD10", "T91.0", "T91.0 Sequelae of superficial injury and open wound of neck and trunk", "gYTE3vgtip7"),
    ("ICD10", "T91.1", "T91.1 Sequelae of fracture of spine", "oc2MDmkA3ci"),
    ("ICD10", "T91.2", "T91.2 Sequelae of other fracture of thorax and pelvis", "MvgB0AUV4HF"),
    ("ICD10", "T91.3", "T91.3 Sequelae of injury of spinal cord", "T3Vnk7mmUFP"),
    ("ICD10", "T91.4", "T91.4 Sequelae of injury of intrathoracic organs", "irW8BSFvPsi"),
    ("ICD10", "T91.5", "T91.5 Sequelae of injury of intra-abdominal and pelvic organs", "rUil3cybIt5"),
    ("ICD10", "T91.8", "T91.8 Sequelae of other specified injuries of neck and trunk", "pMJ4wCiIbSK"),
    ("ICD10", "T91.9", "T91.9 Sequelae of unspecified injury of neck and trunk", "PpwwRSWMyIV"),
    ("ICD10", "T92", "T92 Sequelae of injuries of upper limb", "fLWM9ORYUe0"),
    ("ICD10", "T92.0", "T92.0 Sequelae of open wound of upper limb", "Wo7Ea3OaleN"),
    ("ICD10", "T92.1", "T92.1 Sequelae of fracture of arm", "jvrb5ee5UDg"),
    ("ICD10", "T92.2", "T92.2 Sequelae of fracture at wrist and hand level", "DTZtZ3BLhpi"),
    ("ICD10", "T92.3", "T92.3 Sequelae of dislocation, sprain and strain of upper limb", "Jn86maGQwPt"),
    ("ICD10", "T92.4", "T92.4 Sequelae of injury of nerve of upper limb", "lwYUJwsusNf"),
    ("ICD10", "T92.5", "T92.5 Sequelae of injury of muscle and tendon of upper limb", "EPE5Y1na5xR"),
    ("ICD10", "T92.6", "T92.6 Sequelae of crushing injury and traumatic amputation of upper limb", "ZsEnuW4QxjQ"),
    ("ICD10", "T92.8", "T92.8 Sequelae of other specified injuries of upper limb", "A2V8EvQHzog"),
    ("ICD10", "T92.9", "T92.9 Sequelae of unspecified injury of upper limb", "P34RGjaIkxt"),
    ("ICD10", "T93", "T93 Sequelae of injuries of lower limb", "iyv06VTJvmS"),
    ("ICD10", "T93.0", "T93.0 Sequelae of open wound of lower limb", "qyeMkgTP2Uk"),
    ("ICD10", "T93.1", "T93.1 Sequelae of fracture of femur", "yxhR16KbfQB"),
    ("ICD10", "T93.2", "T93.2 Sequelae of other fractures of lower limb", "zLSAg6T4Yur"),
    ("ICD10", "T93.3", "T93.3 Sequelae of dislocation, sprain and strain of lower limb", "iYSyHIm0iLB"),
    ("ICD10", "T93.4", "T93.4 Sequelae of injury of nerve of lower limb", "OR4UsEYlAgO"),
    ("ICD10", "T93.5", "T93.5 Sequelae of injury of muscle and tendon of lower limb", "Rhl2JocwJYy"),
    ("ICD10", "T93.6", "T93.6 Sequelae of crushing injury and traumatic amputation of lower limb", "sexpK86bDGo"),
    ("ICD10", "T93.8", "T93.8 Sequelae of other specified injuries of lower limb", "zzAim94QwB2"),
    ("ICD10", "T93.9", "T93.9 Sequelae of unspecified injury of lower limb", "bsfFtsNyAjl"),
    ("ICD10", "T94", "T94 Sequelae of injuries involving multiple and unspecified body regions", "poKiWkunMMQ"),
    ("ICD10", "T94.0", "T94.0 Sequelae of injuries involving multiple body regions", "xgwpVJwUYlq"),
    ("ICD10", "T94.1", "T94.1 Sequelae of injuries, not specified by body region", "woyfUySfSqp"),
    ("ICD10", "T95", "T95 Sequelae of burns, corrosions and frostbite", "MAACRRYTepQ"),
    ("ICD10", "T95.0", "T95.0 Sequelae of burn, corrosion and frostbite of head and neck", "lgJK1eIS0Ke"),
    ("ICD10", "T95.1", "T95.1 Sequelae of burn, corrosion and frostbite of trunk", "ultuiidylWc"),
    ("ICD10", "T95.2", "T95.2 Sequelae of burn, corrosion and frostbite of upper limb", "K0Xg1e61xhS"),
    ("ICD10", "T95.3", "T95.3 Sequelae of burn, corrosion and frostbite of lower limb", "hgSaIb6vfAQ"),
    ("ICD10", "T95.4", "T95.4 Sequelae of burn and corrosion classifiable only according to extent of body surface involved", "aHkL1nybIZM"),
    ("ICD10", "T95.8", "T95.8 Sequelae of other specified burn, corrosion and frostbite", "PH4KUiQQtrv"),
    ("ICD10", "T95.9", "T95.9 Sequelae of unspecified burn, corrosion and frostbite", "FFbKf3yXqeA"),
    ("ICD10", "T96", "T96 Sequelae of poisoning by drugs, medicaments and biological substances", "F7TgFKRunov"),
    ("ICD10", "T97", "T97 Sequelae of toxic effects of substances chiefly nonmedicinal as to source", "O6fTsj188I1"),
    ("ICD10", "T98", "T98 Sequelae of other and unspecified effects of external causes", "ZpqRmjwHh7D"),
    ("ICD10", "T98.0", "T98.0 Sequelae of effects of foreign body entering through natural orifice", "drwRLokzKDm"),
    ("ICD10", "T98.1", "T98.1 Sequelae of other and unspecified effects of external causes", "sJlWaxJaSGU"),
    ("ICD10", "T98.2", "T98.2 Sequelae of certain early complications of trauma", "draSo1EInIc"),
    ("ICD10", "T98.3", "T98.3 Sequelae of complications of surgical and medical care, not elsewhere classified", "zVFZMC8nnyI");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "V01", "V01 Pedestrian injured in collision with pedal cycle", "O7VllQNRmSY"),
    ("ICD10", "V02", "V02 Pedestrian injured in collision with two- or three-wheeled motor vehicle", "lCDfkd9hZCG"),
    ("ICD10", "V03", "V03 Pedestrian injured in collision with car, pick-up truck or van", "La0TlllyWjY"),
    ("ICD10", "V04", "V04 Pedestrian injured in collision with heavy transport vehicle or bus", "ZPOqhwhVJC2"),
    ("ICD10", "V05", "V05 Pedestrian injured in collision with railway train or railway vehicle", "coerMWJiGr3"),
    ("ICD10", "V06", "V06 Pedestrian injured in collision with other nonmotor vehicle", "NhIRbWxib1s"),
    ("ICD10", "V09", "V09 Pedestrian injured in other and unspecified transport accidents", "QZMyuKQpfrk"),
    ("ICD10", "V09.0", "V09.0 Pedestrian injured in nontraffic accident involving other and unspecified motor vehicles", "kx9ojiy7hll"),
    ("ICD10", "V09.1", "V09.1 Pedestrian injured in unspecified nontraffic accident", "vSkhAieaki8"),
    ("ICD10", "V09.2", "V09.2 Pedestrian injured in traffic accident involving other and unspecified motor vehicles", "xAVKMQUElno"),
    ("ICD10", "V09.3", "V09.3 Pedestrian injured in unspecified traffic accident", "JpeipbqWs4D"),
    ("ICD10", "V09.9", "V09.9 Pedestrian injured in unspecified transport accident", "KaHkdDwwxva"),
    ("ICD10", "V10", "V10 Pedal cyclist injured in collision with pedestrian or animal", "eQCUdcuQiY3"),
    ("ICD10", "V11", "V11 Pedal cyclist injured in collision with other pedal cycle", "yeFw54PUTtu"),
    ("ICD10", "V12", "V12 Pedal cyclist injured in collision with two- or three-wheeled motor vehicle", "zbPCISO8hT5"),
    ("ICD10", "V13", "V13 Pedal cyclist injured in collision with car, pick-up truck or van", "DOBExxXSKLR"),
    ("ICD10", "V14", "V14 Pedal cyclist injured in collision with heavy transport vehicle or bus", "xC43oAiWb7W"),
    ("ICD10", "V15", "V15 Pedal cyclist injured in collision with railway train or railway vehicle", "uWZBC2e6OB3"),
    ("ICD10", "V16", "V16 Pedal cyclist injured in collision with other nonmotor vehicle", "SJgB0EWVYM5"),
    ("ICD10", "V17", "V17 Pedal cyclist injured in collision with fixed or stationary object", "cvxAPWRuyU6"),
    ("ICD10", "V18", "V18 Pedal cyclist injured in noncollision transport accident", "AnelepqdCHc"),
    ("ICD10", "V19", "V19 Pedal cyclist injured in other and unspecified transport accidents", "LqXyASt1Vll"),
    ("ICD10", "V19.0", "V19.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "et1asak5E9x"),
    ("ICD10", "V19.1", "V19.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "obkv22wBA2M"),
    ("ICD10", "V19.2", "V19.2 Unspecified pedal cyclist injured in collision with other and unspecified motor vehicles in nontraffic accident", "Am9RAFaruBR"),
    ("ICD10", "V19.3", "V19.3 Pedal cyclist [any] injured in unspecified nontraffic accident", "s6Sm5VcBReI"),
    ("ICD10", "V19.4", "V19.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "oYC89iSpwnG"),
    ("ICD10", "V19.5", "V19.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "vIKrsoCmcHk"),
    ("ICD10", "V19.6", "V19.6 Unspecified pedal cyclist injured in collision with other and unspecified motor vehicles in traffic accident", "BbspyGEs9cp"),
    ("ICD10", "V19.8", "V19.8 Pedal cyclist [any] injured in other specified transport accidents", "eYyDtRveowK"),
    ("ICD10", "V19.9", "V19.9 Pedal cyclist [any] injured in unspecified traffic accident", "TUbXg14xE1W"),
    ("ICD10", "V20", "V20 Motorcycle rider injured in collision with pedestrian or animal", "TbgEbuddYUF"),
    ("ICD10", "V21", "V21 Motorcycle rider injured in collision with pedal cycle", "RYH4hYn1jas"),
    ("ICD10", "V22", "V22 Motorcycle rider injured in collision with two- or three-wheeled motor vehicle", "HXHpP30ijPT"),
    ("ICD10", "V23", "V23 Motorcycle rider injured in collision with car, pick-up truck or van", "xvOLEI5qLAU"),
    ("ICD10", "V24", "V24 Motorcycle rider injured in collision with heavy transport vehicle or bus", "BKL6NCWTDtF"),
    ("ICD10", "V25", "V25 Motorcycle rider injured in collision with railway train or railway vehicle", "j7PMcvsv2VB"),
    ("ICD10", "V26", "V26 Motorcycle rider injured in collision with other nonmotor vehicle", "tcalDlxKgwV"),
    ("ICD10", "V27", "V27 Motorcycle rider injured in collision with fixed or stationary object", "wKgTOgyqR6d"),
    ("ICD10", "V28", "V28 Motorcycle rider injured in noncollision transport accident", "IE1pfjd7EFQ"),
    ("ICD10", "V29", "V29 Motorcycle rider injured in other and unspecified transport accidents", "WLWtABL9UID"),
    ("ICD10", "V29.0", "V29.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "WtOmI4fi8Xc"),
    ("ICD10", "V29.1", "V29.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "lfLDA1hHRJa"),
    ("ICD10", "V29.2", "V29.2 Unspecified motorcycle rider injured in collision with other and unspecified motor vehicles in nontraffic accident", "ptO2YeHgM2B"),
    ("ICD10", "V29.3", "V29.3 Motorcycle rider [any] injured in unspecified nontraffic accident", "BKW5cbEjtSk"),
    ("ICD10", "V29.4", "V29.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "H2uBwmHbN7E"),
    ("ICD10", "V29.5", "V29.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "RBPuD0xpGKV"),
    ("ICD10", "V29.6", "V29.6 Unspecified motorcycle rider injured in collision with other and unspecified motor vehicles in traffic accident", "RhqfKlcXONo"),
    ("ICD10", "V29.8", "V29.8 Motorcycle rider [any] injured in other specified transport accidents", "hogztnDczDU"),
    ("ICD10", "V29.9", "V29.9 Motorcycle rider [any] injured in unspecified traffic accident", "qiIK3FBaMjU"),
    ("ICD10", "V30", "V30 Occupant of three-wheeled motor vehicle injured in collision with pedestrian or animal", "WI4gfrXZXnv"),
    ("ICD10", "V31", "V31 Occupant of three-wheeled motor vehicle injured in collision with pedal cycle", "a3wNTNuCtyI"),
    ("ICD10", "V32", "V32 Occupant of three-wheeled motor vehicle injured in collision with two- or three-wheeled motor vehicle", "w1V7YXjnvy5"),
    ("ICD10", "V33", "V33 Occupant of three-wheeled motor vehicle injured in collision with car, pick-up truck or van", "LTM3XbYLdTV"),
    ("ICD10", "V34", "V34 Occupant of three-wheeled motor vehicle injured in collision with heavy transport vehicle or bus", "ruu5KxzYWgk"),
    ("ICD10", "V35", "V35 Occupant of three-wheeled motor vehicle injured in collision with railway train or railway vehicle", "WaA3ORbQ7gi"),
    ("ICD10", "V36", "V36 Occupant of three-wheeled motor vehicle injured in collision with other nonmotor vehicle", "mR5Hc55n0Be"),
    ("ICD10", "V37", "V37 Occupant of three-wheeled motor vehicle injured in collision with fixed or stationary object", "cMPU6mqWP37"),
    ("ICD10", "V38", "V38 Occupant of three-wheeled motor vehicle injured in noncollision transport accident", "DCyveTCYczV"),
    ("ICD10", "V39", "V39 Occupant of three-wheeled motor vehicle injured in other and unspecified transport accidents", "TnMrCh8JxZS"),
    ("ICD10", "V39.0", "V39.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "z1BF9z3ewrt"),
    ("ICD10", "V39.1", "V39.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "RHFXRatRdFF"),
    ("ICD10", "V39.2", "V39.2 Unspecified occupant of three-wheeled motor vehicle injured in collision with other and unspecified motor vehicles in nontraffic accident", "lKqi97rAYHO"),
    ("ICD10", "V39.3", "V39.3 Occupant [any] of three-wheeled motor vehicle injured in unspecified nontraffic accident", "zN122yEU801"),
    ("ICD10", "V39.4", "V39.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "sYG3vRXoLVH"),
    ("ICD10", "V39.5", "V39.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "CkjCKdaSG23"),
    ("ICD10", "V39.6", "V39.6 Unspecified occupant of three-wheeled motor vehicle injured in collision with other and unspecified motor vehicles in traffic accident", "VFfpbdlgngY"),
    ("ICD10", "V39.8", "V39.8 Occupant [any] of three-wheeled motor vehicle injured in other specified transport accidents", "rly8oIGbLnR"),
    ("ICD10", "V39.9", "V39.9 Occupant [any] of three-wheeled motor vehicle injured in unspecified traffic accident", "IPl455FMTON"),
    ("ICD10", "V40", "V40 Car occupant injured in collision with pedestrian or animal", "R2jqMEhlwGN"),
    ("ICD10", "V41", "V41 Car occupant injured in collision with pedal cycle", "R1RIPD83NNN"),
    ("ICD10", "V42", "V42 Car occupant injured in collision with two- or three-wheeled motor vehicle", "g6zQAi4eUcZ"),
    ("ICD10", "V43", "V43 Car occupant injured in collision with car, pick-up truck or van", "XCR7ZpX5pDV"),
    ("ICD10", "V44", "V44 Car occupant injured in collision with heavy transport vehicle or bus", "ns6Q5ai8MOD"),
    ("ICD10", "V45", "V45 Car occupant injured in collision with railway train or railway vehicle", "kDyO3mgeG6q"),
    ("ICD10", "V46", "V46 Car occupant injured in collision with other nonmotor vehicle", "wpf1nQlPuEj"),
    ("ICD10", "V47", "V47 Car occupant injured in collision with fixed or stationary object", "Gbsk0mvx4Zm"),
    ("ICD10", "V48", "V48 Car occupant injured in noncollision transport accident", "D7p45QEmWxU"),
    ("ICD10", "V49", "V49 Car occupant injured in other and unspecified transport accidents", "k2sYVDYT1AW"),
    ("ICD10", "V49.0", "V49.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "Vycnch105BK"),
    ("ICD10", "V49.1", "V49.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "iRl2RQ7lz4R"),
    ("ICD10", "V49.2", "V49.2 Unspecified car occupant injured in collision with other and unspecified motor vehicles in nontraffic accident", "pfcPVLoNUE4"),
    ("ICD10", "V49.3", "V49.3 Car occupant [any] injured in unspecified nontraffic accident", "BhjfvJDUPwi"),
    ("ICD10", "V49.4", "V49.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "VII8A41Gr4u"),
    ("ICD10", "V49.5", "V49.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "QTV0hsoSJIv"),
    ("ICD10", "V49.6", "V49.6 Unspecified car occupant injured in collision with other and unspecified motor vehicles in traffic accident", "D5PtLbUXrF6"),
    ("ICD10", "V49.8", "V49.8 Car occupant [any] injured in other specified transport accidents", "gnCy9eAvEPz"),
    ("ICD10", "V49.9", "V49.9 Car occupant [any] injured in unspecified traffic accident", "glNvMOhrQD5"),
    ("ICD10", "V50", "V50 Occupant of pick-up truck or van injured in collision with pedestrian or animal", "EOLgZymVME1"),
    ("ICD10", "V51", "V51 Occupant of pick-up truck or van injured in collision with pedal cycle", "bWTb0Hc1YX7"),
    ("ICD10", "V52", "V52 Occupant of pick-up truck or van injured in collision with two- or three-wheeled motor vehicle", "ZDvBmaOwWQK"),
    ("ICD10", "V53", "V53 Occupant of pick-up truck or van injured in collision with car, pick-up truck or van", "DehY0io0LBT"),
    ("ICD10", "V54", "V54 Occupant of pick-up truck or van injured in collision with heavy transport vehicle or bus", "UGjpwFrVyK0"),
    ("ICD10", "V55", "V55 Occupant of pick-up truck or van injured in collision with railway train or railway vehicle", "yyogcUxYB1r"),
    ("ICD10", "V56", "V56 Occupant of pick-up truck or van injured in collision with other nonmotor vehicle", "iMwEq6gJbgm"),
    ("ICD10", "V57", "V57 Occupant of pick-up truck or van injured in collision with fixed or stationary object", "VRXa7ZExxoR"),
    ("ICD10", "V58", "V58 Occupant of pick-up truck or van injured in noncollision transport accident", "FikeFeKXU2Y"),
    ("ICD10", "V59", "V59 Occupant of pick-up truck or van injured in other and unspecified transport accidents", "hwkfHCDeco5"),
    ("ICD10", "V59.0", "V59.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "UWoTGiSlx6x"),
    ("ICD10", "V59.1", "V59.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "d2VljNFySDw"),
    ("ICD10", "V59.2", "V59.2 Unspecified occupant of pick-up truck or van injured in collision with other and unspecified motor vehicles in nontraffic accident", "wMP1NFIUbKV"),
    ("ICD10", "V59.3", "V59.3 Occupant [any] of pick-up truck or van injured in unspecified nontraffic accident", "qFbJmijBPn6"),
    ("ICD10", "V59.4", "V59.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "UwxDfuHrpXK"),
    ("ICD10", "V59.5", "V59.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "NzktTzWp7FY"),
    ("ICD10", "V59.6", "V59.6 Unspecified occupant of pick-up truck or van injured in collision with other and unspecified motor vehicles in traffic accident", "QAYtau8AJ7N"),
    ("ICD10", "V59.8", "V59.8 Occupant [any] of pick-up truck or van injured in other specified transport accidents", "GVuT96KifhJ"),
    ("ICD10", "V59.9", "V59.9 Occupant [any] of pick-up truck or van injured in unspecified traffic accident", "RzsDbBkzhIG"),
    ("ICD10", "V60", "V60 Occupant of heavy transport vehicle injured in collision with pedestrian or animal", "gWmSCvCUEbu"),
    ("ICD10", "V61", "V61 Occupant of heavy transport vehicle injured in collision with pedal cycle", "BV9O5mEH02N"),
    ("ICD10", "V62", "V62 Occupant of heavy transport vehicle injured in collision with two- or three-wheeled motor vehicle", "chSSnN20wt7"),
    ("ICD10", "V63", "V63 Occupant of heavy transport vehicle injured in collision with car, pick-up truck or van", "GxsEbE2lYmg"),
    ("ICD10", "V64", "V64 Occupant of heavy transport vehicle injured in collision with heavy transport vehicle or bus", "VecIIB2XgWs"),
    ("ICD10", "V65", "V65 Occupant of heavy transport vehicle injured in collision with railway train or railway vehicle", "Cv3w4Dwz4VA"),
    ("ICD10", "V66", "V66 Occupant of heavy transport vehicle injured in collision with other nonmotor vehicle", "BXEs00kGcLA"),
    ("ICD10", "V67", "V67 Occupant of heavy transport vehicle injured in collision with fixed or stationary object", "kizud9p2J6w"),
    ("ICD10", "V68", "V68 Occupant of heavy transport vehicle injured in noncollision transport accident", "N1OpTQXsdth"),
    ("ICD10", "V69", "V69 Occupant of heavy transport vehicle injured in other and unspecified transport accidents", "wfHWW8kVsFs"),
    ("ICD10", "V69.0", "V69.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "nVa6a3r49E5"),
    ("ICD10", "V69.1", "V69.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "C9NQ5SZ2zU9"),
    ("ICD10", "V69.2", "V69.2 Unspecified occupant of heavy transport vehicle injured in collision with other and unspecified motor vehicles in nontraffic accident", "aptqeBucBMZ"),
    ("ICD10", "V69.3", "V69.3 Occupant [any] of heavy transport vehicle injured in unspecified nontraffic accident", "lkM4P3j9Frz"),
    ("ICD10", "V69.4", "V69.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "RJpVDkdya0y"),
    ("ICD10", "V69.5", "V69.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "ZM2nrBzVFtd"),
    ("ICD10", "V69.6", "V69.6 Unspecified occupant of heavy transport vehicle injured in collision with other and unspecified motor vehicles in traffic accident", "ilrCL3xrGfV"),
    ("ICD10", "V69.8", "V69.8 Occupant [any] of heavy transport vehicle injured in other specified transport accidents", "fM2IqAlI4GT"),
    ("ICD10", "V69.9", "V69.9 Occupant [any] of heavy transport vehicle injured in unspecified traffic accident", "zDaOiFBz4By"),
    ("ICD10", "V70", "V70 Bus occupant injured in collision with pedestrian or animal", "zYddQh20auX"),
    ("ICD10", "V71", "V71 Bus occupant injured in collision with pedal cycle", "Icwriyxkw61"),
    ("ICD10", "V72", "V72 Bus occupant injured in collision with two- or three-wheeled motor vehicle", "IAbvoln7BYQ"),
    ("ICD10", "V73", "V73 Bus occupant injured in collision with car, pick-up truck or van", "jsikYrR8041"),
    ("ICD10", "V74", "V74 Bus occupant injured in collision with heavy transport vehicle or bus", "j4F3kRHoDFK"),
    ("ICD10", "V75", "V75 Bus occupant injured in collision with railway train or railway vehicle", "CSQtrKPbVhV"),
    ("ICD10", "V76", "V76 Bus occupant injured in collision with other nonmotor vehicle", "Iu4zMAPb6ga"),
    ("ICD10", "V77", "V77 Bus occupant injured in collision with fixed or stationary object", "XdqmfKeV28s"),
    ("ICD10", "V78", "V78 Bus occupant injured in noncollision transport accident", "odMHNhnaHFT"),
    ("ICD10", "V79", "V79 Bus occupant injured in other and unspecified transport accidents", "w3fa5YU64mZ"),
    ("ICD10", "V79.0", "V79.0 Driver injured in collision with other and unspecified motor vehicles in nontraffic accident", "G5XFaKGn1NW"),
    ("ICD10", "V79.1", "V79.1 Passenger injured in collision with other and unspecified motor vehicles in nontraffic accident", "mYZaEHFj1H8"),
    ("ICD10", "V79.2", "V79.2 Unspecified bus occupant injured in collision with other and unspecified motor vehicles in nontraffic accident", "JIHtRGOBVK2"),
    ("ICD10", "V79.3", "V79.3 Bus occupant [any] injured in unspecified nontraffic accident", "RyvXjh0yTVr"),
    ("ICD10", "V79.4", "V79.4 Driver injured in collision with other and unspecified motor vehicles in traffic accident", "lg7RHDcES2P"),
    ("ICD10", "V79.5", "V79.5 Passenger injured in collision with other and unspecified motor vehicles in traffic accident", "CwdvUuFGIff"),
    ("ICD10", "V79.6", "V79.6 Unspecified bus occupant injured in collision with other and unspecified motor vehicles in traffic accident", "z0Xgqi9bPg7"),
    ("ICD10", "V79.8", "V79.8 Bus occupant [any] injured in other specified transport accidents", "RttTofHXOcT"),
    ("ICD10", "V79.9", "V79.9 Bus occupant [any] injured in unspecified traffic accident", "Ult0YgAhltA"),
    ("ICD10", "V80", "V80 Animal-rider or occupant of animal-drawn vehicle injured in transport accident", "kBqo3Qnr2CL"),
    ("ICD10", "V80.0", "V80.0 Rider or occupant injured by fall from or being thrown from animal or animal-drawn vehicle in noncollision accident", "XfXgwDTCtHp"),
    ("ICD10", "V80.1", "V80.1 Rider or occupant injured in collision with pedestrian or animal", "vZcGO77CGNp"),
    ("ICD10", "V80.2", "V80.2 Rider or occupant injured in collision with pedal cycle", "JeeWg3MX8rW"),
    ("ICD10", "V80.3", "V80.3 Rider or occupant injured in collision with two- or three-wheeled motor vehicle", "EyB1htP6x47"),
    ("ICD10", "V80.4", "V80.4 Rider or occupant injured in collision with car, pick-up truck, van, heavy transport vehicle or bus", "q1k2KOYvkJ0"),
    ("ICD10", "V80.5", "V80.5 Rider or occupant injured in collision with other specified motor vehicle", "KgptnJIZJT4"),
    ("ICD10", "V80.6", "V80.6 Rider or occupant injured in collision with railway train or railway vehicle", "IAwlGF39L4y"),
    ("ICD10", "V80.7", "V80.7 Rider or occupant injured in collision with other nonmotor vehicle", "nDUpr9QMpDI"),
    ("ICD10", "V80.8", "V80.8 Rider or occupant injured in collision with fixed or stationary object", "U55IEthkwIs"),
    ("ICD10", "V80.9", "V80.9 Rider or occupant injured in other and unspecified transport accidents", "ZnTKwhYFw9o"),
    ("ICD10", "V81", "V81 Occupant of railway train or railway vehicle injured in transport accident", "RZChZZ3sPB2"),
    ("ICD10", "V81.0", "V81.0 Occupant of railway train or railway vehicle injured in collision with motor vehicle in nontraffic accident", "skmJEHcngk7"),
    ("ICD10", "V81.1", "V81.1 Occupant of railway train or railway vehicle injured in collision with motor vehicle in traffic accident", "B1oBrdNxvCT"),
    ("ICD10", "V81.2", "V81.2 Occupant of railway train or railway vehicle injured in collision with or hit by rolling stock", "gOnjIXUKQHR"),
    ("ICD10", "V81.3", "V81.3 Occupant of railway train or railway vehicle injured in collision with other object", "BslzYZE0kPo"),
    ("ICD10", "V81.4", "V81.4 Person injured while boarding or alighting from railway train or railway vehicle", "vHnAPwf950i"),
    ("ICD10", "V81.5", "V81.5 Occupant of railway train or railway vehicle injured by fall in railway train or railway vehicle", "tBACNdQjsxF"),
    ("ICD10", "V81.6", "V81.6 Occupant of railway train or railway vehicle injured by fall from railway train or railway vehicle", "s4hJm4K8udK"),
    ("ICD10", "V81.7", "V81.7 Occupant of railway train or railway vehicle injured in derailment without antecedent collision", "pH2xLi6dH77"),
    ("ICD10", "V81.8", "V81.8 Occupant of railway train or railway vehicle injured in other specified railway accidents", "oVFbKnc3i3F"),
    ("ICD10", "V81.9", "V81.9 Occupant of railway train or railway vehicle injured in unspecified railway accident", "HMtMSu3BmcF"),
    ("ICD10", "V82", "V82 Occupant of streetcar injured in transport accident", "h1J0AaZPKCJ"),
    ("ICD10", "V82.0", "V82.0 Occupant of streetcar injured in collision with motor vehicle in nontraffic accident", "x8DvfreP7pg"),
    ("ICD10", "V82.1", "V82.1 Occupant of streetcar injured in collision with motor vehicle in traffic accident", "ZmNcvkMRYse"),
    ("ICD10", "V82.2", "V82.2 Occupant of streetcar injured in collision with or hit by rolling stock", "FbPOMUzPOo0"),
    ("ICD10", "V82.3", "V82.3 Occupant of streetcar injured in collision with other object", "Or6FGoVABae"),
    ("ICD10", "V82.4", "V82.4 Person injured while boarding or alighting from streetcar", "dZDPgKY8E5q"),
    ("ICD10", "V82.5", "V82.5 Occupant of streetcar injured by fall in streetcar", "gO0Tcl2PsRs"),
    ("ICD10", "V82.6", "V82.6 Occupant of streetcar injured by fall from streetcar", "XM8dBcOozLu"),
    ("ICD10", "V82.7", "V82.7 Occupant of streetcar injured in derailment without antecedent collision", "GFq2aOdCPv1"),
    ("ICD10", "V82.8", "V82.8 Occupant of streetcar injured in other specified transport accidents", "asqpvPVkLps"),
    ("ICD10", "V82.9", "V82.9 Occupant of streetcar injured in unspecified traffic accident", "LQVoEJVora0"),
    ("ICD10", "V83", "V83 Occupant of special vehicle mainly used on industrial premises injured in transport accident", "QdqUghyW0AX"),
    ("ICD10", "V83.0", "V83.0 Driver of special industrial vehicle injured in traffic accident", "GtfUwSaNQwa"),
    ("ICD10", "V83.1", "V83.1 Passenger of special industrial vehicle injured in traffic accident", "Pf9KQZD51Zz"),
    ("ICD10", "V83.2", "V83.2 Person on outside of special industrial vehicle injured in traffic accident", "LRyJsalocbF"),
    ("ICD10", "V83.3", "V83.3 Unspecified occupant of special industrial vehicle injured in traffic accident", "wLqkQQvwFA3"),
    ("ICD10", "V83.4", "V83.4 Person injured while boarding or alighting from special industrial vehicle", "wu1MTsCi5gL"),
    ("ICD10", "V83.5", "V83.5 Driver of special industrial vehicle injured in nontraffic accident", "KBiaxj057lE"),
    ("ICD10", "V83.6", "V83.6 Passenger of special industrial vehicle injured in nontraffic accident", "TnMvvPQenIY"),
    ("ICD10", "V83.7", "V83.7 Person on outside of special industrial vehicle injured in nontraffic accident", "dq5EnMuJKyt"),
    ("ICD10", "V83.9", "V83.9 Unspecified occupant of special industrial vehicle injured in nontraffic accident", "K3s2XPF8jbX"),
    ("ICD10", "V84", "V84 Occupant of special vehicle mainly used in agriculture injured in transport accident", "AVefHmYLAKK"),
    ("ICD10", "V84.0", "V84.0 Driver of special agricultural vehicle injured in traffic accident", "iOYjLrkF6v7"),
    ("ICD10", "V84.1", "V84.1 Passenger of special agricultural vehicle injured in traffic accident", "ImEghfRcU4D"),
    ("ICD10", "V84.2", "V84.2 Person on outside of special agricultural vehicle injured in traffic accident", "p03Odog1pde"),
    ("ICD10", "V84.3", "V84.3 Unspecified occupant of special agricultural vehicle injured in traffic accident", "YZFNVYKru8s"),
    ("ICD10", "V84.4", "V84.4 Person injured while boarding or alighting from special agricultural vehicle", "yGkJPaBBiIE"),
    ("ICD10", "V84.5", "V84.5 Driver of special agricultural vehicle injured in nontraffic accident", "OBpqChXC8uQ"),
    ("ICD10", "V84.6", "V84.6 Passenger of special agricultural vehicle injured in nontraffic accident", "zJaPpint0wq"),
    ("ICD10", "V84.7", "V84.7 Person on outside of special agricultural vehicle injured in nontraffic accident", "X9yTgJ6pz3s"),
    ("ICD10", "V84.9", "V84.9 Unspecified occupant of special agricultural vehicle injured in nontraffic accident", "ynyzJBQnjAb"),
    ("ICD10", "V85", "V85 Occupant of special construction vehicle injured in transport accident", "F0GDMIqexBa"),
    ("ICD10", "V85.0", "V85.0 Driver of special construction vehicle injured in traffic accident", "F5EQk3UiCsQ"),
    ("ICD10", "V85.1", "V85.1 Passenger of special construction vehicle injured in traffic accident", "tu3uNctkFPc"),
    ("ICD10", "V85.2", "V85.2 Person on outside of special construction vehicle injured in traffic accident", "fGDEBU9B2nv"),
    ("ICD10", "V85.3", "V85.3 Unspecified occupant of special construction vehicle injured in traffic accident", "ZhmeHz5713E"),
    ("ICD10", "V85.4", "V85.4 Person injured while boarding or alighting from special construction vehicle", "N4PP055Qgzu"),
    ("ICD10", "V85.5", "V85.5 Driver of special construction vehicle injured in nontraffic accident", "EkpYqXzod15"),
    ("ICD10", "V85.6", "V85.6 Passenger of special construction vehicle injured in nontraffic accident", "uVF9h3YboH3"),
    ("ICD10", "V85.7", "V85.7 Person on outside of special construction vehicle injured in nontraffic accident", "Ws4GWaUKSjz"),
    ("ICD10", "V85.9", "V85.9 Unspecified occupant of special construction vehicle injured in nontraffic accident", "EZUIUn5Oz3x"),
    ("ICD10", "V86", "V86 Occupant of special all-terrain or other motor vehicle designed primarily for off-road use, injured in transport accident", "qlv3IesD9Xn"),
    ("ICD10", "V86.0", "V86.0 Driver of all-terrain or other off-road motor vehicle injured in traffic accident", "mkWDItH9ERR"),
    ("ICD10", "V86.1", "V86.1 Passenger of all-terrain or other off-road motor vehicle injured in traffic accident", "xBRTOuyfz6J"),
    ("ICD10", "V86.2", "V86.2 Person on outside of all-terrain or other off-road motor vehicle injured in traffic accident", "WkHjHne5tE2"),
    ("ICD10", "V86.3", "V86.3 Unspecified occupant of all-terrain or other off-road motor vehicle injured in traffic accident", "Rgl6V8IY0Wx"),
    ("ICD10", "V86.4", "V86.4 Person injured while boarding or alighting from all-terrain or other off-road motor vehicle", "l25ylxm6eSH"),
    ("ICD10", "V86.5", "V86.5 Driver of all-terrain or other off-road motor vehicle injured in nontraffic accident", "ZSbpO8XZLrp"),
    ("ICD10", "V86.6", "V86.6 Passenger of all-terrain or other off-road motor vehicle injured in nontraffic accident", "HAOiLeVPEE5"),
    ("ICD10", "V86.7", "V86.7 Person on outside of all-terrain or other off-road motor vehicle injured in nontraffic accident", "qsFTM156S29"),
    ("ICD10", "V86.9", "V86.9 Unspecified occupant of all-terrain or other off-road motor vehicle injured in nontraffic accident", "ncoW2Vgq61k"),
    ("ICD10", "V87", "V87 Traffic accident of specified type but victim's mode of transport unknown", "SdNYqwjlvK0"),
    ("ICD10", "V87.0", "V87.0 Person injured in collision between car and two- or three-wheeled motor vehicle (traffic)", "Yk1iVsy3hvV"),
    ("ICD10", "V87.1", "V87.1 Person injured in collision between other motor vehicle and two- or three-wheeled motor vehicle (traffic)", "GlNNYKUnZHK"),
    ("ICD10", "V87.2", "V87.2 Person injured in collision between car and pick-up truck or van (traffic)", "H6Kr8py5E6B"),
    ("ICD10", "V87.3", "V87.3 Person injured in collision between car and bus (traffic)", "ENFXZjvzgdu"),
    ("ICD10", "V87.4", "V87.4 Person injured in collision between car and heavy transport vehicle (traffic)", "ybBUpNS8LTI"),
    ("ICD10", "V87.5", "V87.5 Person injured in collision between heavy transport vehicle and bus (traffic)", "NER5yUGXA3j"),
    ("ICD10", "V87.6", "V87.6 Person injured in collision between railway train or railway vehicle and car (traffic)", "m4rZKcN1lyy"),
    ("ICD10", "V87.7", "V87.7 Person injured in collision between other specified motor vehicles (traffic)", "sMTAcwqodWi"),
    ("ICD10", "V87.8", "V87.8 Person injured in other specified noncollision transport accidents involving motor vehicle (traffic)", "OAryFktJUBZ"),
    ("ICD10", "V87.9", "V87.9 Person injured in other specified (collision)(noncollision) transport accidents involving nonmotor vehicle (traffic)", "uALmhJHtkho"),
    ("ICD10", "V88", "V88 Nontraffic accident of specified type but victim's mode of transport unknown", "RVi8UY1bC4t"),
    ("ICD10", "V88.0", "V88.0 Person injured in collision between car and two- or three-wheeled motor vehicle, nontraffic", "rskSfgKPCqS"),
    ("ICD10", "V88.1", "V88.1 Person injured in collision between other motor vehicle and two- or three-wheeled motor vehicle, nontraffic", "ZmnFWUvlbjE"),
    ("ICD10", "V88.2", "V88.2 Person injured in collision between car and pick-up truck or van, nontraffic", "R5BQ3MrGf3d"),
    ("ICD10", "V88.3", "V88.3 Person injured in collision between car and bus, nontraffic", "LfoL0Jdnlq5"),
    ("ICD10", "V88.4", "V88.4 Person injured in collision between car and heavy transport vehicle, nontraffic", "fsZ3lpFgR8q"),
    ("ICD10", "V88.5", "V88.5 Person injured in collision between heavy transport vehicle and bus, nontraffic", "AFIdTD5CBTj"),
    ("ICD10", "V88.6", "V88.6 Person injured in collision between railway train or railway vehicle and car, nontraffic", "LRBcSRAxfCi"),
    ("ICD10", "V88.7", "V88.7 Person injured in collision between other specified motor vehicles, nontraffic", "Ttj0mwKioMG"),
    ("ICD10", "V88.8", "V88.8 Person injured in other specified noncollision transport accidents involving motor vehicle, nontraffic", "D0eyt9aeawC"),
    ("ICD10", "V88.9", "V88.9 Person injured in other specified (collision)(noncollision) transport accidents involving nonmotor vehicle, nontraffic", "b9Ipe7JLF5M"),
    ("ICD10", "V89", "V89 Motor- or nonmotor-vehicle accident, type of vehicle unspecified", "uAEQFxw8eJP"),
    ("ICD10", "V89.0", "V89.0 Person injured in unspecified motor-vehicle accident, nontraffic", "acjOji1Me6s"),
    ("ICD10", "V89.1", "V89.1 Person injured in unspecified nonmotor-vehicle accident, nontraffic", "KPto58GoG8T"),
    ("ICD10", "V89.2", "V89.2 Person injured in unspecified motor-vehicle accident, traffic", "Cg4vwBIeria"),
    ("ICD10", "V89.3", "V89.3 Person injured in unspecified nonmotor-vehicle accident, traffic", "HJcwvPzrxuN"),
    ("ICD10", "V89.9", "V89.9 Person injured in unspecified vehicle accident", "SWvDhY58XLm"),
    ("ICD10", "V90", "V90 Accident to watercraft causing drowning and submersion", "eJkxNbtM4RE"),
    ("ICD10", "V91", "V91 Accident to watercraft causing other injury", "SQiVDkyPoPB"),
    ("ICD10", "V92", "V92 Water-transport-related drowning and submersion without accident to watercraft", "gLbLjq0bcOB"),
    ("ICD10", "V93", "V93 Accident on board watercraft without accident to watercraft, not causing drowning and submersion", "ZQ4hL733I1b"),
    ("ICD10", "V94", "V94 Other and unspecified water transport accidents", "DZESwU5iIuK"),
    ("ICD10", "V95", "V95 Accident to powered aircraft causing injury to occupant", "xt98iMl7vqN"),
    ("ICD10", "V95.0", "V95.0 Helicopter accident injuring occupant", "J4XazR3JvyB"),
    ("ICD10", "V95.1", "V95.1 Ultralight, microlight or powered-glider accident injuring occupant", "DIMPORS2r3h"),
    ("ICD10", "V95.2", "V95.2 Accident to other private fixed-wing aircraft, injuring occupant", "UJ20dAp4J8i"),
    ("ICD10", "V95.3", "V95.3 Accident to commercial fixed-wing aircraft, injuring occupant", "eHlaxj5dBiP"),
    ("ICD10", "V95.4", "V95.4 Spacecraft accident injuring occupant", "ZlW1pXH74Os"),
    ("ICD10", "V95.8", "V95.8 Other aircraft accidents injuring occupant", "uDZ5EIIjQmN"),
    ("ICD10", "V95.9", "V95.9 Unspecified aircraft accident injuring occupant", "lWbaFAdwiEy"),
    ("ICD10", "V96", "V96 Accident to nonpowered aircraft causing injury to occupant", "i8fmv1gJkg5"),
    ("ICD10", "V96.0", "V96.0 Balloon accident injuring occupant", "qnCSRgFV4gp"),
    ("ICD10", "V96.1", "V96.1 Hang-glider accident injuring occupant", "QnierVG17MJ"),
    ("ICD10", "V96.2", "V96.2 Glider (nonpowered) accident injuring occupant", "cGDLCMjuQgP"),
    ("ICD10", "V96.8", "V96.8 Other nonpowered-aircraft accidents injuring occupant", "VNdKpnI2y5E"),
    ("ICD10", "V96.9", "V96.9 Unspecified nonpowered-aircraft accident injuring occupant", "bE6pBb0AX2C"),
    ("ICD10", "V97", "V97 Other specified air transport accidents", "haieRHC8am0"),
    ("ICD10", "V97.0", "V97.0 Occupant of aircraft injured in other specified air transport accidents", "aEd5SUuejX0"),
    ("ICD10", "V97.1", "V97.1 Person injured while boarding or alighting from aircraft", "SVeiwA54OzP"),
    ("ICD10", "V97.2", "V97.2 Parachutist injured in air transport accident", "KNCGASAZCCw"),
    ("ICD10", "V97.3", "V97.3 Person on ground injured in air transport accident", "Lo7IMxymGTv"),
    ("ICD10", "V97.8", "V97.8 Other air transport accidents, not elsewhere classified", "rB7Nack3FPS"),
    ("ICD10", "V98", "V98 Other specified transport accidents", "q0KgX4LUlf2"),
    ("ICD10", "V99", "V99 Unspecified transport accident", "dX0eJ7msrYo");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "W00", "W00 Fall on same level involving ice and snow", "LModBeuNIrm"),
    ("ICD10", "W01", "W01 Fall on same level from slipping, tripping and stumbling", "pUPDIoUXP4l"),
    ("ICD10", "W02", "W02 Fall involving ice-skates, skis, roller-skates or skateboards", "XBcuMlDOCcX"),
    ("ICD10", "W03", "W03 Other fall on same level due to collision with, or pushing by, another person", "hUmCampnL50"),
    ("ICD10", "W04", "W04 Fall while being carried or supported by other persons", "Jn8TTf3U2tQ"),
    ("ICD10", "W05", "W05 Fall involving wheelchair", "aI4Cspa6I3L"),
    ("ICD10", "W06", "W06 Fall involving bed", "rKgcLhD3G7d"),
    ("ICD10", "W07", "W07 Fall involving chair", "Ccj7YLTbfz7"),
    ("ICD10", "W08", "W08 Fall involving other furniture", "Oz60WjvDpyA"),
    ("ICD10", "W09", "W09 Fall involving playground equipment", "mP6FEnQALtK"),
    ("ICD10", "W10", "W10 Fall on and from stairs and steps", "kfqcivyC4vu"),
    ("ICD10", "W11", "W11 Fall on and from ladder", "xCRFzgtFuZz"),
    ("ICD10", "W12", "W12 Fall on and from scaffolding", "ITjWngtWfuD"),
    ("ICD10", "W13", "W13 Fall from, out of or through building or structure", "uUSn10yIlq3"),
    ("ICD10", "W14", "W14 Fall from tree", "bEh38XmfVp2"),
    ("ICD10", "W15", "W15 Fall from cliff", "tkYkd61LEEH"),
    ("ICD10", "W16", "W16 Diving or jumping into water causing injury other than drowning or submersion", "GOF3EEQNTeJ"),
    ("ICD10", "W17", "W17 Other fall from one level to another", "MHH7BymBFru"),
    ("ICD10", "W18", "W18 Other fall on same level", "aJWXFqaRy37"),
    ("ICD10", "W19", "W19 Unspecified fall", "UbngCUhkmYW"),
    ("ICD10", "W20", "W20 Struck by thrown, projected or falling object", "rmX1PmsCIAt"),
    ("ICD10", "W21", "W21 Striking against or struck by sports equipment", "Q4CXrlIMQOC"),
    ("ICD10", "W22", "W22 Striking against or struck by other objects", "ohuzNyljLwU"),
    ("ICD10", "W23", "W23 Caught, crushed, jammed or pinched in or between objects", "qvJoTnZ2t2R"),
    ("ICD10", "W24", "W24 Contact with lifting and transmission devices, not elsewhere classified", "H6w9o7co2pG"),
    ("ICD10", "W25", "W25 Contact with sharp glass", "XheiHh9eSVn"),
    ("ICD10", "W26", "W26 Contact with other sharp object(s)", "YYVUZmJuCa5"),
    ("ICD10", "W26.0", "W26.0 Contact with knife, sword or dagger", "g3FhGSz8iaY"),
    ("ICD10", "W26.8", "W26.8 Contact with other sharp object(s), not elsewhere classified", "vH5WBq1nq0h"),
    ("ICD10", "W26.9", "W26.9 Contact with unspecified sharp object(s)", "JlIoON7nblY"),
    ("ICD10", "W27", "W27 Contact with nonpowered hand tool", "ycalWrNavUW"),
    ("ICD10", "W28", "W28 Contact with powered lawnmower", "htv1TgppN5X"),
    ("ICD10", "W29", "W29 Contact with other powered hand tools and household machinery", "rdNplmcyQSL"),
    ("ICD10", "W30", "W30 Contact with agricultural machinery", "eXT1cVnpEID"),
    ("ICD10", "W31", "W31 Contact with other and unspecified machinery", "LigorKboklW"),
    ("ICD10", "W32", "W32 Handgun discharge", "DxgEDPFn9kG"),
    ("ICD10", "W33", "W33 Rifle, shotgun and larger firearm discharge", "AwkxyOsW1Ky"),
    ("ICD10", "W34", "W34 Discharge from other and unspecified firearms", "Mjei2qhalW9"),
    ("ICD10", "W35", "W35 Explosion and rupture of boiler", "ag0l4SnXhss"),
    ("ICD10", "W36", "W36 Explosion and rupture of gas cylinder", "EYaIeikOrsF"),
    ("ICD10", "W37", "W37 Explosion and rupture of pressurized tyre, pipe or hose", "uZHGxflQawr"),
    ("ICD10", "W38", "W38 Explosion and rupture of other specified pressurized devices", "QWwdNf892N8"),
    ("ICD10", "W39", "W39 Discharge of firework", "sKT9kW5zc0s"),
    ("ICD10", "W40", "W40 Explosion of other materials", "PVnMhwszZno"),
    ("ICD10", "W41", "W41 Exposure to high-pressure jet", "kZIQlOBdk8J"),
    ("ICD10", "W42", "W42 Exposure to noise", "RNaLgUfeunp"),
    ("ICD10", "W43", "W43 Exposure to vibration", "fIhAyp7WaPf"),
    ("ICD10", "W44", "W44 Foreign body entering into or through eye or natural orifice", "zLmDcwCdtC5"),
    ("ICD10", "W45", "W45 Foreign body or object entering through skin", "iek2x1SWHed"),
    ("ICD10", "W46", "W46 Contact with hypodermic needle", "ItKThb0wwqa"),
    ("ICD10", "W49", "W49 Exposure to other and unspecified inanimate mechanical forces", "CGIY5Sz62AY"),
    ("ICD10", "W50", "W50 Hit, struck, kicked, twisted, bitten or scratched by another person", "oNQytTYq2qi"),
    ("ICD10", "W51", "W51 Striking against or bumped into by another person", "g32ZehMQ4lf"),
    ("ICD10", "W52", "W52 Crushed, pushed or stepped on by crowd or human stampede", "cvdhssdjXOS"),
    ("ICD10", "W53", "W53 Bitten by rat", "wqM0UlHSSbq"),
    ("ICD10", "W54", "W54 Bitten or struck by dog", "gPeFdBDO5DX"),
    ("ICD10", "W55", "W55 Bitten or struck by other mammals", "WECsACbWN1m"),
    ("ICD10", "W56", "W56 Contact with marine animal", "IgePopuhSr7"),
    ("ICD10", "W57", "W57 Bitten or stung by nonvenomous insect and other nonvenomous arthropods", "JTCOrXJ2Xmv"),
    ("ICD10", "W58", "W58 Bitten or struck by crocodile or alligator", "zi3pmBlzHlN"),
    ("ICD10", "W59", "W59 Bitten or crushed by other reptiles", "MPQdsCHs3Dl"),
    ("ICD10", "W60", "W60 Contact with plant thorns and spines and sharp leaves", "q4m6tEAEn7q"),
    ("ICD10", "W64", "W64 Exposure to other and unspecified animate mechanical forces", "ha5xfVHFPqN"),
    ("ICD10", "W65", "W65 Drowning and submersion while in bath-tub", "Zwn2SrMPb50"),
    ("ICD10", "W66", "W66 Drowning and submersion following fall into bath-tub", "IKg6kVKncBq"),
    ("ICD10", "W67", "W67 Drowning and submersion while in swimming-pool", "j0MgLolbGqg"),
    ("ICD10", "W68", "W68 Drowning and submersion following fall into swimming-pool", "YQptA35yMxf"),
    ("ICD10", "W69", "W69 Drowning and submersion while in natural water", "NaWuiy6BLBi"),
    ("ICD10", "W70", "W70 Drowning and submersion following fall into natural water", "zhzlt5g2ng0"),
    ("ICD10", "W73", "W73 Other specified drowning and submersion", "p44i3VFJ8nG"),
    ("ICD10", "W74", "W74 Unspecified drowning and submersion", "n5E5vKjXXfy"),
    ("ICD10", "W75", "W75 Accidental suffocation and strangulation in bed", "JKuI8ryy06C"),
    ("ICD10", "W76", "W76 Other accidental hanging and strangulation", "luLyHkWMPUc"),
    ("ICD10", "W77", "W77 Threat to breathing due to cave-in, falling earth and other substances", "TYrSu5Rp46a"),
    ("ICD10", "W78", "W78 Inhalation of gastric contents", "Ko11Y3YD08j"),
    ("ICD10", "W79", "W79 Inhalation and ingestion of food causing obstruction of respiratory tract", "Lk4XoUO43hp"),
    ("ICD10", "W80", "W80 Inhalation and ingestion of other objects causing obstruction of respiratory tract", "I0OpTfi0LEg"),
    ("ICD10", "W81", "W81 Confined to or trapped in a low-oxygen environment", "tEAqB08pPeW"),
    ("ICD10", "W83", "W83 Other specified threats to breathing", "BAAlUfxOE1n"),
    ("ICD10", "W84", "W84 Unspecified threat to breathing", "QddQog5PiXt"),
    ("ICD10", "W85", "W85 Exposure to electric transmission lines", "ZIUFIDWjEVq"),
    ("ICD10", "W86", "W86 Exposure to other specified electric current", "wgnMHsHx9M7"),
    ("ICD10", "W87", "W87 Exposure to unspecified electric current", "PBWgGMEazkg"),
    ("ICD10", "W88", "W88 Exposure to ionizing radiation", "BqcDZMxswUD"),
    ("ICD10", "W89", "W89 Exposure to man-made visible and ultraviolet light", "FP8Jx5Vy04r"),
    ("ICD10", "W90", "W90 Exposure to other nonionizing radiation", "t3L6eFWHml5"),
    ("ICD10", "W91", "W91 Exposure to unspecified type of radiation", "MuvEGjIyGeT"),
    ("ICD10", "W92", "W92 Exposure to excessive heat of man-made origin", "K8WahFg09M1"),
    ("ICD10", "W93", "W93 Exposure to excessive cold of man-made origin", "nCajpLeWrEh"),
    ("ICD10", "W94", "W94 Exposure to high and low air pressure and changes in air pressure", "IVsn1FG8CaX"),
    ("ICD10", "W99", "W99 Exposure to other and unspecified man-made environmental factors", "v7uSh6LKmkl");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "X00", "X00 Exposure to uncontrolled fire in building or structure", "GEF9d071yOH"),
    ("ICD10", "X01", "X01 Exposure to uncontrolled fire, not in building or structure", "QeDZcxbeukH"),
    ("ICD10", "X02", "X02 Exposure to controlled fire in building or structure", "p44raiFu4U8"),
    ("ICD10", "X03", "X03 Exposure to controlled fire, not in building or structure", "JW5opo73izS"),
    ("ICD10", "X04", "X04 Exposure to ignition of highly flammable material", "smM2APMi1UM"),
    ("ICD10", "X05", "X05 Exposure to ignition or melting of nightwear", "bsJ1wpunN7e"),
    ("ICD10", "X06", "X06 Exposure to ignition or melting of other clothing and apparel", "WvwcgafDyYE"),
    ("ICD10", "X08", "X08 Exposure to other specified smoke, fire and flames", "iKaTp6LztJw"),
    ("ICD10", "X09", "X09 Exposure to unspecified smoke, fire and flames", "P2894HSrtlP"),
    ("ICD10", "X10", "X10 Contact with hot drinks, food, fats and cooking oils", "MyVv7VIp4fz"),
    ("ICD10", "X11", "X11 Contact with hot tap-water", "Vt2OFyRNHQR"),
    ("ICD10", "X12", "X12 Contact with other hot fluids", "NwYlUOJKPaQ"),
    ("ICD10", "X13", "X13 Contact with steam and hot vapours", "T5oP013sTKw"),
    ("ICD10", "X14", "X14 Contact with hot air and gases", "okaHFV6q2ua"),
    ("ICD10", "X15", "X15 Contact with hot household appliances", "Rzb3MdtHGrk"),
    ("ICD10", "X16", "X16 Contact with hot heating appliances, radiators and pipes", "Wc0o5WXaJy7"),
    ("ICD10", "X17", "X17 Contact with hot engines, machinery and tools", "lNWS4GyLquQ"),
    ("ICD10", "X18", "X18 Contact with other hot metals", "d3sf3pBapyt"),
    ("ICD10", "X19", "X19 Contact with other and unspecified heat and hot substances", "AB0HunBw7OQ"),
    ("ICD10", "X20", "X20 Contact with venomous snakes and lizards", "HpAKNbif0qG"),
    ("ICD10", "X21", "X21 Contact with venomous spiders", "yu3KluqgEjN"),
    ("ICD10", "X22", "X22 Contact with scorpions", "fyBa2LAIqwf"),
    ("ICD10", "X23", "X23 Contact with hornets, wasps and bees", "pPVqqANgMjv"),
    ("ICD10", "X24", "X24 Contact with centipedes and venomous millipedes (tropical)", "x6FAeSDHE0o"),
    ("ICD10", "X25", "X25 Contact with other venomous arthropods", "BdnG5ehKzXK"),
    ("ICD10", "X26", "X26 Contact with venomous marine animals and plants", "uT1mIQjmQjl"),
    ("ICD10", "X27", "X27 Contact with other specified venomous animals", "prF1EBmsrXw"),
    ("ICD10", "X28", "X28 Contact with other specified venomous plants", "rkTkXydL2eN"),
    ("ICD10", "X29", "X29 Contact with unspecified venomous animal or plant", "WRpkKvZd3Tv"),
    ("ICD10", "X30", "X30 Exposure to excessive natural heat", "BOmuNuJkdCR"),
    ("ICD10", "X31", "X31 Exposure to excessive natural cold", "u1nAuDa6Xps"),
    ("ICD10", "X32", "X32 Exposure to sunlight", "RfMle4seXXq"),
    ("ICD10", "X33", "X33 Victim of lightning", "CZqkMn7TDiw"),
    ("ICD10", "X34", "X34 Victim of earthquake", "QonJw5UAOGu"),
    ("ICD10", "X34.0", "X34.0 Victim of cataclysmic earth movements caused by earthquake", "dwaOxMDkEWt"),
    ("ICD10", "X34.1", "X34.1 Victim of tsunami", "VgzllPAC8c4"),
    ("ICD10", "X34.8", "X34.8 Victim of other specified effects of earthquake", "NCneX645b6q"),
    ("ICD10", "X34.9", "X34.9 Victim of unspecified effect of earthquake", "kREDCqs75M7"),
    ("ICD10", "X35", "X35 Victim of volcanic eruption", "mAsXEXFS95a"),
    ("ICD10", "X36", "X36 Victim of avalanche, landslide and other earth movements", "urX9Hef2YMG"),
    ("ICD10", "X37", "X37 Victim of cataclysmic storm", "fenmfE41fSz"),
    ("ICD10", "X38", "X38 Victim of flood", "JmUdJCLY6bA"),
    ("ICD10", "X39", "X39 Exposure to other and unspecified forces of nature", "AJ9GIvGQ6ww"),
    ("ICD10", "X40", "X40 Accidental poisoning by and exposure to nonopioid analgesics, antipyretics and antirheumatics", "OqksUVZM5cl"),
    ("ICD10", "X41", "X41 Accidental poisoning by and exposure to antiepileptic, sedative-hypnotic, antiparkinsonism and psychotropic drugs, not elsewhere classified", "axi1e2yjHoT"),
    ("ICD10", "X42", "X42 Accidental poisoning by and exposure to narcotics and psychodysleptics [hallucinogens], not elsewhere classified", "j6EM8ZMgvkQ"),
    ("ICD10", "X43", "X43 Accidental poisoning by and exposure to other drugs acting on the autonomic nervous system", "A2O42hgJhPh"),
    ("ICD10", "X44", "X44 Accidental poisoning by and exposure to other and unspecified drugs, medicaments and biological substances", "QFBb6FguHKf"),
    ("ICD10", "X45", "X45 Accidental poisoning by and exposure to alcohol", "Xvp42OePq9q"),
    ("ICD10", "X46", "X46 Accidental poisoning by and exposure to organic solvents and halogenated hydrocarbons and their vapours", "X4R9ZlHtJZg"),
    ("ICD10", "X47", "X47 Accidental poisoning by and exposure to other gases and vapours", "OruqiKMZyBJ"),
    ("ICD10", "X48", "X48 Accidental poisoning by and exposure to pesticides", "VBfTHsve2Sw"),
    ("ICD10", "X49", "X49 Accidental poisoning by and exposure to other and unspecified chemicals and noxious substances", "IDHar4Tmg1T"),
    ("ICD10", "X50", "X50 Overexertion and strenuous or repetitive movements", "CoIrsi36ZiU"),
    ("ICD10", "X51", "X51 Travel and motion", "cnyJoJ3DcfU"),
    ("ICD10", "X52", "X52 Prolonged stay in weightless environment", "iHv0a7MHPRh"),
    ("ICD10", "X53", "X53 Lack of food", "NLmMX5JH6ib"),
    ("ICD10", "X54", "X54 Lack of water", "TNYnqQpUQbH"),
    ("ICD10", "X57", "X57 Unspecified privation", "uk6h9P979Da"),
    ("ICD10", "X58", "X58 Exposure to other specified factors", "rDbVAi8nOmU"),
    ("ICD10", "X59", "X59 Exposure to unspecified factor", "S1ZHb0OoPDT"),
    ("ICD10", "X59.0", "X59.0 Exposure to unspecified factor causing fracture", "D5VWYMmT6eN"),
    ("ICD10", "X59.9", "X59.9 Exposure to unspecified factor causing other and unspecified injury", "B2kR1SbFq2L"),
    ("ICD10", "X60", "X60 Intentional self-poisoning by and exposure to nonopioid analgesics, antipyretics and antirheumatics", "wThI40Rix7u"),
    ("ICD10", "X61", "X61 Intentional self-poisoning by and exposure to antiepileptic, sedative-hypnotic, antiparkinsonism and psychotropic drugs, not elsewhere classified", "mOy1ozg0mvv"),
    ("ICD10", "X62", "X62 Intentional self-poisoning by and exposure to narcotics and psychodysleptics [hallucinogens], not elsewhere classified", "UO8OjvjuIZZ"),
    ("ICD10", "X63", "X63 Intentional self-poisoning by and exposure to other drugs acting on the autonomic nervous system", "skZAqH2bBT5"),
    ("ICD10", "X64", "X64 Intentional self-poisoning by and exposure to other and unspecified drugs, medicaments and biological substances", "UxHPaJHyDQg"),
    ("ICD10", "X65", "X65 Intentional self-poisoning by and exposure to alcohol", "MwzGmRPHC6O"),
    ("ICD10", "X66", "X66 Intentional self-poisoning by and exposure to organic solvents and halogenated hydrocarbons and their vapours", "dM6rDB2IWTe"),
    ("ICD10", "X67", "X67 Intentional self-poisoning by and exposure to other gases and vapours", "JMgWBMjT10M"),
    ("ICD10", "X68", "X68 Intentional self-poisoning by and exposure to pesticides", "n04I7fLMGde"),
    ("ICD10", "X69", "X69 Intentional self-poisoning by and exposure to other and unspecified chemicals and noxious substances", "bztWvQ4LggU"),
    ("ICD10", "X70", "X70 Intentional self-harm by hanging, strangulation and suffocation", "MTyq66Vz9yJ"),
    ("ICD10", "X71", "X71 Intentional self-harm by drowning and submersion", "Hl3ONznspNJ"),
    ("ICD10", "X72", "X72 Intentional self-harm by handgun discharge", "aH1NOVsl6GI"),
    ("ICD10", "X73", "X73 Intentional self-harm by rifle, shotgun and larger firearm discharge", "SL73zzIiUs6"),
    ("ICD10", "X74", "X74 Intentional self-harm by other and unspecified firearm discharge", "MqyhJDu1E7k"),
    ("ICD10", "X75", "X75 Intentional self-harm by explosive material", "Ed6lufiUpkb"),
    ("ICD10", "X76", "X76 Intentional self-harm by smoke, fire and flames", "aFJknzEIo4U"),
    ("ICD10", "X77", "X77 Intentional self-harm by steam, hot vapours and hot objects", "q51EN4JvJmO"),
    ("ICD10", "X78", "X78 Intentional self-harm by sharp object", "TmYID5LPDgq"),
    ("ICD10", "X79", "X79 Intentional self-harm by blunt object", "Kf84YuctuAF"),
    ("ICD10", "X80", "X80 Intentional self-harm by jumping from a high place", "WSKCFO3yi5R"),
    ("ICD10", "X81", "X81 Intentional self-harm by jumping or lying before moving object", "CO0EDLMsJyt"),
    ("ICD10", "X82", "X82 Intentional self-harm by crashing of motor vehicle", "VDH9iv4OrLM"),
    ("ICD10", "X83", "X83 Intentional self-harm by other specified means", "oOCETw5Huw8"),
    ("ICD10", "X84", "X84 Intentional self-harm by unspecified means", "jl0wzmeZGTh"),
    ("ICD10", "X85", "X85 Assault by drugs, medicaments and biological substances", "kTI1ifAaEXA"),
    ("ICD10", "X86", "X86 Assault by corrosive substance", "JMBlIf08oyD"),
    ("ICD10", "X87", "X87 Assault by pesticides", "BQefAawi6GU"),
    ("ICD10", "X88", "X88 Assault by gases and vapours", "pVRr4Fx1h9W"),
    ("ICD10", "X89", "X89 Assault by other specified chemicals and noxious substances", "eYAlMUE2SuL"),
    ("ICD10", "X90", "X90 Assault by unspecified chemical or noxious substance", "Y2Hb5oThqXU"),
    ("ICD10", "X91", "X91 Assault by hanging, strangulation and suffocation", "XRdZvSC2hP9"),
    ("ICD10", "X92", "X92 Assault by drowning and submersion", "oMpNUSz0RHm"),
    ("ICD10", "X93", "X93 Assault by handgun discharge", "inGfy4wJsyT"),
    ("ICD10", "X94", "X94 Assault by rifle, shotgun and larger firearm discharge", "eHVZSrZaCaV"),
    ("ICD10", "X95", "X95 Assault by other and unspecified firearm discharge", "F6CrNaTFDHJ"),
    ("ICD10", "X96", "X96 Assault by explosive material", "cS43cZh1CLB"),
    ("ICD10", "X97", "X97 Assault by smoke, fire and flames", "P50RBA2UCmT"),
    ("ICD10", "X98", "X98 Assault by steam, hot vapours and hot objects", "FUEUtYkFcoa"),
    ("ICD10", "X99", "X99 Assault by sharp object", "Q6oQaBZxdww");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Y00", "Y00 Assault by blunt object", "EtHB1V3GWt1"),
    ("ICD10", "Y01", "Y01 Assault by pushing from high place", "iDz93ZEgnzC"),
    ("ICD10", "Y02", "Y02 Assault by pushing or placing victim before moving object", "hXR9bdXcRHs"),
    ("ICD10", "Y03", "Y03 Assault by crashing of motor vehicle", "l7Y7XmiqD1l"),
    ("ICD10", "Y04", "Y04 Assault by bodily force", "N5RVumnT8DX"),
    ("ICD10", "Y05", "Y05 Sexual assault by bodily force", "tN5u4fxXWW3"),
    ("ICD10", "Y06", "Y06 Neglect and abandonment", "eFOhBTJCZSd"),
    ("ICD10", "Y06.0", "Y06.0 By spouse or partner", "RuMu6jT7uJ3"),
    ("ICD10", "Y06.1", "Y06.1 By parent", "NpuQqJdKLoL"),
    ("ICD10", "Y06.2", "Y06.2 By acquaintance or friend", "XP77EQDnTxG"),
    ("ICD10", "Y06.8", "Y06.8 By other specified persons", "nWqKHpOKNPn"),
    ("ICD10", "Y06.9", "Y06.9 By unspecified person", "EKj6Gsz78Lk"),
    ("ICD10", "Y07", "Y07 Other maltreatment", "eVCtec2QLyl"),
    ("ICD10", "Y07.0", "Y07.0 By spouse or partner", "LYGHVCBn5Pr"),
    ("ICD10", "Y07.1", "Y07.1 By parent", "waqKtzRUA8O"),
    ("ICD10", "Y07.2", "Y07.2 By acquaintance or friend", "mg4pLjsQmkp"),
    ("ICD10", "Y07.3", "Y07.3 By official authorities", "mUA0lMc5nNV"),
    ("ICD10", "Y07.8", "Y07.8 By other specified persons", "UC4I68p1eRY"),
    ("ICD10", "Y07.9", "Y07.9 By unspecified person", "NycgxunBfWy"),
    ("ICD10", "Y08", "Y08 Assault by other specified means", "OqvQWFtmdQn"),
    ("ICD10", "Y09", "Y09 Assault by unspecified means", "We85b7pOoS9"),
    ("ICD10", "Y10", "Y10 Poisoning by and exposure to nonopioid analgesics, antipyretics and antirheumatics, undetermined intent", "KcOKA6XUwSj"),
    ("ICD10", "Y11", "Y11 Poisoning by and exposure to antiepileptic, sedative-hypnotic, antiparkinsonism and psychotropic drugs, not elsewhere classified, undetermined intent", "q6y2SAzehFg"),
    ("ICD10", "Y12", "Y12 Poisoning by and exposure to narcotics and psychodysleptics [hallucinogens], not elsewhere classified, undetermined intent", "TOlVEcpGbg0"),
    ("ICD10", "Y13", "Y13 Poisoning by and exposure to other drugs acting on the autonomic nervous system, undetermined intent", "Gp1UwvlvbRe"),
    ("ICD10", "Y14", "Y14 Poisoning by and exposure to other and unspecified drugs, medicaments and biological substances, undetermined intent", "LaTT6lUoyOd"),
    ("ICD10", "Y15", "Y15 Poisoning by and exposure to alcohol, undetermined intent", "v9igruhRHFE"),
    ("ICD10", "Y16", "Y16 Poisoning by and exposure to organic solvents and halogenated hydrocarbons and their vapours, undetermined intent", "IQjD8GPKk9o"),
    ("ICD10", "Y17", "Y17 Poisoning by and exposure to other gases and vapours, undetermined intent", "ODsz4tWp7ZP"),
    ("ICD10", "Y18", "Y18 Poisoning by and exposure to pesticides, undetermined intent", "Q9ujycg7XSP"),
    ("ICD10", "Y19", "Y19 Poisoning by and exposure to other and unspecified chemicals and noxious substances, undetermined intent", "lOYPoEYs6bI"),
    ("ICD10", "Y20", "Y20 Hanging, strangulation and suffocation, undetermined intent", "L7eNkjaPEBx"),
    ("ICD10", "Y21", "Y21 Drowning and submersion, undetermined intent", "XuWLAAtRuNU"),
    ("ICD10", "Y22", "Y22 Handgun discharge, undetermined intent", "twnxMa5T1dN"),
    ("ICD10", "Y23", "Y23 Rifle, shotgun and larger firearm discharge, undetermined intent", "M0nQM64hSHd"),
    ("ICD10", "Y24", "Y24 Other and unspecified firearm discharge, undetermined intent", "cZ5zZPEACjG"),
    ("ICD10", "Y25", "Y25 Contact with explosive material, undetermined intent", "bhyHUHp7CI2"),
    ("ICD10", "Y26", "Y26 Exposure to smoke, fire and flames, undetermined intent", "G1SCoTStsgF"),
    ("ICD10", "Y27", "Y27 Contact with steam, hot vapours and hot objects, undetermined intent", "tOiQdMog8kL"),
    ("ICD10", "Y28", "Y28 Contact with sharp object, undetermined intent", "zk65BZnZTuT"),
    ("ICD10", "Y29", "Y29 Contact with blunt object, undetermined intent", "jE4wWx8gboY"),
    ("ICD10", "Y30", "Y30 Falling, jumping or pushed from a high place, undetermined intent", "c1MuGoAx0Hj"),
    ("ICD10", "Y31", "Y31 Falling, lying or running before or into moving object, undetermined intent", "TvyHPotmb4f"),
    ("ICD10", "Y32", "Y32 Crashing of motor vehicle, undetermined intent", "CctzNafO7hX"),
    ("ICD10", "Y33", "Y33 Other specified events, undetermined intent", "AnVhX6x5IVo"),
    ("ICD10", "Y34", "Y34 Unspecified event, undetermined intent", "YGeIQ7cS8Q9"),
    ("ICD10", "Y35", "Y35 Legal intervention", "CTQJu8m4voo"),
    ("ICD10", "Y35.0", "Y35.0 Legal intervention involving firearm discharge", "hJ7ejTWK6zz"),
    ("ICD10", "Y35.1", "Y35.1 Legal intervention involving explosives", "gsXJ41w3GC6"),
    ("ICD10", "Y35.2", "Y35.2 Legal intervention involving gas", "fyAizVJiQrv"),
    ("ICD10", "Y35.3", "Y35.3 Legal intervention involving blunt objects", "S6n73zlg7q3"),
    ("ICD10", "Y35.4", "Y35.4 Legal intervention involving sharp objects", "WAiK5J2ZXNc"),
    ("ICD10", "Y35.5", "Y35.5 Legal execution", "EpSAKKsIhfd"),
    ("ICD10", "Y35.6", "Y35.6 Legal intervention involving other specified means", "UMdfZwUGSna"),
    ("ICD10", "Y35.7", "Y35.7 Legal intervention, means unspecified", "KI5F6JQ7UBA"),
    ("ICD10", "Y36", "Y36 Operations of war", "qTXlRl6R1ST"),
    ("ICD10", "Y36.0", "Y36.0 War operations involving explosion of marine weapons", "ipqEXce25pf"),
    ("ICD10", "Y36.1", "Y36.1 War operations involving destruction of aircraft", "z6kc8uKDmkN"),
    ("ICD10", "Y36.2", "Y36.2 War operations involving other explosions and fragments", "WcxbSdAEL74"),
    ("ICD10", "Y36.3", "Y36.3 War operations involving fires, conflagrations and hot substances", "Gq0bwX3mYVM"),
    ("ICD10", "Y36.4", "Y36.4 War operations involving firearm discharge and other forms of conventional warfare", "ZNi0LLS2EkQ"),
    ("ICD10", "Y36.5", "Y36.5 War operations involving nuclear weapons", "zOql6L7RjvY"),
    ("ICD10", "Y36.6", "Y36.6 War operations involving biological weapons", "bDVveTwrzON"),
    ("ICD10", "Y36.7", "Y36.7 War operations involving chemical weapons and other forms of unconventional warfare", "hVlOMNlQc9I"),
    ("ICD10", "Y36.8", "Y36.8 War operations occurring after cessation of hostilities", "yqc0P4bkiUp"),
    ("ICD10", "Y36.9", "Y36.9 War operations, unspecified", "gvuV61oQSAY"),
    ("ICD10", "Y40", "Y40 Systemic antibiotics", "jSr06yC74p4"),
    ("ICD10", "Y40.0", "Y40.0 Penicillins", "wspxjVU81Hn"),
    ("ICD10", "Y40.1", "Y40.1 Cefalosporins and other beta-lactam antibiotics", "qKM5xRCS93D"),
    ("ICD10", "Y40.2", "Y40.2 Chloramphenicol group", "NLJkaINcbo6"),
    ("ICD10", "Y40.3", "Y40.3 Macrolides", "AaLHRwfm7w7"),
    ("ICD10", "Y40.4", "Y40.4 Tetracyclines", "CAJMZOyRqqE"),
    ("ICD10", "Y40.5", "Y40.5 Aminoglycosides", "zzTtfO2iY6m"),
    ("ICD10", "Y40.6", "Y40.6 Rifamycins", "m3L0koHSJJD"),
    ("ICD10", "Y40.7", "Y40.7 Antifungal antibiotics, systemically used", "aYcd2g7OuEe"),
    ("ICD10", "Y40.8", "Y40.8 Other systemic antibiotics", "hqXxVxDQ980"),
    ("ICD10", "Y40.9", "Y40.9 Systemic antibiotic, unspecified", "zJg8wJvhwsx"),
    ("ICD10", "Y41", "Y41 Other systemic anti-infectives and antiparasitics", "y8OdCdrKIIP"),
    ("ICD10", "Y41.0", "Y41.0 Sulfonamides", "ecZ1WfJqMbT"),
    ("ICD10", "Y41.1", "Y41.1 Antimycobacterial drugs", "Jsk0EfzP2yn"),
    ("ICD10", "Y41.2", "Y41.2 Antimalarials and drugs acting on other blood protozoa", "vEbq9uZHFGD"),
    ("ICD10", "Y41.3", "Y41.3 Other antiprotozoal drugs", "lsXDfbqG9zQ"),
    ("ICD10", "Y41.4", "Y41.4 Anthelminthics", "MRA6EsoCvHC"),
    ("ICD10", "Y41.5", "Y41.5 Antiviral drugs", "K8gBDQ1ERXy"),
    ("ICD10", "Y41.8", "Y41.8 Other specified systemic anti-infectives and antiparasitics", "v5jHeTVNAQf"),
    ("ICD10", "Y41.9", "Y41.9 Systemic anti-infective and antiparasitic, unspecified", "Z10r7P1I88v"),
    ("ICD10", "Y42", "Y42 Hormones and their synthetic substitutes and antagonists, not elsewhere classified", "k1P3IECAXtB"),
    ("ICD10", "Y42.0", "Y42.0 Glucocorticoids and synthetic analogues", "JFri21iFxRz"),
    ("ICD10", "Y42.1", "Y42.1 Thyroid hormones and substitutes", "IsumI58YBAK"),
    ("ICD10", "Y42.2", "Y42.2 Antithyroid drugs", "jhaxN4VKqle"),
    ("ICD10", "Y42.3", "Y42.3 Insulin and oral hypoglycaemic [antidiabetic] drugs", "nL7tGPYiJHR"),
    ("ICD10", "Y42.4", "Y42.4 Oral contraceptives", "ZImypledTSa"),
    ("ICD10", "Y42.5", "Y42.5 Other estrogens and progestogens", "qdtNdRCx9jz"),
    ("ICD10", "Y42.6", "Y42.6 Antigonadotrophins, antiestrogens, antiandrogens, not elsewhere classified", "UEVRVbc1foL"),
    ("ICD10", "Y42.7", "Y42.7 Androgens and anabolic congeners", "sPM3p8XnuTW"),
    ("ICD10", "Y42.8", "Y42.8 Other and unspecified hormones and their synthetic substitutes", "p7anvsyARhJ"),
    ("ICD10", "Y42.9", "Y42.9 Other and unspecified hormone antagonists", "UjgSA2M0tyz"),
    ("ICD10", "Y43", "Y43 Primarily systemic agents", "WLvA4gT3RHX"),
    ("ICD10", "Y43.0", "Y43.0 Antiallergic and antiemetic drugs", "Xy0WSFHBRIk"),
    ("ICD10", "Y43.1", "Y43.1 Antineoplastic antimetabolites", "eAs8LHHZPKd"),
    ("ICD10", "Y43.2", "Y43.2 Antineoplastic natural products", "Ir0t8udALvQ"),
    ("ICD10", "Y43.3", "Y43.3 Other antineoplastic drugs", "LraFTCQ4wf9"),
    ("ICD10", "Y43.4", "Y43.4 Immunosuppressive agents", "OqYnmQZNZOh"),
    ("ICD10", "Y43.5", "Y43.5 Acidifying and alkalizing agents", "fnZSjO209EL"),
    ("ICD10", "Y43.6", "Y43.6 Enzymes, not elsewhere classified", "EjfvDG13dlr"),
    ("ICD10", "Y43.8", "Y43.8 Other primarily systemic agents, not elsewhere classified", "XIdY0NGiULl"),
    ("ICD10", "Y43.9", "Y43.9 Primarily systemic agent, unspecified", "DfkHuLt1uHK"),
    ("ICD10", "Y44", "Y44 Agents primarily affecting blood constituents", "qmhi5LWytBf"),
    ("ICD10", "Y44.0", "Y44.0 Iron preparations and other anti-hypochromic-anaemia preparations", "vJvSCwfnnY5"),
    ("ICD10", "Y44.1", "Y44.1 Vitamin B", "YDf2JJeBcqw"),
    ("ICD10", "Y44.2", "Y44.2 Anticoagulants", "BTIMNKiwWt4"),
    ("ICD10", "Y44.3", "Y44.3 Anticoagulant antagonists, vitamin K and other coagulants", "VQu3g0ywPeC"),
    ("ICD10", "Y44.4", "Y44.4 Antithrombotic drugs [platelet-aggregation inhibitors]", "mLLylMSdaYK"),
    ("ICD10", "Y44.5", "Y44.5 Thrombolytic drugs", "Z9IMhc1Pznn"),
    ("ICD10", "Y44.6", "Y44.6 Natural blood and blood products", "vdc7rSKrE9f"),
    ("ICD10", "Y44.7", "Y44.7 Plasma substitutes", "XBBKp1PY5Pl"),
    ("ICD10", "Y44.9", "Y44.9 Other and unspecified agents affecting blood constituents", "DJFMTJVQmUS"),
    ("ICD10", "Y45", "Y45 Analgesics, antipyretics and anti-inflammatory drugs", "hhmZ8AF0ikS"),
    ("ICD10", "Y45.0", "Y45.0 Opioids and related analgesics", "XW0w1CmoPm9"),
    ("ICD10", "Y45.1", "Y45.1 Salicylates", "VfxZMlfqzdr"),
    ("ICD10", "Y45.2", "Y45.2 Propionic acid derivatives", "NY1giLnZC2D"),
    ("ICD10", "Y45.3", "Y45.3 Other nonsteroidal anti-inflammatory drugs [NSAID]", "jUpT6QJW1ul"),
    ("ICD10", "Y45.4", "Y45.4 Antirheumatics", "oUKd17MZoBj"),
    ("ICD10", "Y45.5", "Y45.5 4-Aminophenol derivatives", "a0NTvXUy9xI"),
    ("ICD10", "Y45.8", "Y45.8 Other analgesics and antipyretics", "nedza7IaNvb"),
    ("ICD10", "Y45.9", "Y45.9 Analgesic, antipyretic and anti-inflammatory drug, unspecified", "pm7qBmbnwXa"),
    ("ICD10", "Y46", "Y46 Antiepileptics and antiparkinsonism drugs", "lUYxnyCXmFY"),
    ("ICD10", "Y46.0", "Y46.0 Succinimides", "FvXJh4PuKdX"),
    ("ICD10", "Y46.1", "Y46.1 Oxazolidinediones", "o5lyJv2t0I4"),
    ("ICD10", "Y46.2", "Y46.2 Hydantoin derivatives", "OI184teJGxP"),
    ("ICD10", "Y46.3", "Y46.3 Deoxybarbiturates", "IOZ1tiQc5Uh"),
    ("ICD10", "Y46.4", "Y46.4 Iminostilbenes", "R6bbMfLFDsC"),
    ("ICD10", "Y46.5", "Y46.5 Valproic acid", "Tj24xYeQ1K3"),
    ("ICD10", "Y46.6", "Y46.6 Other and unspecified antiepileptics", "W8l52OlhQKY"),
    ("ICD10", "Y46.7", "Y46.7 Antiparkinsonism drugs", "nFsFDsx66gp"),
    ("ICD10", "Y46.8", "Y46.8 Antispasticity drugs", "jSTjhwBMjVm"),
    ("ICD10", "Y47", "Y47 Sedatives, hypnotics and antianxiety drugs", "MxLVnxUHjoO"),
    ("ICD10", "Y47.0", "Y47.0 Barbiturates, not elsewhere classified", "sdoPZYW21L3"),
    ("ICD10", "Y47.1", "Y47.1 Benzodiazepines", "suvhdQxQyJl"),
    ("ICD10", "Y47.2", "Y47.2 Cloral derivatives", "tLFlzxmk8JR"),
    ("ICD10", "Y47.3", "Y47.3 Paraldehyde", "mx0pjqvrOiY"),
    ("ICD10", "Y47.4", "Y47.4 Bromine compounds", "KMQ7m6LaKn1"),
    ("ICD10", "Y47.5", "Y47.5 Mixed sedatives and hypnotics, not elsewhere classified", "TRd8TYHFNmR"),
    ("ICD10", "Y47.8", "Y47.8 Other sedatives, hypnotics and antianxiety drugs", "L2QwJIQVgwL"),
    ("ICD10", "Y47.9", "Y47.9 Sedative, hypnotic and antianxiety drug, unspecified", "cp3bXxkF2xi"),
    ("ICD10", "Y48", "Y48 Anaesthetics and therapeutic gases", "ypJmuekMuo5"),
    ("ICD10", "Y48.0", "Y48.0 Inhaled anaesthetics", "Jgfj17HdlnQ"),
    ("ICD10", "Y48.1", "Y48.1 Parenteral anaesthetics", "E7wCQi3Kk76"),
    ("ICD10", "Y48.2", "Y48.2 Other and unspecified general anaesthetics", "zDjRqFXsEJj"),
    ("ICD10", "Y48.3", "Y48.3 Local anaesthetics", "GNEYwPNO6sb"),
    ("ICD10", "Y48.4", "Y48.4 Anaesthetic, unspecified", "oRcACHZ17H1"),
    ("ICD10", "Y48.5", "Y48.5 Therapeutic gases", "sNsOyFyGSta"),
    ("ICD10", "Y49", "Y49 Psychotropic drugs, not elsewhere classified", "TC66srOvTWB"),
    ("ICD10", "Y49.0", "Y49.0 Tricyclic and tetracyclic antidepressants", "W62jDuQ9x3H"),
    ("ICD10", "Y49.1", "Y49.1 Monoamine-oxidase-inhibitor antidepressants", "mcjEOWAe82N"),
    ("ICD10", "Y49.2", "Y49.2 Other and unspecified antidepressants", "pjDOmwkGDuA"),
    ("ICD10", "Y49.3", "Y49.3 Phenothiazine antipsychotics and neuroleptics", "ANCgtcbI2C7"),
    ("ICD10", "Y49.4", "Y49.4 Butyrophenone and thioxanthene neuroleptics", "kJcfImARgME"),
    ("ICD10", "Y49.5", "Y49.5 Other antipsychotics and neuroleptics", "anyiMz8ERP3"),
    ("ICD10", "Y49.6", "Y49.6 Psychodysleptics [hallucinogens]", "ISOiTULRyqM"),
    ("ICD10", "Y49.7", "Y49.7 Psychostimulants with abuse potential", "sKUbAqR7EOu"),
    ("ICD10", "Y49.8", "Y49.8 Other psychotropic drugs, not elsewhere classified", "DMqo38Cnx1B"),
    ("ICD10", "Y49.9", "Y49.9 Psychotropic drug, unspecified", "pcASvbkUDdY"),
    ("ICD10", "Y50", "Y50 Central nervous system stimulants, not elsewhere classified", "T60Qwogn6U3"),
    ("ICD10", "Y50.0", "Y50.0 Analeptics", "juWpBTlTM56"),
    ("ICD10", "Y50.1", "Y50.1 Opioid receptor antagonists", "FF4KWeAnM0B"),
    ("ICD10", "Y50.2", "Y50.2 Methylxanthines, not elsewhere classified", "CpISMwSoQfT"),
    ("ICD10", "Y50.8", "Y50.8 Other central nervous system stimulants", "bIkIlCYFGpZ"),
    ("ICD10", "Y50.9", "Y50.9 Central nervous system stimulant, unspecified", "NpKqJll8G4D"),
    ("ICD10", "Y51", "Y51 Drugs primarily affecting the autonomic nervous system", "b7ViqUT557d"),
    ("ICD10", "Y51.0", "Y51.0 Anticholinesterase agents", "CBgkC19xuqZ"),
    ("ICD10", "Y51.1", "Y51.1 Other parasympathomimetics [cholinergics]", "lipJgrpLaVM"),
    ("ICD10", "Y51.2", "Y51.2 Ganglionic blocking drugs, not elsewhere classified", "Ao3JgAktADE"),
    ("ICD10", "Y51.3", "Y51.3 Other parasympatholytics [anticholinergics and antimuscarinics] and spasmolytics, not elsewhere classified", "CpQkcwhHzW2"),
    ("ICD10", "Y51.4", "Y51.4 Predominantly alpha-adrenoreceptor agonists, not elsewhere classified", "bzHGTr5zxIl"),
    ("ICD10", "Y51.5", "Y51.5 Predominantly beta-adrenoreceptor agonists, not elsewhere classified", "c3NVJiIVW6J"),
    ("ICD10", "Y51.6", "Y51.6 Alpha-adrenoreceptor antagonists, not elsewhere classified", "xPxmXgigC0A"),
    ("ICD10", "Y51.7", "Y51.7 Beta-adrenoreceptor antagonists, not elsewhere classified", "TaK15KtJibt"),
    ("ICD10", "Y51.8", "Y51.8 Centrally acting and adrenergic-neuron-blocking agents, not elsewhere classified", "E5aoX5eCDrS"),
    ("ICD10", "Y51.9", "Y51.9 Other and unspecified drugs primarily affecting the autonomic nervous system", "HgEHzcz8aIh"),
    ("ICD10", "Y52", "Y52 Agents primarily affecting the cardiovascular system", "B9DL0TPVu1K"),
    ("ICD10", "Y52.0", "Y52.0 Cardiac-stimulant glycosides and drugs of similar action", "neRHScU3KDL"),
    ("ICD10", "Y52.1", "Y52.1 Calcium-channel blockers", "akj3EKYsEcF"),
    ("ICD10", "Y52.2", "Y52.2 Other antidysrhythmic drugs, not elsewhere classified", "L87nwTnGhth"),
    ("ICD10", "Y52.3", "Y52.3 Coronary vasodilators, not elsewhere classified", "QCJgfYBZBSY"),
    ("ICD10", "Y52.4", "Y52.4 Angiotensin-converting-enzyme inhibitors", "gJb4f9T0Z1h"),
    ("ICD10", "Y52.5", "Y52.5 Other antihypertensive drugs, not elsewhere classified", "iL042zOUMHq"),
    ("ICD10", "Y52.6", "Y52.6 Antihyperlipidaemic and antiarteriosclerotic drugs", "VyURkL4IU0n"),
    ("ICD10", "Y52.7", "Y52.7 Peripheral vasodilators", "wdBIk9pxEIm"),
    ("ICD10", "Y52.8", "Y52.8 Antivaricose drugs, including sclerosing agents", "FR9bY06VXKW"),
    ("ICD10", "Y52.9", "Y52.9 Other and unspecified agents primarily affecting the cardiovascular system", "Eofw0ZXT0T9"),
    ("ICD10", "Y53", "Y53 Agents primarily affecting the gastrointestinal system", "DtN1IzgZp2v"),
    ("ICD10", "Y53.0", "Y53.0 Histamine H", "EQ1SsxIaxxu"),
    ("ICD10", "Y53.1", "Y53.1 Other antacids and anti-gastric-secretion drugs", "iKjQzwRXSWf"),
    ("ICD10", "Y53.2", "Y53.2 Stimulant laxatives", "FLMfvHL9VvI"),
    ("ICD10", "Y53.3", "Y53.3 Saline and osmotic laxatives", "EUG8QaPxi0w"),
    ("ICD10", "Y53.4", "Y53.4 Other laxatives", "BG7Kv2F855K"),
    ("ICD10", "Y53.5", "Y53.5 Digestants", "nBwVKd0SFmd"),
    ("ICD10", "Y53.6", "Y53.6 Antidiarrhoeal drugs", "IknzcIfvEds"),
    ("ICD10", "Y53.7", "Y53.7 Emetics", "gepZcSnHf2v"),
    ("ICD10", "Y53.8", "Y53.8 Other agents primarily affecting the gastrointestinal system", "HAUEzQ5nBbw"),
    ("ICD10", "Y53.9", "Y53.9 Agent primarily affecting the gastrointestinal system, unspecified", "JfXBIMdVMD8"),
    ("ICD10", "Y54", "Y54 Agents primarily affecting water-balance and mineral and uric acid metabolism", "I4kE428cpby"),
    ("ICD10", "Y54.0", "Y54.0 Mineralocorticoids", "JMRU3lyqVor"),
    ("ICD10", "Y54.1", "Y54.1 Mineralocorticoid antagonists [aldosterone antagonists]", "Pce0HyHoX8k"),
    ("ICD10", "Y54.2", "Y54.2 Carbonic-anhydrase inhibitors", "yOaaipMmx1T"),
    ("ICD10", "Y54.3", "Y54.3 Benzothiadiazine derivatives", "lm8fgS5eg4T"),
    ("ICD10", "Y54.4", "Y54.4 Loop [high-ceiling] diuretics", "a82ffyLRTNN"),
    ("ICD10", "Y54.5", "Y54.5 Other diuretics", "dWS5ksGnHN0"),
    ("ICD10", "Y54.6", "Y54.6 Electrolytic, caloric and water-balance agents", "XzqhCQuREgi"),
    ("ICD10", "Y54.7", "Y54.7 Agents affecting calcification", "bfYubmsC49I"),
    ("ICD10", "Y54.8", "Y54.8 Agents affecting uric acid metabolism", "mV0R3QC3PNT"),
    ("ICD10", "Y54.9", "Y54.9 Mineral salts, not elsewhere classified", "JEXY4suFbvv"),
    ("ICD10", "Y55", "Y55 Agents primarily acting on smooth and skeletal muscles and the respiratory system", "czfKsAXdCdS"),
    ("ICD10", "Y55.0", "Y55.0 Oxytocic drugs", "dBjLqIjR1GO"),
    ("ICD10", "Y55.1", "Y55.1 Skeletal muscle relaxants [neuromuscular blocking agents]", "sZPxYUOkbvI"),
    ("ICD10", "Y55.2", "Y55.2 Other and unspecified agents primarily acting on muscles", "axU0sD1fa3W"),
    ("ICD10", "Y55.3", "Y55.3 Antitussives", "ysgT7RCsVX5"),
    ("ICD10", "Y55.4", "Y55.4 Expectorants", "MLyIkO1izDT"),
    ("ICD10", "Y55.5", "Y55.5 Anti-common-cold drugs", "pNn2R7y5Eyx"),
    ("ICD10", "Y55.6", "Y55.6 Antiasthmatics, not elsewhere classified", "nBZn9gshInF"),
    ("ICD10", "Y55.7", "Y55.7 Other and unspecified agents primarily acting on the respiratory system", "nsRIa3vQ4rt"),
    ("ICD10", "Y56", "Y56 Topical agents primarily affecting skin and mucous membrane and ophthalmological, otorhinolaryngological and dental drugs", "Z5kNoxMF3A9"),
    ("ICD10", "Y56.0", "Y56.0 Local antifungal, anti-infective and anti-inflammatory drugs, not elsewhere classified", "qk5716bYMqB"),
    ("ICD10", "Y56.1", "Y56.1 Antipruritics", "Krndozi3RRM"),
    ("ICD10", "Y56.2", "Y56.2 Local astringents and local detergents", "fclOubWsqtC"),
    ("ICD10", "Y56.3", "Y56.3 Emollients, demulcents and protectants", "tdBxFnruYEB"),
    ("ICD10", "Y56.4", "Y56.4 Keratolytics, keratoplastics and other hair treatment drugs and preparations", "orfEeaI36iR"),
    ("ICD10", "Y56.5", "Y56.5 Ophthalmological drugs and preparations", "AD0blcw2WhP"),
    ("ICD10", "Y56.6", "Y56.6 Otorhinolaryngological drugs and preparations", "aG4lW173ykO"),
    ("ICD10", "Y56.7", "Y56.7 Dental drugs, topically applied", "iMd0o6zAlET"),
    ("ICD10", "Y56.8", "Y56.8 Other topical agents", "yGroGVmWKN1"),
    ("ICD10", "Y56.9", "Y56.9 Topical agent, unspecified", "vblhuUBQZXs"),
    ("ICD10", "Y57", "Y57 Other and unspecified drugs and medicaments", "GuYdatxzDpW"),
    ("ICD10", "Y57.0", "Y57.0 Appetite depressants [anorectics]", "zzwuKWOu0x5"),
    ("ICD10", "Y57.1", "Y57.1 Lipotropic drugs", "Sr9fp6YpY2R"),
    ("ICD10", "Y57.2", "Y57.2 Antidotes and chelating agents, not elsewhere classified", "iUaIXGonZHP"),
    ("ICD10", "Y57.3", "Y57.3 Alcohol deterrents", "QRuBleqPmsv"),
    ("ICD10", "Y57.4", "Y57.4 Pharmaceutical excipients", "hJInI52jvdE"),
    ("ICD10", "Y57.5", "Y57.5 X-ray contrast media", "zsJQt8ZHTLw"),
    ("ICD10", "Y57.6", "Y57.6 Other diagnostic agents", "WUo8ugMmVIK"),
    ("ICD10", "Y57.7", "Y57.7 Vitamins, not elsewhere classified", "vt0y7vdjQbo"),
    ("ICD10", "Y57.8", "Y57.8 Other drugs and medicaments", "bxdkF2K4CjS"),
    ("ICD10", "Y57.9", "Y57.9 Drug or medicament, unspecified", "HLXz8R12OuI"),
    ("ICD10", "Y58", "Y58 Bacterial vaccines", "xOYWnKg72Ut"),
    ("ICD10", "Y58.0", "Y58.0 BCG vaccine", "UuLjYiPQnq8"),
    ("ICD10", "Y58.1", "Y58.1 Typhoid and paratyphoid vaccine", "rWJAM37jM4Z"),
    ("ICD10", "Y58.2", "Y58.2 Cholera vaccine", "nTIYYXRd1Kx"),
    ("ICD10", "Y58.3", "Y58.3 Plague vaccine", "tmeTX8RTGiT"),
    ("ICD10", "Y58.4", "Y58.4 Tetanus vaccine", "Y6IrUXijJWx"),
    ("ICD10", "Y58.5", "Y58.5 Diphtheria vaccine", "jvX7V2mHlpT"),
    ("ICD10", "Y58.6", "Y58.6 Pertussis vaccine, including combinations with a pertussis component", "WbMDuqQKiTS"),
    ("ICD10", "Y58.8", "Y58.8 Mixed bacterial vaccines, except combinations with a pertussis component", "ln3e9EtjMEq"),
    ("ICD10", "Y58.9", "Y58.9 Other and unspecified bacterial vaccines", "yJwGlXVDe9I"),
    ("ICD10", "Y59", "Y59 Other and unspecified vaccines and biological substances", "UFMoWxDn5zk"),
    ("ICD10", "Y59.0", "Y59.0 Viral vaccines", "Q1lWUXQJUa8"),
    ("ICD10", "Y59.1", "Y59.1 Rickettsial vaccines", "FrDugDShoek"),
    ("ICD10", "Y59.2", "Y59.2 Protozoal vaccines", "sqAVRfZQpMU"),
    ("ICD10", "Y59.3", "Y59.3 Immunoglobulin", "qDesJDgvMgf"),
    ("ICD10", "Y59.8", "Y59.8 Other specified vaccines and biological substances", "e3CS4od0EGT"),
    ("ICD10", "Y59.9", "Y59.9 Vaccine or biological substance, unspecified", "dpofLeUi3g2"),
    ("ICD10", "Y60", "Y60 Unintentional cut, puncture, perforation or haemorrhage during surgical and medical care", "QciA5IsR1PW"),
    ("ICD10", "Y60.0", "Y60.0 During surgical operation", "sPr9soGp2i0"),
    ("ICD10", "Y60.1", "Y60.1 During infusion or transfusion", "uMjXuiUD4hl"),
    ("ICD10", "Y60.2", "Y60.2 During kidney dialysis or other perfusion", "PCbB6VOLvv1"),
    ("ICD10", "Y60.3", "Y60.3 During injection or immunization", "cJpvICTbGsA"),
    ("ICD10", "Y60.4", "Y60.4 During endoscopic examination", "om6uTLFq8f7"),
    ("ICD10", "Y60.5", "Y60.5 During heart catheterization", "p3DqyKMjuql"),
    ("ICD10", "Y60.6", "Y60.6 During aspiration, puncture and other catheterization", "c9vV6o6LLNW"),
    ("ICD10", "Y60.7", "Y60.7 During administration of enema", "DStDKFQ4xcT"),
    ("ICD10", "Y60.8", "Y60.8 During other surgical and medical care", "Ag28hKIo88Q"),
    ("ICD10", "Y60.9", "Y60.9 During unspecified surgical and medical care", "C17sRFbghUA"),
    ("ICD10", "Y61", "Y61 Foreign object accidentally left in body during surgical and medical care", "l47x9C4dJiB"),
    ("ICD10", "Y61.0", "Y61.0 During surgical operation", "IM33552C1lS"),
    ("ICD10", "Y61.1", "Y61.1 During infusion or transfusion", "MiHchiQUb3G"),
    ("ICD10", "Y61.2", "Y61.2 During kidney dialysis or other perfusion", "l02viIBnfb8"),
    ("ICD10", "Y61.3", "Y61.3 During injection or immunization", "aeh0kaaTLWe"),
    ("ICD10", "Y61.4", "Y61.4 During endoscopic examination", "OWwji0TyZ1E"),
    ("ICD10", "Y61.5", "Y61.5 During heart catheterization", "fmFxidlCZGX"),
    ("ICD10", "Y61.6", "Y61.6 During aspiration, puncture and other catheterization", "uOxY8b9NtHF"),
    ("ICD10", "Y61.7", "Y61.7 During removal of catheter or packing", "tC0EWeNfqea"),
    ("ICD10", "Y61.8", "Y61.8 During other surgical and medical care", "aqfEFkKGf5n"),
    ("ICD10", "Y61.9", "Y61.9 During unspecified surgical and medical care", "Fgd4oFOt7ed"),
    ("ICD10", "Y62", "Y62 Failure of sterile precautions during surgical and medical care", "mlb2Pj2yOsq"),
    ("ICD10", "Y62.0", "Y62.0 During surgical operation", "IeCds8x2PcZ"),
    ("ICD10", "Y62.1", "Y62.1 During infusion or transfusion", "PR3aT9WNd6F"),
    ("ICD10", "Y62.2", "Y62.2 During kidney dialysis or other perfusion", "xg3o2hJj2zQ"),
    ("ICD10", "Y62.3", "Y62.3 During injection or immunization", "lBr2a4afDlg"),
    ("ICD10", "Y62.4", "Y62.4 During endoscopic examination", "klUbdmLI946");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Y62.5", "Y62.5 During heart catheterization", "DalGwtOcECO"),
    ("ICD10", "Y62.6", "Y62.6 During aspiration, puncture and other catheterization", "kvkNzAqy1nV"),
    ("ICD10", "Y62.8", "Y62.8 During other surgical and medical care", "RimKSOLSoBS"),
    ("ICD10", "Y62.9", "Y62.9 During unspecified surgical and medical care", "kYJyMlVk42u"),
    ("ICD10", "Y63", "Y63 Failure in dosage during surgical and medical care", "XGfc4lGQVYw"),
    ("ICD10", "Y63.0", "Y63.0 Excessive amount of blood or other fluid given during transfusion or infusion", "cff8QEPZBHQ"),
    ("ICD10", "Y63.1", "Y63.1 Incorrect dilution of fluid used during infusion", "ZUV21AK6srQ"),
    ("ICD10", "Y63.2", "Y63.2 Overdose of radiation given during therapy", "pn8qm3V5Qtv"),
    ("ICD10", "Y63.3", "Y63.3 Inadvertent exposure of patient to radiation during medical care", "BQ1I5CPMbT6"),
    ("ICD10", "Y63.4", "Y63.4 Failure in dosage in electroshock or insulin-shock therapy", "VnwxeqDDa6j"),
    ("ICD10", "Y63.5", "Y63.5 Inappropriate temperature in local application and packing", "B9ODT1qsN6o"),
    ("ICD10", "Y63.6", "Y63.6 Nonadministration of necessary drug, medicament or biological substance", "BQyb8j1CKrB"),
    ("ICD10", "Y63.8", "Y63.8 Failure in dosage during other surgical and medical care", "zKulvXO4QAu"),
    ("ICD10", "Y63.9", "Y63.9 Failure in dosage during unspecified surgical and medical care", "QasVLGnnzwg"),
    ("ICD10", "Y64", "Y64 Contaminated medical or biological substances", "d0tveCv1aNZ"),
    ("ICD10", "Y64.0", "Y64.0 Contaminated medical or biological substance, transfused or infused", "Tp1axBwqfqN"),
    ("ICD10", "Y64.1", "Y64.1 Contaminated medical or biological substance, injected or used for immunization", "pvta5e7kE9R"),
    ("ICD10", "Y64.8", "Y64.8 Contaminated medical or biological substance administered by other means", "Hz5wUWyO2xY"),
    ("ICD10", "Y64.9", "Y64.9 Contaminated medical or biological substance administered by unspecified means", "SntHMpYviOW"),
    ("ICD10", "Y65", "Y65 Other misadventures during surgical and medical care", "JL3EuGN8uAk"),
    ("ICD10", "Y65.0", "Y65.0 Mismatched blood used in transfusion", "qITWEYoyvz0"),
    ("ICD10", "Y65.1", "Y65.1 Wrong fluid used in infusion", "GhIohVcNwb8"),
    ("ICD10", "Y65.2", "Y65.2 Failure in suture or ligature during surgical operation", "yIZFRm8bTVf"),
    ("ICD10", "Y65.3", "Y65.3 Endotracheal tube wrongly placed during anaesthetic procedure", "pIyNrpEpAVL"),
    ("ICD10", "Y65.4", "Y65.4 Failure to introduce or to remove other tube or instrument", "ARyq0JlX5Cj"),
    ("ICD10", "Y65.5", "Y65.5 Performance of inappropriate operation", "wkw8AeeEP4e"),
    ("ICD10", "Y65.8", "Y65.8 Other specified misadventures during surgical and medical care", "MQ3gL3RI7mn"),
    ("ICD10", "Y66", "Y66 Nonadministration of surgical and medical care", "qqh6ovAWkm5"),
    ("ICD10", "Y69", "Y69 Unspecified misadventure during surgical and medical care", "i7qjKsxcS3G"),
    ("ICD10", "Y70", "Y70 Anaesthesiology devices associated with adverse incidents", "SWW7Eiw3Zgt"),
    ("ICD10", "Y71", "Y71 Cardiovascular devices associated with adverse incidents", "cTAp7TDv1HU"),
    ("ICD10", "Y72", "Y72 Otorhinolaryngological devices associated with adverse incidents", "OyBkQJ2CGe6"),
    ("ICD10", "Y73", "Y73 Gastroenterology and urology devices associated with adverse incidents", "AFKkKbD9FIx"),
    ("ICD10", "Y74", "Y74 General hospital and personal-use devices associated with adverse incidents", "mm32DJ6Iwmu"),
    ("ICD10", "Y75", "Y75 Neurological devices associated with adverse incidents", "Lq2l2cYNKS7"),
    ("ICD10", "Y76", "Y76 Obstetric and gynaecological devices associated with adverse incidents", "iYWCqdPb3pc"),
    ("ICD10", "Y77", "Y77 Ophthalmic devices associated with adverse incidents", "A5qXo69yRuE"),
    ("ICD10", "Y78", "Y78 Radiological devices associated with adverse incidents", "QofgphVyTE6"),
    ("ICD10", "Y79", "Y79 Orthopaedic devices associated with adverse incidents", "rrNW7nABy2q"),
    ("ICD10", "Y80", "Y80 Physical medicine devices associated with adverse incidents", "M1HwZVzsAuI"),
    ("ICD10", "Y81", "Y81 General- and plastic-surgery devices associated with adverse incidents", "BlcjJPOGzix"),
    ("ICD10", "Y82", "Y82 Other and unspecified medical devices associated with adverse incidents", "V8bQHBuolOX"),
    ("ICD10", "Y83", "Y83 Surgical operation and other surgical procedures as the cause of abnormal reaction of the patient, or of later complication, without mention of misadventure at the time of the procedure", "f9q5cknuTQJ"),
    ("ICD10", "Y83.0", "Y83.0 Surgical operation with transplant of whole organ", "PVLzshN8C0y"),
    ("ICD10", "Y83.1", "Y83.1 Surgical operation with implant of artificial internal device", "UVp8wj0gN2O"),
    ("ICD10", "Y83.2", "Y83.2 Surgical operation with anastomosis, bypass or graft", "dZCYj9w7mSt"),
    ("ICD10", "Y83.3", "Y83.3 Surgical operation with formation of external stoma", "g1yeRin5qSE"),
    ("ICD10", "Y83.4", "Y83.4 Other reconstructive surgery", "dLVB4YaR5Sb"),
    ("ICD10", "Y83.5", "Y83.5 Amputation of limb(s)", "nPHttpA45K6"),
    ("ICD10", "Y83.6", "Y83.6 Removal of other organ (partial) (total)", "NMYwe7nS2nj"),
    ("ICD10", "Y83.8", "Y83.8 Other surgical procedures", "d960OztH27m"),
    ("ICD10", "Y83.9", "Y83.9 Surgical procedure, unspecified", "wRKM0zIrjts"),
    ("ICD10", "Y84", "Y84 Other medical procedures as the cause of abnormal reaction of the patient, or of later complication, without mention of misadventure at the time of the procedure", "vTX1fSY90jM"),
    ("ICD10", "Y84.0", "Y84.0 Cardiac catheterization", "fJqu5VM0ME3"),
    ("ICD10", "Y84.1", "Y84.1 Kidney dialysis", "ZKe7Eh4s9Fx"),
    ("ICD10", "Y84.2", "Y84.2 Radiological procedure and radiotherapy", "hSOGJzgvc0b"),
    ("ICD10", "Y84.3", "Y84.3 Shock therapy", "raZ3TvPfZHF"),
    ("ICD10", "Y84.4", "Y84.4 Aspiration of fluid", "ICcWpfb2tEA"),
    ("ICD10", "Y84.5", "Y84.5 Insertion of gastric or duodenal sound", "w4zpJf5nO1y"),
    ("ICD10", "Y84.6", "Y84.6 Urinary catheterization", "yrFiO22SvnL"),
    ("ICD10", "Y84.7", "Y84.7 Blood-sampling", "QV7LgV1MdZF"),
    ("ICD10", "Y84.8", "Y84.8 Other medical procedures", "RXb1xRfSYom"),
    ("ICD10", "Y84.9", "Y84.9 Medical procedure, unspecified", "BOVPBAHQSiK"),
    ("ICD10", "Y85", "Y85 Sequelae of transport accidents", "kDEDYvKMT48"),
    ("ICD10", "Y85.0", "Y85.0 Sequelae of motor-vehicle accident", "RapaObtTI7i"),
    ("ICD10", "Y85.9", "Y85.9 Sequelae of other and unspecified transport accidents", "ff6V34VHSM8"),
    ("ICD10", "Y86", "Y86 Sequelae of other accidents", "Ev3rWuNsP42"),
    ("ICD10", "Y87", "Y87 Sequelae of intentional self-harm, assault and events of undetermined intent", "T6QnZF8uCqd"),
    ("ICD10", "Y87.0", "Y87.0 Sequelae of intentional self-harm", "y5jZ0IfAJBH"),
    ("ICD10", "Y87.1", "Y87.1 Sequelae of assault", "O3q1nVh5h0F"),
    ("ICD10", "Y87.2", "Y87.2 Sequelae of events of undetermined intent", "UhjzD2b2ChY"),
    ("ICD10", "Y88", "Y88 Sequelae with surgical and medical care as external cause", "VIYhK6LUXPL"),
    ("ICD10", "Y88.0", "Y88.0 Sequelae of adverse effects caused by drugs, medicaments and biological substances in therapeutic use", "C64iRMJ3C74"),
    ("ICD10", "Y88.1", "Y88.1 Sequelae of misadventures to patients during surgical and medical procedures", "JWFjSVQzDZ9"),
    ("ICD10", "Y88.2", "Y88.2 Sequelae of adverse incidents associated with medical devices in diagnostic and therapeutic use", "lFhzFsoKP6M"),
    ("ICD10", "Y88.3", "Y88.3 Sequelae of surgical and medical procedures as the cause of abnormal reaction of the patient, or of later complication, without mention of misadventure at the time of the procedure", "MSmhbTx3MgD"),
    ("ICD10", "Y89", "Y89 Sequelae of other external causes", "GMupMwqYtzc"),
    ("ICD10", "Y89.0", "Y89.0 Sequelae of legal intervention", "YTKQ1RuuR19"),
    ("ICD10", "Y89.1", "Y89.1 Sequelae of war operations", "IsWw8pdODAb"),
    ("ICD10", "Y89.9", "Y89.9 Sequelae of unspecified external cause", "AYGfbylt0t2"),
    ("ICD10", "Y90", "Y90 Evidence of alcohol involvement determined by blood alcohol level", "XnHo5Ouhnox"),
    ("ICD10", "Y90.0", "Y90.0 Blood alcohol level of less than 20 mg/100 ml", "qIO9tZbzSR4"),
    ("ICD10", "Y90.1", "Y90.1 Blood alcohol level of 20-39 mg/100 ml", "Z40j14Q5Uve"),
    ("ICD10", "Y90.2", "Y90.2 Blood alcohol level of 40-59 mg/100 ml", "vWE5GMAjfZC"),
    ("ICD10", "Y90.3", "Y90.3 Blood alcohol level of 60-79 mg/100 ml", "ODW1cfZWYD4"),
    ("ICD10", "Y90.4", "Y90.4 Blood alcohol level of 80-99 mg/100 ml", "zf9X2kuCGNF"),
    ("ICD10", "Y90.5", "Y90.5 Blood alcohol level of 100-119 mg/100 ml", "OzY3D3QqiGy"),
    ("ICD10", "Y90.6", "Y90.6 Blood alcohol level of 120-199 mg/100 ml", "sBMbSeNIC22"),
    ("ICD10", "Y90.7", "Y90.7 Blood alcohol level of 200-239 mg/100 ml", "K3wv7yPyqiD"),
    ("ICD10", "Y90.8", "Y90.8 Blood alcohol level of 240 mg/100 ml or more", "PLHT3B7q0lX"),
    ("ICD10", "Y90.9", "Y90.9 Presence of alcohol in blood, level not specified", "OSiEUzoClc1"),
    ("ICD10", "Y91", "Y91 Evidence of alcohol involvement determined by level of intoxication", "Svt0JC6j5Uq"),
    ("ICD10", "Y91.0", "Y91.0 Mild alcohol intoxication", "LbKWIJV6wrs"),
    ("ICD10", "Y91.1", "Y91.1 Moderate alcohol intoxication", "mLP2eh5t58c"),
    ("ICD10", "Y91.2", "Y91.2 Severe alcohol intoxication", "ymiMaLUvHLT"),
    ("ICD10", "Y91.3", "Y91.3 Very severe alcohol intoxication", "RvpJ8P9pGoL"),
    ("ICD10", "Y91.9", "Y91.9 Alcohol involvement, not otherwise specified", "WBJIfdu8T9R"),
    ("ICD10", "Y95", "Y95 Nosocomial condition", "F2714queYzK"),
    ("ICD10", "Y96", "Y96 Work-related condition", "OZjQQDxVQYy"),
    ("ICD10", "Y97", "Y97 Environmental-pollution-related condition", "ufhCZHEtg4p"),
    ("ICD10", "Y98", "Y98 Lifestyle-related condition", "KQAtHD82qQw");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Z00", "Z00 General examination and investigation of persons without complaint and reported diagnosis", "UhyO6jL9NMZ"),
    ("ICD10", "Z00.0", "Z00.0 General medical examination", "gTpI5g5Slkx"),
    ("ICD10", "Z00.1", "Z00.1 Routine child health examination", "oUSTklruW9L"),
    ("ICD10", "Z00.2", "Z00.2 Examination for period of rapid growth in childhood", "bCYpn8rGPqA"),
    ("ICD10", "Z00.3", "Z00.3 Examination for adolescent development state", "G1HFzDUsP31"),
    ("ICD10", "Z00.4", "Z00.4 General psychiatric examination, not elsewhere classified", "RlWF0QzMRWA"),
    ("ICD10", "Z00.5", "Z00.5 Examination of potential donor of organ and tissue", "kPjGtEeHR0D"),
    ("ICD10", "Z00.6", "Z00.6 Examination for normal comparison and control in clinical research programme", "iVJuytBdXCD"),
    ("ICD10", "Z00.8", "Z00.8 Other general examinations", "naakEGDiLrH"),
    ("ICD10", "Z01", "Z01 Other special examinations and investigations of persons without complaint or reported diagnosis", "tbc6xYdfBrI"),
    ("ICD10", "Z01.0", "Z01.0 Examination of eyes and vision", "onrUW6nwRmv"),
    ("ICD10", "Z01.1", "Z01.1 Examination of ears and hearing", "mGb34QQALUL"),
    ("ICD10", "Z01.2", "Z01.2 Dental examination", "Y2fRNvpPFrM"),
    ("ICD10", "Z01.3", "Z01.3 Examination of blood pressure", "YhwSQ3tI1pJ"),
    ("ICD10", "Z01.4", "Z01.4 Gynaecological examination (general)(routine)", "eTA3zbMYVM9"),
    ("ICD10", "Z01.5", "Z01.5 Diagnostic skin and sensitization tests", "su8qDSoxfSy"),
    ("ICD10", "Z01.6", "Z01.6 Radiological examination, not elsewhere classified", "Je0C4Pd8XyI"),
    ("ICD10", "Z01.7", "Z01.7 Laboratory examination", "ZwvAx3B0xdC"),
    ("ICD10", "Z01.8", "Z01.8 Other specified special examinations", "FE6BqGZZP9e"),
    ("ICD10", "Z01.9", "Z01.9 Special examination, unspecified", "YZpdrnDISZu"),
    ("ICD10", "Z02", "Z02 Examination and encounter for administrative purposes", "a63OxQkdvJr"),
    ("ICD10", "Z02.0", "Z02.0 Examination for admission to educational institution", "f9cNHZsi09L"),
    ("ICD10", "Z02.1", "Z02.1 Pre-employment examination", "L1ff4JkkCLZ"),
    ("ICD10", "Z02.2", "Z02.2 Examination for admission to residential institutions", "Q1evFlgID3k"),
    ("ICD10", "Z02.3", "Z02.3 Examination for recruitment to armed forces", "TXhe9fXUYV7"),
    ("ICD10", "Z02.4", "Z02.4 Examination for driving licence", "OGw7w0y51Lm"),
    ("ICD10", "Z02.5", "Z02.5 Examination for participation in sport", "MAuB4Rv6Kpc"),
    ("ICD10", "Z02.6", "Z02.6 Examination for insurance purposes", "YztHP3AwwAb"),
    ("ICD10", "Z02.7", "Z02.7 Issue of medical certificate", "S69r00rKYMW"),
    ("ICD10", "Z02.8", "Z02.8 Other examinations for administrative purposes", "OTmA6eblncR"),
    ("ICD10", "Z02.9", "Z02.9 Examination for administrative purposes, unspecified", "ZZznmcrVPyN"),
    ("ICD10", "Z03", "Z03 Medical observation and evaluation for suspected diseases and conditions", "nZ4uxUqvSC4"),
    ("ICD10", "Z03.0", "Z03.0 Observation for suspected tuberculosis", "HwfAohDrJX8"),
    ("ICD10", "Z03.1", "Z03.1 Observation for suspected malignant neoplasm", "N2irxHS5GAz"),
    ("ICD10", "Z03.2", "Z03.2 Observation for suspected mental and behavioural disorders", "ytQo3WLkQ9p"),
    ("ICD10", "Z03.3", "Z03.3 Observation for suspected nervous system disorder", "f4Y5cSFAGRI"),
    ("ICD10", "Z03.4", "Z03.4 Observation for suspected myocardial infarction", "fQzlkVPDYws"),
    ("ICD10", "Z03.5", "Z03.5 Observation for other suspected cardiovascular diseases", "TTMNfjavMDX"),
    ("ICD10", "Z03.6", "Z03.6 Observation for suspected toxic effect from ingested substance", "GdaR49PpozT"),
    ("ICD10", "Z03.8", "Z03.8 Observation for other suspected diseases and conditions", "WOzoTnWYbCy"),
    ("ICD10", "Z03.9", "Z03.9 Observation for suspected disease or condition, unspecified", "LO7CMuRjgow"),
    ("ICD10", "Z04", "Z04 Examination and observation for other reasons", "SeRb6BGmZlw"),
    ("ICD10", "Z04.0", "Z04.0 Blood-alcohol and blood-drug test", "MUFQrU17AEs"),
    ("ICD10", "Z04.1", "Z04.1 Examination and observation following transport accident", "Tu7aXXSvUNx"),
    ("ICD10", "Z04.2", "Z04.2 Examination and observation following work accident", "gHhicXo3n1O"),
    ("ICD10", "Z04.3", "Z04.3 Examination and observation following other accident", "qMWssugasB0"),
    ("ICD10", "Z04.4", "Z04.4 Examination and observation following alleged rape and seduction", "zHykUGfrwX9"),
    ("ICD10", "Z04.5", "Z04.5 Examination and observation following other inflicted injury", "HvIjSWvmHIa"),
    ("ICD10", "Z04.6", "Z04.6 General psychiatric examination, requested by authority", "TuB2y3bG69g"),
    ("ICD10", "Z04.8", "Z04.8 Examination and observation for other specified reasons", "GpzKNXVz9Rj"),
    ("ICD10", "Z04.9", "Z04.9 Examination and observation for unspecified reason", "PYimTQUYURT"),
    ("ICD10", "Z08", "Z08 Follow-up examination after treatment for malignant neoplasms", "X7xGRpgR4VQ"),
    ("ICD10", "Z08.0", "Z08.0 Follow-up examination after surgery for malignant neoplasm", "wH9otM4zClM"),
    ("ICD10", "Z08.1", "Z08.1 Follow-up examination after radiotherapy for malignant neoplasm", "OnCMi60HZqn"),
    ("ICD10", "Z08.2", "Z08.2 Follow-up examination after chemotherapy for malignant neoplasm", "gDw3YEJXeHY"),
    ("ICD10", "Z08.7", "Z08.7 Follow-up examination after combined treatment for malignant neoplasm", "l2jaLjbkgr5"),
    ("ICD10", "Z08.8", "Z08.8 Follow-up examination after other treatment for malignant neoplasm", "FicdcqdnGrm"),
    ("ICD10", "Z08.9", "Z08.9 Follow-up examination after unspecified treatment for malignant neoplasm", "SgH9pwKrfaY"),
    ("ICD10", "Z09", "Z09 Follow-up examination after treatment for conditions other than malignant neoplasms", "mKNJo6b8G2Z"),
    ("ICD10", "Z09.0", "Z09.0 Follow-up examination after surgery for other conditions", "O3vJNBompkj"),
    ("ICD10", "Z09.1", "Z09.1 Follow-up examination after radiotherapy for other conditions", "TK3wzSejKm0"),
    ("ICD10", "Z09.2", "Z09.2 Follow-up examination after chemotherapy for other conditions", "DLXqkRbQbao"),
    ("ICD10", "Z09.3", "Z09.3 Follow-up examination after psychotherapy", "ziFRmvQP10y"),
    ("ICD10", "Z09.4", "Z09.4 Follow-up examination after treatment of fracture", "dFNrM8uyDq8"),
    ("ICD10", "Z09.7", "Z09.7 Follow-up examination after combined treatment for other conditions", "fe6WadLqwEr"),
    ("ICD10", "Z09.8", "Z09.8 Follow-up examination after other treatment for other conditions", "v6dBrcVuIZl"),
    ("ICD10", "Z09.9", "Z09.9 Follow-up examination after unspecified treatment for other conditions", "gqE6LtQxSZ2"),
    ("ICD10", "Z10", "Z10 Routine general health check-up of defined subpopulation", "qKNBDG8td3W"),
    ("ICD10", "Z10.0", "Z10.0 Occupational health examination", "eQvB5sjbY2k"),
    ("ICD10", "Z10.1", "Z10.1 Routine general health check-up of inhabitants of institutions", "hzmK3rTMSP2"),
    ("ICD10", "Z10.2", "Z10.2 Routine general health check-up of armed forces", "H0NJ2NWaztB"),
    ("ICD10", "Z10.3", "Z10.3 Routine general health check-up of sports teams", "uJJBaxkl1qa"),
    ("ICD10", "Z10.8", "Z10.8 Routine general health check-up of other defined subpopulations", "VQcJdJ4q0vq"),
    ("ICD10", "Z11", "Z11 Special screening examination for infectious and parasitic diseases", "yyQrSTC66W3"),
    ("ICD10", "Z11.0", "Z11.0 Special screening examination for intestinal infectious diseases", "jF6AiUvhoT7"),
    ("ICD10", "Z11.1", "Z11.1 Special screening examination for respiratory tuberculosis", "G0tgaFJOftW"),
    ("ICD10", "Z11.2", "Z11.2 Special screening examination for other bacterial diseases", "ZXbhtJJGVHv"),
    ("ICD10", "Z11.3", "Z11.3 Special screening examination for infections with a predominantly sexual mode of transmission", "y3MLa2xdA2T"),
    ("ICD10", "Z11.4", "Z11.4 Special screening examination for human immunodeficiency virus [HIV]", "jWyYjDIChAM"),
    ("ICD10", "Z11.5", "Z11.5 Special screening examination for other viral diseases", "BkG2noekqZo"),
    ("ICD10", "Z11.6", "Z11.6 Special screening examination for other protozoal diseases and helminthiases", "SJzpKsseuGz"),
    ("ICD10", "Z11.8", "Z11.8 Special screening examination for other infectious and parasitic diseases", "cx7MqvhEON5"),
    ("ICD10", "Z11.9", "Z11.9 Special screening examination for infectious and parasitic diseases, unspecified", "VPpSI6mZm4A"),
    ("ICD10", "Z12", "Z12 Special screening examination for neoplasms", "Ilf5mQgjlss"),
    ("ICD10", "Z12.0", "Z12.0 Special screening examination for neoplasm of stomach", "vvxAkiDxnvc"),
    ("ICD10", "Z12.1", "Z12.1 Special screening examination for neoplasm of intestinal tract", "gcgNIVUKje6"),
    ("ICD10", "Z12.2", "Z12.2 Special screening examination for neoplasm of respiratory organs", "hYbzjWYBHFR"),
    ("ICD10", "Z12.3", "Z12.3 Special screening examination for neoplasm of breast", "FOdO13ax97K"),
    ("ICD10", "Z12.4", "Z12.4 Special screening examination for neoplasm of cervix", "AgOxGEk8PI0"),
    ("ICD10", "Z12.5", "Z12.5 Special screening examination for neoplasm of prostate", "vF5LhIwUggv"),
    ("ICD10", "Z12.6", "Z12.6 Special screening examination for neoplasm of bladder", "ORyhMGbB7vz"),
    ("ICD10", "Z12.8", "Z12.8 Special screening examination for neoplasms of other sites", "FmRkmmBkhQN"),
    ("ICD10", "Z12.9", "Z12.9 Special screening examination for neoplasm, unspecified", "M8FBI6Pb1Ze"),
    ("ICD10", "Z13", "Z13 Special screening examination for other diseases and disorders", "oKKXSppHAB6"),
    ("ICD10", "Z13.0", "Z13.0 Special screening examination for diseases of the blood and blood-forming organs and certain disorders involving the immune mechanism", "R7k6GcPVquU"),
    ("ICD10", "Z13.1", "Z13.1 Special screening examination for diabetes mellitus", "xkQKQnQUEtW"),
    ("ICD10", "Z13.2", "Z13.2 Special screening examination for nutritional disorders", "iIpb2XTjMDg"),
    ("ICD10", "Z13.3", "Z13.3 Special screening examination for mental and behavioural disorders", "UwKSSOmqY07"),
    ("ICD10", "Z13.4", "Z13.4 Special screening examination for certain developmental disorders in childhood", "zKKnJ8ov8mq"),
    ("ICD10", "Z13.5", "Z13.5 Special screening examination for eye and ear disorders", "Mxh2ZaGyIcr"),
    ("ICD10", "Z13.6", "Z13.6 Special screening examination for cardiovascular disorders", "AYxQLgH7UJ2"),
    ("ICD10", "Z13.7", "Z13.7 Special screening examination for congenital malformations, deformations and chromosomal abnormalities", "o5nymlGTY6H"),
    ("ICD10", "Z13.8", "Z13.8 Special screening examination for other specified diseases and disorders", "RxE88gft8Aa"),
    ("ICD10", "Z13.9", "Z13.9 Special screening examination, unspecified", "T97bstfcmhk"),
    ("ICD10", "Z20", "Z20 Contact with and exposure to communicable diseases", "X9XyppnSYlb"),
    ("ICD10", "Z20.0", "Z20.0 Contact with and exposure to intestinal infectious diseases", "gnhYS3I1BGt"),
    ("ICD10", "Z20.1", "Z20.1 Contact with and exposure to tuberculosis", "hOcgFZDyjVY"),
    ("ICD10", "Z20.2", "Z20.2 Contact with and exposure to infections with a predominantly sexual mode of transmission", "MogfopCwGQK"),
    ("ICD10", "Z20.3", "Z20.3 Contact with and exposure to rabies", "u57BRQsM4LE"),
    ("ICD10", "Z20.4", "Z20.4 Contact with and exposure to rubella", "gkMFURRMHff"),
    ("ICD10", "Z20.5", "Z20.5 Contact with and exposure to viral hepatitis", "NLpzLkpshbE"),
    ("ICD10", "Z20.6", "Z20.6 Contact with and exposure to human immunodeficiency virus [HIV]", "E8gbGBnXTwk"),
    ("ICD10", "Z20.7", "Z20.7 Contact with and exposure to pediculosis, acariasis and other infestations", "QimiYNn7cEs"),
    ("ICD10", "Z20.8", "Z20.8 Contact with and exposure to other communicable diseases", "eTsgEzsJKE2"),
    ("ICD10", "Z20.9", "Z20.9 Contact with and exposure to unspecified communicable disease", "BczDOzmt6Gu"),
    ("ICD10", "Z21", "Z21 Asymptomatic human immunodeficiency virus [HIV] infection status", "h8nOdtYdvUX"),
    ("ICD10", "Z22", "Z22 Carrier of infectious disease", "OguIEKG8NfN"),
    ("ICD10", "Z22.0", "Z22.0 Carrier of typhoid", "InPgbOgQEck"),
    ("ICD10", "Z22.1", "Z22.1 Carrier of other intestinal infectious diseases", "V8j5dHfhdB5"),
    ("ICD10", "Z22.2", "Z22.2 Carrier of diphtheria", "rMFEqLUpswf"),
    ("ICD10", "Z22.3", "Z22.3 Carrier of other specified bacterial diseases", "GQtnkdOKadB"),
    ("ICD10", "Z22.4", "Z22.4 Carrier of infections with a predominantly sexual mode of transmission", "M8luWxcPS4C"),
    ("ICD10", "Z22.6", "Z22.6 Carrier of human T-lymphotropic virus type- 1 [HTLV-1] infection", "An6zBPu8yNd"),
    ("ICD10", "Z22.8", "Z22.8 Carrier of other infectious diseases", "S6EcyqBSo1V"),
    ("ICD10", "Z22.9", "Z22.9 Carrier of infectious disease, unspecified", "Eltiurhg5r0"),
    ("ICD10", "Z23", "Z23 Need for immunization against single bacterial diseases", "t4I0TcUW9A1"),
    ("ICD10", "Z23.0", "Z23.0 Need for immunization against cholera alone", "obm5uPtMrbO"),
    ("ICD10", "Z23.1", "Z23.1 Need for immunization against typhoid-paratyphoid alone [TAB]", "PUxrsv05tvu"),
    ("ICD10", "Z23.2", "Z23.2 Need for immunization against tuberculosis [BCG]", "zB9DirtgVLx"),
    ("ICD10", "Z23.3", "Z23.3 Need for immunization against plague", "IBEhSrh3n6q"),
    ("ICD10", "Z23.4", "Z23.4 Need for immunization against tularaemia", "a3M5y0ddfhL"),
    ("ICD10", "Z23.5", "Z23.5 Need for immunization against tetanus alone", "osL5BM7rjgC"),
    ("ICD10", "Z23.6", "Z23.6 Need for immunization against diphtheria alone", "Q1i9ZM4QFZT"),
    ("ICD10", "Z23.7", "Z23.7 Need for immunization against pertussis alone", "L2fWBa6k9On"),
    ("ICD10", "Z23.8", "Z23.8 Need for immunization against other single bacterial diseases", "b6QWiifiR7z"),
    ("ICD10", "Z24", "Z24 Need for immunization against certain single viral diseases", "DKSSKmZsQMW"),
    ("ICD10", "Z24.0", "Z24.0 Need for immunization against poliomyelitis", "s9815VSmAsM"),
    ("ICD10", "Z24.1", "Z24.1 Need for immunization against arthropod-borne viral encephalitis", "kLaCrB5TRi3"),
    ("ICD10", "Z24.2", "Z24.2 Need for immunization against rabies", "q4aoAuwulq7"),
    ("ICD10", "Z24.3", "Z24.3 Need for immunization against yellow fever", "rCWaq1mFOUN"),
    ("ICD10", "Z24.4", "Z24.4 Need for immunization against measles alone", "MRJPm7ANtT9"),
    ("ICD10", "Z24.5", "Z24.5 Need for immunization against rubella alone", "cpWFum6boKa"),
    ("ICD10", "Z24.6", "Z24.6 Need for immunization against viral hepatitis", "q0sDq92y9Rm"),
    ("ICD10", "Z25", "Z25 Need for immunization against other single viral diseases", "DaWvxTcom6B"),
    ("ICD10", "Z25.0", "Z25.0 Need for immunization against mumps alone", "a20atFkHxsO"),
    ("ICD10", "Z25.1", "Z25.1 Need for immunization against influenza", "xtMu3sioIsy"),
    ("ICD10", "Z25.8", "Z25.8 Need for immunization against other specified single viral diseases", "OudAQb2sLo5"),
    ("ICD10", "Z26", "Z26 Need for immunization against other single infectious diseases", "SkV33BR1bVa"),
    ("ICD10", "Z26.0", "Z26.0 Need for immunization against leishmaniasis", "v3w3t8F4yTp"),
    ("ICD10", "Z26.8", "Z26.8 Need for immunization against other specified single infectious diseases", "husbwedi9hF"),
    ("ICD10", "Z26.9", "Z26.9 Need for immunization against unspecified infectious disease", "UBEcoSZCcUE"),
    ("ICD10", "Z27", "Z27 Need for immunization against combinations of infectious diseases", "wHOEXKVYPYw"),
    ("ICD10", "Z27.0", "Z27.0 Need for immunization against cholera with typhoid-paratyphoid [cholera + TAB]", "isQHbmHgVsO"),
    ("ICD10", "Z27.1", "Z27.1 Need for immunization against diphtheria-tetanus-pertussis, combined [DTP]", "CMdwBxo2X6R"),
    ("ICD10", "Z27.2", "Z27.2 Need for immunization against diphtheria-tetanus-pertussis with typhoid-paratyphoid [DTP + TAB]", "uMSEpCF2HIl"),
    ("ICD10", "Z27.3", "Z27.3 Need for immunization against diphtheria-tetanus-pertussis with poliomyelitis [DTP + polio]", "dGVOvbEWCYl"),
    ("ICD10", "Z27.4", "Z27.4 Need for immunization against measles-mumps-rubella [MMR]", "ydENCmQjzAJ"),
    ("ICD10", "Z27.8", "Z27.8 Need for immunization against other combinations of infectious diseases", "qu7eBUBslUD"),
    ("ICD10", "Z27.9", "Z27.9 Need for immunization against unspecified combinations of infectious diseases", "yiwVL0vJ5WF"),
    ("ICD10", "Z28", "Z28 Immunization not carried out", "qr0Y9JdOtRp"),
    ("ICD10", "Z28.0", "Z28.0 Immunization not carried out because of contraindication", "Bf3wQ2S5i0d"),
    ("ICD10", "Z28.1", "Z28.1 Immunization not carried out because of patient's decision for reasons of belief or group pressure", "YgQbhr4VlbT"),
    ("ICD10", "Z28.2", "Z28.2 Immunization not carried out because of patient's decision for other and unspecified reasons", "O4kLVgCWwsa"),
    ("ICD10", "Z28.8", "Z28.8 Immunization not carried out for other reasons", "b7CfwcdCynK");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Z28.9", "Z28.9 Immunization not carried out for unspecified reason", "pxZBhlF6a5D"),
    ("ICD10", "Z29", "Z29 Need for other prophylactic measures", "WmnfnZC4ePn"),
    ("ICD10", "Z29.0", "Z29.0 Isolation", "iBwwje4tPAQ"),
    ("ICD10", "Z29.1", "Z29.1 Prophylactic immunotherapy", "jNOsMejaiQC"),
    ("ICD10", "Z29.2", "Z29.2 Other prophylactic chemotherapy", "W7JbdsF7kRw"),
    ("ICD10", "Z29.8", "Z29.8 Other specified prophylactic measures", "pg9sNZl4HLb"),
    ("ICD10", "Z29.9", "Z29.9 Prophylactic measure, unspecified", "MIcUiWVQcM1"),
    ("ICD10", "Z30", "Z30 Contraceptive management", "p9z6PMjLLUv"),
    ("ICD10", "Z30.0", "Z30.0 General counselling and advice on contraception", "hECQnVoKFEA"),
    ("ICD10", "Z30.1", "Z30.1 Insertion of (intrauterine) contraceptive device", "bvuolypYC8v"),
    ("ICD10", "Z30.2", "Z30.2 Sterilization", "U2sFGlPDrlE"),
    ("ICD10", "Z30.3", "Z30.3 Menstrual extraction", "w69ugIFtyGM"),
    ("ICD10", "Z30.4", "Z30.4 Surveillance of contraceptive drugs", "aShpvc5NELt"),
    ("ICD10", "Z30.5", "Z30.5 Surveillance of (intrauterine) contraceptive device", "OxDEYwLHshx"),
    ("ICD10", "Z30.8", "Z30.8 Other contraceptive management", "lw5CBtJgTYl"),
    ("ICD10", "Z30.9", "Z30.9 Contraceptive management, unspecified", "fZJTlwnng1Z"),
    ("ICD10", "Z31", "Z31 Procreative management", "XUATHKi7Ce2"),
    ("ICD10", "Z31.0", "Z31.0 Tuboplasty or vasoplasty after previous sterilization", "lTI187aVioE"),
    ("ICD10", "Z31.1", "Z31.1 Artificial insemination", "PxV07wkCRJo"),
    ("ICD10", "Z31.2", "Z31.2 None", "bBH2gfjhScK"),
    ("ICD10", "Z31.3", "Z31.3 Other assisted fertilization methods", "DPcfLbz4s20"),
    ("ICD10", "Z31.4", "Z31.4 Procreative investigation and testing", "rg3JUZFSgfv"),
    ("ICD10", "Z31.5", "Z31.5 Genetic counselling", "d9OEIka5v5x"),
    ("ICD10", "Z31.6", "Z31.6 General counselling and advice on procreation", "wPiqEOZQn9V"),
    ("ICD10", "Z31.8", "Z31.8 Other procreative management", "aZKgzgWnCF1"),
    ("ICD10", "Z31.9", "Z31.9 Procreative management, unspecified", "YmYcsfWzvRy"),
    ("ICD10", "Z32", "Z32 Pregnancy examination and test", "zx2MxklFGDH"),
    ("ICD10", "Z32.0", "Z32.0 Pregnancy, not (yet) confirmed", "aFnNtRm0STo"),
    ("ICD10", "Z32.1", "Z32.1 Pregnancy confirmed", "sX55mXg6x7W"),
    ("ICD10", "Z33", "Z33 Pregnant state, incidental", "MoNgnRs8QUM"),
    ("ICD10", "Z34", "Z34 Supervision of normal pregnancy", "ikhCzwWgFW0"),
    ("ICD10", "Z34.0", "Z34.0 Supervision of normal first pregnancy", "rGz2ySoQVsq"),
    ("ICD10", "Z34.8", "Z34.8 Supervision of other normal pregnancy", "kKGueetlTmC"),
    ("ICD10", "Z34.9", "Z34.9 Supervision of normal pregnancy, unspecified", "n2HDGRGZwpr"),
    ("ICD10", "Z35", "Z35 Supervision of high-risk pregnancy", "NnRhLnU3fzP"),
    ("ICD10", "Z35.0", "Z35.0 Supervision of pregnancy with history of infertility", "yac6MGhRoY6"),
    ("ICD10", "Z35.1", "Z35.1 Supervision of pregnancy with history of abortive outcome", "lXtG7HOpFvA"),
    ("ICD10", "Z35.2", "Z35.2 Supervision of pregnancy with other poor reproductive or obstetric history", "uNe63JX4NqN"),
    ("ICD10", "Z35.3", "Z35.3 Supervision of pregnancy with history of insufficient antenatal care", "I2iOpH9Rdm2"),
    ("ICD10", "Z35.4", "Z35.4 Supervision of pregnancy with grand multiparity", "DjtqT33pSyG"),
    ("ICD10", "Z35.5", "Z35.5 Supervision of elderly primigravida", "Hurzonxw1GS"),
    ("ICD10", "Z35.6", "Z35.6 Supervision of very young primigravida", "VaUxLT0dGU1"),
    ("ICD10", "Z35.7", "Z35.7 Supervision of high-risk pregnancy due to social problems", "wJQf1JZxaGW"),
    ("ICD10", "Z35.8", "Z35.8 Supervision of other high-risk pregnancies", "DGUedKZO4AH"),
    ("ICD10", "Z35.9", "Z35.9 Supervision of high-risk pregnancy, unspecified", "SoIJKdTJ2Iu"),
    ("ICD10", "Z36", "Z36 Antenatal screening", "UVeFpEPZm9d"),
    ("ICD10", "Z36.0", "Z36.0 Antenatal screening for chromosomal anomalies", "rtbhLmwEb6J"),
    ("ICD10", "Z36.1", "Z36.1 Antenatal screening for raised alphafetoprotein level", "etL78DbSNS2"),
    ("ICD10", "Z36.2", "Z36.2 Other antenatal screening based on amniocentesis", "cwx4lwgavix"),
    ("ICD10", "Z36.3", "Z36.3 Antenatal screening for malformations using ultrasound and other physical methods", "dtVrdxWLpGH"),
    ("ICD10", "Z36.4", "Z36.4 Antenatal screening for fetal growth retardation using ultrasound and other physical methods", "a3SS6j8plVZ"),
    ("ICD10", "Z36.5", "Z36.5 Antenatal screening for isoimmunization", "ToFePO0j6gL"),
    ("ICD10", "Z36.8", "Z36.8 Other antenatal screening", "E3b9JrgR7CI"),
    ("ICD10", "Z36.9", "Z36.9 Antenatal screening, unspecified", "TJh4KBLmnOm"),
    ("ICD10", "Z37", "Z37 Outcome of delivery", "ZPNuyQg92ng"),
    ("ICD10", "Z37.0", "Z37.0 Single live birth", "EEReCQdszDy"),
    ("ICD10", "Z37.1", "Z37.1 Single stillbirth", "YwVIEwnvpig"),
    ("ICD10", "Z37.2", "Z37.2 Twins, both liveborn", "O8dautxBOJd"),
    ("ICD10", "Z37.3", "Z37.3 Twins, one liveborn and one stillborn", "fRT07QpZne4"),
    ("ICD10", "Z37.4", "Z37.4 Twins, both stillborn", "jQONDv4fk54"),
    ("ICD10", "Z37.5", "Z37.5 Other multiple births, all liveborn", "crQJ6buQBJA"),
    ("ICD10", "Z37.6", "Z37.6 Other multiple births, some liveborn", "i98VRIwzbft"),
    ("ICD10", "Z37.7", "Z37.7 Other multiple births, all stillborn", "FCtEBl7yX9h"),
    ("ICD10", "Z37.9", "Z37.9 Outcome of delivery, unspecified", "w5ZmMf6rond"),
    ("ICD10", "Z38", "Z38 Liveborn infants according to place of birth", "zlOzk0vELww"),
    ("ICD10", "Z38.0", "Z38.0 Singleton, born in hospital", "mfBHj9zDFj4"),
    ("ICD10", "Z38.1", "Z38.1 Singleton, born outside hospital", "N3GldxiTmQT"),
    ("ICD10", "Z38.2", "Z38.2 Singleton, unspecified as to place of birth", "b7PpZ9iV3GJ"),
    ("ICD10", "Z38.3", "Z38.3 Twin, born in hospital", "Enl3XzBkAcE"),
    ("ICD10", "Z38.4", "Z38.4 Twin, born outside hospital", "dkXgOddr0UL"),
    ("ICD10", "Z38.5", "Z38.5 Twin, unspecified as to place of birth", "udmaFvoKCX8"),
    ("ICD10", "Z38.6", "Z38.6 Other multiple, born in hospital", "YLCdhumrUXM"),
    ("ICD10", "Z38.7", "Z38.7 Other multiple, born outside hospital", "imvk99Wj6ws"),
    ("ICD10", "Z38.8", "Z38.8 Other multiple, unspecified as to place of birth", "DfjewlB1L7S"),
    ("ICD10", "Z39", "Z39 Postpartum care and examination", "nujqOqQv2ig"),
    ("ICD10", "Z39.0", "Z39.0 Care and examination immediately after delivery", "XmNar2cQ58l"),
    ("ICD10", "Z39.1", "Z39.1 Care and examination of lactating mother", "Upb2CENbQkP"),
    ("ICD10", "Z39.2", "Z39.2 Routine postpartum follow-up", "saRAM4YhqJT"),
    ("ICD10", "Z40", "Z40 Prophylactic surgery", "REjmoUwVohP"),
    ("ICD10", "Z40.0", "Z40.0 Prophylactic surgery for risk-factors related to malignant neoplasms", "sDm7paBrkmb"),
    ("ICD10", "Z40.8", "Z40.8 Other prophylactic surgery", "Re7v6egd8ow"),
    ("ICD10", "Z40.9", "Z40.9 Prophylactic surgery, unspecified", "Hg2UeEcZHGh"),
    ("ICD10", "Z41", "Z41 Procedures for purposes other than remedying health state", "JpPu9DcFadM"),
    ("ICD10", "Z41.0", "Z41.0 Hair transplant", "DCpiB6ePqeY"),
    ("ICD10", "Z41.1", "Z41.1 Other plastic surgery for unacceptable cosmetic appearance", "GwKoGWRWYjf"),
    ("ICD10", "Z41.2", "Z41.2 Routine and ritual circumcision", "C4Rwl07qqVy"),
    ("ICD10", "Z41.3", "Z41.3 Ear piercing", "qWmsYRHdvRT"),
    ("ICD10", "Z41.8", "Z41.8 Other procedures for purposes other than remedying health state", "mZgOTgm4ns6"),
    ("ICD10", "Z41.9", "Z41.9 Procedure for purposes other than remedying health state, unspecified", "Xr3vXEkpzyH"),
    ("ICD10", "Z42", "Z42 Follow-up care involving plastic surgery", "jw5o0SyiiWI"),
    ("ICD10", "Z42.0", "Z42.0 Follow-up care involving plastic surgery of head and neck", "kwO94OnlGkB"),
    ("ICD10", "Z42.1", "Z42.1 Follow-up care involving plastic surgery of breast", "alZSVwBGij3"),
    ("ICD10", "Z42.2", "Z42.2 Follow-up care involving plastic surgery of other parts of trunk", "q1vq7WDH1Cy"),
    ("ICD10", "Z42.3", "Z42.3 Follow-up care involving plastic surgery of upper extremity", "gbCSEivPP87"),
    ("ICD10", "Z42.4", "Z42.4 Follow-up care involving plastic surgery of lower extremity", "pcnuearWwqB"),
    ("ICD10", "Z42.8", "Z42.8 Follow-up care involving plastic surgery of other body part", "MPUO4JrWOWr"),
    ("ICD10", "Z42.9", "Z42.9 Follow-up care involving plastic surgery, unspecified", "tyPPMfdu62H"),
    ("ICD10", "Z43", "Z43 Attention to artificial openings", "DtXLw1IYFf0"),
    ("ICD10", "Z43.0", "Z43.0 Attention to tracheostomy", "q33ZydOVaxw"),
    ("ICD10", "Z43.1", "Z43.1 Attention to gastrostomy", "ul7tB7MGekN"),
    ("ICD10", "Z43.2", "Z43.2 Attention to ileostomy", "mYf61Gb4P1P"),
    ("ICD10", "Z43.3", "Z43.3 Attention to colostomy", "UA8pcKOWFlu"),
    ("ICD10", "Z43.4", "Z43.4 Attention to other artificial openings of digestive tract", "HOuYRb3iuJZ"),
    ("ICD10", "Z43.5", "Z43.5 Attention to cystostomy", "bgVzvF3dCmD"),
    ("ICD10", "Z43.6", "Z43.6 Attention to other artificial openings of urinary tract", "uU7wvvsUw5y"),
    ("ICD10", "Z43.7", "Z43.7 Attention to artificial vagina", "o5KFcmAlPRm"),
    ("ICD10", "Z43.8", "Z43.8 Attention to other artificial openings", "Z2tNibcU4t3"),
    ("ICD10", "Z43.9", "Z43.9 Attention to unspecified artificial opening", "cuvxW6DDaQf"),
    ("ICD10", "Z44", "Z44 Fitting and adjustment of external prosthetic device", "RNiLRiWCwcH"),
    ("ICD10", "Z44.0", "Z44.0 Fitting and adjustment of artificial arm (complete)(partial)", "ykb06GnkB6M"),
    ("ICD10", "Z44.1", "Z44.1 Fitting and adjustment of artificial leg (complete)(partial)", "s2NU62BwKsC"),
    ("ICD10", "Z44.2", "Z44.2 Fitting and adjustment of artificial eye", "zM0qGUajUbc"),
    ("ICD10", "Z44.3", "Z44.3 Fitting and adjustment of external breast prosthesis", "W9unU025fwO"),
    ("ICD10", "Z44.8", "Z44.8 Fitting and adjustment of other external prosthetic devices", "c6k2Y7hSvZ0"),
    ("ICD10", "Z44.9", "Z44.9 Fitting and adjustment of unspecified external prosthetic device", "ChgKRfAc43V"),
    ("ICD10", "Z45", "Z45 Adjustment and management of implanted device", "OqbUc16J14l"),
    ("ICD10", "Z45.0", "Z45.0 Adjustment and management of cardiac devices", "w95EPmsuICo"),
    ("ICD10", "Z45.1", "Z45.1 Adjustment and management of infusion pump", "FPrRVbCgS0o"),
    ("ICD10", "Z45.2", "Z45.2 Adjustment and management of vascular access device", "F4wWQxskxhO"),
    ("ICD10", "Z45.3", "Z45.3 Adjustment and management of implanted hearing device", "mFnASXzA1Q8"),
    ("ICD10", "Z45.8", "Z45.8 Adjustment and management of other implanted devices", "eucub2S0OgY"),
    ("ICD10", "Z45.9", "Z45.9 Adjustment and management of unspecified implanted device", "vWTYyeG1Nbf"),
    ("ICD10", "Z46", "Z46 Fitting and adjustment of other devices", "BqUk2wlKPHx"),
    ("ICD10", "Z46.0", "Z46.0 Fitting and adjustment of spectacles and contact lenses", "RH1mD5W4A8Z"),
    ("ICD10", "Z46.1", "Z46.1 Fitting and adjustment of hearing aid", "YcbTyhaHbRy"),
    ("ICD10", "Z46.2", "Z46.2 Fitting and adjustment of other devices related to nervous system and special senses", "UcX5HX2aF8y"),
    ("ICD10", "Z46.3", "Z46.3 Fitting and adjustment of dental prosthetic device", "S1W2Cghd91r"),
    ("ICD10", "Z46.4", "Z46.4 Fitting and adjustment of orthodontic device", "v51nJUWgMvm"),
    ("ICD10", "Z46.5", "Z46.5 Fitting and adjustment of ileostomy and other intestinal appliances", "an5eWmpakmQ"),
    ("ICD10", "Z46.6", "Z46.6 Fitting and adjustment of urinary device", "Vp6i3iC63N9"),
    ("ICD10", "Z46.7", "Z46.7 Fitting and adjustment of orthopaedic device", "lSWqNg98J0e"),
    ("ICD10", "Z46.8", "Z46.8 Fitting and adjustment of other specified devices", "TQGluJ23Es3"),
    ("ICD10", "Z46.9", "Z46.9 Fitting and adjustment of unspecified device", "nYWdWPNaWja"),
    ("ICD10", "Z47", "Z47 Other orthopaedic follow-up care", "hQgzaG70Pb6"),
    ("ICD10", "Z47.0", "Z47.0 Follow-up care involving removal of fracture plate and other internal fixation device", "RTrXxhayJ55"),
    ("ICD10", "Z47.8", "Z47.8 Other specified orthopaedic follow-up care", "ue39TVZAoJi"),
    ("ICD10", "Z47.9", "Z47.9 Orthopaedic follow-up care, unspecified", "hQRZTT4iqJ2"),
    ("ICD10", "Z48", "Z48 Other surgical follow-up care", "rbgJowUr2Pr"),
    ("ICD10", "Z48.0", "Z48.0 Attention to surgical dressings and sutures", "HPoOBjeG6da"),
    ("ICD10", "Z48.8", "Z48.8 Other specified surgical follow-up care", "Cgywy6BOPAU"),
    ("ICD10", "Z48.9", "Z48.9 Surgical follow-up care, unspecified", "M5VLCKgzgGO"),
    ("ICD10", "Z49", "Z49 Care involving dialysis", "yW8czYBu8Vx"),
    ("ICD10", "Z49.0", "Z49.0 Preparatory care for dialysis", "YuRPOqz9xYA"),
    ("ICD10", "Z49.1", "Z49.1 Extracorporeal dialysis", "XZnzOWwaFUW"),
    ("ICD10", "Z49.2", "Z49.2 Other dialysis", "uAsipCSctuP"),
    ("ICD10", "Z50", "Z50 Care involving use of rehabilitation procedures", "bkhOTIK5Z1X"),
    ("ICD10", "Z50.0", "Z50.0 Cardiac rehabilitation", "oLi2blmcaII"),
    ("ICD10", "Z50.1", "Z50.1 Other physical therapy", "pnc2lkFmXEm"),
    ("ICD10", "Z50.2", "Z50.2 Alcohol rehabilitation", "AoPOi0YcgYE"),
    ("ICD10", "Z50.3", "Z50.3 Drug rehabilitation", "qqMnrJIIDFA"),
    ("ICD10", "Z50.4", "Z50.4 Psychotherapy, not elsewhere classified", "UKtl2ks6XlK"),
    ("ICD10", "Z50.5", "Z50.5 Speech therapy", "dqB8TphyVRJ"),
    ("ICD10", "Z50.6", "Z50.6 Orthoptic training", "ivSqgpwHTRm"),
    ("ICD10", "Z50.7", "Z50.7 Occupational therapy and vocational rehabilitation, not elsewhere classified", "IPkd4XobSfV"),
    ("ICD10", "Z50.8", "Z50.8 Care involving use of other rehabilitation procedures", "FQ5LbdzND4p"),
    ("ICD10", "Z50.9", "Z50.9 Care involving use of rehabilitation procedure, unspecified", "qXl4BkbqGF6"),
    ("ICD10", "Z51", "Z51 Other medical care", "ezD0BbtiwAI"),
    ("ICD10", "Z51.0", "Z51.0 Radiotherapy session", "ZUhFqBvIX4c"),
    ("ICD10", "Z51.1", "Z51.1 Chemotherapy session for neoplasm", "IwOjM0cvLYn"),
    ("ICD10", "Z51.2", "Z51.2 Other chemotherapy", "GkdkaeaEEOr"),
    ("ICD10", "Z51.3", "Z51.3 Blood transfusion (without reported diagnosis)", "qEk7dujCeyi"),
    ("ICD10", "Z51.4", "Z51.4 Preparatory care for subsequent treatment, not elsewhere classified", "pJxLGsJIWly"),
    ("ICD10", "Z51.5", "Z51.5 Palliative care", "Vuc7xYgAKIO"),
    ("ICD10", "Z51.6", "Z51.6 Desensitization to allergens", "AdQhLy1Pt8B"),
    ("ICD10", "Z51.8", "Z51.8 Other specified medical care", "rdWHTViCVTy"),
    ("ICD10", "Z51.9", "Z51.9 Medical care, unspecified", "A1rQquXqbQG"),
    ("ICD10", "Z52", "Z52 Donors of organs and tissues", "oxl8tXB6t0n"),
    ("ICD10", "Z52.0", "Z52.0 Blood donor", "jHs5wf0q7B0"),
    ("ICD10", "Z52.1", "Z52.1 Skin donor", "rIuioVgZl2Q"),
    ("ICD10", "Z52.2", "Z52.2 Bone donor", "pPL0bmmsekW"),
    ("ICD10", "Z52.3", "Z52.3 Bone marrow donor", "ijNChMOjpst"),
    ("ICD10", "Z52.4", "Z52.4 Kidney donor", "uwcE3s57OcI"),
    ("ICD10", "Z52.5", "Z52.5 Cornea donor", "Dgj7OlMhvhx"),
    ("ICD10", "Z52.6", "Z52.6 Liver donor", "d3FBTtoVLYF"),
    ("ICD10", "Z52.7", "Z52.7 Heart donor", "TES0nd11b9l"),
    ("ICD10", "Z52.8", "Z52.8 Donor of other organs and tissues", "uKm4i7xYwAh"),
    ("ICD10", "Z52.9", "Z52.9 Donor of unspecified organ or tissue", "iXm0IiSnw4p"),
    ("ICD10", "Z53", "Z53 Persons encountering health services for specific procedures, not carried out", "BXCK0eNc1bt"),
    ("ICD10", "Z53.0", "Z53.0 Procedure not carried out because of contraindication", "ylGwbOV5v5i"),
    ("ICD10", "Z53.1", "Z53.1 Procedure not carried out because of patient's decision for reasons of belief and group pressure", "sFXBKVxNC4m"),
    ("ICD10", "Z53.2", "Z53.2 Procedure not carried out because of patient's decision for other and unspecified reasons", "Xi253vMPHHq"),
    ("ICD10", "Z53.8", "Z53.8 Procedure not carried out for other reasons", "o8rfbX8KOVd"),
    ("ICD10", "Z53.9", "Z53.9 Procedure not carried out, unspecified reason", "ot6N0EPckab"),
    ("ICD10", "Z54", "Z54 Convalescence", "u9oLDgP36Nj"),
    ("ICD10", "Z54.0", "Z54.0 Convalescence following surgery", "wIo2LvU90bR"),
    ("ICD10", "Z54.1", "Z54.1 Convalescence following radiotherapy", "HFVk3GA02Q4"),
    ("ICD10", "Z54.2", "Z54.2 Convalescence following chemotherapy", "SVKT5ci54Ie"),
    ("ICD10", "Z54.3", "Z54.3 Convalescence following psychotherapy", "TrZxgYRnoBK"),
    ("ICD10", "Z54.4", "Z54.4 Convalescence following treatment of fracture", "TElkEJfWCo0"),
    ("ICD10", "Z54.7", "Z54.7 Convalescence following combined treatment", "AfjGRRbFxmn"),
    ("ICD10", "Z54.8", "Z54.8 Convalescence following other treatment", "DKkqW5rsrwB"),
    ("ICD10", "Z54.9", "Z54.9 Convalescence following unspecified treatment", "SCDNvtJ81df"),
    ("ICD10", "Z55", "Z55 Problems related to education and literacy", "OjTpB8I8NEG"),
    ("ICD10", "Z55.0", "Z55.0 Illiteracy and low-level literacy", "rE7fb6PuAHz"),
    ("ICD10", "Z55.1", "Z55.1 Schooling unavailable and unattainable", "MDebYEwSrmI"),
    ("ICD10", "Z55.2", "Z55.2 Failed examinations", "qusHcPdbjJP"),
    ("ICD10", "Z55.3", "Z55.3 Underachievement in school", "mwPVMi7wT6Q"),
    ("ICD10", "Z55.4", "Z55.4 Educational maladjustment and discord with teachers and classmates", "kesxt5vRptc"),
    ("ICD10", "Z55.8", "Z55.8 Other problems related to education and literacy", "kkC6agFcQhB"),
    ("ICD10", "Z55.9", "Z55.9 Problem related to education and literacy, unspecified", "tXaB1gKRxMH"),
    ("ICD10", "Z56", "Z56 Problems related to employment and unemployment", "mGtg0ivtBWh"),
    ("ICD10", "Z56.0", "Z56.0 Unemployment, unspecified", "vr1S4kWbJq2"),
    ("ICD10", "Z56.1", "Z56.1 Change of job", "xwEKbYrHIwc"),
    ("ICD10", "Z56.2", "Z56.2 Threat of job loss", "gkcfz4eOJib"),
    ("ICD10", "Z56.3", "Z56.3 Stressful work schedule", "PLEleLuiRkY"),
    ("ICD10", "Z56.4", "Z56.4 Discord with boss and workmates", "iKZ6EZdDb14"),
    ("ICD10", "Z56.5", "Z56.5 Uncongenial work", "A07tMBu70Zv"),
    ("ICD10", "Z56.6", "Z56.6 Other physical and mental strain related to work", "SWKZffwT5EZ"),
    ("ICD10", "Z56.7", "Z56.7 Other and unspecified problems related to employment", "wbyuyvGg3eq"),
    ("ICD10", "Z57", "Z57 Occupational exposure to risk-factors", "CRDTZId9ueb"),
    ("ICD10", "Z57.0", "Z57.0 Occupational exposure to noise", "k261rdEN9sH"),
    ("ICD10", "Z57.1", "Z57.1 Occupational exposure to radiation", "OlTsoIHL4Tl"),
    ("ICD10", "Z57.2", "Z57.2 Occupational exposure to dust", "PshLJyt22EL"),
    ("ICD10", "Z57.3", "Z57.3 Occupational exposure to other air contaminants", "cYOHP0pWyfr"),
    ("ICD10", "Z57.4", "Z57.4 Occupational exposure to toxic agents in agriculture", "Qm8yMlkHB0D"),
    ("ICD10", "Z57.5", "Z57.5 Occupational exposure to toxic agents in other industries", "CdGuHcgMJP5"),
    ("ICD10", "Z57.6", "Z57.6 Occupational exposure to extreme temperature", "cdAVOZLOUtE"),
    ("ICD10", "Z57.7", "Z57.7 Occupational exposure to vibration", "rLbaIiZyHRT"),
    ("ICD10", "Z57.8", "Z57.8 Occupational exposure to other risk-factors", "T8CawIphZWc"),
    ("ICD10", "Z57.9", "Z57.9 Occupational exposure to unspecified risk-factor", "kQwFRNpAsP1"),
    ("ICD10", "Z58", "Z58 Problems related to physical environment", "qhlJXSL55nu"),
    ("ICD10", "Z58.0", "Z58.0 Exposure to noise", "SH4R1SmA01U"),
    ("ICD10", "Z58.1", "Z58.1 Exposure to air pollution", "U234tXRv0El"),
    ("ICD10", "Z58.2", "Z58.2 Exposure to water pollution", "IJbwoJzL3W1"),
    ("ICD10", "Z58.3", "Z58.3 Exposure to soil pollution", "sO06VZJB9Im"),
    ("ICD10", "Z58.4", "Z58.4 Exposure to radiation", "rb8YZK6vnwP"),
    ("ICD10", "Z58.5", "Z58.5 Exposure to other pollution", "zVQutJNapLi"),
    ("ICD10", "Z58.6", "Z58.6 Inadequate drinking-water supply", "DdGManK6gd8"),
    ("ICD10", "Z58.7", "Z58.7 Exposure to tobacco smoke", "SGikV0dHASy"),
    ("ICD10", "Z58.8", "Z58.8 Other problems related to physical environment", "Br2dyStTVyY"),
    ("ICD10", "Z58.9", "Z58.9 Problem related to physical environment, unspecified", "EMLChPSTvBB"),
    ("ICD10", "Z59", "Z59 Problems related to housing and economic circumstances", "SJAdNNOA4EK"),
    ("ICD10", "Z59.0", "Z59.0 Homelessness", "IfQLWwuqLoi"),
    ("ICD10", "Z59.1", "Z59.1 Inadequate housing", "cMxbvEfZzfd"),
    ("ICD10", "Z59.2", "Z59.2 Discord with neighbours, lodgers and landlord", "JS4y0P90OSl"),
    ("ICD10", "Z59.3", "Z59.3 Problems related to living in residential institution", "eNwljrgtAS4"),
    ("ICD10", "Z59.4", "Z59.4 Lack of adequate food", "PYjtRPGEodi"),
    ("ICD10", "Z59.5", "Z59.5 Extreme poverty", "vfPub27bDg0"),
    ("ICD10", "Z59.6", "Z59.6 Low income", "Dzujho0XTLA"),
    ("ICD10", "Z59.7", "Z59.7 Insufficient social insurance and welfare support", "Dya2FLBDWlG"),
    ("ICD10", "Z59.8", "Z59.8 Other problems related to housing and economic circumstances", "bO4TpcO2CuY"),
    ("ICD10", "Z59.9", "Z59.9 Problem related to housing and economic circumstances, unspecified", "jfNd1KFdeVl"),
    ("ICD10", "Z60", "Z60 Problems related to social environment", "gjXdoYz1ZuW"),
    ("ICD10", "Z60.0", "Z60.0 Problems of adjustment to life-cycle transitions", "TNoSEcumZQp"),
    ("ICD10", "Z60.1", "Z60.1 Atypical parenting situation", "aXtTGAUD4Ex"),
    ("ICD10", "Z60.2", "Z60.2 Living alone", "JTWfgabgHoq"),
    ("ICD10", "Z60.3", "Z60.3 Acculturation difficulty", "nT5epvDTdqq"),
    ("ICD10", "Z60.4", "Z60.4 Social exclusion and rejection", "jcyZOsHdCed"),
    ("ICD10", "Z60.5", "Z60.5 Target of perceived adverse discrimination and persecution", "WBXMqje1tFO"),
    ("ICD10", "Z60.8", "Z60.8 Other problems related to social environment", "NY1yoX64Ezb"),
    ("ICD10", "Z60.9", "Z60.9 Problem related to social environment, unspecified", "QW3FpiOXNzd"),
    ("ICD10", "Z61", "Z61 Problems related to negative life events in childhood", "GO4RyYOexu7"),
    ("ICD10", "Z61.0", "Z61.0 Loss of love relationship in childhood", "GaptvVIVpYn"),
    ("ICD10", "Z61.1", "Z61.1 Removal from home in childhood", "sVCZWePl5vk"),
    ("ICD10", "Z61.2", "Z61.2 Altered pattern of family relationships in childhood", "vYaDhQQx8Tn"),
    ("ICD10", "Z61.3", "Z61.3 Events resulting in loss of self-esteem in childhood", "OJ7peTa5CbN"),
    ("ICD10", "Z61.4", "Z61.4 Problems related to alleged sexual abuse of child by person within primary support group", "RKh1mYtMfBN"),
    ("ICD10", "Z61.5", "Z61.5 Problems related to alleged sexual abuse of child by person outside primary support group", "TfCccetfFkP"),
    ("ICD10", "Z61.6", "Z61.6 Problems related to alleged physical abuse of child", "CE7keb7t4Jp"),
    ("ICD10", "Z61.7", "Z61.7 Personal frightening experience in childhood", "qAvZXp2tXmT"),
    ("ICD10", "Z61.8", "Z61.8 Other negative life events in childhood", "rXHmIh9HFiY"),
    ("ICD10", "Z61.9", "Z61.9 Negative life event in childhood, unspecified", "BFpwf2D7sxk"),
    ("ICD10", "Z62", "Z62 Other problems related to upbringing", "ZmMFQLysaAm"),
    ("ICD10", "Z62.0", "Z62.0 Inadequate parental supervision and control", "I5lzUAFhGUJ"),
    ("ICD10", "Z62.1", "Z62.1 Parental overprotection", "jOVTZ9xvdUH"),
    ("ICD10", "Z62.2", "Z62.2 Institutional upbringing", "IonwYXC0cZ7"),
    ("ICD10", "Z62.3", "Z62.3 Hostility towards and scapegoating of child", "mylQWaF5vGh"),
    ("ICD10", "Z62.4", "Z62.4 Emotional neglect of child", "uz35T57c1BC"),
    ("ICD10", "Z62.5", "Z62.5 Other problems related to neglect in upbringing", "ybC4CwJLKd0"),
    ("ICD10", "Z62.6", "Z62.6 Inappropriate parental pressure and other abnormal qualities of upbringing", "uScjlZ2UPOT"),
    ("ICD10", "Z62.8", "Z62.8 Other specified problems related to upbringing", "k6m0emzqx7E"),
    ("ICD10", "Z62.9", "Z62.9 Problem related to upbringing, unspecified", "pvVRn9FzccR"),
    ("ICD10", "Z63", "Z63 Other problems related to primary support group, including family circumstances", "z9IWKvjKBPY"),
    ("ICD10", "Z63.0", "Z63.0 Problems in relationship with spouse or partner", "ylX9PaNy3Cd"),
    ("ICD10", "Z63.1", "Z63.1 Problems in relationship with parents and in-laws", "Fdj6Uxj8SXg"),
    ("ICD10", "Z63.2", "Z63.2 Inadequate family support", "n1nLhNL33sh"),
    ("ICD10", "Z63.3", "Z63.3 Absence of family member", "YRndAXsENPx"),
    ("ICD10", "Z63.4", "Z63.4 Disappearance and death of family member", "CeZo6QEIxU2"),
    ("ICD10", "Z63.5", "Z63.5 Disruption of family by separation and divorce", "dUtWHH7rIzQ"),
    ("ICD10", "Z63.6", "Z63.6 Dependent relative needing care at home", "l3vRqh5oxsf"),
    ("ICD10", "Z63.7", "Z63.7 Other stressful life events affecting family and household", "eh3blPJr10W"),
    ("ICD10", "Z63.8", "Z63.8 Other specified problems related to primary support group", "xyA3SP5T0Ab"),
    ("ICD10", "Z63.9", "Z63.9 Problem related to primary support group, unspecified", "Oekh6KkTb3V"),
    ("ICD10", "Z64", "Z64 Problems related to certain psychosocial circumstances", "MIGZDJiZRy8"),
    ("ICD10", "Z64.0", "Z64.0 Problems related to unwanted pregnancy", "Q6w9Gew4Xcq");

INSERT INTO COD_Codes_DHIS
  (codSource, codCode, codName, codID)
  VALUES
    ("ICD10", "Z64.1", "Z64.1 Problems related to multiparity", "W11qeSQuDXH"),
    ("ICD10", "Z64.2", "Z64.2 Seeking and accepting physical, nutritional and chemical interventions known to be hazardous and harmful", "Mme3889WyWF"),
    ("ICD10", "Z64.3", "Z64.3 Seeking and accepting behavioural and psychological interventions known to be hazardous and harmful", "CAxgEkzRxvY"),
    ("ICD10", "Z64.4", "Z64.4 Discord with counsellors", "dOOPuWbqDRy"),
    ("ICD10", "Z65", "Z65 Problems related to other psychosocial circumstances", "snNsMZL57jZ"),
    ("ICD10", "Z65.0", "Z65.0 Conviction in civil and criminal proceedings without imprisonment", "PaETLIKpSs5"),
    ("ICD10", "Z65.1", "Z65.1 Imprisonment and other incarceration", "mf8ayZ0JtK5"),
    ("ICD10", "Z65.2", "Z65.2 Problems related to release from prison", "ugqmh22BTYn"),
    ("ICD10", "Z65.3", "Z65.3 Problems related to other legal circumstances", "D7RaqkAR9nn"),
    ("ICD10", "Z65.4", "Z65.4 Victim of crime and terrorism", "ujmr8Rf32AI"),
    ("ICD10", "Z65.5", "Z65.5 Exposure to disaster, war and other hostilities", "hJOScVdyS9m"),
    ("ICD10", "Z65.8", "Z65.8 Other specified problems related to psychosocial circumstances", "bKX5w9GK7Z0"),
    ("ICD10", "Z65.9", "Z65.9 Problem related to unspecified psychosocial circumstances", "TSiKNIjxLkv"),
    ("ICD10", "Z70", "Z70 Counselling related to sexual attitude, behaviour and orientation", "h8SPJF3iTSN"),
    ("ICD10", "Z70.0", "Z70.0 Counselling related to sexual attitude", "H0XGD4Z0g1o"),
    ("ICD10", "Z70.1", "Z70.1 Counselling related to patient's sexual behaviour and orientation", "bsknFPKQWkn"),
    ("ICD10", "Z70.2", "Z70.2 Counselling related to sexual behaviour and orientation of third party", "de4FhWUD6Ek"),
    ("ICD10", "Z70.3", "Z70.3 Counselling related to combined concerns regarding sexual attitude, behaviour and orientation", "u1agmZrvEtc"),
    ("ICD10", "Z70.8", "Z70.8 Other sex counselling", "RzDgwvUnMW4"),
    ("ICD10", "Z70.9", "Z70.9 Sex counselling, unspecified", "tmPMk19Wa6P"),
    ("ICD10", "Z71", "Z71 Persons encountering health services for other counselling and medical advice, not elsewhere classified", "MtuE0stowY6"),
    ("ICD10", "Z71.0", "Z71.0 Person consulting on behalf of another person", "hocZSN082vW"),
    ("ICD10", "Z71.1", "Z71.1 Person with feared complaint in whom no diagnosis is made", "eMJSjsGLM83"),
    ("ICD10", "Z71.2", "Z71.2 Person consulting for explanation of investigation findings", "LVmShQWFh9t"),
    ("ICD10", "Z71.3", "Z71.3 Dietary counselling and surveillance", "TzCiOcscjgr"),
    ("ICD10", "Z71.4", "Z71.4 Alcohol abuse counselling and surveillance", "Sru73vLpg1S"),
    ("ICD10", "Z71.5", "Z71.5 Drug abuse counselling and surveillance", "T2JtjQ28ouR"),
    ("ICD10", "Z71.6", "Z71.6 Tobacco abuse counselling", "t8GE7f8duOW"),
    ("ICD10", "Z71.7", "Z71.7 Human immunodeficiency virus [HIV] counselling", "xAtUOI6baaX"),
    ("ICD10", "Z71.8", "Z71.8 Other specified counselling", "yi7kenEV0Qh"),
    ("ICD10", "Z71.9", "Z71.9 Counselling, unspecified", "tkWEuAmlejX"),
    ("ICD10", "Z72", "Z72 Problems related to lifestyle", "xXQI7NxQkUx"),
    ("ICD10", "Z72.0", "Z72.0 Tobacco use", "yLdK2pTEDZK"),
    ("ICD10", "Z72.1", "Z72.1 Alcohol use", "eEdLDHwFf1y"),
    ("ICD10", "Z72.2", "Z72.2 Drug use", "PK6OLldUCzI"),
    ("ICD10", "Z72.3", "Z72.3 Lack of physical exercise", "SGACI0g8F42"),
    ("ICD10", "Z72.4", "Z72.4 Inappropriate diet and eating habits", "XIeyZ0bbhAZ"),
    ("ICD10", "Z72.5", "Z72.5 High-risk sexual behaviour", "cRrz90gwpmQ"),
    ("ICD10", "Z72.6", "Z72.6 Gambling and betting", "KF043jfwwdX"),
    ("ICD10", "Z72.8", "Z72.8 Other problems related to lifestyle", "b93HWWtiRvY"),
    ("ICD10", "Z72.9", "Z72.9 Problem related to lifestyle, unspecified", "bVP41UNkoBS"),
    ("ICD10", "Z73", "Z73 Problems related to life-management difficulty", "BlIGI6AoYke"),
    ("ICD10", "Z73.0", "Z73.0 Burn-out", "Oj2LWHElR4V"),
    ("ICD10", "Z73.1", "Z73.1 Accentuation of personality traits", "O02m5dn8Zba"),
    ("ICD10", "Z73.2", "Z73.2 Lack of relaxation and leisure", "jjBniYhKpbk"),
    ("ICD10", "Z73.3", "Z73.3 Stress, not elsewhere classified", "aackFQ1Cqkf"),
    ("ICD10", "Z73.4", "Z73.4 Inadequate social skills, not elsewhere classified", "ZwogtlgxZvw"),
    ("ICD10", "Z73.5", "Z73.5 Social role conflict, not elsewhere classified", "X24ViDAUH4z"),
    ("ICD10", "Z73.6", "Z73.6 Limitation of activities due to disability", "Q3NVPRM0i2R"),
    ("ICD10", "Z73.8", "Z73.8 Other problems related to life-management difficulty", "R9p3nwFn4t2"),
    ("ICD10", "Z73.9", "Z73.9 Problem related to life-management difficulty, unspecified", "nD57tBPPWrP"),
    ("ICD10", "Z74", "Z74 Problems related to care-provider dependency", "LcOaVsxrx0k"),
    ("ICD10", "Z74.0", "Z74.0 Need for assistance due to reduced mobility", "ea6Sa77bVjg"),
    ("ICD10", "Z74.1", "Z74.1 Need for assistance with personal care", "vcmpo92INTQ"),
    ("ICD10", "Z74.2", "Z74.2 Need for assistance at home and no other household member able to render care", "n2sCE4oPpG9"),
    ("ICD10", "Z74.3", "Z74.3 Need for continuous supervision", "HIOKkJ4b6Wa"),
    ("ICD10", "Z74.8", "Z74.8 Other problems related to care-provider dependency", "rL9ogswalIl"),
    ("ICD10", "Z74.9", "Z74.9 Problem related to care-provider dependency, unspecified", "TrAJc3FLYom"),
    ("ICD10", "Z75", "Z75 Problems related to medical facilities and other health care", "ryl7S6XRQ2c"),
    ("ICD10", "Z75.0", "Z75.0 Medical services not available in home", "aSyt3EvaKW9"),
    ("ICD10", "Z75.1", "Z75.1 Person awaiting admission to adequate facility elsewhere", "TS5GaMWAjL2"),
    ("ICD10", "Z75.2", "Z75.2 Other waiting period for investigation and treatment", "nZlWcwJJlT4"),
    ("ICD10", "Z75.3", "Z75.3 Unavailability and inaccessibility of health-care facilities", "StRs5EwTm1e"),
    ("ICD10", "Z75.4", "Z75.4 Unavailability and inaccessibility of other helping agencies", "OzlhhUOnhrB"),
    ("ICD10", "Z75.5", "Z75.5 Holiday relief care", "EYsm5rO08gv"),
    ("ICD10", "Z75.8", "Z75.8 Other problems related to medical facilities and other health care", "R9oRLkgdfqa"),
    ("ICD10", "Z75.9", "Z75.9 Unspecified problem related to medical facilities and other health care", "BoXA0OV8Ivn"),
    ("ICD10", "Z76", "Z76 Persons encountering health services in other circumstances", "P10YCQ4I3Dl"),
    ("ICD10", "Z76.0", "Z76.0 Issue of repeat prescription", "sSD3RXayGpV"),
    ("ICD10", "Z76.1", "Z76.1 Health supervision and care of foundling", "HM4yDX84yao"),
    ("ICD10", "Z76.2", "Z76.2 Health supervision and care of other healthy infant and child", "mjdiazAzm4O"),
    ("ICD10", "Z76.3", "Z76.3 Healthy person accompanying sick person", "irIovdMbx7W"),
    ("ICD10", "Z76.4", "Z76.4 Other boarder in health-care facility", "TgIdWkX5JaB"),
    ("ICD10", "Z76.5", "Z76.5 Malingerer [conscious simulation]", "gJsrvRgRJNI"),
    ("ICD10", "Z76.8", "Z76.8 Persons encountering health services in other specified circumstances", "uJkILsVouNC"),
    ("ICD10", "Z76.9", "Z76.9 Person encountering health services in unspecified circumstances", "TbtVOMXjq8D"),
    ("ICD10", "Z80", "Z80 Family history of malignant neoplasm", "OS8PjA4pRAJ"),
    ("ICD10", "Z80.0", "Z80.0 Family history of malignant neoplasm of digestive organs", "Ds1WMQVJgDw"),
    ("ICD10", "Z80.1", "Z80.1 Family history of malignant neoplasm of trachea, bronchus and lung", "HmETp4Wjd9t"),
    ("ICD10", "Z80.2", "Z80.2 Family history of malignant neoplasm of other respiratory and intrathoracic organs", "hCnY48LagxZ"),
    ("ICD10", "Z80.3", "Z80.3 Family history of malignant neoplasm of breast", "FwKFNgYJf2q"),
    ("ICD10", "Z80.4", "Z80.4 Family history of malignant neoplasm of genital organs", "Id7oCp9xNCz"),
    ("ICD10", "Z80.5", "Z80.5 Family history of malignant neoplasm of urinary tract", "uFWdxKb7Zpd"),
    ("ICD10", "Z80.6", "Z80.6 Family history of leukaemia", "OILpXTBO0PU"),
    ("ICD10", "Z80.7", "Z80.7 Family history of other malignant neoplasms of lymphoid, haematopoietic and related tissues", "qvXluvgFhLA"),
    ("ICD10", "Z80.8", "Z80.8 Family history of malignant neoplasm of other organs or systems", "s6Qlh8E0YfD"),
    ("ICD10", "Z80.9", "Z80.9 Family history of malignant neoplasm, unspecified", "B4U3eIQj5ig"),
    ("ICD10", "Z81", "Z81 Family history of mental and behavioural disorders", "lu8lb0crORL"),
    ("ICD10", "Z81.0", "Z81.0 Family history of mental retardation", "zGjmCYDOfgi"),
    ("ICD10", "Z81.1", "Z81.1 Family history of alcohol abuse", "MIHNkQ8UWJr"),
    ("ICD10", "Z81.2", "Z81.2 Family history of tobacco abuse", "Quh0xjcrMlD"),
    ("ICD10", "Z81.3", "Z81.3 Family history of other psychoactive substance abuse", "crEI2yB0YYy"),
    ("ICD10", "Z81.4", "Z81.4 Family history of other substance abuse", "taJRpRlMOmD"),
    ("ICD10", "Z81.8", "Z81.8 Family history of other mental and behavioural disorders", "hXnQp9QOe9M"),
    ("ICD10", "Z82", "Z82 Family history of certain disabilities and chronic diseases leading to disablement", "fRJJPmKzbqX"),
    ("ICD10", "Z82.0", "Z82.0 Family history of epilepsy and other diseases of the nervous system", "i9y4z8VZnLb"),
    ("ICD10", "Z82.1", "Z82.1 Family history of blindness and visual loss", "gTkbPd2DpSB"),
    ("ICD10", "Z82.2", "Z82.2 Family history of deafness and hearing loss", "nzMzt1etxbG"),
    ("ICD10", "Z82.3", "Z82.3 Family history of stroke", "MYs8MdAGUhf"),
    ("ICD10", "Z82.4", "Z82.4 Family history of ischaemic heart disease and other diseases of the circulatory system", "J41KX9cHlST"),
    ("ICD10", "Z82.5", "Z82.5 Family history of asthma and other chronic lower respiratory diseases", "Xsxq40YvTBN"),
    ("ICD10", "Z82.6", "Z82.6 Family history of arthritis and other diseases of the musculoskeletal system and connective tissue", "VmbeywGGZcA"),
    ("ICD10", "Z82.7", "Z82.7 Family history of congenital malformations, deformations and chromosomal abnormalities", "mL2NvNes7pN"),
    ("ICD10", "Z82.8", "Z82.8 Family history of other disabilities and chronic diseases leading to disablement, not elsewhere classified", "PG8w8Jf8wcm"),
    ("ICD10", "Z83", "Z83 Family history of other specific disorders", "oKLBxESBK3d"),
    ("ICD10", "Z83.0", "Z83.0 Family history of human immunodeficiency virus [HIV] disease", "vUM9lapWvsK"),
    ("ICD10", "Z83.1", "Z83.1 Family history of other infectious and parasitic diseases", "tiII1fgXSNs"),
    ("ICD10", "Z83.2", "Z83.2 Family history of diseases of the blood and blood-forming organs and certain disorders involving the immune mechanism", "iFp3Sy2NqRT"),
    ("ICD10", "Z83.3", "Z83.3 Family history of diabetes mellitus", "xwhtOvy3bTu"),
    ("ICD10", "Z83.4", "Z83.4 Family history of other endocrine, nutritional and metabolic diseases", "mrFYmw2ZLiH"),
    ("ICD10", "Z83.5", "Z83.5 Family history of eye and ear disorders", "BFTqsGV9SYi"),
    ("ICD10", "Z83.6", "Z83.6 Family history of diseases of the respiratory system", "cDbpbgYuRpA"),
    ("ICD10", "Z83.7", "Z83.7 Family history of diseases of the digestive system", "skWYuBHs3YJ"),
    ("ICD10", "Z84", "Z84 Family history of other conditions", "mlsslSGPTsT"),
    ("ICD10", "Z84.0", "Z84.0 Family history of diseases of the skin and subcutaneous tissue", "mGbrItv1AXR"),
    ("ICD10", "Z84.1", "Z84.1 Family history of disorders of kidney and ureter", "IzvTIo5DGFx"),
    ("ICD10", "Z84.2", "Z84.2 Family history of other diseases of the genitourinary system", "PMJAUbjNred"),
    ("ICD10", "Z84.3", "Z84.3 Family history of consanguinity", "XLpCmu3KEox"),
    ("ICD10", "Z84.8", "Z84.8 Family history of other specified conditions", "lGECgwfiud3"),
    ("ICD10", "Z85", "Z85 Personal history of malignant neoplasm", "p132CJuXUMc"),
    ("ICD10", "Z85.0", "Z85.0 Personal history of malignant neoplasm of digestive organs", "rjfIhdoBcxl"),
    ("ICD10", "Z85.1", "Z85.1 Personal history of malignant neoplasm of trachea, bronchus and lung", "GhantNOObOm"),
    ("ICD10", "Z85.2", "Z85.2 Personal history of malignant neoplasm of other respiratory and intrathoracic organs", "oLNntoI8Wno"),
    ("ICD10", "Z85.3", "Z85.3 Personal history of malignant neoplasm of breast", "Pfb9nvftCbx"),
    ("ICD10", "Z85.4", "Z85.4 Personal history of malignant neoplasm of genital organs", "LRm9yvhAT7v"),
    ("ICD10", "Z85.5", "Z85.5 Personal history of malignant neoplasm of urinary tract", "kodpGpDFJWt"),
    ("ICD10", "Z85.6", "Z85.6 Personal history of leukaemia", "tT6G2f9V5d9"),
    ("ICD10", "Z85.7", "Z85.7 Personal history of other malignant neoplasms of lymphoid, haematopoietic and related tissues", "U7FnL7FfziR"),
    ("ICD10", "Z85.8", "Z85.8 Personal history of malignant neoplasms of other organs and systems", "aAyW2Llql7P"),
    ("ICD10", "Z85.9", "Z85.9 Personal history of malignant neoplasm, unspecified", "DlulKbrLU8w"),
    ("ICD10", "Z86", "Z86 Personal history of certain other diseases", "TSFklQJCRMS"),
    ("ICD10", "Z86.0", "Z86.0 Personal history of other neoplasms", "qSwTZn1hWdX"),
    ("ICD10", "Z86.1", "Z86.1 Personal history of infectious and parasitic diseases", "XirGuJAm3T5"),
    ("ICD10", "Z86.2", "Z86.2 Personal history of diseases of the blood and blood-forming organs and certain disorders involving the immune mechanism", "UMfM2U8OnAW"),
    ("ICD10", "Z86.3", "Z86.3 Personal history of endocrine, nutritional and metabolic diseases", "GJRJZgpreJj"),
    ("ICD10", "Z86.4", "Z86.4 Personal history of psychoactive substance abuse", "eA3SvbEvwTX"),
    ("ICD10", "Z86.5", "Z86.5 Personal history of other mental and behavioural disorders", "RljEoNV5MNf"),
    ("ICD10", "Z86.6", "Z86.6 Personal history of diseases of the nervous system and sense organs", "ZxEo9puU19c"),
    ("ICD10", "Z86.7", "Z86.7 Personal history of diseases of the circulatory system", "eAwus9c5rbo"),
    ("ICD10", "Z87", "Z87 Personal history of other diseases and conditions", "jZNajHnaSEl"),
    ("ICD10", "Z87.0", "Z87.0 Personal history of diseases of the respiratory system", "S0ZAAegOtHw"),
    ("ICD10", "Z87.1", "Z87.1 Personal history of diseases of the digestive system", "lcMjc7IhMlx"),
    ("ICD10", "Z87.2", "Z87.2 Personal history of diseases of the skin and subcutaneous tissue", "np7jxh8CKJh"),
    ("ICD10", "Z87.3", "Z87.3 Personal history of diseases of the musculoskeletal system and connective tissue", "f8T4rHm3x1s"),
    ("ICD10", "Z87.4", "Z87.4 Personal history of diseases of the genitourinary system", "B6rhuwwomeE"),
    ("ICD10", "Z87.5", "Z87.5 Personal history of complications of pregnancy, childbirth and the puerperium", "sztRv8tfO8R"),
    ("ICD10", "Z87.6", "Z87.6 Personal history of certain conditions arising in the perinatal period", "SNjYPcWMwQR"),
    ("ICD10", "Z87.7", "Z87.7 Personal history of congenital malformations, deformations and chromosomal abnormalities", "a3eQchYlu0t"),
    ("ICD10", "Z87.8", "Z87.8 Personal history of other specified conditions", "vlPCCETLGAI"),
    ("ICD10", "Z88", "Z88 Personal history of allergy to drugs, medicaments and biological substances", "lY9UX2nyoQQ"),
    ("ICD10", "Z88.0", "Z88.0 Personal history of allergy to penicillin", "CiF6lWlYq1u"),
    ("ICD10", "Z88.1", "Z88.1 Personal history of allergy to other antibiotic agents", "uhTspxf7Jhc"),
    ("ICD10", "Z88.2", "Z88.2 Personal history of allergy to sulfonamides", "DVb0SrNRj6j"),
    ("ICD10", "Z88.3", "Z88.3 Personal history of allergy to other anti-infective agents", "FQJ06wPcNMV"),
    ("ICD10", "Z88.4", "Z88.4 Personal history of allergy to anaesthetic agent", "fDBbqbnshUb"),
    ("ICD10", "Z88.5", "Z88.5 Personal history of allergy to narcotic agent", "aCTLSz89Y6X"),
    ("ICD10", "Z88.6", "Z88.6 Personal history of allergy to analgesic agent", "sk2MXOmJhLm"),
    ("ICD10", "Z88.7", "Z88.7 Personal history of allergy to serum and vaccine", "TAdG2sTHUKE"),
    ("ICD10", "Z88.8", "Z88.8 Personal history of allergy to other drugs, medicaments and biological substances", "mgCv2FjtcaD"),
    ("ICD10", "Z88.9", "Z88.9 Personal history of allergy to unspecified drugs, medicaments and biological substances", "nOIuBkwnPwZ"),
    ("ICD10", "Z89", "Z89 Acquired absence of limb", "UbgrsnoLNI1"),
    ("ICD10", "Z89.0", "Z89.0 Acquired absence of finger(s) [including thumb], unilateral", "J0b1kBXpUxX"),
    ("ICD10", "Z89.1", "Z89.1 Acquired absence of hand and wrist", "UV9rOGxvZGF"),
    ("ICD10", "Z89.2", "Z89.2 Acquired absence of upper limb above wrist", "lhWQnUVfUwn"),
    ("ICD10", "Z89.3", "Z89.3 Acquired absence of both upper limbs [any level]", "FrTxfpxWJ6M"),
    ("ICD10", "Z89.4", "Z89.4 Acquired absence of foot and ankle", "oWO4C05NASW"),
    ("ICD10", "Z89.5", "Z89.5 Acquired absence of leg at or below knee", "nHNM8gjiWax"),
    ("ICD10", "Z89.6", "Z89.6 Acquired absence of leg above knee", "IJr8Bkf3Dtx"),
    ("ICD10", "Z89.7", "Z89.7 Acquired absence of both lower limbs [any level, except toes alone]", "aaqEJB7Ftb9"),
    ("ICD10", "Z89.8", "Z89.8 Acquired absence of upper and lower limbs [any level]", "fKPWOCsVpio"),
    ("ICD10", "Z89.9", "Z89.9 Acquired absence of limb, unspecified", "VQVdSeO7u2a"),
    ("ICD10", "Z90", "Z90 Acquired absence of organs, not elsewhere classified", "r465JkxlCHy"),
    ("ICD10", "Z90.0", "Z90.0 Acquired absence of part of head and neck", "jbjXM0s9EYw"),
    ("ICD10", "Z90.1", "Z90.1 Acquired absence of breast(s)", "iZqz2lVDTxI"),
    ("ICD10", "Z90.2", "Z90.2 Acquired absence of lung [part of]", "yojDs3acSCS"),
    ("ICD10", "Z90.3", "Z90.3 Acquired absence of part of stomach", "kU06Ikj1qdR"),
    ("ICD10", "Z90.4", "Z90.4 Acquired absence of other parts of digestive tract", "oJDCb8yR1uI"),
    ("ICD10", "Z90.5", "Z90.5 Acquired absence of kidney", "gmbOS6xYDVf"),
    ("ICD10", "Z90.6", "Z90.6 Acquired absence of other organs of urinary tract", "Oi5HYz1KBGt"),
    ("ICD10", "Z90.7", "Z90.7 Acquired absence of genital organ(s)", "SmFk4YtfnYs"),
    ("ICD10", "Z90.8", "Z90.8 Acquired absence of other organs", "olmqfHc628m"),
    ("ICD10", "Z91", "Z91 Personal history of risk-factors, not elsewhere classified", "gvmR0yIFSqA"),
    ("ICD10", "Z91.0", "Z91.0 Personal history of allergy, other than to drugs and biological substances", "Qk016Zlq1aF"),
    ("ICD10", "Z91.1", "Z91.1 Personal history of noncompliance with medical treatment and regimen", "dsisH8Tg73L"),
    ("ICD10", "Z91.2", "Z91.2 Personal history of poor personal hygiene", "iQw2GlVY9oN"),
    ("ICD10", "Z91.3", "Z91.3 Personal history of unhealthy sleep-wake schedule", "kkM6ZmI4dPo"),
    ("ICD10", "Z91.4", "Z91.4 Personal history of psychological trauma, not elsewhere classified", "y6lLxvGm392"),
    ("ICD10", "Z91.5", "Z91.5 Personal history of self-harm", "VQxPXKy59dr"),
    ("ICD10", "Z91.6", "Z91.6 Personal history of other physical trauma", "nRS4jCA8ICB"),
    ("ICD10", "Z91.7", "Z91.7 Personal history of female genital mutilation", "vTvPgDOkLki"),
    ("ICD10", "Z91.8", "Z91.8 Personal history of other specified risk-factors, not elsewhere classified", "m404qdbOgoT"),
    ("ICD10", "Z92", "Z92 Personal history of medical treatment", "rrUTDSguCIc"),
    ("ICD10", "Z92.0", "Z92.0 Personal history of contraception", "EWxbGqnrOm4"),
    ("ICD10", "Z92.1", "Z92.1 Personal history of long-term (current) use of anticoagulants", "VkllG1b0p0t"),
    ("ICD10", "Z92.2", "Z92.2 Personal history of long-term (current) use of other medicaments", "pcb0Quzudbl"),
    ("ICD10", "Z92.3", "Z92.3 Personal history of irradiation", "mHXDFvCoNCc"),
    ("ICD10", "Z92.4", "Z92.4 Personal history of major surgery, not elsewhere classified", "tMLGgZmjMrp"),
    ("ICD10", "Z92.5", "Z92.5 Personal history of rehabilitation measures", "XcqhUQTOhb1"),
    ("ICD10", "Z92.6", "Z92.6 Personal history of chemotherapy for neoplastic disease", "R4GhhICIMDv"),
    ("ICD10", "Z92.8", "Z92.8 Personal history of other medical treatment", "NUJ6FcBxaS8"),
    ("ICD10", "Z92.9", "Z92.9 Personal history of medical treatment, unspecified", "tCyrvmZz61G"),
    ("ICD10", "Z93", "Z93 Artificial opening status", "Wjhx5Hx9jLr"),
    ("ICD10", "Z93.0", "Z93.0 Tracheostomy status", "m5tAV9Xm49m"),
    ("ICD10", "Z93.1", "Z93.1 Gastrostomy status", "yglIQsmM80W"),
    ("ICD10", "Z93.2", "Z93.2 Ileostomy status", "JConz7MZzK4"),
    ("ICD10", "Z93.3", "Z93.3 Colostomy status", "TWNRPg5pXHf"),
    ("ICD10", "Z93.4", "Z93.4 Other artificial openings of gastrointestinal tract status", "lnjtS9udiTb"),
    ("ICD10", "Z93.5", "Z93.5 Cystostomy status", "q9DysExu0WK"),
    ("ICD10", "Z93.6", "Z93.6 Other artificial openings of urinary tract status", "XQMZARNIeNQ"),
    ("ICD10", "Z93.8", "Z93.8 Other artificial opening status", "ggY6ctIOzH4"),
    ("ICD10", "Z93.9", "Z93.9 Artificial opening status, unspecified", "xvIgUlV9vIK"),
    ("ICD10", "Z94", "Z94 Transplanted organ and tissue status", "MXPoP9DwibR"),
    ("ICD10", "Z94.0", "Z94.0 Kidney transplant status", "UvHQrnp4cWY"),
    ("ICD10", "Z94.1", "Z94.1 Heart transplant status", "pSNzQF4i1iM"),
    ("ICD10", "Z94.2", "Z94.2 Lung transplant status", "nulTo3ZLCQe"),
    ("ICD10", "Z94.3", "Z94.3 Heart and lungs transplant status", "iCYQOAHQcvj"),
    ("ICD10", "Z94.4", "Z94.4 Liver transplant status", "DsxD9QLkkeK"),
    ("ICD10", "Z94.5", "Z94.5 Skin transplant status", "JrmtYTtAC3W"),
    ("ICD10", "Z94.6", "Z94.6 Bone transplant status", "urwjnDpzsj1"),
    ("ICD10", "Z94.7", "Z94.7 Corneal transplant status", "eyhPyHy53DG"),
    ("ICD10", "Z94.8", "Z94.8 Other transplanted organ and tissue status", "dVtJHymaUhh"),
    ("ICD10", "Z94.9", "Z94.9 Transplanted organ and tissue status, unspecified", "Xe7iEIn3U2Y"),
    ("ICD10", "Z95", "Z95 Presence of cardiac and vascular implants and grafts", "L69pZBrLYVV"),
    ("ICD10", "Z95.0", "Z95.0 Presence of electronic cardiac devices", "dZMoOgFpTcq"),
    ("ICD10", "Z95.1", "Z95.1 Presence of aortocoronary bypass graft", "ebueOxkk4dP"),
    ("ICD10", "Z95.2", "Z95.2 Presence of prosthetic heart valve", "cUEAs3W8h2w"),
    ("ICD10", "Z95.3", "Z95.3 Presence of xenogenic heart valve", "DzW3eaukn64"),
    ("ICD10", "Z95.4", "Z95.4 Presence of other heart-valve replacement", "vwRAPvSPmvw"),
    ("ICD10", "Z95.5", "Z95.5 Presence of coronary angioplasty implant and graft", "PBwSR7NSGWp"),
    ("ICD10", "Z95.8", "Z95.8 Presence of other cardiac and vascular implants and grafts", "Jb13euEJYim"),
    ("ICD10", "Z95.9", "Z95.9 Presence of cardiac and vascular implant and graft, unspecified", "N6virT8x8Ti"),
    ("ICD10", "Z96", "Z96 Presence of other functional implants", "LvdwnuQSF2l"),
    ("ICD10", "Z96.0", "Z96.0 Presence of urogenital implants", "oWUwWh0RNz2"),
    ("ICD10", "Z96.1", "Z96.1 Presence of intraocular lens", "GniMVs29i9M"),
    ("ICD10", "Z96.2", "Z96.2 Presence of otological and audiological implants", "XHp06LGdmZN"),
    ("ICD10", "Z96.3", "Z96.3 Presence of artificial larynx", "JvdnTdWfKUk"),
    ("ICD10", "Z96.4", "Z96.4 Presence of endocrine implants", "mmT5C9dGzqL"),
    ("ICD10", "Z96.5", "Z96.5 Presence of tooth-root and mandibular implants", "JEj8WrL07Eu"),
    ("ICD10", "Z96.6", "Z96.6 Presence of orthopaedic joint implants", "sY2GcwHYxXU"),
    ("ICD10", "Z96.7", "Z96.7 Presence of other bone and tendon implants", "J3SMczQ5KW6"),
    ("ICD10", "Z96.8", "Z96.8 Presence of other s