#!/bin/env python
# Generated on 2022-03-14 with the following command:
#
#     ./mkquad.py
#
# TODO: make this several files so that everything
#       doesnt have to be loaded.
#

class IntervalQuadrature:
    def __iter__(self):
        yield self.points
        yield self.weights

    def __init__(self, n):
        data = self.__class__.data[n]
        self.points = data["points"]
        self.weights = data["weights"]
        self.degree = data["degree"]


class Lobatto(IntervalQuadrature):
    data = {
        1: {None},
        2: {
            "degree": 1,
            "points": [-1.0, 1.0],
            "weights": [0.9999999999999998, 0.9999999999999998],
            "generator": "gauss_lobatto",
        },
        3: {
            "degree": 3,
            "points": [-0.9999999999999978, 6.661338147750939e-16, 0.9999999999999999],
            "weights": [0.33333333333333476, 1.3333333333333315, 0.33333333333333354],
            "generator": "gauss_lobatto",
        },
        4: {
            "degree": 5,
            "points": [
                -0.9999999999999978,
                -0.4472135954999572,
                0.44721359549995876,
                1.0,
            ],
            "weights": [
                0.16666666666666685,
                0.8333333333333333,
                0.833333333333333,
                0.16666666666666632,
            ],
            "generator": "gauss_lobatto",
        },
        5: {
            "degree": 7,
            "points": [
                -0.9999999999999982,
                -0.6546536707079755,
                6.661338147750939e-16,
                0.6546536707079775,
                1.0,
            ],
            "weights": [
                0.0999999999999992,
                0.5444444444444464,
                0.7111111111111109,
                0.5444444444444436,
                0.09999999999999964,
            ],
            "generator": "gauss_lobatto",
        },
        6: {
            "degree": 9,
            "points": [
                -0.9999999999999998,
                -0.765055323929464,
                -0.28523151648064515,
                0.2852315164806456,
                0.7650553239294646,
                1.0,
            ],
            "weights": [
                0.06666666666666483,
                0.37847495629785,
                0.5548583770354855,
                0.5548583770354855,
                0.37847495629784766,
                0.06666666666666651,
            ],
            "generator": "gauss_lobatto",
        },
        7: {
            "degree": 11,
            "points": [
                -0.9999999999999976,
                -0.8302238962785637,
                -0.4688487934707133,
                2.220446049250313e-16,
                0.46884879347071506,
                0.8302238962785671,
                1.0,
            ],
            "weights": [
                0.047619047619048185,
                0.2768260473615666,
                0.4317453812098624,
                0.4876190476190478,
                0.43174538120986206,
                0.27682604736156524,
                0.04761904761904743,
            ],
            "generator": "gauss_lobatto",
        },
        8: {
            "degree": 13,
            "points": [
                -0.9999999999999987,
                -0.8717401485096059,
                -0.5917001814331417,
                -0.20929921790247863,
                0.20929921790247963,
                0.5917001814331423,
                0.8717401485096068,
                1.0,
            ],
            "weights": [
                0.03571428571428532,
                0.21070422714350415,
                0.3411226924835074,
                0.41245879465870305,
                0.41245879465870405,
                0.34112269248350424,
                0.210704227143506,
                0.035714285714285525,
            ],
            "generator": "gauss_lobatto",
        },
        9: {
            "degree": 15,
            "points": [
                -0.9999999999999984,
                -0.8997579954114587,
                -0.6771862795107362,
                -0.3631174638261774,
                0.0,
                0.3631174638261786,
                0.6771862795107383,
                0.8997579954114601,
                1.0,
            ],
            "weights": [
                0.02777777777777764,
                0.1654953615608063,
                0.27453871250016115,
                0.3464285109730465,
                0.3715192743764182,
                0.3464285109730452,
                0.2745387125001616,
                0.165495361560806,
                0.027777777777777665,
            ],
            "generator": "gauss_lobatto",
        },
        10: {
            "degree": 17,
            "points": [
                -0.9999999999999996,
                -0.9195339081664577,
                -0.7387738651055042,
                -0.47792494981044387,
                -0.16527895766638712,
                0.16527895766638823,
                0.47792494981044487,
                0.7387738651055051,
                0.9195339081664586,
                1.0,
            ],
            "weights": [
                0.022222222222220846,
                0.13330599085107145,
                0.2248893420631292,
                0.2920426836796824,
                0.32753976118389466,
                0.32753976118389705,
                0.29204268367968306,
                0.22488934206312794,
                0.13330599085107017,
                0.022222222222222133,
            ],
            "generator": "gauss_lobatto",
        },
        11: {
            "degree": 19,
            "points": [
                -1.0000000000000004,
                -0.9340014304080582,
                -0.7844834736631436,
                -0.5652353269962056,
                -0.2957581355869381,
                -4.440892098500626e-16,
                0.29575813558693964,
                0.5652353269962049,
                0.7844834736631443,
                0.934001430408059,
                1.0,
            ],
            "weights": [
                0.018181818181816082,
                0.10961227326699295,
                0.1871698817803077,
                0.24804810426403048,
                0.2868791247790077,
                0.3002175954556917,
                0.2868791247790069,
                0.2480481042640292,
                0.18716988178030525,
                0.10961227326699403,
                0.018181818181818146,
            ],
            "generator": "gauss_lobatto",
        },
        12: {
            "degree": 21,
            "points": [
                -1.0000000000000004,
                -0.9448992722228817,
                -0.8192793216440062,
                -0.6328761530318598,
                -0.39953094096534936,
                -0.13655293285492798,
                0.1365529328549281,
                0.39953094096534914,
                0.632876153031861,
                0.8192793216440066,
                0.9448992722228822,
                1.0,
            ],
            "weights": [
                0.015151515151513811,
                0.09168451741319396,
                0.15797470556437102,
                0.21250841776102344,
                0.251275603199203,
                0.27140524091069435,
                0.2714052409106962,
                0.25127560319920217,
                0.21250841776102075,
                0.15797470556436988,
                0.09168451741319555,
                0.015151515151515154,
            ],
            "generator": "gauss_lobatto",
        },
        13: {
            "degree": 23,
            "points": [
                -1.0,
                -0.9533098466421634,
                -0.8463475646518714,
                -0.6861884690817577,
                -0.4829098210913356,
                -0.24928693010623904,
                2.220446049250313e-16,
                0.2492869301062397,
                0.4829098210913362,
                0.6861884690817573,
                0.8463475646518723,
                0.953309846642164,
                1.0,
            ],
            "weights": [
                0.012820512820512638,
                0.07780168674681694,
                0.13498192668960848,
                0.1836468652035522,
                0.2207677935661098,
                0.24401579030667844,
                0.25193084933344745,
                0.2440157903066755,
                0.22076779356610884,
                0.18364686520355059,
                0.13498192668960832,
                0.07780168674681857,
                0.0128205128205129,
            ],
            "generator": "gauss_lobatto",
        },
        14: {
            "degree": 25,
            "points": [
                -0.9999999999999996,
                -0.9599350452672597,
                -0.8678010538303467,
                -0.7288685990913253,
                -0.5506394029286479,
                -0.34272401334271363,
                -0.1163318688837034,
                0.11633186888370439,
                0.3427240133427134,
                0.5506394029286474,
                0.7288685990913264,
                0.8678010538303473,
                0.959935045267261,
                1.0,
            ],
            "weights": [
                0.010989010989011548,
                0.06683728449767998,
                0.11658665589871241,
                0.1600218517629538,
                0.19482614937341677,
                0.21912625300976965,
                0.2316127944684555,
                0.23161279446845567,
                0.2191262530097709,
                0.19482614937341733,
                0.1600218517629522,
                0.11658665589871195,
                0.0668372844976812,
                0.010989010989011104,
            ],
            "generator": "gauss_lobatto",
        },
        15: {
            "degree": 27,
            "points": [
                -0.9999999999999987,
                -0.9652459265038373,
                -0.885082044222975,
                -0.7635196899518146,
                -0.6062532054698446,
                -0.4206380547136723,
                -0.21535395536379376,
                2.220446049250313e-16,
                0.2153539553637943,
                0.4206380547136729,
                0.6062532054698461,
                0.7635196899518154,
                0.8850820442229764,
                0.9652459265038388,
                1.0,
            ],
            "weights": [
                0.009523809523811006,
                0.058029893028599074,
                0.10166007032571688,
                0.14051169980242767,
                0.17278964725360296,
                0.19698723596461373,
                0.21197358592682206,
                0.2170481163488151,
                0.21197358592682133,
                0.1969872359646134,
                0.1727896472535999,
                0.1405116998024282,
                0.10166007032571787,
                0.058029893028601134,
                0.009523809523809554,
            ],
            "generator": "gauss_lobatto",
        },
        16: {
            "degree": 29,
            "points": [
                -0.9999999999999991,
                -0.9695680462702181,
                -0.8992005330934716,
                -0.7920082918618154,
                -0.6523887028824933,
                -0.486059421887137,
                -0.2998304689007629,
                -0.10132627352194912,
                0.10132627352195,
                0.29983046890076404,
                0.48605942188713747,
                0.6523887028824935,
                0.7920082918618151,
                0.8992005330934721,
                0.9695680462702181,
                1.0,
            ],
            "weights": [
                0.008333333333334213,
                0.05085036100591913,
                0.08939369732592968,
                0.12425538213251645,
                0.15402698080716465,
                0.17749191339170423,
                0.19369002382520223,
                0.20195830817823007,
                0.2019583081782291,
                0.19369002382520348,
                0.17749191339170323,
                0.1540269808071652,
                0.12425538213251465,
                0.08939369732593087,
                0.05085036100592017,
                0.008333333333333382,
            ],
            "generator": "gauss_lobatto",
        },
        17: {
            "degree": 31,
            "points": [
                -0.9999999999999987,
                -0.973132176631418,
                -0.9108799959155724,
                -0.8156962512217689,
                -0.6910289806276833,
                -0.5413853993301017,
                -0.3721744335654762,
                -0.1895119735183166,
                4.440892098500626e-16,
                0.18951197351831772,
                0.3721744335654772,
                0.5413853993301019,
                0.6910289806276846,
                0.8156962512217704,
                0.9108799959155737,
                0.9731321766314184,
                1.0,
            ],
            "weights": [
                0.007352941176471605,
                0.04492194054325402,
                0.07919827050368587,
                0.11059290900702957,
                0.13798774620192938,
                0.16039466199761998,
                0.17700425351565824,
                0.18721633967761886,
                0.1906618747534675,
                0.1872163396776194,
                0.17700425351565705,
                0.16039466199762226,
                0.1379877462019271,
                0.11059290900702813,
                0.07919827050368707,
                0.04492194054325447,
                0.0073529411764706315,
            ],
            "generator": "gauss_lobatto",
        },
        18: {
            "degree": 33,
            "points": [
                -0.9999999999999998,
                -0.9761055574121988,
                -0.920649185347534,
                -0.8355935352180901,
                -0.7236793292832424,
                -0.5885048343186625,
                -0.4344150369121247,
                -0.26636265287828076,
                -0.08974909348465188,
                0.08974909348465221,
                0.2663626528782811,
                0.43441503691212446,
                0.5885048343186619,
                0.7236793292832429,
                0.8355935352180905,
                0.920649185347534,
                0.9761055574121986,
                1.0,
            ],
            "weights": [
                0.006535947712417979,
                0.039970628810914614,
                0.07063716688563182,
                0.0990162717175021,
                0.12421053313296705,
                0.14541196157380484,
                0.16193951723760203,
                0.17326210948945586,
                0.17901586343970385,
                0.17901586343970266,
                0.17326210948945525,
                0.16193951723760316,
                0.1454119615738021,
                0.12421053313296658,
                0.09901627171750292,
                0.07063716688563369,
                0.039970628810914365,
                0.006535947712418293,
            ],
            "generator": "gauss_lobatto",
        },
        19: {
            "degree": 35,
            "points": [
                -0.9999999999999996,
                -0.9786117662220799,
                -0.9289015281525861,
                -0.8524605777966456,
                -0.7514942025526123,
                -0.6289081372652199,
                -0.48822928568071267,
                -0.33350484782449863,
                -0.16918602340928146,
                4.440892098500626e-16,
                0.1691860234092818,
                0.33350484782449896,
                0.4882292856807138,
                0.6289081372652212,
                0.7514942025526132,
                0.8524605777966461,
                0.9289015281525864,
                0.9786117662220801,
                1.0,
            ],
            "weights": [
                0.005847953216373969,
                0.03579336518617792,
                0.06338189176262879,
                0.08913175709920805,
                0.11231534147730403,
                0.13226728044875072,
                0.14841394259593946,
                0.1602909240440616,
                0.16755658452714225,
                0.1700019192848255,
                0.1675565845271431,
                0.16029092404406214,
                0.14841394259593788,
                0.13226728044875039,
                0.11231534147730518,
                0.08913175709920762,
                0.06338189176262998,
                0.0357933651861767,
                0.005847953216374237,
            ],
            "generator": "gauss_lobatto",
        },
        20: {
            "degree": 37,
            "points": [
                -0.9999999999999998,
                -0.9807437048939143,
                -0.9359344988126654,
                -0.8668779780899492,
                -0.775368260952056,
                -0.6637764022903114,
                -0.5349928640318862,
                -0.3923531837139085,
                -0.23955170592298636,
                -0.08054593723882153,
                0.08054593723882242,
                0.2395517059229869,
                0.3923531837139097,
                0.5349928640318866,
                0.6637764022903112,
                0.775368260952056,
                0.8668779780899502,
                0.9359344988126655,
                0.9807437048939142,
                1.0,
            ],
            "weights": [
                0.005263157894736142,
                0.03223712318848967,
                0.057181802127566676,
                0.08063176399612038,
                0.10199149969945154,
                0.1207092276286764,
                0.13630048235872197,
                0.1483615540709155,
                0.156580102647475,
                0.1607432863878459,
                0.16074328638784555,
                0.15658010264747457,
                0.14836155407091509,
                0.13630048235872405,
                0.12070922762867584,
                0.1019914996994515,
                0.08063176399611971,
                0.05718180212756718,
                0.03223712318848899,
                0.005263157894736828,
            ],
            "generator": "gauss_lobatto",
        },
        21: {
            "degree": 39,
            "points": [
                -0.9999999999999996,
                -0.9825722966045471,
                -0.9419762969597447,
                -0.8792947553235886,
                -0.7960019260777118,
                -0.6940510260622219,
                -0.5758319602618311,
                -0.44411578327900214,
                -0.30198985650876464,
                -0.15278551580218513,
                6.661338147750939e-16,
                0.1527855158021858,
                0.30198985650876564,
                0.4441157832790025,
                0.5758319602618311,
                0.6940510260622235,
                0.7960019260777125,
                0.8792947553235906,
                0.9419762969597455,
                0.982572296604548,
                1.0,
            ],
            "weights": [
                0.0047619047619041985,
                0.029184840098505617,
                0.051843169000850356,
                0.07327391818507258,
                0.09298546795788809,
                0.11051708321912454,
                0.12545812119087013,
                0.1374584628600417,
                0.14623686244797598,
                0.15158757511168042,
                0.15338519033217307,
                0.15158757511168133,
                0.14623686244797707,
                0.1374584628600426,
                0.12545812119086963,
                0.11051708321912342,
                0.09298546795788624,
                0.07327391818507405,
                0.05184316900084989,
                0.0291848400985054,
                0.0047619047619047224,
            ],
            "generator": "gauss_lobatto",
        },
        22: {
            "degree": 41,
            "points": [
                -1.0000000000000002,
                -0.9841524384576461,
                -0.9472042839992287,
                -0.8900622901909041,
                -0.813948927611921,
                -0.7204872399612023,
                -0.6116694382842585,
                -0.4898148751899014,
                -0.35752071013891906,
                -0.21760658515928477,
                -0.0730545400108984,
                0.07305454001089895,
                0.21760658515928533,
                0.3575207101389194,
                0.4898148751899025,
                0.6116694382842591,
                0.7204872399612022,
                0.8139489276119212,
                0.8900622901909045,
                0.9472042839992286,
                0.9841524384576462,
                1.0,
            ],
            "weights": [
                0.004329004329002971,
                0.026545747682501182,
                0.04721446529374164,
                0.06686560586455079,
                0.0850900603918387,
                0.10150057480164758,
                0.11574764465394027,
                0.1275276966534304,
                0.13658968861374313,
                0.14274049227136137,
                0.14584901944424228,
                0.14584901944424222,
                0.14274049227136126,
                0.1365896886137418,
                0.12752769665342945,
                0.11574764465393828,
                0.10150057480164774,
                0.08509006039183828,
                0.06686560586455305,
                0.04721446529374072,
                0.026545747682501643,
                0.004329004329004284,
            ],
            "generator": "gauss_lobatto",
        },
        23: {
            "degree": 43,
            "points": [
                -1.0000000000000004,
                -0.9855271558787333,
                -0.9517579557107099,
                -0.8994585580403451,
                -0.829651096651286,
                -0.7436950411720602,
                -0.6432636444601372,
                -0.5303117711368441,
                -0.4070379379144746,
                -0.27584154894579305,
                -0.13927620404066854,
                0.0,
                0.13927620404066854,
                0.2758415489457928,
                0.40703793791447496,
                0.5303117711368441,
                0.6432636444601365,
                0.7436950411720609,
                0.829651096651286,
                0.899458558040345,
                0.9517579557107102,
                0.9855271558787326,
                1.0,
            ],
            "weights": [
                0.003952569169959066,
                0.024248600771531598,
                0.04317587117024298,
                0.06125247712955391,
                0.07813544947557091,
                0.09349724616351301,
                0.10703910172433719,
                0.11849751066274897,
                0.12764947470175714,
                0.13431687263860423,
                0.13836993638580744,
                0.13972978001274658,
                0.13836993638580744,
                0.1343168726386032,
                0.12764947470175814,
                0.1184975106627491,
                0.10703910172433752,
                0.09349724616351245,
                0.07813544947557043,
                0.06125247712955459,
                0.04317587117024172,
                0.02424860077153178,
                0.003952569169960447,
            ],
            "generator": "gauss_lobatto",
        },
        24: {
            "degree": 45,
            "points": [
                -1.0,
                -0.9867305535051607,
                -0.9557482209298855,
                -0.9077056751135057,
                -0.8434640701548712,
                -0.7641704824204929,
                -0.6712401052641279,
                -0.5663313579792957,
                -0.4513163732143226,
                -0.3282476133755108,
                -0.19932125339083218,
                -0.06683799373722876,
                0.0668379937372291,
                0.19932125339083295,
                0.3282476133755112,
                0.4513163732143227,
                0.5663313579792957,
                0.6712401052641286,
                0.7641704824204933,
                0.8434640701548719,
                0.9077056751135064,
                0.9557482209298863,
                0.9867305535051609,
                1.0,
            ],
            "weights": [
                0.003623188405796096,
                0.022236853464711236,
                0.03963168133346675,
                0.056309848724646915,
                0.07198186205529497,
                0.08636902996792857,
                0.09921482768408686,
                0.11029008689296768,
                0.11939719370249234,
                0.12637364202801965,
                0.1310949418736035,
                0.1334768438669858,
                0.13347684386698616,
                0.13109494187360327,
                0.1263736420280214,
                0.11939719370249172,
                0.11029008689296872,
                0.0992148276840838,
                0.0863690299679291,
                0.07198186205529435,
                0.056309848724646276,
                0.039631681333467526,
                0.02223685346471116,
                0.0036231884057970672,
            ],
            "generator": "gauss_lobatto",
        },
        25: {
            "degree": 47,
            "points": [
                -1.0,
                -0.9877899449314935,
                -0.9592641382525335,
                -0.9149827707346223,
                -0.8556764658353155,
                -0.7823196592407169,
                -0.6961170488151336,
                -0.5984841472799931,
                -0.49102411481887787,
                -0.37550145785922684,
                -0.2538130641688767,
                -0.12795705948310676,
                2.220446049250313e-16,
                0.12795705948310732,
                0.25381306416887683,
                0.3755014578592274,
                0.49102411481887875,
                0.5984841472799931,
                0.6961170488151346,
                0.7823196592407169,
                0.8556764658353164,
                0.9149827707346225,
                0.9592641382525344,
                0.9877899449314937,
                1.0,
            ],
            "weights": [
                0.0033333333333324796,
                0.020465168932974703,
                0.0365047387942695,
                0.05193622836849148,
                0.0665137286753135,
                0.07999877483629342,
                0.0921701399106198,
                0.10282803034796016,
                0.11179746626832049,
                0.11893117940681282,
                0.12411203893795042,
                0.12725497753833184,
                0.1283083892986616,
                0.1272549775383319,
                0.12411203893795059,
                0.11893117940681133,
                0.11179746626832066,
                0.1028280303479579,
                0.09217013991062027,
                0.07999877483629327,
                0.06651372867531292,
                0.05193622836849123,
                0.03650473879427109,
                0.020465168932974346,
                0.003333333333333285,
            ],
            "generator": "gauss_lobatto",
        },
        26: {
            "degree": 49,
            "points": [
                -1.0,
                -0.9887274123114755,
                -0.9623778747677165,
                -0.921435546817557,
                -0.8665243239591229,
                -0.7984771831074378,
                -0.718325816362666,
                -0.6272852994923173,
                -0.5267357420298788,
                -0.41820138706624665,
                -0.3033275128592521,
                -0.1838554952700544,
                -0.06159641178191988,
                0.06159641178191999,
                0.18385549527005496,
                0.30332751285925275,
                0.41820138706624677,
                0.5267357420298784,
                0.6272852994923171,
                0.7183258163626651,
                0.7984771831074374,
                0.8665243239591236,
                0.9214355468175573,
                0.9623778747677174,
                0.9887274123114757,
                1.0,
            ],
            "weights": [
                0.003076923076922327,
                0.018896858024264447,
                0.03373230368595398,
                0.0480483990811797,
                0.061635025142547685,
                0.07428705012229292,
                0.08581286398000527,
                0.09603780235390186,
                0.10480688623073788,
                0.1119871941198595,
                0.1174698840938088,
                0.1211718462884437,
                0.12303696380008267,
                0.1230369638000832,
                0.12117184628844323,
                0.11746988409380808,
                0.11198719411986052,
                0.1048068862307375,
                0.09603780235390137,
                0.08581286398000496,
                0.07428705012229142,
                0.06163502514254733,
                0.04804839908118027,
                0.033732303685955825,
                0.018896858024263503,
                0.003076923076923039,
            ],
            "generator": "gauss_lobatto",
        },
        27: {
            "degree": 51,
            "points": [
                -0.9999999999999996,
                -0.9895609637285496,
                -0.9651484024508179,
                -0.9271834587251153,
                -0.8762020862145214,
                -0.812920486895812,
                -0.7382271498464585,
                -0.6531706636968091,
                -0.5589450609425604,
                -0.4568730756140822,
                -0.34838758198902875,
                -0.2350114831029182,
                -0.11833633389852127,
                0.0,
                0.1183363338985216,
                0.23501148310291875,
                0.34838758198902886,
                0.45687307561408275,
                0.5589450609425615,
                0.6531706636968095,
                0.7382271498464599,
                0.8129204868958123,
                0.8762020862145226,
                0.9271834587251159,
                0.965148402450819,
                0.9895609637285506,
                1.0,
            ],
            "weights": [
                0.0028490028490025937,
                0.017501974876066667,
                0.031262951735200474,
                0.044577657933060115,
                0.05726556968016187,
                0.0691493423600449,
                0.08006232197053956,
                0.08985136525929296,
                0.09837907458595122,
                0.105525747821254,
                0.11119106525743752,
                0.11529550025465092,
                0.11778143658595626,
                0.11861397766276269,
                0.11778143658595615,
                0.11529550025465177,
                0.11119106525743779,
                0.10552574782125301,
                0.09837907458595203,
                0.08985136525929162,
                0.08006232197053821,
                0.06914934236004312,
                0.057265569680162526,
                0.04457765793306142,
                0.03126295173520229,
                0.01750197487606565,
                0.0028490028490028105,
            ],
            "generator": "gauss_lobatto",
        },
        28: {
            "degree": 53,
            "points": [
                -0.9999999999999993,
                -0.9903054026184528,
                -0.9676242858571305,
                -0.9323251671215582,
                -0.8848710172113015,
                -0.825880970056337,
                -0.7561241940055692,
                -0.6765101289295725,
                -0.5880766898371761,
                -0.4919767539315787,
                -0.3894631375763622,
                -0.28187226662160203,
                -0.17060675530800395,
                -0.05711712169351313,
                0.05711712169351335,
                0.1706067553080045,
                0.2818722666216027,
                0.3894631375763634,
                0.4919767539315797,
                0.5880766898371758,
                0.6765101289295734,
                0.75612419400557,
                0.8258809700563383,
                0.8848710172113028,
                0.9323251671215587,
                0.9676242858571313,
                0.9903054026184541,
                1.0,
            ],
            "weights": [
                0.0026455026455026926,
                0.01625588395750513,
                0.029054220677977825,
                0.04146691524300587,
                0.05333807704732628,
                0.06451365808035513,
                0.07484812350970706,
                0.08420679512151222,
                0.09246768599771345,
                0.09952311041249495,
                0.10528109376105547,
                0.10966657379597773,
                0.11262238007723938,
                0.11410997967262732,
                0.11410997967262825,
                0.11262238007723935,
                0.10966657379597654,
                0.10528109376105509,
                0.09952311041249533,
                0.0924676859977128,
                0.08420679512150998,
                0.0748481235097075,
                0.0645136580803545,
                0.05333807704732728,
                0.0414669152430068,
                0.02905422067797917,
                0.016255883957504248,
                0.002645502645502618,
            ],
            "generator": "gauss_lobatto",
        },
        29: {
            "degree": 55,
            "points": [
                -0.9999999999999987,
                -0.9909729882685678,
                -0.969845807287935,
                -0.9369427185209815,
                -0.8926657199760868,
                -0.8375527362817854,
                -0.7722728972064676,
                -0.6976186613563669,
                -0.6144962522034318,
                -0.5239146743719687,
                -0.42697347171349387,
                -0.3248493828419099,
                -0.21878205828426034,
                -0.11005901339559165,
                0.0,
                0.11005901339559288,
                0.21878205828426134,
                0.3248493828419112,
                0.4269734717134943,
                0.523914674371969,
                0.6144962522034332,
                0.6976186613563683,
                0.7722728972064689,
                0.8375527362817866,
                0.8926657199760883,
                0.9369427185209825,
                0.9698458072879363,
                0.9909729882685698,
                1.0,
            ],
            "weights": [
                0.0024630541871927623,
                0.015138169859968336,
                0.02707080629682449,
                0.03866843997971346,
                0.049795809093235825,
                0.06031850382852379,
                0.070108938000598,
                0.07904831302788477,
                0.08702813344113731,
                0.09395154211479735,
                0.09973450163714985,
                0.1043068164636754,
                0.10761298583356753,
                0.10961287784589033,
                0.11028221677968235,
                0.10961287784589009,
                0.10761298583356732,
                0.10430681646367657,
                0.09973450163715016,
                0.09395154211479696,
                0.08702813344113491,
                0.07904831302788552,
                0.0701089380005981,
                0.060318503828522996,
                0.049795809093237574,
                0.03866843997971321,
                0.027070806296824963,
                0.015138169859967635,
                0.0024630541871920766,
            ],
            "generator": "gauss_lobatto",
        },
        30: {
            "degree": 57,
            "points": [
                -0.9999999999999991,
                -0.991573942840499,
                -0.9718466031662689,
                -0.9411047809510564,
                -0.8996992181992765,
                -0.8480994871801975,
                -0.7868903572375465,
                -0.716765398637085,
                -0.6385191758075579,
                -0.5530382600950519,
                -0.4612911901682406,
                -0.3643175004224488,
                -0.2632159437195736,
                -0.15913204262584957,
                -0.053245110485486746,
                0.05324511048548752,
                0.1591320426258508,
                0.263215943719574,
                0.36431750042244915,
                0.46129119016824094,
                0.5530382600950533,
                0.6385191758075587,
                0.7167653986370852,
                0.7868903572375472,
                0.8480994871801981,
                0.8996992181992769,
                0.9411047809510571,
                0.9718466031662693,
                0.9915739428405004,
                1.0,
            ],
            "weights": [
                0.0022988505747128306,
                0.01413179932790517,
                0.02528316674055106,
                0.0361420941994094,
                0.04659069453314177,
                0.05651119792308141,
                0.06579133639779035,
                0.07432600332471873,
                0.0820185128334073,
                0.08878171231976352,
                0.09453897519386144,
                0.09922507100430097,
                0.1027869053072354,
                0.10518412159645463,
                0.10638955872366648,
                0.10638955872366794,
                0.10518412159645478,
                0.10278690530723525,
                0.09922507100429968,
                0.09453897519386076,
                0.08878171231976362,
                0.08201851283340741,
                0.07432600332471882,
                0.06579133639779018,
                0.05651119792308057,
                0.046590694533143094,
                0.03614209419940867,
                0.025283166740551453,
                0.014131799327905427,
                0.002298850574712603,
            ],
            "generator": "gauss_lobatto",
        },
        31: {
            "degree": 59,
            "points": [
                -0.9999999999999996,
                -0.9921168443464807,
                -0.9736549358157365,
                -0.944869170208039,
                -0.9060669514412696,
                -0.8576599952974551,
                -0.8001615431924636,
                -0.7341811363090749,
                -0.6604182026115255,
                -0.5796546572080026,
                -0.4927466190988321,
                -0.40061533828056195,
                -0.3042374312728724,
                -0.20463452924752357,
                -0.10286244876068174,
                2.220446049250313e-16,
                0.10286244876068285,
                0.20463452924752457,
                0.30423743127287284,
                0.40061533828056217,
                0.49274661909883277,
                0.5796546572080022,
                0.6604182026115255,
                0.7341811363090753,
                0.8001615431924631,
                0.8576599952974557,
                0.9060669514412698,
                0.9448691702080393,
                0.9736549358157365,
                0.9921168443464812,
                1.0,
            ],
            "weights": [
                0.0021505376344082778,
                0.013222471025464089,
                0.023666433230270147,
                0.033853940405224776,
                0.04368181816006659,
                0.05304646549344845,
                0.06184874129045578,
                0.06999537759410146,
                0.07740003234147787,
                0.0839842205175289,
                0.0896781510452599,
                0.0944214683778568,
                0.09816389301371271,
                0.10086575479865058,
                0.10249841359547052,
                0.10304456295320738,
                0.10249841359546978,
                0.10086575479864955,
                0.09816389301371208,
                0.09442146837785782,
                0.08967815104526054,
                0.08398422051753059,
                0.07740003234147638,
                0.06999537759410053,
                0.06184874129045479,
                0.053046465493448776,
                0.043681818160067096,
                0.03385394040522408,
                0.023666433230270283,
                0.013222471025464685,
                0.0021505376344085362,
            ],
            "generator": "gauss_lobatto",
        },
        32: {
            "degree": 61,
            "points": [
                -0.9999999999999996,
                -0.9926089339727611,
                -0.9752946904827089,
                -0.9482848384172318,
                -0.9118499390637314,
                -0.8663524760126744,
                -0.8122447317774417,
                -0.7500644939366736,
                -0.6804297556155496,
                -0.6040325871484211,
                -0.5216322628815653,
                -0.4340477172018471,
                -0.3421494065388817,
                -0.2468506588502053,
                -0.14909859681364712,
                -0.04986472504659356,
                0.04986472504659367,
                0.14909859681364712,
                0.24685065885020552,
                0.3421494065388817,
                0.43404771720184687,
                0.5216322628815653,
                0.6040325871484212,
                0.6804297556155509,
                0.7500644939366747,
                0.8122447317774424,
                0.8663524760126755,
                0.9118499390637318,
                0.9482848384172323,
                0.9752946904827092,
                0.9926089339727614,
                1.0,
            ],
            "weights": [
                0.002016129032257692,
                0.012398106501372777,
                0.022199552889291634,
                0.0317751354109156,
                0.041034201586062614,
                0.0498852713362204,
                0.05824049724805728,
                0.06601687725715376,
                0.07313713960267995,
                0.0795305256921086,
                0.08513349794966917,
                0.08989037295735786,
                0.09375387554681329,
                0.09668560894800203,
                0.098656436540762,
                0.0996467715012752,
                0.09964677150127603,
                0.09865643654076166,
                0.0966856089480028,
                0.09375387554681454,
                0.089890372957358,
                0.08513349794966912,
                0.07953052569210607,
                0.07313713960267876,
                0.06601687725715437,
                0.05824049724805597,
                0.04988527133622131,
                0.04103420158606266,
                0.03177513541091537,
                0.02219955288929185,
                0.012398106501373839,
                0.002016129032258002,
            ],
            "generator": "gauss_lobatto",
        },
        33: {
            "degree": 63,
            "points": [
                -1.0,
                -0.9930563584336582,
                -0.9767861633169064,
                -0.951393451396995,
                -0.9171173034509408,
                -0.8742781007505616,
                -0.8232759230040667,
                -0.7645870017935283,
                -0.6987593166181623,
                -0.626407491281268,
                -0.5482070599191107,
                -0.4648881616321068,
                -0.3772287242533934,
                -0.2860472014876738,
                -0.19219493146747735,
                -0.09654818817610678,
                -2.220446049250313e-16,
                0.09654818817610733,
                0.19219493146747724,
                0.28604720148767426,
                0.37722872425339393,
                0.4648881616321069,
                0.5482070599191116,
                0.6264074912812685,
                0.6987593166181627,
                0.7645870017935288,
                0.8232759230040676,
                0.8742781007505622,
                0.9171173034509412,
                0.9513934513969957,
                0.9767861633169063,
                0.9930563584336584,
                1.0,
            ],
            "weights": [
                0.001893939393938646,
                0.011648448392266943,
                0.02086460901760329,
                0.02988104591674667,
                0.03861781477181372,
                0.04699385046102395,
                0.05493105944262789,
                0.06235536785246499,
                0.06919746949401544,
                0.07539348692397438,
                0.08088557219345445,
                0.0856224485318137,
                0.08955988974707768,
                0.09266113344224239,
                0.09489722439459244,
                0.09624728497298614,
                0.09669871010271691,
                0.0962472849729852,
                0.0948972243945921,
                0.09266113344224174,
                0.0895598897470767,
                0.08562244853181299,
                0.08088557219345367,
                0.07539348692397374,
                0.06919746949401609,
                0.06235536785246557,
                0.05493105944262708,
                0.046993850461024306,
                0.03861781477181381,
                0.029881045916746393,
                0.020864609017603165,
                0.011648448392267778,
                0.0018939393939393424,
            ],
            "generator": "gauss_lobatto",
        },
        34: {
            "degree": 65,
            "points": [
                -0.9999999999999998,
                -0.9934643625875159,
                -0.9781466888799375,
                -0.9542306489128063,
                -0.9219282956774484,
                -0.8815238365122722,
                -0.8333724428031419,
                -0.7778973064318666,
                -0.7155859607202186,
                -0.6469860079360139,
                -0.5727003112749232,
                -0.4933816986732702,
                -0.4097272265595924,
                -0.3224720545114885,
                -0.23238298486911724,
                -0.1402517241761938,
                -0.046887925712970624,
                0.04688792571297118,
                0.14025172417619391,
                0.23238298486911735,
                0.3224720545114895,
                0.4097272265595929,
                0.4933816986732713,
                0.5727003112749234,
                0.6469860079360148,
                0.7155859607202191,
                0.7778973064318674,
                0.8333724428031426,
                0.8815238365122732,
                0.9219282956774489,
                0.9542306489128076,
                0.9781466888799379,
                0.9934643625875162,
                1.0,
            ],
            "weights": [
                0.0017825311942953484,
                0.010964740818306229,
                0.01964627816071329,
                0.02815053686224375,
                0.03640677095078202,
                0.044342902060244785,
                0.051889291830928545,
                0.0589796540267459,
                0.06555169010826653,
                0.07154764987707461,
                0.0769148430635894,
                0.08160610385042211,
                0.08558020597197737,
                0.08880222528358309,
                0.09124384680691325,
                0.09288361362961181,
                0.09370711550430139,
                0.09370711550430255,
                0.09288361362961108,
                0.09124384680691412,
                0.08880222528358349,
                0.08558020597197777,
                0.08160610385042195,
                0.07691484306359125,
                0.07154764987707371,
                0.0655516901082656,
                0.058979654026745244,
                0.05188929183092758,
                0.04434290206024445,
                0.03640677095078245,
                0.02815053686224348,
                0.019646278160713238,
                0.010964740818306624,
                0.001782531194295842,
            ],
            "generator": "gauss_lobatto",
        },
        35: {
            "degree": 67,
            "points": [
                -0.9999999999999996,
                -0.993837443644386,
                -0.9793911434299198,
                -0.9568270584369873,
                -0.9263339320160815,
                -0.8881647537179498,
                -0.8426358953821986,
                -0.7901246570847951,
                -0.7310661783787649,
                -0.6659498438657754,
                -0.5953152320800832,
                -0.5197476460622013,
                -0.4398732641317167,
                -0.3563539515654537,
                -0.2698817763817203,
                -0.18117327476560185,
                -0.0909635136967002,
                -2.220446049250313e-16,
                0.09096351369670053,
                0.18117327476560185,
                0.2698817763817213,
                0.35635395156545424,
                0.43987326413171723,
                0.5197476460622018,
                0.5953152320800832,
                0.6659498438657759,
                0.7310661783787653,
                0.7901246570847958,
                0.8426358953821997,
                0.8881647537179505,
                0.9263339320160819,
                0.9568270584369879,
                0.9793911434299206,
                0.9938374436443865,
                1.0,
            ],
            "weights": [
                0.0016806722689073055,
                0.010339473314540194,
                0.018531393476280997,
                0.02656539533077772,
                0.03437866789040993,
                0.041906918204587,
                0.04908786343721927,
                0.05586202988903645,
                0.0621732958153803,
                0.0679693688733004,
                0.07320222327402046,
                0.0778284991335113,
                0.08180986233584706,
                0.08511332243732662,
                0.0877115061590716,
                0.08958288427371616,
                0.09071195003682318,
                0.09108934769848974,
                0.09071195003682186,
                0.08958288427371745,
                0.08771150615907168,
                0.08511332243732604,
                0.08180986233584744,
                0.07782849913351199,
                0.07320222327401886,
                0.06796936887329859,
                0.06217329581537958,
                0.05586202988903643,
                0.04908786343721831,
                0.04190691820458752,
                0.034378667890410594,
                0.026565395330778112,
                0.01853139347628179,
                0.010339473314540434,
                0.0016806722689075115,
            ],
            "generator": "gauss_lobatto",
        },
        36: {
            "degree": 69,
            "points": [
                -0.9999999999999996,
                -0.9941794754731226,
                -0.9805323512825288,
                -0.9592091158687341,
                -0.9303783239829384,
                -0.8942659119856151,
                -0.8511545934025411,
                -0.8013818044645713,
                -0.745337098771728,
                -0.683459109150045,
                -0.6162321186039119,
                -0.5441822717404141,
                -0.46787345770806965,
                -0.3879028973660359,
                -0.3048964694170535,
                -0.21950381216926784,
                -0.13239323930266078,
                -0.04424650945144992,
                0.04424650945145092,
                0.132393239302661,
                0.21950381216926862,
                0.30489646941705406,
                0.38790289736603645,
                0.4678734577080701,
                0.5441822717404152,
                0.6162321186039124,
                0.6834591091500459,
                0.745337098771729,
                0.8013818044645715,
                0.8511545934025422,
                0.8942659119856163,
                0.9303783239829392,
                0.9592091158687353,
                0.9805323512825298,
                0.9941794754731239,
                1.0,
            ],
            "weights": [
                0.001587301587301344,
                0.009766174271023944,
                0.017508591322166284,
                0.025109861490694618,
                0.03251404642810497,
                0.03966362350512335,
                0.0465027306829876,
                0.05297787087074807,
                0.059038377820917164,
                0.06463682437207552,
                0.06972939725684088,
                0.07427624131547554,
                0.07824177195418117,
                0.08159495388397926,
                0.08430954413049296,
                0.0863642974805055,
                0.08774313278651084,
                0.0884352588408709,
                0.08843525884087183,
                0.08774313278651125,
                0.08636429748050559,
                0.0843095441304918,
                0.08159495388397947,
                0.07824177195418082,
                0.07427624131547453,
                0.06972939725683942,
                0.06463682437207503,
                0.059038377820917316,
                0.052977870870747595,
                0.04650273068298742,
                0.03966362350512482,
                0.03251404642810487,
                0.025109861490694867,
                0.017508591322167512,
                0.009766174271023524,
                0.001587301587301551,
            ],
            "generator": "gauss_lobatto",
        },
        37: {
            "degree": 71,
            "points": [
                -1.0,
                -0.9944938094532614,
                -0.9815814149869773,
                -0.9613997340068479,
                -0.9340997654697045,
                -0.8998839089766069,
                -0.8590055670465144,
                -0.811767418583655,
                -0.7585192115735686,
                -0.6996551837323297,
                -0.6356111473464334,
                -0.5668612641787001,
                -0.4939145356334209,
                -0.4173110346338309,
                -0.3376179072957646,
                -0.2554251740807967,
                -0.17134136155372492,
                -0.0859889971044554,
                -2.220446049250313e-16,
                0.0859889971044554,
                0.1713413615537258,
                0.2554251740807968,
                0.337617907295765,
                0.417311034633831,
                0.49391453563342114,
                0.5668612641787001,
                0.6356111473464341,
                0.6996551837323295,
                0.7585192115735685,
                0.8117674185836551,
                0.8590055670465145,
                0.8998839089766071,
                0.934099765469705,
                0.9613997340068481,
                0.9815814149869772,
                0.9944938094532618,
                1.0,
            ],
            "weights": [
                0.0015015015015008588,
                0.009239243242842431,
                0.016568023462079494,
                0.02377024458155186,
                0.030795943408698567,
                0.037593506203915626,
                0.044112694216875685,
                0.05030526831504403,
                0.0561253907738756,
                0.06152997571648578,
                0.06647901153469894,
                0.07093585836445172,
                0.07486751986271846,
                0.07824488772885185,
                0.08104295732250316,
                0.08324101284579222,
                0.0848227807462066,
                0.08577655021710043,
                0.08609525990961506,
                0.08577655021709886,
                0.08482278074620764,
                0.08324101284579113,
                0.08104295732250393,
                0.0782448877288513,
                0.0748675198627178,
                0.07093585836445347,
                0.06647901153469772,
                0.061529975716485996,
                0.05612539077387593,
                0.05030526831504169,
                0.044112694216875685,
                0.037593506203916965,
                0.030795943408698078,
                0.02377024458155144,
                0.016568023462080778,
                0.009239243242841994,
                0.0015015015015014766,
            ],
            "generator": "gauss_lobatto",
        },
        38: {
            "degree": 73,
            "points": [
                -1.0,
                -0.9947833567954518,
                -0.9825479851985308,
                -0.9634188501435599,
                -0.9375316261398194,
                -0.9050681587972305,
                -0.866256232025671,
                -0.8213681119614868,
                -0.7707186690596928,
                -0.7146631790303801,
                -0.6535948342789091,
                -0.5879419873705343,
                -0.5181651471005366,
                -0.44475374868284323,
                -0.3682227208880473,
                -0.28910887428658505,
                -0.20796713596695948,
                -0.12536665715776873,
                -0.0418868210653518,
                0.04188682106535224,
                0.12536665715776896,
                0.20796713596695948,
                0.28910887428658516,
                0.3682227208880472,
                0.4447537486828437,
                0.5181651471005366,
                0.5879419873705343,
                0.6535948342789093,
                0.7146631790303807,
                0.7707186690596928,
                0.8213681119614873,
                0.8662562320256718,
                0.9050681587972305,
                0.9375316261398197,
                0.9634188501435608,
                0.9825479851985306,
                0.9947833567954523,
                1.0,
            ],
            "weights": [
                0.0014224751066849836,
                0.008753813994360657,
                0.015701121356299405,
                0.022534606874418803,
                0.029209520950421727,
                0.0356794246861418,
                0.04189901971649269,
                0.04782470528819648,
                0.05341492637206182,
                0.058630475628249204,
                0.06343477166386895,
                0.0677941168024437,
                0.07167793392996945,
                0.07505898118723536,
                0.07791354315625747,
                0.08022159726051421,
                0.08196695423783563,
                0.0831373717125468,
                0.0837246400760005,
                0.08372464007600114,
                0.08313737171254802,
                0.08196695423783446,
                0.08022159726051471,
                0.07791354315625713,
                0.075058981187236,
                0.07167793392997057,
                0.06779411680244297,
                0.06343477166386799,
                0.05863047562824852,
                0.05341492637206124,
                0.04782470528819554,
                0.04189901971649322,
                0.03567942468614232,
                0.02920952095042165,
                0.02253460687441873,
                0.01570112135630039,
                0.008753813994360322,
                0.001422475106685603,
            ],
            "generator": "gauss_lobatto",
        },
        39: {
            "degree": 75,
            "points": [
                -1.0,
                -0.9950506561214778,
                -0.9834404825028547,
                -0.9652838770764751,
                -0.940703089395317,
                -0.9098619521802849,
                -0.8729657801795874,
                -0.8302601382070922,
                -0.7820292371494686,
                -0.7285940516231288,
                -0.6703101872063528,
                -0.6075655152952963,
                -0.5407775925050782,
                -0.4703908822090559,
                -0.3968737968734275,
                -0.32071558094263786,
                -0.242423055053562,
                -0.1625172432622235,
                -0.08152990573732777,
                -4.440892098500626e-16,
                0.08152990573732732,
                0.16251724326222394,
                0.242423055053562,
                0.3207155809426385,
                0.3968737968734276,
                0.47039088220905567,
                0.5407775925050782,
                0.6075655152952967,
                0.6703101872063535,
                0.7285940516231298,
                0.7820292371494688,
                0.8302601382070925,
                0.8729657801795878,
                0.9098619521802851,
                0.9407030893953174,
                0.9652838770764764,
                0.9834404825028542,
                0.9950506561214784,
                1.0,
            ],
            "weights": [
                0.0013495276653164917,
                0.008305642007788614,
                0.014900402058705855,
                0.021392502271215356,
                0.027741757700206753,
                0.03390627632120794,
                0.03984511333756594,
                0.04551877069876376,
                0.05088950006012325,
                0.05592156393730749,
                0.06058147661178939,
                0.06483822808904008,
                0.06866349092101105,
                0.07203180892524,
                0.07492076669049709,
                0.0773111387985265,
                0.07918701779350211,
                0.0805359200589121,
                0.08134886890277734,
                0.08162045430100735,
                0.08134886890277566,
                0.08053592005891162,
                0.07918701779350226,
                0.0773111387985265,
                0.07492076669049753,
                0.07203180892523976,
                0.06866349092101007,
                0.06483822808903905,
                0.06058147661178866,
                0.05592156393730738,
                0.05088950006012302,
                0.04551877069876371,
                0.039845113337566816,
                0.03390627632120784,
                0.027741757700206825,
                0.021392502271216137,
                0.014900402058706342,
                0.008305642007788374,
                0.0013495276653171023,
            ],
            "generator": "gauss_lobatto",
        },
        40: {
            "degree": 77,
            "points": [
                -1.0000000000000004,
                -0.9952979292443482,
                -0.9842662807175038,
                -0.9670100764879872,
                -0.9436397649436012,
                -0.9143033396902092,
                -0.8791863434793392,
                -0.8385108227781062,
                -0.792533952601552,
                -0.7415464191473844,
                -0.6858705850843136,
                -0.6258584527552575,
                -0.5618894392947227,
                -0.49436797812525324,
                -0.42372096215555044,
                -0.3503950449141806,
                -0.2748538167143242,
                -0.19757487371891091,
                -0.11904679844497146,
                -0.03976607080218186,
                0.039766070802182085,
                0.11904679844497135,
                0.19757487371891047,
                0.27485381671432474,
                0.3503950449141806,
                0.4237209621555508,
                0.4943679781252538,
                0.5618894392947227,
                0.6258584527552575,
                0.6858705850843136,
                0.7415464191473844,
                0.7925339526015521,
                0.8385108227781064,
                0.8791863434793399,
                0.9143033396902095,
                0.9436397649436017,
                0.9670100764879885,
                0.9842662807175034,
                0.9952979292443489,
                1.0,
            ],
            "weights": [
                0.0012820512820502347,
                0.007891011588600876,
                0.014159307549920593,
                0.020334759063385385,
                0.026381190653141443,
                0.03226071792711726,
                0.03793624370070843,
                0.04337190819475923,
                0.048533353845913646,
                0.05338795197149415,
                0.05790501198178654,
                0.06205597647571128,
                0.06581460222289426,
                0.0691571262760815,
                0.07206241630205483,
                0.0745121042353899,
                0.07649070243339576,
                0.0779857016086813,
                0.07898764992536395,
                0.0794902127615483,
                0.07949021276154873,
                0.0789876499253654,
                0.07798570160868043,
                0.07649070243339645,
                0.07451210423538966,
                0.0720624163020541,
                0.06915712627608069,
                0.0658146022228953,
                0.062055976475709915,
                0.057905011981786166,
                0.05338795197149426,
                0.04853335384591444,
                0.0433719081947583,
                0.0379362437007086,
                0.032260717927117245,
                0.026381190653141425,
                0.020334759063386953,
                0.014159307549919953,
                0.007891011588600677,
                0.0012820512820512478,
            ],
            "generator": "gauss_lobatto",
        },
        41: {
            "degree": 79,
            "points": [
                -0.9999999999999998,
                -0.995527127445283,
                -0.985031859124724,
                -0.9686108695676807,
                -0.9463641996474916,
                -0.9184258706979032,
                -0.8849639721696145,
                -0.8461797721039912,
                -0.8023065339580921,
                -0.7536081218869508,
                -0.7003774167806822,
                -0.6429345560645847,
                -0.5816250089152133,
                -0.516817498847129,
                -0.44890178631482835,
                -0.37828632473108326,
                -0.30539580402944577,
                -0.23066859655953054,
                -0.15455412068383967,
                -0.07751013793625461,
                -2.220446049250313e-16,
                0.07751013793625439,
                0.15455412068383967,
                0.23066859655953065,
                0.30539580402944555,
                0.37828632473108337,
                0.4489017863148289,
                0.5168174988471295,
                0.5816250089152128,
                0.6429345560645856,
                0.7003774167806831,
                0.7536081218869515,
                0.8023065339580919,
                0.8461797721039919,
                0.8849639721696151,
                0.9184258706979039,
                0.9463641996474922,
                0.9686108695676819,
                0.9850318591247248,
                0.9955271274452844,
                1.0,
            ],
            "weights": [
                0.0012195121951215564,
                0.007506658762851599,
                0.013472071094472465,
                0.01935329856624883,
                0.025117698393601274,
                0.030730929097921935,
                0.03615930344468951,
                0.04137019615557334,
                0.04633227634865298,
                0.05101570494798649,
                0.05539231691891452,
                0.059435791663545005,
                0.06312181172754994,
                0.06642820923284208,
                0.06933509928709346,
                0.07182499961976338,
                0.0738829357473907,
                0.07549653104591687,
                0.07665608119331785,
                0.07735461253730637,
                0.07758792403848082,
                0.07735461253730558,
                0.07665608119331647,
                0.07549653104591802,
                0.07388293574738915,
                0.0718249996197635,
                0.06933509928709451,
                0.06642820923284301,
                0.06312181172755009,
                0.059435791663543874,
                0.05539231691891444,
                0.05101570494798653,
                0.046332276348652154,
                0.04137019615557266,
                0.0361593034446895,
                0.030730929097922362,
                0.025117698393601073,
                0.019353298566251457,
                0.013472071094470782,
                0.007506658762851589,
                0.0012195121951219241,
            ],
            "generator": "gauss_lobatto",
        },
        42: {
            "degree": 81,
            "points": [
                -1.0,
                -0.9957399700535154,
                -0.9857429295066997,
                -0.9700980966277575,
                -0.9488963054454349,
                -0.9222592142586157,
                -0.890339459837991,
                -0.8533198987206501,
                -0.8114125857934222,
                -0.7648575674264755,
                -0.7139215093148017,
                -0.6588961702025957,
                -0.6000967312486398,
                -0.5378599909625932,
                -0.47254243619484826,
                -0.4045182002915355,
                -0.33417692013945954,
                -0.2619215043901497,
                -0.1881658256541514,
                -0.11333234988865404,
                -0.03784971655960345,
                0.03784971655960401,
                0.1133323498886546,
                0.1881658256541514,
                0.2619215043901503,
                0.33417692013945954,
                0.40451820029153573,
                0.4725424361948476,
                0.5378599909625932,
                0.6000967312486392,
                0.6588961702025954,
                0.7139215093148015,
                0.7648575674264753,
                0.811412585793422,
                0.8533198987206503,
                0.8903394598379915,
                0.9222592142586162,
                0.9488963054454345,
                0.9700980966277577,
                0.9857429295066996,
                0.9957399700535162,
                1.0,
            ],
            "weights": [
                0.0011614401858298846,
                0.00714970697246629,
                0.012833605558315928,
                0.01844098304466301,
                0.023942318410790798,
                0.029306411216165038,
                0.03450260439911598,
                0.039501155201751424,
                0.044273440030291204,
                0.04879212696038049,
                0.05303133493815715,
                0.05696678298379147,
                0.060575929662545144,
                0.06383810237579704,
                0.06673461585680364,
                0.0692488792419391,
                0.07136649112534915,
                0.07307532206227162,
                0.0743655840531927,
                0.07522988661327033,
                0.0756632791071119,
                0.07566327910711226,
                0.07522988661327157,
                0.0743655840531937,
                0.07307532206227094,
                0.07136649112535047,
                0.06924887924193932,
                0.06673461585680315,
                0.06383810237579648,
                0.060575929662543694,
                0.05696678298379048,
                0.05303133493815706,
                0.04879212696038089,
                0.04427344003028919,
                0.03950115520175152,
                0.03450260439911665,
                0.029306411216165635,
                0.023942318410790545,
                0.01844098304466608,
                0.01283360555831394,
                0.007149706972466681,
                0.001161440185830397,
            ],
            "generator": "gauss_lobatto",
        },
        43: {
            "degree": 83,
            "points": [
                -0.9999999999999998,
                -0.9959379767577774,
                -0.9864045426359749,
                -0.9714822350476839,
                -0.9512537193273729,
                -0.9258296828530972,
                -0.8953490419129551,
                -0.8599782931837545,
                -0.8199106291389544,
                -0.7753648902993537,
                -0.7265843726756209,
                -0.673835500076456,
                -0.6174063695019647,
                -0.5576051779105533,
                -0.49475853908846523,
                -0.4292096998740931,
                -0.36131666550730546,
                -0.2914502443563456,
                -0.21999202270862672,
                -0.14733228069044024,
                -0.07386786070041196,
                0.0,
                0.07386786070041218,
                0.14733228069044046,
                0.2199920227086275,
                0.29145024435634537,
                0.3613166655073057,
                0.4292096998740932,
                0.49475853908846557,
                0.557605177910554,
                0.6174063695019647,
                0.6738355000764562,
                0.7265843726756215,
                0.775364890299354,
                0.8199106291389553,
                0.8599782931837554,
                0.8953490419129557,
                0.9258296828530976,
                0.9512537193273735,
                0.971482235047684,
                0.9864045426359751,
                0.9959379767577786,
                1.0,
            ],
            "weights": [
                0.0011074197120705305,
                0.006817613198072248,
                0.012239409664142054,
                0.017591487668265352,
                0.02284709255902933,
                0.027977816257611317,
                0.03295570132754061,
                0.037753579888411784,
                0.04234525488384265,
                0.04670565131289933,
                0.05081095570337967,
                0.0546387470869538,
                0.058168119828087776,
                0.06137979797082086,
                0.06425624059834757,
                0.06678173767706903,
                0.06894249588194447,
                0.07072671394360507,
                0.07212464711025988,
                0.073128660374638,
                0.0737332701764223,
                0.07393517435317522,
                0.07373327017642209,
                0.07312866037463615,
                0.07212464711026033,
                0.070726713943605,
                0.06894249588194354,
                0.0667817376770684,
                0.06425624059834699,
                0.06137979797082129,
                0.05816811982808717,
                0.05463874708695354,
                0.050810955703379554,
                0.04670565131289886,
                0.042345254883842054,
                0.037753579888412166,
                0.03295570132754239,
                0.027977816257611407,
                0.022847092559028562,
                0.017591487668268034,
                0.01223940966413969,
                0.0068176131980728786,
                0.0011074197120708336,
            ],
            "generator": "gauss_lobatto",
        },
        44: {
            "degree": 85,
            "points": [
                -1.0,
                -0.9961224947867908,
                -0.9870211779298328,
                -0.9727725830081109,
                -0.9534521073830771,
                -0.9291606758841531,
                -0.9000249890978194,
                -0.866196967976935,
                -0.8278529854196253,
                -0.785192953804879,
                -0.7384392852928585,
                -0.6878357333265439,
                -0.6336461222985281,
                -0.5761529723338654,
                -0.5156560264891148,
                -0.4524706881028382,
                -0.38692637647101114,
                -0.3193648094333641,
                -0.2501382218313948,
                -0.17960752912999634,
                -0.10814044577895632,
                -0.03610956812562138,
                0.03610956812562216,
                0.10814044577895732,
                0.17960752912999645,
                0.2501382218313948,
                0.31936480943336487,
                0.3869263764710109,
                0.4524706881028384,
                0.515656026489115,
                0.5761529723338651,
                0.633646122298529,
                0.6878357333265442,
                0.7384392852928585,
                0.7851929538048794,
                0.8278529854196253,
                0.8661969679769357,
                0.9000249890978201,
                0.9291606758841535,
                0.9534521073830775,
                0.9727725830081103,
                0.9870211779298332,
                0.9961224947867913,
                1.0,
            ],
            "weights": [
                0.001057082452430774,
                0.006508122621475179,
                0.011685488970919708,
                0.016799192269920687,
                0.02182493585715388,
                0.026736800540116658,
                0.0315092399671937,
                0.03611739155267959,
                0.04053723748539347,
                0.04474573772625405,
                0.048720952535292926,
                0.05244215772759526,
                0.055889953075828426,
                0.05904636361377699,
                0.06189493342676114,
                0.06442081148488141,
                0.06661082909097442,
                0.0684535685482751,
                0.0699394226941603,
                0.07106064499173026,
                0.07181138991931241,
                0.07218774344787242,
                0.0721877434478727,
                0.07181138991931305,
                0.07106064499173204,
                0.06993942269415905,
                0.06845356854827521,
                0.06661082909097477,
                0.0644208114848825,
                0.061894933426761604,
                0.059046363613777894,
                0.05588995307582642,
                0.052442157727594536,
                0.04872095253529272,
                0.044745737726253836,
                0.04053723748539335,
                0.03611739155267989,
                0.03150923996719514,
                0.026736800540116536,
                0.02182493585715324,
                0.016799192269922006,
                0.011685488970917307,
                0.006508122621476107,
                0.0010570824524312576,
            ],
            "generator": "gauss_lobatto",
        },
        45: {
            "degree": 87,
            "points": [
                -1.0,
                -0.9962947218690874,
                -0.9875968192413058,
                -0.9739774150069722,
                -0.9555054226081019,
                -0.9322730566055355,
                -0.9043961132643066,
                -0.8720134941424478,
                -0.8352865366599902,
                -0.7943982170703006,
                -0.7495522413180629,
                -0.7009720311947056,
                -0.6488996117247845,
                -0.5935944056396347,
                -0.5353319410686916,
                -0.47440247894089627,
                -0.4111095669597429,
                -0.3457685273686695,
                -0.27870488604725474,
                -0.21025275076806804,
                -0.1407531466956935,
                -0.07055231742162427,
                -2.220446049250313e-16,
                0.07055231742162404,
                0.14075314669569328,
                0.21025275076806849,
                0.2787048860472543,
                0.34576852736866914,
                0.4111095669597433,
                0.4744024789408958,
                0.5353319410686919,
                0.5935944056396343,
                0.6488996117247848,
                0.7009720311947063,
                0.7495522413180637,
                0.7943982170703012,
                0.8352865366599911,
                0.8720134941424482,
                0.9043961132643066,
                0.9322730566055358,
                0.9555054226081031,
                0.9739774150069719,
                0.9875968192413066,
                0.9962947218690885,
                1.0,
            ],
            "weights": [
                0.0010101010101005055,
                0.006219230315747298,
                0.01116828899658673,
                0.016059089495837536,
                0.0208695247163971,
                0.025575899418151773,
                0.030154825753535328,
                0.03458350960798901,
                0.038839894146311574,
                0.04290277713113667,
                0.046751918850698355,
                0.050368143785247566,
                0.05373343647877131,
                0.05683103144363149,
                0.059645496759154204,
                0.06216281099064491,
                0.06437043306403449,
                0.06625736475653969,
                0.06781420549608144,
                0.06903319919860183,
                0.06990827291101666,
                0.07043506706792801,
                0.07061095721171447,
                0.07043506706792817,
                0.06990827291101517,
                0.06903319919860068,
                0.06781420549608276,
                0.0662573647565398,
                0.06437043306403467,
                0.06216281099064431,
                0.05964549675915403,
                0.05683103144363009,
                0.05373343647877092,
                0.05036814378524768,
                0.04675191885069797,
                0.0429027771311375,
                0.03883989414631067,
                0.03458350960798987,
                0.03015482575353612,
                0.025575899418151977,
                0.020869524716397168,
                0.01605908949583748,
                0.011168288996584968,
                0.006219230315748654,
                0.0010101010101009748,
            ],
            "generator": "gauss_lobatto",
        },
        46: {
            "degree": 89,
            "points": [
                -1.0000000000000007,
                -0.9964557257048161,
                -0.9881350191822105,
                -0.9751041139968077,
                -0.9574261243113946,
                -0.9351854736066143,
                -0.9084882001398755,
                -0.8774615477240353,
                -0.8422533809366424,
                -0.8030314869289465,
                -0.7599827781733286,
                -0.7133124027041122,
                -0.663242766935862,
                -0.6100124760154941,
                -0.5538751968769602,
                -0.4950984494683952,
                -0.43396233193629863,
                -0.3707581858539353,
                -0.30578720786106084,
                -0.2393590143346418,
                -0.17179016593254381,
                -0.10340265904261181,
                -0.03452239132679624,
                0.034522391326796575,
                0.10340265904261248,
                0.17179016593254426,
                0.2393590143346418,
                0.30578720786106117,
                0.37075818585393594,
                0.4339623319362992,
                0.4950984494683952,
                0.5538751968769603,
                0.6100124760154937,
                0.663242766935862,
                0.713312402704112,
                0.7599827781733288,
                0.8030314869289463,
                0.8422533809366428,
                0.8774615477240354,
                0.9084882001398751,
                0.9351854736066139,
                0.9574261243113948,
                0.9751041139968067,
                0.9881350191822104,
                0.9964557257048159,
                1.0,
            ],
            "weights": [
                0.0009661835748780855,
                0.005949148745438412,
                0.010684638400134323,
                0.015366706580524319,
                0.019975201401607922,
                0.02448841961665932,
                0.028884910179304238,
                0.03314373889358559,
                0.0372446168543982,
                0.04116800424121192,
                0.04489520563290749,
                0.048408459896685206,
                0.05169102515322005,
                0.0547272587051992,
                0.057502691652411675,
                0.06000409787893679,
                0.06221955710126772,
                0.06413851168504207,
                0.06575181696351802,
                0.06705178482003046,
                0.06803222032783275,
                0.06868845127326932,
                0.06901735042193517,
                0.06901735042193537,
                0.06868845127326895,
                0.06803222032783444,
                0.06705178482003137,
                0.06575181696351673,
                0.06413851168504194,
                0.062219557101267114,
                0.060004097878936354,
                0.05750269165241196,
                0.054727258705199254,
                0.05169102515321989,
                0.04840845989668536,
                0.044895205632908525,
                0.04116800424121122,
                0.037244616854397575,
                0.0331437388935859,
                0.028884910179304075,
                0.02448841961665947,
                0.019975201401608803,
                0.015366706580523195,
                0.010684638400132935,
                0.005949148745440329,
                0.0009661835748791924,
            ],
            "generator": "gauss_lobatto",
        },
        47: {
            "degree": 91,
            "points": [
                -1.0000000000000004,
                -0.9966064605421205,
                -0.9886389539180824,
                -0.9761592840697177,
                -0.9592253655069964,
                -0.9379146359386448,
                -0.9123243805586378,
                -0.8825713801553439,
                -0.8487913989291835,
                -0.8111385712065888,
                -0.7697847003900826,
                -0.7249184759811489,
                -0.6767446130563572,
                -0.6254829184098469,
                -0.571367287737131,
                -0.5146446384854091,
                -0.45557378326275444,
                -0.394424248958094,
                -0.3314750469661447,
                -0.2670134001317952,
                -0.20133343222450995,
                -0.1347348259235066,
                -0.0675214554377146,
                0.0,
                0.0675214554377147,
                0.13473482592350683,
                0.2013334322245096,
                0.26701340013179564,
                0.33147504696614505,
                0.394424248958094,
                0.45557378326275433,
                0.5146446384854091,
                0.5713672877371305,
                0.6254829184098465,
                0.6767446130563572,
                0.7249184759811486,
                0.769784700390082,
                0.811138571206589,
                0.8487913989291839,
                0.882571380155344,
                0.9123243805586378,
                0.9379146359386448,
                0.9592253655069967,
                0.9761592840697171,
                0.9886389539180827,
                0.9966064605421207,
                1.0,
            ],
            "weights": [
                0.0009250693802026408,
                0.005696280091590314,
                0.010231700532575227,
                0.014718038492395913,
                0.019136892105083056,
                0.023468346462881397,
                0.027692692211754886,
                0.03179067098267996,
                0.03574359071866286,
                0.03953341776641556,
                0.043142861264354446,
                0.04655545279940325,
                0.04975562185987929,
                0.05272876701974544,
                0.05546132262903431,
                0.05794082074554302,
                0.06015594804198213,
                0.06209659743677947,
                0.06375391421662621,
                0.06512033644232137,
                0.06618962945451227,
                0.06695691432250418,
                0.06741869010664191,
                0.0675728498328651,
                0.06741869010664214,
                0.06695691432250363,
                0.06618962945451018,
                0.0651203364423209,
                0.0637539142166271,
                0.062096597436779005,
                0.06015594804198303,
                0.05794082074554338,
                0.055461322629035345,
                0.05272876701974361,
                0.04975562185987901,
                0.046555452799402874,
                0.04314286126435438,
                0.039533417766413434,
                0.03574359071866342,
                0.031790670982680416,
                0.02769269221175473,
                0.02346834646288136,
                0.01913689210508394,
                0.014718038492394843,
                0.010231700532574694,
                0.005696280091592218,
                0.0009250693802034867,
            ],
            "generator": "gauss_lobatto",
        },
        48: {
            "degree": 93,
            "points": [
                -1.0000000000000004,
                -0.9967477813398571,
                -0.9891114700136354,
                -0.9771488468908365,
                -0.9609131535063815,
                -0.9404755493350812,
                -0.9159254499762464,
                -0.88737022431822,
                -0.8549347448387739,
                -0.8187608474856054,
                -0.7790067135998435,
                -0.7358461791128483,
                -0.6894679748110906,
                -0.6400749012659566,
                -0.5878829421454856,
                -0.533120319832777,
                -0.4760264975028574,
                -0.41685113203270285,
                -0.3558529823289065,
                -0.29329877784975933,
                -0.22946205227124516,
                -0.16462194739809055,
                -0.0990619925507501,
                -0.033068864766153006,
                0.033068864766152894,
                0.09906199255075032,
                0.16462194739809033,
                0.22946205227124472,
                0.2932987778497591,
                0.35585298232890583,
                0.4168511320327025,
                0.47602649750285697,
                0.533120319832777,
                0.5878829421454851,
                0.6400749012659571,
                0.6894679748110907,
                0.7358461791128483,
                0.7790067135998437,
                0.8187608474856058,
                0.8549347448387741,
                0.8873702243182201,
                0.9159254499762465,
                0.9404755493350813,
                0.9609131535063816,
                0.9771488468908367,
                0.9891114700136358,
                0.9967477813398574,
                1.0,
            ],
            "weights": [
                0.0008865248226942032,
                0.0054591926002461105,
                0.009806931978900714,
                0.014109490605489383,
                0.01835003647521908,
                0.022510263736936046,
                0.02657203259091026,
                0.030517597621303093,
                0.03432971170067397,
                0.037991707926729006,
                0.04148757451884792,
                0.04480202556407162,
                0.04792056815673644,
                0.05082956590594581,
                0.05351629862867557,
                0.05596901800514879,
                0.058176998969275466,
                0.06013058661684382,
                0.06182123842997968,
                0.0632415616350388,
                0.06438534553159984,
                0.06524758865172484,
                0.06582452063100816,
                0.06611361869600096,
                0.06611361869600128,
                0.0658245206310075,
                0.06524758865172517,
                0.0643853455316017,
                0.06324156163503898,
                0.061821238429979206,
                0.06013058661684449,
                0.05817699896927495,
                0.055969018005149015,
                0.05351629862867491,
                0.05082956590594475,
                0.04792056815673556,
                0.04480202556407183,
                0.04148757451884714,
                0.037991707926728076,
                0.03432971170067398,
                0.030517597621303634,
                0.026572032590911118,
                0.022510263736935994,
                0.018350036475219256,
                0.014109490605488526,
                0.00980693197890024,
                0.0054591926002480464,
                0.0008865248226950093,
            ],
            "generator": "gauss_lobatto",
        },
        49: {
            "degree": 95,
            "points": [
                -1.0,
                -0.9968804559100228,
                -0.9895551246192305,
                -0.9780781245013712,
                -0.9624984879932525,
                -0.9428817196631991,
                -0.9193101442725842,
                -0.8918826460264422,
                -0.860714272804789,
                -0.8259357592850698,
                -0.7876929806436532,
                -0.7461463415517791,
                -0.7014701037710522,
                -0.6538516554322118,
                -0.6034907251667667,
                -0.5505985444332273,
                -0.49539696157275226,
                -0.4381175113207414,
                -0.379000443682769,
                -0.3182937162511015,
                -0.25625195419014557,
                -0.1931353822540205,
                -0.1292087333163796,
                -0.06474013799089895,
                0.0,
                0.06474013799089917,
                0.1292087333163796,
                0.19313538225402027,
                0.2562519541901457,
                0.3182937162511015,
                0.3790004436827691,
                0.43811751132074184,
                0.49539696157275237,
                0.5505985444332279,
                0.6034907251667666,
                0.6538516554322125,
                0.7014701037710529,
                0.7461463415517796,
                0.7876929806436541,
                0.8259357592850708,
                0.8607142728047894,
                0.8918826460264424,
                0.9193101442725846,
                0.9428817196631998,
                0.9624984879932527,
                0.978078124501372,
                0.9895551246192308,
                0.996880455910023,
                1.0,
            ],
            "weights": [
                0.0008503401360541496,
                0.005236600299775808,
                0.009408046962855644,
                0.013537829381582014,
                0.01761052681678417,
                0.021609284240821796,
                0.02551737916713599,
                0.029318434709842505,
                0.0329965135057254,
                0.03653619081337669,
                0.03992262114358968,
                0.04314160122701746,
                0.0461796298735573,
                0.049023964729225954,
                0.0516626757839648,
                0.054084695442134775,
                0.05627986496113626,
                0.05823897707049075,
                0.05995381459610495,
                0.061417184929447095,
                0.06262295019803378,
                0.06356605301118765,
                0.06424253767338935,
                0.06464956677640539,
                0.06478543310072353,
                0.06464956677640567,
                0.06424253767338964,
                0.06356605301118702,
                0.0626229501980317,
                0.061417184929446436,
                0.05995381459610534,
                0.05823897707049041,
                0.056279864961135795,
                0.054084695442134775,
                0.05166267578396437,
                0.049023964729225655,
                0.04617962987355725,
                0.04314160122701657,
                0.039922621143590055,
                0.036536190813376834,
                0.03299651350572506,
                0.02931843470984285,
                0.025517379167136728,
                0.02160928424082193,
                0.017610526816783278,
                0.013537829381581584,
                0.00940804696285555,
                0.005236600299777707,
                0.0008503401360544015,
            ],
            "generator": "gauss_lobatto",
        },
        50: {
            "degree": 97,
            "points": [
                -1.0,
                -0.9970051753626434,
                -0.9899722200580205,
                -0.9789519106467195,
                -0.963989480109968,
                -0.9451453286808815,
                -0.922495378502753,
                -0.8961308490768325,
                -0.8661579081773534,
                -0.8326972497964575,
                -0.7958836101177285,
                -0.7558652257940521,
                -0.7128032374236455,
                -0.6668710408790444,
                -0.6182535892015295,
                -0.5671466479156699,
                -0.5137560067830482,
                -0.4582966511792994,
                -0.4009918964363979,
                -0.3420724886388038,
                -0.28177567549590976,
                -0.22034425103305644,
                -0.15802557794840233,
                -0.0950705915726564,
                -0.03173278944262359,
                0.031732789442624254,
                0.09507059157265696,
                0.1580255779484031,
                0.2203442510330571,
                0.28177567549591,
                0.342072488638804,
                0.40099189643639865,
                0.45829665117929996,
                0.5137560067830487,
                0.5671466479156704,
                0.6182535892015293,
                0.6668710408790448,
                0.7128032374236459,
                0.755865225794053,
                0.7958836101177286,
                0.8326972497964579,
                0.8661579081773534,
                0.8961308490768326,
                0.9224953785027528,
                0.9451453286808814,
                0.9639894801099685,
                0.9789519106467198,
                0.9899722200580208,
                0.9970051753626435,
                1.0,
            ],
            "weights": [
                0.0008163265306120334,
                0.005027345549739807,
                0.00903298668689961,
                0.013000139812211271,
                0.01691465548386511,
                0.020760989497015964,
                0.024523701718170168,
                0.028187655451059442,
                0.031738102606570645,
                0.035160749089348665,
                0.038441814210997426,
                0.04156808685236869,
                0.044526978934473396,
                0.04730657622923769,
                0.0498956863933454,
                0.05228388406643235,
                0.054461552866931,
                0.05641992412321,
                0.05815111218747441,
                0.05964814619183297,
                0.06090499811963216,
                0.061916607079484265,
                0.06267889968456795,
                0.06318880645526734,
                0.0634442741792523,
                0.06344427417925261,
                0.06318880645526617,
                0.0626788996845672,
                0.06191660707948542,
                0.06090499811963364,
                0.05964814619183382,
                0.058151112187473895,
                0.05641992412321032,
                0.0544615528669308,
                0.05228388406643337,
                0.04989568639334428,
                0.04730657622923685,
                0.04452697893447285,
                0.0415680868523683,
                0.03844181421099802,
                0.035160749089347576,
                0.03173810260657067,
                0.02818765545106019,
                0.024523701718169706,
                0.020760989497016075,
                0.01691465548386372,
                0.013000139812211558,
                0.009032986686899558,
                0.005027345549741612,
                0.00081632653061223,
            ],
            "generator": "gauss_lobatto",
        },
        51: {
            "degree": 99,
            "points": [
                -0.9999999999999998,
                -0.9971225631189886,
                -0.9903648336875108,
                -0.9797745324095919,
                -0.9653934554758863,
                -0.9472773863088948,
                -0.9254964541441031,
                -0.9001349406832235,
                -0.8712909715312058,
                -0.8390761417977732,
                -0.8036150862456395,
                -0.7650449978835676,
                -0.7235150975511915,
                -0.6791860567905124,
                -0.632229376333391,
                -0.582826722651486,
                -0.5311692251550482,
                -0.4774567367693472,
                -0.42189706075452005,
                -0.3647051467629545,
                -0.3061022592460898,
                -0.24631512142886236,
                -0.18557503816417253,
                -0.1241170010612318,
                -0.06217877935012339,
                4.440892098500626e-16,
                0.06217877935012461,
                0.1241170010612328,
                0.1855750381641731,
                0.24631512142886325,
                0.3061022592460906,
                0.3647051467629555,
                0.4218970607545207,
                0.4774567367693474,
                0.5311692251550486,
                0.5828267226514864,
                0.632229376333392,
                0.6791860567905131,
                0.7235150975511915,
                0.7650449978835683,
                0.8036150862456404,
                0.8390761417977741,
                0.8712909715312062,
                0.9001349406832245,
                0.9254964541441035,
                0.947277386308895,
                0.9653934554758873,
                0.9797745324095921,
                0.9903648336875116,
                0.997122563118989,
                1.0,
            ],
            "weights": [
                0.0007843137254902655,
                0.004830383978506059,
                0.008679892841421781,
                0.012493788584865962,
                0.01625906923461851,
                0.01996137724453707,
                0.02358643492249943,
                0.02712023147367082,
                0.030549100473197813,
                0.0338597785040059,
                0.03703945825317161,
                0.04007583870670486,
                0.042957173003353714,
                0.04567231399903497,
                0.04821075745008038,
                0.05056268268147102,
                0.052718990597057015,
                0.05467133889119828,
                0.05641217432883752,
                0.05793476197073571,
                0.059233211231660594,
                0.06030249867120295,
                0.06113848742933829,
                0.0617379432316867,
                0.06209854690263853,
                0.06221890333802954,
                0.06209854690263866,
                0.06173794323168729,
                0.06113848742933936,
                0.06030249867120208,
                0.05923321123165962,
                0.0579347619707352,
                0.05641217432883747,
                0.05467133889119779,
                0.05271899059705736,
                0.05056268268147102,
                0.04821075745007836,
                0.04567231399903462,
                0.042957173003353506,
                0.04007583870670611,
                0.037039458253170676,
                0.033859778504004685,
                0.030549100473198487,
                0.027120231473672294,
                0.02358643492249854,
                0.019961377244536876,
                0.016259069234617916,
                0.012493788584866883,
                0.008679892841421831,
                0.004830383978507957,
                0.0007843137254901656,
            ],
            "generator": "gauss_lobatto",
        },
        52: {
            "degree": 101,
            "points": [
                -1.0000000000000004,
                -0.9972331827130418,
                -0.9907348437589154,
                -0.9805499036237444,
                -0.9667170435633043,
                -0.9492878629251138,
                -0.9283272394756465,
                -0.903913163015146,
                -0.876136462081327,
                -0.8451004710895298,
                -0.8109206477368027,
                -0.7737241442421421,
                -0.7336493346758826,
                -0.6908453003700719,
                -0.6454712754168925,
                -0.5976960543582577,
                -0.5476973642888849,
                -0.4956612037180561,
                -0.441781150654458,
                -0.3862576424907751,
                -0.3292972303684556,
                -0.2711118107973609,
                -0.2119178373892785,
                -0.15193551563805974,
                -0.09138798374206414,
                -0.030500482516470306,
                0.030500482516470195,
                0.09138798374206414,
                0.15193551563805952,
                0.21191783738927894,
                0.27111181079736113,
                0.3292972303684558,
                0.38625764249077477,
                0.4417811506544578,
                0.49566120371805644,
                0.5476973642888848,
                0.5976960543582575,
                0.6454712754168925,
                0.6908453003700721,
                0.7336493346758824,
                0.7737241442421412,
                0.8109206477368027,
                0.8451004710895305,
                0.8761364620813271,
                0.9039131630151457,
                0.9283272394756471,
                0.9492878629251136,
                0.9667170435633055,
                0.9805499036237445,
                0.9907348437589159,
                0.9972331827130421,
                1.0,
            ],
            "weights": [
                0.0007541478129708461,
                0.004644771443211413,
                0.008347084648331041,
                0.012016392112301261,
                0.015640729519940198,
                0.0192068156124795,
                0.02270142836492538,
                0.02611158090173833,
                0.02942459217945504,
                0.03262813970356317,
                0.03571030708289076,
                0.0386596289801308,
                0.041465134017019664,
                0.04411638570210733,
                0.04660352131006651,
                0.04891728859991069,
                0.051049080249230126,
                0.05299096588267064,
                0.05473572157854786,
                0.056276856745426436,
                0.05760863826947345,
                0.05872611184328179,
                0.0596251203970193,
                0.06030231956354017,
                0.06075519012000121,
                0.06098204735976709,
                0.06098204735976736,
                0.06075519012000026,
                0.06030231956353923,
                0.05962512039701863,
                0.058726111843282316,
                0.05760863826947398,
                0.056276856745426304,
                0.05473572157854823,
                0.05299096588267037,
                0.05104908024922993,
                0.04891728859990996,
                0.046603521310066454,
                0.04411638570210672,
                0.04146513401701998,
                0.038659628980130735,
                0.035710307082888894,
                0.03262813970356324,
                0.0294245921794552,
                0.02611158090173967,
                0.02270142836492481,
                0.019206815612478195,
                0.015640729519940638,
                0.012016392112302285,
                0.008347084648331123,
                0.0046447714432131006,
                0.0007541478129713295,
            ],
            "generator": "gauss_lobatto",
        },
        53: {
            "degree": 103,
            "points": [
                -0.9999999999999996,
                -0.9973375445638728,
                -0.9910839518755052,
                -0.9812815712962453,
                -0.9679662554532087,
                -0.9511858046110391,
                -0.9310003269769782,
                -0.907482095658755,
                -0.8807153061392734,
                -0.8507957797162504,
                -0.817830622232804,
                -0.7819378413882299,
                -0.743245924631939,
                -0.7018933793761994,
                -0.6580282372628374,
                -0.6118075242973005,
                -0.563396698765007,
                -0.5129690589511442,
                -0.46070512278884457,
                -0.40679198165903196,
                -0.35142263065666524,
                -0.294795277721688,
                -0.237112634108396,
                -0.17858118873344297,
                -0.11941046900038144,
                -0.05981229074692007,
                0.0,
                0.05981229074692007,
                0.11941046900038155,
                0.17858118873344309,
                0.237112634108396,
                0.2947952777216878,
                0.35142263065666457,
                0.40679198165903285,
                0.46070512278884435,
                0.5129690589511446,
                0.5633966987650072,
                0.611807524297301,
                0.6580282372628381,
                0.7018933793761998,
                0.7432459246319393,
                0.7819378413882301,
                0.8178306222328043,
                0.8507957797162506,
                0.8807153061392732,
                0.9074820956587547,
                0.9310003269769785,
                0.9511858046110395,
                0.9679662554532098,
                0.9812815712962456,
                0.991083951875506,
                0.9973375445638732,
                1.0,
            ],
            "weights": [
                0.0007256894049351012,
                0.004469652707676075,
                0.008033038910742306,
                0.011565788706570847,
                0.015056877844863908,
                0.018494003026791703,
                0.021864902617516307,
                0.025157522479674583,
                0.028360080648519696,
                0.03146111484103161,
                0.03444952513682483,
                0.03731461431019576,
                0.04004612636714411,
                0.0426342833683744,
                0.04506982048456819,
                0.04734401918920704,
                0.049448738483355556,
                0.0513764440466635,
                0.053120235213173,
                0.05467386967691389,
                0.05603178583960164,
                0.05718912272091598,
                0.05814173736033174,
                0.058886219648371554,
                0.05941990453425018,
                0.05974088156628943,
                0.0598480017309938,
                0.059740881566289344,
                0.05941990453425089,
                0.058886219648372894,
                0.058141737360332506,
                0.05718912272091497,
                0.056031785839601264,
                0.054673869676913914,
                0.053120235213173,
                0.051376444046663215,
                0.049448738483356014,
                0.047344019189206644,
                0.045069820484567306,
                0.042634283368374305,
                0.04004612636714361,
                0.03731461431019479,
                0.03444952513682364,
                0.03146111484103228,
                0.028360080648519907,
                0.025157522479674337,
                0.021864902617516606,
                0.018494003026789708,
                0.015056877844865849,
                0.01156578870657179,
                0.008033038910742309,
                0.004469652707677453,
                0.0007256894049346778,
            ],
            "generator": "gauss_lobatto",
        },
        54: {
            "degree": 105,
            "points": [
                -1.0,
                -0.997436111871167,
                -0.9914137025514906,
                -0.9819727560638516,
                -0.9691465516626505,
                -0.9529794338078292,
                -0.9335271710159854,
                -0.9108568330676181,
                -0.8850465753956878,
                -0.8561853743252543,
                -0.8243727220345489,
                -0.7897182842797661,
                -0.7523415226729762,
                -0.7123712830314939,
                -0.669945351303662,
                -0.6252099786392122,
                -0.5783193772588702,
                -0.529435188869728,
                -0.47872592746342457,
                -0.4263663984204309,
                -0.37253709592431905,
                -0.3174235807640926,
                -0.2612158406699432,
                -0.20410763538779864,
                -0.1462958287505376,
                -0.08797971004849336,
                -0.029360307038717837,
                0.029360307038717726,
                0.08797971004849292,
                0.14629582875053793,
                0.20410763538779875,
                0.26121584066994286,
                0.3174235807640925,
                0.37253709592431916,
                0.4263663984204308,
                0.47872592746342413,
                0.5294351888697277,
                0.5783193772588704,
                0.6252099786392118,
                0.6699453513036615,
                0.7123712830314941,
                0.7523415226729762,
                0.7897182842797662,
                0.8243727220345489,
                0.8561853743252541,
                0.8850465753956875,
                0.9108568330676177,
                0.9335271710159847,
                0.9529794338078293,
                0.9691465516626504,
                0.981972756063851,
                0.9914137025514903,
                0.9974361118711665,
                1.0,
            ],
            "weights": [
                0.0006988120195667544,
                0.00430425158446218,
                0.0077363726275994395,
                0.011140014296304724,
                0.014505005478880973,
                0.01781993305212573,
                0.021073410580106092,
                0.024254234983220966,
                0.027351445883032628,
                0.03035436851955376,
                0.03325265213691889,
                0.036036306239565,
                0.038695735266165605,
                0.041221771772643946,
                0.04360570808506711,
                0.04583932634292818,
                0.04791492684196336,
                0.04982535458467816,
                0.05156402394980409,
                0.0531249413971827,
                0.054502726130548414,
                0.05569262864740172,
                0.05669054711227717,
                0.057493041497134155,
                0.05809734544017992,
                0.058501375782316956,
                0.05870373974837218,
                0.058703739748372445,
                0.05850137578231665,
                0.058097345440179186,
                0.05749304149713257,
                0.05669054711227599,
                0.05569262864740177,
                0.05450272613054944,
                0.05312494139718243,
                0.051564023949803466,
                0.049825354584678884,
                0.04791492684196399,
                0.04583932634292603,
                0.043605708085066724,
                0.04122177177264355,
                0.03869573526616485,
                0.03603630623956536,
                0.03325265213691866,
                0.030354368519553494,
                0.02735144588303301,
                0.024254234983220546,
                0.02107341058010671,
                0.01781993305212396,
                0.014505005478883913,
                0.01114001429630515,
                0.00773637262759945,
                0.004304251584463485,
                0.00069881201956673,
            ],
            "generator": "gauss_lobatto",
        },
        55: {
            "degree": 107,
            "points": [
                -1.0,
                -0.9975293057612733,
                -0.9917255002912799,
                -0.9826263875430268,
                -0.9702629014639286,
                -0.9546762374489273,
                -0.93591820858328,
                -0.914051140447173,
                -0.8891476790996726,
                -0.8612905542433056,
                -0.8305723060237145,
                -0.7970949782900671,
                -0.7609697799224486,
                -0.7223167155596153,
                -0.6812641870365539,
                -0.6379485668918294,
                -0.5925137453783147,
                -0.5451106524904481,
                -0.49589675660021126,
                -0.4450355413696867,
                -0.39269596267922147,
                -0.33905188737603176,
                -0.28428151570816396,
                -0.22856678936272767,
                -0.17209278707505016,
                -0.1150471098165915,
                -0.05761925760406417,
                -4.440892098500626e-16,
                0.05761925760406428,
                0.11504710981659161,
                0.17209278707505005,
                0.22856678936272734,
                0.2842815157081635,
                0.33905188737603176,
                0.39269596267922124,
                0.4450355413696869,
                0.49589675660021115,
                0.5451106524904473,
                0.592513745378314,
                0.6379485668918297,
                0.6812641870365532,
                0.7223167155596149,
                0.7609697799224482,
                0.7970949782900661,
                0.8305723060237141,
                0.8612905542433054,
                0.8891476790996722,
                0.9140511404471732,
                0.9359182085832798,
                0.9546762374489277,
                0.9702629014639285,
                0.9826263875430266,
                0.99172550029128,
                0.9975293057612731,
                1.0,
            ],
            "weights": [
                0.0006734006734008287,
                0.004147862328670054,
                0.00745582780352157,
                0.010737281181964724,
                0.01398282690493744,
                0.0171818634922291,
                0.020323803383333568,
                0.023398221250647732,
                0.026394908601619967,
                0.029303912637618872,
                0.03211557084572736,
                0.03482054365059009,
                0.03740984566558146,
                0.03987487564263115,
                0.0422074450936409,
                0.04439980551699236,
                0.04644467415092683,
                0.04833525817387703,
                0.05006527727408618,
                0.05162898451493864,
                0.05302118542745154,
                0.05423725526687359,
                0.05527315437638024,
                0.05612544160686938,
                0.056791285748460034,
                0.05726847493569888,
                0.057555423995304465,
                0.057651179712051664,
                0.05755542399530399,
                0.05726847493569914,
                0.05679128574846041,
                0.05612544160687073,
                0.05527315437638118,
                0.054237255266874354,
                0.05302118542745014,
                0.051628984514939,
                0.050065277274085794,
                0.04833525817387679,
                0.046444674150926055,
                0.04439980551699126,
                0.04220744509364033,
                0.03987487564263076,
                0.037409845665582045,
                0.03482054365059033,
                0.03211557084572653,
                0.029303912637618033,
                0.026394908601620228,
                0.023398221250647822,
                0.020323803383333776,
                0.01718186349222831,
                0.013982826904940238,
                0.010737281181964391,
                0.007455827803521386,
                0.004147862328671053,
                0.0006734006734006708,
            ],
            "generator": "gauss_lobatto",
        },
        56: {
            "degree": 109,
            "points": [
                -0.9999999999999996,
                -0.9976175097907238,
                -0.9920206245418626,
                -0.9832451352964471,
                -0.9713198348916845,
                -0.9562830443137136,
                -0.9381829654068485,
                -0.917077590996499,
                -0.893034533605793,
                -0.8661308131988117,
                -0.8364526120236491,
                -0.8040949991900752,
                -0.7691616264302468,
                -0.7317643962179194,
                -0.6920231033890587,
                -0.6500650514465529,
                -0.6060246447943238,
                -0.5600429582151247,
                -0.5122672849753367,
                -0.4628506650066375,
                -0.41195139467724173,
                -0.35973251972384324,
                -0.3063613129690197,
                -0.2520087384974241,
                -0.1968489040073642,
                -0.14105850309217471,
                -0.08481624923800402,
                -0.028302303351157576,
                0.02830230335115802,
                0.08481624923800435,
                0.14105850309217494,
                0.1968489040073642,
                0.25200873849742433,
                0.30636131296902047,
                0.3597325197238439,
                0.4119513946772422,
                0.46285066500663774,
                0.5122672849753374,
                0.5600429582151253,
                0.6060246447943244,
                0.6500650514465534,
                0.6920231033890591,
                0.7317643962179194,
                0.7691616264302472,
                0.8040949991900752,
                0.8364526120236492,
                0.8661308131988118,
                0.8930345336057935,
                0.9170775909964993,
                0.9381829654068485,
                0.9562830443137147,
                0.9713198348916846,
                0.9832451352964473,
                0.9920206245418629,
                0.9976175097907242,
                1.0,
            ],
            "weights": [
                0.0006493506493512044,
                0.003999842105105392,
                0.007190258142993302,
                0.01035595940326944,
                0.013488256491096405,
                0.016577289173989276,
                0.019613200257610645,
                0.022586276257861516,
                0.025486997771695743,
                0.028306074740683817,
                0.031034477684632952,
                0.033663467159780094,
                0.036184621971785826,
                0.03858986624898963,
                0.04087149535902279,
                0.043022200613338134,
                0.045035092692288156,
                0.04690372372113669,
                0.04862210792893731,
                0.05018474082542113,
                0.05158661683522413,
                0.052823245333322666,
                0.053890665030563195,
                0.05478545666334465,
                0.055504753946864376,
                0.056046252756912336,
                0.05640821851082178,
                0.056589491723958454,
                0.05658949172395885,
                0.056408218510821874,
                0.056046252756911885,
                0.05550475394686371,
                0.054785456663343904,
                0.05389066503056251,
                0.05282324533332147,
                0.051586616835224856,
                0.05018474082542127,
                0.04862210792893696,
                0.046903723721137,
                0.04503509269228796,
                0.04302220061333822,
                0.04087149535902215,
                0.03858986624898964,
                0.03618462197178693,
                0.03366346715977897,
                0.031034477684631204,
                0.02830607474068386,
                0.025486997771695753,
                0.02258627625786245,
                0.019613200257610354,
                0.016577289173989894,
                0.013488256491098836,
                0.010355959403268597,
                0.00719025814299301,
                0.003999842105106364,
                0.000649350649350629,
            ],
            "generator": "gauss_lobatto",
        },
        57: {
            "degree": 111,
            "points": [
                -1.0,
                -0.9977010738972747,
                -0.9923002428155636,
                -0.9838314360258038,
                -0.9723214884484119,
                -0.9578060930787162,
                -0.9403301494268803,
                -0.9199476869958807,
                -0.8967217122548168,
                -0.8707240180636286,
                -0.8420349632716109,
                -0.8107432249553914,
                -0.7769455246084265,
                -0.7407463293221497,
                -0.7022575289593791,
                -0.6615980903512884,
                -0.6188936896024433,
                -0.5742763236482258,
                -0.5278839022693713,
                -0.4798598218269101,
                -0.43035252203635754,
                -0.37951502715187724,
                -0.3275044729790526,
                -0.2744816211785366,
                -0.2206103623619955,
                -0.1660572095164028,
                -0.11099078332253942,
                -0.055581290958606866,
                -4.440892098500626e-16,
                0.05558129095860698,
                0.11099078332253931,
                0.1660572095164028,
                0.2206103623619955,
                0.2744816211785366,
                0.3275044729790527,
                0.37951502715187624,
                0.430352522036357,
                0.4798598218269098,
                0.5278839022693709,
                0.5742763236482253,
                0.6188936896024427,
                0.6615980903512879,
                0.702257528959379,
                0.7407463293221492,
                0.7769455246084259,
                0.8107432249553912,
                0.8420349632716111,
                0.8707240180636286,
                0.8967217122548171,
                0.9199476869958803,
                0.9403301494268803,
                0.9578060930787163,
                0.9723214884484117,
                0.9838314360258036,
                0.9923002428155636,
                0.9977010738972745,
                1.0,
            ],
            "weights": [
                0.0006265664160402111,
                0.003859604378542599,
                0.006938617366646154,
                0.009994560358820471,
                0.013019387947264071,
                0.01600391792535562,
                0.018938961856322305,
                0.021815458738124783,
                0.024624521589128402,
                0.027357469519451224,
                0.03000585598589708,
                0.032561495414960465,
                0.03501648871417529,
                0.037363247781946024,
                0.039594519007425694,
                0.0417034057144175,
                0.04368338949127903,
                0.04552835034614167,
                0.04723258562769852,
                0.048790827654327566,
                0.05019825999781436,
                0.05145053237170054,
                0.05254377407844472,
                0.0534746059739834,
                0.05424015091278637,
                0.05483804264115596,
                0.055266433111326445,
                0.05552399819377568,
                0.05560994177009394,
                0.05552399819377496,
                0.05526643311132632,
                0.05483804264115579,
                0.05424015091278726,
                0.05347460597398446,
                0.05254377407844481,
                0.051450532371701524,
                0.05019825999781396,
                0.04879082765432715,
                0.04723258562769929,
                0.04552835034614261,
                0.043683389491277765,
                0.041703405714416615,
                0.03959451900742566,
                0.0373632477819458,
                0.03501648871417472,
                0.03256149541495871,
                0.030005855985896605,
                0.02735746951945191,
                0.024624521589128926,
                0.021815458738125137,
                0.018938961856321795,
                0.016003917925357106,
                0.013019387947265723,
                0.00999456035881918,
                0.006938617366645686,
                0.0038596043785436135,
                0.0006265664160401062,
            ],
            "generator": "gauss_lobatto",
        },
        58: {
            "degree": 113,
            "points": [
                -1.0,
                -0.9977803178745879,
                -0.9925654222345481,
                -0.9843875175070176,
                -0.973271645364741,
                -0.9592510923198556,
                -0.9423677333155034,
                -0.9226719668637438,
                -0.9002225781287483,
                -0.8750865675183581,
                -0.8473389521824466,
                -0.8170625427332148,
                -0.7843476963811116,
                -0.7492920474102047,
                -0.7120002158716741,
                -0.6725834953971084,
                -0.6311595210783958,
                -0.5878519184129021,
                -0.5427899343655569,
                -0.49610805165106786,
                -0.44794558738861445,
                -0.3984462773275208,
                -0.34775784688518985,
                -0.29603157027774585,
                -0.2434218190593156,
                -0.19008560141737108,
                -0.13618209359915823,
                -0.08187216486766213,
                -0.027317897404865565,
                0.027317897404866343,
                0.08187216486766224,
                0.13618209359915823,
                0.1900856014173714,
                0.24342181905931615,
                0.2960315702777462,
                0.34775784688518985,
                0.39844627732752125,
                0.44794558738861445,
                0.4961080516510681,
                0.5427899343655569,
                0.5878519184129021,
                0.6311595210783962,
                0.6725834953971088,
                0.7120002158716741,
                0.7492920474102048,
                0.784347696381112,
                0.8170625427332148,
                0.8473389521824466,
                0.875086567518358,
                0.9002225781287486,
                0.9226719668637435,
                0.9423677333155037,
                0.9592510923198556,
                0.9732716453647406,
                0.9843875175070177,
                0.9925654222345488,
                0.9977803178745883,
                1.0,
            ],
            "weights": [
                0.0006049606775560388,
                0.0037266131000565626,
                0.006699948927693956,
                0.009651722372700457,
                0.012574476194817287,
                0.01545964932883199,
                0.018298666593521834,
                0.021083065913303424,
                0.02380454150915035,
                0.02645497312938133,
                0.029026451657206447,
                0.03151130321203432,
                0.03390211225424638,
                0.03619174380700775,
                0.038373364793743495,
                0.04044046445332102,
                0.042386873782951584,
                0.04420678395584203,
                0.045894763661120226,
                0.047445775315465455,
                0.0488551900988024,
                0.050118801769526544,
                0.05123283921822752,
                0.05219397772262036,
                0.05299934887010558,
                0.05364654911846479,
                0.054133646969105026,
                0.05445918873150827,
                0.05462220286168692,
                0.05462220286168754,
                0.05445918873150882,
                0.05413364696910492,
                0.05364654911846552,
                0.05299934887010541,
                0.052193977722618676,
                0.0512328392182277,
                0.05011880176952521,
                0.04885519009880287,
                0.04744577531546535,
                0.045894763661120226,
                0.044206783955842044,
                0.0423868737829497,
                0.040440464453321244,
                0.03837336479374351,
                0.036191743807007015,
                0.03390211225424602,
                0.0315113032120331,
                0.02902645165720722,
                0.02645497312938187,
                0.02380454150915229,
                0.021083065913303015,
                0.018298666593521997,
                0.015459649328833508,
                0.01257447619481822,
                0.009651722372699224,
                0.006699948927693694,
                0.0037266131000573853,
                0.000604960677555957,
            ],
            "generator": "gauss_lobatto",
        },
        59: {
            "degree": 115,
            "points": [
                -1.0000000000000002,
                -0.9978555344350872,
                -0.9928171397102565,
                -0.9849154197059757,
                -0.9741737711423282,
                -0.9606232735328779,
                -0.9443030274787465,
                -0.9252600999996676,
                -0.9035494018611672,
                -0.8792335331450694,
                -0.8523826041616378,
                -0.8230740338838318,
                -0.7913923269942977,
                -0.7574288303685979,
                -0.7212814697686099,
                -0.6830544675364429,
                -0.6428580421174586,
                -0.6008080902859865,
                -0.5570258529937526,
                -0.5116375658065866,
                -0.4647740949384298,
                -0.41657055993278136,
                -0.36716594407990444,
                -0.3167026936933284,
                -0.2653263074011962,
                -0.21318491663676653,
                -0.16042885853767985,
                -0.1072102424854966,
                -0.053682511535312116,
                -4.440892098500626e-16,
                0.05368251153531178,
                0.10721024248549638,
                0.16042885853768007,
                0.21318491663676675,
                0.2653263074011959,
                0.3167026936933277,
                0.36716594407990455,
                0.4165705599327808,
                0.4647740949384299,
                0.5116375658065868,
                0.5570258529937526,
                0.6008080902859858,
                0.6428580421174589,
                0.6830544675364423,
                0.7212814697686094,
                0.7574288303685984,
                0.7913923269942975,
                0.8230740338838317,
                0.8523826041616374,
                0.8792335331450697,
                0.9035494018611672,
                0.925260099999668,
                0.9443030274787467,
                0.9606232735328778,
                0.974173771142328,
                0.9849154197059761,
                0.9928171397102572,
                0.9978555344350876,
                1.0,
            ],
            "weights": [
                0.0005844535359437882,
                0.003600377581729292,
                0.00647337694015253,
                0.0093261979484915,
                0.012151921331788735,
                0.014942555892415617,
                0.017690089617495377,
                0.020386610960600057,
                0.023024348980386054,
                0.025595700038299772,
                0.028093251048624975,
                0.030509801332777673,
                0.03283838357671151,
                0.035072284007301315,
                0.03720506179229522,
                0.03923056763271764,
                0.04114296150470354,
                0.04293672950449675,
                0.044606699750397286,
                0.04614805729704238,
                0.047556358019632934,
                0.04882754142847591,
                0.049957942377055836,
                0.05094430163003202,
                0.051783775260742904,
                0.052473942851190176,
                0.05301281447087042,
                0.05339883641434727,
                0.053630895681061594,
                0.05370832318443833,
                0.05363089568106085,
                0.053398836414346895,
                0.05301281447087011,
                0.052473942851190065,
                0.05178377526074211,
                0.050944301630032565,
                0.04995794237705633,
                0.048827541428477034,
                0.04755635801963297,
                0.046148057297041904,
                0.044606699750397334,
                0.04293672950449592,
                0.04114296150470335,
                0.03923056763271708,
                0.0372050617922949,
                0.03507228400730121,
                0.03283838357671216,
                0.030509801332777427,
                0.0280932510486256,
                0.025595700038299796,
                0.02302434898038766,
                0.02038661096059909,
                0.017690089617495963,
                0.014942555892416089,
                0.012151921331788813,
                0.009326197948490161,
                0.006473376940152336,
                0.003600377581730147,
                0.0005844535359438775,
            ],
            "generator": "gauss_lobatto",
        },
        60: {
            "degree": 117,
            "points": [
                -1.0,
                -0.9979269919158114,
                -0.993056290939091,
                -0.9854170134477473,
                -0.9750310449997028,
                -0.9619274380829246,
                -0.946142744770198,
                -0.9277209709714227,
                -0.9067134663792606,
                -0.8831787851105564,
                -0.8571825238628421,
                -0.8287971396455363,
                -0.7981017480862453,
                -0.7651819030489861,
                -0.7301293582479416,
                -0.6930418115513128,
                -0.6540226327020735,
                -0.6131805752214963,
                -0.5706294733021222,
                -0.5264879245370011,
                -0.4808789593706233,
                -0.433929698193525,
                -0.38577099703673223,
                -0.33653708285377815,
                -0.2863651794070299,
                -0.23539512480112146,
                -0.18376898172959533,
                -0.13163064152109127,
                -0.07912542308872461,
                -0.02639966790047965,
                0.02639966790047954,
                0.0791254230887245,
                0.13163064152109116,
                0.18376898172959577,
                0.23539512480112157,
                0.28636517940702944,
                0.3365370828537785,
                0.38577099703673223,
                0.43392969819352556,
                0.4808789593706232,
                0.5264879245370019,
                0.570629473302122,
                0.6131805752214959,
                0.654022632702074,
                0.6930418115513134,
                0.7301293582479416,
                0.7651819030489866,
                0.7981017480862448,
                0.828797139645536,
                0.8571825238628424,
                0.8831787851105563,
                0.9067134663792598,
                0.9277209709714225,
                0.9461427447701982,
                0.9619274380829247,
                0.9750310449997018,
                0.9854170134477473,
                0.993056290939091,
                0.997926991915811,
                1.0,
            ],
            "weights": [
                0.0005649717514124463,
                0.00348044796815213,
                0.006258098158477098,
                0.009016842489364652,
                0.011750254422266985,
                0.014450866330632962,
                0.017111184093520308,
                0.019723802887794066,
                0.022281444575675144,
                0.024776982138835297,
                0.027203460825102964,
                0.029554117996939404,
                0.03182240216955686,
                0.03400199135593159,
                0.03608681072831257,
                0.03807104957092019,
                0.039949177486880386,
                0.04171595981889851,
                0.043366472242993365,
                0.04489611449579703,
                0.046300623197757844,
                0.04757608373687937,
                0.04871894118007353,
                0.04972601018179146,
                0.05059448386245598,
                0.051321941631910915,
                0.05190635593619326,
                0.05234609790877964,
                0.052639941910586796,
                0.05278706894610627,
                0.052787068946106325,
                0.0526399419105877,
                0.0523460979087797,
                0.05190635593619419,
                0.05132194163191088,
                0.050594483862456345,
                0.04972601018179188,
                0.0487189411800731,
                0.047576083736878994,
                0.04630062319775707,
                0.04489611449579741,
                0.04336647224299392,
                0.04171595981889812,
                0.03994917748687999,
                0.038071049570919564,
                0.036086810728312595,
                0.03400199135593272,
                0.031822402169556764,
                0.029554117996939196,
                0.027203460825102575,
                0.024776982138835814,
                0.02228144457567546,
                0.019723802887793823,
                0.017111184093521307,
                0.014450866330632452,
                0.011750254422266713,
                0.009016842489363835,
                0.006258098158477222,
                0.0034804479681531534,
                0.0005649717514124125,
            ],
            "generator": "gauss_lobatto",
        },
        61: {
            "degree": 119,
            "points": [
                -1.0,
                -0.9979949366740559,
                -0.993283698369058,
                -0.9858940169577028,
                -0.9758463877512669,
                -0.9631679988629978,
                -0.9478930579707181,
                -0.9300627543852873,
                -0.9097251601954282,
                -0.8869351043123037,
                -0.8617540259730692,
                -0.8342498096540054,
                -0.8044966023144635,
                -0.7725746136332081,
                -0.7385698998427725,
                -0.7025741317737308,
                -0.6646843477478281,
                -0.6250026919929155,
                -0.5836361392884217,
                -0.5406962065856213,
                -0.4962986523812223,
                -0.4505631646553594,
                -0.40361303821566463,
                -0.35557484231747516,
                -0.3065780794563704,
                -0.2567548362529981,
                -0.20623942737138123,
                -0.1551680334307184,
                -0.10367833388680503,
                -0.0519091358728101,
                0.0,
                0.05190913587280965,
                0.10367833388680481,
                0.15516803343071872,
                0.20623942737138146,
                0.25675483625299744,
                0.3065780794563706,
                0.35557484231747494,
                0.4036130382156652,
                0.4505631646553593,
                0.49629865238122206,
                0.5406962065856213,
                0.5836361392884215,
                0.6250026919929152,
                0.6646843477478281,
                0.7025741317737308,
                0.7385698998427724,
                0.7725746136332077,
                0.8044966023144633,
                0.8342498096540052,
                0.8617540259730693,
                0.8869351043123039,
                0.9097251601954282,
                0.9300627543852872,
                0.9478930579707181,
                0.963167998862998,
                0.9758463877512669,
                0.9858940169577023,
                0.9932836983690582,
                0.9979949366740556,
                1.0,
            ],
            "weights": [
                0.000546448087431701,
                0.0033664112266185656,
                0.0060533748717336855,
                0.008722604294983114,
                0.011368124877434412,
                0.013982950691309486,
                0.01656006451345049,
                0.01909252853234667,
                0.021573519250142077,
                0.02399634988981932,
                0.02635448966182071,
                0.028641581818933778,
                0.030851460976147636,
                0.03297816981349385,
                0.03501597517556399,
                0.03695938354745559,
                0.038803155875360006,
                0.04054232169638006,
                0.0421721925416907,
                0.043688374578085415,
                0.04508678045435234,
                0.04636364032096891,
                0.047515511993546096,
                0.04853929023274174,
                0.04943221511571129,
                0.0501918794765679,
                0.050816235395797806,
                0.05130359972119166,
                0.051652658605384476,
                0.05186247104780314,
                0.05193247143146573,
                0.05186247104780262,
                0.05165265860538412,
                0.051303599721191515,
                0.05081623539579678,
                0.05019187947656752,
                0.04943221511571143,
                0.04853929023274107,
                0.04751551199354642,
                0.046363640320969755,
                0.04508678045435254,
                0.04368837457808573,
                0.04217219254169161,
                0.0405423216963785,
                0.038803155875359575,
                0.03695938354745571,
                0.03501597517556469,
                0.032978169813494475,
                0.03085146097614688,
                0.028641581818932702,
                0.026354489661820323,
                0.02399634988982024,
                0.021573519250141737,
                0.019092528532347365,
                0.016560064513451052,
                0.013982950691308744,
                0.01136812487743414,
                0.008722604294982924,
                0.006053374871734225,
                0.003366411226619644,
                0.0005464480874316899,
            ],
            "generator": "gauss_lobatto",
        },
        62: {
            "degree": 121,
            "points": [
                -0.9999999999999997,
                -0.9980595952127856,
                -0.9935001182696868,
                -0.986348010547111,
                -0.9766224865738202,
                -0.9643490173304319,
                -0.9495596509405893,
                -0.9322929815935628,
                -0.9125940606463694,
                -0.8905142826105714,
                -0.866111252339923,
                -0.8394486352707367,
                -0.810595991566436,
                -0.7796285947624488,
                -0.7466272354494847,
                -0.7116780105355638,
                -0.674872098649796,
                -0.6363055222804086,
                -0.5960788972710216,
                -0.5542971703305759,
                -0.511069345242811,
                -0.4665081984901891,
                -0.42072998503457426,
                -0.3738541350224789,
                -0.326002942206292,
                -0.27730124489447316,
                -0.22787610026312333,
                -0.17785645287868568,
                -0.127372798296582,
                -0.07655684261343443,
                -0.025541158861093205,
                0.025541158861093316,
                0.0765568426134342,
                0.1273727982965821,
                0.177856452878686,
                0.227876100263123,
                0.2773012448944736,
                0.3260029422062921,
                0.3738541350224788,
                0.42072998503457404,
                0.466508198490189,
                0.511069345242811,
                0.5542971703305762,
                0.5960788972710216,
                0.6363055222804088,
                0.674872098649796,
                0.7116780105355638,
                0.7466272354494843,
                0.7796285947624483,
                0.8105959915664355,
                0.839448635270737,
                0.8661112523399237,
                0.8905142826105713,
                0.9125940606463696,
                0.9322929815935628,
                0.9495596509405891,
                0.9643490173304325,
                0.9766224865738201,
                0.9863480105471109,
                0.9935001182696871,
                0.9980595952127858,
                1.0,
            ],
            "weights": [
                0.0005288207297729117,
                0.00325788758921837,
                0.005858528595119563,
                0.008442515672946968,
                0.011004289228371673,
                0.013537307100143732,
                0.016034991787546242,
                0.01849083643619466,
                0.020898437489170037,
                0.023251515275651898,
                0.02554393159397294,
                0.02776970615998225,
                0.029923032386158926,
                0.03199829260972787,
                0.03399007278685067,
                0.035893176636954474,
                0.0377026392099201,
                0.03941373984511706,
                0.04102201449062395,
                0.04252326735160774,
                0.04391358183802819,
                0.04518933078344171,
                0.04634718590845354,
                0.04738412650419224,
                0.04829744731327214,
                0.04908476558766719,
                0.04974402730517798,
                0.050273512528213174,
                0.05067183989098889,
                0.050937970203386626,
                0.05107120916212503,
                0.05107120916212526,
                0.05093797020338748,
                0.05067183989098891,
                0.05027351252821335,
                0.049744027305178365,
                0.04908476558766818,
                0.04829744731327143,
                0.04738412650419347,
                0.04634718590845378,
                0.04518933078344191,
                0.043913581838027696,
                0.042523267351607996,
                0.04102201449062333,
                0.03941373984511608,
                0.0377026392099206,
                0.035893176636954544,
                0.03399007278685031,
                0.031998292609727294,
                0.029923032386157875,
                0.02776970615998167,
                0.025543931593973515,
                0.023251515275652456,
                0.020898437489170196,
                0.018490836436195843,
                0.016034991787545683,
                0.01353730710014317,
                0.011004289228371454,
                0.008442515672946939,
                0.005858528595120236,
                0.00325788758921935,
                0.0005288207297726031,
            ],
            "generator": "gauss_lobatto",
        },
        63: {
            "degree": 123,
            "points": [
                -0.9999999999999999,
                -0.9981211760700918,
                -0.9937062470187039,
                -0.986780449677167,
                -0.9773618170509333,
                -0.9654742364970084,
                -0.9511477642251689,
                -0.9344186002357289,
                -0.9153290082899936,
                -0.8939272125568241,
                -0.8702672770237643,
                -0.8444089694347976,
                -0.8164176105445651,
                -0.7863639092280532,
                -0.7543237839251489,
                -0.7203781708983812,
                -0.6846128198010109,
                -0.6471180770782181,
                -0.6079886577518612,
                -0.5673234061671213,
                -0.5252250463064485,
                -0.48179992230214874,
                -0.4371577298034526,
                -0.39141123887692664,
                -0.3446760091403045,
                -0.29707009784946914,
                -0.24871376167603376,
                -0.19972915292889115,
                -0.1502400109871609,
                -0.10037134972398953,
                -0.050249141710840384,
                0.0,
                0.05024914171084027,
                0.10037134972398942,
                0.1502400109871609,
                0.1997291529288907,
                0.2487137616760331,
                0.29707009784946936,
                0.3446760091403043,
                0.39141123887692675,
                0.437157729803453,
                0.4817999223021483,
                0.525225046306449,
                0.5673234061671207,
                0.6079886577518612,
                0.6471180770782184,
                0.6846128198010109,
                0.7203781708983813,
                0.7543237839251492,
                0.7863639092280537,
                0.8164176105445645,
                0.8444089694347978,
                0.8702672770237638,
                0.8939272125568234,
                0.9153290082899929,
                0.9344186002357289,
                0.9511477642251686,
                0.9654742364970088,
                0.9773618170509324,
                0.9867804496771663,
                0.9937062470187036,
                0.9981211760700917,
                1.0,
            ],
            "weights": [
                0.0005120327700974627,
                0.0031545273895633424,
                0.005672934458268686,
                0.008175685025316114,
                0.010657601118470871,
                0.013112549926151022,
                0.015534359906330843,
                0.017916922379587613,
                0.020254222137223575,
                0.022540356395139124,
                0.024769550866659034,
                0.026936174769537063,
                0.029034755221375226,
                0.03105999114144821,
                0.03300676667882971,
                0.03487016415453923,
                0.0366454764943748,
                0.03832821912523785,
                0.03991414130700932,
                0.04139923687237651,
                0.0427797543480833,
                0.04405220643231825,
                0.04521337880449494,
                0.0462603382452952,
                0.04719044004646796,
                0.04800133469179837,
                0.048690973792284556,
                0.04925761526066263,
                0.04969982771211193,
                0.05001649408011481,
                0.050206814438288415,
                0.050270308021091066,
                0.050206814438288165,
                0.05001649408011443,
                0.04969982771211188,
                0.0492576152606621,
                0.04869097379228503,
                0.048001334691796946,
                0.04719044004646924,
                0.046260338245293915,
                0.045213378804494955,
                0.044052206432317505,
                0.042779754348083565,
                0.0413992368723768,
                0.039914141307009036,
                0.038328219125237914,
                0.03664547649437399,
                0.034870164154539,
                0.03300676667882922,
                0.031059991141448112,
                0.029034755221373842,
                0.02693617476953752,
                0.02476955086666004,
                0.02254035639513924,
                0.02025422213722455,
                0.017916922379588397,
                0.01553435990632916,
                0.01311254992615113,
                0.010657601118470859,
                0.00817568502531623,
                0.005672934458269421,
                0.0031545273895643993,
                0.0005120327700972882,
            ],
            "generator": "gauss_lobatto",
        },
        64: {
            "degree": 125,
            "points": [
                -0.9999999999999999,
                -0.9981798715021633,
                -0.9939027267030576,
                -0.9871926766027406,
                -0.9780666628313968,
                -0.9665471103690995,
                -0.9526622357886629,
                -0.9364460274756341,
                -0.9179381735102821,
                -0.8971839678458502,
                -0.8742342006576276,
                -0.8491450345429914,
                -0.8219778673075169,
                -0.7927991818262086,
                -0.7616803834081203,
                -0.7286976250888368,
                -0.6939316212907045,
                -0.6574674503129765,
                -0.6193943461384317,
                -0.5798054800677186,
                -0.538797732716801,
                -0.496471456936058,
                -0.45293023223158135,
                -0.40828061128985427,
                -0.36263185922626184,
                -0.3160956861956259,
                -0.2687859740191698,
                -0.22081849749695337,
                -0.1723106410877926,
                -0.12338111165002807,
                -0.07414964794611612,
                -0.024736727621958776,
                0.02473672762195922,
                0.07414964794611634,
                0.12338111165002819,
                0.17231064108779282,
                0.22081849749695381,
                0.26878597401917037,
                0.3160956861956262,
                0.36263185922626207,
                0.40828061128985427,
                0.45293023223158135,
                0.496471456936058,
                0.5387977327168008,
                0.5798054800677186,
                0.6193943461384317,
                0.6574674503129765,
                0.6939316212907048,
                0.728697625088837,
                0.76168038340812,
                0.7927991818262082,
                0.8219778673075172,
                0.8491450345429911,
                0.8742342006576276,
                0.8971839678458501,
                0.9179381735102817,
                0.9364460274756341,
                0.9526622357886628,
                0.9665471103690992,
                0.9780666628313961,
                0.9871926766027402,
                0.9939027267030573,
                0.9981798715021633,
                1.0,
            ],
            "weights": [
                0.0004960317460318956,
                0.003056008244911598,
                0.005496016203816361,
                0.007921289790046854,
                0.010327002366815118,
                0.012707399197453685,
                0.01505668398796406,
                0.017369116384542648,
                0.019639040723241102,
                0.021860903511517447,
                0.024029268144024136,
                0.026138828614338343,
                0.02818442266584926,
                0.030161044499089244,
                0.032063857057726554,
                0.03388820388412589,
                0.035629620524490035,
                0.03728384545980234,
                0.038846830537809615,
                0.04031475088155916,
                0.0416840142508016,
                0.042951269833602215,
                0.044113416446892116,
                0.045167610125946826,
                0.04611127108428881,
                0.04694209002702835,
                0.0476580338022205,
                0.048257350376413696,
                0.04873857312223339,
                0.04910052440750182,
                0.04934231847713874,
                0.049463363620776024,
                0.04946336362077623,
                0.049342318477139296,
                0.049100524407501484,
                0.048738573122232856,
                0.04825735037641459,
                0.04765803380221999,
                0.046942090027029114,
                0.04611127108428825,
                0.04516761012594776,
                0.044113416446892546,
                0.04295126983360218,
                0.041684014250802065,
                0.04031475088156014,
                0.03884683053780841,
                0.03728384545980134,
                0.0356296205244894,
                0.03388820388412525,
                0.0320638570577269,
                0.0301610444990896,
                0.028184422665848554,
                0.02613882861433858,
                0.024029268144024077,
                0.02186090351151791,
                0.01963904072324188,
                0.017369116384542388,
                0.015056683987961478,
                0.012707399197454578,
                0.010327002366815176,
                0.007921289790046682,
                0.005496016203817201,
                0.0030560082449124803,
                0.0004960317460317352,
            ],
            "generator": "gauss_lobatto",
        },
        65: {
            "degree": 127,
            "points": [
                -0.9999999999999997,
                -0.9982358589851681,
                -0.9940901501184234,
                -0.9875859307695098,
                -0.9787391331919995,
                -0.9675708302669137,
                -0.9541075374600214,
                -0.9383811976826657,
                -0.9204291162429912,
                -0.9002938755616072,
                -0.8780232353249457,
                -0.8536700196814497,
                -0.8272919921669406,
                -0.7989517188043678,
                -0.7687164197616274,
                -0.7366578099449519,
                -0.7028519289179362,
                -0.6673789605555873,
                -0.630323042864267,
                -0.5917720684203425,
                -0.5518174759018255,
                -0.5105540332080718,
                -0.4680796126822757,
                -0.42449495897013834,
                -0.37990345006546433,
                -0.3344108521095379,
                -0.28812506852594777,
                -0.24115588408589628,
                -0.19361470451111007,
                -0.1456142922319652,
                -0.0972684989276218,
                -0.048691995482555095,
                -4.440892098500626e-16,
                0.048691995482555206,
                0.0972684989276219,
                0.14561429223196465,
                0.1936147045111103,
                0.2411558840858965,
                0.2881250685259472,
                0.3344108521095386,
                0.37990345006546433,
                0.42449495897013845,
                0.4680796126822757,
                0.510554033208072,
                0.5518174759018255,
                0.5917720684203422,
                0.6303230428642677,
                0.6673789605555875,
                0.7028519289179371,
                0.7366578099449526,
                0.7687164197616276,
                0.7989517188043673,
                0.8272919921669405,
                0.8536700196814493,
                0.8780232353249456,
                0.9002938755616071,
                0.9204291162429908,
                0.9383811976826656,
                0.9541075374600222,
                0.9675708302669136,
                0.9787391331919989,
                0.9875859307695092,
                0.9940901501184232,
                0.9982358589851682,
                1.0,
            ],
            "weights": [
                0.0004807692307695053,
                0.0029620325412553833,
                0.005327241721587185,
                0.00767857013354835,
                0.010011514973887732,
                0.01232067111944258,
                0.014600589550423728,
                0.016845871022065813,
                0.019051193120028703,
                0.021211326413489443,
                0.023321147949508236,
                0.025375653798947632,
                0.027369971086317276,
                0.02929936961981051,
                0.031159273145640317,
                0.03294527022031773,
                0.0346531246837988,
                0.036278785712687334,
                0.037818397431575,
                0.03926830806071075,
                0.04062507857886819,
                0.04188549088110619,
                0.043046555412279926,
                0.04410551825829871,
                0.04505986767833274,
                0.04590734006256285,
                0.04664592530132883,
                0.047273871552962,
                0.04778968939903825,
                0.048192155377142123,
                0.0484803148828203,
                0.048653484433821774,
                0.048711253291254884,
                0.048653484433821774,
                0.04848031488281964,
                0.04819215537714174,
                0.04778968939903874,
                0.047273871552961914,
                0.04664592530132842,
                0.04590734006256266,
                0.04505986767833322,
                0.044105518258298185,
                0.04304655541227994,
                0.04188549088110554,
                0.0406250785788681,
                0.039268308060710314,
                0.037818397431573385,
                0.036278785712687084,
                0.03465312468379899,
                0.032945270220318366,
                0.0311592731456411,
                0.02929936961981003,
                0.027369971086316867,
                0.02537565379894772,
                0.023321147949507712,
                0.02121132641349104,
                0.019051193120028502,
                0.016845871022065015,
                0.014600589550421986,
                0.012320671119444144,
                0.01001151497388818,
                0.0076785701335481665,
                0.00532724172158799,
                0.002962032541256194,
                0.0004807692307692244,
            ],
            "generator": "gauss_lobatto",
        },
        66: {
            "degree": 129,
            "points": [
                -0.9999999999999996,
                -0.9982893025579668,
                -0.9942690652398658,
                -0.9879613581145847,
                -0.9793811787558044,
                -0.968548348394562,
                -0.9554878075976152,
                -0.9402296052069474,
                -0.9228088396173295,
                -0.903265581151353,
                -0.8816447810154402,
                -0.857996168372988,
                -0.8323741361774446,
                -0.8048376161719333,
                -0.7754499434001081,
                -0.7442787105647364,
                -0.7113956125805967,
                -0.6768762816850182,
                -0.6408001134883228,
                -0.6032500843659354,
                -0.5643125606130859,
                -0.5240770998016355,
                -0.4826362447962269,
                -0.4400853109037479,
                -0.3965221666458141,
                -0.3520470086585725,
                -0.30676213123762963,
                -0.26077169105820563,
                -0.21418146761167556,
                -0.16709861990954367,
                -0.11963144001442605,
                -0.07188910396496917,
                -0.023981420667563036,
                0.023981420667563036,
                0.07188910396496917,
                0.11963144001442594,
                0.16709861990954322,
                0.21418146761167622,
                0.2607716910582052,
                0.30676213123762996,
                0.3520470086585721,
                0.3965221666458141,
                0.4400853109037476,
                0.4826362447962267,
                0.524077099801636,
                0.5643125606130861,
                0.6032500843659354,
                0.6408001134883233,
                0.6768762816850182,
                0.7113956125805969,
                0.7442787105647364,
                0.7754499434001084,
                0.8048376161719333,
                0.8323741361774446,
                0.8579961683729879,
                0.8816447810154404,
                0.9032655811513528,
                0.9228088396173293,
                0.9402296052069475,
                0.9554878075976159,
                0.9685483483945624,
                0.9793811787558044,
                0.9879613581145849,
                0.9942690652398661,
                0.998289302557967,
                1.0,
            ],
            "weights": [
                0.00046620046620084974,
                0.002872325184720747,
                0.005166119053881018,
                0.007446823304521984,
                0.009710233958057807,
                0.01195126956664888,
                0.014164802868276738,
                0.016345750877716017,
                0.01848910039412096,
                0.02058992295329946,
                0.02264338722092656,
                0.024644770487594225,
                0.026589469687360066,
                0.028473012054875787,
                0.030291065446664368,
                0.032039448322548895,
                0.03371413937272654,
                0.03531128677224304,
                0.03682721704344166,
                0.03825844350698754,
                0.03960167430254061,
                0.04085381996090954,
                0.042012000510434404,
                0.04307355210135072,
                0.04403603313297795,
                0.044897229869619054,
                0.045655161532359066,
                0.04630808485499341,
                0.04685449809364791,
                0.0472931444808977,
                0.04762301511638356,
                0.04784335128734992,
                0.04795364621372375,
                0.047953646213723736,
                0.04784335128735049,
                0.04762301511638348,
                0.04729314448089748,
                0.04685449809364819,
                0.04630808485499278,
                0.04565516153235947,
                0.044897229869618936,
                0.044036033132976736,
                0.043073552101351435,
                0.042012000510433925,
                0.04085381996090987,
                0.03960167430254108,
                0.03825844350698706,
                0.036827217043441315,
                0.03531128677224348,
                0.03371413937272674,
                0.032039448322548826,
                0.03029106544666455,
                0.02847301205487513,
                0.026589469687358976,
                0.024644770487593254,
                0.022643387220926597,
                0.02058992295330102,
                0.01848910039411953,
                0.016345750877715108,
                0.014164802868276219,
                0.011951269566650784,
                0.00971023395805838,
                0.007446823304521293,
                0.005166119053881689,
                0.002872325184721435,
                0.0004662004662004521,
            ],
            "generator": "gauss_lobatto",
        },
        67: {
            "degree": 131,
            "points": [
                -0.9999999999999994,
                -0.9983403540246513,
                -0.9944399792266301,
                -0.9883200194007591,
                -0.9799946055837894,
                -0.9694823989836712,
                -0.9568068804131808,
                -0.94199634281468,
                -0.9250838382075401,
                -0.906107106945742,
                -0.8851084945898828,
                -0.8621348578661581,
                -0.8372374603160682,
                -0.8104718580094046,
                -0.7818977756310057,
                -0.751578973241906,
                -0.7195831040234328,
                -0.685981563327305,
                -0.6508493293714883,
                -0.6142647959388918,
                -0.5763095974531125,
                -0.5370684268221293,
                -0.4966288464566935,
                -0.4550810928853455,
                -0.4125178754021457,
                -0.3690341691965142,
                -0.3247270034268348,
                -0.27969524471076057,
                -0.23403937651535633,
                -0.18786127493937443,
                -0.1412639813879848,
                -0.09435147264722654,
                -0.04722842887124035,
                0.0,
                0.047228428871240125,
                0.09435147264722654,
                0.14126398138798513,
                0.1878612749393751,
                0.23403937651535656,
                0.279695244710761,
                0.324727003426835,
                0.36903416919651466,
                0.41251787540214624,
                0.4550810928853456,
                0.4966288464566939,
                0.5370684268221295,
                0.5763095974531132,
                0.6142647959388918,
                0.6508493293714891,
                0.685981563327305,
                0.7195831040234333,
                0.7515789732419067,
                0.7818977756310062,
                0.8104718580094048,
                0.8372374603160693,
                0.8621348578661591,
                0.8851084945898836,
                0.9061071069457425,
                0.925083838207541,
                0.941996342814681,
                0.9568068804131822,
                0.9694823989836722,
                0.9799946055837903,
                0.9883200194007595,
                0.9944399792266309,
                0.9983403540246515,
                1.0,
            ],
            "weights": [
                0.00045228403437409397,
                0.0027866315875317927,
                0.005012192815940987,
                0.007225398571122257,
                0.0094223209258745,
                0.011598178436227341,
                0.013748142291442444,
                0.01586742304779973,
                0.01795129471924355,
                0.019995108642310366,
                0.021994304875032625,
                0.023944422743325772,
                0.025841110945959114,
                0.027680137331851224,
                0.029457398376408147,
                0.031168928354930445,
                0.032810908200811666,
                0.034379674032538894,
                0.03587172533227533,
                0.03728373275874713,
                0.038612545577449885,
                0.03985519869193524,
                0.04100891926057149,
                0.04207113288417927,
                0.04303946935074966,
                0.04391176792446866,
                0.044686082167277666,
                0.04536068428220713,
                0.04593406896884614,
                0.04640495678227392,
                0.04677229698805237,
                0.04703526990682943,
                0.047193288743391744,
                0.04724600089604137,
                0.04719328874339172,
                0.0470352699068287,
                0.04677229698805218,
                0.046404956782274805,
                0.04593406896884543,
                0.045360684282207867,
                0.0446860821672763,
                0.04391176792446917,
                0.043039469350750606,
                0.04207113288417932,
                0.04100891926057138,
                0.03985519869193566,
                0.03861254557745048,
                0.03728373275874622,
                0.03587172533227514,
                0.0343796740325379,
                0.03281090820081161,
                0.031168928354929792,
                0.02945739837640749,
                0.027680137331850662,
                0.025841110945958378,
                0.023944422743325377,
                0.021994304875033677,
                0.019995108642310692,
                0.01795129471924241,
                0.0158674230477995,
                0.013748142291443301,
                0.011598178436229142,
                0.009422320925875019,
                0.007225398571121351,
                0.005012192815941518,
                0.002786631587532432,
                0.0004522840343735614,
            ],
            "generator": "gauss_lobatto",
        },
        68: {
            "degree": 133,
            "points": [
                -0.9999999999999997,
                -0.9983891540333851,
                -0.9946033620157071,
                -0.9886628976973675,
                -0.9805810878292052,
                -0.9703755172913673,
                -0.9580683123388192,
                -0.9436861362776108,
                -0.9272601415010788,
                -0.9088259049414951,
                -0.8884233520717979,
                -0.8660966708711373,
                -0.841894216322854,
                -0.8158684057873231,
                -0.788075605530091,
                -0.7585760086744675,
                -0.7274335048538194,
                -0.6947155418513336,
                -0.6604929795297332,
                -0.6248399363688764,
                -0.5878336289444828,
                -0.549554204696165,
                -0.5100845683472777,
                -0.4695102023527009,
                -0.42791898176356913,
                -0.38540098390999056,
                -0.3420482933139801,
                -0.29795480225517923,
                -0.25321600742130723,
                -0.2079288030837676,
                -0.16219127124637644,
                -0.11610246922168965,
                -0.06976221509501501,
                -0.023270871540750804,
                0.023270871540750693,
                0.06976221509501557,
                0.11610246922168976,
                0.1621912712463769,
                0.20792880308376782,
                0.2532160074213071,
                0.29795480225517956,
                0.34204829331398046,
                0.385400983909991,
                0.4279189817635697,
                0.4695102023527009,
                0.5100845683472778,
                0.549554204696165,
                0.5878336289444821,
                0.6248399363688761,
                0.6604929795297333,
                0.694715541851334,
                0.7274335048538199,
                0.7585760086744677,
                0.7880756055300915,
                0.8158684057873226,
                0.8418942163228539,
                0.8660966708711371,
                0.8884233520717978,
                0.9088259049414946,
                0.927260141501079,
                0.9436861362776113,
                0.9580683123388193,
                0.9703755172913681,
                0.9805810878292054,
                0.9886628976973675,
                0.9946033620157072,
                0.9983891540333851,
                1.0,
            ],
            "weights": [
                0.0004389815627746748,
                0.002704715860993702,
                0.004865040983040103,
                0.007013692673672116,
                0.009146998291728846,
                0.011260454765194888,
                0.013349510418622456,
                0.015409648553898028,
                0.017436410241160116,
                0.01942540719742966,
                0.021372332286305855,
                0.023272969206685715,
                0.025123201771317626,
                0.02691902288737795,
                0.02865654326672186,
                0.030331999865572546,
                0.03194176404326405,
                0.03348234942608801,
                0.03495041946095425,
                0.03634279464341314,
                0.03765645940487595,
                0.03888856864440231,
                0.040036453891015886,
                0.041097629083346174,
                0.04206979595410821,
                0.04295084900778151,
                0.043738880080757436,
                0.04443218247408342,
                0.045029254649824435,
                0.045528803483127496,
                0.045929747062855464,
                0.046231217034792015,
                0.04643256048231712,
                0.046533341340496366,
                0.0465333413404966,
                0.04643256048231744,
                0.04623121703479218,
                0.04592974706285563,
                0.04552880348312674,
                0.0450292546498249,
                0.0444321824740822,
                0.043738880080759227,
                0.0429508490077812,
                0.04206979595410716,
                0.04109762908334632,
                0.040036453891015525,
                0.03888856864440217,
                0.03765645940487624,
                0.03634279464341168,
                0.034950419460953355,
                0.03348234942608728,
                0.031941764043263446,
                0.030331999865572657,
                0.028656543266722134,
                0.026919022887376323,
                0.025123201771317844,
                0.023272969206686523,
                0.021372332286306955,
                0.019425407197429186,
                0.017436410241159737,
                0.01540964855389835,
                0.013349510418623943,
                0.01126045476519674,
                0.009146998291729075,
                0.007013692673671046,
                0.0048650409830406915,
                0.002704715860994254,
                0.0004389815627743438,
            ],
            "generator": "gauss_lobatto",
        },
        69: {
            "degree": 135,
            "points": [
                -0.9999999999999994,
                -0.9984358330458747,
                -0.9947596495517181,
                -0.9889909051061287,
                -0.981142179119592,
                -0.9712300566974634,
                -0.959275405772027,
                -0.9453033755485103,
                -0.9293433531147788,
                -0.9114289044757322,
                -0.8915977049862687,
                -0.8698914605419759,
                -0.8463558200644794,
                -0.8210402795971281,
                -0.7939980782649834,
                -0.765286086340615,
                -0.7349646856617389,
                -0.7030976426574369,
                -0.6697519742527762,
                -0.6349978069353275,
                -0.5989082292808401,
                -0.5615591382487153,
                -0.5230290795708359,
                -0.48339908256960107,
                -0.44275248975267356,
                -0.4011747815428852,
                -0.35875339651194826,
                -0.3155775474960567,
                -0.2717380339801203,
                -0.2273270511452068,
                -0.18243799598077204,
                -0.13716527086945507,
                -0.09160408505748441,
                -0.04585025442823398,
                0.0,
                0.045850254428234205,
                0.09160408505748452,
                0.1371652708694554,
                0.18243799598077226,
                0.22732705114520613,
                0.27173803398012053,
                0.3155775474960566,
                0.35875339651194793,
                0.4011747815428852,
                0.44275248975267334,
                0.4833990825696012,
                0.5230290795708363,
                0.5615591382487156,
                0.5989082292808402,
                0.6349978069353278,
                0.6697519742527764,
                0.7030976426574371,
                0.7349646856617391,
                0.7652860863406155,
                0.7939980782649836,
                0.8210402795971288,
                0.8463558200644798,
                0.8698914605419763,
                0.891597704986269,
                0.9114289044757328,
                0.9293433531147797,
                0.945303375548511,
                0.9592754057720271,
                0.9712300566974637,
                0.9811421791195923,
                0.9889909051061292,
                0.9947596495517185,
                0.9984358330458749,
                1.0,
            ],
            "weights": [
                0.00042625745950601433,
                0.0026263591915298176,
                0.0047242720019175675,
                0.006811145733865629,
                0.0088835440731812,
                0.010937222525840971,
                0.012967887031228068,
                0.014971274576809102,
                0.01694317479450493,
                0.018879441943171937,
                0.020776004593876896,
                0.022628874542109895,
                0.024434155337754542,
                0.026188050543284838,
                0.027886871748594947,
                0.029527046343649853,
                0.031105125040323662,
                0.032617789131169646,
                0.034061857471577854,
                0.03543429317151625,
                0.03673220998324113,
                0.0379528783718343,
                0.03909373125591585,
                0.04015236940656464,
                0.04112656649314673,
                0.0420142737654828,
                0.04281362436249067,
                0.04352293723830954,
                0.04414072069761785,
                0.04466567553273004,
                0.04509669775587731,
                0.04543288092094127,
                0.045673518029726363,
                0.04581810301880847,
                0.045866331823801475,
                0.0458181030188086,
                0.04567351802972539,
                0.045432880920941034,
                0.045096697755877525,
                0.04466567553272997,
                0.04414072069761737,
                0.0435229372383103,
                0.04281362436248932,
                0.04201427376548213,
                0.04112656649314751,
                0.04015236940656412,
                0.039093731255915816,
                0.0379528783718347,
                0.03673220998324021,
                0.03543429317151506,
                0.03406185747157792,
                0.0326177891311697,
                0.031105125040323835,
                0.029527046343650352,
                0.027886871748594996,
                0.026188050543283787,
                0.024434155337754622,
                0.022628874542110558,
                0.020776004593876792,
                0.018879441943171447,
                0.016943174794505283,
                0.014971274576809909,
                0.012967887031228949,
                0.010937222525842345,
                0.008883544073180956,
                0.006811145733864281,
                0.00472427200191792,
                0.002626359191530236,
                0.0004262574595055283,
            ],
            "generator": "gauss_lobatto",
        },
        70: {
            "degree": 137,
            "points": [
                -0.9999999999999994,
                -0.9984805122099639,
                -0.9949092466945841,
                -0.9893048888177725,
                -0.9816793228104479,
                -0.9720482041147676,
                -0.9604312304918297,
                -0.9468521429009757,
                -0.9313386862253208,
                -0.9139225553452002,
                -0.8946393313808048,
                -0.8735284094124107,
                -0.8506329181864147,
                -0.8259996320990892,
                -0.7996788756886377,
                -0.7717244208527301,
                -0.7421933770118097,
                -0.7111460744476923,
                -0.6786459410584782,
                -0.6447593727830205,
                -0.6095555979605143,
                -0.5731065359027903,
                -0.5354866499685602,
                -0.49677279543993724,
                -0.4570440625121517,
                -0.4163816147172883,
                -0.37486852311219687,
                -0.3325895965693497,
                -0.2896312085173822,
                -0.2460811204852822,
                -0.20202830281074524,
                -0.15756275287897203,
                -0.11277531126325369,
                -0.06775747614295136,
                -0.022601216378025812,
                0.0226012163780257,
                0.06775747614295147,
                0.11277531126325324,
                0.15756275287897215,
                0.20202830281074458,
                0.2460811204852822,
                0.2896312085173819,
                0.33258959656934983,
                0.374868523112197,
                0.4163816147172881,
                0.4570440625121518,
                0.49677279543993746,
                0.5354866499685603,
                0.5731065359027903,
                0.6095555979605137,
                0.6447593727830204,
                0.678645941058478,
                0.7111460744476921,
                0.7421933770118094,
                0.7717244208527301,
                0.7996788756886376,
                0.825999632099089,
                0.8506329181864147,
                0.873528409412411,
                0.8946393313808051,
                0.9139225553452001,
                0.931338686225321,
                0.9468521429009761,
                0.9604312304918297,
                0.9720482041147672,
                0.9816793228104476,
                0.9893048888177725,
                0.9949092466945841,
                0.9984805122099641,
                1.0,
            ],
            "weights": [
                0.0004140786749487133,
                0.0025513583788865893,
                0.004589522189693926,
                0.0066172375688972685,
                0.008631287197510648,
                0.01062766702430861,
                0.01260232270507087,
                0.014551227422678845,
                0.016470402383505164,
                0.0183559279843258,
                0.02020395275887054,
                0.022010701586047638,
                0.023772483540922273,
                0.025485699497132083,
                0.027146849509670046,
                0.028752539980475056,
                0.030299490599709416,
                0.031784541051951484,
                0.03320465747533383,
                0.03455693866123236,
                0.03583862198233217,
                0.03704708903719765,
                0.03817987099997308,
                0.039234653664343686,
                0.040209282171539254,
                0.04110176541273432,
                0.04191028009686807,
                0.04263317447559654,
                0.04326897171777504,
                0.04381637292657152,
                0.044274259793083554,
                0.044641696880977404,
                0.04491793353756583,
                0.04510240542734604,
                0.04519473568492468,
                0.045194735684924964,
                0.04510240542734612,
                0.04491793353756605,
                0.044641696880977785,
                0.04427425979308281,
                0.043816372926572325,
                0.043268971717774565,
                0.042633174475595906,
                0.041910280096868854,
                0.04110176541273527,
                0.040209282171538845,
                0.0392346536643433,
                0.03817987099997336,
                0.03704708903719803,
                0.03583862198233179,
                0.03455693866123216,
                0.033204657475333944,
                0.03178454105195128,
                0.030299490599709007,
                0.02875253998047553,
                0.027146849509669023,
                0.02548569949713187,
                0.023772483540922366,
                0.022010701586047593,
                0.020203952758869863,
                0.018355927984326007,
                0.01647040238350613,
                0.01455122742267971,
                0.012602322705071025,
                0.010627667024309694,
                0.00863128719750995,
                0.006617237568895888,
                0.004589522189694492,
                0.0025513583788869918,
                0.00041407867494824005,
            ],
            "generator": "gauss_lobatto",
        },
        71: {
            "degree": 139,
            "points": [
                -0.9999999999999992,
                -0.9985233041462528,
                -0.995052529841169,
                -0.9896056365744195,
                -0.9821938612364423,
                -0.9728319938997525,
                -0.9615386430027644,
                -0.9483362383655043,
                -0.933250995623832,
                -0.9163128668575786,
                -0.8975554820888356,
                -0.8770160829114597,
                -0.8547354487339411,
                -0.8307578159063278,
                -0.8051307899411058,
                -0.7779052510237576,
                -0.7491352530106141,
                -0.7188779161195176,
                -0.6871933135289565,
                -0.6541443521122483,
                -0.6197966475443715,
                -0.5842183940298926,
                -0.5474802289109186,
                -0.5096550924240717,
                -0.47081808288502947,
                -0.43104630758823004,
                -0.3904187297178259,
                -0.3490160115738443,
                -0.30692035442485777,
                -0.2642153353051304,
                -0.22098574108026936,
                -0.1773174001108513,
                -0.1332970118482395,
                -0.08901197470090882,
                -0.04455021251305702,
                2.220446049250313e-16,
                0.04455021251305702,
                0.08901197470090894,
                0.1332970118482396,
                0.17731740011085162,
                0.22098574108026903,
                0.2642153353051304,
                0.30692035442485854,
                0.3490160115738441,
                0.390418729717826,
                0.4310463075882306,
                0.47081808288502935,
                0.509655092424072,
                0.5474802289109186,
                0.5842183940298924,
                0.6197966475443717,
                0.6541443521122488,
                0.6871933135289567,
                0.7188779161195178,
                0.7491352530106141,
                0.7779052510237578,
                0.8051307899411062,
                0.8307578159063281,
                0.8547354487339418,
                0.8770160829114602,
                0.8975554820888362,
                0.9163128668575791,
                0.9332509956238321,
                0.9483362383655042,
                0.9615386430027649,
                0.972831993899753,
                0.9821938612364427,
                0.9896056365744197,
                0.9950525298411693,
                0.9985233041462532,
                1.0,
            ],
            "weights": [
                0.00040241448692213616,
                0.002479524518262714,
                0.004460453388050698,
                0.006431484365408235,
                0.00838960326302823,
                0.010331029836523944,
                0.012251933027002561,
                0.014148506144262944,
                0.016016986348394612,
                0.017853665073262196,
                0.01965489630202723,
                0.021417104136272562,
                0.02313679003031089,
                0.02481053979754386,
                0.026435030418130025,
                0.0280070366515093,
                0.029523437447917477,
                0.030981222149531636,
                0.03237749647056006,
                0.033709488245209945,
                0.034974552932610314,
                0.036170178867950396,
                0.03729399224961595,
                0.03834376185242098,
                0.039317403457716185,
                0.040212983991550856,
                0.041028725362707755,
                0.04176300799300834,
                0.04241437403289533,
                0.04298153025588953,
                0.043463350626194434,
                0.043858878534370815,
                0.044167328696597084,
                0.04438808871379694,
                0.044520720287505235,
                0.04456496009007845,
                0.044520720287505346,
                0.044388088713796174,
                0.0441673286965968,
                0.04385887853437001,
                0.04346335062619535,
                0.04298153025588867,
                0.04241437403289595,
                0.04176300799300914,
                0.04102872536270711,
                0.040212983991550176,
                0.03931740345771648,
                0.038343761852420964,
                0.03729399224961591,
                0.03617017886795159,
                0.03497455293260911,
                0.0337094882452097,
                0.03237749647055911,
                0.030981222149531962,
                0.029523437447916957,
                0.028007036651509266,
                0.026435030418129727,
                0.024810539797543094,
                0.023136790030310814,
                0.02141710413627228,
                0.019654896302027776,
                0.017853665073263258,
                0.016016986348395684,
                0.014148506144263587,
                0.012251933027002301,
                0.010331029836525,
                0.008389603263027342,
                0.006431484365407097,
                0.004460453388051237,
                0.002479524518263219,
                0.0004024144869215259,
            ],
            "generator": "gauss_lobatto",
        },
        72: {
            "degree": 141,
            "points": [
                -0.9999999999999994,
                -0.9985643136582948,
                -0.9951898492926192,
                -0.9898938816034137,
                -0.9826870440705524,
                -0.9735833204278224,
                -0.9626003040321935,
                -0.9497592027536874,
                -0.9350848067555209,
                -0.9186054432447393,
                -0.9003529227315468,
                -0.8803624780141479,
                -0.8586726963474791,
                -0.8353254450475629,
                -0.810365790723049,
                -0.7838419123106815,
                -0.7558050080923158,
                -0.7263091968777897,
                -0.6954114135469438,
                -0.6631712991538057,
                -0.6296510858058584,
                -0.5949154765410676,
                -0.5590315204348275,
                -0.5220684831780742,
                -0.4840977133764923,
                -0.4451925048289782,
                -0.4054279550512394,
                -0.36488082031765634,
                -0.32362936750122984,
                -0.28175322299762895,
                -0.2393332190249593,
                -0.19645123759595107,
                -0.1531900524637353,
                -0.1096331693463215,
                -0.06586466473816133,
                -0.021969023619967887,
                0.021969023619968775,
                0.06586466473816222,
                0.10963316934632206,
                0.15319005246373607,
                0.1964512375959513,
                0.2393332190249602,
                0.2817532229976296,
                0.3236293675012304,
                0.36488082031765723,
                0.4054279550512401,
                0.44519250482897854,
                0.484097713376493,
                0.5220684831780749,
                0.5590315204348284,
                0.5949154765410678,
                0.6296510858058589,
                0.6631712991538066,
                0.6954114135469445,
                0.7263091968777902,
                0.7558050080923163,
                0.783841912310682,
                0.8103657907230495,
                0.8353254450475642,
                0.8586726963474801,
                0.8803624780141486,
                0.9003529227315474,
                0.9186054432447399,
                0.9350848067555216,
                0.9497592027536874,
                0.9626003040321947,
                0.9735833204278233,
                0.9826870440705534,
                0.989893881603415,
                0.9951898492926201,
                0.998564313658295,
                1.0,
            ],
            "weights": [
                0.00039123630672969714,
                0.00241068181039422,
                0.00433675084444726,
                0.006253435673704117,
                0.008157910705594466,
                0.010046604223576066,
                0.011915893352301947,
                0.013762176749173845,
                0.015581893148042215,
                0.017371531103961817,
                0.019127636658309945,
                0.02084682032695991,
                0.022525763773816737,
                0.02416122627474472,
                0.02575005100134016,
                0.027289171129007587,
                0.02877561576463435,
                0.03020651568567389,
                0.031579108881137685,
                0.03289074588462229,
                0.03413889488948842,
                0.03532114663657014,
                0.03643521906512551,
                0.037478961718107266,
                0.03845035989331726,
                0.03934753853245789,
                0.04016876584060603,
                0.040912456629098634,
                0.04157717537543371,
                0.04216163899423803,
                0.042664719314015144,
                0.04308544525481996,
                0.043423004702727704,
                0.04367674607744292,
                0.04384617959003031,
                0.04393097818834913,
                0.04393097818834937,
                0.04384617959003003,
                0.043676746077443235,
                0.0434230047027278,
                0.043085445254820366,
                0.04266471931401472,
                0.04216163899423892,
                0.041577175375432304,
                0.04091245662909824,
                0.040168765840606094,
                0.039347538532458766,
                0.03845035989331683,
                0.03747896171810747,
                0.03643521906512605,
                0.035321146636569344,
                0.03413889488948712,
                0.03289074588462184,
                0.03157910888113759,
                0.03020651568567358,
                0.02877561576463456,
                0.027289171129007254,
                0.02575005100134002,
                0.02416122627474425,
                0.02252576377381645,
                0.020846820326959965,
                0.019127636658311974,
                0.017371531103962362,
                0.015581893148042921,
                0.013762176749173445,
                0.01191589335230166,
                0.010046604223577279,
                0.008157910705593447,
                0.00625343567370322,
                0.00433675084444776,
                0.0024106818103947127,
                0.00039123630672923407,
            ],
            "generator": "gauss_lobatto",
        },
        73: {
            "degree": 143,
            "points": [
                -0.9999999999999994,
                -0.9986036383747318,
                -0.9953215313951849,
                -0.9901703070802101,
                -0.9831600358879731,
                -0.974303949477461,
                -0.9636186943792271,
                -0.9511243385275139,
                -0.9368443420626029,
                -0.9208055158176811,
                -0.9030379718969634,
                -0.8835750675203689,
                -0.8624533425714411,
                -0.8397124510832277,
                -0.8153950868374027,
                -0.789546903236571,
                -0.762216427609655,
                -0.7334549701159729,
                -0.7033165274214779,
                -0.6718576813293617,
                -0.6391374925560935,
                -0.6052173898527733,
                -0.570161054680232,
                -0.534034301654575,
                -0.4969049549877065,
                -0.45884272115489666,
                -0.4199190580284813,
                -0.38020704072341305,
                -0.3397812244065608,
                -0.2987175043273129,
                -0.2570929733322924,
                -0.21498577713168077,
                -0.17247496758888614,
                -0.12964035430899035,
                -0.08656235480460395,
                -0.04332184352043322,
                2.220446049250313e-16,
                0.043321843520434,
                0.08656235480460461,
                0.1296403543089909,
                0.1724749675888868,
                0.21498577713168154,
                0.2570929733322931,
                0.29871750432731337,
                0.33978122440656133,
                0.3802070407234137,
                0.4199190580284814,
                0.45884272115489777,
                0.49690495498770737,
                0.5340343016545757,
                0.5701610546802326,
                0.6052173898527737,
                0.6391374925560946,
                0.6718576813293629,
                0.703316527421479,
                0.733454970115974,
                0.7622164276096561,
                0.7895469032365717,
                0.8153950868374036,
                0.8397124510832281,
                0.8624533425714417,
                0.8835750675203696,
                0.9030379718969638,
                0.9208055158176814,
                0.9368443420626033,
                0.9511243385275137,
                0.9636186943792272,
                0.9743039494774614,
                0.9831600358879738,
                0.9901703070802109,
                0.9953215313951855,
                0.998603638374732,
                1.0,
            ],
            "weights": [
                0.00038051750380560165,
                0.0023446664855929548,
                0.004218121295625208,
                0.006082671687519448,
                0.007935667326764456,
                0.00977373097555506,
                0.011593434046129414,
                0.013391366934742946,
                0.015164156697001704,
                0.016908476171993758,
                0.018621051091402625,
                0.020298666538886734,
                0.021938173113069434,
                0.02353649289723792,
                0.025090625265342142,
                0.02659765252949104,
                0.028054745425290028,
                0.029459168427803117,
                0.030808284889779665,
                0.03209956199323394,
                0.033330575505522146,
                0.03449901433120644,
                0.03560268485131464,
                0.03663951504190462,
                0.03760755836426363,
                0.038504997419459695,
                0.039330147360421716,
                0.040081459055121026,
                0.04075752199495844,
                0.04135706694289014,
                0.04187896831629331,
                0.04232224630017172,
                0.04268606868666411,
                0.04296975243742779,
                0.04317276496599492,
                0.04329472513764396,
                0.043335403984949894,
                0.04329472513764412,
                0.04317276496599444,
                0.0429697524374274,
                0.04268606868666355,
                0.042322246300172325,
                0.04187896831629321,
                0.041357066942888814,
                0.04075752199496003,
                0.040081459055121546,
                0.03933014736042184,
                0.03850499741945937,
                0.03760755836426315,
                0.03663951504190491,
                0.03560268485131449,
                0.034499014331205974,
                0.03333057550552149,
                0.032099561993234105,
                0.03080828488977987,
                0.029459168427803196,
                0.028054745425290323,
                0.026597652529491495,
                0.02509062526534047,
                0.02353649289723796,
                0.021938173113069472,
                0.020298666538887688,
                0.01862105109140472,
                0.016908476171993727,
                0.01516415669700164,
                0.013391366934741484,
                0.011593434046129279,
                0.009773730975556066,
                0.007935667326763525,
                0.006082671687518759,
                0.004218121295625799,
                0.0023446664855934565,
                0.0003805175038051699,
            ],
            "generator": "gauss_lobatto",
        },
        74: {
            "degree": 145,
            "points": [
                -0.9999999999999993,
                -0.9986413693307293,
                -0.995447880478955,
                -0.9904355501709707,
                -0.9836139230200338,
                -0.9749955285502923,
                -0.9645961292899683,
                -0.9524347287404771,
                -0.9385335449116674,
                -0.9229179721992162,
                -0.9056165358854884,
                -0.8866608404001635,
                -0.8660855117574529,
                -0.8439281343893268,
                -0.8202291825355272,
                -0.7950319463354136,
                -0.7683824527658414,
                -0.7403293815741105,
                -0.7109239763619086,
                -0.680219950984015,
                -0.648273391433458,
                -0.6151426533928248,
                -0.5808882556390975,
                -0.545572769496913,
                -0.5092607045422854,
                -0.4720183907656299,
                -0.4339138574093977,
                -0.3950167087016643,
                -0.3553979967126877,
                -0.31513009156671035,
                -0.2742865492460813,
                -0.23294197722919208,
                -0.19117189820766822,
                -0.1490526121317497,
                -0.10666105683588345,
                -0.06407466749910218,
                -0.021371235196913085,
                0.021371235196913974,
                0.06407466749910296,
                0.10666105683588412,
                0.14905261213175025,
                0.191171898207669,
                0.2329419772291933,
                0.274286549246082,
                0.3151300915667111,
                0.35539799671268824,
                0.39501670870166516,
                0.43391385740939914,
                0.47201839076563057,
                0.5092607045422859,
                0.5455727694969141,
                0.5808882556390986,
                0.6151426533928259,
                0.6482733914334586,
                0.6802199509840154,
                0.7109239763619098,
                0.7403293815741113,
                0.7683824527658427,
                0.7950319463354146,
                0.8202291825355289,
                0.8439281343893276,
                0.866085511757454,
                0.8866608404001644,
                0.9056165358854885,
                0.9229179721992167,
                0.9385335449116681,
                0.9524347287404782,
                0.9645961292899695,
                0.9749955285502928,
                0.9836139230200353,
                0.9904355501709721,
                0.9954478804789564,
                0.9986413693307297,
                1.0,
            ],
            "weights": [
                0.0003702332469460042,
                0.002281325829438644,
                0.0041042912316340205,
                0.005918800778778612,
                0.007722367145175135,
                0.009511794638849144,
                0.011283836158922879,
                0.013035261295964749,
                0.014762873201952846,
                0.016463517146053354,
                0.01813408711659577,
                0.019771531798533932,
                0.021372860271049524,
                0.02293514752643444,
                0.024455539839882478,
                0.025931259996049224,
                0.02735961236955386,
                0.028737987853196013,
                0.030063868626402507,
                0.03133483275595762,
                0.032548558621008694,
                0.033702829154501485,
                0.03479553589341171,
                0.03582468283049079,
                0.03678839006046253,
                0.03768489721412567,
                0.03851256667404749,
                0.039269886566008855,
                0.03995547352073241,
                0.0405680752008794,
                0.04110657258867306,
                0.04156998202998955,
                0.04195745703117201,
                0.0422682898053182,
                0.04250191256515795,
                0.04265789856023126,
                0.04273596285641825,
                0.04273596285641848,
                0.042657898560231,
                0.04250191256515834,
                0.04226828980531815,
                0.041957457031173345,
                0.041569982029988586,
                0.041106572588673264,
                0.040568075200880335,
                0.03995547352073146,
                0.039269886566008105,
                0.03851256667404746,
                0.03768489721412567,
                0.036788390060462556,
                0.03582468283049088,
                0.0347955358934127,
                0.033702829154500465,
                0.032548558621008666,
                0.0313348327559574,
                0.03006386862640199,
                0.028737987853196267,
                0.027359612369554424,
                0.025931259996049425,
                0.024455539839881024,
                0.022935147526434333,
                0.021372860271050263,
                0.019771531798535167,
                0.018134087116596788,
                0.016463517146052722,
                0.01476287320195259,
                0.013035261295962724,
                0.011283836158923179,
                0.009511794638850105,
                0.007722367145174449,
                0.005918800778778063,
                0.004104291231634641,
                0.0022813258294392615,
                0.00037023324694556293,
            ],
            "generator": "gauss_lobatto",
        },
        75: {
            "degree": 147,
            "points": [
                -0.9999999999999993,
                -0.9986775914951751,
                -0.9955691806160256,
                -0.9906902056995024,
                -0.9840497197732121,
                -0.9756595962390613,
                -0.965534771513308,
                -0.9536932542508123,
                -0.9401561013542648,
                -0.9249473829322215,
                -0.9080941403674938,
                -0.8896263385955019,
                -0.8695768129911383,
                -0.8479812110697924,
                -0.8248779291503703,
                -0.8003080441120989,
                -0.7743152403754197,
                -0.74694573224126,
                -0.7182481817290955,
                -0.6882736120611497,
                -0.6570753169473009,
                -0.624708765832396,
                -0.5912315052747017,
                -0.5567030566310069,
                -0.5211848102303858,
                -0.48473991622484025,
                -0.44743317231094126,
                -0.40933090852211973,
                -0.3705008692964644,
                -0.3310120930297116,
                -0.2909347893276122,
                -0.25034021417588903,
                -0.20930054324976788,
                -0.16788874358831696,
                -0.12617844386175414,
                -0.08424380346240246,
                -0.042159380652026845,
                2.220446049250313e-16,
                0.042159380652026734,
                0.0842438034624019,
                0.12617844386175425,
                0.16788874358831685,
                0.2093005432497681,
                0.2503402141758889,
                0.2909347893276121,
                0.3310120930297119,
                0.37050086929646464,
                0.40933090852212006,
                0.4474331723109408,
                0.48473991622484014,
                0.5211848102303862,
                0.5567030566310074,
                0.5912315052747015,
                0.6247087658323958,
                0.6570753169473011,
                0.6882736120611497,
                0.7182481817290958,
                0.7469457322412603,
                0.7743152403754194,
                0.8003080441120988,
                0.8248779291503707,
                0.8479812110697927,
                0.8695768129911386,
                0.8896263385955022,
                0.9080941403674935,
                0.9249473829322215,
                0.9401561013542649,
                0.9536932542508127,
                0.9655347715133081,
                0.9756595962390606,
                0.9840497197732123,
                0.9906902056995024,
                0.9955691806160258,
                0.9986775914951753,
                1.0,
            ],
            "weights": [
                0.00036036036036071376,
                0.002220517299294857,
                0.0039950053212112055,
                0.005761457260425137,
                0.007517537537301218,
                0.009260220087136799,
                0.010986427491338635,
                0.012693096958961791,
                0.01437719644848068,
                0.016035732702303403,
                0.017665757385581807,
                0.019264372623930482,
                0.020828736276305194,
                0.0223560670422066,
                0.023843649432795537,
                0.025288838612329174,
                0.02668906510782605,
                0.028041839381615294,
                0.0293447562600401,
                0.030595499211258644,
                0.03179184446485492,
                0.03293166496623063,
                0.03401293415880859,
                0.035033729587448825,
                0.03599223631667744,
                0.03688675015770327,
                0.03771568069848738,
                0.03847755413151208,
                0.03917101587419455,
                0.03979483297732176,
                0.040347896317214464,
                0.04082922256772379,
                0.041237955948577217,
                0.04157336974691685,
                0.04183486760938663,
                0.04202198460243227,
                0.042134388038937744,
                0.04217187806973751,
                0.04213438803893783,
                0.042021984602431756,
                0.04183486760938613,
                0.041573369746916826,
                0.041237955948576516,
                0.040829222567725,
                0.04034789631721356,
                0.039794832977320664,
                0.03917101587419504,
                0.03847755413151273,
                0.037715680698487866,
                0.03688675015770287,
                0.035992236316677646,
                0.03503372958744922,
                0.03401293415880861,
                0.03293166496622993,
                0.03179184446485467,
                0.030595499211257957,
                0.02934475626004073,
                0.028041839381614742,
                0.02668906510782646,
                0.025288838612328095,
                0.023843649432795815,
                0.02235606704220675,
                0.02082873627630593,
                0.019264372623931263,
                0.017665757385581626,
                0.01603573270230269,
                0.014377196448480633,
                0.012693096958960242,
                0.010986427491339342,
                0.00926022008713769,
                0.007517537537301075,
                0.005761457260424857,
                0.003995005321211914,
                0.002220517299295484,
                0.0003603603603603458,
            ],
            "generator": "gauss_lobatto",
        },
        76: {
            "degree": 149,
            "points": [
                -0.9999999999999996,
                -0.9987123842493484,
                -0.9956856972170369,
                -0.9909348294778535,
                -0.9844683740794968,
                -0.9762975907424487,
                -0.9664366431735452,
                -0.9549026093841073,
                -0.941715459941125,
                -0.9268980257277608,
                -0.910475959260252,
                -0.8924776906261978,
                -0.8729343784259576,
                -0.8518798559103613,
                -0.8293505724509944,
                -0.8053855304630548,
                -0.7800262178987163,
                -0.7533165364322063,
                -0.7253027254631943,
                -0.6960332820712969,
                -0.665558877060993,
                -0.6339322672426828,
                -0.6012082041020299,
                -0.5674433390158347,
                -0.5326961251786375,
                -0.4970267164098916,
                -0.4604968630169455,
                -0.4231698048941339,
                -0.3851101620430666,
                -0.34638382270366064,
                -0.3070578292895887,
                -0.26720026232562244,
                -0.2268801225877921,
                -0.18616721165041672,
                -0.14513201104679374,
                -0.10384556025274438,
                -0.06237933370425974,
                -0.02080511706214261,
                0.020805117062143275,
                0.06237933370426063,
                0.10384556025274538,
                0.14513201104679463,
                0.18616721165041794,
                0.2268801225877929,
                0.26720026232562333,
                0.30705782928959013,
                0.3463838227036612,
                0.38511016204306703,
                0.42316980489413425,
                0.46049686301694637,
                0.49702671640989227,
                0.5326961251786382,
                0.5674433390158354,
                0.6012082041020305,
                0.6339322672426833,
                0.6655588770609937,
                0.6960332820712978,
                0.7253027254631941,
                0.7533165364322065,
                0.7800262178987164,
                0.8053855304630549,
                0.8293505724509946,
                0.8518798559103616,
                0.8729343784259578,
                0.8924776906261979,
                0.9104759592602517,
                0.926898025727761,
                0.9417154599411249,
                0.9549026093841084,
                0.9664366431735457,
                0.9762975907424483,
                0.9844683740794967,
                0.9909348294778539,
                0.9956856972170373,
                0.9987123842493485,
                1.0,
            ],
            "weights": [
                0.00035087719298265284,
                0.0021621077221014363,
                0.0038900249816129786,
                0.005610299353547233,
                0.007320736637641433,
                0.00901846940086317,
                0.010700579009352935,
                0.012364159597680986,
                0.014006333494405356,
                0.015624258777817574,
                0.01721513499120443,
                0.01877620827882826,
                0.02030477627073774,
                0.021798192813625304,
                0.023253872577177467,
                0.024669295542790542,
                0.026042011373255507,
                0.02736964365872945,
                0.028649894033093683,
                0.029880546154275385,
                0.03105946954204469,
                0.0321846232668408,
                0.033254059483372615,
                0.03426592680296306,
                0.035218473498808994,
                0.036110050538668836,
                0.036939114439720956,
                0.03770422994069043,
                0.038404072486580426,
                0.03903743052176332,
                0.03960320758743252,
                0.040100424219785595,
                0.040528219645669133,
                0.04088585327275326,
                0.04117270597164215,
                0.04138828114769191,
                0.04153220560072807,
                0.04160423017111857,
                0.041604230171119146,
                0.04153220560072759,
                0.041388281147692246,
                0.041172705971642215,
                0.040885853272754256,
                0.04052821964566934,
                0.040100424219784714,
                0.03960320758743363,
                0.03903743052176471,
                0.03840407248657992,
                0.037704229940689865,
                0.03693911443972085,
                0.036110050538668316,
                0.035218473498809556,
                0.03426592680296324,
                0.03325405948337201,
                0.03218462326683948,
                0.03105946954204442,
                0.0298805461542754,
                0.02864989403309359,
                0.027369643658729702,
                0.02604201137325562,
                0.02466929554279047,
                0.023253872577177082,
                0.021798192813625782,
                0.020304776270737936,
                0.01877620827882789,
                0.01721513499120386,
                0.01562425877781701,
                0.01400633349440516,
                0.01236415959768051,
                0.010700579009354031,
                0.009018469400863604,
                0.007320736637641627,
                0.005610299353547191,
                0.003890024981613637,
                0.002162107722102005,
                0.00035087719298244733,
            ],
            "generator": "gauss_lobatto",
        },
        77: {
            "degree": 151,
            "points": [
                -0.9999999999999994,
                -0.9987458218220998,
                -0.995797678482873,
                -0.9911699413353943,
                -0.9848707726367407,
                -0.9769108576142822,
                -0.9673036365806087,
                -0.9560653162024657,
                -0.9432148497856685,
                -0.928773907588027,
                -0.9127668410978205,
                -0.8952206423101308,
                -0.876164898367183,
                -0.8556317417446355,
                -0.8336557961097277,
                -0.8102741179607507,
                -0.7855261341547508,
                -0.7594535754330713,
                -0.7321004060589911,
                -0.7035127496873474,
                -0.6737388115918306,
                -0.6428287973814859,
                -0.6108348283437468,
                -0.5778108535568887,
                -0.5438125589202136,
                -0.508897273255412,
                -0.4731238716374935,
                -0.43655267611830384,
                -0.3992453540100689,
                -0.3612648139004788,
                -0.3226750995746803,
                -0.2835412820230443,
                -0.24392934971681624,
                -0.20390609733667908,
                -0.16353901314185282,
                -0.12289616516965518,
                -0.08204608645742373,
                -0.04105765948033602,
                2.220446049250313e-16,
                0.04105765948033624,
                0.08204608645742373,
                0.12289616516965562,
                0.1635390131418536,
                0.20390609733668008,
                0.243929349716817,
                0.28354128202304474,
                0.32267509957468066,
                0.36126481390047926,
                0.3992453540100689,
                0.4365526761183043,
                0.47312387163749337,
                0.508897273255412,
                0.5438125589202134,
                0.577810853556889,
                0.6108348283437469,
                0.6428287973814861,
                0.6737388115918308,
                0.7035127496873479,
                0.7321004060589915,
                0.759453575433072,
                0.7855261341547508,
                0.81027411796075,
                0.8336557961097284,
                0.8556317417446355,
                0.8761648983671831,
                0.8952206423101317,
                0.9127668410978202,
                0.9287739075880269,
                0.9432148497856688,
                0.9560653162024666,
                0.9673036365806088,
                0.9769108576142814,
                0.9848707726367405,
                0.9911699413353945,
                0.9957976784828728,
                0.9987458218221,
                1.0,
            ],
            "weights": [
                0.00034176349965850893,
                0.0021059725650110295,
                0.003789127077950789,
                0.005465007337773884,
                0.00713155097182727,
                0.00878603902398952,
                0.0104257015745436,
                0.012047779796152331,
                0.01364954073054345,
                0.01522828440389468,
                0.01678134915428198,
                0.018306116400209835,
                0.019800015170457264,
                0.021260526490503362,
                0.022685187654798922,
                0.024071596392137518,
                0.025417414923312932,
                0.026720373907026314,
                0.02797827626880353,
                0.02918900090715075,
                0.030350506271086177,
                0.03146083380321885,
                0.032518111242686075,
                0.03352055578245848,
                0.03446647707573644,
                0.03535428008635835,
                0.036182467778488894,
                0.03694964364101834,
                0.03765451404244298,
                0.03829589041224192,
                0.038872691245114804,
                0.03938394392464736,
                0.039828786363392946,
                0.04020646845654595,
                0.04051635334679221,
                0.04075791849821434,
                0.04093075657739728,
                0.04103457614029537,
                0.04106920212367169,
                0.041034576140295445,
                0.04093075657739739,
                0.04075791849821404,
                0.04051635334679253,
                0.04020646845654474,
                0.039828786363393494,
                0.039383943924648286,
                0.03887269124511367,
                0.038295890412240935,
                0.037654514042442494,
                0.036949643641018895,
                0.036182467778488825,
                0.03535428008635831,
                0.03446647707573644,
                0.033520555782459015,
                0.03251811124268531,
                0.03146083380321842,
                0.030350506271086493,
                0.029189000907150806,
                0.027978276268803025,
                0.02672037390702628,
                0.025417414923312714,
                0.024071596392137757,
                0.022685187654797982,
                0.021260526490503574,
                0.019800015170457045,
                0.01830611640020927,
                0.016781349154281817,
                0.01522828440389484,
                0.013649540730543155,
                0.012047779796152956,
                0.01042570157454499,
                0.008786039023989552,
                0.007131550971827604,
                0.005465007337773822,
                0.003789127077951376,
                0.002105972565011574,
                0.0003417634996582166,
            ],
            "generator": "gauss_lobatto",
        },
        78: {
            "degree": 153,
            "points": [
                -0.9999999999999994,
                -0.9987779736859993,
                -0.9959053567263083,
                -0.9913960278771217,
                -0.9852577455908673,
                -0.9775006568246825,
                -0.9681375240848882,
                -0.9571837375196817,
                -0.9446572970506766,
                -0.9305787850131768,
                -0.9149713331378035,
                -0.8978605848748651,
                -0.8792746534131892,
                -0.859244075565158,
                -0.8378017616345144,
                -0.8149829413670369,
                -0.7908251060811657,
                -0.7653679470777845,
                -0.7386532904324996,
                -0.7107250282787354,
                -0.6816290466952306,
                -0.6514131503167895,
                -0.6201269837924093,
                -0.5878219502199744,
                -0.5545511266916143,
                -0.5203691770885674,
                -0.4853322622688423,
                -0.4494979477952863,
                -0.41292510935568316,
                -0.3756738360302716,
                -0.33780533156563974,
                -0.2993818138172133,
                -0.2604664125255347,
                -0.22112306559431927,
                -0.18141641404068554,
                -0.141411695790171,
                -0.10117463849101416,
                -0.060771351523831285,
                -0.02026821738409823,
                0.02026821738409823,
                0.06077135152383162,
                0.1011746384910146,
                0.14141169579017132,
                0.1814164140406861,
                0.22112306559431938,
                0.26046641252553493,
                0.2993818138172136,
                0.3378053315656404,
                0.3756738360302714,
                0.4129251093556835,
                0.4494979477952864,
                0.4853322622688422,
                0.5203691770885679,
                0.5545511266916145,
                0.587821950219974,
                0.6201269837924097,
                0.6514131503167898,
                0.6816290466952311,
                0.7107250282787356,
                0.7386532904324996,
                0.7653679470777854,
                0.7908251060811664,
                0.8149829413670369,
                0.8378017616345146,
                0.8592440755651585,
                0.87927465341319,
                0.8978605848748656,
                0.9149713331378041,
                0.9305787850131775,
                0.9446572970506771,
                0.9571837375196821,
                0.9681375240848891,
                0.9775006568246825,
                0.9852577455908675,
                0.9913960278771224,
                0.9959053567263088,
                0.9987779736859994,
                1.0,
            ],
            "weights": [
                0.0003330003330005759,
                0.002051995271407571,
                0.003692102738811854,
                0.0053252818663183455,
                0.006949593299153848,
                0.008562457170302523,
                0.010161242958429302,
                0.011743329722727408,
                0.013306120273912576,
                0.014847047884015455,
                0.016363581258287817,
                0.017853228967268372,
                0.019313543651581968,
                0.020742126092806536,
                0.022136629179460618,
                0.023494761775674382,
                0.02481429249220242,
                0.02609305335640614,
                0.02732894337643572,
                0.02851993199452019,
                0.029664062424017715,
                0.030759454864958718,
                0.03180430959291491,
                0.032796909916174954,
                0.0337356249964466,
                0.03461891252841846,
                0.03544532127385675,
                0.03621349344603863,
                0.03692216694063975,
                0.037570177409399844,
                0.038156460173161,
                0.03868005197116243,
                0.039140092543670235,
                0.039535826045409436,
                0.039866602287418604,
                0.040131877805309704,
                0.04033121675218458,
                0.04046429161473753,
                0.040530883751356904,
                0.04053088375135724,
                0.04046429161473701,
                0.04033121675218469,
                0.04013187780530978,
                0.039866602287418285,
                0.03953582604541059,
                0.03914009254366955,
                0.03868005197116107,
                0.03815646017316217,
                0.037570177409400635,
                0.03692216694064043,
                0.03621349344603836,
                0.03544532127385638,
                0.03461891252841827,
                0.0337356249964467,
                0.03279690991617572,
                0.03180430959291388,
                0.03075945486495848,
                0.029664062424016993,
                0.028519931994519493,
                0.027328943376435988,
                0.02609305335640647,
                0.024814292492202464,
                0.02349476177567228,
                0.02213662917946033,
                0.020742126092805926,
                0.019313543651581618,
                0.01785322896726871,
                0.01636358125828819,
                0.014847047884015934,
                0.0133061202739123,
                0.011743329722728374,
                0.010161242958430548,
                0.008562457170301978,
                0.006949593299154099,
                0.005325281866318291,
                0.003692102738812242,
                0.0020519952714079647,
                0.00033300033300032324,
            ],
            "generator": "gauss_lobatto",
        },
        79: {
            "degree": 155,
            "points": [
                -0.9999999999999994,
                -0.9988089049183994,
                -0.996008949576777,
                -0.9916135449985226,
                -0.9856300708059924,
                -0.9780681692020268,
                -0.9689399670718193,
                -0.958260088786484,
                -0.9460456400128996,
                -0.9323161824784494,
                -0.9170937034227586,
                -0.9004025807084781,
                -0.8822695439294548,
                -0.8627236316787164,
                -0.8417961450844882,
                -0.8195205977059048,
                -0.7959326618767522,
                -0.771070111587151,
                -0.744972761996783,
                -0.7176824056776518,
                -0.6892427456891459,
                -0.6596993255929564,
                -0.6290994565201671,
                -0.597492141407447,
                -0.5649279965237755,
                -0.5314591704134235,
                -0.4971392603850424,
                -0.4620232266806168,
                -0.42616730446175133,
                -0.3896289137542561,
                -0.3524665674952563,
                -0.3147397778300709,
                -0.2765089608089475,
                -0.23783533963625736,
                -0.19878084662709705,
                -0.15940802402830734,
                -0.11977992386274061,
                -0.07996000695715555,
                -0.040012041315454105,
                2.220446049250313e-16,
                0.04001204131545444,
                0.07996000695715544,
                0.11977992386274072,
                0.15940802402830834,
                0.19878084662709716,
                0.23783533963625791,
                0.2765089608089484,
                0.31473977783007123,
                0.3524665674952566,
                0.3896289137542569,
                0.4261673044617518,
                0.462023226680618,
                0.49713926038504386,
                0.5314591704134244,
                0.5649279965237759,
                0.5974921414074477,
                0.6290994565201679,
                0.6596993255929571,
                0.6892427456891468,
                0.7176824056776532,
                0.744972761996784,
                0.7710701115871521,
                0.7959326618767533,
                0.8195205977059062,
                0.8417961450844889,
                0.8627236316787177,
                0.8822695439294558,
                0.9004025807084792,
                0.9170937034227592,
                0.9323161824784506,
                0.946045640012901,
                0.9582600887864848,
                0.9689399670718203,
                0.9780681692020277,
                0.9856300708059933,
                0.9916135449985239,
                0.9960089495767781,
                0.9988089049183996,
                1.0,
            ],
            "weights": [
                0.00032456994482339067,
                0.002000066655693416,
                0.0035987562764346606,
                0.005190842429147137,
                0.006774500643656519,
                0.008347281454628989,
                0.009906685113140839,
                0.011450220086305784,
                0.012975416662037113,
                0.014479833284759585,
                0.015961061200965524,
                0.017416728582838676,
                0.018844504435087287,
                0.020242102376405016,
                0.02160728432437903,
                0.02293786409163001,
                0.024231710893311727,
                0.025486752763078595,
                0.02670097987331853,
                0.027872447755026893,
                0.028999280412543453,
                0.030079673328303424,
                0.031111896352978088,
                0.0320942964763749,
                0.03302530047475655,
                0.033903417430325836,
                0.034727241118873826,
                0.035495452261776674,
                0.03620682063875481,
                0.03686020705797322,
                0.03745456518039072,
                0.037988943195390375,
                0.038462485345029544,
                0.03887443329447233,
                0.03922412734639796,
                0.03951100749745284,
                0.039734614335055485,
                0.03989458977309805,
                0.03999067762540117,
                0.04002272401596674,
                0.03999067762540117,
                0.03989458977309844,
                0.03973461433505511,
                0.039511007497452975,
                0.0392241273463974,
                0.03887443329447158,
                0.038462485345030065,
                0.037988943195391214,
                0.03745456518039055,
                0.03686020705797226,
                0.036206820638753766,
                0.03549545226177691,
                0.03472724111887321,
                0.03390341743032634,
                0.03302530047475705,
                0.03209429647637386,
                0.031111896352977064,
                0.030079673328303164,
                0.028999280412542724,
                0.027872447755027365,
                0.02670097987331791,
                0.025486752763079,
                0.024231710893311362,
                0.022937864091628003,
                0.0216072843243788,
                0.02024210237640456,
                0.018844504435087357,
                0.017416728582840334,
                0.015961061200966024,
                0.01447983328476051,
                0.012975416662037309,
                0.011450220086306364,
                0.009906685113141956,
                0.008347281454628385,
                0.006774500643656522,
                0.005190842429147004,
                0.0035987562764348783,
                0.0020000666556937996,
                0.0003245699448230993,
            ],
            "generator": "gauss_lobatto",
        },
        80: {
            "degree": 157,
            "points": [
                -0.9999999999999994,
                -0.9988386765309248,
                -0.9961086610799041,
                -0.9918229201812148,
                -0.9859884777633527,
                -0.978614502316915,
                -0.9697125241807945,
                -0.9592964489562785,
                -0.9473825428435656,
                -0.9339894093478791,
                -0.9191379609908794,
                -0.9028513869715409,
                -0.8851551171023875,
                -0.866076782175049,
                -0.8456461708557808,
                -0.8238951831951018,
                -0.8008577808320068,
                -0.7765699339744179,
                -0.7510695652407089,
                -0.7243964904511069,
                -0.6965923564620522,
                -0.6677005761409713,
                -0.6377662605831955,
                -0.6068361486770311,
                -0.5749585341270165,
                -0.5421831900494032,
                -0.5085612912576027,
                -0.4741453343589952,
                -0.4389890557878575,
                -0.40314734790241924,
                -0.3666761732770507,
                -0.3296324773234198,
                -0.29207409937704853,
                -0.2540596823881005,
                -0.21564858135741294,
                -0.1769007706607435,
                -0.13787675040592462,
                -0.09863745196914975,
                -0.0592441428578816,
                -0.019758331048931765,
                0.019758331048931987,
                0.059244142857882265,
                0.09863745196915019,
                0.13787675040592495,
                0.1769007706607435,
                0.21564858135741316,
                0.25405968238810017,
                0.29207409937704853,
                0.32963247732342027,
                0.36667617327705104,
                0.40314734790241935,
                0.4389890557878582,
                0.47414533435899586,
                0.5085612912576036,
                0.542183190049404,
                0.5749585341270175,
                0.6068361486770318,
                0.6377662605831967,
                0.6677005761409718,
                0.6965923564620531,
                0.7243964904511073,
                0.7510695652407099,
                0.7765699339744185,
                0.8008577808320072,
                0.8238951831951027,
                0.8456461708557816,
                0.8660767821750499,
                0.8851551171023884,
                0.9028513869715415,
                0.9191379609908805,
                0.9339894093478802,
                0.9473825428435666,
                0.9592964489562796,
                0.9697125241807956,
                0.9786145023169163,
                0.9859884777633532,
                0.9918229201812159,
                0.9961086610799051,
                0.9988386765309251,
                1.0,
            ],
            "weights": [
                0.0003164556962028016,
                0.0019500843509773183,
                0.0035089042010289038,
                0.005061425949589471,
                0.006605932495168412,
                0.008140096727012804,
                0.009661541673696476,
                0.011167897347743518,
                0.01265681382026588,
                0.014125967211192183,
                0.015573064034917889,
                0.016995845040869012,
                0.01839208884689254,
                0.019759615455044413,
                0.02109628967828171,
                0.02240002448604993,
                0.02366878426930176,
                0.024900588022449748,
                0.02609351243860403,
                0.02724569491386489,
                0.028355336456369694,
                0.029420704495726365,
                0.030440135588557276,
                0.03141203801599491,
                0.032334894269127036,
                0.03320726341851358,
                0.03402778336410129,
                0.03479517296204074,
                0.03550823402508004,
                0.03616585319342861,
                0.036767003673141924,
                0.0373107468393762,
                0.03779623370193474,
                0.038222706230883634,
                0.03858949854013479,
                0.03889603792715097,
                0.03914184576714973,
                0.03932653826043559,
                0.039449827031651785,
                0.03951151958004741,
                0.03951151958004774,
                0.03944982703165141,
                0.039326538260435515,
                0.03914184576714971,
                0.03889603792715001,
                0.03858949854013584,
                0.03822270623088419,
                0.03779623370193382,
                0.03731074683937471,
                0.03676700367314195,
                0.036165853193428285,
                0.035508234025081326,
                0.03479517296204054,
                0.034027783364101435,
                0.033207263418513565,
                0.03233489426912701,
                0.03141203801599477,
                0.03044013558855631,
                0.029420704495726178,
                0.028355336456369562,
                0.027245694913864794,
                0.026093512438604007,
                0.02490058802244972,
                0.02366878426930055,
                0.022400024486050007,
                0.021096289678281418,
                0.019759615455044836,
                0.018392088846893327,
                0.01699584504087066,
                0.015573064034917752,
                0.014125967211192463,
                0.012656813820266264,
                0.011167897347743417,
                0.009661541673697325,
                0.00814009672701192,
                0.006605932495168286,
                0.005061425949589083,
                0.003508904201029047,
                0.0019500843509775727,
                0.00031645569620251837,
            ],
            "generator": "gauss_lobatto",
        },
        81: {
            "degree": 159,
            "points": [
                -0.9999999999999994,
                -0.9988673457705006,
                -0.9962046827021838,
                -0.9920245545909305,
                -0.9863336511254353,
                -0.979140695862641,
                -0.9704566588237951,
                -0.9602947704298548,
                -0.9486705082279148,
                -0.9356015753732589,
                -0.9211078744101708,
                -0.9052114772691726,
                -0.8879365917949777,
                -0.8693095249513572,
                -0.8493586427967572,
                -0.8281143273080511,
                -0.8056089301258431,
                -0.7818767232955937,
                -0.7569538470815567,
                -0.7308782549341117,
                -0.703689655694913,
                -0.675429453128221,
                -0.646140682870743,
                -0.6158679468961239,
                -0.584657345593975,
                -0.5525564075669327,
                -0.5196140172527028,
                -0.4858803404813139,
                -0.4514067480809838,
                -0.41624573764893547,
                -0.38045085360630626,
                -0.34407660565889353,
                -0.3071783857879209,
                -0.2698123838972337,
                -0.23203550224537817,
                -0.19390526879287884,
                -0.15547974959666777,
                -0.11681746038508067,
                -0.07797727744807337,
                -0.039018347978357015,
                2.220446049250313e-16,
                0.039018347978358126,
                0.07797727744807437,
                0.11681746038508156,
                0.15547974959666844,
                0.1939052687928795,
                0.23203550224537883,
                0.2698123838972346,
                0.307178385787922,
                0.3440766056588942,
                0.38045085360630715,
                0.4162457376489366,
                0.45140674808098435,
                0.4858803404813148,
                0.5196140172527037,
                0.5525564075669336,
                0.5846573455939756,
                0.615867946896125,
                0.6461406828707441,
                0.675429453128222,
                0.7036896556949142,
                0.7308782549341131,
                0.7569538470815571,
                0.7818767232955947,
                0.8056089301258444,
                0.8281143273080518,
                0.8493586427967581,
                0.8693095249513578,
                0.8879365917949784,
                0.9052114772691731,
                0.9211078744101717,
                0.93560157537326,
                0.9486705082279155,
                0.9602947704298557,
                0.9704566588237962,
                0.9791406958626417,
                0.9863336511254356,
                0.9920245545909314,
                0.996204682702185,
                0.9988673457705008,
                1.0,
            ],
            "weights": [
                0.00030864197530880704,
                0.0019019523044413187,
                0.003422374319978203,
                0.00493678550132014,
                0.006443569163820863,
                0.007940513090266516,
                0.009425355669783647,
                0.01089584116244325,
                0.012349732276884675,
                0.013784815841039109,
                0.015198906871870182,
                0.01658985215587691,
                0.017955533631296247,
                0.01929387165975802,
                0.020602828215540762,
                0.0218804100006073,
                0.023124671486272397,
                0.024333717879439123,
                0.025505708010114366,
                0.026638857136468415,
                0.027731439663487987,
                0.02878179177128239,
                0.02978831394913708,
                0.030749473431531015,
                0.031663806532433635,
                0.032529920874382064,
                0.033346497508893236,
                0.03411229292507918,
                0.03482614094333734,
                0.0354869544912863,
                0.03609372725921812,
                0.036645535232550486,
                0.03714153809897579,
                0.037580980528113574,
                0.037963193321766994,
                0.03828759443300597,
                0.03855368985254,
                0.03876107436100248,
                0.038909432146044344,
                0.03899853728326851,
                0.03902825408026735,
                0.03899853728326845,
                0.038909432146044885,
                0.038761074361002186,
                0.03855368985253972,
                0.038287594433007,
                0.03796319332176577,
                0.03758098052811286,
                0.03714153809897649,
                0.03664553523255196,
                0.03609372725921813,
                0.03548695449128682,
                0.03482614094333664,
                0.03411229292507866,
                0.03334649750889305,
                0.03252992087438202,
                0.031663806532434724,
                0.030749473431529624,
                0.029788313949136825,
                0.02878179177128246,
                0.02773143966348807,
                0.026638857136467672,
                0.025505708010114272,
                0.024333717879439123,
                0.023124671486272286,
                0.021880410000606844,
                0.020602828215540676,
                0.019293871659758804,
                0.017955533631297246,
                0.016589852155877806,
                0.015198906871869722,
                0.01378481584103903,
                0.012349732276884923,
                0.010895841162442799,
                0.009425355669784138,
                0.007940513090266022,
                0.006443569163820433,
                0.0049367855013199334,
                0.003422374319978283,
                0.0019019523044415143,
                0.00030864197530863525,
            ],
            "generator": "gauss_lobatto",
        },
        82: {
            "degree": 161,
            "points": [
                -0.9999999999999994,
                -0.9988949663946965,
                -0.996297194250044,
                -0.9922188249970549,
                -0.9866662339977512,
                -0.979647726580751,
                -0.9711737460709831,
                -0.9612568881669965,
                -0.9499118889338425,
                -0.9371556049113705,
                -0.9230069887921943,
                -0.9074870615617565,
                -0.8906188814039113,
                -0.8724275095111238,
                -0.8529399728869764,
                -0.8321852242122525,
                -0.8101940988417269,
                -0.7869992689992691,
                -0.7626351952412631,
                -0.7371380752615209,
                -0.7105457901143519,
                -0.6828978479360555,
                -0.6542353252486428,
                -0.6246008059331534,
                -0.5940383179633038,
                -0.5625932679935255,
                -0.5303123738986062,
                -0.4972435953651966,
                -0.4634360626383047,
                -0.4289400035286688,
                -0.39380666878944526,
                -0.3580882559731018,
                -0.3218378318816284,
                -0.28510925372530704,
                -0.2479570891071523,
                -0.21043653495192394,
                -0.17260333550015194,
                -0.13451369948900638,
                -0.09622421664306713,
                -0.05779177359905807,
                -0.019273469389456288,
                0.01927346938945662,
                0.05779177359905863,
                0.09622421664306746,
                0.13451369948900627,
                0.17260333550015194,
                0.21043653495192438,
                0.2479570891071522,
                0.28510925372530715,
                0.32183783188162873,
                0.3580882559731018,
                0.3938066687894459,
                0.4289400035286688,
                0.4634360626383053,
                0.4972435953651967,
                0.5303123738986065,
                0.5625932679935253,
                0.5940383179633038,
                0.6246008059331531,
                0.6542353252486428,
                0.6828978479360558,
                0.7105457901143524,
                0.7371380752615208,
                0.7626351952412631,
                0.7869992689992691,
                0.8101940988417272,
                0.8321852242122527,
                0.8529399728869764,
                0.8724275095111236,
                0.890618881403911,
                0.9074870615617567,
                0.9230069887921943,
                0.9371556049113703,
                0.9499118889338427,
                0.9612568881669974,
                0.9711737460709833,
                0.9796477265807518,
                0.9866662339977508,
                0.9922188249970556,
                0.9962971942500438,
                0.9988949663946968,
                1.0,
            ],
            "weights": [
                0.0003011141222525385,
                0.001855580315744329,
                0.00333900491367526,
                0.004816689134073123,
                0.006287110273231672,
                0.007748164083426034,
                0.009197697427289812,
                0.010633562032621223,
                0.012053626603375169,
                0.013455782194530861,
                0.014837946027710127,
                0.016198064832495404,
                0.017534117997660897,
                0.018844120618260324,
                0.020126126466356233,
                0.02137823089371416,
                0.0225985736675752,
                0.023785341737842275,
                0.024936771932727732,
                0.026051153579530088,
                0.02712683104694409,
                0.028162206205320724,
                0.02915574080133637,
                0.030105958743593585,
                0.031011448295790205,
                0.03187086417424779,
                0.03268292954666961,
                0.033446437929179104,
                0.03416025497882817,
                0.034823320178929154,
                0.035434648414669076,
                0.03599333143672115,
                0.03649853921063742,
                0.03694952115003446,
                0.03734560723175774,
                0.037686208991329795,
                0.03797082039723645,
                0.03819901860274018,
                0.03837046457411185,
                0.03848490359432731,
                0.038542165641503964,
                0.03854216564150437,
                0.03848490359432714,
                0.03837046457411172,
                0.03819901860274016,
                0.037970820397236,
                0.03768620899132955,
                0.03734560723175897,
                0.036949521150035504,
                0.03649853921063665,
                0.0359933314367204,
                0.03543464841466882,
                0.03482332017892826,
                0.03416025497882872,
                0.03344643792917874,
                0.03268292954667049,
                0.03187086417424849,
                0.031011448295789612,
                0.030105958743593,
                0.029155740801336386,
                0.02816220620532013,
                0.02712683104694344,
                0.026051153579530542,
                0.02493677193272775,
                0.023785341737842063,
                0.022598573667575967,
                0.021378230893713632,
                0.0201261264663568,
                0.018844120618260126,
                0.017534117997661244,
                0.0161980648324956,
                0.014837946027709813,
                0.013455782194530952,
                0.012053626603374907,
                0.010633562032620952,
                0.009197697427290494,
                0.007748164083425848,
                0.0062871102732311454,
                0.004816689134073042,
                0.0033390049136754604,
                0.0018555803157445793,
                0.00030111412225231765,
            ],
            "generator": "gauss_lobatto",
        },
        83: {
            "degree": 163,
            "points": [
                -0.9999999999999996,
                -0.9989215889238612,
                -0.9963863647115179,
                -0.9924060855308405,
                -0.9869868309171792,
                -0.9801365127750767,
                -0.9718650789633352,
                -0.9621845280436148,
                -0.951108898428134,
                -0.9386542499786454,
                -0.9248386414254368,
                -0.9096821044747487,
                -0.8932066148978461,
                -0.8754360607343288,
                -0.8563962076917706,
                -0.836114661807491,
                -0.8146208294339032,
                -0.7919458746090919,
                -0.7681226738763349,
                -0.743185768619093,
                -0.7171713149812078,
                -0.6901170314452363,
                -0.6620621441451482,
                -0.6330473299928174,
                -0.6031146577008435,
                -0.5723075267872735,
                -0.540670604650697,
                -0.508249761806971,
                -0.47509200538150087,
                -0.44124541095350733,
                -0.4067590528511209,
                -0.37168293299835975,
                -0.3360679084171734,
                -0.2999656174896681,
                -0.2634284050874178,
                -0.2265092466764369,
                -0.18926167150783835,
                -0.15173968500556234,
                -0.11399769046368502,
                -0.07609041016686047,
                -0.03807280604825336,
                0.0,
                0.03807280604825347,
                0.0760904101668608,
                0.1139976904636848,
                0.15173968500556223,
                0.1892616715078388,
                0.22650924667643635,
                0.26342840508741794,
                0.29996561748966843,
                0.33606790841717415,
                0.37168293299835975,
                0.4067590528511208,
                0.44124541095350733,
                0.47509200538150076,
                0.5082497618069712,
                0.5406706046506973,
                0.5723075267872739,
                0.6031146577008437,
                0.6330473299928173,
                0.6620621441451483,
                0.6901170314452367,
                0.7171713149812083,
                0.7431857686190927,
                0.7681226738763346,
                0.7919458746090924,
                0.8146208294339026,
                0.8361146618074909,
                0.856396207691771,
                0.8754360607343289,
                0.8932066148978458,
                0.9096821044747483,
                0.9248386414254366,
                0.9386542499786452,
                0.9511088984281341,
                0.9621845280436153,
                0.9718650789633357,
                0.9801365127750771,
                0.9869868309171792,
                0.9924060855308408,
                0.9963863647115178,
                0.9989215889238613,
                1.0,
            ],
            "weights": [
                0.00029385836027038495,
                0.0018108836143155636,
                0.0032586439806342087,
                0.00470091879768474,
                0.0061362733792069985,
                0.00756270501545929,
                0.008978162641885624,
                0.010380599149952117,
                0.011767983059443578,
                0.01313830361902759,
                0.014489574387550988,
                0.015819836355151884,
                0.017127160881895025,
                0.0184096525380951,
                0.01966545187374374,
                0.020892738125438952,
                0.02208973186222579,
                0.023254697568934734,
                0.024385946164498414,
                0.025481837452135232,
                0.026540782498229592,
                0.027561245936629213,
                0.028541748195078872,
                0.029480867640686196,
                0.030377242641289246,
                0.031229573539806765,
                0.032036624538678164,
                0.03279722549170896,
                0.0335102736007066,
                0.034174735014461534,
                0.034789646327757544,
                0.03535411597822132,
                0.03586732553902706,
                0.03632853090554135,
                0.03673706337420441,
                0.037092330612101744,
                0.037393817515788505,
                0.037641086958151604,
                0.037833780422187054,
                0.03797161852083333,
                0.03805440140205685,
                0.03808200903860696,
                0.038054401402056494,
                0.0379716185208341,
                0.03783378042218662,
                0.037641086958151236,
                0.03739381751578996,
                0.03709233061210159,
                0.036737063374203294,
                0.036328530905540016,
                0.035867325539027536,
                0.03535411597822215,
                0.03478964632775762,
                0.034174735014462866,
                0.033510273600706506,
                0.032797225491709214,
                0.03203662453867822,
                0.031229573539806654,
                0.030377242641289194,
                0.029480867640685058,
                0.028541748195078605,
                0.02756124593662908,
                0.026540782498230456,
                0.0254818374521352,
                0.024385946164499368,
                0.023254697568935164,
                0.022089731862224255,
                0.02089273812543881,
                0.01966545187374404,
                0.01840965253809528,
                0.017127160881894737,
                0.015819836355151627,
                0.014489574387551106,
                0.01313830361902796,
                0.011767983059442525,
                0.010380599149952261,
                0.008978162641886672,
                0.007562705015459301,
                0.006136273379206441,
                0.004700918797684655,
                0.0032586439806344012,
                0.001810883614315915,
                0.00029385836027033156,
            ],
            "generator": "gauss_lobatto",
        },
        84: {
            "degree": 165,
            "points": [
                -0.9999999999999997,
                -0.998947260872255,
                -0.9964723530279038,
                -0.9925866692976055,
                -0.987296010592762,
                -0.9806079184530128,
                -0.9725318743060847,
                -0.9630793145247929,
                -0.9522636206285771,
                -0.9401001022501931,
                -0.9266059761540926,
                -0.911800342151917,
                -0.8957041561988031,
                -0.8783402007970662,
                -0.8597330527842861,
                -0.8399090485666598,
                -0.8188962468539525,
                -0.796724388952343,
                -0.77342485667321,
                -0.74903062791847,
                -0.7235762300058919,
                -0.697097690800792,
                -0.6696324877234978,
                -0.6412194947048646,
                -0.6118989271650193,
                -0.5817122850932521,
                -0.5507022943096691,
                -0.5189128459917445,
                -0.4863889345514125,
                -0.4531765939506036,
                -0.4193228325454128,
                -0.38487556655108346,
                -0.34988355222201806,
                -0.314396316842791,
                -0.27846408862785044,
                -0.24213772562912306,
                -0.20546864375215246,
                -0.16850874398265003,
                -0.1313103389264736,
                -0.09392607876699532,
                -0.056408876744665326,
                -0.01881183426425226,
                0.01881183426425237,
                0.05640887674466566,
                0.09392607876699544,
                0.1313103389264737,
                0.16850874398265026,
                0.20546864375215268,
                0.24213772562912383,
                0.278464088627851,
                0.31439631684279157,
                0.34988355222201817,
                0.3848755665510837,
                0.41932283254541314,
                0.45317659395060406,
                0.48638893455141274,
                0.5189128459917458,
                0.5507022943096698,
                0.5817122850932532,
                0.6118989271650197,
                0.6412194947048657,
                0.6696324877234989,
                0.6970976908007929,
                0.7235762300058924,
                0.749030627918471,
                0.7734248566732106,
                0.7967243889523439,
                0.8188962468539538,
                0.8399090485666603,
                0.8597330527842865,
                0.878340200797067,
                0.8957041561988043,
                0.9118003421519176,
                0.926605976154093,
                0.9401001022501941,
                0.952263620628578,
                0.9630793145247938,
                0.9725318743060856,
                0.9806079184530138,
                0.9872960105927627,
                0.9925866692976065,
                0.9964723530279048,
                0.998947260872255,
                1.0,
            ],
            "weights": [
                0.00028686173264475597,
                0.001767782471840139,
                0.003181148545302914,
                0.004589269355179852,
                0.0059907927021629805,
                0.007383811435235971,
                0.008766370608785715,
                0.010136518411255858,
                0.011492317424474525,
                0.012831849469580792,
                0.014153218972016034,
                0.015454555879700314,
                0.016734018405800712,
                0.01798979567850006,
                0.019220110324810632,
                0.02042322099689063,
                0.02159742484249713,
                0.022741059918432963,
                0.023852507544777808,
                0.02493019459710312,
                0.025972595733786602,
                0.02697823555543799,
                0.027945690693467664,
                0.028873591824917614,
                0.029760625610723502,
                0.030605536554697867,
                0.0314071287806299,
                0.0321642677249405,
                0.03287588174258708,
                0.033540963623874216,
                0.0341585720200722,
                0.03472783277580472,
                0.03524794016632374,
                0.03571815803794238,
                0.036137820849975785,
                0.03650633461674972,
                0.036823177748324505,
                0.03708790178874422,
                0.037300132050788436,
                0.03745956814629575,
                0.037565984411331216,
                0.03761923022559181,
                0.03761923022559223,
                0.03756598441133095,
                0.03745956814629496,
                0.037300132050788345,
                0.03708790178874455,
                0.03682317774832327,
                0.0365063346167502,
                0.03613782084997671,
                0.03571815803794368,
                0.035247940166324015,
                0.03472783277580402,
                0.034158572020072754,
                0.033540963623873384,
                0.03287588174258669,
                0.03216426772494006,
                0.03140712878062987,
                0.030605536554698876,
                0.029760625610722468,
                0.02887359182491728,
                0.02794569069346767,
                0.026978235555437855,
                0.02597259573378698,
                0.024930194597102998,
                0.023852507544778228,
                0.022741059918432987,
                0.021597424842495137,
                0.020423220996890687,
                0.01922011032481042,
                0.017989795678500294,
                0.016734018405800757,
                0.015454555879700368,
                0.014153218972016147,
                0.012831849469581495,
                0.011492317424473064,
                0.010136518411256495,
                0.008766370608787115,
                0.007383811435236255,
                0.005990792702162206,
                0.004589269355179989,
                0.0031811485453031286,
                0.0017677824718404268,
                0.00028686173264485176,
            ],
            "generator": "gauss_lobatto",
        },
        85: {
            "degree": 167,
            "points": [
                -0.9999999999999999,
                -0.9989720269601577,
                -0.9965553088019701,
                -0.9927608898566143,
                -0.9875943084220864,
                -0.9810627571287895,
                -0.97317527799111,
                -0.9639427777168581,
                -0.9533780188711556,
                -0.9414956040992075,
                -0.9283119566153712,
                -0.9138452977819955,
                -0.8981156220527409,
                -0.8811446694014127,
                -0.8629558953087304,
                -0.8435744383634045,
                -0.8230270855292705,
                -0.8013422351299422,
                -0.7785498576039609,
                -0.7546814540856617,
                -0.7297700128695803,
                -0.703849963818888,
                -0.676957130781074,
                -0.6491286820767748,
                -0.6204030791302424,
                -0.5908200233125149,
                -0.5604204010707858,
                -0.5292462274198384,
                -0.497340587873641,
                -0.4647475788974045,
                -0.43151224696237467,
                -0.39768052628762685,
                -0.3632991753548884,
                -0.32841571228415356,
                -0.29307834915940556,
                -0.25733592539519723,
                -0.22123784023621829,
                -0.18483398448311128,
                -0.1481746715389154,
                -0.11131056787142946,
                -0.07429262298761152,
                -0.03717199901678803,
                2.220446049250313e-16,
                0.03717199901678858,
                0.07429262298761163,
                0.11131056787142901,
                0.14817467153891528,
                0.18483398448311128,
                0.22123784023621806,
                0.2573359253951971,
                0.2930783491594051,
                0.328415712284154,
                0.363299175354888,
                0.39768052628762696,
                0.4315122469623748,
                0.4647475788974045,
                0.497340587873641,
                0.5292462274198384,
                0.5604204010707863,
                0.5908200233125143,
                0.6204030791302422,
                0.6491286820767749,
                0.6769571307810742,
                0.7038499638188881,
                0.7297700128695807,
                0.7546814540856618,
                0.7785498576039604,
                0.8013422351299422,
                0.8230270855292707,
                0.843574438363405,
                0.8629558953087307,
                0.8811446694014129,
                0.898115622052741,
                0.913845297781996,
                0.9283119566153714,
                0.9414956040992079,
                0.9533780188711558,
                0.9639427777168582,
                0.9731752779911096,
                0.9810627571287895,
                0.987594308422086,
                0.9927608898566145,
                0.9965553088019703,
                0.9989720269601576,
                1.0,
            ],
            "weights": [
                0.0002801120448176054,
                0.0017262018466267914,
                0.003106384022699244,
                0.004481547676585324,
                0.005850417962710866,
                0.007211177725200171,
                0.00856196259444194,
                0.009900910591637769,
                0.011226172998876587,
                0.01253591896839724,
                0.01382833868768238,
                0.015101646110443177,
                0.016354081518746292,
                0.017583913997018703,
                0.01878944384455774,
                0.01996900493507359,
                0.021120967025047312,
                0.02224373801006401,
                0.023335766127107287,
                0.024395542100391233,
                0.025421601228014613,
                0.02641252540677417,
                0.027366945092419836,
                0.028283541192681994,
                0.02916104689052087,
                0.029998249395074575,
                0.030793991617919934,
                0.031547173772317624,
                0.032256754893254067,
                0.03292175427616967,
                0.033541252832413784,
                0.0341143943595085,
                0.03464038672451564,
                0.035118502958846616,
                0.03554808226299782,
                0.03592853091984514,
                0.036259323115219504,
                0.03654000166462973,
                0.03677017864513797,
                0.036949535931497225,
                0.03707782563584009,
                0.037154870450285385,
                0.03718056389198086,
                0.03715487045028513,
                0.037077825635840576,
                0.03694953593149689,
                0.03677017864513787,
                0.0365400016646304,
                0.03625932311522077,
                0.035928530919844916,
                0.03554808226299676,
                0.03511850295884517,
                0.03464038672451517,
                0.03411439435950839,
                0.0335412528324133,
                0.032921754276170355,
                0.032256754893253574,
                0.031547173772318464,
                0.030793991617920527,
                0.029998249395074675,
                0.02916104689051999,
                0.028283541192681658,
                0.027366945092419784,
                0.026412525406774332,
                0.02542160122801346,
                0.024395542100391257,
                0.023335766127107426,
                0.02224373801006271,
                0.021120967025047312,
                0.019969004935073316,
                0.018789443844557465,
                0.01758391399701858,
                0.016354081518747163,
                0.015101646110443592,
                0.013828338687682403,
                0.012535918968397583,
                0.011226172998875218,
                0.009900910591638667,
                0.008561962594443794,
                0.007211177725200419,
                0.005850417962709995,
                0.004481547676585465,
                0.003106384022699524,
                0.0017262018466269158,
                0.0002801120448179153,
            ],
            "generator": "gauss_lobatto",
        },
        86: {
            "degree": 169,
            "points": [
                -0.9999999999999998,
                -0.998995929308719,
                -0.9966353729485959,
                -0.9929290425808805,
                -0.9878822288039901,
                -0.9815017953198426,
                -0.9737963698914731,
                -0.964776359855114,
                -0.9544539441634674,
                -0.9428430587631034,
                -0.9299593784371685,
                -0.9158202959159052,
                -0.900444898521195,
                -0.8838539424610703,
                -0.8660698248423921,
                -0.8471165534540357,
                -0.8270197143681677,
                -0.8058064374067431,
                -0.7835053595216095,
                -0.7601465861386068,
                -0.7357616505184263,
                -0.710383471189383,
                -0.6840463075097793,
                -0.6567857134199755,
                -0.6286384894466568,
                -0.5996426330241658,
                -0.56983728719998,
                -0.5392626877936069,
                -0.5079601090802484,
                -0.47597180807257056,
                -0.4433409674757993,
                -0.4101116373931559,
                -0.376328675860341,
                -0.342037688289325,
                -0.3072849659032231,
                -0.27211742324533894,
                -0.23658253484676028,
                -0.2007282711379883,
                -0.16460303369112328,
                -0.12825558988003194,
                -0.09173500704669535,
                -0.05509058626260743,
                -0.01837179577466097,
                0.01837179577466108,
                0.05509058626260732,
                0.0917350070466948,
                0.12825558988003194,
                0.16460303369112306,
                0.20072827113798786,
                0.2365825348467604,
                0.2721174232453393,
                0.30728496590322296,
                0.3420376882893251,
                0.3763286758603409,
                0.41011163739315615,
                0.443340967475799,
                0.4759718080725708,
                0.5079601090802482,
                0.5392626877936069,
                0.5698372871999802,
                0.5996426330241662,
                0.6286384894466566,
                0.6567857134199755,
                0.68404630750978,
                0.7103834711893833,
                0.7357616505184272,
                0.7601465861386073,
                0.7835053595216097,
                0.8058064374067442,
                0.8270197143681685,
                0.8471165534540368,
                0.8660698248423933,
                0.8838539424610709,
                0.9004448985211957,
                0.9158202959159059,
                0.9299593784371691,
                0.9428430587631038,
                0.9544539441634686,
                0.9647763598551145,
                0.9737963698914732,
                0.9815017953198432,
                0.9878822288039906,
                0.9929290425808817,
                0.9966353729485965,
                0.9989959293087189,
                1.0,
            ],
            "weights": [
                0.0002735978112172441,
                0.0016860710568962502,
                0.003034223634601373,
                0.004377571806013842,
                0.005714913310934736,
                0.007044515807472613,
                0.008364600337360069,
                0.009673389661041493,
                0.010969118760399306,
                0.012250039227788535,
                0.0135144222462051,
                0.01476056114743047,
                0.01598677380740677,
                0.017191404957972205,
                0.018372828441146613,
                0.019529449414531854,
                0.020659706509761788,
                0.02176207394338947,
                0.022835063578455665,
                0.023877226934510255,
                0.024887157143693897,
                0.025863490850395462,
                0.026804910052003302,
                0.027710143878354725,
                0.02857797030748743,
                0.029407217815394664,
                0.030196766957612215,
                0.030945551880451123,
                0.03165256175989021,
                0.03231684216616516,
                0.03293749635222434,
                0.03351368646431275,
                0.034044634673039094,
                0.03452962422342205,
                0.0349680004024857,
                0.03535917142308782,
                0.03570260922281383,
                0.0359978501768407,
                0.03624449572380601,
                0.03644221290385619,
                0.036590734808120126,
                0.03668986093902885,
                0.03673945748097972,
                0.03673945748098011,
                0.03668986093902863,
                0.036590734808119196,
                0.03644221290385622,
                0.03624449572380676,
                0.03599785017683987,
                0.03570260922281284,
                0.03535917142308747,
                0.03496800040248627,
                0.034529624223423504,
                0.0340446346730396,
                0.033513686464312645,
                0.0329374963522253,
                0.03231684216616477,
                0.031652561759890445,
                0.03094555188045106,
                0.0301967669576122,
                0.029407217815394075,
                0.028577970307486274,
                0.027710143878354725,
                0.026804910052002414,
                0.02586349085039468,
                0.024887157143694324,
                0.023877226934509867,
                0.022835063578455328,
                0.021762073943389085,
                0.020659706509761382,
                0.019529449414531542,
                0.01837282844114681,
                0.017191404957972282,
                0.015986773807407973,
                0.014760561147430695,
                0.013514422246205209,
                0.012250039227788062,
                0.010969118760398406,
                0.00967338966104215,
                0.008364600337361841,
                0.007044515807472483,
                0.005714913310933739,
                0.004377571806013972,
                0.0030342236346015093,
                0.0016860710568963651,
                0.0002735978112175019,
            ],
            "generator": "gauss_lobatto",
        },
        87: {
            "degree": 171,
            "points": [
                -0.9999999999999998,
                -0.9990190076191392,
                -0.9967126782931601,
                -0.9930914059079317,
                -0.988160247266231,
                -0.9819257557642662,
                -0.9743961683669251,
                -0.965581421278171,
                -0.9554931427884046,
                -0.9441446397141604,
                -0.9315508804879093,
                -0.9177284756803212,
                -0.9026956562132404,
                -0.8864722493745609,
                -0.869079652699374,
                -0.8505408057660415,
                -0.8308801599510589,
                -0.8101236461858865,
                -0.7882986407600066,
                -0.7654339292162697,
                -0.7415596683866614,
                -0.7167073466189047,
                -0.690909742246532,
                -0.664200880357328,
                -0.6366159879172333,
                -0.6081914473089591,
                -0.5789647483466018,
                -0.5489744388296027,
                -0.5182600737012486,
                -0.4868621628788068,
                -0.4548221178240923,
                -0.4221821969249595,
                -0.38898544975974003,
                -0.3552756603181586,
                -0.3210972892536026,
                -0.28649541524292443,
                -0.25151567553110876,
                -0.21620420573922905,
                -0.18060757901508073,
                -0.14477274460675016,
                -0.10874696594012812,
                -0.0725777582820526,
                -0.03631282607128794,
                0.0,
                0.03631282607128794,
                0.0725777582820527,
                0.10874696594012812,
                0.14477274460675005,
                0.18060757901508084,
                0.21620420573922916,
                0.25151567553110865,
                0.28649541524292454,
                0.3210972892536025,
                0.35527566031815894,
                0.3889854497597406,
                0.42218219692495973,
                0.45482211782409254,
                0.4868621628788068,
                0.5182600737012489,
                0.5489744388296028,
                0.5789647483466019,
                0.6081914473089591,
                0.6366159879172342,
                0.664200880357328,
                0.6909097422465323,
                0.7167073466189049,
                0.7415596683866614,
                0.76543392921627,
                0.788298640760007,
                0.8101236461858864,
                0.8308801599510592,
                0.8505408057660416,
                0.869079652699374,
                0.8864722493745613,
                0.9026956562132402,
                0.9177284756803213,
                0.9315508804879098,
                0.944144639714161,
                0.955493142788405,
                0.9655814212781711,
                0.9743961683669248,
                0.9819257557642668,
                0.988160247266231,
                0.993091405907932,
                0.9967126782931606,
                0.9990190076191392,
                1.0,
            ],
            "weights": [
                0.00026730820636169657,
                0.0016473234803334926,
                0.002964547872568193,
                0.004277170195334239,
                0.005584056340854852,
                0.00688355395225289,
                0.008173964666507867,
                0.009453591231560933,
                0.010720747661947987,
                0.011973763422656792,
                0.013210986238049496,
                0.01443078449025768,
                0.015631549460494568,
                0.01681169749084468,
                0.01796967209228009,
                0.019103946007477234,
                0.020213023230520467,
                0.021295440983053478,
                0.022349771645373013,
                0.023374624640420998,
                0.02436864826854583,
                0.025330531490716544,
                0.026259005657987885,
                0.02715284618492837,
                0.028010874164902565,
                0.02883195792504349,
                0.02961501451891244,
                0.030359011154875194,
                0.031062966558296753,
                0.03172595226580589,
                0.032347093849879896,
                0.03292557207216745,
                0.033460623964007695,
                0.03395154383273814,
                0.03439768419245839,
                0.03479845661801259,
                0.035153332521092436,
                0.0354618438473993,
                0.035723583693978184,
                0.035938206845891184,
                0.03610543023153377,
                0.036225033295983075,
                0.03629685829190186,
                0.03632081048758213,
                0.0362968582919015,
                0.036225033295983255,
                0.0361054302315338,
                0.035938206845891274,
                0.03572358369397769,
                0.035461843847400476,
                0.035153332521093525,
                0.03479845661801321,
                0.03439768419245776,
                0.03395154383273749,
                0.03346062396400708,
                0.03292557207216755,
                0.0323470938498792,
                0.031725952265805504,
                0.031062966558296084,
                0.03035901115487506,
                0.02961501451891273,
                0.028831957925042923,
                0.02801087416490158,
                0.027152846184927873,
                0.026259005657987586,
                0.02533053149071705,
                0.02436864826854565,
                0.02337462464042134,
                0.022349771645372718,
                0.021295440983054182,
                0.02021302323051922,
                0.019103946007477113,
                0.017969672092280488,
                0.016811697490845365,
                0.01563154946049587,
                0.01443078449025759,
                0.013210986238049883,
                0.01197376342265583,
                0.010720747661947938,
                0.009453591231561437,
                0.008173964666509655,
                0.006883553952252452,
                0.005584056340853799,
                0.0042771701953343375,
                0.0029645478725683376,
                0.0016473234803334547,
                0.0002673082063619174,
            ],
            "generator": "gauss_lobatto",
        },
        88: {
            "degree": 173,
            "points": [
                -0.9999999999999999,
                -0.9990412993376028,
                -0.9967873501223838,
                -0.9932482424913667,
                -0.9884288124247946,
                -0.9823353203844285,
                -0.9749756344152323,
                -0.9663592459346613,
                -0.956497263315689,
                -0.9454023993047216,
                -0.9330889552613628,
                -0.9195728029830941,
                -0.9048713643655766,
                -0.8890035890053538,
                -0.8719899298058231,
                -0.8538523166318064,
                -0.8346141280531711,
                -0.8143001612171565,
                -0.7929365998899194,
                -0.7705509807094297,
                -0.747172157693718,
                -0.7228302650505607,
                -0.6975566783366987,
                -0.671383974016796,
                -0.6443458874743162,
                -0.6164772695285043,
                -0.5878140415135495,
                -0.5583931489778431,
                -0.5282525140630441,
                -0.4974309866243234,
                -0.46596829415481156,
                -0.4339049905787984,
                -0.40128240397968784,
                -0.368142583330088,
                -0.33452824429270445,
                -0.3004827141618953,
                -0.26604987601685637,
                -0.23127411215842342,
                -0.19620024690239957,
                -0.16087348880314178,
                -0.12533937238188608,
                -0.08964369943490724,
                -0.05383247999717877,
                -0.017951873037621136,
                0.017951873037621024,
                0.05383247999717844,
                0.08964369943490724,
                0.12533937238188597,
                0.1608734888031419,
                0.19620024690239912,
                0.23127411215842308,
                0.2660498760168566,
                0.30048271416189576,
                0.3345282442927049,
                0.3681425833300882,
                0.4012824039796882,
                0.4339049905787987,
                0.4659682941548118,
                0.49743098662432317,
                0.5282525140630441,
                0.5583931489778431,
                0.5878140415135492,
                0.6164772695285048,
                0.6443458874743165,
                0.6713839740167967,
                0.6975566783366991,
                0.7228302650505607,
                0.7471721576937184,
                0.7705509807094298,
                0.7929365998899202,
                0.8143001612171564,
                0.8346141280531716,
                0.8538523166318068,
                0.8719899298058235,
                0.8890035890053538,
                0.9048713643655767,
                0.9195728029830944,
                0.9330889552613632,
                0.9454023993047223,
                0.9564972633156894,
                0.9663592459346615,
                0.9749756344152318,
                0.982335320384429,
                0.9884288124247946,
                0.993248242491367,
                0.9967873501223841,
                0.9990412993376027,
                1.0,
            ],
            "weights": [
                0.00026123301985336096,
                0.0016098962775170757,
                0.002897244003548779,
                0.004180180998415408,
                0.0054576371824309015,
                0.006728035679402233,
                0.007989754226934152,
                0.009241171124094576,
                0.010480675058716159,
                0.011706669099868068,
                0.012917573348050396,
                0.014111827185787264,
                0.015287891376486073,
                0.016444250087539896,
                0.017579412863016442,
                0.01869191655448099,
                0.019780327212174997,
                0.02084324193627416,
                0.021879290686900615,
                0.022887138051120404,
                0.023865484964874416,
                0.02481307038784262,
                0.025728672929155476,
                0.026611112421888357,
                0.027459251444379065,
                0.02827199678639404,
                0.029048300858290306,
                0.029787163041365083,
                0.030487630977623,
                0.031148801797359137,
                0.031769823282921245,
                0.03234989496720698,
                0.032888269165427496,
                0.03338425193884459,
                0.03383720398924266,
                0.03424654148294914,
                0.03461173680337118,
                0.03493231923107903,
                0.035207875550537455,
                0.03543805058272722,
                0.03562254764295153,
                0.03576112892325057,
                0.03585361579892595,
                0.03589988905878196,
                0.03589988905878232,
                0.0358536157989259,
                0.035761128923249785,
                0.03562254764295165,
                0.03543805058272751,
                0.03520787555053781,
                0.03493231923107788,
                0.03461173680337003,
                0.034246541482947694,
                0.03383720398924286,
                0.033384251938844804,
                0.03288826916542724,
                0.032349894967207145,
                0.03176982328292189,
                0.031148801797358548,
                0.03048763097762388,
                0.029787163041365423,
                0.02904830085829125,
                0.028271996786392806,
                0.027459251444378798,
                0.02661111242188866,
                0.02572867292915532,
                0.02481307038784317,
                0.023865484964873826,
                0.02288713805112092,
                0.021879290686900824,
                0.02084324193627258,
                0.019780327212174778,
                0.01869191655448136,
                0.017579412863016515,
                0.016444250087540673,
                0.015287891376486859,
                0.014111827185786551,
                0.012917573348050645,
                0.011706669099867267,
                0.0104806750587165,
                0.00924117112409496,
                0.00798975422693553,
                0.0067280356794016125,
                0.005457637182429876,
                0.00418018099841559,
                0.0028972440035490822,
                0.0016098962775169421,
                0.00026123301985369305,
            ],
            "generator": "gauss_lobatto",
        },
        89: {
            "degree": 175,
            "points": [
                -0.9999999999999997,
                -0.9990628398072443,
                -0.9968595066919201,
                -0.9933998002621378,
                -0.9886883477899269,
                -0.9827311330193853,
                -0.9755356755007749,
                -0.9671110464636394,
                -0.957467863073278,
                -0.9466182767502043,
                -0.9345759584712623,
                -0.9213560817969442,
                -0.9069753038684583,
                -0.8914517444772563,
                -0.8748049632646497,
                -0.8570559350938338,
                -0.8382270236316873,
                -0.8183419531768004,
                -0.7974257787708718,
                -0.7755048546320367,
                -0.7526068009504212,
                -0.7287604690880549,
                -0.703995905227178,
                -0.678344312512855,
                -0.6518380117376725,
                -0.6245104006181104,
                -0.5963959117139113,
                -0.567529969043514,
                -0.5379489434502138,
                -0.507690106775303,
                -0.4767915848959432,
                -0.44529230968694145,
                -0.4132319699669662,
                -0.38065096149101296,
                -0.34759033605212286,
                -0.3140917497565008,
                -0.2801974105371956,
                -0.24595002497248286,
                -0.21139274447595335,
                -0.17656911092611072,
                -0.1415230018039908,
                -0.10629857490791395,
                -0.07094021271504691,
                -0.03549246645986859,
                0.0,
                0.03549246645986892,
                0.07094021271504725,
                0.10629857490791395,
                0.14152300180399124,
                0.17656911092611116,
                0.2113927444759537,
                0.24595002497248364,
                0.28019741053719627,
                0.314091749756501,
                0.3475903360521232,
                0.38065096149101374,
                0.4132319699669672,
                0.44529230968694156,
                0.4767915848959434,
                0.5076901067753035,
                0.5379489434502142,
                0.5675299690435145,
                0.5963959117139117,
                0.6245104006181108,
                0.6518380117376731,
                0.678344312512855,
                0.7039959052271787,
                0.7287604690880556,
                0.7526068009504214,
                0.7755048546320368,
                0.7974257787708722,
                0.8183419531768011,
                0.838227023631688,
                0.8570559350938346,
                0.8748049632646504,
                0.8914517444772566,
                0.9069753038684588,
                0.9213560817969447,
                0.934575958471263,
                0.9466182767502045,
                0.9574678630732781,
                0.9671110464636401,
                0.9755356755007744,
                0.9827311330193857,
                0.9886883477899272,
                0.9933998002621385,
                0.9968595066919204,
                0.9990628398072444,
                1.0,
            ],
            "weights": [
                0.00025536261491296313,
                0.0015737301370834646,
                0.002832205614263046,
                0.00408645142053899,
                0.0053354576642186975,
                0.006577718744988999,
                0.007811684303220325,
                0.00903580404402185,
                0.01024853725360725,
                0.011448356613040968,
                0.012633750701162226,
                0.013803226108304303,
                0.01495530940332221,
                0.016088549028309185,
                0.017201517145980852,
                0.018292811448216026,
                0.019361056928076284,
                0.02040490761520911,
                0.021423048273454367,
                0.02241419605908892,
                0.023377102137831993,
                0.024310553258790318,
                0.02521337328341409,
                0.02608442466761929,
                0.026922609895195508,
                0.0277268728607667,
                0.02849620020052877,
                0.02922962256913156,
                0.02992621586107671,
                0.030585102375103486,
                0.03120545192010568,
                0.03178648286117801,
                0.03232746310448101,
                0.03282771101968217,
                0.03328659629880175,
                0.03370354075041422,
                0.0340780190281555,
                0.034409559292665835,
                0.034697743806102924,
                0.034942209458488555,
                0.03514264822522433,
                0.03529880755520894,
                0.03541049068904,
                0.03547755690694209,
                0.035499921706059735,
                0.03547755690694157,
                0.03541049068904008,
                0.03529880755520928,
                0.035142648225224504,
                0.03494220945848758,
                0.03469774380610301,
                0.034409559292666904,
                0.03407801902815647,
                0.03370354075041522,
                0.03328659629880248,
                0.03282771101968197,
                0.032327463104481445,
                0.031786482861178286,
                0.031205451920105206,
                0.030585102375103944,
                0.02992621586107675,
                0.029229622569131832,
                0.02849620020052783,
                0.027726872860766073,
                0.026922609895195387,
                0.0260844246676191,
                0.025213373283414414,
                0.024310553258789124,
                0.023377102137832464,
                0.022414196059089297,
                0.021423048273454422,
                0.02040490761520679,
                0.019361056928076572,
                0.01829281144821645,
                0.017201517145981293,
                0.016088549028309456,
                0.014955309403322457,
                0.01380322610830373,
                0.012633750701162143,
                0.011448356613041086,
                0.010248537253607616,
                0.009035804044022376,
                0.0078116843032211055,
                0.006577718744988436,
                0.0053354576642178015,
                0.004086451420539385,
                0.0028322056142633303,
                0.001573730137083281,
                0.0002553626149131647,
            ],
            "generator": "gauss_lobatto",
        },
        90: {
            "degree": 177,
            "points": [
                -0.9999999999999998,
                -0.9990836624083022,
                -0.9969292596945181,
                -0.993546313407524,
                -0.9889392534324077,
                -0.9831138019464447,
                -0.9760771490887139,
                -0.9678379688858874,
                -0.9584064141255111,
                -0.9477941055070418,
                -0.9360141179233732,
                -0.9230809645996263,
                -0.9090105793259755,
                -0.8938202968833895,
                -0.8775288317169814,
                -0.8601562548965216,
                -0.8417239693987046,
                -0.8222546837446909,
                -0.801772384027047,
                -0.780302304361399,
                -0.7578708957997231,
                -0.7345057937438633,
                -0.7102357838996041,
                -0.6850907668133464,
                -0.6591017210351597,
                -0.632300664953632,
                -0.6047206173495725,
                -0.5763955567171808,
                -0.5473603794028199,
                -0.5176508566129638,
                -0.4873035903443148,
                -0.4563559682903604,
                -0.4248461177799563,
                -0.39281285880466243,
                -0.3602956561927275,
                -0.32733457098861796,
                -0.29397021109802113,
                -0.26024368125910247,
                -0.22619653240167414,
                -0.19187071045665127,
                -0.15730850467886603,
                -0.12255249554691172,
                -0.08764550230419355,
                -0.05263053020582609,
                -0.017550717536363614,
                0.017550717536363947,
                0.0526305302058262,
                0.08764550230419366,
                0.12255249554691194,
                0.15730850467886648,
                0.19187071045665138,
                0.22619653240167426,
                0.26024368125910236,
                0.293970211098021,
                0.32733457098861796,
                0.3602956561927274,
                0.39281285880466266,
                0.42484611777995585,
                0.45635596829036085,
                0.48730359034431514,
                0.5176508566129641,
                0.5473603794028197,
                0.5763955567171812,
                0.6047206173495725,
                0.6323006649536316,
                0.6591017210351593,
                0.6850907668133461,
                0.7102357838996038,
                0.7345057937438633,
                0.7578708957997226,
                0.7803023043613989,
                0.801772384027047,
                0.8222546837446909,
                0.8417239693987042,
                0.8601562548965218,
                0.8775288317169808,
                0.8938202968833892,
                0.9090105793259757,
                0.9230809645996264,
                0.936014117923373,
                0.9477941055070421,
                0.9584064141255111,
                0.9678379688858875,
                0.9760771490887129,
                0.9831138019464452,
                0.9889392534324081,
                0.9935463134075238,
                0.996929259694518,
                0.9990836624083022,
                1.0,
            ],
            "weights": [
                0.00024968789013698323,
                0.0015387690406950272,
                0.00276933219091806,
                0.003995837118109067,
                0.0052173305404760156,
                0.006432374205385824,
                0.007639485732308495,
                0.008837182356577388,
                0.010023990150963502,
                0.011198447672338878,
                0.012359108327817597,
                0.013504542361621243,
                0.014633338699983189,
                0.01574410672693113,
                0.016835478015547925,
                0.0179061080231323,
                0.018954677752674173,
                0.019979895380697756,
                0.020980497850448785,
                0.021955252428981536,
                0.022902958226531104,
                0.023822447676397174,
                0.024712587973663654,
                0.025572282470976725,
                0.026400472029745086,
                0.02719613632507639,
                0.027958295102866678,
                0.02868600938752761,
                0.02937838263882084,
                0.030034561856417,
                0.030653738630808277,
                0.031235150139275848,
                0.031778080085699725,
                0.032281859583029524,
                0.03274586797736776,
                0.0331695336126109,
                0.033552334534728376,
                0.03389379913481611,
                0.034193506730117576,
                0.034451088082300275,
                0.03466622585236681,
                0.03483865499160149,
                0.03496816306812339,
                0.03505459052859419,
                0.03509783089479256,
                0.03509783089479302,
                0.03505459052859427,
                0.03496816306812298,
                0.03483865499160165,
                0.0346662258523666,
                0.03445108808230176,
                0.034193506730117784,
                0.0338937991348157,
                0.033552334534727384,
                0.03316953361260962,
                0.032745867977367504,
                0.03228185958302948,
                0.03177808008569919,
                0.031235150139275605,
                0.030653738630808076,
                0.030034561856416512,
                0.029378382638820935,
                0.028686009387527717,
                0.027958295102866973,
                0.027196136325075424,
                0.026400472029745402,
                0.025572282470976412,
                0.024712587973663075,
                0.023822447676397667,
                0.022902958226531003,
                0.021955252428981768,
                0.02098049785044776,
                0.019979895380698016,
                0.01895467775267422,
                0.017906108023132236,
                0.016835478015548695,
                0.015744106726931308,
                0.014633338699983402,
                0.013504542361621366,
                0.012359108327817623,
                0.01119844767233965,
                0.010023990150963629,
                0.008837182356578158,
                0.007639485732308716,
                0.006432374205385292,
                0.0052173305404752315,
                0.003995837118109573,
                0.002769332190918619,
                0.0015387690406947774,
                0.00024968789013730714,
            ],
            "generator": "gauss_lobatto",
        },
        91: {
            "degree": 179,
            "points": [
                -0.9999999999999999,
                -0.9991037986874923,
                -0.9969967146922207,
                -0.9936880032750133,
                -0.9891819075222938,
                -0.9834839022102602,
                -0.9766008659102923,
                -0.9685410969397406,
                -0.959314308800405,
                -0.9489316200972291,
                -0.9374055417262381,
                -0.9247499620414477,
                -0.9109801302310281,
                -0.8961126379980846,
                -0.8801653995980108,
                -0.8631576302694586,
                -0.8451098230909888,
                -0.8260437242942946,
                -0.805982307065324,
                -0.784949743865748,
                -0.7629713773085876,
                -0.7400736896234121,
                -0.716284270748051,
                -0.6916317850853975,
                -0.6661459369654077,
                -0.6398574348539756,
                -0.6127979543518249,
                -0.5850001000280298,
                -0.5564973661341672,
                -0.52732409624644,
                -0.4975154418844101,
                -0.4671073201562128,
                -0.4361363704812773,
                -0.40463991044271785,
                -0.37265589082257855,
                -0.3402228498741171,
                -0.3073798668862344,
                -0.27416651509598444,
                -0.2406228140059219,
                -0.20678918116372857,
                -0.17270638346222444,
                -0.13841548801844605,
                -0.1039578126909746,
                -0.06937487629514005,
                -0.034708348576091286,
                -2.220446049250313e-16,
                0.034708348576091064,
                0.06937487629513994,
                0.10395781269097415,
                0.13841548801844628,
                0.17270638346222467,
                0.2067891811637289,
                0.24062281400592234,
                0.27416651509598466,
                0.30737986688623486,
                0.34022284987411766,
                0.37265589082257855,
                0.4046399104427181,
                0.4361363704812776,
                0.46710732015621315,
                0.49751544188441044,
                0.5273240962464403,
                0.5564973661341677,
                0.5850001000280303,
                0.6127979543518249,
                0.6398574348539761,
                0.6661459369654081,
                0.6916317850853977,
                0.7162842707480516,
                0.7400736896234124,
                0.7629713773085885,
                0.7849497438657487,
                0.8059823070653249,
                0.8260437242942946,
                0.8451098230909896,
                0.863157630269459,
                0.880165399598011,
                0.8961126379980852,
                0.9109801302310283,
                0.9247499620414474,
                0.9374055417262378,
                0.9489316200972286,
                0.9593143088004052,
                0.968541096939741,
                0.9766008659102922,
                0.9834839022102603,
                0.9891819075222944,
                0.9936880032750137,
                0.9969967146922212,
                0.9991037986874922,
                1.0,
            ],
            "weights": [
                0.0002442002441998309,
                0.0015049600460723825,
                0.0027085287311674425,
                0.0039082016442666245,
                0.005103078777115993,
                0.006291785552222556,
                0.007472903898053499,
                0.008645014953474623,
                0.00980670800954333,
                0.010956583999801218,
                0.012093257739247078,
                0.013215359793536148,
                0.014321538210654832,
                0.015410460186440041,
                0.016480813688137284,
                0.017531309044353377,
                0.01856068050391282,
                0.019567687763763268,
                0.020551117465075267,
                0.021509784656239195,
                0.022442534221256954,
                0.023348242271974524,
                0.024225817502532544,
                0.0250742025044938,
                0.025892375041046176,
                0.02667934927881464,
                0.027434176975767378,
                0.028155948623813157,
                0.028843794544736664,
                0.02949688593808877,
                0.030114435879869277,
                0.03069570027070124,
                0.031239978732440957,
                0.03174661545207698,
                0.032214999971933396,
                0.03264456792524378,
                0.03303480171616318,
                0.03338523114343233,
                0.03369543396693854,
                0.03396503641648796,
                0.03419371364216211,
                0.03438119010574321,
                0.03452723991272015,
                0.034631687084466206,
                0.03469440577028873,
                0.034715320399060924,
                0.034694405770288074,
                0.034631687084466074,
                0.03452723991272074,
                0.0343811901057432,
                0.03419371364216157,
                0.03396503641648677,
                0.03369543396693845,
                0.033385231143432,
                0.033034801716163735,
                0.03264456792524494,
                0.03221499997193398,
                0.031746615452076424,
                0.031239978732441658,
                0.030695700270701842,
                0.030114435879868555,
                0.029496885938089797,
                0.028843794544736692,
                0.0281559486238145,
                0.02743417697576604,
                0.026679349278814057,
                0.025892375041045614,
                0.02507420250449346,
                0.02422581750253288,
                0.023348242271974698,
                0.022442534221257145,
                0.021509784656238665,
                0.02055111746507488,
                0.0195676877637634,
                0.01856068050391252,
                0.01753130904435295,
                0.01648081368813708,
                0.015410460186440085,
                0.014321538210654997,
                0.013215359793536658,
                0.012093257739247238,
                0.010956583999801909,
                0.009806708009542961,
                0.008645014953475475,
                0.007472903898052956,
                0.006291785552222121,
                0.00510307877711521,
                0.003908201644267241,
                0.0027085287311679625,
                0.0015049600460720727,
                0.00024420024420021634,
            ],
            "generator": "gauss_lobatto",
        },
        92: {
            "degree": 181,
            "points": [
                -0.9999999999999999,
                -0.9991232784775455,
                -0.9970619715157298,
                -0.9938250792076224,
                -0.9894166677511598,
                -0.9838419777760437,
                -0.9771075929823703,
                -0.9692214560918464,
                -0.9601928648044338,
                -0.9500324624262275,
                -0.9387522258961059,
                -0.9263654519044298,
                -0.9128867413279536,
                -0.8983319820729789,
                -0.8827183303762056,
                -0.8660641905980337,
                -0.8483891935380705,
                -0.8297141733013482,
                -0.8100611427440714,
                -0.7894532675286725,
                -0.7679148388192591,
                -0.7454712446498897,
                -0.7221489399996255,
                -0.6979754156097229,
                -0.6729791655798045,
                -0.6471896537812305,
                -0.6206372791273056,
                -0.593353339741272,
                -0.5653699960643384,
                -0.5367202329472427,
                -0.5074378207700343,
                -0.47755727563591743,
                -0.447113818686075,
                -0.41614333458343045,
                -0.38468232921429424,
                -0.35276788665774617,
                -0.32043762547347887,
                -0.2877296543596328,
                -0.2546825272328861,
                -0.22133519778374344,
                -0.1877269735606084,
                -0.1538974696367419,
                -0.11988656191473224,
                -0.08573434012352177,
                -0.05148106056338131,
                -0.017167098654548463,
                0.017167098654548907,
                0.05148106056338109,
                0.08573434012352155,
                0.11988656191473246,
                0.15389746963674167,
                0.18772697356060863,
                0.22133519778374355,
                0.25468252723288576,
                0.28772965435963294,
                0.3204376254734784,
                0.35276788665774605,
                0.38468232921429435,
                0.41614333458343056,
                0.4471138186860748,
                0.47755727563591766,
                0.5074378207700343,
                0.5367202329472427,
                0.5653699960643386,
                0.593353339741272,
                0.6206372791273056,
                0.6471896537812304,
                0.6729791655798048,
                0.6979754156097229,
                0.722148939999625,
                0.7454712446498897,
                0.7679148388192593,
                0.7894532675286725,
                0.810061142744071,
                0.8297141733013489,
                0.8483891935380713,
                0.8660641905980344,
                0.882718330376206,
                0.8983319820729795,
                0.912886741327954,
                0.9263654519044299,
                0.9387522258961063,
                0.9500324624262279,
                0.9601928648044344,
                0.9692214560918472,
                0.9771075929823702,
                0.9838419777760442,
                0.98941666775116,
                0.9938250792076229,
                0.9970619715157305,
                0.9991232784775456,
                1.0,
            ],
            "weights": [
                0.00023889154323897366,
                0.0014722530865219528,
                0.002649705385511404,
                0.003823415936444382,
                0.00499253489145028,
                0.0061557479121444264,
                0.007311697800572377,
                0.008459026203127627,
                0.009596382286527648,
                0.010722426081610887,
                0.011835830603961043,
                0.012935283613875187,
                0.014019489242960623,
                0.015087169557356117,
                0.01613706608131451,
                0.017167941289462873,
                0.018178580070316256,
                0.019167791161273304,
                0.02013440855439102,
                0.021077292871778223,
                0.021995332709204545,
                0.022887445946556825,
                0.02375258102360884,
                0.02458971817972048,
                0.025397870655961843,
                0.026176085858335044,
                0.02692344648067271,
                0.027639071585947382,
                0.028322117644684067,
                0.028971779529284397,
                0.029587291463064574,
                0.0301679279229185,
                0.030713004494522075,
                0.031221878679083395,
                0.03169395065068354,
                0.032128663963304806,
                0.03252550620674977,
                0.032884009610623904,
                0.03320375159572515,
                0.03348435527214449,
                0.033725489883522856,
                0.03392687119692965,
                0.03408826183788327,
                0.03420947157017083,
                0.034290357520073755,
                0.03433082434478357,
                0.03433082434478384,
                0.034290357520073984,
                0.034209471570170645,
                0.03408826183788315,
                0.03392687119692897,
                0.0337254898835241,
                0.033484355272145556,
                0.03320375159572548,
                0.03288400961062427,
                0.03252550620674926,
                0.03212866396330427,
                0.03169395065068269,
                0.031221878679084207,
                0.030713004494522095,
                0.030167927922917878,
                0.02958729146306486,
                0.028971779529284248,
                0.028322117644684338,
                0.027639071585946435,
                0.026923446480672034,
                0.026176085858334485,
                0.025397870655962298,
                0.024589718179720027,
                0.023752581023609484,
                0.022887445946555767,
                0.021995332709205093,
                0.021077292871778,
                0.020134408554391994,
                0.01916779116127205,
                0.01817858007031593,
                0.017167941289463168,
                0.016137066081314193,
                0.015087169557356764,
                0.014019489242960944,
                0.012935283613875317,
                0.011835830603961872,
                0.010722426081610992,
                0.009596382286527363,
                0.008459026203128654,
                0.0073116978005715715,
                0.006155747912144249,
                0.0049925348914494905,
                0.0038234159364451694,
                0.002649705385512091,
                0.00147225308652158,
                0.00023889154323935885,
            ],
            "generator": "gauss_lobatto",
        },
        93: {
            "degree": 183,
            "points": [
                -0.9999999999999998,
                -0.9991421300077487,
                -0.9971251246337416,
                -0.9939577393164996,
                -0.9896438726477956,
                -0.984188543521906,
                -0.9775980564020619,
                -0.969880017250339,
                -0.9610433299595169,
                -0.9510981876366413,
                -0.940056061406358,
                -0.9279296874114793,
                -0.9147330522291099,
                -0.9004813767912336,
                -0.8851910988569225,
                -0.8688798540688207,
                -0.8515664556215459,
                -0.8332708725683651,
                -0.8140142067926563,
                -0.7938186686715571,
                -0.7727075514603403,
                -0.7507052044273255,
                -0.7278370047704925,
                -0.7041293283482872,
                -0.6796095192584488,
                -0.6543058582999788,
                -0.6282475303546748,
                -0.6014645907258496,
                -0.5739879304730877,
                -0.5458492407830284,
                -0.517080976417271,
                -0.48771631827957296,
                -0.45778913514550923,
                -0.4273339445987503,
                -0.396385873219002,
                -0.36498061606753374,
                -0.33315439551702575,
                -0.3009439194732215,
                -0.2683863390365655,
                -0.23551920565267026,
                -0.20238042780102594,
                -0.16900822727191356,
                -0.13544109508194735,
                -0.10171774707909531,
                -0.06787707928838072,
                -0.03395812304977186,
                2.220446049250313e-16,
                0.03395812304977264,
                0.06787707928838138,
                0.10171774707909631,
                0.13544109508194802,
                0.16900822727191434,
                0.20238042780102639,
                0.2355192056526707,
                0.2683863390365663,
                0.3009439194732223,
                0.33315439551702664,
                0.36498061606753407,
                0.3963858732190023,
                0.42733394459875074,
                0.4577891351455097,
                0.4877163182795735,
                0.5170809764172717,
                0.5458492407830289,
                0.5739879304730879,
                0.6014645907258502,
                0.6282475303546757,
                0.6543058582999797,
                0.6796095192584495,
                0.7041293283482885,
                0.7278370047704932,
                0.7507052044273266,
                0.7727075514603412,
                0.7938186686715578,
                0.8140142067926565,
                0.8332708725683662,
                0.8515664556215471,
                0.8688798540688214,
                0.8851910988569236,
                0.9004813767912344,
                0.9147330522291109,
                0.9279296874114801,
                0.9400560614063587,
                0.9510981876366421,
                0.9610433299595179,
                0.9698800172503403,
                0.9775980564020628,
                0.9841885435219071,
                0.9896438726477966,
                0.9939577393165008,
                0.997125124633743,
                0.9991421300077488,
                1.0,
            ],
            "weights": [
                0.00023375409069624188,
                0.0014406007855411896,
                0.0025927771256211377,
                0.003741357842276684,
                0.004885540341146161,
                0.006024067305896395,
                0.007155639194124727,
                0.008278954977530862,
                0.009392720565092206,
                0.010495652009467175,
                0.011586477517381148,
                0.012663939108097369,
                0.01372679414243943,
                0.014773816791010135,
                0.015803799464913854,
                0.01681555421723453,
                0.01780791411789578,
                0.018779734602230033,
                0.019729894792670052,
                0.020657298792491813,
                0.02156087695042004,
                0.02243958709471152,
                0.023292415735444355,
                0.024118379233623,
                0.024916524935824004,
                0.0256859322730359,
                0.026425713822504738,
                0.027135016331298206,
                0.027813021700483286,
                0.028458947928718337,
                0.02907205001422538,
                0.029651620814073566,
                0.030196991859798305,
                0.03070753412841561,
                0.03118265876792088,
                0.03162181777648101,
                0.03202450463448676,
                0.03239025488877077,
                0.032718646688299574,
                0.033009301270738665,
                0.033261883399308814,
                0.03347610174944315,
                0.033651709244800945,
                0.03378850334224136,
                0.03388632626543311,
                0.033945065186833566,
                0.03396465235781941,
                0.0339450651868328,
                0.033886326265432774,
                0.03378850334224202,
                0.03365170924480086,
                0.033476101749443564,
                0.03326188339930786,
                0.033009301270737854,
                0.032718646688299005,
                0.03239025488876975,
                0.0320245046344868,
                0.031621817776481424,
                0.03118265876792144,
                0.030707534128414912,
                0.03019699185979865,
                0.029651620814073736,
                0.02907205001422489,
                0.02845894792871865,
                0.027813021700483276,
                0.027135016331298296,
                0.026425713822504207,
                0.02568593227303626,
                0.024916524935823484,
                0.024118379233623404,
                0.023292415735443363,
                0.022439587094711888,
                0.02156087695042037,
                0.020657298792492167,
                0.019729894792668574,
                0.018779734602229453,
                0.017807914117895413,
                0.016815554217235053,
                0.015803799464914205,
                0.014773816791011217,
                0.01372679414243967,
                0.012663939108097055,
                0.011586477517382081,
                0.01049565200946645,
                0.009392720565092239,
                0.008278954977531927,
                0.007155639194123671,
                0.006024067305896505,
                0.004885540341145327,
                0.003741357842277409,
                0.002592777125621915,
                0.001440600785540793,
                0.0002337540906965698,
            ],
            "generator": "gauss_lobatto",
        },
        94: {
            "degree": 185,
            "points": [
                -0.9999999999999999,
                -0.9991603800062583,
                -0.9971862634948234,
                -0.994086171196165,
                -0.9898638427963968,
                -0.9845240870838974,
                -0.9780729439354161,
                -0.9705177002053695,
                -0.9618668865936977,
                -0.9521302695360889,
                -0.9413188407271305,
                -0.9294448049386155,
                -0.9165215663457567,
                -0.9025637134472799,
                -0.8875870026244463,
                -0.871608340369701,
                -0.8546457642107153,
                -0.8367184223541713,
                -0.8178465520737432,
                -0.7980514568674943,
                -0.777355482410919,
                -0.7557819913330639,
                -0.7333553368443488,
                -0.7101008352459768,
                -0.6860447373520087,
                -0.6612141988564391,
                -0.6356372496787133,
                -0.6093427623223442,
                -0.5823604192823322,
                -0.5547206795382131,
                -0.5264547441705458,
                -0.49759452113966907,
                -0.46817258926649186,
                -0.43822216145596404,
                -0.40777704720477104,
                -0.37687161443555195,
                -0.3455407507007344,
                -0.31381982379979223,
                -0.28174464185436565,
                -0.24935141288632634,
                -0.21667670394441507,
                -0.18375739982558947,
                -0.15063066143768333,
                -0.11733388385037191,
                -0.08390465408181336,
                -0.05038070866859856,
                -0.01679989106692603,
                0.016799891066926365,
                0.05038070866859845,
                0.08390465408181336,
                0.11733388385037224,
                0.15063066143768356,
                0.18375739982559014,
                0.21667670394441552,
                0.24935141288632645,
                0.2817446418543659,
                0.3138198237997927,
                0.34554075070073487,
                0.3768716144355524,
                0.4077770472047716,
                0.4382221614559644,
                0.46817258926649175,
                0.49759452113966973,
                0.526454744170546,
                0.5547206795382137,
                0.5823604192823328,
                0.6093427623223444,
                0.6356372496787137,
                0.6612141988564393,
                0.6860447373520094,
                0.710100835245977,
                0.73335533684435,
                0.7557819913330641,
                0.7773554824109195,
                0.7980514568674947,
                0.8178465520737442,
                0.8367184223541723,
                0.8546457642107164,
                0.8716083403697013,
                0.8875870026244468,
                0.9025637134472808,
                0.9165215663457574,
                0.9294448049386168,
                0.9413188407271312,
                0.9521302695360896,
                0.9618668865936986,
                0.9705177002053706,
                0.9780729439354171,
                0.9845240870838979,
                0.9898638427963974,
                0.9940861711961657,
                0.9971862634948241,
                0.9991603800062584,
                1.0,
            ],
            "weights": [
                0.00022878059940480255,
                0.0014099582852190164,
                0.002537663437295275,
                0.0036619116806187214,
                0.004781944958253353,
                0.005896559961769039,
                0.007004511787825379,
                0.008104553749490602,
                0.00919544555875005,
                0.010275956403925663,
                0.01134486685728453,
                0.012400970439111947,
                0.013443075056065807,
                0.014470004381093934,
                0.015480599197841383,
                0.016473718717708603,
                0.017448241872220903,
                0.018403068581148013,
                0.019337120995851637,
                0.02024934471693457,
                0.021138709985100743,
                0.022004212843954835,
                0.022844876273564595,
                0.023659751293542333,
                0.024447918034404957,
                0.02520848677605331,
                0.025940598952183706,
                0.026643428119518146,
                0.027316180890765034,
                0.027958097830263096,
                0.028568454311264358,
                0.029146561333963202,
                0.029691766303262535,
                0.030203453765478866,
                0.03068104610309284,
                0.03112400418679098,
                0.03153182798407632,
                0.03190405712372677,
                0.032240271415481934,
                0.03254009132438366,
                0.032803178399209626,
                0.03302923565453663,
                0.03321800790599395,
                0.03336928205832213,
                0.03348288734593582,
                0.033558695525686355,
                0.033596621021629317,
                0.033596621021629414,
                0.033558695525686556,
                0.03348288734593603,
                0.03336928205832153,
                0.033218007905993246,
                0.03302923565453649,
                0.032803178399210466,
                0.03254009132438435,
                0.03224027141548267,
                0.03190405712372746,
                0.03153182798407693,
                0.031124004186790868,
                0.030681046103091754,
                0.030203453765479598,
                0.029691766303262784,
                0.029146561333962262,
                0.02856845431126504,
                0.027958097830262985,
                0.027316180890766154,
                0.026643428119517497,
                0.025940598952182578,
                0.02520848677605312,
                0.02444791803440459,
                0.023659751293541743,
                0.022844876273564487,
                0.02200421284395513,
                0.021138709985101468,
                0.020249344716934604,
                0.019337120995849246,
                0.018403068581148325,
                0.017448241872221333,
                0.016473718717708512,
                0.015480599197842075,
                0.014470004381094935,
                0.013443075056066034,
                0.01240097043911176,
                0.011344866857284993,
                0.010275956403924492,
                0.009195445558750407,
                0.008104553749491369,
                0.007004511787824629,
                0.005896559961769189,
                0.0047819449582526,
                0.003661911680619421,
                0.0025376634372961467,
                0.001409958285218527,
                0.00022878059940515717,
            ],
            "generator": "gauss_lobatto",
        },
        95: {
            "degree": 187,
            "points": [
                -0.9999999999999999,
                -0.9991780537948777,
                -0.9972454728441199,
                -0.994210552587176,
                -0.9900768819653893,
                -0.9848490705660524,
                -0.9785329074172602,
                -0.971135376819581,
                -0.9626646556140728,
                -0.9531301056342096,
                -0.9425422638966696,
                -0.9309128311785086,
                -0.9182546591881646,
                -0.9045817364134987,
                -0.8899091726899622,
                -0.8742531825178279,
                -0.8576310671524858,
                -0.8400611954903694,
                -0.8215629837730867,
                -0.8021568741329592,
                -0.7818643120041386,
                -0.7607077224245387,
                -0.7387104852549145,
                -0.7158969093425782,
                -0.6922922056583791,
                -0.6679224594366568,
                -0.6428146013490017,
                -0.6169963777436793,
                -0.5904963199836328,
                -0.5633437129169507,
                -0.5355685625146522,
                -0.50720156271155,
                -0.47827406148685125,
                -0.4488180262219694,
                -0.4188660083738398,
                -0.3884511075027748,
                -0.3576069346946178,
                -0.3263675754176072,
                -0.29476755185501613,
                -0.26284178475516806,
                -0.230625554841015,
                -0.1981544638219057,
                -0.16546439505063315,
                -0.13259147386924797,
                -0.09957202768744566,
                -0.06644254583765563,
                -0.033239639251186226,
                -2.220446049250313e-16,
                0.033239639251186115,
                0.0664425458376553,
                0.09957202768744622,
                0.13259147386924763,
                0.16546439505063326,
                0.1981544638219056,
                0.2306255548410152,
                0.2628417847551683,
                0.29476755185501635,
                0.32636757541760775,
                0.3576069346946177,
                0.38845110750277534,
                0.41886600837384025,
                0.4488180262219701,
                0.47827406148685203,
                0.5072015627115505,
                0.5355685625146525,
                0.5633437129169512,
                0.5904963199836328,
                0.6169963777436794,
                0.6428146013490021,
                0.6679224594366573,
                0.6922922056583792,
                0.7158969093425789,
                0.7387104852549151,
                0.7607077224245393,
                0.7818643120041388,
                0.8021568741329592,
                0.8215629837730879,
                0.8400611954903701,
                0.8576310671524858,
                0.8742531825178288,
                0.8899091726899631,
                0.9045817364134987,
                0.9182546591881652,
                0.93091283117851,
                0.9425422638966698,
                0.9531301056342103,
                0.9626646556140733,
                0.9711353768195817,
                0.9785329074172608,
                0.9848490705660531,
                0.9900768819653901,
                0.9942105525871768,
                0.9972454728441205,
                0.9991780537948779,
                1.0,
            ],
            "weights": [
                0.00022396416573309248,
                0.0013802830872706726,
                0.0024842880359848135,
                0.0035849678347397666,
                0.004681606424547469,
                0.005773051678903585,
                0.006858110504034438,
                0.007935587754480394,
                0.00900429418628915,
                0.010063049413204822,
                0.011110683718378605,
                0.01214603953057558,
                0.013167972778206923,
                0.014175354187114523,
                0.015167070544695559,
                0.016142025938385558,
                0.017099142971240308,
                0.018037363955091295,
                0.01895565208087799,
                0.019852992565323493,
                0.02072839377291949,
                0.021580888312147925,
                0.02240953410476066,
                0.02321341542702839,
                0.023991643921800372,
                0.024743359580291436,
                0.025467731692527897,
                0.026163959765386748,
                0.02683127440723781,
                0.027468938178216062,
                0.02807624640516573,
                0.028652527960375995,
                0.029197146003247992,
                0.029709498684063026,
                0.030189019809083655,
                0.030635179466255283,
                0.03104748461079766,
                0.03142547961007739,
                0.031768746747110985,
                0.03207690668218824,
                0.032349618872074666,
                0.032586581946339094,
                0.03278753404039886,
                0.032952253084901156,
                0.033080557051127786,
                0.03317230415215751,
                0.0332273929995492,
                0.03324576271538435,
                0.03322739299954827,
                0.03317230415215725,
                0.033080557051128244,
                0.03295225308490113,
                0.032787534040399996,
                0.03258658194633933,
                0.03234961887207407,
                0.03207690668218786,
                0.03176874674711012,
                0.031425479610076405,
                0.031047484610797465,
                0.030635179466254776,
                0.030189019809084693,
                0.029709498684062655,
                0.029197146003247552,
                0.028652527960376425,
                0.028076246405165574,
                0.027468938178216433,
                0.026831274407237638,
                0.02616395976538538,
                0.02546773169252758,
                0.024743359580291002,
                0.023991643921800112,
                0.023213415427028646,
                0.022409534104761507,
                0.021580888312147484,
                0.02072839377291931,
                0.01985299256532227,
                0.018955652080877985,
                0.018037363955091562,
                0.017099142971240818,
                0.016142025938385967,
                0.015167070544696163,
                0.014175354187115565,
                0.013167972778206477,
                0.012146039530575923,
                0.011110683718378249,
                0.010063049413203334,
                0.009004294186289872,
                0.007935587754481393,
                0.006858110504033677,
                0.0057730516789039465,
                0.00468160642454667,
                0.0035849678347406244,
                0.002484288035985806,
                0.0013802830872701856,
                0.00022396416573346276,
            ],
            "generator": "gauss_lobatto",
        },
        96: {
            "degree": 189,
            "points": [
                -1.0,
                -0.999195175376926,
                -0.997302833017008,
                -0.9943310519906123,
                -0.9902832781543303,
                -0.9851639321266141,
                -0.978978564977784,
                -0.9717338739890569,
                -0.9634377002879264,
                -0.9540990218205396,
                -0.9437279441621884,
                -0.9323356897992658,
                -0.9199345860850412,
                -0.90653805194989,
                -0.8921605834072086,
                -0.8768177378823581,
                -0.8605261173870324,
                -0.843303350559981,
                -0.8251680735949178,
                -0.8061399100770419,
                -0.786239449750429,
                -0.7654882262395202,
                -0.7439086937489796,
                -0.7215242027672275,
                -0.6983589748000016,
                -0.6744380761613378,
                -0.6497873908503309,
                -0.6244335925430788,
                -0.5984041157300983,
                -0.5717271260304713,
                -0.544431489714841,
                -0.5165467424702437,
                -0.48810305744058025,
                -0.4591312125773004,
                -0.42966255733565384,
                -0.39972897875251934,
                -0.36936286694253395,
                -0.33859708004985944,
                -0.3074649086935082,
                -0.276000039944692,
                -0.24423652087519443,
                -0.21220872171618543,
                -0.1799512986673666,
                -0.14749915639666966,
                -0.11488741027109839,
                -0.0821513483595846,
                -0.04932639324895782,
                -0.01644806371437002,
                0.01644806371437102,
                0.04932639324895838,
                0.08215134835958515,
                0.11488741027109906,
                0.14749915639666988,
                0.17995129866736714,
                0.21220872171618643,
                0.24423652087519498,
                0.2760000399446929,
                0.30746490869350884,
                0.33859708004986033,
                0.36936286694253406,
                0.3997289787525199,
                0.4296625573356546,
                0.45913121257730094,
                0.48810305744058036,
                0.5165467424702446,
                0.5444314897148415,
                0.5717271260304717,
                0.598404115730099,
                0.6244335925430795,
                0.6497873908503318,
                0.6744380761613384,
                0.6983589748000026,
                0.7215242027672276,
                0.7439086937489799,
                0.7654882262395207,
                0.7862394497504295,
                0.8061399100770424,
                0.8251680735949183,
                0.8433033505599818,
                0.860526117387033,
                0.876817737882358,
                0.8921605834072087,
                0.90653805194989,
                0.9199345860850416,
                0.9323356897992663,
                0.9437279441621886,
                0.9540990218205402,
                0.9634377002879265,
                0.9717338739890573,
                0.9789785649777843,
                0.985163932126614,
                0.9902832781543305,
                0.9943310519906123,
                0.9973028330170083,
                0.999195175376926,
                1.0,
            ],
            "weights": [
                0.0002192982456134513,
                0.0013515349056560863,
                0.002432578603009581,
                0.003510422375023907,
                0.004584389784780243,
                0.00565337723637112,
                0.006716240789720554,
                0.007771834211913673,
                0.008819016711676385,
                0.00985665578151856,
                0.01088362891988304,
                0.011898825025498029,
                0.012901145672925333,
                0.013889506333908836,
                0.014862837566750295,
                0.01582008618163064,
                0.016760216384642295,
                0.017682210901064418,
                0.018585072077597516,
                0.01946782296277539,
                0.020329508364648165,
                0.021169195884721256,
                0.021985976927118133,
                0.022778967681879817,
                0.023547310081440353,
                0.024290172729165737,
                0.025006751799048123,
                0.025696271905530702,
                0.026357986942555835,
                0.02699118089092438,
                0.027595168593088314,
                0.028169296494549703,
                0.028712943351056067,
                0.02922552090083772,
                0.029706474501154413,
                0.03015528372844893,
                0.030571462941492662,
                0.030954561806881713,
                0.03130416578632985,
                0.03161989658522326,
                0.03190141256196655,
                0.03214840909766446,
                0.03236061892573427,
                0.03253781242111013,
                0.03267979784871285,
                0.032786421570919703,
                0.032857568213814824,
                0.03289316079202326,
                0.032893160792023694,
                0.03285756821381499,
                0.032786421570920106,
                0.032679797848711944,
                0.03253781242110967,
                0.03236061892573297,
                0.032148409097664324,
                0.03190141256196693,
                0.03161989658522308,
                0.03130416578633025,
                0.030954561806882806,
                0.03057146294149317,
                0.0301552837284493,
                0.029706474501153754,
                0.029225520900838256,
                0.028712943351056206,
                0.02816929649454915,
                0.02759516859308877,
                0.026991180890924556,
                0.026357986942555325,
                0.025696271905530185,
                0.02500675179904766,
                0.02429017272916586,
                0.023547310081440016,
                0.02277896768188062,
                0.021985976927117085,
                0.02116919588472198,
                0.020329508364647537,
                0.01946782296277504,
                0.018585072077598165,
                0.017682210901064185,
                0.01676021638464178,
                0.01582008618163137,
                0.014862837566750428,
                0.013889506333909224,
                0.012901145672924668,
                0.011898825025498548,
                0.010883628919882099,
                0.009856655781517298,
                0.008819016711677044,
                0.007771834211914658,
                0.006716240789720135,
                0.005653377236371471,
                0.00458438978477941,
                0.003510422375024565,
                0.002432578603010575,
                0.001351534905655541,
                0.00021929824561401972,
            ],
            "generator": "gauss_lobatto",
        },
        97: {
            "degree": 191,
            "points": [
                -0.9999999999999999,
                -0.9992117675187677,
                -0.9973584202115748,
                -0.994447829238317,
                -0.9904833045655761,
                -0.9854690874505485,
                -0.9794105031099913,
                -0.9723139763933841,
                -0.9641870297556598,
                -0.9550382767121335,
                -0.9448774132246325,
                -0.933715207638498,
                -0.9215634893679368,
                -0.9084351364079282,
                -0.8943440617122116,
                -0.8793051984632039,
                -0.8633344842547972,
                -0.8464488442074509,
                -0.828666173034855,
                -0.8100053160819363,
                -0.7904860493547248,
                -0.7701290585635134,
                -0.748955917201652,
                -0.7269890636833278,
                -0.7042517775645993,
                -0.6807681548729423,
                -0.6565630825714663,
                -0.631662212184884,
                -0.6060919326152066,
                -0.5798793421759614,
                -0.5530522198745995,
                -0.5256389959735104,
                -0.497668721860858,
                -0.4691710392631656,
                -0.44017614883227796,
                -0.410714778139994,
                -0.3808181491142908,
                -0.350517944951638,
                -0.31984627654049036,
                -0.28883564843151577,
                -0.2575189243906433,
                -0.22592929257142313,
                -0.19410023034362234,
                -0.1620654688153067,
                -0.1298589570860329,
                -0.09751482626901797,
                -0.06506735332041469,
                -0.03255092471403365,
                4.440892098500626e-16,
                0.03255092471403409,
                0.06506735332041536,
                0.09751482626901886,
                0.12985895708603312,
                0.1620654688153068,
                0.19410023034362256,
                0.22592929257142347,
                0.25751892439064306,
                0.288835648431516,
                0.3198462765404908,
                0.3505179449516387,
                0.3808181491142909,
                0.4107147781399946,
                0.44017614883227796,
                0.4691710392631657,
                0.4976687218608581,
                0.5256389959735107,
                0.5530522198745997,
                0.5798793421759614,
                0.6060919326152063,
                0.6316622121848839,
                0.6565630825714661,
                0.6807681548729428,
                0.7042517775645998,
                0.7269890636833282,
                0.7489559172016527,
                0.7701290585635137,
                0.7904860493547252,
                0.8100053160819364,
                0.8286661730348553,
                0.8464488442074511,
                0.8633344842547974,
                0.8793051984632039,
                0.8943440617122116,
                0.9084351364079281,
                0.9215634893679365,
                0.9337152076384981,
                0.944877413224633,
                0.955038276712134,
                0.9641870297556596,
                0.9723139763933839,
                0.9794105031099911,
                0.9854690874505482,
                0.9904833045655764,
                0.9944478292383172,
                0.9973584202115753,
                0.999211767518768,
                1.0,
            ],
            "weights": [
                0.00021477663230194273,
                0.0013236755298252376,
                0.0023824665407633314,
                0.0034381767087557145,
                0.004490166994744291,
                0.005537379844305034,
                0.006578717976538253,
                0.007613081601077933,
                0.008639375943790668,
                0.009656513981520091,
                0.010663418080519885,
                0.011659021314494969,
                0.01264226866703982,
                0.013612118181804123,
                0.014567542082226504,
                0.015507527868679209,
                0.016431079395788098,
                0.017337217930541254,
                0.018224983190944625,
                0.019093434364555174,
                0.01994165110607531,
                0.020768734513027416,
                0.021573808078620398,
                0.02235601862078287,
                0.023114537186434577,
                0.023848559930061144,
                0.024557308965633143,
                0.02524003319103049,
                0.02589600908403983,
                0.026524541469149957,
                0.02712496425427851,
                0.027696641136670242,
                0.028238966277250963,
                0.028751364942657523,
                0.029233294114338965,
                0.029684243064019847,
                0.030103733894949754,
                0.030491322048364886,
                0.03084659677461724,
                0.031169181568463267,
                0.0314587345680786,
                0.03171494891734482,
                0.031937553091041876,
                0.03212631118260742,
                0.03228102315413297,
                0.03240152504835826,
                0.03248768916243143,
                0.03253942418323771,
                0.03255667528417011,
                0.032539424183237096,
                0.03248768916243127,
                0.03240152504835838,
                0.032281023154133025,
                0.032126311182608294,
                0.03193755309104297,
                0.03171494891734496,
                0.03145873456807881,
                0.03116918156846338,
                0.03084659677461683,
                0.030491322048364584,
                0.030103733894949088,
                0.02968424306401917,
                0.029233294114339732,
                0.02875136494265751,
                0.028238966277249835,
                0.027696641136670967,
                0.027124964254278332,
                0.026524541469150693,
                0.0258960090840399,
                0.025240033191029417,
                0.024557308965633427,
                0.023848559930060628,
                0.023114537186435014,
                0.022356018620782004,
                0.021573808078620228,
                0.020768734513027704,
                0.01994165110607523,
                0.019093434364556218,
                0.018224983190943553,
                0.01733721793054087,
                0.016431079395787834,
                0.01550752786867934,
                0.014567542082226586,
                0.013612118181804413,
                0.012642268667039115,
                0.011659021314495189,
                0.01066341808051903,
                0.009656513981519656,
                0.008639375943791092,
                0.0076130816010789104,
                0.006578717976538041,
                0.0055373798443054826,
                0.004490166994743627,
                0.003438176708756313,
                0.0023824665407643757,
                0.0013236755298246846,
                0.00021477663230238725,
            ],
            "generator": "gauss_lobatto",
        },
        98: {
            "degree": 193,
            "points": [
                -0.9999999999999999,
                -0.9992278518255229,
                -0.9974123067416633,
                -0.9945610360225208,
                -0.9906772205068566,
                -0.985764931117584,
                -0.9798292785908649,
                -0.9728764290517948,
                -0.9649136022969922,
                -0.9559490656972363,
                -0.9459921261186959,
                -0.9350531204691948,
                -0.923143405062335,
                -0.9102753438753701,
                -0.8964622957387736,
                -0.8817186004819952,
                -0.8660595640549962,
                -0.849501442643624,
                -0.8320614257966601,
                -0.8137576185828213,
                -0.7946090227966323,
                -0.7746355172329706,
                -0.7538578370508582,
                -0.7322975522480701,
                -0.709977045268936,
                -0.6869194877686202,
                -0.6631488165580437,
                -0.6386897087544232,
                -0.6135675561632479,
                -0.5878084389182829,
                -0.5614390984069879,
                -0.5344869095094493,
                -0.5069798521796549,
                -0.4789464823986114,
                -0.45041590252946606,
                -0.4214177311054079,
                -0.391982072081706,
                -0.362139483583821,
                -0.33192094618401824,
                -0.3013578307394311,
                -0.2704818658249426,
                -0.23932510479472202,
                -0.20791989250658705,
                -0.17629883174374883,
                -0.14449474936879558,
                -0.11254066224505,
                -0.08046974296068443,
                -0.048315285391164586,
                -0.016110670135792482,
                0.016110670135792815,
                0.048315285391164586,
                0.08046974296068421,
                0.11254066224504977,
                0.14449474936879525,
                0.1762988317437485,
                0.20791989250658693,
                0.2393251047947219,
                0.2704818658249424,
                0.3013578307394309,
                0.33192094618401846,
                0.36213948358382075,
                0.3919820720817059,
                0.4214177311054077,
                0.4504159025294665,
                0.4789464823986116,
                0.5069798521796554,
                0.5344869095094495,
                0.5614390984069879,
                0.5878084389182829,
                0.6135675561632481,
                0.6386897087544239,
                0.6631488165580439,
                0.6869194877686209,
                0.7099770452689367,
                0.732297552248071,
                0.7538578370508584,
                0.7746355172329711,
                0.7946090227966331,
                0.8137576185828206,
                0.8320614257966605,
                0.8495014426436241,
                0.8660595640549968,
                0.8817186004819952,
                0.8964622957387737,
                0.9102753438753701,
                0.9231434050623357,
                0.9350531204691953,
                0.9459921261186963,
                0.9559490656972371,
                0.9649136022969923,
                0.9728764290517952,
                0.9798292785908651,
                0.9857649311175847,
                0.9906772205068576,
                0.994561036022521,
                0.9974123067416637,
                0.9992278518255231,
                1.0,
            ],
            "weights": [
                0.00021039343572434695,
                0.0012966686977257636,
                0.0023338867453642003,
                0.0033681372547991434,
                0.0043988165013377975,
                0.005424910633713039,
                0.006445366685723346,
                0.0074591289874154304,
                0.008465146491308355,
                0.0094623754059016,
                0.010449780755787053,
                0.011426337628496838,
                0.012391032308784031,
                0.013342863362451017,
                0.014280842691149754,
                0.015203996565960685,
                0.0161113666424694,
                0.017002010958050044,
                0.01787500491114349,
                0.018729442221977137,
                0.019564435873932803,
                0.020379119034743324,
                0.02117264595659282,
                0.02194419285427407,
                0.022692958760490094,
                0.02341816635743689,
                0.024119062783817567,
                0.024794920416444228,
                0.025445037625638472,
                0.026068739503629847,
                0.026665378565229145,
                0.027234335419995905,
                0.027775019415269917,
                0.028286869249349363,
                0.028769353554201006,
                0.0292219714470958,
                0.029644253050596037,
                0.03003575998035015,
                0.03039608580019825,
                0.03072485644410676,
                0.03102173060449977,
                0.0312864000865842,
                0.03151859012829952,
                0.031718059685551796,
                0.03188460168245316,
                0.032018043226299794,
                0.03211824578704578,
                0.03218510534113172,
                0.03221855247945975,
                0.032218552479459886,
                0.0321851053411322,
                0.032118245787046355,
                0.032018043226298906,
                0.03188460168245327,
                0.0317180596855504,
                0.031518590128298565,
                0.031286400086584114,
                0.031021730604499455,
                0.030724856444106247,
                0.03039608580019834,
                0.03003575998035058,
                0.029644253050596443,
                0.0292219714470966,
                0.02876935355420066,
                0.028286869249349176,
                0.02777501941527058,
                0.02723433541999597,
                0.026665378565229252,
                0.026068739503630887,
                0.02544503762563715,
                0.024794920416443524,
                0.024119062783817147,
                0.023418166357436633,
                0.02269295876048939,
                0.021944192854273712,
                0.02117264595659358,
                0.020379119034743813,
                0.019564435873933122,
                0.018729442221976027,
                0.017875004911142457,
                0.01700201095804972,
                0.016111366642469743,
                0.015203996565960328,
                0.014280842691149861,
                0.013342863362451135,
                0.01239103230878435,
                0.01142633762849675,
                0.010449780755786736,
                0.00946237540590182,
                0.008465146491308705,
                0.007459128987416846,
                0.006445366685723322,
                0.005424910633713091,
                0.004398816501337051,
                0.0033681372547996447,
                0.0023338867453652017,
                0.001296668697725118,
                0.00021039343572479217,
            ],
            "generator": "gauss_lobatto",
        },
        99: {
            "degree": 195,
            "points": [
                -0.9999999999999998,
                -0.9992434488114226,
                -0.9974645612720405,
                -0.9946708163880984,
                -0.990865272230294,
                -0.9860518378741467,
                -0.9802354202679529,
                -0.973421939700841,
                -0.9656183283699986,
                -0.9568325246989797,
                -0.9470734657566864,
                -0.9363510783707389,
                -0.9246762691235482,
                -0.9120609133048243,
                -0.8985178428569907,
                -0.8840608333367166,
                -0.8687045899109522,
                -0.8524647324042625,
                -0.8353577794139908,
                -0.8174011315101442,
                -0.7986130535375049,
                -0.7790126560382067,
                -0.7586198758138256,
                -0.7374554556468522,
                -0.7155409232022156,
                -0.6928985691303835,
                -0.6695514243943048,
                -0.6455232368433048,
                -0.6208384470577515,
                -0.595522163489081,
                -0.5696001369204744,
                -0.5430987342741627,
                -0.516044911792009,
                -0.4884661876166547,
                -0.460390613801106,
                -0.43184674777525034,
                -0.4028636232983165,
                -0.37347072092682465,
                -0.34369793802807425,
                -0.31357555836965934,
                -0.28313422131595667,
                -0.25240489066290817,
                -0.22141882314280448,
                -0.1902075366311058,
                -0.1588027780876331,
                -0.12723649126474745,
                -0.09554078421535372,
                -0.06374789663378788,
                -0.0318901670628009,
                0.0,
                0.03189016706280112,
                0.06374789663378799,
                0.09554078421535417,
                0.12723649126474768,
                0.15880277808763366,
                0.1902075366311059,
                0.2214188231428048,
                0.2524048906629087,
                0.2831342213159572,
                0.3135755583696599,
                0.3436979380280746,
                0.373470720926825,
                0.4028636232983167,
                0.4318467477752509,
                0.46039061380110646,
                0.4884661876166555,
                0.5160449117920096,
                0.5430987342741629,
                0.5696001369204747,
                0.5955221634890812,
                0.6208384470577514,
                0.6455232368433049,
                0.669551424394305,
                0.6928985691303837,
                0.7155409232022161,
                0.737455455646852,
                0.7586198758138258,
                0.7790126560382067,
                0.7986130535375053,
                0.8174011315101445,
                0.835357779413991,
                0.8524647324042628,
                0.8687045899109526,
                0.8840608333367167,
                0.8985178428569909,
                0.9120609133048241,
                0.924676269123548,
                0.936351078370739,
                0.9470734657566869,
                0.9568325246989802,
                0.9656183283699988,
                0.9734219397008408,
                0.980235420267953,
                0.9860518378741464,
                0.9908652722302943,
                0.9946708163880983,
                0.997464561272041,
                0.9992434488114229,
                1.0,
            ],
            "weights": [
                0.00020614306328558434,
                0.0012704799777829075,
                0.0022867773953415276,
                0.0033002151411629086,
                0.004310222852066574,
                0.00531582818188288,
                0.006316020274268991,
                0.007309785395200894,
                0.00829611406845865,
                0.009274003613616447,
                0.010242459632814758,
                0.011200497191141199,
                0.012147141887326959,
                0.013081430875699223,
                0.01400241386041639,
                0.014909154069722687,
                0.01580072921292406,
                0.016676232420854246,
                0.01753477316967966,
                0.018375478187549626,
                0.019197492343363858,
                0.01999997951694562,
                0.020782123449709224,
                0.021543128575081963,
                0.022282220827838508,
                0.022998648431509474,
                0.02369168266311368,
                0.02436061859443274,
                0.025004775809052502,
                0.02562349909448439,
                0.026216159108635142,
                0.026782153019963253,
                0.027320905120661772,
                0.02783186741225319,
                0.02831452016300061,
                0.028768372436566318,
                0.029192962591368467,
                0.02958785875015163,
                0.029952659239283835,
                0.030286992997319944,
                0.03059051995243148,
                0.030862931368320346,
                0.03110395015825203,
                0.03131333116689824,
                0.031490861419706084,
                0.0316363603395166,
                0.03174967993025225,
                0.03183070492744873,
                0.0318793529154999,
                0.03189557441148312,
                0.031879352915499405,
                0.031830704927448494,
                0.03174967993025165,
                0.03163636033951665,
                0.031490861419705946,
                0.03131333116689957,
                0.03110395015825286,
                0.030862931368320773,
                0.030590519952431748,
                0.03028699299732054,
                0.029952659239284307,
                0.02958785875015149,
                0.029192962591367715,
                0.02876837243656581,
                0.028314520163001056,
                0.027831867412253082,
                0.02732090512066109,
                0.026782153019963555,
                0.02621615910863548,
                0.02562349909448344,
                0.025004775809051707,
                0.02436061859443228,
                0.023691682663113608,
                0.022998648431508926,
                0.022282220827838668,
                0.021543128575082896,
                0.02078212344970862,
                0.019999979516945994,
                0.019197492343363907,
                0.018375478187546722,
                0.017534773169679788,
                0.016676232420854236,
                0.015800729212924438,
                0.0149091540697225,
                0.014002413860416793,
                0.013081430875699093,
                0.012147141887327413,
                0.011200497191140853,
                0.010242459632815108,
                0.009274003613616794,
                0.008296114068458711,
                0.007309785395202456,
                0.006316020274268879,
                0.005315828181882837,
                0.004310222852065901,
                0.003300215141163199,
                0.0022867773953425645,
                0.0012704799777822748,
                0.0002061430632859134,
            ],
            "generator": "gauss_lobatto",
        },
    }


class Legendre(IntervalQuadrature):
    data = {
        1: {
            "degree": 1,
            "points": [0.0],
            "weights": [2.0],
            "generator": "gauss_legendre",
        },
        2: {
            "degree": 3,
            "points": [-0.5773502691896257, 0.5773502691896257],
            "weights": [1.0, 1.0],
            "generator": "gauss_legendre",
        },
        3: {
            "degree": 5,
            "points": [-0.7745966692414834, 0.0, 0.7745966692414834],
            "weights": [0.5555555555555557, 0.8888888888888888, 0.5555555555555557],
            "generator": "gauss_legendre",
        },
        4: {
            "degree": 7,
            "points": [
                -0.8611363115940526,
                -0.33998104358485626,
                0.33998104358485626,
                0.8611363115940526,
            ],
            "weights": [
                0.3478548451374537,
                0.6521451548625462,
                0.6521451548625462,
                0.3478548451374537,
            ],
            "generator": "gauss_legendre",
        },
        5: {
            "degree": 9,
            "points": [
                -0.906179845938664,
                -0.5384693101056831,
                0.0,
                0.5384693101056831,
                0.906179845938664,
            ],
            "weights": [
                0.23692688505618942,
                0.4786286704993662,
                0.568888888888889,
                0.4786286704993662,
                0.23692688505618942,
            ],
            "generator": "gauss_legendre",
        },
        6: {
            "degree": 11,
            "points": [
                -0.932469514203152,
                -0.6612093864662645,
                -0.23861918608319693,
                0.23861918608319693,
                0.6612093864662645,
                0.932469514203152,
            ],
            "weights": [
                0.17132449237916975,
                0.36076157304813894,
                0.46791393457269137,
                0.46791393457269137,
                0.36076157304813894,
                0.17132449237916975,
            ],
            "generator": "gauss_legendre",
        },
        7: {
            "degree": 13,
            "points": [
                -0.9491079123427585,
                -0.7415311855993945,
                -0.4058451513773972,
                0.0,
                0.4058451513773972,
                0.7415311855993945,
                0.9491079123427585,
            ],
            "weights": [
                0.12948496616887065,
                0.2797053914892766,
                0.3818300505051183,
                0.41795918367346896,
                0.3818300505051183,
                0.2797053914892766,
                0.12948496616887065,
            ],
            "generator": "gauss_legendre",
        },
        8: {
            "degree": 15,
            "points": [
                -0.9602898564975362,
                -0.7966664774136267,
                -0.525532409916329,
                -0.18343464249564978,
                0.18343464249564978,
                0.525532409916329,
                0.7966664774136267,
                0.9602898564975362,
            ],
            "weights": [
                0.10122853629037669,
                0.22238103445337434,
                0.31370664587788705,
                0.36268378337836177,
                0.36268378337836177,
                0.31370664587788705,
                0.22238103445337434,
                0.10122853629037669,
            ],
            "generator": "gauss_legendre",
        },
        9: {
            "degree": 17,
            "points": [
                -0.9681602395076261,
                -0.8360311073266358,
                -0.6133714327005904,
                -0.3242534234038089,
                0.0,
                0.3242534234038089,
                0.6133714327005904,
                0.8360311073266358,
                0.9681602395076261,
            ],
            "weights": [
                0.08127438836157472,
                0.18064816069485712,
                0.26061069640293566,
                0.3123470770400028,
                0.33023935500125967,
                0.3123470770400028,
                0.26061069640293566,
                0.18064816069485712,
                0.08127438836157472,
            ],
            "generator": "gauss_legendre",
        },
        10: {
            "degree": 19,
            "points": [
                -0.9739065285171717,
                -0.8650633666889845,
                -0.6794095682990244,
                -0.4333953941292472,
                -0.14887433898163122,
                0.14887433898163122,
                0.4333953941292472,
                0.6794095682990244,
                0.8650633666889845,
                0.9739065285171717,
            ],
            "weights": [
                0.06667134430868807,
                0.14945134915058036,
                0.219086362515982,
                0.2692667193099965,
                0.295524224714753,
                0.295524224714753,
                0.2692667193099965,
                0.219086362515982,
                0.14945134915058036,
                0.06667134430868807,
            ],
            "generator": "gauss_legendre",
        },
        11: {
            "degree": 21,
            "points": [
                -0.978228658146057,
                -0.8870625997680953,
                -0.7301520055740494,
                -0.5190961292068118,
                -0.26954315595234496,
                0.0,
                0.26954315595234496,
                0.5190961292068118,
                0.7301520055740494,
                0.8870625997680953,
                0.978228658146057,
            ],
            "weights": [
                0.055668567116173164,
                0.1255803694649047,
                0.18629021092773443,
                0.23319376459199068,
                0.26280454451024676,
                0.2729250867779009,
                0.26280454451024676,
                0.23319376459199068,
                0.18629021092773443,
                0.1255803694649047,
                0.055668567116173164,
            ],
            "generator": "gauss_legendre",
        },
        12: {
            "degree": 23,
            "points": [
                -0.9815606342467192,
                -0.9041172563704748,
                -0.7699026741943047,
                -0.5873179542866175,
                -0.3678314989981802,
                -0.1252334085114689,
                0.1252334085114689,
                0.3678314989981802,
                0.5873179542866175,
                0.7699026741943047,
                0.9041172563704748,
                0.9815606342467192,
            ],
            "weights": [
                0.04717533638651202,
                0.10693932599531888,
                0.1600783285433461,
                0.20316742672306565,
                0.23349253653835464,
                0.2491470458134027,
                0.2491470458134027,
                0.23349253653835464,
                0.20316742672306565,
                0.1600783285433461,
                0.10693932599531888,
                0.04717533638651202,
            ],
            "generator": "gauss_legendre",
        },
        13: {
            "degree": 25,
            "points": [
                -0.9841830547185881,
                -0.9175983992229779,
                -0.8015780907333099,
                -0.6423493394403402,
                -0.4484927510364468,
                -0.23045831595513477,
                0.0,
                0.23045831595513477,
                0.4484927510364468,
                0.6423493394403402,
                0.8015780907333099,
                0.9175983992229779,
                0.9841830547185881,
            ],
            "weights": [
                0.04048400476531588,
                0.0921214998377286,
                0.13887351021978736,
                0.17814598076194552,
                0.20781604753688857,
                0.22628318026289715,
                0.2325515532308739,
                0.22628318026289715,
                0.20781604753688857,
                0.17814598076194552,
                0.13887351021978736,
                0.0921214998377286,
                0.04048400476531588,
            ],
            "generator": "gauss_legendre",
        },
        14: {
            "degree": 27,
            "points": [
                -0.9862838086968123,
                -0.9284348836635735,
                -0.827201315069765,
                -0.6872929048116855,
                -0.5152486363581541,
                -0.31911236892788974,
                -0.10805494870734367,
                0.10805494870734367,
                0.31911236892788974,
                0.5152486363581541,
                0.6872929048116855,
                0.827201315069765,
                0.9284348836635735,
                0.9862838086968123,
            ],
            "weights": [
                0.035119460331752374,
                0.0801580871597603,
                0.12151857068790296,
                0.1572031671581934,
                0.18553839747793763,
                0.20519846372129555,
                0.21526385346315766,
                0.21526385346315766,
                0.20519846372129555,
                0.18553839747793763,
                0.1572031671581934,
                0.12151857068790296,
                0.0801580871597603,
                0.035119460331752374,
            ],
            "generator": "gauss_legendre",
        },
        15: {
            "degree": 29,
            "points": [
                -0.9879925180204854,
                -0.937273392400706,
                -0.8482065834104272,
                -0.7244177313601701,
                -0.5709721726085388,
                -0.3941513470775634,
                -0.20119409399743451,
                0.0,
                0.20119409399743451,
                0.3941513470775634,
                0.5709721726085388,
                0.7244177313601701,
                0.8482065834104272,
                0.937273392400706,
                0.9879925180204854,
            ],
            "weights": [
                0.030753241996118647,
                0.07036604748810807,
                0.10715922046717177,
                0.1395706779261539,
                0.16626920581699378,
                0.18616100001556188,
                0.19843148532711125,
                0.2025782419255609,
                0.19843148532711125,
                0.18616100001556188,
                0.16626920581699378,
                0.1395706779261539,
                0.10715922046717177,
                0.07036604748810807,
                0.030753241996118647,
            ],
            "generator": "gauss_legendre",
        },
        16: {
            "degree": 31,
            "points": [
                -0.9894009349916499,
                -0.9445750230732326,
                -0.8656312023878318,
                -0.755404408355003,
                -0.6178762444026438,
                -0.45801677765722737,
                -0.2816035507792589,
                -0.09501250983763745,
                0.09501250983763745,
                0.2816035507792589,
                0.45801677765722737,
                0.6178762444026438,
                0.755404408355003,
                0.8656312023878318,
                0.9445750230732326,
                0.9894009349916499,
            ],
            "weights": [
                0.027152459411754037,
                0.062253523938647706,
                0.09515851168249259,
                0.12462897125553403,
                0.14959598881657676,
                0.16915651939500262,
                0.1826034150449236,
                0.18945061045506859,
                0.18945061045506859,
                0.1826034150449236,
                0.16915651939500262,
                0.14959598881657676,
                0.12462897125553403,
                0.09515851168249259,
                0.062253523938647706,
                0.027152459411754037,
            ],
            "generator": "gauss_legendre",
        },
        17: {
            "degree": 33,
            "points": [
                -0.9905754753144174,
                -0.9506755217687678,
                -0.8802391537269859,
                -0.7815140038968014,
                -0.6576711592166908,
                -0.5126905370864769,
                -0.3512317634538763,
                -0.17848418149584785,
                0.0,
                0.17848418149584785,
                0.3512317634538763,
                0.5126905370864769,
                0.6576711592166908,
                0.7815140038968014,
                0.8802391537269859,
                0.9506755217687678,
                0.9905754753144174,
            ],
            "weights": [
                0.02414830286854952,
                0.0554595293739866,
                0.08503614831717908,
                0.11188384719340365,
                0.13513636846852523,
                0.15404576107681012,
                0.16800410215644995,
                0.17656270536699253,
                0.17944647035620653,
                0.17656270536699253,
                0.16800410215644995,
                0.15404576107681012,
                0.13513636846852523,
                0.11188384719340365,
                0.08503614831717908,
                0.0554595293739866,
                0.02414830286854952,
            ],
            "generator": "gauss_legendre",
        },
        18: {
            "degree": 35,
            "points": [
                -0.9915651684209309,
                -0.9558239495713978,
                -0.8926024664975557,
                -0.8037049589725231,
                -0.6916870430603532,
                -0.5597708310739475,
                -0.41175116146284263,
                -0.2518862256915055,
                -0.08477501304173529,
                0.08477501304173529,
                0.2518862256915055,
                0.41175116146284263,
                0.5597708310739475,
                0.6916870430603532,
                0.8037049589725231,
                0.8926024664975557,
                0.9558239495713978,
                0.9915651684209309,
            ],
            "weights": [
                0.02161601352648413,
                0.04971454889496922,
                0.07642573025488925,
                0.10094204410628699,
                0.12255520671147836,
                0.14064291467065063,
                0.15468467512626521,
                0.16427648374583273,
                0.16914238296314363,
                0.16914238296314363,
                0.16427648374583273,
                0.15468467512626521,
                0.14064291467065063,
                0.12255520671147836,
                0.10094204410628699,
                0.07642573025488925,
                0.04971454889496922,
                0.02161601352648413,
            ],
            "generator": "gauss_legendre",
        },
        19: {
            "degree": 37,
            "points": [
                -0.9924068438435844,
                -0.96020815213483,
                -0.9031559036148179,
                -0.8227146565371428,
                -0.7209661773352294,
                -0.600545304661681,
                -0.46457074137596094,
                -0.31656409996362983,
                -0.1603586456402254,
                0.0,
                0.1603586456402254,
                0.31656409996362983,
                0.46457074137596094,
                0.600545304661681,
                0.7209661773352294,
                0.8227146565371428,
                0.9031559036148179,
                0.96020815213483,
                0.9924068438435844,
            ],
            "weights": [
                0.01946178822972761,
                0.04481422676569981,
                0.06904454273764107,
                0.09149002162244985,
                0.11156664554733375,
                0.1287539625393362,
                0.14260670217360638,
                0.15276604206585945,
                0.15896884339395415,
                0.16105444984878345,
                0.15896884339395415,
                0.15276604206585945,
                0.14260670217360638,
                0.1287539625393362,
                0.11156664554733375,
                0.09149002162244985,
                0.06904454273764107,
                0.04481422676569981,
                0.01946178822972761,
            ],
            "generator": "gauss_legendre",
        },
        20: {
            "degree": 39,
            "points": [
                -0.9931285991850949,
                -0.9639719272779138,
                -0.9122344282513258,
                -0.8391169718222188,
                -0.7463319064601508,
                -0.636053680726515,
                -0.5108670019508271,
                -0.37370608871541955,
                -0.2277858511416451,
                -0.07652652113349734,
                0.07652652113349734,
                0.2277858511416451,
                0.37370608871541955,
                0.5108670019508271,
                0.636053680726515,
                0.7463319064601508,
                0.8391169718222188,
                0.9122344282513258,
                0.9639719272779138,
                0.9931285991850949,
            ],
            "weights": [
                0.017614007139153273,
                0.04060142980038622,
                0.06267204833410944,
                0.08327674157670467,
                0.10193011981724026,
                0.11819453196151825,
                0.13168863844917653,
                0.14209610931838187,
                0.14917298647260366,
                0.15275338713072578,
                0.15275338713072578,
                0.14917298647260366,
                0.14209610931838187,
                0.13168863844917653,
                0.11819453196151825,
                0.10193011981724026,
                0.08327674157670467,
                0.06267204833410944,
                0.04060142980038622,
                0.017614007139153273,
            ],
            "generator": "gauss_legendre",
        },
        21: {
            "degree": 41,
            "points": [
                -0.9937521706203895,
                -0.9672268385663063,
                -0.9200993341504008,
                -0.8533633645833173,
                -0.7684399634756779,
                -0.6671388041974123,
                -0.5516188358872198,
                -0.4243421202074388,
                -0.2880213168024011,
                -0.1455618541608951,
                0.0,
                0.1455618541608951,
                0.2880213168024011,
                0.4243421202074388,
                0.5516188358872198,
                0.6671388041974123,
                0.7684399634756779,
                0.8533633645833173,
                0.9200993341504008,
                0.9672268385663063,
                0.9937521706203895,
            ],
            "weights": [
                0.016017228257774137,
                0.03695378977085292,
                0.057134425426857156,
                0.07610011362837935,
                0.09344442345603382,
                0.10879729916714831,
                0.12183141605372842,
                0.13226893863333739,
                0.13988739479107312,
                0.14452440398997007,
                0.14608113364969047,
                0.14452440398997007,
                0.13988739479107312,
                0.13226893863333739,
                0.12183141605372842,
                0.10879729916714831,
                0.09344442345603382,
                0.07610011362837935,
                0.057134425426857156,
                0.03695378977085292,
                0.016017228257774137,
            ],
            "generator": "gauss_legendre",
        },
        22: {
            "degree": 43,
            "points": [
                -0.9942945854823992,
                -0.9700604978354287,
                -0.926956772187174,
                -0.8658125777203002,
                -0.7878168059792081,
                -0.6944872631866827,
                -0.5876404035069116,
                -0.46935583798675706,
                -0.34193582089208424,
                -0.2078604266882213,
                -0.06973927331972221,
                0.06973927331972221,
                0.2078604266882213,
                0.34193582089208424,
                0.46935583798675706,
                0.5876404035069116,
                0.6944872631866827,
                0.7878168059792081,
                0.8658125777203002,
                0.926956772187174,
                0.9700604978354287,
                0.9942945854823992,
            ],
            "weights": [
                0.014627995298274705,
                0.03377490158481518,
                0.05229333515268287,
                0.0697964684245202,
                0.0859416062170674,
                0.10041414444288072,
                0.11293229608053883,
                0.12325237681051199,
                0.13117350478706188,
                0.13654149834601478,
                0.13925187285563156,
                0.13925187285563156,
                0.13654149834601478,
                0.13117350478706188,
                0.12325237681051199,
                0.11293229608053883,
                0.10041414444288072,
                0.0859416062170674,
                0.0697964684245202,
                0.05229333515268287,
                0.03377490158481518,
                0.014627995298274705,
            ],
            "generator": "gauss_legendre",
        },
        23: {
            "degree": 45,
            "points": [
                -0.9947693349975522,
                -0.9725424712181152,
                -0.9329710868260161,
                -0.8767523582704416,
                -0.8048884016188399,
                -0.7186613631319502,
                -0.6196098757636461,
                -0.5095014778460075,
                -0.3903010380302908,
                -0.26413568097034495,
                -0.1332568242984661,
                0.0,
                0.1332568242984661,
                0.26413568097034495,
                0.3903010380302908,
                0.5095014778460075,
                0.6196098757636461,
                0.7186613631319502,
                0.8048884016188399,
                0.8767523582704416,
                0.9329710868260161,
                0.9725424712181152,
                0.9947693349975522,
            ],
            "weights": [
                0.013411859487141846,
                0.030988005856979497,
                0.04803767173108495,
                0.06423242140852606,
                0.07928141177671887,
                0.09291576606003524,
                0.10489209146454138,
                0.1149966402224113,
                0.12304908430672945,
                0.128905722188082,
                0.13246203940469642,
                0.13365457218610594,
                0.13246203940469642,
                0.128905722188082,
                0.12304908430672945,
                0.1149966402224113,
                0.10489209146454138,
                0.09291576606003524,
                0.07928141177671887,
                0.06423242140852606,
                0.04803767173108495,
                0.030988005856979497,
                0.013411859487141846,
            ],
            "generator": "gauss_legendre",
        },
        24: {
            "degree": 47,
            "points": [
                -0.9951872199970213,
                -0.9747285559713095,
                -0.9382745520027328,
                -0.886415527004401,
                -0.820001985973903,
                -0.7401241915785544,
                -0.6480936519369755,
                -0.5454214713888396,
                -0.4337935076260451,
                -0.3150426796961634,
                -0.1911188674736163,
                -0.06405689286260563,
                0.06405689286260563,
                0.1911188674736163,
                0.3150426796961634,
                0.4337935076260451,
                0.5454214713888396,
                0.6480936519369755,
                0.7401241915785544,
                0.820001985973903,
                0.886415527004401,
                0.9382745520027328,
                0.9747285559713095,
                0.9951872199970213,
            ],
            "weights": [
                0.012341229799987091,
                0.028531388628933743,
                0.04427743881741955,
                0.05929858491543674,
                0.07334648141108041,
                0.08619016153195329,
                0.09761865210411406,
                0.1074442701159656,
                0.11550566805372561,
                0.12167047292780342,
                0.1258374563468283,
                0.12793819534675221,
                0.12793819534675221,
                0.1258374563468283,
                0.12167047292780342,
                0.11550566805372561,
                0.1074442701159656,
                0.09761865210411406,
                0.08619016153195329,
                0.07334648141108041,
                0.05929858491543674,
                0.04427743881741955,
                0.028531388628933743,
                0.012341229799987091,
            ],
            "generator": "gauss_legendre",
        },
        25: {
            "degree": 49,
            "points": [
                -0.995556969790498,
                -0.9766639214595175,
                -0.9429745712289743,
                -0.8949919978782753,
                -0.833442628760834,
                -0.7592592630373576,
                -0.6735663684734684,
                -0.577662930241223,
                -0.473002731445715,
                -0.36117230580938786,
                -0.24386688372098841,
                -0.1228646926107104,
                0.0,
                0.1228646926107104,
                0.24386688372098841,
                0.36117230580938786,
                0.473002731445715,
                0.577662930241223,
                0.6735663684734684,
                0.7592592630373576,
                0.833442628760834,
                0.8949919978782753,
                0.9429745712289743,
                0.9766639214595175,
                0.995556969790498,
            ],
            "weights": [
                0.011393798501027593,
                0.026354986615031908,
                0.0409391567013065,
                0.05490469597583544,
                0.06803833381235701,
                0.08014070033500098,
                0.09102826198296338,
                0.10053594906705049,
                0.10851962447426344,
                0.11485825914571146,
                0.1194557635357845,
                0.12224244299030987,
                0.12317605372671524,
                0.12224244299030987,
                0.1194557635357845,
                0.11485825914571146,
                0.10851962447426344,
                0.10053594906705049,
                0.09102826198296338,
                0.08014070033500098,
                0.06803833381235701,
                0.05490469597583544,
                0.0409391567013065,
                0.026354986615031908,
                0.011393798501027593,
            ],
            "generator": "gauss_legendre",
        },
        26: {
            "degree": 51,
            "points": [
                -0.9958857011456169,
                -0.9783854459564709,
                -0.9471590666617142,
                -0.9026378619843071,
                -0.845445942788498,
                -0.7763859488206788,
                -0.6964272604199573,
                -0.6066922930176181,
                -0.5084407148245057,
                -0.4030517551234863,
                -0.2920048394859569,
                -0.17685882035689018,
                -0.05923009342931321,
                0.05923009342931321,
                0.17685882035689018,
                0.2920048394859569,
                0.4030517551234863,
                0.5084407148245057,
                0.6066922930176181,
                0.6964272604199573,
                0.7763859488206788,
                0.845445942788498,
                0.9026378619843071,
                0.9471590666617142,
                0.9783854459564709,
                0.9958857011456169,
            ],
            "weights": [
                0.010551372617343395,
                0.024417851092631938,
                0.03796238329436312,
                0.05097582529714808,
                0.06327404632957467,
                0.07468414976565976,
                0.08504589431348507,
                0.09421380035591416,
                0.10205916109442532,
                0.10847184052857647,
                0.11336181654631956,
                0.11666044348529646,
                0.11832141527926213,
                0.11832141527926213,
                0.11666044348529646,
                0.11336181654631956,
                0.10847184052857647,
                0.10205916109442532,
                0.09421380035591416,
                0.08504589431348507,
                0.07468414976565976,
                0.06327404632957467,
                0.05097582529714808,
                0.03796238329436312,
                0.024417851092631938,
                0.010551372617343395,
            ],
            "generator": "gauss_legendre",
        },
        27: {
            "degree": 53,
            "points": [
                -0.9961792628889885,
                -0.9799234759615012,
                -0.9509005578147051,
                -0.9094823206774911,
                -0.8562079080182945,
                -0.7917716390705083,
                -0.7170134737394237,
                -0.6329079719464952,
                -0.540551564579457,
                -0.44114825175002687,
                -0.3359939036385089,
                -0.22645936543953685,
                -0.11397258560952997,
                0.0,
                0.11397258560952997,
                0.22645936543953685,
                0.3359939036385089,
                0.44114825175002687,
                0.540551564579457,
                0.6329079719464952,
                0.7170134737394237,
                0.7917716390705083,
                0.8562079080182945,
                0.9094823206774911,
                0.9509005578147051,
                0.9799234759615012,
                0.9961792628889885,
            ],
            "weights": [
                0.009798996051294204,
                0.022686231596180995,
                0.03529705375741918,
                0.047449412520615374,
                0.05898353685983364,
                0.06974882376624564,
                0.07960486777305782,
                0.08842315854375683,
                0.0960887273700285,
                0.10250163781774586,
                0.10757828578853317,
                0.11125248835684516,
                0.1134763461089652,
                0.11422086737895706,
                0.1134763461089652,
                0.11125248835684516,
                0.10757828578853317,
                0.10250163781774586,
                0.0960887273700285,
                0.08842315854375683,
                0.07960486777305782,
                0.06974882376624564,
                0.05898353685983364,
                0.047449412520615374,
                0.03529705375741918,
                0.022686231596180995,
                0.009798996051294204,
            ],
            "generator": "gauss_legendre",
        },
        28: {
            "degree": 55,
            "points": [
                -0.9964424975739544,
                -0.9813031653708728,
                -0.9542592806289382,
                -0.9156330263921321,
                -0.865892522574395,
                -0.8056413709171791,
                -0.7356108780136318,
                -0.656651094038865,
                -0.5697204718114017,
                -0.4758742249551183,
                -0.3762515160890787,
                -0.2720616276351781,
                -0.1645692821333808,
                -0.055079289884034266,
                0.055079289884034266,
                0.1645692821333808,
                0.2720616276351781,
                0.3762515160890787,
                0.4758742249551183,
                0.5697204718114017,
                0.656651094038865,
                0.7356108780136318,
                0.8056413709171791,
                0.865892522574395,
                0.9156330263921321,
                0.9542592806289382,
                0.9813031653708728,
                0.9964424975739544,
            ],
            "weights": [
                0.009124282593094397,
                0.02113211259277127,
                0.03290142778230452,
                0.044272934759003985,
                0.055107345675716936,
                0.06527292396699975,
                0.07464621423456881,
                0.08311341722890093,
                0.09057174439303285,
                0.09693065799792992,
                0.10211296757806078,
                0.10605576592284637,
                0.10871119225829413,
                0.11004701301647524,
                0.11004701301647524,
                0.10871119225829413,
                0.10605576592284637,
                0.10211296757806078,
                0.09693065799792992,
                0.09057174439303285,
                0.08311341722890093,
                0.07464621423456881,
                0.06527292396699975,
                0.055107345675716936,
                0.044272934759003985,
                0.03290142778230452,
                0.02113211259277127,
                0.009124282593094397,
            ],
            "generator": "gauss_legendre",
        },
        29: {
            "degree": 57,
            "points": [
                -0.9966794422605966,
                -0.9825455052614132,
                -0.9572855957780877,
                -0.9211802329530587,
                -0.8746378049201028,
                -0.8181854876152524,
                -0.7524628517344771,
                -0.6782145376026865,
                -0.5962817971382278,
                -0.5075929551242276,
                -0.41315288817400864,
                -0.31403163786763993,
                -0.21135228616600107,
                -0.10627823013267923,
                0.0,
                0.10627823013267923,
                0.21135228616600107,
                0.31403163786763993,
                0.41315288817400864,
                0.5075929551242276,
                0.5962817971382278,
                0.6782145376026865,
                0.7524628517344771,
                0.8181854876152524,
                0.8746378049201028,
                0.9211802329530587,
                0.9572855957780877,
                0.9825455052614132,
                0.9966794422605966,
            ],
            "weights": [
                0.008516903878747237,
                0.019732085056123293,
                0.03074049220209336,
                0.04140206251868274,
                0.051594826902497753,
                0.06120309065707902,
                0.07011793325505114,
                0.07823832713576369,
                0.0854722573661724,
                0.0917377571392587,
                0.09696383409440848,
                0.10109127375991488,
                0.10407331007772933,
                0.10587615509732079,
                0.10647938171831416,
                0.10587615509732079,
                0.10407331007772933,
                0.10109127375991488,
                0.09696383409440848,
                0.0917377571392587,
                0.0854722573661724,
                0.07823832713576369,
                0.07011793325505114,
                0.06120309065707902,
                0.051594826902497753,
                0.04140206251868274,
                0.03074049220209336,
                0.019732085056123293,
                0.008516903878747237,
            ],
            "generator": "gauss_legendre",
        },
        30: {
            "degree": 59,
            "points": [
                -0.9968934840746495,
                -0.9836681232797473,
                -0.9600218649683075,
                -0.9262000474292743,
                -0.8825605357920526,
                -0.8295657623827684,
                -0.7677774321048262,
                -0.6978504947933158,
                -0.6205261829892429,
                -0.5366241481420199,
                -0.44703376953808915,
                -0.3527047255308781,
                -0.25463692616788985,
                -0.15386991360858354,
                -0.0514718425553177,
                0.0514718425553177,
                0.15386991360858354,
                0.25463692616788985,
                0.3527047255308781,
                0.44703376953808915,
                0.5366241481420199,
                0.6205261829892429,
                0.6978504947933158,
                0.7677774321048262,
                0.8295657623827684,
                0.8825605357920526,
                0.9262000474292743,
                0.9600218649683075,
                0.9836681232797473,
                0.9968934840746495,
            ],
            "weights": [
                0.007968192496169523,
                0.018466468311091087,
                0.028784707883322873,
                0.03879919256962679,
                0.048402672830594434,
                0.05749315621761909,
                0.06597422988218032,
                0.0737559747377048,
                0.08075589522941981,
                0.0868997872010827,
                0.09212252223778579,
                0.09636873717464399,
                0.09959342058679493,
                0.10176238974840521,
                0.10285265289355848,
                0.10285265289355848,
                0.10176238974840521,
                0.09959342058679493,
                0.09636873717464399,
                0.09212252223778579,
                0.0868997872010827,
                0.08075589522941981,
                0.0737559747377048,
                0.06597422988218032,
                0.05749315621761909,
                0.048402672830594434,
                0.03879919256962679,
                0.028784707883322873,
                0.018466468311091087,
                0.007968192496169523,
            ],
            "generator": "gauss_legendre",
        },
        31: {
            "degree": 61,
            "points": [
                -0.997087481819477,
                -0.9846859096651525,
                -0.9625039250929497,
                -0.9307569978966481,
                -0.8897600299482711,
                -0.8399203201462674,
                -0.7817331484166249,
                -0.7157767845868533,
                -0.6427067229242603,
                -0.5632491614071493,
                -0.4781937820449025,
                -0.38838590160823294,
                -0.29471806998170164,
                -0.19812119933557062,
                -0.09955531215234152,
                0.0,
                0.09955531215234152,
                0.19812119933557062,
                0.29471806998170164,
                0.38838590160823294,
                0.4781937820449025,
                0.5632491614071493,
                0.6427067229242603,
                0.7157767845868533,
                0.7817331484166249,
                0.8399203201462674,
                0.8897600299482711,
                0.9307569978966481,
                0.9625039250929497,
                0.9846859096651525,
                0.997087481819477,
            ],
            "weights": [
                0.007470831579250505,
                0.017318620790311306,
                0.027009019184978618,
                0.036432273912385876,
                0.045493707527200826,
                0.05410308242491656,
                0.06217478656102859,
                0.06962858323541009,
                0.07639038659877649,
                0.08239299176158905,
                0.08757674060847766,
                0.09189011389364135,
                0.09529024291231938,
                0.09774333538632848,
                0.09922501122667204,
                0.0997205447934263,
                0.09922501122667204,
                0.09774333538632848,
                0.09529024291231938,
                0.09189011389364135,
                0.08757674060847766,
                0.08239299176158905,
                0.07639038659877649,
                0.06962858323541009,
                0.06217478656102859,
                0.05410308242491656,
                0.045493707527200826,
                0.036432273912385876,
                0.027009019184978618,
                0.017318620790311306,
                0.007470831579250505,
            ],
            "generator": "gauss_legendre",
        },
        32: {
            "degree": 63,
            "points": [
                -0.9972638618494816,
                -0.9856115115452684,
                -0.9647622555875064,
                -0.9349060759377397,
                -0.8963211557660522,
                -0.84936761373257,
                -0.7944837959679424,
                -0.7321821187402897,
                -0.6630442669302152,
                -0.5877157572407623,
                -0.5068999089322294,
                -0.42135127613063533,
                -0.33186860228212767,
                -0.23928736225213706,
                -0.1444719615827965,
                -0.04830766568773831,
                0.04830766568773831,
                0.1444719615827965,
                0.23928736225213706,
                0.33186860228212767,
                0.42135127613063533,
                0.5068999089322294,
                0.5877157572407623,
                0.6630442669302152,
                0.7321821187402897,
                0.7944837959679424,
                0.84936761373257,
                0.8963211557660522,
                0.9349060759377397,
                0.9647622555875064,
                0.9856115115452684,
                0.9972638618494816,
            ],
            "weights": [
                0.007018610009469298,
                0.016274394730905965,
                0.025392065309262427,
                0.034273862913021626,
                0.042835898022226426,
                0.050998059262376244,
                0.058684093478535704,
                0.06582222277636175,
                0.07234579410884845,
                0.07819389578707031,
                0.08331192422694685,
                0.08765209300440391,
                0.09117387869576386,
                0.09384439908080457,
                0.09563872007927483,
                0.09654008851472781,
                0.09654008851472781,
                0.09563872007927483,
                0.09384439908080457,
                0.09117387869576386,
                0.08765209300440391,
                0.08331192422694685,
                0.07819389578707031,
                0.07234579410884845,
                0.06582222277636175,
                0.058684093478535704,
                0.050998059262376244,
                0.042835898022226426,
                0.034273862913021626,
                0.025392065309262427,
                0.016274394730905965,
                0.007018610009469298,
            ],
            "generator": "gauss_legendre",
        },
        33: {
            "degree": 65,
            "points": [
                -0.9974246942464552,
                -0.9864557262306425,
                -0.9668229096899927,
                -0.9386943726111683,
                -0.9023167677434336,
                -0.8580096526765041,
                -0.8061623562741667,
                -0.7472304964495622,
                -0.6817319599697428,
                -0.610242345836379,
                -0.5333899047863476,
                -0.45185001727245067,
                -0.36633925774807335,
                -0.27760909715249704,
                -0.18643929882799157,
                -0.0936310658547334,
                0.0,
                0.0936310658547334,
                0.18643929882799157,
                0.27760909715249704,
                0.36633925774807335,
                0.45185001727245067,
                0.5333899047863476,
                0.610242345836379,
                0.6817319599697428,
                0.7472304964495622,
                0.8061623562741667,
                0.8580096526765041,
                0.9023167677434336,
                0.9386943726111683,
                0.9668229096899927,
                0.9864557262306425,
                0.9974246942464552,
            ],
            "weights": [
                0.006606227847588961,
                0.015321701512935035,
                0.023915548101749375,
                0.032300358632329156,
                0.040401541331669406,
                0.048147742818711606,
                0.05547084663166331,
                0.06230648253031735,
                0.06859457281865657,
                0.07427985484395408,
                0.0793123647948866,
                0.08364787606703859,
                0.08724828761884415,
                0.09008195866063844,
                0.09212398664331668,
                0.09335642606559598,
                0.09376844616020981,
                0.09335642606559598,
                0.09212398664331668,
                0.09008195866063844,
                0.08724828761884415,
                0.08364787606703859,
                0.0793123647948866,
                0.07427985484395408,
                0.06859457281865657,
                0.06230648253031735,
                0.05547084663166331,
                0.048147742818711606,
                0.040401541331669406,
                0.032300358632329156,
                0.023915548101749375,
                0.015321701512935035,
                0.006606227847588961,
            ],
            "generator": "gauss_legendre",
        },
        34: {
            "degree": 67,
            "points": [
                -0.997571753790842,
                -0.9872278164063095,
                -0.9687082625333443,
                -0.9421623974051071,
                -0.9078096777183245,
                -0.8659346383345644,
                -0.8168842279009336,
                -0.761064876629873,
                -0.6989391132162629,
                -0.6310217270805285,
                -0.5578755006697467,
                -0.480106545190327,
                -0.39835927775864594,
                -0.3133110813394632,
                -0.22566669161644948,
                -0.13615235725918298,
                -0.04550982195310253,
                0.04550982195310253,
                0.13615235725918298,
                0.22566669161644948,
                0.3133110813394632,
                0.39835927775864594,
                0.480106545190327,
                0.5578755006697467,
                0.6310217270805285,
                0.6989391132162629,
                0.761064876629873,
                0.8168842279009336,
                0.8659346383345644,
                0.9078096777183245,
                0.9421623974051071,
                0.9687082625333443,
                0.9872278164063095,
                0.997571753790842,
            ],
            "weights": [
                0.006229140555910033,
                0.014450162748594548,
                0.022563721985495038,
                0.030491380638445777,
                0.038166593796386906,
                0.04552561152335378,
                0.05250741457267806,
                0.059054135827524654,
                0.06511152155407646,
                0.07062937581425573,
                0.0755619746600318,
                0.07986844433977182,
                0.08351309969984552,
                0.08646573974703567,
                0.08870189783569374,
                0.09020304437064061,
                0.09095674033025979,
                0.09095674033025979,
                0.09020304437064061,
                0.08870189783569374,
                0.08646573974703567,
                0.08351309969984552,
                0.07986844433977182,
                0.0755619746600318,
                0.07062937581425573,
                0.06511152155407646,
                0.059054135827524654,
                0.05250741457267806,
                0.04552561152335378,
                0.038166593796386906,
                0.030491380638445777,
                0.022563721985495038,
                0.014450162748594548,
                0.006229140555910033,
            ],
            "generator": "gauss_legendre",
        },
        35: {
            "degree": 69,
            "points": [
                -0.9977065690996003,
                -0.9879357644438516,
                -0.9704376160392298,
                -0.9453451482078273,
                -0.9128542613593176,
                -0.8732191250252224,
                -0.8267498990922254,
                -0.7738102522869126,
                -0.7148145015566287,
                -0.6502243646658904,
                -0.5805453447497645,
                -0.5063227732414886,
                -0.42813754151781425,
                -0.346601554430814,
                -0.2623529412092961,
                -0.17605106116598956,
                -0.08837134327565926,
                0.0,
                0.08837134327565926,
                0.17605106116598956,
                0.2623529412092961,
                0.346601554430814,
                0.42813754151781425,
                0.5063227732414886,
                0.5805453447497645,
                0.6502243646658904,
                0.7148145015566287,
                0.7738102522869126,
                0.8267498990922254,
                0.8732191250252224,
                0.9128542613593176,
                0.9453451482078273,
                0.9704376160392298,
                0.9879357644438516,
                0.9977065690996003,
            ],
            "weights": [
                0.00588343342044155,
                0.013650828348361326,
                0.021322979911483672,
                0.028829260108894132,
                0.03611011586346367,
                0.04310842232617002,
                0.04976937040135368,
                0.056040816212370004,
                0.06187367196608038,
                0.06722228526908706,
                0.07204479477256023,
                0.07630345715544233,
                0.07996494224232442,
                0.08300059372885674,
                0.08538665339209921,
                0.08710444699718374,
                0.08814053043027563,
                0.08848679490710447,
                0.08814053043027563,
                0.08710444699718374,
                0.08538665339209921,
                0.08300059372885674,
                0.07996494224232442,
                0.07630345715544233,
                0.07204479477256023,
                0.06722228526908706,
                0.06187367196608038,
                0.056040816212370004,
                0.04976937040135368,
                0.04310842232617002,
                0.03611011586346367,
                0.028829260108894132,
                0.021322979911483672,
                0.013650828348361326,
                0.00588343342044155,
            ],
            "generator": "gauss_legendre",
        },
        36: {
            "degree": 71,
            "points": [
                -0.9978304624840858,
                -0.9885864789022123,
                -0.972027691049698,
                -0.9482729843995076,
                -0.9174977745156591,
                -0.8799298008903971,
                -0.8358471669924753,
                -0.7855762301322066,
                -0.7294891715935566,
                -0.668001236585521,
                -0.6015676581359806,
                -0.5306802859262452,
                -0.45586394443342027,
                -0.37767254711968923,
                -0.29668499534402826,
                -0.2135008923168656,
                -0.1287361038093848,
                -0.04301819847370861,
                0.04301819847370861,
                0.1287361038093848,
                0.2135008923168656,
                0.29668499534402826,
                0.37767254711968923,
                0.45586394443342027,
                0.5306802859262452,
                0.6015676581359806,
                0.668001236585521,
                0.7294891715935566,
                0.7855762301322066,
                0.8358471669924753,
                0.8799298008903971,
                0.9174977745156591,
                0.9482729843995076,
                0.972027691049698,
                0.9885864789022123,
                0.9978304624840858,
            ],
            "weights": [
                0.005565719664247784,
                0.012915947284064104,
                0.020181515297735174,
                0.027298621498568355,
                0.03421381077030748,
                0.04087575092364523,
                0.04723508349026605,
                0.05324471397775968,
                0.05886014424532455,
                0.06403979735501543,
                0.0687453238357363,
                0.072941885005653,
                0.07659841064587063,
                0.07968782891207156,
                0.08218726670433965,
                0.08407821897966179,
                0.0853466857393385,
                0.08598327567039463,
                0.08598327567039463,
                0.0853466857393385,
                0.08407821897966179,
                0.08218726670433965,
                0.07968782891207156,
                0.07659841064587063,
                0.072941885005653,
                0.0687453238357363,
                0.06403979735501543,
                0.05886014424532455,
                0.05324471397775968,
                0.04723508349026605,
                0.04087575092364523,
                0.03421381077030748,
                0.027298621498568355,
                0.020181515297735174,
                0.012915947284064104,
                0.005565719664247784,
            ],
            "generator": "gauss_legendre",
        },
        37: {
            "degree": 73,
            "points": [
                -0.9979445824779136,
                -0.9891859632143192,
                -0.9734930300564858,
                -0.9509723432620948,
                -0.9217814374124638,
                -0.8861249621554861,
                -0.844252987340556,
                -0.7964592005099023,
                -0.7430788339819653,
                -0.6844863091309593,
                -0.6210926084089244,
                -0.5533423918615817,
                -0.48171087780320554,
                -0.40670050931832613,
                -0.328837429883707,
                -0.24866779279136575,
                -0.16675393023985197,
                -0.0836704089547699,
                0.0,
                0.0836704089547699,
                0.16675393023985197,
                0.24866779279136575,
                0.328837429883707,
                0.40670050931832613,
                0.48171087780320554,
                0.5533423918615817,
                0.6210926084089244,
                0.6844863091309593,
                0.7430788339819653,
                0.7964592005099023,
                0.844252987340556,
                0.8861249621554861,
                0.9217814374124638,
                0.9509723432620948,
                0.9734930300564858,
                0.9891859632143192,
                0.9979445824779136,
            ],
            "weights": [
                0.005273057279501005,
                0.012238780100306875,
                0.01912904448908302,
                0.025886036990559313,
                0.0324616398475212,
                0.03880960250193438,
                0.04488536466243705,
                0.05064629765482456,
                0.05605198799827474,
                0.06106451652322591,
                0.06564872287275128,
                0.06977245155570029,
                0.07340677724848815,
                0.07652620757052905,
                0.07910886183752924,
                0.08113662450846486,
                0.0825952722364371,
                0.0834745736258626,
                0.08376836099313872,
                0.0834745736258626,
                0.0825952722364371,
                0.08113662450846486,
                0.07910886183752924,
                0.07652620757052905,
                0.07340677724848815,
                0.06977245155570029,
                0.06564872287275128,
                0.06106451652322591,
                0.05605198799827474,
                0.05064629765482456,
                0.04488536466243705,
                0.03880960250193438,
                0.0324616398475212,
                0.025886036990559313,
                0.01912904448908302,
                0.012238780100306875,
                0.005273057279501005,
            ],
            "generator": "gauss_legendre",
        },
        38: {
            "degree": 75,
            "points": [
                -0.9980499305356876,
                -0.9897394542663855,
                -0.9748463285901535,
                -0.9534663309335296,
                -0.9257413320485843,
                -0.8918557390046322,
                -0.8520350219323621,
                -0.8065441676053169,
                -0.7556859037539707,
                -0.6997986803791844,
                -0.6392544158296817,
                -0.5744560210478071,
                -0.5058347179279311,
                -0.4338471694323765,
                -0.358972440479435,
                -0.28170880979016527,
                -0.2025704538921167,
                -0.12208402533786741,
                -0.04078514790457824,
                0.04078514790457824,
                0.12208402533786741,
                0.2025704538921167,
                0.28170880979016527,
                0.358972440479435,
                0.4338471694323765,
                0.5058347179279311,
                0.5744560210478071,
                0.6392544158296817,
                0.6997986803791844,
                0.7556859037539707,
                0.8065441676053169,
                0.8520350219323621,
                0.8918557390046322,
                0.9257413320485843,
                0.9534663309335296,
                0.9748463285901535,
                0.9897394542663855,
                0.9980499305356876,
            ],
            "weights": [
                0.005002880749638933,
                0.011613444716468455,
                0.01815657770961341,
                0.024579739738232007,
                0.03083950054517572,
                0.03689408159402486,
                0.0427031585046747,
                0.04822806186075853,
                0.053432019910332196,
                0.058280399146997154,
                0.06274093339213317,
                0.06678393797914038,
                0.07038250706689894,
                0.07351269258474341,
                0.07615366354844648,
                0.07828784465821098,
                0.07990103324352782,
                0.08098249377059706,
                0.0815250292803858,
                0.0815250292803858,
                0.08098249377059706,
                0.07990103324352782,
                0.07828784465821098,
                0.07615366354844648,
                0.07351269258474341,
                0.07038250706689894,
                0.06678393797914038,
                0.06274093339213317,
                0.058280399146997154,
                0.053432019910332196,
                0.04822806186075853,
                0.0427031585046747,
                0.03689408159402486,
                0.03083950054517572,
                0.024579739738232007,
                0.01815657770961341,
                0.011613444716468455,
                0.005002880749638933,
            ],
            "generator": "gauss_legendre",
        },
        39: {
            "degree": 77,
            "points": [
                -0.9981473830664329,
                -0.990251536854686,
                -0.9760987093334711,
                -0.9557752123246522,
                -0.9294091484867382,
                -0.8971671192929929,
                -0.8592529379999062,
                -0.8159062974301431,
                -0.7674012429310635,
                -0.7140444358945347,
                -0.656173213432011,
                -0.594153454957278,
                -0.5283772686604374,
                -0.45926051230913606,
                -0.38724016397156147,
                -0.3127715592481859,
                -0.23632551246183575,
                -0.1583853399978378,
                -0.07944380460875547,
                0.0,
                0.07944380460875547,
                0.1583853399978378,
                0.23632551246183575,
                0.3127715592481859,
                0.38724016397156147,
                0.45926051230913606,
                0.5283772686604374,
                0.594153454957278,
                0.656173213432011,
                0.7140444358945347,
                0.7674012429310635,
                0.8159062974301431,
                0.8592529379999062,
                0.8971671192929929,
                0.9294091484867382,
                0.9557752123246522,
                0.9760987093334711,
                0.990251536854686,
                0.9981473830664329,
            ],
            "weights": [
                0.004752944691632988,
                0.011034788939163166,
                0.017256229093724738,
                0.023369384832178573,
                0.029334955983903753,
                0.035115111498131645,
                0.04067327684793373,
                0.045974301108916926,
                0.05098466529212963,
                0.05567269034091639,
                0.06000873608859619,
                0.06396538813868251,
                0.06751763096623158,
                0.07064300597060895,
                0.07332175341426887,
                0.07553693732283634,
                0.07727455254468223,
                0.07852361328737141,
                0.07927622256836872,
                0.0795276221394431,
                0.07927622256836872,
                0.07852361328737141,
                0.07727455254468223,
                0.07553693732283634,
                0.07332175341426887,
                0.07064300597060895,
                0.06751763096623158,
                0.06396538813868251,
                0.06000873608859619,
                0.05567269034091639,
                0.05098466529212963,
                0.045974301108916926,
                0.04067327684793373,
                0.035115111498131645,
                0.029334955983903753,
                0.023369384832178573,
                0.017256229093724738,
                0.011034788939163166,
                0.004752944691632988,
            ],
            "generator": "gauss_legendre",
        },
        40: {
            "degree": 79,
            "points": [
                -0.9982377097105593,
                -0.9907262386994571,
                -0.9772599499837743,
                -0.9579168192137917,
                -0.9328128082786765,
                -0.9020988069688743,
                -0.8659595032122596,
                -0.8246122308333117,
                -0.7783056514265194,
                -0.7273182551899271,
                -0.6719566846141796,
                -0.6125538896679803,
                -0.5494671250951282,
                -0.4830758016861787,
                -0.413779204371605,
                -0.3419940908257585,
                -0.2681521850072537,
                -0.1926975807013711,
                -0.11608407067525521,
                -0.038772417506050816,
                0.038772417506050816,
                0.11608407067525521,
                0.1926975807013711,
                0.2681521850072537,
                0.3419940908257585,
                0.413779204371605,
                0.4830758016861787,
                0.5494671250951282,
                0.6125538896679803,
                0.6719566846141796,
                0.7273182551899271,
                0.7783056514265194,
                0.8246122308333117,
                0.8659595032122596,
                0.9020988069688743,
                0.9328128082786765,
                0.9579168192137917,
                0.9772599499837743,
                0.9907262386994571,
                0.9982377097105593,
            ],
            "weights": [
                0.004521277098530018,
                0.010498284531151609,
                0.016421058381907345,
                0.022245849194166653,
                0.027937006980023528,
                0.03346019528254768,
                0.03878216797447238,
                0.043870908185673324,
                0.048695807635072405,
                0.053227846983937115,
                0.05743976909939189,
                0.06130624249292932,
                0.06480401345660149,
                0.0679120458152344,
                0.07061164739128717,
                0.07288658239580448,
                0.07472316905796868,
                0.07611036190062674,
                0.07703981816424839,
                0.07750594797842533,
                0.07750594797842533,
                0.07703981816424839,
                0.07611036190062674,
                0.07472316905796868,
                0.07288658239580448,
                0.07061164739128717,
                0.0679120458152344,
                0.06480401345660149,
                0.06130624249292932,
                0.05743976909939189,
                0.053227846983937115,
                0.048695807635072405,
                0.043870908185673324,
                0.03878216797447238,
                0.03346019528254768,
                0.027937006980023528,
                0.022245849194166653,
                0.016421058381907345,
                0.010498284531151609,
                0.004521277098530018,
            ],
            "generator": "gauss_legendre",
        },
        41: {
            "degree": 81,
            "points": [
                -0.9983215885747715,
                -0.9911671096990163,
                -0.9783386735610834,
                -0.9599068917303463,
                -0.9359769874978539,
                -0.9066859447581012,
                -0.8722015116924414,
                -0.8327212004013613,
                -0.7884711450474093,
                -0.7397048030699263,
                -0.6867015020349513,
                -0.6297648390721963,
                -0.5692209416102159,
                -0.5054165991994061,
                -0.43871727705140706,
                -0.36950502264048146,
                -0.2981762773418249,
                -0.22513960563342278,
                -0.15081335486399217,
                -0.075623258989163,
                0.0,
                0.075623258989163,
                0.15081335486399217,
                0.22513960563342278,
                0.2981762773418249,
                0.36950502264048146,
                0.43871727705140706,
                0.5054165991994061,
                0.5692209416102159,
                0.6297648390721963,
                0.6867015020349513,
                0.7397048030699263,
                0.7884711450474093,
                0.8327212004013613,
                0.8722015116924414,
                0.9066859447581012,
                0.9359769874978539,
                0.9599068917303463,
                0.9783386735610834,
                0.9911671096990163,
                0.9983215885747715,
            ],
            "weights": [
                0.004306140358161792,
                0.009999938773905072,
                0.015644938407818807,
                0.021201063368779208,
                0.026635899207110153,
                0.03191821173169939,
                0.03701771670350802,
                0.04190519519590998,
                0.0465526483690147,
                0.05093345429461772,
                0.055022519242578914,
                0.05879642094987231,
                0.06223354258096662,
                0.06531419645352765,
                0.06802073676087711,
                0.07033766062081781,
                0.07225169686102335,
                0.07375188202722383,
                0.0748296231762219,
                0.0754787470927162,
                0.07569553564729874,
                0.0754787470927162,
                0.0748296231762219,
                0.07375188202722383,
                0.07225169686102335,
                0.07033766062081781,
                0.06802073676087711,
                0.06531419645352765,
                0.06223354258096662,
                0.05879642094987231,
                0.055022519242578914,
                0.05093345429461772,
                0.0465526483690147,
                0.04190519519590998,
                0.03701771670350802,
                0.03191821173169939,
                0.026635899207110153,
                0.021201063368779208,
                0.015644938407818807,
                0.009999938773905072,
                0.004306140358161792,
            ],
            "generator": "gauss_legendre",
        },
        42: {
            "degree": 83,
            "points": [
                -0.9983996189900625,
                -0.9915772883408609,
                -0.9793425080637482,
                -0.9617593653382045,
                -0.9389235573549881,
                -0.9109597249041275,
                -0.8780205698121728,
                -0.8402859832618169,
                -0.7979620532554874,
                -0.7512799356894805,
                -0.7004945905561712,
                -0.6458833888692479,
                -0.5877445974851093,
                -0.5263957499311923,
                -0.46217191207042196,
                -0.39542385204297503,
                -0.3265161244654115,
                -0.25582507934287907,
                -0.18373680656485455,
                -0.11064502720851986,
                -0.03694894316535177,
                0.03694894316535177,
                0.11064502720851986,
                0.18373680656485455,
                0.25582507934287907,
                0.3265161244654115,
                0.39542385204297503,
                0.46217191207042196,
                0.5263957499311923,
                0.5877445974851093,
                0.6458833888692479,
                0.7004945905561712,
                0.7512799356894805,
                0.7979620532554874,
                0.8402859832618169,
                0.8780205698121728,
                0.9109597249041275,
                0.9389235573549881,
                0.9617593653382045,
                0.9793425080637482,
                0.9915772883408609,
                0.9983996189900625,
            ],
            "weights": [
                0.004105998604646913,
                0.009536220301748407,
                0.014922443697357294,
                0.020227869569052214,
                0.025422959526113627,
                0.030479240699603335,
                0.035369071097592,
                0.040065735180692286,
                0.04454357777196598,
                0.04877814079280347,
                0.05274629569917415,
                0.05642636935801852,
                0.05979826222758681,
                0.06284355804500275,
                0.06554562436490913,
                0.06788970337652217,
                0.06986299249259438,
                0.0714547142651712,
                0.07265617524380438,
                0.07346081345346782,
                0.07386423423217317,
                0.07386423423217317,
                0.07346081345346782,
                0.07265617524380438,
                0.0714547142651712,
                0.06986299249259438,
                0.06788970337652217,
                0.06554562436490913,
                0.06284355804500275,
                0.05979826222758681,
                0.05642636935801852,
                0.05274629569917415,
                0.04877814079280347,
                0.04454357777196598,
                0.040065735180692286,
                0.035369071097592,
                0.030479240699603335,
                0.025422959526113627,
                0.020227869569052214,
                0.014922443697357294,
                0.009536220301748407,
                0.004105998604646913,
            ],
            "generator": "gauss_legendre",
        },
        43: {
            "degree": 85,
            "points": [
                -0.9984723322425076,
                -0.9919595575932442,
                -0.9802782209802554,
                -0.96348661301408,
                -0.9416719568476378,
                -0.9149479072061387,
                -0.8834537652186168,
                -0.8473537162093151,
                -0.8068359641369386,
                -0.7621117471949551,
                -0.7134142352689571,
                -0.6609973137514982,
                -0.605134259639601,
                -0.5461163166600848,
                -0.4842511767857347,
                -0.41986137602926926,
                -0.3532826128643038,
                -0.2848619980329136,
                -0.2149562448605182,
                -0.1439298095107133,
                -0.07215299087458624,
                0.0,
                0.07215299087458624,
                0.1439298095107133,
                0.2149562448605182,
                0.2848619980329136,
                0.3532826128643038,
                0.41986137602926926,
                0.4842511767857347,
                0.5461163166600848,
                0.605134259639601,
                0.6609973137514982,
                0.7134142352689571,
                0.7621117471949551,
                0.8068359641369386,
                0.8473537162093151,
                0.8834537652186168,
                0.9149479072061387,
                0.9416719568476378,
                0.96348661301408,
                0.9802782209802554,
                0.9919595575932442,
                0.9984723322425076,
            ],
            "weights": [
                0.0039194902538480176,
                0.009103996637401121,
                0.01424875643157602,
                0.01931990142368387,
                0.024290456613839044,
                0.029134413261498505,
                0.03382649208686005,
                0.03834222219413227,
                0.04265805719798207,
                0.04675149475434644,
                0.05060119278438981,
                0.05418708031888151,
                0.05749046195691038,
                0.06049411524999097,
                0.06318238044939598,
                0.0655412421263225,
                0.06755840222936497,
                0.06922334419365646,
                0.07052738776508476,
                0.07146373425251396,
                0.07202750197142171,
                0.07221575169379876,
                0.07202750197142171,
                0.07146373425251396,
                0.07052738776508476,
                0.06922334419365646,
                0.06755840222936497,
                0.0655412421263225,
                0.06318238044939598,
                0.06049411524999097,
                0.05749046195691038,
                0.05418708031888151,
                0.05060119278438981,
                0.04675149475434644,
                0.04265805719798207,
                0.03834222219413227,
                0.03382649208686005,
                0.029134413261498505,
                0.024290456613839044,
                0.01931990142368387,
                0.01424875643157602,
                0.009103996637401121,
                0.0039194902538480176,
            ],
            "generator": "gauss_legendre",
        },
        44: {
            "degree": 87,
            "points": [
                -0.9985402006367742,
                -0.9923163921385159,
                -0.981151833077914,
                -0.9650996504224931,
                -0.9442395091181941,
                -0.9186752599841758,
                -0.8885342382860432,
                -0.8539665950047104,
                -0.815144539645135,
                -0.7722614792487559,
                -0.725531053660717,
                -0.6751860706661224,
                -0.6214773459035758,
                -0.5646724531854708,
                -0.5050543913882023,
                -0.4429201745254115,
                -0.37857935201470716,
                -0.3123524665027858,
                -0.24456945692820126,
                -0.17556801477551678,
                -0.10569190170865325,
                -0.035289236964135356,
                0.035289236964135356,
                0.10569190170865325,
                0.17556801477551678,
                0.24456945692820126,
                0.3123524665027858,
                0.37857935201470716,
                0.4429201745254115,
                0.5050543913882023,
                0.5646724531854708,
                0.6214773459035758,
                0.6751860706661224,
                0.725531053660717,
                0.7722614792487559,
                0.815144539645135,
                0.8539665950047104,
                0.8885342382860432,
                0.9186752599841758,
                0.9442395091181941,
                0.9650996504224931,
                0.981151833077914,
                0.9923163921385159,
                0.9985402006367742,
            ],
            "weights": [
                0.0037454048031164908,
                0.008700481367523676,
                0.013619586755579383,
                0.018471481736814985,
                0.02323148190201923,
                0.02787578282128097,
                0.03238122281206993,
                0.03672534781380876,
                0.040886512310346054,
                0.04484398408197005,
                0.04857804644835181,
                0.05207009609170433,
                0.0553027355637279,
                0.05825985987759541,
                0.06092673670156192,
                0.06329007973320361,
                0.06533811487918127,
                0.06706063890629348,
                0.06844907026936646,
                0.06949649186157239,
                0.07019768547355804,
                0.07054915778935386,
                0.07054915778935386,
                0.07019768547355804,
                0.06949649186157239,
                0.06844907026936646,
                0.06706063890629348,
                0.06533811487918127,
                0.06329007973320361,
                0.06092673670156192,
                0.05825985987759541,
                0.0553027355637279,
                0.05207009609170433,
                0.04857804644835181,
                0.04484398408197005,
                0.040886512310346054,
                0.03672534781380876,
                0.03238122281206993,
                0.02787578282128097,
                0.02323148190201923,
                0.018471481736814985,
                0.013619586755579383,
                0.008700481367523676,
                0.0037454048031164908,
            ],
            "generator": "gauss_legendre",
        },
        45: {
            "degree": 89,
            "points": [
                -0.9986036451819367,
                -0.9926499984472038,
                -0.9819687150345406,
                -0.9666083103968945,
                -0.946641690995629,
                -0.9221639367190004,
                -0.8932916717532418,
                -0.8601624759606642,
                -0.8229342205020864,
                -0.7817843125939063,
                -0.7369088489454904,
                -0.6885216807712006,
                -0.6368533944532233,
                -0.5821502125693532,
                -0.5246728204629161,
                -0.4646951239196351,
                -0.4025029438585419,
                -0.33839265425060217,
                -0.27266976975237756,
                -0.20564748978326375,
                -0.13764520598325303,
                -0.06898698016314417,
                0.0,
                0.06898698016314417,
                0.13764520598325303,
                0.20564748978326375,
                0.27266976975237756,
                0.33839265425060217,
                0.4025029438585419,
                0.4646951239196351,
                0.5246728204629161,
                0.5821502125693532,
                0.6368533944532233,
                0.6885216807712006,
                0.7369088489454904,
                0.7817843125939063,
                0.8229342205020864,
                0.8601624759606642,
                0.8932916717532418,
                0.9221639367190004,
                0.946641690995629,
                0.9666083103968945,
                0.9819687150345406,
                0.9926499984472038,
                0.9986036451819367,
            ],
            "weights": [
                0.0035826631552810725,
                0.00832318929621773,
                0.013031104991582781,
                0.017677535257937863,
                0.022239847550579454,
                0.02669621396757769,
                0.031025374934515317,
                0.0352066922016093,
                0.03922023672930242,
                0.04304688070916464,
                0.046668387718373366,
                0.05006749923795213,
                0.05322801673126928,
                0.056134878759786656,
                0.05877423271884185,
                0.06113350083106668,
                0.0632014400738202,
                0.06496819575072363,
                0.06642534844984264,
                0.06756595416360778,
                0.06838457737866988,
                0.06887731697766154,
                0.06904182482923223,
                0.06887731697766154,
                0.06838457737866988,
                0.06756595416360778,
                0.06642534844984264,
                0.06496819575072363,
                0.0632014400738202,
                0.06113350083106668,
                0.05877423271884185,
                0.056134878759786656,
                0.05322801673126928,
                0.05006749923795213,
                0.046668387718373366,
                0.04304688070916464,
                0.03922023672930242,
                0.0352066922016093,
                0.031025374934515317,
                0.02669621396757769,
                0.022239847550579454,
                0.017677535257937863,
                0.013031104991582781,
                0.00832318929621773,
                0.0035826631552810725,
            ],
            "generator": "gauss_legendre",
        },
        46: {
            "degree": 91,
            "points": [
                -0.998663042133818,
                -0.9929623489061743,
                -0.9827336698041669,
                -0.9680213918539919,
                -0.9488923634460897,
                -0.925433798806754,
                -0.897752711533942,
                -0.865975394866858,
                -0.8302468370660661,
                -0.7907300570752742,
                -0.747605359615666,
                -0.7010695120204057,
                -0.6513348462019977,
                -0.5986282897127152,
                -0.5431903302618026,
                -0.4852739183881647,
                -0.4251433132828284,
                -0.3630728770209957,
                -0.29934582270187005,
                -0.23425292220626975,
                -0.16809117946710353,
                -0.10116247530558424,
                -0.03377219001605204,
                0.03377219001605204,
                0.10116247530558424,
                0.16809117946710353,
                0.23425292220626975,
                0.29934582270187005,
                0.3630728770209957,
                0.4251433132828284,
                0.4852739183881647,
                0.5431903302618026,
                0.5986282897127152,
                0.6513348462019977,
                0.7010695120204057,
                0.747605359615666,
                0.7907300570752742,
                0.8302468370660661,
                0.865975394866858,
                0.897752711533942,
                0.925433798806754,
                0.9488923634460897,
                0.9680213918539919,
                0.9827336698041669,
                0.9929623489061743,
                0.998663042133818,
            ],
            "weights": [
                0.0034303008681091456,
                0.007969898229724492,
                0.012479883770988784,
                0.016933514007836395,
                0.021309998754136483,
                0.025589286397129797,
                0.02975182955220257,
                0.0337786279991068,
                0.03765130535738592,
                0.04135219010967875,
                0.04486439527731805,
                0.04817189510171219,
                0.051259598007142824,
                0.05411341538585653,
                0.056720325843991094,
                0.05906843459554615,
                0.061147027724650325,
                0.06294662106439443,
                0.06445900346713893,
                0.06567727426778112,
                0.06659587476845476,
                0.06721061360067808,
                0.06751868584903632,
                0.06751868584903632,
                0.06721061360067808,
                0.06659587476845476,
                0.06567727426778112,
                0.06445900346713893,
                0.06294662106439443,
                0.061147027724650325,
                0.05906843459554615,
                0.056720325843991094,
                0.05411341538585653,
                0.051259598007142824,
                0.04817189510171219,
                0.04486439527731805,
                0.04135219010967875,
                0.03765130535738592,
                0.0337786279991068,
                0.02975182955220257,
                0.025589286397129797,
                0.021309998754136483,
                0.016933514007836395,
                0.012479883770988784,
                0.007969898229724492,
                0.0034303008681091456,
            ],
            "generator": "gauss_legendre",
        },
        47: {
            "degree": 93,
            "points": [
                -0.9987187285842121,
                -0.9932552109877686,
                -0.9834510030716237,
                -0.9693467873265644,
                -0.9510039692577085,
                -0.9285026930123607,
                -0.9019413294385253,
                -0.8714360157968963,
                -0.8371201398999021,
                -0.799143754167742,
                -0.7576729184454386,
                -0.7128889734090643,
                -0.6649877473903327,
                -0.6141786999563736,
                -0.5606840059346642,
                -0.5047375838635779,
                -0.4465840731048557,
                -0.38647776408466716,
                -0.3246814863377359,
                -0.26146545921497455,
                -0.19710611027911182,
                -0.1318848665545149,
                -0.06608692391635568,
                0.0,
                0.06608692391635568,
                0.1318848665545149,
                0.19710611027911182,
                0.26146545921497455,
                0.3246814863377359,
                0.38647776408466716,
                0.4465840731048557,
                0.5047375838635779,
                0.5606840059346642,
                0.6141786999563736,
                0.6649877473903327,
                0.7128889734090643,
                0.7576729184454386,
                0.799143754167742,
                0.8371201398999021,
                0.8714360157968963,
                0.9019413294385253,
                0.9285026930123607,
                0.9510039692577085,
                0.9693467873265644,
                0.9834510030716237,
                0.9932552109877686,
                0.9987187285842121,
            ],
            "weights": [
                0.003287453842531307,
                0.007638616295848331,
                0.01196284846431249,
                0.016235333146433207,
                0.02043693814766801,
                0.024549211659658725,
                0.028554150700643353,
                0.032434235515184644,
                0.036172496584174964,
                0.03975258612253073,
                0.043158848648479506,
                0.04637638908650575,
                0.04939113774736104,
                0.052189911780056865,
                0.05476047278153011,
                0.057091580293231324,
                0.05917304094233872,
                0.06099575300873949,
                0.06255174622092143,
                0.06383421660571689,
                0.0648375562389456,
                0.06555737776654957,
                0.06599053358881034,
                0.06613512962365524,
                0.06599053358881034,
                0.06555737776654957,
                0.0648375562389456,
                0.06383421660571689,
                0.06255174622092143,
                0.06099575300873949,
                0.05917304094233872,
                0.057091580293231324,
                0.05476047278153011,
                0.052189911780056865,
                0.04939113774736104,
                0.04637638908650575,
                0.043158848648479506,
                0.03975258612253073,
                0.036172496584174964,
                0.032434235515184644,
                0.028554150700643353,
                0.024549211659658725,
                0.02043693814766801,
                0.016235333146433207,
                0.01196284846431249,
                0.007638616295848331,
                0.003287453842531307,
            ],
            "generator": "gauss_legendre",
        },
        48: {
            "degree": 95,
            "points": [
                -0.9987710072524261,
                -0.9935301722663508,
                -0.9841245837228269,
                -0.9705915925462473,
                -0.9529877031604309,
                -0.9313866907065543,
                -0.9058791367155696,
                -0.8765720202742479,
                -0.8435882616243935,
                -0.8070662040294426,
                -0.7671590325157404,
                -0.7240341309238146,
                -0.6778723796326639,
                -0.6288673967765136,
                -0.5772247260839727,
                -0.523160974722233,
                -0.4669029047509584,
                -0.4086864819907167,
                -0.34875588629216075,
                -0.28736248735545555,
                -0.22476379039468905,
                -0.1612223560688917,
                -0.0970046992094627,
                -0.03238017096286937,
                0.03238017096286937,
                0.0970046992094627,
                0.1612223560688917,
                0.22476379039468905,
                0.28736248735545555,
                0.34875588629216075,
                0.4086864819907167,
                0.4669029047509584,
                0.523160974722233,
                0.5772247260839727,
                0.6288673967765136,
                0.6778723796326639,
                0.7240341309238146,
                0.7671590325157404,
                0.8070662040294426,
                0.8435882616243935,
                0.8765720202742479,
                0.9058791367155696,
                0.9313866907065543,
                0.9529877031604309,
                0.9705915925462473,
                0.9841245837228269,
                0.9935301722663508,
                0.9987710072524261,
            ],
            "weights": [
                0.0031533460523091796,
                0.007327553901276492,
                0.011477234579234974,
                0.015579315722942928,
                0.019616160457355297,
                0.023570760839324092,
                0.027426509708356882,
                0.03116722783279834,
                0.03477722256477066,
                0.038241351065830674,
                0.041545082943464554,
                0.0446745608566941,
                0.047616658492490284,
                0.05035903555385428,
                0.05289018948519349,
                0.055199503699984054,
                0.05727729210040293,
                0.05911483969839548,
                0.06070443916589358,
                0.062039423159892464,
                0.06311419228625378,
                0.06392423858464795,
                0.06446616443594984,
                0.06473769681268368,
                0.06473769681268368,
                0.06446616443594984,
                0.06392423858464795,
                0.06311419228625378,
                0.062039423159892464,
                0.06070443916589358,
                0.05911483969839548,
                0.05727729210040293,
                0.055199503699984054,
                0.05289018948519349,
                0.05035903555385428,
                0.047616658492490284,
                0.0446745608566941,
                0.041545082943464554,
                0.038241351065830674,
                0.03477722256477066,
                0.03116722783279834,
                0.027426509708356882,
                0.023570760839324092,
                0.019616160457355297,
                0.015579315722942928,
                0.011477234579234974,
                0.007327553901276492,
                0.0031533460523091796,
            ],
            "generator": "gauss_legendre",
        },
        49: {
            "degree": 97,
            "points": [
                -0.9988201506066353,
                -0.9937886619441678,
                -0.984757895914213,
                -0.9717622009015554,
                -0.9548536586741372,
                -0.9341002947558101,
                -0.9095856558280733,
                -0.8814084455730089,
                -0.8496821198441658,
                -0.8145344273598554,
                -0.7761068943454467,
                -0.7345542542374027,
                -0.6900438244251321,
                -0.6427548324192377,
                -0.5928776941089007,
                -0.5406132469917261,
                -0.48617194145249204,
                -0.42977299334157654,
                -0.3716435012622849,
                -0.31201753211974875,
                -0.2511351786125773,
                -0.1892415924618136,
                -0.12658599726967204,
                -0.06342068498268678,
                0.0,
                0.06342068498268678,
                0.12658599726967204,
                0.1892415924618136,
                0.2511351786125773,
                0.31201753211974875,
                0.3716435012622849,
                0.42977299334157654,
                0.48617194145249204,
                0.5406132469917261,
                0.5928776941089007,
                0.6427548324192377,
                0.6900438244251321,
                0.7345542542374027,
                0.7761068943454467,
                0.8145344273598554,
                0.8496821198441658,
                0.8814084455730089,
                0.9095856558280733,
                0.9341002947558101,
                0.9548536586741372,
                0.9717622009015554,
                0.984757895914213,
                0.9937886619441678,
                0.9988201506066353,
            ],
            "weights": [
                0.0030272789889268293,
                0.00703509959008707,
                0.011020551031592718,
                0.014962144935625083,
                0.018843595853089968,
                0.022649201587446474,
                0.026363618927066127,
                0.02997188462058378,
                0.033459466791621775,
                0.03681232096300051,
                0.04001694576637272,
                0.043060436981259324,
                0.04593053935559558,
                0.04861569588782794,
                0.051105094330144415,
                0.05338871070825872,
                0.05545734967480332,
                0.05730268153018716,
                0.05891727576002699,
                0.06029463095315184,
                0.06142920097919265,
                0.06231641732005697,
                0.06295270746519542,
                0.06333550929649147,
                0.06346328140479025,
                0.06333550929649147,
                0.06295270746519542,
                0.06231641732005697,
                0.06142920097919265,
                0.06029463095315184,
                0.05891727576002699,
                0.05730268153018716,
                0.05545734967480332,
                0.05338871070825872,
                0.051105094330144415,
                0.04861569588782794,
                0.04593053935559558,
                0.043060436981259324,
                0.04001694576637272,
                0.03681232096300051,
                0.033459466791621775,
                0.02997188462058378,
                0.026363618927066127,
                0.022649201587446474,
                0.018843595853089968,
                0.014962144935625083,
                0.011020551031592718,
                0.00703509959008707,
                0.0030272789889268293,
            ],
            "generator": "gauss_legendre",
        },
        50: {
            "degree": 99,
            "points": [
                -0.998866404420071,
                -0.9940319694320907,
                -0.9853540840480058,
                -0.972864385106692,
                -0.9566109552428079,
                -0.936656618944878,
                -0.9130785566557919,
                -0.8859679795236131,
                -0.8554297694299461,
                -0.821582070859336,
                -0.7845558329003992,
                -0.7444943022260686,
                -0.7015524687068222,
                -0.6558964656854394,
                -0.6077029271849502,
                -0.55715830451465,
                -0.5044581449074642,
                -0.44980633497403877,
                -0.39341431189756515,
                -0.33550024541943735,
                -0.27628819377953195,
                -0.21600723687604176,
                -0.1548905899981459,
                -0.09317470156008613,
                -0.031098338327188876,
                0.031098338327188876,
                0.09317470156008613,
                0.1548905899981459,
                0.21600723687604176,
                0.27628819377953195,
                0.33550024541943735,
                0.39341431189756515,
                0.44980633497403877,
                0.5044581449074642,
                0.55715830451465,
                0.6077029271849502,
                0.6558964656854394,
                0.7015524687068222,
                0.7444943022260686,
                0.7845558329003992,
                0.821582070859336,
                0.8554297694299461,
                0.8859679795236131,
                0.9130785566557919,
                0.936656618944878,
                0.9566109552428079,
                0.972864385106692,
                0.9853540840480058,
                0.9940319694320907,
                0.998866404420071,
            ],
            "weights": [
                0.0029086225531578685,
                0.006759799195745505,
                0.01059054838365167,
                0.01438082276148571,
                0.01811556071348957,
                0.021780243170124582,
                0.02536067357001259,
                0.028842993580534923,
                0.032213728223577896,
                0.035459835615146026,
                0.038568756612587844,
                0.0415284630901474,
                0.0443275043388031,
                0.04695505130394827,
                0.049400938449466136,
                0.05165570306958092,
                0.05371062188899592,
                0.05555774480621228,
                0.05718992564772815,
                0.058600849813222215,
                0.059785058704265225,
                0.06073797084176991,
                0.06145589959031641,
                0.06193606742068298,
                0.062176616655347,
                0.062176616655347,
                0.06193606742068298,
                0.06145589959031641,
                0.06073797084176991,
                0.059785058704265225,
                0.058600849813222215,
                0.05718992564772815,
                0.05555774480621228,
                0.05371062188899592,
                0.05165570306958092,
                0.049400938449466136,
                0.04695505130394827,
                0.0443275043388031,
                0.0415284630901474,
                0.038568756612587844,
                0.035459835615146026,
                0.032213728223577896,
                0.028842993580534923,
                0.02536067357001259,
                0.021780243170124582,
                0.01811556071348957,
                0.01438082276148571,
                0.01059054838365167,
                0.006759799195745505,
                0.0029086225531578685,
            ],
            "generator": "gauss_legendre",
        },
        51: {
            "degree": 101,
            "points": [
                -0.9989099908489035,
                -0.9942612604367526,
                -0.985915991735903,
                -0.9739033680193239,
                -0.9582678486139082,
                -0.9390675440029623,
                -0.9163738623097802,
                -0.8902712180295274,
                -0.8608567111822923,
                -0.8282397638230649,
                -0.7925417120993812,
                -0.7538953544853755,
                -0.7124444575770367,
                -0.66834322117537,
                -0.6217557046007233,
                -0.5728552163513039,
                -0.5218236693661858,
                -0.4688509042860411,
                -0.4141339832263039,
                -0.3578764566884095,
                -0.3002876063353319,
                -0.24158166644779872,
                -0.18197702695707754,
                -0.12169542101888878,
                -0.06096110015057872,
                0.0,
                0.06096110015057872,
                0.12169542101888878,
                0.18197702695707754,
                0.24158166644779872,
                0.3002876063353319,
                0.3578764566884095,
                0.4141339832263039,
                0.4688509042860411,
                0.5218236693661858,
                0.5728552163513039,
                0.6217557046007233,
                0.66834322117537,
                0.7124444575770367,
                0.7538953544853755,
                0.7925417120993812,
                0.8282397638230649,
                0.8608567111822923,
                0.8902712180295274,
                0.9163738623097802,
                0.9390675440029623,
                0.9582678486139082,
                0.9739033680193239,
                0.985915991735903,
                0.9942612604367526,
                0.9989099908489035,
            ],
            "weights": [
                0.002796807171086596,
                0.006500337783252846,
                0.01018519129782049,
                0.013832634006477582,
                0.017428714723400632,
                0.020959988401703097,
                0.024413300573781594,
                0.027775798594162272,
                0.031034971290160383,
                0.03417869320418841,
                0.03719526892326064,
                0.040073476285496665,
                0.04280260799788018,
                0.04537251140765047,
                0.047773626240623354,
                0.04999702015005761,
                0.05203442193669743,
                0.05387825231304583,
                0.05552165209573906,
                0.05695850772025894,
                0.05818347398259247,
                0.05919199392296185,
                0.0599803157775036,
                0.0605455069347381,
                0.06088546484485665,
                0.06099892484120624,
                0.06088546484485665,
                0.0605455069347381,
                0.0599803157775036,
                0.05919199392296185,
                0.05818347398259247,
                0.05695850772025894,
                0.05552165209573906,
                0.05387825231304583,
                0.05203442193669743,
                0.04999702015005761,
                0.047773626240623354,
                0.04537251140765047,
                0.04280260799788018,
                0.040073476285496665,
                0.03719526892326064,
                0.03417869320418841,
                0.031034971290160383,
                0.027775798594162272,
                0.024413300573781594,
                0.020959988401703097,
                0.017428714723400632,
                0.013832634006477582,
                0.01018519129782049,
                0.006500337783252846,
                0.002796807171086596,
            ],
            "generator": "gauss_legendre",
        },
        52: {
            "degree": 103,
            "points": [
                -0.9989511111039503,
                -0.9944775909292161,
                -0.9864461956515499,
                -0.9748838842217445,
                -0.9598318269330866,
                -0.9413438536413591,
                -0.9194861289164246,
                -0.8943368905344953,
                -0.8659861628460676,
                -0.8345354323267345,
                -0.8000972834304683,
                -0.7627949951937449,
                -0.7227620997499832,
                -0.6801419042271677,
                -0.6350869776952459,
                -0.5877586049795791,
                -0.5383262092858274,
                -0.48696674569809606,
                -0.4338640677187617,
                -0.3792082691160937,
                -0.32319500343480784,
                -0.2660247836050018,
                -0.20790226415636606,
                -0.14903550860694917,
                -0.08963524464890057,
                -0.029914109797338766,
                0.029914109797338766,
                0.08963524464890057,
                0.14903550860694917,
                0.20790226415636606,
                0.2660247836050018,
                0.32319500343480784,
                0.3792082691160937,
                0.4338640677187617,
                0.48696674569809606,
                0.5383262092858274,
                0.5877586049795791,
                0.6350869776952459,
                0.6801419042271677,
                0.7227620997499832,
                0.7627949951937449,
                0.8000972834304683,
                0.8345354323267345,
                0.8659861628460676,
                0.8943368905344953,
                0.9194861289164246,
                0.9413438536413591,
                0.9598318269330866,
                0.9748838842217445,
                0.9864461956515499,
                0.9944775909292161,
                0.9989511111039503,
            ],
            "weights": [
                0.002691316950046796,
                0.0062555239629720275,
                0.009802634579461853,
                0.013315114982340117,
                0.01678002339630083,
                0.020184891507980453,
                0.023517513553984442,
                0.026765953746504065,
                0.02991858114714431,
                0.032964109089718835,
                0.035891634835097594,
                0.03869067831042415,
                0.04135121950056041,
                0.04386373425900059,
                0.046219228372784964,
                0.048409269744074994,
                0.05042601856634259,
                0.052262255383907115,
                0.05391140693275745,
                0.055367569669302855,
                0.056625530902368756,
                0.05768078745252701,
                0.05852956177181407,
                0.059168815466043176,
                0.059596260171248326,
                0.05981036574529205,
                0.05981036574529205,
                0.059596260171248326,
                0.059168815466043176,
                0.05852956177181407,
                0.05768078745252701,
                0.056625530902368756,
                0.055367569669302855,
                0.05391140693275745,
                0.052262255383907115,
                0.05042601856634259,
                0.048409269744074994,
                0.046219228372784964,
                0.04386373425900059,
                0.04135121950056041,
                0.03869067831042415,
                0.035891634835097594,
                0.032964109089718835,
                0.02991858114714431,
                0.026765953746504065,
                0.023517513553984442,
                0.020184891507980453,
                0.01678002339630083,
                0.013315114982340117,
                0.009802634579461853,
                0.0062555239629720275,
                0.002691316950046796,
            ],
            "generator": "gauss_legendre",
        },
        53: {
            "degree": 105,
            "points": [
                -0.9989899477763282,
                -0.9946819193080071,
                -0.9869470350233716,
                -0.9758102337149845,
                -0.9613096946231363,
                -0.9434953534644419,
                -0.9224286030428122,
                -0.8981820578754266,
                -0.8708392975582413,
                -0.8404945765458014,
                -0.8072524984168955,
                -0.7712276549255324,
                -0.7325442308075103,
                -0.6913355756013667,
                -0.6477437439165101,
                -0.6019190057137693,
                -0.5540193282770679,
                -0.5042098316571334,
                -0.4526622194618458,
                -0.39955418695395295,
                -0.34506880849572236,
                -0.2893939064516262,
                -0.23272140372427258,
                -0.17524666215532575,
                -0.11716780907195515,
                -0.05868505430025947,
                0.0,
                0.05868505430025947,
                0.11716780907195515,
                0.17524666215532575,
                0.23272140372427258,
                0.2893939064516262,
                0.34506880849572236,
                0.39955418695395295,
                0.4526622194618458,
                0.5042098316571334,
                0.5540193282770679,
                0.6019190057137693,
                0.6477437439165101,
                0.6913355756013667,
                0.7325442308075103,
                0.7712276549255324,
                0.8072524984168955,
                0.8404945765458014,
                0.8708392975582413,
                0.8981820578754266,
                0.9224286030428122,
                0.9434953534644419,
                0.9613096946231363,
                0.9758102337149845,
                0.9869470350233716,
                0.9946819193080071,
                0.9989899477763282,
            ],
            "weights": [
                0.0025916837205687228,
                0.006024276226947747,
                0.009441202284940213,
                0.0128260261442401,
                0.016166725256687685,
                0.019451721107636828,
                0.022669673057070416,
                0.025809482510757608,
                0.02886032361782363,
                0.031811678459019256,
                0.034653372583534035,
                0.0373756098034828,
                0.03996900584354026,
                0.04242462063452008,
                0.04473398910367275,
                0.04688915034075029,
                0.04888267503269898,
                0.05070769106929276,
                0.05235790722987274,
                0.05382763486873103,
                0.055111807523933604,
                0.056205998381739695,
                0.057106435536267174,
                0.05781001499171317,
                0.058314311362256024,
                0.05861758623272024,
                0.058718794151164315,
                0.05861758623272024,
                0.058314311362256024,
                0.05781001499171317,
                0.057106435536267174,
                0.056205998381739695,
                0.055111807523933604,
                0.05382763486873103,
                0.05235790722987274,
                0.05070769106929276,
                0.04888267503269898,
                0.04688915034075029,
                0.04473398910367275,
                0.04242462063452008,
                0.03996900584354026,
                0.0373756098034828,
                0.034653372583534035,
                0.031811678459019256,
                0.02886032361782363,
                0.025809482510757608,
                0.022669673057070416,
                0.019451721107636828,
                0.016166725256687685,
                0.0128260261442401,
                0.009441202284940213,
                0.006024276226947747,
                0.0025916837205687228,
            ],
            "generator": "gauss_legendre",
        },
        54: {
            "degree": 107,
            "points": [
                -0.999026666867341,
                -0.9948751170183389,
                -0.9874206373973435,
                -0.9766863288579033,
                -0.9627076457859236,
                -0.9455309751649958,
                -0.9252133598666514,
                -0.9018222862847016,
                -0.8754354540655689,
                -0.8461405159707729,
                -0.8140347859135678,
                -0.779224915346254,
                -0.7418265388091843,
                -0.7019638897191729,
                -0.6597693876319831,
                -0.6153831983311273,
                -0.5689527681952095,
                -0.520632334385933,
                -0.4705824124813823,
                -0.41896926325520456,
                -0.36596434037219117,
                -0.3117437208344682,
                -0.2564875200699973,
                -0.20037929360621357,
                -0.14360542731625614,
                -0.08635451826324822,
                -0.028816748199341775,
                0.028816748199341775,
                0.08635451826324822,
                0.14360542731625614,
                0.20037929360621357,
                0.2564875200699973,
                0.3117437208344682,
                0.36596434037219117,
                0.41896926325520456,
                0.4705824124813823,
                0.520632334385933,
                0.5689527681952095,
                0.6153831983311273,
                0.6597693876319831,
                0.7019638897191729,
                0.7418265388091843,
                0.779224915346254,
                0.8140347859135678,
                0.8461405159707729,
                0.8754354540655689,
                0.9018222862847016,
                0.9252133598666514,
                0.9455309751649958,
                0.9627076457859236,
                0.9766863288579033,
                0.9874206373973435,
                0.9948751170183389,
                0.999026666867341,
            ],
            "weights": [
                0.002497481835760338,
                0.005805611015240988,
                0.009099369455510098,
                0.012363328128846919,
                0.01558630303592393,
                0.018757527621469608,
                0.021866451422853622,
                0.024902741467208465,
                0.027856309310596104,
                0.03071734249787103,
                0.03347633646437272,
                0.03612412584038348,
                0.03865191478210257,
                0.041051306136645045,
                0.043314329309597006,
                0.045433466728276785,
                0.04740167880644483,
                0.04921242732452895,
                0.050859697146188106,
                0.05233801619829868,
                0.05364247364755353,
                0.054768736213057924,
                0.05571306256058993,
                0.05647231573062589,
                0.05704397355879454,
                0.05742613705411204,
                0.05761753670714698,
                0.05761753670714698,
                0.05742613705411204,
                0.05704397355879454,
                0.05647231573062589,
                0.05571306256058993,
                0.054768736213057924,
                0.05364247364755353,
                0.05233801619829868,
                0.050859697146188106,
                0.04921242732452895,
                0.04740167880644483,
                0.045433466728276785,
                0.043314329309597006,
                0.041051306136645045,
                0.03865191478210257,
                0.03612412584038348,
                0.03347633646437272,
                0.03071734249787103,
                0.027856309310596104,
                0.024902741467208465,
                0.021866451422853622,
                0.018757527621469608,
                0.01558630303592393,
                0.012363328128846919,
                0.009099369455510098,
                0.005805611015240988,
                0.002497481835760338,
            ],
            "generator": "gauss_legendre",
        },
        55: {
            "degree": 109,
            "points": [
                -0.9990614195648185,
                -0.9950579778474119,
                -0.9878689411988892,
                -0.9775157355039892,
                -0.9640313285931352,
                -0.9474588680412107,
                -0.9278514247207917,
                -0.905271800744,
                -0.8797923224198955,
                -0.8514946066171545,
                -0.8204692985593209,
                -0.7868157811276224,
                -0.7506418563480219,
                -0.7120633999866378,
                -0.6712039903198264,
                -0.6281945122499282,
                -0.5831727380260321,
                -0.5362828859083433,
                -0.4876751581874741,
                -0.4375052600371746,
                -0.38593390074097944,
                -0.3331262788900239,
                -0.2792515532008065,
                -0.22448230064784547,
                -0.1689939636468732,
                -0.11296428805932926,
                -0.05657275381833678,
                0.0,
                0.05657275381833678,
                0.11296428805932926,
                0.1689939636468732,
                0.22448230064784547,
                0.2792515532008065,
                0.3331262788900239,
                0.38593390074097944,
                0.4375052600371746,
                0.4876751581874741,
                0.5362828859083433,
                0.5831727380260321,
                0.6281945122499282,
                0.6712039903198264,
                0.7120633999866378,
                0.7506418563480219,
                0.7868157811276224,
                0.8204692985593209,
                0.8514946066171545,
                0.8797923224198955,
                0.905271800744,
                0.9278514247207917,
                0.9474588680412107,
                0.9640313285931352,
                0.9775157355039892,
                0.9878689411988892,
                0.9950579778474119,
                0.9990614195648185,
            ],
            "weights": [
                0.0024083236199831147,
                0.005598632266559247,
                0.008775746107057643,
                0.01192516071984901,
                0.015036458333511426,
                0.018099614520729283,
                0.02110480166801605,
                0.024042388009725475,
                0.026902961456396427,
                0.029677357765160926,
                0.03235668922618577,
                0.03493237287358967,
                0.0373961578679654,
                0.03974015187433726,
                0.041956846317718864,
                0.04403914042160644,
                0.0459803639462838,
                0.0477742985512007,
                0.04941519771155173,
                0.05089780512449391,
                0.052217371545632024,
                0.05336967000160544,
                0.05435100932991106,
                0.05515824600250864,
                0.05578879419528405,
                0.05624063407108432,
                0.056512318249771994,
                0.0566029764445603,
                0.056512318249771994,
                0.05624063407108432,
                0.05578879419528405,
                0.05515824600250864,
                0.05435100932991106,
                0.05336967000160544,
                0.052217371545632024,
                0.05089780512449391,
                0.04941519771155173,
                0.0477742985512007,
                0.0459803639462838,
                0.04403914042160644,
                0.041956846317718864,
                0.03974015187433726,
                0.0373961578679654,
                0.03493237287358967,
                0.03235668922618577,
                0.029677357765160926,
                0.026902961456396427,
                0.024042388009725475,
                0.02110480166801605,
                0.018099614520729283,
                0.015036458333511426,
                0.01192516071984901,
                0.008775746107057643,
                0.005598632266559247,
                0.0024083236199831147,
            ],
            "generator": "gauss_legendre",
        },
        56: {
            "degree": 111,
            "points": [
                -0.9990943438014656,
                -0.9952312260810697,
                -0.9882937155401615,
                -0.9783017091402564,
                -0.9652859019054902,
                -0.9492864795619627,
                -0.9303528802474963,
                -0.9085436204206555,
                -0.8839261083278276,
                -0.8565764337627486,
                -0.8265791321428817,
                -0.7940269228938666,
                -0.7590204227051289,
                -0.7216678344501881,
                -0.6820846126944704,
                -0.6403931068070069,
                -0.5967221827706634,
                -0.5512068248555346,
                -0.5039877183843817,
                -0.4552108148784596,
                -0.40502688092709127,
                -0.3535910321749545,
                -0.3010622538672207,
                -0.24760290943433721,
                -0.19337823863527526,
                -0.13855584681037625,
                -0.08330518682243537,
                -0.02779703528727544,
                0.02779703528727544,
                0.08330518682243537,
                0.13855584681037625,
                0.19337823863527526,
                0.24760290943433721,
                0.3010622538672207,
                0.3535910321749545,
                0.40502688092709127,
                0.4552108148784596,
                0.5039877183843817,
                0.5512068248555346,
                0.5967221827706634,
                0.6403931068070069,
                0.6820846126944704,
                0.7216678344501881,
                0.7590204227051289,
                0.7940269228938666,
                0.8265791321428817,
                0.8565764337627486,
                0.8839261083278276,
                0.9085436204206555,
                0.9303528802474963,
                0.9492864795619627,
                0.9652859019054902,
                0.9783017091402564,
                0.9882937155401615,
                0.9952312260810697,
                0.9990943438014656,
            ],
            "weights": [
                0.002323855375775428,
                0.005402522246016065,
                0.008469063163307694,
                0.011509824340383248,
                0.014515089278020676,
                0.017475512911400724,
                0.02038192988240258,
                0.023225351562565236,
                0.02599698705839167,
                0.028688268473822876,
                0.031290876747310147,
                0.03379676711561167,
                0.03619819387231511,
                0.0384877342592475,
                0.040658311384744586,
                0.042703216084666984,
                0.04461612765269215,
                0.04639113337300188,
                0.04802274679360016,
                0.049505924683047514,
                0.05083608261779835,
                0.05200910915174137,
                0.053021378524010704,
                0.053869761865714405,
                0.05455163687088944,
                0.055064895901762376,
                0.05540795250324507,
                0.05557974630651438,
                0.05557974630651438,
                0.05540795250324507,
                0.055064895901762376,
                0.05455163687088944,
                0.053869761865714405,
                0.053021378524010704,
                0.05200910915174137,
                0.05083608261779835,
                0.049505924683047514,
                0.04802274679360016,
                0.04639113337300188,
                0.04461612765269215,
                0.042703216084666984,
                0.040658311384744586,
                0.0384877342592475,
                0.03619819387231511,
                0.03379676711561167,
                0.031290876747310147,
                0.028688268473822876,
                0.02599698705839167,
                0.023225351562565236,
                0.02038192988240258,
                0.017475512911400724,
                0.014515089278020676,
                0.011509824340383248,
                0.008469063163307694,
                0.005402522246016065,
                0.002323855375775428,
            ],
            "generator": "gauss_legendre",
        },
        57: {
            "degree": 113,
            "points": [
                -0.9991255656252629,
                -0.9953955236784303,
                -0.988696577650222,
                -0.9790472267094688,
                -0.9664760851718867,
                -0.9510206264478767,
                -0.9327269610671016,
                -0.9116496785213912,
                -0.8878516788822213,
                -0.8614039832620469,
                -0.8323855211504392,
                -0.8008828945472183,
                -0.7669901193594502,
                -0.7308083447445233,
                -0.6924455511995177,
                -0.6520162282809769,
                -0.6096410329087154,
                -0.5654464292692367,
                -0.5195643113911876,
                -0.4721316095179757,
                -0.42328988145156393,
                -0.37318489008659445,
                -0.3219661683953786,
                -0.26978657316183874,
                -0.21680182879612403,
                -0.16317006259126426,
                -0.1090513328087878,
                -0.05460715100164683,
                0.0,
                0.05460715100164683,
                0.1090513328087878,
                0.16317006259126426,
                0.21680182879612403,
                0.26978657316183874,
                0.3219661683953786,
                0.37318489008659445,
                0.42328988145156393,
                0.4721316095179757,
                0.5195643113911876,
                0.5654464292692367,
                0.6096410329087154,
                0.6520162282809769,
                0.6924455511995177,
                0.7308083447445233,
                0.7669901193594502,
                0.8008828945472183,
                0.8323855211504392,
                0.8614039832620469,
                0.8878516788822213,
                0.9116496785213912,
                0.9327269610671016,
                0.9510206264478767,
                0.9664760851718867,
                0.9790472267094688,
                0.988696577650222,
                0.9953955236784303,
                0.9991255656252629,
            ],
            "weights": [
                0.0022437538722474204,
                0.0052165334747191466,
                0.008178160067822118,
                0.011115763732336133,
                0.01402027079075377,
                0.016882959023441547,
                0.019695270699488725,
                0.02244880789077644,
                0.025135350990918157,
                0.027746881402180446,
                0.030275604842694002,
                0.03271397436637136,
                0.03505471278231276,
                0.037290834324417564,
                0.03941566547548044,
                0.04142286487080117,
                0.04330644221621514,
                0.04506077616138127,
                0.04668063107364153,
                0.04816117266168779,
                0.049497982402019754,
                0.050687070724927494,
                0.05172488892051787,
                0.05260833972917751,
                0.05333478658481916,
                0.05390206148329861,
                0.05430847145249873,
                0.05455280360476196,
                0.05463432875658407,
                0.05455280360476196,
                0.05430847145249873,
                0.05390206148329861,
                0.05333478658481916,
                0.05260833972917751,
                0.05172488892051787,
                0.050687070724927494,
                0.049497982402019754,
                0.04816117266168779,
                0.04668063107364153,
                0.04506077616138127,
                0.04330644221621514,
                0.04142286487080117,
                0.03941566547548044,
                0.037290834324417564,
                0.03505471278231276,
                0.03271397436637136,
                0.030275604842694002,
                0.027746881402180446,
                0.025135350990918157,
                0.02244880789077644,
                0.019695270699488725,
                0.016882959023441547,
                0.01402027079075377,
                0.011115763732336133,
                0.008178160067822118,
                0.0052165334747191466,
                0.0022437538722474204,
            ],
            "generator": "gauss_legendre",
        },
        58: {
            "degree": 115,
            "points": [
                -0.9991552004073866,
                -0.9955514765972909,
                -0.9890790082484426,
                -0.9797550146943503,
                -0.9676062025029241,
                -0.9526675575188691,
                -0.9349821375882593,
                -0.9146009285643526,
                -0.8915826920220302,
                -0.8659937940748075,
                -0.8379080133393734,
                -0.8074063279130882,
                -0.7745766817496528,
                -0.7395137310200423,
                -0.7023185711539081,
                -0.6630984453321253,
                -0.6219664352630792,
                -0.579041135130225,
                -0.5344463096488477,
                -0.48831053721671847,
                -0.44076683918683957,
                -0.3919522963307531,
                -0.34200765359799523,
                -0.2910769143111092,
                -0.23930692496615347,
                -0.18684695183576133,
                -0.13384825059546684,
                -0.08046363021414274,
                -0.02684701236594236,
                0.02684701236594236,
                0.08046363021414274,
                0.13384825059546684,
                0.18684695183576133,
                0.23930692496615347,
                0.2910769143111092,
                0.34200765359799523,
                0.3919522963307531,
                0.44076683918683957,
                0.48831053721671847,
                0.5344463096488477,
                0.579041135130225,
                0.6219664352630792,
                0.6630984453321253,
                0.7023185711539081,
                0.7395137310200423,
                0.7745766817496528,
                0.8074063279130882,
                0.8379080133393734,
                0.8659937940748075,
                0.8915826920220302,
                0.9146009285643526,
                0.9349821375882593,
                0.9526675575188691,
                0.9676062025029241,
                0.9797550146943503,
                0.9890790082484426,
                0.9955514765972909,
                0.9991552004073866,
            ],
            "weights": [
                0.0021677232496301654,
                0.005039981612649626,
                0.007901973849998231,
                0.010741553532878381,
                0.013550237112989007,
                0.016319874234971013,
                0.019042465461893778,
                0.02171015614014626,
                0.024315252724963578,
                0.026850243181981794,
                0.029307818044160175,
                0.03168089125380902,
                0.03396262049341578,
                0.03614642686708729,
                0.038226013845858595,
                0.040195385409867765,
                0.04204886332958198,
                0.04378110353364021,
                0.04538711151481967,
                0.046862256729026316,
                0.04820228594541772,
                0.04940333550896228,
                0.050461942479953045,
                0.051375054618285655,
                0.05214003918366976,
                0.052754690526370766,
                0.05321723644657896,
                0.0535263433040582,
                0.05368111986333478,
                0.05368111986333478,
                0.0535263433040582,
                0.05321723644657896,
                0.052754690526370766,
                0.05214003918366976,
                0.051375054618285655,
                0.050461942479953045,
                0.04940333550896228,
                0.04820228594541772,
                0.046862256729026316,
                0.04538711151481967,
                0.04378110353364021,
                0.04204886332958198,
                0.040195385409867765,
                0.038226013845858595,
                0.03614642686708729,
                0.03396262049341578,
                0.03168089125380902,
                0.029307818044160175,
                0.026850243181981794,
                0.024315252724963578,
                0.02171015614014626,
                0.019042465461893778,
                0.016319874234971013,
                0.013550237112989007,
                0.010741553532878381,
                0.007901973849998231,
                0.005039981612649626,
                0.0021677232496301654,
            ],
            "generator": "gauss_legendre",
        },
        59: {
            "degree": 117,
            "points": [
                -0.9991833539092947,
                -0.995699640383246,
                -0.9894423651337309,
                -0.9804275739567156,
                -0.9686802216817816,
                -0.9542330093769511,
                -0.9371261903534539,
                -0.9174074387881552,
                -0.8951317117434721,
                -0.8703610942928822,
                -0.8431646258168722,
                -0.8136181072882116,
                -0.7818038898623609,
                -0.7478106452786403,
                -0.7117331186771978,
                -0.6736718645049372,
                -0.6337329662388501,
                -0.5920277407040302,
                -0.5486724278083964,
                -0.503787866557718,
                -0.4574991582532667,
                -0.409935317810419,
                -0.3612289141697948,
                -0.3115157008030137,
                -0.2609342373428117,
                -0.20962550339203656,
                -0.15773250558785798,
                -0.10539987901634415,
                -0.05277348408831001,
                0.0,
                0.05277348408831001,
                0.10539987901634415,
                0.15773250558785798,
                0.20962550339203656,
                0.2609342373428117,
                0.3115157008030137,
                0.3612289141697948,
                0.409935317810419,
                0.4574991582532667,
                0.503787866557718,
                0.5486724278083964,
                0.5920277407040302,
                0.6337329662388501,
                0.6736718645049372,
                0.7117331186771978,
                0.7478106452786403,
                0.7818038898623609,
                0.8136181072882116,
                0.8431646258168722,
                0.8703610942928822,
                0.8951317117434721,
                0.9174074387881552,
                0.9371261903534539,
                0.9542330093769511,
                0.9686802216817816,
                0.9804275739567156,
                0.9894423651337309,
                0.995699640383246,
                0.9991833539092947,
            ],
            "weights": [
                0.0020954922845406714,
                0.004872239168265079,
                0.0076395294534899365,
                0.010385885500996754,
                0.013103366306344587,
                0.015784347313080888,
                0.0184213427536097,
                0.0210069982884371,
                0.023534105393713523,
                0.025995619731298675,
                0.028384680200534633,
                0.030694627836111515,
                0.03291902427104502,
                0.035051669636399954,
                0.03708661981887089,
                0.03901820301616004,
                0.04084103553868671,
                0.042550036811067574,
                0.044140443530297335,
                0.045607822940509704,
                0.04694808518696196,
                0.048157494714606355,
                0.049232680679362005,
                0.050170646342996866,
                0.050968777425393935,
                0.051624849390891514,
                0.05213703364837538,
                0.05250390264782871,
                0.052724433859127944,
                0.05279801262199038,
                0.052724433859127944,
                0.05250390264782871,
                0.05213703364837538,
                0.051624849390891514,
                0.050968777425393935,
                0.050170646342996866,
                0.049232680679362005,
                0.048157494714606355,
                0.04694808518696196,
                0.045607822940509704,
                0.044140443530297335,
                0.042550036811067574,
                0.04084103553868671,
                0.03901820301616004,
                0.03708661981887089,
                0.035051669636399954,
                0.03291902427104502,
                0.030694627836111515,
                0.028384680200534633,
                0.025995619731298675,
                0.023534105393713523,
                0.0210069982884371,
                0.0184213427536097,
                0.015784347313080888,
                0.013103366306344587,
                0.010385885500996754,
                0.0076395294534899365,
                0.004872239168265079,
                0.0020954922845406714,
            ],
            "generator": "gauss_legendre",
        },
        60: {
            "degree": 119,
            "points": [
                -0.9992101232274361,
                -0.9958405251188381,
                -0.9897878952222218,
                -0.9810672017525982,
                -0.9697017887650528,
                -0.955722255839996,
                -0.9391662761164232,
                -0.9200784761776275,
                -0.898510310810046,
                -0.8745199226468983,
                -0.8481719847859297,
                -0.8195375261621458,
                -0.7886937399322641,
                -0.7557237753065857,
                -0.7207165133557304,
                -0.6837663273813555,
                -0.6449728284894771,
                -0.6044405970485104,
                -0.5622789007539446,
                -0.5186014000585697,
                -0.4735258417617071,
                -0.42717374158307836,
                -0.379670056576798,
                -0.3311428482684482,
                -0.2817229374232617,
                -0.23154355137602933,
                -0.18073996487342542,
                -0.129449135396945,
                -0.07780933394953657,
                -0.025959772301247803,
                0.025959772301247803,
                0.07780933394953657,
                0.129449135396945,
                0.18073996487342542,
                0.23154355137602933,
                0.2817229374232617,
                0.3311428482684482,
                0.379670056576798,
                0.42717374158307836,
                0.4735258417617071,
                0.5186014000585697,
                0.5622789007539446,
                0.6044405970485104,
                0.6449728284894771,
                0.6837663273813555,
                0.7207165133557304,
                0.7557237753065857,
                0.7886937399322641,
                0.8195375261621458,
                0.8481719847859297,
                0.8745199226468983,
                0.898510310810046,
                0.9200784761776275,
                0.9391662761164232,
                0.955722255839996,
                0.9697017887650528,
                0.9810672017525982,
                0.9897878952222218,
                0.9958405251188381,
                0.9992101232274361,
            ],
            "weights": [
                0.0020268119688693106,
                0.00471272992695454,
                0.0073899311633443855,
                0.01004755718228753,
                0.012678166476815937,
                0.015274618596785182,
                0.0178299010142081,
                0.020337120729457824,
                0.022789516943997886,
                0.025180477621521515,
                0.027503556749924763,
                0.0297524915007891,
                0.03192121901929624,
                0.03400389272494669,
                0.035994898051084655,
                0.037888867569243576,
                0.03968069545238093,
                0.0413655512355849,
                0.04293889283593564,
                0.04439647879578732,
                0.04573437971611472,
                0.04694898884891243,
                0.048037031819971425,
                0.04899557545575704,
                0.049822035690550354,
                0.05051418453250958,
                0.05107015606985579,
                0.051488451500981164,
                0.051767943174910416,
                0.051907877631220865,
                0.051907877631220865,
                0.051767943174910416,
                0.051488451500981164,
                0.05107015606985579,
                0.05051418453250958,
                0.049822035690550354,
                0.04899557545575704,
                0.048037031819971425,
                0.04694898884891243,
                0.04573437971611472,
                0.04439647879578732,
                0.04293889283593564,
                0.0413655512355849,
                0.03968069545238093,
                0.037888867569243576,
                0.035994898051084655,
                0.03400389272494669,
                0.03192121901929624,
                0.0297524915007891,
                0.027503556749924763,
                0.025180477621521515,
                0.022789516943997886,
                0.020337120729457824,
                0.0178299010142081,
                0.015274618596785182,
                0.012678166476815937,
                0.01004755718228753,
                0.0073899311633443855,
                0.00471272992695454,
                0.0020268119688693106,
            ],
            "generator": "gauss_legendre",
        },
        61: {
            "degree": 121,
            "points": [
                -0.9992355976313635,
                -0.9959745998151203,
                -0.990116745232517,
                -0.981676011284037,
                -0.9706742588331829,
                -0.9571401519129841,
                -0.9411089866813611,
                -0.9226225813829553,
                -0.9017291624740011,
                -0.878483237214881,
                -0.8529454508476634,
                -0.8251824281086599,
                -0.7952665992823597,
                -0.7632760111723123,
                -0.7292941234494651,
                -0.6934095908944912,
                -0.6557160320950709,
                -0.6163117851979217,
                -0.5752996513508306,
                -0.5327866265029253,
                -0.4888836222622521,
                -0.4437051765385316,
                -0.3973691547257566,
                -0.34999644220406684,
                -0.3017106289630307,
                -0.2526376871690535,
                -0.20290564251805848,
                -0.1526442402308153,
                -0.10198460656227407,
                -0.051058906707974354,
                0.0,
                0.051058906707974354,
                0.10198460656227407,
                0.1526442402308153,
                0.20290564251805848,
                0.2526376871690535,
                0.3017106289630307,
                0.34999644220406684,
                0.3973691547257566,
                0.4437051765385316,
                0.4888836222622521,
                0.5327866265029253,
                0.5752996513508306,
                0.6163117851979217,
                0.6557160320950709,
                0.6934095908944912,
                0.7292941234494651,
                0.7632760111723123,
                0.7952665992823597,
                0.8251824281086599,
                0.8529454508476634,
                0.878483237214881,
                0.9017291624740011,
                0.9226225813829553,
                0.9411089866813611,
                0.9571401519129841,
                0.9706742588331829,
                0.981676011284037,
                0.990116745232517,
                0.9959745998151203,
                0.9992355976313635,
            ],
            "weights": [
                0.0019614533616696844,
                0.004560924006011563,
                0.00715235499174966,
                0.009725461830356146,
                0.01227326350781197,
                0.014789065884938233,
                0.01726629298761383,
                0.01969847774610118,
                0.022079273148319298,
                0.024402467187544206,
                0.026661998524151336,
                0.028851972088183353,
                0.03096667436839737,
                0.03300058827590729,
                0.0349484075165335,
                0.03680505042315481,
                0.03856567320700798,
                0.04022568259099818,
                0.041780747790888466,
                0.04322681181249605,
                0.04456010203508348,
                0.04577714005314598,
                0.04687475075080901,
                0.04785007058509562,
                0.048700555056411556,
                0.049423985346735574,
                0.05001847410817828,
                0.050482470386797436,
                0.05081476366881837,
                0.051014487038697265,
                0.05108111944078618,
                0.051014487038697265,
                0.05081476366881837,
                0.050482470386797436,
                0.05001847410817828,
                0.049423985346735574,
                0.048700555056411556,
                0.04785007058509562,
                0.04687475075080901,
                0.04577714005314598,
                0.04456010203508348,
                0.04322681181249605,
                0.041780747790888466,
                0.04022568259099818,
                0.03856567320700798,
                0.03680505042315481,
                0.0349484075165335,
                0.03300058827590729,
                0.03096667436839737,
                0.028851972088183353,
                0.026661998524151336,
                0.024402467187544206,
                0.022079273148319298,
                0.01969847774610118,
                0.01726629298761383,
                0.014789065884938233,
                0.01227326350781197,
                0.009725461830356146,
                0.00715235499174966,
                0.004560924006011563,
                0.0019614533616696844,
            ],
            "generator": "gauss_legendre",
        },
        62: {
            "degree": 123,
            "points": [
                -0.999259859308777,
                -0.9961022963162671,
                -0.9904299711892903,
                -0.9822559490972367,
                -0.9716007233716518,
                -0.958491172973927,
                -0.9429604013923285,
                -0.9250476356362037,
                -0.9047981225210935,
                -0.8822630128318973,
                -0.857499231512071,
                -0.8305693336040049,
                -0.8015413461039764,
                -0.7704885960554193,
                -0.7374895252831567,
                -0.702627492222297,
                -0.6659905613354795,
                -0.6276712806468852,
                -0.5877664479530873,
                -0.5463768663002511,
                -0.503607089344756,
                -0.4595651572401134,
                -0.41436232371712606,
                -0.36811277504656453,
                -0.320933341594194,
                -0.27294320269672634,
                -0.22426358560416554,
                -0.17501745924901563,
                -0.12532922361589682,
                -0.07532439549623433,
                -0.025129291421820615,
                0.025129291421820615,
                0.07532439549623433,
                0.12532922361589682,
                0.17501745924901563,
                0.22426358560416554,
                0.27294320269672634,
                0.320933341594194,
                0.36811277504656453,
                0.41436232371712606,
                0.4595651572401134,
                0.503607089344756,
                0.5463768663002511,
                0.5877664479530873,
                0.6276712806468852,
                0.6659905613354795,
                0.702627492222297,
                0.7374895252831567,
                0.7704885960554193,
                0.8015413461039764,
                0.8305693336040049,
                0.857499231512071,
                0.8822630128318973,
                0.9047981225210935,
                0.9250476356362037,
                0.9429604013923285,
                0.958491172973927,
                0.9716007233716518,
                0.9822559490972367,
                0.9904299711892903,
                0.9961022963162671,
                0.999259859308777,
            ],
            "weights": [
                0.0018992056795127678,
                0.00441633345693071,
                0.006926041901831181,
                0.009418579428419773,
                0.011887390117010234,
                0.014326191823807299,
                0.016728811790177277,
                0.019089176658573435,
                0.021401322277669787,
                0.023659407208682974,
                0.02585772695402455,
                0.027990728163314448,
                0.030053022573989865,
                0.03203940058162479,
                0.033944844379410775,
                0.035764540622768196,
                0.037493892582280024,
                0.03912853175196313,
                0.04066432888241756,
                0.04209740441038527,
                0.04342413825804749,
                0.044641178977124496,
                0.04574545221457025,
                0.04673416847841558,
                0.047604830184101284,
                0.04835523796347774,
                0.04898349622051791,
                0.049488017919699374,
                0.04986752859495244,
                0.05012106956904338,
                0.050248000375256376,
                0.050248000375256376,
                0.05012106956904338,
                0.04986752859495244,
                0.049488017919699374,
                0.04898349622051791,
                0.04835523796347774,
                0.047604830184101284,
                0.04673416847841558,
                0.04574545221457025,
                0.044641178977124496,
                0.04342413825804749,
                0.04209740441038527,
                0.04066432888241756,
                0.03912853175196313,
                0.037493892582280024,
                0.035764540622768196,
                0.033944844379410775,
                0.03203940058162479,
                0.030053022573989865,
                0.027990728163314448,
                0.02585772695402455,
                0.023659407208682974,
                0.021401322277669787,
                0.019089176658573435,
                0.016728811790177277,
                0.014326191823807299,
                0.011887390117010234,
                0.009418579428419773,
                0.006926041901831181,
                0.00441633345693071,
                0.0018992056795127678,
            ],
            "generator": "gauss_legendre",
        },
        63: {
            "degree": 125,
            "points": [
                -0.9992829840291237,
                -0.9962240127779701,
                -0.9907285468921895,
                -0.9828088105937273,
                -0.97248403469757,
                -0.9597794497589419,
                -0.9447261340410098,
                -0.9273609206218432,
                -0.9077263027785316,
                -0.8858703285078534,
                -0.8618464823641238,
                -0.8357135543195029,
                -0.8075354957734567,
                -0.7773812629903724,
                -0.7453246483178474,
                -0.7114440995848458,
                -0.6758225281149861,
                -0.6385471058213654,
                -0.5997090518776252,
                -0.559403409486285,
                -0.5177288132900333,
                -0.47478724799480443,
                -0.4306837987951116,
                -0.3855263942122479,
                -0.3394255419745844,
                -0.29249405858625144,
                -0.24484679324595338,
                -0.19660034679150667,
                -0.14787278635787196,
                -0.09878335644694528,
                -0.04945218711615963,
                0.0,
                0.04945218711615963,
                0.09878335644694528,
                0.14787278635787196,
                0.19660034679150667,
                0.24484679324595338,
                0.29249405858625144,
                0.3394255419745844,
                0.3855263942122479,
                0.4306837987951116,
                0.47478724799480443,
                0.5177288132900333,
                0.559403409486285,
                0.5997090518776252,
                0.6385471058213654,
                0.6758225281149861,
                0.7114440995848458,
                0.7453246483178474,
                0.7773812629903724,
                0.8075354957734567,
                0.8357135543195029,
                0.8618464823641238,
                0.8858703285078534,
                0.9077263027785316,
                0.9273609206218432,
                0.9447261340410098,
                0.9597794497589419,
                0.97248403469757,
                0.9828088105937273,
                0.9907285468921895,
                0.9962240127779701,
                0.9992829840291237,
            ],
            "weights": [
                0.0018398745955790698,
                0.004278508346862996,
                0.006710291765959956,
                0.009125968676326153,
                0.011519376076879823,
                0.013884612616115835,
                0.016215878410338374,
                0.018507464460161504,
                0.02075376125803898,
                0.022949271004890113,
                0.025088620553344983,
                0.027166574359097945,
                0.029178047208280707,
                0.031118116622219694,
                0.03298203488377931,
                0.03476524064535596,
                0.03646337008545718,
                0.038072267584349374,
                0.039587995891544055,
                0.041006845759666385,
                0.04232534502081564,
                0.043540267083027454,
                0.044648638825941285,
                0.04564774787629253,
                0.046535149245383635,
                0.047308671312268874,
                0.04796642113799502,
                0.04850678909788376,
                0.048928452820511954,
                0.049230380423747444,
                0.049411833039918134,
                0.049472366623930966,
                0.049411833039918134,
                0.049230380423747444,
                0.048928452820511954,
                0.04850678909788376,
                0.04796642113799502,
                0.047308671312268874,
                0.046535149245383635,
                0.04564774787629253,
                0.044648638825941285,
                0.043540267083027454,
                0.04232534502081564,
                0.041006845759666385,
                0.039587995891544055,
                0.038072267584349374,
                0.03646337008545718,
                0.03476524064535596,
                0.03298203488377931,
                0.031118116622219694,
                0.029178047208280707,
                0.027166574359097945,
                0.025088620553344983,
                0.022949271004890113,
                0.02075376125803898,
                0.018507464460161504,
                0.016215878410338374,
                0.013884612616115835,
                0.011519376076879823,
                0.009125968676326153,
                0.006710291765959956,
                0.004278508346862996,
                0.0018398745955790698,
            ],
            "generator": "gauss_legendre",
        },
        64: {
            "degree": 127,
            "points": [
                -0.9993050417357722,
                -0.9963401167719552,
                -0.9910133714767443,
                -0.983336253884626,
                -0.973326827789911,
                -0.9610087996520538,
                -0.9464113748584028,
                -0.9295691721319396,
                -0.9105221370785028,
                -0.8893154459951141,
                -0.8659993981540928,
                -0.8406292962525803,
                -0.8132653151227975,
                -0.7839723589433414,
                -0.7528199072605319,
                -0.7198818501716108,
                -0.6852363130542333,
                -0.6489654712546573,
                -0.6111553551723933,
                -0.571895646202634,
                -0.5312794640198946,
                -0.48940314570705296,
                -0.4463660172534641,
                -0.4022701579639916,
                -0.3572201583376681,
                -0.31132287199021097,
                -0.2646871622087674,
                -0.21742364374000708,
                -0.1696444204239928,
                -0.12146281929612056,
                -0.07299312178779904,
                -0.02435029266342443,
                0.02435029266342443,
                0.07299312178779904,
                0.12146281929612056,
                0.1696444204239928,
                0.21742364374000708,
                0.2646871622087674,
                0.31132287199021097,
                0.3572201583376681,
                0.4022701579639916,
                0.4463660172534641,
                0.48940314570705296,
                0.5312794640198946,
                0.571895646202634,
                0.6111553551723933,
                0.6489654712546573,
                0.6852363130542333,
                0.7198818501716108,
                0.7528199072605319,
                0.7839723589433414,
                0.8132653151227975,
                0.8406292962525803,
                0.8659993981540928,
                0.8893154459951141,
                0.9105221370785028,
                0.9295691721319396,
                0.9464113748584028,
                0.9610087996520538,
                0.973326827789911,
                0.983336253884626,
                0.9910133714767443,
                0.9963401167719552,
                0.9993050417357722,
            ],
            "weights": [
                0.0017832807216942152,
                0.004147033260562923,
                0.006504457968979654,
                0.008846759826364391,
                0.011168139460131466,
                0.013463047896718231,
                0.015726030476025082,
                0.0179517157756973,
                0.020134823153530094,
                0.022270173808383007,
                0.024352702568710853,
                0.026377469715054627,
                0.028339672614259702,
                0.030234657072402495,
                0.03205792835485145,
                0.03380516183714179,
                0.03547221325688232,
                0.03705512854024015,
                0.03855015317861559,
                0.03995374113272035,
                0.041262563242623486,
                0.0424735151236536,
                0.043583724529323464,
                0.044590558163756545,
                0.045491627927418114,
                0.046284796581314375,
                0.04696818281621,
                0.0475401657148303,
                0.04799938859645832,
                0.048344762234802954,
                0.048575467441503456,
                0.04869095700913975,
                0.04869095700913975,
                0.048575467441503456,
                0.048344762234802954,
                0.04799938859645832,
                0.0475401657148303,
                0.04696818281621,
                0.046284796581314375,
                0.045491627927418114,
                0.044590558163756545,
                0.043583724529323464,
                0.0424735151236536,
                0.041262563242623486,
                0.03995374113272035,
                0.03855015317861559,
                0.03705512854024015,
                0.03547221325688232,
                0.03380516183714179,
                0.03205792835485145,
                0.030234657072402495,
                0.028339672614259702,
                0.026377469715054627,
                0.024352702568710853,
                0.022270173808383007,
                0.020134823153530094,
                0.0179517157756973,
                0.015726030476025082,
                0.013463047896718231,
                0.011168139460131466,
                0.008846759826364391,
                0.006504457968979654,
                0.004147033260562923,
                0.0017832807216942152,
            ],
            "generator": "gauss_legendre",
        },
        65: {
            "degree": 129,
            "points": [
                -0.9993260970754129,
                -0.9964509480618492,
                -0.9912852761768016,
                -0.983839812187035,
                -0.9741315398335512,
                -0.9621827547180553,
                -0.9480209281684076,
                -0.9316786282287494,
                -0.9131934405428462,
                -0.8926078805047389,
                -0.8699692949264071,
                -0.8453297528999303,
                -0.8187459259226515,
                -0.7902789574921218,
                -0.7599943224419998,
                -0.7279616763294247,
                -0.6942546952139916,
                -0.6589509061936252,
                -0.6221315090854003,
                -0.5838811896604873,
                -0.5442879248622271,
                -0.5034427804550069,
                -0.46143970156914504,
                -0.418375296623409,
                -0.374348615122066,
                -0.3294609198374864,
                -0.2838154539022487,
                -0.2375172033464168,
                -0.19067265562614277,
                -0.14338955469897519,
                -0.09577665320919751,
                -0.04794346235317186,
                0.0,
                0.04794346235317186,
                0.09577665320919751,
                0.14338955469897519,
                0.19067265562614277,
                0.2375172033464168,
                0.2838154539022487,
                0.3294609198374864,
                0.374348615122066,
                0.418375296623409,
                0.46143970156914504,
                0.5034427804550069,
                0.5442879248622271,
                0.5838811896604873,
                0.6221315090854003,
                0.6589509061936252,
                0.6942546952139916,
                0.7279616763294247,
                0.7599943224419998,
                0.7902789574921218,
                0.8187459259226515,
                0.8453297528999303,
                0.8699692949264071,
                0.8926078805047389,
                0.9131934405428462,
                0.9316786282287494,
                0.9480209281684076,
                0.9621827547180553,
                0.9741315398335512,
                0.983839812187035,
                0.9912852761768016,
                0.9964509480618492,
                0.9993260970754129,
            ],
            "weights": [
                0.0017292582512998327,
                0.004021524172002136,
                0.006307942578972684,
                0.008580148266880501,
                0.01083267878959809,
                0.01306031163999467,
                0.015257912146448505,
                0.017420421997670153,
                0.019542865836750162,
                0.02162036128493398,
                0.023648129691287097,
                0.025621506938037816,
                0.027535954088450214,
                0.02938706778931075,
                0.03117059038018902,
                0.03288241967636875,
                0.03451861839854914,
                0.036075423225565256,
                0.03754925344825777,
                0.03893671920405134,
                0.040234629273005716,
                0.041439998417240366,
                0.042550054246755994,
                0.04356224359580069,
                0.044474238395083104,
                0.04528394102630035,
                0.04598948914665186,
                0.04658925997223365,
                0.04708187401045469,
                0.04746619823288566,
                0.047741348681240775,
                0.047906692500496006,
                0.047961849394466745,
                0.047906692500496006,
                0.047741348681240775,
                0.04746619823288566,
                0.04708187401045469,
                0.04658925997223365,
                0.04598948914665186,
                0.04528394102630035,
                0.044474238395083104,
                0.04356224359580069,
                0.042550054246755994,
                0.041439998417240366,
                0.040234629273005716,
                0.03893671920405134,
                0.03754925344825777,
                0.036075423225565256,
                0.03451861839854914,
                0.03288241967636875,
                0.03117059038018902,
                0.02938706778931075,
                0.027535954088450214,
                0.025621506938037816,
                0.023648129691287097,
                0.02162036128493398,
                0.019542865836750162,
                0.017420421997670153,
                0.015257912146448505,
                0.01306031163999467,
                0.01083267878959809,
                0.008580148266880501,
                0.006307942578972684,
                0.004021524172002136,
                0.0017292582512998327,
            ],
            "generator": "gauss_legendre",
        },
        66: {
            "degree": 131,
            "points": [
                -0.9993462098721778,
                -0.9965568210895527,
                -0.9915450303833757,
                -0.9843209049351401,
                -0.9749004277462859,
                -0.9633045868592574,
                -0.9495592462062353,
                -0.9336950725447924,
                -0.915747462945207,
                -0.8957564644465639,
                -0.8737666841669447,
                -0.8498271895360162,
                -0.8239913986955876,
                -0.7963169612458245,
                -0.7668656295753196,
                -0.7357031210495129,
                -0.7028989713588742,
                -0.6685263793509676,
                -0.6326620436909631,
                -0.5953859917141384,
                -0.5567814008517231,
                -0.5169344130282315,
                -0.47593394244423687,
                -0.43387147717337066,
                -0.3908408750161829,
                -0.34693815406633755,
                -0.3022612784564361,
                -0.2569099397615302,
                -0.210985334548079,
                -0.1645899385647146,
                -0.11782727807867599,
                -0.0708016988681416,
                -0.023618133385924566,
                0.023618133385924566,
                0.0708016988681416,
                0.11782727807867599,
                0.1645899385647146,
                0.210985334548079,
                0.2569099397615302,
                0.3022612784564361,
                0.34693815406633755,
                0.3908408750161829,
                0.43387147717337066,
                0.47593394244423687,
                0.5169344130282315,
                0.5567814008517231,
                0.5953859917141384,
                0.6326620436909631,
                0.6685263793509676,
                0.7028989713588742,
                0.7357031210495129,
                0.7668656295753196,
                0.7963169612458245,
                0.8239913986955876,
                0.8498271895360162,
                0.8737666841669447,
                0.8957564644465639,
                0.915747462945207,
                0.9336950725447924,
                0.9495592462062353,
                0.9633045868592574,
                0.9749004277462859,
                0.9843209049351401,
                0.9915450303833757,
                0.9965568210895527,
                0.9993462098721778,
            ],
            "weights": [
                0.0016776537440131765,
                0.0039016256417437967,
                0.006120192018448194,
                0.008325388765990637,
                0.010512065987705365,
                0.012675303981261599,
                0.014810265002733906,
                0.016912181472245418,
                0.018976361722770996,
                0.020998199091864487,
                0.022973181735326666,
                0.02489690251475713,
                0.026765068754249843,
                0.028573511782931882,
                0.030318196218868592,
                0.031995228964046725,
                0.03360086788611207,
                0.03513153016547228,
                0.036583800288138964,
                0.03795443766594144,
                0.03924038386682804,
                0.040438769438954685,
                0.04154692031324164,
                0.04256236377005552,
                0.04348283395666718,
                0.044306276943152874,
                0.04503085530544121,
                0.04565495222527288,
                0.04617717509791573,
                0.04659635863958383,
                0.04691156748762055,
                0.04712209828764447,
                0.04722748126299827,
                0.04722748126299827,
                0.04712209828764447,
                0.04691156748762055,
                0.04659635863958383,
                0.04617717509791573,
                0.04565495222527288,
                0.04503085530544121,
                0.044306276943152874,
                0.04348283395666718,
                0.04256236377005552,
                0.04154692031324164,
                0.040438769438954685,
                0.03924038386682804,
                0.03795443766594144,
                0.036583800288138964,
                0.03513153016547228,
                0.03360086788611207,
                0.031995228964046725,
                0.030318196218868592,
                0.028573511782931882,
                0.026765068754249843,
                0.02489690251475713,
                0.022973181735326666,
                0.020998199091864487,
                0.018976361722770996,
                0.016912181472245418,
                0.014810265002733906,
                0.012675303981261599,
                0.010512065987705365,
                0.008325388765990637,
                0.006120192018448194,
                0.0039016256417437967,
                0.0016776537440131765,
            ],
            "generator": "gauss_legendre",
        },
        67: {
            "degree": 133,
            "points": [
                -0.9993654355529769,
                -0.9966580272061137,
                -0.9917933470823096,
                -0.9847808477559511,
                -0.9756355839229081,
                -0.9643773304277126,
                -0.9510304595401454,
                -0.9356238732707509,
                -0.9181909368127386,
                -0.8987694049613204,
                -0.8774013398316587,
                -0.8541330195370507,
                -0.8290148378533012,
                -0.8021011950216944,
                -0.7734503798999803,
                -0.7431244437043663,
                -0.7111890656100404,
                -0.6777134104982808,
                -0.6427699791566154,
                -0.6064344512555574,
                -0.568785521441471,
                -0.529904728900236,
                -0.4898762807606466,
                -0.4487868697198909,
                -0.4067254862860139,
                -0.3637832260439542,
                -0.3200530923625363,
                -0.2756297949696896,
                -0.23060954483211574,
                -0.18508984578364018,
                -0.13916928335352372,
                -0.09294731125207989,
                -0.046524035976017224,
                0.0,
                0.046524035976017224,
                0.09294731125207989,
                0.13916928335352372,
                0.18508984578364018,
                0.23060954483211574,
                0.2756297949696896,
                0.3200530923625363,
                0.3637832260439542,
                0.4067254862860139,
                0.4487868697198909,
                0.4898762807606466,
                0.529904728900236,
                0.568785521441471,
                0.6064344512555574,
                0.6427699791566154,
                0.6777134104982808,
                0.7111890656100404,
                0.7431244437043663,
                0.7734503798999803,
                0.8021011950216944,
                0.8290148378533012,
                0.8541330195370507,
                0.8774013398316587,
                0.8987694049613204,
                0.9181909368127386,
                0.9356238732707509,
                0.9510304595401454,
                0.9643773304277126,
                0.9756355839229081,
                0.9847808477559511,
                0.9917933470823096,
                0.9966580272061137,
                0.9993654355529769,
            ],
            "weights": [
                0.0016283250352347757,
                0.0037870083018259203,
                0.0059406931775826755,
                0.008081790299023906,
                0.010205440034102347,
                0.012307003849289061,
                0.014381919827200057,
                0.016425690622530655,
                0.01843388845680485,
                0.020402163371343603,
                0.022326252196452245,
                0.024201987609673112,
                0.026025307086213253,
                0.02779226166243694,
                0.02949902447094573,
                0.031141899019472737,
                0.032717327191531385,
                0.03422189694953685,
                0.035652349722745016,
                0.03700558746349269,
                0.03827867935617967,
                0.039468868164309126,
                0.040573576201744635,
                0.04159041091519937,
                0.042517170065830695,
                0.04335184649869967,
                0.04409263248975118,
                0.04473792366088998,
                0.04528632245466974,
                0.045736641161063844,
                0.04608790448976174,
                0.046339351682415805,
                0.0464904381602648,
                0.0465408367035637,
                0.0464904381602648,
                0.046339351682415805,
                0.04608790448976174,
                0.045736641161063844,
                0.04528632245466974,
                0.04473792366088998,
                0.04409263248975118,
                0.04335184649869967,
                0.042517170065830695,
                0.04159041091519937,
                0.040573576201744635,
                0.039468868164309126,
                0.03827867935617967,
                0.03700558746349269,
                0.035652349722745016,
                0.03422189694953685,
                0.032717327191531385,
                0.031141899019472737,
                0.02949902447094573,
                0.02779226166243694,
                0.026025307086213253,
                0.024201987609673112,
                0.022326252196452245,
                0.020402163371343603,
                0.01843388845680485,
                0.016425690622530655,
                0.014381919827200057,
                0.012307003849289061,
                0.010205440034102347,
                0.008081790299023906,
                0.0059406931775826755,
                0.0037870083018259203,
                0.0016283250352347757,
            ],
            "generator": "gauss_legendre",
        },
        68: {
            "degree": 135,
            "points": [
                -0.9993838255297044,
                -0.9967548366766643,
                -0.9920308877424485,
                -0.9852208614402447,
                -0.976338950400357,
                -0.9654038025821998,
                -0.952438404479602,
                -0.9374700183128009,
                -0.9205301208479182,
                -0.9016543359201078,
                -0.8808823590174559,
                -0.8582578735826598,
                -0.8338284590416709,
                -0.8076454906897087,
                -0.7797640316188976,
                -0.7502427169029166,
                -0.719143630276473,
                -0.6865321735660129,
                -0.6524769291446769,
                -0.6170495156998834,
                -0.5803244376163508,
                -0.5423789282910034,
                -0.5032927877090849,
                -0.46314821462293904,
                -0.4220296336863136,
                -0.38002351790767447,
                -0.33721820679588077,
                -0.29370372058063876,
                -0.24957157089841672,
                -0.2049145683419393,
                -0.15982662727797897,
                -0.11440256834391069,
                -0.06873791903837714,
                -0.022928712825422352,
                0.022928712825422352,
                0.06873791903837714,
                0.11440256834391069,
                0.15982662727797897,
                0.2049145683419393,
                0.24957157089841672,
                0.29370372058063876,
                0.33721820679588077,
                0.38002351790767447,
                0.4220296336863136,
                0.46314821462293904,
                0.5032927877090849,
                0.5423789282910034,
                0.5803244376163508,
                0.6170495156998834,
                0.6524769291446769,
                0.6865321735660129,
                0.719143630276473,
                0.7502427169029166,
                0.7797640316188976,
                0.8076454906897087,
                0.8338284590416709,
                0.8582578735826598,
                0.8808823590174559,
                0.9016543359201078,
                0.9205301208479182,
                0.9374700183128009,
                0.952438404479602,
                0.9654038025821998,
                0.976338950400357,
                0.9852208614402447,
                0.9920308877424485,
                0.9967548366766643,
                0.9993838255297044,
            ],
            "weights": [
                0.0015811402563670584,
                0.003677366595010882,
                0.005768969918731274,
                0.007848711393176413,
                0.009912001251585405,
                0.011954462319769269,
                0.013971789174457669,
                0.01595973590961423,
                0.01791412045792314,
                0.019830832087955826,
                0.021705839610378082,
                0.023535199685876657,
                0.025315065045176697,
                0.027041692545904116,
                0.02871145102748529,
                0.03032082893855408,
                0.03186644171682134,
                0.03334503890398087,
                0.034753510979751934,
                0.03608889590018012,
                0.037348385326186874,
                0.03852933052910689,
                0.03962924796071256,
                0.04064582447595437,
                0.04157692219740321,
                0.04242058301114277,
                0.04317503268464448,
                0.043838684597956326,
                0.04441014308035301,
                0.04488820634542696,
                0.045271869018444114,
                0.045560324250648605,
                0.04575296541606825,
                0.04584938738725131,
                0.04584938738725131,
                0.04575296541606825,
                0.045560324250648605,
                0.045271869018444114,
                0.04488820634542696,
                0.04441014308035301,
                0.043838684597956326,
                0.04317503268464448,
                0.04242058301114277,
                0.04157692219740321,
                0.04064582447595437,
                0.03962924796071256,
                0.03852933052910689,
                0.037348385326186874,
                0.03608889590018012,
                0.034753510979751934,
                0.03334503890398087,
                0.03186644171682134,
                0.03032082893855408,
                0.02871145102748529,
                0.027041692545904116,
                0.025315065045176697,
                0.023535199685876657,
                0.021705839610378082,
                0.019830832087955826,
                0.01791412045792314,
                0.01595973590961423,
                0.013971789174457669,
                0.011954462319769269,
                0.009912001251585405,
                0.007848711393176413,
                0.005768969918731274,
                0.003677366595010882,
                0.0015811402563670584,
            ],
            "generator": "gauss_legendre",
        },
        69: {
            "degree": 137,
            "points": [
                -0.9994014275432448,
                -0.9968475004851951,
                -0.9922582667168531,
                -0.9856420800226375,
                -0.9770123316220942,
                -0.9663866216428606,
                -0.9537866478051819,
                -0.9392381470416085,
                -0.922770839180445,
                -0.9044183649858272,
                -0.8842182169472524,
                -0.8622116624727441,
                -0.8384436594805043,
                -0.8129627645002956,
                -0.7858210334467598,
                -0.7570739152558379,
                -0.7267801385960081,
                -0.6950015918829284,
                -0.6618031968410782,
                -0.6272527758698494,
                -0.5914209134845558,
                -0.554380812115132,
                -0.5162081425569337,
                -0.4769808893790457,
                -0.43677919160584444,
                -0.3956851789972444,
                -0.3537828042620663,
                -0.3111576715472812,
                -0.26789686155350345,
                -0.22408875363399902,
                -0.17982284524064318,
                -0.135189569085683,
                -0.09028010839282874,
                -0.045186210615101724,
                0.0,
                0.045186210615101724,
                0.09028010839282874,
                0.135189569085683,
                0.17982284524064318,
                0.22408875363399902,
                0.26789686155350345,
                0.3111576715472812,
                0.3537828042620663,
                0.3956851789972444,
                0.43677919160584444,
                0.4769808893790457,
                0.5162081425569337,
                0.554380812115132,
                0.5914209134845558,
                0.6272527758698494,
                0.6618031968410782,
                0.6950015918829284,
                0.7267801385960081,
                0.7570739152558379,
                0.7858210334467598,
                0.8129627645002956,
                0.8384436594805043,
                0.8622116624727441,
                0.8842182169472524,
                0.9044183649858272,
                0.922770839180445,
                0.9392381470416085,
                0.9537866478051819,
                0.9663866216428606,
                0.9770123316220942,
                0.9856420800226375,
                0.9922582667168531,
                0.9968475004851951,
                0.9994014275432448,
            ],
            "weights": [
                0.001535976952791426,
                0.00357241673939702,
                0.00560457992786983,
                0.007625555931201533,
                0.009631006150415377,
                0.011616796610671757,
                0.013578860649076019,
                0.015513186543406221,
                0.01741582123196991,
                0.019282877128849303,
                0.021110539639872025,
                0.022895074790740898,
                0.024632836784542582,
                0.026320275416869664,
                0.027953943312187562,
                0.02953050295790675,
                0.031046733517890536,
                0.03249953740964631,
                0.03388594663083226,
                0.03520312882168357,
                0.036448393050700585,
                0.037619195311641006,
                0.03871314372049259,
                0.03972800340176169,
                0.04066170105406173,
                0.04151232918565457,
                0.0422781500112806,
                0.042957599002305315,
                0.04354928808292679,
                0.04405200846590931,
                0.04446473312204719,
                0.04478661887831261,
                0.04501700814039987,
                0.04515543023614558,
                0.045201602377079986,
                0.04515543023614558,
                0.04501700814039987,
                0.04478661887831261,
                0.04446473312204719,
                0.04405200846590931,
                0.04354928808292679,
                0.042957599002305315,
                0.0422781500112806,
                0.04151232918565457,
                0.04066170105406173,
                0.03972800340176169,
                0.03871314372049259,
                0.037619195311641006,
                0.036448393050700585,
                0.03520312882168357,
                0.03388594663083226,
                0.03249953740964631,
                0.031046733517890536,
                0.02953050295790675,
                0.027953943312187562,
                0.026320275416869664,
                0.024632836784542582,
                0.022895074790740898,
                0.021110539639872025,
                0.019282877128849303,
                0.01741582123196991,
                0.015513186543406221,
                0.013578860649076019,
                0.011616796610671757,
                0.009631006150415377,
                0.007625555931201533,
                0.00560457992786983,
                0.00357241673939702,
                0.001535976952791426,
            ],
            "generator": "gauss_legendre",
        },
        70: {
            "degree": 139,
            "points": [
                -0.9994182859735758,
                -0.9969362519616801,
                -0.99247605521169,
                -0.9860455580703986,
                -0.9776574059575924,
                -0.9673282236649865,
                -0.9550785091142928,
                -0.9409325790038153,
                -0.9249185168979345,
                -0.9070681162609229,
                -0.8874168168633482,
                -0.8660036342138586,
                -0.8428710819989802,
                -0.8180650876254412,
                -0.7916349010078928,
                -0.7636329967718996,
                -0.7341149700609426,
                -0.7031394261515286,
                -0.6707678640940774,
                -0.6370645546097781,
                -0.6020964124853555,
                -0.5659328637188082,
                -0.5286457076797111,
                -0.4903089745576366,
                -0.45099877838164787,
                -0.4107931659026306,
                -0.3697719616384619,
                -0.3280166093896433,
                -0.2856100105400379,
                -0.24263635946374065,
                -0.19918097636485765,
                -0.15533013788207023,
                -0.1111709057942987,
                -0.06679095416755133,
                -0.022278395286140312,
                0.022278395286140312,
                0.06679095416755133,
                0.1111709057942987,
                0.15533013788207023,
                0.19918097636485765,
                0.24263635946374065,
                0.2856100105400379,
                0.3280166093896433,
                0.3697719616384619,
                0.4107931659026306,
                0.45099877838164787,
                0.4903089745576366,
                0.5286457076797111,
                0.5659328637188082,
                0.6020964124853555,
                0.6370645546097781,
                0.6707678640940774,
                0.7031394261515286,
                0.7341149700609426,
                0.7636329967718996,
                0.7916349010078928,
                0.8180650876254412,
                0.8428710819989802,
                0.8660036342138586,
                0.8874168168633482,
                0.9070681162609229,
                0.9249185168979345,
                0.9409325790038153,
                0.9550785091142928,
                0.9673282236649865,
                0.9776574059575924,
                0.9860455580703986,
                0.99247605521169,
                0.9969362519616801,
                0.9994182859735758,
            ],
            "weights": [
                0.0014927212888433063,
                0.003471894893079354,
                0.005447111874216002,
                0.007411769363190451,
                0.009361762769698311,
                0.011293184649931497,
                0.013202190814677075,
                0.015084987865443477,
                0.016937836376302633,
                0.018757057093133276,
                0.020539037824326575,
                0.022280240452256746,
                0.023977207889100613,
                0.02562657090846865,
                0.027225054818664274,
                0.028769485955808333,
                0.030256797980154376,
                0.031684037961308524,
                0.03304837223937246,
                0.03434709204990668,
                0.03557761890129241,
                0.036737509693672836,
                0.03782446156922297,
                0.03883631648407337,
                0.03977106549277658,
                0.04062685273678964,
                0.04140197912904528,
                0.042094905727284415,
                0.0427042567894498,
                0.04322882250506874,
                0.043667561397201474,
                0.044019602390183495,
                0.044284246539055466,
                0.04446096841724641,
                0.04454941715975472,
                0.04454941715975472,
                0.04446096841724641,
                0.044284246539055466,
                0.044019602390183495,
                0.043667561397201474,
                0.04322882250506874,
                0.0427042567894498,
                0.042094905727284415,
                0.04140197912904528,
                0.04062685273678964,
                0.03977106549277658,
                0.03883631648407337,
                0.03782446156922297,
                0.036737509693672836,
                0.03557761890129241,
                0.03434709204990668,
                0.03304837223937246,
                0.031684037961308524,
                0.030256797980154376,
                0.028769485955808333,
                0.027225054818664274,
                0.02562657090846865,
                0.023977207889100613,
                0.022280240452256746,
                0.020539037824326575,
                0.018757057093133276,
                0.016937836376302633,
                0.015084987865443477,
                0.013202190814677075,
                0.011293184649931497,
                0.009361762769698311,
                0.007411769363190451,
                0.005447111874216002,
                0.003471894893079354,
                0.0014927212888433063,
            ],
            "generator": "gauss_legendre",
        },
        71: {
            "degree": 141,
            "points": [
                -0.9994344421197369,
                -0.9970213082512551,
                -0.9926847848706416,
                -0.9864322772682613,
                -0.9782757361136017,
                -0.9682308774263253,
                -0.9563170810410528,
                -0.9425573399222712,
                -0.9269782122508714,
                -0.9096097689845344,
                -0.8904855353552066,
                -0.8696424259563074,
                -0.8471206733918739,
                -0.8229637505675528,
                -0.7972182867493179,
                -0.7699339775410367,
                -0.7411634889493769,
                -0.7109623557185444,
                -0.6793888741296445,
                -0.6465039894707877,
                -0.6123711783946824,
                -0.5770563263905198,
                -0.5406276006064874,
                -0.5031553182682901,
                -0.46471181094759784,
                -0.42537128494236953,
                -0.3852096780385273,
                -0.344304512929447,
                -0.3027347475761914,
                -0.26058062279731864,
                -0.21792350738245334,
                -0.17484574102858486,
                -0.1314304754022661,
                -0.08776151363450069,
                -0.043923148558135325,
                0.0,
                0.043923148558135325,
                0.08776151363450069,
                0.1314304754022661,
                0.17484574102858486,
                0.21792350738245334,
                0.26058062279731864,
                0.3027347475761914,
                0.344304512929447,
                0.3852096780385273,
                0.42537128494236953,
                0.46471181094759784,
                0.5031553182682901,
                0.5406276006064874,
                0.5770563263905198,
                0.6123711783946824,
                0.6465039894707877,
                0.6793888741296445,
                0.7109623557185444,
                0.7411634889493769,
                0.7699339775410367,
                0.7972182867493179,
                0.8229637505675528,
                0.8471206733918739,
                0.8696424259563074,
                0.8904855353552066,
                0.9096097689845344,
                0.9269782122508714,
                0.9425573399222712,
                0.9563170810410528,
                0.9682308774263253,
                0.9782757361136017,
                0.9864322772682613,
                0.9926847848706416,
                0.9970213082512551,
                0.9994344421197369,
            ],
            "weights": [
                0.0014512673300332772,
                0.003375555496731194,
                0.005296182844025117,
                0.0072068352818319935,
                0.009103626461992543,
                0.010982860154298297,
                0.012840899668088109,
                0.01467415533461093,
                0.01647908720746238,
                0.018252210704678543,
                0.019990102932349815,
                0.021689409135985615,
                0.023346849109223397,
                0.024959223494313666,
                0.02652341994215781,
                0.028036419111741394,
                0.029495300493708566,
                0.03089724804509056,
                0.03223955562344347,
                0.03351963220945385,
                0.03473500690768202,
                0.0358833337156487,
                0.03696239605198189,
                0.03797011103483097,
                0.038904533502262736,
                0.03976385976685745,
                0.04054643109724669,
                0.04125073691986588,
                0.04187541773473282,
                0.042419267739624386,
                0.04288123715758022,
                0.0432604342632411,
                0.04355612710410835,
                0.04376774491340195,
                0.04389487921178838,
                0.043937284595852145,
                0.04389487921178838,
                0.04376774491340195,
                0.04355612710410835,
                0.0432604342632411,
                0.04288123715758022,
                0.042419267739624386,
                0.04187541773473282,
                0.04125073691986588,
                0.04054643109724669,
                0.03976385976685745,
                0.038904533502262736,
                0.03797011103483097,
                0.03696239605198189,
                0.0358833337156487,
                0.03473500690768202,
                0.03351963220945385,
                0.03223955562344347,
                0.03089724804509056,
                0.029495300493708566,
                0.028036419111741394,
                0.02652341994215781,
                0.024959223494313666,
                0.023346849109223397,
                0.021689409135985615,
                0.019990102932349815,
                0.018252210704678543,
                0.01647908720746238,
                0.01467415533461093,
                0.012840899668088109,
                0.010982860154298297,
                0.009103626461992543,
                0.0072068352818319935,
                0.005296182844025117,
                0.003375555496731194,
                0.0014512673300332772,
            ],
            "generator": "gauss_legendre",
        },
        72: {
            "degree": 143,
            "points": [
                -0.9994499344529626,
                -0.997102871642729,
                -0.992884951016802,
                -0.9868031523758305,
                -0.9788687785572338,
                -0.9690966979987804,
                -0.9575052475776983,
                -0.9441161852725379,
                -0.928954645880918,
                -0.9120490926886715,
                -0.8934312635880912,
                -0.8731361112987789,
                -0.8512017376544379,
                -0.8276693220227543,
                -0.8025830439692918,
                -0.7759900002999826,
                -0.7479401166328323,
                -0.718486053662235,
                -0.6876831082904677,
                -0.6555891098112011,
                -0.6222643113394681,
                -0.5877712766916556,
                -0.5521747629277144,
                -0.5155415987760036,
                -0.47794055916894046,
                -0.43944223612496075,
                -0.40011890621916163,
                -0.36004439489141926,
                -0.3192939378467122,
                -0.2779440398078476,
                -0.23607233088575993,
                -0.19375742083702607,
                -0.15107875148221003,
                -0.10811644756210281,
                -0.06495116631185711,
                -0.02166394603542405,
                0.02166394603542405,
                0.06495116631185711,
                0.10811644756210281,
                0.15107875148221003,
                0.19375742083702607,
                0.23607233088575993,
                0.2779440398078476,
                0.3192939378467122,
                0.36004439489141926,
                0.40011890621916163,
                0.43944223612496075,
                0.47794055916894046,
                0.5155415987760036,
                0.5521747629277144,
                0.5877712766916556,
                0.6222643113394681,
                0.6555891098112011,
                0.6876831082904677,
                0.718486053662235,
                0.7479401166328323,
                0.7759900002999826,
                0.8025830439692918,
                0.8276693220227543,
                0.8512017376544379,
                0.8731361112987789,
                0.8934312635880912,
                0.9120490926886715,
                0.928954645880918,
                0.9441161852725379,
                0.9575052475776983,
                0.9690966979987804,
                0.9788687785572338,
                0.9868031523758305,
                0.992884951016802,
                0.997102871642729,
                0.9994499344529626,
            ],
            "weights": [
                0.0014115163939784783,
                0.003283169774667923,
                0.005151436018788564,
                0.007010272321861315,
                0.008855996073706261,
                0.01068510816535226,
                0.012494165619873158,
                0.014279769054554373,
                0.01603856495028501,
                0.017767250789200207,
                0.01946258086329457,
                0.021121372216440656,
                0.022740510555035693,
                0.02431695606441899,
                0.025847749100656032,
                0.027330015738950907,
                0.028760973164701855,
                0.030137934895375446,
                0.031458315822561686,
                0.03271963706429363,
                0.03391953061828609,
                0.03505574380721771,
                0.03612614350763786,
                0.03712872015450266,
                0.038061591513801986,
                0.03892300621616951,
                0.03971134704483473,
                0.04042513397173381,
                0.04106302693607495,
                0.04162382836013845,
                0.042106485397586324,
                0.042510091910057585,
                0.04283389016833869,
                0.0430772722749136,
                0.04323978130522252,
                0.04332111216548643,
                0.04332111216548643,
                0.04323978130522252,
                0.0430772722749136,
                0.04283389016833869,
                0.042510091910057585,
                0.042106485397586324,
                0.04162382836013845,
                0.04106302693607495,
                0.04042513397173381,
                0.03971134704483473,
                0.03892300621616951,
                0.038061591513801986,
                0.03712872015450266,
                0.03612614350763786,
                0.03505574380721771,
                0.03391953061828609,
                0.03271963706429363,
                0.031458315822561686,
                0.030137934895375446,
                0.028760973164701855,
                0.027330015738950907,
                0.025847749100656032,
                0.02431695606441899,
                0.022740510555035693,
                0.021121372216440656,
                0.01946258086329457,
                0.017767250789200207,
                0.01603856495028501,
                0.014279769054554373,
                0.012494165619873158,
                0.01068510816535226,
                0.008855996073706261,
                0.007010272321861315,
                0.005151436018788564,
                0.003283169774667923,
                0.0014115163939784783,
            ],
            "generator": "gauss_legendre",
        },
        73: {
            "degree": 145,
            "points": [
                -0.9994647988458811,
                -0.9971811307716113,
                -0.9930770155889451,
                -0.9871590366249321,
                -0.9794378920564837,
                -0.9699276590549859,
                -0.9586457006979743,
                -0.9456126216894836,
                -0.9308522273812245,
                -0.9143914791762564,
                -0.8962604448466912,
                -0.8764922434206515,
                -0.8551229845942995,
                -0.8321917027249097,
                -0.8077402855027359,
                -0.7818133974216448,
                -0.7544583981833235,
                -0.7257252561815598,
                -0.6956664572232627,
                -0.6643369086521963,
                -0.6317938390501184,
                -0.598096693698271,
                -0.5633070259900165,
                -0.527488384992871,
                -0.490706199365252,
                -0.45302765783994536,
                -0.41452158649257576,
                -0.3752583230192515,
                -0.3353095882530225,
                -0.2947483551538368,
                -0.2536487155113014,
                -0.21208574460373053,
                -0.17013536406070076,
                -0.1278742031796143,
                -0.0853794589495963,
                -0.04272875503841399,
                0.0,
                0.04272875503841399,
                0.0853794589495963,
                0.1278742031796143,
                0.17013536406070076,
                0.21208574460373053,
                0.2536487155113014,
                0.2947483551538368,
                0.3353095882530225,
                0.3752583230192515,
                0.41452158649257576,
                0.45302765783994536,
                0.490706199365252,
                0.527488384992871,
                0.5633070259900165,
                0.598096693698271,
                0.6317938390501184,
                0.6643369086521963,
                0.6956664572232627,
                0.7257252561815598,
                0.7544583981833235,
                0.7818133974216448,
                0.8077402855027359,
                0.8321917027249097,
                0.8551229845942995,
                0.8764922434206515,
                0.8962604448466912,
                0.9143914791762564,
                0.9308522273812245,
                0.9456126216894836,
                0.9586457006979743,
                0.9699276590549859,
                0.9794378920564837,
                0.9871590366249321,
                0.9930770155889451,
                0.9971811307716113,
                0.9994647988458811,
            ],
            "weights": [
                0.0013733764627644432,
                0.0031945243772877638,
                0.005012538571607,
                0.006821631349175216,
                0.008618310479532027,
                0.01039926099500079,
                0.01216122092928036,
                0.013900968788314648,
                0.015615325433591655,
                0.017301158762488854,
                0.01895538904867009,
                0.020574994420361033,
                0.022157016317039948,
                0.023698564864219087,
                0.025196824137538276,
                0.026649057298727193,
                0.02805261159057182,
                0.029404923180116477,
                0.030703521840433436,
                0.03194603546197667,
                0.033130194385043714,
                0.03425383554530198,
                0.03531490642472817,
                0.03631146880069752,
                0.037241702286349536,
                0.03810390765573971,
                0.03889650994769659,
                0.03961806134270594,
                0.040267243807559805,
                0.04084287150293863,
                0.04134389294952528,
                0.04176939294869268,
                0.042118594254255466,
                0.042390858992231384,
                0.04258568982601819,
                0.042702730864857,
                0.04274176831392337,
                0.042702730864857,
                0.04258568982601819,
                0.042390858992231384,
                0.042118594254255466,
                0.04176939294869268,
                0.04134389294952528,
                0.04084287150293863,
                0.040267243807559805,
                0.03961806134270594,
                0.03889650994769659,
                0.03810390765573971,
                0.037241702286349536,
                0.03631146880069752,
                0.03531490642472817,
                0.03425383554530198,
                0.033130194385043714,
                0.03194603546197667,
                0.030703521840433436,
                0.029404923180116477,
                0.02805261159057182,
                0.026649057298727193,
                0.025196824137538276,
                0.023698564864219087,
                0.022157016317039948,
                0.020574994420361033,
                0.01895538904867009,
                0.017301158762488854,
                0.015615325433591655,
                0.013900968788314648,
                0.01216122092928036,
                0.01039926099500079,
                0.008618310479532027,
                0.006821631349175216,
                0.005012538571607,
                0.0031945243772877638,
                0.0013733764627644432,
            ],
            "generator": "gauss_legendre",
        },
        74: {
            "degree": 147,
            "points": [
                -0.9994790687803295,
                -0.9972562617110163,
                -0.993261409804645,
                -0.9875007266162386,
                -0.9799843454313003,
                -0.9707256040425187,
                -0.9597409554595289,
                -0.947049926428385,
                -0.9326750794620545,
                -0.9166419716429065,
                -0.8989791087618958,
                -0.8797178944520888,
                -0.8588925742659835,
                -0.8365401747428157,
                -0.8127004375519744,
                -0.7874157488195755,
                -0.7607310637589945,
                -0.7326938267368803,
                -0.7033538869154419,
                -0.6727634096202476,
                -0.6409767835906924,
                -0.6080505242777798,
                -0.5740431733609942,
                -0.5390151946628171,
                -0.5030288666458852,
                -0.4661481716838812,
                -0.4284386823030033,
                -0.38996744459625077,
                -0.35080285901779806,
                -0.31101455876939066,
                -0.2706732859949804,
                -0.22985076600371704,
                -0.18861957974491858,
                -0.1470530347617534,
                -0.10522503485307097,
                -0.0632099486751163,
                -0.021082477516748306,
                0.021082477516748306,
                0.0632099486751163,
                0.10522503485307097,
                0.1470530347617534,
                0.18861957974491858,
                0.22985076600371704,
                0.2706732859949804,
                0.31101455876939066,
                0.35080285901779806,
                0.38996744459625077,
                0.4284386823030033,
                0.4661481716838812,
                0.5030288666458852,
                0.5390151946628171,
                0.5740431733609942,
                0.6080505242777798,
                0.6409767835906924,
                0.6727634096202476,
                0.7033538869154419,
                0.7326938267368803,
                0.7607310637589945,
                0.7874157488195755,
                0.8127004375519744,
                0.8365401747428157,
                0.8588925742659835,
                0.8797178944520888,
                0.8989791087618958,
                0.9166419716429065,
                0.9326750794620545,
                0.947049926428385,
                0.9597409554595289,
                0.9707256040425187,
                0.9799843454313003,
                0.9875007266162386,
                0.993261409804645,
                0.9972562617110163,
                0.9994790687803295,
            ],
            "weights": [
                0.0013367616500667935,
                0.0031094201498985704,
                0.004879179758594387,
                0.006640492909114192,
                0.008390045433971857,
                0.010124694538287148,
                0.011841347547500014,
                0.013536949411787206,
                0.015208484243401491,
                0.016852979582024634,
                0.018467511308979938,
                0.020049208702794957,
                0.02159525948167598,
                0.023102914774915953,
                0.024569493995942555,
                0.02599238960072368,
                0.027369071719679484,
                0.028697092653269814,
                0.029974091222461186,
                0.031197796965915504,
                0.0323660341762169,
                0.03347672576782886,
                0.034527896969826416,
                0.035517678836801035,
                0.036444311571658596,
                0.03730614765439422,
                0.03810165477126334,
                0.038829418539137704,
                0.03948814502019651,
                0.04007666302247699,
                0.04059392618219479,
                0.04103901482412732,
                0.04141113759675357,
                0.04170963287924085,
                0.041933969957777095,
                0.042083749969157036,
                0.04215870660994349,
                0.04215870660994349,
                0.042083749969157036,
                0.041933969957777095,
                0.04170963287924085,
                0.04141113759675357,
                0.04103901482412732,
                0.04059392618219479,
                0.04007666302247699,
                0.03948814502019651,
                0.038829418539137704,
                0.03810165477126334,
                0.03730614765439422,
                0.036444311571658596,
                0.035517678836801035,
                0.034527896969826416,
                0.03347672576782886,
                0.0323660341762169,
                0.031197796965915504,
                0.029974091222461186,
                0.028697092653269814,
                0.027369071719679484,
                0.02599238960072368,
                0.024569493995942555,
                0.023102914774915953,
                0.02159525948167598,
                0.020049208702794957,
                0.018467511308979938,
                0.016852979582024634,
                0.015208484243401491,
                0.013536949411787206,
                0.011841347547500014,
                0.010124694538287148,
                0.008390045433971857,
                0.006640492909114192,
                0.004879179758594387,
                0.0031094201498985704,
                0.0013367616500667935,
            ],
            "generator": "gauss_legendre",
        },
        75: {
            "degree": 149,
            "points": [
                -0.9994927755360354,
                -0.9973284289622318,
                -0.9934385365788927,
                -0.9878289667675245,
                -0.9805093245974166,
                -0.9714922563430638,
                -0.9607933637418923,
                -0.9484311650792874,
                -0.9344270599641071,
                -0.9188052912283939,
                -0.9015929025484463,
                -0.8828196914478955,
                -0.8625181576268834,
                -0.840723446654958,
                -0.8174732891035413,
                -0.7928079352135635,
                -0.7667700852066419,
                -0.7394048153580325,
                -0.7107594999580411,
                -0.6808837292962696,
                -0.6498292238102622,
                -0.617649744546926,
                -0.5844010000915779,
                -0.5501405501256456,
                -0.5149277057799166,
                -0.47882342695580316,
                -0.4418902167923483,
                -0.4041920134616536,
                -0.36579407948003595,
                -0.3267628887265263,
                -0.28716601136429726,
                -0.24707199686423476,
                -0.2065502553331596,
                -0.16567093735213784,
                -0.12450481253290026,
                -0.083123147002611,
                -0.041597580029079456,
                0.0,
                0.041597580029079456,
                0.083123147002611,
                0.12450481253290026,
                0.16567093735213784,
                0.2065502553331596,
                0.24707199686423476,
                0.28716601136429726,
                0.3267628887265263,
                0.36579407948003595,
                0.4041920134616536,
                0.4418902167923483,
                0.47882342695580316,
                0.5149277057799166,
                0.5501405501256456,
                0.5844010000915779,
                0.617649744546926,
                0.6498292238102622,
                0.6808837292962696,
                0.7107594999580411,
                0.7394048153580325,
                0.7667700852066419,
                0.7928079352135635,
                0.8174732891035413,
                0.840723446654958,
                0.8625181576268834,
                0.8828196914478955,
                0.9015929025484463,
                0.9188052912283939,
                0.9344270599641071,
                0.9484311650792874,
                0.9607933637418923,
                0.9714922563430638,
                0.9805093245974166,
                0.9878289667675245,
                0.9934385365788927,
                0.9973284289622318,
                0.9994927755360354,
            ],
            "weights": [
                0.0013015917173756495,
                0.0030276710146050255,
                0.004751069185015929,
                0.006466464907037747,
                0.008170710707328405,
                0.009860824916114168,
                0.01153387332830483,
                0.013186956762824862,
                0.014817212289814584,
                0.016421817119024986,
                0.01799799312564532,
                0.01954301152012805,
                0.021054197512282775,
                0.022528934913865935,
                0.023964670653716904,
                0.025358919190216336,
                0.026709266810120903,
                0.028013375804780655,
                0.029268988515725975,
                0.030473931242214446,
                0.03162611800374956,
                0.032723554150934066,
                0.03376433981833399,
                0.03474667321333029,
                0.03566885373524038,
                0.03652928491929027,
                0.03732647720033201,
                0.03805905049151351,
                0.03872573657343249,
                0.03932538128963505,
                0.039856946544656255,
                0.04031951210114148,
                0.04071227717293726,
                0.04103456181139203,
                0.041285808082467096,
                0.04146558103261901,
                0.04157356944178118,
                0.041609586362141314,
                0.04157356944178118,
                0.04146558103261901,
                0.041285808082467096,
                0.04103456181139203,
                0.04071227717293726,
                0.04031951210114148,
                0.039856946544656255,
                0.03932538128963505,
                0.03872573657343249,
                0.03805905049151351,
                0.03732647720033201,
                0.03652928491929027,
                0.03566885373524038,
                0.03474667321333029,
                0.03376433981833399,
                0.032723554150934066,
                0.03162611800374956,
                0.030473931242214446,
                0.029268988515725975,
                0.028013375804780655,
                0.026709266810120903,
                0.025358919190216336,
                0.023964670653716904,
                0.022528934913865935,
                0.021054197512282775,
                0.01954301152012805,
                0.01799799312564532,
                0.016421817119024986,
                0.014817212289814584,
                0.013186956762824862,
                0.01153387332830483,
                0.009860824916114168,
                0.008170710707328405,
                0.006466464907037747,
                0.004751069185015929,
                0.0030276710146050255,
                0.0013015917173756495,
            ],
            "generator": "gauss_legendre",
        },
        76: {
            "degree": 151,
            "points": [
                -0.9995059483621531,
                -0.9973977863553555,
                -0.993608772723527,
                -0.9881444533598375,
                -0.9810139389756559,
                -0.9722292285203769,
                -0.9618051267587678,
                -0.9497592077108964,
                -0.9361117819348108,
                -0.9208858612521501,
                -0.9041071195455668,
                -0.8858038492920828,
                -0.8660069137719819,
                -0.8447496949833424,
                -0.8220680373289746,
                -0.7980001871612001,
                -0.7725867282818097,
                -0.7458705135036104,
                -0.7178965923877036,
                -0.6887121352776406,
                -0.6583663537581427,
                -0.6269104176722665,
                -0.594397368836793,
                -0.5608820316012375,
                -0.5264209204012426,
                -0.4910721444621939,
                -0.45489530981372633,
                -0.4179514187803273,
                -0.38030276711750444,
                -0.34201283896696205,
                -0.3031461998079078,
                -0.26376838758499427,
                -0.22394580219647414,
                -0.18374559352891448,
                -0.14323554822726753,
                -0.10248397539122703,
                -0.06155959139061121,
                -0.020531403993998637,
                0.020531403993998637,
                0.06155959139061121,
                0.10248397539122703,
                0.14323554822726753,
                0.18374559352891448,
                0.22394580219647414,
                0.26376838758499427,
                0.3031461998079078,
                0.34201283896696205,
                0.38030276711750444,
                0.4179514187803273,
                0.45489530981372633,
                0.4910721444621939,
                0.5264209204012426,
                0.5608820316012375,
                0.594397368836793,
                0.6269104176722665,
                0.6583663537581427,
                0.6887121352776406,
                0.7178965923877036,
                0.7458705135036104,
                0.7725867282818097,
                0.7980001871612001,
                0.8220680373289746,
                0.8447496949833424,
                0.8660069137719819,
                0.8858038492920828,
                0.9041071195455668,
                0.9208858612521501,
                0.9361117819348108,
                0.9497592077108964,
                0.9618051267587678,
                0.9722292285203769,
                0.9810139389756559,
                0.9881444533598375,
                0.993608772723527,
                0.9973977863553555,
                0.9995059483621531,
            ],
            "weights": [
                0.0012677916340801453,
                0.0029491029536403484,
                0.00462793522803766,
                0.006299180497328108,
                0.007959847477239289,
                0.009607105414714554,
                0.01123816856966751,
                0.012850283847510175,
                0.014440731748276592,
                0.01600682991224884,
                0.01754593729147493,
                0.019055458467190707,
                0.020532847967908028,
                0.021975614534416394,
                0.02338132530701144,
                0.02474760992065992,
                0.026072164497986272,
                0.027352755531827692,
                0.028587223650054207,
                0.029773487255905142,
                0.03090954603749171,
                0.03199348434042196,
                0.03302347439779197,
                0.03399777941205664,
                0.034914756483551135,
                0.03577285938071427,
                0.036570641147329934,
                0.03730675654238187,
                0.03797996430840554,
                0.03858912926450697,
                0.03913322422051868,
                0.03961133170906238,
                0.040022645532597115,
                0.04036647212284434,
                0.040642231710295004,
                0.04084945930182883,
                0.04098780546479425,
                0.04105703691622975,
                0.04105703691622975,
                0.04098780546479425,
                0.04084945930182883,
                0.040642231710295004,
                0.04036647212284434,
                0.040022645532597115,
                0.03961133170906238,
                0.03913322422051868,
                0.03858912926450697,
                0.03797996430840554,
                0.03730675654238187,
                0.036570641147329934,
                0.03577285938071427,
                0.034914756483551135,
                0.03399777941205664,
                0.03302347439779197,
                0.03199348434042196,
                0.03090954603749171,
                0.029773487255905142,
                0.028587223650054207,
                0.027352755531827692,
                0.026072164497986272,
                0.02474760992065992,
                0.02338132530701144,
                0.021975614534416394,
                0.020532847967908028,
                0.019055458467190707,
                0.01754593729147493,
                0.01600682991224884,
                0.014440731748276592,
                0.012850283847510175,
                0.01123816856966751,
                0.009607105414714554,
                0.007959847477239289,
                0.006299180497328108,
                0.00462793522803766,
                0.0029491029536403484,
                0.0012677916340801453,
            ],
            "generator": "gauss_legendre",
        },
        77: {
            "degree": 153,
            "points": [
                -0.99951861463341,
                -0.9974644778692141,
                -0.9937724709498782,
                -0.9884478382225613,
                -0.9814992273311385,
                -0.9729380307491085,
                -0.9627783064677343,
                -0.9510367436005919,
                -0.9377326319590611,
                -0.9228878293594022,
                -0.9065267253212578,
                -0.8886762008255641,
                -0.8693655840677341,
                -0.848626602229624,
                -0.8264933293290021,
                -0.8030021302229252,
                -0.7781916008525431,
                -0.7521025048252159,
                -0.7247777064369118,
                -0.6962621002442422,
                -0.6666025373014515,
                -0.6358477481833124,
                -0.6040482629202574,
                -0.5712563279771983,
                -0.5375258204123777,
                -0.5029121593572515,
                -0.46747221496281177,
                -0.4312642149619357,
                -0.39434764900126357,
                -0.35678317089978107,
                -0.3186324989946873,
                -0.27995831473827615,
                -0.2408241597124322,
                -0.20129433122994436,
                -0.16143377669416092,
                -0.12130798689055258,
                -0.08098288838550313,
                -0.040524735209115925,
                0.0,
                0.040524735209115925,
                0.08098288838550313,
                0.12130798689055258,
                0.16143377669416092,
                0.20129433122994436,
                0.2408241597124322,
                0.27995831473827615,
                0.3186324989946873,
                0.35678317089978107,
                0.39434764900126357,
                0.4312642149619357,
                0.46747221496281177,
                0.5029121593572515,
                0.5375258204123777,
                0.5712563279771983,
                0.6040482629202574,
                0.6358477481833124,
                0.6666025373014515,
                0.6962621002442422,
                0.7247777064369118,
                0.7521025048252159,
                0.7781916008525431,
                0.8030021302229252,
                0.8264933293290021,
                0.848626602229624,
                0.8693655840677341,
                0.8886762008255641,
                0.9065267253212578,
                0.9228878293594022,
                0.9377326319590611,
                0.9510367436005919,
                0.9627783064677343,
                0.9729380307491085,
                0.9814992273311385,
                0.9884478382225613,
                0.9937724709498782,
                0.9974644778692141,
                0.99951861463341,
            ],
            "weights": [
                0.0012352911771443755,
                0.002873553083652651,
                0.004509523600207086,
                0.0061382961597557534,
                0.007757025950082721,
                0.009363023692385841,
                0.01095364285391132,
                0.01252626736922723,
                0.01407831234002644,
                0.015607227268749212,
                0.017110499906531396,
                0.018585660248341247,
                0.020030284534315834,
                0.021441999205456093,
                0.02281848479012957,
                0.024157479707955787,
                0.025456783981694316,
                0.026714262849557826,
                0.02792785027127678,
                0.029095552321768633,
                0.030215450466622867,
                0.03128570471390527,
                0.032304556637030864,
                0.03327033226369833,
                0.03418144482611557,
                0.035036397367978055,
                0.03583378520391182,
                0.03657229822732728,
                0.03725072306289348,
                0.037867945060089156,
                0.03842295012455434,
                0.03891482638423363,
                0.03934276568756996,
                0.03970606493128912,
                0.040004127215591045,
                0.040236462824850903,
                0.04040269003221754,
                0.04050253572678786,
                0.04053583586232543,
                0.04050253572678786,
                0.04040269003221754,
                0.040236462824850903,
                0.040004127215591045,
                0.03970606493128912,
                0.03934276568756996,
                0.03891482638423363,
                0.03842295012455434,
                0.037867945060089156,
                0.03725072306289348,
                0.03657229822732728,
                0.03583378520391182,
                0.035036397367978055,
                0.03418144482611557,
                0.03327033226369833,
                0.032304556637030864,
                0.03128570471390527,
                0.030215450466622867,
                0.029095552321768633,
                0.02792785027127678,
                0.026714262849557826,
                0.025456783981694316,
                0.024157479707955787,
                0.02281848479012957,
                0.021441999205456093,
                0.020030284534315834,
                0.018585660248341247,
                0.017110499906531396,
                0.015607227268749212,
                0.01407831234002644,
                0.01252626736922723,
                0.01095364285391132,
                0.009363023692385841,
                0.007757025950082721,
                0.0061382961597557534,
                0.004509523600207086,
                0.002873553083652651,
                0.0012352911771443755,
            ],
            "generator": "gauss_legendre",
        },
        78: {
            "degree": 155,
            "points": [
                -0.9995307999924238,
                -0.9975286383787244,
                -0.9939299616944888,
                -0.9887397320937175,
                -0.9819661630995505,
                -0.9736200785062364,
                -0.9637148359867559,
                -0.9522662946898633,
                -0.9392927869149466,
                -0.9248150877800638,
                -0.9088563815731883,
                -0.8914422244588186,
                -0.8726005034727246,
                -0.8523613918225577,
                -0.8307573005459112,
                -0.8078228265942017,
                -0.7835946974211427,
                -0.7581117121623153,
                -0.7314146794988304,
                -0.7035463523039238,
                -0.6745513591767508,
                -0.6444761329727928,
                -0.6133688364451848,
                -0.5812792851159517,
                -0.5482588675006126,
                -0.514360462813864,
                -0.47963835628810725,
                -0.4441481522404086,
                -0.4079466850270984,
                -0.37109192802859625,
                -0.3336429008102106,
                -0.29565957460758013,
                -0.25720277628811244,
                -0.21833409094221198,
                -0.17911576326028916,
                -0.1396105978534836,
                -0.09988185867772842,
                -0.0599931677222177,
                -0.02000840312451792,
                0.02000840312451792,
                0.0599931677222177,
                0.09988185867772842,
                0.1396105978534836,
                0.17911576326028916,
                0.21833409094221198,
                0.25720277628811244,
                0.29565957460758013,
                0.3336429008102106,
                0.37109192802859625,
                0.4079466850270984,
                0.4441481522404086,
                0.47963835628810725,
                0.514360462813864,
                0.5482588675006126,
                0.5812792851159517,
                0.6133688364451848,
                0.6444761329727928,
                0.6745513591767508,
                0.7035463523039238,
                0.7314146794988304,
                0.7581117121623153,
                0.7835946974211427,
                0.8078228265942017,
                0.8307573005459112,
                0.8523613918225577,
                0.8726005034727246,
                0.8914422244588186,
                0.9088563815731883,
                0.9248150877800638,
                0.9392927869149466,
                0.9522662946898633,
                0.9637148359867559,
                0.9736200785062364,
                0.9819661630995505,
                0.9887397320937175,
                0.9939299616944888,
                0.9975286383787244,
                0.9995307999924238,
            ],
            "weights": [
                0.0012040245660638238,
                0.002800868811836366,
                0.004395596039459112,
                0.005983489944440028,
                0.007561843189439228,
                0.00912809922725498,
                0.010679742157481381,
                0.012214284549790273,
                0.01372926792014474,
                0.015222265680178565,
                0.01669088668934382,
                0.01813277895498232,
                0.019545633343399878,
                0.020927187251878147,
                0.022275228219114214,
                0.02358759746145774,
                0.02486219332622279,
                0.02609697465510898,
                0.02728996405162444,
                0.02843925104689755,
                0.02954299515860712,
                0.030599428838013334,
                0.031606860300304934,
                0.03256367623368934,
                0.03346834438285924,
                0.03431941600268937,
                0.035115528178217434,
                0.03585540600719192,
                0.036537864641684945,
                0.037161811185498696,
                0.037726246444324485,
                0.038230266525851264,
                0.038673064287257954,
                0.03905393062777367,
                0.03937225562423342,
                0.03962752950781081,
                0.039819343480364366,
                0.039947390369088336,
                0.04001146511842077,
                0.04001146511842077,
                0.039947390369088336,
                0.039819343480364366,
                0.03962752950781081,
                0.03937225562423342,
                0.03905393062777367,
                0.038673064287257954,
                0.038230266525851264,
                0.037726246444324485,
                0.037161811185498696,
                0.036537864641684945,
                0.03585540600719192,
                0.035115528178217434,
                0.03431941600268937,
                0.03346834438285924,
                0.03256367623368934,
                0.031606860300304934,
                0.030599428838013334,
                0.02954299515860712,
                0.02843925104689755,
                0.02728996405162444,
                0.02609697465510898,
                0.02486219332622279,
                0.02358759746145774,
                0.022275228219114214,
                0.020927187251878147,
                0.019545633343399878,
                0.01813277895498232,
                0.01669088668934382,
                0.015222265680178565,
                0.01372926792014474,
                0.012214284549790273,
                0.010679742157481381,
                0.00912809922725498,
                0.007561843189439228,
                0.005983489944440028,
                0.004395596039459112,
                0.002800868811836366,
                0.0012040245660638238,
            ],
            "generator": "gauss_legendre",
        },
        79: {
            "degree": 157,
            "points": [
                -0.9995425284795698,
                -0.9975903943369414,
                -0.9940815547855426,
                -0.9890207076877844,
                -0.9824156592512789,
                -0.9742766995978072,
                -0.9646165291148647,
                -0.9534502278892691,
                -0.9407952293065772,
                -0.9266712918809039,
                -0.9111004680345809,
                -0.8941070695042351,
                -0.8757176293035295,
                -0.8559608602552193,
                -0.8348676101377779,
                -0.8124708135078068,
                -0.7888054402691977,
                -0.7639084410671702,
                -0.7378186895912782,
                -0.7105769218768242,
                -0.6822256726990711,
                -0.652809209159344,
                -0.6223734615665772,
                -0.59096595172214,
                -0.558635718719859,
                -0.5254332423770546,
                -0.49141036441611985,
                -0.4566202075196891,
                -0.42111709238577194,
                -0.38495645291235087,
                -0.3481947496438679,
                -0.31088938161473645,
                -0.27309859672752357,
                -0.23488140080573192,
                -0.19629746546318466,
                -0.1574070349338616,
                -0.11827083200766088,
                -0.07894996321895441,
                -0.039505823435974065,
                0.0,
                0.039505823435974065,
                0.07894996321895441,
                0.11827083200766088,
                0.1574070349338616,
                0.19629746546318466,
                0.23488140080573192,
                0.27309859672752357,
                0.31088938161473645,
                0.3481947496438679,
                0.38495645291235087,
                0.42111709238577194,
                0.4566202075196891,
                0.49141036441611985,
                0.5254332423770546,
                0.558635718719859,
                0.59096595172214,
                0.6223734615665772,
                0.652809209159344,
                0.6822256726990711,
                0.7105769218768242,
                0.7378186895912782,
                0.7639084410671702,
                0.7888054402691977,
                0.8124708135078068,
                0.8348676101377779,
                0.8559608602552193,
                0.8757176293035295,
                0.8941070695042351,
                0.9111004680345809,
                0.9266712918809039,
                0.9407952293065772,
                0.9534502278892691,
                0.9646165291148647,
                0.9742766995978072,
                0.9824156592512789,
                0.9890207076877844,
                0.9940815547855426,
                0.9975903943369414,
                0.9995425284795698,
            ],
            "weights": [
                0.0011739301299596256,
                0.002730907065755578,
                0.004285929113126977,
                0.005834459868762667,
                0.007373921131330134,
                0.008901880982651968,
                0.010415946204513391,
                0.01191375021511702,
                0.013392953344825874,
                0.014851245526349678,
                0.016286349576191416,
                0.017696024624310306,
                0.019078069558937517,
                0.02043032643814102,
                0.021750683846607985,
                0.023037080185718796,
                0.024287506888799538,
                0.025500011555128772,
                0.026672700997105663,
                0.027803744195446917,
                0.028891375157607153,
                0.029933895674838146,
                0.030929677973524743,
                0.03187716725661119,
                0.0327748841311307,
                0.0336214269180308,
                0.034415473840676475,
                0.035155785088611086,
                0.0358412047533456,
                0.03647066263315337,
                0.03704317590404666,
                0.03755785065432963,
                0.03801388328032593,
                0.03841056174110401,
                0.03874726667023985,
                0.03902347234287968,
                0.03923874749659457,
                0.03939275600474293,
                0.03948525740129104,
                0.03951610725627119,
                0.03948525740129104,
                0.03939275600474293,
                0.03923874749659457,
                0.03902347234287968,
                0.03874726667023985,
                0.03841056174110401,
                0.03801388328032593,
                0.03755785065432963,
                0.03704317590404666,
                0.03647066263315337,
                0.0358412047533456,
                0.035155785088611086,
                0.034415473840676475,
                0.0336214269180308,
                0.0327748841311307,
                0.03187716725661119,
                0.030929677973524743,
                0.029933895674838146,
                0.028891375157607153,
                0.027803744195446917,
                0.026672700997105663,
                0.025500011555128772,
                0.024287506888799538,
                0.023037080185718796,
                0.021750683846607985,
                0.02043032643814102,
                0.019078069558937517,
                0.017696024624310306,
                0.016286349576191416,
                0.014851245526349678,
                0.013392953344825874,
                0.01191375021511702,
                0.010415946204513391,
                0.008901880982651968,
                0.007373921131330134,
                0.005834459868762667,
                0.004285929113126977,
                0.002730907065755578,
                0.0011739301299596256,
            ],
            "generator": "gauss_legendre",
        },
        80: {
            "degree": 159,
            "points": [
                -0.9995538226516306,
                -0.9976498643982377,
                -0.9942275409656882,
                -0.9892913024997555,
                -0.9828485727386291,
                -0.9749091405857278,
                -0.9654850890437993,
                -0.9545907663436349,
                -0.9422427613098727,
                -0.9284598771724458,
                -0.9132631025717577,
                -0.8966755794387706,
                -0.8787225676782139,
                -0.859431406663111,
                -0.8388314735802553,
                -0.8169541386814635,
                -0.7938327175046055,
                -0.7695024201350413,
                -0.7440002975835973,
                -0.7173651853620999,
                -0.6896376443420276,
                -0.6608598989861199,
                -0.631075773046872,
                -0.6003306228297517,
                -0.5686712681227097,
                -0.536145920897132,
                -0.5028041118887849,
                -0.4686966151705445,
                -0.4338753708317561,
                -0.39839340588196925,
                -0.3623047534994873,
                -0.32566437074770194,
                -0.28852805488451183,
                -0.25095235839227215,
                -0.21299450285766613,
                -0.1747122918326468,
                -0.1361640228091439,
                -0.09740839844158461,
                -0.058504437152420666,
                -0.019511383256793996,
                0.019511383256793996,
                0.058504437152420666,
                0.09740839844158461,
                0.1361640228091439,
                0.1747122918326468,
                0.21299450285766613,
                0.25095235839227215,
                0.28852805488451183,
                0.32566437074770194,
                0.3623047534994873,
                0.39839340588196925,
                0.4338753708317561,
                0.4686966151705445,
                0.5028041118887849,
                0.536145920897132,
                0.5686712681227097,
                0.6003306228297517,
                0.631075773046872,
                0.6608598989861199,
                0.6896376443420276,
                0.7173651853620999,
                0.7440002975835973,
                0.7695024201350413,
                0.7938327175046055,
                0.8169541386814635,
                0.8388314735802553,
                0.859431406663111,
                0.8787225676782139,
                0.8966755794387706,
                0.9132631025717577,
                0.9284598771724458,
                0.9422427613098727,
                0.9545907663436349,
                0.9654850890437993,
                0.9749091405857278,
                0.9828485727386291,
                0.9892913024997555,
                0.9942275409656882,
                0.9976498643982377,
                0.9995538226516306,
            ],
            "weights": [
                0.0011449500031885224,
                0.002663533589513713,
                0.004180313124695047,
                0.005690922451403673,
                0.007192904768117152,
                0.008683945269261395,
                0.010161766041102983,
                0.011624114120797644,
                0.013068761592400866,
                0.014493508040508975,
                0.015896183583725406,
                0.01727465205626924,
                0.018626814208298613,
                0.019950610878142407,
                0.021244026115781908,
                0.02250509024633233,
                0.02373188286592992,
                0.024922535764115357,
                0.02607523576756492,
                0.027188227500486207,
                0.028259816057276736,
                0.02928836958326768,
                0.030272321759557783,
                0.03121017418811484,
                0.03210049867348784,
                0.03294193939764526,
                0.03373321498461144,
                0.034473120451753846,
                0.03516052904474753,
                0.035794393953415986,
                0.03637374990583587,
                0.03689771463827592,
                0.03736549023873043,
                0.03777636436200133,
                0.03812971131447754,
                0.03842499300695934,
                0.038661759774076425,
                0.03883965105905189,
                0.03895839596276948,
                0.03901781365630659,
                0.03901781365630659,
                0.03895839596276948,
                0.03883965105905189,
                0.038661759774076425,
                0.03842499300695934,
                0.03812971131447754,
                0.03777636436200133,
                0.03736549023873043,
                0.03689771463827592,
                0.03637374990583587,
                0.035794393953415986,
                0.03516052904474753,
                0.034473120451753846,
                0.03373321498461144,
                0.03294193939764526,
                0.03210049867348784,
                0.03121017418811484,
                0.030272321759557783,
                0.02928836958326768,
                0.028259816057276736,
                0.027188227500486207,
                0.02607523576756492,
                0.024922535764115357,
                0.02373188286592992,
                0.02250509024633233,
                0.021244026115781908,
                0.019950610878142407,
                0.018626814208298613,
                0.01727465205626924,
                0.015896183583725406,
                0.014493508040508975,
                0.013068761592400866,
                0.011624114120797644,
                0.010161766041102983,
                0.008683945269261395,
                0.007192904768117152,
                0.005690922451403673,
                0.004180313124695047,
                0.002663533589513713,
                0.0011449500031885224,
            ],
            "generator": "gauss_legendre",
        },
        81: {
            "degree": 161,
            "points": [
                -0.999564703690319,
                -0.9977071599883465,
                -0.9943681932852199,
                -0.989552021371022,
                -0.9832657085664303,
                -0.9755185726723613,
                -0.9663221163380561,
                -0.9556899997564026,
                -0.9436380176528139,
                -0.9301840749151675,
                -0.9153481596407507,
                -0.8991523132861565,
                -0.8816205978467202,
                -0.8627790600697919,
                -0.842655692736467,
                -0.8212803930609103,
                -0.7986849182650283,
                -0.7749028383924235,
                -0.7499694864306207,
                -0.7239219058150526,
                -0.6967987953924356,
                -0.6686404519250901,
                -0.6394887102214946,
                -0.6093868809819365,
                -0.5783796864515514,
                -0.5465131939763113,
                -0.5138347475606582,
                -0.48039289752844827,
                -0.44623732839169905,
                -0.4114187850342975,
                -0.3759889973203313,
                -0.34000060323904835,
                -0.30350707070062616,
                -0.26656261809893533,
                -0.2292221337593161,
                -0.19154109439104286,
                -0.15357548266563065,
                -0.11538170404343671,
                -0.07701650297212717,
                -0.03853687858151199,
                0.0,
                0.03853687858151199,
                0.07701650297212717,
                0.11538170404343671,
                0.15357548266563065,
                0.19154109439104286,
                0.2292221337593161,
                0.26656261809893533,
                0.30350707070062616,
                0.34000060323904835,
                0.3759889973203313,
                0.4114187850342975,
                0.44623732839169905,
                0.48039289752844827,
                0.5138347475606582,
                0.5465131939763113,
                0.5783796864515514,
                0.6093868809819365,
                0.6394887102214946,
                0.6686404519250901,
                0.6967987953924356,
                0.7239219058150526,
                0.7499694864306207,
                0.7749028383924235,
                0.7986849182650283,
                0.8212803930609103,
                0.842655692736467,
                0.8627790600697919,
                0.8816205978467202,
                0.8991523132861565,
                0.9153481596407507,
                0.9301840749151675,
                0.9436380176528139,
                0.9556899997564026,
                0.9663221163380561,
                0.9755185726723613,
                0.9832657085664303,
                0.989552021371022,
                0.9943681932852199,
                0.9977071599883465,
                0.999564703690319,
            ],
            "weights": [
                0.0011170298471264706,
                0.0025986222999291124,
                0.004078551113421077,
                0.005552611370256507,
                0.007018460484931308,
                0.008473893785345623,
                0.009916741809595911,
                0.011344858495415893,
                0.012756121115134281,
                0.01414843251323594,
                0.015519723912464287,
                0.016867957867635133,
                0.01819113124125582,
                0.019487278155601962,
                0.02075447290144578,
                0.0219908327927516,
                0.0231945209602738,
                0.024363749078562858,
                0.025496780021665697,
                0.026591930443220103,
                0.027647573276924874,
                0.028662140153560632,
                0.02963412373090553,
                0.030562079933052735,
                0.03144463009577403,
                0.03228046301473259,
                0.033068336893488044,
                0.03380708118839621,
                0.034495598347659764,
                0.03513286544193938,
                0.03571793568410447,
                0.03624993983586338,
                0.03672808749918039,
                0.037151668290563655,
                0.03752005289647575,
                0.037832694008300465,
                0.03808912713547551,
                0.03828897129558344,
                0.038431929580375085,
                0.0385177895968846,
                0.0385464237829806,
                0.0385177895968846,
                0.038431929580375085,
                0.03828897129558344,
                0.03808912713547551,
                0.037832694008300465,
                0.03752005289647575,
                0.037151668290563655,
                0.03672808749918039,
                0.03624993983586338,
                0.03571793568410447,
                0.03513286544193938,
                0.034495598347659764,
                0.03380708118839621,
                0.033068336893488044,
                0.03228046301473259,
                0.03144463009577403,
                0.030562079933052735,
                0.02963412373090553,
                0.028662140153560632,
                0.027647573276924874,
                0.026591930443220103,
                0.025496780021665697,
                0.024363749078562858,
                0.0231945209602738,
                0.0219908327927516,
                0.02075447290144578,
                0.019487278155601962,
                0.01819113124125582,
                0.016867957867635133,
                0.015519723912464287,
                0.01414843251323594,
                0.012756121115134281,
                0.011344858495415893,
                0.009916741809595911,
                0.008473893785345623,
                0.007018460484931308,
                0.005552611370256507,
                0.004078551113421077,
                0.0025986222999291124,
                0.0011170298471264706,
            ],
            "generator": "gauss_legendre",
        },
        82: {
            "degree": 163,
            "points": [
                -0.9995751915016526,
                -0.9977623858263859,
                -0.9945037683780756,
                -0.989803338839909,
                -0.9836678235220077,
                -0.9761060970944988,
                -0.9671291162525907,
                -0.9567498938616109,
                -0.9449834774389605,
                -0.9318469264546229,
                -0.9173592872532801,
                -0.9015415652888412,
                -0.8844166945967247,
                -0.8660095045047654,
                -0.8463466836129137,
                -0.8254567410857676,
                -0.8033699653101083,
                -0.7801183799753583,
                -0.7557356976395604,
                -0.7302572708475963,
                -0.7037200408721667,
                -0.676162484151647,
                -0.6476245565023466,
                -0.6181476351859787,
                -0.5877744589162849,
                -0.5565490658917638,
                -0.5245167299443277,
                -0.4917238948964493,
                -0.4582181072219632,
                -0.42404794710815075,
                -0.3892629580190548,
                -0.3539135748621479,
                -0.3180510508625015,
                -0.2817273832504801,
                -0.24499523787070454,
                -0.20790787282159234,
                -0.17051906123619015,
                -0.13288301331625751,
                -0.09505429773264487,
                -0.05708776250592693,
                -0.019038455482006812,
                0.019038455482006812,
                0.05708776250592693,
                0.09505429773264487,
                0.13288301331625751,
                0.17051906123619015,
                0.20790787282159234,
                0.24499523787070454,
                0.2817273832504801,
                0.3180510508625015,
                0.3539135748621479,
                0.3892629580190548,
                0.42404794710815075,
                0.4582181072219632,
                0.4917238948964493,
                0.5245167299443277,
                0.5565490658917638,
                0.5877744589162849,
                0.6181476351859787,
                0.6476245565023466,
                0.676162484151647,
                0.7037200408721667,
                0.7302572708475963,
                0.7557356976395604,
                0.7801183799753583,
                0.8033699653101083,
                0.8254567410857676,
                0.8463466836129137,
                0.8660095045047654,
                0.8844166945967247,
                0.9015415652888412,
                0.9173592872532801,
                0.9318469264546229,
                0.9449834774389605,
                0.9567498938616109,
                0.9671291162525907,
                0.9761060970944988,
                0.9836678235220077,
                0.989803338839909,
                0.9945037683780756,
                0.9977623858263859,
                0.9995751915016526,
            ],
            "weights": [
                0.0010901185952767803,
                0.0025360546968549685,
                0.003980457937855649,
                0.005419276232446696,
                0.006850274534182072,
                0.008271351818383853,
                0.009680440704371174,
                0.011075495781759743,
                0.012454493401141952,
                0.013815433714126713,
                0.01515634327076275,
                0.01647527776398398,
                0.01777032479849845,
                0.019039606640178973,
                0.020281282926912392,
                0.021493553330775163,
                0.02267466016491411,
                0.023822890930047733,
                0.024936580796240927,
                0.026014115016016928,
                0.02705393126512474,
                0.028054521907454194,
                0.02901443618076433,
                0.02993228230001264,
                0.03080672947521564,
                0.031636509840900384,
                0.0324204202943407,
                0.03315732423990723,
                0.03384615323699694,
                0.034485908549150714,
                0.035075662592112714,
                0.03561456027872756,
                0.036101820258727046,
                0.03653673605160773,
                0.03691867707095447,
                0.03724708953872771,
                0.03752149728818508,
                0.037741502454275884,
                0.037906786050505854,
                0.03801710843143529,
                0.03807230964014191,
                0.03807230964014191,
                0.03801710843143529,
                0.037906786050505854,
                0.037741502454275884,
                0.03752149728818508,
                0.03724708953872771,
                0.03691867707095447,
                0.03653673605160773,
                0.036101820258727046,
                0.03561456027872756,
                0.035075662592112714,
                0.034485908549150714,
                0.03384615323699694,
                0.03315732423990723,
                0.0324204202943407,
                0.031636509840900384,
                0.03080672947521564,
                0.02993228230001264,
                0.02901443618076433,
                0.028054521907454194,
                0.02705393126512474,
                0.026014115016016928,
                0.024936580796240927,
                0.023822890930047733,
                0.02267466016491411,
                0.021493553330775163,
                0.020281282926912392,
                0.019039606640178973,
                0.01777032479849845,
                0.01647527776398398,
                0.01515634327076275,
                0.013815433714126713,
                0.012454493401141952,
                0.011075495781759743,
                0.009680440704371174,
                0.008271351818383853,
                0.006850274534182072,
                0.005419276232446696,
                0.003980457937855649,
                0.0025360546968549685,
                0.0010901185952767803,
            ],
            "generator": "gauss_legendre",
        },
        83: {
            "degree": 165,
            "points": [
                -0.9995853048070493,
                -0.99781564040343,
                -0.9946345076317803,
                -0.9900457012972652,
                -0.9840556295966815,
                -0.9766727500728429,
                -0.9679075054501287,
                -0.9577722991227671,
                -0.9462814750117909,
                -0.9334512964018387,
                -0.9192999225872079,
                -0.9038473830228995,
                -0.8871155489050634,
                -0.8691281021787169,
                -0.8499105019989338,
                -0.8294899486849843,
                -0.8078953452145896,
                -0.7851572563108158,
                -0.7613078651784587,
                -0.7363809279505643,
                -0.7104117259092174,
                -0.6834370155480218,
                -0.6554949765468238,
                -0.6266251577322394,
                -0.5968684211004183,
                -0.5662668839812408,
                -0.5348638594257853,
                -0.5027037949014261,
                -0.4698322093813203,
                -0.43629562891731927,
                -0.4021415207874887,
                -0.3674182263114404,
                -0.3321748924285642,
                -0.2964614021360032,
                -0.2603283038848259,
                -0.2238267400343274,
                -0.1870083744657227,
                -0.14992531945768683,
                -0.11263006192724032,
                -0.07517538914037727,
                -0.03761431399758438,
                0.0,
                0.03761431399758438,
                0.07517538914037727,
                0.11263006192724032,
                0.14992531945768683,
                0.1870083744657227,
                0.2238267400343274,
                0.2603283038848259,
                0.2964614021360032,
                0.3321748924285642,
                0.3674182263114404,
                0.4021415207874887,
                0.43629562891731927,
                0.4698322093813203,
                0.5027037949014261,
                0.5348638594257853,
                0.5662668839812408,
                0.5968684211004183,
                0.6266251577322394,
                0.6554949765468238,
                0.6834370155480218,
                0.7104117259092174,
                0.7363809279505643,
                0.7613078651784587,
                0.7851572563108158,
                0.8078953452145896,
                0.8294899486849843,
                0.8499105019989338,
                0.8691281021787169,
                0.8871155489050634,
                0.9038473830228995,
                0.9192999225872079,
                0.9334512964018387,
                0.9462814750117909,
                0.9577722991227671,
                0.9679075054501287,
                0.9766727500728429,
                0.9840556295966815,
                0.9900457012972652,
                0.9946345076317803,
                0.99781564040343,
                0.9995853048070493,
            ],
            "weights": [
                0.0010641682196673942,
                0.002475719322545105,
                0.0038858594353542953,
                0.005290681445860296,
                0.0066880516352437825,
                0.008075966593123287,
                0.009452455092480022,
                0.010815566558037566,
                0.012163370727798054,
                0.013493959512374957,
                0.014805449400717964,
                0.016095984011935644,
                0.017363736673824154,
                0.018606912985478705,
                0.019823753345654904,
                0.021012535437269896,
                0.022171576661803635,
                0.02329923651890052,
                0.02439391892715859,
                0.025454074482489278,
                0.026478202650673924,
                0.027464853890903054,
                0.028412631707247477,
                0.029320194625104455,
                0.03018625808981448,
                0.031009596284739156,
                0.03178904386622212,
                0.03252349761296801,
                0.03321191798750499,
                0.03385333060751519,
                0.034446827624950487,
                0.034991569010979565,
                0.03548678374494699,
                0.0359317709056606,
                0.036325900663462245,
                0.03666861517167802,
                0.036959429356184896,
                0.03719793160197668,
                0.03738378433575734,
                0.037516724503737234,
                0.03759656394395506,
                0.03762318965260004,
                0.03759656394395506,
                0.037516724503737234,
                0.03738378433575734,
                0.03719793160197668,
                0.036959429356184896,
                0.03666861517167802,
                0.036325900663462245,
                0.0359317709056606,
                0.03548678374494699,
                0.034991569010979565,
                0.034446827624950487,
                0.03385333060751519,
                0.03321191798750499,
                0.03252349761296801,
                0.03178904386622212,
                0.031009596284739156,
                0.03018625808981448,
                0.029320194625104455,
                0.028412631707247477,
                0.027464853890903054,
                0.026478202650673924,
                0.025454074482489278,
                0.02439391892715859,
                0.02329923651890052,
                0.022171576661803635,
                0.021012535437269896,
                0.019823753345654904,
                0.018606912985478705,
                0.017363736673824154,
                0.016095984011935644,
                0.014805449400717964,
                0.013493959512374957,
                0.012163370727798054,
                0.010815566558037566,
                0.009452455092480022,
                0.008075966593123287,
                0.0066880516352437825,
                0.005290681445860296,
                0.0038858594353542953,
                0.002475719322545105,
                0.0010641682196673942,
            ],
            "generator": "gauss_legendre",
        },
        84: {
            "degree": 167,
            "points": [
                -0.9995950612269232,
                -0.9978670164217119,
                -0.9947606382612846,
                -0.9902795289653566,
                -0.9844297971275817,
                -0.9772195073583158,
                -0.9686586181736219,
                -0.9587589587296934,
                -0.9475342099474431,
                -0.9349998847635588,
                -0.9211733063630512,
                -0.9060735840940084,
                -0.8897215869883155,
                -0.872139914883579,
                -0.8533528671689187,
                -0.8333864091900214,
                -0.812268136356123,
                -0.7900272359965969,
                -0.7666944470188363,
                -0.7423020174226099,
                -0.7168836597292748,
                -0.6904745043872484,
                -0.6631110512180146,
                -0.6348311189696915,
                -0.6056737930478334,
                -0.5756793714956742,
                -0.5448893092984497,
                -0.5133461610887614,
                -0.4810935223321562,
                -0.4481759690742023,
                -0.4146389963323312,
                -0.38052895521758867,
                -0.3458929888731971,
                -0.310778967318464,
                -0.27523542128808853,
                -0.23931147515830337,
                -0.20305677905255348,
                -0.16652144022054816,
                -0.12975595378552474,
                -0.09281113295543789,
                -0.05573803879452822,
                -0.018587909652332132,
                0.018587909652332132,
                0.05573803879452822,
                0.09281113295543789,
                0.12975595378552474,
                0.16652144022054816,
                0.20305677905255348,
                0.23931147515830337,
                0.27523542128808853,
                0.310778967318464,
                0.3458929888731971,
                0.38052895521758867,
                0.4146389963323312,
                0.4481759690742023,
                0.4810935223321562,
                0.5133461610887614,
                0.5448893092984497,
                0.5756793714956742,
                0.6056737930478334,
                0.6348311189696915,
                0.6631110512180146,
                0.6904745043872484,
                0.7168836597292748,
                0.7423020174226099,
                0.7666944470188363,
                0.7900272359965969,
                0.812268136356123,
                0.8333864091900214,
                0.8533528671689187,
                0.872139914883579,
                0.8897215869883155,
                0.9060735840940084,
                0.9211733063630512,
                0.9349998847635588,
                0.9475342099474431,
                0.9587589587296934,
                0.9686586181736219,
                0.9772195073583158,
                0.9844297971275817,
                0.9902795289653566,
                0.9947606382612846,
                0.9978670164217119,
                0.9995950612269232,
            ],
            "weights": [
                0.0010391335164544866,
                0.002417511265443844,
                0.003794591650452313,
                0.005166605182747508,
                0.006531513687712504,
                0.007887405752648421,
                0.009232400784190643,
                0.010564637623008208,
                0.01188227408980137,
                0.013183488679182651,
                0.014466482789161524,
                0.01572948309558371,
                0.016970743955211334,
                0.0181885497960566,
                0.0193812174773188,
                0.020547098609756394,
                0.021684581830644638,
                0.022792095028942052,
                0.023868107516958118,
                0.024911132145206252,
                0.025919727357334523,
                0.026892499182197528,
                0.027828103160258303,
                0.028725246201621677,
                0.029582688373110646,
                0.0303992446119023,
                0.03117378636334549,
                0.03190524314069258,
                0.03259260400458406,
                0.03323491896024033,
                0.033831300270425836,
                0.034380923682372534,
                0.034883029566963125,
                0.035336923968601074,
                0.035741979564315164,
                0.03609763653077238,
                0.03640340331800194,
                0.036658857328758884,
                0.03686364550259016,
                0.03701748480379434,
                0.037120162612601905,
                0.03717153701903387,
                0.03717153701903387,
                0.037120162612601905,
                0.03701748480379434,
                0.03686364550259016,
                0.036658857328758884,
                0.03640340331800194,
                0.03609763653077238,
                0.035741979564315164,
                0.035336923968601074,
                0.034883029566963125,
                0.034380923682372534,
                0.033831300270425836,
                0.03323491896024033,
                0.03259260400458406,
                0.03190524314069258,
                0.03117378636334549,
                0.0303992446119023,
                0.029582688373110646,
                0.028725246201621677,
                0.027828103160258303,
                0.026892499182197528,
                0.025919727357334523,
                0.024911132145206252,
                0.023868107516958118,
                0.022792095028942052,
                0.021684581830644638,
                0.020547098609756394,
                0.0193812174773188,
                0.0181885497960566,
                0.016970743955211334,
                0.01572948309558371,
                0.014466482789161524,
                0.013183488679182651,
                0.01188227408980137,
                0.010564637623008208,
                0.009232400784190643,
                0.007887405752648421,
                0.006531513687712504,
                0.005166605182747508,
                0.003794591650452313,
                0.002417511265443844,
                0.0010391335164544866,
            ],
            "generator": "gauss_legendre",
        },
        85: {
            "degree": 169,
            "points": [
                -0.9996044773574785,
                -0.997916601198117,
                -0.9948823742956163,
                -0.990505217716416,
                -0.9847909576855804,
                -0.9777472884122433,
                -0.9693837119236783,
                -0.9597115159571884,
                -0.948743756254579,
                -0.9364952381164307,
                -0.9229824960960901,
                -0.9082237715390918,
                -0.8922389878913559,
                -0.8750497237690971,
                -0.8566791838099562,
                -0.8371521673370826,
                -0.8164950348747916,
                -0.7947356725591165,
                -0.7719034544902931,
                -0.748029203077434,
                -0.723145147428601,
                -0.6972848798422495,
                -0.6704833104586627,
                -0.6427766201325147,
                -0.614202211590137,
                -0.5847986589373881,
                -0.5546056555862694,
                -0.5236639606705679,
                -0.4920153440228513,
                -0.4597025297870887,
                -0.4267691387430097,
                -0.3932596294200592,
                -0.35921923808043804,
                -0.32469391765224753,
                -0.28973027569517373,
                -0.2543755114824535,
                -0.21867735228405902,
                -0.18268398893711268,
                -0.146444010790511,
                -0.11000634011157723,
                -0.07342016604329113,
                -0.03673487820124966,
                0.0,
                0.03673487820124966,
                0.07342016604329113,
                0.11000634011157723,
                0.146444010790511,
                0.18268398893711268,
                0.21867735228405902,
                0.2543755114824535,
                0.28973027569517373,
                0.32469391765224753,
                0.35921923808043804,
                0.3932596294200592,
                0.4267691387430097,
                0.4597025297870887,
                0.4920153440228513,
                0.5236639606705679,
                0.5546056555862694,
                0.5847986589373881,
                0.614202211590137,
                0.6427766201325147,
                0.6704833104586627,
                0.6972848798422495,
                0.723145147428601,
                0.748029203077434,
                0.7719034544902931,
                0.7947356725591165,
                0.8164950348747916,
                0.8371521673370826,
                0.8566791838099562,
                0.8750497237690971,
                0.8922389878913559,
                0.9082237715390918,
                0.9229824960960901,
                0.9364952381164307,
                0.948743756254579,
                0.9597115159571884,
                0.9693837119236783,
                0.9777472884122433,
                0.9847909576855804,
                0.990505217716416,
                0.9948823742956163,
                0.997916601198117,
                0.9996044773574785,
            ],
            "weights": [
                0.0010149719089635016,
                0.002361331704283739,
                0.00370650012575929,
                0.00504683842692466,
                0.006380398587898551,
                0.007705355960383501,
                0.009019915439993585,
                0.010322300230523926,
                0.011610751286703781,
                0.012883528856498693,
                0.01413891454840072,
                0.015375213542389856,
                0.01659075683115459,
                0.017783903451398273,
                0.018953042688182795,
                0.020096596243575588,
                0.02121302036408954,
                0.022300807922839515,
                0.023358490452990027,
                0.024384640129435687,
                0.025377871695866173,
                0.026336844334514546,
                0.027260263476011272,
                0.028146882546865242,
                0.028995504652190272,
                0.02980498419139585,
                0.030574228404650208,
                0.03130219884802104,
                0.031987912795304836,
                0.03263044456464236,
                0.033228926768132896,
                0.033782551482757654,
                0.03429057134102996,
                0.03475230053990075,
                0.03516711576655591,
                0.03553445703985584,
                0.03585382846628094,
                0.03612479890936258,
                0.03634700257169532,
                0.03652013948874501,
                0.036643975933785815,
                0.03671834473341972,
                0.03674314549325224,
                0.03671834473341972,
                0.036643975933785815,
                0.03652013948874501,
                0.03634700257169532,
                0.03612479890936258,
                0.03585382846628094,
                0.03553445703985584,
                0.03516711576655591,
                0.03475230053990075,
                0.03429057134102996,
                0.033782551482757654,
                0.033228926768132896,
                0.03263044456464236,
                0.031987912795304836,
                0.03130219884802104,
                0.030574228404650208,
                0.02980498419139585,
                0.028995504652190272,
                0.028146882546865242,
                0.027260263476011272,
                0.026336844334514546,
                0.025377871695866173,
                0.024384640129435687,
                0.023358490452990027,
                0.022300807922839515,
                0.02121302036408954,
                0.020096596243575588,
                0.018953042688182795,
                0.017783903451398273,
                0.01659075683115459,
                0.015375213542389856,
                0.01413891454840072,
                0.012883528856498693,
                0.011610751286703781,
                0.010322300230523926,
                0.009019915439993585,
                0.007705355960383501,
                0.006380398587898551,
                0.00504683842692466,
                0.00370650012575929,
                0.002361331704283739,
                0.0010149719089635016,
            ],
            "generator": "gauss_legendre",
        },
        86: {
            "degree": 171,
            "points": [
                -0.9996135688413259,
                -0.9979644770352439,
                -0.9949999174853379,
                -0.9907231407455187,
                -0.9851397067325024,
                -0.9782569602536847,
                -0.9700839726857401,
                -0.9606315209428984,
                -0.9499120708522102,
                -0.9379397599098925,
                -0.924730378322862,
                -0.9103013480461658,
                -0.8946716997394464,
                -0.877862047633366,
                -0.8598945623226849,
                -0.8407929415144331,
                -0.8205823787661602,
                -0.7992895302536618,
                -0.7769424796110234,
                -0.7535707008888088,
                -0.7292050196789284,
                -0.7038775724572677,
                -0.6776217641975886,
                -0.6504722243125263,
                -0.6224647609797508,
                -0.593636313913498,
                -0.5640249056437413,
                -0.5336695913672487,
                -0.5026104074366573,
                -0.4708883185554978,
                -0.4385451637488091,
                -0.4056236011806004,
                -0.3721670518909396,
                -0.33821964252687264,
                -0.3038261471427057,
                -0.2690319281464103,
                -0.23388287647003747,
                -0.19842535104305142,
                -0.1627061176484117,
                -0.12677228724204825,
                -0.09067125381708016,
                -0.054450631894731205,
                -0.018158193724385818,
                0.018158193724385818,
                0.054450631894731205,
                0.09067125381708016,
                0.12677228724204825,
                0.1627061176484117,
                0.19842535104305142,
                0.23388287647003747,
                0.2690319281464103,
                0.3038261471427057,
                0.33821964252687264,
                0.3721670518909396,
                0.4056236011806004,
                0.4385451637488091,
                0.4708883185554978,
                0.5026104074366573,
                0.5336695913672487,
                0.5640249056437413,
                0.593636313913498,
                0.6224647609797508,
                0.6504722243125263,
                0.6776217641975886,
                0.7038775724572677,
                0.7292050196789284,
                0.7535707008888088,
                0.7769424796110234,
                0.7992895302536618,
                0.8205823787661602,
                0.8407929415144331,
                0.8598945623226849,
                0.877862047633366,
                0.8946716997394464,
                0.9103013480461658,
                0.924730378322862,
                0.9379397599098925,
                0.9499120708522102,
                0.9606315209428984,
                0.9700839726857401,
                0.9782569602536847,
                0.9851397067325024,
                0.9907231407455187,
                0.9949999174853379,
                0.9979644770352439,
                0.9996135688413259,
            ],
            "weights": [
                0.000991643266613615,
                0.0023070874888097494,
                0.003621439249611204,
                0.004931184096959908,
                0.0062344591391401884,
                0.00752952161219476,
                0.008814657101955246,
                0.010088168460386557,
                0.011348375156177821,
                0.012593614678070422,
                0.013822244452766613,
                0.015032643905081598,
                0.016223216549728865,
                0.017392392075690537,
                0.01853862840671017,
                0.019660413729562228,
                0.020756268484909128,
                0.02182474731692782,
                0.02286444097854821,
                0.023873978189479155,
                0.02485202744439993,
                0.02579729876883974,
                0.026708545420372348,
                0.02758456553285133,
                0.028424203701493757,
                0.02922635250671015,
                0.02998995397466509,
                0.030714000972632216,
                0.03139753853730298,
                0.03203966513429413,
                0.03263953384719009,
                0.03319635349455176,
                0.03370938967341773,
                0.034177965727920104,
                0.0346014636417379,
                0.03497932485321032,
                0.03531105099203437,
                0.03559620453657567,
                0.035834409390924214,
                0.03602535138093543,
                0.03616877866860084,
                0.03626450208420254,
                0.036312395375813475,
                0.036312395375813475,
                0.03626450208420254,
                0.03616877866860084,
                0.03602535138093543,
                0.035834409390924214,
                0.03559620453657567,
                0.03531105099203437,
                0.03497932485321032,
                0.0346014636417379,
                0.034177965727920104,
                0.03370938967341773,
                0.03319635349455176,
                0.03263953384719009,
                0.03203966513429413,
                0.03139753853730298,
                0.030714000972632216,
                0.02998995397466509,
                0.02922635250671015,
                0.028424203701493757,
                0.02758456553285133,
                0.026708545420372348,
                0.02579729876883974,
                0.02485202744439993,
                0.023873978189479155,
                0.02286444097854821,
                0.02182474731692782,
                0.020756268484909128,
                0.019660413729562228,
                0.01853862840671017,
                0.017392392075690537,
                0.016223216549728865,
                0.015032643905081598,
                0.013822244452766613,
                0.012593614678070422,
                0.011348375156177821,
                0.010088168460386557,
                0.008814657101955246,
                0.00752952161219476,
                0.0062344591391401884,
                0.004931184096959908,
                0.003621439249611204,
                0.0023070874888097494,
                0.000991643266613615,
            ],
            "generator": "gauss_legendre",
        },
        87: {
            "degree": 173,
            "points": [
                -0.9996223504324843,
                -0.9980107215629823,
                -0.995113458137992,
                -0.9909336501109646,
                -0.9854766060684204,
                -0.9787493410038163,
                -0.9707605197472843,
                -0.9615204369360731,
                -0.9510410013893136,
                -0.9393357199742057,
                -0.9264196798912372,
                -0.9123095290941229,
                -0.8970234547675694,
                -0.8805811598520419,
                -0.8630038376297066,
                -0.8443141443970352,
                -0.8245361702557805,
                -0.8036954080581777,
                -0.7818187205454378,
                -0.7589343057213493,
                -0.7350716605053138,
                -0.7102615427114729,
                -0.6845359314028236,
                -0.6579279856713494,
                -0.6304720018972505,
                -0.6022033695423352,
                -0.5731585255345304,
                -0.5433749073022933,
                -0.5128909045194523,
                -0.4817458096226668,
                -0.44997976716528437,
                -0.4176337220728691,
                -0.3847493668670969,
                -0.3513690879260413,
                -0.31753591085011573,
                -0.28329344500409187,
                -0.24868582730667713,
                -0.2137576653401016,
                -0.17855397985304422,
                -0.14312014673100815,
                -0.10750183850894277,
                -0.07174496550149943,
                -0.035895616626800894,
                0.0,
                0.035895616626800894,
                0.07174496550149943,
                0.10750183850894277,
                0.14312014673100815,
                0.17855397985304422,
                0.2137576653401016,
                0.24868582730667713,
                0.28329344500409187,
                0.31753591085011573,
                0.3513690879260413,
                0.3847493668670969,
                0.4176337220728691,
                0.44997976716528437,
                0.4817458096226668,
                0.5128909045194523,
                0.5433749073022933,
                0.5731585255345304,
                0.6022033695423352,
                0.6304720018972505,
                0.6579279856713494,
                0.6845359314028236,
                0.7102615427114729,
                0.7350716605053138,
                0.7589343057213493,
                0.7818187205454378,
                0.8036954080581777,
                0.8245361702557805,
                0.8443141443970352,
                0.8630038376297066,
                0.8805811598520419,
                0.8970234547675694,
                0.9123095290941229,
                0.9264196798912372,
                0.9393357199742057,
                0.9510410013893136,
                0.9615204369360731,
                0.9707605197472843,
                0.9787493410038163,
                0.9854766060684204,
                0.9909336501109646,
                0.995113458137992,
                0.9980107215629823,
                0.9996223504324843,
            ],
            "weights": [
                0.0009691097381757348,
                0.0022546907537549384,
                0.003539271655388117,
                0.004819456238501684,
                0.00609346204763528,
                0.007359623648817653,
                0.008616302838488783,
                0.009861877713702014,
                0.011094741940560695,
                0.012313306030048123,
                0.013515999118245947,
                0.0147012708872398,
                0.015867593518826113,
                0.017013463643001287,
                0.0181374042653544,
                0.01923796666535654,
                0.020313732260655384,
                0.021363314433802724,
                0.022385360318485367,
                0.02337855254266003,
                0.024341610926167583,
                0.025273294130557043,
                0.026172401258933563,
                0.027037773403735973,
                0.02786829514042919,
                0.028662895965176235,
                0.02942055167462312,
                0.03014028568601895,
                0.030821170295962166,
                0.031462327876150824,
                0.032062932004589706,
                0.03262220853080143,
                0.03313943657366203,
                0.03361394945057692,
                0.034045135536799345,
                0.03443243905378225,
                0.03477536078554787,
                0.03507345872215154,
                0.03532634862941022,
                0.03553370454416061,
                0.035695259194409426,
                0.03581080434383377,
                0.03588019106018702,
                0.03590332990726553,
                0.03588019106018702,
                0.03581080434383377,
                0.035695259194409426,
                0.03553370454416061,
                0.03532634862941022,
                0.03507345872215154,
                0.03477536078554787,
                0.03443243905378225,
                0.034045135536799345,
                0.03361394945057692,
                0.03313943657366203,
                0.03262220853080143,
                0.032062932004589706,
                0.031462327876150824,
                0.030821170295962166,
                0.03014028568601895,
                0.02942055167462312,
                0.028662895965176235,
                0.02786829514042919,
                0.027037773403735973,
                0.026172401258933563,
                0.025273294130557043,
                0.024341610926167583,
                0.02337855254266003,
                0.022385360318485367,
                0.021363314433802724,
                0.020313732260655384,
                0.01923796666535654,
                0.0181374042653544,
                0.017013463643001287,
                0.015867593518826113,
                0.0147012708872398,
                0.013515999118245947,
                0.012313306030048123,
                0.011094741940560695,
                0.009861877713702014,
                0.008616302838488783,
                0.007359623648817653,
                0.00609346204763528,
                0.004819456238501684,
                0.003539271655388117,
                0.0022546907537549384,
                0.0009691097381757348,
            ],
            "generator": "gauss_legendre",
        },
        88: {
            "degree": 175,
            "points": [
                -0.9996308360562707,
                -0.9980554080532497,
                -0.9952231758879889,
                -0.9911370781540155,
                -0.9858021860877636,
                -0.9792252031542967,
                -0.9714144101413222,
                -0.9623796460637707,
                -0.9521322934638021,
                -0.9406852633026436,
                -0.928052978394692,
                -0.9142513551045272,
                -0.899297783230057,
                -0.8832111040594506,
                -0.8660115866137813,
                -0.847720902098209,
                -0.8283620965904562,
                -0.8079595619992365,
                -0.7865390053282871,
                -0.7641274162842069,
                -0.7407530332686078,
                -0.7164453077972505,
                -0.6912348673908805,
                -0.6651534769844532,
                -0.6382339989033264,
                -0.610510351456819,
                -0.5820174662012874,
                -0.5527912439265554,
                -0.5228685094211437,
                -0.49228696507328673,
                -0.4610851433661965,
                -0.42930235832742436,
                -0.396978655993491,
                -0.3641547639521983,
                -0.3308720400261963,
                -0.2971724201624643,
                -0.2630983655933626,
                -0.2286928093358313,
                -0.1939991020961468,
                -0.1590609576483942,
                -0.12392239775547906,
                -0.08862769670207607,
                -0.053221325509403575,
                -0.017747895902112096,
                0.017747895902112096,
                0.053221325509403575,
                0.08862769670207607,
                0.12392239775547906,
                0.1590609576483942,
                0.1939991020961468,
                0.2286928093358313,
                0.2630983655933626,
                0.2971724201624643,
                0.3308720400261963,
                0.3641547639521983,
                0.396978655993491,
                0.42930235832742436,
                0.4610851433661965,
                0.49228696507328673,
                0.5228685094211437,
                0.5527912439265554,
                0.5820174662012874,
                0.610510351456819,
                0.6382339989033264,
                0.6651534769844532,
                0.6912348673908805,
                0.7164453077972505,
                0.7407530332686078,
                0.7641274162842069,
                0.7865390053282871,
                0.8079595619992365,
                0.8283620965904562,
                0.847720902098209,
                0.8660115866137813,
                0.8832111040594506,
                0.899297783230057,
                0.9142513551045272,
                0.928052978394692,
                0.9406852633026436,
                0.9521322934638021,
                0.9623796460637707,
                0.9714144101413222,
                0.9792252031542967,
                0.9858021860877636,
                0.9911370781540155,
                0.9952231758879889,
                0.9980554080532497,
                0.9996308360562707,
            ],
            "weights": [
                0.0009473355981601172,
                0.002204058563145238,
                0.003459867667861557,
                0.004711479279598937,
                0.00595718699613714,
                0.007195398459795966,
                0.008424547492703152,
                0.00964308332205318,
                0.010849469775429216,
                0.012042186439580964,
                0.013219730313628233,
                0.01438061760130026,
                0.015523385536933604,
                0.01664659420821771,
                0.017748828360324355,
                0.01882869917375565,
                0.01988484601127417,
                0.020915938130576784,
                0.021920676359989965,
                0.02289779473478103,
                0.023846062091859698,
                0.02476428362076878,
                0.02565130236896187,
                0.026506000699434765,
                0.027327301698855354,
                0.0281141705344086,
                0.02886561575763545,
                0.029580690553619438,
                0.03025849393394365,
                0.03089817187191218,
                0.03149891837860495,
                0.03205997651840641,
                0.03258063936273217,
                0.03306025088074669,
                0.03349820676595309,
                0.033893955197610286,
                0.03424699753602011,
                0.03455688895080718,
                0.03482323898139939,
                0.035045712029004306,
                0.0352240277794591,
                0.035357961556423886,
                0.035447344604470785,
                0.03549206430171453,
                0.03549206430171453,
                0.035447344604470785,
                0.035357961556423886,
                0.0352240277794591,
                0.035045712029004306,
                0.03482323898139939,
                0.03455688895080718,
                0.03424699753602011,
                0.033893955197610286,
                0.03349820676595309,
                0.03306025088074669,
                0.03258063936273217,
                0.03205997651840641,
                0.03149891837860495,
                0.03089817187191218,
                0.03025849393394365,
                0.029580690553619438,
                0.02886561575763545,
                0.0281141705344086,
                0.027327301698855354,
                0.026506000699434765,
                0.02565130236896187,
                0.02476428362076878,
                0.023846062091859698,
                0.02289779473478103,
                0.021920676359989965,
                0.020915938130576784,
                0.01988484601127417,
                0.01882869917375565,
                0.017748828360324355,
                0.01664659420821771,
                0.015523385536933604,
                0.01438061760130026,
                0.013219730313628233,
                0.012042186439580964,
                0.010849469775429216,
                0.00964308332205318,
                0.008424547492703152,
                0.007195398459795966,
                0.00595718699613714,
                0.004711479279598937,
                0.003459867667861557,
                0.002204058563145238,
                0.0009473355981601172,
            ],
            "generator": "gauss_legendre",
        },
        89: {
            "degree": 177,
            "points": [
                -0.9996390388645334,
                -0.998098605710274,
                -0.9953292404067497,
                -0.9913337388086653,
                -0.9861169478611037,
                -0.9796852765838766,
                -0.9720466427489094,
                -0.9632104546565354,
                -0.953187597292841,
                -0.9419904181702149,
                -0.9296327118237186,
                -0.9161297026888234,
                -0.9014980262839978,
                -0.88575570868447,
                -0.8689221442970837,
                -0.8510180719566774,
                -0.8320655493700791,
                -0.812087925937486,
                -0.7911098139837933,
                -0.7691570584348011,
                -0.74625670497536,
                -0.7224369667285082,
                -0.6977271894965399,
                -0.6721578156067596,
                -0.6457603464064199,
                -0.6185673034530191,
                -0.5906121884477524,
                -0.5619294419614643,
                -0.5325544010039439,
                -0.5025232554888296,
                -0.4718730036477532,
                -0.4406414064486518,
                -0.4088669410743988,
                -0.3765887535190676,
                -0.34384661036022796,
                -0.3106808497666898,
                -0.2771323318020521,
                -0.24324238808528204,
                -0.20905277087034174,
                -0.17460560160759628,
                -0.13994331905037422,
                -0.1051086269706134,
                -0.0701444415480058,
                -0.03509383849745701,
                0.0,
                0.03509383849745701,
                0.0701444415480058,
                0.1051086269706134,
                0.13994331905037422,
                0.17460560160759628,
                0.20905277087034174,
                0.24324238808528204,
                0.2771323318020521,
                0.3106808497666898,
                0.34384661036022796,
                0.3765887535190676,
                0.4088669410743988,
                0.4406414064486518,
                0.4718730036477532,
                0.5025232554888296,
                0.5325544010039439,
                0.5619294419614643,
                0.5906121884477524,
                0.6185673034530191,
                0.6457603464064199,
                0.6721578156067596,
                0.6977271894965399,
                0.7224369667285082,
                0.74625670497536,
                0.7691570584348011,
                0.7911098139837933,
                0.812087925937486,
                0.8320655493700791,
                0.8510180719566774,
                0.8689221442970837,
                0.88575570868447,
                0.9014980262839978,
                0.9161297026888234,
                0.9296327118237186,
                0.9419904181702149,
                0.953187597292841,
                0.9632104546565354,
                0.9720466427489094,
                0.9796852765838766,
                0.9861169478611037,
                0.9913337388086653,
                0.9953292404067497,
                0.998098605710274,
                0.9996390388645334,
            ],
            "weights": [
                0.0009262871051964369,
                0.002155112582217011,
                0.0033831047924084,
                0.0046070873434645235,
                0.0058254257887694295,
                0.0070365968709893995,
                0.008239102525388578,
                0.009431459260798143,
                0.010612197289971793,
                0.011779861580875161,
                0.012933013392602376,
                0.014070231948644395,
                0.015190116144665904,
                0.016291286254792318,
                0.017372385621502402,
                0.018432082321784147,
                0.01946907080515168,
                0.020482073500400266,
                0.021469842388561165,
                0.022431160539836435,
                0.023364843612455458,
                0.024269741311522326,
                0.025144738806002615,
                0.02598875810207372,
                0.02680075937112898,
                0.027579742230784503,
                0.02832474697730514,
                0.029034855767926727,
                0.029709193751612444,
                0.030346930146849006,
                0.030947279265154812,
                0.031509501479034224,
                0.03203290413318954,
                0.03251684239786311,
                0.0329607200632611,
                0.03336399027407727,
                0.033726156203214605,
                0.03404677166387099,
                0.03432544165923902,
                0.03456182286913775,
                0.034755624072981356,
                0.03490660650856065,
                0.035014584166196405,
                0.035079424017901956,
                0.03510104618127303,
                0.035079424017901956,
                0.035014584166196405,
                0.03490660650856065,
                0.034755624072981356,
                0.03456182286913775,
                0.03432544165923902,
                0.03404677166387099,
                0.033726156203214605,
                0.03336399027407727,
                0.0329607200632611,
                0.03251684239786311,
                0.03203290413318954,
                0.031509501479034224,
                0.030947279265154812,
                0.030346930146849006,
                0.029709193751612444,
                0.029034855767926727,
                0.02832474697730514,
                0.027579742230784503,
                0.02680075937112898,
                0.02598875810207372,
                0.025144738806002615,
                0.024269741311522326,
                0.023364843612455458,
                0.022431160539836435,
                0.021469842388561165,
                0.020482073500400266,
                0.01946907080515168,
                0.018432082321784147,
                0.017372385621502402,
                0.016291286254792318,
                0.015190116144665904,
                0.014070231948644395,
                0.012933013392602376,
                0.011779861580875161,
                0.010612197289971793,
                0.009431459260798143,
                0.008239102525388578,
                0.0070365968709893995,
                0.0058254257887694295,
                0.0046070873434645235,
                0.0033831047924084,
                0.002155112582217011,
                0.0009262871051964369,
            ],
            "generator": "gauss_legendre",
        },
        90: {
            "degree": 179,
            "points": [
                -0.9996469712866385,
                -0.9981403799385682,
                -0.9954318120583446,
                -0.9915239288110628,
                -0.9864213650578328,
                -0.9801302513451484,
                -0.9726581620901932,
                -0.9640140981715055,
                -0.9542084738815003,
                -0.9432531036453577,
                -0.931161187500432,
                -0.9179472950665863,
                -0.9036273479313027,
                -0.888218600434746,
                -0.8717396188629034,
                -0.8542102590670719,
                -0.8356516425333771,
                -0.816086130929481,
                -0.7955372991582481,
                -0.7740299069503342,
                -0.7515898690296384,
                -0.7282442238873904,
                -0.7040211012023911,
                -0.6789496879465972,
                -0.6530601932168422,
                -0.6263838118350451,
                -0.5989526867607422,
                -0.5707998703612209,
                -0.5419592845859134,
                -0.512465680093028,
                -0.4823545943776657,
                -0.4516623089518694,
                -0.42042580562819776,
                -0.3886827219594982,
                -0.35647130588856785,
                -0.32383036966234596,
                -0.29079924306616667,
                -0.25741772603442015,
                -0.22372604069472285,
                -0.189764782903379,
                -0.1555748733305291,
                -0.12119750815392408,
                -0.08667410942073478,
                -0.05204627513720694,
                -0.017355729146299653,
                0.017355729146299653,
                0.05204627513720694,
                0.08667410942073478,
                0.12119750815392408,
                0.1555748733305291,
                0.189764782903379,
                0.22372604069472285,
                0.25741772603442015,
                0.29079924306616667,
                0.32383036966234596,
                0.35647130588856785,
                0.3886827219594982,
                0.42042580562819776,
                0.4516623089518694,
                0.4823545943776657,
                0.512465680093028,
                0.5419592845859134,
                0.5707998703612209,
                0.5989526867607422,
                0.6263838118350451,
                0.6530601932168422,
                0.6789496879465972,
                0.7040211012023911,
                0.7282442238873904,
                0.7515898690296384,
                0.7740299069503342,
                0.7955372991582481,
                0.816086130929481,
                0.8356516425333771,
                0.8542102590670719,
                0.8717396188629034,
                0.888218600434746,
                0.9036273479313027,
                0.9179472950665863,
                0.931161187500432,
                0.9432531036453577,
                0.9542084738815003,
                0.9640140981715055,
                0.9726581620901932,
                0.9801302513451484,
                0.9864213650578328,
                0.9915239288110628,
                0.9954318120583446,
                0.9981403799385682,
                0.9996469712866385,
            ],
            "weights": [
                0.0009059323712157259,
                0.002107778774524567,
                0.003308867243337093,
                0.004506123613675202,
                0.005697981560747534,
                0.006882983208462412,
                0.00805969494461967,
                0.009226696957741538,
                0.010382582309893479,
                0.011525957889148227,
                0.01265544583716832,
                0.01376968511233744,
                0.014867333088043094,
                0.0159470671510065,
                0.017007586285222656,
                0.01804761263446009,
                0.01906589303913717,
                0.020061200544639772,
                0.02103233587872259,
                0.02197812889593415,
                0.022897439987163343,
                0.0237891614525286,
                0.024652218835904866,
                0.025485572219443205,
                0.026288217476514667,
                0.027059187481548053,
                0.02779755327530226,
                0.028502425184161552,
                0.02917295389210082,
                0.02980833146403132,
                0.03040779231928696,
                0.030970614154080957,
                0.03149611881181865,
                0.031983673100218594,
                0.032432689554255635,
                0.0328426271440075,
                0.033212991926551326,
                0.033543337641124216,
                0.03383326624683168,
                0.034082428402254,
                0.03429052388637504,
                0.03445730196032425,
                0.03458256166949692,
                0.03466615208568823,
                0.03470797248895009,
                0.03470797248895009,
                0.03466615208568823,
                0.03458256166949692,
                0.03445730196032425,
                0.03429052388637504,
                0.034082428402254,
                0.03383326624683168,
                0.033543337641124216,
                0.033212991926551326,
                0.0328426271440075,
                0.032432689554255635,
                0.031983673100218594,
                0.03149611881181865,
                0.030970614154080957,
                0.03040779231928696,
                0.02980833146403132,
                0.02917295389210082,
                0.028502425184161552,
                0.02779755327530226,
                0.027059187481548053,
                0.026288217476514667,
                0.025485572219443205,
                0.024652218835904866,
                0.0237891614525286,
                0.022897439987163343,
                0.02197812889593415,
                0.02103233587872259,
                0.020061200544639772,
                0.01906589303913717,
                0.01804761263446009,
                0.017007586285222656,
                0.0159470671510065,
                0.014867333088043094,
                0.01376968511233744,
                0.01265544583716832,
                0.011525957889148227,
                0.010382582309893479,
                0.009226696957741538,
                0.00805969494461967,
                0.006882983208462412,
                0.005697981560747534,
                0.004506123613675202,
                0.003308867243337093,
                0.002107778774524567,
                0.0009059323712157259,
            ],
            "generator": "gauss_legendre",
        },
        91: {
            "degree": 181,
            "points": [
                -0.9996546450765761,
                -0.9981807925905347,
                -0.9955310425053524,
                -0.9917079288172771,
                -0.9867158857234698,
                -0.9805607802412134,
                -0.9732498618306907,
                -0.9647917457472761,
                -0.9551964007322764,
                -0.9444751365457187,
                -0.9326405903562645,
                -0.9197067117234505,
                -0.9056887460965719,
                -0.8906032168143975,
                -0.8744679056122304,
                -0.8573018316526426,
                -0.839125229101387,
                -0.8199595232732804,
                -0.7998273053752922,
                -0.7787523058761223,
                -0.7567593665333693,
                -0.7338744111110947,
                -0.7101244148221939,
                -0.6855373725315247,
                -0.6601422657572348,
                -0.6339690285091533,
                -0.607048512004496,
                -0.5794124483024631,
                -0.5510934129005836,
                -0.5221247863368906,
                -0.4925407148431834,
                -0.46237607009575143,
                -0.4316664081110018,
                -0.4004479273344393,
                -0.3687574259723996,
                -0.3366322586168285,
                -0.3041102922142353,
                -0.27122986143071925,
                -0.23802972346568213,
                -0.20454901236748876,
                -0.17082719290492515,
                -0.1369040140488264,
                -0.10281946211870771,
                -0.06861371364962542,
                -0.03432708803482533,
                0.0,
                0.03432708803482533,
                0.06861371364962542,
                0.10281946211870771,
                0.1369040140488264,
                0.17082719290492515,
                0.20454901236748876,
                0.23802972346568213,
                0.27122986143071925,
                0.3041102922142353,
                0.3366322586168285,
                0.3687574259723996,
                0.4004479273344393,
                0.4316664081110018,
                0.46237607009575143,
                0.4925407148431834,
                0.5221247863368906,
                0.5510934129005836,
                0.5794124483024631,
                0.607048512004496,
                0.6339690285091533,
                0.6601422657572348,
                0.6855373725315247,
                0.7101244148221939,
                0.7338744111110947,
                0.7567593665333693,
                0.7787523058761223,
                0.7998273053752922,
                0.8199595232732804,
                0.839125229101387,
                0.8573018316526426,
                0.8744679056122304,
                0.8906032168143975,
                0.9056887460965719,
                0.9197067117234505,
                0.9326405903562645,
                0.9444751365457187,
                0.9551964007322764,
                0.9647917457472761,
                0.9732498618306907,
                0.9805607802412134,
                0.9867158857234698,
                0.9917079288172771,
                0.9955310425053524,
                0.9981807925905347,
                0.9996546450765761,
            ],
            "weights": [
                0.0008862412406751003,
                0.002061987122034217,
                0.003237045507973795,
                0.00440843974730319,
                0.005574668047479728,
                0.006734334432269666,
                0.007886066314628907,
                0.0090285041892342,
                0.010160300654414872,
                0.011280121273769492,
                0.012386645903556388,
                0.01347857015383048,
                0.014554606885208363,
                0.015613487707049404,
                0.01665396446306089,
                0.017674810697521498,
                0.018674823098168144,
                0.01965282291296886,
                0.02060765733859825,
                0.021538200878685607,
                0.022443356670097222,
                0.02332205777559865,
                0.02417326844132255,
                0.02499598531753465,
                0.025789238641235817,
                0.026552093379198703,
                0.027283650330082787,
                0.02798304718432304,
                0.028649459540540777,
                0.029282101877277113,
                0.02988022847890014,
                0.030443134314594188,
                0.03097015586939625,
                0.03146067192629684,
                0.03191410429848342,
                0.0323299185108651,
                0.03270762443007254,
                0.033046776842191476,
                0.03334697597754954,
                0.03360786798193549,
                0.03382914533369764,
                0.03401054720622884,
                0.034151859775409875,
                0.03425291647165076,
                0.0343135981762311,
                0.03433383336170866,
                0.0343135981762311,
                0.03425291647165076,
                0.034151859775409875,
                0.03401054720622884,
                0.03382914533369764,
                0.03360786798193549,
                0.03334697597754954,
                0.033046776842191476,
                0.03270762443007254,
                0.0323299185108651,
                0.03191410429848342,
                0.03146067192629684,
                0.03097015586939625,
                0.030443134314594188,
                0.02988022847890014,
                0.029282101877277113,
                0.028649459540540777,
                0.02798304718432304,
                0.027283650330082787,
                0.026552093379198703,
                0.025789238641235817,
                0.02499598531753465,
                0.02417326844132255,
                0.02332205777559865,
                0.022443356670097222,
                0.021538200878685607,
                0.02060765733859825,
                0.01965282291296886,
                0.018674823098168144,
                0.017674810697521498,
                0.01665396446306089,
                0.015613487707049404,
                0.014554606885208363,
                0.01347857015383048,
                0.012386645903556388,
                0.011280121273769492,
                0.010160300654414872,
                0.0090285041892342,
                0.007886066314628907,
                0.006734334432269666,
                0.005574668047479728,
                0.00440843974730319,
                0.003237045507973795,
                0.002061987122034217,
                0.0008862412406751003,
            ],
            "generator": "gauss_legendre",
        },
        92: {
            "degree": 183,
            "points": [
                -0.9996620713565245,
                -0.9982199021954502,
                -0.9956270752692151,
                -0.9918860044372535,
                -0.987000933924012,
                -0.980977481210154,
                -0.973822588026942,
                -0.9655445044215959,
                -0.9561527771340069,
                -0.945658237884363,
                -0.9340729906070955,
                -0.9214103973710761,
                -0.907685062910925,
                -0.8929128177527762,
                -0.8771106999395697,
                -0.8602969353704469,
                -0.842490916773781,
                -0.8237131813364887,
                -0.8039853870145665,
                -0.78333028755169,
                -0.7617717062344163,
                -0.7393345084140881,
                -0.7160445728270332,
                -0.691928761746073,
                -0.6670148899977241,
                -0.6413316928808015,
                -0.6149087930234077,
                -0.5877766662165204,
                -0.5599666062635777,
                -0.5315106888865979,
                -0.5024417347304565,
                -0.47279327150799183,
                -0.44259949532959425,
                -0.4118952312618817,
                -0.38071589316095056,
                -0.34909744282652816,
                -0.31707634852413813,
                -0.28468954292311693,
                -0.2519743804989962,
                -0.21896859444938016,
                -0.18571025317301246,
                -0.152237716362227,
                -0.11858959075942593,
                -0.08480468562861401,
                -0.05092196799334792,
                -0.016980517692728233,
                0.016980517692728233,
                0.05092196799334792,
                0.08480468562861401,
                0.11858959075942593,
                0.152237716362227,
                0.18571025317301246,
                0.21896859444938016,
                0.2519743804989962,
                0.28468954292311693,
                0.31707634852413813,
                0.34909744282652816,
                0.38071589316095056,
                0.4118952312618817,
                0.44259949532959425,
                0.47279327150799183,
                0.5024417347304565,
                0.5315106888865979,
                0.5599666062635777,
                0.5877766662165204,
                0.6149087930234077,
                0.6413316928808015,
                0.6670148899977241,
                0.691928761746073,
                0.7160445728270332,
                0.7393345084140881,
                0.7617717062344163,
                0.78333028755169,
                0.8039853870145665,
                0.8237131813364887,
                0.842490916773781,
                0.8602969353704469,
                0.8771106999395697,
                0.8929128177527762,
                0.907685062910925,
                0.9214103973710761,
                0.9340729906070955,
                0.945658237884363,
                0.9561527771340069,
                0.9655445044215959,
                0.973822588026942,
                0.980977481210154,
                0.987000933924012,
                0.9918860044372535,
                0.9956270752692151,
                0.9982199021954502,
                0.9996620713565245,
            ],
            "weights": [
                0.0008671851787713772,
                0.002017671366259443,
                0.003167535943397252,
                0.004313895331861211,
                0.005455308908001706,
                0.0065904393342145935,
                0.007717971837373496,
                0.00883660405646801,
                0.009945045019726314,
                0.011042015922635182,
                0.012126251362637902,
                0.013196500705710693,
                0.014251529488954426,
                0.01529012082579651,
                0.01631107680025589,
                0.01731321984368947,
                0.018295394090267297,
                0.019256466708559485,
                0.020195329207187404,
                0.02111089871276239,
                0.022002119218485886,
                0.022867962801892457,
                0.02370743081028203,
                0.024519555012440925,
                0.025303398715313178,
                0.02605805784431407,
                0.02678266198604026,
                0.027476375392164135,
                0.028138397943354338,
                0.028767966072107024,
                0.029364353643422728,
                0.029926872792311064,
                0.03045487471715822,
                0.03094775042804097,
                0.031404931449122105,
                0.031825890474320016,
                0.03221014197549325,
                0.03255724276243994,
                0.03286679249406559,
                0.03313843414012923,
                0.033371854393036755,
                0.03356678402920363,
                0.03372299821957377,
                0.03384031678893349,
                0.03391860442372246,
                0.03395777082810228,
                0.03395777082810228,
                0.03391860442372246,
                0.03384031678893349,
                0.03372299821957377,
                0.03356678402920363,
                0.033371854393036755,
                0.03313843414012923,
                0.03286679249406559,
                0.03255724276243994,
                0.03221014197549325,
                0.031825890474320016,
                0.031404931449122105,
                0.03094775042804097,
                0.03045487471715822,
                0.029926872792311064,
                0.029364353643422728,
                0.028767966072107024,
                0.028138397943354338,
                0.027476375392164135,
                0.02678266198604026,
                0.02605805784431407,
                0.025303398715313178,
                0.024519555012440925,
                0.02370743081028203,
                0.022867962801892457,
                0.022002119218485886,
                0.02111089871276239,
                0.020195329207187404,
                0.019256466708559485,
                0.018295394090267297,
                0.01731321984368947,
                0.01631107680025589,
                0.01529012082579651,
                0.014251529488954426,
                0.013196500705710693,
                0.012126251362637902,
                0.011042015922635182,
                0.009945045019726314,
                0.00883660405646801,
                0.007717971837373496,
                0.0065904393342145935,
                0.005455308908001706,
                0.004313895331861211,
                0.003167535943397252,
                0.002017671366259443,
                0.0008671851787713772,
            ],
            "generator": "gauss_legendre",
        },
        93: {
            "degree": 185,
            "points": [
                -0.9996692606571687,
                -0.9982577641714128,
                -0.9957200462489502,
                -0.9920584071920627,
                -0.9872769112685723,
                -0.9813809395335016,
                -0.9743771421334104,
                -0.9662734230400591,
                -0.9570789290651234,
                -0.9468040388484754,
                -0.9354603508751892,
                -0.9230606702658535,
                -0.9096189942656765,
                -0.895150496414999,
                -0.8796715094050029,
                -0.8631995066316017,
                -0.8457530824652613,
                -0.8273519312574519,
                -0.8080168251065866,
                -0.7877695904080753,
                -0.7666330832146929,
                -0.7446311634349144,
                -0.7217886678982397,
                -0.6981313823178534,
                -0.6736860121822279,
                -0.6484801526084999,
                -0.6225422571916356,
                -0.595901605884536,
                -0.5685882719453317,
                -0.5406330879891732,
                -0.5120676111828354,
                -0.4829240876214217,
                -0.45323541592737976,
                -0.42303511011291894,
                -0.3923572617477494,
                -0.3612365014748497,
                -0.32970795991770563,
                -0.2978072280231479,
                -0.2655703168845569,
                -0.23303361709078646,
                -0.2002338576466961,
                -0.16720806451166345,
                -0.13399351880288074,
                -0.10062771471061727,
                -0.06714831717295511,
                -0.03359311935777656,
                0.0,
                0.03359311935777656,
                0.06714831717295511,
                0.10062771471061727,
                0.13399351880288074,
                0.16720806451166345,
                0.2002338576466961,
                0.23303361709078646,
                0.2655703168845569,
                0.2978072280231479,
                0.32970795991770563,
                0.3612365014748497,
                0.3923572617477494,
                0.42303511011291894,
                0.45323541592737976,
                0.4829240876214217,
                0.5120676111828354,
                0.5406330879891732,
                0.5685882719453317,
                0.595901605884536,
                0.6225422571916356,
                0.6484801526084999,
                0.6736860121822279,
                0.6981313823178534,
                0.7217886678982397,
                0.7446311634349144,
                0.7666330832146929,
                0.7877695904080753,
                0.8080168251065866,
                0.8273519312574519,
                0.8457530824652613,
                0.8631995066316017,
                0.8796715094050029,
                0.895150496414999,
                0.9096189942656765,
                0.9230606702658535,
                0.9354603508751892,
                0.9468040388484754,
                0.9570789290651234,
                0.9662734230400591,
                0.9743771421334104,
                0.9813809395335016,
                0.9872769112685723,
                0.9920584071920627,
                0.9957200462489502,
                0.9982577641714128,
                0.9996692606571687,
            ],
            "weights": [
                0.0008487371680734414,
                0.001974768768687738,
                0.003100240403099636,
                0.004222357382406593,
                0.0053397370981683135,
                0.006451097794311515,
                0.007555179500770054,
                0.008650734035428332,
                0.009736523941887475,
                0.010811323190542671,
                0.011873918327447656,
                0.012923109753185185,
                0.013957713038007545,
                0.014976560240671927,
                0.01597850121778225,
                0.016962404917328654,
                0.017927160652813745,
                0.018871679355507955,
                0.019794894802927843,
                0.020695764821868586,
                0.021573272464499846,
                0.02242642715610953,
                0.023254265813157426,
                0.024055853930344394,
                0.024830286635452416,
                0.02557668971075768,
                0.026294220579853218,
                0.02698206925876261,
                0.027639459270270516,
                0.028265648520432857,
                0.028859930136277544,
                0.029421633263748703,
                0.02995012382499363,
                0.0304448052341351,
                0.030905119070722735,
                0.03133054571010255,
                0.0317206049099921,
                0.032074856352598984,
                0.03239290014167199,
                0.03267437725392214,
                0.032918969944304294,
                0.03312640210470301,
                0.03329643957561553,
                0.033428890410482734,
                0.03352360509236663,
                0.03358047670273268,
                0.03359944104214394,
                0.03358047670273268,
                0.03352360509236663,
                0.033428890410482734,
                0.03329643957561553,
                0.03312640210470301,
                0.032918969944304294,
                0.03267437725392214,
                0.03239290014167199,
                0.032074856352598984,
                0.0317206049099921,
                0.03133054571010255,
                0.030905119070722735,
                0.0304448052341351,
                0.02995012382499363,
                0.029421633263748703,
                0.028859930136277544,
                0.028265648520432857,
                0.027639459270270516,
                0.02698206925876261,
                0.026294220579853218,
                0.02557668971075768,
                0.024830286635452416,
                0.024055853930344394,
                0.023254265813157426,
                0.02242642715610953,
                0.021573272464499846,
                0.020695764821868586,
                0.019794894802927843,
                0.018871679355507955,
                0.017927160652813745,
                0.016962404917328654,
                0.01597850121778225,
                0.014976560240671927,
                0.013957713038007545,
                0.012923109753185185,
                0.011873918327447656,
                0.010811323190542671,
                0.009736523941887475,
                0.008650734035428332,
                0.007555179500770054,
                0.006451097794311515,
                0.0053397370981683135,
                0.004222357382406593,
                0.003100240403099636,
                0.001974768768687738,
                0.0008487371680734414,
            ],
            "generator": "gauss_legendre",
        },
        94: {
            "degree": 187,
            "points": [
                -0.9996762229550498,
                -0.9982944310216876,
                -0.9958100842017189,
                -0.9922253754008766,
                -0.9875441983204798,
                -0.9817717098833783,
                -0.9749142837904651,
                -0.9669794958813434,
                -0.957976113742955,
                -0.9479140863487617,
                -0.9368045328028254,
                -0.9246597299379515,
                -0.9114930986940575,
                -0.897319189258768,
                -0.8821536649728723,
                -0.8660132850121987,
                -0.8489158858620334,
                -0.8308803616030174,
                -0.8119266430294829,
                -0.7920756756228452,
                -0.7713493964041237,
                -0.7497707096910136,
                -0.727363461786199,
                -0.7041524146248203,
                -0.6801632184101726,
                -0.6554223832678553,
                -0.6299572499496732,
                -0.6037959596196573,
                -0.5769674227555817,
                -0.5495012872003404,
                -0.5214279053984839,
                -0.49277830085411933,
                -0.4635841338472393,
                -0.4338776664463639,
                -0.40369172685615895,
                -0.37305967313942784,
                -0.3420153563535674,
                -0.31059308314222417,
                -0.27882757782349027,
                -0.24675394401653425,
                -0.2144076258490726,
                -0.18182436878855096,
                -0.14904018014031928,
                -0.11609128925645443,
                -0.08301410749920224,
                -0.049845188003282914,
                -0.016621185281526032,
                0.016621185281526032,
                0.049845188003282914,
                0.08301410749920224,
                0.11609128925645443,
                0.14904018014031928,
                0.18182436878855096,
                0.2144076258490726,
                0.24675394401653425,
                0.27882757782349027,
                0.31059308314222417,
                0.3420153563535674,
                0.37305967313942784,
                0.40369172685615895,
                0.4338776664463639,
                0.4635841338472393,
                0.49277830085411933,
                0.5214279053984839,
                0.5495012872003404,
                0.5769674227555817,
                0.6037959596196573,
                0.6299572499496732,
                0.6554223832678553,
                0.6801632184101726,
                0.7041524146248203,
                0.727363461786199,
                0.7497707096910136,
                0.7713493964041237,
                0.7920756756228452,
                0.8119266430294829,
                0.8308803616030174,
                0.8489158858620334,
                0.8660132850121987,
                0.8821536649728723,
                0.897319189258768,
                0.9114930986940575,
                0.9246597299379515,
                0.9368045328028254,
                0.9479140863487617,
                0.957976113742955,
                0.9669794958813434,
                0.9749142837904651,
                0.9817717098833783,
                0.9875441983204798,
                0.9922253754008766,
                0.9958100842017189,
                0.9982944310216876,
                0.9996762229550498,
            ],
            "weights": [
                0.0008308716126862451,
                0.0019332198887263505,
                0.0030350658910378845,
                0.004133699875408537,
                0.00522779428950745,
                0.0063161200910360135,
                0.0073974692881421215,
                0.008470645094534964,
                0.009534460832865577,
                0.010587740564954049,
                0.01162932016112229,
                0.012658048497638892,
                0.01367278869060694,
                0.014672419334499507,
                0.015655835732515392,
                0.016621951112665415,
                0.017569697826143354,
                0.01849802852566583,
                0.01940591732198177,
                0.020292360917010772,
                0.02115637971222128,
                0.02199701889093982,
                0.022813349473355164,
                0.02360446934301428,
                0.0243695042436691,
                0.025107608745352172,
                0.025817967178616622,
                0.02649979453589149,
                0.027152337338966385,
                0.027774874471634035,
                0.028366717976575972,
                0.028927213815606152,
                0.02945574259243349,
                0.02995172023714369,
                0.030414598651642564,
                0.03084386631534899,
                0.031239048850467264,
                0.0315997095462131,
                0.031925449841415494,
                0.03221590976496016,
                0.03247076833358756,
                0.032689743906606165,
                0.032872594497129426,
                0.03301911803949149,
                0.033129152612546765,
                0.03320257661860668,
                0.03323930891781514,
                0.03323930891781514,
                0.03320257661860668,
                0.033129152612546765,
                0.03301911803949149,
                0.032872594497129426,
                0.032689743906606165,
                0.03247076833358756,
                0.03221590976496016,
                0.031925449841415494,
                0.0315997095462131,
                0.031239048850467264,
                0.03084386631534899,
                0.030414598651642564,
                0.02995172023714369,
                0.02945574259243349,
                0.028927213815606152,
                0.028366717976575972,
                0.027774874471634035,
                0.027152337338966385,
                0.02649979453589149,
                0.025817967178616622,
                0.025107608745352172,
                0.0243695042436691,
                0.02360446934301428,
                0.022813349473355164,
                0.02199701889093982,
                0.02115637971222128,
                0.020292360917010772,
                0.01940591732198177,
                0.01849802852566583,
                0.017569697826143354,
                0.016621951112665415,
                0.015655835732515392,
                0.014672419334499507,
                0.01367278869060694,
                0.012658048497638892,
                0.01162932016112229,
                0.010587740564954049,
                0.009534460832865577,
                0.008470645094534964,
                0.0073974692881421215,
                0.0063161200910360135,
                0.00522779428950745,
                0.004133699875408537,
                0.0030350658910378845,
                0.0019332198887263505,
                0.0008308716126862451,
            ],
            "generator": "gauss_legendre",
        },
        95: {
            "degree": 189,
            "points": [
                -0.999682967707192,
                -0.9983299525167464,
                -0.9958973111884234,
                -0.9923871350035014,
                -0.9878031559060813,
                -0.9821503182216257,
                -0.9754347334114409,
                -0.9676636660221966,
                -0.9588455238479094,
                -0.9489898481742954,
                -0.938107303198478,
                -0.9262096643777198,
                -0.9133098056340674,
                -0.8994216853963932,
                -0.8845603314814405,
                -0.8687418248241299,
                -0.8519832820717843,
                -0.8343028370596013,
                -0.8157196211866097,
                -0.7962537427128932,
                -0.775926265000224,
                -0.7547591837194924,
                -0.7327754030495022,
                -0.7099987108928231,
                -0.6864537531354822,
                -0.6621660069783181,
                -0.6371617533688401,
                -0.6114680485634107,
                -0.5851126948505141,
                -0.5581242104667844,
                -0.5305317987383433,
                -0.502365316480834,
                -0.4736552416923438,
                -0.4444326405741703,
                -0.4147291339151185,
                -0.38457686287569903,
                -0.3540084542092533,
                -0.3230569849576369,
                -0.2917559466596621,
                -0.2601392091110289,
                -0.2282409837149581,
                -0.19609578646318276,
                -0.16373840058735595,
                -0.13120383892128715,
                -0.09852730601473486,
                -0.0657441600397498,
                -0.03288987453078894,
                0.0,
                0.03288987453078894,
                0.0657441600397498,
                0.09852730601473486,
                0.13120383892128715,
                0.16373840058735595,
                0.19609578646318276,
                0.2282409837149581,
                0.2601392091110289,
                0.2917559466596621,
                0.3230569849576369,
                0.3540084542092533,
                0.38457686287569903,
                0.4147291339151185,
                0.4444326405741703,
                0.4736552416923438,
                0.502365316480834,
                0.5305317987383433,
                0.5581242104667844,
                0.5851126948505141,
                0.6114680485634107,
                0.6371617533688401,
                0.6621660069783181,
                0.6864537531354822,
                0.7099987108928231,
                0.7327754030495022,
                0.7547591837194924,
                0.775926265000224,
                0.7962537427128932,
                0.8157196211866097,
                0.8343028370596013,
                0.8519832820717843,
                0.8687418248241299,
                0.8845603314814405,
                0.8994216853963932,
                0.9133098056340674,
                0.9262096643777198,
                0.938107303198478,
                0.9489898481742954,
                0.9588455238479094,
                0.9676636660221966,
                0.9754347334114409,
                0.9821503182216257,
                0.9878031559060813,
                0.9923871350035014,
                0.9958973111884234,
                0.9983299525167464,
                0.999682967707192,
            ],
            "weights": [
                0.0008135642494554402,
                0.0018929683779222934,
                0.0029719242408186093,
                0.004047803316371942,
                0.005119330329928406,
                0.006185326261032374,
                0.007244632443932776,
                0.008296100874530385,
                0.009338593083876447,
                0.010370980703116501,
                0.011392146459086072,
                0.012400985296115863,
                0.013396405534368003,
                0.014377330033658984,
                0.015342697350288518,
                0.016291462880991172,
                0.017222599990716934,
                0.018135101122045336,
                0.01902797888454552,
                0.019900267122657335,
                0.020751021960784766,
                0.021579322824411554,
                0.0223842734360694,
                0.023165002785071515,
                0.02392066606993068,
                0.024650445612442538,
                0.025353551742431892,
                0.026029223652202078,
                0.026676730219761333,
                0.027295370799930194,
                0.027884475982476814,
                0.028443408316454845,
                0.028971562999960947,
                0.0294683685345669,
                0.029933287343714098,
                0.03036581635440501,
                0.030765487541558872,
                0.031131868434443974,
                0.031464562584638374,
                0.03176320999501227,
                0.03202748750926767,
                0.032257109161614395,
                0.03245182648620326,
                0.03261142878598212,
                0.03273574336068394,
                0.03282463569369913,
                0.03287800959763198,
                0.03289580731838069,
                0.03287800959763198,
                0.03282463569369913,
                0.03273574336068394,
                0.03261142878598212,
                0.03245182648620326,
                0.032257109161614395,
                0.03202748750926767,
                0.03176320999501227,
                0.031464562584638374,
                0.031131868434443974,
                0.030765487541558872,
                0.03036581635440501,
                0.029933287343714098,
                0.0294683685345669,
                0.028971562999960947,
                0.028443408316454845,
                0.027884475982476814,
                0.027295370799930194,
                0.026676730219761333,
                0.026029223652202078,
                0.025353551742431892,
                0.024650445612442538,
                0.02392066606993068,
                0.023165002785071515,
                0.0223842734360694,
                0.021579322824411554,
                0.020751021960784766,
                0.019900267122657335,
                0.01902797888454552,
                0.018135101122045336,
                0.017222599990716934,
                0.016291462880991172,
                0.015342697350288518,
                0.014377330033658984,
                0.013396405534368003,
                0.012400985296115863,
                0.011392146459086072,
                0.010370980703116501,
                0.009338593083876447,
                0.008296100874530385,
                0.007244632443932776,
                0.006185326261032374,
                0.005119330329928406,
                0.004047803316371942,
                0.0029719242408186093,
                0.0018929683779222934,
                0.0008135642494554402,
            ],
            "generator": "gauss_legendre",
        },
        96: {
            "degree": 191,
            "points": [
                -0.9996895038832307,
                -0.9983643758631817,
                -0.9959818429872093,
                -0.9925439003237626,
                -0.9880541263296237,
                -0.9825172635630147,
                -0.9759391745851365,
                -0.9683268284632642,
                -0.9596882914487426,
                -0.9500327177844377,
                -0.9393703397527552,
                -0.9277124567223087,
                -0.9150714231208981,
                -0.9014606353158523,
                -0.8868945174024204,
                -0.8713885059092965,
                -0.8549590334346014,
                -0.8376235112281871,
                -0.8194003107379317,
                -0.8003087441391408,
                -0.7803690438674332,
                -0.7596023411766475,
                -0.7380306437444001,
                -0.7156768123489676,
                -0.6925645366421715,
                -0.6687183100439161,
                -0.6441634037849671,
                -0.6189258401254686,
                -0.593032364777572,
                -0.5665104185613972,
                -0.5393881083243575,
                -0.5116941771546677,
                -0.48345797392059636,
                -0.454709422167743,
                -0.42547898840730053,
                -0.3957976498289086,
                -0.3656968614723136,
                -0.3352085228926254,
                -0.30436494435449635,
                -0.27319881259104917,
                -0.24174315616384,
                -0.2100313104605672,
                -0.17809688236761861,
                -0.14597371465489695,
                -0.11369585011066592,
                -0.08129749546442556,
                -0.04881298513604973,
                -0.01627674484960297,
                0.01627674484960297,
                0.04881298513604973,
                0.08129749546442556,
                0.11369585011066592,
                0.14597371465489695,
                0.17809688236761861,
                0.2100313104605672,
                0.24174315616384,
                0.27319881259104917,
                0.30436494435449635,
                0.3352085228926254,
                0.3656968614723136,
                0.3957976498289086,
                0.42547898840730053,
                0.454709422167743,
                0.48345797392059636,
                0.5116941771546677,
                0.5393881083243575,
                0.5665104185613972,
                0.593032364777572,
                0.6189258401254686,
                0.6441634037849671,
                0.6687183100439161,
                0.6925645366421715,
                0.7156768123489676,
                0.7380306437444001,
                0.7596023411766475,
                0.7803690438674332,
                0.8003087441391408,
                0.8194003107379317,
                0.8376235112281871,
                0.8549590334346014,
                0.8713885059092965,
                0.8868945174024204,
                0.9014606353158523,
                0.9150714231208981,
                0.9277124567223087,
                0.9393703397527552,
                0.9500327177844377,
                0.9596882914487426,
                0.9683268284632642,
                0.9759391745851365,
                0.9825172635630147,
                0.9880541263296237,
                0.9925439003237626,
                0.9959818429872093,
                0.9983643758631817,
                0.9996895038832307,
            ],
            "weights": [
                0.0007967920655551096,
                0.0018539607889438041,
                0.0029107318179363785,
                0.003964554338445037,
                0.0050142027429287035,
                0.006058545504235144,
                0.007096470791153892,
                0.008126876925698382,
                0.009148671230782973,
                0.010160770535008074,
                0.011162102099838618,
                0.012151604671087984,
                0.013128229566961701,
                0.014090941772314996,
                0.015038721026994937,
                0.0159705629025622,
                0.016885479864245205,
                0.017782502316045244,
                0.018660679627411376,
                0.01951908114014511,
                0.020356797154333334,
                0.021172939892191236,
                0.021966644438744517,
                0.022737069658329327,
                0.023483399085926244,
                0.024204841792364724,
                0.02490063322248356,
                0.025570036005349267,
                0.026212340735672468,
                0.02682686672559171,
                0.027412962726029177,
                0.02797000761684825,
                0.028497411065085323,
                0.028994614150555188,
                0.029461089958167895,
                0.02989634413632837,
                0.030299915420827574,
                0.030671376123669082,
                0.03101033258631377,
                0.031316425596861285,
                0.03158933077072709,
                0.03182875889441097,
                0.0320344562319926,
                0.03220620479403022,
                0.03234382256857588,
                0.03244716371406422,
                0.032516118713868766,
                0.0325506144923631,
                0.0325506144923631,
                0.032516118713868766,
                0.03244716371406422,
                0.03234382256857588,
                0.03220620479403022,
                0.0320344562319926,
                0.03182875889441097,
                0.03158933077072709,
                0.031316425596861285,
                0.03101033258631377,
                0.030671376123669082,
                0.030299915420827574,
                0.02989634413632837,
                0.029461089958167895,
                0.028994614150555188,
                0.028497411065085323,
                0.02797000761684825,
                0.027412962726029177,
                0.02682686672559171,
                0.026212340735672468,
                0.025570036005349267,
                0.02490063322248356,
                0.024204841792364724,
                0.023483399085926244,
                0.022737069658329327,
                0.021966644438744517,
                0.021172939892191236,
                0.020356797154333334,
                0.01951908114014511,
                0.018660679627411376,
                0.017782502316045244,
                0.016885479864245205,
                0.0159705629025622,
                0.015038721026994937,
                0.014090941772314996,
                0.013128229566961701,
                0.012151604671087984,
                0.011162102099838618,
                0.010160770535008074,
                0.009148671230782973,
                0.008126876925698382,
                0.007096470791153892,
                0.006058545504235144,
                0.0050142027429287035,
                0.003964554338445037,
                0.0029107318179363785,
                0.0018539607889438041,
                0.0007967920655551096,
            ],
            "generator": "gauss_legendre",
        },
        97: {
            "degree": 193,
            "points": [
                -0.9996958399952467,
                -0.9983977458605664,
                -0.9960637894774884,
                -0.9926958747785516,
                -0.9882974345018388,
                -0.9828730196135284,
                -0.9764282563086197,
                -0.968969833034951,
                -0.9605054916527872,
                -0.9510440187666391,
                -0.940595236358028,
                -0.9291699914816192,
                -0.9167801449531889,
                -0.9034385590101216,
                -0.8891590839443003,
                -0.8739565437154142,
                -0.8578467205567903,
                -0.8408463385882867,
                -0.8229730464524845,
                -0.8042453989917706,
                -0.7846828379850858,
                -0.7643056719641821,
                -0.7431350551302539,
                -0.7211929653927706,
                -0.6985021815532712,
                -0.675086259657785,
                -0.6509695085424083,
                -0.6261769645974139,
                -0.6007343657760842,
                -0.5746681248752441,
                -0.5480053021152277,
                -0.5207735770477429,
                -0.4930012198207932,
                -0.46471706183048883,
                -0.4359504657902099,
                -0.4067312952481959,
                -0.3770898835852041,
                -0.34705700252442134,
                -0.31666383018631916,
                -0.2859419187216169,
                -0.2549231615559514,
                -0.22363976028025953,
                -0.19212419122124463,
                -0.16040917172663133,
                -0.12852762620020855,
                -0.09651265192192161,
                -0.06439748468849585,
                -0.032215464310261704,
                0.0,
                0.032215464310261704,
                0.06439748468849585,
                0.09651265192192161,
                0.12852762620020855,
                0.16040917172663133,
                0.19212419122124463,
                0.22363976028025953,
                0.2549231615559514,
                0.2859419187216169,
                0.31666383018631916,
                0.34705700252442134,
                0.3770898835852041,
                0.4067312952481959,
                0.4359504657902099,
                0.46471706183048883,
                0.4930012198207932,
                0.5207735770477429,
                0.5480053021152277,
                0.5746681248752441,
                0.6007343657760842,
                0.6261769645974139,
                0.6509695085424083,
                0.675086259657785,
                0.6985021815532712,
                0.7211929653927706,
                0.7431350551302539,
                0.7643056719641821,
                0.7846828379850858,
                0.8042453989917706,
                0.8229730464524845,
                0.8408463385882867,
                0.8578467205567903,
                0.8739565437154142,
                0.8891590839443003,
                0.9034385590101216,
                0.9167801449531889,
                0.9291699914816192,
                0.940595236358028,
                0.9510440187666391,
                0.9605054916527872,
                0.968969833034951,
                0.9764282563086197,
                0.9828730196135284,
                0.9882974345018388,
                0.9926958747785516,
                0.9960637894774884,
                0.9983977458605664,
                0.9996958399952467,
            ],
            "weights": [
                0.0007805332219465117,
                0.0018161463982113693,
                0.0028514092432127885,
                0.0038838453294899955,
                0.004912276262165032,
                0.005935615630788138,
                0.006952796096469788,
                0.007962759997865299,
                0.008964458176698272,
                0.00995685042708416,
                0.010938906359195909,
                0.011909606385330585,
                0.01286794274249329,
                0.013812920521853025,
                0.014743558693237069,
                0.015658891119156904,
                0.016557967555342203,
                0.017439854635807887,
                0.01830363684096388,
                0.01914841744752783,
                0.019973319459107866,
                0.02077748651642632,
                0.021560083786191713,
                0.02232029882766696,
                0.023057342436025766,
                0.02377044946160281,
                0.024458879604187744,
                0.025121918181529777,
                0.02575887687125671,
                0.02636909442542923,
                0.026951937356996445,
                0.02750680059743016,
                0.028033108124862552,
                0.02853031356206704,
                0.028997900743668283,
                0.02943538425198718,
                0.029842309920966925,
                0.03021825530765583,
                0.030562830130758455,
                0.030875676675797523,
                0.031156470166468872,
                0.03140491910180158,
                0.031620765558773856,
                0.031803785460071364,
                0.031953788806708516,
                0.03207061987527269,
                0.03215415737958533,
                0.03220431459661337,
                0.03222103945649855,
                0.03220431459661337,
                0.03215415737958533,
                0.03207061987527269,
                0.031953788806708516,
                0.031803785460071364,
                0.031620765558773856,
                0.03140491910180158,
                0.031156470166468872,
                0.030875676675797523,
                0.030562830130758455,
                0.03021825530765583,
                0.029842309920966925,
                0.02943538425198718,
                0.028997900743668283,
                0.02853031356206704,
                0.028033108124862552,
                0.02750680059743016,
                0.026951937356996445,
                0.02636909442542923,
                0.02575887687125671,
                0.025121918181529777,
                0.024458879604187744,
                0.02377044946160281,
                0.023057342436025766,
                0.02232029882766696,
                0.021560083786191713,
                0.02077748651642632,
                0.019973319459107866,
                0.01914841744752783,
                0.01830363684096388,
                0.017439854635807887,
                0.016557967555342203,
                0.015658891119156904,
                0.014743558693237069,
                0.013812920521853025,
                0.01286794274249329,
                0.011909606385330585,
                0.010938906359195909,
                0.00995685042708416,
                0.008964458176698272,
                0.007962759997865299,
                0.006952796096469788,
                0.005935615630788138,
                0.004912276262165032,
                0.0038838453294899955,
                0.0028514092432127885,
                0.0018161463982113693,
                0.0007805332219465117,
            ],
            "generator": "gauss_legendre",
        },
        98: {
            "degree": 195,
            "points": [
                -0.9997019841254909,
                -0.9984301050472305,
                -0.9961432549968593,
                -0.9928432515369068,
                -0.9885333889891582,
                -0.983218036293723,
                -0.9769025950638861,
                -0.9695934871007945,
                -0.9612981460028911,
                -0.9520250089864015,
                -0.9417835080627118,
                -0.9305840603393071,
                -0.9184380573735681,
                -0.9053578535598391,
                -0.8913567535488911,
                -0.8764489987068441,
                -0.8606497526245518,
                -0.8439750856907705,
                -0.8264419587440479,
                -0.8080682058195343,
                -0.7888725160080223,
                -0.7688744144455177,
                -0.7480942424525925,
                -0.7265531368436585,
                -0.7042730084271774,
                -0.6812765197186463,
                -0.657587061889015,
                -0.6332287309719699,
                -0.6082263033542795,
                -0.582605210574124,
                -0.5563915134530406,
                -0.5296118755877949,
                -0.5022935362291369,
                -0.4744642825750288,
                -0.44615242150652545,
                -0.41738675079505433,
                -0.3881965298103839,
                -0.35861144975907194,
                -0.32866160348366813,
                -0.29837745485338757,
                -0.2677898077773914,
                -0.23692977487219216,
                -0.20582874581505378,
                -0.17451835541557656,
                -0.14303045143794288,
                -0.11139706220655361,
                -0.07965036402800599,
                -0.04782264846254933,
                -0.0159462894783094,
                0.0159462894783094,
                0.04782264846254933,
                0.07965036402800599,
                0.11139706220655361,
                0.14303045143794288,
                0.17451835541557656,
                0.20582874581505378,
                0.23692977487219216,
                0.2677898077773914,
                0.29837745485338757,
                0.32866160348366813,
                0.35861144975907194,
                0.3881965298103839,
                0.41738675079505433,
                0.44615242150652545,
                0.4744642825750288,
                0.5022935362291369,
                0.5296118755877949,
                0.5563915134530406,
                0.582605210574124,
                0.6082263033542795,
                0.6332287309719699,
                0.657587061889015,
                0.6812765197186463,
                0.7042730084271774,
                0.7265531368436585,
                0.7480942424525925,
                0.7688744144455177,
                0.7888725160080223,
                0.8080682058195343,
                0.8264419587440479,
                0.8439750856907705,
                0.8606497526245518,
                0.8764489987068441,
                0.8913567535488911,
                0.9053578535598391,
                0.9184380573735681,
                0.9305840603393071,
                0.9417835080627118,
                0.9520250089864015,
                0.9612981460028911,
                0.9695934871007945,
                0.9769025950638861,
                0.983218036293723,
                0.9885333889891582,
                0.9928432515369068,
                0.9961432549968593,
                0.9984301050472305,
                0.9997019841254909,
            ],
            "weights": [
                0.0007647669822709107,
                0.001779477041010497,
                0.0027938811357221304,
                0.003805574085351315,
                0.004813422398585957,
                0.005816382546440352,
                0.0068134294791651045,
                0.007803547379100159,
                0.008785728467392508,
                0.009758973402174116,
                0.010722292083224488,
                0.011674704577138087,
                0.012615242078922222,
                0.013542947881029712,
                0.014456878338304741,
                0.015356103823497877,
                0.01623970967045355,
                0.017106797103089866,
                0.017956484148770463,
                0.018787906534905082,
                0.019600218567726455,
                0.020392593992292138,
                0.02116422683277494,
                0.021914332212178696,
                0.022642147150618613,
                0.02334693134134951,
                0.024027967903745603,
                0.02468456411246125,
                0.025316052102026396,
                0.025921789546162772,
                0.026501160311123907,
                0.027053575082396395,
                0.027578471964122653,
                0.028075317050636442,
                0.028543604969528232,
                0.02898285939568863,
                0.029392633535806793,
                0.029772510582829814,
                0.03012210413992223,
                0.030441058613493596,
                0.030729049574893995,
                0.03098578409041024,
                0.031211001019226577,
                0.031404471279046914,
                0.03156599807910843,
                0.03169541712034957,
                0.03179259676252894,
                0.031857438158124335,
                0.03188987535287677,
                0.03188987535287677,
                0.031857438158124335,
                0.03179259676252894,
                0.03169541712034957,
                0.03156599807910843,
                0.031404471279046914,
                0.031211001019226577,
                0.03098578409041024,
                0.030729049574893995,
                0.030441058613493596,
                0.03012210413992223,
                0.029772510582829814,
                0.029392633535806793,
                0.02898285939568863,
                0.028543604969528232,
                0.028075317050636442,
                0.027578471964122653,
                0.027053575082396395,
                0.026501160311123907,
                0.025921789546162772,
                0.025316052102026396,
                0.02468456411246125,
                0.024027967903745603,
                0.02334693134134951,
                0.022642147150618613,
                0.021914332212178696,
                0.02116422683277494,
                0.020392593992292138,
                0.019600218567726455,
                0.018787906534905082,
                0.017956484148770463,
                0.017106797103089866,
                0.01623970967045355,
                0.015356103823497877,
                0.014456878338304741,
                0.013542947881029712,
                0.012615242078922222,
                0.011674704577138087,
                0.010722292083224488,
                0.009758973402174116,
                0.008785728467392508,
                0.007803547379100159,
                0.0068134294791651045,
                0.005816382546440352,
                0.004813422398585957,
                0.003805574085351315,
                0.0027938811357221304,
                0.001779477041010497,
                0.0007647669822709107,
            ],
            "generator": "gauss_legendre",
        },
        99: {
            "degree": 197,
            "points": [
                -0.9997079439521693,
                -0.9984614938358414,
                -0.9962203386730886,
                -0.9929862141331123,
                -0.9887622829898737,
                -0.98355274115628,
                -0.9773627767507059,
                -0.9701985580742902,
                -0.962067225640902,
                -0.9529768844533735,
                -0.9429365956884794,
                -0.931956367561497,
                -0.9200471453005002,
                -0.9072208002105736,
                -0.8934901178264142,
                -0.8788687851595138,
                -0.8633713770499171,
                -0.8470133416347742,
                -0.8298109849474306,
                -0.8117814546619891,
                -0.7929427229993089,
                -0.7733135688113362,
                -0.7529135588615381,
                -0.7317630283200436,
                -0.7098830604928968,
                -0.6872954658056091,
                -0.6640227600619385,
                -0.6400881419995625,
                -0.6155154701650072,
                -0.5903292391308785,
                -0.5645545550791016,
                -0.5382171107745011,
                -0.511343159953671,
                -0.4839594911546597,
                -0.45609340101355667,
                -0.4277726670545996,
                -0.39902552000092417,
                -0.3698806156335562,
                -0.34036700622669946,
                -0.31051411158779074,
                -0.2803516897311913,
                -0.24990980721474654,
                -0.21921880916878408,
                -0.18830928904742447,
                -0.1572120581323584,
                -0.12595811481948846,
                -0.09457861371905203,
                -0.06310483460002624,
                -0.03156815120977227,
                0.0,
                0.03156815120977227,
                0.06310483460002624,
                0.09457861371905203,
                0.12595811481948846,
                0.1572120581323584,
                0.18830928904742447,
                0.21921880916878408,
                0.24990980721474654,
                0.2803516897311913,
                0.31051411158779074,
                0.34036700622669946,
                0.3698806156335562,
                0.39902552000092417,
                0.4277726670545996,
                0.45609340101355667,
                0.4839594911546597,
                0.511343159953671,
                0.5382171107745011,
                0.5645545550791016,
                0.5903292391308785,
                0.6155154701650072,
                0.6400881419995625,
                0.6640227600619385,
                0.6872954658056091,
                0.7098830604928968,
                0.7317630283200436,
                0.7529135588615381,
                0.7733135688113362,
                0.7929427229993089,
                0.8117814546619891,
                0.8298109849474306,
                0.8470133416347742,
                0.8633713770499171,
                0.8788687851595138,
                0.8934901178264142,
                0.9072208002105736,
                0.9200471453005002,
                0.931956367561497,
                0.9429365956884794,
                0.9529768844533735,
                0.962067225640902,
                0.9701985580742902,
                0.9773627767507059,
                0.98355274115628,
                0.9887622829898737,
                0.9929862141331123,
                0.9962203386730886,
                0.9984614938358414,
                0.9997079439521693,
            ],
            "weights": [
                0.0007494736467398138,
                0.0017439069582158347,
                0.002738075873628021,
                0.00372964348724204,
                0.004717519037520736,
                0.005700699773396526,
                0.006678200860575141,
                0.007649046279334905,
                0.008612267615478689,
                0.009566904411326498,
                0.010512004915524568,
                0.011446626951498338,
                0.01236983882217502,
                0.01328072022265703,
                0.014178363149579595,
                0.01506187280199032,
                0.015930368470960687,
                0.016782984416138656,
                0.01761887072792446,
                0.018437194174178426,
                0.01923713903048718,
                0.02001790789308651,
                0.020778722473594337,
                0.021518824374730232,
                0.022237475846239405,
                0.022933960520251186,
                0.023607584125337776,
                0.024257675178557085,
                0.02488358565478196,
                0.025484691632654845,
                0.026060393916515476,
                0.02661011863368581,
                0.02713331780651271,
                0.027629469898599088,
                0.028098080334680958,
                0.02853868199362698,
                0.02895083567407332,
                0.02933413053222754,
                0.029688184491405117,
                0.030012644622891115,
                0.03030718749774584,
                0.03057151950920587,
                0.03080537716535635,
                0.031008527351785664,
                0.031180767563958194,
                0.03132192610907524,
                0.031431862277221605,
                0.03151046648162837,
                0.03155766036791128,
                0.03157339689217573,
                0.03155766036791128,
                0.03151046648162837,
                0.031431862277221605,
                0.03132192610907524,
                0.031180767563958194,
                0.031008527351785664,
                0.03080537716535635,
                0.03057151950920587,
                0.03030718749774584,
                0.030012644622891115,
                0.029688184491405117,
                0.02933413053222754,
                0.02895083567407332,
                0.02853868199362698,
                0.028098080334680958,
                0.027629469898599088,
                0.02713331780651271,
                0.02661011863368581,
                0.026060393916515476,
                0.025484691632654845,
                0.02488358565478196,
                0.024257675178557085,
                0.023607584125337776,
                0.022933960520251186,
                0.022237475846239405,
                0.021518824374730232,
                0.020778722473594337,
                0.02001790789308651,
                0.01923713903048718,
                0.018437194174178426,
                0.01761887072792446,
                0.016782984416138656,
                0.015930368470960687,
                0.01506187280199032,
                0.014178363149579595,
                0.01328072022265703,
                0.01236983882217502,
                0.011446626951498338,
                0.010512004915524568,
                0.009566904411326498,
                0.008612267615478689,
                0.007649046279334905,
                0.006678200860575141,
                0.005700699773396526,
                0.004717519037520736,
                0.00372964348724204,
                0.002738075873628021,
                0.0017439069582158347,
                0.0007494736467398138,
            ],
            "generator": "gauss_legendre",
        },
    }


class Radau(IntervalQuadrature):
    data = {
        1: {None},
        2: {
            "degree": 3,
            "points": [-1.0, 0.3333333333333333],
            "weights": [0.5, 1.5000000000000002],
            "generator": "gauss_radau",
        },
        3: {
            "degree": 5,
            "points": [-0.999999999999998, -0.2898979485566351, 0.6898979485566356],
            "weights": [0.22222222222222354, 1.0249716523768417, 0.7528061254009351],
            "generator": "gauss_radau",
        },
        4: {
            "degree": 7,
            "points": [
                -1.0,
                -0.5753189235216946,
                0.18106627111853002,
                0.8228240809745897,
            ],
            "weights": [
                0.1249999999999997,
                0.6576886399601198,
                0.7763869376863416,
                0.4409244223535388,
            ],
            "generator": "gauss_radau",
        },
        5: {
            "degree": 9,
            "points": [
                -0.9999999999999981,
                -0.7204802713124371,
                -0.16718086473783267,
                0.44631397272375317,
                0.8857916077709646,
            ],
            "weights": [
                0.07999999999999925,
                0.4462078021671427,
                0.6236530459514837,
                0.5627120302989234,
                0.28742712158245115,
            ],
            "generator": "gauss_radau",
        },
        6: {
            "degree": 11,
            "points": [
                -1.000000000000001,
                -0.8029298284023476,
                -0.3909285467072725,
                0.12405037950522779,
                0.6039731642527839,
                0.9203802858970626,
            ],
            "weights": [
                0.05555555555555272,
                0.3196407532205138,
                0.4853871884689698,
                0.5209267831895743,
                0.4169013343119085,
                0.20158838525348047,
            ],
            "generator": "gauss_radau",
        },
        7: {
            "degree": 13,
            "points": [
                -1.0,
                -0.8538913426394823,
                -0.5384677240601097,
                -0.11734303754310071,
                0.3260306194376901,
                0.7038428006630302,
                0.9413671456804296,
            ],
            "weights": [
                0.040816326530612033,
                0.23922748922531167,
                0.3809498736442315,
                0.4471098290145656,
                0.4247037790059544,
                0.318204231467305,
                0.14898847111201885,
            ],
            "generator": "gauss_radau",
        },
        8: {
            "degree": 15,
            "points": [
                -0.999999999999999,
                -0.8874748789261552,
                -0.6395186165262147,
                -0.29475056577366077,
                0.09430725266111195,
                0.4684203544308216,
                0.770641893678192,
                0.955041227122575,
            ],
            "weights": [
                0.031249999999999375,
                0.1853581548029777,
                0.3041306206467884,
                0.37651754538911847,
                0.391572167452493,
                0.3470147956345016,
                0.24964790132986428,
                0.11450881474425688,
            ],
            "generator": "gauss_radau",
        },
        9: {
            "degree": 17,
            "points": [
                -0.9999999999999997,
                -0.9107320894200593,
                -0.7112674859157085,
                -0.42635048571113854,
                -0.09037336960685283,
                0.256135670833456,
                0.5713830412087388,
                0.8173527842004122,
                0.9644401697052731,
            ],
            "weights": [
                0.02469135802468986,
                0.14765401904631686,
                0.2471893782045919,
                0.3168437756704382,
                0.34827300277296885,
                0.33769396697592846,
                0.28638669635723,
                0.20055329802455277,
                0.0907145049232826,
            ],
            "generator": "gauss_radau",
        },
        10: {
            "degree": 19,
            "points": [
                -1.0,
                -0.9274843742335809,
                -0.7638420424200026,
                -0.5256460303700798,
                -0.23623446939058867,
                0.07605919783797788,
                0.38066484014472324,
                0.6477666876740098,
                0.8512252205816073,
                0.9711751807022453,
            ],
            "weights": [
                0.01999999999999995,
                0.1202966705574815,
                0.20427013187900203,
                0.2681948378411784,
                0.30585928772442306,
                0.3135824572269351,
                0.2906101648329181,
                0.23919343171438087,
                0.16437601273692445,
                0.0736170054867575,
            ],
            "generator": "gauss_radau",
        },
        11: {
            "degree": 21,
            "points": [
                -1.0,
                -0.9399419356770269,
                -0.8034219755802934,
                -0.6019578420737974,
                -0.35188892335333044,
                -0.07347753143132119,
                0.21072030622842575,
                0.47768064798308774,
                0.7057771007138587,
                0.8765358562457026,
                0.9761647731351679,
            ],
            "weights": [
                0.016528925619834687,
                0.09984608190796725,
                0.1713176192066597,
                0.2288661238489774,
                0.26786708618968347,
                0.2851655639410077,
                0.2793613331033843,
                0.25092537769712786,
                0.20216310854002723,
                0.13703368213320263,
                0.0609250978121278,
            ],
            "generator": "gauss_radau",
        },
        12: {
            "degree": 23,
            "points": [
                -1.0000000000000002,
                -0.9494527592049584,
                -0.8339167731051884,
                -0.6616497992456365,
                -0.4444065697819355,
                -0.19699455953427836,
                0.06372477382083264,
                0.3199836841706698,
                0.554318785912324,
                0.7507615497111135,
                0.8959290977456387,
                0.9799634390766392,
            ],
            "weights": [
                0.013888888888887842,
                0.08417213493867881,
                0.14556366885399594,
                0.19699853482609134,
                0.23500311514498806,
                0.2569913381527065,
                0.2614656605521323,
                0.24812156080401143,
                0.217868879026192,
                0.17277063931330872,
                0.11590748029173799,
                0.051248099207269096,
            ],
            "generator": "gauss_radau",
        },
        13: {
            "degree": 25,
            "points": [
                -1.0,
                -0.9568758736682993,
                -0.857884202528822,
                -0.7091050875298716,
                -0.5191977790504543,
                -0.2992013005545099,
                -0.06190169862563555,
                0.17890983759708412,
                0.4092382314748395,
                0.6156978909402926,
                0.7862910182330469,
                0.9111070736891838,
                0.9829218900231456,
            ],
            "weights": [
                0.011834319526627297,
                0.07190241629249519,
                0.1251038343311523,
                0.17100346047061707,
                0.206960611455876,
                0.23088886288699426,
                0.2413983422876918,
                0.23787854766071498,
                0.22053422928845218,
                0.19037371555963178,
                0.14915095009000126,
                0.09926780688184601,
                0.04370290326790038,
            ],
            "generator": "gauss_radau",
        },
        14: {
            "degree": 27,
            "points": [
                -1.0,
                -0.9627792699780244,
                -0.877048918201462,
                -0.747389642613379,
                -0.5803140565468752,
                -0.3842020034392035,
                -0.16888792804268116,
                0.05483122799176443,
                0.2757372054355225,
                0.48275291858847447,
                0.6654979772168834,
                0.8148095506019939,
                0.9232037225206424,
                0.985270697947821,
            ],
            "weights": [
                0.010204081632653168,
                0.06212201690777143,
                0.10860772274436306,
                0.14962053935312125,
                0.18312700212573108,
                0.20744976333517606,
                0.22136981149956975,
                0.2241893480027066,
                0.21576710060461693,
                0.19652551845298113,
                0.16742972789108995,
                0.12993966873734356,
                0.08594053544297982,
                0.03770716326989677,
            ],
            "generator": "gauss_radau",
        },
        15: {
            "degree": 29,
            "points": [
                -0.9999999999999977,
                -0.9675504681971988,
                -0.8926054001205489,
                -0.7786856176390305,
                -0.630779478886948,
                -0.4553529057785285,
                -0.2600733767408069,
                -0.05347572267974543,
                0.15541068538485991,
                0.35745651202212825,
                0.543831458701484,
                0.7063902646375728,
                0.8380290006360898,
                0.9329971909359738,
                0.9871664784143631,
            ],
            "weights": [
                0.008888888888891335,
                0.054202780048642346,
                0.09512959946047948,
                0.13187546250495158,
                0.16285447730383387,
                0.18671514583945134,
                0.20241518703061975,
                0.2092686081476937,
                0.2069759602495546,
                0.19563750304511565,
                0.175748872642447,
                0.1481795270034669,
                0.11413520348975274,
                0.07510839276050618,
                0.03286439158459372,
            ],
            "generator": "gauss_radau",
        },
        16: {
            "degree": 31,
            "points": [
                -1.0,
                -0.9714610905263485,
                -0.9054008198116666,
                -0.804573401358756,
                -0.6728619212112205,
                -0.5153294780626858,
                -0.3380303900599203,
                -0.1477783218133718,
                0.04811538307353036,
                0.24212262270604334,
                0.4267878274849457,
                0.5950144898997922,
                0.7403379488928175,
                0.8571740937696806,
                0.9410354027041141,
                0.9887186220549766,
            ],
            "weights": [
                0.007812500000000038,
                0.04770222694768599,
                0.08398528144496523,
                0.11702035310386057,
                0.1455555452202034,
                0.16849639784992157,
                0.18496178148866532,
                0.19431908971156708,
                0.1962087882390317,
                0.1905582942553541,
                0.17758479275274006,
                0.15778692180420084,
                0.13192569993306916,
                0.10099567962178446,
                0.06618950861013541,
                0.02889713901681552,
            ],
            "generator": "gauss_radau",
        },
        17: {
            "degree": 33,
            "points": [
                -1.0,
                -0.9747060412520833,
                -0.9160488353809509,
                -0.8262167530742828,
                -0.7082762955504214,
                -0.5662451079297366,
                -0.40496027585008254,
                -0.2299143037529796,
                -0.04706823205033761,
                0.13735131280874913,
                0.3170641449043541,
                0.4859503843096584,
                0.6382588806842333,
                0.768803124840368,
                0.8731381088323258,
                0.9477129726372115,
                0.9900054006724557,
            ],
            "weights": [
                0.006920415224913498,
                0.04230158951731019,
                0.07467143455161619,
                0.10448032169818759,
                0.13072873735310514,
                0.1525247060771516,
                0.16912641012270369,
                0.17996862815731005,
                0.1846821930762528,
                0.18310661712863807,
                0.17529557640022056,
                0.16151509638994552,
                0.1422345171369415,
                0.11811058827403058,
                0.08996545627634521,
                0.05876112752157939,
                0.025606585093749055,
            ],
            "generator": "gauss_radau",
        },
        18: {
            "degree": 35,
            "points": [
                -1.0,
                -0.977428081264488,
                -0.9250023956467008,
                -0.8444860691845972,
                -0.7383321191348275,
                -0.6097671570499337,
                -0.4626979054681033,
                -0.30159311690676427,
                -0.1313479337732686,
                0.04286480629384104,
                0.2157517305558091,
                0.38205976449560886,
                0.5367357484456556,
                0.675079993143727,
                0.792889134129606,
                0.8865840624618435,
                0.9533198117524515,
                0.9910840128644252,
            ],
            "weights": [
                0.006172839506172243,
                0.037766623512008615,
                0.06681191753752674,
                0.09381102938618877,
                0.11795749924358352,
                0.13851932451549415,
                0.15487211549710705,
                0.16651911538405367,
                0.1731064804826022,
                0.1744340786060745,
                0.1704615856252496,
                0.16130971859643545,
                0.14725657664876604,
                0.1287292114721158,
                0.10629072030769382,
                0.0806234497202777,
                0.052510454797875264,
                0.022847259160774236,
            ],
            "generator": "gauss_radau",
        },
        19: {
            "degree": 37,
            "points": [
                -1.0,
                -0.9797336964051944,
                -0.9326015038912653,
                -0.8600417793993865,
                -0.7640396507241585,
                -0.6472148595497397,
                -0.5127543868123015,
                -0.3643260782273031,
                -0.2059787211196642,
                -0.04203164174155294,
                0.12304310155172327,
                0.2847427000467311,
                0.4386564198796563,
                0.5805859208223136,
                0.7066597926447638,
                0.81343920814291,
                0.8980119168242184,
                0.9580727032124667,
                0.9919970412322645,
            ],
            "weights": [
                0.00554016620498614,
                0.033922137462156006,
                0.06012153016985569,
                0.08466649695087268,
                0.10689997538541816,
                0.12621699523060087,
                0.14209097024117573,
                0.1540890016881836,
                0.16188385365662966,
                0.16526292104495424,
                0.16413404232328538,
                0.15852801920422446,
                0.14859778071899984,
                0.13461421851502184,
                0.1169588154189077,
                0.09611330091239415,
                0.07264679134280502,
                0.0472022313072817,
                0.02051075222224728,
            ],
            "generator": "gauss_radau",
        },
        20: {
            "degree": 39,
            "points": [
                -1.0,
                -0.9817036105419115,
                -0.9391052741604419,
                -0.8733916961487301,
                -0.78618626996369,
                -0.6796372314174222,
                -0.5563684459535236,
                -0.4194153033078054,
                -0.27215008975854205,
                -0.11819898529806427,
                0.03864721284289652,
                0.19452642766984507,
                0.3456003984723759,
                0.4881491930357942,
                0.6186628101904739,
                0.7339276228838023,
                0.83110555443158,
                0.907804133903138,
                0.9621363259368227,
                0.9927767143628856,
            ],
            "weights": [
                0.0049999999999999715,
                0.03063502654430823,
                0.05438111425973006,
                0.07677511310468157,
                0.0972768461107785,
                0.1153828451440001,
                0.13064757887435294,
                0.1426952703421887,
                0.15122930020129546,
                0.15603954805397818,
                0.15700757819490072,
                0.15410956057594527,
                0.1474168602357906,
                0.13709428292648856,
                0.12339602275669403,
                0.1066594189016548,
                0.08729670433750222,
                0.06578510807928707,
                0.04265687653887113,
                0.0185149448175527,
            ],
            "generator": "gauss_radau",
        },
        21: {
            "degree": 41,
            "points": [
                -0.9999999999999997,
                -0.983399911585865,
                -0.944713893294873,
                -0.8849310847263717,
                -0.805391743586907,
                -0.7078735060717799,
                -0.5945550166731898,
                -0.46796771647131885,
                -0.33093939781102655,
                -0.18653106696701227,
                -0.0379685774071471,
                0.11142942607397843,
                0.2583256388312064,
                0.3994386463281001,
                0.531616227372816,
                0.6519057747289156,
                0.7576202653526479,
                0.846398325820756,
                0.9162571377644697,
                0.9656375637094885,
                0.9934477866618998,
            ],
            "weights": [
                0.004535147392289454,
                0.027802721117422494,
                0.04942017564948912,
                0.0699218415044895,
                0.08885993209894245,
                0.10581262693619761,
                0.1204015008551054,
                0.13230074507880865,
                0.14124458141013502,
                0.14703323324784554,
                0.14953739892167028,
                0.1487011441207444,
                0.14454315334014348,
                0.13715631402877265,
                0.12670564386242894,
                0.11342460951259727,
                0.0976099256101211,
                0.07961497651447813,
                0.05984215127323751,
                0.03873546133861913,
                0.016796716186461714,
            ],
            "generator": "gauss_radau",
        },
        22: {
            "degree": 43,
            "points": [
                -1.0,
                -0.984870981451243,
                -0.9495839513207313,
                -0.8949710888127949,
                -0.8221485316052317,
                -0.7325995179419131,
                -0.628147233025395,
                -0.5109181088993742,
                -0.38329863002592424,
                -0.2478867794425642,
                -0.1074391614565875,
                0.035185110775121986,
                0.1770826168761892,
                0.3153647340825385,
                0.44721644181243314,
                0.5699536292839593,
                0.6810777411118687,
                0.7783266533592723,
                0.8597207618753471,
                0.9236034235098529,
                0.9686754388848517,
                0.9940295254335727,
            ],
            "weights": [
                0.0041322314049586,
                0.02534516517929636,
                0.045104568215282005,
                0.063935006184142,
                0.08146242260323061,
                0.09733112481423561,
                0.11121831731510391,
                0.12284137185608844,
                0.13196370483611394,
                0.13839962433639105,
                0.14201811991591723,
                0.1427455331958473,
                0.14056705894365848,
                0.1355270474610686,
                0.12772810279338215,
                0.11732899587425606,
                0.1045414368667833,
                0.08962577824749965,
                0.07288576014009986,
                0.054662535451801095,
                0.03532918780364094,
                0.015306906561203091,
            ],
            "generator": "gauss_radau",
        },
        23: {
            "degree": 45,
            "points": [
                -1.0,
                -0.9861549700886965,
                -0.9538393264742577,
                -0.9037591864594399,
                -0.8368514499796985,
                -0.75436319493084,
                -0.6578312272434531,
                -0.5490538321296452,
                -0.43005736094952507,
                -0.30305850979162896,
                -0.1704230359025981,
                -0.03462169190198239,
                0.1018157980263652,
                0.23634786148649933,
                0.36646842257910484,
                0.4897535860566258,
                0.6039067917636347,
                0.7068015996846686,
                0.7965213130956714,
                0.8713947177356813,
                0.9300273432975668,
                0.9713281330325998,
                0.9945371079822303,
            ],
            "weights": [
                0.0037807183364838895,
                0.02319914581676493,
                0.04132763837538364,
                0.05867643055799611,
                0.0749308311418059,
                0.08978907050309821,
                0.1029745919728143,
                0.11424184258789863,
                0.1233809605081703,
                0.13022171253645543,
                0.13463667402492713,
                0.136543605792474,
                0.13590698748007676,
                0.13273867997834213,
                0.12709770508554538,
                0.11908914686440958,
                0.10886219575965518,
                0.0966073734967861,
                0.08255299577674118,
                0.06696096061931855,
                0.05012206019956411,
                0.032351901619240495,
                0.014006770966048163,
            ],
            "generator": "gauss_radau",
        },
        24: {
            "degree": 47,
            "points": [
                -1.0000000000000004,
                -0.9872822846827322,
                -0.9575790350341441,
                -0.9114941101527604,
                -0.8498197084151845,
                -0.7736117501215859,
                -0.6841743631520284,
                -0.5830379167843988,
                -0.4719329150899937,
                -0.35276041107190437,
                -0.22755948764445677,
                -0.09847237186742885,
                0.0322922175960072,
                0.1624968615909379,
                0.289913723146654,
                0.4123626665988258,
                0.5277485610600682,
                0.6340971304475864,
                0.7295887380272382,
                0.8125895315487204,
                0.8816794307722184,
                0.9356765446347289,
                0.9736580299992622,
                0.9949826207220345,
            ],
            "weights": [
                0.003472222222220885,
                0.021314219142218274,
                0.03800377096517013,
                0.05403403089987985,
                0.06913850535413023,
                0.08305968769383665,
                0.09555958822438387,
                0.1064243927935216,
                0.11546822509765671,
                0.12253635292550093,
                0.12750784371078044,
                0.13029763666944452,
                0.13085799945609933,
                0.1291793454961773,
                0.1252903984236305,
                0.11925770103706229,
                0.11118447742341925,
                0.10120886823026581,
                0.08950157072054676,
                0.07626292886189853,
                0.06171954338618645,
                0.04612056940151992,
                0.029734681241544887,
                0.0128654406229042,
            ],
            "generator": "gauss_radau",
        },
        25: {
            "degree": 49,
            "points": [
                -1.0,
                -0.9882774004199696,
                -0.9608829735441546,
                -0.9183368667912291,
                -0.8613134401536147,
                -0.7907125892435223,
                -0.707647905094505,
                -0.6134294324617324,
                -0.5095430818381945,
                -0.3976272174245109,
                -0.27944682699460865,
                -0.15686569022587615,
                -0.03181698724059556,
                0.09372718812427805,
                0.21778692914562847,
                0.33840574053140116,
                0.4536813938100588,
                0.5617959273460071,
                0.6610443183251715,
                0.7498613758003376,
                0.8268464344899467,
                0.8907854734329141,
                0.9406703715718621,
                0.9757153924578508,
                0.9953757847644025,
            ],
            "weights": [
                0.0031999999999999524,
                0.019649739677902935,
                0.035063625373687256,
                0.04991621210311337,
                0.06398044116768545,
                0.07703537239350271,
                0.08887531092952838,
                0.09931359144477568,
                0.10818561761075063,
                0.11535148167318389,
                0.12069817827420283,
                0.12414138931549176,
                0.12562681483060584,
                0.12513102986448713,
                0.12266185421174049,
                0.11825822935246685,
                0.11198960465555526,
                0.10395484272463017,
                0.0942806616065065,
                0.0831196397472679,
                0.07064781964165784,
                0.05706196651836141,
                0.04257662622717999,
                0.027421872952792768,
                0.0118580777029218,
            ],
            "generator": "gauss_radau",
        },
        26: {
            "degree": 51,
            "points": [
                -1.0,
                -0.9891601960799508,
                -0.9638161746693923,
                -0.9244189731814625,
                -0.8715462170626063,
                -0.8059694661908475,
                -0.7286451373151425,
                -0.6407008532771362,
                -0.5434190664181751,
                -0.4382183775405515,
                -0.32663285676038323,
                -0.21028967631026962,
                -0.0908853840665177,
                0.02983883528916853,
                0.15012255036570354,
                0.26821175403072606,
                0.38238444087541,
                0.4909757182459802,
                0.5924020848337244,
                0.6851845232226679,
                0.7679700708250254,
                0.8395515581753294,
                0.8988852392615743,
                0.9451061130713603,
                0.9775410787886956,
                0.995724490318441,
            ],
            "weights": [
                0.0029585798816567613,
                0.018172664828839998,
                0.03245057748738162,
                0.04624759407972411,
                0.05936915510349676,
                0.0716247142502115,
                0.0828357325943138,
                0.09283878136811476,
                0.10148801349511143,
                0.1086573123372973,
                0.11424213758207476,
                0.11816105216302852,
                0.12035691082527555,
                0.12079769391124584,
                0.11947697453857895,
                0.11641401249918445,
                0.11165347359394917,
                0.10526477858521523,
                0.0973410914279083,
                0.08799796194865583,
                0.0773716439795217,
                0.06561711761081862,
                0.05290586154151114,
                0.03942350128578966,
                0.025368147843871362,
                0.01096451523722247,
            ],
            "generator": "gauss_radau",
        },
        27: {
            "degree": 53,
            "points": [
                -0.9999999999999999,
                -0.9899469517144245,
                -0.9664319997323673,
                -0.9298486784711372,
                -0.8806946114437336,
                -0.8196350381545322,
                -0.7474958327540103,
                -0.665252609758619,
                -0.5740175923186298,
                -0.47502458983451723,
                -0.3696123195127542,
                -0.2592063052927337,
                -0.14529960135007391,
                -0.0294326017162837,
                0.08682779060724155,
                0.20190935319951786,
                0.3142558058314304,
                0.42234785661453744,
                0.5247237481343658,
                0.6199990258800345,
                0.7068852620437777,
                0.784207482570266,
                0.8509200650500451,
                0.9061209040545523,
                0.949063704499088,
                0.979168575929815,
                0.996035195374998,
            ],
            "weights": [
                0.0027434842249651234,
                0.016855911921446438,
                0.030118032763424313,
                0.042965727151415195,
                0.05523140026275151,
                0.06674991720858457,
                0.07736567165224559,
                0.0869351529038883,
                0.09532896854937978,
                0.10243361461105673,
                0.10815301681048582,
                0.11240983210834425,
                0.11514649558442565,
                0.11632599933983166,
                0.11593239319073398,
                0.11397100050743308,
                0.11046834634339554,
                0.10547179887613731,
                0.09904892907963377,
                0.0912865974366896,
                0.08228978042388746,
                0.07218015376192102,
                0.061094455424497575,
                0.049182666425625986,
                0.03660612044352125,
                0.02353629124599675,
                0.01016824174828188,
            ],
            "generator": "gauss_radau",
        },
        28: {
            "degree": 55,
            "points": [
                -1.0,
                -0.9906511026542187,
                -0.9687745604655731,
                -0.934715713987627,
                -0.8889055653975015,
                -0.8319206823807117,
                -0.7644778204682794,
                -0.6874251642933811,
                -0.6017317185749748,
                -0.5084751395280385,
                -0.4088281889437716,
                -0.3040439886131191,
                -0.19544026277563087,
                -0.0843827675523725,
                0.027731883936836565,
                0.1394937846540858,
                0.24949746400047434,
                0.3563595624656648,
                0.4587362283192342,
                0.5553400176338579,
                0.6449560852681606,
                0.7264574635788943,
                0.7988192377346288,
                0.8611314424021348,
                0.9126105283908839,
                0.9526093035216991,
                0.9806255379609188,
                0.996313226676812,
            ],
            "weights": [
                0.0025510204081632204,
                0.01567711457711172,
                0.02802737614713289,
                0.04001854787029346,
                0.05150554928172092,
                0.062344609867739695,
                0.07239957249811656,
                0.08154403584215332,
                0.08966302004041142,
                0.0966544315485306,
                0.1024303528879103,
                0.10691815039283008,
                0.11006138849830961,
                0.11182053984979777,
                0.11217348258432303,
                0.11111577864258267,
                0.10866072966510268,
                0.10483920980307018,
                0.09969927758144267,
                0.09330557175594269,
                0.08573849889729152,
                0.07709322327267805,
                0.0674784727698789,
                0.05701517944216394,
                0.045834986529768924,
                0.03407872109382844,
                0.02189552397071545,
                0.009455634280989623,
            ],
            "generator": "gauss_radau",
        },
        29: {
            "degree": 57,
            "points": [
                -1.0,
                -0.9912838155284457,
                -0.9708805751658466,
                -0.9390949538760438,
                -0.8963021179339513,
                -0.8430042198947189,
                -0.7798262569447872,
                -0.7075089808644179,
                -0.6269002668564793,
                -0.5389451890084362,
                -0.44467494596538815,
                -0.34519477347467575,
                -0.24167098761023775,
                -0.13531731132705827,
                -0.027380644949465682,
                0.0808735524521893,
                0.1881760993508239,
                0.2932689717547077,
                0.3949200524490091,
                0.4919375765896359,
                0.583184104350871,
                0.6675898569569834,
                0.7441652601005548,
                0.8120125486293728,
                0.8703362992737838,
                0.9184527779604499,
                0.9557980372844257,
                0.9819349630093797,
                0.996563009413195,
            ],
            "weights": [
                0.002378121284185458,
                0.01461767133772945,
                0.02614639276209,
                0.03736239336672218,
                0.04813950271968342,
                0.058352007502898574,
                0.0678803154693491,
                0.07661275842623533,
                0.08444697234747606,
                0.09129111510804025,
                0.09706494871001221,
                0.10170078198528164,
                0.10514426502764425,
                0.10735502676527926,
                0.10830714845835299,
                0.10798946767439634,
                0.1064057092244208,
                0.10357444155041211,
                0.09952885909621971,
                0.09431639324128711,
                0.08799815641263173,
                0.08064822601766636,
                0.07235277692157545,
                0.06320907361076106,
                0.053324337176535966,
                0.042814514155042865,
                0.0318030365464868,
                0.020420214345132172,
                0.008815372756450708,
            ],
            "generator": "gauss_radau",
        },
        30: {
            "degree": 59,
            "points": [
                -0.9999999999999986,
                -0.9918544327214188,
                -0.9727808050785783,
                -0.9430492617119831,
                -0.9029878912329529,
                -0.8530360305438803,
                -0.7937410822005916,
                -0.7257527387724884,
                -0.6498159146010974,
                -0.566762599321173,
                -0.4775027478238817,
                -0.3830143128461695,
                -0.28433253134637126,
                -0.1825385827415661,
                -0.07874774354544722,
                0.02590283169392571,
                0.13026656922794888,
                0.233200038187786,
                0.33357547827197165,
                0.43029315579296323,
                0.5222934127332672,
                0.6085682768597533,
                0.6881725058312342,
                0.760233944630206,
                0.8239630837202256,
                0.8786617158468355,
                0.9237306060057757,
                0.9586761327276817,
                0.9831161023919377,
                0.9967882442949197,
            ],
            "weights": [
                0.0022222222222229946,
                0.013662010682415373,
                0.024448040257753077,
                0.03496044020978953,
                0.045089011200102926,
                0.05472337879976086,
                0.06375811761328545,
                0.07209428082328899,
                0.07964055049676273,
                0.08631425452677428,
                0.09204227750318376,
                0.0967618636328289,
                0.10042130506473433,
                0.10298050875544093,
                0.10441143590590621,
                0.1046984092517539,
                0.10383828488264564,
                0.10184048672982073,
                0.09872690335826559,
                0.09453164820910277,
                0.0893006859429133,
                0.08309132902706154,
                0.07597161019887629,
                0.06801953798643073,
                0.0593222443496529,
                0.049975036879062386,
                0.040080378781463755,
                0.029746877786174544,
                0.019088880646578103,
                0.00823798827594799,
            ],
            "generator": "gauss_radau",
        },
        31: {
            "degree": 61,
            "points": [
                -1.0,
                -0.9923708185065793,
                -0.9745011759334659,
                -0.9466317227870897,
                -0.9090506314865004,
                -0.8621439243422729,
                -0.806393039447123,
                -0.742370098123899,
                -0.6707320809141951,
                -0.5922141000654906,
                -0.5076218613509869,
                -0.4178233985386316,
                -0.3237401671544149,
                -0.22633758958022954,
                -0.1266151487649132,
                -0.025596132312383446,
                0.07568286776215039,
                0.17618259183735097,
                0.2748717768948157,
                0.3707377387031261,
                0.46279676339973497,
                0.5501042018651481,
                0.6317641633651239,
                0.7069387091205901,
                0.7748564517781265,
                0.834820473362105,
                0.886215482929489,
                0.9285141492501869,
                0.9612825830219471,
                0.9841851693600752,
                0.9969920453467223,
            ],
            "weights": [
                0.002081165452653426,
                0.012797018009642922,
                0.02290948642335658,
                0.03278146834140626,
                0.04231632384234066,
                0.05141677064194873,
                0.05998954820740084,
                0.06794672535310319,
                0.0752066645267356,
                0.08169487491046427,
                0.08734478156732593,
                0.09209841032274872,
                0.09590698336787039,
                0.09873142010604997,
                0.10054273832950116,
                0.10132235169926063,
                0.10106226051510832,
                0.09976513383686417,
                0.09744428212553442,
                0.09412352069416823,
                0.08983692538146285,
                0.08462848297646061,
                0.07855164002697723,
                0.0716687547700606,
                0.06405045809496084,
                0.055774930943710756,
                0.04692710846456287,
                0.037597831109492684,
                0.027883016885920982,
                0.01788341159189867,
                0.007715511481006965,
            ],
            "generator": "gauss_radau",
        },
        32: {
            "degree": 63,
            "points": [
                -1.0,
                -0.9928396309426932,
                -0.9760636609903446,
                -0.949887408508848,
                -0.9145650236298253,
                -0.8704370454956689,
                -0.817928555473052,
                -0.7575452781951043,
                -0.6898687549842124,
                -0.615550756415883,
                -0.5353070101614041,
                -0.4499103101081322,
                -0.36018307483614265,
                -0.2669894277269901,
                -0.1712268752199857,
                -0.0738176634642197,
                0.024300103344750745,
                0.12218149738496598,
                0.21888386736788124,
                0.31347591679544085,
                0.40504667288918417,
                0.4927142598270664,
                0.5756343918223914,
                0.6530085043064482,
                0.7240914450288884,
                0.7881986512984203,
                0.8447127450151706,
                0.8930894842974744,
                0.9328630226122379,
                0.9636504618094672,
                0.985155896347087,
                0.9971770480691116,
            ],
            "weights": [
                0.0019531249999999345,
                0.012011585075554877,
                0.0215113487509174,
                0.03079887576103193,
                0.03978909469956358,
                0.04839594854163394,
                0.05653666334419624,
                0.06413287436898563,
                0.07111143893338018,
                0.07740515524848744,
                0.08295341408171582,
                0.08770278408089684,
                0.09160752701241459,
                0.09463003854492483,
                0.09674121054581288,
                0.09792071148527715,
                0.09815718228399743,
                0.09744834573556514,
                0.0958010284591409,
                0.09323109517751645,
                0.08976329596003949,
                0.08543102791174169,
                0.0802760136230799,
                0.0743478995193285,
                0.06770377807936433,
                0.06040763879360492,
                0.05252975394376327,
                0.04414600784022049,
                0.03533718725752938,
                0.02618830135572891,
                0.016788452159654216,
                0.007241196424930919,
            ],
            "generator": "gauss_radau",
        },
        33: {
            "degree": 65,
            "points": [
                -0.9999999999999999,
                -0.9932665371803572,
                -0.9774869817634827,
                -0.9528547813626708,
                -0.9195949441144974,
                -0.8780090195224856,
                -0.82847371462362,
                -0.7714376655910656,
                -0.7074174160053374,
                -0.6369927512877455,
                -0.5608014525356037,
                -0.4795335225272558,
                -0.393924937799467,
                -0.3047509839523087,
                -0.21281923476598796,
                -0.11896223881088808,
                -0.024029979828091297,
                0.07111782081724227,
                0.1656194898886172,
                0.2586192057236544,
                0.3492747487031065,
                0.43676512855871497,
                0.5202980194573875,
                0.5991169355528467,
                0.6725080820733962,
                0.7398068200158766,
                0.8004036861750159,
                0.85374991471541,
                0.899362412458895,
                0.936828150562535,
                0.9658079676423548,
                0.9860399766002637,
                0.9973454950332497,
            ],
            "weights": [
                0.0018365472910920884,
                0.01129625289159199,
                0.020237089080590385,
                0.02898988800400717,
                0.037479493911880095,
                0.04562951589272046,
                0.05336625393708886,
                0.06061967563656254,
                0.06732410507242374,
                0.07341883115214978,
                0.07884866162095243,
                0.08356442441696611,
                0.08752341360538869,
                0.09068977641103046,
                0.09303483804335734,
                0.09453736145130076,
                0.09518373968941264,
                0.09496811916923346,
                0.09389245268794341,
                0.09196648175910677,
                0.08920764840984456,
                0.08564093724848483,
                0.08129864924197727,
                0.0762201092697169,
                0.07045131014180274,
                0.06404449640094399,
                0.05705769192936143,
                0.0495541763859308,
                0.041601917771926726,
                0.03327297686800405,
                0.024642946708803293,
                0.015790915917232293,
                0.006809301981171226,
            ],
            "generator": "gauss_radau",
        },
        34: {
            "degree": 67,
            "points": [
                -1.0,
                -0.9936563852451316,
                -0.9787871681563945,
                -0.9555668214962498,
                -0.9241952755802746,
                -0.8849405045783173,
                -0.8381375090318073,
                -0.7841856302018511,
                -0.723545181814261,
                -0.6567335344345163,
                -0.5843207056439168,
                -0.506924498590913,
                -0.4252052319117905,
                -0.33986010652255205,
                -0.25161725755713205,
                -0.16122954229203512,
                -0.06946811710015965,
                0.02288414174567044,
                0.11503931727735961,
                0.20621117405476985,
                0.29562186605440743,
                0.3825085729957596,
                0.4661300084917668,
                0.5457727445095573,
                0.620757298206609,
                0.6904439292603133,
                0.7542380983380932,
                0.811595540396747,
                0.862026910210479,
                0.9051019625433245,
                0.9404532385833326,
                0.9677792599863326,
                0.9868474168022883,
                0.9974993041333247,
            ],
            "weights": [
                0.0017301038062283178,
                0.010642926580880124,
                0.019072528313326148,
                0.02733491998030081,
                0.0353634819281751,
                0.043090180897765985,
                0.050449196964706046,
                0.057377776368337595,
                0.06381681838350486,
                0.06971139231979508,
                0.07501121012704663,
                0.07967105687107189,
                0.08365117707894598,
                0.08691761418282315,
                0.08944250035378846,
                0.09120429432711938,
                0.09218796522186902,
                0.09238512080130311,
                0.09179407908745435,
                0.09041988272302523,
                0.08827425596128897,
                0.0853755046539544,
                0.08174836009492954,
                0.07742376806036541,
                0.07243862486162518,
                0.06683546270018578,
                0.060662087098736564,
                0.05397116973906731,
                0.04681980088404735,
                0.03926900760993711,
                0.0313832519455007,
                0.02322996761270816,
                0.01487959497324001,
                0.006414917486945504,
            ],
            "generator": "gauss_radau",
        },
        35: {
            "degree": 69,
            "points": [
                -1.0,
                -0.9940133420661593,
                -0.9799780093057533,
                -0.9580519360477159,
                -0.9284133775991198,
                -0.8913012710546565,
                -0.8470145086602678,
                -0.7959096940043953,
                -0.7383983074387198,
                -0.6749434040288641,
                -0.6060558892668351,
                -0.5322904072010773,
                -0.4542408755222046,
                -0.37253570406194125,
                -0.2878327354054786,
                -0.20081394844048894,
                -0.11217996752784665,
                -0.022644421523270508,
                0.06707180192190876,
                0.15624636051468,
                0.24416127319515524,
                0.3301087009062549,
                0.4133966457171516,
                0.4933545224199072,
                0.5693385577510539,
                0.6407369737888728,
                0.70697491383868,
                0.7675190712476188,
                0.8218819841241807,
                0.8696259620280771,
                0.9103666149483967,
                0.9437759630252265,
                0.9695851329209506,
                0.9875868205964289,
                0.9976401233986514,
            ],
            "weights": [
                0.0016326530612244294,
                0.010044646097612029,
                0.018005454799279057,
                0.02581705776895096,
                0.03342021416912802,
                0.040754145219774975,
                0.047759898200957385,
                0.054381095923980986,
                0.06056443921167147,
                0.06626014807983983,
                0.07142236626750528,
                0.07600953179835152,
                0.0799847121670065,
                0.08331590194671268,
                0.08597628059900056,
                0.08794442847955422,
                0.0892044993311517,
                0.08974634788879224,
                0.08956561157651152,
                0.08866374564192679,
                0.08704801144806522,
                0.08473141801879172,
                0.08173261731105874,
                0.0780757540611847,
                0.07379027142172687,
                0.06891067396953433,
                0.0634762500281184,
                0.05753075562460999,
                0.05112206284973563,
                0.04430177611552529,
                0.03712482167163506,
                0.029649023106264206,
                0.021934717587889334,
                0.014044845875057915,
                0.006053822681869753,
            ],
            "generator": "gauss_radau",
        },
        36: {
            "degree": 71,
            "points": [
                -1.0000000000000004,
                -0.9943410051206263,
                -0.9810714188158196,
                -0.96033469768808,
                -0.9322902856248634,
                -0.8971519055561503,
                -0.855187064308518,
                -0.8067151704603956,
                -0.7521051380148795,
                -0.6917725890841515,
                -0.6261766944939953,
                -0.5558166807658769,
                -0.4812280314131323,
                -0.40297841194219797,
                -0.32166334976324507,
                -0.23790170197186478,
                -0.1523309455336166,
                -0.06560232573525271,
                0.02162410016426497,
                0.1086844863569596,
                0.19491625074949404,
                0.2796631176157318,
                0.36228011226133516,
                0.44213846969053106,
                0.5186304199224935,
                0.5911738135487322,
                0.6592165523491407,
                0.7222407912905588,
                0.7797668800242779,
                0.8313570141155464,
                0.8766185688255689,
                0.9152070919004656,
                0.9468289390802525,
                0.9712435615117714,
                0.9882656180573681,
                0.9977693753070477,
            ],
            "weights": [
                0.0015432098765421325,
                0.009495400650994985,
                0.017025306344061665,
                0.02442163545246902,
                0.031631550487151744,
                0.03860059293883882,
                0.04527581467951713,
                0.05160644064790561,
                0.05754430116917334,
                0.0630442099383614,
                0.06806431144008547,
                0.07256640077295044,
                0.07651621493475314,
                0.07988369381946833,
                0.08264320910675273,
                0.0847737593678888,
                0.0862591299317295,
                0.08708801630697145,
                0.08725411022800324,
                0.0867561476727981,
                0.0855979184895574,
                0.08378823756036687,
                0.08134087772280536,
                0.07827446496228081,
                0.07461233667633559,
                0.07038236409677759,
                0.06561674023584776,
                0.06035173500333852,
                0.05462741943822779,
                0.04848736136504714,
                0.04197829541809562,
                0.03514977209080399,
                0.02805379738384002,
                0.020744514311790422,
                0.01327833503349188,
                0.005722374444975732,
            ],
            "generator": "gauss_radau",
        },
        37: {
            "degree": 73,
            "points": [
                -1.0,
                -0.9946424933026509,
                -0.982077732450778,
                -0.9624364479869478,
                -0.9358616937913223,
                -0.9025452141275779,
                -0.8627271330777146,
                -0.8166943699541167,
                -0.7647786047489524,
                -0.7073538981582,
                -0.6448340000035773,
                -0.5776693696209932,
                -0.5063439309635486,
                -0.43137158625326466,
                -0.35329251348158985,
                -0.27266927451397016,
                -0.19008276187649753,
                -0.10612801344640288,
                -0.021409925211109293,
                0.06346110700944929,
                0.14787358547315632,
                0.2312193163705223,
                0.31289779187966804,
                0.39232051684981073,
                0.4689152489420314,
                0.5421301216822443,
                0.6114376207297385,
                0.6763383847320292,
                0.7363648034219967,
                0.7910843871239015,
                0.8401028836087632,
                0.8830671204178813,
                0.9196675539039101,
                0.9496405127656216,
                0.9727701475881123,
                0.988890252565676,
                0.9978882928362052,
            ],
            "weights": [
                0.0014609203798392565,
                0.008989977571490108,
                0.01612291046826762,
                0.023135887706835657,
                0.029981649193028644,
                0.03661126222479379,
                0.04297704592089299,
                0.049033160593056645,
                0.05473598145450086,
                0.060044423709541536,
                0.06492024190545266,
                0.06932830670147182,
                0.07323685847099491,
                0.07661773635248151,
                0.0794465812567488,
                0.08170301143041146,
                0.08337076933733256,
                0.0844378388121301,
                0.08489653164775629,
                0.08474354299642252,
                0.08397997518656722,
                0.0826113297854863,
                0.08064746796584704,
                0.07810253946294284,
                0.07499488063642518,
                0.07134688237444092,
                0.06718482879857185,
                0.06253870794563332,
                0.05744199582169669,
                0.05193141545966151,
                0.04604667291652762,
                0.03983017270566625,
                0.03332671674531248,
                0.026583197418265207,
                0.01964833287714862,
                0.012572831138804188,
                0.0054174146275529425,
            ],
            "generator": "gauss_radau",
        },
        38: {
            "degree": 75,
            "points": [
                -1.0,
                -0.9949205213190917,
                -0.9830059521775563,
                -0.9643757930909057,
                -0.9391587647717254,
                -0.9075273833903681,
                -0.8696977973357819,
                -0.8259284486269657,
                -0.7765183384919483,
                -0.7218049941593203,
                -0.6621621665568596,
                -0.5979972786018505,
                -0.5297486427267147,
                -0.4578824670778474,
                -0.3828896710096874,
                -0.3052825317019905,
                -0.22559118484219642,
                -0.14436000329411602,
                -0.06214387849933456,
                0.020495569982036832,
                0.10299383089596326,
                0.18478735747649022,
                0.26531741704311296,
                0.3440339077172252,
                0.4203991161869105,
                0.49389139085335887,
                0.5640087052726475,
                0.6302720875605423,
                0.6922288923528532,
                0.7494558930095674,
                0.8015621730261215,
                0.8481917971069093,
                0.8890262442005172,
                0.9237865875146267,
                0.9522354124401715,
                0.9741784855171789,
                0.98946633388374,
                0.997997948967617,
            ],
            "weights": [
                0.0013850415512465164,
                0.008523838507027533,
                0.015290271062843093,
                0.021948663125942642,
                0.02845662962633253,
                0.03477008532225446,
                0.04084598406380218,
                0.04664284586993513,
                0.052121081445641836,
                0.05724327282592933,
                0.06197443213869633,
                0.06628224175346178,
                0.07013727551196745,
                0.07351319994897117,
                0.07638695427841119,
                0.07873890797456824,
                0.080552994897181,
                0.08181682305600285,
                0.08252175927066184,
                0.0826629881505822,
                0.0822395449936384,
                0.08125432237991403,
                0.07971405041630218,
                0.07762925076769811,
                0.07501416478983883,
                0.07188665625652256,
                0.06826808934881617,
                0.06418318274604107,
                0.059659840828403775,
                0.05472896317396214,
                0.04942423372276074,
                0.04378189123798584,
                0.03784048319427982,
                0.03164060669921204,
                0.025224646204236777,
                0.018636553327975366,
                0.011922034922221015,
                0.005136194608731812,
            ],
            "generator": "gauss_radau",
        },
        39: {
            "degree": 77,
            "points": [
                -1.0000000000000009,
                -0.9951774609379771,
                -0.9838639473207904,
                -0.9661690130855107,
                -0.9422088004762903,
                -0.9121389458016151,
                -0.876154533801847,
                -0.8344889633655148,
                -0.7874124632692414,
                -0.7352303484400546,
                -0.6782810430511272,
                -0.6169338870279939,
                -0.5515867413418636,
                -0.482663408029397,
                -0.41061088183364935,
                -0.33589645136110335,
                -0.259004668587999,
                -0.18043420638634355,
                -0.10069462445834709,
                -0.020303064658070635,
                0.06021910286503018,
                0.14034966094828427,
                0.21956893219418516,
                0.29736314928040297,
                0.3732277869442536,
                0.44667083403377617,
                0.517215984407513,
                0.584405725993617,
                0.64780430798366,
                0.7070005669356698,
                0.7616105934950619,
                0.81128022252059,
                0.8556873306617131,
                0.8945439270044845,
                0.9275980247818623,
                0.9546352875348229,
                0.9754804639494172,
                0.9899987642393635,
                0.9980992809675178,
            ],
            "weights": [
                0.0013149243918459674,
                0.008093017446571888,
                0.014520392224728939,
                0.020850186508141456,
                0.027044290526155364,
                0.03306288506464651,
                0.03886701424749848,
                0.04441905938182529,
                0.04968302200377116,
                0.05462476703137862,
                0.05921224714260042,
                0.06341571170191007,
                0.0672079001489545,
                0.07056421899320536,
                0.07346290140876734,
                0.07588514845045492,
                0.07781525099932388,
                0.07924069165788845,
                0.08015222593964005,
                0.0805439422290327,
                0.08041330012473055,
                0.07976114691826106,
                0.07859171210190748,
                0.07691257994198898,
                0.07473464029607452,
                0.07207201799401196,
                0.06894198124242966,
                0.06536482964971564,
                0.061363762603642784,
                0.05696472886775685,
                0.05219625840003975,
                0.047089277552436935,
                0.04167690902968007,
                0.03599425843823798,
                0.03007819063660014,
                0.023967104918035304,
                0.01770075180554308,
                0.011320438786016346,
                0.004876313194548025,
            ],
            "generator": "gauss_radau",
        },
        40: {
            "degree": 79,
            "points": [
                -1.0,
                -0.9954153916787257,
                -0.9846586212247592,
                -0.9678304017664825,
                -0.9450358001527009,
                -0.9164155856388388,
                -0.8821462780565977,
                -0.8424391839392783,
                -0.7975391217070817,
                -0.7477229206417213,
                -0.6932977171633037,
                -0.6345990624830787,
                -0.5719888543927607,
                -0.5058531063300129,
                -0.43659956762900554,
                -0.3646552096951883,
                -0.2904635936343134,
                -0.2144821355808012,
                -0.13717928659378487,
                -0.05903164451215481,
                0.019478984422543588,
                0.09786855605792488,
                0.17565377262253135,
                0.25235506241817185,
                0.3274995365422493,
                0.4006239044115518,
                0.4712773301137232,
                0.5390242119785582,
                0.6034468682367735,
                0.6641481122169373,
                0.7207537012206662,
                0.7729146440131114,
                0.8203093527800618,
                0.8626456264701801,
                0.899662453786402,
                0.931131626187762,
                0.9568591562079811,
                0.9766865160140201,
                0.9904918427200198,
                0.9981931104753552,
            ],
            "weights": [
                0.001249999999999971,
                0.00769403628350383,
                0.013807132062228637,
                0.019831860824182326,
                0.02573387402386327,
                0.031477118275579447,
                0.03702625776123859,
                0.04234710234079149,
                0.04740685548308642,
                0.05217432567524129,
                0.05662012157836596,
                0.06071683426811949,
                0.06443920664196998,
                0.06776428932706809,
                0.07067158226247197,
                0.07314316113614058,
                0.07516378792002398,
                0.07672100483228309,
                0.07780521115246967,
                0.07840972241868577,
                0.0785308116432616,
                0.07816773229359873,
                0.07732272289709734,
                0.07600099324218319,
                0.07421069226094469,
                0.0719628577919133,
                0.06927134853363848,
                0.0661527586100643,
                0.06262631527729606,
                0.05871376040805174,
                0.054439216496407684,
                0.04982903803557365,
                0.044911649249535925,
                0.039717369349946956,
                0.03427822690262916,
                0.028627766184371437,
                0.02280085392898704,
                0.016833526930500844,
                0.010763210466287655,
                0.004635665230395611,
            ],
            "generator": "gauss_radau",
        },
        41: {
            "degree": 81,
            "points": [
                -1.0,
                -0.9956361429736496,
                -0.9853960500143687,
                -0.9693725499933649,
                -0.9476609269057328,
                -0.9203888148537748,
                -0.8877163208817542,
                -0.8498352038169334,
                -0.8069677755582899,
                -0.7593656044174268,
                -0.7073080416900277,
                -0.6511005835012065,
                -0.5910730785787818,
                -0.5275777928414802,
                -0.4609873423067734,
                -0.39169250651278364,
                -0.32009993531590974,
                -0.24662976253647184,
                -0.17171314046425334,
                -0.09578970969668477,
                -0.019305019160040793,
                0.057292088544654174,
                0.1335521111264526,
                0.209027524462448,
                0.2832754088488496,
                0.3558600482336107,
                0.4263554871779802,
                0.494348030543067,
                0.5594386712346777,
                0.6212454317638927,
                0.6794056058904141,
                0.7335778872100445,
                0.7834443722283737,
                0.8287124262397965,
                0.869116401239153,
                0.9044191962526946,
                0.9344136523374293,
                0.9589237790592819,
                0.9778058277762318,
                0.990949352137384,
                0.9982801602070965,
            ],
            "weights": [
                0.00118976799524089,
                0.007323834555540033,
                0.013145080792402196,
                0.018886101508503752,
                0.024515867093712,
                0.03000165816051146,
                0.035311351550445166,
                0.0404138089446191,
                0.04527909493682224,
                0.04987866146812319,
                0.05418551806956558,
                0.05817439123586939,
                0.06182187314194351,
                0.06510655918946673,
                0.06800917370478184,
                0.07051268310116468,
                0.07260239586312892,
                0.07426604877602692,
                0.07549387889977047,
                0.07627868086684793,
                0.0766158491696822,
                0.07650340519002373,
                0.07594200881217672,
                0.07493495455228667,
                0.07348815222672356,
                0.07161009227327629,
                0.06931179592928793,
                0.0666067505597768,
                0.0635108305165842,
                0.0600422039956407,
                0.0562212264442844,
                0.05207032115552532,
                0.047613847775238416,
                0.042877959555390276,
                0.037890450353578284,
                0.03268059275922941,
                0.027278969948502912,
                0.02171730911137097,
                0.01602835480781851,
                0.010246096143271675,
                0.004412398865844343,
            ],
            "generator": "gauss_radau",
        },
        42: {
            "degree": 83,
            "points": [
                -1.0000000000000004,
                -0.9958413294017663,
                -0.986081598664174,
                -0.9708065830638859,
                -0.9501028993567504,
                -0.9240865421162383,
                -0.8929030657980759,
                -0.8567268835639923,
                -0.8157603172400101,
                -0.7702324734291484,
                -0.7203979649921024,
                -0.6665354882819812,
                -0.6089462650811668,
                -0.547952358305611,
                -0.48389487103577045,
                -0.41713203900682094,
                -0.34803722725421493,
                -0.27699684213234543,
                -0.2044081703905778,
                -0.13067715739545882,
                -0.05621613692648797,
                0.01855847475735517,
                0.09322850768385238,
                0.16737637674277916,
                0.24058741699173458,
                0.3124522026326997,
                0.3825688366910275,
                0.45054519859278874,
                0.5160011370724114,
                0.5785705961493218,
                0.6379036622884797,
                0.6936685213041334,
                0.7455533140784276,
                0.7932678807488196,
                0.8365453836805381,
                0.8751438003163663,
                0.908847278001044,
                0.9374673445427103,
                0.9608439725021737,
                0.978846512718734,
                0.9913746316457501,
                0.9983610679098943,
            ],
            "weights": [
                0.0011337868480715213,
                0.006979710706072518,
                0.012529458632623102,
                0.018006197208452267,
                0.02338183388487206,
                0.028626609210156227,
                0.03371125862265314,
                0.038607366773501885,
                0.04328756010906272,
                0.047725668302247594,
                0.051896873190464606,
                0.05577784850504808,
                0.05934689070364043,
                0.06258404051674873,
                0.0654711946510986,
                0.06799220707335946,
                0.07013297932857787,
                0.07188153939768616,
                0.07322810865776193,
                0.07416515657293307,
                0.074687442811368,
                0.07479204655352437,
                0.07447838282821088,
                0.0737482057853958,
                0.07260559888768203,
                0.07105695207556495,
                0.0691109260344213,
                0.06677840376357139,
                0.06407242971897016,
                0.06100813687123376,
                0.057602662089482434,
                0.05387505032929518,
                0.049846148171377905,
                0.04553848733043554,
                0.040976158844189293,
                0.036184678801064046,
                0.03119084681701637,
                0.026022599627072825,
                0.020708867143334996,
                0.015279467401191557,
                0.009765339374301234,
                0.004204879846263891,
            ],
            "generator": "gauss_radau",
        },
        43: {
            "degree": 85,
            "points": [
                -1.0,
                -0.9960323802656841,
                -0.9867200185162784,
                -0.9721423604276618,
                -0.9523783218183414,
                -0.9275335538013119,
                -0.8977406715930814,
                -0.86315865457489,
                -0.8239720222453852,
                -0.7803898569568164,
                -0.7326446909809008,
                -0.6809912669289454,
                -0.6257051790854545,
                -0.5670814032399706,
                -0.505432722994578,
                -0.44108806100145825,
                -0.3743907240612393,
                -0.3056965714588262,
                -0.23537211631651989,
                -0.163792570098389,
                -0.09133984070151802,
                -0.018400494816424806,
                0.05463630457090396,
                0.12738087453065017,
                0.19944509131604193,
                0.2704444611724319,
                0.3400001717800616,
                0.4077411133856059,
                0.47330585883956755,
                0.5363445919764682,
                0.5965209740513142,
                0.6535139382781154,
                0.7070194029033536,
                0.7567518936890958,
                0.802446067179541,
                0.8438581266908629,
                0.8807671236302115,
                0.9129761376260521,
                0.9403133304505766,
                0.9626328726520332,
                0.9798157584242917,
                0.9917706377221653,
                0.9984363980731439,
            ],
            "weights": [
                0.0010816657652785034,
                0.0066592727581921505,
                0.01195602990246973,
                0.017186192291297083,
                0.022324273615105198,
                0.027343149290154217,
                0.032216104726086894,
                0.03691715974010615,
                0.041421239291543295,
                0.045704315229721584,
                0.04974353695783268,
                0.05351735424355469,
                0.05700563256349665,
                0.06018976069313976,
                0.06305275008491032,
                0.06557932555018253,
                0.06775600678117284,
                0.06957118028680766,
                0.07101516136319216,
                0.0720802457703179,
                0.07276075084048021,
                0.07305304579978102,
                0.07295557114135684,
                0.07246884694719523,
                0.07159547011435394,
                0.07034010050057518,
                0.0687094360633355,
                0.06671217712532164,
                0.06435897995735938,
                0.061662399927166406,
                0.058636824518551504,
                0.055298396580850374,
                0.05166492822297061,
                0.04775580582171034,
                0.043591886674190936,
                0.03919538790153854,
                0.03458976834437529,
                0.02979960451853047,
                0.02485046279427581,
                0.019768774712766477,
                0.014581750080897342,
                0.009317612966494835,
                0.004011661541361669,
            ],
            "generator": "gauss_radau",
        },
        44: {
            "degree": 87,
            "points": [
                -1.0,
                -0.9962105645260071,
                -0.9873155295574342,
                -0.9733886444051535,
                -0.9545019637386616,
                -0.9307519220711583,
                -0.902259599188249,
                -0.8691702059234181,
                -0.8316523672818086,
                -0.789897270066408,
                -0.7441176911262072,
                -0.6945469141254323,
                -0.6414375412565283,
                -0.5850602062726091,
                -0.5257021955248639,
                -0.4636659840872095,
                -0.39926769445370813,
                -0.33283548567578214,
                -0.264707881154576,
                -0.19523204361335855,
                -0.12476200604239884,
                -0.05365686763224198,
                0.017721036110781574,
                0.08900797974173846,
                0.1598407013380172,
                0.2298582535991205,
                0.29870384315259635,
                0.3660266486936392,
                0.43148360869392466,
                0.49474116957065184,
                0.5554769854087314,
                0.613381560576876,
                0.6681598268710476,
                0.7195326471556684,
                0.7672382378544433,
                0.8110335030711215,
                0.8506952736059454,
                0.8860214447075421,
                0.9168320071685563,
                0.9429699677303394,
                0.9643021584426441,
                0.9807199504028723,
                0.9921399955912962,
                0.9985066517988672,
            ],
            "weights": [
                0.001033057851239637,
                0.006360396716927369,
                0.011421030464798384,
                0.01642078732374079,
                0.021336499705128815,
                0.026143394529252757,
                0.030817037386414944,
                0.035333630739798026,
                0.03967016586324683,
                0.04380454769064487,
                0.047715709759192204,
                0.051383722411598054,
                0.05478989470111858,
                0.05791686979243437,
                0.060748713483616545,
                0.06327099544205983,
                0.06547086275926448,
                0.067337105458318,
                0.06886021362447826,
                0.07003242586989174,
                0.07084776888664253,
                0.0713020878872411,
                0.07139306777779292,
                0.07112024495620933,
                0.07048500967549685,
                0.06949059896023005,
                0.06814208011240208,
                0.06644632489092002,
                0.06441197449651162,
                0.0620493955408874,
                0.059370627225195476,
                0.05638931999817421,
                0.053120666008851895,
                0.04958132171293152,
                0.045789323036906034,
                0.04176399355428065,
                0.037525846194985994,
                0.03309647912995046,
                0.028498466779905637,
                0.023755247937481055,
                0.018891017523583218,
                0.013930654975654202,
                0.008899961483501608,
                0.0038314596811010277,
            ],
            "generator": "gauss_radau",
        },
        45: {
            "degree": 89,
            "points": [
                -0.9999999999999998,
                -0.9963770119076163,
                -0.9878718901161492,
                -0.974553243281336,
                -0.9564869971057925,
                -0.9337613523484243,
                -0.9064870786452659,
                -0.8747970730917527,
                -0.838845734847173,
                -0.7988082195127837,
                -0.7548795881731099,
                -0.7072738580634008,
                -0.6562229603511465,
                -0.60197561041556,
                -0.5447960962506297,
                -0.48496299094749307,
                -0.42276779555356914,
                -0.35851351893263805,
                -0.2925132015511136,
                -0.22508839038601014,
                -0.15656757238671237,
                -0.08728457412372381,
                -0.01757693542186134,
                0.0522157350982031,
                0.12175341455819044,
                0.19069732237938486,
                0.25871157078814855,
                0.32546480122877597,
                0.3906317987114778,
                0.4538950762309405,
                0.5149464215370354,
                0.573488398723137,
                0.6292357973185172,
                0.6819170218286584,
                0.7312754149606532,
                0.7770705081004831,
                0.8190791929777186,
                0.857096808870677,
                0.8909381402019771,
                0.9204383200523752,
                0.9454536363567169,
                0.9658622409991263,
                0.9815647770402341,
                0.9924850427679797,
                0.9985722751547751,
            ],
            "weights": [
                0.000987654320987378,
                0.006081191346806703,
                0.010921106193539695,
                0.015705254460868914,
                0.020412536629736706,
                0.025020283381859174,
                0.02950610399398155,
                0.03384816146565014,
                0.03802530822566645,
                0.0420171964274621,
                0.04580437932965008,
                0.04936840685314217,
                0.05269191580070274,
                0.05575871459784594,
                0.058553862248696506,
                0.061063741164174686,
                0.06327612352566919,
                0.06518023086921382,
                0.0667667866038399,
                0.06802806121036593,
                0.06895790990148488,
                0.0695518025602931,
                0.0698068458118072,
                0.06972179712009077,
                0.06929707084251309,
                0.06853473621172439,
                0.06743850725530907,
                0.06601372470227954,
                0.06426732996477355,
                0.062207831321897875,
                0.05984526247083322,
                0.05719113364779325,
                0.05425837555812463,
                0.05106127639092795,
                0.04761541222950713,
                0.04393757120600773,
                0.040045671790778115,
                0.03595867566538289,
                0.031696495738608894,
                0.02727990015360919,
                0.022730414124309952,
                0.018070225767861586,
                0.01332212740916315,
                0.008509752532382162,
                0.0036631309726766364,
            ],
            "generator": "gauss_radau",
        },
        46: {
            "degree": 91,
            "points": [
                -1.0,
                -0.9965327308349335,
                -0.9883924561295219,
                -0.9756431331209208,
                -0.9583451988678139,
                -0.9365794802054892,
                -0.9104475092617892,
                -0.8800711440719926,
                -0.8455920215330966,
                -0.8071709033371239,
                -0.7649869287043977,
                -0.7192367800964053,
                -0.670133766623659,
                -0.6179068297151398,
                -0.5627994758018318,
                -0.5050686410413154,
                -0.4449834934003084,
                -0.38282417769219934,
                -0.3188805094269701,
                -0.2534506235667695,
                -0.18683958448917914,
                -0.11935796364030438,
                -0.05132039150999046,
                0.01695590931906188,
                0.08515260320844065,
                0.15295172569134663,
                0.22003716596989942,
                0.28609614077036416,
                0.3508206526846436,
                0.41390892619876873,
                0.47506681471339185,
                0.5340091719967373,
                0.5904611816768224,
                0.6441596385761847,
                0.6948541759184759,
                0.7423084326916771,
                0.7863011557379909,
                0.8266272314584815,
                0.8630986423808087,
                0.8955453442704,
                0.9238160600668728,
                0.947778988059278,
                0.9673224249642547,
                0.9823553188838099,
                0.9928078660681081,
                0.9986336662708315,
            ],
            "weights": [
                0.0009451795841209612,
                0.005819968232466634,
                0.010453260596623014,
                0.015035365254114318,
                0.01954703160047087,
                0.023967476863585142,
                0.028276146147337002,
                0.03245296715668666,
                0.03647847183813243,
                0.04033389410144338,
                0.0440012594664521,
                0.04746346964764886,
                0.05070438259244099,
                0.05370888788551357,
                0.056462977269546515,
                0.05895380999370183,
                0.061169772702393696,
                0.06310053359307032,
                0.06473709059430498,
                0.06607181334158155,
                0.06709847875608146,
                0.06781230006121464,
                0.06820994910191139,
                0.06828957186284479,
                0.06805079711335339,
                0.06749473813884987,
                0.06662398755073748,
                0.06544260519908275,
                0.06395609924451082,
                0.06217140047773255,
                0.060096830006581,
                0.05774206046163903,
                0.05511807090188984,
                0.05223709563178253,
                0.04911256717044632,
                0.04575905364324081,
                0.0421921908964286,
                0.03842860967163726,
                0.03448585822826047,
                0.030382320903646513,
                0.026137133373440914,
                0.021770096318535496,
                0.017301593344357588,
                0.012752543216061257,
                0.008144635332162288,
                0.003505654931935761,
            ],
            "generator": "gauss_radau",
        },
        47: {
            "degree": 93,
            "points": [
                -1.0,
                -0.9966786237290736,
                -0.988880231725154,
                -0.9766645618408825,
                -0.9600871241231915,
                -0.9392221258757206,
                -0.9141628034118738,
                -0.8850210956755098,
                -0.8519271645146137,
                -0.8150288193895546,
                -0.7744908594019487,
                -0.7304943381643728,
                -0.6832357555848309,
                -0.6329261804562623,
                -0.5797903078813431,
                -0.5240654557908471,
                -0.4660005050600693,
                -0.405854787968291,
                -0.34389692997163124,
                -0.2804036499654352,
                -0.21565852439637567,
                -0.14995072074511961,
                -0.08357370603677705,
                -0.016823936147645546,
                0.050000468237636486,
                0.11660105310490443,
                0.18268036407846222,
                0.2479432749249073,
                0.312098305659408,
                0.37485892436759016,
                0.4359448269289985,
                0.4950831889269789,
                0.5520098841542689,
                0.6064706642732622,
                0.6582222943641634,
                0.7070336392927945,
                0.7526866960523242,
                0.7949775674805515,
                0.8337173730292713,
                0.868733092574137,
                0.8998683396307268,
                0.9269840608790121,
                0.9499591599400876,
                0.9686910464176086,
                0.9830961248789474,
                0.9931103331836806,
                0.9986911813907662,
            ],
            "weights": [
                0.000905387052965116,
                0.0055752162360351,
                0.01001481007182672,
                0.01440732884470465,
                0.018735178708425095,
                0.02297927246743578,
                0.027120707892041348,
                0.031141004328093597,
                0.03502221210576786,
                0.03874699936589185,
                0.04229873152779806,
                0.04566154632960934,
                0.0488204249775976,
                0.05176125936033878,
                0.054470915125008276,
                0.05693729037258376,
                0.05914936972630666,
                0.061097273539498065,
                0.06277230202664473,
                0.06416697412253285,
                0.06527506089690127,
                0.06609161337592206,
                0.06661298464657735,
                0.06683684614542956,
                0.06676219805912144,
                0.06638937379026447,
                0.06572003846882228,
                0.06475718151571233,
                0.06350510329188319,
                0.06196939589258387,
                0.0601569181727319,
                0.05807576511513085,
                0.05573523167863461,
                0.05314577128837469,
                0.050318949154413616,
                0.04726739062944962,
                0.04400472484017949,
                0.040545523852707,
                0.03690523766288646,
                0.03310012534859919,
                0.029147182814943284,
                0.025064067821636983,
                0.020869023883354498,
                0.01658080859633929,
                0.01221865514047871,
                0.0078025053471198515,
                0.0033581183886977448,
            ],
            "generator": "gauss_radau",
        },
        48: {
            "degree": 95,
            "points": [
                -1.000000000000001,
                -0.9968155001011723,
                -0.9893379125419266,
                -0.9776231384294853,
                -0.9617222547955673,
                -0.9417035131321108,
                -0.917652682929883,
                -0.8896727707154319,
                -0.8578835983444604,
                -0.8224212956983317,
                -0.7834377198461562,
                -0.7410998056344265,
                -0.695588851242958,
                -0.6470997420354336,
                -0.5958401161350422,
                -0.5420294753448218,
                -0.48589824524164715,
                -0.42768678847948927,
                -0.3676443755328247,
                -0.306028117290724,
                -0.24310186407419554,
                -0.17913507579238042,
                -0.11440166807641772,
                -0.04917883933236333,
                0.01625411626383433,
                0.08161700474623257,
                0.1466299321922282,
                0.21101450327141336,
                0.2744950133776124,
                0.33679962923927664,
                0.39766155295280925,
                0.4568201644544787,
                0.5140221375390612,
                0.5690225246468607,
                0.6215858057749288,
                0.6714868970226922,
                0.7185121144564696,
                0.7624600891714901,
                0.8031426296447499,
                0.8403855277103289,
                0.8740293047596411,
                0.9039298951000816,
                0.9299592638866184,
                0.9520059580041388,
                0.9699755911828298,
                0.9837912776886092,
                0.9933941197153432,
                0.9987451400507801,
            ],
            "weights": [
                0.0008680555555540515,
                0.005345579628843681,
                0.009603345551856306,
                0.013817738874809917,
                0.017972653570832147,
                0.022050529685245287,
                0.026033955858194405,
                0.029905889784945128,
                0.03364975695239054,
                0.03724952799675215,
                0.04068978931795247,
                0.04395580979823929,
                0.04703360417506532,
                0.049909993059007556,
                0.05257265943322506,
                0.05501020142937867,
                0.05721218116985788,
                0.05916916947438599,
                0.060872786243152094,
                0.062315736345289426,
                0.0634918408600348,
                0.06439606353731543,
                0.06502453236473779,
                0.06537455614884559,
                0.06544463603976029,
                0.06523447194989204,
                0.06474496383933354,
                0.06397820786245487,
                0.06293748739225496,
                0.061627258960955014,
                0.060053133177126086,
                0.058221850701159976,
                0.05614125338217126,
                0.053820250680226236,
                0.05126878151825117,
                0.048497771727984515,
                0.045519087274148426,
                0.04234548346102689,
                0.038990550347152736,
                0.03546865462029932,
                0.031794878226319816,
                0.02798495413307425,
                0.024055199855878735,
                0.02002245023304839,
                0.015903994737382743,
                0.011717546846874415,
                0.007481473991793441,
                0.0032197022255185297,
            ],
            "generator": "gauss_radau",
        },
        49: {
            "degree": 97,
            "points": [
                -1.0,
                -0.9969440877973259,
                -0.9897679229561934,
                -0.9785239096829843,
                -0.9632591276707356,
                -0.9440364580996605,
                -0.9209349353297239,
                -0.894049504951204,
                -0.8634906522299785,
                -0.8293839536566687,
                -0.791869562931931,
                -0.7511016358744825,
                -0.7072476973421393,
                -0.6604879530253459,
                -0.6110145490437271,
                -0.5590307824327182,
                -0.5047502657854268,
                -0.4483960494927659,
                -0.3901997051942101,
                -0.33040037420844837,
                -0.2692437848558329,
                -0.20698124271165363,
                -0.1438685979401103,
                -0.0801651939527932,
                -0.0161328017120973,
                0.04796545594111001,
                0.11186618551532845,
                0.1753068052087159,
                0.2380266239142801,
                0.299767912456119,
                0.36027696265486187,
                0.4193051298705144,
                0.47660985473889306,
                0.5319556599034785,
                0.5851151176475069,
                0.6358697844510821,
                0.6840110986347547,
                0.7293412374040524,
                0.771673929778959,
                0.8108352220791506,
                0.8466641928427732,
                0.879013614292627,
                0.9077505577551979,
                0.9327569408717038,
                0.9539300153348838,
                0.9711827966409852,
                0.9844444498455787,
                0.993660732393963,
                0.9987958295263799,
            ],
            "weights": [
                0.000832986255726765,
                0.00512983930576555,
                0.009216699518172932,
                0.013263527743042666,
                0.017255556861560967,
                0.021176605401308803,
                0.025010609606449286,
                0.028741829445454822,
                0.032354938005642805,
                0.03583509059896628,
                0.03916798765602141,
                0.04233993417217991,
                0.04533789626336455,
                0.0481495548506207,
                0.05076335634254121,
                0.05316856014268736,
                0.05535528280194163,
                0.05731453864132439,
                0.05903827668175609,
                0.06051941373070871,
                0.06175186349076077,
                0.06273056157091123,
                0.0634514862982017,
                0.06391167524429812,
                0.06410923739923151,
                0.06404336094233057,
                0.06371431657848214,
                0.06312345642603823,
                0.062273208460983234,
                0.061167066540213685,
                0.05980957604499674,
                0.05820631520365669,
                0.05636387217034157,
                0.05428981795427068,
                0.05199267531096103,
                0.04948188372382798,
                0.0467677606210145,
                0.04386145898871307,
                0.04077492155884308,
                0.03752083176723898,
                0.03411256170154346,
                0.030564117295551828,
                0.026890081108823887,
                0.023105553263816,
                0.019226091938341617,
                0.015267658453495588,
                0.011246593334599129,
                0.007179842593781585,
                0.003089669989494291,
            ],
            "generator": "gauss_radau",
        },
        50: {
            "degree": 99,
            "points": [
                -1.0,
                -0.9970650426874255,
                -0.9901724481734503,
                -0.979371426414232,
                -0.9647054449986707,
                -0.94623253261254,
                -0.924025635923384,
                -0.8981724112259195,
                -0.8687748963606334,
                -0.8359491133526346,
                -0.7998246124517463,
                -0.7605439616533433,
                -0.7182621844127342,
                -0.6731461480199215,
                -0.6253739051469869,
                -0.5751339912095275,
                -0.5226246803351544,
                -0.4680532028853892,
                -0.41163492762424647,
                -0.35359251176398554,
                -0.2941550222440318,
                -0.23355703171193898,
                -0.17203769277472358,
                -0.10983979417443712,
                -0.04720880261303795,
                0.0156081059918034,
                0.07836302199670353,
                0.14080828041849536,
                0.20269743835484433,
                0.2637862475821129,
                0.3238336184921251,
                0.38260257156369715,
                0.439861172614024,
                0.4953834481391588,
                0.5489502771314723,
                0.600350255855093,
                0.6493805321674089,
                0.6958476060956114,
                0.7395680935117364,
                0.7803694498978921,
                0.8180906513561363,
                0.8525828301977798,
                0.8837098626532873,
                0.9113489065019758,
                0.9353908868136782,
                0.9557409288286551,
                0.9723187396222557,
                0.9850589521774644,
                0.9939115290929441,
                0.9988435086632297,
            ],
            "weights": [
                0.0007999999999999931,
                0.00492689659552924,
                0.008852917542566454,
                0.012741927068933422,
                0.01658036537956644,
                0.020353297707038885,
                0.024045880749672895,
                0.027643555697121278,
                0.031132129421512694,
                0.034497836372046634,
                0.03772739471995443,
                0.04080805943459059,
                0.04372767285113447,
                0.04647471277185177,
                0.049038337997209185,
                0.05140843114110492,
                0.053575638575833966,
                0.05553140735579455,
                0.05726801897749842,
                0.058778619844300384,
                0.06005724831649956,
                0.061098858240568044,
                0.061899338864923444,
                0.06245553106380966,
                0.06276523980537062,
                0.06282724281478233,
                0.06264129539828843,
                0.06220813140913146,
                0.06152946035161666,
                0.06060796063474951,
                0.05944726900209325,
                0.0580519661796358,
                0.0564275587983522,
                0.054580457662926025,
                0.05251795245252216,
                0.0502481829538201,
                0.04778010694026126,
                0.045123464825282976,
                0.042288741230799426,
                0.03928712362616155,
                0.03613045820843155,
                0.03283120321500742,
                0.029402379894073953,
                0.025857521435383505,
                0.022210620386682266,
                0.018476075872511134,
                0.014668645428928264,
                0.010803426758951448,
                0.006896079944406457,
                0.0029673580807688554,
            ],
            "generator": "gauss_radau",
        },
        51: {
            "degree": 101,
            "points": [
                -1.0000000000000002,
                -0.9971789570391585,
                -0.9905534619787282,
                -0.9801698007502369,
                -0.9660681703161438,
                -0.9483022059495705,
                -0.9269393408985922,
                -0.9020606270263123,
                -0.8737604445154366,
                -0.8421461489792694,
                -0.8073376660758198,
                -0.7694670373539794,
                -0.7286779197254996,
                -0.685125040699484,
                -0.6389736115404971,
                -0.5903987006175029,
                -0.5395845693399737,
                -0.4867239732097808,
                -0.43201743064522313,
                -0.375672462353547,
                -0.31790280413883476,
                -0.2589275961322941,
                -0.19897055152099896,
                -0.13825910792876317,
                -0.07702356466843385,
                -0.015496209138459616,
                0.04608956432230549,
                0.10750013977903194,
                0.16850256588612977,
                0.2288654395516514,
                0.2883597837288565,
                0.3467599160052164,
                0.40384430469409094,
                0.4593964091817545,
                0.5132055013422601,
                0.5650674649045682,
                0.6147855697402218,
                0.6621712181353562,
                0.7070446602177717,
                0.7492356758280745,
                0.7885842202536392,
                0.8249410313863261,
                0.858168196022332,
                0.8881396732036017,
                0.9147417727295949,
                0.9378735873259255,
                0.9574473777370196,
                0.9733889125062456,
                0.9856377756952999,
                0.9941477361281509,
                0.9988884111876143,
            ],
            "weights": [
                0.0007689350249900288,
                0.004735759265154397,
                0.008510233660684102,
                0.01225043342411696,
                0.015943889533081672,
                0.019576796918090514,
                0.023135419633744422,
                0.026606272181309447,
                0.029976193474155102,
                0.033232402413880195,
                0.03636254812106919,
                0.039354757419440896,
                0.04219768013324466,
                0.04488053225813694,
                0.04739313692458981,
                0.04972596303102577,
                0.05187016141417391,
                0.05381759842582587,
                0.055560886791763124,
                0.05709341363741832,
                0.05840936557477018,
                0.05950375075581323,
                0.06037241780921641,
                0.06101207158849446,
                0.06142028567203889,
                0.06159551156769079,
                0.0615370845869379,
                0.061245226366523665,
                0.0607210440278895,
                0.059966525977698755,
                0.058984534365358984,
                0.05777879422620844,
                0.05635387935158203,
                0.054715194939412494,
                0.052868957091301655,
                0.05082216923396339,
                0.048582595554789366,
                0.04615873155277684,
                0.043559771817442805,
                0.040795575159655394,
                0.037876627230102516,
                0.034814000774452146,
                0.03161931369229362,
                0.02830468509847799,
                0.024882689658370483,
                0.021366310681332074,
                0.017768893216390205,
                0.01410410175402238,
                0.010385906832515111,
                0.006628802883475476,
                0.002852167273106538,
            ],
            "generator": "gauss_radau",
        },
        52: {
            "degree": 103,
            "points": [
                -1.0,
                -0.9972863667771933,
                -0.9909127508038165,
                -0.9809227558619188,
                -0.9673536117000012,
                -0.9502549681465764,
                -0.9296892555914655,
                -0.9057315307037768,
                -0.8784692190643848,
                -0.8480018010905557,
                -0.814440450822445,
                -0.7779076309969654,
                -0.7385366465318275,
                -0.696471158277993,
                -0.651864658905779,
                -0.6048799128765913,
                -0.5556883625622786,
                -0.5044695026883212,
                -0.45141022538826103,
                -0.39670413826184636,
                -0.34055085792672757,
                -0.2831552816423364,
                -0.2247268396642612,
                -0.1654787310575211,
                -0.10562714575738719,
                -0.04539047571650101,
                0.015011481983184582,
                0.07535832714582913,
                0.1354298606780011,
                0.19500688807133382,
                0.25387201921973057,
                0.31181046165268866,
                0.3686108042903833,
                0.42406578886074,
                0.47797306616381907,
                0.5301359344241721,
                0.5803640570373523,
                0.6284741570921033,
                0.6742906861349096,
                0.7176464647381686,
                0.7583832925373934,
                0.7963525255165942,
                0.8314156184454113,
                0.8634446305094234,
                0.8923226923343861,
                0.9179444328099569,
                0.9402163644455543,
                0.9590572267241229,
                0.974398289301986,
                0.9861836279341851,
                0.9943704632574915,
                0.9989307485757626,
            ],
            "weights": [
                0.0007396449704141805,
                0.0045555293851886345,
                0.008187048999613854,
                0.01178677854545576,
                0.01534323630076666,
                0.018843642767947002,
                0.022275268542833817,
                0.025625605051245847,
                0.028882432130807743,
                0.032033868056622346,
                0.03506841457717066,
                0.037974999478961435,
                0.04074301723628256,
                0.04336236782095403,
                0.04582349361004651,
                0.04811741428829237,
                0.05023575963129341,
                0.05217080005606852,
                0.05391547483047896,
                0.05546341784014021,
                0.05680898081959905,
                0.05794725396349623,
                0.05887408384273356,
                0.05958608856046047,
                0.060080670092638545,
                0.06035602376824697,
                0.060411144854554275,
                0.06024583222346697,
                0.05986068908557815,
                0.05925712078928872,
                0.058437329693021865,
                0.057404307129265086,
                0.056161822489796995,
                0.054714409471969414,
                0.0530673495362674,
                0.0512266526356265,
                0.04919903528697087,
                0.04699189606524787,
                0.04461328860985397,
                0.042071892242830804,
                0.03937698030766379,
                0.03653838634754156,
                0.03356646825345434,
                0.030472070528664033,
                0.027266484845229217,
                0.023961409137336156,
                0.020568905679905786,
                0.017101359330766643,
                0.013571440345743297,
                0.009992095119664623,
                0.006376759458689075,
                0.0027435553638435525,
            ],
            "generator": "gauss_radau",
        },
        53: {
            "degree": 105,
            "points": [
                -1.0,
                -0.9973877577939588,
                -0.9912519346592961,
                -0.9816336692459783,
                -0.9685674942969249,
                -0.9520994375633818,
                -0.9322873815113892,
                -0.9092009307734829,
                -0.8829211835470065,
                -0.8535404514796334,
                -0.821161937134139,
                -0.785899372193785,
                -0.7478766183001829,
                -0.7072272321460584,
                -0.6640939964380901,
                -0.618628418415395,
                -0.5709901977029329,
                -0.5213466653778847,
                -0.46987219622393106,
                -0.416747596240462,
                -0.3621594675595615,
                -0.30629955300236733,
                -0.2493640625775908,
                -0.1915529842882263,
                -0.13306938166746074,
                -0.07411868051134907,
                -0.01490794731371603,
                0.04435483806213236,
                0.10346151292010108,
                0.1622044629103312,
                0.22037735128228442,
                0.2777758436503506,
                0.33419832572625663,
                0.389446611497259,
                0.4433266393626927,
                0.4956491537838055,
                0.5462303700527471,
                0.5948926198460098,
                0.6414649752952886,
                0.6857838493845669,
                0.7276935705659675,
                0.7670469295786748,
                0.8037056965551204,
                0.8375411066077323,
                0.8684343122105276,
                0.8962768008305904,
                0.9209707764480013,
                0.9424295039033557,
                0.9605776157024601,
                0.9753513831854166,
                0.9866989645695221,
                0.9945807167231095,
                0.9989707125479648,
            ],
            "weights": [
                0.0007119971520113937,
                0.004385392778355805,
                0.007881913177734647,
                0.011348903374074725,
                0.014775776881974284,
                0.018150686911727363,
                0.02146182054769006,
                0.024697559877666152,
                0.02784654391871059,
                0.03089771375476925,
                0.033840352999189104,
                0.036664126022307696,
                0.039359114494816834,
                0.04191585233339274,
                0.04432535900244225,
                0.046579171085191474,
                0.04866937202618304,
                0.05058861994665738,
                0.05233017343798537,
                0.053887915244058573,
                0.05525637375022382,
                0.0564307422037239,
                0.05740689559838462,
                0.058181405164390035,
                0.05875155041234314,
                0.05911532868935166,
                0.05927146221363646,
                0.05921940256294108,
                0.05895933260103121,
                0.05849216583551338,
                0.05781954320924369,
                0.05694382733661443,
                0.055868094204975315,
                0.05459612237038586,
                0.053132379685644486,
                0.051482007607314646,
                0.049650803136916645,
                0.04764519845991737,
                0.04547223835423878,
                0.04313955544812719,
                0.04065534341513078,
                0.03802832820189021,
                0.035267737393021324,
                0.03238326782740375,
                0.029385051594728994,
                0.026283620568314243,
                0.02308986969582776,
                0.01981501946480976,
                0.016470578661733827,
                0.01306831165297294,
                0.009620232650785624,
                0.006138814277002234,
                0.002641030784522635,
            ],
            "generator": "gauss_radau",
        },
        54: {
            "degree": 107,
            "points": [
                -1.0000000000000004,
                -0.9974835714510208,
                -0.9915724853894035,
                -0.9823056104959416,
                -0.969715023676722,
                -0.9538434549546733,
                -0.934744645114798,
                -0.9124832320265797,
                -0.8871345472322236,
                -0.858784365619524,
                -0.8275286168363671,
                -0.7934730613771193,
                -0.7567329330351178,
                -0.7174325491432987,
                -0.6757048900060962,
                -0.6316911489823549,
                -0.5855402547587536,
                -0.5374083674387584,
                -0.4874583501566625,
                -0.4358592180070242,
                -0.38278556615556814,
                -0.3284169790674498,
                -0.27293742285237665,
                -0.21653462278299274,
                -0.15939942809301821,
                -0.10172516620458372,
                -0.04370698856993793,
                0.014458789658955529,
                0.07257535389854908,
                0.13044605609188242,
                0.18787508010338394,
                0.2446681042988359,
                0.3006329590685446,
                0.35558027706890627,
                0.40932413398219947,
                0.4616826776265571,
                0.5124787432875242,
                0.5615404531893178,
                0.6087017980776543,
                0.653803198946757,
                0.696692047010658,
                0.7372232200931281,
                0.7752595736914814,
                0.8106724050573965,
                0.8433418887337376,
                0.8731574820928457,
                0.9000182995465087,
                0.923833454263019,
                0.9445223665039985,
                0.9620150383459124,
                0.9762522967317313,
                0.9871860169974337,
                0.9947794106226632,
                0.9990084772425157,
            ],
            "weights": [
                0.000685871056241047,
                0.004224609819923079,
                0.007593508073767694,
                0.010934935370158265,
                0.01423911837285508,
                0.0174950600069011,
                0.020691783244456193,
                0.023818483487985855,
                0.0268645854704677,
                0.029819784077956143,
                0.032674080776861986,
                0.03541781801010363,
                0.0380417121054732,
                0.04053688479181256,
                0.04289489329013905,
                0.04510775890697689,
                0.04716799404562094,
                0.049068627549697715,
                0.05080322829597046,
                0.052365926958060506,
                0.05375143586817801,
                0.05495506691005998,
                0.055972747382826545,
                0.056801033782237796,
                0.05743712345277973,
                0.05787886407122112,
                0.05812476092958781,
                0.05817398199293593,
                0.05802636071481454,
                0.05768239660091732,
                0.05714325351902988,
                0.05641075576098922,
                0.05548738186999808,
                0.05437625625420055,
                0.05308113861492283,
                0.05160641122536391,
                0.04995706410287228,
                0.04813867812502469,
                0.046157406146814926,
                0.04401995218307381,
                0.04173354872701201,
                0.03930593228241301,
                0.036745317193822694,
                0.034060367866333256,
                0.03126016947543204,
                0.02835419728057614,
                0.025352284681553205,
                0.02226459021917292,
                0.01910156390932925,
                0.01587391397489298,
                0.012592578034956455,
                0.009268720375888521,
                0.005913935727999592,
                0.0025441470313387077,
            ],
            "generator": "gauss_radau",
        },
        55: {
            "degree": 109,
            "points": [
                -1.0,
                -0.9975742093875332,
                -0.9918757426338168,
                -0.982941374349134,
                -0.9708009413099791,
                -0.955494165940012,
                -0.9370710108597357,
                -0.9155915816222323,
                -0.8911259454106188,
                -0.8637539068989961,
                -0.8335647495359645,
                -0.8006569449777684,
                -0.7651378321953732,
                -0.7271232675066999,
                -0.6867372467567938,
                -0.6441115009136211,
                -0.5993850664151019,
                -0.5527038316770317,
                -0.5042200612454028,
                -0.4540918991475943,
                -0.402482853063741,
                -0.34956126100160057,
                -0.29549974221498665,
                -0.24047463415707016,
                -0.18466541730526387,
                -0.1282541297339279,
                -0.07142477334451436,
                -0.014362713689952566,
                0.04274592464903071,
                0.09971486516349248,
                0.15635828701150345,
                0.21249143112718127,
                0.26793120286652994,
                0.3224967692243992,
                0.37601014867460103,
                0.42829679170928525,
                0.47918615018406774,
                0.528512233611925,
                0.5761141505915419,
                0.6218366336043613,
                0.6655305454690459,
                0.7070533658021885,
                0.7462696558999165,
                0.7830515005264933,
                0.8172789251734647,
                0.8488402874373007,
                0.8776326412574116,
                0.9035620728673646,
                0.9265440074614346,
                0.9465034858354084,
                0.963375410878311,
                0.9771047658822303,
                0.9876468164571868,
                0.9949673768498835,
                0.9990442011156067,
            ],
            "weights": [
                0.0006611570247933878,
                0.0040725073954533805,
                0.0073206336266354215,
                0.01054316864052327,
                0.013731078908273582,
                0.016874142748519817,
                0.019962146740529277,
                0.022985030120871695,
                0.025932937205972277,
                0.028796254396353978,
                0.03156564303588086,
                0.034232070416333464,
                0.03678683946212866,
                0.0392216171977953,
                0.04152846197645004,
                0.043699849408507185,
                0.04572869691806781,
                0.04760838685239795,
                0.049332788071809366,
                0.050896275950887596,
                0.052293750726565384,
                0.05352065413359355,
                0.05457298427338567,
                0.055447308667876144,
                0.05614077545589835,
                0.056651122695607334,
                0.056976685742638415,
                0.05711640267998506,
                0.0570698177818482,
                0.05683708300022626,
                0.05641895746936827,
                0.05581680502972981,
                0.055032589779521544,
                0.054068869668351616,
                0.05292878815390229,
                0.051616063948849794,
                0.05013497889153233,
                0.048490363979936016,
                0.04668758361469608,
                0.044732518102598505,
                0.04263154447790385,
                0.04039151570450314,
                0.038019738327454984,
                0.03552394864832556,
                0.03291228750498533,
                0.03019327374432832,
                0.027375776488509793,
                0.024468986319077773,
                0.021482385563076595,
                0.01842571804541423,
                0.015308959322316948,
                0.01214229129749113,
                0.008936102053976741,
                0.005701184810958982,
                0.0024524977973790535,
            ],
            "generator": "gauss_radau",
        },
        56: {
            "degree": 111,
            "points": [
                -1.0,
                -0.9976600377337416,
                -0.9921629278196165,
                -0.9835435096723204,
                -0.9718295732674981,
                -0.9570580934749351,
                -0.9392755806866614,
                -0.9185379978516494,
                -0.8949105986213683,
                -0.8684677262866007,
                -0.839292581399126,
                -0.8074769606257667,
                -0.7731209682125062,
                -0.7363327011637872,
                -0.6972279092058917,
                -0.6559296306383517,
                -0.6125678052350697,
                -0.5672788654210266,
                -0.5202053070150494,
                -0.47149524089150197,
                -0.42130192697283897,
                -0.36978329202002236,
                -0.31710143273845837,
                -0.2634221057631728,
                -0.20891420612809164,
                -0.15374923586047673,
                -0.09810076437259851,
                -0.04214388234849875,
                0.013945349155845,
                0.06999045266559434,
                0.12581508955042264,
                0.18124361485109897,
                0.23610162992361117,
                0.2902165311620106,
                0.3434180530735069,
                0.3955388039971335,
                0.4464147927804718,
                0.4958859447573658,
                0.5437966054033079,
                0.5899960300839713,
                0.6343388583562475,
                0.676685571329922,
                0.7169029306517192,
                0.754864397731841,
                0.7904505318963215,
                0.8235493662168736,
                0.8540567598443498,
                0.8818767257550899,
                0.9069217329183599,
                0.9291129820286113,
                0.9483806541849866,
                0.9646641324869976,
                0.9779121985219887,
                0.9880832151820558,
                0.9951453738064624,
                0.9990780286059555,
            ],
            "weights": [
                0.0006377551020408225,
                0.003928471852526747,
                0.007062195381110996,
                0.01017204648818555,
                0.013249665795157843,
                0.01628554032937691,
                0.019270155336009342,
                0.02219413136095482,
                0.02504827267313646,
                0.027823600882304456,
                0.030511384636682428,
                0.03310316761950485,
                0.035590795369711055,
                0.037966441034773195,
                0.04022263004319563,
                0.04235226364610571,
                0.044348641265452654,
                0.04620548158382635,
                0.04791694231211431,
                0.04947763857412973,
                0.050882659851076296,
                0.052127585432918636,
                0.05320849832828248,
                0.05412199758922393,
                0.05486520901221052,
                0.055435794181660336,
                0.05583195782763088,
                0.05605245347453689,
                0.05609658736312514,
                0.05596422063338389,
                0.055655769761524344,
                0.05517220524966778,
                0.054515048572378474,
                0.053686367389630715,
                0.05268876904130809,
                0.05152539234371293,
                0.0501998977139054,
                0.04871645565298602,
                0.04707973362460585,
                0.045294881370080586,
                0.043367514706415214,
                0.04130369785847668,
                0.03910992438130421,
                0.036793096733315184,
                0.034360504566105184,
                0.03181980180199818,
                0.029178982577485333,
                0.02644635614176299,
                0.02363052082207502,
                0.020740337224682655,
                0.017784901013605713,
                0.014773516236500623,
                0.011715672951155129,
                0.008621049237842035,
                0.005499705339737008,
                0.002365712707389151,
            ],
            "generator": "gauss_radau",
        },
        57: {
            "degree": 113,
            "points": [
                -1.0000000000000002,
                -0.9977413908121848,
                -0.992435156456295,
                -0.9841143449460441,
                -0.9728048730701293,
                -0.9585412016811836,
                -0.9413666817486042,
                -0.921333483868686,
                -0.8985024535537689,
                -0.872942930546988,
                -0.8447325397193086,
                -0.8139569559369146,
                -0.7807096441496506,
                -0.7450915756802665,
                -0.7072109216516762,
                -0.667182724516173,
                -0.6251285486995246,
                -0.5811761114285754,
                -0.535458894867533,
                -0.4881157407430605,
                -0.43929042869052903,
                -0.38913123960272356,
                -0.3377905053075325,
                -0.2854241459425324,
                -0.2321911964315957,
                -0.17825332350174117,
                -0.12377433470708632,
                -0.06891968095103485,
                -0.013855954017564676,
                0.041249619362390466,
                0.09622968537294363,
                0.15091727136127409,
                0.2051462929281367,
                0.2587520583208367,
                0.3115717685968713,
                0.3634450120392646,
                0.4142142513221082,
                0.4637253019468561,
                0.511827800496433,
                0.5583756612852149,
                0.6032275200182055,
                0.6462471631123099,
                0.6873039413763153,
                0.7262731667939777,
                0.7630364912064854,
                0.7974822657465268,
                0.8295058799366337,
                0.8590100794302938,
                0.8859052614480674,
                0.9101097470495334,
                0.9315500295053205,
                0.9501609982562006,
                0.9658861385042111,
                0.9786777084093284,
                0.9884969049894616,
                0.9953140940557511,
                0.9991100915968859,
            ],
            "weights": [
                0.0006155740227761433,
                0.0037919428085326596,
                0.00681719353842139,
                0.009820146053038657,
                0.012793056234549476,
                0.015727059873245068,
                0.018613282427312552,
                0.02144296938956749,
                0.02420753112666862,
                0.026898573486782998,
                0.02950792469008743,
                0.03202766065234106,
                0.03445012925656469,
                0.03676797368479617,
                0.038974154805192236,
                0.04106197257263294,
                0.04302508638898719,
                0.04485753436636147,
                0.04655375143733007,
                0.04810858625837193,
                0.04951731685593061,
                0.050775664967929,
                0.05187980903737316,
                0.05282639581876704,
                0.05361255056211507,
                0.05423588574367592,
                0.054694508316952425,
                0.054987025461933625,
                0.055112548815143166,
                0.0550706971676411,
                0.05486159762281658,
                0.05448588521043798,
                0.05394470095815778,
                0.05323968842632529,
                0.05237298871663194,
                0.05134723396977132,
                0.05016553937187055,
                0.0488314936939765,
                0.04734914839337787,
                0.04572300530989374,
                0.04395800299458147,
                0.04205950171250742,
                0.040033267165354,
                0.037885452983677126,
                0.03562258204271272,
                0.03325152665984522,
                0.030779487736624145,
                0.02821397291447377,
                0.025562773823483504,
                0.022833942524978536,
                0.020035767303255375,
                0.01717674812885386,
                0.014265572720780701,
                0.011311096822061972,
                0.00832234806648653,
                0.0053087153347383285,
                0.0022834535713034277,
            ],
            "generator": "gauss_radau",
        },
        58: {
            "degree": 115,
            "points": [
                -1.0,
                -0.9978185743965636,
                -0.9926934489649226,
                -0.9846560107223865,
                -0.9737304594771448,
                -0.9599489521906501,
                -0.9433519439440828,
                -0.9239881283477138,
                -0.9019143079730656,
                -0.877195231701016,
                -0.8499034062308902,
                -0.8201188839963295,
                -0.7879290286282522,
                -0.7534282588366789,
                -0.7167177715356846,
                -0.6779052450553373,
                -0.6371045233260013,
                -0.5944352819687326,
                -0.5500226772750418,
                -0.5039969791077548,
                -0.45649318880093426,
                -0.40765064318034494,
                -0.3576126058663628,
                -0.3065258470583817,
                -0.25454021303345076,
                -0.20180818662198607,
                -0.1484844399498394,
                -0.09472538075864645,
                -0.040688693635215656,
                0.013467122504367879,
                0.06758321931927269,
                0.12150086497343215,
                0.1750619097233812,
                0.22810924979876868,
                0.28048728821491586,
                0.33204239116578127,
                0.3826233386586917,
                0.4320817680690503,
                0.4802726093140728,
                0.5270545103691742,
                0.5722902518789883,
                0.6158471496470732,
                0.6575974438239947,
                0.697418673652646,
                0.7351940366723351,
                0.770812731329271,
                0.8041702819907022,
                0.8351688454135036,
                0.863717497776326,
                0.8897325014499988,
                0.9131375507604538,
                0.9338639961113084,
                0.9518510460417167,
                0.9670459473270638,
                0.9794041450855373,
                0.9888894336584535,
                0.9954741710626409,
                0.9991405107035343,
            ],
            "weights": [
                0.0005945303210463724,
                0.0036624076977333914,
                0.0065847133076769,
                0.009486164762634204,
                0.01235958028919647,
                0.015196690454890036,
                0.017989208225633234,
                0.020728953148738138,
                0.023407892974511128,
                0.02601817158248204,
                0.02855213337453562,
                0.03100234621885482,
                0.033361623449042914,
                0.03562304503318371,
                0.03777997791464246,
                0.03982609549015669,
                0.04175539617887765,
                0.04356222103285455,
                0.04524127033971652,
                0.046787619170087495,
                0.048196731824784886,
                0.04946447513980042,
                0.05058713061023317,
                0.051561405297744355,
                0.052384441489624595,
                0.0530538250811658,
                0.053567592656806606,
                0.05392423724928251,
                0.0541227127599081,
                0.054162437027038275,
                0.05404329353370827,
                0.053765631749450676,
                0.0533302661052938,
                0.05273847360496306,
                0.05199199007926423,
                0.051093005094679185,
                0.05004415553110722,
                0.048848517847566296,
                0.047509599058634444,
                0.046031326448033864,
                0.04441803604966585,
                0.0426744599298951,
                0.04080571230852436,
                0.03881727455943191,
                0.03671497913515133,
                0.034504992463329456,
                0.032193796866507106,
                0.029788171560911614,
                0.02729517279561769,
                0.024722113202899368,
                0.02207654045088477,
                0.01936621534208609,
                0.016599089662355345,
                0.01378328466893591,
                0.010927073701073672,
                0.008038887620999042,
                0.005127499440455276,
                0.00220541108569157,
            ],
            "generator": "gauss_radau",
        },
        59: {
            "degree": 117,
            "points": [
                -1.0,
                -0.9978918685876634,
                -0.9929387402377696,
                -0.9851704594597329,
                -0.9746096498840301,
                -0.9612863539873973,
                -0.9452383685799217,
                -0.9265111947482749,
                -0.9051579216900321,
                -0.881239080052807,
                -0.8548224717340023,
                -0.8259829782594944,
                -0.7948023487851862,
                -0.7613689684999863,
                -0.7257776081572582,
                -0.6881291554753879,
                -0.6485303291831833,
                -0.6070933765278124,
                -0.5639357551064583,
                -0.5191797999256286,
                -0.47295237663302836,
                -0.42538452190564613,
                -0.37661107201382504,
                -0.326770280614449,
                -0.2760034268568258,
                -0.22445441491222873,
                -0.17226936606235932,
                -0.11959620450303976,
                -0.06658423803724833,
                -0.013383734846104445,
                0.03985450246250921,
                0.09297956432026155,
                0.145840861967929,
                0.1982885543156243,
                0.25017397268373065,
                0.3013500422205595,
                0.3516716988022093,
                0.4009963002328769,
                0.4491840305800756,
                0.49609829649866466,
                0.5416061144203339,
                0.585578487511123,
                0.6278907713285973,
                0.6684230271424503,
                0.7070603619174094,
                0.7436932539954317,
                0.7782178635551769,
                0.8105363269708783,
                0.8405570342401729,
                0.8681948887022672,
                0.8933715483262819,
                0.9160156479213262,
                0.9360630017234552,
                0.9534567860103857,
                0.9681477019029796,
                0.9800941202993976,
                0.9892622193902993,
                0.9956261851421855,
                0.9991693964086881,
            ],
            "weights": [
                0.0005745475438092563,
                0.003539396958449584,
                0.006363916384608259,
                0.009168908353801209,
                0.011947705803757747,
                0.01469258537559367,
                0.017395799939204867,
                0.02004969706841779,
                0.022646757766013745,
                0.025179621996253235,
                0.027641110851946805,
                0.030024247376091415,
                0.03232227653147457,
                0.034528684434862573,
                0.03663721686300566,
                0.0386418970023487,
                0.040537042402574434,
                0.042317281090708536,
                0.0439775668024358,
                0.04551319328864492,
                0.04691980765728402,
                0.04819342271306229,
                0.049330428260217364,
                0.050327601336437426,
                0.05118211534898333,
                0.05189154808719074,
                0.052453888588628664,
                0.05286754283950594,
                0.05313133829315696,
                0.053244527193824116,
                0.053206788696300425,
                0.05301822977544894,
                0.052679384923021925,
                0.05219121463262647,
                0.05155510267715799,
                0.05077285218640098,
                0.04984668053594669,
                0.04877921306189634,
                0.0475734756192043,
                0.046232886004751984,
                0.04476124426950602,
                0.04316272194727117,
                0.04144185023061797,
                0.03960350712764341,
                0.037652903636186334,
                0.0355955689750097,
                0.03343733491453259,
                0.031184319252786894,
                0.028842908485976742,
                0.026419739728237454,
                0.023921681943937612,
                0.02135581657528798,
                0.018729417698326596,
                0.01604993199583514,
                0.013324959399795682,
                0.010562237763559404,
                0.00776964963615607,
                0.0049554022313394,
                0.0021313019229439326,
            ],
            "generator": "gauss_radau",
        },
        60: {
            "degree": 119,
            "points": [
                -0.9999999999999998,
                -0.9979615303569094,
                -0.9931718880956031,
                -0.985659483078601,
                -0.9754454899022751,
                -0.9625580075892137,
                -0.9470323893006916,
                -0.9289112006286289,
                -0.9082441153137739,
                -0.8850877827927179,
                -0.8595056742603178,
                -0.8315679092511137,
                -0.8013510636992163,
                -0.7689379601745072,
                -0.7344174409382993,
                -0.6978841244701419,
                -0.6594381461469896,
                -0.619184883792395,
                -0.5772346688516048,
                -0.5337024839861759,
                -0.4887076479181063,
                -0.4423734883879744,
                -0.39482700412388594,
                -0.3461985167479902,
                -0.2966213135748379,
                -0.2462312822807411,
                -0.19516653844555432,
                -0.14356704698780276,
                -0.09157423853081337,
                -0.03933062175137714,
                0.013020607226506442,
                0.06533595732218533,
                0.11747203579739862,
                0.1692859412858161,
                0.22063565547579356,
                0.2713804323727882,
                0.3213811840744857,
                0.3705008620012844,
                0.41860483253721326,
                0.4655612460517238,
                0.5112413982909211,
                0.5555200831477669,
                0.5982759358444191,
                0.6393917655862371,
                0.678754876775913,
                0.7162573779076958,
                0.7517964772957282,
                0.7852747648270682,
                0.8166004789691935,
                0.845687758303973,
                0.8724568769061766,
                0.8968344629368855,
                0.918753699886971,
                0.9381545100012649,
                0.954983719598322,
                0.9691952064868735,
                0.9807500314025301,
                0.9896165636042255,
                0.9957706687213576,
                0.9991968500672739,
            ],
            "weights": [
                0.0005555555555558046,
                0.0034224797759479387,
                0.006154033409668961,
                0.008867280260696454,
                0.011556025026842432,
                0.014213046409671358,
                0.016831094116130176,
                0.019403002052406682,
                0.021921724435040098,
                0.024380359182218227,
                0.026772168092889723,
                0.029090595772260353,
                0.03132928778593826,
                0.03348210816042015,
                0.03554315624168034,
                0.03750678288916167,
                0.039367605970914384,
                0.04112052512200303,
                0.0427607357279935,
                0.04428374209636191,
                0.045685369780289774,
                0.04696177702145926,
                0.04810946528066768,
                0.04912528882746928,
                0.05000646336271403,
                0.05075057365028464,
                0.05135558013726394,
                0.05181982454429703,
                0.052142034410895724,
                0.05232132658323638,
                0.05235720963486803,
                0.05224958521371973,
                0.051998748311716074,
                0.05160538645626325,
                0.05107057782583045,
                0.050395788294776284,
                0.04958286741555114,
                0.04863404334927881,
                0.04755191675860807,
                0.04633945367962314,
                0.04499997739231906,
                0.04353715931199338,
                0.0419550089265385,
                0.04025786280729482,
                0.0384503727236985,
                0.03653749289450533,
                0.03452446641087547,
                0.032416810869192285,
                0.030220303254225155,
                0.02794096411655116,
                0.025585041092833175,
                0.023158991825893715,
                0.020669466359904576,
                0.01812328913459305,
                0.015527440852326732,
                0.012889041037338672,
                0.010215334530716548,
                0.007513699390555391,
                0.004791822289065374,
                0.002060866156963916,
            ],
            "generator": "gauss_radau",
        },
        61: {
            "degree": 121,
            "points": [
                -1.0,
                -0.9980277958007275,
                -0.9933936807855241,
                -0.9861247285327244,
                -0.976240779611265,
                -0.9637681442899312,
                -0.9487399262608333,
                -0.9311959882493803,
                -0.9111828582891979,
                -0.8887536099167144,
                -0.8639677227206634,
                -0.8368909251464096,
                -0.8075950204403096,
                -0.7761576963617977,
                -0.7426623192337933,
                -0.7071977129062414,
                -0.66985792323235,
                -0.6307419686887594,
                -0.5899535778044476,
                -0.5476009140965744,
                -0.503796289243779,
                -0.4586558652581757,
                -0.412299346446236,
                -0.3648496619756517,
                -0.31643263989011894,
                -0.267176673436592,
                -0.21721238058991998,
                -0.16667225767778016,
                -0.11569032802447987,
                -0.0644017865453641,
                -0.012942641234325425,
                0.03855064750486359,
                0.08994152872697114,
                0.14109372305385026,
                0.19187158406287597,
                0.24214045799693107,
                0.2917670408420583,
                0.3406197318258899,
                0.3885689823994407,
                0.43548763977686167,
                0.4812512841221601,
                0.5257385584887895,
                0.5688314906372105,
                0.6104158058771425,
                0.6503812301050211,
                0.6886217822333383,
                0.7250360552367421,
                0.7595274850702867,
                0.7920046067478059,
                0.8223812969033344,
                0.8505770021960566,
                0.8765169529603527,
                0.9001323615494006,
                0.9213606048795366,
                0.9401453907708601,
                0.9564369078535007,
                0.9701919592749371,
                0.9813740821055628,
                0.9899536622836911,
                0.9959081110030845,
                0.9992229647965463,
            ],
            "weights": [
                0.000537489922063955,
                0.003311260308889462,
                0.005954357279051948,
                0.008580272194352527,
                0.01118324271955809,
                0.013756509776838953,
                0.016293280885439142,
                0.018786838457639482,
                0.02123057354549103,
                0.02361800731286179,
                0.025942809435984218,
                0.02819881533199259,
                0.030380042686447034,
                0.03248070739805774,
                0.034495238956062324,
                0.036418295232260374,
                0.038244776658234565,
                0.039969839754641294,
                0.04158890997886479,
                0.043097693858092735,
                0.04449219037621494,
                0.04576870158468896,
                0.04692384240942843,
                0.04795454962780286,
                0.048858089992029424,
                0.04963206747744289,
                0.05027442963646463,
                0.05078347304142449,
                0.05115784780181286,
                0.0513965611440139,
                0.05149898004400744,
                0.0514648329060695,
                0.0512942102830314,
                0.05098756463618452,
                0.05054570913546522,
                0.049969815503111754,
                0.049261410906513675,
                0.0484223739084861,
                0.04745492948573277,
                0.046361643128698206,
                0.04514541403848097,
                0.04380946743883992,
                0.04235734602375015,
                0.040792900563184464,
                0.039120279692115706,
                0.03734391890996024,
                0.03546852881976967,
                0.03349908263874318,
                0.03144080301379185,
                0.029299148178312875,
                0.027079797489286763,
                0.024788636388106685,
                0.022431740836399972,
                0.02001536129569437,
                0.017545906366594664,
                0.015029926348045957,
                0.012474097504734055,
                0.009885210176144877,
                0.007270177623642768,
                0.004636206951302813,
                0.0019938649816495175,
            ],
            "generator": "gauss_radau",
        },
        62: {
            "degree": 123,
            "points": [
                -1.0,
                -0.9980908821426898,
                -0.9936048436417089,
                -0.9865677116475366,
                -0.9769980969027912,
                -0.9649206610822051,
                -0.9503664343796151,
                -0.933372787537852,
                -0.9139833475179119,
                -0.8922478889728406,
                -0.8682222077263912,
                -0.8419679780622725,
                -0.8135525946436492,
                -0.7830489996294774,
                -0.750535495495323,
                -0.7160955440669048,
                -0.6798175522952186,
                -0.6417946453296086,
                -0.6021244274746862,
                -0.560908731646564,
                -0.5182533579726056,
                -0.4742678022063196,
                -0.42906497465492843,
                -0.3827609103413614,
                -0.3354744711448221,
                -0.28732704068464165,
                -0.23844221273069643,
                -0.1889454739402966,
                -0.1389638817359652,
                -0.08862573815103558,
                -0.03806026048029143,
                0.01260275041888903,
                0.06323324332342173,
                0.11370125048411683,
                0.1638772212510342,
                0.21363235462817598,
                0.26283892990385804,
                0.3113706345080529,
                0.3591028882550842,
                0.40591316313938486,
                0.4516812978634088,
                0.49628980629034736,
                0.5396241790298808,
                0.5815731773828856,
                0.6220291188906137,
                0.6608881537555047,
                0.698050531424288,
                0.7334208566494245,
                0.7669083343722238,
                0.7984270028000868,
                0.8278959540815023,
                0.8552395420159162,
                0.8803875762723095,
                0.9032755026324646,
                0.9238445688283561,
                0.9420419756249443,
                0.9578210129643288,
                0.971141181434384,
                0.9819683009296274,
                0.9902746160577605,
                0.9960389621089085,
                0.9992478262666273,
            ],
            "weights": [
                0.0005202913631633613,
                0.0032053743375767127,
                0.005764237200210912,
                0.008306955763490739,
                0.010828165565382025,
                0.013321533628928297,
                0.015780689868874542,
                0.018199330835333212,
                0.020571251316891966,
                0.022890364089031008,
                0.025150716720617146,
                0.027346507281175023,
                0.029472099408722252,
                0.03152203685632928,
                0.033491057535954695,
                0.03537410704553913,
                0.03716635165409281,
                0.038863190715761796,
                0.04046026848312707,
                0.04195348529047664,
                0.043339008078928855,
                0.044613280236700505,
                0.04577303072944868,
                0.04681528249735137,
                0.047737360097440215,
                0.048536896571616285,
                0.04921183952271572,
                0.049760456383095786,
                0.05018133886217435,
                0.05047340656154551,
                0.05063590974839386,
                0.050668431280083324,
                0.050570887674985264,
                0.05034352932680293,
                0.04998693986183801,
                0.04950203464086917,
                0.04889005840946172,
                0.04815258210276363,
                0.0472914988129819,
                0.046309018929929155,
                0.045207664467045404,
                0.04399026258756983,
                0.04265993834741186,
                0.041220106673435675,
                0.039674463597747164,
                0.03802697677057,
                0.0362818752761927,
                0.03444363877825716,
                0.032516986022651226,
                0.0305068627280724,
                0.0284184288965367,
                0.026257045578700334,
                0.024028261132902774,
                0.021737797024168788,
                0.019391533226357286,
                0.016995493335742785,
                0.014555829644453918,
                0.012078808932701648,
                0.009570802008960414,
                0.007038293349592323,
                0.004488047646416134,
                0.0019300786847082716,
            ],
            "generator": "gauss_radau",
        },
        63: {
            "degree": 125,
            "points": [
                -1.0,
                -0.9981509895151767,
                -0.9938060450141462,
                -0.986989829442767,
                -0.9777198182799245,
                -0.966019151794538,
                -0.9519169464037625,
                -0.9354482723388584,
                -0.9166540776882612,
                -0.895581089948392,
                -0.8722817010616921,
                -0.8468138376619674,
                -0.8192408172886503,
                -0.7896311910831568,
                -0.7580585734202565,
                -0.7246014589249044,
                -0.6893430273420122,
                -0.6523709367505495,
                -0.6137771056393342,
                -0.5736574843881064,
                -0.5321118167230505,
                -0.4892433917403949,
                -0.445158787115,
                -0.3999676041325564,
                -0.35378219520430654,
                -0.30671738454181674,
                -0.2588901826863208,
                -0.21041949560237883,
                -0.1614258290591537,
                -0.1120309890342468,
                -0.06235777888497207,
                -0.012529694039947303,
                0.037329385029939655,
                0.0870955007978712,
                0.13664492685903262,
                0.18585447553396806,
                0.2346018041326,
                0.28276571911750237,
                0.3302264774102359,
                0.37686608409165046,
                0.4225685857560506,
                0.46722035878990187,
                0.5107103918584148,
                0.5529305618977289,
                0.5937759029265994,
                0.6331448670093724,
                0.6709395767215897,
                0.7070660684907768,
                0.7414345262077946,
                0.7739595045285632,
                0.8045601413120362,
                0.8331603586681369,
                0.8596890521192995,
                0.8840802674121292,
                0.9062733645536689,
                0.9262131686955626,
                0.943850107565534,
                0.9591403353018564,
                0.9720458429761833,
                0.9825345576407667,
                0.990580439176103,
                0.9961636367658119,
                0.9992715134039268,
            ],
            "weights": [
                0.0005039052658100522,
                0.0031044862810025624,
                0.0055830733987431444,
                0.008046475007313285,
                0.010489692721599787,
                0.012906786867939857,
                0.015291777565856963,
                0.01763874423172934,
                0.019941855234079497,
                0.022195386091056604,
                0.024393734845780217,
                0.026531436407641548,
                0.028603176308213657,
                0.03060380398948235,
                0.032528345645485554,
                0.03437201660673773,
                0.0361302332458551,
                0.03779862437893134,
                0.03937304213638955,
                0.04084957227729148,
                0.04222454392206908,
                0.043494538679732256,
                0.044656399147074505,
                0.0457072367588653,
                0.04664443896950659,
                0.04746567574843799,
                0.04816890537306581,
                0.0487523795049144,
                0.04921464753633094,
                0.04955456019698342,
                0.04977127241116226,
                0.0498642453988097,
                0.04983324801503713,
                0.04967835732481196,
                0.04939995841138819,
                0.04899874341894833,
                0.0484757098318543,
                0.04783215799477564,
                0.047069687879859566,
                0.04619019510900212,
                0.04519586624109256,
                0.04408917333597378,
                0.04287286780862222,
                0.041549973588869936,
                0.040123779603673616,
                0.03859783160067645,
                0.03697592333344204,
                0.0352620871303938,
                0.03346058387107513,
                0.031575892394972445,
                0.029612698369829334,
                0.027575882648233116,
                0.02547050914368271,
                0.023301812261007363,
                0.021075183923064664,
                0.01879616025181768,
                0.01647040800547921,
                0.014103711009049887,
                0.011701957309839622,
                0.009271129988175747,
                0.006817317456236148,
                0.0043468757405584054,
                0.001869304844666018,
            ],
            "generator": "gauss_radau",
        },
        64: {
            "degree": 127,
            "points": [
                -1.0,
                -0.9982083025478743,
                -0.9939979015558583,
                -0.9873923711258606,
                -0.978408137422235,
                -0.9670669349034302,
                -0.9533961114045691,
                -0.9374286107538735,
                -0.9192029042922031,
                -0.8987629014421076,
                -0.8761578450984516,
                -0.8514421934823473,
                -0.8246754891683783,
                -0.7959222157515,
                -0.7652516425588343,
                -0.7327376578064955,
                -0.6984585906155645,
                -0.6624970223220453,
                -0.6249395875385422,
                -0.5858767654486572,
                -0.5454026618378824,
                -0.5036147823866814,
                -0.46061379777226275,
                -0.416503301145161,
                -0.37138955856502365,
                -0.32538125299692144,
                -0.27858922248497375,
                -0.23112619313409088,
                -0.1831065075431435,
                -0.13464584934379176,
                -0.08586096450860836,
                -0.03686938009989493,
                0.01221087886324268,
                0.0612615737374671,
                0.11016453710243979,
                0.15880195743648917,
                0.2070566629349111,
                0.25481240378715575,
                0.30195413223287315,
                0.34836827972215256,
                0.39394303051225044,
                0.438568591041703,
                0.48213745443290223,
                0.5245446594859473,
                0.5656880435398646,
                0.6054684885921036,
                0.6437901600834579,
                0.6805607377733078,
                0.715691638149188,
                0.7490982278352363,
                0.780700027485985,
                0.8104209056753049,
                0.8381892623152194,
                0.8639382011660817,
                0.887605691029109,
                0.9091347152465892,
                0.9284734091797211,
                0.9455751854051329,
                0.9603988465196707,
                0.9729086858565044,
                0.9830745779151426,
                0.99087206751419,
                0.9962825175936476,
                0.9992940990182639,
            ],
            "weights": [
                0.00048828124999999686,
                0.003008286537027181,
                0.00541031239637733,
                0.007798039728768763,
                0.010166807374230353,
                0.012511039136825015,
                0.01482511603964074,
                0.01710347187145723,
                0.019340621068183933,
                0.021531175512262392,
                0.02366985862092884,
                0.0257515184590175,
                0.02777114031401161,
                0.02972385885018811,
                0.03160496986502254,
                0.03340994164021747,
                0.03513442586885921,
                0.03677426813645182,
                0.03832551793255098,
                0.039784438169887706,
                0.041147514188598903,
                0.04241146222415246,
                0.0435732373187601,
                0.04463004065730569,
                0.04557932631018137,
                0.04641880736683271,
                0.04714646144523933,
                0.047760535564113936,
                0.04825955036603957,
                0.04864230368143453,
                0.04890787342470907,
                0.04905561981569175,
                0.049085186920937704,
                0.048996503511224955,
                0.04878978323317423,
                0.048465524094568786,
                0.04802450726464189,
                0.04746779519219322,
                0.04679672904607419,
                0.04601292548424684,
                0.045118272759143735,
                0.044114926168775,
                0.04300530286450241,
                0.04179207602802158,
                0.0404781684316017,
                0.03906674539709682,
                0.037561207170743086,
                0.03596518073218427,
                0.03428251105753629,
                0.03251725185772528,
                0.030673655814723828,
                0.02875616433977434,
                0.026769396879343137,
                0.024718139796785738,
                0.022607334861046123,
                0.020442067380497083,
                0.01822755403555661,
                0.01596913050579307,
                0.01367223911865548,
                0.01134241722573187,
                0.008985289142817078,
                0.006606576992620711,
                0.004212258833884141,
                0.0018113567234092297,
            ],
            "generator": "gauss_radau",
        },
        65: {
            "degree": 129,
            "points": [
                -1.0,
                -0.9982629917866762,
                -0.9941809829466994,
                -0.9877765279174741,
                -0.9790650817870026,
                -0.968067078419473,
                -0.9548082292527238,
                -0.9393195102649265,
                -0.9216371001798213,
                -0.9018022991199749,
                -0.8798614332847552,
                -0.8558657472228559,
                -0.8298712843633057,
                -0.8019387562302286,
                -0.7721334007048871,
                -0.7405248296912794,
                -0.7071868665528792,
                -0.6721973737060558,
                -0.6356380707759146,
                -0.5975943437409457,
                -0.5581550455131867,
                -0.5174122884202229,
                -0.47546122907403054,
                -0.43239984612932736,
                -0.3883287114506244,
                -0.3433507552225118,
                -0.29757102555183945,
                -0.2510964431232936,
                -0.20403555148139696,
                -0.15649826352220408,
                -0.10859560478675534,
                -0.06043945415587637,
                -0.012142282551929506,
                0.0361831097421923,
                0.08442385653332973,
                0.13246728932227714,
                0.1802012004462914,
                0.22751410514531867,
                0.2742955019398683,
                0.3204361307124066,
                0.3658282278895393,
                0.4103657781289589,
                0.4539447619233956,
                0.49646339854324806,
                0.5378223837505511,
                0.5779251217291113,
                0.6166779506891815,
                0.6539903616198595,
                0.6897752096784222,
                0.723948917723106,
                0.7564316715143073,
                0.7871476061288742,
                0.8160249831530757,
                0.8429963582421762,
                0.8679987386585262,
                0.8909737304266103,
                0.9118676747746053,
                0.9306317735729552,
                0.9472222035470548,
                0.9616002191825865,
                0.9737322446404444,
                0.9835899564491919,
                0.9911503657265548,
                0.9963959580418353,
                0.9993156503629748,
            ],
            "weights": [
                0.0004733727810650701,
                0.002916489106295521,
                0.005245442790751769,
                0.007560919531840057,
                0.009858569176805193,
                0.012133151845187975,
                0.014379382754808328,
                0.01659202406842226,
                0.018765911156354995,
                0.02089596813325653,
                0.022977220786957547,
                0.025004808584734004,
                0.026973996183871543,
                0.028880184562293,
                0.03071892179408563,
                0.03248591346480845,
                0.03417703271084581,
                0.03578832986329691,
                0.037316041675795456,
                0.03875660011568086,
                0.04010664069852253,
                0.04136301034681116,
                0.04252277475463177,
                0.043583225241220325,
                0.044541885077453595,
                0.045396515270525156,
                0.0461451197933485,
                0.04678595024644125,
                0.04731750994147138,
                0.04773855739687871,
                0.04804810923745697,
                0.048245442491096094,
                0.04833009627734456,
                0.0483018728838349,
                0.04816083822806739,
                0.047907321703476106,
                0.047541915410130454,
                0.04706547277188318,
                0.046479106543170216,
                0.0457841862101595,
                0.04498233479227638,
                0.04407542505162315,
                0.04306557511909547,
                0.04195514354749014,
                0.040746723803085354,
                0.039443138208652764,
                0.03804743135200799,
                0.03656286297555224,
                0.03499290036350793,
                0.033341210244651816,
                0.03161165022969381,
                0.029808259803565728,
                0.027935250894217736,
                0.02599699804100265,
                0.023998028187721763,
                0.02194301012861284,
                0.019836743641968545,
                0.017684148361017928,
                0.015490252472489358,
                0.013260181460483448,
                0.010999147577444945,
                0.008712442789212939,
                0.006405450061900537,
                0.004083797451241154,
                0.0017560618304027864,
            ],
            "generator": "gauss_radau",
        },
        66: {
            "degree": 131,
            "points": [
                -0.9999999999999996,
                -0.998315214963363,
                -0.9943558161212993,
                -0.9881434018486226,
                -0.9796925274800481,
                -0.9690224221933221,
                -0.95615728154264,
                -0.9411262582490605,
                -0.9239634063933053,
                -0.9047076073276354,
                -0.8834024826990841,
                -0.8600962960877188,
                -0.8348418438826193,
                -0.8076963357846267,
                -0.7787212652628703,
                -0.7479822702830106,
                -0.7155489846341356,
                -0.6814948801967935,
                -0.6458971005124556,
                -0.6088362860330636,
                -0.5703963914474415,
                -0.530664495498957,
                -0.48973060372556754,
                -0.44768744456932197,
                -0.40463025931733054,
                -0.36065658635014275,
                -0.3158660401863227,
                -0.270360085823814,
                -0.22424180888930012,
                -0.17761568211626377,
                -0.1305873286807666,
                -0.08326328293107177,
                -0.03575074905314635,
                0.011842641781252716,
                0.059409075233775366,
                0.10684079803361768,
                0.1540303620733401,
                0.2008708678134048,
                0.24725620644405166,
                0.29308130025593226,
                0.3382423406749918,
                0.3826370234223826,
                0.4261647802667001,
                0.46872700684356217,
                0.5102272860264627,
                0.5505716063429191,
                0.5896685749411662,
                0.6274296246250134,
                0.6637692144879467,
                0.6986050236921018,
                0.7318581379533414,
                0.763453228310315,
                0.7933187217730825,
                0.8213869634656759,
                0.8475943698969954,
                0.8718815730159934,
                0.8941935547310133,
                0.9144797716013611,
                0.9326942694469816,
                0.9487957876844965,
                0.9627478533330203,
                0.9745188650172107,
                0.9840821687002017,
                0.9914161336501389,
                0.9965042850174605,
                0.9993362296360994,
            ],
            "weights": [
                0.00045913682277366226,
                0.00282882946585579,
                0.005087991477013929,
                0.007334438479281521,
                0.00956410746913042,
                0.011772070109989085,
                0.013953351435103107,
                0.016103018228160276,
                0.018216203805525227,
                0.020288122410644455,
                0.022314081096835903,
                0.02428949073533232,
                0.026209876564919764,
                0.02807088839757411,
                0.029868310506296746,
                0.031598071192184954,
                0.03325625201739677,
                0.034839096686922866,
                0.03634301956088211,
                0.03776461377903369,
                0.03910065897958515,
                0.040348128595113254,
                0.04150419670920687,
                0.042566244458408675,
                0.043531865965032224,
                0.04439887378738897,
                0.04516530387517634,
                0.045829420018767705,
                0.04638971778233197,
                0.046844927911932524,
                0.047194019210809145,
                0.0474362008754112,
                0.047570924286843376,
                0.04759788425367521,
                0.047517019703321124,
                0.04732851382040201,
                0.047032793631782976,
                0.04663052903924527,
                0.046122631301957824,
                0.04551025097219305,
                0.04479477528899689,
                0.0439778250356622,
                0.04306125086818924,
                0.042047129123002555,
                0.04093775711345728,
                0.03973564792579642,
                0.03844352472634822,
                0.03706431459289922,
                0.035601141884233634,
                0.03405732116293978,
                0.03243634968758617,
                0.030741899491457964,
                0.028977809066080804,
                0.02714807466890638,
                0.025256841275871335,
                0.023308393201376024,
                0.021307144411240545,
                0.01925762856030517,
                0.01716448880078518,
                0.015032467446941452,
                0.012866395704935966,
                0.010671184126894879,
                0.00845181645123898,
                0.006213361247435794,
                0.003961122080038651,
                0.0017032606379375525,
            ],
            "generator": "gauss_radau",
        },
        67: {
            "degree": 133,
            "points": [
                -1.0,
                -0.998365118133736,
                -0.994522889059741,
                -0.9884940136506021,
                -0.9802922125990488,
                -0.9699355979422127,
                -0.9574469593769543,
                -0.9428537584115025,
                -0.9261880779283911,
                -0.9074865546238426,
                -0.8867902995415897,
                -0.8641448081436308,
                -0.8395998605036314,
                -0.8132094119799728,
                -0.7850314746634237,
                -0.755127989883782,
                -0.7235646920668494,
                -0.6904109642465277,
                -0.6557396855525508,
                -0.6196270710106807,
                -0.5821525040084303,
                -0.5433983617951155,
                -0.5034498344001493,
                -0.46239473736783543,
                -0.42032331872043616,
                -0.3773280605739411,
                -0.3335034758426768,
                -0.2889459004796904,
                -0.24375328170962163,
                -0.19802496271960812,
                -0.15186146428151626,
                -0.10536426378556007,
                -0.058635572171039096,
                -0.011778109244559354,
                0.035105122120363985,
                0.08191106240596024,
                0.12853682199738192,
                0.17487990735642045,
                0.22083844632456917,
                0.2663114120601664,
                0.3111988451173828,
                0.3554020731788443,
                0.39882392795890875,
                0.44136895880078053,
                0.4829436424979543,
                0.5234565888787679,
                0.5628187417021706,
                0.6009435744231233,
                0.6377472803973601,
                0.6731489571074674,
                0.7070707840054447,
                0.7394381935810044,
                0.770180035279878,
                0.7992287319123481,
                0.8265204282090961,
                0.8519951311994542,
                0.8755968421065619,
                0.8972736794754885,
                0.9169779932761053,
                0.9346664697573546,
                0.9503002268883141,
                0.9638449003506697,
                0.9752707204179303,
                0.9845525814182625,
                0.991670112046203,
                0.9966078012412647,
                0.9993558944296039,
            ],
            "weights": [
                0.0004455335263978541,
                0.002745062662912681,
                0.004937520259174675,
                0.007117970298199422,
                0.009282615185662275,
                0.011426815506643961,
                0.013545883827104683,
                0.01563516982202418,
                0.017690083701011154,
                0.01970610956742262,
                0.02167881635584019,
                0.023603867938331205,
                0.025477032805393863,
                0.027294193434548045,
                0.029051355373808527,
                0.030744656038946074,
                0.032370373213262624,
                0.03392493323492108,
                0.035404918855623406,
                0.03680707675428557,
                0.03812832468968601,
                0.03936575827664038,
                0.04051665737094837,
                0.04157849204919325,
                0.042548928170286195,
                0.04342583250656813,
                0.04420727743322352,
                0.044891545165697586,
                0.045477131535810816,
                0.04596274929830804,
                0.04634733096051763,
                0.04663003112897174,
                0.04681022836777975,
                0.04688752656469687,
                0.046861755801881795,
                0.04673297272942264,
                0.04650146044082249,
                0.04616772785071223,
                0.04573250857616131,
                0.04519675932403432,
                0.044561657787979624,
                0.043828600059600605,
                0.042999197559605455,
                0.04207527349556765,
                0.04105885885418833,
                0.039952187936815466,
                0.03875769344807364,
                0.037478001148388326,
                0.03611592408221072,
                0.03467445639463949,
                0.03315676675010679,
                0.03156619136767626,
                0.029906226688414434,
                0.028180521691274673,
                0.026392869874848776,
                0.024547200923639587,
                0.022647572079165505,
                0.020698159239012845,
                0.01870324781287215,
                0.016667223378468984,
                0.014594562218591985,
                0.012489821939906564,
                0.010357632811127634,
                0.008202692401640687,
                0.006029777509457817,
                0.003843890514322606,
                0.0016528054295257457,
            ],
            "generator": "gauss_radau",
        },
        68: {
            "degree": 135,
            "points": [
                -1.0,
                -0.9984128366995431,
                -0.9946826541918775,
                -0.988829309842969,
                -0.9808657492258377,
                -0.9708090472588973,
                -0.9586806883692766,
                -0.944506563598865,
                -0.9283169249903503,
                -0.9101463239055599,
                -0.8900335383290052,
                -0.8680214905424991,
                -0.8441571557231994,
                -0.8184914617937132,
                -0.7910791807910335,
                -0.7619788120091777,
                -0.7312524571756929,
                -0.6989656879337544,
                -0.6651874059154737,
                -0.6299896957065558,
                -0.593447671016964,
                -0.5556393143863857,
                -0.5166453107668878,
                -0.4765488753381022,
                -0.4354355759225098,
                -0.39339315037988976,
                -0.3505113193706657,
                -0.3068815948877671,
                -0.2625970849656274,
                -0.21775229498310167,
                -0.17244292598434052,
                -0.12676567044803078,
                -0.08081800594083632,
                -0.0346979870954075,
                0.011495963643109564,
                0.05766526605551392,
                0.10371139252369455,
                0.14953607829353222,
                0.19504153117685208,
                0.2401306402449057,
                0.284707183068023,
                0.32867603105918297,
                0.37194335248329025,
                0.4144168126989187,
                0.4560057712052348,
                0.49662147507356624,
                0.5361772483508693,
                0.5745886770309059,
                0.6117737891984303,
                0.6476532299620033,
                0.6821504308021928,
                0.7151917729738837,
                0.7467067446141762,
                0.7766280912209209,
                0.8048919591812509,
                0.8314380320447414,
                0.8562096592519579,
                0.8791539770466643,
                0.9002220213195031,
                0.9193688321543896,
                0.9365535498811917,
                0.9517395024936686,
                0.96489428441542,
                0.9759898269547798,
                0.9850024621096076,
                0.9919129877577186,
                0.9967067873632627,
                0.9993746981327116,
            ],
            "weights": [
                0.0004325259515570862,
                0.002664961603057862,
                0.004793622805964095,
                0.0069109340703002895,
                0.009013343374689167,
                0.011096479539082126,
                0.013155922269305039,
                0.015187284227984101,
                0.0171862332145325,
                0.019148504584393704,
                0.021069911330980455,
                0.0229463533760547,
                0.024773826464324307,
                0.026548430773575604,
                0.028266379268409955,
                0.029924005798065065,
                0.0315177729288822,
                0.0330442794983043,
                0.034500267876034066,
                0.0358826309177503,
                0.03718841859701714,
                0.03841484430150585,
                0.0395592907802361,
                0.04061931572923488,
                0.04159265700375721,
                0.04247723744597042,
                0.043271169317814495,
                0.04397275832961562,
                0.04458050725584364,
                0.04509311913029859,
                0.04550950001395059,
                0.045828761329469045,
                0.04605022175752393,
                0.046173408690766915,
                0.0461980592424109,
                0.046124120807260936,
                0.04595175117398152,
                0.04568131818838007,
                0.0453133989684217,
                0.044848778672636466,
                0.04428844882457518,
                0.04363360519684959,
                0.04288564525934165,
                0.042046165196935194,
                0.04111695650323127,
                0.04010000215746496,
                0.038997472392783866,
                0.037811720064977926,
                0.036545275631501464,
                0.03520084175154098,
                0.033781287518725306,
                0.03228964233876781,
                0.030729089465257216,
                0.029102959207511856,
                0.02741472182528784,
                0.02566798012598458,
                0.02386646178113295,
                0.02201401138046913,
                0.020114582244624455,
                0.018172228023052264,
                0.016191094117303653,
                0.014175409006796794,
                0.012129475670257584,
                0.010057663720013271,
                0.007964404753110433,
                0.005854204497833429,
                0.0037317854694191876,
                0.0016045592659068568,
            ],
            "generator": "gauss_radau",
        },
        69: {
            "degree": 137,
            "points": [
                -0.9999999999999994,
                -0.9984584963275704,
                -0.9948355314596522,
                -0.9891501691113647,
                -0.981414634221649,
                -0.9716450378316315,
                -0.9598616511781952,
                -0.9460889053961143,
                -0.9303553502417301,
                -0.9126935977139032,
                -0.8931402554685821,
                -0.8717358513602376,
                -0.848524749632366,
                -0.823555059060491,
                -0.7968785332895718,
                -0.7685504635947531,
                -0.7386295642982081,
                -0.7071778510847537,
                -0.6742605124711818,
                -0.6399457746971935,
                -0.6043047603188207,
                -0.5674113407979173,
                -0.5293419833935642,
                -0.4901755926729041,
                -0.44999334697003524,
                -0.4088785301319917,
                -0.36691635890060703,
                -0.3241938062880665,
                -0.280799421312254,
                -0.23682314546554517,
                -0.1923561262974418,
                -0.14749052849744437,
                -0.10231934286972466,
                -0.05693619359553348,
                -0.011435144182823542,
                0.03408949749471235,
                0.07954337466509731,
                0.12483227722688417,
                0.169862337013986,
                0.2145402223517977,
                0.25877333150137183,
                0.3024699845907035,
                0.34553961363531915,
                0.38789295025433135,
                0.42944221069288535,
                0.4701012777675313,
                0.5097858793574122,
                0.548413763071337,
                0.5859048667287392,
                0.6221814843012039,
                0.6571684269706753,
                0.6907931789706012,
                0.7229860478871277,
                0.7536803091090076,
                0.7828123441271261,
                0.8103217723975022,
                0.8361515764953285,
                0.8602482203021948,
                0.8825617599844391,
                0.9030459475382602,
                0.9216583266987024,
                0.9383603210396345,
                0.9531173141442201,
                0.9658987218441434,
                0.9766780568722051,
                0.9854329875533874,
                0.9921453983492337,
                0.9968015038656013,
                0.9993926902946286,
            ],
            "weights": [
                0.00042007981516541354,
                0.0025883155106512503,
                0.004655921911777742,
                0.006712790351663227,
                0.008755596259505376,
                0.010780217748815218,
                0.012782482978434298,
                0.014758249345227303,
                0.016703424518144543,
                0.018613978002796183,
                0.020485950447934363,
                0.022315462196660776,
                0.024098721468245193,
                0.025832032280139028,
                0.027511802138880166,
                0.029134549501714894,
                0.030696911001089462,
                0.032195648420533615,
                0.03362765540918379,
                0.03498996392188418,
                0.03627975037198822,
                0.03749434148436992,
                0.03863121983665277,
                0.039688029077253655,
                0.04066257880949105,
                0.04155284913167691,
                0.04235699482376109,
                0.04307334917191512,
                0.04370042742310431,
                0.04423692986251153,
                0.04468174450741265,
                0.04503394941197499,
                0.04529281457812639,
                0.04545780346861935,
                0.045528574119095895,
                0.045504979846867376,
                0.04538706955494957,
                0.04517508763071392,
                0.04486947343936388,
                0.044470860413299215,
                0.0439800747392335,
                0.043398133645823345,
                0.042726243295306804,
                0.04196579628358639,
                0.04111836875387827,
                0.040185717129957305,
                0.039169774475748445,
                0.03807264648882878,
                0.0368966071361411,
                0.03564409394099071,
                0.03431770293109849,
                0.03292018325823315,
                0.03145443150060493,
                0.029923485659936626,
                0.02833051886578843,
                0.026678832800465346,
                0.024971850858610766,
                0.023213111056607273,
                0.021406258708346088,
                0.019555038886496293,
                0.01766328869378782,
                0.015734929381855844,
                0.013773958391130213,
                0.011784441497916893,
                0.009770505666530338,
                0.007736335036842002,
                0.005686183233442188,
                0.003624512436086616,
                0.0015583950551306593,
            ],
            "generator": "gauss_radau",
        },
        70: {
            "degree": 139,
            "points": [
                -1.0,
                -0.9985022137775504,
                -0.9949819110760998,
                -0.98945740805528,
                -0.9819402589597659,
                -0.9724456780750746,
                -0.9609928078464823,
                -0.9476047208612658,
                -0.9323083824784738,
                -0.9151345992394766,
                -0.8961179578069077,
                -0.8752967557162519,
                -0.8527129244349344,
                -0.8284119450098941,
                -0.8024427565235598,
                -0.7748576575643329,
                -0.7457122009201673,
                -0.7150650817123778,
                -0.6829780191976013,
                -0.6495156324774,
                -0.6147453103666335,
                -0.5787370756831524,
                -0.5415634442324114,
                -0.5032992787711711,
                -0.4640216382445058,
                -0.4238096225998059,
                -0.3827442134903537,
                -0.34090811118930675,
                -0.2983855680425469,
                -0.2552622187958169,
                -0.2116249081378465,
                -0.16756151580679857,
                -0.12316077961223215,
                -0.0785121167290157,
                -0.0337054436230706,
                0.011169005028397017,
                0.056020858057512335,
                0.10075978980123201,
                0.14529570200520547,
                0.18953890526968342,
                0.2334002996720448,
                0.27679155420221724,
                0.3196252846496108,
                0.36181522958335166,
                0.40327642407138575,
                0.44392537078865457,
                0.48368020816971513,
                0.5224608752672142,
                0.5601892729842075,
                0.5967894213556575,
                0.6321876125623878,
                0.6663125593694064,
                0.6990955386897177,
                0.7304705299846421,
                0.7603743482220728,
                0.7887467711252361,
                0.815530660456149,
                0.8406720770903948,
                0.8641203896529608,
                0.8858283764991819,
                0.9057523208409135,
                0.9238520988377465,
                0.9400912605010288,
                0.9544371033080976,
                0.9668607385382264,
                0.977337150676977,
                0.9858452514784533,
                0.992367936287694,
                0.9968921927767562,
                0.99940991695126,
            ],
            "weights": [
                0.0004081632653061159,
                0.0025149285418297664,
                0.004524067028262819,
                0.006523037673874753,
                0.008508726781303,
                0.010477244392766368,
                0.012424649975520265,
                0.014347028900711246,
                0.016240512421229227,
                0.018101288457833854,
                0.019925610201750942,
                0.02170980399527418,
                0.023450276866652166,
                0.02514352382703728,
                0.026786134958607957,
                0.028374802296874686,
                0.029906326500700034,
                0.031377623300001795,
                0.03278572970980554,
                0.03412780999896419,
                0.03540116140199416,
                0.036603219562753135,
                0.037731563699162037,
                0.038783921478628386,
                0.03975817359443228,
                0.04065235803387136,
                0.04146467402958972,
                0.04219348568616152,
                0.04283732527462433,
                0.04339489618831652,
                0.04386507555411305,
                0.04424691649376387,
                0.04453965003079033,
                0.044742686639124785,
                0.04485561743034823,
                0.0448782149771416,
                0.0448104337713103,
                0.0446524103154344,
                0.04440446284798038,
                0.044067090702421166,
                0.04364097330165356,
                0.04312696878974429,
                0.04252611230374779,
                0.04183961388909943,
                0.041068856062774446,
                0.040215391029090705,
                0.03928093755382691,
                0.038267377502900796,
                0.037176752052612436,
                0.036011257579072975,
                0.03477324123513761,
                0.03346519622373187,
                0.032089756777170984,
                0.03064969285257161,
                0.029147904554190415,
                0.027587416294011027,
                0.025971370702634743,
                0.024303022303196677,
                0.02258573096195685,
                0.020822955130571984,
                0.019018244897492143,
                0.017175234871123483,
                0.015297636929981288,
                0.013389232909986138,
                0.011453867408427996,
                0.009495441284173647,
                0.007517908214131309,
                0.005525287116678016,
                0.0035217977471179635,
                0.0015141947149219302,
            ],
            "generator": "gauss_radau",
        },
        71: {
            "degree": 141,
            "points": [
                -1.0,
                -0.9985440976490789,
                -0.995122156014891,
                -0.9897517863758797,
                -0.9824439181133456,
                -0.9732129303473004,
                -0.9620769141858756,
                -0.9490576767087061,
                -0.9341807071185856,
                -0.9174751294842048,
                -0.8989736466801478,
                -0.8787124767626362,
                -0.8567312822510014,
                -0.8330730925758171,
                -0.8077842198941456,
                -0.7809141684578261,
                -0.7525155377221029,
                -0.7226439193891743,
                -0.6913577885907767,
                -0.6587183894242278,
                -0.6247896150667966,
                -0.5896378827035563,
                -0.5533320035138389,
                -0.5159430479709806,
                -0.47754420671914866,
                -0.4382106472996693,
                -0.3980193670073695,
                -0.35704904216500544,
                -0.3153798741108541,
                -0.2730934322009694,
                -0.23027249413344852,
                -0.18700088390728375,
                -0.14336330773301365,
                -0.09944518821638448,
                -0.05533249713962829,
                -0.011111587167685788,
                0.03313097719117031,
                0.07730858903941873,
                0.12133476862735071,
                0.16512333264125068,
                0.20858856291128802,
                0.25164537420888133,
                0.2942094808050575,
                0.3361975614637669,
                0.3775274225471661,
                0.41811815891360093,
                0.45789031229331423,
                0.4967660268318619,
                0.5346692014967767,
                0.5715256390491328,
                0.6072631912884248,
                0.6418119002864631,
                0.6751041353338743,
                0.7070747253311747,
                0.7376610863653901,
                0.7668033442226394,
                0.7944444515971585,
                0.8205302997677828,
                0.8450098245241064,
                0.86783510613642,
                0.88896146317647,
                0.9083475400107246,
                0.9259553878059381,
                0.9417505389129126,
                0.955702074541471,
                0.9677826857494496,
                0.9779687280931433,
                0.9862402714934633,
                0.9925811527154036,
                0.9969790792181594,
                0.9994264209199566,
            ],
            "weights": [
                0.0003967466772465735,
                0.0024446185331022125,
                0.004397732036431984,
                0.006341209384351346,
                0.00827213257096205,
                0.010186827628216322,
                0.012081569583365847,
                0.013952656375257954,
                0.01579642785689439,
                0.017609275871401927,
                0.019387652214789233,
                0.021128075907351156,
                0.022827140140639558,
                0.02448151900591314,
                0.026087974033471337,
                0.027643360546866884,
                0.02914463382674572,
                0.03058885507555414,
                0.031973197173034165,
                0.03329495021206602,
                0.03455152680445249,
                0.03574046714650753,
                0.03685944383466911,
                0.03790626642179029,
                0.0388788857052394,
                0.03977539773845198,
                0.04059404755809586,
                0.04133323261955866,
                0.041991505934062624,
                0.04256757890124909,
                0.04306032383170613,
                0.043468776154487285,
                0.043792136305336474,
                0.044029771291869,
                0.044181215932708906,
                0.04424617376810515,
                0.044224517640278495,
                0.044116289942340944,
                0.04392170253532001,
                0.04364113633343732,
                0.04327514055845692,
                0.04282443166457521,
                0.04228989193592049,
                0.04167256775947273,
                0.04097366757671715,
                0.040194559518079466,
                0.039336768724783255,
                0.03840197436334644,
                0.03739200633857116,
                0.03630884171149869,
                0.035154600829305736,
                0.03393154317474299,
                0.03264206294329601,
                0.031288684356696905,
                0.029874056722058232,
                0.02840094924635299,
                0.026872245616564462,
                0.025290938356325544,
                0.023660122970599485,
                0.0219829918907141,
                0.020262828233378237,
                0.018502999389631573,
                0.01670695046466909,
                0.014878197601692188,
                0.013020321256860827,
                0.011136959598672594,
                0.009231802593962397,
                0.007308589073277861,
                0.00537111922676601,
                0.0034233868326851787,
                0.0014718484169968765,
            ],
            "generator": "gauss_radau",
        },
        72: {
            "degree": 143,
            "points": [
                -0.9999999999999996,
                -0.9985842490564778,
                -0.9952566042600623,
                -0.9900340115653228,
                -0.9829268176016945,
                -0.9739486229066807,
                -0.963116538418634,
                -0.9504511912147253,
                -0.9359766938418752,
                -0.9197206009832275,
                -0.9017138579316193,
                -0.8819907420657249,
                -0.860588797776138,
                -0.8375487650843889,
                -0.8129145021380513,
                -0.7867329017500433,
                -0.7590538021505839,
                -0.7299298921264774,
                -0.6994166107307977,
                -0.6675720417552509,
                -0.634456803166872,
                -0.6001339317199792,
                -0.5646687629633056,
                -0.5281288068709069,
                -0.49058361933368744,
                -0.4521046697562461,
                -0.4127652050111268,
                -0.37264011000947717,
                -0.33180576515354465,
                -0.2903399009423835,
                -0.24832145000753103,
                -0.20583039686034965,
                -0.16294762563701815,
                -0.11975476613103697,
                -0.07633403840630804,
                -0.032768096286599935,
                0.010860129980683197,
                0.054467591586930264,
                0.09797127925044624,
                0.14128838122933574,
                0.18433644095836887,
                0.2270335140097529,
                0.26929832407902987,
                0.3110504176991683,
                0.3522103173883563,
                0.3926996729399542,
                0.4324414105666402,
                0.4713598796148373,
                0.5093809965701548,
                0.5464323860797321,
                0.5824435187230494,
                0.6173458452689842,
                0.6510729271635611,
                0.683560563000067,
                0.714746910730844,
                0.744572605388238,
                0.7729808720907833,
                0.7999176341197816,
                0.8253316158610113,
                0.849174440416407,
                0.8714007217013204,
                0.8919681508547163,
                0.9108375768030056,
                0.9279730808349219,
                0.943342045069268,
                0.9569152147422143,
                0.9686667543465628,
                0.9785742979700301,
                0.9866189953520869,
                0.9927855608599139,
                0.9970623728016939,
                0.9994422420658052,
            ],
            "weights": [
                0.0003858024691360644,
                0.0023772158706017363,
                0.004276613232907753,
                0.0061668707887917625,
                0.008045252303305186,
                0.009908285150617323,
                0.01175244543522194,
                0.013574229485151926,
                0.015370171952359074,
                0.01713685523981756,
                0.018870916881849324,
                0.020569056261399446,
                0.02222804102204241,
                0.023844713278784836,
                0.02541599565718956,
                0.026938897165675667,
                0.028410518896811777,
                0.029828059549948324,
                0.031188820766236833,
                0.032490212266693484,
                0.03372975678392055,
                0.03490509477836315,
                0.03601398893025041,
                0.037054328398741246,
                0.03802413284021875,
                0.03892155617811976,
                0.039744890117155415,
                0.04049256739520438,
                0.0411631647667423,
                0.041755405712100756,
                0.04226816286743567,
                0.04270046017074122,
                0.0430514747198518,
                0.04332053833890913,
                0.04350713885027017,
                0.04361092104948755,
                0.04363168738145677,
                0.04356939831648961,
                0.04342417242556378,
                0.0431962861546198,
                0.04288617329834318,
                0.042494424174412335,
                0.04202178449981116,
                0.041469153971313455,
                0.04083758455287692,
                0.04012827847319179,
                0.039342585937173775,
                0.038482002555810434,
                0.03754816649921011,
                0.0365428553782978,
                0.035467982861095974,
                0.034325595030035974,
                0.033117866487249084,
                0.03184709621527049,
                0.030515703201059508,
                0.02912622183171918,
                0.02768129707076154,
                0.026183679424230694,
                0.024636219706518872,
                0.023041863616280762,
                0.021403646133634165,
                0.019724685751023038,
                0.018008178552355075,
                0.016257392159839856,
                0.0144756595798257,
                0.012666373011814473,
                0.0108329777882227,
                0.00897896699047794,
                0.007107878969926717,
                0.005223309880062504,
                0.00332904264366136,
                0.0014312539043095872,
            ],
            "generator": "gauss_radau",
        },
        73: {
            "degree": 145,
            "points": [
                -1.0,
                -0.9986227622394318,
                -0.995385570841976,
                -0.9903047431515644,
                -0.9833900817857688,
                -0.9746544607438951,
                -0.9641140762618126,
                -0.9517884540863537,
                -0.9377004216795934,
                -0.9218760684437142,
                -0.9043446983095587,
                -0.8851387758443124,
                -0.8642938663048338,
                -0.8418485698634999,
                -0.8178444501743687,
                -0.7923259574319252,
                -0.7653403460742296,
                -0.7369375872875135,
                -0.7071702764766702,
                -0.6760935358743221,
                -0.6437649124695589,
                -0.6102442714458144,
                -0.5755936853254737,
                -0.5398773190266645,
                -0.5031613110451817,
                -0.46551365098164477,
                -0.4270040536407248,
                -0.38770382993561037,
                -0.34768575483679065,
                -0.30702393260969774,
                -0.2657936595907734,
                -0.2240712847560662,
                -0.1819340683405657,
                -0.13946003877008395,
                -0.09672784817060631,
                -0.05381662672268961,
                -0.010805836130605706,
                0.03222487752243097,
                0.07519583126046792,
                0.1180274527693359,
                0.16064042774626652,
                0.2029558467717245,
                0.24489535143150687,
                0.2863812794185081,
                0.32733680834546397,
                0.3676860980023715,
                0.4073544307951451,
                0.4462683501054814,
                0.48435579631568704,
                0.5215462402466267,
                0.5577708137616859,
                0.5929624372949134,
                0.6270559440672203,
                0.659988200760641,
                0.6916982244272345,
                0.7221272954162132,
                0.7512190661102864,
                0.7789196652700228,
                0.805177797793285,
                0.8299448397054547,
                0.8531749282053189,
                0.8748250466012526,
                0.8948551039830166,
                0.9132280094866785,
                0.9299097410256034,
                0.9448694083833833,
                0.9580793106073144,
                0.969514987743022,
                0.9791552672559627,
                0.9869823066251922,
                0.9929816391202497,
                0.997142268894283,
                0.9994574175425706,
            ],
            "weights": [
                0.00037530493525987895,
                0.0023125624668746056,
                0.004160427507101825,
                0.005999616563260295,
                0.007827562392962225,
                0.009640980236390446,
                0.011436533941376559,
                0.013210905162426982,
                0.01496081062506211,
                0.016683010959149293,
                0.018374317548355355,
                0.020031598742705797,
                0.02165178578326682,
                0.023231878541010834,
                0.024768951099516864,
                0.026260157187045944,
                0.027702735454737122,
                0.029094014594266172,
                0.030431418287011167,
                0.031712469976331245,
                0.03293479745454371,
                0.03409613725632076,
                0.035194338850513374,
                0.03622736862271778,
                0.03719331364124338,
                0.038090385199556764,
                0.03891692212864868,
                0.03967139387319892,
                0.040352403325865205,
                0.0409586894144409,
                0.041489129437097726,
                0.04194274114138585,
                0.042318684543163725,
                0.04261626348206613,
                0.042834926910636444,
                0.04297426991475605,
                0.04303403446345461,
                0.043014109886733556,
                0.04291453308050156,
                0.04273548843826285,
                0.04247730750966394,
                0.04214046838654836,
                0.04172559481765088,
                0.0412334550535568,
                0.040664960424090624,
                0.04002116365076597,
                0.0393032568973843,
                0.03851256956245189,
                0.03765056581746199,
                0.03671884189561717,
                0.035719123136023906,
                0.03465326078881241,
                0.033523228587144654,
                0.03233111909242427,
                0.03107913981954641,
                0.029769609149331352,
                0.0284049520358137,
                0.026987695516380153,
                0.025520464033215666,
                0.024005974574952543,
                0.022447031647969372,
                0.020846522087470374,
                0.019207409719628022,
                0.017532729888206918,
                0.01582558386372181,
                0.014089133164746775,
                0.012326593852895196,
                0.01054123096358331,
                0.008736353602409543,
                0.006915312873979443,
                0.005081514419350531,
                0.0032385442246991598,
                0.0013923158732824174,
            ],
            "generator": "gauss_radau",
        },
        74: {
            "degree": 147,
            "points": [
                -1.0,
                -0.998659725116291,
                -0.9955093496824003,
                -0.9905645965461132,
                -0.9838347599927989,
                -0.9753320354082154,
                -0.9650717646182139,
                -0.9530724445064028,
                -0.939355701818148,
                -0.9239462566166167,
                -0.9068718786114318,
                -0.8881633374775688,
                -0.867854347571964,
                -0.8459815072601939,
                -0.8225842330073319,
                -0.7977046883711975,
                -0.7713877080350559,
                -0.7436807170211805,
                -0.7146336452332297,
                -0.684298837482733,
                -0.6527309591625633,
                -0.6199868977378091,
                -0.5861256602318345,
                -0.5512082668924223,
                -0.5152976412297332,
                -0.4784584966243002,
                -0.44075721970944814,
                -0.4022617507383256,
                -0.36304146115114877,
                -0.32316702856330914,
                -0.2827103093996375,
                -0.24174420940434527,
                -0.20034255226000997,
                -0.15857994655235408,
                -0.11653165132056997,
                -0.0742734404354708,
                -0.03188146604987363,
                0.010567878632710581,
                0.05299809702378422,
                0.095332727001884,
                0.13749547870248757,
                0.1794103719975162,
                0.221001873416669,
                0.2621950322638562,
                0.30291561568344383,
                0.3430902424329061,
                0.38264651512082537,
                0.42151315067193784,
                0.4596201087841201,
                0.4968987181458355,
                0.5332818001866002,
                0.5687037901374572,
                0.6031008551833301,
                0.6364110094943423,
                0.6685742259288523,
                0.6995325442069347,
                0.7292301753594512,
                0.7576136022645792,
                0.7846316760907903,
                0.810235708472739,
                0.8343795592543948,
                0.857019719642053,
                0.8781153906187158,
                0.8976285564810635,
                0.9155240533714091,
                0.9317696326913176,
                0.9463360193051342,
                0.9591969644824914,
                0.9703292936273074,
                0.9797129491369223,
                0.9873310298432489,
                0.9931698338640813,
                0.9972189497638162,
                0.9994719820110014,
            ],
            "weights": [
                0.0003652300949598115,
                0.0022505108336736,
                0.004048910688920471,
                0.005839068407239292,
                0.007618573995838158,
                0.00938431814845096,
                0.011133140166557929,
                0.01286189498346139,
                0.014567469652594648,
                0.016246791636685496,
                0.017896835172667824,
                0.019514627023993748,
                0.021097251960810023,
                0.02264185806811425,
                0.02414566191151572,
                0.025605953566749856,
                0.02702010151049122,
                0.028385557366703517,
                0.029699860501428556,
                0.030960642458510577,
                0.03216563122864219,
                0.03331265534428523,
                0.03439964779319427,
                0.03542464974358218,
                0.0363858140742467,
                0.03728140870333635,
                0.038109819709771016,
                0.03886955424170232,
                0.03955924320677665,
                0.04017764373937433,
                0.040723641440353946,
                0.041196252385308635,
                0.04159462489766997,
                0.04191804108349713,
                0.042165918125189786,
                0.04233780933176183,
                0.04243340494382716,
                0.042452532691798474,
                0.042395158106347496,
                0.04226138458051512,
                0.04205145318340246,
                0.04176574222574622,
                0.04140476657819337,
                0.04096917674345706,
                0.04045975768409478,
                0.039877427407949424,
                0.03922323531384624,
                0.03849836030052676,
                0.03770410864220823,
                0.03684191163461447,
                0.03591332301570905,
                0.03492001616580876,
                0.033863781092093266,
                0.032746521202970176,
                0.03157024987813042,
                0.030337086840472306,
                0.02904925433646121,
                0.027709073131880414,
                0.026318958330223106,
                0.02488141502143301,
                0.023399033769026013,
                0.021874485944202337,
                0.020310518916096823,
                0.018709951108529976,
                0.01707566693555662,
                0.015410611632666446,
                0.013717786011693444,
                0.012000241198503098,
                0.010261073510441357,
                0.008503419988295215,
                0.006730456690610809,
                0.004945411209520416,
                0.003151685421037791,
                0.0013549454140509148,
            ],
            "generator": "gauss_radau",
        },
        75: {
            "degree": 149,
            "points": [
                -0.9999999999999994,
                -0.998695219786114,
                -0.995628215268892,
                -0.990814146536618,
                -0.9842618324405339,
                -0.9759828339332342,
                -0.9659916940188842,
                -0.954305947542945,
                -0.9409460983508391,
                -0.9259355856816538,
                -0.9093007439003538,
                -0.8910707566505236,
                -0.8712776058175749,
                -0.8499560155016836,
                -0.8271433911423454,
                -0.8028797539202539,
                -0.7772076705604487,
                -0.7501721786642745,
                -0.7218207077034537,
                -0.6922029958161204,
                -0.6613710025515303,
                -0.6293788177169113,
                -0.5962825664866529,
                -0.5621403109404406,
                -0.5270119482032001,
                -0.4909591053655804,
                -0.45404503136939844,
                -0.41633448604772694,
                -0.37789362651431246,
                -0.33878989110163893,
                -0.2990918810512875,
                -0.2588692401641137,
                -0.21819253262142424,
                -0.17713311919146757,
                -0.13576303203843398,
                -0.09415484835359211,
                -0.05238156303025421,
                -0.010516460605944689,
                0.03136701330357117,
                0.07319538085284572,
                0.11489526087185997,
                0.15639349760153043,
                0.19761728903377596,
                0.2384943146309907,
                0.278952862200856,
                0.31892195370391907,
                0.3583314697732217,
                0.39711227272753447,
                0.4351963278623975,
                0.47251682280617513,
                0.5090082847317461,
                0.5446066952182047,
                0.5792496025610744,
                0.612876231334017,
                0.6454275890098531,
                0.6768465694538638,
                0.7070780531078615,
                0.7360690036893314,
                0.7637685612361012,
                0.7901281313334639,
                0.8151014703674722,
                0.8386447666552647,
                0.8607167173108322,
                0.8812786007126808,
                0.9002943444487126,
                0.9177305886239111,
                0.933556744429679,
                0.9477450478939932,
                0.9602706087706139,
                0.9711114546206879,
                0.9802485704276879,
                0.9876659351647211,
                0.9933505619663652,
                0.9972925856189642,
                0.999485967836904,
            ],
            "weights": [
                0.0003555555555558679,
                0.0021909232406117692,
                0.003941816049031885,
                0.005684872912351266,
                0.00741783028433675,
                0.009137742867108622,
                0.010841614076364721,
                0.01252646100105983,
                0.014189330170175613,
                0.01582730534245939,
                0.017437513428497264,
                0.019017129822817908,
                0.020563383478163846,
                0.022073561820106113,
                0.023545015531537237,
                0.024975163213689363,
                0.026361495921932626,
                0.027701581571378888,
                0.028993069205953823,
                0.030233693124236325,
                0.03142127685516398,
                0.03255373697690145,
                0.033629086772243647,
                0.0346454397142603,
                0.03560101277608312,
                0.036494129559058834,
                0.03732322323380929,
                0.03808683928905677,
                0.038783638083369154,
                0.039412397195379,
                0.03997201356835835,
                0.04046150544536297,
                0.040880014091600116,
                0.04122680530093927,
                0.041501270683968396,
                0.04170292873533236,
                0.04183142567845339,
                0.04188653608619019,
                0.041868163276308774,
                0.04177633948110756,
                0.041611225790870246,
                0.041373111871266105,
                0.041062415455179614,
                0.040679681609876714,
                0.04022558178076515,
                0.03970091261346686,
                0.0391065945562407,
                0.0384436702452078,
                0.03771330267522803,
                0.036916773159632314,
                0.036055479082386065,
                0.0351309314466322,
                0.03414475222392138,
                0.03309867150878032,
                0.031994524483619516,
                0.030834248199314858,
                0.02961987817712854,
                0.028353544837958267,
                0.027037469765220278,
                0.025673961808004783,
                0.02426541303145368,
                0.022814294521704758,
                0.02132315205316007,
                0.0197946016264832,
                0.018231324886723972,
                0.016636064432954376,
                0.015011619035161787,
                0.013360838785002434,
                0.011686620237274167,
                0.00999190169417463,
                0.008279659132741283,
                0.006552904826761499,
                0.004814699817911783,
                0.003068273704894124,
                0.0013190595025827933,
            ],
            "generator": "gauss_radau",
        },
        76: {
            "degree": 151,
            "points": [
                -1.0,
                -0.9987293229848041,
                -0.9957424241762878,
                -0.991053930461238,
                -0.9846722156233527,
                -0.9766082469550023,
                -0.9668758199452991,
                -0.9554915690899952,
                -0.9424749471850796,
                -0.9278481943944615,
                -0.9116363010832657,
                -0.8938669654651382,
                -0.8745705464373074,
                -0.8537800117908492,
                -0.8315308819270734,
                -0.8078611691946204,
                -0.7828113129595313,
                -0.7564241105235057,
                -0.7287446440106137,
                -0.6998202033486038,
                -0.66970020547709,
                -0.6384361099210605,
                -0.6060813308741997,
                -0.5726911459423812,
                -0.538322601703344,
                -0.5030344162439622,
                -0.46688687884167146,
                -0.4299417469614639,
                -0.3922621407444644,
                -0.35391243516834947,
                -0.3149581500638774,
                -0.2754658381754307,
                -0.23550297145682852,
                -0.19513782579667072,
                -0.15443936437016093,
                -0.1134771198167106,
                -0.07232107544460853,
                -0.03104154566573003,
                0.01029094413544529,
                0.05160577809326172,
                0.09283237050690873,
                0.1339002864349037,
                0.17473936203201434,
                0.21527982442301763,
                0.2554524109084977,
                0.29518848729902514,
                0.3344201651755405,
                0.3730804178756093,
                0.4111031950073871,
                0.4484235352956609,
                0.48497767756716104,
                0.5207031696855402,
                0.5555389752499145,
                0.5894255778746738,
                0.6223050828724255,
                0.6541213161663548,
                0.6848199202630532,
                0.7143484471218693,
                0.7426564477622004,
                0.7696955584557086,
                0.795419583356364,
                0.8197845734274021,
                0.8427489015307295,
                0.8642733335512547,
                0.8843210954358494,
                0.902857936034835,
                0.919852185643274,
                0.9352748101516928,
                0.9490994607350771,
                0.9613025190463913,
                0.971863137972875,
                0.9807632782928106,
                0.9879877426196966,
                0.9935242131163953,
                0.9973633355539675,
                0.9994994052710946,
            ],
            "weights": [
                0.0003462603878116197,
                0.0021336709506991304,
                0.003838912935798971,
                0.0055366996244456635,
                0.007224903968231307,
                0.008900734113195533,
                0.010561347115655987,
                0.012203911940157977,
                0.013825624554306871,
                0.015423715259442616,
                0.01699545420751812,
                0.01853815634907093,
                0.020049186136416677,
                0.021525962078301118,
                0.02296596117537187,
                0.024366723243545784,
                0.0257258551241605,
                0.027041034776585718,
                0.0283100152477137,
                0.02953062851225161,
                0.030700789177641952,
                0.03181849804748968,
                0.03288184553753006,
                0.033889014938374894,
                0.0348382855195029,
                0.035728035469218704,
                0.03655674466557771,
                0.03732299727355056,
                0.03802548416399749,
                0.03866300515032742,
                0.039234471039021536,
                0.039738905490521254,
                0.04017544668730458,
                0.040543348806291575,
                0.04084198329308702,
                0.04107083993585807,
                0.041229527737027795,
                0.04131777558130056,
                0.0413354326988484,
                0.041282468922917,
                0.041158974741357976,
                0.040965161142043155,
                0.0407013592523923,
                0.04036801977365918,
                0.039965712210912926,
                0.03949512390005627,
                0.03895705883353519,
                0.03835243628673392,
                0.037682289247414034,
                0.036947762650896665,
                0.036150111423969906,
                0.03529069834088692,
                0.03437099169512956,
                0.0333925627908818,
                0.0323570832585491,
                0.03126632219887658,
                0.030122143160592717,
                0.028926500956718778,
                0.027681438325050777,
                0.026389082438523764,
                0.02505164127153344,
                0.023671399828501295,
                0.02225071624138982,
                0.0207920177432019,
                0.019297796525134626,
                0.017770605485994337,
                0.0162130538843923,
                0.014627802908469049,
                0.013017561188456761,
                0.011385080306806903,
                0.00973315045338986,
                0.008064596712363805,
                0.006382277977745287,
                0.004689099360144822,
                0.002988129108978179,
                0.0012845805392451108,
            ],
            "generator": "gauss_radau",
        },
        77: {
            "degree": 153,
            "points": [
                -1.0,
                -0.9987621065000718,
                -0.9958522164510446,
                -0.9912844510974843,
                -0.9850667672153434,
                -0.97720957610491,
                -0.9677259731448102,
                -0.9566317494872797,
                -0.9439453732893501,
                -0.929687961217335,
                -0.9138832441089746,
                -0.8965575278098398,
                -0.8777396495427716,
                -0.8574609299870778,
                -0.8357551211885841,
                -0.8126583504051903,
                -0.7882090599897916,
                -0.7624479434147985,
                -0.7354178775469152,
                -0.7071638512860996,
                -0.6777328906881569,
                -0.6471739806959904,
                -0.6155379836100291,
                -0.5828775544336746,
                -0.5492470532347684,
                -0.5147024546690058,
                -0.47930125481592956,
                -0.44310237548258957,
                -0.40616606613417117,
                -0.3685538036148309,
                -0.3303281898256474,
                -0.2915528475300124,
                -0.2522923144598743,
                -0.21261193589909888,
                -0.17257775592272862,
                -0.13225640747316525,
                -0.0917150014562329,
                -0.051021015041715634,
                -0.01024217935427929,
                0.0305536332582923,
                0.07129852219192001,
                0.11192467160007769,
                0.15236446326658326,
                0.19255058914944767,
                0.23241616340847693,
                0.271894833730167,
                0.3109208917645965,
                0.34942938249051236,
                0.38735621232658635,
                0.4246382558088895,
                0.46121346065704927,
                0.49702095105420807,
                0.5320011289688984,
                0.5660957733501912,
                0.5992481370310332,
                0.6314030411784899,
                0.6625069671337322,
                0.692508145488901,
                0.7213566422526569,
                0.7490044419610526,
                0.775405527595491,
                0.8005159571748972,
                0.8242939368948796,
                0.8466998906925316,
                0.8676965261217997,
                0.8872488964310141,
                0.9053244587415821,
                0.9218931282355529,
                0.9369273282712642,
                0.9504020363644463,
                0.962294826008085,
                0.9725859043933958,
                0.9812581463659169,
                0.9882971259723281,
                0.9936911519170994,
                0.9974313484081967,
                0.9995123226131029,
            ],
            "weights": [
                0.0003373250126496727,
                0.0020786335248353617,
                0.003739985534832458,
                0.005394239279263645,
                0.007039395036226376,
                0.008672804634043208,
                0.010291769085916978,
                0.011893599721636578,
                0.013475632655664137,
                0.015035235695293787,
                0.016569813486272702,
                0.018076812109233634,
                0.019553723443274308,
                0.02099808939099436,
                0.022407505994144584,
                0.023779627447311394,
                0.02511217000905955,
                0.026402915806840743,
                0.02764971653067828,
                0.02885049701019541,
                0.0300032586693903,
                0.03110608285362626,
                0.03215713402340664,
                0.033154662809693466,
                0.034097008925732954,
                0.03498260393054983,
                0.035809973839549904,
                0.03657774157788231,
                0.03728462927248763,
                0.0379294603790225,
                0.03851116164012926,
                0.03902876487178079,
                0.03948140857474209,
                0.03986833936846772,
                0.04018891324503301,
                0.04044259664102319,
                0.040628967325615065,
                0.04074771510333272,
                0.040798642330347294,
                0.040781664243437155,
                0.040696809101069036,
                0.0405442181363734,
                0.04032414532207016,
                0.04003695694777069,
                0.039683131010317965,
                0.039263256418222474,
                0.03877803201147865,
                0.03822826539842001,
                0.037614871611554725,
                0.036938871584580334,
                0.036201390453161675,
                0.03540365568226562,
                0.03454699502318781,
                0.0336328343036769,
                0.032662695054819,
                0.031638191978657415,
                0.03056103026075147,
                0.029433002732185264,
                0.028255986885720216,
                0.027031941751133357,
                0.02576290463495504,
                0.02445098773010425,
                0.023098374601196597,
                0.02170731655156716,
                0.02028012887849245,
                0.01881918702351858,
                0.017326922625877414,
                0.015805819488688443,
                0.014258409471786363,
                0.012687268335322776,
                0.011095011586879162,
                0.009484290475222564,
                0.007857788604184547,
                0.006218221111549358,
                0.004568346994482734,
                0.002911083256112791,
                0.0012514359290267216,
            ],
            "generator": "gauss_radau",
        },
        78: {
            "degree": 155,
            "points": [
                -0.9999999999999994,
                -0.9987936375494224,
                -0.9959578168723882,
                -0.9915061792945119,
                -0.9854462905391994,
                -0.977788040750317,
                -0.9685438690401982,
                -0.957728775950554,
                -0.9453603064438159,
                -0.9314585236307895,
                -0.9160459770163034,
                -0.899147666249325,
                -0.8807910007224489,
                -0.8610057551877246,
                -0.8398240215010977,
                -0.8172801565912313,
                -0.7934107267452764,
                -0.7682544483060396,
                -0.7418521248788501,
                -0.7142465811511474,
                -0.6854825934328086,
                -0.6556068170302487,
                -0.6246677105723442,
                -0.5927154574110738,
                -0.5598018842244403,
                -0.5259803769537919,
                -0.49130579421189635,
                -0.4558343783022796,
                -0.419623