import pyvista as pv
from matplotlib.path import Path


def find_min_max_z(mesh): #Finds min and max point in the z-direction
      min_value = 0
      max_value = 0
      for point in mesh.points:
            z_value = point[2]
            if z_value < min_value:
               min_value = z_value
            elif z_value > max_value:
               max_value = z_value
      return min_value, max_value
        

def find_in_list_of_tuples(to_find,tuples_list):
    for i in range(len(tuples_list)):
        if tuples_list[i][0] == to_find:
            return i
    return None


def sort_dominoes(dominoes):
    all_paths = []

    sorted_list = [dominoes[0][0],dominoes[0][1]]
    dominoes.pop(0)

    while len(dominoes) > 0:
        result = find_in_list_of_tuples(sorted_list[-1],dominoes)
        if result == None:
            all_paths.append(sorted_list)
            sorted_list = [dominoes[0][0],dominoes[0][1]]
            dominoes.pop(0)
        else:
            sorted_list.append(dominoes[result][1])
            dominoes.pop(result)
    all_paths.append(sorted_list)
    return all_paths


def py_to_mpl_path(pv_path):
    pv_lines = []
    for i in range(1,len(pv_path.lines),3):
        pv_lines.append((pv_path.lines[i],pv_path.lines[i+1]))
    line_points = sort_dominoes(pv_lines)
    
    all_points = pv_path.points

    mpl_paths = []
    for path_points in line_points:
        codes = [Path.MOVETO]
        path_lines = []
        for point in path_points:
            path_lines.append((all_points[point][0],all_points[point][1]))
            codes.append(Path.LINETO)
        codes.pop(1)
        codes[-1] = (Path.CLOSEPOLY)
        mpl_paths.append(Path(path_lines, codes))

    return mpl_paths


def slice_stl(path, layer_height):
    mesh = pv.read(path)
    min_z, max_z = find_min_max_z(mesh)
    
    slices = []
    z_pos = min_z+layer_height/2
    while z_pos < max_z:
        single_slice = mesh.slice(normal=[0, 0, 1],origin=(0,0,z_pos))
        mpl_path = py_to_mpl_path(single_slice)
        slices.append(mpl_path)
        z_pos = z_pos + layer_height
    return slices


