"""v1

Revision ID: 916c510752d0
Revises: 
Create Date: 2021-06-15 00:35:37.822695

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '916c510752d0'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('users',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=False),
    sa.Column('password', sa.String(), nullable=False),
    sa.Column('admin', sa.Boolean(), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('email', sa.String(length=100), nullable=True),
    sa.Column('created_ts', sa.Integer(), nullable=False),
    sa.Column('last_modified_ts', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('notebooks',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('user_id', sa.String(length=36), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('created_ts', sa.Integer(), nullable=False),
    sa.Column('last_modified_ts', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('user_id', 'name', name='un_notebooks_uid_name')
    )
    op.create_table('notes',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('notebook_id', sa.String(length=36), nullable=False),
    sa.Column('active', sa.Boolean(), nullable=False),
    sa.Column('title', sa.String(length=100), nullable=True),
    sa.Column('body', sa.String(length=1000), nullable=True),
    sa.Column('created_ts', sa.Integer(), nullable=False),
    sa.Column('last_modified_ts', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['notebook_id'], ['notebooks.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tags',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('notebook_id', sa.String(length=36), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('color', sa.String(length=7), nullable=True),
    sa.Column('created_ts', sa.Integer(), nullable=False),
    sa.Column('last_modified_ts', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['notebook_id'], ['notebooks.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('notebook_id', 'name', name='un_tags_nid_name')
    )
    op.create_table('note_tags',
    sa.Column('id', sa.String(length=36), nullable=False),
    sa.Column('note_id', sa.String(length=36), nullable=False),
    sa.Column('tag_id', sa.String(length=36), nullable=False),
    sa.ForeignKeyConstraint(['note_id'], ['notes.id'], ),
    sa.ForeignKeyConstraint(['tag_id'], ['tags.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('note_id', 'tag_id', name='un_note_id_tag_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('note_tags')
    op.drop_table('tags')
    op.drop_table('notes')
    op.drop_table('notebooks')
    op.drop_table('users')
    # ### end Alembic commands ###
