import datetime

class Clock:
    def __init__(self, data):
 
        self.id = data['id']
        self.type = data.get('type', 'private')
        self.user = data.get('user')
        self.content = data.get('content', '')
        
        self.ones = int(data.get('ones', 1))
        self.month = int(data.get('month', 0))
        self.day = int(data.get('day', 0))
        self.week = str(data.get('week', ''))
        
        self.time = data.get('time', 1)
        self.get_time()

    @classmethod
    def init_from_db(cls, *args):
        args = args[0]
        data = {}
        data['id'] = args[0]
        data['type'] = args[1]
        data['user'] = args[2]
        data['content'] = args[3]
        data['month'] = args[4]
        data['day'] = args[5]
        data['week'] = args[6]
        data['time'] = args[7]
        data['ones'] = args[8]
        return cls(data)
    

    def get_info(self):
        ones=['重复', '不重复']
        time_ = ' '.join([i for i in self.time.split() if i !='null'])

        if self.month and self.day:
            tag = f"{self.month}.{self.day}"
        else:
            tag = f'每周{self.week}' if self.week else ones[(self.ones)]
      
        return f'[{self.id}] ⏰{time_} ({tag})\n备注: {self.content}'


    def get_time(self):
        time = self.time.split()[-1].split(':')
        self.hour = int(time[0])
        self.minute = int(time[1])


    def verify_today(self):

        if self.week and str(datetime.date.today().weekday()+1) not in self.week:
            return False

        if self.month > 0 and self.month != datetime.date.today().month:
            return False

        if self.day > 0 and self.day != datetime.date.today().day:
            return False

        return True
