import numpy as np
from typing import Tuple
from .shape_function import ShapeFunction


class Tri10(ShapeFunction):
    """
    Tri10 (10-node triangular element) class inheriting class: ShapeFunction
    """

    def __init__(self) -> None:

        super().__init__()

        self._shape = "TRI"
        self._name = "Tri10"
        self._n_dof = 2
        self._n_node = 10
        self._n_intgp = 7
        self._n_face = 3
        self._n_fnode = 4
        self._weight = np.array(
            [
                0.0629695903,
                0.0629695903,
                0.0629695903,
                0.0661970764,
                0.0661970764,
                0.0661970764,
                0.1125,
            ]
        )
        self._Shpfnc = np.array(
            [
                [
                    0.059797125229094,
                    0.217763476026479,
                    0.059797125229094,
                    -0.056881673338108,
                    -0.056881673338108,
                    0.044627194353795,
                    0.0,
                ],
                [
                    0.059797125229094,
                    0.059797125229094,
                    0.217763476026479,
                    0.044627194353795,
                    -0.056881673338108,
                    -0.056881673338108,
                    0.0,
                ],
                [
                    0.217763476267246,
                    0.059797125251786,
                    0.059797125251786,
                    -0.056881673362841,
                    0.044627194404864,
                    -0.056881673362841,
                    -0.0,
                ],
                [
                    -0.032137537163421,
                    0.506036589725931,
                    -0.253018294917484,
                    0.051852114128879,
                    0.408230831611552,
                    -0.103704228295658,
                    -0.0,
                ],
                [
                    -0.032137537163421,
                    -0.253018294917484,
                    0.506036589725931,
                    -0.103704228295658,
                    0.408230831611552,
                    0.051852114128879,
                    -0.0,
                ],
                [
                    -0.253018294949214,
                    -0.03213753719515,
                    0.50603659022554,
                    -0.103704228317716,
                    0.05185211421571,
                    0.408230831698384,
                    -0.0,
                ],
                [
                    0.506036589898427,
                    -0.0321375371813,
                    -0.253018295058251,
                    0.051852114177809,
                    -0.10370422843142,
                    0.408230831996779,
                    0.0,
                ],
                [
                    0.506036589898427,
                    -0.253018295058251,
                    -0.0321375371813,
                    0.408230831996779,
                    -0.10370422843142,
                    0.051852114177809,
                    0.0,
                ],
                [
                    -0.253018294949214,
                    0.50603659022554,
                    -0.03213753719515,
                    0.408230831698384,
                    0.05185211421571,
                    -0.103704228317716,
                    -0.0,
                ],
                [
                    0.22088075770298,
                    0.220880757893356,
                    0.220880757893356,
                    0.356378716958679,
                    0.356378717479667,
                    0.356378716958679,
                    1.0,
                ],
            ]
        )
        self._Bmatrix_nat = np.array(
            [
                [
                    [
                        0.226917347873945,
                        2.407669390242727,
                        0.226917347873945,
                        -0.247325511011185,
                        -0.247325511011185,
                        0.510697956694027,
                        -0.5,
                    ],
                    [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                    [
                        -2.40766939149578,
                        -0.226917347247418,
                        -0.226917347247418,
                        0.247325510641801,
                        -0.510697955955259,
                        0.247325510641801,
                        0.5,
                    ],
                    [
                        -0.17879745570211,
                        1.724962759680747,
                        -1.407669391319253,
                        0.489302043225357,
                        3.852266843327629,
                        -1.357615822574643,
                        1.5,
                    ],
                    [
                        -0.317293369276055,
                        -0.317293369276055,
                        4.996090824092727,
                        -0.220580620655973,
                        0.868313777438815,
                        0.868313777438815,
                        -0.0,
                    ],
                    [
                        0.317293369276055,
                        0.317293369276055,
                        -4.996090824092727,
                        0.220580620655973,
                        -0.868313777438815,
                        -0.868313777438815,
                        0.0,
                    ],
                    [
                        -1.724962759954221,
                        0.178797455428637,
                        1.4076693891662,
                        -0.48930204338659,
                        1.35761582130526,
                        -3.852266844597013,
                        -1.5,
                    ],
                    [
                        3.27112806584156,
                        1.090376019713619,
                        -0.138495914023945,
                        -2.983953066338815,
                        1.137035200360519,
                        0.379011734871609,
                        -1.5,
                    ],
                    [
                        -1.090376022219724,
                        -3.271128062708927,
                        0.138495913397418,
                        2.983953066708199,
                        -0.379011733394074,
                        -1.137035202207437,
                        1.5,
                    ],
                    [
                        1.903760215656331,
                        -1.903760215109384,
                        0.0,
                        0.0,
                        -5.209882664632889,
                        5.209882667171656,
                        0.0,
                    ],
                ],
                [
                    [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
                    [
                        0.226917347873945,
                        0.226917347873945,
                        2.407669390242727,
                        0.510697956694027,
                        -0.247325511011185,
                        -0.247325511011185,
                        -0.5,
                    ],
                    [
                        -2.40766939149578,
                        -0.226917347247418,
                        -0.226917347247418,
                        0.247325510641801,
                        -0.510697955955259,
                        0.247325510641801,
                        0.5,
                    ],
                    [
                        -0.317293369276055,
                        4.996090824092727,
                        -0.317293369276055,
                        0.868313777438815,
                        0.868313777438815,
                        -0.220580620655973,
                        -0.0,
                    ],
                    [
                        -0.17879745570211,
                        -1.407669391319253,
                        1.724962759680747,
                        -1.357615822574643,
                        3.852266843327629,
                        0.489302043225357,
                        1.5,
                    ],
                    [
                        -1.090376022219724,
                        0.138495913397418,
                        -3.271128062708927,
                        -1.137035202207437,
                        -0.379011733394074,
                        2.983953066708199,
                        1.5,
                    ],
                    [
                        3.27112806584156,
                        -0.138495914023945,
                        1.090376019713619,
                        0.379011734871609,
                        1.137035200360519,
                        -2.983953066338815,
                        -1.5,
                    ],
                    [
                        -1.724962759954221,
                        1.4076693891662,
                        0.178797455428637,
                        -3.852266844597013,
                        1.35761582130526,
                        -0.48930204338659,
                        -1.5,
                    ],
                    [
                        0.317293369276055,
                        -4.996090824092727,
                        0.317293369276055,
                        -0.868313777438815,
                        -0.868313777438815,
                        0.220580620655973,
                        0.0,
                    ],
                    [
                        1.903760215656331,
                        0.0,
                        -1.903760215109384,
                        5.209882667171656,
                        -5.209882664632889,
                        0.0,
                        0.0,
                    ],
                ],
            ]
        )
        self._idx_face = np.array([[1, 2, 5, 6], [2, 0, 7, 8], [0, 1, 3, 4]])
