import numpy as np
from typing import Tuple
from .shape_function import ShapeFunction


class Quad9(ShapeFunction):
    """
    Quad9 (9-node quadrilateral element) class inheriting class: ShapeFunction
    """

    def __init__(self) -> None:

        super().__init__()

        self._shape = "QUAD"
        self._name = "QUAD9"
        self._n_dof = 2
        self._n_node = 9
        self._n_intgp = 9
        self._n_face = 4
        self._n_fnode = 3
        self._weight = np.array(
            [
                0.308641975308643,
                0.493827160493828,
                0.308641975308643,
                0.493827160493828,
                0.790123456790124,
                0.493827160493828,
                0.308641975308643,
                0.493827160493828,
                0.308641975308643,
            ]
        )
        self._Shpfnc = np.array(
            [
                [
                    0.472379000772444,
                    -0.0,
                    -0.06,
                    -0.0,
                    0.0,
                    0.0,
                    -0.06,
                    0.0,
                    0.007620999227555,
                ],
                [
                    -0.06,
                    0.0,
                    0.472379000772444,
                    0.0,
                    -0.0,
                    -0.0,
                    0.007620999227555,
                    -0.0,
                    -0.06,
                ],
                [
                    0.007620999227555,
                    -0.0,
                    -0.06,
                    -0.0,
                    0.0,
                    0.0,
                    -0.06,
                    0.0,
                    0.472379000772444,
                ],
                [
                    -0.06,
                    0.0,
                    0.007620999227555,
                    0.0,
                    -0.0,
                    -0.0,
                    0.472379000772444,
                    -0.0,
                    -0.06,
                ],
                [
                    0.274919333848297,
                    0.687298334620741,
                    0.274919333848297,
                    -0.0,
                    -0.0,
                    -0.0,
                    -0.034919333848297,
                    -0.087298334620742,
                    -0.034919333848297,
                ],
                [
                    -0.034919333848297,
                    0.0,
                    0.274919333848297,
                    -0.087298334620742,
                    0.0,
                    0.687298334620741,
                    -0.034919333848297,
                    0.0,
                    0.274919333848297,
                ],
                [
                    -0.034919333848297,
                    -0.087298334620742,
                    -0.034919333848297,
                    0.0,
                    0.0,
                    0.0,
                    0.274919333848297,
                    0.687298334620741,
                    0.274919333848297,
                ],
                [
                    0.274919333848297,
                    -0.0,
                    -0.034919333848297,
                    0.687298334620741,
                    -0.0,
                    -0.087298334620742,
                    0.274919333848297,
                    -0.0,
                    -0.034919333848297,
                ],
                [
                    0.16,
                    0.4,
                    0.16,
                    0.4,
                    1.0,
                    0.4,
                    0.16,
                    0.4,
                    0.16,
                ],
            ]
        )
        self._Bmatrix_nat = np.array(
            [
                [
                    [
                        -0.876028168082815,
                        -0.343649167310371,
                        0.188729833462074,
                        0.0,
                        0.0,
                        -0.0,
                        0.111270166537926,
                        0.043649167310371,
                        -0.023971831917184,
                    ],
                    [
                        -0.188729833462074,
                        0.343649167310371,
                        0.876028168082815,
                        0.0,
                        -0.0,
                        -0.0,
                        0.023971831917184,
                        -0.043649167310371,
                        -0.111270166537926,
                    ],
                    [
                        0.023971831917184,
                        -0.043649167310371,
                        -0.111270166537926,
                        -0.0,
                        0.0,
                        0.0,
                        -0.188729833462074,
                        0.343649167310371,
                        0.876028168082815,
                    ],
                    [
                        0.111270166537926,
                        0.043649167310371,
                        -0.023971831917184,
                        -0.0,
                        -0.0,
                        0.0,
                        -0.876028168082815,
                        -0.343649167310371,
                        0.188729833462074,
                    ],
                    [
                        1.064758001544889,
                        -0.0,
                        -1.064758001544889,
                        -0.0,
                        0.0,
                        0.0,
                        -0.13524199845511,
                        0.0,
                        0.13524199845511,
                    ],
                    [
                        -0.109838667696593,
                        0.2,
                        0.509838667696594,
                        -0.274596669241483,
                        0.5,
                        1.274596669241483,
                        -0.109838667696593,
                        0.2,
                        0.509838667696594,
                    ],
                    [
                        -0.13524199845511,
                        0.0,
                        0.13524199845511,
                        0.0,
                        -0.0,
                        -0.0,
                        1.064758001544889,
                        -0.0,
                        -1.064758001544889,
                    ],
                    [
                        -0.509838667696594,
                        -0.2,
                        0.109838667696593,
                        -1.274596669241483,
                        -0.5,
                        0.274596669241483,
                        -0.509838667696594,
                        -0.2,
                        0.109838667696593,
                    ],
                    [
                        0.619677335393187,
                        -0.0,
                        -0.619677335393187,
                        1.549193338482966,
                        -0.0,
                        -1.549193338482966,
                        0.619677335393187,
                        -0.0,
                        -0.619677335393187,
                    ],
                ],
                [
                    [
                        -0.876028168082815,
                        0.0,
                        0.111270166537926,
                        -0.343649167310371,
                        0.0,
                        0.043649167310371,
                        0.188729833462074,
                        -0.0,
                        -0.023971831917184,
                    ],
                    [
                        0.111270166537926,
                        -0.0,
                        -0.876028168082815,
                        0.043649167310371,
                        -0.0,
                        -0.343649167310371,
                        -0.023971831917184,
                        0.0,
                        0.188729833462074,
                    ],
                    [
                        0.023971831917184,
                        -0.0,
                        -0.188729833462074,
                        -0.043649167310371,
                        0.0,
                        0.343649167310371,
                        -0.111270166537926,
                        0.0,
                        0.876028168082815,
                    ],
                    [
                        -0.188729833462074,
                        0.0,
                        0.023971831917184,
                        0.343649167310371,
                        -0.0,
                        -0.043649167310371,
                        0.876028168082815,
                        -0.0,
                        -0.111270166537926,
                    ],
                    [
                        -0.509838667696594,
                        -1.274596669241483,
                        -0.509838667696594,
                        -0.2,
                        -0.5,
                        -0.2,
                        0.109838667696593,
                        0.274596669241483,
                        0.109838667696593,
                    ],
                    [
                        -0.13524199845511,
                        0.0,
                        1.064758001544889,
                        0.0,
                        -0.0,
                        -0.0,
                        0.13524199845511,
                        -0.0,
                        -1.064758001544889,
                    ],
                    [
                        -0.109838667696593,
                        -0.274596669241483,
                        -0.109838667696593,
                        0.2,
                        0.5,
                        0.2,
                        0.509838667696594,
                        1.274596669241483,
                        0.509838667696594,
                    ],
                    [
                        1.064758001544889,
                        -0.0,
                        -0.13524199845511,
                        -0.0,
                        0.0,
                        0.0,
                        -1.064758001544889,
                        0.0,
                        0.13524199845511,
                    ],
                    [
                        0.619677335393187,
                        1.549193338482966,
                        0.619677335393187,
                        -0.0,
                        -0.0,
                        -0.0,
                        -0.619677335393187,
                        -1.549193338482966,
                        -0.619677335393187,
                    ],
                ],
            ]
        )
        self._idx_face = np.array([[0, 1, 4], [1, 2, 5], [2, 3, 6], [3, 0, 7]])
