import numpy as np
from typing import Tuple
from .shape_function import ShapeFunction


class Quad8(ShapeFunction):
    """
    Quad8 (8-node quadrilateral element) class inheriting class: ShapeFunction
    """

    def __init__(self) -> None:

        super().__init__()

        self._shape = "QUAD"
        self._name = "QUAD8"
        self._n_dof = 2
        self._n_node = 8
        self._n_intgp = 9
        self._n_face = 4
        self._n_fnode = 3
        self._weight = np.array(
            [
                0.308641975308643,
                0.493827160493828,
                0.308641975308643,
                0.493827160493828,
                0.790123456790124,
                0.493827160493828,
                0.308641975308643,
                0.493827160493828,
                0.308641975308643,
            ]
        )
        self._Shpfnc = np.array(
            [
                [
                    0.432379000772444,
                    -0.1,
                    -0.1,
                    -0.1,
                    -0.25,
                    -0.1,
                    -0.1,
                    -0.1,
                    -0.032379000772445,
                ],
                [
                    -0.1,
                    -0.1,
                    0.432379000772444,
                    -0.1,
                    -0.25,
                    -0.1,
                    -0.032379000772445,
                    -0.1,
                    -0.1,
                ],
                [
                    -0.032379000772445,
                    -0.1,
                    -0.1,
                    -0.1,
                    -0.25,
                    -0.1,
                    -0.1,
                    -0.1,
                    0.432379000772444,
                ],
                [
                    -0.1,
                    -0.1,
                    -0.032379000772445,
                    -0.1,
                    -0.25,
                    -0.1,
                    0.432379000772444,
                    -0.1,
                    -0.1,
                ],
                [
                    0.354919333848297,
                    0.887298334620741,
                    0.354919333848297,
                    0.2,
                    0.5,
                    0.2,
                    0.045080666151703,
                    0.112701665379259,
                    0.045080666151703,
                ],
                [
                    0.045080666151703,
                    0.2,
                    0.354919333848297,
                    0.112701665379259,
                    0.5,
                    0.887298334620741,
                    0.045080666151703,
                    0.2,
                    0.354919333848297,
                ],
                [
                    0.045080666151703,
                    0.112701665379259,
                    0.045080666151703,
                    0.2,
                    0.5,
                    0.2,
                    0.354919333848297,
                    0.887298334620741,
                    0.354919333848297,
                ],
                [
                    0.354919333848297,
                    0.2,
                    0.045080666151703,
                    0.887298334620741,
                    0.5,
                    0.112701665379259,
                    0.354919333848297,
                    0.2,
                    0.045080666151703,
                ],
            ]
        )
        self._Bmatrix_nat = np.array(
            [
                [
                    [
                        -1.030947501931112,
                        -0.343649167310371,
                        0.343649167310371,
                        -0.387298334620741,
                        0.0,
                        0.387298334620741,
                        -0.043649167310371,
                        0.043649167310371,
                        0.130947501931113,
                    ],
                    [
                        -0.343649167310371,
                        0.343649167310371,
                        1.030947501931112,
                        -0.387298334620741,
                        0.0,
                        0.387298334620741,
                        -0.130947501931113,
                        -0.043649167310371,
                        0.043649167310371,
                    ],
                    [
                        -0.130947501931113,
                        -0.043649167310371,
                        0.043649167310371,
                        -0.387298334620741,
                        0.0,
                        0.387298334620741,
                        -0.343649167310371,
                        0.343649167310371,
                        1.030947501931112,
                    ],
                    [
                        -0.043649167310371,
                        0.043649167310371,
                        0.130947501931113,
                        -0.387298334620741,
                        0.0,
                        0.387298334620741,
                        -1.030947501931112,
                        -0.343649167310371,
                        0.343649167310371,
                    ],
                    [
                        1.374596669241482,
                        -0.0,
                        -1.374596669241482,
                        0.774596669241483,
                        -0.0,
                        -0.774596669241483,
                        0.174596669241484,
                        -0.0,
                        -0.174596669241484,
                    ],
                    [0.2, 0.2, 0.2, 0.5, 0.5, 0.5, 0.2, 0.2, 0.2],
                    [
                        0.174596669241484,
                        -0.0,
                        -0.174596669241484,
                        0.774596669241483,
                        -0.0,
                        -0.774596669241483,
                        1.374596669241482,
                        -0.0,
                        -1.374596669241482,
                    ],
                    [-0.2, -0.2, -0.2, -0.5, -0.5, -0.5, -0.2, -0.2, -0.2],
                ],
                [
                    [
                        -1.030947501931112,
                        -0.387298334620741,
                        -0.043649167310371,
                        -0.343649167310371,
                        0.0,
                        0.043649167310371,
                        0.343649167310371,
                        0.387298334620741,
                        0.130947501931113,
                    ],
                    [
                        -0.043649167310371,
                        -0.387298334620741,
                        -1.030947501931112,
                        0.043649167310371,
                        0.0,
                        -0.343649167310371,
                        0.130947501931113,
                        0.387298334620741,
                        0.343649167310371,
                    ],
                    [
                        -0.130947501931113,
                        -0.387298334620741,
                        -0.343649167310371,
                        -0.043649167310371,
                        0.0,
                        0.343649167310371,
                        0.043649167310371,
                        0.387298334620741,
                        1.030947501931112,
                    ],
                    [
                        -0.343649167310371,
                        -0.387298334620741,
                        -0.130947501931113,
                        0.343649167310371,
                        0.0,
                        -0.043649167310371,
                        1.030947501931112,
                        0.387298334620741,
                        0.043649167310371,
                    ],
                    [-0.2, -0.5, -0.2, -0.2, -0.5, -0.2, -0.2, -0.5, -0.2],
                    [
                        0.174596669241484,
                        0.774596669241483,
                        1.374596669241482,
                        -0.0,
                        -0.0,
                        -0.0,
                        -0.174596669241484,
                        -0.774596669241483,
                        -1.374596669241482,
                    ],
                    [0.2, 0.5, 0.2, 0.2, 0.5, 0.2, 0.2, 0.5, 0.2],
                    [
                        1.374596669241482,
                        0.774596669241483,
                        0.174596669241484,
                        -0.0,
                        -0.0,
                        -0.0,
                        -1.374596669241482,
                        -0.774596669241483,
                        -0.174596669241484,
                    ],
                ],
            ]
        )
        self._idx_face = np.array([[0, 1, 4], [1, 2, 5], [2, 3, 6], [3, 0, 7]])
