import numpy as np
from typing import Tuple
from .shape_function import ShapeFunction


class Quad12(ShapeFunction):
    """
    Quad12 (12-node quadrilateral element) class inheriting class: ShapeFunction
    """

    def __init__(self) -> None:

        super().__init__()

        self._shape = "QUAD"
        self._name = "QUAD12"
        self._n_dof = 2
        self._n_node = 12
        self._n_intgp = 16
        self._n_face = 4
        self._n_fnode = 4
        self._weight = np.array(
            [
                0.121002993285602,
                0.226851851851852,
                0.226851851851852,
                0.121002993285602,
                0.226851851851852,
                0.425293303010694,
                0.425293303010694,
                0.226851851851852,
                0.226851851851852,
                0.425293303010694,
                0.425293303010694,
                0.226851851851852,
                0.121002993285602,
                0.226851851851852,
                0.226851851851852,
                0.121002993285602,
            ]
        )
        self._Shpfnc = np.array(
            [
                [
                    0.3624034165413,
                    -0.17813481264739,
                    -0.087741803294617,
                    0.027039757807282,
                    -0.17813481264739,
                    -0.444366556425723,
                    -0.21887649250116,
                    -0.013291050721874,
                    -0.087741803294617,
                    -0.21887649250116,
                    -0.107809461078599,
                    -0.006546619050404,
                    0.027039757807282,
                    -0.013291050721874,
                    -0.006546619050404,
                    0.002017498922208,
                ],
                [
                    0.027039757807282,
                    -0.087741803294617,
                    -0.17813481264739,
                    0.3624034165413,
                    -0.013291050721874,
                    -0.21887649250116,
                    -0.444366556425723,
                    -0.17813481264739,
                    -0.006546619050404,
                    -0.107809461078599,
                    -0.21887649250116,
                    -0.087741803294617,
                    0.002017498922208,
                    -0.006546619050404,
                    -0.013291050721874,
                    0.027039757807282,
                ],
                [
                    0.002017498922208,
                    -0.006546619050404,
                    -0.013291050721874,
                    0.027039757807282,
                    -0.006546619050404,
                    -0.107809461078599,
                    -0.21887649250116,
                    -0.087741803294617,
                    -0.013291050721874,
                    -0.21887649250116,
                    -0.444366556425723,
                    -0.17813481264739,
                    0.027039757807282,
                    -0.087741803294617,
                    -0.17813481264739,
                    0.3624034165413,
                ],
                [
                    0.027039757807282,
                    -0.013291050721874,
                    -0.006546619050404,
                    0.002017498922208,
                    -0.087741803294617,
                    -0.21887649250116,
                    -0.107809461078599,
                    -0.006546619050404,
                    -0.17813481264739,
                    -0.444366556425723,
                    -0.21887649250116,
                    -0.013291050721874,
                    0.3624034165413,
                    -0.17813481264739,
                    -0.087741803294617,
                    0.027039757807282,
                ],
                [
                    0.484768023339046,
                    0.935114776711619,
                    -0.009232495696808,
                    -0.214205532614824,
                    0.349023313211304,
                    0.673263998216464,
                    -0.006647212856809,
                    -0.154223713409267,
                    0.171914374500398,
                    0.331621856609181,
                    -0.003274140715516,
                    -0.075964189841471,
                    0.036169664372656,
                    0.069771078114026,
                    -0.000688857875516,
                    -0.015982370635914,
                ],
                [
                    -0.214205532614824,
                    -0.009232495696808,
                    0.935114776711619,
                    0.484768023339046,
                    -0.154223713409267,
                    -0.006647212856809,
                    0.673263998216464,
                    0.349023313211304,
                    -0.075964189841471,
                    -0.003274140715516,
                    0.331621856609181,
                    0.171914374500398,
                    -0.015982370635914,
                    -0.000688857875516,
                    0.069771078114026,
                    0.036169664372656,
                ],
                [
                    0.036169664372656,
                    0.171914374500398,
                    0.349023313211304,
                    0.484768023339046,
                    0.069771078114026,
                    0.331621856609181,
                    0.673263998216464,
                    0.935114776711619,
                    -0.000688857875516,
                    -0.003274140715516,
                    -0.006647212856809,
                    -0.009232495696808,
                    -0.015982370635914,
                    -0.075964189841471,
                    -0.154223713409267,
                    -0.214205532614824,
                ],
                [
                    -0.015982370635914,
                    -0.075964189841471,
                    -0.154223713409267,
                    -0.214205532614824,
                    -0.000688857875516,
                    -0.003274140715516,
                    -0.006647212856809,
                    -0.009232495696808,
                    0.069771078114026,
                    0.331621856609181,
                    0.673263998216464,
                    0.935114776711619,
                    0.036169664372656,
                    0.171914374500398,
                    0.349023313211304,
                    0.484768023339046,
                ],
                [
                    -0.015982370635914,
                    -0.000688857875516,
                    0.069771078114026,
                    0.036169664372656,
                    -0.075964189841471,
                    -0.003274140715516,
                    0.331621856609181,
                    0.171914374500398,
                    -0.154223713409267,
                    -0.006647212856809,
                    0.673263998216464,
                    0.349023313211304,
                    -0.214205532614824,
                    -0.009232495696808,
                    0.935114776711619,
                    0.484768023339046,
                ],
                [
                    0.036169664372656,
                    0.069771078114026,
                    -0.000688857875516,
                    -0.015982370635914,
                    0.171914374500398,
                    0.331621856609181,
                    -0.003274140715516,
                    -0.075964189841471,
                    0.349023313211304,
                    0.673263998216464,
                    -0.006647212856809,
                    -0.154223713409267,
                    0.484768023339046,
                    0.935114776711619,
                    -0.009232495696808,
                    -0.214205532614824,
                ],
                [
                    -0.214205532614824,
                    -0.154223713409267,
                    -0.075964189841471,
                    -0.015982370635914,
                    -0.009232495696808,
                    -0.006647212856809,
                    -0.003274140715516,
                    -0.000688857875516,
                    0.935114776711619,
                    0.673263998216464,
                    0.331621856609181,
                    0.069771078114026,
                    0.484768023339046,
                    0.349023313211304,
                    0.171914374500398,
                    0.036169664372656,
                ],
                [
                    0.484768023339046,
                    0.349023313211304,
                    0.171914374500398,
                    0.036169664372656,
                    0.935114776711619,
                    0.673263998216464,
                    0.331621856609181,
                    0.069771078114026,
                    -0.009232495696808,
                    -0.006647212856809,
                    -0.003274140715516,
                    -0.000688857875516,
                    -0.214205532614824,
                    -0.154223713409267,
                    -0.075964189841471,
                    -0.015982370635914,
                ],
            ]
        )
        self._Bmatrix_nat = np.array(
            [
                [
                    [
                        -1.872562554762897,
                        -0.343991060612386,
                        0.367853888040706,
                        -0.069533988680551,
                        -1.112299118111532,
                        -0.011758113583205,
                        0.500756059196437,
                        0.185845507051908,
                        -0.547872305113671,
                        -0.005791557943115,
                        0.246651617343169,
                        0.091539770809508,
                        -0.139716226858485,
                        -0.025665969310113,
                        0.02744643010272,
                        -0.005188091854212,
                    ],
                    [
                        0.069533988680551,
                        -0.367853888040706,
                        0.343991060612386,
                        1.872562554762897,
                        -0.185845507051908,
                        -0.500756059196437,
                        0.011758113583205,
                        1.112299118111532,
                        -0.091539770809508,
                        -0.246651617343169,
                        0.005791557943115,
                        0.547872305113671,
                        0.005188091854212,
                        -0.02744643010272,
                        0.025665969310113,
                        0.139716226858485,
                    ],
                    [
                        0.005188091854212,
                        -0.02744643010272,
                        0.025665969310113,
                        0.139716226858485,
                        -0.091539770809508,
                        -0.246651617343169,
                        0.005791557943115,
                        0.547872305113671,
                        -0.185845507051908,
                        -0.500756059196437,
                        0.011758113583205,
                        1.112299118111532,
                        0.069533988680551,
                        -0.367853888040706,
                        0.343991060612386,
                        1.872562554762897,
                    ],
                    [
                        -0.139716226858485,
                        -0.025665969310113,
                        0.02744643010272,
                        -0.005188091854212,
                        -0.547872305113671,
                        -0.005791557943115,
                        0.246651617343169,
                        0.091539770809508,
                        -1.112299118111532,
                        -0.011758113583205,
                        0.500756059196437,
                        0.185845507051908,
                        -1.872562554762897,
                        -0.343991060612386,
                        0.367853888040706,
                        -0.069533988680551,
                    ],
                    [
                        2.824650600597138,
                        -0.669880264425141,
                        -1.381725213078233,
                        1.021622034514792,
                        2.033692124521998,
                        -0.482300436679185,
                        -0.994814609458827,
                        0.735547499358558,
                        1.001712195946975,
                        -0.237561144927798,
                        -0.490004320214082,
                        0.362300120023796,
                        0.210753719871834,
                        -0.049981317181842,
                        -0.103093716594675,
                        0.076225584867561,
                    ],
                    [
                        -1.021622034514792,
                        1.381725213078233,
                        0.669880264425141,
                        -2.824650600597138,
                        -0.735547499358558,
                        0.994814609458827,
                        0.482300436679185,
                        -2.033692124521998,
                        -0.362300120023796,
                        0.490004320214082,
                        0.237561144927798,
                        -1.001712195946975,
                        -0.076225584867561,
                        0.103093716594675,
                        0.049981317181842,
                        -0.210753719871834,
                    ],
                    [
                        0.260468843855851,
                        0.260468843855851,
                        0.260468843855851,
                        0.260468843855851,
                        0.502442927412823,
                        0.502442927412823,
                        0.502442927412823,
                        0.502442927412823,
                        -0.004960676786162,
                        -0.004960676786162,
                        -0.004960676786162,
                        -0.004960676786162,
                        -0.115093951625369,
                        -0.115093951625369,
                        -0.115093951625369,
                        -0.115093951625369,
                    ],
                    [
                        -0.115093951625369,
                        -0.115093951625369,
                        -0.115093951625369,
                        -0.115093951625369,
                        -0.004960676786162,
                        -0.004960676786162,
                        -0.004960676786162,
                        -0.004960676786162,
                        0.502442927412823,
                        0.502442927412823,
                        0.502442927412823,
                        0.502442927412823,
                        0.260468843855851,
                        0.260468843855851,
                        0.260468843855851,
                        0.260468843855851,
                    ],
                    [
                        -0.076225584867561,
                        0.103093716594675,
                        0.049981317181842,
                        -0.210753719871834,
                        -0.362300120023796,
                        0.490004320214082,
                        0.237561144927798,
                        -1.001712195946975,
                        -0.735547499358558,
                        0.994814609458827,
                        0.482300436679185,
                        -2.033692124521998,
                        -1.021622034514792,
                        1.381725213078233,
                        0.669880264425141,
                        -2.824650600597138,
                    ],
                    [
                        0.210753719871834,
                        -0.049981317181842,
                        -0.103093716594675,
                        0.076225584867561,
                        1.001712195946975,
                        -0.237561144927798,
                        -0.490004320214082,
                        0.362300120023796,
                        2.033692124521998,
                        -0.482300436679185,
                        -0.994814609458827,
                        0.735547499358558,
                        2.824650600597138,
                        -0.669880264425141,
                        -1.381725213078233,
                        1.021622034514792,
                    ],
                    [
                        0.115093951625369,
                        0.115093951625369,
                        0.115093951625369,
                        0.115093951625369,
                        0.004960676786162,
                        0.004960676786162,
                        0.004960676786162,
                        0.004960676786162,
                        -0.502442927412823,
                        -0.502442927412823,
                        -0.502442927412823,
                        -0.502442927412823,
                        -0.260468843855851,
                        -0.260468843855851,
                        -0.260468843855851,
                        -0.260468843855851,
                    ],
                    [
                        -0.260468843855851,
                        -0.260468843855851,
                        -0.260468843855851,
                        -0.260468843855851,
                        -0.502442927412823,
                        -0.502442927412823,
                        -0.502442927412823,
                        -0.502442927412823,
                        0.004960676786162,
                        0.004960676786162,
                        0.004960676786162,
                        0.004960676786162,
                        0.115093951625369,
                        0.115093951625369,
                        0.115093951625369,
                        0.115093951625369,
                    ],
                ],
                [
                    [
                        -1.872562554762897,
                        -1.112299118111532,
                        -0.547872305113671,
                        -0.139716226858485,
                        -0.343991060612386,
                        -0.011758113583205,
                        -0.005791557943115,
                        -0.025665969310113,
                        0.367853888040706,
                        0.500756059196437,
                        0.246651617343169,
                        0.02744643010272,
                        -0.069533988680551,
                        0.185845507051908,
                        0.091539770809508,
                        -0.005188091854212,
                    ],
                    [
                        -0.139716226858485,
                        -0.547872305113671,
                        -1.112299118111532,
                        -1.872562554762897,
                        -0.025665969310113,
                        -0.005791557943115,
                        -0.011758113583205,
                        -0.343991060612386,
                        0.02744643010272,
                        0.246651617343169,
                        0.500756059196437,
                        0.367853888040706,
                        -0.005188091854212,
                        0.091539770809508,
                        0.185845507051908,
                        -0.069533988680551,
                    ],
                    [
                        0.005188091854212,
                        -0.091539770809508,
                        -0.185845507051908,
                        0.069533988680551,
                        -0.02744643010272,
                        -0.246651617343169,
                        -0.500756059196437,
                        -0.367853888040706,
                        0.025665969310113,
                        0.005791557943115,
                        0.011758113583205,
                        0.343991060612386,
                        0.139716226858485,
                        0.547872305113671,
                        1.112299118111532,
                        1.872562554762897,
                    ],
                    [
                        0.069533988680551,
                        -0.185845507051908,
                        -0.091539770809508,
                        0.005188091854212,
                        -0.367853888040706,
                        -0.500756059196437,
                        -0.246651617343169,
                        -0.02744643010272,
                        0.343991060612386,
                        0.011758113583205,
                        0.005791557943115,
                        0.025665969310113,
                        1.872562554762897,
                        1.112299118111532,
                        0.547872305113671,
                        0.139716226858485,
                    ],
                    [
                        -0.260468843855851,
                        -0.502442927412823,
                        0.004960676786162,
                        0.115093951625369,
                        -0.260468843855851,
                        -0.502442927412823,
                        0.004960676786162,
                        0.115093951625369,
                        -0.260468843855851,
                        -0.502442927412823,
                        0.004960676786162,
                        0.115093951625369,
                        -0.260468843855851,
                        -0.502442927412823,
                        0.004960676786162,
                        0.115093951625369,
                    ],
                    [
                        0.115093951625369,
                        0.004960676786162,
                        -0.502442927412823,
                        -0.260468843855851,
                        0.115093951625369,
                        0.004960676786162,
                        -0.502442927412823,
                        -0.260468843855851,
                        0.115093951625369,
                        0.004960676786162,
                        -0.502442927412823,
                        -0.260468843855851,
                        0.115093951625369,
                        0.004960676786162,
                        -0.502442927412823,
                        -0.260468843855851,
                    ],
                    [
                        0.210753719871834,
                        1.001712195946975,
                        2.033692124521998,
                        2.824650600597138,
                        -0.049981317181842,
                        -0.237561144927798,
                        -0.482300436679185,
                        -0.669880264425141,
                        -0.103093716594675,
                        -0.490004320214082,
                        -0.994814609458827,
                        -1.381725213078233,
                        0.076225584867561,
                        0.362300120023796,
                        0.735547499358558,
                        1.021622034514792,
                    ],
                    [
                        -0.076225584867561,
                        -0.362300120023796,
                        -0.735547499358558,
                        -1.021622034514792,
                        0.103093716594675,
                        0.490004320214082,
                        0.994814609458827,
                        1.381725213078233,
                        0.049981317181842,
                        0.237561144927798,
                        0.482300436679185,
                        0.669880264425141,
                        -0.210753719871834,
                        -1.001712195946975,
                        -2.033692124521998,
                        -2.824650600597138,
                    ],
                    [
                        -0.115093951625369,
                        -0.004960676786162,
                        0.502442927412823,
                        0.260468843855851,
                        -0.115093951625369,
                        -0.004960676786162,
                        0.502442927412823,
                        0.260468843855851,
                        -0.115093951625369,
                        -0.004960676786162,
                        0.502442927412823,
                        0.260468843855851,
                        -0.115093951625369,
                        -0.004960676786162,
                        0.502442927412823,
                        0.260468843855851,
                    ],
                    [
                        0.260468843855851,
                        0.502442927412823,
                        -0.004960676786162,
                        -0.115093951625369,
                        0.260468843855851,
                        0.502442927412823,
                        -0.004960676786162,
                        -0.115093951625369,
                        0.260468843855851,
                        0.502442927412823,
                        -0.004960676786162,
                        -0.115093951625369,
                        0.260468843855851,
                        0.502442927412823,
                        -0.004960676786162,
                        -0.115093951625369,
                    ],
                    [
                        -1.021622034514792,
                        -0.735547499358558,
                        -0.362300120023796,
                        -0.076225584867561,
                        1.381725213078233,
                        0.994814609458827,
                        0.490004320214082,
                        0.103093716594675,
                        0.669880264425141,
                        0.482300436679185,
                        0.237561144927798,
                        0.049981317181842,
                        -2.824650600597138,
                        -2.033692124521998,
                        -1.001712195946975,
                        -0.210753719871834,
                    ],
                    [
                        2.824650600597138,
                        2.033692124521998,
                        1.001712195946975,
                        0.210753719871834,
                        -0.669880264425141,
                        -0.482300436679185,
                        -0.237561144927798,
                        -0.049981317181842,
                        -1.381725213078233,
                        -0.994814609458827,
                        -0.490004320214082,
                        -0.103093716594675,
                        1.021622034514792,
                        0.735547499358558,
                        0.362300120023796,
                        0.076225584867561,
                    ],
                ],
            ]
        )
        self._idx_face = np.array(
            [[0, 1, 4, 5], [1, 2, 6, 7], [2, 3, 8, 9], [3, 0, 10, 11]]
        )
