"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from nexuscloud_client.exceptions import ApiAttributeError


def lazy_import():
    from nexuscloud_client.model.platform_aci_site import PlatformAciSite
    from nexuscloud_client.model.platform_claim_info import PlatformClaimInfo
    from nexuscloud_client.model.platform_controller import PlatformController
    from nexuscloud_client.model.platform_fed_information import PlatformFedInformation
    from nexuscloud_client.model.platform_meta_info import PlatformMetaInfo
    from nexuscloud_client.model.platform_site_mode import PlatformSiteMode
    from nexuscloud_client.model.platform_site_reachability_status import PlatformSiteReachabilityStatus
    from nexuscloud_client.model.platform_site_type import PlatformSiteType
    from nexuscloud_client.model.platform_switch import PlatformSwitch
    from nexuscloud_client.model.platform_version_compatibility import PlatformVersionCompatibility
    from nexuscloud_client.model.site_config_issues import SiteConfigIssues
    globals()['PlatformAciSite'] = PlatformAciSite
    globals()['PlatformClaimInfo'] = PlatformClaimInfo
    globals()['PlatformController'] = PlatformController
    globals()['PlatformFedInformation'] = PlatformFedInformation
    globals()['PlatformMetaInfo'] = PlatformMetaInfo
    globals()['PlatformSiteMode'] = PlatformSiteMode
    globals()['PlatformSiteReachabilityStatus'] = PlatformSiteReachabilityStatus
    globals()['PlatformSiteType'] = PlatformSiteType
    globals()['PlatformSwitch'] = PlatformSwitch
    globals()['PlatformVersionCompatibility'] = PlatformVersionCompatibility
    globals()['SiteConfigIssues'] = SiteConfigIssues


class PlatformSiteInfo(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('device_host_name',): {
            'min_items': 0,
        },
        ('device_ip_address',): {
            'min_items': 0,
        },
        ('controllers',): {
            'min_items': 0,
        },
        ('site_group',): {
            'min_items': 0,
        },
        ('standalone_switches',): {
            'min_items': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'dev_claim_info': (PlatformClaimInfo,),  # noqa: E501
            'device_claim_id': (str,),  # noqa: E501
            'device_host_name': ([str],),  # noqa: E501
            'device_id': (str,),  # noqa: E501
            'device_ip_address': ([str],),  # noqa: E501
            'name': (str,),  # noqa: E501
            'site_reachability': (PlatformSiteReachabilityStatus,),  # noqa: E501
            'site_type': (PlatformSiteType,),  # noqa: E501
            'tenant_org_id': (str,),  # noqa: E501
            'url': (str,),  # noqa: E501
            'aci': (PlatformAciSite,),  # noqa: E501
            'advisory': (str,),  # noqa: E501
            'annotation': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'annotation_lock': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'anomaly': (str,),  # noqa: E501
            'appliance_name': (str,),  # noqa: E501
            'city': (str,),  # noqa: E501
            'claim_info': (PlatformClaimInfo,),  # noqa: E501
            'config_issues': (SiteConfigIssues,),  # noqa: E501
            'controllers': ([PlatformController],),  # noqa: E501
            'device_external_ip_address': (str,),  # noqa: E501
            'display_name': (str,),  # noqa: E501
            'fed_info': (PlatformFedInformation,),  # noqa: E501
            'image_ref': (str,),  # noqa: E501
            'is_simulated': (bool,),  # noqa: E501
            'latitude': (str,),  # noqa: E501
            'license_allowed': (bool, none_type,),  # noqa: E501
            'longitude': (str,),  # noqa: E501
            'meta': (PlatformMetaInfo,),  # noqa: E501
            'mode': (PlatformSiteMode,),  # noqa: E501
            'site_group': ([str],),  # noqa: E501
            'site_health': (str,),  # noqa: E501
            'standalone_switches': ([PlatformSwitch],),  # noqa: E501
            'tier': (str,),  # noqa: E501
            'version_compatibility': (PlatformVersionCompatibility,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'dev_claim_info': 'devClaimInfo',  # noqa: E501
        'device_claim_id': 'deviceClaimID',  # noqa: E501
        'device_host_name': 'deviceHostName',  # noqa: E501
        'device_id': 'deviceID',  # noqa: E501
        'device_ip_address': 'deviceIPAddress',  # noqa: E501
        'name': 'name',  # noqa: E501
        'site_reachability': 'siteReachability',  # noqa: E501
        'site_type': 'siteType',  # noqa: E501
        'tenant_org_id': 'tenantOrgID',  # noqa: E501
        'url': 'url',  # noqa: E501
        'aci': 'aci',  # noqa: E501
        'advisory': 'advisory',  # noqa: E501
        'annotation': 'annotation',  # noqa: E501
        'annotation_lock': 'annotationLock',  # noqa: E501
        'anomaly': 'anomaly',  # noqa: E501
        'appliance_name': 'applianceName',  # noqa: E501
        'city': 'city',  # noqa: E501
        'claim_info': 'claimInfo',  # noqa: E501
        'config_issues': 'configIssues',  # noqa: E501
        'controllers': 'controllers',  # noqa: E501
        'device_external_ip_address': 'deviceExternalIPAddress',  # noqa: E501
        'display_name': 'displayName',  # noqa: E501
        'fed_info': 'fedInfo',  # noqa: E501
        'image_ref': 'imageRef',  # noqa: E501
        'is_simulated': 'isSimulated',  # noqa: E501
        'latitude': 'latitude',  # noqa: E501
        'license_allowed': 'licenseAllowed',  # noqa: E501
        'longitude': 'longitude',  # noqa: E501
        'meta': 'meta',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'site_group': 'siteGroup',  # noqa: E501
        'site_health': 'siteHealth',  # noqa: E501
        'standalone_switches': 'standaloneSwitches',  # noqa: E501
        'tier': 'tier',  # noqa: E501
        'version_compatibility': 'versionCompatibility',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, dev_claim_info, device_claim_id, device_host_name, device_id, device_ip_address, name, site_reachability, site_type, tenant_org_id, url, *args, **kwargs):  # noqa: E501
        """PlatformSiteInfo - a model defined in OpenAPI

        Args:
            dev_claim_info (PlatformClaimInfo):
            device_claim_id (str): Device claim ID
            device_host_name ([str]): Host names
            device_id (str): Device ID
            device_ip_address ([str]): Device IP addresses
            name (str): Name
            site_reachability (PlatformSiteReachabilityStatus):
            site_type (PlatformSiteType):
            tenant_org_id (str): Tenant org ID
            url (str): URL

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aci (PlatformAciSite): [optional]  # noqa: E501
            advisory (str): Advisory. [optional]  # noqa: E501
            annotation (bool, date, datetime, dict, float, int, list, str, none_type): Annotation. [optional]  # noqa: E501
            annotation_lock (bool, date, datetime, dict, float, int, list, str, none_type): AnnotationLock. [optional]  # noqa: E501
            anomaly (str): Anomaly. [optional]  # noqa: E501
            appliance_name (str): Appliance name. [optional]  # noqa: E501
            city (str): Nearest city. [optional]  # noqa: E501
            claim_info (PlatformClaimInfo): [optional]  # noqa: E501
            config_issues (SiteConfigIssues): [optional]  # noqa: E501
            controllers ([PlatformController]): controllers list. [optional]  # noqa: E501
            device_external_ip_address (str): Device external IP address. [optional]  # noqa: E501
            display_name (str): Display name. [optional]  # noqa: E501
            fed_info (PlatformFedInformation): [optional]  # noqa: E501
            image_ref (str): Image reference. [optional]  # noqa: E501
            is_simulated (bool): Is simulated boolean. [optional]  # noqa: E501
            latitude (str): Latitude. [optional]  # noqa: E501
            license_allowed (bool, none_type): License Allowed. [optional]  # noqa: E501
            longitude (str): Longitude. [optional]  # noqa: E501
            meta (PlatformMetaInfo): [optional]  # noqa: E501
            mode (PlatformSiteMode): [optional]  # noqa: E501
            site_group ([str]): Site groups. [optional]  # noqa: E501
            site_health (str): Site health. [optional]  # noqa: E501
            standalone_switches ([PlatformSwitch]): List. [optional]  # noqa: E501
            tier (str): Licensing functionality fier. [optional]  # noqa: E501
            version_compatibility (PlatformVersionCompatibility): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.dev_claim_info = dev_claim_info
        self.device_claim_id = device_claim_id
        self.device_host_name = device_host_name
        self.device_id = device_id
        self.device_ip_address = device_ip_address
        self.name = name
        self.site_reachability = site_reachability
        self.site_type = site_type
        self.tenant_org_id = tenant_org_id
        self.url = url
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, dev_claim_info, device_claim_id, device_host_name, device_id, device_ip_address, name, site_reachability, site_type, tenant_org_id, url, *args, **kwargs):  # noqa: E501
        """PlatformSiteInfo - a model defined in OpenAPI

        Args:
            dev_claim_info (PlatformClaimInfo):
            device_claim_id (str): Device claim ID
            device_host_name ([str]): Host names
            device_id (str): Device ID
            device_ip_address ([str]): Device IP addresses
            name (str): Name
            site_reachability (PlatformSiteReachabilityStatus):
            site_type (PlatformSiteType):
            tenant_org_id (str): Tenant org ID
            url (str): URL

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            aci (PlatformAciSite): [optional]  # noqa: E501
            advisory (str): Advisory. [optional]  # noqa: E501
            annotation (bool, date, datetime, dict, float, int, list, str, none_type): Annotation. [optional]  # noqa: E501
            annotation_lock (bool, date, datetime, dict, float, int, list, str, none_type): AnnotationLock. [optional]  # noqa: E501
            anomaly (str): Anomaly. [optional]  # noqa: E501
            appliance_name (str): Appliance name. [optional]  # noqa: E501
            city (str): Nearest city. [optional]  # noqa: E501
            claim_info (PlatformClaimInfo): [optional]  # noqa: E501
            config_issues (SiteConfigIssues): [optional]  # noqa: E501
            controllers ([PlatformController]): controllers list. [optional]  # noqa: E501
            device_external_ip_address (str): Device external IP address. [optional]  # noqa: E501
            display_name (str): Display name. [optional]  # noqa: E501
            fed_info (PlatformFedInformation): [optional]  # noqa: E501
            image_ref (str): Image reference. [optional]  # noqa: E501
            is_simulated (bool): Is simulated boolean. [optional]  # noqa: E501
            latitude (str): Latitude. [optional]  # noqa: E501
            license_allowed (bool, none_type): License Allowed. [optional]  # noqa: E501
            longitude (str): Longitude. [optional]  # noqa: E501
            meta (PlatformMetaInfo): [optional]  # noqa: E501
            mode (PlatformSiteMode): [optional]  # noqa: E501
            site_group ([str]): Site groups. [optional]  # noqa: E501
            site_health (str): Site health. [optional]  # noqa: E501
            standalone_switches ([PlatformSwitch]): List. [optional]  # noqa: E501
            tier (str): Licensing functionality fier. [optional]  # noqa: E501
            version_compatibility (PlatformVersionCompatibility): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.dev_claim_info = dev_claim_info
        self.device_claim_id = device_claim_id
        self.device_host_name = device_host_name
        self.device_id = device_id
        self.device_ip_address = device_ip_address
        self.name = name
        self.site_reachability = site_reachability
        self.site_type = site_type
        self.tenant_org_id = tenant_org_id
        self.url = url
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
