"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_utilization_energy_get200_response import NexusInsightsApiV1UtilizationEnergyGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_utilization_node_details_get200_response import NexusInsightsApiV1UtilizationNodeDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_utilization_resources_get200_response import NexusInsightsApiV1UtilizationResourcesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_utilization_sites_summary_get200_response import NexusInsightsApiV1UtilizationSitesSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_utilization_top_nodes_get200_response import NexusInsightsApiV1UtilizationTopNodesGet200Response


class UtilizationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_utilization_energy_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1UtilizationEnergyGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/utilization/energy',
                'operation_id': 'nexus_insights_api_v1_utilization_energy_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'granularity',
                    'history',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'granularity':
                        (str,),
                    'history':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'granularity': 'granularity',
                    'history': 'history',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'granularity': 'query',
                    'history': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_utilization_node_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1UtilizationNodeDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/utilization/nodeDetails',
                'operation_id': 'nexus_insights_api_v1_utilization_node_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'node_name',
                    'stat_name',
                    'sub_resource_name',
                    'history',
                    'granularity',
                    'scope',
                    'sub_tree',
                    'site_group_name',
                    'site_name',
                    'anomaly_score',
                    'sort',
                    'count',
                    'offset',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "OPERATIONAL": "operational",
                        "CONFIG": "config",
                        "HARDWARE": "hardware",
                        "ENVIRONMENTAL": "environmental",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'node_name':
                        (str,),
                    'stat_name':
                        (str,),
                    'sub_resource_name':
                        (str,),
                    'history':
                        (int,),
                    'granularity':
                        (str,),
                    'scope':
                        (str,),
                    'sub_tree':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'anomaly_score':
                        (str,),
                    'sort':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'node_name': 'nodeName',
                    'stat_name': 'statName',
                    'sub_resource_name': 'subResourceName',
                    'history': 'history',
                    'granularity': 'granularity',
                    'scope': 'scope',
                    'sub_tree': 'subTree',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'anomaly_score': 'anomalyScore',
                    'sort': 'sort',
                    'count': 'count',
                    'offset': 'offset',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'node_name': 'query',
                    'stat_name': 'query',
                    'sub_resource_name': 'query',
                    'history': 'query',
                    'granularity': 'query',
                    'scope': 'query',
                    'sub_tree': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'anomaly_score': 'query',
                    'sort': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_utilization_resources_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1UtilizationResourcesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/utilization/resources',
                'operation_id': 'nexus_insights_api_v1_utilization_resources_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_utilization_sites_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1UtilizationSitesSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/utilization/sitesSummary',
                'operation_id': 'nexus_insights_api_v1_utilization_sites_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'start_date',
                    'end_date',
                    'granularity',
                ],
                'required': [
                    'site_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'granularity':
                        (str,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'granularity': 'granularity',
                },
                'location_map': {
                    'site_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'granularity': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_utilization_top_nodes_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1UtilizationTopNodesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/utilization/topNodes',
                'operation_id': 'nexus_insights_api_v1_utilization_top_nodes_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'score_type',
                    'stat_name',
                    'granularity',
                    'count',
                    'resource_count',
                    'site_group_name',
                    'site_name',
                    'node_name',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'score_type',
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('score_type',): {

                        "TOTALSCORE": "totalScore",
                        "ANOMALYSCORE": "anomalyScore",
                        "TRENDSCORE": "trendScore",
                        "RAWANOMALYSCORE": "rawAnomalyScore",
                        "ALL": "ALL"
                    },
                    ('stat_name',): {

                        "CONFIG": "config",
                        "OPERATIONAL": "operational",
                        "HARDWARE": "hardware",
                        "ENVIRONMENTAL": "environmental",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'score_type':
                        (str,),
                    'stat_name':
                        (str,),
                    'granularity':
                        (str,),
                    'count':
                        (str,),
                    'resource_count':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'score_type': 'scoreType',
                    'stat_name': 'statName',
                    'granularity': 'granularity',
                    'count': 'count',
                    'resource_count': 'resourceCount',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'filter': 'filter',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'score_type': 'query',
                    'stat_name': 'query',
                    'granularity': 'query',
                    'count': 'query',
                    'resource_count': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_utilization_energy_get(
        self,
        **kwargs
    ):
        """Get Energy Consumption data  # noqa: E501

        Get energy consumed timeseries in Kilowat-hour  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_utilization_energy_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start Date, to collect the records from the specified date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End Date, to collect the records till the specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            history (str): Require the timeseries data or not. [optional] if omitted the server will use the default value of "0"
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1UtilizationEnergyGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_utilization_energy_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_utilization_node_details_get(
        self,
        **kwargs
    ):
        """Utilization details of fabric nodes  # noqa: E501

        Gives the Environmental and Resource utilization details of the fabric nodes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_utilization_node_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            node_name (str): Name of the fabric node, limit the anamaloy score to given nodeName. [optional] if omitted the server will use the default value of "None"
            stat_name (str): Stats type, either or combination of [operational, config, hardware, environmental, ALL] . [optional] if omitted the server will use the default value of "ALL"
            sub_resource_name (str): default value: None. [optional] if omitted the server will use the default value of "None"
            history (int): Defines whether records need to be added with timeseries or not in response. [optional] if omitted the server will use the default value of 0
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            scope (str): Node or subResource : if scope=subResource, then response is with sub-resources in same level as other resourcces. [optional] if omitted the server will use the default value of "node"
            sub_tree (str): Requires the sub-resources data or not (sub-resources are available for only limited resources). [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site, Limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            anomaly_score (str): Furnish anomaly score in the response or not\". [optional] if omitted the server will use the default value of "yes"
            sort (str): Sort results in response by fields like anomalyScore, nodeName. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            count (int): Limits the number of entries. [optional] if omitted the server will use the default value of 10000
            offset (int): Offset from which records are returned. [optional] if omitted the server will use the default value of 0
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1UtilizationNodeDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_utilization_node_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_utilization_resources_get(
        self,
        **kwargs
    ):
        """Get resources list  # noqa: E501

        Get all resources list having resource name and respective category like BD:config, CPU:environmental etc  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_utilization_resources_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1UtilizationResourcesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_utilization_resources_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_utilization_sites_summary_get(
        self,
        site_name,
        **kwargs
    ):
        """Get fabric utilization stats summary  # noqa: E501

        Get fabric stats summary of utilization resources like Bridge Domains, Endpoint Groups, L4/L7 Devices etc  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_utilization_sites_summary_get(site_name, async_req=True)
        >>> result = thread.get()

        Args:
            site_name (str): Name of the Site, limit the records pertaining to this siteName

        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1UtilizationSitesSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_name'] = \
            site_name
        return self.nexus_insights_api_v1_utilization_sites_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_utilization_top_nodes_get(
        self,
        **kwargs
    ):
        """Get utilization top nodes  # noqa: E501

        Get Top Nodes based on Utilization and Environmental resources  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_utilization_top_nodes_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            score_type (str): Score type, either of [totalScore, anomalyScore, trendScore, rawAnomalyScore, ALL]. [optional] if omitted the server will use the default value of "ALL"
            stat_name (str): Type of the stats, either of [config, operational, hardware, environmental, ALL]. [optional] if omitted the server will use the default value of "ALL"
            granularity (str): Granularity of the values w.r.t duration. [optional] if omitted the server will use the default value of "5m"
            count (str): Limits the number of entries in the response. [optional] if omitted the server will use the default value of "10"
            resource_count (str): Limits the number of resources entries per node. [optional] if omitted the server will use the default value of "5"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the Site, Limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            node_name (str): Name of the fabric node, limit the anamaloy score to given nodeName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1UtilizationTopNodesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_utilization_top_nodes_get_endpoint.call_with_http_info(**kwargs)

