"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_available_timelines_get200_response import NexusInsightsApiV1SustainabilityAvailableTimelinesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_calc_status_get200_response import NexusInsightsApiV1SustainabilityCalcStatusGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_cost_get200_response import NexusInsightsApiV1SustainabilityCostGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_data_status_get200_response import NexusInsightsApiV1SustainabilityDataStatusGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_emissions_get200_response import NexusInsightsApiV1SustainabilityEmissionsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_energy_settings_get200_response import NexusInsightsApiV1SustainabilityEnergySettingsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_energy_settings_get200_response1 import NexusInsightsApiV1SustainabilityEnergySettingsGet200Response1
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_energy_settings_get_request import NexusInsightsApiV1SustainabilityEnergySettingsGetRequest
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_power_get200_response import NexusInsightsApiV1SustainabilityPowerGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_site_status_get200_response import NexusInsightsApiV1SustainabilitySiteStatusGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_sources_get200_response import NexusInsightsApiV1SustainabilitySourcesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_trigger_calcs_post200_response import NexusInsightsApiV1SustainabilityTriggerCalcsPost200Response
from nexuscloud_client.model.nexus_insights_api_v1_sustainability_trigger_calcs_post_request import NexusInsightsApiV1SustainabilityTriggerCalcsPostRequest


class SustainabilityApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_sustainability_available_timelines_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityAvailableTimelinesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/availableTimelines',
                'operation_id': 'nexus_insights_api_v1_sustainability_available_timelines_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_calc_status_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityCalcStatusGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/calcStatus',
                'operation_id': 'nexus_insights_api_v1_sustainability_calc_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'calc_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'calc_id':
                        (str,),
                },
                'attribute_map': {
                    'calc_id': 'calcId',
                },
                'location_map': {
                    'calc_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_cost_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityCostGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/cost',
                'operation_id': 'nexus_insights_api_v1_sustainability_cost_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'start_date',
                    'end_date',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_data_status_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityDataStatusGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/dataStatus',
                'operation_id': 'nexus_insights_api_v1_sustainability_data_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_emissions_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityEmissionsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/emissions',
                'operation_id': 'nexus_insights_api_v1_sustainability_emissions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'start_date',
                    'end_date',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_energy_settings_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityEnergySettingsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/energySettings',
                'operation_id': 'nexus_insights_api_v1_sustainability_energy_settings_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_energy_settings_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityEnergySettingsGet200Response1,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/energySettings',
                'operation_id': 'nexus_insights_api_v1_sustainability_energy_settings_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_sustainability_energy_settings_get_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_sustainability_energy_settings_get_request':
                        (NexusInsightsApiV1SustainabilityEnergySettingsGetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_sustainability_energy_settings_get_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_power_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityPowerGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/power',
                'operation_id': 'nexus_insights_api_v1_sustainability_power_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'start_date',
                    'end_date',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_site_status_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilitySiteStatusGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/siteStatus',
                'operation_id': 'nexus_insights_api_v1_sustainability_site_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'site_name_list',
                ],
                'required': [
                    'site_group_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_sources_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilitySourcesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/sources',
                'operation_id': 'nexus_insights_api_v1_sustainability_sources_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name_list',
                    'start_date',
                    'end_date',
                    'site_name',
                    'site_list_name',
                ],
                'required': [
                    'site_name_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_name_list':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'site_list_name':
                        (str,),
                },
                'attribute_map': {
                    'site_name_list': 'siteNameList',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'site_list_name': 'siteListName',
                },
                'location_map': {
                    'site_name_list': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_name': 'query',
                    'site_list_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_sustainability_trigger_calcs_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SustainabilityTriggerCalcsPost200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/sustainability/triggerCalcs',
                'operation_id': 'nexus_insights_api_v1_sustainability_trigger_calcs_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_sustainability_trigger_calcs_post_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_sustainability_trigger_calcs_post_request':
                        (NexusInsightsApiV1SustainabilityTriggerCalcsPostRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_sustainability_trigger_calcs_post_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_sustainability_available_timelines_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get available timelines for the sites  # noqa: E501

        Get available timelines for the sites  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_available_timelines_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityAvailableTimelinesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_available_timelines_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_calc_status_get(
        self,
        **kwargs
    ):
        """Get Sustainability Calc Status  # noqa: E501

        Get Sustainability Calc Status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_calc_status_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            calc_id (str): calc ID. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityCalcStatusGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sustainability_calc_status_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_cost_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get Sustainability Cost data  # noqa: E501

        Get Sustainability Cost data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_cost_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            start_date (str): Start timestamp. [optional] if omitted the server will use the default value of "None"
            end_date (str): End timestamp. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityCostGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_cost_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_data_status_get(
        self,
        start_date="None",
        end_date="None",
        site_group_name="None",
        **kwargs
    ):
        """Is Sustainability Data ready to be consumed  # noqa: E501

        Gives the status if the Sustainability data is ready to be consumed or not  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_data_status_get(start_date="None", end_date="None", site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            start_date (str): Start timestamp. defaults to "None", must be one of ["None"]
            end_date (str): End timestamp. defaults to "None", must be one of ["None"]
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityDataStatusGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_data_status_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_emissions_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get Sustainability Emissions data  # noqa: E501

        Get Sustainability Emissions data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_emissions_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            start_date (str): Start timestamp. [optional] if omitted the server will use the default value of "None"
            end_date (str): End timestamp. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityEmissionsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_emissions_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_energy_settings_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get Cost ($/kWh) per Site  # noqa: E501

        Get Cost ($/kWh) per Site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_energy_settings_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityEnergySettingsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_energy_settings_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_energy_settings_post(
        self,
        **kwargs
    ):
        """Set Power Cost ($/kWh) per Site  # noqa: E501

        Set Power Cost ($/kWh) per Site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_energy_settings_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_sustainability_energy_settings_get_request (NexusInsightsApiV1SustainabilityEnergySettingsGetRequest): The parameters used for setting the data. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityEnergySettingsGet200Response1
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sustainability_energy_settings_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_power_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get Sustainability Power data  # noqa: E501

        Get Sustainability Power data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_power_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            start_date (str): Start timestamp. [optional] if omitted the server will use the default value of "None"
            end_date (str): End timestamp. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityPowerGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_power_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_site_status_get(
        self,
        site_group_name="None",
        **kwargs
    ):
        """Get Sustainability Site Status  # noqa: E501

        Get Sustainability Site Status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_site_status_get(site_group_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_name_list (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilitySiteStatusGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        return self.nexus_insights_api_v1_sustainability_site_status_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_sources_get(
        self,
        site_name_list="None",
        **kwargs
    ):
        """Get Sustainability Sources data  # noqa: E501

        Get Sustainability Sources data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_sources_get(site_name_list="None", async_req=True)
        >>> result = thread.get()

        Args:
            site_name_list (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. defaults to "None", must be one of ["None"]

        Keyword Args:
            start_date (str): Start timestamp. [optional] if omitted the server will use the default value of "None"
            end_date (str): End timestamp. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            site_list_name (str): Name of the sites - limit the records pertaining to given siteListNames. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilitySourcesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_name_list'] = \
            site_name_list
        return self.nexus_insights_api_v1_sustainability_sources_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_sustainability_trigger_calcs_post(
        self,
        **kwargs
    ):
        """Trigger Sustainability Data calculations  # noqa: E501

        Trigger Sustainability Data calculations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_sustainability_trigger_calcs_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_sustainability_trigger_calcs_post_request (NexusInsightsApiV1SustainabilityTriggerCalcsPostRequest): The parameters used for scheduling the job. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SustainabilityTriggerCalcsPost200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_sustainability_trigger_calcs_post_endpoint.call_with_http_info(**kwargs)

