"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_advisories_details_get401_response import NexusInsightsApiV1AdvisoriesDetailsGet401Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_affected_endpoints_get200_response import NexusInsightsApiV1SoftwareManagementAffectedEndpointsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_customize_groups_post200_response import NexusInsightsApiV1SoftwareManagementCustomizeGroupsPost200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_customize_groups_post_request_inner import NexusInsightsApiV1SoftwareManagementCustomizeGroupsPostRequestInner
from nexuscloud_client.model.nexus_insights_api_v1_software_management_forecast_cleared_advisories_get200_response import NexusInsightsApiV1SoftwareManagementForecastClearedAdvisoriesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get200_response import NexusInsightsApiV1SoftwareManagementForecastClearedAnomaliesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_postvalidation_details_get200_response import NexusInsightsApiV1SoftwareManagementPostvalidationDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_prevalidations_get200_response import NexusInsightsApiV1SoftwareManagementPrevalidationsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_recommended_plan_get200_response import NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_recommended_plan_get200_response1 import NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response1
from nexuscloud_client.model.nexus_insights_api_v1_software_management_recommended_plan_get_request_inner import NexusInsightsApiV1SoftwareManagementRecommendedPlanGetRequestInner
from nexuscloud_client.model.nexus_insights_api_v1_software_management_sites_get200_response import NexusInsightsApiV1SoftwareManagementSitesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_sites_get200_response1 import NexusInsightsApiV1SoftwareManagementSitesGet200Response1
from nexuscloud_client.model.nexus_insights_api_v1_software_management_sites_get_request_inner import NexusInsightsApiV1SoftwareManagementSitesGetRequestInner
from nexuscloud_client.model.nexus_insights_api_v1_software_management_upgrade_post200_response import NexusInsightsApiV1SoftwareManagementUpgradePost200Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_upgrade_post400_response import NexusInsightsApiV1SoftwareManagementUpgradePost400Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_upgrade_post500_response import NexusInsightsApiV1SoftwareManagementUpgradePost500Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_upgrade_post502_response import NexusInsightsApiV1SoftwareManagementUpgradePost502Response
from nexuscloud_client.model.nexus_insights_api_v1_software_management_upgrade_post_request import NexusInsightsApiV1SoftwareManagementUpgradePostRequest
from nexuscloud_client.model.nexus_insights_api_v1_software_management_versions_get200_response import NexusInsightsApiV1SoftwareManagementVersionsGet200Response


class SoftwareManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_software_management_affected_endpoints_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementAffectedEndpointsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/affectedEndpoints',
                'operation_id': 'nexus_insights_api_v1_software_management_affected_endpoints_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'config_id',
                    'instance_id',
                ],
                'required': [
                    'config_id',
                    'instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'config_id':
                        (str,),
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'config_id': 'configId',
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'config_id': 'query',
                    'instance_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_customize_groups_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementCustomizeGroupsPost200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/customizeGroups',
                'operation_id': 'nexus_insights_api_v1_software_management_customize_groups_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_software_management_customize_groups_post_request_inner',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_software_management_customize_groups_post_request_inner':
                        ([NexusInsightsApiV1SoftwareManagementCustomizeGroupsPostRequestInner],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_software_management_customize_groups_post_request_inner': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_forecast_cleared_advisories_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementForecastClearedAdvisoriesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/forecastClearedAdvisories',
                'operation_id': 'nexus_insights_api_v1_software_management_forecast_cleared_advisories_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance_id',
                ],
                'required': [
                    'instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'instance_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementForecastClearedAnomaliesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/forecastClearedAnomalies',
                'operation_id': 'nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instance_id',
                ],
                'required': [
                    'instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'instance_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_postvalidation_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementPostvalidationDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/postvalidationDetails',
                'operation_id': 'nexus_insights_api_v1_software_management_postvalidation_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'config_id',
                    'instance_id',
                ],
                'required': [
                    'config_id',
                    'instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'config_id':
                        (str,),
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'config_id': 'configId',
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'config_id': 'query',
                    'instance_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_prevalidations_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementPrevalidationsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/prevalidations',
                'operation_id': 'nexus_insights_api_v1_software_management_prevalidations_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'config_id',
                    'instance_id',
                ],
                'required': [
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'config_id':
                        (str,),
                    'instance_id':
                        (str,),
                },
                'attribute_map': {
                    'config_id': 'configId',
                    'instance_id': 'instanceId',
                },
                'location_map': {
                    'config_id': 'query',
                    'instance_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_recommended_plan_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/recommendedPlan',
                'operation_id': 'nexus_insights_api_v1_software_management_recommended_plan_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'config_id',
                ],
                'required': [
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'config_id':
                        (str,),
                },
                'attribute_map': {
                    'config_id': 'configId',
                },
                'location_map': {
                    'config_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_recommended_plan_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response1,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/recommendedPlan',
                'operation_id': 'nexus_insights_api_v1_software_management_recommended_plan_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_software_management_recommended_plan_get_request_inner',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_software_management_recommended_plan_get_request_inner':
                        ([NexusInsightsApiV1SoftwareManagementRecommendedPlanGetRequestInner],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_software_management_recommended_plan_get_request_inner': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_sites_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementSitesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/sites',
                'operation_id': 'nexus_insights_api_v1_software_management_sites_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'offset',
                    'count',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'offset':
                        (int,),
                    'count':
                        (int,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'offset': 'offset',
                    'count': 'count',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'offset': 'query',
                    'count': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_sites_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementSitesGet200Response1,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/sites',
                'operation_id': 'nexus_insights_api_v1_software_management_sites_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_software_management_sites_get_request_inner',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_software_management_sites_get_request_inner':
                        ([NexusInsightsApiV1SoftwareManagementSitesGetRequestInner],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_software_management_sites_get_request_inner': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_upgrade_post_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementUpgradePost200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/upgrade',
                'operation_id': 'nexus_insights_api_v1_software_management_upgrade_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'nexus_insights_api_v1_software_management_upgrade_post_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'nexus_insights_api_v1_software_management_upgrade_post_request':
                        (NexusInsightsApiV1SoftwareManagementUpgradePostRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'nexus_insights_api_v1_software_management_upgrade_post_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_software_management_versions_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SoftwareManagementVersionsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/softwareManagement/versions',
                'operation_id': 'nexus_insights_api_v1_software_management_versions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vendor',
                    'minimum_version',
                ],
                'required': [
                    'vendor',
                ],
                'nullable': [
                ],
                'enum': [
                    'vendor',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('vendor',): {

                        "ACI": "CISCO_ACI",
                        "NX-OS": "CISCO_NX-OS"
                    },
                },
                'openapi_types': {
                    'vendor':
                        (str,),
                    'minimum_version':
                        (str,),
                },
                'attribute_map': {
                    'vendor': 'vendor',
                    'minimum_version': 'minimumVersion',
                },
                'location_map': {
                    'vendor': 'query',
                    'minimum_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_software_management_affected_endpoints_get(
        self,
        config_id,
        instance_id,
        **kwargs
    ):
        """Get affected endpoints after upgrade  # noqa: E501

        Get affected endpoints after an upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_affected_endpoints_get(config_id, instance_id, async_req=True)
        >>> result = thread.get()

        Args:
            config_id (str): config id for a previous run of pre-validation check
            instance_id (str): instance id for a previous run of pre-validation check

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementAffectedEndpointsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['config_id'] = \
            config_id
        kwargs['instance_id'] = \
            instance_id
        return self.nexus_insights_api_v1_software_management_affected_endpoints_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_customize_groups_post(
        self,
        **kwargs
    ):
        """Post customized groups  # noqa: E501

        Post customized groups for a site(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_customize_groups_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_software_management_customize_groups_post_request_inner ([NexusInsightsApiV1SoftwareManagementCustomizeGroupsPostRequestInner]): Parameters for software update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementCustomizeGroupsPost200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_software_management_customize_groups_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_forecast_cleared_advisories_get(
        self,
        instance_id,
        **kwargs
    ):
        """Get forecast cleared advisories  # noqa: E501

        Get the list of advisories that will be cleared on upgrade   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_forecast_cleared_advisories_get(instance_id, async_req=True)
        >>> result = thread.get()

        Args:
            instance_id (str): Instance id for the group in a site

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementForecastClearedAdvisoriesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instance_id'] = \
            instance_id
        return self.nexus_insights_api_v1_software_management_forecast_cleared_advisories_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get(
        self,
        instance_id,
        **kwargs
    ):
        """Get forecast cleared bug anomalies  # noqa: E501

        Get the list of bug anomalies that will be cleared on upgrade   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get(instance_id, async_req=True)
        >>> result = thread.get()

        Args:
            instance_id (str): Instance id for the group in a site

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementForecastClearedAnomaliesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instance_id'] = \
            instance_id
        return self.nexus_insights_api_v1_software_management_forecast_cleared_anomalies_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_postvalidation_details_get(
        self,
        config_id,
        instance_id,
        **kwargs
    ):
        """Get post-upgrade check results  # noqa: E501

        Get detailed results for the validation checks after an upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_postvalidation_details_get(config_id, instance_id, async_req=True)
        >>> result = thread.get()

        Args:
            config_id (str): config id for a previous run of pre-validation check
            instance_id (str): instance id for a previous run of pre-validation check

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementPostvalidationDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['config_id'] = \
            config_id
        kwargs['instance_id'] = \
            instance_id
        return self.nexus_insights_api_v1_software_management_postvalidation_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_prevalidations_get(
        self,
        config_id,
        **kwargs
    ):
        """Get pre-upgrade check results  # noqa: E501

        Get detailed results for the validation checks before an upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_prevalidations_get(config_id, async_req=True)
        >>> result = thread.get()

        Args:
            config_id (str): config id for a previous run of pre-validation check

        Keyword Args:
            instance_id (str): instance id for a previous run of pre-validation check. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementPrevalidationsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['config_id'] = \
            config_id
        return self.nexus_insights_api_v1_software_management_prevalidations_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_recommended_plan_get(
        self,
        config_id,
        **kwargs
    ):
        """Get update plan  # noqa: E501

        Get detailed status of an update in progress  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_recommended_plan_get(config_id, async_req=True)
        >>> result = thread.get()

        Args:
            config_id (str): Instance id for the group in a site

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['config_id'] = \
            config_id
        return self.nexus_insights_api_v1_software_management_recommended_plan_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_recommended_plan_post(
        self,
        **kwargs
    ):
        """Cancel Software update  # noqa: E501

        Cancel software update for site  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_recommended_plan_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_software_management_recommended_plan_get_request_inner ([NexusInsightsApiV1SoftwareManagementRecommendedPlanGetRequestInner]): Parameters for cancelling software update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementRecommendedPlanGet200Response1
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_software_management_recommended_plan_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_sites_get(
        self,
        **kwargs
    ):
        """Get upgrade status  # noqa: E501

        Get status of upgrades in progress  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_sites_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_group_name (str): Name of the Insights Group - limit the records pertaining to the sites in this siteGroupName. [optional]
            site_name (str): Name of the fabric - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            offset (int): Pagination index into response.. [optional]
            count (int): Limit the number of records in the response. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementSitesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_software_management_sites_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_sites_post(
        self,
        **kwargs
    ):
        """Software update  # noqa: E501

        Start software update for site(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_sites_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_software_management_sites_get_request_inner ([NexusInsightsApiV1SoftwareManagementSitesGetRequestInner]): Parameters for software update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementSitesGet200Response1
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_software_management_sites_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_upgrade_post(
        self,
        **kwargs
    ):
        """Software update  # noqa: E501

        Start software update install for site(s)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_upgrade_post(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            nexus_insights_api_v1_software_management_upgrade_post_request (NexusInsightsApiV1SoftwareManagementUpgradePostRequest): Parameters for software update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementUpgradePost200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_software_management_upgrade_post_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_software_management_versions_get(
        self,
        vendor,
        **kwargs
    ):
        """Get software versions  # noqa: E501

        Get software versions, release-notes URL and their recommended or latest tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_software_management_versions_get(vendor, async_req=True)
        >>> result = thread.get()

        Args:
            vendor (str): vendor

        Keyword Args:
            minimum_version (str): Exclude versions that are higher than the minimum version specified. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SoftwareManagementVersionsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['vendor'] = \
            vendor
        return self.nexus_insights_api_v1_software_management_versions_get_endpoint.call_with_http_info(**kwargs)

