"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_advisories_details_get401_response import NexusInsightsApiV1AdvisoriesDetailsGet401Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_cloud_details_get200_response import NexusInsightsApiV1ReportsCloudDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_cloud_inventory_get200_response import NexusInsightsApiV1ReportsCloudInventoryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_cloud_summary_get200_response import NexusInsightsApiV1ReportsCloudSummaryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_details_get200_response import NexusInsightsApiV1ReportsDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_inventory_get200_response import NexusInsightsApiV1ReportsInventoryGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_reports_summary_get200_response import NexusInsightsApiV1ReportsSummaryGet200Response


class ReportsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_reports_cloud_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsCloudDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/cloudDetails',
                'operation_id': 'nexus_insights_api_v1_reports_cloud_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'outlook',
                    'site_name',
                    'site_name_list',
                    'site_group_name',
                    'filter',
                    'include',
                    'offset',
                    'count',
                    'sort',
                ],
                'required': [
                    'outlook',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'outlook':
                        (int,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                    'site_group_name':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        (str,),
                    'offset':
                        (str,),
                    'count':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'outlook': 'outlook',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                    'site_group_name': 'siteGroupName',
                    'filter': 'filter',
                    'include': 'include',
                    'offset': 'offset',
                    'count': 'count',
                    'sort': 'sort',
                },
                'location_map': {
                    'outlook': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                    'site_group_name': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'offset': 'query',
                    'count': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_reports_cloud_inventory_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsCloudInventoryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/cloudInventory',
                'operation_id': 'nexus_insights_api_v1_reports_cloud_inventory_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'site_name_list',
                    'site_group_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'site_name': 'query',
                    'site_name_list': 'query',
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_reports_cloud_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsCloudSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/cloudSummary',
                'operation_id': 'nexus_insights_api_v1_reports_cloud_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'outlook_period',
                    'report_type',
                    'site_name',
                    'site_name_list',
                    'site_group_name',
                ],
                'required': [
                    'outlook_period',
                    'report_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'outlook_period':
                        (int,),
                    'report_type':
                        (str,),
                    'site_name':
                        (str,),
                    'site_name_list':
                        (str,),
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'outlook_period': 'outlookPeriod',
                    'report_type': 'reportType',
                    'site_name': 'siteName',
                    'site_name_list': 'siteNameList',
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'outlook_period': 'query',
                    'report_type': 'query',
                    'site_name': 'query',
                    'site_name_list': 'query',
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_reports_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/details',
                'operation_id': 'nexus_insights_api_v1_reports_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'outlook',
                    'site_name',
                    'site_group_name',
                    'filter',
                    'include',
                ],
                'required': [
                    'outlook',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'outlook':
                        (int,),
                    'site_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        (str,),
                },
                'attribute_map': {
                    'outlook': 'outlook',
                    'site_name': 'siteName',
                    'site_group_name': 'siteGroupName',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'outlook': 'query',
                    'site_name': 'query',
                    'site_group_name': 'query',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_reports_inventory_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsInventoryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/inventory',
                'operation_id': 'nexus_insights_api_v1_reports_inventory_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'site_group_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'site_name': 'query',
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_reports_summary_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ReportsSummaryGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/reports/summary',
                'operation_id': 'nexus_insights_api_v1_reports_summary_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'outlook_period',
                    'report_type',
                    'site_name',
                    'site_group_name',
                ],
                'required': [
                    'outlook_period',
                    'report_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'outlook_period':
                        (int,),
                    'report_type':
                        (str,),
                    'site_name':
                        (str,),
                    'site_group_name':
                        (str,),
                },
                'attribute_map': {
                    'outlook_period': 'outlookPeriod',
                    'report_type': 'reportType',
                    'site_name': 'siteName',
                    'site_group_name': 'siteGroupName',
                },
                'location_map': {
                    'outlook_period': 'query',
                    'report_type': 'query',
                    'site_name': 'query',
                    'site_group_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_reports_cloud_details_get(
        self,
        outlook,
        **kwargs
    ):
        """Get conformance details of a reportType for a siteName over an outlookPeriod  # noqa: E501

        Get a hardware, software or overall conformance details for a fabric over a projection period (from now to max. 18 months in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_cloud_details_get(outlook, async_req=True)
        >>> result = thread.get()

        Args:
            outlook (int): Period over which the conformance details for the fabric are projected

        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_name_list (str): List of site names. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            include (str): Device types to include in the conformance results. [optional]
            offset (str): Pagination index into response. [optional]
            count (str): Limits the number of entries in the response. [optional]
            sort (str): Sort records in response by this field. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsCloudDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['outlook'] = \
            outlook
        return self.nexus_insights_api_v1_reports_cloud_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_reports_cloud_inventory_get(
        self,
        **kwargs
    ):
        """Get Inventory reports for a siteName  # noqa: E501

        Get Inventory reports for the given siteName  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_cloud_inventory_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_name_list (str): List of site names. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsCloudInventoryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_reports_cloud_inventory_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_reports_cloud_summary_get(
        self,
        outlook_period,
        report_type,
        **kwargs
    ):
        """Get conformance summary of a reportType for a siteName over an outlookPeriod  # noqa: E501

        Get a hardware, software or overall conformance summary for a fabric over a projection period (from now to max. 18 months in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_cloud_summary_get(outlook_period, report_type, async_req=True)
        >>> result = thread.get()

        Args:
            outlook_period (int): Period over which the conformance details for the fabric are projected
            report_type (str): Type of report

        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_name_list (str): List of site names. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsCloudSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['outlook_period'] = \
            outlook_period
        kwargs['report_type'] = \
            report_type
        return self.nexus_insights_api_v1_reports_cloud_summary_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_reports_details_get(
        self,
        outlook,
        **kwargs
    ):
        """Get conformance details of a reportType for a siteName over an outlookPeriod  # noqa: E501

        Get a hardware, software or overall conformance details for a fabric over a projection period (from now to max. 18 months in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_details_get(outlook, async_req=True)
        >>> result = thread.get()

        Args:
            outlook (int): Period over which the conformance details for the fabric are projected

        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional]
            include (str): Device types to include in the conformance results. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['outlook'] = \
            outlook
        return self.nexus_insights_api_v1_reports_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_reports_inventory_get(
        self,
        **kwargs
    ):
        """Get Inventory reports for a siteName  # noqa: E501

        Get Inventory reports for the given siteName  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_inventory_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsInventoryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_reports_inventory_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_reports_summary_get(
        self,
        outlook_period,
        report_type,
        **kwargs
    ):
        """Get conformance summary of a reportType for a siteName over an outlookPeriod  # noqa: E501

        Get a hardware, software or overall conformance summary for a fabric over a projection period (from now to max. 18 months in the future).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_reports_summary_get(outlook_period, report_type, async_req=True)
        >>> result = thread.get()

        Args:
            outlook_period (int): Period over which the conformance details for the fabric are projected
            report_type (str): Type of report

        Keyword Args:
            site_name (str): Name of the Site - limit the records pertaining to the site. [optional]
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ReportsSummaryGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['outlook_period'] = \
            outlook_period
        kwargs['report_type'] = \
            report_type
        return self.nexus_insights_api_v1_reports_summary_get_endpoint.call_with_http_info(**kwargs)

