"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_bgp_details_get200_response import NexusInsightsApiV1BgpDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_igmp_details_get200_response import NexusInsightsApiV1IgmpDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_igmpsnoop_details_get200_response import NexusInsightsApiV1IgmpsnoopDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_protocols_details_get200_response import NexusInsightsApiV1ProtocolsDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_protocols_top_entities_get200_response import NexusInsightsApiV1ProtocolsTopEntitiesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_svi_details_get200_response import NexusInsightsApiV1SviDetailsGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_vpc_domains_get200_response import NexusInsightsApiV1VpcDomainsGet200Response


class ProtocolsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_bgp_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1BgpDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/bgp/details',
                'operation_id': 'nexus_insights_api_v1_bgp_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                    'site_name',
                    'vrf_name',
                    'record_name',
                    'sort',
                    'filter_string',
                    'end_date',
                    'start_date',
                    'count',
                    'offset',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'record_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('record_name',): {

                        "PEERENTRYINFO": "peerentryInfo",
                        "VRFINFO": "vrfInfo",
                        "NODEINFO": "nodeInfo",
                        "PEERINFO": "peerInfo",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                    'site_name':
                        (str,),
                    'vrf_name':
                        (str,),
                    'record_name':
                        (str,),
                    'sort':
                        (str,),
                    'filter_string':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'node_name': 'nodeName',
                    'site_name': 'siteName',
                    'vrf_name': 'vrfName',
                    'record_name': 'recordName',
                    'sort': 'sort',
                    'filter_string': 'filterString',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'count': 'count',
                    'offset': 'offset',
                },
                'location_map': {
                    'node_name': 'query',
                    'site_name': 'query',
                    'vrf_name': 'query',
                    'record_name': 'query',
                    'sort': 'query',
                    'filter_string': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'count': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_igmp_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1IgmpDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/igmp/details',
                'operation_id': 'nexus_insights_api_v1_igmp_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                    'site_name',
                    'record_name',
                    'site_group_name',
                    'sort',
                    'end_date',
                    'start_date',
                    'count',
                    'offset',
                    'filter',
                ],
                'required': [
                    'node_name',
                    'site_name',
                    'record_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'record_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('record_name',): {

                        "IGMPIF": "igmpIf",
                        "IGMPOIF": "igmpOIF"
                    },
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                    'site_name':
                        (str,),
                    'record_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'sort':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'node_name': 'nodeName',
                    'site_name': 'siteName',
                    'record_name': 'recordName',
                    'site_group_name': 'siteGroupName',
                    'sort': 'sort',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'count': 'count',
                    'offset': 'offset',
                    'filter': 'filter',
                },
                'location_map': {
                    'node_name': 'query',
                    'site_name': 'query',
                    'record_name': 'query',
                    'site_group_name': 'query',
                    'sort': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_igmpsnoop_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1IgmpsnoopDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/igmpsnoop/details',
                'operation_id': 'nexus_insights_api_v1_igmpsnoop_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                    'site_name',
                    'record_name',
                    'sort',
                    'end_date',
                    'start_date',
                    'count',
                    'offset',
                    'filter_string',
                ],
                'required': [
                    'node_name',
                    'site_name',
                    'record_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'record_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('record_name',): {

                        "IGMPSNOOPOIF": "igmpsnoopOIF",
                        "IGMPSNOOPBRIDGEDOM": "igmpsnoopBridgeDom",
                        "IGMPSNOOPINST": "igmpsnoopInst"
                    },
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                    'site_name':
                        (str,),
                    'record_name':
                        (str,),
                    'sort':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'filter_string':
                        (str,),
                },
                'attribute_map': {
                    'node_name': 'nodeName',
                    'site_name': 'siteName',
                    'record_name': 'recordName',
                    'sort': 'sort',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'count': 'count',
                    'offset': 'offset',
                    'filter_string': 'filterString',
                },
                'location_map': {
                    'node_name': 'query',
                    'site_name': 'query',
                    'record_name': 'query',
                    'sort': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'filter_string': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_protocols_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ProtocolsDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/protocols/details',
                'operation_id': 'nexus_insights_api_v1_protocols_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_name',
                    'node_name',
                    'site_group_name',
                    'stat_name',
                    'history',
                    'filter',
                    'filter_l2_neighbors',
                    'count',
                    'offset',
                    'granularity',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "LACP": "lacp",
                        "LLDP": "lldp",
                        "CDP": "cdp",
                        "BGP": "bgp",
                        "IGMP": "igmp",
                        "INTERFACE": "interface",
                        "IGMPSNOOP": "igmpsnoop",
                        "PIM": "pim",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'stat_name':
                        (str,),
                    'history':
                        (int,),
                    'filter':
                        (str,),
                    'filter_l2_neighbors':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'granularity':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'site_group_name': 'siteGroupName',
                    'stat_name': 'statName',
                    'history': 'history',
                    'filter': 'filter',
                    'filter_l2_neighbors': 'filterL2Neighbors',
                    'count': 'count',
                    'offset': 'offset',
                    'granularity': 'granularity',
                    'sort': 'sort',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_name': 'query',
                    'node_name': 'query',
                    'site_group_name': 'query',
                    'stat_name': 'query',
                    'history': 'query',
                    'filter': 'query',
                    'filter_l2_neighbors': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'granularity': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_protocols_top_entities_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1ProtocolsTopEntitiesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/protocols/topEntities',
                'operation_id': 'nexus_insights_api_v1_protocols_top_entities_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'node_name',
                    'site_group_name',
                    'filter',
                    'start_date',
                    'end_date',
                    'count',
                    'offset',
                    'granularity',
                    'history',
                    'stat_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'stat_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('stat_name',): {

                        "UTILIZATION:EGRESS": "interface:utilization:egress",
                        "UTILIZATION:INGRESS": "interface:utilization:ingress",
                        "TOTAL:INTFERRORS": "interface:total:intferrors"
                    },
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'filter':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                    'granularity':
                        (str,),
                    'history':
                        (int,),
                    'stat_name':
                        (str,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'site_group_name': 'siteGroupName',
                    'filter': 'filter',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'count': 'count',
                    'offset': 'offset',
                    'granularity': 'granularity',
                    'history': 'history',
                    'stat_name': 'statName',
                },
                'location_map': {
                    'site_name': 'query',
                    'node_name': 'query',
                    'site_group_name': 'query',
                    'filter': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'count': 'query',
                    'offset': 'query',
                    'granularity': 'query',
                    'history': 'query',
                    'stat_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_svi_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1SviDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/svi/details',
                'operation_id': 'nexus_insights_api_v1_svi_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'node_name',
                    'site_name',
                    'interface_name',
                    'site_group_name',
                    'end_date',
                    'start_date',
                    'interface_type',
                ],
                'required': [
                    'node_name',
                    'site_name',
                    'interface_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'node_name':
                        (str,),
                    'site_name':
                        (str,),
                    'interface_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'interface_type':
                        (str,),
                },
                'attribute_map': {
                    'node_name': 'nodeName',
                    'site_name': 'siteName',
                    'interface_name': 'interfaceName',
                    'site_group_name': 'siteGroupName',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'interface_type': 'interfaceType',
                },
                'location_map': {
                    'node_name': 'query',
                    'site_name': 'query',
                    'interface_name': 'query',
                    'site_group_name': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'interface_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_vpc_domains_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1VpcDomainsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/vpcDomains',
                'operation_id': 'nexus_insights_api_v1_vpc_domains_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end_date',
                    'site_name',
                    'site_group_name',
                    'sort',
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'end_date':
                        (str,),
                    'site_name':
                        (str,),
                    'site_group_name':
                        (str,),
                    'sort':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'end_date': 'endDate',
                    'site_name': 'siteName',
                    'site_group_name': 'siteGroupName',
                    'sort': 'sort',
                    'filter': 'filter',
                },
                'location_map': {
                    'end_date': 'query',
                    'site_name': 'query',
                    'site_group_name': 'query',
                    'sort': 'query',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_bgp_details_get(
        self,
        **kwargs
    ):
        """BGP protocol details  # noqa: E501

        Get BGP protocol details based on given parameters such as fabric name, node name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_bgp_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            node_name (str): Node name - Gives bgp protocol details for this node. [optional] if omitted the server will use the default value of "None"
            site_name (str): Site name - Limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            vrf_name (str): Virtual routing and forwarding name - Limit the records pertaining to given vrf name. [optional] if omitted the server will use the default value of "None"
            record_name (str): Record type - Limit the records pertaining to this record type. [optional] if omitted the server will use the default value of "None"
            sort (str): Order the records based on this field. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            filter_string (str): Lucene format filter - Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            count (int): Number of nodes in response. [optional] if omitted the server will use the default value of 100
            offset (int): Offset from which records are to be returned. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1BgpDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_bgp_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_igmp_details_get(
        self,
        node_name,
        site_name,
        record_name,
        **kwargs
    ):
        """IGMP protocol details  # noqa: E501

        Get igmp protocol details based on given fabricname, nodename, recordname, end timestamp and start timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_igmp_details_get(node_name, site_name, record_name, async_req=True)
        >>> result = thread.get()

        Args:
            node_name (str): Node name - limit the records pertaining to given node name
            site_name (str): Site name - limit the records pertaining to given site name
            record_name (str): Record name - limit the records pertaining to given record type

        Keyword Args:
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional]
            sort (str): Sort results by event type/severity. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            start_date (str): Start timestamp, to skip records generated earlier to this timestamp. [optional] if omitted the server will use the default value of "now-1h"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 10
            offset (int): Pagination index into response. [optional] if omitted the server will use the default value of 0
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1IgmpDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['node_name'] = \
            node_name
        kwargs['site_name'] = \
            site_name
        kwargs['record_name'] = \
            record_name
        return self.nexus_insights_api_v1_igmp_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_igmpsnoop_details_get(
        self,
        node_name,
        site_name,
        record_name,
        **kwargs
    ):
        """IGMP snoop protocol details  # noqa: E501

        Get igmp snoop protocol details based on given fabricname, nodename, recordname, end timestamp and start timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_igmpsnoop_details_get(node_name, site_name, record_name, async_req=True)
        >>> result = thread.get()

        Args:
            node_name (str): Node name - limit the records pertaining to given node name
            site_name (str): Site name - limit the records pertaining to given siteName
            record_name (str): Record name - limit the records pertaining to given record type

        Keyword Args:
            sort (str): Order the response based on this field. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 10
            offset (int): Pagination index into response. [optional] if omitted the server will use the default value of 0
            filter_string (str): Lucene format filter - Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1IgmpsnoopDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['node_name'] = \
            node_name
        kwargs['site_name'] = \
            site_name
        kwargs['record_name'] = \
            record_name
        return self.nexus_insights_api_v1_igmpsnoop_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_protocols_details_get(
        self,
        **kwargs
    ):
        """Get protocol details  # noqa: E501

        Get telemetry protocol stats details for interfaces present in a given fabric  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_protocols_details_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_name (str): Site name - limit the records pertaining to given siteName. [optional] if omitted the server will use the default value of "None"
            node_name (str): Node name - limit the records pertaining to given node name. [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            stat_name (str): Limit the records based on given statName. [optional] if omitted the server will use the default value of "None"
            history (int): Defines whether records need to be added with timeseries or not in response. [optional] if omitted the server will use the default value of 0
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            filter_l2_neighbors (str): Filter the l2neighbors list in response based on this field. [optional] if omitted the server will use the default value of "None"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 100
            offset (int): Offset from which records are to be returned. [optional] if omitted the server will use the default value of 0
            granularity (str): Granularity of the values w.r.t duration : mandatory when history is 1. [optional] if omitted the server will use the default value of "None"
            sort (str): Order the records based on this field. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "nodeName"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ProtocolsDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_protocols_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_protocols_top_entities_get(
        self,
        **kwargs
    ):
        """Protocol top entities  # noqa: E501

        Get interface top entries based on various counters such as error, transmit utilization, receive utilization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_protocols_top_entities_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            site_name (str): Site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            node_name (str): Node name - limit the records pertaining to given node name. [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of Site Group, limit the records pertaining to the sites in this siteGroupName. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter - Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            start_date (str): Start timestamp, to skip records generated earlier to this timestamp. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 100
            offset (int): Offset from which records are to be returned. [optional] if omitted the server will use the default value of 0
            granularity (str): Granularity of the values w.r.t duration, mandatory when history is 1. [optional] if omitted the server will use the default value of "5m"
            history (int): Defines whether records need to be added with timeseries or not in response. [optional] if omitted the server will use the default value of 0
            stat_name (str): Limit the records based on given statName. [optional] if omitted the server will use the default value of "interface:total:intferrors"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1ProtocolsTopEntitiesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_protocols_top_entities_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_svi_details_get(
        self,
        node_name,
        site_name,
        interface_name="None",
        **kwargs
    ):
        """IGMP protocol details  # noqa: E501

        Get igmp protocol details based on given fabricname, nodename, recordname, end timestamp and start timestamp  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_svi_details_get(node_name, site_name, interface_name="None", async_req=True)
        >>> result = thread.get()

        Args:
            node_name (str): Node name - limit the records pertaining to given node name
            site_name (str): Site name - limit the records pertaining to given site name
            interface_name (str): Name of the node interface - limit the records pertaining to given interfaceName. defaults to "None", must be one of ["None"]

        Keyword Args:
            site_group_name (str): Name of Site Group, limit the records pertaining to the sites in this siteGroupName. [optional]
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            start_date (str): Start timestamp, to skip records generated earlier to this timestamp. [optional] if omitted the server will use the default value of "now-1h"
            interface_type (str): Interface type - limit the records pertaining to the given interfaceType. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1SviDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['node_name'] = \
            node_name
        kwargs['site_name'] = \
            site_name
        kwargs['interface_name'] = \
            interface_name
        return self.nexus_insights_api_v1_svi_details_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_vpc_domains_get(
        self,
        **kwargs
    ):
        """Get VPC domain details  # noqa: E501

        Get VPC domain details in a given fabric  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_vpc_domains_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            end_date (str): End timestamp, to collect the records generated till specified time. [optional] if omitted the server will use the default value of "now"
            site_name (str): site name - limit the records pertaining to given site name. [optional] if omitted the server will use the default value of "None"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            sort (str): Order the response based on this field. [optional] if omitted the server will use the default value of "None"
            filter (str): Filter the response based on this filter field. [optional] if omitted the server will use the default value of "None"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1VpcDomainsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_vpc_domains_get_endpoint.call_with_http_info(**kwargs)

