"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_portchannel_details_get200_response import NexusInsightsApiV1PortchannelDetailsGet200Response


class PortChannelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_portchannel_details_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1PortchannelDetailsGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/portchannel/details',
                'operation_id': 'nexus_insights_api_v1_portchannel_details_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'node_name',
                    'name',
                    'pc_type',
                    'sort',
                    'end_date',
                    'start_date',
                    'count',
                    'offset',
                ],
                'required': [
                    'site_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'pc_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('pc_type',): {

                        "PC": "pc",
                        "VPC": "vpc"
                    },
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                    'name':
                        (str,),
                    'pc_type':
                        (str,),
                    'sort':
                        (str,),
                    'end_date':
                        (str,),
                    'start_date':
                        (str,),
                    'count':
                        (int,),
                    'offset':
                        (int,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                    'name': 'name',
                    'pc_type': 'pcType',
                    'sort': 'sort',
                    'end_date': 'endDate',
                    'start_date': 'startDate',
                    'count': 'count',
                    'offset': 'offset',
                },
                'location_map': {
                    'site_name': 'query',
                    'node_name': 'query',
                    'name': 'query',
                    'pc_type': 'query',
                    'sort': 'query',
                    'end_date': 'query',
                    'start_date': 'query',
                    'count': 'query',
                    'offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_portchannel_details_get(
        self,
        site_name,
        **kwargs
    ):
        """Port channel details  # noqa: E501

        Get port channel protocol details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_portchannel_details_get(site_name, async_req=True)
        >>> result = thread.get()

        Args:
            site_name (str): Site Name - limit the records pertaining to given siteName

        Keyword Args:
            node_name (str): Node name - limit the records pertaining to given node name. [optional] if omitted the server will use the default value of "None"
            name (str): Portchannel interface name. [optional] if omitted the server will use the default value of "None"
            pc_type (str): Port channel type. [optional] if omitted the server will use the default value of "pc"
            sort (str): Order the response based on this field. Use +/- as prefix for ascending/descending order. [optional] if omitted the server will use the default value of "None"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            count (int): Limit the number of entries in response. [optional] if omitted the server will use the default value of 100
            offset (int): Pagination index into response. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1PortchannelDetailsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_name'] = \
            site_name
        return self.nexus_insights_api_v1_portchannel_details_get_endpoint.call_with_http_info(**kwargs)

