"""
    Cisco Nexus Cloud API

    Cisco Nexus Cloud API is a programmatic interface that uses the REST architecture to provide access to the Nexus Cloud functionality.  # noqa: E501

    The version of the OpenAPI document: 1.0.9
    Contact: nexuscloud@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nexuscloud_client.api_client import ApiClient, Endpoint as _Endpoint
from nexuscloud_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nexuscloud_client.model.nexus_insights_api_v1_advisories_details_get401_response import NexusInsightsApiV1AdvisoriesDetailsGet401Response
from nexuscloud_client.model.nexus_insights_api_v1_jobs_node_states_get200_response import NexusInsightsApiV1JobsNodeStatesGet200Response
from nexuscloud_client.model.nexus_insights_api_v1_node_capabilities_get200_response_value import NexusInsightsApiV1NodeCapabilitiesGet200ResponseValue
from nexuscloud_client.model.nexus_insights_api_v1_nodes_get200_response import NexusInsightsApiV1NodesGet200Response


class NodesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.nexus_insights_api_v1_jobs_node_states_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1JobsNodeStatesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/jobs/nodeStates',
                'operation_id': 'nexus_insights_api_v1_jobs_node_states_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_group_name',
                    'site_name',
                    'job_type',
                ],
                'required': [
                    'site_group_name',
                    'site_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'job_type':
                        (str,),
                },
                'attribute_map': {
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'job_type': 'jobType',
                },
                'location_map': {
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'job_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_node_capabilities_get_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (NexusInsightsApiV1NodeCapabilitiesGet200ResponseValue,)},),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/nodeCapabilities',
                'operation_id': 'nexus_insights_api_v1_node_capabilities_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'site_name',
                    'node_name',
                ],
                'required': [
                    'site_name',
                    'node_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'site_name':
                        (str,),
                    'node_name':
                        (str,),
                },
                'attribute_map': {
                    'site_name': 'siteName',
                    'node_name': 'nodeName',
                },
                'location_map': {
                    'site_name': 'query',
                    'node_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.nexus_insights_api_v1_nodes_get_endpoint = _Endpoint(
            settings={
                'response_type': (NexusInsightsApiV1NodesGet200Response,),
                'auth': [],
                'endpoint_path': '/nexus/insights/api/v1/nodes',
                'operation_id': 'nexus_insights_api_v1_nodes_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'site_group_name',
                    'site_name',
                    'node_names',
                    'node_roles',
                    'filter',
                    'include',
                    'count',
                    'oper_st',
                    'include_crv',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'node_roles',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('node_roles',): {

                        "CONTROLLER": "Controller",
                        "LEAF": "Leaf",
                        "SPINE": "Spine",
                        "NONE": "None"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'site_group_name':
                        (str,),
                    'site_name':
                        (str,),
                    'node_names':
                        (str,),
                    'node_roles':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        (str,),
                    'count':
                        (int,),
                    'oper_st':
                        (str,),
                    'include_crv':
                        (bool,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'site_group_name': 'siteGroupName',
                    'site_name': 'siteName',
                    'node_names': 'nodeNames',
                    'node_roles': 'nodeRoles',
                    'filter': 'filter',
                    'include': 'include',
                    'count': 'count',
                    'oper_st': 'operSt',
                    'include_crv': 'includeCRV',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'site_group_name': 'query',
                    'site_name': 'query',
                    'node_names': 'query',
                    'node_roles': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'count': 'query',
                    'oper_st': 'query',
                    'include_crv': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def nexus_insights_api_v1_jobs_node_states_get(
        self,
        site_group_name,
        site_name,
        **kwargs
    ):
        """Node state of fabric nodes  # noqa: E501

        Gives the node state details of the fabric nodes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_jobs_node_states_get(site_group_name, site_name, async_req=True)
        >>> result = thread.get()

        Args:
            site_group_name (str): Limit the records pertaining to this siteGroupName
            site_name (str): Limit the records pertaining to this siteName

        Keyword Args:
            job_type (str): Comma separated list of job types w.r.t which node state is to be returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1JobsNodeStatesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_group_name'] = \
            site_group_name
        kwargs['site_name'] = \
            site_name
        return self.nexus_insights_api_v1_jobs_node_states_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_node_capabilities_get(
        self,
        site_name,
        node_name,
        **kwargs
    ):
        """Get the features available on the node  # noqa: E501

        Get the list of features available for a given node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_node_capabilities_get(site_name, node_name, async_req=True)
        >>> result = thread.get()

        Args:
            site_name (str): Name of the Site, Limit the records pertaining to this siteName
            node_name (str): Name of the site node, limits the capabilites to given nodeName

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (NexusInsightsApiV1NodeCapabilitiesGet200ResponseValue,)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['site_name'] = \
            site_name
        kwargs['node_name'] = \
            node_name
        return self.nexus_insights_api_v1_node_capabilities_get_endpoint.call_with_http_info(**kwargs)

    def nexus_insights_api_v1_nodes_get(
        self,
        **kwargs
    ):
        """Get nodes list  # noqa: E501

        Get detailed info of nodes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nexus_insights_api_v1_nodes_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            start_date (str): Start date, to skip records generated earlier to this date. [optional] if omitted the server will use the default value of "now-1h"
            end_date (str): End date, to collect the records generated till specified date. [optional] if omitted the server will use the default value of "now"
            site_group_name (str): Name of the Site Group - limit the records pertaining to the sites in this site group. [optional] if omitted the server will use the default value of "None"
            site_name (str): Name of the site - limit the records pertaining to this siteName. [optional] if omitted the server will use the default value of "None"
            node_names (str): List of comma separated nodeNames - limit the records pertaining to these nodeNames. [optional] if omitted the server will use the default value of "None"
            node_roles (str): List of comma separated types of node. [optional] if omitted the server will use the default value of "None"
            filter (str): Lucene format filter. [optional] if omitted the server will use the default value of "None"
            include (str): Include Anomaly Scores field in nodes output. [optional] if omitted the server will use the default value of "None"
            count (int): Limits the number of records in the response. [optional] if omitted the server will use the default value of 10
            oper_st (str): Comma separated list of operSt - limit the records pertaining to this operSt. [optional] if omitted the server will use the default value of "None"
            include_crv (bool): Display Cisco Recommended Version. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            NexusInsightsApiV1NodesGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.nexus_insights_api_v1_nodes_get_endpoint.call_with_http_info(**kwargs)

